--TEST--
Hash: serialization formats
--FILE--
<?php

$serializations = [
    [
        "md2",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjM6Im1kMiI7aToxO2k6MDtpOjI7YTo0OntpOjA7czo0ODoiuyJG48A1rdYMPXAiWBDcbOrPsUaDg8lhMXhr/DQfjaN7dOqrImXTxBykKAln5L8sIjtpOjE7czoxNjoiwrfjcIJR1I8RljMyAxmcSyI7aToyO3M6MTY6IiBhbnl0aGluZwAAAAAAAAAiO2k6MztpOjk7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "md4",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjM6Im1kNCI7aToxO2k6MDtpOjI7YTo3OntpOjA7aToxNzMyNTg0MTkzO2k6MTtpOi0yNzE3MzM4Nzk7aToyO2k6LTE3MzI1ODQxOTQ7aTozO2k6MjcxNzMzODc4O2k6NDtpOjIwMDtpOjU7aTowO2k6NjtzOjY0OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIjt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "md5",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjM6Im1kNSI7aToxO2k6MDtpOjI7YToyMzp7aTowO2k6MjU7aToxO2k6MDtpOjI7aToxNzMyNTg0MTkzO2k6MztpOi0yNzE3MzM4Nzk7aTo0O2k6LTE3MzI1ODQxOTQ7aTo1O2k6MjcxNzMzODc4O2k6NjtzOjY0OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIjtpOjc7aTowO2k6ODtpOjA7aTo5O2k6MDtpOjEwO2k6MDtpOjExO2k6MDtpOjEyO2k6MDtpOjEzO2k6MDtpOjE0O2k6MDtpOjE1O2k6MDtpOjE2O2k6MDtpOjE3O2k6MDtpOjE4O2k6MDtpOjE5O2k6MDtpOjIwO2k6MDtpOjIxO2k6MDtpOjIyO2k6MDt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "sha1",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjQ6InNoYTEiO2k6MTtpOjA7aToyO2E6ODp7aTowO2k6MTczMjU4NDE5MztpOjE7aTotMjcxNzMzODc5O2k6MjtpOi0xNzMyNTg0MTk0O2k6MztpOjI3MTczMzg3ODtpOjQ7aTotMTAwOTU4OTc3NjtpOjU7aToyMDA7aTo2O2k6MDtpOjc7czo2NDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "sha224",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjY6InNoYTIyNCI7aToxO2k6MDtpOjI7YToxMTp7aTowO2k6LTEwNTY1OTYyNjQ7aToxO2k6OTE0MTUwNjYzO2k6MjtpOjgxMjcwMjk5OTtpOjM7aTotMTUwMDU0NTk5O2k6NDtpOi00MTkxNDM5O2k6NTtpOjE3NTA2MDMwMjU7aTo2O2k6MTY5NDA3NjgzOTtpOjc7aTotMTA5MDg5MTg2ODtpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6NjQ6IkkgY2FuJ3QgcmVtZW1iZXIgYW55dGhpbmcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO31pOjM7aToyO2k6NDthOjA6e319"
    ],
    [
        "sha256",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjY6InNoYTI1NiI7aToxO2k6MDtpOjI7YToxMTp7aTowO2k6MTc3OTAzMzcwMztpOjE7aTotMTE1MDgzMzAxOTtpOjI7aToxMDEzOTA0MjQyO2k6MztpOi0xNTIxNDg2NTM0O2k6NDtpOjEzNTk4OTMxMTk7aTo1O2k6LTE2OTQxNDQzNzI7aTo2O2k6NTI4NzM0NjM1O2k6NztpOjE1NDE0NTkyMjU7aTo4O2k6MjAwO2k6OTtpOjA7aToxMDtzOjY0OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIjt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "sha384",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjY6InNoYTM4NCI7aToxO2k6MDtpOjI7YToyMTp7aTowO2k6LTEwNTY1OTYyNjQ7aToxO2k6LTg3Njg5NjkzMTtpOjI7aTo5MTQxNTA2NjM7aTozO2k6MTY1NDI3MDI1MDtpOjQ7aTo4MTI3MDI5OTk7aTo1O2k6LTE4NTY0Mzc5MjY7aTo2O2k6LTE1MDA1NDU5OTtpOjc7aTozNTU0NjIzNjA7aTo4O2k6LTQxOTE0Mzk7aTo5O2k6MTczMTQwNTQxNTtpOjEwO2k6MTc1MDYwMzAyNTtpOjExO2k6LTE5MDA3ODcwNjU7aToxMjtpOjE2OTQwNzY4Mzk7aToxMztpOi02MTk5NTg3NzE7aToxNDtpOi0xMDkwODkxODY4O2k6MTU7aToxMjAzMDYyODEzO2k6MTY7aToyMDA7aToxNztpOjA7aToxODtpOjA7aToxOTtpOjA7aToyMDtzOjEyODoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO31pOjM7aToyO2k6NDthOjA6e319"
    ],
    [
        "sha512/224",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJzaGE1MTIvMjI0IjtpOjE7aTowO2k6MjthOjIxOntpOjA7aTo0MjQ5NTUyOTg7aToxO2k6LTE5NDIxNDUwODA7aToyO2k6LTE5ODIwMTYyOTg7aTozO2k6MTk0NDE2NDcxMDtpOjQ7aTo4NTU2MTI1NDY7aTo1O2k6NTAyOTcwMjg2O2k6NjtpOjE0Nzk1MTYxMTE7aTo3O2k6MTczODM5Njk0ODtpOjg7aToyMDc3NTExMDgwO2k6OTtpOjI1ODgxMjc3NztpOjEwO2k6Nzk5ODkwNTg7aToxMTtpOjIwMTEzOTM5MDc7aToxMjtpOjE3ODAyOTk0NjQ7aToxMztpOjEwNjcyODc5NzY7aToxNDtpOi0xODQ4MjA4NzM1O2k6MTU7aToyODY0NTEzNzM7aToxNjtpOjIwMDtpOjE3O2k6MDtpOjE4O2k6MDtpOjE5O2k6MDtpOjIwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "sha512/256",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJzaGE1MTIvMjU2IjtpOjE7aTowO2k6MjthOjIxOntpOjA7aTotNjQyMjc1NDA7aToxO2k6NTczNjQ1MjA0O2k6MjtpOi05MzQ1MTc1NjY7aTozO2k6LTE2MjE3OTQ5MDk7aTo0O2k6MTg2Nzc1NTg1NztpOjU7aTo1OTY4ODM1NjM7aTo2O2k6MTQ5NzQyNjYyMTtpOjc7aTotMTc3NDY4NDM5MTtpOjg7aTotMTQ2NzAyMzM4OTtpOjk7aTotMTc3NTc0NzM1ODtpOjEwO2k6MTQwMTMwNTQ5MDtpOjExO2k6LTExMDExMjgxNTU7aToxMjtpOjc0Njk2MTA2NjtpOjEzO2k6NzIxNTI1MjQ0O2k6MTQ7aTotMjExNzc4NDQxNDtpOjE1O2k6MjQ2ODg1ODUyO2k6MTY7aToyMDA7aToxNztpOjA7aToxODtpOjA7aToxOTtpOjA7aToyMDtzOjEyODoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO31pOjM7aToyO2k6NDthOjA6e319"
    ],
    [
        "sha512",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjY6InNoYTUxMiI7aToxO2k6MDtpOjI7YToyMTp7aTowO2k6LTIwNTczMTU3NjtpOjE7aToxNzc5MDMzNzAzO2k6MjtpOi0yMDY3MDkzNzAxO2k6MztpOi0xMTUwODMzMDE5O2k6NDtpOi0yMzc5MTU3MztpOjU7aToxMDEzOTA0MjQyO2k6NjtpOjE1OTU3NTAxMjk7aTo3O2k6LTE1MjE0ODY1MzQ7aTo4O2k6LTEzNzc0MDIxNTk7aTo5O2k6MTM1OTg5MzExOTtpOjEwO2k6NzI1NTExMTk5O2k6MTE7aTotMTY5NDE0NDM3MjtpOjEyO2k6LTc5NTc3NzQ5O2k6MTM7aTo1Mjg3MzQ2MzU7aToxNDtpOjMyNzAzMzIwOTtpOjE1O2k6MTU0MTQ1OTIyNTtpOjE2O2k6MjAwO2k6MTc7aTowO2k6MTg7aTowO2k6MTk7aTowO2k6MjA7czoxMjg6IkkgY2FuJ3QgcmVtZW1iZXIgYW55dGhpbmcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIjt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "ripemd128",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjk6InJpcGVtZDEyOCI7aToxO2k6MDtpOjI7YTo3OntpOjA7aToxNzMyNTg0MTkzO2k6MTtpOi0yNzE3MzM4Nzk7aToyO2k6LTE3MzI1ODQxOTQ7aTozO2k6MjcxNzMzODc4O2k6NDtpOjIwMDtpOjU7aTowO2k6NjtzOjY0OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIjt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "ripemd160",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjk6InJpcGVtZDE2MCI7aToxO2k6MDtpOjI7YTo4OntpOjA7aToxNzMyNTg0MTkzO2k6MTtpOi0yNzE3MzM4Nzk7aToyO2k6LTE3MzI1ODQxOTQ7aTozO2k6MjcxNzMzODc4O2k6NDtpOi0xMDA5NTg5Nzc2O2k6NTtpOjIwMDtpOjY7aTowO2k6NztzOjY0OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIjt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "ripemd256",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjk6InJpcGVtZDI1NiI7aToxO2k6MDtpOjI7YToxMTp7aTowO2k6MTczMjU4NDE5MztpOjE7aTotMjcxNzMzODc5O2k6MjtpOi0xNzMyNTg0MTk0O2k6MztpOjI3MTczMzg3ODtpOjQ7aToxOTg1MjI5MzI4O2k6NTtpOi0xOTA4ODc0NDtpOjY7aTotMTk4NTIyOTMyOTtpOjc7aToxOTA4ODc0MztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6NjQ6IkkgY2FuJ3QgcmVtZW1iZXIgYW55dGhpbmcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO31pOjM7aToyO2k6NDthOjA6e319"
    ],
    [
        "ripemd320",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjk6InJpcGVtZDMyMCI7aToxO2k6MDtpOjI7YToxMzp7aTowO2k6MTczMjU4NDE5MztpOjE7aTotMjcxNzMzODc5O2k6MjtpOi0xNzMyNTg0MTk0O2k6MztpOjI3MTczMzg3ODtpOjQ7aTotMTAwOTU4OTc3NjtpOjU7aToxOTg1MjI5MzI4O2k6NjtpOi0xOTA4ODc0NDtpOjc7aTotMTk4NTIyOTMyOTtpOjg7aToxOTA4ODc0MztpOjk7aToxMDA5NTg5Nzc1O2k6MTA7aToyMDA7aToxMTtpOjA7aToxMjtzOjY0OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIjt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "whirlpool",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjk6IndoaXJscG9vbCI7aToxO2k6MDtpOjI7YToyMDp7aTowO2k6MDtpOjE7aTowO2k6MjtpOjA7aTozO2k6MDtpOjQ7aTowO2k6NTtpOjA7aTo2O2k6MDtpOjc7aTowO2k6ODtpOjA7aTo5O2k6MDtpOjEwO2k6MDtpOjExO2k6MDtpOjEyO2k6MDtpOjEzO2k6MDtpOjE0O2k6MDtpOjE1O2k6MDtpOjE2O3M6MzI6IgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADIIjtpOjE3O2k6MjU7aToxODtpOjIwMDtpOjE5O3M6NjQ6IkkgY2FuJ3QgcmVtZW1iZXIgYW55dGhpbmcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO31pOjM7aToyO2k6NDthOjA6e319"
    ],
    [
        "tiger128,3",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJ0aWdlcjEyOCwzIjtpOjE7aTowO2k6MjthOjEwOntpOjA7aTotMTk4NTIyOTMyOTtpOjE7aToxOTA4ODc0MztpOjI7aToxOTg1MjI5MzI4O2k6MztpOi0xOTA4ODc0NDtpOjQ7aTotMTAxMTY4NzAzMztpOjU7aTotMjU4NTYyNjM2O2k6NjtpOjA7aTo3O2k6MDtpOjg7czo2NDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7aTo5O2k6MjU7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "tiger160,3",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJ0aWdlcjE2MCwzIjtpOjE7aTowO2k6MjthOjEwOntpOjA7aTotMTk4NTIyOTMyOTtpOjE7aToxOTA4ODc0MztpOjI7aToxOTg1MjI5MzI4O2k6MztpOi0xOTA4ODc0NDtpOjQ7aTotMTAxMTY4NzAzMztpOjU7aTotMjU4NTYyNjM2O2k6NjtpOjA7aTo3O2k6MDtpOjg7czo2NDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7aTo5O2k6MjU7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "tiger192,3",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJ0aWdlcjE5MiwzIjtpOjE7aTowO2k6MjthOjEwOntpOjA7aTotMTk4NTIyOTMyOTtpOjE7aToxOTA4ODc0MztpOjI7aToxOTg1MjI5MzI4O2k6MztpOi0xOTA4ODc0NDtpOjQ7aTotMTAxMTY4NzAzMztpOjU7aTotMjU4NTYyNjM2O2k6NjtpOjA7aTo3O2k6MDtpOjg7czo2NDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7aTo5O2k6MjU7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "tiger128,4",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJ0aWdlcjEyOCw0IjtpOjE7aTowO2k6MjthOjEwOntpOjA7aTotMTk4NTIyOTMyOTtpOjE7aToxOTA4ODc0MztpOjI7aToxOTg1MjI5MzI4O2k6MztpOi0xOTA4ODc0NDtpOjQ7aTotMTAxMTY4NzAzMztpOjU7aTotMjU4NTYyNjM2O2k6NjtpOjA7aTo3O2k6MDtpOjg7czo2NDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7aTo5O2k6MjU7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "tiger160,4",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJ0aWdlcjE2MCw0IjtpOjE7aTowO2k6MjthOjEwOntpOjA7aTotMTk4NTIyOTMyOTtpOjE7aToxOTA4ODc0MztpOjI7aToxOTg1MjI5MzI4O2k6MztpOi0xOTA4ODc0NDtpOjQ7aTotMTAxMTY4NzAzMztpOjU7aTotMjU4NTYyNjM2O2k6NjtpOjA7aTo3O2k6MDtpOjg7czo2NDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7aTo5O2k6MjU7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "tiger192,4",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJ0aWdlcjE5Miw0IjtpOjE7aTowO2k6MjthOjEwOntpOjA7aTotMTk4NTIyOTMyOTtpOjE7aToxOTA4ODc0MztpOjI7aToxOTg1MjI5MzI4O2k6MztpOi0xOTA4ODc0NDtpOjQ7aTotMTAxMTY4NzAzMztpOjU7aTotMjU4NTYyNjM2O2k6NjtpOjA7aTo3O2k6MDtpOjg7czo2NDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7aTo5O2k6MjU7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "snefru",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjY6InNuZWZydSI7aToxO2k6MDtpOjI7YToyMDp7aTowO2k6MDtpOjE7aTowO2k6MjtpOjA7aTozO2k6MDtpOjQ7aTowO2k6NTtpOjA7aTo2O2k6MDtpOjc7aTowO2k6ODtpOjA7aTo5O2k6MDtpOjEwO2k6MDtpOjExO2k6MDtpOjEyO2k6MDtpOjEzO2k6MDtpOjE0O2k6MDtpOjE1O2k6MDtpOjE2O2k6MDtpOjE3O2k6MjAwO2k6MTg7aToyNTtpOjE5O3M6MzI6IkkgY2FuJ3QgcmVtZW1iZXIgYW55dGhpbmcAAAAAAAAAIjt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "snefru256",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjY6InNuZWZydSI7aToxO2k6MDtpOjI7YToyMDp7aTowO2k6MDtpOjE7aTowO2k6MjtpOjA7aTozO2k6MDtpOjQ7aTowO2k6NTtpOjA7aTo2O2k6MDtpOjc7aTowO2k6ODtpOjA7aTo5O2k6MDtpOjEwO2k6MDtpOjExO2k6MDtpOjEyO2k6MDtpOjEzO2k6MDtpOjE0O2k6MDtpOjE1O2k6MDtpOjE2O2k6MDtpOjE3O2k6MjAwO2k6MTg7aToyNTtpOjE5O3M6MzI6IkkgY2FuJ3QgcmVtZW1iZXIgYW55dGhpbmcAAAAAAAAAIjt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "gost",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjQ6Imdvc3QiO2k6MTtpOjA7aToyO2E6MjA6e2k6MDtpOjA7aToxO2k6MDtpOjI7aTowO2k6MztpOjA7aTo0O2k6MDtpOjU7aTowO2k6NjtpOjA7aTo3O2k6MDtpOjg7aTowO2k6OTtpOjA7aToxMDtpOjA7aToxMTtpOjA7aToxMjtpOjA7aToxMztpOjA7aToxNDtpOjA7aToxNTtpOjA7aToxNjtpOjIwMDtpOjE3O2k6MDtpOjE4O2k6MjU7aToxOTtzOjMyOiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "gost-crypto",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjExOiJnb3N0LWNyeXB0byI7aToxO2k6MDtpOjI7YToyMDp7aTowO2k6MDtpOjE7aTowO2k6MjtpOjA7aTozO2k6MDtpOjQ7aTowO2k6NTtpOjA7aTo2O2k6MDtpOjc7aTowO2k6ODtpOjA7aTo5O2k6MDtpOjEwO2k6MDtpOjExO2k6MDtpOjEyO2k6MDtpOjEzO2k6MDtpOjE0O2k6MDtpOjE1O2k6MDtpOjE2O2k6MjAwO2k6MTc7aTowO2k6MTg7aToyNTtpOjE5O3M6MzI6IkkgY2FuJ3QgcmVtZW1iZXIgYW55dGhpbmcAAAAAAAAAIjt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "adler32",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjc6ImFkbGVyMzIiO2k6MTtpOjA7aToyO2E6MTp7aTowO2k6MTg3MDM5OTc4NDt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "crc32",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjU6ImNyYzMyIjtpOjE7aTowO2k6MjthOjE6e2k6MDtpOi0xNjIzMzE0NDA2O31pOjM7aToyO2k6NDthOjA6e319"
    ],
    [
        "crc32b",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjY6ImNyYzMyYiI7aToxO2k6MDtpOjI7YToxOntpOjA7aTotMTc2Mjk0OTcxMTt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "crc32c",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjY6ImNyYzMyYyI7aToxO2k6MDtpOjI7YToxOntpOjA7aTotMTU4MTI3NjgyMDt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "fnv132",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjY6ImZudjEzMiI7aToxO2k6MDtpOjI7YToxOntpOjA7aTotMTc0MzU0NzEzMjt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "fnv1a32",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjc6ImZudjFhMzIiO2k6MTtpOjA7aToyO2E6MTp7aTowO2k6LTE0Mjc4NDA5NTg7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "fnv164",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjY6ImZudjE2NCI7aToxO2k6MDtpOjI7YToyOntpOjA7aTotMTMyOTM4MTA4O2k6MTtpOjM0MDkyODA4OTt9aTozO2k6MjtpOjQ7YTowOnt9fQ=="
    ],
    [
        "fnv1a64",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjc6ImZudjFhNjQiO2k6MTtpOjA7aToyO2E6Mjp7aTowO2k6ODY3NjA5NDQyO2k6MTtpOi0xMDk0OTQ1Njg2O31pOjM7aToyO2k6NDthOjA6e319"
    ],
    [
        "joaat",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjU6ImpvYWF0IjtpOjE7aTowO2k6MjthOjE6e2k6MDtpOi0xNDY5OTExMTA7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval128,3",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDEyOCwzIjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval160,3",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDE2MCwzIjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval192,3",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDE5MiwzIjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval224,3",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDIyNCwzIjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval256,3",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDI1NiwzIjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval128,4",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDEyOCw0IjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval160,4",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDE2MCw0IjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval192,4",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDE5Miw0IjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval224,4",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDIyNCw0IjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval256,4",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDI1Niw0IjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval128,5",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDEyOCw1IjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval160,5",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDE2MCw1IjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval192,5",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDE5Miw1IjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval224,5",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDIyNCw1IjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "haval256,5",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjEwOiJoYXZhbDI1Niw1IjtpOjE7aTowO2k6MjthOjExOntpOjA7aTo2MDgxMzU4MTY7aToxO2k6LTIwNTI5MTI5NDE7aToyO2k6MzIwNDQwODc4O2k6MztpOjU3NzAxMTg4O2k6NDtpOi0xNTQyODk5Njc4O2k6NTtpOjY5ODI5ODgzMjtpOjY7aToxMzcyOTY1MzY7aTo3O2k6LTMzMDQwNDcyNztpOjg7aToyMDA7aTo5O2k6MDtpOjEwO3M6MTI4OiJJIGNhbid0IHJlbWVtYmVyIGFueXRoaW5nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACI7fWk6MztpOjI7aTo0O2E6MDp7fX0="
    ],
    [
        "sha3-224",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtMjI0IjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiSSBjYW4ndCCNmpKakp2ajd+ekYaLl5aRZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToxMDA7aTo0O2E6MDp7fX0=", /* 64-bit fast LE */
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtMjI0IjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiCZk6DkJFV0S8u4vLRUZWVJDajqlEZ2R2CwAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToxMDE7aTo0O2E6MDp7fX0=", /* 32-bit fast LE */
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtMjI0IjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToyO2k6NDthOjA6e319" /* slow */
    ],
    [
        "sha3-256",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtMjU2IjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiSSBjYW4ndCCNmpKakp2ajd+ekYaLl5aRZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToxMDA7aTo0O2E6MDp7fX0=", /* 64-bit fast LE */
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtMjU2IjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiCZk6DkJFV0S8u4vLRUZWVJDajqlEZ2R2CwAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToxMDE7aTo0O2E6MDp7fX0=", /* 32-bit fast LE */
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtMjU2IjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToyO2k6NDthOjA6e319" /* slow */
    ],
    [
        "sha3-384",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtMzg0IjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiSSBjYW4ndCCNmpKakp2ajd+ekYaLl5aRZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToxMDA7aTo0O2E6MDp7fX0=", /* 64-bit fast LE */
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtMzg0IjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiCZk6DkJFV0S8u4vLRUZWVJDajqlEZ2R2CwAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToxMDE7aTo0O2E6MDp7fX0=", /* 32-bit fast LE */
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtMzg0IjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToyO2k6NDthOjA6e319" /* slow */
    ],
    [
        "sha3-512",
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtNTEyIjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiSSBjYW4ndCCNmpKakp2ajd+ekYaLl5aRZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAP//////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToxMDA7aTo0O2E6MDp7fX0=", /* 64-bit fast LE */
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtNTEyIjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiCZk6DkJFV0S8u4vLRUZWVJDajqlEZ2R2CwAAAAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToxMDE7aTo0O2E6MDp7fX0=", /* 32-bit fast LE */
        "TzoxMToiSGFzaENvbnRleHQiOjU6e2k6MDtzOjg6InNoYTMtNTEyIjtpOjE7aTowO2k6MjthOjI6e2k6MDtzOjIwMDoiSSBjYW4ndCByZW1lbWJlciBhbnl0aGluZwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAiO2k6MTtpOjI1O31pOjM7aToyO2k6NDthOjA6e319" /* slow */
    ]
];


function test_serialization($serial, $hash, $algo) {
    try {
        $ctx = unserialize(base64_decode($serial));
        hash_update($ctx, "Can’t tell if this is true or dream");
        $hash2 = hash_final($ctx);
        if ($hash !== $hash2) {
            echo "$algo: unexpected hash $hash2 for serialization {$serial}\n";
        }
    } catch (Throwable $e) {
        echo "$algo: problem with serialization {$serial}\n";
        echo "  ", $e->getMessage(), "\n", $e->getTraceAsString();
    }
}

foreach ($serializations as $slist) {
    $algo = $slist[0];
    $hash = hash($algo, "I can't remember anythingCan’t tell if this is true or dream");

    $ctx = hash_init($algo);
    hash_update($ctx, "I can't remember anything");
    $serial = base64_encode(serialize($ctx));
    if (!in_array($serial, $slist)) {
        echo "$algo: unexpected serialization $serial\n";
    }

    test_serialization($serial, $hash, $algo);
}

echo "Done\n";
?>
--EXPECT--
Done
