#line 2 "pgc.c"
/*-------------------------------------------------------------------------
 *
 * pgc.l
 *	  lexical scanner for ecpg
 *
 * This is a modified version of src/backend/parser/scan.l
 *
 * The ecpg scanner is not backup-free, so the fail rules are
 * only here to simplify syncing this file with scan.l.
 *
 *
 * Portions Copyright (c) 1996-2022, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/interfaces/ecpg/preproc/pgc.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres_fe.h"

#include <ctype.h>
#include <limits.h>

#include "common/string.h"

#include "preproc_extern.h"
#include "preproc.h"

#line 32 "pgc.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer base_yy_create_buffer
#define yy_delete_buffer base_yy_delete_buffer
#define yy_scan_buffer base_yy_scan_buffer
#define yy_scan_string base_yy_scan_string
#define yy_scan_bytes base_yy_scan_bytes
#define yy_init_buffer base_yy_init_buffer
#define yy_flush_buffer base_yy_flush_buffer
#define yy_load_buffer_state base_yy_load_buffer_state
#define yy_switch_to_buffer base_yy_switch_to_buffer
#define yypush_buffer_state base_yypush_buffer_state
#define yypop_buffer_state base_yypop_buffer_state
#define yyensure_buffer_stack base_yyensure_buffer_stack
#define yy_flex_debug base_yy_flex_debug
#define yyin base_yyin
#define yyleng base_yyleng
#define yylex base_yylex
#define yylineno base_yylineno
#define yyout base_yyout
#define yyrestart base_yyrestart
#define yytext base_yytext
#define yywrap base_yywrap
#define yyalloc base_yyalloc
#define yyrealloc base_yyrealloc
#define yyfree base_yyfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define base_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer base_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define base_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer base_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define base_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer base_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define base_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string base_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define base_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes base_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define base_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer base_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define base_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer base_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define base_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state base_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define base_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer base_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define base_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state base_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define base_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state base_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define base_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack base_yyensure_buffer_stack
#endif

#ifdef yylex
#define base_yylex_ALREADY_DEFINED
#else
#define yylex base_yylex
#endif

#ifdef yyrestart
#define base_yyrestart_ALREADY_DEFINED
#else
#define yyrestart base_yyrestart
#endif

#ifdef yylex_init
#define base_yylex_init_ALREADY_DEFINED
#else
#define yylex_init base_yylex_init
#endif

#ifdef yylex_init_extra
#define base_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra base_yylex_init_extra
#endif

#ifdef yylex_destroy
#define base_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy base_yylex_destroy
#endif

#ifdef yyget_debug
#define base_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug base_yyget_debug
#endif

#ifdef yyset_debug
#define base_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug base_yyset_debug
#endif

#ifdef yyget_extra
#define base_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra base_yyget_extra
#endif

#ifdef yyset_extra
#define base_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra base_yyset_extra
#endif

#ifdef yyget_in
#define base_yyget_in_ALREADY_DEFINED
#else
#define yyget_in base_yyget_in
#endif

#ifdef yyset_in
#define base_yyset_in_ALREADY_DEFINED
#else
#define yyset_in base_yyset_in
#endif

#ifdef yyget_out
#define base_yyget_out_ALREADY_DEFINED
#else
#define yyget_out base_yyget_out
#endif

#ifdef yyset_out
#define base_yyset_out_ALREADY_DEFINED
#else
#define yyset_out base_yyset_out
#endif

#ifdef yyget_leng
#define base_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng base_yyget_leng
#endif

#ifdef yyget_text
#define base_yyget_text_ALREADY_DEFINED
#else
#define yyget_text base_yyget_text
#endif

#ifdef yyget_lineno
#define base_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno base_yyget_lineno
#endif

#ifdef yyset_lineno
#define base_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno base_yyset_lineno
#endif

#ifdef yywrap
#define base_yywrap_ALREADY_DEFINED
#else
#define yywrap base_yywrap
#endif

#ifdef yyalloc
#define base_yyalloc_ALREADY_DEFINED
#else
#define yyalloc base_yyalloc
#endif

#ifdef yyrealloc
#define base_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc base_yyrealloc
#endif

#ifdef yyfree
#define base_yyfree_ALREADY_DEFINED
#else
#define yyfree base_yyfree
#endif

#ifdef yytext
#define base_yytext_ALREADY_DEFINED
#else
#define yytext base_yytext
#endif

#ifdef yyleng
#define base_yyleng_ALREADY_DEFINED
#else
#define yyleng base_yyleng
#endif

#ifdef yyin
#define base_yyin_ALREADY_DEFINED
#else
#define yyin base_yyin
#endif

#ifdef yyout
#define base_yyout_ALREADY_DEFINED
#else
#define yyout base_yyout
#endif

#ifdef yy_flex_debug
#define base_yy_flex_debug_ALREADY_DEFINED
#else
#define yy_flex_debug base_yy_flex_debug
#endif

#ifdef yylineno
#define base_yylineno_ALREADY_DEFINED
#else
#define yylineno base_yylineno
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define base_yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 142
#define YY_END_OF_BUFFER 143
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[588] =
    {   0,
        0,    0,   10,   10,    0,    0,    0,    0,    0,    0,
        9,    9,    0,    0,    0,    0,   19,   19,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  143,  141,   10,   17,    5,    5,
        6,    6,   42,   38,   44,   39,   44,    9,   23,   17,
       20,   19,   19,   19,   19,   24,   24,   17,   29,   23,
       33,   33,   35,   40,  132,  132,  130,   89,   89,  130,
      130,  111,   89,   89,  111,   43,  111,   71,   83,  111,
       12,   87,   88,   82,   85,   81,   86,  111,   84,   59,

       59,   79,   80,  111,   94,  111,   77,   77,   92,   93,
       90,  111,   91,   69,    1,    1,   55,   36,   55,   53,
       54,   55,   14,   54,   54,   54,   54,   59,   54,   54,
       54,   54,   68,   68,   68,   68,   68,   68,  140,  140,
      140,  140,  136,  136,  135,  134,  133,  117,  117,   10,
        5,    7,    4,    3,   42,   41,   44,    9,   23,   21,
       19,   19,   19,   19,   18,   19,   19,   24,   26,   27,
       26,   26,   26,   22,   33,   32,   34,    0,    0,  131,
        0,    0,    0,    0,    0,  103,    0,    0,    0,    0,
        0,    0,  108,   99,    0,   78,  106,  100,  104,  101,

      105,   95,  110,   60,    2,    0,  107,   60,   59,    0,
       73,   97,  102,   96,   77,   77,   98,    1,    0,   55,
       52,   55,    0,    0,   30,   56,   31,    1,   46,   60,
        2,   60,   59,   64,   64,   45,   47,   67,   49,   51,
       48,   50,   68,    8,   15,   13,    0,   11,    0,  139,
        0,    0,    0,  135,  133,    0,    0,  116,    3,   19,
       19,   19,   19,   27,    0,    0,   28,   34,    0,    0,
        0,    0,    0,   76,   76,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  109,    2,    0,
       72,   61,   60,   63,   62,   73,   77,   55,   55,   57,

       31,    1,    1,   65,   65,    2,   60,   59,   64,   63,
       62,   67,    0,    0,    0,   37,   16,  138,  137,   19,
       19,   18,   19,   19,   27,    0,    0,   28,    0,    0,
        0,    0,    0,    0,    0,    0,   76,   76,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   77,
       55,   57,   65,   62,    0,   60,   59,   62,   64,   67,
        0,    0,    0,   67,  138,  138,  137,  137,   19,    0,
        0,  125,    0,    0,    0,    0,    0,    0,    0,   76,
       76,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   77,   55,   55,   65,    0,

       60,   60,   66,   64,   67,    0,    0,    0,    0,    0,
       25,  125,    0,  127,    0,  121,    0,    0,    0,    0,
        0,    0,   76,   76,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  115,    0,   77,   55,   65,    0,
        0,   60,   66,    0,    0,    0,    0,   67,   67,    0,
        0,  129,  121,  123,    0,    0,    0,    0,  113,    0,
      115,    0,   70,   58,    0,    0,    0,    0,    0,   67,
        0,  123,    0,    0,    0,   74,   74,  113,  119,   70,
       70,   77,   77,   77,   77,   58,   67,    0,    0,    0,
        0,   74,   74,   74,    0,   74,    0,  119,    0,    0,

        0,   77,   77,   77,   77,   77,   77,   58,   67,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   77,
       77,   77,   77,   77,   77,   77,   77,  124,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   77,   77,   77,
       77,   77,   77,   77,   77,  124,    0,  126,    0,  120,
        0,    0,    0,    0,    0,    0,   77,   77,   77,   77,
       77,   77,    0,  128,  120,  122,   75,   75,    0,    0,
      114,   77,   77,   77,  114,  122,   75,   75,   75,   75,
      112,    0,  112,   77,  118,  118,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   28,   28,   29,   30,   31,   32,   33,   34,
       35,   35,   36,   35,   35,   37,   38,   39,   40,   41,
       42,   43,   44,   45,   46,   35,   35,   47,   35,   35,
       48,   49,   50,   51,   52,   28,   29,   30,   31,   32,

       33,   34,   35,   35,   53,   35,   35,   37,   38,   39,
       40,   41,   42,   43,   44,   45,   54,   35,   35,   55,
       35,   35,   56,   57,   58,   28,    1,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,

       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59
    } ;

static const YY_CHAR yy_meta[60] =
    {   0,
        1,    2,    3,    3,    4,    5,    4,    6,    7,    4,
        8,    9,    9,   10,    7,    1,   11,   12,   13,   14,
       14,   14,   15,   16,   17,   18,   19,    4,   20,   20,
       20,   20,   20,   20,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   22,   23,    9,
        4,   21,   21,   21,   21,    1,    4,    1,   21
    } ;

static const flex_int16_t yy_base[673] =
    {   0,
        0,    0, 2289, 2252,    0,   53, 2248, 2246,    0,    5,
     2229, 2222, 2221, 2220, 2219, 2218,   18,   27,    1,   34,
        7,   12,    0,   30, 2221, 2220, 2214, 2213,  110,    0,
       38,  168,  201,    0,  260,    0,   28,   60,   71,  171,
      319,    0,  378,    0, 2223, 2933,    0, 2933,    0,    0,
       29, 2208,    0, 2215, 2933, 2933,   10,    0,    0, 2206,
     2933,   86,   89,  175, 2198,    0,    0, 2203,  418, 2199,
        0,    0, 2201, 2202, 2933,  438, 2933, 2933, 2933,  147,
       22, 2933,   94,  186, 2181, 2933,   11,  412, 2180, 2194,
     2933, 2933, 2933,  168,   50, 2933,   82,  177,  433,  435,

      456, 2933, 2933, 2175, 2173, 2171,    0,   39, 2933, 2933,
     2933, 2140, 2933, 2933,  447,  477, 2170, 2933,  486,  477,
        0,    0, 2933, 2933, 2177,  449, 2179,  486,   13,  158,
     2165, 2165,    0, 2179, 2178, 2177, 2173, 2171, 2157,    0,
     2933,    0, 2933,  514, 2933, 2933,    0, 2933,  521,    0,
        0,   88, 2933,    0,    0, 2933, 2933,    0,    0, 2933,
      524,  529, 2162,  545, 2933, 2159,  548,    0, 2933,  440,
        0,    0,    0, 2933,    0, 2933, 2167,  551,  555, 2933,
      449, 2139, 2139,  564,  410, 2933,  579,  496,  535, 2135,
      453, 2128, 2933, 2933,  496, 2933, 2933, 2933, 2933, 2933,

     2933, 2152, 2933,  619,    0, 2162, 2933,  624,  629,  638,
        0, 2933, 2933, 2933,    0, 2131, 2933,  661,  508,    0,
        0,  664,  526,  538, 2933,  655, 2154,  717, 2933,  664,
        0,  678,  683,    0,  692, 2933, 2933,  670,    0,    0,
        0,    0,    0, 2933, 2933, 2933,  637, 2933, 2137, 2933,
     2154, 2132,  726, 2933,    0,  735,  745, 2933,    0,  691,
      749,  753,  758,  500,    0,    0,    0, 2150,  710, 2125,
      470, 2125,  747, 2933,    0, 2115,    0,  769,  497, 2087,
     2096,  531, 2084, 2092, 2088, 2090, 2088, 2933,    0, 2116,
     2933, 2933,  775,  783,  789,    0, 2087,  807, 2103,    0,

     2107,    0,  860,    0,  798,    0,  807,  821,    0,  816,
      839,  828, 2087,    0,  846, 2933, 2933,  849,  878,  887,
      890,  910,  920,  916, 2933,    0,    0, 2933, 2060, 2018,
      670, 1995, 1973,  853,  896,  926,  932,  936, 1946, 1932,
     1921, 1899, 1535, 1535, 1526, 1528,  705, 1527, 1530,  939,
      981,    0,    0,  936,  926,  931,  941,  945,    0,  951,
      975,  999, 1009, 1016,  969, 2933, 1019, 2933, 1025,    0,
        0,  978, 1037, 1527, 1526, 1526, 1042, 1516, 1044, 1543,
     1048,  642, 1051, 1522, 1522, 1511,  429, 1519, 1518, 1507,
      626, 1498,  671, 1482, 1069, 1472,    0,  721,    0, 1056,

     1061, 1069,    0,    0,  987, 1113, 1104, 1170, 1108,    0,
     2933, 1101, 1124, 2933, 1131, 1140, 1479, 1441, 1461,  852,
     1446, 1147, 1224, 1228,    0, 1394, 1382, 1385,    0, 1380,
     1352, 1349, 1347, 1310, 1143, 1298, 1302, 1318,    0, 1155,
     1215, 1219,    0, 1277,    0,    0, 1306, 1051, 1334,    0,
     1242, 2933, 1191, 1246, 1253, 1289,    0, 1287, 1256, 1266,
     1259, 1248, 1383, 1247, 1247, 1247,  693, 1409,    0, 1467,
        0, 1268, 1288,  728, 1220, 1293, 1305, 1272, 1308, 1516,
        0, 1220,  866,  844, 1212, 1293, 1570,    0,  872, 1202,
      767, 1314, 1327, 1352, 1182, 1356, 1180, 1360, 1126,  916,

     1117, 1088, 1048, 1077,  791, 1067, 1064, 2933,    0, 1061,
     1052,  873, 1042, 1028, 1024,  991,  983,  984,  978,  934,
      960,  956,  961,  943,  943,  895,  873, 1363, 1366,  861,
      850,  839, 1033, 1085, 1145,  807,  798,  768, 1369, 1372,
      764,  730,  700, 1106,  685, 1375, 1389, 2933, 1396, 1399,
      648,  625,  622,  627, 1111,  620,  509, 1402, 1405,  460,
      411, 1408, 1463, 2933, 1419, 1428, 1431, 1455,  163,  149,
     1470, 1486, 1489,   72, 1493, 1496, 1499, 1502, 1505, 1508,
     1519,   49, 1522, 1525, 1528, 1531, 2933, 1629, 1652, 1675,
     1698, 1721, 1744, 1767, 1790, 1813, 1836, 1859, 1882, 1905,

     1928, 1951, 1974, 1997, 2020, 2043, 2065, 2088, 1147, 2110,
     2131, 2149, 2167, 2181, 2191, 2198, 2214, 2235, 2258, 2281,
     2299, 2319, 2337, 2356,  848,  940, 1017, 2374, 2392, 2411,
     1036, 1374, 2429, 2450, 1404, 2470, 2478, 2494, 2510, 2527,
     2548, 2571, 2594, 2612, 2632, 2650, 2669, 1166, 1284, 1305,
     2687, 2703, 2719,  557, 2739, 1330, 1369, 2761, 2779, 1522,
     2795, 2811, 1463, 1524, 2833, 2851, 2867, 2888, 1525, 2910,
     1526, 1527
    } ;

static const flex_int16_t yy_def[673] =
    {   0,
      588,  588,  589,  589,  590,  590,  591,  591,  592,  592,
      593,  593,  594,  594,  594,  594,  595,  595,  596,  596,
      594,  594,  597,  597,  591,  591,  594,  594,  587,   29,
      598,  598,  587,   33,  587,   35,  599,  599,  600,  600,
      587,   41,  587,   43,  587,  587,  601,  587,  602,  602,
      587,  587,  603,  587,  587,  587,  587,  604,  605,  587,
      587,  587,  587,  587,  587,  606,  606,  587,  607,  605,
      608,  608,  609,  587,  587,  610,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  611,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,

      587,  587,  587,  587,  587,  587,  612,  612,  587,  587,
      587,  587,  587,  587,  587,  587,  613,  587,  611,  614,
      613,  613,  587,  587,  613,  587,  613,  615,  616,  613,
      613,  613,  617,  617,  617,  617,  617,  617,  618,  619,
      587,  620,  587,  587,  587,  587,  621,  587,  622,  601,
      602,  587,  587,  623,  603,  587,  587,  604,  605,  587,
      587,  587,  587,  587,  587,  587,  624,  606,  587,  587,
      625,  626,  627,  587,  608,  587,  628,  587,  610,  587,
      587,  587,  587,  587,  611,  587,  587,  187,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,

      587,  587,  587,  587,  629,  630,  587,  587,  587,  587,
      631,  587,  587,  587,  612,  612,  587,  587,  611,  613,
      613,  187,  187,  587,  587,  632,  633,  634,  587,  635,
      636,  635,  637,  638,  638,  587,  587,  639,  613,  613,
      613,  613,  640,  587,  587,  587,  587,  587,  641,  587,
      642,  643,  587,  587,  644,  587,  645,  587,  646,  647,
      624,  624,  624,  587,  648,  649,  650,  628,  587,  587,
      587,  587,  187,  587,  273,  273,  187,  273,  187,  187,
      187,  273,  587,  587,  587,  587,  587,  587,  629,  630,
      587,  587,  587,  587,  587,  631,  612,  273,  298,  651,

      633,  634,  634,  652,  652,  636,  635,  637,  638,  587,
      653,  639,  587,  654,  655,  587,  587,  587,  587,  647,
      647,  647,  647,  624,  587,  656,  657,  587,  587,  587,
      587,  587,  587,  587,  658,  273,  273,  273,  187,  187,
      187,  187,  273,  273,  587,  587,  587,  587,  587,  612,
      658,  651,  652,  659,  587,  635,  637,  660,  661,  662,
      655,  655,  655,  655,  587,  587,  587,  587,  647,  663,
      664,  587,  587,  587,  587,  587,  587,  587,  658,  665,
      658,  273,  658,  187,  187,  187,  187,  273,  273,  587,
      587,  587,  587,  587,  587,  612,  351,  298,  666,  587,

      635,  635,  667,  661,  662,  668,  655,  587,  655,  669,
      587,  587,  587,  587,  587,  587,  587,  587,  665,  587,
      273,  658,  658,  658,  187,  187,  187,  187,  273,  273,
      587,  587,  587,  587,  587,  587,  612,  298,  666,  587,
      587,  635,  667,  668,  444,  444,  444,  444,  670,  671,
      587,  587,  587,  587,  587,  187,  273,  587,  587,  587,
      587,  587,  612,  587,  587,  444,  444,  444,  444,  670,
      672,  587,  587,  587,  587,  187,  587,  587,  587,  587,
      480,  612,  612,  612,  612,  587,  587,  664,  587,  587,
      587,  273,  587,  273,  273,  587,  587,  587,  587,  587,

      587,  612,  612,  612,  612,  612,  612,  587,  487,  587,
      587,  587,  587,  587,  273,  587,  587,  587,  587,  612,
      612,  612,  612,  612,  612,  612,  612,  587,  587,  587,
      587,  587,  273,  587,  587,  587,  587,  612,  612,  612,
      612,  612,  612,  612,  612,  587,  587,  587,  587,  587,
      587,  273,  587,  587,  587,  587,  612,  612,  612,  612,
      612,  612,  587,  587,  587,  587,  273,  587,  587,  587,
      587,  612,  612,  612,  587,  587,  273,  587,  273,  587,
      587,  587,  587,  612,  587,  587,    0,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,

      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587
    } ;

static const flex_int16_t yy_nxt[2993] =
    {   0,
      587,  587,   72,   67,   50,   56,   50,   73,   50,   50,
       56,   68,  587,   51,   50,  157,   50,   48,   52,   62,
       63,   64,   48,  587,   50,   50,   50,   50,   62,   63,
       64,  587,   72,  140,   65,  236,   67,   73,  237,   78,
       79,   78,  152,   65,   68,   80,  188,  153,   57,   69,
       50,  141,  142,   57,  141,   70,   50,   50,  157,   50,
       70,   50,   50,  189,  198,  140,   51,   50,  183,   50,
       81,   52,  144,  144,  144,  199,  183,   50,   50,   50,
       50,  585,   69,  141,  142,  216,  141,  161,  162,  162,
      164,  164,  164,  216,  145,  184,  184,  184,  200,  165,

      185,  152,  163,   50,  584,  166,  153,  201,  202,   50,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   75,   75,   75,
       75,   76,   76,   76,   76,   75,   75,   75,   76,   78,
       79,   78,  144,  144,  144,   80,  164,  164,  164,  181,
      582,  195,  182,  239,  240,  165,  196,  184,  184,  184,
      203,  166,  185,  197,  145,  581,  204,  204,  204,  182,

       81,   82,   83,   84,   83,   85,   86,   87,   88,   89,
       90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
      100,  101,  101,  102,  103,  104,  105,  106,   82,  107,
      107,  107,  107,  108,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  109,   82,
      110,   82,  107,  107,  107,  107,  111,  112,  113,  107,
      114,  115,  116,  115,  117,  118,  119,  120,  121,  122,
      123,  124,  124,  121,  121,  124,  125,  126,  127,  128,
      128,  128,  129,  124,  130,  131,  132,  122,  133,  134,
      133,  133,  135,  133,  133,  133,  133,  133,  136,  133,

      133,  133,  133,  133,  133,  137,  138,  124,  114,  124,
      121,  133,  133,  137,  138,  114,  122,  114,  133,  146,
      146,  146,  146,  146,  146,  146,  146,  146,  146,  146,
      146,  146,  146,  146,  146,  146,  146,  146,  146,  146,
      146,  146,  146,  146,  146,  146,  146,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  146,  146,  146,  146,
      147,  147,  147,  147,  146,  146,  146,  147,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,

      148,  148,  148,  148,  148,  148,  149,  149,  149,  149,
      149,  149,  149,  149,  149,  149,  149,  149,  149,  149,
      149,  149,  149,  149,  149,  148,  148,  148,  148,  149,
      149,  149,  149,  148,  148,  148,  149,  170,  170,  178,
      178,  178,  574,  190,  181,  188,  205,  191,  218,  218,
      218,  206,  208,  219,  209,  209,  209,  192,  207,  264,
      264,  180,  189,  171,  191,  192,  229,  210,  230,  230,
      230,  172,  173,  208,  428,  209,  209,  209,  218,  218,
      218,  211,  428,  219,  225,  269,  271,  270,  210,  211,
      222,  286,  222,  573,  222,  222,  226,  226,  226,  222,

      222,  332,  222,  232,  222,  233,  233,  233,  333,  195,
      222,  222,  222,  222,  196,  253,  253,  253,  235,  325,
      325,  223,  256,  256,  256,  161,  162,  162,  339,  279,
      164,  164,  164,  280,  281,  340,  222,  254,  224,  165,
      163,  572,  222,  223,  258,  166,  164,  164,  164,  262,
      162,  162,  178,  178,  178,  165,  178,  178,  178,  279,
      224,  166,  343,  280,  263,  184,  184,  184,  282,  344,
      185,  282,  283,  284,  180,  283,  360,  360,  180,  273,
      273,  274,  275,  273,  273,  273,  273,  273,  273,  273,
      273,  273,  273,  273,  273,  273,  273,  276,  273,  273,

      273,  273,  273,  273,  273,  273,  273,  277,  277,  277,
      277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
      277,  277,  277,  277,  277,  277,  273,  278,  273,  273,
      273,  277,  277,  277,  273,  273,  273,  273,  204,  204,
      204,  292,  316,  293,  293,  293,  208,  317,  209,  209,
      209,  210,  294,  571,  294,  382,  210,  295,  295,  295,
      421,  210,  218,  218,  218,  569,  568,  219,  298,  567,
      298,  432,  298,  298,  226,  226,  226,  298,  298,  432,
      298,  566,  299,  230,  230,  230,  313,  314,  298,  298,
      298,  298,  321,  164,  164,  292,  305,  307,  307,  307,

      232,  322,  308,  308,  308,  374,  310,  323,  310,  447,
      305,  311,  311,  311,  298,  235,  434,  315,  562,  468,
      298,  303,  374,  303,  434,  303,  303,  253,  253,  253,
      303,  303,  560,  303,  398,  303,  256,  256,  256,  438,
      392,  303,  303,  303,  303,  329,  256,  256,  256,  254,
      262,  162,  162,  330,  262,  162,  162,  392,  258,  262,
      162,  162,  329,  559,  489,  263,  490,  303,  258,  263,
      336,  337,  338,  303,  324,  273,  273,  273,  273,  273,
      273,  273,  273,  273,  273,  273,  273,  273,  273,  273,
      273,  273,  273,  273,  293,  293,  293,  558,  513,  273,

      273,  273,  295,  295,  295,  514,  557,  210,  295,  295,
      295,  298,  310,  298,  310,  298,  298,  354,  354,  354,
      298,  298,  524,  298,  355,  299,  356,  356,  356,  525,
      556,  298,  298,  298,  298,  358,  358,  358,  232,  305,
      357,  357,  357,  555,  313,  314,  309,  361,  361,  361,
      365,  365,  365,  235,  377,  377,  377,  298,  311,  311,
      311,  265,  363,  298,  303,  420,  303,  265,  303,  303,
      273,  551,  366,  303,  303,  315,  303,  505,  303,  367,
      367,  367,  506,  550,  303,  303,  303,  303,  321,  164,
      164,  321,  164,  164,  549,  364,  378,  322,  380,  381,

      322,  368,  503,  323,  504,  545,  323,  510,  530,  382,
      303,  321,  164,  164,  276,  511,  303,  262,  162,  162,
      322,  321,  164,  164,  510,  530,  323,  336,  337,  338,
      322,  544,  324,  336,  337,  338,  369,  336,  337,  338,
      395,  395,  395,  353,  383,  400,  400,  400,  355,  491,
      401,  401,  401,  266,  518,  354,  354,  354,  402,  266,
      357,  357,  357,  305,  358,  358,  358,  313,  314,  538,
      365,  365,  365,  235,  543,  542,  361,  361,  361,  412,
      412,  412,  396,  380,  381,  397,  538,  397,  540,  397,
      397,  363,  366,  539,  398,  397,  541,  397,  315,  299,

      361,  361,  361,  313,  314,  397,  397,  397,  397,  537,
      361,  361,  361,  541,  536,  363,  535,  361,  361,  361,
      367,  367,  367,  534,  364,  406,  321,  164,  164,  383,
      267,  397,  407,  408,  315,  322,  267,  397,  413,  413,
      413,  369,  368,  377,  377,  377,  380,  381,  364,  296,
      380,  381,  422,  423,  424,  296,  533,  382,  364,  532,
      414,  382,  276,  409,  382,  364,  276,  467,  468,  276,
      395,  395,  395,  440,  531,  441,  441,  441,  355,  552,
      442,  442,  442,  521,  529,  378,  292,  552,  442,  442,
      442,  522,  383,  305,  528,  527,  383,  526,  469,  383,

      521,  305,  412,  412,  412,  361,  361,  361,  523,  361,
      361,  361,  436,  444,  445,  361,  361,  444,  444,  444,
      406,  520,  444,  444,  363,  413,  413,  413,  444,  447,
      408,  553,  451,  451,  451,  444,  444,  444,  444,  553,
      444,  453,  453,  453,  461,  461,  461,  414,  422,  423,
      424,  561,  177,  364,  452,  519,  570,  364,  517,  561,
      382,  444,  448,  444,  570,  276,  177,  177,  444,  444,
      444,  361,  361,  361,  464,  464,  464,  362,  362,  326,
      554,  362,  362,  362,  362,  326,  363,  362,  362,  362,
      362,  362,  453,  453,  453,  383,  362,  554,  449,  449,

      449,  449,  449,  449,  449,  449,  449,  449,  449,  449,
      449,  449,  449,  449,  449,  449,  449,  362,  516,  364,
      515,  449,  449,  449,  449,  422,  423,  424,  449,  422,
      423,  424,  440,  512,  465,  465,  465,  382,  442,  442,
      442,  382,  276,  451,  451,  451,  276,  472,  472,  472,
      507,  305,  502,  491,  473,  473,  473,  478,  478,  478,
      461,  461,  461,  447,  440,  452,  486,  486,  486,  472,
      472,  472,  383,  478,  478,  478,  383,  444,  445,  361,
      361,  444,  444,  444,  480,  474,  444,  444,  475,  473,
      473,  473,  444,  466,  492,  493,  494,  327,  479,  444,

      444,  444,  444,  327,  444,  475,  496,  496,  496,  498,
      498,  498,  508,  508,  508,  492,  493,  494,  328,  477,
      474,  476,  447,  475,  328,  444,  448,  444,  496,  496,
      496,  351,  444,  444,  444,  361,  361,  361,  463,  462,
      475,  460,  362,  370,  495,  362,  362,  362,  362,  370,
      407,  408,  362,  492,  493,  494,  497,  496,  496,  496,
      362,  498,  498,  498,  546,  546,  546,  547,  547,  547,
      546,  546,  546,  547,  547,  547,  546,  546,  546,  459,
      458,  409,  371,  364,  481,  481,  481,  300,  371,  548,
      547,  547,  547,  300,  300,  548,  457,  563,  563,  563,

      565,  565,  565,  563,  563,  563,  565,  565,  565,  575,
      575,  575,  548,  429,  482,  483,  456,  304,  484,  564,
      565,  565,  565,  304,  304,  564,  425,  425,  485,  576,
      576,  576,  577,  578,  579,  484,  485,  487,  487,  487,
      487,  487,  487,  487,  487,  487,  487,  487,  487,  487,
      487,  487,  487,  487,  487,  487,  580,  580,  580,  335,
      487,  487,  487,  487,  563,  563,  563,  487,  361,  361,
      361,  575,  575,  575,  420,  362,  410,  455,  362,  362,
      362,  362,  410,  407,  408,  362,  564,  583,  583,  583,
      576,  576,  576,  362,  575,  575,  575,  576,  576,  576,

      577,  578,  579,  580,  580,  580,  577,  578,  579,  580,
      580,  580,  454,  437,  409,  435,  364,  481,  481,  481,
      583,  583,  583,  583,  583,  583,  586,  586,  586,  586,
      586,  586,  586,  586,  586,  403,  433,  411,  450,  471,
      488,  403,  403,  411,  450,  471,  488,  499,  474,  431,
      430,  500,  429,  427,  426,  425,  420,  418,  417,  416,
      415,  501,  394,  393,  391,  390,  389,  388,  500,  501,
      444,  445,  361,  361,  444,  444,  444,  509,  446,  444,
      444,  446,  446,  446,  446,  444,  467,  468,  446,  509,
      509,  509,  444,  444,  444,  444,  446,  444,  509,  509,

      509,  509,  509,  509,  509,  509,  509,  509,  509,  509,
      509,  509,  509,  509,  509,  509,  509,  469,  444,  448,
      444,  509,  509,  509,  509,  444,  444,  444,  509,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   47,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   53,   53,

       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   58,   58,   58,   58,   58,   58,
       58,   58,   58,   58,   58,   58,   58,   58,   58,   58,
       58,   58,   58,   58,   58,   58,   58,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,

       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   66,   66,   66,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   77,
       77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
       77,   77,  139,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,

      139,  139,  139,  139,  139,  143,  143,  143,  143,  143,
      143,  143,  143,  143,  143,  143,  143,  143,  143,  143,
      143,  143,  143,  143,  143,  143,  143,  143,  150,  150,
      150,  150,  150,  150,  150,  387,  150,  150,  150,  150,
      150,  150,  150,  150,  150,  150,  150,  150,  150,  150,
      150,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      386,  151,  151,  385,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  155,  155,  155,  155,  384,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  158,  158,  158,

      158,  158,  158,  158,  376,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      159,  159,  159,  159,  159,  159,  159,  375,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  168,  168,  168,  168,  168,  168,  168,
      373,  168,  168,  168,  168,  168,  168,  168,  168,  168,
      168,  168,  168,  168,  168,  169,  169,  169,  169,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  175,  175,
      175,  175,  175,  372,  175,  175,  175,  175,  175,  175,

      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  179,  179,  314,  225,  179,  351,  350,  291,  349,
      348,  347,  346,  179,  345,  179,  342,  341,  335,  179,
      179,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  215,  334,  331,  176,  319,  318,
      250,  225,  215,  297,  291,  288,  287,  285,  215,  215,
      220,  272,  271,  220,  176,  260,  220,  220,  167,  220,
      250,  248,  247,  220,  220,  220,  227,  246,  245,  244,
      242,  241,  231,  228,  227,  221,  217,  214,  213,  212,

      227,  227,  234,  194,  234,  193,  186,  156,  176,  174,
      234,  234,  238,  160,  167,  238,  160,  238,  238,  243,
      156,  154,  587,   60,   60,   74,   74,  243,   60,   60,
       60,   60,   48,  243,  243,  249,  249,  249,  249,   48,
      249,  249,  249,  249,  249,  249,  249,  249,  249,  249,
      249,   54,  249,   54,  249,  249,  249,  249,  251,  251,
      251,  251,   48,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  252,  252,  252,  252,  252,  252,  252,  252,  252,
      252,  252,  252,  252,  252,  252,  252,  252,  252,   48,

      252,  252,  252,  252,  255,  587,  587,  587,  587,  587,
      587,  587,  255,  587,  587,  587,  587,  587,  255,  255,
      257,  257,  587,  587,  257,  587,  587,  587,  587,  587,
      587,  587,  257,  587,  257,  587,  587,  587,  257,  257,
      259,  587,  587,  259,  587,  587,  259,  259,  587,  259,
      587,  587,  587,  259,  259,  259,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  268,
      587,  587,  587,  587,  587,  587,  587,  268,  587,  587,
      587,  587,  587,  268,  268,  289,  587,  587,  289,  587,

      587,  289,  289,  587,  289,  587,  587,  587,  289,  289,
      289,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  301,  587,  587,  587,  587,  587,
      587,  587,  301,  587,  587,  587,  587,  587,  301,  301,
      302,  302,  587,  302,  302,  302,  302,  302,  302,  302,
      302,  302,  302,  302,  302,  302,  302,  302,  302,  302,
      302,  302,  302,  306,  587,  587,  306,  587,  587,  306,
      306,  587,  306,  587,  587,  587,  306,  306,  306,  234,
      587,  234,  587,  587,  587,  587,  587,  234,  234,  309,

      587,  587,  587,  587,  587,  587,  587,  309,  587,  587,
      587,  587,  587,  309,  309,  312,  587,  587,  587,  587,
      312,  312,  587,  312,  587,  587,  587,  587,  587,  312,
      312,  312,  243,  587,  587,  587,  587,  587,  587,  587,
      243,  587,  587,  587,  587,  587,  243,  243,  249,  249,
      249,  249,  587,  249,  249,  249,  249,  249,  249,  249,
      249,  249,  249,  249,  587,  249,  587,  249,  249,  249,
      249,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  252,  252,  252,  252,  252,  252,

      252,  252,  252,  252,  252,  252,  252,  252,  252,  252,
      252,  252,  252,  252,  252,  252,  252,  255,  587,  587,
      587,  587,  587,  587,  587,  255,  587,  587,  587,  587,
      587,  255,  255,  257,  257,  587,  587,  257,  587,  587,
      587,  587,  587,  587,  587,  257,  587,  257,  587,  587,
      587,  257,  257,  259,  587,  587,  259,  587,  587,  259,
      259,  587,  259,  587,  587,  587,  259,  259,  259,  320,
      320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
      320,  320,  320,  320,  320,  320,  320,  320,  320,  320,
      320,  320,  352,  587,  587,  587,  587,  587,  587,  587,

      352,  587,  587,  587,  587,  587,  352,  352,  353,  587,
      587,  587,  587,  587,  587,  587,  353,  587,  587,  587,
      587,  587,  353,  353,  359,  587,  587,  587,  587,  587,
      587,  587,  359,  587,  587,  587,  587,  587,  359,  359,
      362,  362,  587,  587,  362,  362,  587,  362,  362,  362,
      362,  362,  362,  587,  587,  587,  587,  362,  362,  362,
      362,  379,  379,  379,  379,  379,  379,  379,  379,  379,
      379,  379,  379,  379,  379,  379,  379,  379,  379,  379,
      379,  379,  379,  379,  399,  587,  587,  587,  587,  587,
      587,  587,  399,  587,  587,  587,  587,  587,  399,  399,

      404,  587,  587,  587,  587,  587,  587,  587,  404,  587,
      587,  587,  587,  587,  404,  404,  405,  587,  587,  587,
      587,  405,  405,  587,  405,  587,  587,  587,  587,  587,
      405,  405,  405,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  587,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  439,  587,  587,  587,
      587,  587,  587,  587,  439,  587,  587,  587,  587,  587,
      439,  439,  443,  587,  587,  587,  587,  587,  587,  587,
      443,  587,  587,  587,  587,  587,  443,  443,  446,  446,
      446,  446,  446,  446,  446,  446,  446,  446,  446,  446,

      446,  446,  446,  446,  446,  446,  446,  446,  446,  446,
      446,  470,  470,  587,  587,  470,  470,  587,  470,  470,
      470,  470,  470,  470,  587,  587,  587,  587,  470,  470,
      470,  470,   45,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587

    } ;

static const flex_int16_t yy_chk[2993] =
    {   0,
        0,    0,   23,   19,    5,    9,    5,   23,    5,    5,
       10,   19,    0,    5,    5,   57,    5,   21,    5,   17,
       17,   17,   22,    0,    5,    5,    5,    5,   18,   18,
       18,    0,   24,   37,   17,  129,   20,   24,  129,   31,
       31,   31,   51,   18,   20,   31,   87,   51,    9,   19,
        5,   37,   37,   10,   37,   21,    5,    6,   57,    6,
       22,    6,    6,   87,   95,   38,    6,    6,   81,    6,
       31,    6,   39,   39,   39,   95,   81,    6,    6,    6,
        6,  582,   20,   38,   38,  108,   38,   62,   62,   62,
       63,   63,   63,  108,   39,   83,   83,   83,   97,   63,

       83,  152,   62,    6,  574,   63,  152,   97,   97,    6,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   32,
       32,   32,   40,   40,   40,   32,   64,   64,   64,   80,
      570,   94,   80,  130,  130,   64,   94,   84,   84,   84,
       98,   64,   84,   94,   40,  569,   98,   98,   98,   80,

       32,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,

       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,

       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   69,   69,   76,
       76,   76,  561,   88,   88,  185,   99,   88,  115,  115,
      115,   99,  100,  115,  100,  100,  100,   88,   99,  170,
      170,   76,  185,   69,   88,   88,  126,  100,  126,  126,
      126,   69,   69,  101,  387,  101,  101,  101,  116,  116,
      116,  100,  387,  116,  120,  181,  191,  181,  101,  100,
      119,  191,  119,  560,  119,  119,  120,  120,  120,  119,

      119,  271,  119,  128,  119,  128,  128,  128,  271,  195,
      119,  119,  119,  119,  195,  144,  144,  144,  128,  264,
      264,  119,  149,  149,  149,  161,  161,  161,  279,  188,
      162,  162,  162,  188,  188,  279,  119,  144,  119,  162,
      161,  557,  119,  219,  149,  162,  164,  164,  164,  167,
      167,  167,  178,  178,  178,  164,  179,  179,  179,  223,
      219,  164,  282,  223,  167,  184,  184,  184,  189,  282,
      184,  224,  189,  189,  178,  224,  654,  654,  179,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,

      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  204,  204,
      204,  208,  247,  208,  208,  208,  209,  247,  209,  209,
      209,  204,  210,  556,  210,  382,  208,  210,  210,  210,
      382,  209,  218,  218,  218,  554,  553,  218,  222,  552,
      222,  391,  222,  222,  226,  226,  226,  222,  222,  391,
      222,  551,  222,  230,  230,  230,  238,  238,  222,  222,
      222,  222,  260,  260,  260,  232,  230,  232,  232,  232,

      233,  260,  233,  233,  233,  331,  235,  260,  235,  467,
      232,  235,  235,  235,  222,  233,  393,  238,  545,  467,
      222,  228,  331,  228,  393,  228,  228,  253,  253,  253,
      228,  228,  543,  228,  398,  228,  256,  256,  256,  398,
      347,  228,  228,  228,  228,  269,  257,  257,  257,  253,
      261,  261,  261,  269,  262,  262,  262,  347,  256,  263,
      263,  263,  269,  542,  474,  261,  474,  228,  257,  262,
      278,  278,  278,  228,  263,  273,  273,  273,  273,  273,
      273,  273,  273,  273,  273,  273,  273,  273,  273,  273,
      273,  273,  273,  273,  293,  293,  293,  541,  491,  273,

      273,  273,  294,  294,  294,  491,  538,  293,  295,  295,
      295,  298,  305,  298,  305,  298,  298,  305,  305,  305,
      298,  298,  505,  298,  307,  298,  307,  307,  307,  505,
      537,  298,  298,  298,  298,  310,  310,  310,  308,  307,
      308,  308,  308,  536,  312,  312,  311,  315,  315,  315,
      318,  318,  318,  308,  334,  334,  334,  298,  311,  311,
      311,  625,  315,  298,  303,  420,  303,  625,  303,  303,
      420,  532,  318,  303,  303,  312,  303,  484,  303,  319,
      319,  319,  484,  531,  303,  303,  303,  303,  320,  320,
      320,  321,  321,  321,  530,  315,  334,  320,  335,  335,

      321,  319,  483,  320,  483,  527,  321,  489,  512,  335,
      303,  322,  322,  322,  335,  489,  303,  324,  324,  324,
      322,  323,  323,  323,  489,  512,  322,  336,  336,  336,
      323,  526,  324,  337,  337,  337,  323,  338,  338,  338,
      350,  350,  350,  354,  335,  355,  355,  355,  356,  500,
      356,  356,  356,  626,  500,  354,  354,  354,  357,  626,
      357,  357,  357,  356,  358,  358,  358,  360,  360,  520,
      365,  365,  365,  357,  525,  524,  361,  361,  361,  372,
      372,  372,  350,  351,  351,  351,  520,  351,  522,  351,
      351,  361,  365,  521,  351,  351,  523,  351,  360,  351,

      362,  362,  362,  405,  405,  351,  351,  351,  351,  519,
      363,  363,  363,  523,  518,  362,  517,  364,  364,  364,
      367,  367,  367,  516,  361,  363,  369,  369,  369,  351,
      627,  351,  364,  364,  405,  369,  627,  351,  373,  373,
      373,  369,  367,  377,  377,  377,  379,  379,  362,  631,
      381,  381,  383,  383,  383,  631,  515,  379,  363,  514,
      373,  381,  379,  364,  383,  364,  381,  448,  448,  383,
      395,  395,  395,  400,  513,  400,  400,  400,  401,  533,
      401,  401,  401,  503,  511,  377,  402,  533,  402,  402,
      402,  503,  379,  401,  510,  507,  381,  506,  448,  383,

      503,  402,  412,  412,  412,  407,  407,  407,  504,  409,
      409,  409,  395,  406,  406,  406,  406,  406,  406,  406,
      407,  502,  406,  406,  409,  413,  413,  413,  406,  406,
      407,  534,  415,  415,  415,  406,  406,  406,  406,  534,
      406,  416,  416,  416,  435,  435,  435,  413,  422,  422,
      422,  544,  609,  407,  415,  501,  555,  409,  499,  544,
      422,  406,  406,  406,  555,  422,  609,  609,  406,  406,
      406,  408,  408,  408,  440,  440,  440,  408,  408,  648,
      535,  408,  408,  408,  408,  648,  408,  408,  408,  408,
      408,  408,  453,  453,  453,  422,  408,  535,  408,  408,

      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  497,  408,
      495,  408,  408,  408,  408,  423,  423,  423,  408,  424,
      424,  424,  441,  490,  441,  441,  441,  423,  442,  442,
      442,  424,  423,  451,  451,  451,  424,  454,  454,  454,
      485,  442,  482,  475,  455,  455,  455,  459,  459,  459,
      461,  461,  461,  466,  465,  451,  464,  464,  464,  472,
      472,  472,  423,  478,  478,  478,  424,  444,  444,  444,
      444,  444,  444,  444,  462,  455,  444,  444,  455,  473,
      473,  473,  444,  444,  476,  476,  476,  649,  460,  444,

      444,  444,  444,  649,  444,  455,  477,  477,  477,  479,
      479,  479,  486,  486,  486,  492,  492,  492,  650,  458,
      473,  456,  447,  473,  650,  444,  444,  444,  493,  493,
      493,  438,  444,  444,  444,  449,  449,  449,  437,  436,
      473,  434,  449,  656,  476,  449,  449,  449,  449,  656,
      449,  449,  449,  494,  494,  494,  477,  496,  496,  496,
      449,  498,  498,  498,  528,  528,  528,  529,  529,  529,
      539,  539,  539,  540,  540,  540,  546,  546,  546,  433,
      432,  449,  657,  449,  463,  463,  463,  632,  657,  529,
      547,  547,  547,  632,  632,  540,  431,  549,  549,  549,

      550,  550,  550,  558,  558,  558,  559,  559,  559,  562,
      562,  562,  547,  430,  463,  463,  428,  635,  463,  549,
      565,  565,  565,  635,  635,  558,  427,  426,  463,  566,
      566,  566,  567,  567,  567,  463,  463,  468,  468,  468,
      468,  468,  468,  468,  468,  468,  468,  468,  468,  468,
      468,  468,  468,  468,  468,  468,  568,  568,  568,  421,
      468,  468,  468,  468,  563,  563,  563,  468,  470,  470,
      470,  571,  571,  571,  419,  470,  663,  418,  470,  470,
      470,  470,  663,  470,  470,  470,  563,  572,  572,  572,
      573,  573,  573,  470,  575,  575,  575,  576,  576,  576,

      577,  577,  577,  578,  578,  578,  579,  579,  579,  580,
      580,  580,  417,  396,  470,  394,  470,  480,  480,  480,
      581,  581,  581,  583,  583,  583,  584,  584,  584,  585,
      585,  585,  586,  586,  586,  660,  392,  664,  669,  671,
      672,  660,  660,  664,  669,  671,  672,  480,  480,  390,
      389,  480,  388,  386,  385,  384,  380,  378,  376,  375,
      374,  480,  349,  348,  346,  345,  344,  343,  480,  480,
      487,  487,  487,  487,  487,  487,  487,  487,  487,  487,
      487,  487,  487,  487,  487,  487,  487,  487,  487,  487,
      487,  487,  487,  487,  487,  487,  487,  487,  487,  487,

      487,  487,  487,  487,  487,  487,  487,  487,  487,  487,
      487,  487,  487,  487,  487,  487,  487,  487,  487,  487,
      487,  487,  487,  487,  487,  487,  487,  487,  487,  588,
      588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
      588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
      588,  588,  589,  589,  589,  589,  589,  589,  589,  589,
      589,  589,  589,  589,  589,  589,  589,  589,  589,  589,
      589,  589,  589,  589,  589,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  591,  591,

      591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
      591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
      591,  592,  592,  592,  592,  592,  592,  592,  592,  592,
      592,  592,  592,  592,  592,  592,  592,  592,  592,  592,
      592,  592,  592,  592,  593,  593,  593,  593,  593,  593,
      593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
      593,  593,  593,  593,  593,  593,  593,  594,  594,  594,
      594,  594,  594,  594,  594,  594,  594,  594,  594,  594,
      594,  594,  594,  594,  594,  594,  594,  594,  594,  594,
      595,  595,  595,  595,  595,  595,  595,  595,  595,  595,

      595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
      595,  595,  595,  596,  596,  596,  596,  596,  596,  596,
      596,  596,  596,  596,  596,  596,  596,  596,  596,  596,
      596,  596,  596,  596,  596,  596,  597,  597,  597,  597,
      597,  597,  597,  597,  597,  597,  597,  597,  597,  597,
      597,  597,  597,  597,  597,  597,  597,  597,  597,  598,
      598,  598,  598,  598,  598,  598,  598,  598,  598,  598,
      598,  598,  598,  598,  598,  598,  598,  598,  598,  598,
      598,  598,  599,  599,  599,  599,  599,  599,  599,  599,
      599,  599,  599,  599,  599,  599,  599,  599,  599,  599,

      599,  599,  599,  599,  599,  600,  600,  600,  600,  600,
      600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
      600,  600,  600,  600,  600,  600,  600,  600,  601,  601,
      601,  601,  601,  601,  601,  342,  601,  601,  601,  601,
      601,  601,  601,  601,  601,  601,  601,  601,  601,  601,
      601,  602,  602,  602,  602,  602,  602,  602,  602,  602,
      341,  602,  602,  340,  602,  602,  602,  602,  602,  602,
      602,  602,  602,  602,  603,  603,  603,  603,  339,  603,
      603,  603,  603,  603,  603,  603,  603,  603,  603,  603,
      603,  603,  603,  603,  603,  603,  603,  604,  604,  604,

      604,  604,  604,  604,  333,  604,  604,  604,  604,  604,
      604,  604,  604,  604,  604,  604,  604,  604,  604,  604,
      605,  605,  605,  605,  605,  605,  605,  332,  605,  605,
      605,  605,  605,  605,  605,  605,  605,  605,  605,  605,
      605,  605,  605,  606,  606,  606,  606,  606,  606,  606,
      330,  606,  606,  606,  606,  606,  606,  606,  606,  606,
      606,  606,  606,  606,  606,  607,  607,  607,  607,  607,
      607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
      607,  607,  607,  607,  607,  607,  607,  607,  608,  608,
      608,  608,  608,  329,  608,  608,  608,  608,  608,  608,

      608,  608,  608,  608,  608,  608,  608,  608,  608,  608,
      608,  610,  610,  313,  301,  610,  299,  297,  290,  287,
      286,  285,  284,  610,  283,  610,  281,  280,  276,  610,
      610,  611,  611,  611,  611,  611,  611,  611,  611,  611,
      611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
      611,  611,  611,  611,  612,  272,  270,  268,  252,  251,
      249,  227,  612,  216,  206,  202,  192,  190,  612,  612,
      613,  183,  182,  613,  177,  166,  613,  613,  163,  613,
      139,  138,  137,  613,  613,  613,  614,  136,  135,  134,
      132,  131,  127,  125,  614,  117,  112,  106,  105,  104,

      614,  614,  615,   90,  615,   89,   85,   74,   73,   70,
      615,  615,  616,   68,   65,  616,   60,  616,  616,  617,
       54,   52,   45,   28,   27,   26,   25,  617,   16,   15,
       14,   13,   12,  617,  617,  618,  618,  618,  618,   11,
      618,  618,  618,  618,  618,  618,  618,  618,  618,  618,
      618,    8,  618,    7,  618,  618,  618,  618,  619,  619,
      619,  619,    4,  619,  619,  619,  619,  619,  619,  619,
      619,  619,  619,  619,  619,  619,  619,  619,  619,  619,
      619,  620,  620,  620,  620,  620,  620,  620,  620,  620,
      620,  620,  620,  620,  620,  620,  620,  620,  620,    3,

      620,  620,  620,  620,  621,    0,    0,    0,    0,    0,
        0,    0,  621,    0,    0,    0,    0,    0,  621,  621,
      622,  622,    0,    0,  622,    0,    0,    0,    0,    0,
        0,    0,  622,    0,  622,    0,    0,    0,  622,  622,
      623,    0,    0,  623,    0,    0,  623,  623,    0,  623,
        0,    0,    0,  623,  623,  623,  624,  624,  624,  624,
      624,  624,  624,  624,  624,  624,  624,  624,  624,  624,
      624,  624,  624,  624,  624,  624,  624,  624,  624,  628,
        0,    0,    0,    0,    0,    0,    0,  628,    0,    0,
        0,    0,    0,  628,  628,  629,    0,    0,  629,    0,

        0,  629,  629,    0,  629,    0,    0,    0,  629,  629,
      629,  630,  630,  630,  630,  630,  630,  630,  630,  630,
      630,  630,  630,  630,  630,  630,  630,  630,  630,  630,
      630,  630,  630,  630,  633,    0,    0,    0,    0,    0,
        0,    0,  633,    0,    0,    0,    0,    0,  633,  633,
      634,  634,    0,  634,  634,  634,  634,  634,  634,  634,
      634,  634,  634,  634,  634,  634,  634,  634,  634,  634,
      634,  634,  634,  636,    0,    0,  636,    0,    0,  636,
      636,    0,  636,    0,    0,    0,  636,  636,  636,  637,
        0,  637,    0,    0,    0,    0,    0,  637,  637,  638,

        0,    0,    0,    0,    0,    0,    0,  638,    0,    0,
        0,    0,    0,  638,  638,  639,    0,    0,    0,    0,
      639,  639,    0,  639,    0,    0,    0,    0,    0,  639,
      639,  639,  640,    0,    0,    0,    0,    0,    0,    0,
      640,    0,    0,    0,    0,    0,  640,  640,  641,  641,
      641,  641,    0,  641,  641,  641,  641,  641,  641,  641,
      641,  641,  641,  641,    0,  641,    0,  641,  641,  641,
      641,  642,  642,  642,  642,  642,  642,  642,  642,  642,
      642,  642,  642,  642,  642,  642,  642,  642,  642,  642,
      642,  642,  642,  642,  643,  643,  643,  643,  643,  643,

      643,  643,  643,  643,  643,  643,  643,  643,  643,  643,
      643,  643,  643,  643,  643,  643,  643,  644,    0,    0,
        0,    0,    0,    0,    0,  644,    0,    0,    0,    0,
        0,  644,  644,  645,  645,    0,    0,  645,    0,    0,
        0,    0,    0,    0,    0,  645,    0,  645,    0,    0,
        0,  645,  645,  646,    0,    0,  646,    0,    0,  646,
      646,    0,  646,    0,    0,    0,  646,  646,  646,  647,
      647,  647,  647,  647,  647,  647,  647,  647,  647,  647,
      647,  647,  647,  647,  647,  647,  647,  647,  647,  647,
      647,  647,  651,    0,    0,    0,    0,    0,    0,    0,

      651,    0,    0,    0,    0,    0,  651,  651,  652,    0,
        0,    0,    0,    0,    0,    0,  652,    0,    0,    0,
        0,    0,  652,  652,  653,    0,    0,    0,    0,    0,
        0,    0,  653,    0,    0,    0,    0,    0,  653,  653,
      655,  655,    0,    0,  655,  655,    0,  655,  655,  655,
      655,  655,  655,    0,    0,    0,    0,  655,  655,  655,
      655,  658,  658,  658,  658,  658,  658,  658,  658,  658,
      658,  658,  658,  658,  658,  658,  658,  658,  658,  658,
      658,  658,  658,  658,  659,    0,    0,    0,    0,    0,
        0,    0,  659,    0,    0,    0,    0,    0,  659,  659,

      661,    0,    0,    0,    0,    0,    0,    0,  661,    0,
        0,    0,    0,    0,  661,  661,  662,    0,    0,    0,
        0,  662,  662,    0,  662,    0,    0,    0,    0,    0,
      662,  662,  662,  665,  665,  665,  665,  665,  665,  665,
      665,  665,  665,  665,  665,    0,  665,  665,  665,  665,
      665,  665,  665,  665,  665,  665,  666,    0,    0,    0,
        0,    0,    0,    0,  666,    0,    0,    0,    0,    0,
      666,  666,  667,    0,    0,    0,    0,    0,    0,    0,
      667,    0,    0,    0,    0,    0,  667,  667,  668,  668,
      668,  668,  668,  668,  668,  668,  668,  668,  668,  668,

      668,  668,  668,  668,  668,  668,  668,  668,  668,  668,
      668,  670,  670,    0,    0,  670,  670,    0,  670,  670,
      670,  670,  670,  670,    0,    0,    0,    0,  670,  670,
      670,  670,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587

    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[143] =
    {   0,
1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
    1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
    0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
    1, 1, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "pgc.l"

#line 33 "pgc.l"

/* LCOV_EXCL_START */

extern YYSTYPE base_yylval;

static int		xcdepth = 0;	/* depth of nesting in slash-star comments */
static char	   *dolqstart = NULL;	/* current $foo$ quote start string */

/*
 * literalbuf is used to accumulate literal values when multiple rules
 * are needed to parse a single literal.  Call startlit to reset buffer
 * to empty, addlit to add text.  Note that the buffer is permanently
 * malloc'd to the largest size needed so far in the current run.
 */
static char	   *literalbuf = NULL;		/* expandable buffer */
static int		literallen;				/* actual current length */
static int		literalalloc;			/* current allocated buffer size */

/* Used for detecting global state together with braces_open */
static int		parenths_open;

/* Used to tell parse_include() whether the command was #include or #include_next */
static bool		include_next;

#define startlit()	(literalbuf[0] = '\0', literallen = 0)
static void addlit(char *ytext, int yleng);
static void addlitchar(unsigned char);
static int	process_integer_literal(const char *token, YYSTYPE *lval);
static void parse_include(void);
static bool ecpg_isspace(char ch);
static bool isdefine(void);
static bool isinformixdefine(void);

char *token_start;

/* vars to keep track of start conditions when scanning literals */
static int state_before_str_start;
static int state_before_str_stop;

/*
 * State for handling include files and macro expansion.  We use a new
 * flex input buffer for each level of include or macro, and create a
 * struct _yy_buffer to remember the previous level.  There is not a struct
 * for the currently active input source; that state is kept in the global
 * variables YY_CURRENT_BUFFER, yylineno, and input_filename.
 */
static struct _yy_buffer
{
	YY_BUFFER_STATE		buffer;
	long				lineno;
	char			   *filename;
	struct _yy_buffer  *next;
} *yy_buffer = NULL;

/*
 * Vars for handling ifdef/elif/endif constructs.  preproc_tos is the current
 * nesting depth of such constructs, and stacked_if_value[preproc_tos] is the
 * state for the innermost level.  (For convenience, stacked_if_value[0] is
 * initialized as though we are in the active branch of some outermost IF.)
 * The active field is true if the current branch is active (being expanded).
 * The saw_active field is true if we have found any successful branch,
 * so that all subsequent branches of this level should be skipped.
 * The else_branch field is true if we've found an 'else' (so that another
 * 'else' or 'elif' at this level is an error.)
 * For IFs nested within an inactive branch, all branches always have active
 * set to false, but saw_active and else_branch are maintained normally.
 * ifcond is valid only while evaluating an if-condition; it's true if we
 * are doing ifdef, false if ifndef.
 */
#define MAX_NESTED_IF 128
static short preproc_tos;
static bool ifcond;
static struct _if_value
{
	bool		active;
	bool		saw_active;
	bool		else_branch;
} stacked_if_value[MAX_NESTED_IF];

#line 1716 "pgc.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xdc> double-quoted strings in C
 *  <xh> hexadecimal byte string
 *  <xn> national character quoted strings
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xqc> single-quoted strings in C
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xcond> condition of an EXEC SQL IFDEF construct
 *  <xskip> skipping the inactive part of an EXEC SQL IFDEF construct
 *
 * Note: we intentionally don't mimic the backend's <xeu> state; we have
 * no need to distinguish it from <xe> state.
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/* Additional exclusive states that are specific to ECPG */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  SQL-style comments, which start with -- and extend to the
 * next newline, are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix ecpg_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* special stuff for C strings */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {decimalfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/* special characters for other dbms */
/* we have to react differently in compat mode */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
/* some stuff needed for ecpg */
/* C version of hex number */
/* we might want to parse all cpp include files */
/* take care of cpp lines, they may also be continued */
/* first a general line for all commands not starting with "i" */
/* and then the other commands starting with "i", we have to add these
 * separately because the cppline production would match on "include" too
 */
#line 1878 "pgc.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xdc 4
#define xh 5
#define xn 6
#define xq 7
#define xqs 8
#define xe 9
#define xqc 10
#define xdolq 11
#define xui 12
#define xus 13
#define xcond 14
#define xskip 15
#define C 16
#define SQL 17
#define incl 18
#define def 19
#define def_ident 20
#define undef 21

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 436 "pgc.l"



#line 440 "pgc.l"
		/* code to execute during start of each call of yylex() */
		char *newdefsymbol = NULL;

		token_start = NULL;


#line 2127 "pgc.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 588 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 587 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 447 "pgc.l"
{
					/* ignore */
				}
	YY_BREAK
/* <SQL> */

case 2:
YY_RULE_SETUP
#line 453 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/*", yyout);
				}
	YY_BREAK
/* <C,SQL> */

case 3:
YY_RULE_SETUP
#line 465 "pgc.l"
{
					if (state_before_str_start == SQL)
					{
						xcdepth++;
						/* Put back any characters past slash-star; see above */
						yyless(2);
						fputs("/_*", yyout);
					}
					else if (state_before_str_start == C)
					{
						ECHO;
					}
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 479 "pgc.l"
{
					if (state_before_str_start == SQL)
					{
						if (xcdepth <= 0)
						{
							ECHO;
							BEGIN(SQL);
							token_start = NULL;
						}
						else
						{
							xcdepth--;
							fputs("*_/", yyout);
						}
					}
					else if (state_before_str_start == C)
					{
						ECHO;
						BEGIN(C);
						token_start = NULL;
					}
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 502 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 506 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 510 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 514 "pgc.l"
{
					mmfatal(PARSE_ERROR, "unterminated /* comment");
				}
	YY_BREAK
/* <xc> */

case 8:
YY_RULE_SETUP
#line 520 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xb);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 9:
/* rule 9 can match eol */
#line 529 "pgc.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 529 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 532 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated bit string literal"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 534 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xh);
					startlit();
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 540 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated hexadecimal string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 542 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xqc);
					startlit();
				}
	YY_BREAK

case 13:
YY_RULE_SETUP
#line 550 "pgc.l"
{
					/* National character.
					 * Transfer it as-is to the backend.
					 */
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xn);
					startlit();
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 560 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xq);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 566 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 572 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 17:
YY_RULE_SETUP
#line 580 "pgc.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 592 "pgc.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(state_before_str_stop);
				}
	YY_BREAK
case 19:
/* rule 19 can match eol */
#line 601 "pgc.l"
case 20:
/* rule 20 can match eol */
#line 602 "pgc.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 602 "pgc.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(state_before_str_start);

					switch (state_before_str_stop)
					{
						case xb:
							if (literalbuf[strspn(literalbuf, "01")] != '\0')
								mmerror(PARSE_ERROR, ET_ERROR, "invalid bit string literal");
							base_yylval.str = psprintf("b'%s'", literalbuf);
							return BCONST;
						case xh:
							if (literalbuf[strspn(literalbuf, "0123456789abcdefABCDEF")] != '\0')
								mmerror(PARSE_ERROR, ET_ERROR, "invalid hexadecimal string literal");
							base_yylval.str = psprintf("x'%s'", literalbuf);
							return XCONST;
						case xq:
							/* fallthrough */
						case xqc:
							base_yylval.str = psprintf("'%s'", literalbuf);
							return SCONST;
						case xe:
							base_yylval.str = psprintf("E'%s'", literalbuf);
							return SCONST;
						case xn:
							base_yylval.str = psprintf("N'%s'", literalbuf);
							return SCONST;
						case xus:
							base_yylval.str = psprintf("U&'%s'", literalbuf);
							return USCONST;
						default:
							mmfatal(PARSE_ERROR, "unhandled previous state in xqs\n");
					}
				}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 642 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 643 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 644 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 645 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 648 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 651 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 654 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 657 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 660 "pgc.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0]);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xqc):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xn):
case YY_STATE_EOF(xus):
#line 664 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK

case 30:
YY_RULE_SETUP
#line 667 "pgc.l"
{
					token_start = yytext;
					if (dolqstart)
						free(dolqstart);
					dolqstart = mm_strdup(yytext);
					BEGIN(xdolq);
					startlit();
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 676 "pgc.l"
{
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
/* <SQL> */
case 32:
YY_RULE_SETUP
#line 684 "pgc.l"
{
					if (strcmp(yytext, dolqstart) == 0)
					{
						addlit(yytext, yyleng);
						free(dolqstart);
						dolqstart = NULL;
						BEGIN(SQL);
						base_yylval.str = mm_strdup(literalbuf);
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 33:
/* rule 33 can match eol */
YY_RULE_SETUP
#line 705 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 708 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 711 "pgc.l"
{
					/* single quote or dollar sign */
					addlitchar(yytext[0]);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 715 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated dollar-quoted string"); }
	YY_BREAK

case 36:
YY_RULE_SETUP
#line 718 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 723 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 38:
YY_RULE_SETUP
#line 730 "pgc.l"
{
					BEGIN(state_before_str_start);
					if (literallen == 0)
						mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
					/*
					 * The server will truncate the identifier here.  We do
					 * not, as (1) it does not change the result; (2) we don't
					 * know what NAMEDATALEN the server might use; (3) this
					 * code path is also taken for literal query strings in
					 * PREPARE and EXECUTE IMMEDIATE, which can certainly be
					 * longer than NAMEDATALEN.
					 */
					base_yylval.str = mm_strdup(literalbuf);
					return CSTRING;
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 745 "pgc.l"
{
					BEGIN(state_before_str_start);
					base_yylval.str = mm_strdup(literalbuf);
					return CSTRING;
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 750 "pgc.l"
{
					BEGIN(state_before_str_start);
					if (literallen == 0)
						mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
					/* The backend will truncate the identifier here. We do not as it does not change the result. */
					base_yylval.str = psprintf("U&\"%s\"", literalbuf);
					return UIDENT;
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 758 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 761 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 764 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted identifier"); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 765 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xdc);
					startlit();
				}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 770 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xdc):
#line 773 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK

case 45:
YY_RULE_SETUP
#line 776 "pgc.l"
{
					return TYPECAST;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 780 "pgc.l"
{
					return DOT_DOT;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 784 "pgc.l"
{
					return COLON_EQUALS;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 788 "pgc.l"
{
					return EQUALS_GREATER;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 792 "pgc.l"
{
					return LESS_EQUALS;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 796 "pgc.l"
{
					return GREATER_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 800 "pgc.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					return NOT_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 805 "pgc.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 810 "pgc.l"
{
			  /* are we simulating Informix? */
				if (INFORMIX_MODE)
				{
					unput(':');
				}
				else
					return yytext[0];
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 820 "pgc.l"
{
					/*
					 * We may find a ';' inside a structure
					 * definition in a TYPE or VAR statement.
					 * This is not an EOL marker.
					 */
					if (yytext[0] == ';' && struct_level == 0)
						BEGIN(C);
					return yytext[0];
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 831 "pgc.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					base_yylval.str = mm_strdup(yytext);
					return Op;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 928 "pgc.l"
{
					base_yylval.ival = atol(yytext+1);
					return PARAM;
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 932 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after parameter");
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 936 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return IP;
				}
	YY_BREAK
/* <SQL> */

case 59:
YY_RULE_SETUP
#line 943 "pgc.l"
{
					return process_integer_literal(yytext, &base_yylval);
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 946 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 950 "pgc.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					return process_integer_literal(yytext, &base_yylval);
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 955 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 959 "pgc.l"
{
					/*
					 * throw back the [Ee][+-], and figure out whether what
					 * remains is an {integer} or {decimal}.
					 */
					yyless(yyleng - 2);
					return process_integer_literal(yytext, &base_yylval);
				}
	YY_BREAK
/* <C,SQL> */

/*
	 * Note that some trailing junk is valid in C (such as 100LL), so we
	 * contain this to SQL mode.
	 */
case 64:
YY_RULE_SETUP
#line 974 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 977 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 980 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 67:
/* rule 67 can match eol */
YY_RULE_SETUP
#line 984 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext+1);
					return CVARIABLE;
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 989 "pgc.l"
{
					/* First check to see if it's a define symbol to expand */
					if (!isdefine())
					{
						int		kwvalue;

						/* Is it an SQL/ECPG keyword? */
						kwvalue = ScanECPGKeywordLookup(yytext);
						if (kwvalue >= 0)
							return kwvalue;

						/* Is it a C keyword? */
						kwvalue = ScanCKeywordLookup(yytext);
						if (kwvalue >= 0)
							return kwvalue;

						/*
						 * None of the above.  Return it as an identifier.
						 *
						 * The backend will attempt to truncate and case-fold
						 * the identifier, but I see no good reason for ecpg
						 * to do so; that's just another way that ecpg could get
						 * out of step with the backend.
						 */
						base_yylval.str = mm_strdup(yytext);
						return IDENT;
					}
				}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 1018 "pgc.l"
{
					return yytext[0];
				}
	YY_BREAK
/* <SQL> */
/*
	 * Begin ECPG-specific rules
	 */
case 70:
/* rule 70 can match eol */
YY_RULE_SETUP
#line 1027 "pgc.l"
{ BEGIN(SQL); return SQL_START; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1028 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(SQL);
							return SQL_START;
						}
						else
							return S_ANYTHING;
					 }
	YY_BREAK
case 72:
/* rule 72 can match eol */
YY_RULE_SETUP
#line 1038 "pgc.l"
{ ECHO; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 1039 "pgc.l"
{
						char* endptr;

						errno = 0;
						base_yylval.ival = strtoul((char *) yytext, &endptr, 16);
						if (*endptr != '\0' || errno == ERANGE)
						{
							errno = 0;
							base_yylval.str = mm_strdup(yytext);
							return SCONST;
						}
						return ICONST;
					}
	YY_BREAK
case 74:
/* rule 74 can match eol */
YY_RULE_SETUP
#line 1052 "pgc.l"
{
						if (system_includes)
						{
							include_next = false;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(yytext);
							return CPP_LINE;
						}
					}
	YY_BREAK
case 75:
/* rule 75 can match eol */
YY_RULE_SETUP
#line 1064 "pgc.l"
{
						if (system_includes)
						{
							include_next = true;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(yytext);
							return CPP_LINE;
						}
					}
	YY_BREAK
case 76:
/* rule 76 can match eol */
YY_RULE_SETUP
#line 1076 "pgc.l"
{
						base_yylval.str = mm_strdup(yytext);
						return CPP_LINE;
					}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 1080 "pgc.l"
{
						/*
						 * Try to detect a function name:
						 * look for identifiers at the global scope
						 * keep the last identifier before the first '(' and '{'
						 */
						if (braces_open == 0 && parenths_open == 0)
						{
							if (current_function)
								free(current_function);
							current_function = mm_strdup(yytext);
						}
						/* Informix uses SQL defines only in SQL space */
						/* however, some defines have to be taken care of for compatibility */
						if ((!INFORMIX_MODE || !isinformixdefine()) && !isdefine())
						{
							int		kwvalue;

							kwvalue = ScanCKeywordLookup(yytext);
							if (kwvalue >= 0)
								return kwvalue;
							else
							{
								base_yylval.str = mm_strdup(yytext);
								return IDENT;
							}
						}
					}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 1108 "pgc.l"
{ mmerror(PARSE_ERROR, ET_ERROR, "nested /* ... */ comments"); }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 1109 "pgc.l"
{ return ':'; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 1110 "pgc.l"
{ return ';'; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 1111 "pgc.l"
{ return ','; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 1112 "pgc.l"
{ return '*'; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 1113 "pgc.l"
{ return '%'; }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 1114 "pgc.l"
{ return '/'; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 1115 "pgc.l"
{ return '+'; }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 1116 "pgc.l"
{ return '-'; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 1117 "pgc.l"
{ parenths_open++; return '('; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 1118 "pgc.l"
{ parenths_open--; return ')'; }
	YY_BREAK
case 89:
/* rule 89 can match eol */
YY_RULE_SETUP
#line 1119 "pgc.l"
{ ECHO; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 1120 "pgc.l"
{ return '{'; }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 1121 "pgc.l"
{ return '}'; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 1122 "pgc.l"
{ return '['; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 1123 "pgc.l"
{ return ']'; }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 1124 "pgc.l"
{ return '='; }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 1125 "pgc.l"
{ return S_MEMBER; }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 1126 "pgc.l"
{ return S_RSHIFT; }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 1127 "pgc.l"
{ return S_LSHIFT; }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 1128 "pgc.l"
{ return S_OR; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 1129 "pgc.l"
{ return S_AND; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 1130 "pgc.l"
{ return S_INC; }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 1131 "pgc.l"
{ return S_DEC; }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 1132 "pgc.l"
{ return S_EQUAL; }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 1133 "pgc.l"
{ return S_NEQUAL; }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 1134 "pgc.l"
{ return S_ADD; }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 1135 "pgc.l"
{ return S_SUB; }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 1136 "pgc.l"
{ return S_MUL; }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 1137 "pgc.l"
{ return S_DIV; }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 1138 "pgc.l"
{ return S_MOD; }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 1139 "pgc.l"
{ return S_MEMPOINT; }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 1140 "pgc.l"
{ return S_DOTPOINT; }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 1141 "pgc.l"
{ return S_ANYTHING; }
	YY_BREAK
case 112:
/* rule 112 can match eol */
YY_RULE_SETUP
#line 1142 "pgc.l"
{ BEGIN(def_ident); }
	YY_BREAK
case 113:
/* rule 113 can match eol */
YY_RULE_SETUP
#line 1143 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(def_ident);
						}
						else
						{
							yyless(1);
							return S_ANYTHING;
						}
					}
	YY_BREAK
case 114:
/* rule 114 can match eol */
YY_RULE_SETUP
#line 1155 "pgc.l"
{ BEGIN(undef); }
	YY_BREAK
case 115:
/* rule 115 can match eol */
YY_RULE_SETUP
#line 1156 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(undef);
						}
						else
						{
							yyless(1);
							return S_ANYTHING;
						}
					}
	YY_BREAK
case 116:
/* rule 116 can match eol */
YY_RULE_SETUP
#line 1168 "pgc.l"
{
					struct _defines *ptr, *ptr2 = NULL;
					int i;

					/*
					 *	Skip the ";" and trailing whitespace. Note that yytext
					 *	contains at least one non-space character plus the ";"
					 */
					for (i = strlen(yytext)-2;
						 i > 0 && ecpg_isspace(yytext[i]);
						 i--)
						;
					yytext[i+1] = '\0';


					/* Find and unset any matching define; should be only 1 */
					for (ptr = defines; ptr; ptr2 = ptr, ptr = ptr->next)
					{
						if (strcmp(yytext, ptr->name) == 0)
						{
							free(ptr->value);
							ptr->value = NULL;
							/* We cannot forget it if there's a cmdvalue */
							if (ptr->cmdvalue == NULL)
							{
								if (ptr2 == NULL)
									defines = ptr->next;
								else
									ptr2->next = ptr->next;
								free(ptr->name);
								free(ptr);
							}
							break;
						}
					}

					BEGIN(C);
				}
	YY_BREAK
case 117:
/* rule 117 can match eol */
YY_RULE_SETUP
#line 1206 "pgc.l"
{
						mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL UNDEF command");
						yyterminate();
				}
	YY_BREAK
case 118:
/* rule 118 can match eol */
YY_RULE_SETUP
#line 1210 "pgc.l"
{ BEGIN(incl); }
	YY_BREAK
case 119:
/* rule 119 can match eol */
YY_RULE_SETUP
#line 1211 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  BEGIN(incl);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 120:
/* rule 120 can match eol */
YY_RULE_SETUP
#line 1223 "pgc.l"
{
					  if (preproc_tos >= MAX_NESTED_IF-1)
						  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					  preproc_tos++;
					  stacked_if_value[preproc_tos].active = false;
					  stacked_if_value[preproc_tos].saw_active = false;
					  stacked_if_value[preproc_tos].else_branch = false;
					  ifcond = true;
					  BEGIN(xcond);
					}
	YY_BREAK
case 121:
/* rule 121 can match eol */
YY_RULE_SETUP
#line 1233 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  if (preproc_tos >= MAX_NESTED_IF-1)
							  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
						  preproc_tos++;
						  stacked_if_value[preproc_tos].active = false;
						  stacked_if_value[preproc_tos].saw_active = false;
						  stacked_if_value[preproc_tos].else_branch = false;
						  ifcond = true;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 122:
/* rule 122 can match eol */
YY_RULE_SETUP
#line 1252 "pgc.l"
{
					  if (preproc_tos >= MAX_NESTED_IF-1)
						  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					  preproc_tos++;
					  stacked_if_value[preproc_tos].active = false;
					  stacked_if_value[preproc_tos].saw_active = false;
					  stacked_if_value[preproc_tos].else_branch = false;
					  ifcond = false;
					  BEGIN(xcond);
					}
	YY_BREAK
case 123:
/* rule 123 can match eol */
YY_RULE_SETUP
#line 1262 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  if (preproc_tos >= MAX_NESTED_IF-1)
							  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
						  preproc_tos++;
						  stacked_if_value[preproc_tos].active = false;
						  stacked_if_value[preproc_tos].saw_active = false;
						  stacked_if_value[preproc_tos].else_branch = false;
						  ifcond = false;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 124:
/* rule 124 can match eol */
YY_RULE_SETUP
#line 1281 "pgc.l"
{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						ifcond = true;
						BEGIN(xcond);
					}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 1289 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						ifcond = true;
						BEGIN(xcond);
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 126:
/* rule 126 can match eol */
YY_RULE_SETUP
#line 1307 "pgc.l"
{	/* only exec sql endif pops the stack, so take care of duplicated 'else' */
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
					else if (stacked_if_value[preproc_tos].else_branch)
						mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
					else
					{
						stacked_if_value[preproc_tos].else_branch = true;
						stacked_if_value[preproc_tos].active =
							(stacked_if_value[preproc_tos-1].active &&
							 !stacked_if_value[preproc_tos].saw_active);
						stacked_if_value[preproc_tos].saw_active = true;

						if (stacked_if_value[preproc_tos].active)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
				}
	YY_BREAK
case 127:
/* rule 127 can match eol */
YY_RULE_SETUP
#line 1326 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						else if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
						else
						{
							stacked_if_value[preproc_tos].else_branch = true;
							stacked_if_value[preproc_tos].active =
								(stacked_if_value[preproc_tos-1].active &&
								 !stacked_if_value[preproc_tos].saw_active);
							stacked_if_value[preproc_tos].saw_active = true;

							if (stacked_if_value[preproc_tos].active)
								BEGIN(C);
							else
								BEGIN(xskip);
						}
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 128:
/* rule 128 can match eol */
YY_RULE_SETUP
#line 1354 "pgc.l"
{
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
					else
						preproc_tos--;

					if (stacked_if_value[preproc_tos].active)
					   BEGIN(C);
					else
					   BEGIN(xskip);
				}
	YY_BREAK
case 129:
/* rule 129 can match eol */
YY_RULE_SETUP
#line 1365 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
						else
							preproc_tos--;

						if (stacked_if_value[preproc_tos].active)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 1386 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case 131:
/* rule 131 can match eol */
YY_RULE_SETUP
#line 1388 "pgc.l"
{
					{
						struct _defines *defptr;
						unsigned int i;
						bool this_active;

						/*
						 *	Skip the ";" and trailing whitespace. Note that yytext
						 *	contains at least one non-space character plus the ";"
						 */
						for (i = strlen(yytext)-2;
							 i > 0 && ecpg_isspace(yytext[i]);
							 i--)
							;
						yytext[i+1] = '\0';

						/* Does a definition exist? */
						for (defptr = defines; defptr; defptr = defptr->next)
						{
							if (strcmp(yytext, defptr->name) == 0)
							{
								/* Found it, but is it currently undefined? */
								if (defptr->value == NULL)
									defptr = NULL; /* pretend it's not found */
								break;
							}
						}

						this_active = (defptr ? ifcond : !ifcond);
						stacked_if_value[preproc_tos].active =
							(stacked_if_value[preproc_tos-1].active &&
							 !stacked_if_value[preproc_tos].saw_active &&
							 this_active);
						stacked_if_value[preproc_tos].saw_active |= this_active;
					}

					if (stacked_if_value[preproc_tos].active)
						BEGIN(C);
					else
						BEGIN(xskip);
				}
	YY_BREAK
case 132:
/* rule 132 can match eol */
YY_RULE_SETUP
#line 1430 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL IFDEF command");
				yyterminate();
			}
	YY_BREAK
case 133:
YY_RULE_SETUP
#line 1434 "pgc.l"
{
				newdefsymbol = mm_strdup(yytext);
				BEGIN(def);
				startlit();
			}
	YY_BREAK
case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 1439 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL DEFINE command");
				yyterminate();
			}
	YY_BREAK
case 135:
/* rule 135 can match eol */
YY_RULE_SETUP
#line 1443 "pgc.l"
{
						struct _defines *ptr;

						/* Does it already exist? */
						for (ptr = defines; ptr != NULL; ptr = ptr->next)
						{
							if (strcmp(newdefsymbol, ptr->name) == 0)
							{
								free(ptr->value);
								ptr->value = mm_strdup(literalbuf);
								/* Don't leak newdefsymbol */
								free(newdefsymbol);
								break;
							}
						}
						if (ptr == NULL)
						{
							/* Not present, make a new entry */
							ptr = (struct _defines *) mm_alloc(sizeof(struct _defines));

							ptr->name = newdefsymbol;
							ptr->value = mm_strdup(literalbuf);
							ptr->cmdvalue = NULL;
							ptr->used = NULL;
							ptr->next = defines;
							defines = ptr;
						}

						BEGIN(C);
					}
	YY_BREAK
case 136:
/* rule 136 can match eol */
YY_RULE_SETUP
#line 1473 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 137:
/* rule 137 can match eol */
YY_RULE_SETUP
#line 1474 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 138:
/* rule 138 can match eol */
YY_RULE_SETUP
#line 1475 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 139:
/* rule 139 can match eol */
YY_RULE_SETUP
#line 1476 "pgc.l"
{ parse_include(); }
	YY_BREAK
case 140:
/* rule 140 can match eol */
YY_RULE_SETUP
#line 1477 "pgc.l"
{
					mmfatal(PARSE_ERROR, "syntax error in EXEC SQL INCLUDE command");
					yyterminate();
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(xcond):
case YY_STATE_EOF(xskip):
case YY_STATE_EOF(C):
case YY_STATE_EOF(SQL):
case YY_STATE_EOF(incl):
case YY_STATE_EOF(def):
case YY_STATE_EOF(def_ident):
case YY_STATE_EOF(undef):
#line 1482 "pgc.l"
{
					if (yy_buffer == NULL)
					{
						/* No more input */
						if (preproc_tos > 0)
						{
							preproc_tos = 0;
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						}
						yyterminate();
					}
					else
					{
						/* Revert to previous input source */
						struct _yy_buffer *yb = yy_buffer;
						int i;
						struct _defines *ptr;

						/* Check to see if we are exiting a macro value */
						for (ptr = defines; ptr; ptr = ptr->next)
						{
							if (ptr->used == yy_buffer)
							{
								ptr->used = NULL;
								break; /* there can't be multiple matches */
							}
						}

						if (yyin != NULL)
							fclose(yyin);

						yy_delete_buffer(YY_CURRENT_BUFFER);
						yy_switch_to_buffer(yy_buffer->buffer);

						yylineno = yy_buffer->lineno;

						/* We have to output the filename only if we change files here */
						i = strcmp(input_filename, yy_buffer->filename);

						free(input_filename);
						input_filename = yy_buffer->filename;

						yy_buffer = yy_buffer->next;
						free(yb);

						if (i != 0)
							output_line_number();

					}
				}
	YY_BREAK
case 141:
/* rule 141 can match eol */
YY_RULE_SETUP
#line 1533 "pgc.l"
{ mmfatal(PARSE_ERROR, "internal error: unreachable state; please report this to <%s>", PACKAGE_BUGREPORT); }
	YY_BREAK
case 142:
YY_RULE_SETUP
#line 1535 "pgc.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 3881 "pgc.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 588 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 588 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 587);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 1535 "pgc.l"


/* LCOV_EXCL_STOP */

void
lex_init(void)
{
	braces_open = 0;
	parenths_open = 0;
	current_function = NULL;

	yylineno = 1;

	/* initialize state for if/else/endif */
	preproc_tos = 0;
	stacked_if_value[preproc_tos].active = true;
	stacked_if_value[preproc_tos].saw_active = true;
	stacked_if_value[preproc_tos].else_branch = false;

	/* initialize literal buffer to a reasonable but expansible size */
	if (literalbuf == NULL)
	{
		literalalloc = 1024;
		literalbuf = (char *) mm_alloc(literalalloc);
	}
	startlit();

	BEGIN(C);
}

static void
addlit(char *ytext, int yleng)
{
	/* enlarge buffer if needed */
	if ((literallen+yleng) >= literalalloc)
	{
		do
			literalalloc *= 2;
		while ((literallen+yleng) >= literalalloc);
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	memcpy(literalbuf+literallen, ytext, yleng);
	literallen += yleng;
	literalbuf[literallen] = '\0';
}

static void
addlitchar(unsigned char ychar)
{
	/* enlarge buffer if needed */
	if ((literallen+1) >= literalalloc)
	{
		literalalloc *= 2;
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	literalbuf[literallen] = ychar;
	literallen += 1;
	literalbuf[literallen] = '\0';
}

/*
 * Process {integer}.  Note this will also do the right thing with {decimal},
 * ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval)
{
	int			val;
	char	   *endptr;

	errno = 0;
	val = strtoint(token, &endptr, 10);
	if (*endptr != '\0' || errno == ERANGE)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = mm_strdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
parse_include(void)
{
	/* got the include file name */
	struct _yy_buffer *yb;
	struct _include_path *ip;
	char inc_file[MAXPGPATH];
	unsigned int i;

	yb = mm_alloc(sizeof(struct _yy_buffer));

	yb->buffer =	YY_CURRENT_BUFFER;
	yb->lineno = yylineno;
	yb->filename = input_filename;
	yb->next = yy_buffer;

	yy_buffer = yb;

	/*
	 * skip the ";" if there is one and trailing whitespace. Note that
	 * yytext contains at least one non-space character plus the ";"
	 */
	for (i = strlen(yytext)-2;
		 i > 0 && ecpg_isspace(yytext[i]);
		 i--)
		;

	if (yytext[i] == ';')
		i--;

	yytext[i+1] = '\0';

	yyin = NULL;

	/* If file name is enclosed in '"' remove these and look only in '.' */
	/* Informix does look into all include paths though, except filename starts with '/' */
	if (yytext[0] == '"' && yytext[i] == '"' &&
		((compat != ECPG_COMPAT_INFORMIX && compat != ECPG_COMPAT_INFORMIX_SE) || yytext[1] == '/'))
	{
		yytext[i] = '\0';
		memmove(yytext, yytext+1, strlen(yytext));

		strlcpy(inc_file, yytext, sizeof(inc_file));
		yyin = fopen(inc_file, "r");
		if (!yyin)
		{
			if (strlen(inc_file) <= 2 || strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
			{
				strcat(inc_file, ".h");
				yyin = fopen(inc_file, "r");
			}
		}

	}
	else
	{
		if ((yytext[0] == '"' && yytext[i] == '"') || (yytext[0] == '<' && yytext[i] == '>'))
		{
			yytext[i] = '\0';
			memmove(yytext, yytext+1, strlen(yytext));
		}

		for (ip = include_paths; yyin == NULL && ip != NULL; ip = ip->next)
		{
			if (strlen(ip->path) + strlen(yytext) + 4 > MAXPGPATH)
			{
				fprintf(stderr, _("Error: include path \"%s/%s\" is too long on line %d, skipping\n"), ip->path, yytext, yylineno);
				continue;
			}
			snprintf (inc_file, sizeof(inc_file), "%s/%s", ip->path, yytext);
			yyin = fopen(inc_file, "r");
			if (!yyin)
			{
				if (strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
				{
					strcat(inc_file, ".h");
					yyin = fopen(inc_file, "r");
				}
			}
			/* if the command was "include_next" we have to disregard the first hit */
			if (yyin && include_next)
			{
				fclose (yyin);
				yyin = NULL;
				include_next = false;
			}
		}
	}
	if (!yyin)
		mmfatal(NO_INCLUDE_FILE, "could not open include file \"%s\" on line %d", yytext, yylineno);

	input_filename = mm_strdup(inc_file);
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE));
	yylineno = 1;
	output_line_number();

	BEGIN(C);
}

/*
 * ecpg_isspace() --- return true if flex scanner considers char whitespace
 */
static bool
ecpg_isspace(char ch)
{
	if (ch == ' ' ||
		ch == '\t' ||
		ch == '\n' ||
		ch == '\r' ||
		ch == '\f')
		return true;
	return false;
}

/*
 * If yytext matches a define symbol, begin scanning the symbol's value
 * and return true
 */
static bool
isdefine(void)
{
	struct _defines *ptr;

	/* is it a define? */
	for (ptr = defines; ptr; ptr = ptr->next)
	{
		/* notice we do not match anything being actively expanded */
		if (strcmp(yytext, ptr->name) == 0 &&
			ptr->value != NULL &&
			ptr->used == NULL)
		{
			/* Save state associated with the current buffer */
			struct _yy_buffer *yb;

			yb = mm_alloc(sizeof(struct _yy_buffer));

			yb->buffer =  YY_CURRENT_BUFFER;
			yb->lineno = yylineno;
			yb->filename = mm_strdup(input_filename);
			yb->next = yy_buffer;
			yy_buffer = yb;

			/* Mark symbol as being actively expanded */
			ptr->used = yb;

			/*
			 * We use yy_scan_string which will copy the value, so there's
			 * no need to worry about a possible undef happening while we
			 * are still scanning it.
			 */
			yy_scan_string(ptr->value);
			return true;
		}
	}

	return false;
}

/*
 * Handle replacement of INFORMIX built-in defines.  This works just
 * like isdefine() except for the source of the string to scan.
 */
static bool
isinformixdefine(void)
{
	const char *new = NULL;

	if (strcmp(yytext, "dec_t") == 0)
		new = "decimal";
	else if (strcmp(yytext, "intrvl_t") == 0)
		new = "interval";
	else if (strcmp(yytext, "dtime_t") == 0)
		new = "timestamp";

	if (new)
	{
		struct _yy_buffer *yb;

		yb = mm_alloc(sizeof(struct _yy_buffer));

		yb->buffer =  YY_CURRENT_BUFFER;
		yb->lineno = yylineno;
		yb->filename = mm_strdup(input_filename);
		yb->next = yy_buffer;
		yy_buffer = yb;

		yy_scan_string(new);
		return true;
	}

	return false;
}

