/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.proguard.patterns;

import com.android.tools.build.jetifier.processor.transform.proguard.patterns.GroupsReplacer;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/proguard/patterns/ReplacersRunner;", "", "replacers", "", "Lcom/android/tools/build/jetifier/processor/transform/proguard/patterns/GroupsReplacer;", "(Ljava/util/List;)V", "getReplacers", "()Ljava/util/List;", "applyReplacers", "", "input", "jetifier-processor"})
public final class ReplacersRunner {
    @NotNull
    private final List<GroupsReplacer> replacers;

    @NotNull
    public final String applyReplacers(@NotNull String input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        StringBuilder sb = new StringBuilder();
        int lastSeenChar = 0;
        String processedInput = input;
        for (GroupsReplacer replacer2 : this.replacers) {
            Matcher matcher = replacer2.getPattern().matcher(processedInput);
            while (matcher.find()) {
                if (lastSeenChar < matcher.start()) {
                    sb.append(processedInput, lastSeenChar, matcher.start());
                }
                Matcher matcher2 = matcher;
                Intrinsics.checkExpressionValueIsNotNull((Object)matcher2, (String)"matcher");
                List<String> result = replacer2.runReplacements(matcher2);
                Iterable iterable = result;
                String string = System.lineSeparator();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.lineSeparator()");
                sb.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null));
                lastSeenChar = matcher.end();
            }
            if (lastSeenChar == 0) continue;
            if (lastSeenChar <= processedInput.length() - 1) {
                sb.append(processedInput, lastSeenChar, processedInput.length());
            }
            lastSeenChar = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)sb.toString(), (String)"sb.toString()");
            sb.setLength(0);
        }
        return processedInput;
    }

    @NotNull
    public final List<GroupsReplacer> getReplacers() {
        return this.replacers;
    }

    public ReplacersRunner(@NotNull List<GroupsReplacer> replacers) {
        Intrinsics.checkParameterIsNotNull(replacers, (String)"replacers");
        this.replacers = replacers;
    }
}

