/* SPDX-License-Identifier: GPL-2.0 */


#ifndef INSPUR_DRM_HW_H
#define INSPUR_DRM_HW_H

/* register definition */
#define INSPUR_MISC_CTRL				0x4

#define INSPUR_MSCCTL_LOCALMEM_RESET(x)		((x) << 6)
#define INSPUR_MSCCTL_LOCALMEM_RESET_MASK	0x40

#define INSPUR_CURRENT_GATE			0x000040
#define INSPUR_CURR_GATE_DISPLAY(x)		((x) << 2)
#define INSPUR_CURR_GATE_DISPLAY_MASK		0x4

#define INSPUR_CURR_GATE_LOCALMEM(x)		((x) << 1)
#define INSPUR_CURR_GATE_LOCALMEM_MASK		0x2

#define INSPUR_MODE0_GATE			0x000044
#define INSPUR_MODE1_GATE			0x000048
#define INSPUR_POWER_MODE_CTRL			0x00004C

#define INSPUR_PW_MODE_CTL_OSC_INPUT(x)		((x) << 3)
#define INSPUR_PW_MODE_CTL_OSC_INPUT_MASK	0x8

#define INSPUR_PW_MODE_CTL_MODE(x)		((x) << 0)
#define INSPUR_PW_MODE_CTL_MODE_MASK		0x03
#define INSPUR_PW_MODE_CTL_MODE_SHIFT		0

#define INSPUR_PW_MODE_CTL_MODE_MODE0		0
#define INSPUR_PW_MODE_CTL_MODE_MODE1		1
#define INSPUR_PW_MODE_CTL_MODE_SLEEP		2

//#define INSPUR_CRT_PLL_CTRL                   0x000060

#define INSPUR_PLL_CTRL_BYPASS(x)		((x) << 18)
#define INSPUR_PLL_CTRL_BYPASS_MASK		0x40000

#define INSPUR_PLL_CTRL_POWER(x)			((x) << 17)
#define INSPUR_PLL_CTRL_POWER_MASK		0x20000

#define INSPUR_PLL_CTRL_INPUT(x)			((x) << 16)
#define INSPUR_PLL_CTRL_INPUT_MASK		0x10000

#define INSPUR_PLL_CTRL_POD(x)			((x) << 14)
#define INSPUR_PLL_CTRL_POD_MASK			0xC000

#define INSPUR_PLL_CTRL_OD(x)			((x) << 12)
#define INSPUR_PLL_CTRL_OD_MASK			0x3000

#define INSPUR_PLL_CTRL_N(x)			((x) << 8)
#define INSPUR_PLL_CTRL_N_MASK			0xF00

#define INSPUR_PLL_CTRL_M(x)			((x) << 0)
#define INSPUR_PLL_CTRL_M_MASK			0xFF

#define INSPUR_CRT_DISP_CTL			0x80200

#define INSPUR_CRT_DISP_CTL_DPMS(x)		((x) << 30)
#define INSPUR_CRT_DISP_CTL_DPMS_MASK		0xc0000000

#define INSPUR_CRT_DPMS_ON			0
#define INSPUR_CRT_DPMS_OFF			3

#define INSPUR_CRT_DISP_CTL_CRTSELECT(x)		((x) << 25)
#define INSPUR_CRT_DISP_CTL_CRTSELECT_MASK	0x2000000

#define INSPUR_CRTSELECT_CRT			1

#define INSPUR_CRT_DISP_CTL_CLOCK_PHASE(x)	((x) << 14)
#define INSPUR_CRT_DISP_CTL_CLOCK_PHASE_MASK	0x4000

#define INSPUR_CRT_DISP_CTL_VSYNC_PHASE(x)	((x) << 13)
#define INSPUR_CRT_DISP_CTL_VSYNC_PHASE_MASK	0x2000

#define INSPUR_CRT_DISP_CTL_HSYNC_PHASE(x)	((x) << 12)
#define INSPUR_CRT_DISP_CTL_HSYNC_PHASE_MASK	0x1000

#define INSPUR_CRT_DISP_CTL_TIMING(x)		((x) << 8)
#define INSPUR_CRT_DISP_CTL_TIMING_MASK		0x100

#define INSPUR_CRT_DISP_CTL_PLANE(x)		((x) << 2)
#define INSPUR_CRT_DISP_CTL_PLANE_MASK		4

#define INSPUR_CRT_DISP_CTL_FORMAT(x)		((x) << 0)
#define INSPUR_CRT_DISP_CTL_FORMAT_MASK		0x03

#define INSPUR_CRT_FB_ADDRESS			0x080204

#define INSPUR_CRT_FB_WIDTH			0x080208
#define INSPUR_CRT_FB_WIDTH_WIDTH(x)		((x) << 16)
#define INSPUR_CRT_FB_WIDTH_WIDTH_MASK		0x3FFF0000
#define INSPUR_CRT_FB_WIDTH_OFFS(x)		((x) << 0)
#define INSPUR_CRT_FB_WIDTH_OFFS_MASK		0x3FFF

#define INSPUR_CRT_HORZ_TOTAL			0x08020C
#define INSPUR_CRT_HORZ_TOTAL_TOTAL(x)		((x) << 16)
#define INSPUR_CRT_HORZ_TOTAL_TOTAL_MASK		0xFFF0000

#define INSPUR_CRT_HORZ_TOTAL_DISP_END(x)	((x) << 0)
#define INSPUR_CRT_HORZ_TOTAL_DISP_END_MASK	0xFFF

#define INSPUR_CRT_HORZ_SYNC			0x080210
#define INSPUR_CRT_HORZ_SYNC_WIDTH(x)		((x) << 16)
#define INSPUR_CRT_HORZ_SYNC_WIDTH_MASK		0xFF0000

#define INSPUR_CRT_HORZ_SYNC_START(x)		((x) << 0)
#define INSPUR_CRT_HORZ_SYNC_START_MASK		0xFFF

#define INSPUR_CRT_VERT_TOTAL			0x080214
#define INSPUR_CRT_VERT_TOTAL_TOTAL(x)		((x) << 16)
#define INSPUR_CRT_VERT_TOTAL_TOTAL_MASK		0x7FFF0000

#define INSPUR_CRT_VERT_TOTAL_DISP_END(x)	((x) << 0)
#define INSPUR_CRT_VERT_TOTAL_DISP_END_MASK	0x7FF

#define INSPUR_CRT_VERT_SYNC			0x080218
#define INSPUR_CRT_VERT_SYNC_HEIGHT(x)		((x) << 16)
#define INSPUR_CRT_VERT_SYNC_HEIGHT_MASK		0x3F0000

#define INSPUR_CRT_VERT_SYNC_START(x)		((x) << 0)
#define INSPUR_CRT_VERT_SYNC_START_MASK		0x7FF

/* Hardware Cursor */
#define INSPUR_HWC_ADDRESS                   0x080230
#define INSPUR_HWC_ADDRESS_ENABLE(x)         ((x) << 31)
#define INSPUR_HWC_ADDRESS_ENABLE_MASK       0x80000000
#define INSPUR_HWC_ADDRESS_ADDRESS(x)        ((x) << 0)
#define INSPUR_HWC_ADDRESS_ADDRESS_MASK      0xFFFFFFF

#define INSPUR_HWC_LOCATION                  0x080234
#define INSPUR_HWC_LOCATION_TOP(x)           ((x) << 27)
#define INSPUR_HWC_LOCATION_TOP_MASK         0x8000000
#define INSPUR_HWC_LOCATION_Y(x)             ((x) << 16)
#define INSPUR_HWC_LOCATION_Y_MASK           0x7FF0000
#define INSPUR_HWC_LOCATION_LEFT(x)          ((x) << 11)
#define INSPUR_HWC_LOCATION_LEFT_MASK        0x800
#define INSPUR_HWC_LOCATION_X(x)             ((x) << 0)
#define INSPUR_HWC_LOCATION_X_MASK           0x7FF

#define INSPUR_HWC_COLOR_12                  0x080238
#define INSPUR_HWC_COLOR_12_2_RGB(x)         ((x) << 16)
#define INSPUR_HWC_COLOR_12_2_RGB_MASK       0xFFFF0000
#define INSPUR_HWC_COLOR_12_1_RGB(x)         ((x) << 0)
#define INSPUR_HWC_COLOR_12_1_RGB_MASK       0xFFFF

#define INSPUR_HWC_COLOR_3                   0x08023C
#define INSPUR_HWC_COLOR_3_RGB(x)            ((x) << 0)
#define INSPUR_HWC_COLOR_3_RGB_MASK          0xFFFF

/* Auto Centering */
#define INSPUR_CRT_AUTO_CENTERING_TL		0x080280
#define INSPUR_CRT_AUTO_CENTERING_TL_TOP(x)	((x) << 16)
#define INSPUR_CRT_AUTO_CENTERING_TL_TOP_MASK	0x7FF0000

#define INSPUR_CRT_AUTO_CENTERING_TL_LEFT(x)	((x) << 0)
#define INSPUR_CRT_AUTO_CENTERING_TL_LEFT_MASK	0x7FF

#define INSPUR_CRT_AUTO_CENTERING_BR		0x080284
#define INSPUR_CRT_AUTO_CENTERING_BR_BOTTOM(x)	((x) << 16)
#define INSPUR_CRT_AUTO_CENTERING_BR_BOTTOM_MASK	0x7FF0000

#define INSPUR_CRT_AUTO_CENTERING_BR_RIGHT(x)	((x) << 0)
#define INSPUR_CRT_AUTO_CENTERING_BR_RIGHT_MASK	0x7FF

/* register to control panel output */
#define INSPUR_DISPLAY_CONTROL_HISILE		0x80288
#define INSPUR_DISPLAY_CONTROL_FPVDDEN(x)	((x) << 0)
#define INSPUR_DISPLAY_CONTROL_PANELDATE(x)	((x) << 1)
#define INSPUR_DISPLAY_CONTROL_FPEN(x)		((x) << 2)
#define INSPUR_DISPLAY_CONTROL_VBIASEN(x)	((x) << 3)

#define INSPUR_RAW_INTERRUPT			0x80290
#define INSPUR_RAW_INTERRUPT_VBLANK(x)		((x) << 2)
#define INSPUR_RAW_INTERRUPT_VBLANK_MASK		0x4

#define INSPUR_RAW_INTERRUPT_EN			0x80298
#define INSPUR_RAW_INTERRUPT_EN_VBLANK(x)	((x) << 2)
#define INSPUR_RAW_INTERRUPT_EN_VBLANK_MASK	0x4

/* register and values for PLL control */
#define CRT_PLL1_NS				0x802a8
#define CRT_PLL1_NS_OUTER_BYPASS(x)		((x) << 30)
#define CRT_PLL1_NS_INTER_BYPASS(x)		((x) << 29)
#define CRT_PLL1_NS_POWERON(x)			((x) << 24)

#define CRT_PLL1_NS_25MHZ			0x00006691	//640x480
#define CRT_PLL1_NS_40MHZ			0x00004580	//800x600
#define CRT_PLL1_NS_65MHZ			0x00002568	//1024x768
#define CRT_PLL1_NS_83MHZ			0x000027bb	//1280x800
#define CRT_PLL1_NS_106MHZ			0x000027ef	//1440x900
#define CRT_PLL1_NS_108MHZ			0x000027f2	//1280x1024
#define CRT_PLL1_NS_146MHZ			0x00001575	//1680x1050
#define CRT_PLL1_NS_148MHZ			0x0000145f	//1920x1080
#define CRT_PLL1_NS_193MHZ			0x000018f7	//1920x1200

#define CRT_PLL2_NS				0x802ac
#define CRT_PLL2_NS_25MHZ			0x0
#define CRT_PLL2_NS_40MHZ			0x0
#define CRT_PLL2_NS_65MHZ			0x0
#define CRT_PLL2_NS_83MHZ			0x0
#define CRT_PLL2_NS_106MHZ			0x0
#define CRT_PLL2_NS_108MHZ			0x0
#define CRT_PLL2_NS_146MHZ			0x0
#define CRT_PLL2_NS_148MHZ			0x0
#define CRT_PLL2_NS_193MHZ			0x0

#define INSPUR_FIELD(field, value) (field(value) & field##_MASK)
#endif
