; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=x86_64-- -expand-large-fp-convert < %s | FileCheck %s

define i129 @halftoui129(half %a) {
; CHECK-LABEL: @halftoui129(
; CHECK-NEXT:    [[TMP1:%.*]] = fptoui half [[A:%.*]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i129
; CHECK-NEXT:    ret i129 [[TMP2]]
;
  %conv = fptoui half %a to i129
  ret i129 %conv
}

define i129 @floattoui129(float %a) {
; CHECK-LABEL: @floattoui129(
; CHECK-NEXT:  fp-to-i-entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float [[A:%.*]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i129
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i32 [[TMP0]], -1
; CHECK-NEXT:    [[TMP3:%.*]] = select i1 [[TMP2]], i129 1, i129 -1
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i129 [[TMP1]], 23
; CHECK-NEXT:    [[TMP5:%.*]] = and i129 [[TMP4]], 255
; CHECK-NEXT:    [[TMP6:%.*]] = and i129 [[TMP1]], 8388607
; CHECK-NEXT:    [[TMP7:%.*]] = or i129 [[TMP6]], 8388608
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ult i129 [[TMP5]], 127
; CHECK-NEXT:    br i1 [[TMP8]], label [[FP_TO_I_CLEANUP:%.*]], label [[FP_TO_I_IF_END:%.*]]
; CHECK:       fp-to-i-if-end:
; CHECK-NEXT:    [[TMP9:%.*]] = add i129 [[TMP5]], -256
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ult i129 [[TMP9]], 4294967167
; CHECK-NEXT:    br i1 [[TMP10]], label [[FP_TO_I_IF_THEN5:%.*]], label [[FP_TO_I_IF_END9:%.*]]
; CHECK:       fp-to-i-if-then5:
; CHECK-NEXT:    [[TMP11:%.*]] = select i1 [[TMP2]], i129 340282366920938463463374607431768211455, i129 -340282366920938463463374607431768211456
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-if-end9:
; CHECK-NEXT:    [[TMP12:%.*]] = icmp ult i129 [[TMP5]], 150
; CHECK-NEXT:    br i1 [[TMP12]], label [[FP_TO_I_IF_THEN12:%.*]], label [[FP_TO_I_IF_ELSE:%.*]]
; CHECK:       fp-to-i-if-then12:
; CHECK-NEXT:    [[TMP13:%.*]] = sub i129 150, [[TMP5]]
; CHECK-NEXT:    [[TMP14:%.*]] = lshr i129 [[TMP7]], [[TMP13]]
; CHECK-NEXT:    [[TMP15:%.*]] = mul i129 [[TMP14]], [[TMP3]]
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-if-else:
; CHECK-NEXT:    [[TMP16:%.*]] = add i129 [[TMP5]], 4294967146
; CHECK-NEXT:    [[TMP17:%.*]] = shl i129 [[TMP7]], [[TMP16]]
; CHECK-NEXT:    [[TMP18:%.*]] = mul i129 [[TMP17]], [[TMP3]]
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-cleanup:
; CHECK-NEXT:    [[TMP19:%.*]] = phi i129 [ [[TMP11]], [[FP_TO_I_IF_THEN5]] ], [ [[TMP15]], [[FP_TO_I_IF_THEN12]] ], [ [[TMP18]], [[FP_TO_I_IF_ELSE]] ], [ 0, [[FP_TO_I_ENTRY:%.*]] ]
; CHECK-NEXT:    ret i129 [[TMP19]]
;
  %conv = fptoui float %a to i129
  ret i129 %conv
}

define i129 @doubletoui129(double %a) {
; CHECK-LABEL: @doubletoui129(
; CHECK-NEXT:  fp-to-i-entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast double [[A:%.*]] to i64
; CHECK-NEXT:    [[TMP1:%.*]] = zext i64 [[TMP0]] to i129
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i64 [[TMP0]], -1
; CHECK-NEXT:    [[TMP3:%.*]] = select i1 [[TMP2]], i129 1, i129 -1
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i129 [[TMP1]], 52
; CHECK-NEXT:    [[TMP5:%.*]] = and i129 [[TMP4]], 2047
; CHECK-NEXT:    [[TMP6:%.*]] = and i129 [[TMP1]], 4503599627370495
; CHECK-NEXT:    [[TMP7:%.*]] = or i129 [[TMP6]], 4503599627370496
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ult i129 [[TMP5]], 1023
; CHECK-NEXT:    br i1 [[TMP8]], label [[FP_TO_I_CLEANUP:%.*]], label [[FP_TO_I_IF_END:%.*]]
; CHECK:       fp-to-i-if-end:
; CHECK-NEXT:    [[TMP9:%.*]] = add i129 [[TMP5]], -1152
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ult i129 [[TMP9]], 4294967167
; CHECK-NEXT:    br i1 [[TMP10]], label [[FP_TO_I_IF_THEN5:%.*]], label [[FP_TO_I_IF_END9:%.*]]
; CHECK:       fp-to-i-if-then5:
; CHECK-NEXT:    [[TMP11:%.*]] = select i1 [[TMP2]], i129 340282366920938463463374607431768211455, i129 -340282366920938463463374607431768211456
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-if-end9:
; CHECK-NEXT:    [[TMP12:%.*]] = icmp ult i129 [[TMP5]], 1075
; CHECK-NEXT:    br i1 [[TMP12]], label [[FP_TO_I_IF_THEN12:%.*]], label [[FP_TO_I_IF_ELSE:%.*]]
; CHECK:       fp-to-i-if-then12:
; CHECK-NEXT:    [[TMP13:%.*]] = sub i129 1075, [[TMP5]]
; CHECK-NEXT:    [[TMP14:%.*]] = lshr i129 [[TMP7]], [[TMP13]]
; CHECK-NEXT:    [[TMP15:%.*]] = mul i129 [[TMP14]], [[TMP3]]
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-if-else:
; CHECK-NEXT:    [[TMP16:%.*]] = add i129 [[TMP5]], 4294966221
; CHECK-NEXT:    [[TMP17:%.*]] = shl i129 [[TMP7]], [[TMP16]]
; CHECK-NEXT:    [[TMP18:%.*]] = mul i129 [[TMP17]], [[TMP3]]
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-cleanup:
; CHECK-NEXT:    [[TMP19:%.*]] = phi i129 [ [[TMP11]], [[FP_TO_I_IF_THEN5]] ], [ [[TMP15]], [[FP_TO_I_IF_THEN12]] ], [ [[TMP18]], [[FP_TO_I_IF_ELSE]] ], [ 0, [[FP_TO_I_ENTRY:%.*]] ]
; CHECK-NEXT:    ret i129 [[TMP19]]
;
  %conv = fptoui double %a to i129
  ret i129 %conv
}

define i129 @x86_fp80toui129(x86_fp80 %a) {
; CHECK-LABEL: @x86_fp80toui129(
; CHECK-NEXT:  fp-to-i-entry:
; CHECK-NEXT:    [[TMP0:%.*]] = fpext x86_fp80 [[A:%.*]] to fp128
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast fp128 [[TMP0]] to i128
; CHECK-NEXT:    [[TMP2:%.*]] = zext i128 [[TMP1]] to i129
; CHECK-NEXT:    [[TMP3:%.*]] = icmp sgt i128 [[TMP1]], -1
; CHECK-NEXT:    [[TMP4:%.*]] = select i1 [[TMP3]], i129 1, i129 -1
; CHECK-NEXT:    [[TMP5:%.*]] = lshr i129 [[TMP2]], 112
; CHECK-NEXT:    [[TMP6:%.*]] = and i129 [[TMP5]], 32767
; CHECK-NEXT:    [[TMP7:%.*]] = and i129 [[TMP2]], 5192296858534827628530496329220095
; CHECK-NEXT:    [[TMP8:%.*]] = or i129 [[TMP7]], 5192296858534827628530496329220096
; CHECK-NEXT:    [[TMP9:%.*]] = icmp ult i129 [[TMP6]], 16383
; CHECK-NEXT:    br i1 [[TMP9]], label [[FP_TO_I_CLEANUP:%.*]], label [[FP_TO_I_IF_END:%.*]]
; CHECK:       fp-to-i-if-end:
; CHECK-NEXT:    [[TMP10:%.*]] = add i129 [[TMP6]], -16512
; CHECK-NEXT:    [[TMP11:%.*]] = icmp ult i129 [[TMP10]], 4294967167
; CHECK-NEXT:    br i1 [[TMP11]], label [[FP_TO_I_IF_THEN5:%.*]], label [[FP_TO_I_IF_END9:%.*]]
; CHECK:       fp-to-i-if-then5:
; CHECK-NEXT:    [[TMP12:%.*]] = select i1 [[TMP3]], i129 340282366920938463463374607431768211455, i129 -340282366920938463463374607431768211456
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-if-end9:
; CHECK-NEXT:    [[TMP13:%.*]] = icmp ult i129 [[TMP6]], 16495
; CHECK-NEXT:    br i1 [[TMP13]], label [[FP_TO_I_IF_THEN12:%.*]], label [[FP_TO_I_IF_ELSE:%.*]]
; CHECK:       fp-to-i-if-then12:
; CHECK-NEXT:    [[TMP14:%.*]] = sub i129 16495, [[TMP6]]
; CHECK-NEXT:    [[TMP15:%.*]] = lshr i129 [[TMP8]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = mul i129 [[TMP15]], [[TMP4]]
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-if-else:
; CHECK-NEXT:    [[TMP17:%.*]] = add i129 [[TMP6]], 4294950801
; CHECK-NEXT:    [[TMP18:%.*]] = shl i129 [[TMP8]], [[TMP17]]
; CHECK-NEXT:    [[TMP19:%.*]] = mul i129 [[TMP18]], [[TMP4]]
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-cleanup:
; CHECK-NEXT:    [[TMP20:%.*]] = phi i129 [ [[TMP12]], [[FP_TO_I_IF_THEN5]] ], [ [[TMP16]], [[FP_TO_I_IF_THEN12]] ], [ [[TMP19]], [[FP_TO_I_IF_ELSE]] ], [ 0, [[FP_TO_I_ENTRY:%.*]] ]
; CHECK-NEXT:    ret i129 [[TMP20]]
;
  %conv = fptoui x86_fp80 %a to i129
  ret i129 %conv
}

define i129 @fp128toui129(fp128 %a) {
; CHECK-LABEL: @fp128toui129(
; CHECK-NEXT:  fp-to-i-entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast fp128 [[A:%.*]] to i128
; CHECK-NEXT:    [[TMP1:%.*]] = zext i128 [[TMP0]] to i129
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i128 [[TMP0]], -1
; CHECK-NEXT:    [[TMP3:%.*]] = select i1 [[TMP2]], i129 1, i129 -1
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i129 [[TMP1]], 112
; CHECK-NEXT:    [[TMP5:%.*]] = and i129 [[TMP4]], 32767
; CHECK-NEXT:    [[TMP6:%.*]] = and i129 [[TMP1]], 5192296858534827628530496329220095
; CHECK-NEXT:    [[TMP7:%.*]] = or i129 [[TMP6]], 5192296858534827628530496329220096
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ult i129 [[TMP5]], 16383
; CHECK-NEXT:    br i1 [[TMP8]], label [[FP_TO_I_CLEANUP:%.*]], label [[FP_TO_I_IF_END:%.*]]
; CHECK:       fp-to-i-if-end:
; CHECK-NEXT:    [[TMP9:%.*]] = add i129 [[TMP5]], -16512
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ult i129 [[TMP9]], 4294967167
; CHECK-NEXT:    br i1 [[TMP10]], label [[FP_TO_I_IF_THEN5:%.*]], label [[FP_TO_I_IF_END9:%.*]]
; CHECK:       fp-to-i-if-then5:
; CHECK-NEXT:    [[TMP11:%.*]] = select i1 [[TMP2]], i129 340282366920938463463374607431768211455, i129 -340282366920938463463374607431768211456
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-if-end9:
; CHECK-NEXT:    [[TMP12:%.*]] = icmp ult i129 [[TMP5]], 16495
; CHECK-NEXT:    br i1 [[TMP12]], label [[FP_TO_I_IF_THEN12:%.*]], label [[FP_TO_I_IF_ELSE:%.*]]
; CHECK:       fp-to-i-if-then12:
; CHECK-NEXT:    [[TMP13:%.*]] = sub i129 16495, [[TMP5]]
; CHECK-NEXT:    [[TMP14:%.*]] = lshr i129 [[TMP7]], [[TMP13]]
; CHECK-NEXT:    [[TMP15:%.*]] = mul i129 [[TMP14]], [[TMP3]]
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-if-else:
; CHECK-NEXT:    [[TMP16:%.*]] = add i129 [[TMP5]], 4294950801
; CHECK-NEXT:    [[TMP17:%.*]] = shl i129 [[TMP7]], [[TMP16]]
; CHECK-NEXT:    [[TMP18:%.*]] = mul i129 [[TMP17]], [[TMP3]]
; CHECK-NEXT:    br label [[FP_TO_I_CLEANUP]]
; CHECK:       fp-to-i-cleanup:
; CHECK-NEXT:    [[TMP19:%.*]] = phi i129 [ [[TMP11]], [[FP_TO_I_IF_THEN5]] ], [ [[TMP15]], [[FP_TO_I_IF_THEN12]] ], [ [[TMP18]], [[FP_TO_I_IF_ELSE]] ], [ 0, [[FP_TO_I_ENTRY:%.*]] ]
; CHECK-NEXT:    ret i129 [[TMP19]]
;
  %conv = fptoui fp128 %a to i129
  ret i129 %conv
}
