; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; FIXME: globalisel crashes on v3
; RUN:  llc -mtriple=amdgcn -mcpu=gfx704 < %s  | FileCheck --check-prefixes=GFX7CHECK,GFX7SELDAG %s
; xUN:  llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx704 < %s  | FileCheck --check-prefixes=GFX7CHECK,GFX7GLISEL %s
; RUN:  llc -mtriple=amdgcn -mcpu=gfx803 < %s  | FileCheck --check-prefixes=GFX8CHECK,GFX8SELDAG %s
; xUN:  llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx803 < %s  | FileCheck --check-prefixes=GFX8CHECK,GFX8GLISEL %s
; RUN:  llc -mtriple=amdgcn -mcpu=gfx908 < %s  | FileCheck --check-prefixes=GFX9CHECK,GFX9SELDAG %s
; xUN:  llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx908 < %s  | FileCheck --check-prefixes=GFX9CHECK,GFX9GLISEL %s
; RUN:  llc -mtriple=amdgcn -mcpu=gfx1031 < %s | FileCheck --check-prefixes=GFX10CHECK,GFX10SELDAG %s
; xUN:  llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1031 < %s | FileCheck --check-prefixes=GFX10CHECK,GFX10GLISEL %s
; RUN:  llc -mtriple=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 < %s | FileCheck --check-prefixes=GFX11CHECK,GFX11SELDAG %s
; xUN:  llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 < %s | FileCheck --check-prefixes=GFX11CHECK,GFX11GLISEL %s

define amdgpu_kernel void @sgpr_isnan_bf16(ptr addrspace(1) %out, bfloat %x) {
; GFX7CHECK-LABEL: sgpr_isnan_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_load_dword s4, s[0:1], 0xb
; GFX7CHECK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; GFX7CHECK-NEXT:    s_mov_b32 s3, 0xf000
; GFX7CHECK-NEXT:    s_mov_b32 s2, -1
; GFX7CHECK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7CHECK-NEXT:    s_and_b32 s4, s4, 0x7fff
; GFX7CHECK-NEXT:    s_cmpk_gt_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    s_cselect_b64 s[4:5], -1, 0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, -1, s[4:5]
; GFX7CHECK-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7CHECK-NEXT:    s_endpgm
;
; GFX8CHECK-LABEL: sgpr_isnan_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GFX8CHECK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX8CHECK-NEXT:    v_mov_b32_e32 v0, 0x7fff
; GFX8CHECK-NEXT:    s_movk_i32 s3, 0x7f80
; GFX8CHECK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, s2, v0
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s3, v0
; GFX8CHECK-NEXT:    v_mov_b32_e32 v0, s0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, -1, vcc
; GFX8CHECK-NEXT:    v_mov_b32_e32 v1, s1
; GFX8CHECK-NEXT:    flat_store_dword v[0:1], v2
; GFX8CHECK-NEXT:    s_endpgm
;
; GFX9CHECK-LABEL: sgpr_isnan_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9CHECK-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9CHECK-NEXT:    v_mov_b32_e32 v1, 0x7fff
; GFX9CHECK-NEXT:    s_movk_i32 s0, 0x7f80
; GFX9CHECK-NEXT:    v_mov_b32_e32 v0, 0
; GFX9CHECK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s0, v1
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, -1, vcc
; GFX9CHECK-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9CHECK-NEXT:    s_endpgm
;
; GFX10CHECK-LABEL: sgpr_isnan_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_clause 0x1
; GFX10CHECK-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GFX10CHECK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10CHECK-NEXT:    v_mov_b32_e32 v1, 0
; GFX10CHECK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e64 v0, 0x7fff, s2
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX10CHECK-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10CHECK-NEXT:    s_endpgm
;
; GFX11CHECK-LABEL: sgpr_isnan_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_clause 0x1
; GFX11CHECK-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11CHECK-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11CHECK-NEXT:    v_mov_b32_e32 v1, 0
; GFX11CHECK-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e64 v0, 0x7fff, s2
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc_lo
; GFX11CHECK-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11CHECK-NEXT:    s_nop 0
; GFX11CHECK-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11CHECK-NEXT:    s_endpgm
  %result = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 3)
  %sext = sext i1 %result to i32
  store i32 %sext, ptr addrspace(1) %out, align 4
  ret void
}

define i1 @zeromask_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: zeromask_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_mov_b32_e32 v0, 0
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: zeromask_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_mov_b32_e32 v0, 0
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: zeromask_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_mov_b32_e32 v0, 0
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: zeromask_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_mov_b32_e32 v0, 0
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: zeromask_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_mov_b32_e32 v0, 0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 0)
  ret i1 %1
}

; FIXME: DAG and GlobalISel return different values for i1 true
define i1 @allflags_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: allflags_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_mov_b32_e32 v0, 1
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: allflags_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_mov_b32_e32 v0, 1
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: allflags_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_mov_b32_e32 v0, 1
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: allflags_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_mov_b32_e32 v0, 1
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: allflags_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_mov_b32_e32 v0, 1
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 1023) ; 0x3ff
  ret i1 %1
}

define i1 @snan_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: snan_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7fc0
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e64 s[4:5], s4, v0
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: snan_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7fc0
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e64 s[4:5], s4, v0
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: snan_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7fc0
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e64 s[4:5], s4, v0
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: snan_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7fc0, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e64 s4, 0x7f80, v0
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: snan_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7fc0, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e64 s0, 0x7f80, v0
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 1)  ; 0x001
  ret i1 %1
}

define i1 @qnan_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: qnan_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7fbf
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: qnan_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7fbf
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: qnan_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7fbf
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: qnan_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7fbf, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: qnan_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7fbf, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 2)  ; 0x002
  ret i1 %1
}

define i1 @posinf_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: posinf_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: posinf_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: posinf_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: posinf_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: posinf_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 512)  ; 0x200
  ret i1 %1
}

define i1 @neginf_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: neginf_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7CHECK-NEXT:    s_mov_b32 s4, 0xff80
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: neginf_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0xff80
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: neginf_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0xff80
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: neginf_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0xff80, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: neginf_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0xff80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 4)  ; 0x004
  ret i1 %1
}

define i1 @posnormal_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: posnormal_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_ashrrev_i32_e32 v1, 16, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, 0xffffff80, v0
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7CHECK-NEXT:    s_movk_i32 s6, 0x7f00
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e64 s[4:5], -1, v1
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e32 vcc, s6, v0
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: posnormal_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, -1, v0
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f00
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e64 s[4:5], s4, v0
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: posnormal_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, -1, v0
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f00
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e64 s[4:5], s4, v0
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: posnormal_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, -1, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v1, v1, 0xff80
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e64 s4, 0x7f00, v1
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: posnormal_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, -1, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v1, v1, 0xff80
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e64 s0, 0x7f00, v1
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 256)  ; 0x100
  ret i1 %1
}

define i1 @negnormal_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: negnormal_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_ashrrev_i32_e32 v1, 16, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, 0xffffff80, v0
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7CHECK-NEXT:    s_movk_i32 s6, 0x7f00
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e64 s[4:5], 0, v1
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e32 vcc, s6, v0
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: negnormal_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f00
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e64 s[4:5], s4, v0
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: negnormal_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f00
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e64 s[4:5], s4, v0
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: negnormal_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v1, v1, 0xff80
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e64 s4, 0x7f00, v1
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: negnormal_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v1, v1, 0xff80
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e64 s0, 0x7f00, v1
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 8)  ; 0x008
  ret i1 %1
}

define i1 @possubnormal_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: possubnormal_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, -1, v0
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: possubnormal_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, -1, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: possubnormal_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, -1, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: possubnormal_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_add_nc_u16 v0, v0, -1
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: possubnormal_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_add_nc_u16 v0, v0, -1
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 128)  ; 0x080
  ret i1 %1
}

define i1 @negsubnormal_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: negsubnormal_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_ashrrev_i32_e32 v1, 16, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_add_i32_e64 v0, s[4:5], -1, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, 0, v1
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e64 s[4:5], s4, v0
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: negsubnormal_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, -1, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e64 s[4:5], s4, v0
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: negsubnormal_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, -1, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e64 s[4:5], s4, v0
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: negsubnormal_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v1, v1, -1
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e64 s4, 0x7f, v1
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: negsubnormal_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v1, v1, -1
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e64 s0, 0x7f, v1
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 16)  ; 0x010
  ret i1 %1
}

define i1 @poszero_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: poszero_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: poszero_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: poszero_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: poszero_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: poszero_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 64)  ; 0x040
  ret i1 %1
}

define i1 @negzero_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: negzero_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7CHECK-NEXT:    s_mov_b32 s4, 0x8000
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: negzero_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x8000
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: negzero_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x8000
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: negzero_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0x8000, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: negzero_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0x8000, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 32)  ; 0x020
  ret i1 %1
}

define i1 @posfinite_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: posfinite_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: posfinite_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: posfinite_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: posfinite_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: posfinite_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 448)  ; 0x1c0
  ret i1 %1
}

define i1 @negfinite_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: negfinite_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_ashrrev_i32_e32 v1, 16, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, 0, v1
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e64 s[4:5], s4, v0
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: negfinite_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e64 s[4:5], s4, v0
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: negfinite_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e64 s[4:5], s4, v0
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: negfinite_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e64 s4, 0x7f80, v1
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: negfinite_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e64 s0, 0x7f80, v1
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 56)  ; 0x038
  ret i1 %1
}

define i1 @isnan_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: isnan_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: isnan_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: isnan_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: isnan_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: isnan_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 3)  ; nan
  ret i1 %1
}

define i1 @not_isnan_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_isnan_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_isnan_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_isnan_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_isnan_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f81, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_isnan_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f81, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 1020)  ; ~nan
  ret i1 %class
}

define <2 x i1> @isnan_v2bf16(<2 x bfloat> %x) nounwind {
; GFX7CHECK-LABEL: isnan_v2bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_bfe_u32 v1, v1, 16, 15
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v1
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: isnan_v2bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_bfe_u32 v1, v0, 16, 15
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v1
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: isnan_v2bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v1
; GFX9CHECK-NEXT:    v_cmp_gt_i16_sdwa s[4:5], v1, s4 src0_sel:WORD_1 src1_sel:DWORD
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: isnan_v2bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff7fff, v0
; GFX10CHECK-NEXT:    v_mov_b32_e32 v2, 0x7f80
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v1
; GFX10CHECK-NEXT:    v_cmp_gt_i16_sdwa s4, v1, v2 src0_sel:WORD_1 src1_sel:DWORD
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: isnan_v2bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX11CHECK-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v1
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call <2 x i1> @llvm.is.fpclass.v2bf16(<2 x bfloat> %x, i32 3)  ; nan
  ret <2 x i1> %1
}

define <3 x i1> @isnan_v3bf16(<3 x bfloat> %x) nounwind {
; GFX7CHECK-LABEL: isnan_v3bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_bfe_u32 v1, v1, 16, 15
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v2, v2, 16, 15
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v1
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v2
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: isnan_v3bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v2, 0x7fff, v1
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_bfe_u32 v1, v0, 16, 15
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v1
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v2
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: isnan_v3bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v3
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v1
; GFX9CHECK-NEXT:    v_cmp_gt_i16_sdwa s[4:5], v3, s4 src0_sel:WORD_1 src1_sel:DWORD
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: isnan_v3bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v0
; GFX10CHECK-NEXT:    v_mov_b32_e32 v3, 0x7f80
; GFX10CHECK-NEXT:    v_and_b32_e32 v4, 0x7fff, v1
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v2
; GFX10CHECK-NEXT:    v_cmp_gt_i16_sdwa s4, v2, v3 src0_sel:WORD_1 src1_sel:DWORD
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v4
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s4
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: isnan_v3bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX11CHECK-NEXT:    v_and_b32_e32 v3, 0x7fff, v1
; GFX11CHECK-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v2
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v3
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call <3 x i1> @llvm.is.fpclass.v3bf16(<3 x bfloat> %x, i32 3)  ; nan
  ret <3 x i1> %1
}

define <4 x i1> @isnan_v4bf16(<4 x bfloat> %x) nounwind {
; GFX7CHECK-LABEL: isnan_v4bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_bfe_u32 v1, v1, 16, 15
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v2, v2, 16, 15
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v1
; GFX7CHECK-NEXT:    v_bfe_u32 v3, v3, 16, 15
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v2
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v3
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: isnan_v4bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_bfe_u32 v3, v1, 16, 15
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v1
; GFX8CHECK-NEXT:    v_bfe_u32 v1, v0, 16, 15
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v1
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v2
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v3
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: isnan_v4bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v1
; GFX9CHECK-NEXT:    s_movk_i32 s6, 0x7f80
; GFX9CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff7fff, v0
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s6, v1
; GFX9CHECK-NEXT:    v_cmp_gt_i16_sdwa s[4:5], v1, s6 src0_sel:WORD_1 src1_sel:DWORD
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s6, v3
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    v_cmp_gt_i16_sdwa s[4:5], v3, s6 src0_sel:WORD_1 src1_sel:DWORD
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: isnan_v4bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v3, 0x7fff7fff, v0
; GFX10CHECK-NEXT:    v_mov_b32_e32 v5, 0x7f80
; GFX10CHECK-NEXT:    v_and_b32_e32 v4, 0x7fff7fff, v1
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v3
; GFX10CHECK-NEXT:    v_cmp_gt_i16_sdwa s4, v3, v5 src0_sel:WORD_1 src1_sel:DWORD
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v4
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s4
; GFX10CHECK-NEXT:    v_cmp_gt_i16_sdwa s4, v4, v5 src0_sel:WORD_1 src1_sel:DWORD
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: isnan_v4bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX11CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff7fff, v1
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX11CHECK-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v1
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v4
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v3
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call <4 x i1> @llvm.is.fpclass.v4bf16(<4 x bfloat> %x, i32 3)  ; nan
  ret <4 x i1> %1
}

; FIXME: Broken for gfx6/7
; define i1 @isnan_bf16_strictfp(bfloat %x) strictfp nounwind {
;   %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 3) strictfp ; nan
;   ret i1 %1
; }

define i1 @isinf_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: isinf_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: isinf_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: isinf_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: isinf_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: isinf_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 516)  ; 0x204 = "inf"
  ret i1 %1
}

define i1 @isfinite_bf16(bfloat %x) nounwind {
; GFX7CHECK-LABEL: isfinite_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: isfinite_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: isfinite_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: isfinite_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: isfinite_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %1 = call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 504)  ; 0x1f8 = "finite"
  ret i1 %1
}

define i1 @issubnormal_or_zero_bf16(bfloat %x) {
; GFX7CHECK-LABEL: issubnormal_or_zero_bf16:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0x7f80, v0
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: issubnormal_or_zero_bf16:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7f80, v0
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: issubnormal_or_zero_bf16:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7f80, v0
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: issubnormal_or_zero_bf16:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: issubnormal_or_zero_bf16:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 240)  ; 0xf0 = "subnormal|zero"
  ret i1 %class
}

define i1 @not_issubnormal_or_zero_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_issubnormal_or_zero_bf16:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0x7f80, v0
; GFX7CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_issubnormal_or_zero_bf16:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7f80, v0
; GFX8CHECK-NEXT:    v_cmp_ne_u16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_issubnormal_or_zero_bf16:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7f80, v0
; GFX9CHECK-NEXT:    v_cmp_ne_u16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_issubnormal_or_zero_bf16:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cmp_ne_u16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_issubnormal_or_zero_bf16:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cmp_ne_u16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
    %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 783)  ; ~0xf0 = "~(subnormal|zero)"
  ret i1 %class
}

define i1 @isnormal_bf16(bfloat %x) {
; GFX7CHECK-LABEL: isnormal_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, 0xffffff80, v0
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f00
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: isnormal_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f00
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: isnormal_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f00
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: isnormal_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v0, v0, 0xff80
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f00, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: isnormal_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v0, v0, 0xff80
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f00, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 264)  ; 0x108 = "normal"
  ret i1 %class
}

define i1 @not_isnormal_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_isnormal_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, 0xffffff80, v0
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7eff
; GFX7CHECK-NEXT:    v_cmp_lt_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_isnormal_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7eff
; GFX8CHECK-NEXT:    v_cmp_lt_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_isnormal_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7eff
; GFX9CHECK-NEXT:    v_cmp_lt_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_isnormal_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v0, v0, 0xff80
; GFX10CHECK-NEXT:    v_cmp_lt_u16_e32 vcc_lo, 0x7eff, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_isnormal_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v0, v0, 0xff80
; GFX11CHECK-NEXT:    v_cmp_lt_u16_e32 vcc_lo, 0x7eff, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 759)  ; ~0x108 = "~normal"
  ret i1 %class
}

define i1 @not_is_plus_normal_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_is_plus_normal_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_ashrrev_i32_e32 v1, 16, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, 0xffffff80, v0
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7CHECK-NEXT:    s_movk_i32 s6, 0x7eff
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e64 s[4:5], 0, v1
; GFX7CHECK-NEXT:    v_cmp_lt_u32_e32 vcc, s6, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_is_plus_normal_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7eff
; GFX8CHECK-NEXT:    v_cmp_lt_u16_e64 s[4:5], s4, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_is_plus_normal_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7eff
; GFX9CHECK-NEXT:    v_cmp_lt_u16_e64 s[4:5], s4, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_is_plus_normal_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v1, v1, 0xff80
; GFX10CHECK-NEXT:    v_cmp_lt_u16_e64 s4, 0x7eff, v1
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_is_plus_normal_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v1, v1, 0xff80
; GFX11CHECK-NEXT:    v_cmp_lt_u16_e64 s0, 0x7eff, v1
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 767)  ; ~0x100 = ~"+normal"
  ret i1 %class
}

define i1 @not_is_neg_normal_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_is_neg_normal_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_ashrrev_i32_e32 v1, 16, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, 0xffffff80, v0
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7CHECK-NEXT:    s_movk_i32 s6, 0x7eff
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e64 s[4:5], -1, v1
; GFX7CHECK-NEXT:    v_cmp_lt_u32_e32 vcc, s6, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_is_neg_normal_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, -1, v0
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7eff
; GFX8CHECK-NEXT:    v_cmp_lt_u16_e64 s[4:5], s4, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_is_neg_normal_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, -1, v0
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7eff
; GFX9CHECK-NEXT:    v_cmp_lt_u16_e64 s[4:5], s4, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_is_neg_normal_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, -1, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v1, v1, 0xff80
; GFX10CHECK-NEXT:    v_cmp_lt_u16_e64 s4, 0x7eff, v1
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_is_neg_normal_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, -1, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v1, v1, 0xff80
; GFX11CHECK-NEXT:    v_cmp_lt_u16_e64 s0, 0x7eff, v1
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 1015)  ; ~0x008 = ~"-normal"
  ret i1 %class
}

define i1 @issubnormal_bf16(bfloat %x) {
; GFX7CHECK-LABEL: issubnormal_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, -1, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: issubnormal_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, -1, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: issubnormal_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, -1, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: issubnormal_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v0, v0, -1
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: issubnormal_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v0, v0, -1
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 144)  ; 0x90 = "subnormal"
  ret i1 %class
}

define i1 @not_issubnormal_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_issubnormal_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, -1, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7e
; GFX7CHECK-NEXT:    v_cmp_lt_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_issubnormal_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, -1, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7e
; GFX8CHECK-NEXT:    v_cmp_lt_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_issubnormal_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, -1, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7e
; GFX9CHECK-NEXT:    v_cmp_lt_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_issubnormal_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v0, v0, -1
; GFX10CHECK-NEXT:    v_cmp_lt_u16_e32 vcc_lo, 0x7e, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_issubnormal_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v0, v0, -1
; GFX11CHECK-NEXT:    v_cmp_lt_u16_e32 vcc_lo, 0x7e, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 879)  ; ~0x90 = ~"subnormal"
  ret i1 %class
}

define i1 @iszero_bf16(bfloat %x) {
; GFX7CHECK-LABEL: iszero_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: iszero_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: iszero_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: iszero_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: iszero_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 96)  ; 0x60 = "zero"
  ret i1 %class
}

define i1 @not_iszero_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_iszero_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_iszero_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    v_cmp_ne_u16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_iszero_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    v_cmp_ne_u16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_iszero_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_ne_u16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_iszero_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_ne_u16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 927)  ; ~0x60 = ~"zero"
  ret i1 %class
}

define i1 @ispositive_bf16(bfloat %x) {
; GFX7CHECK-LABEL: ispositive_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: ispositive_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: ispositive_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: ispositive_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f81, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: ispositive_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f81, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 960)  ; fcPositive
  ret i1 %class
}

define i1 @not_ispositive_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_ispositive_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX7CHECK-NEXT:    v_ashrrev_i32_e32 v2, 16, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s6, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, 0, v2
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e64 s[4:5], s6, v0
; GFX7CHECK-NEXT:    s_mov_b32 s7, 0xff80
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s7, v1
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s6, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_ispositive_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s6, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e64 s[4:5], s6, v1
; GFX8CHECK-NEXT:    s_movk_i32 s7, 0xff80
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s7, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s6, v1
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_ispositive_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s6, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e64 s[4:5], s6, v1
; GFX9CHECK-NEXT:    s_movk_i32 s7, 0xff80
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s7, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s6, v1
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_ispositive_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e64 s5, 0xff80, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e64 s4, 0x7f80, v1
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e64 s6, 0x7f80, v1
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, s5
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, s6
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_ispositive_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e64 s1, 0xff80, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e64 s0, 0x7f80, v1
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e64 s2, 0x7f80, v1
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, s1
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, s2
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 63)  ; ~fcPositive
  ret i1 %class
}

define i1 @isnegative_bf16(bfloat %x) {
; GFX7CHECK-LABEL: isnegative_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX7CHECK-NEXT:    v_ashrrev_i32_e32 v2, 16, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, 0, v2
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e64 s[4:5], s4, v0
; GFX7CHECK-NEXT:    s_mov_b32 s6, 0xff80
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s6, v1
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: isnegative_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e64 s[4:5], s4, v1
; GFX8CHECK-NEXT:    s_movk_i32 s6, 0xff80
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s6, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: isnegative_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e64 s[4:5], s4, v1
; GFX9CHECK-NEXT:    s_movk_i32 s6, 0xff80
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s6, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: isnegative_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e64 s5, 0xff80, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e64 s4, 0x7f80, v1
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, s5
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: isnegative_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e64 s1, 0xff80, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e64 s0, 0x7f80, v1
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, s1
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 60)  ; fcNegative
  ret i1 %class
}

define i1 @not_isnegative_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_isnegative_bf16:
; GFX7CHECK:       ; %bb.0:
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e64 s[4:5], s4, v1
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_isnegative_bf16:
; GFX8CHECK:       ; %bb.0:
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e64 s[4:5], s4, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_isnegative_bf16:
; GFX9CHECK:       ; %bb.0:
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e64 s[4:5], s4, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_isnegative_bf16:
; GFX10CHECK:       ; %bb.0:
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f81, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e64 s4, 0x7f80, v1
; GFX10CHECK-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_isnegative_bf16:
; GFX11CHECK:       ; %bb.0:
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v1, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f81, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e64 s0, 0x7f80, v1
; GFX11CHECK-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
  %class = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 963)  ; ~fcNegative
  ret i1 %class
}

define i1 @iszero_or_nan_bf16(bfloat %x) {
; GFX7CHECK-LABEL: iszero_or_nan_bf16:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: iszero_or_nan_bf16:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e64 s[4:5], 0, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: iszero_or_nan_bf16:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e64 s[4:5], 0, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: iszero_or_nan_bf16:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e64 s4, 0, v0
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: iszero_or_nan_bf16:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 99)  ; 0x60|0x3 = "zero|nan"
  ret i1 %0
}

define i1 @iszero_or_nan_f_daz(bfloat %x) #0 {
; GFX7CHECK-LABEL: iszero_or_nan_f_daz:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: iszero_or_nan_f_daz:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e64 s[4:5], 0, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: iszero_or_nan_f_daz:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e64 s[4:5], 0, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: iszero_or_nan_f_daz:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e64 s4, 0, v0
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: iszero_or_nan_f_daz:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 99)  ; 0x60|0x3 = "zero|nan"
  ret i1 %0
}

define i1 @iszero_or_nan_f_maybe_daz(bfloat %x) #1 {
; GFX7CHECK-LABEL: iszero_or_nan_f_maybe_daz:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: iszero_or_nan_f_maybe_daz:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e64 s[4:5], 0, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: iszero_or_nan_f_maybe_daz:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e64 s[4:5], 0, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: iszero_or_nan_f_maybe_daz:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e64 s4, 0, v0
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: iszero_or_nan_f_maybe_daz:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 99)  ; 0x60|0x3 = "zero|nan"
  ret i1 %0
}

define i1 @not_iszero_or_nan_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_iszero_or_nan_bf16:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v0
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_iszero_or_nan_bf16:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cmp_ne_u16_e64 s[4:5], 0, v0
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_iszero_or_nan_bf16:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cmp_ne_u16_e64 s[4:5], 0, v0
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_iszero_or_nan_bf16:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f81, v0
; GFX10CHECK-NEXT:    v_cmp_ne_u16_e64 s4, 0, v0
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_iszero_or_nan_bf16:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f81, v0
; GFX11CHECK-NEXT:    v_cmp_ne_u16_e64 s0, 0, v0
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 924)  ; ~0x60 = "~(zero|nan)"
  ret i1 %0
}

define i1 @not_iszero_or_nan_f_daz(bfloat %x) #0 {
; GFX7CHECK-LABEL: not_iszero_or_nan_f_daz:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v0
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_iszero_or_nan_f_daz:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cmp_ne_u16_e64 s[4:5], 0, v0
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_iszero_or_nan_f_daz:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cmp_ne_u16_e64 s[4:5], 0, v0
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_iszero_or_nan_f_daz:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f81, v0
; GFX10CHECK-NEXT:    v_cmp_ne_u16_e64 s4, 0, v0
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_iszero_or_nan_f_daz:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f81, v0
; GFX11CHECK-NEXT:    v_cmp_ne_u16_e64 s0, 0, v0
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 924)  ; ~(0x60|0x3) = "~(zero|nan)"
  ret i1 %0
}

define i1 @not_iszero_or_nan_f_maybe_daz(bfloat %x) #1 {
; GFX7CHECK-LABEL: not_iszero_or_nan_f_maybe_daz:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v0
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_iszero_or_nan_f_maybe_daz:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cmp_ne_u16_e64 s[4:5], 0, v0
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_iszero_or_nan_f_maybe_daz:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f81
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cmp_ne_u16_e64 s[4:5], 0, v0
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_iszero_or_nan_f_maybe_daz:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f81, v0
; GFX10CHECK-NEXT:    v_cmp_ne_u16_e64 s4, 0, v0
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_iszero_or_nan_f_maybe_daz:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f81, v0
; GFX11CHECK-NEXT:    v_cmp_ne_u16_e64 s0, 0, v0
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 924)  ; ~(0x60|0x3) = "~(zero|nan)"
  ret i1 %0
}

define i1 @iszero_or_qnan_bf16(bfloat %x) {
; GFX7CHECK-LABEL: iszero_or_qnan_bf16:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7fbf
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: iszero_or_qnan_bf16:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7fbf
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e64 s[4:5], 0, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: iszero_or_qnan_bf16:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7fbf
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e64 s[4:5], 0, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: iszero_or_qnan_bf16:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7fbf, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e64 s4, 0, v0
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: iszero_or_qnan_bf16:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7fbf, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 98)  ; 0x60|0x2 = "zero|qnan"
  ret i1 %0
}

define i1 @iszero_or_snan_bf16(bfloat %x) {
; GFX7CHECK-LABEL: iszero_or_snan_bf16:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7fc0
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e64 s[4:5], s4, v0
; GFX7CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: iszero_or_snan_bf16:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7fc0
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e64 s[4:5], s4, v0
; GFX8CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: iszero_or_snan_bf16:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7fc0
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e64 s[4:5], s4, v0
; GFX9CHECK-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: iszero_or_snan_bf16:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7fc0, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e64 s4, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e64 s5, 0, v0
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    s_or_b32 s4, s5, s4
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: iszero_or_snan_bf16:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7fc0, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e64 s0, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e64 s1, 0, v0
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    s_or_b32 s0, s1, s0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 97)  ; 0x60|0x1 = "zero|snan"
  ret i1 %0
}

define i1 @not_iszero_or_qnan_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_iszero_or_qnan_bf16:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7fc0
; GFX7CHECK-NEXT:    s_movk_i32 s8, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e64 s[4:5], s8, v0
; GFX7CHECK-NEXT:    s_and_b64 s[6:7], s[4:5], vcc
; GFX7CHECK-NEXT:    v_add_i32_e64 v1, s[4:5], -1, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s8, v0
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e64 s[4:5], s4, v1
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, 0xffffff80, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], s[6:7]
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7CHECK-NEXT:    s_movk_i32 s6, 0x7f00
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e32 vcc, s6, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_iszero_or_qnan_bf16:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7fc0
; GFX8CHECK-NEXT:    s_movk_i32 s8, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e64 s[4:5], s8, v0
; GFX8CHECK-NEXT:    s_and_b64 s[6:7], s[4:5], vcc
; GFX8CHECK-NEXT:    v_add_u16_e32 v1, -1, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s8, v0
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e64 s[4:5], s4, v1
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], s[6:7]
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX8CHECK-NEXT:    s_movk_i32 s6, 0x7f00
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s6, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_iszero_or_qnan_bf16:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7fc0
; GFX9CHECK-NEXT:    s_movk_i32 s8, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e64 s[4:5], s8, v0
; GFX9CHECK-NEXT:    s_and_b64 s[6:7], s[4:5], vcc
; GFX9CHECK-NEXT:    v_add_u16_e32 v1, -1, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s8, v0
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e64 s[4:5], s4, v1
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], s[6:7]
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX9CHECK-NEXT:    s_movk_i32 s6, 0x7f00
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s6, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_iszero_or_qnan_bf16:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v1, v0, -1
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7fc0, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e64 s4, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e64 s5, 0x7f80, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v0, v0, 0xff80
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e64 s6, 0x7f, v1
; GFX10CHECK-NEXT:    s_and_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f00, v0
; GFX10CHECK-NEXT:    s_or_b32 s5, s6, s5
; GFX10CHECK-NEXT:    s_or_b32 s4, s5, s4
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_iszero_or_qnan_bf16:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v1, v0, -1
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7fc0, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e64 s0, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e64 s1, 0x7f80, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v0, v0, 0xff80
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e64 s2, 0x7f, v1
; GFX11CHECK-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 0x7f00, v0
; GFX11CHECK-NEXT:    s_or_b32 s1, s2, s1
; GFX11CHECK-NEXT:    s_or_b32 s0, s1, s0
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 925)  ; ~(0x60|0x2) = "~(zero|qnan)"
  ret i1 %0
}

define i1 @not_iszero_or_snan_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_iszero_or_snan_bf16:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_add_i32_e64 v1, s[4:5], -1, v0
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e64 s[4:5], s4, v1
; GFX7CHECK-NEXT:    s_movk_i32 s6, 0x7fbf
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s6, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_add_i32_e32 v0, vcc, 0xffffff80, v0
; GFX7CHECK-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7CHECK-NEXT:    s_movk_i32 s6, 0x7f00
; GFX7CHECK-NEXT:    v_cmp_gt_u32_e32 vcc, s6, v0
; GFX7CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_iszero_or_snan_bf16:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v1, -1, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e64 s[4:5], s4, v1
; GFX8CHECK-NEXT:    s_movk_i32 s6, 0x7fbf
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s6, v0
; GFX8CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX8CHECK-NEXT:    s_movk_i32 s6, 0x7f00
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s6, v0
; GFX8CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_iszero_or_snan_bf16:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v1, -1, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e64 s[4:5], s4, v1
; GFX9CHECK-NEXT:    s_movk_i32 s6, 0x7fbf
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s6, v0
; GFX9CHECK-NEXT:    v_add_u16_e32 v0, 0xff80, v0
; GFX9CHECK-NEXT:    s_movk_i32 s6, 0x7f00
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cmp_gt_u16_e32 vcc, s6, v0
; GFX9CHECK-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_iszero_or_snan_bf16:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_add_nc_u16 v1, v0, -1
; GFX10CHECK-NEXT:    v_add_nc_u16 v2, v0, 0xff80
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e64 s5, 0x7fbf, v0
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e64 s4, 0x7f, v1
; GFX10CHECK-NEXT:    v_cmp_gt_u16_e64 s6, 0x7f00, v2
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, vcc_lo
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, s5
; GFX10CHECK-NEXT:    s_or_b32 s4, s4, s6
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_iszero_or_snan_bf16:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_add_nc_u16 v1, v0, -1
; GFX11CHECK-NEXT:    v_add_nc_u16 v2, v0, 0xff80
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e64 s1, 0x7fbf, v0
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e64 s0, 0x7f, v1
; GFX11CHECK-NEXT:    v_cmp_gt_u16_e64 s2, 0x7f00, v2
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, vcc_lo
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, s1
; GFX11CHECK-NEXT:    s_or_b32 s0, s0, s2
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 926)  ; ~(0x60|0x1) = "~(zero|snan)"
  ret i1 %0
}

define i1 @isinf_or_nan_bf16(bfloat %x) {
; GFX7CHECK-LABEL: isinf_or_nan_bf16:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f7f
; GFX7CHECK-NEXT:    v_cmp_lt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: isinf_or_nan_bf16:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f7f
; GFX8CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: isinf_or_nan_bf16:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f7f
; GFX9CHECK-NEXT:    v_cmp_lt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: isinf_or_nan_bf16:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f7f, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: isinf_or_nan_bf16:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 0x7f7f, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 519)  ; 0x204|0x3 = "inf|nan"
  ret i1 %0
}

define i1 @not_isinf_or_nan_bf16(bfloat %x) {
; GFX7CHECK-LABEL: not_isinf_or_nan_bf16:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_gt_i32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_isinf_or_nan_bf16:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_isinf_or_nan_bf16:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_gt_i16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_isinf_or_nan_bf16:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_isinf_or_nan_bf16:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_gt_i16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 504)  ; ~(0x204|0x3) = "~(inf|nan)"
  ret i1 %0
}

define i1 @isfinite_or_nan_f(bfloat %x) {
; GFX7CHECK-LABEL: isfinite_or_nan_f:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_ne_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: isfinite_or_nan_f:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_ne_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: isfinite_or_nan_f:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_ne_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: isfinite_or_nan_f:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_ne_u16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: isfinite_or_nan_f:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_ne_u16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 507)  ; 0x1f8|0x3 = "finite|nan"
  ret i1 %0
}

define i1 @not_isfinite_or_nan_f(bfloat %x) {
; GFX7CHECK-LABEL: not_isfinite_or_nan_f:
; GFX7CHECK:       ; %bb.0: ; %entry
; GFX7CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7CHECK-NEXT:    v_bfe_u32 v0, v0, 16, 15
; GFX7CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX7CHECK-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v0
; GFX7CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX7CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8CHECK-LABEL: not_isfinite_or_nan_f:
; GFX8CHECK:       ; %bb.0: ; %entry
; GFX8CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX8CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX8CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX8CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9CHECK-LABEL: not_isfinite_or_nan_f:
; GFX9CHECK:       ; %bb.0: ; %entry
; GFX9CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX9CHECK-NEXT:    s_movk_i32 s4, 0x7f80
; GFX9CHECK-NEXT:    v_cmp_eq_u16_e32 vcc, s4, v0
; GFX9CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10CHECK-LABEL: not_isfinite_or_nan_f:
; GFX10CHECK:       ; %bb.0: ; %entry
; GFX10CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX10CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0x7f80, v0
; GFX10CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10CHECK-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11CHECK-LABEL: not_isfinite_or_nan_f:
; GFX11CHECK:       ; %bb.0: ; %entry
; GFX11CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11CHECK-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11CHECK-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0x7f80, v0
; GFX11CHECK-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11CHECK-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = tail call i1 @llvm.is.fpclass.bf16(bfloat %x, i32 516)  ; ~(0x1f8|0x3) = "~(finite|nan)"
  ret i1 %0
}

declare i1 @llvm.is.fpclass.bf16(bfloat, i32)
declare <2 x i1> @llvm.is.fpclass.v2bf16(<2 x bfloat>, i32)
declare <3 x i1> @llvm.is.fpclass.v3bf16(<3 x bfloat>, i32)
declare <4 x i1> @llvm.is.fpclass.v4bf16(<4 x bfloat>, i32)

; Assume DAZ
attributes #0 = { "denormal-fp-math"="ieee,preserve-sign" }

; Maybe daz
attributes #1 = { "denormal-fp-math"="ieee,dynamic" }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX10SELDAG: {{.*}}
; GFX11SELDAG: {{.*}}
; GFX7SELDAG: {{.*}}
; GFX8SELDAG: {{.*}}
; GFX9SELDAG: {{.*}}
