; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32_NOZBB,RV32I
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV64NOZBB,RV64I
; RUN: llc -mtriple=riscv32 -mattr=+m -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV32_NOZBB,RV32M
; RUN: llc -mtriple=riscv64 -mattr=+m -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV64NOZBB,RV64M
; RUN: llc -mtriple=riscv32 -mattr=+zbb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32ZBB
; RUN: llc -mtriple=riscv64 -mattr=+zbb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64ZBB
; RUN: llc -mtriple=riscv32 -mattr=+xtheadbb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32XTHEADBB
; RUN: llc -mtriple=riscv64 -mattr=+xtheadbb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64XTHEADBB

declare i8 @llvm.cttz.i8(i8, i1)
declare i16 @llvm.cttz.i16(i16, i1)
declare i32 @llvm.cttz.i32(i32, i1)
declare i64 @llvm.cttz.i64(i64, i1)
declare i8 @llvm.ctlz.i8(i8, i1)
declare i16 @llvm.ctlz.i16(i16, i1)
declare i32 @llvm.ctlz.i32(i32, i1)
declare i64 @llvm.ctlz.i64(i64, i1)
declare i8 @llvm.ctpop.i8(i8)
declare i16 @llvm.ctpop.i16(i16)
declare i32 @llvm.ctpop.i32(i32)
declare i64 @llvm.ctpop.i64(i64)

define i8 @test_cttz_i8(i8 %a) nounwind {
; RV32_NOZBB-LABEL: test_cttz_i8:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    andi a1, a0, 255
; RV32_NOZBB-NEXT:    beqz a1, .LBB0_2
; RV32_NOZBB-NEXT:  # %bb.1: # %cond.false
; RV32_NOZBB-NEXT:    addi a1, a0, -1
; RV32_NOZBB-NEXT:    not a0, a0
; RV32_NOZBB-NEXT:    and a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    andi a1, a1, 85
; RV32_NOZBB-NEXT:    sub a0, a0, a1
; RV32_NOZBB-NEXT:    andi a1, a0, 51
; RV32_NOZBB-NEXT:    srli a0, a0, 2
; RV32_NOZBB-NEXT:    andi a0, a0, 51
; RV32_NOZBB-NEXT:    add a0, a1, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    add a0, a0, a1
; RV32_NOZBB-NEXT:    andi a0, a0, 15
; RV32_NOZBB-NEXT:    ret
; RV32_NOZBB-NEXT:  .LBB0_2:
; RV32_NOZBB-NEXT:    li a0, 8
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_cttz_i8:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    andi a1, a0, 255
; RV64NOZBB-NEXT:    beqz a1, .LBB0_2
; RV64NOZBB-NEXT:  # %bb.1: # %cond.false
; RV64NOZBB-NEXT:    addi a1, a0, -1
; RV64NOZBB-NEXT:    not a0, a0
; RV64NOZBB-NEXT:    and a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    andi a1, a1, 85
; RV64NOZBB-NEXT:    subw a0, a0, a1
; RV64NOZBB-NEXT:    andi a1, a0, 51
; RV64NOZBB-NEXT:    srli a0, a0, 2
; RV64NOZBB-NEXT:    andi a0, a0, 51
; RV64NOZBB-NEXT:    add a0, a1, a0
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    add a0, a0, a1
; RV64NOZBB-NEXT:    andi a0, a0, 15
; RV64NOZBB-NEXT:    ret
; RV64NOZBB-NEXT:  .LBB0_2:
; RV64NOZBB-NEXT:    li a0, 8
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_cttz_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ori a0, a0, 256
; RV32ZBB-NEXT:    ctz a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_cttz_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ori a0, a0, 256
; RV64ZBB-NEXT:    ctz a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_cttz_i8:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a1, a0, 255
; RV32XTHEADBB-NEXT:    beqz a1, .LBB0_2
; RV32XTHEADBB-NEXT:  # %bb.1: # %cond.false
; RV32XTHEADBB-NEXT:    addi a1, a0, -1
; RV32XTHEADBB-NEXT:    not a0, a0
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 32
; RV32XTHEADBB-NEXT:    sub a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
; RV32XTHEADBB-NEXT:  .LBB0_2:
; RV32XTHEADBB-NEXT:    li a0, 8
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_cttz_i8:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a1, a0, 255
; RV64XTHEADBB-NEXT:    beqz a1, .LBB0_2
; RV64XTHEADBB-NEXT:  # %bb.1: # %cond.false
; RV64XTHEADBB-NEXT:    addi a1, a0, -1
; RV64XTHEADBB-NEXT:    not a0, a0
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    li a1, 64
; RV64XTHEADBB-NEXT:    sub a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
; RV64XTHEADBB-NEXT:  .LBB0_2:
; RV64XTHEADBB-NEXT:    li a0, 8
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i8 @llvm.cttz.i8(i8 %a, i1 false)
  ret i8 %tmp
}

define i16 @test_cttz_i16(i16 %a) nounwind {
; RV32_NOZBB-LABEL: test_cttz_i16:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    slli a1, a0, 16
; RV32_NOZBB-NEXT:    beqz a1, .LBB1_2
; RV32_NOZBB-NEXT:  # %bb.1: # %cond.false
; RV32_NOZBB-NEXT:    addi a1, a0, -1
; RV32_NOZBB-NEXT:    not a0, a0
; RV32_NOZBB-NEXT:    and a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    lui a2, 5
; RV32_NOZBB-NEXT:    addi a2, a2, 1365
; RV32_NOZBB-NEXT:    and a1, a1, a2
; RV32_NOZBB-NEXT:    sub a0, a0, a1
; RV32_NOZBB-NEXT:    lui a1, 3
; RV32_NOZBB-NEXT:    addi a1, a1, 819
; RV32_NOZBB-NEXT:    and a2, a0, a1
; RV32_NOZBB-NEXT:    srli a0, a0, 2
; RV32_NOZBB-NEXT:    and a0, a0, a1
; RV32_NOZBB-NEXT:    add a0, a2, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    add a0, a0, a1
; RV32_NOZBB-NEXT:    andi a1, a0, 15
; RV32_NOZBB-NEXT:    slli a0, a0, 20
; RV32_NOZBB-NEXT:    srli a0, a0, 28
; RV32_NOZBB-NEXT:    add a0, a1, a0
; RV32_NOZBB-NEXT:    ret
; RV32_NOZBB-NEXT:  .LBB1_2:
; RV32_NOZBB-NEXT:    li a0, 16
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_cttz_i16:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    slli a1, a0, 48
; RV64NOZBB-NEXT:    beqz a1, .LBB1_2
; RV64NOZBB-NEXT:  # %bb.1: # %cond.false
; RV64NOZBB-NEXT:    addi a1, a0, -1
; RV64NOZBB-NEXT:    not a0, a0
; RV64NOZBB-NEXT:    and a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    lui a2, 5
; RV64NOZBB-NEXT:    addiw a2, a2, 1365
; RV64NOZBB-NEXT:    and a1, a1, a2
; RV64NOZBB-NEXT:    sub a0, a0, a1
; RV64NOZBB-NEXT:    lui a1, 3
; RV64NOZBB-NEXT:    addiw a1, a1, 819
; RV64NOZBB-NEXT:    and a2, a0, a1
; RV64NOZBB-NEXT:    srli a0, a0, 2
; RV64NOZBB-NEXT:    and a0, a0, a1
; RV64NOZBB-NEXT:    add a0, a2, a0
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    add a0, a0, a1
; RV64NOZBB-NEXT:    andi a1, a0, 15
; RV64NOZBB-NEXT:    slli a0, a0, 52
; RV64NOZBB-NEXT:    srli a0, a0, 60
; RV64NOZBB-NEXT:    add a0, a1, a0
; RV64NOZBB-NEXT:    ret
; RV64NOZBB-NEXT:  .LBB1_2:
; RV64NOZBB-NEXT:    li a0, 16
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_cttz_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    lui a1, 16
; RV32ZBB-NEXT:    or a0, a0, a1
; RV32ZBB-NEXT:    ctz a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_cttz_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lui a1, 16
; RV64ZBB-NEXT:    or a0, a0, a1
; RV64ZBB-NEXT:    ctz a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_cttz_i16:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    slli a1, a0, 16
; RV32XTHEADBB-NEXT:    beqz a1, .LBB1_2
; RV32XTHEADBB-NEXT:  # %bb.1: # %cond.false
; RV32XTHEADBB-NEXT:    addi a1, a0, -1
; RV32XTHEADBB-NEXT:    not a0, a0
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 32
; RV32XTHEADBB-NEXT:    sub a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
; RV32XTHEADBB-NEXT:  .LBB1_2:
; RV32XTHEADBB-NEXT:    li a0, 16
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_cttz_i16:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    slli a1, a0, 48
; RV64XTHEADBB-NEXT:    beqz a1, .LBB1_2
; RV64XTHEADBB-NEXT:  # %bb.1: # %cond.false
; RV64XTHEADBB-NEXT:    addi a1, a0, -1
; RV64XTHEADBB-NEXT:    not a0, a0
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    li a1, 64
; RV64XTHEADBB-NEXT:    sub a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
; RV64XTHEADBB-NEXT:  .LBB1_2:
; RV64XTHEADBB-NEXT:    li a0, 16
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i16 @llvm.cttz.i16(i16 %a, i1 false)
  ret i16 %tmp
}

define i32 @test_cttz_i32(i32 %a) nounwind {
; RV32I-LABEL: test_cttz_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beqz a0, .LBB2_2
; RV32I-NEXT:  # %bb.1: # %cond.false
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    neg a1, a0
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    lui a1, 30667
; RV32I-NEXT:    addi a1, a1, 1329
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    srli a0, a0, 27
; RV32I-NEXT:    lui a1, %hi(.LCPI2_0)
; RV32I-NEXT:    addi a1, a1, %lo(.LCPI2_0)
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    lbu a0, 0(a0)
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB2_2:
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_cttz_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a1, a0
; RV64I-NEXT:    beqz a1, .LBB2_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    neg a1, a0
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, 30667
; RV64I-NEXT:    addiw a1, a1, 1329
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srliw a0, a0, 27
; RV64I-NEXT:    lui a1, %hi(.LCPI2_0)
; RV64I-NEXT:    addi a1, a1, %lo(.LCPI2_0)
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    lbu a0, 0(a0)
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB2_2:
; RV64I-NEXT:    li a0, 32
; RV64I-NEXT:    ret
;
; RV32M-LABEL: test_cttz_i32:
; RV32M:       # %bb.0:
; RV32M-NEXT:    beqz a0, .LBB2_2
; RV32M-NEXT:  # %bb.1: # %cond.false
; RV32M-NEXT:    neg a1, a0
; RV32M-NEXT:    and a0, a0, a1
; RV32M-NEXT:    lui a1, 30667
; RV32M-NEXT:    addi a1, a1, 1329
; RV32M-NEXT:    mul a0, a0, a1
; RV32M-NEXT:    srli a0, a0, 27
; RV32M-NEXT:    lui a1, %hi(.LCPI2_0)
; RV32M-NEXT:    addi a1, a1, %lo(.LCPI2_0)
; RV32M-NEXT:    add a0, a1, a0
; RV32M-NEXT:    lbu a0, 0(a0)
; RV32M-NEXT:    ret
; RV32M-NEXT:  .LBB2_2:
; RV32M-NEXT:    li a0, 32
; RV32M-NEXT:    ret
;
; RV64M-LABEL: test_cttz_i32:
; RV64M:       # %bb.0:
; RV64M-NEXT:    sext.w a1, a0
; RV64M-NEXT:    beqz a1, .LBB2_2
; RV64M-NEXT:  # %bb.1: # %cond.false
; RV64M-NEXT:    negw a1, a0
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    lui a1, 30667
; RV64M-NEXT:    addi a1, a1, 1329
; RV64M-NEXT:    mul a0, a0, a1
; RV64M-NEXT:    srliw a0, a0, 27
; RV64M-NEXT:    lui a1, %hi(.LCPI2_0)
; RV64M-NEXT:    addi a1, a1, %lo(.LCPI2_0)
; RV64M-NEXT:    add a0, a1, a0
; RV64M-NEXT:    lbu a0, 0(a0)
; RV64M-NEXT:    ret
; RV64M-NEXT:  .LBB2_2:
; RV64M-NEXT:    li a0, 32
; RV64M-NEXT:    ret
;
; RV32ZBB-LABEL: test_cttz_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ctz a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_cttz_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctzw a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_cttz_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    beqz a0, .LBB2_2
; RV32XTHEADBB-NEXT:  # %bb.1: # %cond.false
; RV32XTHEADBB-NEXT:    addi a1, a0, -1
; RV32XTHEADBB-NEXT:    not a0, a0
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 32
; RV32XTHEADBB-NEXT:    sub a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
; RV32XTHEADBB-NEXT:  .LBB2_2:
; RV32XTHEADBB-NEXT:    li a0, 32
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_cttz_i32:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    sext.w a1, a0
; RV64XTHEADBB-NEXT:    beqz a1, .LBB2_2
; RV64XTHEADBB-NEXT:  # %bb.1: # %cond.false
; RV64XTHEADBB-NEXT:    addi a1, a0, -1
; RV64XTHEADBB-NEXT:    not a0, a0
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    li a1, 64
; RV64XTHEADBB-NEXT:    sub a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
; RV64XTHEADBB-NEXT:  .LBB2_2:
; RV64XTHEADBB-NEXT:    li a0, 32
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i32 @llvm.cttz.i32(i32 %a, i1 false)
  ret i32 %tmp
}

define i64 @test_cttz_i64(i64 %a) nounwind {
; RV32I-LABEL: test_cttz_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s2, a1
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    and a0, s0, a0
; RV32I-NEXT:    lui a1, 30667
; RV32I-NEXT:    addi s3, a1, 1329
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui a0, %hi(.LCPI3_0)
; RV32I-NEXT:    addi s4, a0, %lo(.LCPI3_0)
; RV32I-NEXT:    neg a0, s2
; RV32I-NEXT:    and a0, s2, a0
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    bnez s2, .LBB3_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    beqz s0, .LBB3_4
; RV32I-NEXT:  .LBB3_2:
; RV32I-NEXT:    srli s1, s1, 27
; RV32I-NEXT:    add s1, s4, s1
; RV32I-NEXT:    lbu a0, 0(s1)
; RV32I-NEXT:    j .LBB3_5
; RV32I-NEXT:  .LBB3_3:
; RV32I-NEXT:    srli a0, a0, 27
; RV32I-NEXT:    add a0, s4, a0
; RV32I-NEXT:    lbu a0, 0(a0)
; RV32I-NEXT:    bnez s0, .LBB3_2
; RV32I-NEXT:  .LBB3_4:
; RV32I-NEXT:    addi a0, a0, 32
; RV32I-NEXT:  .LBB3_5:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_cttz_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a0, .LBB3_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    neg a1, a0
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, %hi(.LCPI3_0)
; RV64I-NEXT:    ld a1, %lo(.LCPI3_0)(a1)
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srli a0, a0, 58
; RV64I-NEXT:    lui a1, %hi(.LCPI3_1)
; RV64I-NEXT:    addi a1, a1, %lo(.LCPI3_1)
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    lbu a0, 0(a0)
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB3_2:
; RV64I-NEXT:    li a0, 64
; RV64I-NEXT:    ret
;
; RV32M-LABEL: test_cttz_i64:
; RV32M:       # %bb.0:
; RV32M-NEXT:    lui a2, 30667
; RV32M-NEXT:    addi a2, a2, 1329
; RV32M-NEXT:    lui a3, %hi(.LCPI3_0)
; RV32M-NEXT:    addi a3, a3, %lo(.LCPI3_0)
; RV32M-NEXT:    bnez a1, .LBB3_3
; RV32M-NEXT:  # %bb.1:
; RV32M-NEXT:    li a1, 32
; RV32M-NEXT:    beqz a0, .LBB3_4
; RV32M-NEXT:  .LBB3_2:
; RV32M-NEXT:    neg a1, a0
; RV32M-NEXT:    and a0, a0, a1
; RV32M-NEXT:    mul a0, a0, a2
; RV32M-NEXT:    srli a0, a0, 27
; RV32M-NEXT:    add a0, a3, a0
; RV32M-NEXT:    lbu a0, 0(a0)
; RV32M-NEXT:    li a1, 0
; RV32M-NEXT:    ret
; RV32M-NEXT:  .LBB3_3:
; RV32M-NEXT:    neg a4, a1
; RV32M-NEXT:    and a1, a1, a4
; RV32M-NEXT:    mul a1, a1, a2
; RV32M-NEXT:    srli a1, a1, 27
; RV32M-NEXT:    add a1, a3, a1
; RV32M-NEXT:    lbu a1, 0(a1)
; RV32M-NEXT:    bnez a0, .LBB3_2
; RV32M-NEXT:  .LBB3_4:
; RV32M-NEXT:    addi a0, a1, 32
; RV32M-NEXT:    li a1, 0
; RV32M-NEXT:    ret
;
; RV64M-LABEL: test_cttz_i64:
; RV64M:       # %bb.0:
; RV64M-NEXT:    beqz a0, .LBB3_2
; RV64M-NEXT:  # %bb.1: # %cond.false
; RV64M-NEXT:    lui a1, %hi(.LCPI3_0)
; RV64M-NEXT:    ld a1, %lo(.LCPI3_0)(a1)
; RV64M-NEXT:    neg a2, a0
; RV64M-NEXT:    and a0, a0, a2
; RV64M-NEXT:    mul a0, a0, a1
; RV64M-NEXT:    srli a0, a0, 58
; RV64M-NEXT:    lui a1, %hi(.LCPI3_1)
; RV64M-NEXT:    addi a1, a1, %lo(.LCPI3_1)
; RV64M-NEXT:    add a0, a1, a0
; RV64M-NEXT:    lbu a0, 0(a0)
; RV64M-NEXT:    ret
; RV64M-NEXT:  .LBB3_2:
; RV64M-NEXT:    li a0, 64
; RV64M-NEXT:    ret
;
; RV32ZBB-LABEL: test_cttz_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    bnez a0, .LBB3_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    ctz a0, a1
; RV32ZBB-NEXT:    addi a0, a0, 32
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
; RV32ZBB-NEXT:  .LBB3_2:
; RV32ZBB-NEXT:    ctz a0, a0
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_cttz_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctz a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_cttz_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    bnez a0, .LBB3_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    addi a0, a1, -1
; RV32XTHEADBB-NEXT:    not a1, a1
; RV32XTHEADBB-NEXT:    and a0, a1, a0
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 64
; RV32XTHEADBB-NEXT:    j .LBB3_3
; RV32XTHEADBB-NEXT:  .LBB3_2:
; RV32XTHEADBB-NEXT:    addi a1, a0, -1
; RV32XTHEADBB-NEXT:    not a0, a0
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 32
; RV32XTHEADBB-NEXT:  .LBB3_3:
; RV32XTHEADBB-NEXT:    sub a0, a1, a0
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_cttz_i64:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    beqz a0, .LBB3_2
; RV64XTHEADBB-NEXT:  # %bb.1: # %cond.false
; RV64XTHEADBB-NEXT:    addi a1, a0, -1
; RV64XTHEADBB-NEXT:    not a0, a0
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    li a1, 64
; RV64XTHEADBB-NEXT:    sub a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
; RV64XTHEADBB-NEXT:  .LBB3_2:
; RV64XTHEADBB-NEXT:    li a0, 64
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i64 @llvm.cttz.i64(i64 %a, i1 false)
  ret i64 %tmp
}

define i8 @test_cttz_i8_zero_undef(i8 %a) nounwind {
; RV32_NOZBB-LABEL: test_cttz_i8_zero_undef:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    addi a1, a0, -1
; RV32_NOZBB-NEXT:    not a0, a0
; RV32_NOZBB-NEXT:    and a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    andi a1, a1, 85
; RV32_NOZBB-NEXT:    sub a0, a0, a1
; RV32_NOZBB-NEXT:    andi a1, a0, 51
; RV32_NOZBB-NEXT:    srli a0, a0, 2
; RV32_NOZBB-NEXT:    andi a0, a0, 51
; RV32_NOZBB-NEXT:    add a0, a1, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    add a0, a0, a1
; RV32_NOZBB-NEXT:    andi a0, a0, 15
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_cttz_i8_zero_undef:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    addi a1, a0, -1
; RV64NOZBB-NEXT:    not a0, a0
; RV64NOZBB-NEXT:    and a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    andi a1, a1, 85
; RV64NOZBB-NEXT:    subw a0, a0, a1
; RV64NOZBB-NEXT:    andi a1, a0, 51
; RV64NOZBB-NEXT:    srli a0, a0, 2
; RV64NOZBB-NEXT:    andi a0, a0, 51
; RV64NOZBB-NEXT:    add a0, a1, a0
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    add a0, a0, a1
; RV64NOZBB-NEXT:    andi a0, a0, 15
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_cttz_i8_zero_undef:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ctz a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_cttz_i8_zero_undef:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctz a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_cttz_i8_zero_undef:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    addi a1, a0, -1
; RV32XTHEADBB-NEXT:    not a0, a0
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 32
; RV32XTHEADBB-NEXT:    sub a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_cttz_i8_zero_undef:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    addi a1, a0, -1
; RV64XTHEADBB-NEXT:    not a0, a0
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    li a1, 64
; RV64XTHEADBB-NEXT:    sub a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i8 @llvm.cttz.i8(i8 %a, i1 true)
  ret i8 %tmp
}

define i16 @test_cttz_i16_zero_undef(i16 %a) nounwind {
; RV32_NOZBB-LABEL: test_cttz_i16_zero_undef:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    addi a1, a0, -1
; RV32_NOZBB-NEXT:    not a0, a0
; RV32_NOZBB-NEXT:    and a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    lui a2, 5
; RV32_NOZBB-NEXT:    addi a2, a2, 1365
; RV32_NOZBB-NEXT:    and a1, a1, a2
; RV32_NOZBB-NEXT:    sub a0, a0, a1
; RV32_NOZBB-NEXT:    lui a1, 3
; RV32_NOZBB-NEXT:    addi a1, a1, 819
; RV32_NOZBB-NEXT:    and a2, a0, a1
; RV32_NOZBB-NEXT:    srli a0, a0, 2
; RV32_NOZBB-NEXT:    and a0, a0, a1
; RV32_NOZBB-NEXT:    add a0, a2, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    add a0, a0, a1
; RV32_NOZBB-NEXT:    andi a1, a0, 15
; RV32_NOZBB-NEXT:    slli a0, a0, 20
; RV32_NOZBB-NEXT:    srli a0, a0, 28
; RV32_NOZBB-NEXT:    add a0, a1, a0
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_cttz_i16_zero_undef:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    addi a1, a0, -1
; RV64NOZBB-NEXT:    not a0, a0
; RV64NOZBB-NEXT:    and a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    lui a2, 5
; RV64NOZBB-NEXT:    addiw a2, a2, 1365
; RV64NOZBB-NEXT:    and a1, a1, a2
; RV64NOZBB-NEXT:    sub a0, a0, a1
; RV64NOZBB-NEXT:    lui a1, 3
; RV64NOZBB-NEXT:    addiw a1, a1, 819
; RV64NOZBB-NEXT:    and a2, a0, a1
; RV64NOZBB-NEXT:    srli a0, a0, 2
; RV64NOZBB-NEXT:    and a0, a0, a1
; RV64NOZBB-NEXT:    add a0, a2, a0
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    add a0, a0, a1
; RV64NOZBB-NEXT:    andi a1, a0, 15
; RV64NOZBB-NEXT:    slli a0, a0, 52
; RV64NOZBB-NEXT:    srli a0, a0, 60
; RV64NOZBB-NEXT:    add a0, a1, a0
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_cttz_i16_zero_undef:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ctz a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_cttz_i16_zero_undef:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctz a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_cttz_i16_zero_undef:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    addi a1, a0, -1
; RV32XTHEADBB-NEXT:    not a0, a0
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 32
; RV32XTHEADBB-NEXT:    sub a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_cttz_i16_zero_undef:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    addi a1, a0, -1
; RV64XTHEADBB-NEXT:    not a0, a0
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    li a1, 64
; RV64XTHEADBB-NEXT:    sub a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i16 @llvm.cttz.i16(i16 %a, i1 true)
  ret i16 %tmp
}

define i32 @test_cttz_i32_zero_undef(i32 %a) nounwind {
; RV32I-LABEL: test_cttz_i32_zero_undef:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    neg a1, a0
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    lui a1, 30667
; RV32I-NEXT:    addi a1, a1, 1329
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    srli a0, a0, 27
; RV32I-NEXT:    lui a1, %hi(.LCPI6_0)
; RV32I-NEXT:    addi a1, a1, %lo(.LCPI6_0)
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    lbu a0, 0(a0)
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_cttz_i32_zero_undef:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    neg a1, a0
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, 30667
; RV64I-NEXT:    addiw a1, a1, 1329
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srliw a0, a0, 27
; RV64I-NEXT:    lui a1, %hi(.LCPI6_0)
; RV64I-NEXT:    addi a1, a1, %lo(.LCPI6_0)
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    lbu a0, 0(a0)
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32M-LABEL: test_cttz_i32_zero_undef:
; RV32M:       # %bb.0:
; RV32M-NEXT:    neg a1, a0
; RV32M-NEXT:    and a0, a0, a1
; RV32M-NEXT:    lui a1, 30667
; RV32M-NEXT:    addi a1, a1, 1329
; RV32M-NEXT:    mul a0, a0, a1
; RV32M-NEXT:    srli a0, a0, 27
; RV32M-NEXT:    lui a1, %hi(.LCPI6_0)
; RV32M-NEXT:    addi a1, a1, %lo(.LCPI6_0)
; RV32M-NEXT:    add a0, a1, a0
; RV32M-NEXT:    lbu a0, 0(a0)
; RV32M-NEXT:    ret
;
; RV64M-LABEL: test_cttz_i32_zero_undef:
; RV64M:       # %bb.0:
; RV64M-NEXT:    negw a1, a0
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    lui a1, 30667
; RV64M-NEXT:    addi a1, a1, 1329
; RV64M-NEXT:    mul a0, a0, a1
; RV64M-NEXT:    srliw a0, a0, 27
; RV64M-NEXT:    lui a1, %hi(.LCPI6_0)
; RV64M-NEXT:    addi a1, a1, %lo(.LCPI6_0)
; RV64M-NEXT:    add a0, a1, a0
; RV64M-NEXT:    lbu a0, 0(a0)
; RV64M-NEXT:    ret
;
; RV32ZBB-LABEL: test_cttz_i32_zero_undef:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ctz a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_cttz_i32_zero_undef:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctzw a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_cttz_i32_zero_undef:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    addi a1, a0, -1
; RV32XTHEADBB-NEXT:    not a0, a0
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 32
; RV32XTHEADBB-NEXT:    sub a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_cttz_i32_zero_undef:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    addi a1, a0, -1
; RV64XTHEADBB-NEXT:    not a0, a0
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    li a1, 64
; RV64XTHEADBB-NEXT:    sub a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i32 @llvm.cttz.i32(i32 %a, i1 true)
  ret i32 %tmp
}

define i64 @test_cttz_i64_zero_undef(i64 %a) nounwind {
; RV32I-LABEL: test_cttz_i64_zero_undef:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    and a0, s2, a0
; RV32I-NEXT:    lui a1, 30667
; RV32I-NEXT:    addi s3, a1, 1329
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    lui a0, %hi(.LCPI7_0)
; RV32I-NEXT:    addi s4, a0, %lo(.LCPI7_0)
; RV32I-NEXT:    neg a0, s1
; RV32I-NEXT:    and a0, s1, a0
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    bnez s2, .LBB7_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srli a0, a0, 27
; RV32I-NEXT:    add a0, s4, a0
; RV32I-NEXT:    lbu a0, 0(a0)
; RV32I-NEXT:    addi a0, a0, 32
; RV32I-NEXT:    j .LBB7_3
; RV32I-NEXT:  .LBB7_2:
; RV32I-NEXT:    srli s0, s0, 27
; RV32I-NEXT:    add s0, s4, s0
; RV32I-NEXT:    lbu a0, 0(s0)
; RV32I-NEXT:  .LBB7_3:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_cttz_i64_zero_undef:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    neg a1, a0
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, %hi(.LCPI7_0)
; RV64I-NEXT:    ld a1, %lo(.LCPI7_0)(a1)
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srli a0, a0, 58
; RV64I-NEXT:    lui a1, %hi(.LCPI7_1)
; RV64I-NEXT:    addi a1, a1, %lo(.LCPI7_1)
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    lbu a0, 0(a0)
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32M-LABEL: test_cttz_i64_zero_undef:
; RV32M:       # %bb.0:
; RV32M-NEXT:    lui a2, 30667
; RV32M-NEXT:    addi a3, a2, 1329
; RV32M-NEXT:    lui a2, %hi(.LCPI7_0)
; RV32M-NEXT:    addi a2, a2, %lo(.LCPI7_0)
; RV32M-NEXT:    bnez a0, .LBB7_2
; RV32M-NEXT:  # %bb.1:
; RV32M-NEXT:    neg a0, a1
; RV32M-NEXT:    and a0, a1, a0
; RV32M-NEXT:    mul a0, a0, a3
; RV32M-NEXT:    srli a0, a0, 27
; RV32M-NEXT:    add a0, a2, a0
; RV32M-NEXT:    lbu a0, 0(a0)
; RV32M-NEXT:    addi a0, a0, 32
; RV32M-NEXT:    li a1, 0
; RV32M-NEXT:    ret
; RV32M-NEXT:  .LBB7_2:
; RV32M-NEXT:    neg a1, a0
; RV32M-NEXT:    and a0, a0, a1
; RV32M-NEXT:    mul a0, a0, a3
; RV32M-NEXT:    srli a0, a0, 27
; RV32M-NEXT:    add a0, a2, a0
; RV32M-NEXT:    lbu a0, 0(a0)
; RV32M-NEXT:    li a1, 0
; RV32M-NEXT:    ret
;
; RV64M-LABEL: test_cttz_i64_zero_undef:
; RV64M:       # %bb.0:
; RV64M-NEXT:    lui a1, %hi(.LCPI7_0)
; RV64M-NEXT:    ld a1, %lo(.LCPI7_0)(a1)
; RV64M-NEXT:    neg a2, a0
; RV64M-NEXT:    and a0, a0, a2
; RV64M-NEXT:    mul a0, a0, a1
; RV64M-NEXT:    srli a0, a0, 58
; RV64M-NEXT:    lui a1, %hi(.LCPI7_1)
; RV64M-NEXT:    addi a1, a1, %lo(.LCPI7_1)
; RV64M-NEXT:    add a0, a1, a0
; RV64M-NEXT:    lbu a0, 0(a0)
; RV64M-NEXT:    ret
;
; RV32ZBB-LABEL: test_cttz_i64_zero_undef:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    bnez a0, .LBB7_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    ctz a0, a1
; RV32ZBB-NEXT:    addi a0, a0, 32
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
; RV32ZBB-NEXT:  .LBB7_2:
; RV32ZBB-NEXT:    ctz a0, a0
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_cttz_i64_zero_undef:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctz a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_cttz_i64_zero_undef:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    bnez a0, .LBB7_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    addi a0, a1, -1
; RV32XTHEADBB-NEXT:    not a1, a1
; RV32XTHEADBB-NEXT:    and a0, a1, a0
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 64
; RV32XTHEADBB-NEXT:    j .LBB7_3
; RV32XTHEADBB-NEXT:  .LBB7_2:
; RV32XTHEADBB-NEXT:    addi a1, a0, -1
; RV32XTHEADBB-NEXT:    not a0, a0
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    li a1, 32
; RV32XTHEADBB-NEXT:  .LBB7_3:
; RV32XTHEADBB-NEXT:    sub a0, a1, a0
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_cttz_i64_zero_undef:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    addi a1, a0, -1
; RV64XTHEADBB-NEXT:    not a0, a0
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    li a1, 64
; RV64XTHEADBB-NEXT:    sub a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i64 @llvm.cttz.i64(i64 %a, i1 true)
  ret i64 %tmp
}

define i8 @test_ctlz_i8(i8 %a) nounwind {
; RV32_NOZBB-LABEL: test_ctlz_i8:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    andi a1, a0, 255
; RV32_NOZBB-NEXT:    beqz a1, .LBB8_2
; RV32_NOZBB-NEXT:  # %bb.1: # %cond.false
; RV32_NOZBB-NEXT:    slli a1, a0, 24
; RV32_NOZBB-NEXT:    srli a1, a1, 25
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    slli a1, a0, 24
; RV32_NOZBB-NEXT:    srli a1, a1, 26
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    slli a1, a0, 24
; RV32_NOZBB-NEXT:    srli a1, a1, 28
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    not a0, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    andi a1, a1, 85
; RV32_NOZBB-NEXT:    sub a0, a0, a1
; RV32_NOZBB-NEXT:    andi a1, a0, 51
; RV32_NOZBB-NEXT:    srli a0, a0, 2
; RV32_NOZBB-NEXT:    andi a0, a0, 51
; RV32_NOZBB-NEXT:    add a0, a1, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    add a0, a0, a1
; RV32_NOZBB-NEXT:    andi a0, a0, 15
; RV32_NOZBB-NEXT:    ret
; RV32_NOZBB-NEXT:  .LBB8_2:
; RV32_NOZBB-NEXT:    li a0, 8
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_ctlz_i8:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    andi a1, a0, 255
; RV64NOZBB-NEXT:    beqz a1, .LBB8_2
; RV64NOZBB-NEXT:  # %bb.1: # %cond.false
; RV64NOZBB-NEXT:    slli a1, a0, 56
; RV64NOZBB-NEXT:    srli a1, a1, 57
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    slli a1, a0, 56
; RV64NOZBB-NEXT:    srli a1, a1, 58
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    slli a1, a0, 56
; RV64NOZBB-NEXT:    srli a1, a1, 60
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    not a0, a0
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    andi a1, a1, 85
; RV64NOZBB-NEXT:    subw a0, a0, a1
; RV64NOZBB-NEXT:    andi a1, a0, 51
; RV64NOZBB-NEXT:    srli a0, a0, 2
; RV64NOZBB-NEXT:    andi a0, a0, 51
; RV64NOZBB-NEXT:    add a0, a1, a0
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    add a0, a0, a1
; RV64NOZBB-NEXT:    andi a0, a0, 15
; RV64NOZBB-NEXT:    ret
; RV64NOZBB-NEXT:  .LBB8_2:
; RV64NOZBB-NEXT:    li a0, 8
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctlz_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi a0, a0, 255
; RV32ZBB-NEXT:    clz a0, a0
; RV32ZBB-NEXT:    addi a0, a0, -24
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctlz_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    andi a0, a0, 255
; RV64ZBB-NEXT:    clz a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -56
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctlz_i8:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a0, a0, 255
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    addi a0, a0, -24
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctlz_i8:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a0, a0, 255
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    addi a0, a0, -56
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i8 @llvm.ctlz.i8(i8 %a, i1 false)
  ret i8 %tmp
}

define i16 @test_ctlz_i16(i16 %a) nounwind {
; RV32_NOZBB-LABEL: test_ctlz_i16:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    slli a1, a0, 16
; RV32_NOZBB-NEXT:    beqz a1, .LBB9_2
; RV32_NOZBB-NEXT:  # %bb.1: # %cond.false
; RV32_NOZBB-NEXT:    srli a1, a1, 17
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    slli a1, a0, 16
; RV32_NOZBB-NEXT:    srli a1, a1, 18
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    slli a1, a0, 16
; RV32_NOZBB-NEXT:    srli a1, a1, 20
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    slli a1, a0, 16
; RV32_NOZBB-NEXT:    srli a1, a1, 24
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    not a0, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    lui a2, 5
; RV32_NOZBB-NEXT:    addi a2, a2, 1365
; RV32_NOZBB-NEXT:    and a1, a1, a2
; RV32_NOZBB-NEXT:    sub a0, a0, a1
; RV32_NOZBB-NEXT:    lui a1, 3
; RV32_NOZBB-NEXT:    addi a1, a1, 819
; RV32_NOZBB-NEXT:    and a2, a0, a1
; RV32_NOZBB-NEXT:    srli a0, a0, 2
; RV32_NOZBB-NEXT:    and a0, a0, a1
; RV32_NOZBB-NEXT:    add a0, a2, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    add a0, a0, a1
; RV32_NOZBB-NEXT:    andi a1, a0, 15
; RV32_NOZBB-NEXT:    slli a0, a0, 20
; RV32_NOZBB-NEXT:    srli a0, a0, 28
; RV32_NOZBB-NEXT:    add a0, a1, a0
; RV32_NOZBB-NEXT:    ret
; RV32_NOZBB-NEXT:  .LBB9_2:
; RV32_NOZBB-NEXT:    li a0, 16
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_ctlz_i16:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    slli a1, a0, 48
; RV64NOZBB-NEXT:    beqz a1, .LBB9_2
; RV64NOZBB-NEXT:  # %bb.1: # %cond.false
; RV64NOZBB-NEXT:    srli a1, a1, 49
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    slli a1, a0, 48
; RV64NOZBB-NEXT:    srli a1, a1, 50
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    slli a1, a0, 48
; RV64NOZBB-NEXT:    srli a1, a1, 52
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    slli a1, a0, 48
; RV64NOZBB-NEXT:    srli a1, a1, 56
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    not a0, a0
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    lui a2, 5
; RV64NOZBB-NEXT:    addiw a2, a2, 1365
; RV64NOZBB-NEXT:    and a1, a1, a2
; RV64NOZBB-NEXT:    sub a0, a0, a1
; RV64NOZBB-NEXT:    lui a1, 3
; RV64NOZBB-NEXT:    addiw a1, a1, 819
; RV64NOZBB-NEXT:    and a2, a0, a1
; RV64NOZBB-NEXT:    srli a0, a0, 2
; RV64NOZBB-NEXT:    and a0, a0, a1
; RV64NOZBB-NEXT:    add a0, a2, a0
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    add a0, a0, a1
; RV64NOZBB-NEXT:    andi a1, a0, 15
; RV64NOZBB-NEXT:    slli a0, a0, 52
; RV64NOZBB-NEXT:    srli a0, a0, 60
; RV64NOZBB-NEXT:    add a0, a1, a0
; RV64NOZBB-NEXT:    ret
; RV64NOZBB-NEXT:  .LBB9_2:
; RV64NOZBB-NEXT:    li a0, 16
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctlz_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    clz a0, a0
; RV32ZBB-NEXT:    addi a0, a0, -16
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctlz_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    clz a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -48
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctlz_i16:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.extu a0, a0, 15, 0
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    addi a0, a0, -16
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctlz_i16:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    th.extu a0, a0, 15, 0
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    addi a0, a0, -48
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i16 @llvm.ctlz.i16(i16 %a, i1 false)
  ret i16 %tmp
}

define i32 @test_ctlz_i32(i32 %a) nounwind {
; RV32I-LABEL: test_ctlz_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beqz a0, .LBB10_2
; RV32I-NEXT:  # %bb.1: # %cond.false
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    lui a1, 209715
; RV32I-NEXT:    addi a1, a1, 819
; RV32I-NEXT:    and a2, a0, a1
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lui a1, 61681
; RV32I-NEXT:    addi a1, a1, -241
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    lui a1, 4112
; RV32I-NEXT:    addi a1, a1, 257
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB10_2:
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_ctlz_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a1, a0
; RV64I-NEXT:    beqz a1, .LBB10_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    srliw a1, a0, 1
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srliw a1, a0, 2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srliw a1, a0, 4
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srliw a1, a0, 8
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srliw a1, a0, 16
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    addiw a2, a2, 1365
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    and a2, a0, a1
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    add a0, a2, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    lui a1, 61681
; RV64I-NEXT:    addiw a1, a1, -241
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, 4112
; RV64I-NEXT:    addiw a1, a1, 257
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srliw a0, a0, 24
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB10_2:
; RV64I-NEXT:    li a0, 32
; RV64I-NEXT:    ret
;
; RV32M-LABEL: test_ctlz_i32:
; RV32M:       # %bb.0:
; RV32M-NEXT:    beqz a0, .LBB10_2
; RV32M-NEXT:  # %bb.1: # %cond.false
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 2
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 8
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 16
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    not a0, a0
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    lui a2, 349525
; RV32M-NEXT:    addi a2, a2, 1365
; RV32M-NEXT:    and a1, a1, a2
; RV32M-NEXT:    sub a0, a0, a1
; RV32M-NEXT:    lui a1, 209715
; RV32M-NEXT:    addi a1, a1, 819
; RV32M-NEXT:    and a2, a0, a1
; RV32M-NEXT:    srli a0, a0, 2
; RV32M-NEXT:    and a0, a0, a1
; RV32M-NEXT:    add a0, a2, a0
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    add a0, a0, a1
; RV32M-NEXT:    lui a1, 61681
; RV32M-NEXT:    addi a1, a1, -241
; RV32M-NEXT:    and a0, a0, a1
; RV32M-NEXT:    lui a1, 4112
; RV32M-NEXT:    addi a1, a1, 257
; RV32M-NEXT:    mul a0, a0, a1
; RV32M-NEXT:    srli a0, a0, 24
; RV32M-NEXT:    ret
; RV32M-NEXT:  .LBB10_2:
; RV32M-NEXT:    li a0, 32
; RV32M-NEXT:    ret
;
; RV64M-LABEL: test_ctlz_i32:
; RV64M:       # %bb.0:
; RV64M-NEXT:    sext.w a1, a0
; RV64M-NEXT:    beqz a1, .LBB10_2
; RV64M-NEXT:  # %bb.1: # %cond.false
; RV64M-NEXT:    srliw a1, a0, 1
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srliw a1, a0, 2
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srliw a1, a0, 4
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srliw a1, a0, 8
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srliw a1, a0, 16
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    not a0, a0
; RV64M-NEXT:    srli a1, a0, 1
; RV64M-NEXT:    lui a2, 349525
; RV64M-NEXT:    addiw a2, a2, 1365
; RV64M-NEXT:    and a1, a1, a2
; RV64M-NEXT:    sub a0, a0, a1
; RV64M-NEXT:    lui a1, 209715
; RV64M-NEXT:    addiw a1, a1, 819
; RV64M-NEXT:    and a2, a0, a1
; RV64M-NEXT:    srli a0, a0, 2
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    add a0, a2, a0
; RV64M-NEXT:    srli a1, a0, 4
; RV64M-NEXT:    add a0, a0, a1
; RV64M-NEXT:    lui a1, 61681
; RV64M-NEXT:    addi a1, a1, -241
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    lui a1, 4112
; RV64M-NEXT:    addi a1, a1, 257
; RV64M-NEXT:    mul a0, a0, a1
; RV64M-NEXT:    srliw a0, a0, 24
; RV64M-NEXT:    ret
; RV64M-NEXT:  .LBB10_2:
; RV64M-NEXT:    li a0, 32
; RV64M-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctlz_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    clz a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctlz_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    clzw a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctlz_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctlz_i32:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    not a0, a0
; RV64XTHEADBB-NEXT:    slli a0, a0, 32
; RV64XTHEADBB-NEXT:    th.ff0 a0, a0
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
  ret i32 %tmp
}

define i64 @test_ctlz_i64(i64 %a) nounwind {
; RV32I-LABEL: test_ctlz_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    srli a0, a1, 1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi s4, a2, 1365
; RV32I-NEXT:    and a1, a1, s4
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    lui a1, 209715
; RV32I-NEXT:    addi s5, a1, 819
; RV32I-NEXT:    and a1, a0, s5
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, s5
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lui a1, 61681
; RV32I-NEXT:    addi s6, a1, -241
; RV32I-NEXT:    and a0, a0, s6
; RV32I-NEXT:    lui a1, 4112
; RV32I-NEXT:    addi s3, a1, 257
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    srli a0, s2, 1
; RV32I-NEXT:    or a0, s2, a0
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    and a1, a1, s4
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    and a1, a0, s5
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, s5
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    and a0, a0, s6
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    bnez s0, .LBB11_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    addi a0, a0, 32
; RV32I-NEXT:    j .LBB11_3
; RV32I-NEXT:  .LBB11_2:
; RV32I-NEXT:    srli a0, s1, 24
; RV32I-NEXT:  .LBB11_3:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_ctlz_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a0, .LBB11_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srli a1, a0, 2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srli a1, a0, 8
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    addiw a2, a2, 1365
; RV64I-NEXT:    slli a3, a2, 32
; RV64I-NEXT:    add a2, a2, a3
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    slli a2, a1, 32
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    and a2, a0, a1
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    add a0, a2, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    lui a1, 61681
; RV64I-NEXT:    addiw a1, a1, -241
; RV64I-NEXT:    slli a2, a1, 32
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, 4112
; RV64I-NEXT:    addiw a1, a1, 257
; RV64I-NEXT:    slli a2, a1, 32
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srli a0, a0, 56
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB11_2:
; RV64I-NEXT:    li a0, 64
; RV64I-NEXT:    ret
;
; RV32M-LABEL: test_ctlz_i64:
; RV32M:       # %bb.0:
; RV32M-NEXT:    lui a2, 349525
; RV32M-NEXT:    addi a5, a2, 1365
; RV32M-NEXT:    lui a2, 209715
; RV32M-NEXT:    addi a4, a2, 819
; RV32M-NEXT:    lui a2, 61681
; RV32M-NEXT:    addi a2, a2, -241
; RV32M-NEXT:    lui a3, 4112
; RV32M-NEXT:    addi a3, a3, 257
; RV32M-NEXT:    bnez a1, .LBB11_2
; RV32M-NEXT:  # %bb.1:
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 2
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 8
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 16
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    not a0, a0
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    and a1, a1, a5
; RV32M-NEXT:    sub a0, a0, a1
; RV32M-NEXT:    and a1, a0, a4
; RV32M-NEXT:    srli a0, a0, 2
; RV32M-NEXT:    and a0, a0, a4
; RV32M-NEXT:    add a0, a1, a0
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    add a0, a0, a1
; RV32M-NEXT:    and a0, a0, a2
; RV32M-NEXT:    mul a0, a0, a3
; RV32M-NEXT:    srli a0, a0, 24
; RV32M-NEXT:    addi a0, a0, 32
; RV32M-NEXT:    li a1, 0
; RV32M-NEXT:    ret
; RV32M-NEXT:  .LBB11_2:
; RV32M-NEXT:    srli a0, a1, 1
; RV32M-NEXT:    or a0, a1, a0
; RV32M-NEXT:    srli a1, a0, 2
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 8
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 16
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    not a0, a0
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    and a1, a1, a5
; RV32M-NEXT:    sub a0, a0, a1
; RV32M-NEXT:    and a1, a0, a4
; RV32M-NEXT:    srli a0, a0, 2
; RV32M-NEXT:    and a0, a0, a4
; RV32M-NEXT:    add a0, a1, a0
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    add a0, a0, a1
; RV32M-NEXT:    and a0, a0, a2
; RV32M-NEXT:    mul a0, a0, a3
; RV32M-NEXT:    srli a0, a0, 24
; RV32M-NEXT:    li a1, 0
; RV32M-NEXT:    ret
;
; RV64M-LABEL: test_ctlz_i64:
; RV64M:       # %bb.0:
; RV64M-NEXT:    beqz a0, .LBB11_2
; RV64M-NEXT:  # %bb.1: # %cond.false
; RV64M-NEXT:    srli a1, a0, 1
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srli a1, a0, 2
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srli a1, a0, 4
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srli a1, a0, 8
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srli a1, a0, 16
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srli a1, a0, 32
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    not a0, a0
; RV64M-NEXT:    srli a1, a0, 1
; RV64M-NEXT:    lui a2, 349525
; RV64M-NEXT:    addiw a2, a2, 1365
; RV64M-NEXT:    slli a3, a2, 32
; RV64M-NEXT:    add a2, a2, a3
; RV64M-NEXT:    and a1, a1, a2
; RV64M-NEXT:    sub a0, a0, a1
; RV64M-NEXT:    lui a1, 209715
; RV64M-NEXT:    addiw a1, a1, 819
; RV64M-NEXT:    slli a2, a1, 32
; RV64M-NEXT:    add a1, a1, a2
; RV64M-NEXT:    and a2, a0, a1
; RV64M-NEXT:    srli a0, a0, 2
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    add a0, a2, a0
; RV64M-NEXT:    srli a1, a0, 4
; RV64M-NEXT:    add a0, a0, a1
; RV64M-NEXT:    lui a1, 61681
; RV64M-NEXT:    addiw a1, a1, -241
; RV64M-NEXT:    slli a2, a1, 32
; RV64M-NEXT:    add a1, a1, a2
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    lui a1, 4112
; RV64M-NEXT:    addiw a1, a1, 257
; RV64M-NEXT:    slli a2, a1, 32
; RV64M-NEXT:    add a1, a1, a2
; RV64M-NEXT:    mul a0, a0, a1
; RV64M-NEXT:    srli a0, a0, 56
; RV64M-NEXT:    ret
; RV64M-NEXT:  .LBB11_2:
; RV64M-NEXT:    li a0, 64
; RV64M-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctlz_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    bnez a1, .LBB11_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    clz a0, a0
; RV32ZBB-NEXT:    addi a0, a0, 32
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
; RV32ZBB-NEXT:  .LBB11_2:
; RV32ZBB-NEXT:    clz a0, a1
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctlz_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    clz a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctlz_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    bnez a1, .LBB11_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    addi a0, a0, 32
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
; RV32XTHEADBB-NEXT:  .LBB11_2:
; RV32XTHEADBB-NEXT:    th.ff1 a0, a1
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctlz_i64:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i64 @llvm.ctlz.i64(i64 %a, i1 false)
  ret i64 %tmp
}

define i8 @test_ctlz_i8_zero_undef(i8 %a) nounwind {
; RV32_NOZBB-LABEL: test_ctlz_i8_zero_undef:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    slli a1, a0, 24
; RV32_NOZBB-NEXT:    srli a1, a1, 25
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    slli a1, a0, 24
; RV32_NOZBB-NEXT:    srli a1, a1, 26
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    slli a1, a0, 24
; RV32_NOZBB-NEXT:    srli a1, a1, 28
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    not a0, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    andi a1, a1, 85
; RV32_NOZBB-NEXT:    sub a0, a0, a1
; RV32_NOZBB-NEXT:    andi a1, a0, 51
; RV32_NOZBB-NEXT:    srli a0, a0, 2
; RV32_NOZBB-NEXT:    andi a0, a0, 51
; RV32_NOZBB-NEXT:    add a0, a1, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    add a0, a0, a1
; RV32_NOZBB-NEXT:    andi a0, a0, 15
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_ctlz_i8_zero_undef:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    slli a1, a0, 56
; RV64NOZBB-NEXT:    srli a1, a1, 57
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    slli a1, a0, 56
; RV64NOZBB-NEXT:    srli a1, a1, 58
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    slli a1, a0, 56
; RV64NOZBB-NEXT:    srli a1, a1, 60
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    not a0, a0
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    andi a1, a1, 85
; RV64NOZBB-NEXT:    subw a0, a0, a1
; RV64NOZBB-NEXT:    andi a1, a0, 51
; RV64NOZBB-NEXT:    srli a0, a0, 2
; RV64NOZBB-NEXT:    andi a0, a0, 51
; RV64NOZBB-NEXT:    add a0, a1, a0
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    add a0, a0, a1
; RV64NOZBB-NEXT:    andi a0, a0, 15
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctlz_i8_zero_undef:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi a0, a0, 255
; RV32ZBB-NEXT:    clz a0, a0
; RV32ZBB-NEXT:    addi a0, a0, -24
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctlz_i8_zero_undef:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    andi a0, a0, 255
; RV64ZBB-NEXT:    clz a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -56
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctlz_i8_zero_undef:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a0, a0, 255
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    addi a0, a0, -24
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctlz_i8_zero_undef:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a0, a0, 255
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    addi a0, a0, -56
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i8 @llvm.ctlz.i8(i8 %a, i1 true)
  ret i8 %tmp
}

define i16 @test_ctlz_i16_zero_undef(i16 %a) nounwind {
; RV32_NOZBB-LABEL: test_ctlz_i16_zero_undef:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    slli a1, a0, 16
; RV32_NOZBB-NEXT:    srli a1, a1, 17
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    slli a1, a0, 16
; RV32_NOZBB-NEXT:    srli a1, a1, 18
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    slli a1, a0, 16
; RV32_NOZBB-NEXT:    srli a1, a1, 20
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    slli a1, a0, 16
; RV32_NOZBB-NEXT:    srli a1, a1, 24
; RV32_NOZBB-NEXT:    or a0, a0, a1
; RV32_NOZBB-NEXT:    not a0, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    lui a2, 5
; RV32_NOZBB-NEXT:    addi a2, a2, 1365
; RV32_NOZBB-NEXT:    and a1, a1, a2
; RV32_NOZBB-NEXT:    sub a0, a0, a1
; RV32_NOZBB-NEXT:    lui a1, 3
; RV32_NOZBB-NEXT:    addi a1, a1, 819
; RV32_NOZBB-NEXT:    and a2, a0, a1
; RV32_NOZBB-NEXT:    srli a0, a0, 2
; RV32_NOZBB-NEXT:    and a0, a0, a1
; RV32_NOZBB-NEXT:    add a0, a2, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    add a0, a0, a1
; RV32_NOZBB-NEXT:    andi a1, a0, 15
; RV32_NOZBB-NEXT:    slli a0, a0, 20
; RV32_NOZBB-NEXT:    srli a0, a0, 28
; RV32_NOZBB-NEXT:    add a0, a1, a0
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_ctlz_i16_zero_undef:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    slli a1, a0, 48
; RV64NOZBB-NEXT:    srli a1, a1, 49
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    slli a1, a0, 48
; RV64NOZBB-NEXT:    srli a1, a1, 50
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    slli a1, a0, 48
; RV64NOZBB-NEXT:    srli a1, a1, 52
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    slli a1, a0, 48
; RV64NOZBB-NEXT:    srli a1, a1, 56
; RV64NOZBB-NEXT:    or a0, a0, a1
; RV64NOZBB-NEXT:    not a0, a0
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    lui a2, 5
; RV64NOZBB-NEXT:    addiw a2, a2, 1365
; RV64NOZBB-NEXT:    and a1, a1, a2
; RV64NOZBB-NEXT:    sub a0, a0, a1
; RV64NOZBB-NEXT:    lui a1, 3
; RV64NOZBB-NEXT:    addiw a1, a1, 819
; RV64NOZBB-NEXT:    and a2, a0, a1
; RV64NOZBB-NEXT:    srli a0, a0, 2
; RV64NOZBB-NEXT:    and a0, a0, a1
; RV64NOZBB-NEXT:    add a0, a2, a0
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    add a0, a0, a1
; RV64NOZBB-NEXT:    andi a1, a0, 15
; RV64NOZBB-NEXT:    slli a0, a0, 52
; RV64NOZBB-NEXT:    srli a0, a0, 60
; RV64NOZBB-NEXT:    add a0, a1, a0
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctlz_i16_zero_undef:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    clz a0, a0
; RV32ZBB-NEXT:    addi a0, a0, -16
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctlz_i16_zero_undef:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    clz a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -48
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctlz_i16_zero_undef:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.extu a0, a0, 15, 0
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    addi a0, a0, -16
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctlz_i16_zero_undef:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    th.extu a0, a0, 15, 0
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    addi a0, a0, -48
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i16 @llvm.ctlz.i16(i16 %a, i1 true)
  ret i16 %tmp
}

define i32 @test_ctlz_i32_zero_undef(i32 %a) nounwind {
; RV32I-LABEL: test_ctlz_i32_zero_undef:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    lui a1, 209715
; RV32I-NEXT:    addi a1, a1, 819
; RV32I-NEXT:    and a2, a0, a1
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lui a1, 61681
; RV32I-NEXT:    addi a1, a1, -241
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    lui a1, 4112
; RV32I-NEXT:    addi a1, a1, 257
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_ctlz_i32_zero_undef:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    srliw a1, a0, 1
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srliw a1, a0, 2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srliw a1, a0, 4
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srliw a1, a0, 8
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srliw a1, a0, 16
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    addiw a2, a2, 1365
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    and a2, a0, a1
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    add a0, a2, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    lui a1, 61681
; RV64I-NEXT:    addiw a1, a1, -241
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, 4112
; RV64I-NEXT:    addiw a1, a1, 257
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srliw a0, a0, 24
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32M-LABEL: test_ctlz_i32_zero_undef:
; RV32M:       # %bb.0:
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 2
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 8
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 16
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    not a0, a0
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    lui a2, 349525
; RV32M-NEXT:    addi a2, a2, 1365
; RV32M-NEXT:    and a1, a1, a2
; RV32M-NEXT:    sub a0, a0, a1
; RV32M-NEXT:    lui a1, 209715
; RV32M-NEXT:    addi a1, a1, 819
; RV32M-NEXT:    and a2, a0, a1
; RV32M-NEXT:    srli a0, a0, 2
; RV32M-NEXT:    and a0, a0, a1
; RV32M-NEXT:    add a0, a2, a0
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    add a0, a0, a1
; RV32M-NEXT:    lui a1, 61681
; RV32M-NEXT:    addi a1, a1, -241
; RV32M-NEXT:    and a0, a0, a1
; RV32M-NEXT:    lui a1, 4112
; RV32M-NEXT:    addi a1, a1, 257
; RV32M-NEXT:    mul a0, a0, a1
; RV32M-NEXT:    srli a0, a0, 24
; RV32M-NEXT:    ret
;
; RV64M-LABEL: test_ctlz_i32_zero_undef:
; RV64M:       # %bb.0:
; RV64M-NEXT:    srliw a1, a0, 1
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srliw a1, a0, 2
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srliw a1, a0, 4
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srliw a1, a0, 8
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srliw a1, a0, 16
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    not a0, a0
; RV64M-NEXT:    srli a1, a0, 1
; RV64M-NEXT:    lui a2, 349525
; RV64M-NEXT:    addiw a2, a2, 1365
; RV64M-NEXT:    and a1, a1, a2
; RV64M-NEXT:    sub a0, a0, a1
; RV64M-NEXT:    lui a1, 209715
; RV64M-NEXT:    addiw a1, a1, 819
; RV64M-NEXT:    and a2, a0, a1
; RV64M-NEXT:    srli a0, a0, 2
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    add a0, a2, a0
; RV64M-NEXT:    srli a1, a0, 4
; RV64M-NEXT:    add a0, a0, a1
; RV64M-NEXT:    lui a1, 61681
; RV64M-NEXT:    addi a1, a1, -241
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    lui a1, 4112
; RV64M-NEXT:    addi a1, a1, 257
; RV64M-NEXT:    mul a0, a0, a1
; RV64M-NEXT:    srliw a0, a0, 24
; RV64M-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctlz_i32_zero_undef:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    clz a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctlz_i32_zero_undef:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    clzw a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctlz_i32_zero_undef:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctlz_i32_zero_undef:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    not a0, a0
; RV64XTHEADBB-NEXT:    slli a0, a0, 32
; RV64XTHEADBB-NEXT:    th.ff0 a0, a0
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i32 @llvm.ctlz.i32(i32 %a, i1 true)
  ret i32 %tmp
}

define i64 @test_ctlz_i64_zero_undef(i64 %a) nounwind {
; RV32I-LABEL: test_ctlz_i64_zero_undef:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    srli a0, a1, 1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi s4, a2, 1365
; RV32I-NEXT:    and a1, a1, s4
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    lui a1, 209715
; RV32I-NEXT:    addi s5, a1, 819
; RV32I-NEXT:    and a1, a0, s5
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, s5
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lui a1, 61681
; RV32I-NEXT:    addi s6, a1, -241
; RV32I-NEXT:    and a0, a0, s6
; RV32I-NEXT:    lui a1, 4112
; RV32I-NEXT:    addi s3, a1, 257
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    srli a0, s2, 1
; RV32I-NEXT:    or a0, s2, a0
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    and a1, a1, s4
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    and a1, a0, s5
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, s5
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    and a0, a0, s6
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    bnez s0, .LBB15_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    addi a0, a0, 32
; RV32I-NEXT:    j .LBB15_3
; RV32I-NEXT:  .LBB15_2:
; RV32I-NEXT:    srli a0, s1, 24
; RV32I-NEXT:  .LBB15_3:
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_ctlz_i64_zero_undef:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srli a1, a0, 2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srli a1, a0, 8
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    addiw a2, a2, 1365
; RV64I-NEXT:    slli a3, a2, 32
; RV64I-NEXT:    add a2, a2, a3
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    slli a2, a1, 32
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    and a2, a0, a1
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    add a0, a2, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    lui a1, 61681
; RV64I-NEXT:    addiw a1, a1, -241
; RV64I-NEXT:    slli a2, a1, 32
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, 4112
; RV64I-NEXT:    addiw a1, a1, 257
; RV64I-NEXT:    slli a2, a1, 32
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srli a0, a0, 56
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32M-LABEL: test_ctlz_i64_zero_undef:
; RV32M:       # %bb.0:
; RV32M-NEXT:    lui a2, 349525
; RV32M-NEXT:    addi a5, a2, 1365
; RV32M-NEXT:    lui a2, 209715
; RV32M-NEXT:    addi a4, a2, 819
; RV32M-NEXT:    lui a2, 61681
; RV32M-NEXT:    addi a2, a2, -241
; RV32M-NEXT:    lui a3, 4112
; RV32M-NEXT:    addi a3, a3, 257
; RV32M-NEXT:    bnez a1, .LBB15_2
; RV32M-NEXT:  # %bb.1:
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 2
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 8
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 16
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    not a0, a0
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    and a1, a1, a5
; RV32M-NEXT:    sub a0, a0, a1
; RV32M-NEXT:    and a1, a0, a4
; RV32M-NEXT:    srli a0, a0, 2
; RV32M-NEXT:    and a0, a0, a4
; RV32M-NEXT:    add a0, a1, a0
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    add a0, a0, a1
; RV32M-NEXT:    and a0, a0, a2
; RV32M-NEXT:    mul a0, a0, a3
; RV32M-NEXT:    srli a0, a0, 24
; RV32M-NEXT:    addi a0, a0, 32
; RV32M-NEXT:    li a1, 0
; RV32M-NEXT:    ret
; RV32M-NEXT:  .LBB15_2:
; RV32M-NEXT:    srli a0, a1, 1
; RV32M-NEXT:    or a0, a1, a0
; RV32M-NEXT:    srli a1, a0, 2
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 8
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    srli a1, a0, 16
; RV32M-NEXT:    or a0, a0, a1
; RV32M-NEXT:    not a0, a0
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    and a1, a1, a5
; RV32M-NEXT:    sub a0, a0, a1
; RV32M-NEXT:    and a1, a0, a4
; RV32M-NEXT:    srli a0, a0, 2
; RV32M-NEXT:    and a0, a0, a4
; RV32M-NEXT:    add a0, a1, a0
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    add a0, a0, a1
; RV32M-NEXT:    and a0, a0, a2
; RV32M-NEXT:    mul a0, a0, a3
; RV32M-NEXT:    srli a0, a0, 24
; RV32M-NEXT:    li a1, 0
; RV32M-NEXT:    ret
;
; RV64M-LABEL: test_ctlz_i64_zero_undef:
; RV64M:       # %bb.0:
; RV64M-NEXT:    srli a1, a0, 1
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srli a1, a0, 2
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srli a1, a0, 4
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srli a1, a0, 8
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srli a1, a0, 16
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    srli a1, a0, 32
; RV64M-NEXT:    or a0, a0, a1
; RV64M-NEXT:    not a0, a0
; RV64M-NEXT:    srli a1, a0, 1
; RV64M-NEXT:    lui a2, 349525
; RV64M-NEXT:    addiw a2, a2, 1365
; RV64M-NEXT:    slli a3, a2, 32
; RV64M-NEXT:    add a2, a2, a3
; RV64M-NEXT:    and a1, a1, a2
; RV64M-NEXT:    sub a0, a0, a1
; RV64M-NEXT:    lui a1, 209715
; RV64M-NEXT:    addiw a1, a1, 819
; RV64M-NEXT:    slli a2, a1, 32
; RV64M-NEXT:    add a1, a1, a2
; RV64M-NEXT:    and a2, a0, a1
; RV64M-NEXT:    srli a0, a0, 2
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    add a0, a2, a0
; RV64M-NEXT:    srli a1, a0, 4
; RV64M-NEXT:    add a0, a0, a1
; RV64M-NEXT:    lui a1, 61681
; RV64M-NEXT:    addiw a1, a1, -241
; RV64M-NEXT:    slli a2, a1, 32
; RV64M-NEXT:    add a1, a1, a2
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    lui a1, 4112
; RV64M-NEXT:    addiw a1, a1, 257
; RV64M-NEXT:    slli a2, a1, 32
; RV64M-NEXT:    add a1, a1, a2
; RV64M-NEXT:    mul a0, a0, a1
; RV64M-NEXT:    srli a0, a0, 56
; RV64M-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctlz_i64_zero_undef:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    bnez a1, .LBB15_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    clz a0, a0
; RV32ZBB-NEXT:    addi a0, a0, 32
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
; RV32ZBB-NEXT:  .LBB15_2:
; RV32ZBB-NEXT:    clz a0, a1
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctlz_i64_zero_undef:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    clz a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctlz_i64_zero_undef:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    bnez a1, .LBB15_2
; RV32XTHEADBB-NEXT:  # %bb.1:
; RV32XTHEADBB-NEXT:    th.ff1 a0, a0
; RV32XTHEADBB-NEXT:    addi a0, a0, 32
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
; RV32XTHEADBB-NEXT:  .LBB15_2:
; RV32XTHEADBB-NEXT:    th.ff1 a0, a1
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctlz_i64_zero_undef:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    th.ff1 a0, a0
; RV64XTHEADBB-NEXT:    ret
  %tmp = call i64 @llvm.ctlz.i64(i64 %a, i1 true)
  ret i64 %tmp
}

define i8 @test_ctpop_i8(i8 %a) nounwind {
; RV32_NOZBB-LABEL: test_ctpop_i8:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    andi a1, a1, 85
; RV32_NOZBB-NEXT:    sub a0, a0, a1
; RV32_NOZBB-NEXT:    andi a1, a0, 51
; RV32_NOZBB-NEXT:    srli a0, a0, 2
; RV32_NOZBB-NEXT:    andi a0, a0, 51
; RV32_NOZBB-NEXT:    add a0, a1, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    add a0, a0, a1
; RV32_NOZBB-NEXT:    andi a0, a0, 15
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_ctpop_i8:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    andi a1, a1, 85
; RV64NOZBB-NEXT:    subw a0, a0, a1
; RV64NOZBB-NEXT:    andi a1, a0, 51
; RV64NOZBB-NEXT:    srli a0, a0, 2
; RV64NOZBB-NEXT:    andi a0, a0, 51
; RV64NOZBB-NEXT:    add a0, a1, a0
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    add a0, a0, a1
; RV64NOZBB-NEXT:    andi a0, a0, 15
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctpop_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi a0, a0, 255
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctpop_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    andi a0, a0, 255
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctpop_i8:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    srli a1, a0, 1
; RV32XTHEADBB-NEXT:    andi a1, a1, 85
; RV32XTHEADBB-NEXT:    sub a0, a0, a1
; RV32XTHEADBB-NEXT:    andi a1, a0, 51
; RV32XTHEADBB-NEXT:    srli a0, a0, 2
; RV32XTHEADBB-NEXT:    andi a0, a0, 51
; RV32XTHEADBB-NEXT:    add a0, a1, a0
; RV32XTHEADBB-NEXT:    srli a1, a0, 4
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    andi a0, a0, 15
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctpop_i8:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    srli a1, a0, 1
; RV64XTHEADBB-NEXT:    andi a1, a1, 85
; RV64XTHEADBB-NEXT:    subw a0, a0, a1
; RV64XTHEADBB-NEXT:    andi a1, a0, 51
; RV64XTHEADBB-NEXT:    srli a0, a0, 2
; RV64XTHEADBB-NEXT:    andi a0, a0, 51
; RV64XTHEADBB-NEXT:    add a0, a1, a0
; RV64XTHEADBB-NEXT:    srli a1, a0, 4
; RV64XTHEADBB-NEXT:    add a0, a0, a1
; RV64XTHEADBB-NEXT:    andi a0, a0, 15
; RV64XTHEADBB-NEXT:    ret
  %1 = call i8 @llvm.ctpop.i8(i8 %a)
  ret i8 %1
}

define i16 @test_ctpop_i16(i16 %a) nounwind {
; RV32_NOZBB-LABEL: test_ctpop_i16:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    lui a2, 5
; RV32_NOZBB-NEXT:    addi a2, a2, 1365
; RV32_NOZBB-NEXT:    and a1, a1, a2
; RV32_NOZBB-NEXT:    sub a0, a0, a1
; RV32_NOZBB-NEXT:    lui a1, 3
; RV32_NOZBB-NEXT:    addi a1, a1, 819
; RV32_NOZBB-NEXT:    and a2, a0, a1
; RV32_NOZBB-NEXT:    srli a0, a0, 2
; RV32_NOZBB-NEXT:    and a0, a0, a1
; RV32_NOZBB-NEXT:    add a0, a2, a0
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    add a0, a0, a1
; RV32_NOZBB-NEXT:    andi a1, a0, 15
; RV32_NOZBB-NEXT:    slli a0, a0, 20
; RV32_NOZBB-NEXT:    srli a0, a0, 28
; RV32_NOZBB-NEXT:    add a0, a1, a0
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_ctpop_i16:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    lui a2, 5
; RV64NOZBB-NEXT:    addiw a2, a2, 1365
; RV64NOZBB-NEXT:    and a1, a1, a2
; RV64NOZBB-NEXT:    sub a0, a0, a1
; RV64NOZBB-NEXT:    lui a1, 3
; RV64NOZBB-NEXT:    addiw a1, a1, 819
; RV64NOZBB-NEXT:    and a2, a0, a1
; RV64NOZBB-NEXT:    srli a0, a0, 2
; RV64NOZBB-NEXT:    and a0, a0, a1
; RV64NOZBB-NEXT:    add a0, a2, a0
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    add a0, a0, a1
; RV64NOZBB-NEXT:    andi a1, a0, 15
; RV64NOZBB-NEXT:    slli a0, a0, 52
; RV64NOZBB-NEXT:    srli a0, a0, 60
; RV64NOZBB-NEXT:    add a0, a1, a0
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctpop_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctpop_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctpop_i16:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    srli a1, a0, 1
; RV32XTHEADBB-NEXT:    lui a2, 5
; RV32XTHEADBB-NEXT:    addi a2, a2, 1365
; RV32XTHEADBB-NEXT:    and a1, a1, a2
; RV32XTHEADBB-NEXT:    sub a0, a0, a1
; RV32XTHEADBB-NEXT:    lui a1, 3
; RV32XTHEADBB-NEXT:    addi a1, a1, 819
; RV32XTHEADBB-NEXT:    and a2, a0, a1
; RV32XTHEADBB-NEXT:    srli a0, a0, 2
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    add a0, a2, a0
; RV32XTHEADBB-NEXT:    srli a1, a0, 4
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    andi a1, a0, 15
; RV32XTHEADBB-NEXT:    slli a0, a0, 20
; RV32XTHEADBB-NEXT:    srli a0, a0, 28
; RV32XTHEADBB-NEXT:    add a0, a1, a0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctpop_i16:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    srli a1, a0, 1
; RV64XTHEADBB-NEXT:    lui a2, 5
; RV64XTHEADBB-NEXT:    addiw a2, a2, 1365
; RV64XTHEADBB-NEXT:    and a1, a1, a2
; RV64XTHEADBB-NEXT:    sub a0, a0, a1
; RV64XTHEADBB-NEXT:    lui a1, 3
; RV64XTHEADBB-NEXT:    addiw a1, a1, 819
; RV64XTHEADBB-NEXT:    and a2, a0, a1
; RV64XTHEADBB-NEXT:    srli a0, a0, 2
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    add a0, a2, a0
; RV64XTHEADBB-NEXT:    srli a1, a0, 4
; RV64XTHEADBB-NEXT:    add a0, a0, a1
; RV64XTHEADBB-NEXT:    andi a1, a0, 15
; RV64XTHEADBB-NEXT:    slli a0, a0, 52
; RV64XTHEADBB-NEXT:    srli a0, a0, 60
; RV64XTHEADBB-NEXT:    add a0, a1, a0
; RV64XTHEADBB-NEXT:    ret
  %1 = call i16 @llvm.ctpop.i16(i16 %a)
  ret i16 %1
}

define i32 @test_ctpop_i32(i32 %a) nounwind {
; RV32I-LABEL: test_ctpop_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    lui a1, 209715
; RV32I-NEXT:    addi a1, a1, 819
; RV32I-NEXT:    and a2, a0, a1
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lui a1, 61681
; RV32I-NEXT:    addi a1, a1, -241
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    lui a1, 4112
; RV32I-NEXT:    addi a1, a1, 257
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_ctpop_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    addiw a2, a2, 1365
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    and a2, a0, a1
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    add a0, a2, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    lui a1, 61681
; RV64I-NEXT:    addiw a1, a1, -241
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, 4112
; RV64I-NEXT:    addiw a1, a1, 257
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srliw a0, a0, 24
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32M-LABEL: test_ctpop_i32:
; RV32M:       # %bb.0:
; RV32M-NEXT:    srli a1, a0, 1
; RV32M-NEXT:    lui a2, 349525
; RV32M-NEXT:    addi a2, a2, 1365
; RV32M-NEXT:    and a1, a1, a2
; RV32M-NEXT:    sub a0, a0, a1
; RV32M-NEXT:    lui a1, 209715
; RV32M-NEXT:    addi a1, a1, 819
; RV32M-NEXT:    and a2, a0, a1
; RV32M-NEXT:    srli a0, a0, 2
; RV32M-NEXT:    and a0, a0, a1
; RV32M-NEXT:    add a0, a2, a0
; RV32M-NEXT:    srli a1, a0, 4
; RV32M-NEXT:    add a0, a0, a1
; RV32M-NEXT:    lui a1, 61681
; RV32M-NEXT:    addi a1, a1, -241
; RV32M-NEXT:    and a0, a0, a1
; RV32M-NEXT:    lui a1, 4112
; RV32M-NEXT:    addi a1, a1, 257
; RV32M-NEXT:    mul a0, a0, a1
; RV32M-NEXT:    srli a0, a0, 24
; RV32M-NEXT:    ret
;
; RV64M-LABEL: test_ctpop_i32:
; RV64M:       # %bb.0:
; RV64M-NEXT:    srli a1, a0, 1
; RV64M-NEXT:    lui a2, 349525
; RV64M-NEXT:    addiw a2, a2, 1365
; RV64M-NEXT:    and a1, a1, a2
; RV64M-NEXT:    sub a0, a0, a1
; RV64M-NEXT:    lui a1, 209715
; RV64M-NEXT:    addiw a1, a1, 819
; RV64M-NEXT:    and a2, a0, a1
; RV64M-NEXT:    srli a0, a0, 2
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    add a0, a2, a0
; RV64M-NEXT:    srli a1, a0, 4
; RV64M-NEXT:    add a0, a0, a1
; RV64M-NEXT:    lui a1, 61681
; RV64M-NEXT:    addi a1, a1, -241
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    lui a1, 4112
; RV64M-NEXT:    addi a1, a1, 257
; RV64M-NEXT:    mul a0, a0, a1
; RV64M-NEXT:    srliw a0, a0, 24
; RV64M-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctpop_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctpop_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctpop_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    addi sp, sp, -16
; RV32XTHEADBB-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32XTHEADBB-NEXT:    srli a1, a0, 1
; RV32XTHEADBB-NEXT:    lui a2, 349525
; RV32XTHEADBB-NEXT:    addi a2, a2, 1365
; RV32XTHEADBB-NEXT:    and a1, a1, a2
; RV32XTHEADBB-NEXT:    sub a0, a0, a1
; RV32XTHEADBB-NEXT:    lui a1, 209715
; RV32XTHEADBB-NEXT:    addi a1, a1, 819
; RV32XTHEADBB-NEXT:    and a2, a0, a1
; RV32XTHEADBB-NEXT:    srli a0, a0, 2
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    add a0, a2, a0
; RV32XTHEADBB-NEXT:    srli a1, a0, 4
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    lui a1, 61681
; RV32XTHEADBB-NEXT:    addi a1, a1, -241
; RV32XTHEADBB-NEXT:    and a0, a0, a1
; RV32XTHEADBB-NEXT:    lui a1, 4112
; RV32XTHEADBB-NEXT:    addi a1, a1, 257
; RV32XTHEADBB-NEXT:    call __mulsi3
; RV32XTHEADBB-NEXT:    srli a0, a0, 24
; RV32XTHEADBB-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32XTHEADBB-NEXT:    addi sp, sp, 16
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctpop_i32:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    addi sp, sp, -16
; RV64XTHEADBB-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64XTHEADBB-NEXT:    srli a1, a0, 1
; RV64XTHEADBB-NEXT:    lui a2, 349525
; RV64XTHEADBB-NEXT:    addiw a2, a2, 1365
; RV64XTHEADBB-NEXT:    and a1, a1, a2
; RV64XTHEADBB-NEXT:    sub a0, a0, a1
; RV64XTHEADBB-NEXT:    lui a1, 209715
; RV64XTHEADBB-NEXT:    addiw a1, a1, 819
; RV64XTHEADBB-NEXT:    and a2, a0, a1
; RV64XTHEADBB-NEXT:    srli a0, a0, 2
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    add a0, a2, a0
; RV64XTHEADBB-NEXT:    srli a1, a0, 4
; RV64XTHEADBB-NEXT:    add a0, a0, a1
; RV64XTHEADBB-NEXT:    lui a1, 61681
; RV64XTHEADBB-NEXT:    addiw a1, a1, -241
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    lui a1, 4112
; RV64XTHEADBB-NEXT:    addiw a1, a1, 257
; RV64XTHEADBB-NEXT:    call __muldi3
; RV64XTHEADBB-NEXT:    srliw a0, a0, 24
; RV64XTHEADBB-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64XTHEADBB-NEXT:    addi sp, sp, 16
; RV64XTHEADBB-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  ret i32 %1
}

define i64 @test_ctpop_i64(i64 %a) nounwind {
; RV32I-LABEL: test_ctpop_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    srli a0, a1, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi s2, a2, 1365
; RV32I-NEXT:    and a0, a0, s2
; RV32I-NEXT:    sub a1, a1, a0
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi s3, a0, 819
; RV32I-NEXT:    and a0, a1, s3
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    and a1, a1, s3
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lui a1, 61681
; RV32I-NEXT:    addi s4, a1, -241
; RV32I-NEXT:    and a0, a0, s4
; RV32I-NEXT:    lui a1, 4112
; RV32I-NEXT:    addi s1, a1, 257
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    srli s5, a0, 24
; RV32I-NEXT:    srli a0, s0, 1
; RV32I-NEXT:    and a0, a0, s2
; RV32I-NEXT:    sub s0, s0, a0
; RV32I-NEXT:    and a0, s0, s3
; RV32I-NEXT:    srli s0, s0, 2
; RV32I-NEXT:    and a1, s0, s3
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    and a0, a0, s4
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __mulsi3
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    add a0, a0, s5
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_ctpop_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    addiw a2, a2, 1365
; RV64I-NEXT:    slli a3, a2, 32
; RV64I-NEXT:    add a2, a2, a3
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    lui a1, 209715
; RV64I-NEXT:    addiw a1, a1, 819
; RV64I-NEXT:    slli a2, a1, 32
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    and a2, a0, a1
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    add a0, a2, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    lui a1, 61681
; RV64I-NEXT:    addiw a1, a1, -241
; RV64I-NEXT:    slli a2, a1, 32
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, 4112
; RV64I-NEXT:    addiw a1, a1, 257
; RV64I-NEXT:    slli a2, a1, 32
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srli a0, a0, 56
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV32M-LABEL: test_ctpop_i64:
; RV32M:       # %bb.0:
; RV32M-NEXT:    srli a2, a1, 1
; RV32M-NEXT:    lui a3, 349525
; RV32M-NEXT:    addi a3, a3, 1365
; RV32M-NEXT:    and a2, a2, a3
; RV32M-NEXT:    sub a1, a1, a2
; RV32M-NEXT:    lui a2, 209715
; RV32M-NEXT:    addi a2, a2, 819
; RV32M-NEXT:    and a4, a1, a2
; RV32M-NEXT:    srli a1, a1, 2
; RV32M-NEXT:    and a1, a1, a2
; RV32M-NEXT:    add a1, a4, a1
; RV32M-NEXT:    srli a4, a1, 4
; RV32M-NEXT:    add a1, a1, a4
; RV32M-NEXT:    lui a4, 61681
; RV32M-NEXT:    addi a4, a4, -241
; RV32M-NEXT:    and a1, a1, a4
; RV32M-NEXT:    lui a5, 4112
; RV32M-NEXT:    addi a5, a5, 257
; RV32M-NEXT:    mul a1, a1, a5
; RV32M-NEXT:    srli a1, a1, 24
; RV32M-NEXT:    srli a6, a0, 1
; RV32M-NEXT:    and a3, a6, a3
; RV32M-NEXT:    sub a0, a0, a3
; RV32M-NEXT:    and a3, a0, a2
; RV32M-NEXT:    srli a0, a0, 2
; RV32M-NEXT:    and a0, a0, a2
; RV32M-NEXT:    add a0, a3, a0
; RV32M-NEXT:    srli a2, a0, 4
; RV32M-NEXT:    add a0, a0, a2
; RV32M-NEXT:    and a0, a0, a4
; RV32M-NEXT:    mul a0, a0, a5
; RV32M-NEXT:    srli a0, a0, 24
; RV32M-NEXT:    add a0, a0, a1
; RV32M-NEXT:    li a1, 0
; RV32M-NEXT:    ret
;
; RV64M-LABEL: test_ctpop_i64:
; RV64M:       # %bb.0:
; RV64M-NEXT:    srli a1, a0, 1
; RV64M-NEXT:    lui a2, 349525
; RV64M-NEXT:    addiw a2, a2, 1365
; RV64M-NEXT:    slli a3, a2, 32
; RV64M-NEXT:    add a2, a2, a3
; RV64M-NEXT:    and a1, a1, a2
; RV64M-NEXT:    sub a0, a0, a1
; RV64M-NEXT:    lui a1, 209715
; RV64M-NEXT:    addiw a1, a1, 819
; RV64M-NEXT:    slli a2, a1, 32
; RV64M-NEXT:    add a1, a1, a2
; RV64M-NEXT:    and a2, a0, a1
; RV64M-NEXT:    srli a0, a0, 2
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    add a0, a2, a0
; RV64M-NEXT:    srli a1, a0, 4
; RV64M-NEXT:    add a0, a0, a1
; RV64M-NEXT:    lui a1, 61681
; RV64M-NEXT:    addiw a1, a1, -241
; RV64M-NEXT:    slli a2, a1, 32
; RV64M-NEXT:    add a1, a1, a2
; RV64M-NEXT:    and a0, a0, a1
; RV64M-NEXT:    lui a1, 4112
; RV64M-NEXT:    addiw a1, a1, 257
; RV64M-NEXT:    slli a2, a1, 32
; RV64M-NEXT:    add a1, a1, a2
; RV64M-NEXT:    mul a0, a0, a1
; RV64M-NEXT:    srli a0, a0, 56
; RV64M-NEXT:    ret
;
; RV32ZBB-LABEL: test_ctpop_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    cpop a1, a1
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    add a0, a0, a1
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_ctpop_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_ctpop_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    addi sp, sp, -32
; RV32XTHEADBB-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32XTHEADBB-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32XTHEADBB-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32XTHEADBB-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32XTHEADBB-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32XTHEADBB-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32XTHEADBB-NEXT:    sw s5, 4(sp) # 4-byte Folded Spill
; RV32XTHEADBB-NEXT:    mv s0, a0
; RV32XTHEADBB-NEXT:    srli a0, a1, 1
; RV32XTHEADBB-NEXT:    lui a2, 349525
; RV32XTHEADBB-NEXT:    addi s2, a2, 1365
; RV32XTHEADBB-NEXT:    and a0, a0, s2
; RV32XTHEADBB-NEXT:    sub a1, a1, a0
; RV32XTHEADBB-NEXT:    lui a0, 209715
; RV32XTHEADBB-NEXT:    addi s3, a0, 819
; RV32XTHEADBB-NEXT:    and a0, a1, s3
; RV32XTHEADBB-NEXT:    srli a1, a1, 2
; RV32XTHEADBB-NEXT:    and a1, a1, s3
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 4
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    lui a1, 61681
; RV32XTHEADBB-NEXT:    addi s4, a1, -241
; RV32XTHEADBB-NEXT:    and a0, a0, s4
; RV32XTHEADBB-NEXT:    lui a1, 4112
; RV32XTHEADBB-NEXT:    addi s1, a1, 257
; RV32XTHEADBB-NEXT:    mv a1, s1
; RV32XTHEADBB-NEXT:    call __mulsi3
; RV32XTHEADBB-NEXT:    srli s5, a0, 24
; RV32XTHEADBB-NEXT:    srli a0, s0, 1
; RV32XTHEADBB-NEXT:    and a0, a0, s2
; RV32XTHEADBB-NEXT:    sub s0, s0, a0
; RV32XTHEADBB-NEXT:    and a0, s0, s3
; RV32XTHEADBB-NEXT:    srli s0, s0, 2
; RV32XTHEADBB-NEXT:    and a1, s0, s3
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 4
; RV32XTHEADBB-NEXT:    add a0, a0, a1
; RV32XTHEADBB-NEXT:    and a0, a0, s4
; RV32XTHEADBB-NEXT:    mv a1, s1
; RV32XTHEADBB-NEXT:    call __mulsi3
; RV32XTHEADBB-NEXT:    srli a0, a0, 24
; RV32XTHEADBB-NEXT:    add a0, a0, s5
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32XTHEADBB-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32XTHEADBB-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32XTHEADBB-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32XTHEADBB-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32XTHEADBB-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32XTHEADBB-NEXT:    lw s5, 4(sp) # 4-byte Folded Reload
; RV32XTHEADBB-NEXT:    addi sp, sp, 32
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_ctpop_i64:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    addi sp, sp, -16
; RV64XTHEADBB-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64XTHEADBB-NEXT:    srli a1, a0, 1
; RV64XTHEADBB-NEXT:    lui a2, 349525
; RV64XTHEADBB-NEXT:    addiw a2, a2, 1365
; RV64XTHEADBB-NEXT:    slli a3, a2, 32
; RV64XTHEADBB-NEXT:    add a2, a2, a3
; RV64XTHEADBB-NEXT:    and a1, a1, a2
; RV64XTHEADBB-NEXT:    sub a0, a0, a1
; RV64XTHEADBB-NEXT:    lui a1, 209715
; RV64XTHEADBB-NEXT:    addiw a1, a1, 819
; RV64XTHEADBB-NEXT:    slli a2, a1, 32
; RV64XTHEADBB-NEXT:    add a1, a1, a2
; RV64XTHEADBB-NEXT:    and a2, a0, a1
; RV64XTHEADBB-NEXT:    srli a0, a0, 2
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    add a0, a2, a0
; RV64XTHEADBB-NEXT:    srli a1, a0, 4
; RV64XTHEADBB-NEXT:    add a0, a0, a1
; RV64XTHEADBB-NEXT:    lui a1, 61681
; RV64XTHEADBB-NEXT:    addiw a1, a1, -241
; RV64XTHEADBB-NEXT:    slli a2, a1, 32
; RV64XTHEADBB-NEXT:    add a1, a1, a2
; RV64XTHEADBB-NEXT:    and a0, a0, a1
; RV64XTHEADBB-NEXT:    lui a1, 4112
; RV64XTHEADBB-NEXT:    addiw a1, a1, 257
; RV64XTHEADBB-NEXT:    slli a2, a1, 32
; RV64XTHEADBB-NEXT:    add a1, a1, a2
; RV64XTHEADBB-NEXT:    call __muldi3
; RV64XTHEADBB-NEXT:    srli a0, a0, 56
; RV64XTHEADBB-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64XTHEADBB-NEXT:    addi sp, sp, 16
; RV64XTHEADBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  ret i64 %1
}

define i8 @test_parity_i8(i8 %a) {
; RV32_NOZBB-LABEL: test_parity_i8:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    andi a0, a0, 255
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 2
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    andi a0, a0, 1
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_parity_i8:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    andi a0, a0, 255
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 2
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    andi a0, a0, 1
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_parity_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andi a0, a0, 255
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    andi a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_parity_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    andi a0, a0, 255
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    andi a0, a0, 1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_parity_i8:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    andi a0, a0, 255
; RV32XTHEADBB-NEXT:    srli a1, a0, 4
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 2
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 1
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    andi a0, a0, 1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_parity_i8:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    andi a0, a0, 255
; RV64XTHEADBB-NEXT:    srli a1, a0, 4
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 2
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 1
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    andi a0, a0, 1
; RV64XTHEADBB-NEXT:    ret
  %1 = call i8 @llvm.ctpop.i8(i8 %a)
  %2 = and i8 %1, 1
  ret i8 %2
}

define i16 @test_parity_i16(i16 %a) {
; RV32_NOZBB-LABEL: test_parity_i16:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    slli a0, a0, 16
; RV32_NOZBB-NEXT:    srli a0, a0, 16
; RV32_NOZBB-NEXT:    srli a1, a0, 8
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 2
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    andi a0, a0, 1
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_parity_i16:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    slli a0, a0, 48
; RV64NOZBB-NEXT:    srli a0, a0, 48
; RV64NOZBB-NEXT:    srli a1, a0, 8
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 2
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    andi a0, a0, 1
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_parity_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    andi a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_parity_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    andi a0, a0, 1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_parity_i16:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    th.extu a0, a0, 15, 0
; RV32XTHEADBB-NEXT:    srli a1, a0, 8
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 4
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 2
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 1
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    andi a0, a0, 1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_parity_i16:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    th.extu a0, a0, 15, 0
; RV64XTHEADBB-NEXT:    srli a1, a0, 8
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 4
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 2
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 1
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    andi a0, a0, 1
; RV64XTHEADBB-NEXT:    ret
  %1 = call i16 @llvm.ctpop.i16(i16 %a)
  %2 = and i16 %1, 1
  ret i16 %2
}

define i32 @test_parity_i32(i32 %a) {
; RV32_NOZBB-LABEL: test_parity_i32:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    srli a1, a0, 16
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 8
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 2
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    andi a0, a0, 1
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_parity_i32:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    slli a1, a0, 32
; RV64NOZBB-NEXT:    srli a1, a1, 32
; RV64NOZBB-NEXT:    srliw a0, a0, 16
; RV64NOZBB-NEXT:    xor a0, a1, a0
; RV64NOZBB-NEXT:    srli a1, a0, 8
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 2
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    andi a0, a0, 1
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_parity_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    andi a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_parity_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    andi a0, a0, 1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_parity_i32:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    srli a1, a0, 16
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 8
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 4
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 2
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 1
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    andi a0, a0, 1
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_parity_i32:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    th.extu a1, a0, 31, 0
; RV64XTHEADBB-NEXT:    srliw a0, a0, 16
; RV64XTHEADBB-NEXT:    xor a0, a1, a0
; RV64XTHEADBB-NEXT:    srli a1, a0, 8
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 4
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 2
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 1
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    andi a0, a0, 1
; RV64XTHEADBB-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  %2 = and i32 %1, 1
  ret i32 %2
}

define i64 @test_parity_i64(i64 %a) {
; RV32_NOZBB-LABEL: test_parity_i64:
; RV32_NOZBB:       # %bb.0:
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 16
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 8
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 4
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 2
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    srli a1, a0, 1
; RV32_NOZBB-NEXT:    xor a0, a0, a1
; RV32_NOZBB-NEXT:    andi a0, a0, 1
; RV32_NOZBB-NEXT:    li a1, 0
; RV32_NOZBB-NEXT:    ret
;
; RV64NOZBB-LABEL: test_parity_i64:
; RV64NOZBB:       # %bb.0:
; RV64NOZBB-NEXT:    srli a1, a0, 32
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 16
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 8
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 4
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 2
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    srli a1, a0, 1
; RV64NOZBB-NEXT:    xor a0, a0, a1
; RV64NOZBB-NEXT:    andi a0, a0, 1
; RV64NOZBB-NEXT:    ret
;
; RV32ZBB-LABEL: test_parity_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    xor a0, a0, a1
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    andi a0, a0, 1
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: test_parity_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    andi a0, a0, 1
; RV64ZBB-NEXT:    ret
;
; RV32XTHEADBB-LABEL: test_parity_i64:
; RV32XTHEADBB:       # %bb.0:
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 16
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 8
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 4
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 2
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    srli a1, a0, 1
; RV32XTHEADBB-NEXT:    xor a0, a0, a1
; RV32XTHEADBB-NEXT:    andi a0, a0, 1
; RV32XTHEADBB-NEXT:    li a1, 0
; RV32XTHEADBB-NEXT:    ret
;
; RV64XTHEADBB-LABEL: test_parity_i64:
; RV64XTHEADBB:       # %bb.0:
; RV64XTHEADBB-NEXT:    srli a1, a0, 32
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 16
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 8
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 4
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 2
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    srli a1, a0, 1
; RV64XTHEADBB-NEXT:    xor a0, a0, a1
; RV64XTHEADBB-NEXT:    andi a0, a0, 1
; RV64XTHEADBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  %2 = and i64 %1, 1
  ret i64 %2
}
