; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -riscv-disable-using-constant-pool-for-large-ints -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv64 -riscv-disable-using-constant-pool-for-large-ints -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV64I,RV64-NOPOOL
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV64I,RV64I-POOL
; RUN: llc -mtriple=riscv64 -riscv-disable-using-constant-pool-for-large-ints -mattr=+zba \
; RUN:   -verify-machineinstrs < %s | FileCheck %s -check-prefix=RV64IZBA
; RUN: llc -mtriple=riscv64 -riscv-disable-using-constant-pool-for-large-ints -mattr=+zbb \
; RUN:   -verify-machineinstrs < %s | FileCheck %s -check-prefix=RV64IZBB
; RUN: llc -mtriple=riscv64 -riscv-disable-using-constant-pool-for-large-ints -mattr=+zbs \
; RUN:   -verify-machineinstrs < %s | FileCheck %s -check-prefix=RV64IZBS
; RUN: llc -mtriple=riscv64 -riscv-disable-using-constant-pool-for-large-ints -mattr=+xtheadbb \
; RUN:   -verify-machineinstrs < %s | FileCheck %s -check-prefix=RV64IXTHEADBB

; Materializing constants

; TODO: It would be preferable if anyext constant returns were sign rather
; than zero extended. See PR39092. For now, mark returns as explicitly signext
; (this matches what Clang would generate for equivalent C/C++ anyway).

define signext i32 @zero() nounwind {
; RV32I-LABEL: zero:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 0
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: zero:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, 0
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: zero:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, 0
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: zero:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, 0
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: zero:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, 0
; RV64IXTHEADBB-NEXT:    ret
  ret i32 0
}

define signext i32 @pos_small() nounwind {
; RV32I-LABEL: pos_small:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 2047
; RV32I-NEXT:    ret
;
; RV64I-LABEL: pos_small:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 2047
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: pos_small:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, 2047
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: pos_small:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, 2047
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: pos_small:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, 2047
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: pos_small:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, 2047
; RV64IXTHEADBB-NEXT:    ret
  ret i32 2047
}

define signext i32 @neg_small() nounwind {
; RV32I-LABEL: neg_small:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, -2048
; RV32I-NEXT:    ret
;
; RV64I-LABEL: neg_small:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, -2048
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: neg_small:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -2048
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: neg_small:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -2048
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: neg_small:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, -2048
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: neg_small:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -2048
; RV64IXTHEADBB-NEXT:    ret
  ret i32 -2048
}

define signext i32 @pos_i32() nounwind {
; RV32I-LABEL: pos_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 423811
; RV32I-NEXT:    addi a0, a0, -1297
; RV32I-NEXT:    ret
;
; RV64I-LABEL: pos_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 423811
; RV64I-NEXT:    addiw a0, a0, -1297
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: pos_i32:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 423811
; RV64IZBA-NEXT:    addiw a0, a0, -1297
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: pos_i32:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 423811
; RV64IZBB-NEXT:    addiw a0, a0, -1297
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: pos_i32:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 423811
; RV64IZBS-NEXT:    addiw a0, a0, -1297
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: pos_i32:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 423811
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1297
; RV64IXTHEADBB-NEXT:    ret
  ret i32 1735928559
}

define signext i32 @neg_i32() nounwind {
; RV32I-LABEL: neg_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 912092
; RV32I-NEXT:    addi a0, a0, -273
; RV32I-NEXT:    ret
;
; RV64I-LABEL: neg_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 912092
; RV64I-NEXT:    addiw a0, a0, -273
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: neg_i32:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 912092
; RV64IZBA-NEXT:    addiw a0, a0, -273
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: neg_i32:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 912092
; RV64IZBB-NEXT:    addiw a0, a0, -273
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: neg_i32:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 912092
; RV64IZBS-NEXT:    addiw a0, a0, -273
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: neg_i32:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 912092
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -273
; RV64IXTHEADBB-NEXT:    ret
  ret i32 -559038737
}

define signext i32 @pos_i32_hi20_only() nounwind {
; RV32I-LABEL: pos_i32_hi20_only:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: pos_i32_hi20_only:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 16
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: pos_i32_hi20_only:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 16
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: pos_i32_hi20_only:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 16
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: pos_i32_hi20_only:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 16
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: pos_i32_hi20_only:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 16
; RV64IXTHEADBB-NEXT:    ret
  ret i32 65536 ; 0x10000
}

define signext i32 @neg_i32_hi20_only() nounwind {
; RV32I-LABEL: neg_i32_hi20_only:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 1048560
; RV32I-NEXT:    ret
;
; RV64I-LABEL: neg_i32_hi20_only:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1048560
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: neg_i32_hi20_only:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 1048560
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: neg_i32_hi20_only:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 1048560
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: neg_i32_hi20_only:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 1048560
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: neg_i32_hi20_only:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 1048560
; RV64IXTHEADBB-NEXT:    ret
  ret i32 -65536 ; -0x10000
}

; This can be materialized with ADDI+SLLI, improving compressibility.

define signext i32 @imm_left_shifted_addi() nounwind {
; RV32I-LABEL: imm_left_shifted_addi:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 32
; RV32I-NEXT:    addi a0, a0, -64
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_left_shifted_addi:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 32
; RV64I-NEXT:    addiw a0, a0, -64
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_left_shifted_addi:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 32
; RV64IZBA-NEXT:    addiw a0, a0, -64
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_left_shifted_addi:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 32
; RV64IZBB-NEXT:    addiw a0, a0, -64
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_left_shifted_addi:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 32
; RV64IZBS-NEXT:    addiw a0, a0, -64
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_left_shifted_addi:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 32
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -64
; RV64IXTHEADBB-NEXT:    ret
  ret i32 131008 ; 0x1FFC0
}

; This can be materialized with ADDI+SRLI, improving compressibility.

define signext i32 @imm_right_shifted_addi() nounwind {
; RV32I-LABEL: imm_right_shifted_addi:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 524288
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_right_shifted_addi:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 524288
; RV64I-NEXT:    addiw a0, a0, -1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_right_shifted_addi:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 524288
; RV64IZBA-NEXT:    addiw a0, a0, -1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_right_shifted_addi:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 524288
; RV64IZBB-NEXT:    addiw a0, a0, -1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_right_shifted_addi:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 524288
; RV64IZBS-NEXT:    addiw a0, a0, -1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_right_shifted_addi:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 524288
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1
; RV64IXTHEADBB-NEXT:    ret
  ret i32 2147483647 ; 0x7FFFFFFF
}

; This can be materialized with LUI+SRLI, improving compressibility.

define signext i32 @imm_right_shifted_lui() nounwind {
; RV32I-LABEL: imm_right_shifted_lui:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 56
; RV32I-NEXT:    addi a0, a0, 580
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_right_shifted_lui:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 56
; RV64I-NEXT:    addiw a0, a0, 580
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_right_shifted_lui:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 56
; RV64IZBA-NEXT:    addiw a0, a0, 580
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_right_shifted_lui:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 56
; RV64IZBB-NEXT:    addiw a0, a0, 580
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_right_shifted_lui:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 56
; RV64IZBS-NEXT:    addiw a0, a0, 580
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_right_shifted_lui:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 56
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 580
; RV64IXTHEADBB-NEXT:    ret
  ret i32 229956 ; 0x38244
}

define i64 @imm64_1() nounwind {
; RV32I-LABEL: imm64_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 524288
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm64_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    slli a0, a0, 31
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_1:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, 1
; RV64IZBA-NEXT:    slli a0, a0, 31
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_1:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, 1
; RV64IZBB-NEXT:    slli a0, a0, 31
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_1:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    bseti a0, zero, 31
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_1:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, 1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 31
; RV64IXTHEADBB-NEXT:    ret
  ret i64 2147483648 ; 0x8000_0000
}

define i64 @imm64_2() nounwind {
; RV32I-LABEL: imm64_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, -1
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm64_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, -1
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_2:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -1
; RV64IZBA-NEXT:    srli a0, a0, 32
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_2:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -1
; RV64IZBB-NEXT:    srli a0, a0, 32
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_2:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, -1
; RV64IZBS-NEXT:    srli a0, a0, 32
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_2:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -1
; RV64IXTHEADBB-NEXT:    srli a0, a0, 32
; RV64IXTHEADBB-NEXT:    ret
  ret i64 4294967295 ; 0xFFFF_FFFF
}

define i64 @imm64_3() nounwind {
; RV32I-LABEL: imm64_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 1
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm64_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_3:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, 1
; RV64IZBA-NEXT:    slli a0, a0, 32
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_3:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, 1
; RV64IZBB-NEXT:    slli a0, a0, 32
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_3:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    bseti a0, zero, 32
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_3:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, 1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 32
; RV64IXTHEADBB-NEXT:    ret
  ret i64 4294967296 ; 0x1_0000_0000
}

define i64 @imm64_4() nounwind {
; RV32I-LABEL: imm64_4:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm64_4:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, -1
; RV64I-NEXT:    slli a0, a0, 63
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_4:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -1
; RV64IZBA-NEXT:    slli a0, a0, 63
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_4:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -1
; RV64IZBB-NEXT:    slli a0, a0, 63
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_4:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    bseti a0, zero, 63
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_4:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 63
; RV64IXTHEADBB-NEXT:    ret
  ret i64 9223372036854775808 ; 0x8000_0000_0000_0000
}

define i64 @imm64_5() nounwind {
; RV32I-LABEL: imm64_5:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm64_5:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, -1
; RV64I-NEXT:    slli a0, a0, 63
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_5:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -1
; RV64IZBA-NEXT:    slli a0, a0, 63
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_5:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -1
; RV64IZBB-NEXT:    slli a0, a0, 63
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_5:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    bseti a0, zero, 63
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_5:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 63
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -9223372036854775808 ; 0x8000_0000_0000_0000
}

define i64 @imm64_6() nounwind {
; RV32I-LABEL: imm64_6:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 74565
; RV32I-NEXT:    addi a1, a0, 1656
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm64_6:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 9321
; RV64I-NEXT:    addiw a0, a0, -1329
; RV64I-NEXT:    slli a0, a0, 35
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_6:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 9321
; RV64IZBA-NEXT:    addiw a0, a0, -1329
; RV64IZBA-NEXT:    slli a0, a0, 35
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_6:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 9321
; RV64IZBB-NEXT:    addiw a0, a0, -1329
; RV64IZBB-NEXT:    slli a0, a0, 35
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_6:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 9321
; RV64IZBS-NEXT:    addiw a0, a0, -1329
; RV64IZBS-NEXT:    slli a0, a0, 35
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_6:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 9321
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1329
; RV64IXTHEADBB-NEXT:    slli a0, a0, 35
; RV64IXTHEADBB-NEXT:    ret
  ret i64 1311768464867721216 ; 0x1234_5678_0000_0000
}

define i64 @imm64_7() nounwind {
; RV32I-LABEL: imm64_7:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 45056
; RV32I-NEXT:    addi a0, a0, 15
; RV32I-NEXT:    lui a1, 458752
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm64_7:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 7
; RV64I-NEXT:    slli a0, a0, 36
; RV64I-NEXT:    addi a0, a0, 11
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    addi a0, a0, 15
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_7:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, 7
; RV64IZBA-NEXT:    slli a0, a0, 36
; RV64IZBA-NEXT:    addi a0, a0, 11
; RV64IZBA-NEXT:    slli a0, a0, 24
; RV64IZBA-NEXT:    addi a0, a0, 15
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_7:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, 7
; RV64IZBB-NEXT:    slli a0, a0, 36
; RV64IZBB-NEXT:    addi a0, a0, 11
; RV64IZBB-NEXT:    slli a0, a0, 24
; RV64IZBB-NEXT:    addi a0, a0, 15
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_7:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, 7
; RV64IZBS-NEXT:    slli a0, a0, 36
; RV64IZBS-NEXT:    addi a0, a0, 11
; RV64IZBS-NEXT:    slli a0, a0, 24
; RV64IZBS-NEXT:    addi a0, a0, 15
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_7:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, 7
; RV64IXTHEADBB-NEXT:    slli a0, a0, 36
; RV64IXTHEADBB-NEXT:    addi a0, a0, 11
; RV64IXTHEADBB-NEXT:    slli a0, a0, 24
; RV64IXTHEADBB-NEXT:    addi a0, a0, 15
; RV64IXTHEADBB-NEXT:    ret
  ret i64 8070450532432478223 ; 0x7000_0000_0B00_000F
}

; TODO: it can be preferable to put constants that are expensive to materialise
; into the constant pool, especially for -Os.
define i64 @imm64_8() nounwind {
; RV32I-LABEL: imm64_8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 633806
; RV32I-NEXT:    addi a0, a0, -272
; RV32I-NEXT:    lui a1, 74565
; RV32I-NEXT:    addi a1, a1, 1656
; RV32I-NEXT:    ret
;
; RV64-NOPOOL-LABEL: imm64_8:
; RV64-NOPOOL:       # %bb.0:
; RV64-NOPOOL-NEXT:    lui a0, 583
; RV64-NOPOOL-NEXT:    addiw a0, a0, -1875
; RV64-NOPOOL-NEXT:    slli a0, a0, 14
; RV64-NOPOOL-NEXT:    addi a0, a0, -947
; RV64-NOPOOL-NEXT:    slli a0, a0, 12
; RV64-NOPOOL-NEXT:    addi a0, a0, 1511
; RV64-NOPOOL-NEXT:    slli a0, a0, 13
; RV64-NOPOOL-NEXT:    addi a0, a0, -272
; RV64-NOPOOL-NEXT:    ret
;
; RV64I-POOL-LABEL: imm64_8:
; RV64I-POOL:       # %bb.0:
; RV64I-POOL-NEXT:    lui a0, %hi(.LCPI17_0)
; RV64I-POOL-NEXT:    ld a0, %lo(.LCPI17_0)(a0)
; RV64I-POOL-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_8:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 596523
; RV64IZBA-NEXT:    addiw a0, a0, 965
; RV64IZBA-NEXT:    slli.uw a0, a0, 13
; RV64IZBA-NEXT:    addi a0, a0, -1347
; RV64IZBA-NEXT:    slli a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, -529
; RV64IZBA-NEXT:    slli a0, a0, 4
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_8:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 583
; RV64IZBB-NEXT:    addiw a0, a0, -1875
; RV64IZBB-NEXT:    slli a0, a0, 14
; RV64IZBB-NEXT:    addi a0, a0, -947
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1511
; RV64IZBB-NEXT:    slli a0, a0, 13
; RV64IZBB-NEXT:    addi a0, a0, -272
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_8:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 583
; RV64IZBS-NEXT:    addiw a0, a0, -1875
; RV64IZBS-NEXT:    slli a0, a0, 14
; RV64IZBS-NEXT:    addi a0, a0, -947
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    addi a0, a0, 1511
; RV64IZBS-NEXT:    slli a0, a0, 13
; RV64IZBS-NEXT:    addi a0, a0, -272
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_8:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 583
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1875
; RV64IXTHEADBB-NEXT:    slli a0, a0, 14
; RV64IXTHEADBB-NEXT:    addi a0, a0, -947
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1511
; RV64IXTHEADBB-NEXT:    slli a0, a0, 13
; RV64IXTHEADBB-NEXT:    addi a0, a0, -272
; RV64IXTHEADBB-NEXT:    ret
  ret i64 1311768467463790320 ; 0x1234_5678_9ABC_DEF0
}

define i64 @imm64_9() nounwind {
; RV32I-LABEL: imm64_9:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, -1
; RV32I-NEXT:    li a1, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm64_9:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, -1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_9:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_9:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_9:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, -1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_9:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -1
}

; Various cases where extraneous ADDIs can be inserted where a (left shifted)
; LUI suffices.

define i64 @imm_left_shifted_lui_1() nounwind {
; RV32I-LABEL: imm_left_shifted_lui_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 524290
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_left_shifted_lui_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 262145
; RV64I-NEXT:    slli a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_left_shifted_lui_1:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 262145
; RV64IZBA-NEXT:    slli a0, a0, 1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_left_shifted_lui_1:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 262145
; RV64IZBB-NEXT:    slli a0, a0, 1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_left_shifted_lui_1:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 262145
; RV64IZBS-NEXT:    slli a0, a0, 1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_left_shifted_lui_1:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 262145
; RV64IXTHEADBB-NEXT:    slli a0, a0, 1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 2147491840 ; 0x8000_2000
}

define i64 @imm_left_shifted_lui_2() nounwind {
; RV32I-LABEL: imm_left_shifted_lui_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 4
; RV32I-NEXT:    li a1, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_left_shifted_lui_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 262145
; RV64I-NEXT:    slli a0, a0, 2
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_left_shifted_lui_2:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 262145
; RV64IZBA-NEXT:    slli a0, a0, 2
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_left_shifted_lui_2:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 262145
; RV64IZBB-NEXT:    slli a0, a0, 2
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_left_shifted_lui_2:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 262145
; RV64IZBS-NEXT:    slli a0, a0, 2
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_left_shifted_lui_2:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 262145
; RV64IXTHEADBB-NEXT:    slli a0, a0, 2
; RV64IXTHEADBB-NEXT:    ret
  ret i64 4294983680 ; 0x1_0000_4000
}

define i64 @imm_left_shifted_lui_3() nounwind {
; RV32I-LABEL: imm_left_shifted_lui_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 1
; RV32I-NEXT:    addi a1, a1, 1
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_left_shifted_lui_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 4097
; RV64I-NEXT:    slli a0, a0, 20
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_left_shifted_lui_3:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 4097
; RV64IZBA-NEXT:    slli a0, a0, 20
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_left_shifted_lui_3:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 4097
; RV64IZBB-NEXT:    slli a0, a0, 20
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_left_shifted_lui_3:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 4097
; RV64IZBS-NEXT:    slli a0, a0, 20
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_left_shifted_lui_3:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 4097
; RV64IXTHEADBB-NEXT:    slli a0, a0, 20
; RV64IXTHEADBB-NEXT:    ret
  ret i64 17596481011712 ; 0x1001_0000_0000
}

; Various cases where extraneous ADDIs can be inserted where a (right shifted)
; LUI suffices, or where multiple ADDIs can be used instead of a single LUI.

define i64 @imm_right_shifted_lui_1() nounwind {
; RV32I-LABEL: imm_right_shifted_lui_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 1048575
; RV32I-NEXT:    addi a0, a0, 1
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_right_shifted_lui_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 983056
; RV64I-NEXT:    srli a0, a0, 16
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_right_shifted_lui_1:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 983056
; RV64IZBA-NEXT:    srli a0, a0, 16
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_right_shifted_lui_1:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 983056
; RV64IZBB-NEXT:    srli a0, a0, 16
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_right_shifted_lui_1:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 983056
; RV64IZBS-NEXT:    srli a0, a0, 16
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_right_shifted_lui_1:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 983056
; RV64IXTHEADBB-NEXT:    srli a0, a0, 16
; RV64IXTHEADBB-NEXT:    ret
  ret i64 281474976706561 ; 0xFFFF_FFFF_F001
}

define i64 @imm_right_shifted_lui_2() nounwind {
; RV32I-LABEL: imm_right_shifted_lui_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 1048575
; RV32I-NEXT:    addi a0, a0, 1
; RV32I-NEXT:    li a1, 255
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_right_shifted_lui_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1044481
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    srli a0, a0, 24
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_right_shifted_lui_2:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 1044481
; RV64IZBA-NEXT:    slli a0, a0, 12
; RV64IZBA-NEXT:    srli a0, a0, 24
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_right_shifted_lui_2:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 1044481
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    srli a0, a0, 24
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_right_shifted_lui_2:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 1044481
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    srli a0, a0, 24
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_right_shifted_lui_2:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 1044481
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    srli a0, a0, 24
; RV64IXTHEADBB-NEXT:    ret
  ret i64 1099511623681 ; 0xFF_FFFF_F001
}

; We can materialize the upper bits with a single (shifted) LUI, but that option
; can be missed due to the lower bits, which aren't just 1s or just 0s.

define i64 @imm_decoupled_lui_addi() nounwind {
; RV32I-LABEL: imm_decoupled_lui_addi:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, -3
; RV32I-NEXT:    lui a1, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_decoupled_lui_addi:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 4097
; RV64I-NEXT:    slli a0, a0, 20
; RV64I-NEXT:    addi a0, a0, -3
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_decoupled_lui_addi:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 4097
; RV64IZBA-NEXT:    slli a0, a0, 20
; RV64IZBA-NEXT:    addi a0, a0, -3
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_decoupled_lui_addi:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 4097
; RV64IZBB-NEXT:    slli a0, a0, 20
; RV64IZBB-NEXT:    addi a0, a0, -3
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_decoupled_lui_addi:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 4097
; RV64IZBS-NEXT:    slli a0, a0, 20
; RV64IZBS-NEXT:    addi a0, a0, -3
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_decoupled_lui_addi:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 4097
; RV64IXTHEADBB-NEXT:    slli a0, a0, 20
; RV64IXTHEADBB-NEXT:    addi a0, a0, -3
; RV64IXTHEADBB-NEXT:    ret
  ret i64 17596481011709 ; 0x1000_FFFF_FFFD
}

; This constant can be materialized for RV64 with LUI+SRLI+XORI.

define i64 @imm_end_xori_1() nounwind {
; RV32I-LABEL: imm_end_xori_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 8192
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    lui a1, 917504
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_end_xori_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, -1
; RV64I-NEXT:    slli a0, a0, 36
; RV64I-NEXT:    addi a0, a0, 1
; RV64I-NEXT:    slli a0, a0, 25
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_end_xori_1:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -1
; RV64IZBA-NEXT:    slli a0, a0, 36
; RV64IZBA-NEXT:    addi a0, a0, 1
; RV64IZBA-NEXT:    slli a0, a0, 25
; RV64IZBA-NEXT:    addi a0, a0, -1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_end_xori_1:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -1
; RV64IZBB-NEXT:    slli a0, a0, 36
; RV64IZBB-NEXT:    addi a0, a0, 1
; RV64IZBB-NEXT:    slli a0, a0, 25
; RV64IZBB-NEXT:    addi a0, a0, -1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_end_xori_1:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, -1
; RV64IZBS-NEXT:    slli a0, a0, 36
; RV64IZBS-NEXT:    addi a0, a0, 1
; RV64IZBS-NEXT:    slli a0, a0, 25
; RV64IZBS-NEXT:    addi a0, a0, -1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_end_xori_1:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 36
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 25
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -2305843009180139521 ; 0xE000_0000_01FF_FFFF
}

; This constant can be materialized for RV64 with ADDI+SLLI+ADDI+ADDI.

define i64 @imm_end_2addi_1() nounwind {
; RV32I-LABEL: imm_end_2addi_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 1048575
; RV32I-NEXT:    addi a0, a0, 2047
; RV32I-NEXT:    lui a1, 1048512
; RV32I-NEXT:    addi a1, a1, 127
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_end_2addi_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, -2047
; RV64I-NEXT:    slli a0, a0, 27
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, 2047
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_end_2addi_1:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -2047
; RV64IZBA-NEXT:    slli a0, a0, 27
; RV64IZBA-NEXT:    addi a0, a0, -1
; RV64IZBA-NEXT:    slli a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, 2047
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_end_2addi_1:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -2047
; RV64IZBB-NEXT:    slli a0, a0, 27
; RV64IZBB-NEXT:    addi a0, a0, -1
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 2047
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_end_2addi_1:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, -2047
; RV64IZBS-NEXT:    slli a0, a0, 27
; RV64IZBS-NEXT:    addi a0, a0, -1
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    addi a0, a0, 2047
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_end_2addi_1:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -2047
; RV64IXTHEADBB-NEXT:    slli a0, a0, 27
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 2047
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -1125350151030785 ; 0xFFFC_007F_FFFF_F7FF
}

; This constant can be more efficiently materialized for RV64 if we use two
; registers instead of one.

define i64 @imm_2reg_1() nounwind {
; RV32I-LABEL: imm_2reg_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 74565
; RV32I-NEXT:    addi a0, a0, 1656
; RV32I-NEXT:    lui a1, 983040
; RV32I-NEXT:    ret
;
; RV64-NOPOOL-LABEL: imm_2reg_1:
; RV64-NOPOOL:       # %bb.0:
; RV64-NOPOOL-NEXT:    li a0, -1
; RV64-NOPOOL-NEXT:    slli a0, a0, 35
; RV64-NOPOOL-NEXT:    addi a0, a0, 9
; RV64-NOPOOL-NEXT:    slli a0, a0, 13
; RV64-NOPOOL-NEXT:    addi a0, a0, 837
; RV64-NOPOOL-NEXT:    slli a0, a0, 12
; RV64-NOPOOL-NEXT:    addi a0, a0, 1656
; RV64-NOPOOL-NEXT:    ret
;
; RV64I-POOL-LABEL: imm_2reg_1:
; RV64I-POOL:       # %bb.0:
; RV64I-POOL-NEXT:    lui a0, %hi(.LCPI27_0)
; RV64I-POOL-NEXT:    ld a0, %lo(.LCPI27_0)(a0)
; RV64I-POOL-NEXT:    ret
;
; RV64IZBA-LABEL: imm_2reg_1:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -1
; RV64IZBA-NEXT:    slli a0, a0, 35
; RV64IZBA-NEXT:    addi a0, a0, 9
; RV64IZBA-NEXT:    slli a0, a0, 13
; RV64IZBA-NEXT:    addi a0, a0, 837
; RV64IZBA-NEXT:    slli a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, 1656
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_2reg_1:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -1
; RV64IZBB-NEXT:    slli a0, a0, 35
; RV64IZBB-NEXT:    addi a0, a0, 9
; RV64IZBB-NEXT:    slli a0, a0, 13
; RV64IZBB-NEXT:    addi a0, a0, 837
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1656
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_2reg_1:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 74565
; RV64IZBS-NEXT:    addiw a0, a0, 1656
; RV64IZBS-NEXT:    bseti a0, a0, 60
; RV64IZBS-NEXT:    bseti a0, a0, 61
; RV64IZBS-NEXT:    bseti a0, a0, 62
; RV64IZBS-NEXT:    bseti a0, a0, 63
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_2reg_1:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 35
; RV64IXTHEADBB-NEXT:    addi a0, a0, 9
; RV64IXTHEADBB-NEXT:    slli a0, a0, 13
; RV64IXTHEADBB-NEXT:    addi a0, a0, 837
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1656
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -1152921504301427080 ; 0xF000_0000_1234_5678
}

; FIXME: This should use a single ADDI for the immediate.
define void @imm_store_i16_neg1(ptr %p) nounwind {
; RV32I-LABEL: imm_store_i16_neg1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, -1
; RV32I-NEXT:    sh a1, 0(a0)
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_store_i16_neg1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, -1
; RV64I-NEXT:    sh a1, 0(a0)
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_store_i16_neg1:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a1, -1
; RV64IZBA-NEXT:    sh a1, 0(a0)
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_store_i16_neg1:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a1, -1
; RV64IZBB-NEXT:    sh a1, 0(a0)
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_store_i16_neg1:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a1, -1
; RV64IZBS-NEXT:    sh a1, 0(a0)
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_store_i16_neg1:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a1, -1
; RV64IXTHEADBB-NEXT:    sh a1, 0(a0)
; RV64IXTHEADBB-NEXT:    ret
  store i16 -1, ptr %p
  ret void
}

; FIXME: This should use a single ADDI for the immediate.
define void @imm_store_i32_neg1(ptr %p) nounwind {
; RV32I-LABEL: imm_store_i32_neg1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, -1
; RV32I-NEXT:    sw a1, 0(a0)
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_store_i32_neg1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, -1
; RV64I-NEXT:    sw a1, 0(a0)
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_store_i32_neg1:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a1, -1
; RV64IZBA-NEXT:    sw a1, 0(a0)
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_store_i32_neg1:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a1, -1
; RV64IZBB-NEXT:    sw a1, 0(a0)
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_store_i32_neg1:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a1, -1
; RV64IZBS-NEXT:    sw a1, 0(a0)
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_store_i32_neg1:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a1, -1
; RV64IXTHEADBB-NEXT:    sw a1, 0(a0)
; RV64IXTHEADBB-NEXT:    ret
  store i32 -1, ptr %p
  ret void
}

define i64 @imm_5372288229() {
; RV32I-LABEL: imm_5372288229:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 263018
; RV32I-NEXT:    addi a0, a0, -795
; RV32I-NEXT:    li a1, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_5372288229:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 160
; RV64I-NEXT:    addiw a0, a0, 437
; RV64I-NEXT:    slli a0, a0, 13
; RV64I-NEXT:    addi a0, a0, -795
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_5372288229:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 655797
; RV64IZBA-NEXT:    slli.uw a0, a0, 1
; RV64IZBA-NEXT:    addi a0, a0, -795
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_5372288229:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 160
; RV64IZBB-NEXT:    addiw a0, a0, 437
; RV64IZBB-NEXT:    slli a0, a0, 13
; RV64IZBB-NEXT:    addi a0, a0, -795
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_5372288229:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 263018
; RV64IZBS-NEXT:    addiw a0, a0, -795
; RV64IZBS-NEXT:    bseti a0, a0, 32
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_5372288229:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 160
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 437
; RV64IXTHEADBB-NEXT:    slli a0, a0, 13
; RV64IXTHEADBB-NEXT:    addi a0, a0, -795
; RV64IXTHEADBB-NEXT:    ret
  ret i64 5372288229
}

define i64 @imm_neg_5372288229() {
; RV32I-LABEL: imm_neg_5372288229:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 785558
; RV32I-NEXT:    addi a0, a0, 795
; RV32I-NEXT:    li a1, -2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_neg_5372288229:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1048416
; RV64I-NEXT:    addiw a0, a0, -437
; RV64I-NEXT:    slli a0, a0, 13
; RV64I-NEXT:    addi a0, a0, 795
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_5372288229:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 611378
; RV64IZBA-NEXT:    addiw a0, a0, 265
; RV64IZBA-NEXT:    sh1add a0, a0, a0
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_5372288229:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 1048416
; RV64IZBB-NEXT:    addiw a0, a0, -437
; RV64IZBB-NEXT:    slli a0, a0, 13
; RV64IZBB-NEXT:    addi a0, a0, 795
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_5372288229:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 785558
; RV64IZBS-NEXT:    addiw a0, a0, 795
; RV64IZBS-NEXT:    bclri a0, a0, 32
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_5372288229:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 1048416
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -437
; RV64IXTHEADBB-NEXT:    slli a0, a0, 13
; RV64IXTHEADBB-NEXT:    addi a0, a0, 795
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -5372288229
}

define i64 @imm_8953813715() {
; RV32I-LABEL: imm_8953813715:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 88838
; RV32I-NEXT:    addi a0, a0, -1325
; RV32I-NEXT:    li a1, 2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_8953813715:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 267
; RV64I-NEXT:    addiw a0, a0, -637
; RV64I-NEXT:    slli a0, a0, 13
; RV64I-NEXT:    addi a0, a0, -1325
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_8953813715:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 437198
; RV64IZBA-NEXT:    addiw a0, a0, -265
; RV64IZBA-NEXT:    sh2add a0, a0, a0
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_8953813715:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 267
; RV64IZBB-NEXT:    addiw a0, a0, -637
; RV64IZBB-NEXT:    slli a0, a0, 13
; RV64IZBB-NEXT:    addi a0, a0, -1325
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_8953813715:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 88838
; RV64IZBS-NEXT:    addiw a0, a0, -1325
; RV64IZBS-NEXT:    bseti a0, a0, 33
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_8953813715:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 267
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -637
; RV64IXTHEADBB-NEXT:    slli a0, a0, 13
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1325
; RV64IXTHEADBB-NEXT:    ret
  ret i64 8953813715
}

define i64 @imm_neg_8953813715() {
; RV32I-LABEL: imm_neg_8953813715:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 959738
; RV32I-NEXT:    addi a0, a0, 1325
; RV32I-NEXT:    li a1, -3
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_neg_8953813715:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1048309
; RV64I-NEXT:    addiw a0, a0, 637
; RV64I-NEXT:    slli a0, a0, 13
; RV64I-NEXT:    addi a0, a0, 1325
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_8953813715:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 611378
; RV64IZBA-NEXT:    addiw a0, a0, 265
; RV64IZBA-NEXT:    sh2add a0, a0, a0
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_8953813715:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 1048309
; RV64IZBB-NEXT:    addiw a0, a0, 637
; RV64IZBB-NEXT:    slli a0, a0, 13
; RV64IZBB-NEXT:    addi a0, a0, 1325
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_8953813715:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 959738
; RV64IZBS-NEXT:    addiw a0, a0, 1325
; RV64IZBS-NEXT:    bclri a0, a0, 33
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_8953813715:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 1048309
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 637
; RV64IXTHEADBB-NEXT:    slli a0, a0, 13
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1325
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -8953813715
}

define i64 @imm_16116864687() {
; RV32I-LABEL: imm_16116864687:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 789053
; RV32I-NEXT:    addi a0, a0, 1711
; RV32I-NEXT:    li a1, 3
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_16116864687:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 961
; RV64I-NEXT:    addiw a0, a0, -1475
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, 1711
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_16116864687:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 437198
; RV64IZBA-NEXT:    addiw a0, a0, -265
; RV64IZBA-NEXT:    sh3add a0, a0, a0
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_16116864687:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 961
; RV64IZBB-NEXT:    addiw a0, a0, -1475
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1711
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_16116864687:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 961
; RV64IZBS-NEXT:    addiw a0, a0, -1475
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    addi a0, a0, 1711
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_16116864687:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 961
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1475
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1711
; RV64IXTHEADBB-NEXT:    ret
  ret i64 16116864687
}

define i64 @imm_neg_16116864687() {
; RV32I-LABEL: imm_neg_16116864687:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 259523
; RV32I-NEXT:    addi a0, a0, -1711
; RV32I-NEXT:    li a1, -4
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_neg_16116864687:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1047615
; RV64I-NEXT:    addiw a0, a0, 1475
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, -1711
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_16116864687:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 611378
; RV64IZBA-NEXT:    addiw a0, a0, 265
; RV64IZBA-NEXT:    sh3add a0, a0, a0
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_16116864687:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 1047615
; RV64IZBB-NEXT:    addiw a0, a0, 1475
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, -1711
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_16116864687:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 1047615
; RV64IZBS-NEXT:    addiw a0, a0, 1475
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    addi a0, a0, -1711
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_16116864687:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 1047615
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 1475
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1711
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -16116864687
}

define i64 @imm_2344336315() {
; RV32I-LABEL: imm_2344336315:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 572348
; RV32I-NEXT:    addi a0, a0, -1093
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_2344336315:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 143087
; RV64I-NEXT:    slli a0, a0, 2
; RV64I-NEXT:    addi a0, a0, -1093
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_2344336315:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 143087
; RV64IZBA-NEXT:    slli a0, a0, 2
; RV64IZBA-NEXT:    addi a0, a0, -1093
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_2344336315:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 143087
; RV64IZBB-NEXT:    slli a0, a0, 2
; RV64IZBB-NEXT:    addi a0, a0, -1093
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_2344336315:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 143087
; RV64IZBS-NEXT:    slli a0, a0, 2
; RV64IZBS-NEXT:    addi a0, a0, -1093
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_2344336315:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 143087
; RV64IXTHEADBB-NEXT:    slli a0, a0, 2
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1093
; RV64IXTHEADBB-NEXT:    ret
  ret i64 2344336315 ; 0x8bbbbbbb
}

define i64 @imm_70370820078523() {
; RV32I-LABEL: imm_70370820078523:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 506812
; RV32I-NEXT:    addi a0, a0, -1093
; RV32I-NEXT:    lui a1, 4
; RV32I-NEXT:    ret
;
; RV64-NOPOOL-LABEL: imm_70370820078523:
; RV64-NOPOOL:       # %bb.0:
; RV64-NOPOOL-NEXT:    lui a0, 256
; RV64-NOPOOL-NEXT:    addiw a0, a0, 31
; RV64-NOPOOL-NEXT:    slli a0, a0, 12
; RV64-NOPOOL-NEXT:    addi a0, a0, -273
; RV64-NOPOOL-NEXT:    slli a0, a0, 14
; RV64-NOPOOL-NEXT:    addi a0, a0, -1093
; RV64-NOPOOL-NEXT:    ret
;
; RV64I-POOL-LABEL: imm_70370820078523:
; RV64I-POOL:       # %bb.0:
; RV64I-POOL-NEXT:    lui a0, %hi(.LCPI37_0)
; RV64I-POOL-NEXT:    ld a0, %lo(.LCPI37_0)(a0)
; RV64I-POOL-NEXT:    ret
;
; RV64IZBA-LABEL: imm_70370820078523:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 256
; RV64IZBA-NEXT:    addiw a0, a0, 31
; RV64IZBA-NEXT:    slli a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, -273
; RV64IZBA-NEXT:    slli a0, a0, 14
; RV64IZBA-NEXT:    addi a0, a0, -1093
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_70370820078523:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 256
; RV64IZBB-NEXT:    addiw a0, a0, 31
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, -273
; RV64IZBB-NEXT:    slli a0, a0, 14
; RV64IZBB-NEXT:    addi a0, a0, -1093
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_70370820078523:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 506812
; RV64IZBS-NEXT:    addiw a0, a0, -1093
; RV64IZBS-NEXT:    bseti a0, a0, 46
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_70370820078523:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 256
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 31
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, -273
; RV64IXTHEADBB-NEXT:    slli a0, a0, 14
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1093
; RV64IXTHEADBB-NEXT:    ret
  ret i64 70370820078523 ; 0x40007bbbbbbb
}

define i64 @imm_neg_9223372034778874949() {
; RV32I-LABEL: imm_neg_9223372034778874949:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 506812
; RV32I-NEXT:    addi a0, a0, -1093
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    ret
;
; RV64-NOPOOL-LABEL: imm_neg_9223372034778874949:
; RV64-NOPOOL:       # %bb.0:
; RV64-NOPOOL-NEXT:    li a0, -1
; RV64-NOPOOL-NEXT:    slli a0, a0, 37
; RV64-NOPOOL-NEXT:    addi a0, a0, 31
; RV64-NOPOOL-NEXT:    slli a0, a0, 12
; RV64-NOPOOL-NEXT:    addi a0, a0, -273
; RV64-NOPOOL-NEXT:    slli a0, a0, 14
; RV64-NOPOOL-NEXT:    addi a0, a0, -1093
; RV64-NOPOOL-NEXT:    ret
;
; RV64I-POOL-LABEL: imm_neg_9223372034778874949:
; RV64I-POOL:       # %bb.0:
; RV64I-POOL-NEXT:    lui a0, %hi(.LCPI38_0)
; RV64I-POOL-NEXT:    ld a0, %lo(.LCPI38_0)(a0)
; RV64I-POOL-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_9223372034778874949:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -1
; RV64IZBA-NEXT:    slli a0, a0, 37
; RV64IZBA-NEXT:    addi a0, a0, 31
; RV64IZBA-NEXT:    slli a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, -273
; RV64IZBA-NEXT:    slli a0, a0, 14
; RV64IZBA-NEXT:    addi a0, a0, -1093
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_9223372034778874949:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -1
; RV64IZBB-NEXT:    slli a0, a0, 37
; RV64IZBB-NEXT:    addi a0, a0, 31
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, -273
; RV64IZBB-NEXT:    slli a0, a0, 14
; RV64IZBB-NEXT:    addi a0, a0, -1093
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_9223372034778874949:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 506812
; RV64IZBS-NEXT:    addiw a0, a0, -1093
; RV64IZBS-NEXT:    bseti a0, a0, 63
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_9223372034778874949:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 37
; RV64IXTHEADBB-NEXT:    addi a0, a0, 31
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, -273
; RV64IXTHEADBB-NEXT:    slli a0, a0, 14
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1093
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -9223372034778874949 ; 0x800000007bbbbbbb
}

define i64 @imm_neg_9223301666034697285() {
; RV32I-LABEL: imm_neg_9223301666034697285:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 506812
; RV32I-NEXT:    addi a0, a0, -1093
; RV32I-NEXT:    lui a1, 524292
; RV32I-NEXT:    ret
;
; RV64-NOPOOL-LABEL: imm_neg_9223301666034697285:
; RV64-NOPOOL:       # %bb.0:
; RV64-NOPOOL-NEXT:    lui a0, 917505
; RV64-NOPOOL-NEXT:    slli a0, a0, 8
; RV64-NOPOOL-NEXT:    addi a0, a0, 31
; RV64-NOPOOL-NEXT:    slli a0, a0, 12
; RV64-NOPOOL-NEXT:    addi a0, a0, -273
; RV64-NOPOOL-NEXT:    slli a0, a0, 14
; RV64-NOPOOL-NEXT:    addi a0, a0, -1093
; RV64-NOPOOL-NEXT:    ret
;
; RV64I-POOL-LABEL: imm_neg_9223301666034697285:
; RV64I-POOL:       # %bb.0:
; RV64I-POOL-NEXT:    lui a0, %hi(.LCPI39_0)
; RV64I-POOL-NEXT:    ld a0, %lo(.LCPI39_0)(a0)
; RV64I-POOL-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_9223301666034697285:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 917505
; RV64IZBA-NEXT:    slli a0, a0, 8
; RV64IZBA-NEXT:    addi a0, a0, 31
; RV64IZBA-NEXT:    slli a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, -273
; RV64IZBA-NEXT:    slli a0, a0, 14
; RV64IZBA-NEXT:    addi a0, a0, -1093
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_9223301666034697285:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 917505
; RV64IZBB-NEXT:    slli a0, a0, 8
; RV64IZBB-NEXT:    addi a0, a0, 31
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, -273
; RV64IZBB-NEXT:    slli a0, a0, 14
; RV64IZBB-NEXT:    addi a0, a0, -1093
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_9223301666034697285:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 506812
; RV64IZBS-NEXT:    addiw a0, a0, -1093
; RV64IZBS-NEXT:    bseti a0, a0, 46
; RV64IZBS-NEXT:    bseti a0, a0, 63
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_9223301666034697285:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 917505
; RV64IXTHEADBB-NEXT:    slli a0, a0, 8
; RV64IXTHEADBB-NEXT:    addi a0, a0, 31
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, -273
; RV64IXTHEADBB-NEXT:    slli a0, a0, 14
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1093
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -9223301666034697285 ; 0x800040007bbbbbbb
}

define i64 @imm_neg_2219066437() {
; RV32I-LABEL: imm_neg_2219066437:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 506812
; RV32I-NEXT:    addi a0, a0, -1093
; RV32I-NEXT:    li a1, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_neg_2219066437:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 913135
; RV64I-NEXT:    slli a0, a0, 2
; RV64I-NEXT:    addi a0, a0, -1093
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_2219066437:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 913135
; RV64IZBA-NEXT:    slli a0, a0, 2
; RV64IZBA-NEXT:    addi a0, a0, -1093
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_2219066437:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 913135
; RV64IZBB-NEXT:    slli a0, a0, 2
; RV64IZBB-NEXT:    addi a0, a0, -1093
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_2219066437:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 913135
; RV64IZBS-NEXT:    slli a0, a0, 2
; RV64IZBS-NEXT:    addi a0, a0, -1093
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_2219066437:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 913135
; RV64IXTHEADBB-NEXT:    slli a0, a0, 2
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1093
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -2219066437 ; 0xffffffff7bbbbbbb
}

define i64 @imm_neg_8798043653189() {
; RV32I-LABEL: imm_neg_8798043653189:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 572348
; RV32I-NEXT:    addi a0, a0, -1093
; RV32I-NEXT:    lui a1, 1048575
; RV32I-NEXT:    addi a1, a1, 2047
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_neg_8798043653189:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 917475
; RV64I-NEXT:    addiw a0, a0, -273
; RV64I-NEXT:    slli a0, a0, 14
; RV64I-NEXT:    addi a0, a0, -1093
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_8798043653189:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 917475
; RV64IZBA-NEXT:    addiw a0, a0, -273
; RV64IZBA-NEXT:    slli a0, a0, 14
; RV64IZBA-NEXT:    addi a0, a0, -1093
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_8798043653189:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 917475
; RV64IZBB-NEXT:    addiw a0, a0, -273
; RV64IZBB-NEXT:    slli a0, a0, 14
; RV64IZBB-NEXT:    addi a0, a0, -1093
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_8798043653189:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 572348
; RV64IZBS-NEXT:    addiw a0, a0, -1093
; RV64IZBS-NEXT:    bclri a0, a0, 43
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_8798043653189:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 917475
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -273
; RV64IXTHEADBB-NEXT:    slli a0, a0, 14
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1093
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -8798043653189 ; 0xfffff7ff8bbbbbbb
}

define i64 @imm_9223372034904144827() {
; RV32I-LABEL: imm_9223372034904144827:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 572348
; RV32I-NEXT:    addi a0, a0, -1093
; RV32I-NEXT:    lui a1, 524288
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_9223372034904144827:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1048343
; RV64I-NEXT:    addiw a0, a0, 1911
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, 1911
; RV64I-NEXT:    srli a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_9223372034904144827:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 1048343
; RV64IZBA-NEXT:    addiw a0, a0, 1911
; RV64IZBA-NEXT:    slli a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, 1911
; RV64IZBA-NEXT:    srli a0, a0, 1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_9223372034904144827:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 1048343
; RV64IZBB-NEXT:    addiw a0, a0, 1911
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1911
; RV64IZBB-NEXT:    srli a0, a0, 1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_9223372034904144827:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 572348
; RV64IZBS-NEXT:    addiw a0, a0, -1093
; RV64IZBS-NEXT:    bclri a0, a0, 63
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_9223372034904144827:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 1048343
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 1911
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1911
; RV64IXTHEADBB-NEXT:    srli a0, a0, 1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 9223372034904144827 ; 0x7fffffff8bbbbbbb
}

define i64 @imm_neg_9223354442718100411() {
; RV32I-LABEL: imm_neg_9223354442718100411:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 572348
; RV32I-NEXT:    addi a0, a0, -1093
; RV32I-NEXT:    lui a1, 524287
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    ret
;
; RV64-NOPOOL-LABEL: imm_neg_9223354442718100411:
; RV64-NOPOOL:       # %bb.0:
; RV64-NOPOOL-NEXT:    lui a0, 524287
; RV64-NOPOOL-NEXT:    slli a0, a0, 6
; RV64-NOPOOL-NEXT:    addi a0, a0, -29
; RV64-NOPOOL-NEXT:    slli a0, a0, 12
; RV64-NOPOOL-NEXT:    addi a0, a0, -273
; RV64-NOPOOL-NEXT:    slli a0, a0, 14
; RV64-NOPOOL-NEXT:    addi a0, a0, -1093
; RV64-NOPOOL-NEXT:    ret
;
; RV64I-POOL-LABEL: imm_neg_9223354442718100411:
; RV64I-POOL:       # %bb.0:
; RV64I-POOL-NEXT:    lui a0, %hi(.LCPI43_0)
; RV64I-POOL-NEXT:    ld a0, %lo(.LCPI43_0)(a0)
; RV64I-POOL-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_9223354442718100411:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 524287
; RV64IZBA-NEXT:    slli a0, a0, 6
; RV64IZBA-NEXT:    addi a0, a0, -29
; RV64IZBA-NEXT:    slli a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, -273
; RV64IZBA-NEXT:    slli a0, a0, 14
; RV64IZBA-NEXT:    addi a0, a0, -1093
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_9223354442718100411:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 524287
; RV64IZBB-NEXT:    slli a0, a0, 6
; RV64IZBB-NEXT:    addi a0, a0, -29
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, -273
; RV64IZBB-NEXT:    slli a0, a0, 14
; RV64IZBB-NEXT:    addi a0, a0, -1093
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_9223354442718100411:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 572348
; RV64IZBS-NEXT:    addiw a0, a0, -1093
; RV64IZBS-NEXT:    bclri a0, a0, 44
; RV64IZBS-NEXT:    bclri a0, a0, 63
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_9223354442718100411:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 524287
; RV64IXTHEADBB-NEXT:    slli a0, a0, 6
; RV64IXTHEADBB-NEXT:    addi a0, a0, -29
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, -273
; RV64IXTHEADBB-NEXT:    slli a0, a0, 14
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1093
; RV64IXTHEADBB-NEXT:    ret
  ret i64 9223354442718100411 ; 0x7fffefff8bbbbbbb
}

define i64 @imm_2863311530() {
; RV32I-LABEL: imm_2863311530:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 699051
; RV32I-NEXT:    addi a0, a0, -1366
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_2863311530:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    slli a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_2863311530:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 349525
; RV64IZBA-NEXT:    addiw a0, a0, 1365
; RV64IZBA-NEXT:    slli a0, a0, 1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_2863311530:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 349525
; RV64IZBB-NEXT:    addiw a0, a0, 1365
; RV64IZBB-NEXT:    slli a0, a0, 1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_2863311530:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 349525
; RV64IZBS-NEXT:    addiw a0, a0, 1365
; RV64IZBS-NEXT:    slli a0, a0, 1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_2863311530:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 349525
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 1365
; RV64IXTHEADBB-NEXT:    slli a0, a0, 1
; RV64IXTHEADBB-NEXT:    ret
	ret i64 2863311530 ; #0xaaaaaaaa
}

define i64 @imm_neg_2863311530() {
; RV32I-LABEL: imm_neg_2863311530:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1366
; RV32I-NEXT:    li a1, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_neg_2863311530:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 699051
; RV64I-NEXT:    addiw a0, a0, -1365
; RV64I-NEXT:    slli a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_2863311530:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 699051
; RV64IZBA-NEXT:    addiw a0, a0, -1365
; RV64IZBA-NEXT:    slli a0, a0, 1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_2863311530:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 699051
; RV64IZBB-NEXT:    addiw a0, a0, -1365
; RV64IZBB-NEXT:    slli a0, a0, 1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_2863311530:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 699051
; RV64IZBS-NEXT:    addiw a0, a0, -1365
; RV64IZBS-NEXT:    slli a0, a0, 1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_2863311530:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 699051
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1365
; RV64IXTHEADBB-NEXT:    slli a0, a0, 1
; RV64IXTHEADBB-NEXT:    ret
	ret i64 -2863311530 ; #0xffffffff55555556
}

define i64 @imm_2147486378() {
; RV32I-LABEL: imm_2147486378:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 524288
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_2147486378:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    slli a0, a0, 31
; RV64I-NEXT:    addi a0, a0, 1365
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_2147486378:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, 1
; RV64IZBA-NEXT:    slli a0, a0, 31
; RV64IZBA-NEXT:    addi a0, a0, 1365
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_2147486378:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, 1
; RV64IZBB-NEXT:    slli a0, a0, 31
; RV64IZBB-NEXT:    addi a0, a0, 1365
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_2147486378:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, 1365
; RV64IZBS-NEXT:    bseti a0, a0, 31
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_2147486378:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, 1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 31
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1365
; RV64IXTHEADBB-NEXT:    ret
  ret i64 2147485013
}

define i64 @imm_neg_2147485013() {
; RV32I-LABEL: imm_neg_2147485013:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 524288
; RV32I-NEXT:    addi a0, a0, -1365
; RV32I-NEXT:    li a1, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_neg_2147485013:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 524288
; RV64I-NEXT:    addi a0, a0, -1365
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_2147485013:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 524288
; RV64IZBA-NEXT:    addi a0, a0, -1365
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_2147485013:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 524288
; RV64IZBB-NEXT:    addi a0, a0, -1365
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_2147485013:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 524288
; RV64IZBS-NEXT:    addi a0, a0, -1365
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_2147485013:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 524288
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1365
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -2147485013
}

define i64 @imm_12900924131259() {
; RV32I-LABEL: imm_12900924131259:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 765952
; RV32I-NEXT:    addi a0, a0, 1979
; RV32I-NEXT:    lui a1, 1
; RV32I-NEXT:    addi a1, a1, -1093
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_12900924131259:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 188
; RV64I-NEXT:    addiw a0, a0, -1093
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    addi a0, a0, 1979
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_12900924131259:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 768955
; RV64IZBA-NEXT:    slli.uw a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, 1979
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_12900924131259:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 188
; RV64IZBB-NEXT:    addiw a0, a0, -1093
; RV64IZBB-NEXT:    slli a0, a0, 24
; RV64IZBB-NEXT:    addi a0, a0, 1979
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_12900924131259:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 188
; RV64IZBS-NEXT:    addiw a0, a0, -1093
; RV64IZBS-NEXT:    slli a0, a0, 24
; RV64IZBS-NEXT:    addi a0, a0, 1979
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_12900924131259:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 188
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1093
; RV64IXTHEADBB-NEXT:    slli a0, a0, 24
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1979
; RV64IXTHEADBB-NEXT:    ret
  ret i64 12900924131259
}

define i64 @imm_50394234880() {
; RV32I-LABEL: imm_50394234880:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 768944
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_50394234880:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 188
; RV64I-NEXT:    addiw a0, a0, -1093
; RV64I-NEXT:    slli a0, a0, 16
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_50394234880:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 768955
; RV64IZBA-NEXT:    slli.uw a0, a0, 4
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_50394234880:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 188
; RV64IZBB-NEXT:    addiw a0, a0, -1093
; RV64IZBB-NEXT:    slli a0, a0, 16
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_50394234880:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 188
; RV64IZBS-NEXT:    addiw a0, a0, -1093
; RV64IZBS-NEXT:    slli a0, a0, 16
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_50394234880:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 188
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1093
; RV64IXTHEADBB-NEXT:    slli a0, a0, 16
; RV64IXTHEADBB-NEXT:    ret
  ret i64 50394234880
}

define i64 @imm_12900936431479() {
; RV32I-LABEL: imm_12900936431479:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 768955
; RV32I-NEXT:    addi a0, a0, 1911
; RV32I-NEXT:    lui a1, 1
; RV32I-NEXT:    addi a1, a1, -1093
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_12900936431479:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 192239
; RV64I-NEXT:    slli a0, a0, 2
; RV64I-NEXT:    addi a0, a0, -1093
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, 1911
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_12900936431479:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 768956
; RV64IZBA-NEXT:    addiw a0, a0, -1093
; RV64IZBA-NEXT:    slli.uw a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, 1911
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_12900936431479:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 192239
; RV64IZBB-NEXT:    slli a0, a0, 2
; RV64IZBB-NEXT:    addi a0, a0, -1093
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1911
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_12900936431479:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 192239
; RV64IZBS-NEXT:    slli a0, a0, 2
; RV64IZBS-NEXT:    addi a0, a0, -1093
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    addi a0, a0, 1911
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_12900936431479:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 192239
; RV64IXTHEADBB-NEXT:    slli a0, a0, 2
; RV64IXTHEADBB-NEXT:    addi a0, a0, -1093
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1911
; RV64IXTHEADBB-NEXT:    ret
  ret i64 12900936431479
}

define i64 @imm_12900918536874() {
; RV32I-LABEL: imm_12900918536874:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 764587
; RV32I-NEXT:    addi a0, a0, -1366
; RV32I-NEXT:    lui a1, 1
; RV32I-NEXT:    addi a1, a1, -1093
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_12900918536874:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 384477
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, 1365
; RV64I-NEXT:    slli a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_12900918536874:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 768955
; RV64IZBA-NEXT:    addiw a0, a0, -1365
; RV64IZBA-NEXT:    slli.uw a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, -1366
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_12900918536874:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 384477
; RV64IZBB-NEXT:    addiw a0, a0, 1365
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1365
; RV64IZBB-NEXT:    slli a0, a0, 1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_12900918536874:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 384477
; RV64IZBS-NEXT:    addiw a0, a0, 1365
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    addi a0, a0, 1365
; RV64IZBS-NEXT:    slli a0, a0, 1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_12900918536874:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 384477
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 1365
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1365
; RV64IXTHEADBB-NEXT:    slli a0, a0, 1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 12900918536874
}

define i64 @imm_12900925247761() {
; RV32I-LABEL: imm_12900925247761:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 766225
; RV32I-NEXT:    addi a0, a0, 273
; RV32I-NEXT:    lui a1, 1
; RV32I-NEXT:    addi a1, a1, -1093
; RV32I-NEXT:    ret
;
; RV64-NOPOOL-LABEL: imm_12900925247761:
; RV64-NOPOOL:       # %bb.0:
; RV64-NOPOOL-NEXT:    lui a0, 188
; RV64-NOPOOL-NEXT:    addiw a0, a0, -1093
; RV64-NOPOOL-NEXT:    slli a0, a0, 12
; RV64-NOPOOL-NEXT:    addi a0, a0, 273
; RV64-NOPOOL-NEXT:    slli a0, a0, 12
; RV64-NOPOOL-NEXT:    addi a0, a0, 273
; RV64-NOPOOL-NEXT:    ret
;
; RV64I-POOL-LABEL: imm_12900925247761:
; RV64I-POOL:       # %bb.0:
; RV64I-POOL-NEXT:    lui a0, %hi(.LCPI52_0)
; RV64I-POOL-NEXT:    ld a0, %lo(.LCPI52_0)(a0)
; RV64I-POOL-NEXT:    ret
;
; RV64IZBA-LABEL: imm_12900925247761:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 768955
; RV64IZBA-NEXT:    addiw a0, a0, 273
; RV64IZBA-NEXT:    slli.uw a0, a0, 12
; RV64IZBA-NEXT:    addi a0, a0, 273
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_12900925247761:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 188
; RV64IZBB-NEXT:    addiw a0, a0, -1093
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 273
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 273
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_12900925247761:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 188
; RV64IZBS-NEXT:    addiw a0, a0, -1093
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    addi a0, a0, 273
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    addi a0, a0, 273
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_12900925247761:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 188
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1093
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 273
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 273
; RV64IXTHEADBB-NEXT:    ret
  ret i64 12900925247761
}

define i64 @imm_7158272001() {
; RV32I-LABEL: imm_7158272001:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 699049
; RV32I-NEXT:    addi a0, a0, 1
; RV32I-NEXT:    li a1, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_7158272001:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 427
; RV64I-NEXT:    addiw a0, a0, -1367
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_7158272001:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 349525
; RV64IZBA-NEXT:    sh2add a0, a0, a0
; RV64IZBA-NEXT:    addi a0, a0, 1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_7158272001:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 427
; RV64IZBB-NEXT:    addiw a0, a0, -1367
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_7158272001:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 427
; RV64IZBS-NEXT:    addiw a0, a0, -1367
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    addi a0, a0, 1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_7158272001:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 427
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1367
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 7158272001 ; 0x0000_0001_aaaa_9001
}

define i64 @imm_12884889601() {
; RV32I-LABEL: imm_12884889601:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 1048573
; RV32I-NEXT:    addi a0, a0, 1
; RV32I-NEXT:    li a1, 2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_12884889601:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 768
; RV64I-NEXT:    addiw a0, a0, -3
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_12884889601:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 349525
; RV64IZBA-NEXT:    sh3add a0, a0, a0
; RV64IZBA-NEXT:    addi a0, a0, 1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_12884889601:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 768
; RV64IZBB-NEXT:    addiw a0, a0, -3
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_12884889601:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 768
; RV64IZBS-NEXT:    addiw a0, a0, -3
; RV64IZBS-NEXT:    slli a0, a0, 12
; RV64IZBS-NEXT:    addi a0, a0, 1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_12884889601:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 768
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -3
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 12884889601 ; 0x0000_0002_ffff_d001
}

define i64 @imm_neg_3435982847() {
; RV32I-LABEL: imm_neg_3435982847:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 209713
; RV32I-NEXT:    addi a0, a0, 1
; RV32I-NEXT:    li a1, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_neg_3435982847:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1048371
; RV64I-NEXT:    addiw a0, a0, 817
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_3435982847:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 768955
; RV64IZBA-NEXT:    sh1add a0, a0, a0
; RV64IZBA-NEXT:    addi a0, a0, 1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_3435982847:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 1048371
; RV64IZBB-NEXT:    addiw a0, a0, 817
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_3435982847:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 734001
; RV64IZBS-NEXT:    addiw a0, a0, 1
; RV64IZBS-NEXT:    bclri a0, a0, 31
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_3435982847:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 1048371
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 817
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -3435982847 ; 0xffff_ffff_3333_1001
}

define i64 @imm_neg_5726842879() {
; RV32I-LABEL: imm_neg_5726842879:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 698997
; RV32I-NEXT:    addi a0, a0, 1
; RV32I-NEXT:    li a1, -2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_neg_5726842879:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1048235
; RV64I-NEXT:    addiw a0, a0, -1419
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_5726842879:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 768945
; RV64IZBA-NEXT:    sh2add a0, a0, a0
; RV64IZBA-NEXT:    addi a0, a0, 1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_5726842879:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 1048235
; RV64IZBB-NEXT:    addiw a0, a0, -1419
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_5726842879:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 698997
; RV64IZBS-NEXT:    addiw a0, a0, 1
; RV64IZBS-NEXT:    bclri a0, a0, 32
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_5726842879:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 1048235
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1419
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -5726842879 ; 0xffff_fffe_aaa7_5001
}

define i64 @imm_neg_10307948543() {
; RV32I-LABEL: imm_neg_10307948543:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 629139
; RV32I-NEXT:    addi a0, a0, 1
; RV32I-NEXT:    li a1, -3
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm_neg_10307948543:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1047962
; RV64I-NEXT:    addiw a0, a0, -1645
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    addi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm_neg_10307948543:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 768955
; RV64IZBA-NEXT:    sh3add a0, a0, a0
; RV64IZBA-NEXT:    addi a0, a0, 1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm_neg_10307948543:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 1047962
; RV64IZBB-NEXT:    addiw a0, a0, -1645
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    addi a0, a0, 1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm_neg_10307948543:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 629139
; RV64IZBS-NEXT:    addiw a0, a0, 1
; RV64IZBS-NEXT:    bclri a0, a0, 33
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm_neg_10307948543:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 1047962
; RV64IXTHEADBB-NEXT:    addiw a0, a0, -1645
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    addi a0, a0, 1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -10307948543 ; 0xffff_fffd_9999_3001
}

define i64 @li_rori_1() {
; RV32I-LABEL: li_rori_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 1048567
; RV32I-NEXT:    addi a1, a0, 2047
; RV32I-NEXT:    li a0, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: li_rori_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, -17
; RV64I-NEXT:    slli a0, a0, 43
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: li_rori_1:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -17
; RV64IZBA-NEXT:    slli a0, a0, 43
; RV64IZBA-NEXT:    addi a0, a0, -1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: li_rori_1:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -18
; RV64IZBB-NEXT:    rori a0, a0, 21
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: li_rori_1:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, -17
; RV64IZBS-NEXT:    slli a0, a0, 43
; RV64IZBS-NEXT:    addi a0, a0, -1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: li_rori_1:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -18
; RV64IXTHEADBB-NEXT:    th.srri a0, a0, 21
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -149533581377537
}

define i64 @li_rori_2() {
; RV32I-LABEL: li_rori_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 720896
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    li a0, -6
; RV32I-NEXT:    ret
;
; RV64I-LABEL: li_rori_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, -5
; RV64I-NEXT:    slli a0, a0, 60
; RV64I-NEXT:    addi a0, a0, -6
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: li_rori_2:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -5
; RV64IZBA-NEXT:    slli a0, a0, 60
; RV64IZBA-NEXT:    addi a0, a0, -6
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: li_rori_2:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -86
; RV64IZBB-NEXT:    rori a0, a0, 4
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: li_rori_2:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, -5
; RV64IZBS-NEXT:    slli a0, a0, 60
; RV64IZBS-NEXT:    addi a0, a0, -6
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: li_rori_2:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -86
; RV64IXTHEADBB-NEXT:    th.srri a0, a0, 4
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -5764607523034234886
}

define i64 @li_rori_3() {
; RV32I-LABEL: li_rori_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 491520
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    li a1, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: li_rori_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, -17
; RV64I-NEXT:    slli a0, a0, 27
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: li_rori_3:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, -17
; RV64IZBA-NEXT:    slli a0, a0, 27
; RV64IZBA-NEXT:    addi a0, a0, -1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: li_rori_3:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, -18
; RV64IZBB-NEXT:    rori a0, a0, 37
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: li_rori_3:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    li a0, -17
; RV64IZBS-NEXT:    slli a0, a0, 27
; RV64IZBS-NEXT:    addi a0, a0, -1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: li_rori_3:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, -18
; RV64IXTHEADBB-NEXT:    th.srri a0, a0, 37
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -2281701377
}

; This used to assert when compiled with Zba.
define i64 @PR54812() {
; RV32I-LABEL: PR54812:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 521599
; RV32I-NEXT:    li a1, -1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: PR54812:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 1048447
; RV64I-NEXT:    addiw a0, a0, 1407
; RV64I-NEXT:    slli a0, a0, 12
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: PR54812:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 872917
; RV64IZBA-NEXT:    sh1add a0, a0, a0
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: PR54812:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 1048447
; RV64IZBB-NEXT:    addiw a0, a0, 1407
; RV64IZBB-NEXT:    slli a0, a0, 12
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: PR54812:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 1045887
; RV64IZBS-NEXT:    bclri a0, a0, 31
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: PR54812:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 1048447
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 1407
; RV64IXTHEADBB-NEXT:    slli a0, a0, 12
; RV64IXTHEADBB-NEXT:    ret
  ret i64 -2158497792;
}

define signext i32 @pos_2048() nounwind {
; RV32I-LABEL: pos_2048:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    slli a0, a0, 11
; RV32I-NEXT:    ret
;
; RV64I-LABEL: pos_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    slli a0, a0, 11
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: pos_2048:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    li a0, 1
; RV64IZBA-NEXT:    slli a0, a0, 11
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: pos_2048:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    li a0, 1
; RV64IZBB-NEXT:    slli a0, a0, 11
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: pos_2048:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    bseti a0, zero, 11
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: pos_2048:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    li a0, 1
; RV64IXTHEADBB-NEXT:    slli a0, a0, 11
; RV64IXTHEADBB-NEXT:    ret
  ret i32 2048
}

define i64 @imm64_same_lo_hi() nounwind {
; RV32I-LABEL: imm64_same_lo_hi:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 65793
; RV32I-NEXT:    addi a0, a0, 16
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: imm64_same_lo_hi:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 65793
; RV64I-NEXT:    addiw a0, a0, 16
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_same_lo_hi:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 65793
; RV64IZBA-NEXT:    addiw a0, a0, 16
; RV64IZBA-NEXT:    slli a1, a0, 32
; RV64IZBA-NEXT:    add a0, a0, a1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_same_lo_hi:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 65793
; RV64IZBB-NEXT:    addiw a0, a0, 16
; RV64IZBB-NEXT:    slli a1, a0, 32
; RV64IZBB-NEXT:    add a0, a0, a1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_same_lo_hi:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 65793
; RV64IZBS-NEXT:    addiw a0, a0, 16
; RV64IZBS-NEXT:    slli a1, a0, 32
; RV64IZBS-NEXT:    add a0, a0, a1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_same_lo_hi:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 65793
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 16
; RV64IXTHEADBB-NEXT:    slli a1, a0, 32
; RV64IXTHEADBB-NEXT:    add a0, a0, a1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 1157442765409226768 ; 0x0101010101010101
}

; Same as above with optsize. Make sure we use constant pool on RV64
define i64 @imm64_same_lo_hi_optsize() nounwind optsize {
; RV32I-LABEL: imm64_same_lo_hi_optsize:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 65793
; RV32I-NEXT:    addi a0, a0, 16
; RV32I-NEXT:    mv a1, a0
; RV32I-NEXT:    ret
;
; RV64-NOPOOL-LABEL: imm64_same_lo_hi_optsize:
; RV64-NOPOOL:       # %bb.0:
; RV64-NOPOOL-NEXT:    lui a0, 65793
; RV64-NOPOOL-NEXT:    addiw a0, a0, 16
; RV64-NOPOOL-NEXT:    slli a1, a0, 32
; RV64-NOPOOL-NEXT:    add a0, a0, a1
; RV64-NOPOOL-NEXT:    ret
;
; RV64I-POOL-LABEL: imm64_same_lo_hi_optsize:
; RV64I-POOL:       # %bb.0:
; RV64I-POOL-NEXT:    lui a0, %hi(.LCPI64_0)
; RV64I-POOL-NEXT:    ld a0, %lo(.LCPI64_0)(a0)
; RV64I-POOL-NEXT:    ret
;
; RV64IZBA-LABEL: imm64_same_lo_hi_optsize:
; RV64IZBA:       # %bb.0:
; RV64IZBA-NEXT:    lui a0, 65793
; RV64IZBA-NEXT:    addiw a0, a0, 16
; RV64IZBA-NEXT:    slli a1, a0, 32
; RV64IZBA-NEXT:    add a0, a0, a1
; RV64IZBA-NEXT:    ret
;
; RV64IZBB-LABEL: imm64_same_lo_hi_optsize:
; RV64IZBB:       # %bb.0:
; RV64IZBB-NEXT:    lui a0, 65793
; RV64IZBB-NEXT:    addiw a0, a0, 16
; RV64IZBB-NEXT:    slli a1, a0, 32
; RV64IZBB-NEXT:    add a0, a0, a1
; RV64IZBB-NEXT:    ret
;
; RV64IZBS-LABEL: imm64_same_lo_hi_optsize:
; RV64IZBS:       # %bb.0:
; RV64IZBS-NEXT:    lui a0, 65793
; RV64IZBS-NEXT:    addiw a0, a0, 16
; RV64IZBS-NEXT:    slli a1, a0, 32
; RV64IZBS-NEXT:    add a0, a0, a1
; RV64IZBS-NEXT:    ret
;
; RV64IXTHEADBB-LABEL: imm64_same_lo_hi_optsize:
; RV64IXTHEADBB:       # %bb.0:
; RV64IXTHEADBB-NEXT:    lui a0, 65793
; RV64IXTHEADBB-NEXT:    addiw a0, a0, 16
; RV64IXTHEADBB-NEXT:    slli a1, a0, 32
; RV64IXTHEADBB-NEXT:    add a0, a0, a1
; RV64IXTHEADBB-NEXT:    ret
  ret i64 1157442765409226768 ; 0x0101010101010101
}
