; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+v -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+m,+v -verify-machineinstrs < %s | FileCheck %s

declare i1 @llvm.vector.reduce.or.nxv1i1(<vscale x 1 x i1>)

define zeroext i1 @vreduce_or_nxv1i1(<vscale x 1 x i1> %v) {
; CHECK-LABEL: vreduce_or_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.or.nxv1i1(<vscale x 1 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.xor.nxv1i1(<vscale x 1 x i1>)

define zeroext i1 @vreduce_xor_nxv1i1(<vscale x 1 x i1> %v) {
; CHECK-LABEL: vreduce_xor_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.xor.nxv1i1(<vscale x 1 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.and.nxv1i1(<vscale x 1 x i1>)

define zeroext i1 @vreduce_and_nxv1i1(<vscale x 1 x i1> %v) {
; CHECK-LABEL: vreduce_and_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.and.nxv1i1(<vscale x 1 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umax.nxv1i1(<vscale x 1 x i1>)

define zeroext i1 @vreduce_umax_nxv1i1(<vscale x 1 x i1> %v) {
; CHECK-LABEL: vreduce_umax_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umax.nxv1i1(<vscale x 1 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smax.nxv1i1(<vscale x 1 x i1>)

define zeroext i1 @vreduce_smax_nxv1i1(<vscale x 1 x i1> %v) {
; CHECK-LABEL: vreduce_smax_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smax.nxv1i1(<vscale x 1 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umin.nxv1i1(<vscale x 1 x i1>)

define zeroext i1 @vreduce_umin_nxv1i1(<vscale x 1 x i1> %v) {
; CHECK-LABEL: vreduce_umin_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umin.nxv1i1(<vscale x 1 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smin.nxv1i1(<vscale x 1 x i1>)

define zeroext i1 @vreduce_smin_nxv1i1(<vscale x 1 x i1> %v) {
; CHECK-LABEL: vreduce_smin_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smin.nxv1i1(<vscale x 1 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.or.nxv2i1(<vscale x 2 x i1>)

define zeroext i1 @vreduce_or_nxv2i1(<vscale x 2 x i1> %v) {
; CHECK-LABEL: vreduce_or_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.or.nxv2i1(<vscale x 2 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.xor.nxv2i1(<vscale x 2 x i1>)

define zeroext i1 @vreduce_xor_nxv2i1(<vscale x 2 x i1> %v) {
; CHECK-LABEL: vreduce_xor_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.xor.nxv2i1(<vscale x 2 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.and.nxv2i1(<vscale x 2 x i1>)

define zeroext i1 @vreduce_and_nxv2i1(<vscale x 2 x i1> %v) {
; CHECK-LABEL: vreduce_and_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.and.nxv2i1(<vscale x 2 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umax.nxv2i1(<vscale x 2 x i1>)

define zeroext i1 @vreduce_umax_nxv2i1(<vscale x 2 x i1> %v) {
; CHECK-LABEL: vreduce_umax_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umax.nxv2i1(<vscale x 2 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smax.nxv2i1(<vscale x 2 x i1>)

define zeroext i1 @vreduce_smax_nxv2i1(<vscale x 2 x i1> %v) {
; CHECK-LABEL: vreduce_smax_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smax.nxv2i1(<vscale x 2 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umin.nxv2i1(<vscale x 2 x i1>)

define zeroext i1 @vreduce_umin_nxv2i1(<vscale x 2 x i1> %v) {
; CHECK-LABEL: vreduce_umin_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umin.nxv2i1(<vscale x 2 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smin.nxv2i1(<vscale x 2 x i1>)

define zeroext i1 @vreduce_smin_nxv2i1(<vscale x 2 x i1> %v) {
; CHECK-LABEL: vreduce_smin_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smin.nxv2i1(<vscale x 2 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.or.nxv4i1(<vscale x 4 x i1>)

define zeroext i1 @vreduce_or_nxv4i1(<vscale x 4 x i1> %v) {
; CHECK-LABEL: vreduce_or_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.or.nxv4i1(<vscale x 4 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.xor.nxv4i1(<vscale x 4 x i1>)

define zeroext i1 @vreduce_xor_nxv4i1(<vscale x 4 x i1> %v) {
; CHECK-LABEL: vreduce_xor_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.xor.nxv4i1(<vscale x 4 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.and.nxv4i1(<vscale x 4 x i1>)

define zeroext i1 @vreduce_and_nxv4i1(<vscale x 4 x i1> %v) {
; CHECK-LABEL: vreduce_and_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.and.nxv4i1(<vscale x 4 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umax.nxv4i1(<vscale x 4 x i1>)

define zeroext i1 @vreduce_umax_nxv4i1(<vscale x 4 x i1> %v) {
; CHECK-LABEL: vreduce_umax_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umax.nxv4i1(<vscale x 4 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smax.nxv4i1(<vscale x 4 x i1>)

define zeroext i1 @vreduce_smax_nxv4i1(<vscale x 4 x i1> %v) {
; CHECK-LABEL: vreduce_smax_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smax.nxv4i1(<vscale x 4 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umin.nxv4i1(<vscale x 4 x i1>)

define zeroext i1 @vreduce_umin_nxv4i1(<vscale x 4 x i1> %v) {
; CHECK-LABEL: vreduce_umin_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umin.nxv4i1(<vscale x 4 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smin.nxv4i1(<vscale x 4 x i1>)

define zeroext i1 @vreduce_smin_nxv4i1(<vscale x 4 x i1> %v) {
; CHECK-LABEL: vreduce_smin_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smin.nxv4i1(<vscale x 4 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.or.nxv8i1(<vscale x 8 x i1>)

define zeroext i1 @vreduce_or_nxv8i1(<vscale x 8 x i1> %v) {
; CHECK-LABEL: vreduce_or_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.or.nxv8i1(<vscale x 8 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.xor.nxv8i1(<vscale x 8 x i1>)

define zeroext i1 @vreduce_xor_nxv8i1(<vscale x 8 x i1> %v) {
; CHECK-LABEL: vreduce_xor_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.xor.nxv8i1(<vscale x 8 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.and.nxv8i1(<vscale x 8 x i1>)

define zeroext i1 @vreduce_and_nxv8i1(<vscale x 8 x i1> %v) {
; CHECK-LABEL: vreduce_and_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.and.nxv8i1(<vscale x 8 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umax.nxv8i1(<vscale x 8 x i1>)

define zeroext i1 @vreduce_umax_nxv8i1(<vscale x 8 x i1> %v) {
; CHECK-LABEL: vreduce_umax_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umax.nxv8i1(<vscale x 8 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smax.nxv8i1(<vscale x 8 x i1>)

define zeroext i1 @vreduce_smax_nxv8i1(<vscale x 8 x i1> %v) {
; CHECK-LABEL: vreduce_smax_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smax.nxv8i1(<vscale x 8 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umin.nxv8i1(<vscale x 8 x i1>)

define zeroext i1 @vreduce_umin_nxv8i1(<vscale x 8 x i1> %v) {
; CHECK-LABEL: vreduce_umin_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umin.nxv8i1(<vscale x 8 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smin.nxv8i1(<vscale x 8 x i1>)

define zeroext i1 @vreduce_smin_nxv8i1(<vscale x 8 x i1> %v) {
; CHECK-LABEL: vreduce_smin_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smin.nxv8i1(<vscale x 8 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.or.nxv16i1(<vscale x 16 x i1>)

define zeroext i1 @vreduce_or_nxv16i1(<vscale x 16 x i1> %v) {
; CHECK-LABEL: vreduce_or_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.or.nxv16i1(<vscale x 16 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.xor.nxv16i1(<vscale x 16 x i1>)

define zeroext i1 @vreduce_xor_nxv16i1(<vscale x 16 x i1> %v) {
; CHECK-LABEL: vreduce_xor_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.xor.nxv16i1(<vscale x 16 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.and.nxv16i1(<vscale x 16 x i1>)

define zeroext i1 @vreduce_and_nxv16i1(<vscale x 16 x i1> %v) {
; CHECK-LABEL: vreduce_and_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.and.nxv16i1(<vscale x 16 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umax.nxv16i1(<vscale x 16 x i1>)

define zeroext i1 @vreduce_umax_nxv16i1(<vscale x 16 x i1> %v) {
; CHECK-LABEL: vreduce_umax_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umax.nxv16i1(<vscale x 16 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smax.nxv16i1(<vscale x 16 x i1>)

define zeroext i1 @vreduce_smax_nxv16i1(<vscale x 16 x i1> %v) {
; CHECK-LABEL: vreduce_smax_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smax.nxv16i1(<vscale x 16 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umin.nxv16i1(<vscale x 16 x i1>)

define zeroext i1 @vreduce_umin_nxv16i1(<vscale x 16 x i1> %v) {
; CHECK-LABEL: vreduce_umin_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umin.nxv16i1(<vscale x 16 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smin.nxv16i1(<vscale x 16 x i1>)

define zeroext i1 @vreduce_smin_nxv16i1(<vscale x 16 x i1> %v) {
; CHECK-LABEL: vreduce_smin_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smin.nxv16i1(<vscale x 16 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.or.nxv32i1(<vscale x 32 x i1>)

define zeroext i1 @vreduce_or_nxv32i1(<vscale x 32 x i1> %v) {
; CHECK-LABEL: vreduce_or_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.or.nxv32i1(<vscale x 32 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.xor.nxv32i1(<vscale x 32 x i1>)

define zeroext i1 @vreduce_xor_nxv32i1(<vscale x 32 x i1> %v) {
; CHECK-LABEL: vreduce_xor_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.xor.nxv32i1(<vscale x 32 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.and.nxv32i1(<vscale x 32 x i1>)

define zeroext i1 @vreduce_and_nxv32i1(<vscale x 32 x i1> %v) {
; CHECK-LABEL: vreduce_and_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.and.nxv32i1(<vscale x 32 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umax.nxv32i1(<vscale x 32 x i1>)

define zeroext i1 @vreduce_umax_nxv32i1(<vscale x 32 x i1> %v) {
; CHECK-LABEL: vreduce_umax_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umax.nxv32i1(<vscale x 32 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smax.nxv32i1(<vscale x 32 x i1>)

define zeroext i1 @vreduce_smax_nxv32i1(<vscale x 32 x i1> %v) {
; CHECK-LABEL: vreduce_smax_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smax.nxv32i1(<vscale x 32 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umin.nxv32i1(<vscale x 32 x i1>)

define zeroext i1 @vreduce_umin_nxv32i1(<vscale x 32 x i1> %v) {
; CHECK-LABEL: vreduce_umin_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umin.nxv32i1(<vscale x 32 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smin.nxv32i1(<vscale x 32 x i1>)

define zeroext i1 @vreduce_smin_nxv32i1(<vscale x 32 x i1> %v) {
; CHECK-LABEL: vreduce_smin_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smin.nxv32i1(<vscale x 32 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.or.nxv64i1(<vscale x 64 x i1>)

define zeroext i1 @vreduce_or_nxv64i1(<vscale x 64 x i1> %v) {
; CHECK-LABEL: vreduce_or_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.or.nxv64i1(<vscale x 64 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.xor.nxv64i1(<vscale x 64 x i1>)

define zeroext i1 @vreduce_xor_nxv64i1(<vscale x 64 x i1> %v) {
; CHECK-LABEL: vreduce_xor_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.xor.nxv64i1(<vscale x 64 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.and.nxv64i1(<vscale x 64 x i1>)

define zeroext i1 @vreduce_and_nxv64i1(<vscale x 64 x i1> %v) {
; CHECK-LABEL: vreduce_and_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.and.nxv64i1(<vscale x 64 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umax.nxv64i1(<vscale x 64 x i1>)

define zeroext i1 @vreduce_umax_nxv64i1(<vscale x 64 x i1> %v) {
; CHECK-LABEL: vreduce_umax_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umax.nxv64i1(<vscale x 64 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smax.nxv64i1(<vscale x 64 x i1>)

define zeroext i1 @vreduce_smax_nxv64i1(<vscale x 64 x i1> %v) {
; CHECK-LABEL: vreduce_smax_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smax.nxv64i1(<vscale x 64 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.umin.nxv64i1(<vscale x 64 x i1>)

define zeroext i1 @vreduce_umin_nxv64i1(<vscale x 64 x i1> %v) {
; CHECK-LABEL: vreduce_umin_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vmnot.m v8, v0
; CHECK-NEXT:    vcpop.m a0, v8
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.umin.nxv64i1(<vscale x 64 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.smin.nxv64i1(<vscale x 64 x i1>)

define zeroext i1 @vreduce_smin_nxv64i1(<vscale x 64 x i1> %v) {
; CHECK-LABEL: vreduce_smin_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.smin.nxv64i1(<vscale x 64 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.add.nxv1i1(<vscale x 1 x i1>)

define zeroext i1 @vreduce_add_nxv1i1(<vscale x 1 x i1> %v) {
; CHECK-LABEL: vreduce_add_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.add.nxv1i1(<vscale x 1 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.add.nxv2i1(<vscale x 2 x i1>)

define zeroext i1 @vreduce_add_nxv2i1(<vscale x 2 x i1> %v) {
; CHECK-LABEL: vreduce_add_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.add.nxv2i1(<vscale x 2 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.add.nxv4i1(<vscale x 4 x i1>)

define zeroext i1 @vreduce_add_nxv4i1(<vscale x 4 x i1> %v) {
; CHECK-LABEL: vreduce_add_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.add.nxv4i1(<vscale x 4 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.add.nxv8i1(<vscale x 8 x i1>)

define zeroext i1 @vreduce_add_nxv8i1(<vscale x 8 x i1> %v) {
; CHECK-LABEL: vreduce_add_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.add.nxv8i1(<vscale x 8 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.add.nxv16i1(<vscale x 16 x i1>)

define zeroext i1 @vreduce_add_nxv16i1(<vscale x 16 x i1> %v) {
; CHECK-LABEL: vreduce_add_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.add.nxv16i1(<vscale x 16 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.add.nxv32i1(<vscale x 32 x i1>)

define zeroext i1 @vreduce_add_nxv32i1(<vscale x 32 x i1> %v) {
; CHECK-LABEL: vreduce_add_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.add.nxv32i1(<vscale x 32 x i1> %v)
  ret i1 %red
}

declare i1 @llvm.vector.reduce.add.nxv64i1(<vscale x 64 x i1>)

define zeroext i1 @vreduce_add_nxv64i1(<vscale x 64 x i1> %v) {
; CHECK-LABEL: vreduce_add_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vcpop.m a0, v0
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    ret
  %red = call i1 @llvm.vector.reduce.add.nxv64i1(<vscale x 64 x i1> %v)
  ret i1 %red
}
