; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple x86_64-linux < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple x86_64-windows < %s | FileCheck %s --check-prefix=WIN64

declare i64 @llvm.x86.flags.read.u64()
declare void @llvm.x86.flags.write.u64(i64)

define i64 @read_flags() {
; CHECK-LABEL: read_flags:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushfq
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; WIN64-LABEL: read_flags:
; WIN64:       # %bb.0: # %entry
; WIN64-NEXT:    pushq %rbp
; WIN64-NEXT:    .seh_pushreg %rbp
; WIN64-NEXT:    movq %rsp, %rbp
; WIN64-NEXT:    .seh_setframe %rbp, 0
; WIN64-NEXT:    .seh_endprologue
; WIN64-NEXT:    pushfq
; WIN64-NEXT:    popq %rax
; WIN64-NEXT:    popq %rbp
; WIN64-NEXT:    retq
; WIN64-NEXT:    .seh_endproc
entry:
  %flags = call i64 @llvm.x86.flags.read.u64()
  ret i64 %flags
}

define void @write_flags(i64 %arg) {
; CHECK-LABEL: write_flags:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rdi
; CHECK-NEXT:    popfq
; CHECK-NEXT:    retq
;
; WIN64-LABEL: write_flags:
; WIN64:       # %bb.0: # %entry
; WIN64-NEXT:    pushq %rbp
; WIN64-NEXT:    .seh_pushreg %rbp
; WIN64-NEXT:    movq %rsp, %rbp
; WIN64-NEXT:    .seh_setframe %rbp, 0
; WIN64-NEXT:    .seh_endprologue
; WIN64-NEXT:    pushq %rcx
; WIN64-NEXT:    popfq
; WIN64-NEXT:    popq %rbp
; WIN64-NEXT:    retq
; WIN64-NEXT:    .seh_endproc
entry:
  call void @llvm.x86.flags.write.u64(i64 %arg)
  ret void
}
