; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency -mtriple=x86_64-- -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency -mtriple=x86_64-- -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency -mtriple=x86_64-- -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency -mtriple=x86_64-- -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency -mtriple=x86_64-- -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency -mtriple=x86_64-- -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512,AVX512DQ
;
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency -mtriple=x86_64-- -mcpu=slm | FileCheck %s --check-prefixes=SSE,SLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency -mtriple=x86_64-- -mcpu=goldmont | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=latency -mtriple=x86_64-- -mcpu=btver2 | FileCheck %s --check-prefixes=AVX,AVX1

define i32 @add(i32 %arg) {
; SSE-LABEL: 'add'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = add i64 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = add <2 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4I64 = add <4 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I64 = add <8 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = add i32 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = add <4 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = add <8 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = add <16 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = add i16 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = add <8 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = add <16 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = add <32 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = add i8 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = add <16 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = add <32 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = add <64 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'add'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = add i64 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = add <2 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = add <4 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = add <8 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = add i32 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = add <4 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = add <8 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = add <16 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = add i16 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = add <8 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = add <16 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = add <32 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = add i8 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = add <16 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = add <32 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = add <64 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'add'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = add i64 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = add <2 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = add <4 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = add <8 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = add i32 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = add <4 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = add <8 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = add <16 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = add i16 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = add <8 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = add <16 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = add <32 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = add i8 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = add <16 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = add <32 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I8 = add <64 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'add'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = add i64 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = add <2 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = add <4 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = add <8 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = add i32 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = add <4 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = add <8 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = add <16 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = add i16 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = add <8 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = add <16 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I16 = add <32 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = add i8 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = add <16 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = add <32 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64I8 = add <64 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'add'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = add i64 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = add <2 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = add <4 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = add <8 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = add i32 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = add <4 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = add <8 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = add <16 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = add i16 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = add <8 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = add <16 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = add <32 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = add i8 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = add <16 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = add <32 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = add <64 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512DQ-LABEL: 'add'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = add i64 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = add <2 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = add <4 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = add <8 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = add i32 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = add <4 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = add <8 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = add <16 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = add i16 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = add <8 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = add <16 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I16 = add <32 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = add i8 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = add <16 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = add <32 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64I8 = add <64 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I64 = add i64 undef, undef
  %V2I64 = add <2 x i64> undef, undef
  %V4I64 = add <4 x i64> undef, undef
  %V8I64 = add <8 x i64> undef, undef

  %I32 = add i32 undef, undef
  %V4I32 = add <4 x i32> undef, undef
  %V8I32 = add <8 x i32> undef, undef
  %V16I32 = add <16 x i32> undef, undef

  %I16 = add i16 undef, undef
  %V8I16 = add <8 x i16> undef, undef
  %V16I16 = add <16 x i16> undef, undef
  %V32I16 = add <32 x i16> undef, undef

  %I8 = add i8 undef, undef
  %V16I8 = add <16 x i8> undef, undef
  %V32I8 = add <32 x i8> undef, undef
  %V64I8 = add <64 x i8> undef, undef

  ret i32 undef
}

define i32 @sub(i32 %arg) {
; SSE-LABEL: 'sub'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sub i64 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = sub <2 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4I64 = sub <4 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I64 = sub <8 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sub i32 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = sub <4 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = sub <8 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = sub <16 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sub i16 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = sub <8 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = sub <16 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = sub <32 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sub i8 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = sub <16 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = sub <32 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = sub <64 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'sub'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sub i64 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = sub <2 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = sub <4 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = sub <8 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sub i32 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = sub <4 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = sub <8 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = sub <16 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sub i16 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = sub <8 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = sub <16 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = sub <32 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sub i8 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = sub <16 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = sub <32 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = sub <64 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'sub'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sub i64 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = sub <2 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = sub <4 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = sub <8 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sub i32 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = sub <4 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = sub <8 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = sub <16 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sub i16 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = sub <8 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = sub <16 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = sub <32 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sub i8 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = sub <16 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = sub <32 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I8 = sub <64 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'sub'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sub i64 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = sub <2 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = sub <4 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = sub <8 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sub i32 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = sub <4 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = sub <8 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = sub <16 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sub i16 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = sub <8 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = sub <16 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I16 = sub <32 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sub i8 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = sub <16 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = sub <32 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64I8 = sub <64 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'sub'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sub i64 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = sub <2 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = sub <4 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = sub <8 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sub i32 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = sub <4 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = sub <8 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = sub <16 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sub i16 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = sub <8 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = sub <16 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = sub <32 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sub i8 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = sub <16 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = sub <32 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = sub <64 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512DQ-LABEL: 'sub'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sub i64 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = sub <2 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = sub <4 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = sub <8 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sub i32 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = sub <4 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = sub <8 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = sub <16 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sub i16 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = sub <8 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = sub <16 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I16 = sub <32 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sub i8 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = sub <16 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = sub <32 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64I8 = sub <64 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I64 = sub i64 undef, undef
  %V2I64 = sub <2 x i64> undef, undef
  %V4I64 = sub <4 x i64> undef, undef
  %V8I64 = sub <8 x i64> undef, undef

  %I32 = sub i32 undef, undef
  %V4I32 = sub <4 x i32> undef, undef
  %V8I32 = sub <8 x i32> undef, undef
  %V16I32 = sub <16 x i32> undef, undef

  %I16 = sub i16 undef, undef
  %V8I16 = sub <8 x i16> undef, undef
  %V16I16 = sub <16 x i16> undef, undef
  %V32I16 = sub <32 x i16> undef, undef

  %I8 = sub i8 undef, undef
  %V16I8 = sub <16 x i8> undef, undef
  %V32I8 = sub <32 x i8> undef, undef
  %V64I8 = sub <64 x i8> undef, undef

  ret i32 undef
}

define i32 @or(i32 %arg) {
; SSE-LABEL: 'or'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = or i64 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = or <2 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = or <4 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = or <8 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = or i32 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = or <4 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = or <8 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = or <16 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = or i16 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = or <8 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = or <16 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = or <32 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = or i8 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = or <16 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = or <32 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = or <64 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I1 = or i1 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I1 = or <2 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I1 = or <4 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I1 = or <8 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I1 = or <16 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I1 = or <32 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I1 = or <64 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'or'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = or i64 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = or <2 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = or <4 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = or <8 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = or i32 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = or <4 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = or <8 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = or <16 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = or i16 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = or <8 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = or <16 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = or <32 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = or i8 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = or <16 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = or <32 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I8 = or <64 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I1 = or i1 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I1 = or <2 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I1 = or <4 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I1 = or <8 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I1 = or <16 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I1 = or <32 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I1 = or <64 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'or'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = or i64 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = or <2 x i64> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = or <4 x i64> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = or <8 x i64> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = or i32 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = or <4 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = or <8 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = or <16 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = or i16 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = or <8 x i16> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = or <16 x i16> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = or <32 x i16> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = or i8 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = or <16 x i8> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = or <32 x i8> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = or <64 x i8> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I1 = or i1 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I1 = or <2 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I1 = or <4 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I1 = or <8 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I1 = or <16 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I1 = or <32 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I1 = or <64 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I64 = or i64 undef, undef
  %V2I64 = or <2 x i64> undef, undef
  %V4I64 = or <4 x i64> undef, undef
  %V8I64 = or <8 x i64> undef, undef

  %I32 = or i32 undef, undef
  %V4I32 = or <4 x i32> undef, undef
  %V8I32 = or <8 x i32> undef, undef
  %V16I32 = or <16 x i32> undef, undef

  %I16 = or i16 undef, undef
  %V8I16 = or <8 x i16> undef, undef
  %V16I16 = or <16 x i16> undef, undef
  %V32I16 = or <32 x i16> undef, undef

  %I8 = or i8 undef, undef
  %V16I8 = or <16 x i8> undef, undef
  %V32I8 = or <32 x i8> undef, undef
  %V64I8 = or <64 x i8> undef, undef

  %I1 = or i1 undef, undef
  %V2I1 = or <2 x i1> undef, undef
  %V4I1 = or <4 x i1> undef, undef
  %V8I1 = or <8 x i1> undef, undef
  %V16I1 = or <16 x i1> undef, undef
  %V32I1 = or <32 x i1> undef, undef
  %V64I1 = or <64 x i1> undef, undef

  ret i32 undef
}

define i32 @xor(i32 %arg) {
; SSE-LABEL: 'xor'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = xor i64 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = xor <2 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = xor <4 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = xor <8 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = xor i32 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = xor <4 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = xor <8 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = xor <16 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = xor i16 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = xor <8 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = xor <16 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = xor <32 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = xor i8 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = xor <16 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = xor <32 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = xor <64 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I1 = xor i1 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I1 = xor <2 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I1 = xor <4 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I1 = xor <8 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I1 = xor <16 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I1 = xor <32 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I1 = xor <64 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'xor'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = xor i64 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = xor <2 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = xor <4 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = xor <8 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = xor i32 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = xor <4 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = xor <8 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = xor <16 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = xor i16 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = xor <8 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = xor <16 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = xor <32 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = xor i8 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = xor <16 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = xor <32 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I8 = xor <64 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I1 = xor i1 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I1 = xor <2 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I1 = xor <4 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I1 = xor <8 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I1 = xor <16 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I1 = xor <32 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I1 = xor <64 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'xor'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = xor i64 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = xor <2 x i64> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = xor <4 x i64> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = xor <8 x i64> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = xor i32 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = xor <4 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = xor <8 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = xor <16 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = xor i16 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = xor <8 x i16> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = xor <16 x i16> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = xor <32 x i16> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = xor i8 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = xor <16 x i8> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = xor <32 x i8> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = xor <64 x i8> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I1 = xor i1 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I1 = xor <2 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I1 = xor <4 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I1 = xor <8 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I1 = xor <16 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I1 = xor <32 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I1 = xor <64 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I64 = xor i64 undef, undef
  %V2I64 = xor <2 x i64> undef, undef
  %V4I64 = xor <4 x i64> undef, undef
  %V8I64 = xor <8 x i64> undef, undef

  %I32 = xor i32 undef, undef
  %V4I32 = xor <4 x i32> undef, undef
  %V8I32 = xor <8 x i32> undef, undef
  %V16I32 = xor <16 x i32> undef, undef

  %I16 = xor i16 undef, undef
  %V8I16 = xor <8 x i16> undef, undef
  %V16I16 = xor <16 x i16> undef, undef
  %V32I16 = xor <32 x i16> undef, undef

  %I8 = xor i8 undef, undef
  %V16I8 = xor <16 x i8> undef, undef
  %V32I8 = xor <32 x i8> undef, undef
  %V64I8 = xor <64 x i8> undef, undef

  %I1 = xor i1 undef, undef
  %V2I1 = xor <2 x i1> undef, undef
  %V4I1 = xor <4 x i1> undef, undef
  %V8I1 = xor <8 x i1> undef, undef
  %V16I1 = xor <16 x i1> undef, undef
  %V32I1 = xor <32 x i1> undef, undef
  %V64I1 = xor <64 x i1> undef, undef

  ret i32 undef
}

define i32 @and(i32 %arg) {
; SSE-LABEL: 'and'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = and i64 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = and <2 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = and <4 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = and <8 x i64> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = and i32 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = and <4 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = and <8 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = and <16 x i32> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = and i16 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = and <8 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = and <16 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = and <32 x i16> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = and i8 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = and <16 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = and <32 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = and <64 x i8> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I1 = and i1 undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I1 = and <2 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I1 = and <4 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I1 = and <8 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I1 = and <16 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I1 = and <32 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I1 = and <64 x i1> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'and'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = and i64 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = and <2 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = and <4 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I64 = and <8 x i64> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = and i32 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = and <4 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = and <8 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I32 = and <16 x i32> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = and i16 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = and <8 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = and <16 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I16 = and <32 x i16> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = and i8 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = and <16 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = and <32 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I8 = and <64 x i8> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I1 = and i1 undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I1 = and <2 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I1 = and <4 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I1 = and <8 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I1 = and <16 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I1 = and <32 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I1 = and <64 x i1> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'and'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = and i64 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = and <2 x i64> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = and <4 x i64> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = and <8 x i64> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = and i32 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = and <4 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = and <8 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = and <16 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = and i16 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = and <8 x i16> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = and <16 x i16> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = and <32 x i16> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = and i8 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = and <16 x i8> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = and <32 x i8> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = and <64 x i8> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I1 = and i1 undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I1 = and <2 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I1 = and <4 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I1 = and <8 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I1 = and <16 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I1 = and <32 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I1 = and <64 x i1> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I64 = and i64 undef, undef
  %V2I64 = and <2 x i64> undef, undef
  %V4I64 = and <4 x i64> undef, undef
  %V8I64 = and <8 x i64> undef, undef

  %I32 = and i32 undef, undef
  %V4I32 = and <4 x i32> undef, undef
  %V8I32 = and <8 x i32> undef, undef
  %V16I32 = and <16 x i32> undef, undef

  %I16 = and i16 undef, undef
  %V8I16 = and <8 x i16> undef, undef
  %V16I16 = and <16 x i16> undef, undef
  %V32I16 = and <32 x i16> undef, undef

  %I8 = and i8 undef, undef
  %V16I8 = and <16 x i8> undef, undef
  %V32I8 = and <32 x i8> undef, undef
  %V64I8 = and <64 x i8> undef, undef

  %I1 = and i1 undef, undef
  %V2I1 = and <2 x i1> undef, undef
  %V4I1 = and <4 x i1> undef, undef
  %V8I1 = and <8 x i1> undef, undef
  %V16I1 = and <16 x i1> undef, undef
  %V32I1 = and <32 x i1> undef, undef
  %V64I1 = and <64 x i1> undef, undef

  ret i32 undef
}

define i32 @mul(i32 %arg) {
; SSE2-LABEL: 'mul'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %I64 = mul i64 undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V2I64 = mul <2 x i64> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V4I64 = mul <4 x i64> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V8I64 = mul <8 x i64> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I32 = mul i32 undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4I32 = mul <4 x i32> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8I32 = mul <8 x i32> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16I32 = mul <16 x i32> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I16 = mul i16 undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8I16 = mul <8 x i16> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16I16 = mul <16 x i16> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V32I16 = mul <32 x i16> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I8 = mul i8 undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V2I8 = mul <2 x i8> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I8 = mul <4 x i8> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I8 = mul <8 x i8> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V16I8 = mul <16 x i8> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V32I8 = mul <32 x i8> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %V64I8 = mul <64 x i8> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; SSE42-LABEL: 'mul'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %I64 = mul i64 undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V2I64 = mul <2 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V4I64 = mul <4 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V8I64 = mul <8 x i64> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I32 = mul i32 undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V4I32 = mul <4 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V8I32 = mul <8 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %V16I32 = mul <16 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I16 = mul i16 undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8I16 = mul <8 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16I16 = mul <16 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V32I16 = mul <32 x i16> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I8 = mul i8 undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V2I8 = mul <2 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I8 = mul <4 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I8 = mul <8 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V16I8 = mul <16 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V32I8 = mul <32 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %V64I8 = mul <64 x i8> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'mul'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %I64 = mul i64 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V2I64 = mul <2 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V4I64 = mul <4 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V8I64 = mul <8 x i64> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I32 = mul i32 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4I32 = mul <4 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I32 = mul <8 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16I32 = mul <16 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I16 = mul i16 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8I16 = mul <8 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I16 = mul <16 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I16 = mul <32 x i16> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I8 = mul i8 undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V2I8 = mul <2 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I8 = mul <4 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I8 = mul <8 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V16I8 = mul <16 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32I8 = mul <32 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64I8 = mul <64 x i8> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'mul'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %I64 = mul i64 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V2I64 = mul <2 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I64 = mul <4 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V8I64 = mul <8 x i64> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I32 = mul i32 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I32 = mul <4 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8I32 = mul <8 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V16I32 = mul <16 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I16 = mul i16 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8I16 = mul <8 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16I16 = mul <16 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32I16 = mul <32 x i16> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I8 = mul i8 undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V2I8 = mul <2 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I8 = mul <4 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I8 = mul <8 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V16I8 = mul <16 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V32I8 = mul <32 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V64I8 = mul <64 x i8> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'mul'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %I64 = mul i64 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V2I64 = mul <2 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I64 = mul <4 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8I64 = mul <8 x i64> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I32 = mul i32 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I32 = mul <4 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8I32 = mul <8 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16I32 = mul <16 x i32> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I16 = mul i16 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8I16 = mul <8 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16I16 = mul <16 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = mul <32 x i16> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I8 = mul i8 undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V2I8 = mul <2 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I8 = mul <4 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I8 = mul <8 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V16I8 = mul <16 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V32I8 = mul <32 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = mul <64 x i8> undef, undef
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'mul'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %I64 = mul i64 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V2I64 = mul <2 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I64 = mul <4 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8I64 = mul <8 x i64> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I32 = mul i32 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I32 = mul <4 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8I32 = mul <8 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16I32 = mul <16 x i32> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I16 = mul i16 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8I16 = mul <8 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16I16 = mul <16 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32I16 = mul <32 x i16> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I8 = mul i8 undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V2I8 = mul <2 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I8 = mul <4 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I8 = mul <8 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V16I8 = mul <16 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V32I8 = mul <32 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64I8 = mul <64 x i8> undef, undef
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512DQ-LABEL: 'mul'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %I64 = mul i64 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V2I64 = mul <2 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V4I64 = mul <4 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V8I64 = mul <8 x i64> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I32 = mul i32 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I32 = mul <4 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8I32 = mul <8 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16I32 = mul <16 x i32> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I16 = mul i16 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8I16 = mul <8 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16I16 = mul <16 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = mul <32 x i16> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I8 = mul i8 undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V2I8 = mul <2 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I8 = mul <4 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I8 = mul <8 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V16I8 = mul <16 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V32I8 = mul <32 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = mul <64 x i8> undef, undef
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; SLM-LABEL: 'mul'
; SLM-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %I64 = mul i64 undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V2I64 = mul <2 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %V4I64 = mul <4 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %V8I64 = mul <8 x i64> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I32 = mul i32 undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V4I32 = mul <4 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V8I32 = mul <8 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %V16I32 = mul <16 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I16 = mul i16 undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8I16 = mul <8 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16I16 = mul <16 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V32I16 = mul <32 x i16> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %I8 = mul i8 undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V2I8 = mul <2 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I8 = mul <4 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I8 = mul <8 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V16I8 = mul <16 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V32I8 = mul <32 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %V64I8 = mul <64 x i8> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I64 = mul i64 undef, undef
  %V2I64 = mul <2 x i64> undef, undef
  %V4I64 = mul <4 x i64> undef, undef
  %V8I64 = mul <8 x i64> undef, undef

  %I32 = mul i32 undef, undef
  %V4I32 = mul <4 x i32> undef, undef
  %V8I32 = mul <8 x i32> undef, undef
  %V16I32 = mul <16 x i32> undef, undef

  %I16 = mul i16 undef, undef
  %V8I16 = mul <8 x i16> undef, undef
  %V16I16 = mul <16 x i16> undef, undef
  %V32I16 = mul <32 x i16> undef, undef

  %I8 = mul i8 undef, undef
  %V2I8 = mul <2 x i8> undef, undef
  %V4I8 = mul <4 x i8> undef, undef
  %V8I8 = mul <8 x i8> undef, undef
  %V16I8 = mul <16 x i8> undef, undef
  %V32I8 = mul <32 x i8> undef, undef
  %V64I8 = mul <64 x i8> undef, undef

  ret i32 undef
}

; A <2 x i32> gets expanded to a <2 x i64> vector.
; A <2 x i64> vector multiply is implemented using
; 3 PMULUDQ and 2 PADDS and 4 shifts.
define void @mul_2i32() {
; SSE2-LABEL: 'mul_2i32'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %A0 = mul <2 x i32> undef, undef
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; SSE42-LABEL: 'mul_2i32'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %A0 = mul <2 x i32> undef, undef
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; AVX1-LABEL: 'mul_2i32'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %A0 = mul <2 x i32> undef, undef
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; AVX2-LABEL: 'mul_2i32'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %A0 = mul <2 x i32> undef, undef
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; AVX512-LABEL: 'mul_2i32'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %A0 = mul <2 x i32> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; SLM-LABEL: 'mul_2i32'
; SLM-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %A0 = mul <2 x i32> undef, undef
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %A0 = mul <2 x i32> undef, undef

  ret void
}
