; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -disable-output "-passes=print<scalar-evolution>" 2>&1 | FileCheck %s

define void @merge_values_with_ranges(ptr %a_len_ptr, ptr %b_len_ptr, i1 %unknown_cond) {
; CHECK-LABEL: 'merge_values_with_ranges'
; CHECK-NEXT:  Classifying expressions for: @merge_values_with_ranges
; CHECK-NEXT:    %len_a = load i32, ptr %a_len_ptr, align 4, !range !0
; CHECK-NEXT:    --> %len_a U: [0,2147483647) S: [0,2147483647)
; CHECK-NEXT:    %len_b = load i32, ptr %b_len_ptr, align 4, !range !0
; CHECK-NEXT:    --> %len_b U: [0,2147483647) S: [0,2147483647)
; CHECK-NEXT:    %len = phi i32 [ %len_a, %if.true ], [ %len_b, %if.false ]
; CHECK-NEXT:    --> %len U: [0,2147483647) S: [0,2147483647)
; CHECK-NEXT:  Determining loop execution counts for: @merge_values_with_ranges
;

  entry:
  br i1 %unknown_cond, label %if.true, label %if.false

if.true:
  %len_a = load i32, ptr %a_len_ptr, !range !0
  br label %merge

if.false:
  %len_b = load i32, ptr %b_len_ptr, !range !0
  br label %merge

merge:
  %len = phi i32 [ %len_a, %if.true ], [ %len_b, %if.false ]
  ret void
}

define void @merge_values_with_ranges_looped(ptr %a_len_ptr, ptr %b_len_ptr) {
; TODO: We could be much smarter here. So far we just make sure that we do not
;       go into infinite loop analyzing these Phis.
; CHECK-LABEL: 'merge_values_with_ranges_looped'
; CHECK-NEXT:  Classifying expressions for: @merge_values_with_ranges_looped
; CHECK-NEXT:    %len_a = load i32, ptr %a_len_ptr, align 4, !range !0
; CHECK-NEXT:    --> %len_a U: [0,2147483647) S: [0,2147483647)
; CHECK-NEXT:    %len_b = load i32, ptr %b_len_ptr, align 4, !range !0
; CHECK-NEXT:    --> %len_b U: [0,2147483647) S: [0,2147483647)
; CHECK-NEXT:    %p1 = phi i32 [ %len_a, %entry ], [ %p2, %loop ]
; CHECK-NEXT:    --> %p1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %p2 = phi i32 [ %len_b, %entry ], [ %p1, %loop ]
; CHECK-NEXT:    --> %p2 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,100) S: [0,100) Exits: 99 LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i32 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,101) S: [1,101) Exits: 100 LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @merge_values_with_ranges_looped
; CHECK-NEXT:  Loop %loop: backedge-taken count is 99
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 99
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is 99
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is 99
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 100
;

  entry:
  %len_a = load i32, ptr %a_len_ptr, !range !0
  %len_b = load i32, ptr %b_len_ptr, !range !0
  br label %loop

loop:
  %p1 = phi i32 [ %len_a, %entry ], [ %p2, %loop ]
  %p2 = phi i32 [ %len_b, %entry ], [ %p1, %loop ]
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %iv.next = add i32 %iv, 1
  %loop.cond = icmp slt i32 %iv.next, 100
  br i1 %loop.cond, label %loop, label %exit

exit:
  ret void
}


!0 = !{i32 0, i32 2147483647}
