; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O1 -mtriple i686-unknown-linux-gnu -o - %s | FileCheck %s

@foo = global i16 0, align 1
@aliasFoo = alias i16, i16 * @foo
@bar = global i16 0, align 1

; This used to miscompile due to not realizing that the store to @aliasFoo
; clobbered @foo (see PR51878).
;
; With some improvements to codegen it should be possible to detect that @foo
; and @aliasFoo are aliases, and that @aliasFoo isn't aliasing with @bar. So
; ideally we would end up with three movw instructions here. Running opt
; before llc on this test case would take care of that, but llc is not smart
; enough to deduce that itself yet.
define i16 @main() {
; CHECK-LABEL: main:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movw $1, foo
; CHECK-NEXT:    movw $2, bar
; CHECK-NEXT:    movw $4, aliasFoo
; CHECK-NEXT:    movzwl foo, %eax
; CHECK-NEXT:    addw bar, %ax
; CHECK-NEXT:    retl
entry:
  store i16 1, i16 * @foo
  store i16 2, i16 * @bar
  store i16 4, i16 * @aliasFoo
  %foo = load i16, i16 * @foo
  %bar = load i16, i16 * @bar
  %res = add i16 %foo, %bar
  ret i16 %res
}
