; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mcpu=pwr9 -mtriple=powerpc64le-unknown-unknown \
; RUN:   -ppc-asm-full-reg-names < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mcpu=pwr8 -mtriple=powerpc64le-unknown-unknown \
; RUN:   -ppc-asm-full-reg-names < %s | FileCheck %s -check-prefix=CHECK-PWR8    \
; RUN:   -implicit-check-not "\<setb\>"

; Test different patterns with type i64

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setne)), setlt
define i64 @setb1(i64 %a, i64 %b) {
; CHECK-LABEL: setb1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb1:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r3, r4
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    addic r7, r6, -1
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    subfe r6, r7, r6
; CHECK-PWR8-NEXT:    isellt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %a, %b
  %t2 = icmp ne i64 %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setne)), setgt
define i64 @setb2(i64 %a, i64 %b) {
; CHECK-LABEL: setb2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb2:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r3, r4
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    addic r7, r6, -1
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    subfe r6, r7, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i64 %b, %a
  %t2 = icmp ne i64 %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setne)), setlt
define i64 @setb3(i64 %a, i64 %b) {
; CHECK-LABEL: setb3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb3:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    addic r7, r6, -1
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    subfe r6, r7, r6
; CHECK-PWR8-NEXT:    isellt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %a, %b
  %t2 = icmp ne i64 %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setne)), setgt
define i64 @setb4(i64 %a, i64 %b) {
; CHECK-LABEL: setb4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb4:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    addic r7, r6, -1
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    subfe r6, r7, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i64 %b, %a
  %t2 = icmp ne i64 %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setgt)), setlt
define i64 @setb5(i64 %a, i64 %b) {
; CHECK-LABEL: setb5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb5:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    sradi r6, r4, 63
; CHECK-PWR8-NEXT:    rldicl r7, r3, 1, 63
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    subc r8, r4, r3
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    adde r6, r7, r6
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    isellt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %a, %b
  %t2 = icmp sgt i64 %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setgt)), setgt
define i64 @setb6(i64 %a, i64 %b) {
; CHECK-LABEL: setb6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb6:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    sradi r6, r4, 63
; CHECK-PWR8-NEXT:    rldicl r7, r3, 1, 63
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    subc r8, r4, r3
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    adde r6, r7, r6
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    iselgt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i64 %b, %a
  %t2 = icmp sgt i64 %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setlt)), setlt
define i64 @setb7(i64 %a, i64 %b) {
; CHECK-LABEL: setb7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb7:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    sradi r6, r4, 63
; CHECK-PWR8-NEXT:    rldicl r7, r3, 1, 63
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    subc r8, r4, r3
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    adde r6, r7, r6
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    isellt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %a, %b
  %t2 = icmp slt i64 %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setlt)), setgt
define i64 @setb8(i64 %a, i64 %b) {
; CHECK-LABEL: setb8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb8:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    sradi r6, r4, 63
; CHECK-PWR8-NEXT:    rldicl r7, r3, 1, 63
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    subc r8, r4, r3
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    adde r6, r7, r6
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    iselgt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i64 %b, %a
  %t2 = icmp slt i64 %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc lhs, rhs, setne)), setgt
define i64 @setb9(i64 %a, i64 %b) {
; CHECK-LABEL: setb9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb9:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r3, r4
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    subfic r6, r6, 0
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    subfe r3, r6, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i64 %a, %b
  %t2 = icmp ne i64 %a, %b
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc rhs, lhs, setne)), setlt
define i64 @setb10(i64 %a, i64 %b) {
; CHECK-LABEL: setb10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb10:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r3, r4
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    subfic r6, r6, 0
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    subfe r3, r6, r6
; CHECK-PWR8-NEXT:    isellt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %b, %a
  %t2 = icmp ne i64 %a, %b
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc rhs, lhs, setne)), setgt
define i64 @setb11(i64 %a, i64 %b) {
; CHECK-LABEL: setb11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb11:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    subfic r6, r6, 0
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    subfe r3, r6, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i64 %a, %b
  %t2 = icmp ne i64 %b, %a
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc lhs, rhs, setne)), setlt
define i64 @setb12(i64 %a, i64 %b) {
; CHECK-LABEL: setb12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb12:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    subfic r6, r6, 0
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    subfe r3, r6, r6
; CHECK-PWR8-NEXT:    isellt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %b, %a
  %t2 = icmp ne i64 %b, %a
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc lhs, rhs, setlt)), setgt
define i64 @setb13(i64 %a, i64 %b) {
; CHECK-LABEL: setb13:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb13:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    sradi r6, r3, 63
; CHECK-PWR8-NEXT:    rldicl r7, r4, 1, 63
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    subc r8, r3, r4
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    adde r6, r7, r6
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    neg r6, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i64 %a, %b
  %t2 = icmp slt i64 %a, %b
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc rhs, lhs, setlt)), setlt
define i64 @setb14(i64 %a, i64 %b) {
; CHECK-LABEL: setb14:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb14:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    sradi r6, r3, 63
; CHECK-PWR8-NEXT:    rldicl r7, r4, 1, 63
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    subc r8, r3, r4
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    adde r6, r7, r6
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    neg r6, r6
; CHECK-PWR8-NEXT:    isellt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %b, %a
  %t2 = icmp slt i64 %a, %b
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc rhs, lhs, setgt)), setgt
define i64 @setb15(i64 %a, i64 %b) {
; CHECK-LABEL: setb15:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb15:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    sradi r6, r3, 63
; CHECK-PWR8-NEXT:    rldicl r7, r4, 1, 63
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    subc r8, r3, r4
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    adde r6, r7, r6
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    neg r6, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i64 %a, %b
  %t2 = icmp sgt i64 %b, %a
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc lhs, rhs, setgt)), setlt
define i64 @setb16(i64 %a, i64 %b) {
; CHECK-LABEL: setb16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb16:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    sradi r6, r3, 63
; CHECK-PWR8-NEXT:    rldicl r7, r4, 1, 63
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    subc r8, r3, r4
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    adde r6, r7, r6
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    neg r6, r6
; CHECK-PWR8-NEXT:    isellt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %b, %a
  %t2 = icmp sgt i64 %b, %a
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc lhs, rhs, 1, -1, setgt), seteq
define i64 @setb17(i64 %a, i64 %b) {
; CHECK-LABEL: setb17:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb17:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    li r6, 1
; CHECK-PWR8-NEXT:    iselgt r5, r6, r5
; CHECK-PWR8-NEXT:    cmpld r3, r4
; CHECK-PWR8-NEXT:    iseleq r3, 0, r5
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp eq i64 %a, %b
  %t2 = icmp sgt i64 %a, %b
  %t3 = select i1 %t2, i64 1, i64 -1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc rhs, lhs, 1, -1, setgt), seteq
define i64 @setb18(i64 %a, i64 %b) {
; CHECK-LABEL: setb18:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb18:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    li r6, 1
; CHECK-PWR8-NEXT:    iselgt r5, r6, r5
; CHECK-PWR8-NEXT:    cmpld r4, r3
; CHECK-PWR8-NEXT:    iseleq r3, 0, r5
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp eq i64 %b, %a
  %t2 = icmp sgt i64 %a, %b
  %t3 = select i1 %t2, i64 1, i64 -1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc rhs, lhs, 1, -1, setlt), seteq
define i64 @setb19(i64 %a, i64 %b) {
; CHECK-LABEL: setb19:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb19:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    li r6, 1
; CHECK-PWR8-NEXT:    isellt r5, r6, r5
; CHECK-PWR8-NEXT:    cmpld r3, r4
; CHECK-PWR8-NEXT:    iseleq r3, 0, r5
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp eq i64 %a, %b
  %t2 = icmp slt i64 %b, %a
  %t3 = select i1 %t2, i64 1, i64 -1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc lhs, rhs, 1, -1, setlt), seteq
define i64 @setb20(i64 %a, i64 %b) {
; CHECK-LABEL: setb20:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb20:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    li r6, 1
; CHECK-PWR8-NEXT:    isellt r5, r6, r5
; CHECK-PWR8-NEXT:    cmpld r4, r3
; CHECK-PWR8-NEXT:    iseleq r3, 0, r5
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp eq i64 %b, %a
  %t2 = icmp slt i64 %b, %a
  %t3 = select i1 %t2, i64 1, i64 -1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc lhs, rhs, -1, 1, setlt), seteq
define i64 @setb21(i64 %a, i64 %b) {
; CHECK-LABEL: setb21:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb21:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    li r6, -1
; CHECK-PWR8-NEXT:    isellt r5, r6, r5
; CHECK-PWR8-NEXT:    cmpld r3, r4
; CHECK-PWR8-NEXT:    iseleq r3, 0, r5
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp eq i64 %a, %b
  %t2 = icmp slt i64 %a, %b
  %t3 = select i1 %t2, i64 -1, i64 1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc rhs, lhs, -1, 1, setlt), seteq
define i64 @setb22(i64 %a, i64 %b) {
; CHECK-LABEL: setb22:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb22:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    li r6, -1
; CHECK-PWR8-NEXT:    isellt r5, r6, r5
; CHECK-PWR8-NEXT:    cmpld r4, r3
; CHECK-PWR8-NEXT:    iseleq r3, 0, r5
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp eq i64 %b, %a
  %t2 = icmp slt i64 %a, %b
  %t3 = select i1 %t2, i64 -1, i64 1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc rhs, lhs, -1, 1, setgt), seteq
define i64 @setb23(i64 %a, i64 %b) {
; CHECK-LABEL: setb23:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb23:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    li r6, -1
; CHECK-PWR8-NEXT:    iselgt r5, r6, r5
; CHECK-PWR8-NEXT:    cmpld r3, r4
; CHECK-PWR8-NEXT:    iseleq r3, 0, r5
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp eq i64 %a, %b
  %t2 = icmp sgt i64 %b, %a
  %t3 = select i1 %t2, i64 -1, i64 1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc lhs, rhs, -1, 1, setgt), seteq
define i64 @setb24(i64 %a, i64 %b) {
; CHECK-LABEL: setb24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb24:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    li r6, -1
; CHECK-PWR8-NEXT:    iselgt r5, r6, r5
; CHECK-PWR8-NEXT:    cmpld r4, r3
; CHECK-PWR8-NEXT:    iseleq r3, 0, r5
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp eq i64 %b, %a
  %t2 = icmp sgt i64 %b, %a
  %t3 = select i1 %t2, i64 -1, i64 1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}
; end all patterns testing for i64

; Test with swapping the input parameters

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setne)), setlt
define i64 @setb25(i64 %a, i64 %b) {
; CHECK-LABEL: setb25:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r4, r3
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb25:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    addic r7, r6, -1
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    subfe r6, r7, r6
; CHECK-PWR8-NEXT:    isellt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %b, %a
  %t2 = icmp ne i64 %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setne)), setgt
define i64 @setb26(i64 %a, i64 %b) {
; CHECK-LABEL: setb26:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r4, r3
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb26:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    addic r7, r6, -1
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    subfe r6, r7, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i64 %a, %b
  %t2 = icmp ne i64 %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; Test with different scalar integer type for selected value
; i32/i16/i8 rather than i64 above

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setne)), setlt
define i64 @setb27(i64 %a, i64 %b) {
; CHECK-LABEL: setb27:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb27:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    addic r7, r6, -1
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    subfe r6, r7, r6
; CHECK-PWR8-NEXT:    isellt r3, r5, r6
; CHECK-PWR8-NEXT:    extsw r3, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %a, %b
  %t2 = icmp ne i64 %b, %a
  %t3 = zext i1 %t2 to i32
  %t4 = select i1 %t1, i32 -1, i32 %t3
  %t5 = sext i32 %t4 to i64
  ret i64 %t5
}

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setne)), setgt
define i64 @setb28(i64 %a, i64 %b) {
; CHECK-LABEL: setb28:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb28:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    addic r7, r6, -1
; CHECK-PWR8-NEXT:    cmpd r4, r3
; CHECK-PWR8-NEXT:    subfe r6, r7, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r6
; CHECK-PWR8-NEXT:    extsw r3, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i64 %b, %a
  %t2 = icmp ne i64 %b, %a
  %t3 = zext i1 %t2 to i16
  %t4 = select i1 %t1, i16 -1, i16 %t3
  %t5 = sext i16 %t4 to i64
  ret i64 %t5
}

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setgt)), setlt
define i64 @setb29(i64 %a, i64 %b) {
; CHECK-LABEL: setb29:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    clrldi r3, r3, 56
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setb29:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    sradi r6, r4, 63
; CHECK-PWR8-NEXT:    rldicl r7, r3, 1, 63
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    subc r8, r4, r3
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    adde r6, r7, r6
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    isellt r3, r5, r6
; CHECK-PWR8-NEXT:    clrldi r3, r3, 56
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %a, %b
  %t2 = icmp sgt i64 %a, %b
  %t3 = zext i1 %t2 to i8
  %t4 = select i1 %t1, i8 -1, i8 %t3
  %t5 = zext i8 %t4 to i64
  ret i64 %t5
}

; Testings to cover different comparison opcodes
; Test with integer type i32/i16/i8 for input parameter

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setne)), setlt
define i64 @setbsw1(i32 %a, i32 %b) {
; CHECK-LABEL: setbsw1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbsw1:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r3, r4
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    cntlzw r6, r6
; CHECK-PWR8-NEXT:    cmpw r3, r4
; CHECK-PWR8-NEXT:    srwi r6, r6, 5
; CHECK-PWR8-NEXT:    xori r3, r6, 1
; CHECK-PWR8-NEXT:    isellt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i32 %a, %b
  %t2 = icmp ne i32 %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setne)), setgt
define i64 @setbsw2(i32 %a, i32 %b) {
; CHECK-LABEL: setbsw2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbsw2:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r3, r4
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    cntlzw r6, r6
; CHECK-PWR8-NEXT:    cmpw r4, r3
; CHECK-PWR8-NEXT:    srwi r6, r6, 5
; CHECK-PWR8-NEXT:    xori r3, r6, 1
; CHECK-PWR8-NEXT:    iselgt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i32 %b, %a
  %t2 = icmp ne i32 %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc rhs, lhs, -1, 1, setgt), seteq
define i64 @setbsw3(i32 %a, i32 %b) {
; CHECK-LABEL: setbsw3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbsw3:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    cmpw r4, r3
; CHECK-PWR8-NEXT:    li r6, -1
; CHECK-PWR8-NEXT:    iselgt r5, r6, r5
; CHECK-PWR8-NEXT:    cmplw r3, r4
; CHECK-PWR8-NEXT:    iseleq r3, 0, r5
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp eq i32 %a, %b
  %t2 = icmp sgt i32 %b, %a
  %t3 = select i1 %t2, i64 -1, i64 1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setne)), setlt
define i64 @setbsh1(i16 signext %a, i16 signext %b) {
; CHECK-LABEL: setbsh1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbsh1:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    cntlzw r6, r6
; CHECK-PWR8-NEXT:    cmpw r3, r4
; CHECK-PWR8-NEXT:    srwi r6, r6, 5
; CHECK-PWR8-NEXT:    xori r3, r6, 1
; CHECK-PWR8-NEXT:    isellt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i16 %a, %b
  %t2 = icmp ne i16 %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setne)), setgt
define i64 @setbsh2(i16 signext %a, i16 signext %b) {
; CHECK-LABEL: setbsh2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbsh2:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    cntlzw r6, r6
; CHECK-PWR8-NEXT:    cmpw r4, r3
; CHECK-PWR8-NEXT:    srwi r6, r6, 5
; CHECK-PWR8-NEXT:    xori r3, r6, 1
; CHECK-PWR8-NEXT:    iselgt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i16 %b, %a
  %t2 = icmp ne i16 %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setgt)), setlt
define i64 @setbsc1(i8 %a, i8 %b) {
; CHECK-LABEL: setbsc1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    extsb r4, r4
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    cmpw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbsc1:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    extsb r4, r4
; CHECK-PWR8-NEXT:    extsb r3, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    sub r6, r4, r3
; CHECK-PWR8-NEXT:    cmpw r3, r4
; CHECK-PWR8-NEXT:    rldicl r3, r6, 1, 63
; CHECK-PWR8-NEXT:    isellt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i8 %a, %b
  %t2 = icmp sgt i8 %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setgt)), setgt
define i64 @setbsc2(i8 %a, i8 %b) {
; CHECK-LABEL: setbsc2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    extsb r4, r4
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    cmpw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbsc2:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    extsb r4, r4
; CHECK-PWR8-NEXT:    extsb r3, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    sub r6, r4, r3
; CHECK-PWR8-NEXT:    cmpw r4, r3
; CHECK-PWR8-NEXT:    rldicl r3, r6, 1, 63
; CHECK-PWR8-NEXT:    iselgt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp sgt i8 %b, %a
  %t2 = icmp sgt i8 %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setlt)), setlt
define i64 @setbsc3(i4 %a, i4 %b) {
; CHECK-LABEL: setbsc3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slwi r4, r4, 28
; CHECK-NEXT:    slwi r3, r3, 28
; CHECK-NEXT:    srawi r4, r4, 28
; CHECK-NEXT:    srawi r3, r3, 28
; CHECK-NEXT:    cmpw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbsc3:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    slwi r4, r4, 28
; CHECK-PWR8-NEXT:    slwi r3, r3, 28
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    srawi r4, r4, 28
; CHECK-PWR8-NEXT:    srawi r3, r3, 28
; CHECK-PWR8-NEXT:    sub r6, r4, r3
; CHECK-PWR8-NEXT:    cmpw r3, r4
; CHECK-PWR8-NEXT:    rldicl r3, r6, 1, 63
; CHECK-PWR8-NEXT:    isellt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i4 %a, %b
  %t2 = icmp slt i4 %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; Test with unsigned integer type i64/i32/i16/i8 for input parameter

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setult)), setugt
define i64 @setbud1(i64 %a, i64 %b) {
; CHECK-LABEL: setbud1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpld r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbud1:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    subc r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    subfe r6, r4, r4
; CHECK-PWR8-NEXT:    cmpld r4, r3
; CHECK-PWR8-NEXT:    neg r3, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp ugt i64 %b, %a
  %t2 = icmp ult i64 %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc lhs, rhs, setne)), setugt
define i64 @setbud2(i64 %a, i64 %b) {
; CHECK-LABEL: setbud2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpld r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbud2:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r3, r4
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    subfic r6, r6, 0
; CHECK-PWR8-NEXT:    cmpld r3, r4
; CHECK-PWR8-NEXT:    subfe r3, r6, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp ugt i64 %a, %b
  %t2 = icmp ne i64 %a, %b
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc lhs, rhs, -1, 1, setugt), seteq
define i64 @setbud3(i64 %a, i64 %b) {
; CHECK-LABEL: setbud3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpld r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbud3:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    cmpld r4, r3
; CHECK-PWR8-NEXT:    li r3, -1
; CHECK-PWR8-NEXT:    iselgt r3, r3, r5
; CHECK-PWR8-NEXT:    iseleq r3, 0, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp eq i64 %b, %a
  %t2 = icmp ugt i64 %b, %a
  %t3 = select i1 %t2, i64 -1, i64 1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc rhs, lhs, setne)), setult
define i64 @setbuw1(i32 %a, i32 %b) {
; CHECK-LABEL: setbuw1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmplw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbuw1:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r3, r4
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    cntlzw r6, r6
; CHECK-PWR8-NEXT:    cmplw r4, r3
; CHECK-PWR8-NEXT:    srwi r6, r6, 5
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    neg r3, r6
; CHECK-PWR8-NEXT:    isellt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp ult i32 %b, %a
  %t2 = icmp ne i32 %a, %b
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc rhs, lhs, setne)), setugt
define i64 @setbuw2(i32 %a, i32 %b) {
; CHECK-LABEL: setbuw2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmplw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbuw2:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    cntlzw r6, r6
; CHECK-PWR8-NEXT:    cmplw r3, r4
; CHECK-PWR8-NEXT:    srwi r6, r6, 5
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    neg r3, r6
; CHECK-PWR8-NEXT:    iselgt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp ugt i32 %a, %b
  %t2 = icmp ne i32 %b, %a
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc lhs, rhs, setne)), setult
define i64 @setbuh(i16 %a, i16 %b) {
; CHECK-LABEL: setbuh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    clrlwi r4, r4, 16
; CHECK-NEXT:    clrlwi r3, r3, 16
; CHECK-NEXT:    cmplw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbuh:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    clrlwi r3, r3, 16
; CHECK-PWR8-NEXT:    clrlwi r4, r4, 16
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    xor r6, r4, r3
; CHECK-PWR8-NEXT:    cmplw r4, r3
; CHECK-PWR8-NEXT:    cntlzw r6, r6
; CHECK-PWR8-NEXT:    srwi r6, r6, 5
; CHECK-PWR8-NEXT:    xori r6, r6, 1
; CHECK-PWR8-NEXT:    neg r3, r6
; CHECK-PWR8-NEXT:    isellt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp ult i16 %b, %a
  %t2 = icmp ne i16 %b, %a
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc lhs, rhs, setult)), setugt
define i64 @setbuc(i8 %a, i8 %b) {
; CHECK-LABEL: setbuc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    clrlwi r4, r4, 24
; CHECK-NEXT:    clrlwi r3, r3, 24
; CHECK-NEXT:    cmplw r3, r4
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbuc:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    clrlwi r3, r3, 24
; CHECK-PWR8-NEXT:    clrlwi r4, r4, 24
; CHECK-PWR8-NEXT:    li r5, 1
; CHECK-PWR8-NEXT:    clrldi r6, r3, 32
; CHECK-PWR8-NEXT:    clrldi r7, r4, 32
; CHECK-PWR8-NEXT:    sub r6, r6, r7
; CHECK-PWR8-NEXT:    cmplw r3, r4
; CHECK-PWR8-NEXT:    sradi r6, r6, 63
; CHECK-PWR8-NEXT:    iselgt r3, r5, r6
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp ugt i8 %a, %b
  %t2 = icmp ult i8 %a, %b
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; Test with float/double/float128 for input parameter

; select_cc lhs, rhs, -1, (zext (setcc rhs, lhs, setlt)), setlt
define i64 @setbf1(float %a, float %b) {
; CHECK-LABEL: setbf1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbf1:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    fcmpu cr0, f2, f1
; CHECK-PWR8-NEXT:    fcmpu cr1, f1, f2
; CHECK-PWR8-NEXT:    li r3, 0
; CHECK-PWR8-NEXT:    li r4, 1
; CHECK-PWR8-NEXT:    isellt r3, r4, r3
; CHECK-PWR8-NEXT:    li r4, -1
; CHECK-PWR8-NEXT:    isel r3, r4, r3, 4*cr1+lt
; CHECK-PWR8-NEXT:    blr
  %t1 = fcmp nnan olt float %a, %b
  %t2 = fcmp nnan olt float %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, -1, (zext (setcc lhs, rhs, setlt)), setgt
define i64 @setbf2(float %a, float %b) {
; CHECK-LABEL: setbf2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbf2:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    fcmpu cr0, f2, f1
; CHECK-PWR8-NEXT:    li r3, 0
; CHECK-PWR8-NEXT:    li r4, 1
; CHECK-PWR8-NEXT:    isellt r3, r4, r3
; CHECK-PWR8-NEXT:    li r4, -1
; CHECK-PWR8-NEXT:    iselgt r3, r4, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = fcmp nnan ogt float %b, %a
  %t2 = fcmp nnan olt float %b, %a
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 0, (select_cc lhs, rhs, -1, 1, setgt), seteq
define i64 @setbdf1(double %a, double %b) {
; CHECK-LABEL: setbdf1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xscmpudp cr0, f1, f2
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbdf1:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xscmpudp cr0, f2, f1
; CHECK-PWR8-NEXT:    li r3, 1
; CHECK-PWR8-NEXT:    li r4, -1
; CHECK-PWR8-NEXT:    iselgt r3, r4, r3
; CHECK-PWR8-NEXT:    iseleq r3, 0, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = fcmp nnan oeq double %b, %a
  %t2 = fcmp nnan ogt double %b, %a
  %t3 = select i1 %t2, i64 -1, i64 1
  %t4 = select i1 %t1, i64 0, i64 %t3
  ret i64 %t4
}

; select_cc lhs, rhs, 1, (sext (setcc lhs, rhs, setgt)), setlt
define i64 @setbdf2(double %a, double %b) {
; CHECK-LABEL: setbdf2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xscmpudp cr0, f1, f2
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbdf2:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    fcmpu cr0, f2, f1
; CHECK-PWR8-NEXT:    xscmpudp cr1, f2, f1
; CHECK-PWR8-NEXT:    li r3, 0
; CHECK-PWR8-NEXT:    li r4, -1
; CHECK-PWR8-NEXT:    iselgt r3, r4, r3
; CHECK-PWR8-NEXT:    li r4, 1
; CHECK-PWR8-NEXT:    isel r3, r4, r3, 4*cr1+lt
; CHECK-PWR8-NEXT:    blr
  %t1 = fcmp nnan olt double %b, %a
  %t2 = fcmp nnan ogt double %b, %a
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

define i64 @setbf128(fp128 %a, fp128 %b) {
; CHECK-LABEL: setbf128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xscmpuqp cr0, v2, v3
; CHECK-NEXT:    setb r3, cr0
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbf128:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    mflr r0
; CHECK-PWR8-NEXT:    stdu r1, -96(r1)
; CHECK-PWR8-NEXT:    std r0, 112(r1)
; CHECK-PWR8-NEXT:    .cfi_def_cfa_offset 96
; CHECK-PWR8-NEXT:    .cfi_offset lr, 16
; CHECK-PWR8-NEXT:    .cfi_offset r30, -16
; CHECK-PWR8-NEXT:    .cfi_offset v30, -48
; CHECK-PWR8-NEXT:    .cfi_offset v31, -32
; CHECK-PWR8-NEXT:    li r3, 48
; CHECK-PWR8-NEXT:    std r30, 80(r1) # 8-byte Folded Spill
; CHECK-PWR8-NEXT:    stvx v30, r1, r3 # 16-byte Folded Spill
; CHECK-PWR8-NEXT:    li r3, 64
; CHECK-PWR8-NEXT:    vmr v30, v2
; CHECK-PWR8-NEXT:    stvx v31, r1, r3 # 16-byte Folded Spill
; CHECK-PWR8-NEXT:    vmr v31, v3
; CHECK-PWR8-NEXT:    bl __ltkf2
; CHECK-PWR8-NEXT:    nop
; CHECK-PWR8-NEXT:    vmr v2, v30
; CHECK-PWR8-NEXT:    srawi r30, r3, 31
; CHECK-PWR8-NEXT:    vmr v3, v31
; CHECK-PWR8-NEXT:    bl __gtkf2
; CHECK-PWR8-NEXT:    nop
; CHECK-PWR8-NEXT:    li r4, 1
; CHECK-PWR8-NEXT:    cmpwi r3, 0
; CHECK-PWR8-NEXT:    iselgt r3, r4, r30
; CHECK-PWR8-NEXT:    li r4, 64
; CHECK-PWR8-NEXT:    ld r30, 80(r1) # 8-byte Folded Reload
; CHECK-PWR8-NEXT:    lvx v31, r1, r4 # 16-byte Folded Reload
; CHECK-PWR8-NEXT:    li r4, 48
; CHECK-PWR8-NEXT:    lvx v30, r1, r4 # 16-byte Folded Reload
; CHECK-PWR8-NEXT:    addi r1, r1, 96
; CHECK-PWR8-NEXT:    ld r0, 16(r1)
; CHECK-PWR8-NEXT:    mtlr r0
; CHECK-PWR8-NEXT:    blr
  %t1 = fcmp nnan ogt fp128 %a, %b
  %t2 = fcmp nnan olt fp128 %a, %b
  %t3 = sext i1 %t2 to i64
  %t4 = select i1 %t1, i64 1, i64 %t3
  ret i64 %t4
}

; Some cases we can't leverage setb

define i64 @setbn1(i64 %a, i64 %b) {
; CHECK-LABEL: setbn1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xor r5, r3, r4
; CHECK-NEXT:    cmpd r3, r4
; CHECK-NEXT:    li r3, -1
; CHECK-NEXT:    cntlzd r5, r5
; CHECK-NEXT:    rldicl r5, r5, 58, 63
; CHECK-NEXT:    isellt r3, r3, r5
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbn1:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    xor r6, r3, r4
; CHECK-PWR8-NEXT:    li r5, -1
; CHECK-PWR8-NEXT:    cntlzd r6, r6
; CHECK-PWR8-NEXT:    cmpd r3, r4
; CHECK-PWR8-NEXT:    rldicl r3, r6, 58, 63
; CHECK-PWR8-NEXT:    isellt r3, r5, r3
; CHECK-PWR8-NEXT:    blr
  %t1 = icmp slt i64 %a, %b
  %t2 = icmp eq i64 %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

define i64 @setbn2(double %a, double %b) {
; CHECK-LABEL: setbn2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    li r4, -1
; CHECK-NEXT:    cror 4*cr5+lt, un, eq
; CHECK-NEXT:    xscmpudp cr0, f1, f2
; CHECK-NEXT:    isel r3, 0, r3, 4*cr5+lt
; CHECK-NEXT:    isellt r3, r4, r3
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbn2:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    fcmpu cr0, f1, f2
; CHECK-PWR8-NEXT:    xscmpudp cr1, f1, f2
; CHECK-PWR8-NEXT:    li r3, 1
; CHECK-PWR8-NEXT:    li r4, -1
; CHECK-PWR8-NEXT:    cror 4*cr5+lt, un, eq
; CHECK-PWR8-NEXT:    isel r3, 0, r3, 4*cr5+lt
; CHECK-PWR8-NEXT:    isel r3, r4, r3, 4*cr1+lt
; CHECK-PWR8-NEXT:    blr
  %t1 = fcmp olt double %a, %b
  %t2 = fcmp one double %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

define i64 @setbn3(float %a, float %b) {
; CHECK-LABEL: setbn3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    li r4, -1
; CHECK-NEXT:    iseleq r3, 0, r3
; CHECK-NEXT:    cror 4*cr5+lt, lt, un
; CHECK-NEXT:    isel r3, r4, r3, 4*cr5+lt
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbn3:
; CHECK-PWR8:       # %bb.0:
; CHECK-PWR8-NEXT:    fcmpu cr0, f1, f2
; CHECK-PWR8-NEXT:    li r3, 1
; CHECK-PWR8-NEXT:    li r4, -1
; CHECK-PWR8-NEXT:    cror 4*cr5+lt, lt, un
; CHECK-PWR8-NEXT:    iseleq r3, 0, r3
; CHECK-PWR8-NEXT:    isel r3, r4, r3, 4*cr5+lt
; CHECK-PWR8-NEXT:    blr
  %t1 = fcmp ult float %a, %b
  %t2 = fcmp une float %a, %b
  %t3 = zext i1 %t2 to i64
  %t4 = select i1 %t1, i64 -1, i64 %t3
  ret i64 %t4
}

; Verify this case doesn't crash
define void @setbn4(i128 %0, ptr %sel.out) {
; CHECK-LABEL: setbn4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r6, 1
; CHECK-NEXT:    cmpdi cr1, r3, 0
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    rldic r6, r6, 48, 15
; CHECK-NEXT:    cmpld r4, r6
; CHECK-NEXT:    crandc 4*cr5+lt, gt, eq
; CHECK-NEXT:    crandc 4*cr5+gt, eq, 4*cr1+eq
; CHECK-NEXT:    crnor 4*cr5+lt, 4*cr5+gt, 4*cr5+lt
; CHECK-NEXT:    rldicl. r4, r4, 16, 48
; CHECK-NEXT:    li r4, -1
; CHECK-NEXT:    isel r3, 0, r3, 4*cr5+lt
; CHECK-NEXT:    iseleq r3, r4, r3
; CHECK-NEXT:    stw r3, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-PWR8-LABEL: setbn4:
; CHECK-PWR8:       # %bb.0: # %entry
; CHECK-PWR8-NEXT:    li r6, 1
; CHECK-PWR8-NEXT:    cmpdi cr1, r3, 0
; CHECK-PWR8-NEXT:    li r3, 1
; CHECK-PWR8-NEXT:    rldic r6, r6, 48, 15
; CHECK-PWR8-NEXT:    cmpld r4, r6
; CHECK-PWR8-NEXT:    crandc 4*cr5+lt, gt, eq
; CHECK-PWR8-NEXT:    crandc 4*cr5+gt, eq, 4*cr1+eq
; CHECK-PWR8-NEXT:    rldicl. r4, r4, 16, 48
; CHECK-PWR8-NEXT:    li r4, -1
; CHECK-PWR8-NEXT:    crnor 4*cr5+lt, 4*cr5+gt, 4*cr5+lt
; CHECK-PWR8-NEXT:    isel r3, 0, r3, 4*cr5+lt
; CHECK-PWR8-NEXT:    iseleq r3, r4, r3
; CHECK-PWR8-NEXT:    stw r3, 0(r5)
; CHECK-PWR8-NEXT:    blr
entry:
  %c1 = icmp ult i128 %0, 5192296858534827628530496329220096
  %c2 = icmp ugt i128 %0, 5192296858534827628530496329220096
  %ext = zext i1 %c2 to i32
  %sel = select i1 %c1, i32 -1, i32 %ext
  store i32 %sel, ptr %sel.out, align 4
  ret void
}
