; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+m -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+v,+m -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,RV64

; FIXME: We're missing canonicalizations of ISD::VP_SETCC equivalent to those
; for ISD::SETCC, e.g., splats aren't moved to the RHS.

declare <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8>, <vscale x 1 x i8>, metadata, <vscale x 1 x i1>, i32)

define <vscale x 1 x i1> @icmp_eq_vv_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vx_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vx_swap_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vi_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vi_swap_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vv_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsne.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vx_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vx_swap_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vx_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vi_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vi_swap_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vv_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vx_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vx_swap_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vx_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vi_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vi_swap_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vv_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vx_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vx_swap_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vx_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsleu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vi_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vi_swap_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vv_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vx_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vx_swap_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vx_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vi_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vi_swap_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vv_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vx_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vx_swap_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vx_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vi_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vi_swap_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vv_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vx_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vx_swap_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vx_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vi_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vi_swap_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vv_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vx_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vx_swap_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vx_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vi_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vi_swap_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vv_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vx_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vx_swap_nxv1i8(<vscale x 1 x i8> %va, i8 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vx_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vi_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vi_swap_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_swap_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 1 x i8> %elt.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i8(<vscale x 1 x i8> %vb, <vscale x 1 x i8> %va, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

declare <vscale x 3 x i1> @llvm.vp.icmp.nxv3i8(<vscale x 3 x i8>, <vscale x 3 x i8>, metadata, <vscale x 3 x i1>, i32)

define <vscale x 3 x i1> @icmp_eq_vv_nxv3i8(<vscale x 3 x i8> %va, <vscale x 3 x i8> %vb, <vscale x 3 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv3i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 3 x i1> @llvm.vp.icmp.nxv3i8(<vscale x 3 x i8> %va, <vscale x 3 x i8> %vb, metadata !"eq", <vscale x 3 x i1> %m, i32 %evl)
  ret <vscale x 3 x i1> %v
}

define <vscale x 3 x i1> @icmp_eq_vx_nxv3i8(<vscale x 3 x i8> %va, i8 %b, <vscale x 3 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_nxv3i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 3 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 3 x i8> %elt.head, <vscale x 3 x i8> poison, <vscale x 3 x i32> zeroinitializer
  %v = call <vscale x 3 x i1> @llvm.vp.icmp.nxv3i8(<vscale x 3 x i8> %va, <vscale x 3 x i8> %vb, metadata !"eq", <vscale x 3 x i1> %m, i32 %evl)
  ret <vscale x 3 x i1> %v
}

define <vscale x 3 x i1> @icmp_eq_vx_swap_nxv3i8(<vscale x 3 x i8> %va, i8 %b, <vscale x 3 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_swap_nxv3i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 3 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 3 x i8> %elt.head, <vscale x 3 x i8> poison, <vscale x 3 x i32> zeroinitializer
  %v = call <vscale x 3 x i1> @llvm.vp.icmp.nxv3i8(<vscale x 3 x i8> %vb, <vscale x 3 x i8> %va, metadata !"eq", <vscale x 3 x i1> %m, i32 %evl)
  ret <vscale x 3 x i1> %v
}

declare <vscale x 8 x i1> @llvm.vp.icmp.nxv8i7(<vscale x 8 x i7>, <vscale x 8 x i7>, metadata, <vscale x 8 x i1>, i32)

define <vscale x 8 x i1> @icmp_eq_vv_nxv8i7(<vscale x 8 x i7> %va, <vscale x 8 x i7> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv8i7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 127
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vand.vx v9, v9, a1
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i7(<vscale x 8 x i7> %va, <vscale x 8 x i7> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vx_nxv8i7(<vscale x 8 x i7> %va, i7 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_nxv8i7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 127
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a2
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vand.vx v9, v9, a2
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i7> poison, i7 %b, i32 0
  %vb = shufflevector <vscale x 8 x i7> %elt.head, <vscale x 8 x i7> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i7(<vscale x 8 x i7> %va, <vscale x 8 x i7> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vx_swap_nxv8i7(<vscale x 8 x i7> %va, i7 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_swap_nxv8i7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 127
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a2
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vand.vx v9, v9, a2
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i7> poison, i7 %b, i32 0
  %vb = shufflevector <vscale x 8 x i7> %elt.head, <vscale x 8 x i7> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i7(<vscale x 8 x i7> %vb, <vscale x 8 x i7> %va, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

declare <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8>, <vscale x 8 x i8>, metadata, <vscale x 8 x i1>, i32)

define <vscale x 8 x i1> @icmp_eq_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vx_swap_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vi_swap_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsne.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vx_swap_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vx_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vi_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vi_swap_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vx_swap_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vx_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vi_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vi_swap_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vx_swap_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vx_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vi_swap_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vx_swap_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vx_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vi_swap_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vx_swap_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vx_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vi_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vi_swap_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vx_swap_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vx_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vi_swap_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vx_swap_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vx_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vi_swap_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vx_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vx_swap_nxv8i8(<vscale x 8 x i8> %va, i8 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vx_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vi_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vi_swap_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_swap_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i8> poison, i8 4, i32 0
  %vb = shufflevector <vscale x 8 x i8> %elt.head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i8(<vscale x 8 x i8> %vb, <vscale x 8 x i8> %va, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

declare <vscale x 128 x i1> @llvm.vp.icmp.nxv128i8(<vscale x 128 x i8>, <vscale x 128 x i8>, metadata, <vscale x 128 x i1>, i32)

define <vscale x 128 x i1> @icmp_eq_vv_nxv128i8(<vscale x 128 x i8> %va, <vscale x 128 x i8> %vb, <vscale x 128 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 4
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a4, a0, a1
; CHECK-NEXT:    vl8r.v v8, (a4)
; CHECK-NEXT:    vl8r.v v0, (a0)
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v0, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    sub a0, a3, a1
; CHECK-NEXT:    vlm.v v0, (a2)
; CHECK-NEXT:    sltu a2, a3, a0
; CHECK-NEXT:    addi a2, a2, -1
; CHECK-NEXT:    and a0, a2, a0
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmseq.vv v1, v16, v8, v0.t
; CHECK-NEXT:    bltu a3, a1, .LBB96_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:  .LBB96_2:
; CHECK-NEXT:    vsetvli zero, a3, e8, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmseq.vv v16, v8, v24, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmv1r.v v8, v1
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = call <vscale x 128 x i1> @llvm.vp.icmp.nxv128i8(<vscale x 128 x i8> %va, <vscale x 128 x i8> %vb, metadata !"eq", <vscale x 128 x i1> %m, i32 %evl)
  ret <vscale x 128 x i1> %v
}

define <vscale x 128 x i1> @icmp_eq_vx_nxv128i8(<vscale x 128 x i8> %va, i8 %b, <vscale x 128 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_nxv128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    vsetvli a3, zero, e8, m8, ta, ma
; CHECK-NEXT:    vlm.v v0, (a1)
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    sub a3, a2, a1
; CHECK-NEXT:    sltu a4, a2, a3
; CHECK-NEXT:    addi a4, a4, -1
; CHECK-NEXT:    and a3, a4, a3
; CHECK-NEXT:    vsetvli zero, a3, e8, m8, ta, ma
; CHECK-NEXT:    vmseq.vx v25, v16, a0, v0.t
; CHECK-NEXT:    bltu a2, a1, .LBB97_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:  .LBB97_2:
; CHECK-NEXT:    vsetvli zero, a2, e8, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    vmseq.vx v16, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmv1r.v v8, v25
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 128 x i8> poison, i8 %b, i8 0
  %vb = shufflevector <vscale x 128 x i8> %elt.head, <vscale x 128 x i8> poison, <vscale x 128 x i32> zeroinitializer
  %v = call <vscale x 128 x i1> @llvm.vp.icmp.nxv128i8(<vscale x 128 x i8> %va, <vscale x 128 x i8> %vb, metadata !"eq", <vscale x 128 x i1> %m, i32 %evl)
  ret <vscale x 128 x i1> %v
}

define <vscale x 128 x i1> @icmp_eq_vx_swap_nxv128i8(<vscale x 128 x i8> %va, i8 %b, <vscale x 128 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_swap_nxv128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    vsetvli a3, zero, e8, m8, ta, ma
; CHECK-NEXT:    vlm.v v0, (a1)
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    sub a3, a2, a1
; CHECK-NEXT:    sltu a4, a2, a3
; CHECK-NEXT:    addi a4, a4, -1
; CHECK-NEXT:    and a3, a4, a3
; CHECK-NEXT:    vsetvli zero, a3, e8, m8, ta, ma
; CHECK-NEXT:    vmseq.vx v25, v16, a0, v0.t
; CHECK-NEXT:    bltu a2, a1, .LBB98_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:  .LBB98_2:
; CHECK-NEXT:    vsetvli zero, a2, e8, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    vmseq.vx v16, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmv1r.v v8, v25
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 128 x i8> poison, i8 %b, i8 0
  %vb = shufflevector <vscale x 128 x i8> %elt.head, <vscale x 128 x i8> poison, <vscale x 128 x i32> zeroinitializer
  %v = call <vscale x 128 x i1> @llvm.vp.icmp.nxv128i8(<vscale x 128 x i8> %vb, <vscale x 128 x i8> %va, metadata !"eq", <vscale x 128 x i1> %m, i32 %evl)
  ret <vscale x 128 x i1> %v
}

declare <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32>, <vscale x 1 x i32>, metadata, <vscale x 1 x i1>, i32)

define <vscale x 1 x i1> @icmp_eq_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vx_swap_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmseq.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vi_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vi_swap_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsne.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vx_swap_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vx_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsne.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vi_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vi_swap_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vx_swap_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vx_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vi_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vi_swap_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vx_swap_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vx_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsleu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vi_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vi_swap_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsltu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vx_swap_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vx_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgtu.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vi_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vi_swap_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vx_swap_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vx_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vi_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vi_swap_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vx_swap_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vx_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vi_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vi_swap_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmslt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vx_swap_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vx_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vi_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vi_swap_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vx_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vx v0, v8, a0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vx_swap_nxv1i32(<vscale x 1 x i32> %va, i32 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vx_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vi_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vi_swap_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_swap_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 1 x i32> %elt.head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i32(<vscale x 1 x i32> %vb, <vscale x 1 x i32> %va, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

declare <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32>, <vscale x 8 x i32>, metadata, <vscale x 8 x i1>, i32)

define <vscale x 8 x i1> @icmp_eq_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vx_swap_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vi_swap_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmseq.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsne.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsne.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vx_swap_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vx_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsne.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vi_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsne.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vi_swap_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsne.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsltu.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vx_swap_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vx_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsltu.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vi_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vi_swap_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vi v12, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v16, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vv v12, v16, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vx_swap_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vx_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vi v12, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vi_swap_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsltu.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsltu.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vx_swap_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vx_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsleu.vi v12, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vi_swap_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsgtu.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vx_swap_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vx_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vi_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vi_swap_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vi v12, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v16, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vv v12, v16, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vx_swap_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vx_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v12, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vi_swap_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vx_swap_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vx_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vi v12, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vi_swap_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vx_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vx_swap_nxv8i32(<vscale x 8 x i32> %va, i32 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vx_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v16, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vv v12, v16, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vi_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vi v12, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vi_swap_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_swap_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v12, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i32> poison, i32 4, i32 0
  %vb = shufflevector <vscale x 8 x i32> %elt.head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i32(<vscale x 8 x i32> %vb, <vscale x 8 x i32> %va, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

declare <vscale x 32 x i1> @llvm.vp.icmp.nxv32i32(<vscale x 32 x i32>, <vscale x 32 x i32>, metadata, <vscale x 32 x i1>, i32)

define <vscale x 32 x i1> @icmp_eq_vv_nxv32i32(<vscale x 32 x i32> %va, <vscale x 32 x i32> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 4
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    vsetvli a3, zero, e8, mf2, ta, ma
; CHECK-NEXT:    slli a3, a1, 3
; CHECK-NEXT:    add a3, a0, a3
; CHECK-NEXT:    vl8re32.v v8, (a3)
; CHECK-NEXT:    slli a3, a1, 1
; CHECK-NEXT:    sub a4, a2, a3
; CHECK-NEXT:    sltu a5, a2, a4
; CHECK-NEXT:    addi a5, a5, -1
; CHECK-NEXT:    and a4, a5, a4
; CHECK-NEXT:    srli a1, a1, 2
; CHECK-NEXT:    vl8re32.v v0, (a0)
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v0, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vslidedown.vx v0, v24, a1
; CHECK-NEXT:    vsetvli zero, a4, e32, m8, ta, ma
; CHECK-NEXT:    vmseq.vv v1, v16, v8, v0.t
; CHECK-NEXT:    bltu a2, a3, .LBB189_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:  .LBB189_2:
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmseq.vv v16, v8, v24, v0.t
; CHECK-NEXT:    add a0, a1, a1
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    vslideup.vx v16, v1, a1
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i32(<vscale x 32 x i32> %va, <vscale x 32 x i32> %vb, metadata !"eq", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 32 x i1> @icmp_eq_vx_nxv32i32(<vscale x 32 x i32> %va, i32 %b, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_nxv32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    csrr a3, vlenb
; CHECK-NEXT:    srli a2, a3, 2
; CHECK-NEXT:    vsetvli a4, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-NEXT:    slli a3, a3, 1
; CHECK-NEXT:    sub a4, a1, a3
; CHECK-NEXT:    sltu a5, a1, a4
; CHECK-NEXT:    addi a5, a5, -1
; CHECK-NEXT:    and a4, a5, a4
; CHECK-NEXT:    vsetvli zero, a4, e32, m8, ta, ma
; CHECK-NEXT:    vmseq.vx v25, v16, a0, v0.t
; CHECK-NEXT:    bltu a1, a3, .LBB190_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:  .LBB190_2:
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    vmseq.vx v16, v8, a0, v0.t
; CHECK-NEXT:    add a0, a2, a2
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    vslideup.vx v16, v25, a2
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 32 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 32 x i32> %elt.head, <vscale x 32 x i32> poison, <vscale x 32 x i32> zeroinitializer
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i32(<vscale x 32 x i32> %va, <vscale x 32 x i32> %vb, metadata !"eq", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 32 x i1> @icmp_eq_vx_swap_nxv32i32(<vscale x 32 x i32> %va, i32 %b, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vx_swap_nxv32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    csrr a3, vlenb
; CHECK-NEXT:    srli a2, a3, 2
; CHECK-NEXT:    vsetvli a4, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-NEXT:    slli a3, a3, 1
; CHECK-NEXT:    sub a4, a1, a3
; CHECK-NEXT:    sltu a5, a1, a4
; CHECK-NEXT:    addi a5, a5, -1
; CHECK-NEXT:    and a4, a5, a4
; CHECK-NEXT:    vsetvli zero, a4, e32, m8, ta, ma
; CHECK-NEXT:    vmseq.vx v25, v16, a0, v0.t
; CHECK-NEXT:    bltu a1, a3, .LBB191_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:  .LBB191_2:
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    vmseq.vx v16, v8, a0, v0.t
; CHECK-NEXT:    add a0, a2, a2
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    vslideup.vx v16, v25, a2
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 32 x i32> poison, i32 %b, i32 0
  %vb = shufflevector <vscale x 32 x i32> %elt.head, <vscale x 32 x i32> poison, <vscale x 32 x i32> zeroinitializer
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i32(<vscale x 32 x i32> %vb, <vscale x 32 x i32> %va, metadata !"eq", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

declare <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64>, <vscale x 1 x i64>, metadata, <vscale x 1 x i1>, i32)

define <vscale x 1 x i1> @icmp_eq_vv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmseq.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vx_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_eq_vx_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmseq.vv v0, v8, v9, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_eq_vx_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmseq.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vx_swap_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_eq_vx_swap_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmseq.vv v0, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_eq_vx_swap_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmseq.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vi_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_eq_vi_swap_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_swap_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmseq.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsne.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vx_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ne_vx_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsne.vv v0, v8, v9, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ne_vx_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsne.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vx_swap_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ne_vx_swap_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsne.vv v0, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ne_vx_swap_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsne.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vi_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vi_swap_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_swap_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vx_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ugt_vx_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsltu.vv v0, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ugt_vx_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsgtu.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vx_swap_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ugt_vx_swap_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsltu.vv v0, v8, v9, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ugt_vx_swap_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsltu.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vi_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vi_swap_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_swap_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsleu.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vx_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_uge_vx_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsleu.vv v0, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_uge_vx_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.v.x v9, a0
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsleu.vv v0, v9, v8, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vx_swap_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_uge_vx_swap_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsleu.vv v0, v8, v9, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_uge_vx_swap_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsleu.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vi_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vi_swap_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_swap_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsltu.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vx_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ult_vx_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsltu.vv v0, v8, v9, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ult_vx_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsltu.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vx_swap_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ult_vx_swap_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsltu.vv v0, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ult_vx_swap_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsgtu.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vi_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsleu.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vi_swap_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_swap_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsgtu.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vx_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sgt_vx_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmslt.vv v0, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sgt_vx_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsgt.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vx_swap_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sgt_vx_swap_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmslt.vv v0, v8, v9, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sgt_vx_swap_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmslt.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vi_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vi_swap_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_swap_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vx_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sge_vx_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsle.vv v0, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sge_vx_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.v.x v9, a0
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsle.vv v0, v9, v8, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vx_swap_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sge_vx_swap_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsle.vv v0, v8, v9, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sge_vx_swap_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsle.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vi_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vi_swap_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_swap_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmslt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vx_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_slt_vx_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmslt.vv v0, v8, v9, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_slt_vx_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmslt.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vx_swap_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_slt_vx_swap_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmslt.vv v0, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_slt_vx_swap_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsgt.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vi_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vi_swap_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_swap_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vx_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sle_vx_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsle.vv v0, v8, v9, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sle_vx_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsle.vx v0, v8, a0, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vx_swap_nxv1i64(<vscale x 1 x i64> %va, i64 %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sle_vx_swap_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vmsle.vv v0, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sle_vx_swap_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.v.x v9, a0
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmsle.vv v0, v9, v8, v0.t
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vi_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsle.vi v0, v8, 4, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vi_swap_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_swap_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 3, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 1 x i64> %elt.head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i64(<vscale x 1 x i64> %vb, <vscale x 1 x i64> %va, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

declare <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64>, <vscale x 8 x i64>, metadata, <vscale x 8 x i1>, i32)

define <vscale x 8 x i1> @icmp_eq_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmseq.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_eq_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmseq.vv v16, v8, v24, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_eq_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmseq.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vx_swap_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_eq_vx_swap_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmseq.vv v16, v24, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_eq_vx_swap_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmseq.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vi_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmseq.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_eq_vi_swap_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vi_swap_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmseq.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsne.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ne_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsne.vv v16, v8, v24, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ne_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsne.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vx_swap_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ne_vx_swap_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsne.vv v16, v24, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ne_vx_swap_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsne.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vi_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsne.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vi_swap_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vi_swap_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsne.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsltu.vv v24, v16, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ugt_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsltu.vv v16, v24, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ugt_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsgtu.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vx_swap_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ugt_vx_swap_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsltu.vv v16, v8, v24, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ugt_vx_swap_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsltu.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vi_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vi_swap_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vi_swap_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsleu.vi v16, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsleu.vv v24, v16, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_uge_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsleu.vv v16, v24, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_uge_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, ma
; RV64-NEXT:    vmv.v.x v24, a0
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsleu.vv v16, v24, v8, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vx_swap_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_uge_vx_swap_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsleu.vv v16, v8, v24, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_uge_vx_swap_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsleu.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vi_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v16, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vi_swap_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vi_swap_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsleu.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsltu.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ult_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsltu.vv v16, v8, v24, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ult_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsltu.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vx_swap_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_ult_vx_swap_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsltu.vv v16, v24, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_ult_vx_swap_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsgtu.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vi_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsleu.vi v16, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vi_swap_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vi_swap_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsgtu.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmslt.vv v24, v16, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sgt_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmslt.vv v16, v24, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sgt_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsgt.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vx_swap_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sgt_vx_swap_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmslt.vv v16, v8, v24, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sgt_vx_swap_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmslt.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vi_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsgt.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vi_swap_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vi_swap_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vi v16, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vv v24, v16, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sge_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsle.vv v16, v24, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sge_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, ma
; RV64-NEXT:    vmv.v.x v24, a0
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsle.vv v16, v24, v8, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vx_swap_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sge_vx_swap_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsle.vv v16, v8, v24, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sge_vx_swap_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsle.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vi_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsgt.vi v16, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vi_swap_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vi_swap_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmslt.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_slt_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmslt.vv v16, v8, v24, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_slt_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmslt.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vx_swap_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_slt_vx_swap_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmslt.vv v16, v24, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_slt_vx_swap_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsgt.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vi_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vi v16, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vi_swap_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vi_swap_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsgt.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sle_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsle.vv v16, v8, v24, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sle_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsle.vx v16, v8, a0, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vx_swap_nxv8i64(<vscale x 8 x i64> %va, i64 %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: icmp_sle_vx_swap_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; RV32-NEXT:    vmsle.vv v16, v24, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: icmp_sle_vx_swap_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, ma
; RV64-NEXT:    vmv.v.x v24, a0
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; RV64-NEXT:    vmsle.vv v16, v24, v8, v0.t
; RV64-NEXT:    vmv1r.v v0, v16
; RV64-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vi_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsle.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vi_swap_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vi_swap_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmsgt.vi v16, v8, 3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x i64> poison, i64 4, i32 0
  %vb = shufflevector <vscale x 8 x i64> %elt.head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i64(<vscale x 8 x i64> %vb, <vscale x 8 x i64> %va, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}
