; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=newgvn < %s | FileCheck %s

define ptr addrspace(1) @addrspacecast(ptr %ptr) {
; CHECK-LABEL: @addrspacecast(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[Z1:%.*]] = addrspacecast ptr [[PTR:%.*]] to ptr addrspace(1)
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    store ptr addrspace(1) [[Z1]], ptr undef
; CHECK-NEXT:    ret ptr addrspace(1) [[Z1]]
;
block1:
  %z1 = addrspacecast ptr %ptr to ptr addrspace(1)
  br label %block2

block2:
  %z2 = addrspacecast ptr %ptr to ptr addrspace(1)
  store ptr addrspace(1) %z1, ptr undef
  ret ptr addrspace(1) %z2
}

; Make sure casts with the same source value but different result
; address spaces aren't incorrectly merged.
define ptr addrspace(1) @addrspacecast_different_result_types(ptr %ptr) {
; CHECK-LABEL: @addrspacecast_different_result_types(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[Z1:%.*]] = addrspacecast ptr [[PTR:%.*]] to ptr addrspace(2)
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    [[Z2:%.*]] = addrspacecast ptr [[PTR]] to ptr addrspace(1)
; CHECK-NEXT:    store ptr addrspace(2) [[Z1]], ptr undef
; CHECK-NEXT:    ret ptr addrspace(1) [[Z2]]
;
block1:
  %z1 = addrspacecast ptr %ptr to ptr addrspace(2)
  br label %block2

block2:
  %z2 = addrspacecast ptr %ptr to ptr addrspace(1)
  store ptr addrspace(2) %z1, ptr undef
  ret ptr addrspace(1) %z2
}

define ptr addrspace(1) @addrspacecast_simplify(ptr addrspace(1) %ptr) {
; CHECK-LABEL: @addrspacecast_simplify(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[CAST0:%.*]] = addrspacecast ptr addrspace(1) [[PTR:%.*]] to ptr
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    store ptr addrspace(1) [[PTR]], ptr undef
; CHECK-NEXT:    ret ptr addrspace(1) [[PTR]]
;
block1:
  %cast0 = addrspacecast ptr addrspace(1) %ptr to ptr
  %z1 = addrspacecast ptr %cast0 to ptr addrspace(1)
  br label %block2

block2:
  %z2 = addrspacecast ptr %cast0 to ptr addrspace(1)
  store ptr addrspace(1) %z1, ptr undef
  ret ptr addrspace(1) %z2
}

@h = common local_unnamed_addr global ptr null, align 4

define ptr addrspace(1) @addrspacecast_constant() {
; CHECK-LABEL: @addrspacecast_constant(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    store ptr undef, ptr @h, align 4
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    store ptr addrspace(1) undef, ptr undef
; CHECK-NEXT:    ret ptr addrspace(1) undef
;
block1:
  store ptr undef, ptr @h, align 4
  %ptr = load ptr, ptr @h, align 4
  %z1 = addrspacecast ptr %ptr to ptr addrspace(1)
  br label %block2

block2:
  %z2 = addrspacecast ptr %ptr to ptr addrspace(1)
  store ptr addrspace(1) %z1, ptr undef
  ret ptr addrspace(1) %z2
}

define ptr addrspace(1) @addrspacecast_leader(ptr %arg.ptr) {
; CHECK-LABEL: @addrspacecast_leader(
; CHECK-NEXT:  block1:
; CHECK-NEXT:    [[LOAD0:%.*]] = load ptr, ptr [[ARG_PTR:%.*]]
; CHECK-NEXT:    [[Z1:%.*]] = addrspacecast ptr [[LOAD0]] to ptr addrspace(1)
; CHECK-NEXT:    br label [[BLOCK2:%.*]]
; CHECK:       block2:
; CHECK-NEXT:    store ptr addrspace(1) [[Z1]], ptr undef
; CHECK-NEXT:    ret ptr addrspace(1) [[Z1]]
;
block1:
  %load0 = load ptr, ptr %arg.ptr
  %z1 = addrspacecast ptr %load0 to ptr addrspace(1)
  br label %block2

block2:
  %load1 = load ptr, ptr %arg.ptr
  %z2 = addrspacecast ptr %load1 to ptr addrspace(1)
  store ptr addrspace(1) %z1, ptr undef
  ret ptr addrspace(1) %z2
}
