; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mcpu=pwr8 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64le-unknown-linux-gnu < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-LE-P8
; RUN: llc -verify-machineinstrs -mcpu=pwr9 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64le-unknown-linux-gnu < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-LE-P9
; RUN: llc -verify-machineinstrs -mcpu=pwr8 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64-unknown-linux-gnu < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-BE-P8
; RUN: llc -verify-machineinstrs -mcpu=pwr9 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64-unknown-linux-gnu < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-BE-P9

; RUN: llc -verify-machineinstrs -mcpu=pwr8 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64-ibm-aix < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-AIX-64-P8
; RUN: llc -verify-machineinstrs -mcpu=pwr9 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc64-ibm-aix < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-AIX-64-P9
; RUN: llc -verify-machineinstrs -mcpu=pwr8 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc-ibm-aix < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-AIX-32-P8
; RUN: llc -verify-machineinstrs -mcpu=pwr9 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -mtriple=powerpc-ibm-aix < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-AIX-32-P9

define <2 x i64> @test_v16i8_v16i8(i8 %arg1, i8 %arg) {
; CHECK-LE-P8-LABEL: test_v16i8_v16i8:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v16i8_v16i8:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    mtfprd f1, r4
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v16i8_v16i8:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    mtfprwz f0, r3
; CHECK-BE-P8-NEXT:    mtfprwz f1, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v16i8_v16i8:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mtfprwz f0, r3
; CHECK-BE-P9-NEXT:    mtfprwz f1, r4
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v16i8_v16i8:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P8-NEXT:    mtfprwz f1, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v16i8_v16i8:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P9-NEXT:    mtfprwz f1, r4
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v16i8_v16i8:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    stb r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v16i8_v16i8:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    stb r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <16 x i8> undef, i8 %arg1, i32 0
  %lhs = bitcast <16 x i8> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <16 x i8> undef, i8 %arg, i32 0
  %rhs = bitcast <16 x i8> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_none_v16i8(i8 %arg1, ptr nocapture noundef readonly %b) {
; CHECK-LE-P8-LABEL: test_none_v16i8:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    lxvd2x vs0, 0, r4
; CHECK-LE-P8-NEXT:    xxswapd v2, vs0
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_none_v16i8:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_none_v16i8:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-BE-P8-NEXT:    mtfprwz f0, r3
; CHECK-BE-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_none_v16i8:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-BE-P9-NEXT:    mtfprwz f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_none_v16i8:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_none_v16i8:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_none_v16i8:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_none_v16i8:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <16 x i8> undef, i8 %arg1, i32 0
  %lhs = bitcast <16 x i8> %lhs.tmp to <2 x i64>
  %rhs = load <2 x i64>, ptr %b, align 4
  %shuffle = shufflevector <2 x i64> %rhs, <2 x i64> %lhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v16i8_none(i8 %arg1, ptr nocapture noundef readonly %b) {
; CHECK-LE-P8-LABEL: test_v16i8_none:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    lxvd2x vs0, 0, r4
; CHECK-LE-P8-NEXT:    xxswapd v2, vs0
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v16i8_none:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v16i8_none:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-BE-P8-NEXT:    mtfprwz f0, r3
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, v2
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v16i8_none:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-BE-P9-NEXT:    mtfprwz f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, v2
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v16i8_none:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v16i8_none:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v16i8_none:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v16i8_none:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <16 x i8> undef, i8 %arg1, i32 0
  %lhs = bitcast <16 x i8> %lhs.tmp to <2 x i64>
  %rhs = load <2 x i64>, ptr %b, align 4
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v16i8_v8i16(i8 %arg1, i16 %arg) {
; CHECK-LE-P8-LABEL: test_v16i8_v8i16:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P8-NEXT:    xxswapd vs1, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v16i8_v8i16:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    mtfprd f1, r4
; CHECK-LE-P9-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P9-NEXT:    xxswapd vs1, vs1
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v16i8_v8i16:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    sldi r3, r3, 56
; CHECK-BE-P8-NEXT:    sldi r4, r4, 48
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    mtfprd f1, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v16i8_v8i16:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    sldi r3, r3, 56
; CHECK-BE-P9-NEXT:    mtfprd f0, r3
; CHECK-BE-P9-NEXT:    sldi r3, r4, 48
; CHECK-BE-P9-NEXT:    mtfprd f1, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v16i8_v8i16:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    sldi r3, r3, 56
; CHECK-AIX-64-P8-NEXT:    sldi r4, r4, 48
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v16i8_v8i16:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    sldi r3, r3, 56
; CHECK-AIX-64-P9-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P9-NEXT:    sldi r3, r4, 48
; CHECK-AIX-64-P9-NEXT:    mtfprd f1, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v16i8_v8i16:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    sth r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v16i8_v8i16:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    sth r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <16 x i8> undef, i8 %arg1, i32 0
  %lhs = bitcast <16 x i8> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <8 x i16> undef, i16 %arg, i32 0
  %rhs = bitcast <8 x i16> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v8i16_v16i8(i8 %arg1, i16 %arg) {
; CHECK-LE-P8-LABEL: test_v8i16_v16i8:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P8-NEXT:    xxswapd vs1, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs0, vs1
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v8i16_v16i8:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    mtfprd f1, r4
; CHECK-LE-P9-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P9-NEXT:    xxswapd vs1, vs1
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs0, vs1
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v8i16_v16i8:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    sldi r3, r3, 56
; CHECK-BE-P8-NEXT:    sldi r4, r4, 48
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    mtfprd f1, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v8i16_v16i8:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    sldi r3, r3, 56
; CHECK-BE-P9-NEXT:    mtfprd f0, r3
; CHECK-BE-P9-NEXT:    sldi r3, r4, 48
; CHECK-BE-P9-NEXT:    mtfprd f1, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v8i16_v16i8:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    sldi r3, r3, 56
; CHECK-AIX-64-P8-NEXT:    sldi r4, r4, 48
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v8i16_v16i8:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    sldi r3, r3, 56
; CHECK-AIX-64-P9-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P9-NEXT:    sldi r3, r4, 48
; CHECK-AIX-64-P9-NEXT:    mtfprd f1, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v8i16_v16i8:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    sth r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v8i16_v16i8:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    sth r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <16 x i8> undef, i8 %arg1, i32 0
  %lhs = bitcast <16 x i8> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <8 x i16> undef, i16 %arg, i32 0
  %rhs = bitcast <8 x i16> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %rhs, <2 x i64> %lhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v8i16_none(i16 %arg1, ptr nocapture noundef readonly %b) {
; CHECK-LE-P8-LABEL: test_v8i16_none:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    lxvd2x vs0, 0, r4
; CHECK-LE-P8-NEXT:    xxswapd v2, vs0
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v8i16_none:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v8i16_none:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-BE-P8-NEXT:    mtfprwz f0, r3
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, v2
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v8i16_none:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-BE-P9-NEXT:    mtfprwz f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, v2
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v8i16_none:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v8i16_none:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v8i16_none:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    sth r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v8i16_none:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    sth r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <8 x i16> undef, i16 %arg1, i32 0
  %lhs = bitcast <8 x i16> %lhs.tmp to <2 x i64>
  %rhs = load <2 x i64>, ptr %b, align 4
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_none_v8i16(i16 %arg1, ptr nocapture noundef readonly %b) {
; CHECK-LE-P8-LABEL: test_none_v8i16:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    lxvd2x vs0, 0, r4
; CHECK-LE-P8-NEXT:    xxswapd v2, vs0
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_none_v8i16:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_none_v8i16:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-BE-P8-NEXT:    mtfprwz f0, r3
; CHECK-BE-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_none_v8i16:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-BE-P9-NEXT:    mtfprwz f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_none_v8i16:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_none_v8i16:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_none_v8i16:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    sth r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_none_v8i16:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    sth r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <8 x i16> undef, i16 %arg1, i32 0
  %lhs = bitcast <8 x i16> %lhs.tmp to <2 x i64>
  %rhs = load <2 x i64>, ptr %b, align 4
  %shuffle = shufflevector <2 x i64> %rhs, <2 x i64> %lhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v16i8_v4i32(i8 %arg1, i32 %arg) {
; CHECK-LE-P8-LABEL: test_v16i8_v4i32:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P8-NEXT:    xxswapd vs1, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v16i8_v4i32:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    mtvsrws vs1, r4
; CHECK-LE-P9-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v16i8_v4i32:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    sldi r3, r3, 56
; CHECK-BE-P8-NEXT:    sldi r4, r4, 32
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    mtfprd f1, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v16i8_v4i32:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    sldi r3, r3, 56
; CHECK-BE-P9-NEXT:    mtvsrws vs1, r4
; CHECK-BE-P9-NEXT:    mtfprd f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v16i8_v4i32:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    sldi r3, r3, 56
; CHECK-AIX-64-P8-NEXT:    sldi r4, r4, 32
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v16i8_v4i32:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    sldi r3, r3, 56
; CHECK-AIX-64-P9-NEXT:    mtvsrws vs1, r4
; CHECK-AIX-64-P9-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v16i8_v4i32:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v16i8_v4i32:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <16 x i8> undef, i8 %arg1, i32 0
  %lhs = bitcast <16 x i8> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <4 x i32> undef, i32 %arg, i32 0
  %rhs = bitcast <4 x i32> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v4i32_v16i8(i8 %arg1, i32 %arg) {
; CHECK-LE-P8-LABEL: test_v4i32_v16i8:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P8-NEXT:    xxswapd vs1, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs0, vs1
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v4i32_v16i8:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    mtvsrws vs1, r4
; CHECK-LE-P9-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs0, vs1
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v4i32_v16i8:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    sldi r3, r3, 56
; CHECK-BE-P8-NEXT:    sldi r4, r4, 32
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    mtfprd f1, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v4i32_v16i8:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    sldi r3, r3, 56
; CHECK-BE-P9-NEXT:    mtvsrws vs1, r4
; CHECK-BE-P9-NEXT:    mtfprd f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v4i32_v16i8:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    sldi r3, r3, 56
; CHECK-AIX-64-P8-NEXT:    sldi r4, r4, 32
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v4i32_v16i8:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    sldi r3, r3, 56
; CHECK-AIX-64-P9-NEXT:    mtvsrws vs1, r4
; CHECK-AIX-64-P9-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v4i32_v16i8:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v4i32_v16i8:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <16 x i8> undef, i8 %arg1, i32 0
  %lhs = bitcast <16 x i8> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <4 x i32> undef, i32 %arg, i32 0
  %rhs = bitcast <4 x i32> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %rhs, <2 x i64> %lhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_none_v4i32(i32 %arg1, ptr nocapture noundef readonly %b) {
; CHECK-LE-P8-LABEL: test_none_v4i32:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    lxvd2x vs0, 0, r4
; CHECK-LE-P8-NEXT:    xxswapd v2, vs0
; CHECK-LE-P8-NEXT:    mtfprwz f0, r3
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_none_v4i32:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-LE-P9-NEXT:    mtfprwz f0, r3
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_none_v4i32:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-BE-P8-NEXT:    mtfprwz f0, r3
; CHECK-BE-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_none_v4i32:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-BE-P9-NEXT:    mtfprwz f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_none_v4i32:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_none_v4i32:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_none_v4i32:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stw r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_none_v4i32:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stw r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <4 x i32> undef, i32 %arg1, i32 0
  %lhs = bitcast <4 x i32> %lhs.tmp to <2 x i64>
  %rhs = load <2 x i64>, ptr %b, align 4
  %shuffle = shufflevector <2 x i64> %rhs, <2 x i64> %lhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v4i32_none(i32 %arg1, ptr nocapture noundef readonly %b) {
; CHECK-LE-P8-LABEL: test_v4i32_none:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    lxvd2x vs0, 0, r4
; CHECK-LE-P8-NEXT:    xxswapd v2, vs0
; CHECK-LE-P8-NEXT:    mtfprwz f0, r3
; CHECK-LE-P8-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v4i32_none:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-LE-P9-NEXT:    mtfprwz f0, r3
; CHECK-LE-P9-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v4i32_none:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-BE-P8-NEXT:    mtfprwz f0, r3
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, v2
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v4i32_none:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    lxv v2, 0(r4)
; CHECK-BE-P9-NEXT:    mtfprwz f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, v2
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v4i32_none:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v4i32_none:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v4i32_none:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stw r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    lxvd2x v2, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v4i32_none:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stw r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv v2, 0(r4)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <4 x i32> undef, i32 %arg1, i32 0
  %lhs = bitcast <4 x i32> %lhs.tmp to <2 x i64>
  %rhs = load <2 x i64>, ptr %b, align 4
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v16i8_v2i64(i8 %arg1, i64 %arg) {
; CHECK-LE-P8-LABEL: test_v16i8_v2i64:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P8-NEXT:    xxswapd v2, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v16i8_v2i64:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    mtfprd f1, r4
; CHECK-LE-P9-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P9-NEXT:    xxswapd v2, vs1
; CHECK-LE-P9-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v16i8_v2i64:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    sldi r3, r3, 56
; CHECK-BE-P8-NEXT:    mtfprd f1, r4
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v16i8_v2i64:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    sldi r3, r3, 56
; CHECK-BE-P9-NEXT:    mtfprd f1, r4
; CHECK-BE-P9-NEXT:    mtfprd f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v16i8_v2i64:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    sldi r3, r3, 56
; CHECK-AIX-64-P8-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v16i8_v2i64:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    sldi r3, r3, 56
; CHECK-AIX-64-P9-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P9-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v16i8_v2i64:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    lwz r3, L..C0(r2) # %const.0
; CHECK-AIX-32-P8-NEXT:    addi r6, r1, -16
; CHECK-AIX-32-P8-NEXT:    lxvw4x v2, 0, r6
; CHECK-AIX-32-P8-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    stw r5, -48(r1)
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x v3, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x v4, 0, r4
; CHECK-AIX-32-P8-NEXT:    lwz r3, L..C1(r2) # %const.1
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -48
; CHECK-AIX-32-P8-NEXT:    vperm v2, v2, v4, v3
; CHECK-AIX-32-P8-NEXT:    lxvw4x v3, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x v4, 0, r4
; CHECK-AIX-32-P8-NEXT:    vperm v2, v2, v4, v3
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v16i8_v2i64:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    mtfprwz f0, r4
; CHECK-AIX-32-P9-NEXT:    lxv v2, -16(r1)
; CHECK-AIX-32-P9-NEXT:    xxinsertw v2, vs0, 8
; CHECK-AIX-32-P9-NEXT:    mtfprwz f0, r5
; CHECK-AIX-32-P9-NEXT:    xxinsertw v2, vs0, 12
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <16 x i8> undef, i8 %arg1, i32 0
  %lhs = bitcast <16 x i8> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <2 x i64> undef, i64 %arg, i32 0
  %rhs = bitcast <2 x i64> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v2i64_v16i8(i8 %arg1, i64 %arg) {
; CHECK-LE-P8-LABEL: test_v2i64_v16i8:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P8-NEXT:    xxswapd v2, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v2i64_v16i8:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    mtfprd f1, r4
; CHECK-LE-P9-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P9-NEXT:    xxswapd v2, vs1
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v2i64_v16i8:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    mtfprd f0, r4
; CHECK-BE-P8-NEXT:    xxspltd v2, vs0, 0
; CHECK-BE-P8-NEXT:    mtfprwz f0, r3
; CHECK-BE-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v2i64_v16i8:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mtfprwz f0, r3
; CHECK-BE-P9-NEXT:    mtvsrdd v2, r4, r4
; CHECK-BE-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v2i64_v16i8:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs0
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v2i64_v16i8:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P9-NEXT:    mtvsrdd v2, r4, r4
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v2i64_v16i8:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r6, r1, -16
; CHECK-AIX-32-P8-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r6
; CHECK-AIX-32-P8-NEXT:    stw r5, -32(r1)
; CHECK-AIX-32-P8-NEXT:    stw r4, -48(r1)
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -48
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs2, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghw vs1, vs2, vs1
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v2i64_v16i8:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stw r5, -32(r1)
; CHECK-AIX-32-P9-NEXT:    stw r4, -48(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs2, -48(r1)
; CHECK-AIX-32-P9-NEXT:    stb r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghw vs1, vs2, vs1
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <16 x i8> undef, i8 %arg1, i32 0
  %lhs = bitcast <16 x i8> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <2 x i64> undef, i64 %arg, i32 0
  %rhs = bitcast <2 x i64> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %rhs, <2 x i64> %lhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_none_v2i64(ptr nocapture noundef readonly %b, i64 %arg) {
; CHECK-LE-P8-LABEL: test_none_v2i64:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    lxvd2x vs0, 0, r3
; CHECK-LE-P8-NEXT:    xxswapd v2, vs0
; CHECK-LE-P8-NEXT:    mtfprd f0, r4
; CHECK-LE-P8-NEXT:    xxpermdi v2, vs0, v2, 1
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_none_v2i64:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    lxv v2, 0(r3)
; CHECK-LE-P9-NEXT:    mtfprd f0, r4
; CHECK-LE-P9-NEXT:    xxpermdi v2, vs0, v2, 1
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_none_v2i64:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    lxvd2x v2, 0, r3
; CHECK-BE-P8-NEXT:    mtfprd f0, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_none_v2i64:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    lxv v2, 0(r3)
; CHECK-BE-P9-NEXT:    mtfprd f0, r4
; CHECK-BE-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_none_v2i64:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    lxvd2x v2, 0, r3
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_none_v2i64:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    lxv v2, 0(r3)
; CHECK-AIX-64-P9-NEXT:    mtfprd f0, r4
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_none_v2i64:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    lwz r6, L..C2(r2) # %const.0
; CHECK-AIX-32-P8-NEXT:    stw r4, -16(r1)
; CHECK-AIX-32-P8-NEXT:    stw r5, -32(r1)
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -16
; CHECK-AIX-32-P8-NEXT:    lxvw4x v3, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x v4, 0, r4
; CHECK-AIX-32-P8-NEXT:    lwz r3, L..C3(r2) # %const.1
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x v2, 0, r6
; CHECK-AIX-32-P8-NEXT:    vperm v2, v3, v4, v2
; CHECK-AIX-32-P8-NEXT:    lxvw4x v3, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x v4, 0, r4
; CHECK-AIX-32-P8-NEXT:    vperm v2, v2, v4, v3
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_none_v2i64:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    lxv v2, 0(r3)
; CHECK-AIX-32-P9-NEXT:    mtfprwz f0, r4
; CHECK-AIX-32-P9-NEXT:    xxinsertw v2, vs0, 8
; CHECK-AIX-32-P9-NEXT:    mtfprwz f0, r5
; CHECK-AIX-32-P9-NEXT:    xxinsertw v2, vs0, 12
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs = load <2 x i64>, ptr %b, align 4
  %rhs = insertelement <2 x i64> undef, i64 %arg, i32 0
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v2i64_none(ptr nocapture noundef readonly %b, i64 %arg) {
; CHECK-LE-P8-LABEL: test_v2i64_none:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    lxvd2x vs0, 0, r3
; CHECK-LE-P8-NEXT:    xxswapd v2, vs0
; CHECK-LE-P8-NEXT:    mtfprd f0, r4
; CHECK-LE-P8-NEXT:    xxpermdi v2, v2, vs0, 2
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v2i64_none:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    lxv v2, 0(r3)
; CHECK-LE-P9-NEXT:    mtfprd f0, r4
; CHECK-LE-P9-NEXT:    xxpermdi v2, v2, vs0, 2
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v2i64_none:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    mtfprd f0, r4
; CHECK-BE-P8-NEXT:    lxvd2x v2, 0, r3
; CHECK-BE-P8-NEXT:    xxspltd v3, vs0, 0
; CHECK-BE-P8-NEXT:    xxmrghd v2, v3, v2
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v2i64_none:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    lxv v2, 0(r3)
; CHECK-BE-P9-NEXT:    mtvsrdd v3, r4, r4
; CHECK-BE-P9-NEXT:    xxmrghd v2, v3, v2
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v2i64_none:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r4
; CHECK-AIX-64-P8-NEXT:    lxvd2x v2, 0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v3, vs0, vs0
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, v3, v2
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v2i64_none:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    lxv v2, 0(r3)
; CHECK-AIX-64-P9-NEXT:    mtvsrdd v3, r4, r4
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, v3, v2
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v2i64_none:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    lxvd2x v2, 0, r3
; CHECK-AIX-32-P8-NEXT:    stw r5, -16(r1)
; CHECK-AIX-32-P8-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -16
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghw vs0, vs1, vs0
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v2i64_none:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    lxv v2, 0(r3)
; CHECK-AIX-32-P9-NEXT:    stw r5, -16(r1)
; CHECK-AIX-32-P9-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghw vs0, vs1, vs0
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, v2
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs = load <2 x i64>, ptr %b, align 4
  %rhs = insertelement <2 x i64> undef, i64 %arg, i32 0
  %shuffle = shufflevector <2 x i64> %rhs, <2 x i64> %lhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v8i16_v8i16(i16 %arg1, i16 %arg) {
; CHECK-LE-P8-LABEL: test_v8i16_v8i16:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v8i16_v8i16:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    mtfprd f1, r4
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v8i16_v8i16:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    mtfprwz f0, r3
; CHECK-BE-P8-NEXT:    mtfprwz f1, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v8i16_v8i16:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mtfprwz f0, r3
; CHECK-BE-P9-NEXT:    mtfprwz f1, r4
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v8i16_v8i16:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P8-NEXT:    mtfprwz f1, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v8i16_v8i16:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P9-NEXT:    mtfprwz f1, r4
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v8i16_v8i16:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    sth r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    sth r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v8i16_v8i16:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    sth r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    sth r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <8 x i16> undef, i16 %arg1, i32 0
  %lhs = bitcast <8 x i16> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <8 x i16> undef, i16 %arg, i32 0
  %rhs = bitcast <8 x i16> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v8i16_v4i32(i16 %arg1, i32 %arg) {
; CHECK-LE-P8-LABEL: test_v8i16_v4i32:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P8-NEXT:    xxswapd vs1, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v8i16_v4i32:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    mtvsrws vs1, r4
; CHECK-LE-P9-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v8i16_v4i32:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    sldi r3, r3, 48
; CHECK-BE-P8-NEXT:    sldi r4, r4, 32
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    mtfprd f1, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v8i16_v4i32:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    sldi r3, r3, 48
; CHECK-BE-P9-NEXT:    mtvsrws vs1, r4
; CHECK-BE-P9-NEXT:    mtfprd f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v8i16_v4i32:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    sldi r3, r3, 48
; CHECK-AIX-64-P8-NEXT:    sldi r4, r4, 32
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v8i16_v4i32:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    sldi r3, r3, 48
; CHECK-AIX-64-P9-NEXT:    mtvsrws vs1, r4
; CHECK-AIX-64-P9-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v8i16_v4i32:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    sth r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v8i16_v4i32:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    sth r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <8 x i16> undef, i16 %arg1, i32 0
  %lhs = bitcast <8 x i16> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <4 x i32> undef, i32 %arg, i32 0
  %rhs = bitcast <4 x i32> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v8i16_v2i64(i16 %arg1, i64 %arg) {
; CHECK-LE-P8-LABEL: test_v8i16_v2i64:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P8-NEXT:    xxswapd v2, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v8i16_v2i64:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    mtfprd f1, r4
; CHECK-LE-P9-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P9-NEXT:    xxswapd v2, vs1
; CHECK-LE-P9-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v8i16_v2i64:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    sldi r3, r3, 48
; CHECK-BE-P8-NEXT:    mtfprd f1, r4
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v8i16_v2i64:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    sldi r3, r3, 48
; CHECK-BE-P9-NEXT:    mtfprd f1, r4
; CHECK-BE-P9-NEXT:    mtfprd f0, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v8i16_v2i64:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    sldi r3, r3, 48
; CHECK-AIX-64-P8-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v8i16_v2i64:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    sldi r3, r3, 48
; CHECK-AIX-64-P9-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P9-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v8i16_v2i64:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    sth r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    lwz r3, L..C4(r2) # %const.0
; CHECK-AIX-32-P8-NEXT:    addi r6, r1, -16
; CHECK-AIX-32-P8-NEXT:    lxvw4x v2, 0, r6
; CHECK-AIX-32-P8-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    stw r5, -48(r1)
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x v3, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x v4, 0, r4
; CHECK-AIX-32-P8-NEXT:    lwz r3, L..C5(r2) # %const.1
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -48
; CHECK-AIX-32-P8-NEXT:    vperm v2, v2, v4, v3
; CHECK-AIX-32-P8-NEXT:    lxvw4x v3, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x v4, 0, r4
; CHECK-AIX-32-P8-NEXT:    vperm v2, v2, v4, v3
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v8i16_v2i64:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    sth r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    mtfprwz f0, r4
; CHECK-AIX-32-P9-NEXT:    lxv v2, -16(r1)
; CHECK-AIX-32-P9-NEXT:    xxinsertw v2, vs0, 8
; CHECK-AIX-32-P9-NEXT:    mtfprwz f0, r5
; CHECK-AIX-32-P9-NEXT:    xxinsertw v2, vs0, 12
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <8 x i16> undef, i16 %arg1, i32 0
  %lhs = bitcast <8 x i16> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <2 x i64> undef, i64 %arg, i32 0
  %rhs = bitcast <2 x i64> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v4i32_v4i32(i32 %arg1, i32 %arg) {
; CHECK-LE-P8-LABEL: test_v4i32_v4i32:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprwz f0, r3
; CHECK-LE-P8-NEXT:    mtfprwz f1, r4
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v4i32_v4i32:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprwz f0, r3
; CHECK-LE-P9-NEXT:    mtfprwz f1, r4
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v4i32_v4i32:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    mtfprwz f0, r3
; CHECK-BE-P8-NEXT:    mtfprwz f1, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v4i32_v4i32:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mtfprwz f0, r3
; CHECK-BE-P9-NEXT:    mtfprwz f1, r4
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v4i32_v4i32:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P8-NEXT:    mtfprwz f1, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v4i32_v4i32:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r3
; CHECK-AIX-64-P9-NEXT:    mtfprwz f1, r4
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v4i32_v4i32:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stw r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v4i32_v4i32:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stw r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <4 x i32> undef, i32 %arg1, i32 0
  %lhs = bitcast <4 x i32> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <4 x i32> undef, i32 %arg, i32 0
  %rhs = bitcast <4 x i32> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v4i32_v8i16(i32 %arg1, i16 %arg) {
; CHECK-LE-P8-LABEL: test_v4i32_v8i16:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P8-NEXT:    xxswapd vs1, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v4i32_v8i16:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f1, r4
; CHECK-LE-P9-NEXT:    mtvsrws vs0, r3
; CHECK-LE-P9-NEXT:    xxswapd vs1, vs1
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs1, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v4i32_v8i16:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    sldi r3, r3, 32
; CHECK-BE-P8-NEXT:    sldi r4, r4, 48
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    mtfprd f1, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v4i32_v8i16:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mtvsrws vs0, r3
; CHECK-BE-P9-NEXT:    sldi r3, r4, 48
; CHECK-BE-P9-NEXT:    mtfprd f1, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v4i32_v8i16:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    sldi r3, r3, 32
; CHECK-AIX-64-P8-NEXT:    sldi r4, r4, 48
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v4i32_v8i16:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mtvsrws vs0, r3
; CHECK-AIX-64-P9-NEXT:    sldi r3, r4, 48
; CHECK-AIX-64-P9-NEXT:    mtfprd f1, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v4i32_v8i16:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    stw r3, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    sth r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v4i32_v8i16:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stw r3, -16(r1)
; CHECK-AIX-32-P9-NEXT:    sth r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <4 x i32> undef, i32 %arg1, i32 0
  %lhs = bitcast <4 x i32> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <8 x i16> undef, i16 %arg, i32 0
  %rhs = bitcast <8 x i16> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v4i32_v2i64(i32 %arg1, i64 %arg) {
; CHECK-LE-P8-LABEL: test_v4i32_v2i64:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P8-NEXT:    xxswapd v2, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v4i32_v2i64:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f1, r4
; CHECK-LE-P9-NEXT:    mtvsrws vs0, r3
; CHECK-LE-P9-NEXT:    xxswapd v2, vs1
; CHECK-LE-P9-NEXT:    xxmrgld v2, v2, vs0
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v4i32_v2i64:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    sldi r3, r3, 32
; CHECK-BE-P8-NEXT:    mtfprd f1, r4
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v4i32_v2i64:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mtvsrws vs0, r3
; CHECK-BE-P9-NEXT:    mtfprd f1, r4
; CHECK-BE-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v4i32_v2i64:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    sldi r3, r3, 32
; CHECK-AIX-64-P8-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v4i32_v2i64:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mtvsrws vs0, r3
; CHECK-AIX-64-P9-NEXT:    mtfprd f1, r4
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, vs0, vs1
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v4i32_v2i64:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P8-NEXT:    stw r3, -48(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -32
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -48
; CHECK-AIX-32-P8-NEXT:    stw r5, -16(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r3
; CHECK-AIX-32-P8-NEXT:    lwz r3, L..C6(r2) # %const.0
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r4
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -16
; CHECK-AIX-32-P8-NEXT:    lxvw4x v4, 0, r4
; CHECK-AIX-32-P8-NEXT:    lxvw4x v3, 0, r3
; CHECK-AIX-32-P8-NEXT:    xxmrghw v2, vs1, vs0
; CHECK-AIX-32-P8-NEXT:    vperm v2, v2, v4, v3
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v4i32_v2i64:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stw r4, -32(r1)
; CHECK-AIX-32-P9-NEXT:    stw r3, -48(r1)
; CHECK-AIX-32-P9-NEXT:    lwz r3, L..C0(r2) # %const.0
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -48(r1)
; CHECK-AIX-32-P9-NEXT:    stw r5, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv v2, -16(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghw v3, vs1, vs0
; CHECK-AIX-32-P9-NEXT:    lxv vs0, 0(r3)
; CHECK-AIX-32-P9-NEXT:    xxperm v2, v3, vs0
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <4 x i32> undef, i32 %arg1, i32 0
  %lhs = bitcast <4 x i32> %lhs.tmp to <2 x i64>
  %rhs = insertelement <2 x i64> undef, i64 %arg, i32 0
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v2i64_v2i64(ptr nocapture noundef readonly %a, ptr nocapture noundef readonly %b) {
; CHECK-LE-P8-LABEL: test_v2i64_v2i64:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    ld r3, 0(r3)
; CHECK-LE-P8-NEXT:    lfdx f0, 0, r4
; CHECK-LE-P8-NEXT:    mtfprd f1, r3
; CHECK-LE-P8-NEXT:    xxswapd v2, vs1
; CHECK-LE-P8-NEXT:    xxmrghd v3, vs0, vs1
; CHECK-LE-P8-NEXT:    vaddudm v2, v3, v2
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v2i64_v2i64:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    ld r3, 0(r3)
; CHECK-LE-P9-NEXT:    lfd f1, 0(r4)
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    xxswapd v2, vs0
; CHECK-LE-P9-NEXT:    xxmrghd v3, vs1, vs0
; CHECK-LE-P9-NEXT:    vaddudm v2, v3, v2
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v2i64_v2i64:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    lxsdx v2, 0, r3
; CHECK-BE-P8-NEXT:    lfdx f0, 0, r4
; CHECK-BE-P8-NEXT:    xxmrghd v3, v2, vs0
; CHECK-BE-P8-NEXT:    vaddudm v2, v3, v2
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v2i64_v2i64:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    lxsd v2, 0(r3)
; CHECK-BE-P9-NEXT:    lfd f0, 0(r4)
; CHECK-BE-P9-NEXT:    xxmrghd v3, v2, vs0
; CHECK-BE-P9-NEXT:    vaddudm v2, v3, v2
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v2i64_v2i64:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    lxsdx v2, 0, r3
; CHECK-AIX-64-P8-NEXT:    lfdx f0, 0, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v3, v2, vs0
; CHECK-AIX-64-P8-NEXT:    vaddudm v2, v3, v2
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v2i64_v2i64:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    lxsd v2, 0(r3)
; CHECK-AIX-64-P9-NEXT:    lfd f0, 0(r4)
; CHECK-AIX-64-P9-NEXT:    xxmrghd v3, v2, vs0
; CHECK-AIX-64-P9-NEXT:    vaddudm v2, v3, v2
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v2i64_v2i64:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    lwz r5, 4(r3)
; CHECK-AIX-32-P8-NEXT:    addi r6, r1, -32
; CHECK-AIX-32-P8-NEXT:    stw r5, -16(r1)
; CHECK-AIX-32-P8-NEXT:    addi r5, r1, -16
; CHECK-AIX-32-P8-NEXT:    lwz r3, 0(r3)
; CHECK-AIX-32-P8-NEXT:    stw r3, -32(r1)
; CHECK-AIX-32-P8-NEXT:    lwz r3, 4(r4)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r5
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r6
; CHECK-AIX-32-P8-NEXT:    stw r3, -48(r1)
; CHECK-AIX-32-P8-NEXT:    lwz r3, 0(r4)
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -64
; CHECK-AIX-32-P8-NEXT:    xxmrghw v2, vs1, vs0
; CHECK-AIX-32-P8-NEXT:    stw r3, -64(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -48
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs2, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs3, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghw vs0, vs3, vs2
; CHECK-AIX-32-P8-NEXT:    xxmrghd v3, v2, vs0
; CHECK-AIX-32-P8-NEXT:    vaddudm v2, v3, v2
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v2i64_v2i64:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    lwz r5, 4(r3)
; CHECK-AIX-32-P9-NEXT:    stw r5, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lwz r3, 0(r3)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -16(r1)
; CHECK-AIX-32-P9-NEXT:    stw r3, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lwz r3, 4(r4)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -32(r1)
; CHECK-AIX-32-P9-NEXT:    stw r3, -48(r1)
; CHECK-AIX-32-P9-NEXT:    lwz r3, 0(r4)
; CHECK-AIX-32-P9-NEXT:    xxmrghw v2, vs1, vs0
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -48(r1)
; CHECK-AIX-32-P9-NEXT:    stw r3, -64(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -64(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghw vs0, vs1, vs0
; CHECK-AIX-32-P9-NEXT:    xxmrghd v3, v2, vs0
; CHECK-AIX-32-P9-NEXT:    vaddudm v2, v3, v2
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %0 = load <8 x i8>, ptr %a, align 8
  %bc1 = bitcast <8 x i8> %0 to i64
  %vecinit3 = insertelement <2 x i64> poison, i64 %bc1, i64 0
  %1 = load <8 x i8>, ptr %b, align 8
  %bc2 = bitcast <8 x i8> %1 to i64
  %vecinit6 = insertelement <2 x i64> undef, i64 %bc2, i64 0
  %2 = bitcast <2 x i64> %vecinit3 to <2 x i64>
  %3 = bitcast <2 x i64> %vecinit6 to <2 x i64>
  %shuffle = shufflevector <2 x i64> %2, <2 x i64> %3, <2 x i32> <i32 0, i32 2>
  %4 = add <2 x i64> %shuffle, %2
  ret <2 x i64> %4
}

define <2 x i64> @test_v2i64_v4i32(i64 %arg1, i32 %arg) {
; CHECK-LE-P8-LABEL: test_v2i64_v4i32:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd v2, vs0
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v2i64_v4i32:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    xxswapd v2, vs0
; CHECK-LE-P9-NEXT:    mtvsrws vs0, r4
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v2i64_v4i32:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    xxspltd v2, vs0, 0
; CHECK-BE-P8-NEXT:    mtfprwz f0, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v2i64_v4i32:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mtfprwz f0, r4
; CHECK-BE-P9-NEXT:    mtvsrdd v2, r3, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v2i64_v4i32:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs0
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v2i64_v4i32:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r4
; CHECK-AIX-64-P9-NEXT:    mtvsrdd v2, r3, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v2i64_v4i32:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r6, r1, -48
; CHECK-AIX-32-P8-NEXT:    stw r5, -48(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r6
; CHECK-AIX-32-P8-NEXT:    stw r4, -16(r1)
; CHECK-AIX-32-P8-NEXT:    stw r3, -32(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -16
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs2, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghw vs1, vs2, vs1
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v2i64_v4i32:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stw r4, -16(r1)
; CHECK-AIX-32-P9-NEXT:    stw r3, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs2, -32(r1)
; CHECK-AIX-32-P9-NEXT:    stw r5, -48(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -48(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghw vs1, vs2, vs1
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <2 x i64> undef, i64 %arg1, i32 0
  %lhs = bitcast <2 x i64> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <4 x i32> undef, i32 %arg, i32 0
  %rhs = bitcast <4 x i32> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

define <2 x i64> @test_v2i64_v8i16(i64 %arg1, i16 %arg) {
; CHECK-LE-P8-LABEL: test_v2i64_v8i16:
; CHECK-LE-P8:       # %bb.0: # %entry
; CHECK-LE-P8-NEXT:    mtfprd f0, r3
; CHECK-LE-P8-NEXT:    mtfprd f1, r4
; CHECK-LE-P8-NEXT:    xxswapd v2, vs0
; CHECK-LE-P8-NEXT:    xxswapd vs0, vs1
; CHECK-LE-P8-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P8-NEXT:    blr
;
; CHECK-LE-P9-LABEL: test_v2i64_v8i16:
; CHECK-LE-P9:       # %bb.0: # %entry
; CHECK-LE-P9-NEXT:    mtfprd f0, r3
; CHECK-LE-P9-NEXT:    xxswapd v2, vs0
; CHECK-LE-P9-NEXT:    mtfprd f0, r4
; CHECK-LE-P9-NEXT:    xxswapd vs0, vs0
; CHECK-LE-P9-NEXT:    xxmrgld v2, vs0, v2
; CHECK-LE-P9-NEXT:    blr
;
; CHECK-BE-P8-LABEL: test_v2i64_v8i16:
; CHECK-BE-P8:       # %bb.0: # %entry
; CHECK-BE-P8-NEXT:    mtfprd f0, r3
; CHECK-BE-P8-NEXT:    xxspltd v2, vs0, 0
; CHECK-BE-P8-NEXT:    mtfprwz f0, r4
; CHECK-BE-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P8-NEXT:    blr
;
; CHECK-BE-P9-LABEL: test_v2i64_v8i16:
; CHECK-BE-P9:       # %bb.0: # %entry
; CHECK-BE-P9-NEXT:    mtfprwz f0, r4
; CHECK-BE-P9-NEXT:    mtvsrdd v2, r3, r3
; CHECK-BE-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-BE-P9-NEXT:    blr
;
; CHECK-AIX-64-P8-LABEL: test_v2i64_v8i16:
; CHECK-AIX-64-P8:       # %bb.0: # %entry
; CHECK-AIX-64-P8-NEXT:    mtfprd f0, r3
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, vs0, vs0
; CHECK-AIX-64-P8-NEXT:    mtfprwz f0, r4
; CHECK-AIX-64-P8-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P8-NEXT:    blr
;
; CHECK-AIX-64-P9-LABEL: test_v2i64_v8i16:
; CHECK-AIX-64-P9:       # %bb.0: # %entry
; CHECK-AIX-64-P9-NEXT:    mtfprwz f0, r4
; CHECK-AIX-64-P9-NEXT:    mtvsrdd v2, r3, r3
; CHECK-AIX-64-P9-NEXT:    xxmrghd v2, v2, vs0
; CHECK-AIX-64-P9-NEXT:    blr
;
; CHECK-AIX-32-P8-LABEL: test_v2i64_v8i16:
; CHECK-AIX-32-P8:       # %bb.0: # %entry
; CHECK-AIX-32-P8-NEXT:    addi r6, r1, -48
; CHECK-AIX-32-P8-NEXT:    sth r5, -48(r1)
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs0, 0, r6
; CHECK-AIX-32-P8-NEXT:    stw r4, -16(r1)
; CHECK-AIX-32-P8-NEXT:    stw r3, -32(r1)
; CHECK-AIX-32-P8-NEXT:    addi r3, r1, -16
; CHECK-AIX-32-P8-NEXT:    addi r4, r1, -32
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs1, 0, r3
; CHECK-AIX-32-P8-NEXT:    lxvw4x vs2, 0, r4
; CHECK-AIX-32-P8-NEXT:    xxmrghw vs1, vs2, vs1
; CHECK-AIX-32-P8-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-32-P8-NEXT:    blr
;
; CHECK-AIX-32-P9-LABEL: test_v2i64_v8i16:
; CHECK-AIX-32-P9:       # %bb.0: # %entry
; CHECK-AIX-32-P9-NEXT:    stw r4, -16(r1)
; CHECK-AIX-32-P9-NEXT:    stw r3, -32(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs1, -16(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs2, -32(r1)
; CHECK-AIX-32-P9-NEXT:    sth r5, -48(r1)
; CHECK-AIX-32-P9-NEXT:    lxv vs0, -48(r1)
; CHECK-AIX-32-P9-NEXT:    xxmrghw vs1, vs2, vs1
; CHECK-AIX-32-P9-NEXT:    xxmrghd v2, vs1, vs0
; CHECK-AIX-32-P9-NEXT:    blr
entry:
  %lhs.tmp = insertelement <2 x i64> undef, i64 %arg1, i32 0
  %lhs = bitcast <2 x i64> %lhs.tmp to <2 x i64>
  %rhs.tmp = insertelement <8 x i16> undef, i16 %arg, i32 0
  %rhs = bitcast <8 x i16> %rhs.tmp to <2 x i64>
  %shuffle = shufflevector <2 x i64> %lhs, <2 x i64> %rhs, <2 x i32> <i32 0, i32 2>
  ret <2 x i64> %shuffle
}

