// RUN: llvm-mc -arch=amdgcn -mcpu=bonaire -show-encoding %s | FileCheck %s

s_mov_b32 s5, s1
// CHECK: [0x01,0x03,0x85,0xbe]

s_mov_b32 s103, s1
// CHECK: [0x01,0x03,0xe7,0xbe]

s_mov_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x03,0xe8,0xbe]

s_mov_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x03,0xe9,0xbe]

s_mov_b32 vcc_lo, s1
// CHECK: [0x01,0x03,0xea,0xbe]

s_mov_b32 vcc_hi, s1
// CHECK: [0x01,0x03,0xeb,0xbe]

s_mov_b32 tba_lo, s1
// CHECK: [0x01,0x03,0xec,0xbe]

s_mov_b32 tba_hi, s1
// CHECK: [0x01,0x03,0xed,0xbe]

s_mov_b32 tma_lo, s1
// CHECK: [0x01,0x03,0xee,0xbe]

s_mov_b32 tma_hi, s1
// CHECK: [0x01,0x03,0xef,0xbe]

s_mov_b32 ttmp11, s1
// CHECK: [0x01,0x03,0xfb,0xbe]

s_mov_b32 m0, s1
// CHECK: [0x01,0x03,0xfc,0xbe]

s_mov_b32 exec_lo, s1
// CHECK: [0x01,0x03,0xfe,0xbe]

s_mov_b32 exec_hi, s1
// CHECK: [0x01,0x03,0xff,0xbe]

s_mov_b32 s5, s103
// CHECK: [0x67,0x03,0x85,0xbe]

s_mov_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x03,0x85,0xbe]

s_mov_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x03,0x85,0xbe]

s_mov_b32 s5, vcc_lo
// CHECK: [0x6a,0x03,0x85,0xbe]

s_mov_b32 s5, vcc_hi
// CHECK: [0x6b,0x03,0x85,0xbe]

s_mov_b32 s5, tba_lo
// CHECK: [0x6c,0x03,0x85,0xbe]

s_mov_b32 s5, tba_hi
// CHECK: [0x6d,0x03,0x85,0xbe]

s_mov_b32 s5, tma_lo
// CHECK: [0x6e,0x03,0x85,0xbe]

s_mov_b32 s5, tma_hi
// CHECK: [0x6f,0x03,0x85,0xbe]

s_mov_b32 s5, ttmp11
// CHECK: [0x7b,0x03,0x85,0xbe]

s_mov_b32 s5, m0
// CHECK: [0x7c,0x03,0x85,0xbe]

s_mov_b32 s5, exec_lo
// CHECK: [0x7e,0x03,0x85,0xbe]

s_mov_b32 s5, exec_hi
// CHECK: [0x7f,0x03,0x85,0xbe]

s_mov_b32 s5, 0
// CHECK: [0x80,0x03,0x85,0xbe]

s_mov_b32 s5, -1
// CHECK: [0xc1,0x03,0x85,0xbe]

s_mov_b32 s5, 0.5
// CHECK: [0xf0,0x03,0x85,0xbe]

s_mov_b32 s5, -4.0
// CHECK: [0xf7,0x03,0x85,0xbe]

s_mov_b32 s5, src_vccz
// CHECK: [0xfb,0x03,0x85,0xbe]

s_mov_b32 s5, src_execz
// CHECK: [0xfc,0x03,0x85,0xbe]

s_mov_b32 s5, src_scc
// CHECK: [0xfd,0x03,0x85,0xbe]

s_mov_b32 s5, 0xaf123456
// CHECK: [0xff,0x03,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_mov_b32 s5, 0x3f717273
// CHECK: [0xff,0x03,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_mov_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x04,0x8a,0xbe]

s_mov_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x04,0x8c,0xbe]

s_mov_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x04,0xe6,0xbe]

s_mov_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x04,0xe8,0xbe]

s_mov_b64 vcc, s[2:3]
// CHECK: [0x02,0x04,0xea,0xbe]

s_mov_b64 tba, s[2:3]
// CHECK: [0x02,0x04,0xec,0xbe]

s_mov_b64 tma, s[2:3]
// CHECK: [0x02,0x04,0xee,0xbe]

s_mov_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x04,0xfa,0xbe]

s_mov_b64 exec, s[2:3]
// CHECK: [0x02,0x04,0xfe,0xbe]

s_mov_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], vcc
// CHECK: [0x6a,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], tba
// CHECK: [0x6c,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], tma
// CHECK: [0x6e,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], exec
// CHECK: [0x7e,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], 0
// CHECK: [0x80,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], -1
// CHECK: [0xc1,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], 0.5
// CHECK: [0xf0,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], -4.0
// CHECK: [0xf7,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], src_execz
// CHECK: [0xfc,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], src_scc
// CHECK: [0xfd,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x04,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_mov_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x04,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b32 s5, s1
// CHECK: [0x01,0x05,0x85,0xbe]

s_cmov_b32 s103, s1
// CHECK: [0x01,0x05,0xe7,0xbe]

s_cmov_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x05,0xe8,0xbe]

s_cmov_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x05,0xe9,0xbe]

s_cmov_b32 vcc_lo, s1
// CHECK: [0x01,0x05,0xea,0xbe]

s_cmov_b32 vcc_hi, s1
// CHECK: [0x01,0x05,0xeb,0xbe]

s_cmov_b32 tba_lo, s1
// CHECK: [0x01,0x05,0xec,0xbe]

s_cmov_b32 tba_hi, s1
// CHECK: [0x01,0x05,0xed,0xbe]

s_cmov_b32 tma_lo, s1
// CHECK: [0x01,0x05,0xee,0xbe]

s_cmov_b32 tma_hi, s1
// CHECK: [0x01,0x05,0xef,0xbe]

s_cmov_b32 ttmp11, s1
// CHECK: [0x01,0x05,0xfb,0xbe]

s_cmov_b32 m0, s1
// CHECK: [0x01,0x05,0xfc,0xbe]

s_cmov_b32 exec_lo, s1
// CHECK: [0x01,0x05,0xfe,0xbe]

s_cmov_b32 exec_hi, s1
// CHECK: [0x01,0x05,0xff,0xbe]

s_cmov_b32 s5, s103
// CHECK: [0x67,0x05,0x85,0xbe]

s_cmov_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x05,0x85,0xbe]

s_cmov_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x05,0x85,0xbe]

s_cmov_b32 s5, vcc_lo
// CHECK: [0x6a,0x05,0x85,0xbe]

s_cmov_b32 s5, vcc_hi
// CHECK: [0x6b,0x05,0x85,0xbe]

s_cmov_b32 s5, tba_lo
// CHECK: [0x6c,0x05,0x85,0xbe]

s_cmov_b32 s5, tba_hi
// CHECK: [0x6d,0x05,0x85,0xbe]

s_cmov_b32 s5, tma_lo
// CHECK: [0x6e,0x05,0x85,0xbe]

s_cmov_b32 s5, tma_hi
// CHECK: [0x6f,0x05,0x85,0xbe]

s_cmov_b32 s5, ttmp11
// CHECK: [0x7b,0x05,0x85,0xbe]

s_cmov_b32 s5, m0
// CHECK: [0x7c,0x05,0x85,0xbe]

s_cmov_b32 s5, exec_lo
// CHECK: [0x7e,0x05,0x85,0xbe]

s_cmov_b32 s5, exec_hi
// CHECK: [0x7f,0x05,0x85,0xbe]

s_cmov_b32 s5, 0
// CHECK: [0x80,0x05,0x85,0xbe]

s_cmov_b32 s5, -1
// CHECK: [0xc1,0x05,0x85,0xbe]

s_cmov_b32 s5, 0.5
// CHECK: [0xf0,0x05,0x85,0xbe]

s_cmov_b32 s5, -4.0
// CHECK: [0xf7,0x05,0x85,0xbe]

s_cmov_b32 s5, src_vccz
// CHECK: [0xfb,0x05,0x85,0xbe]

s_cmov_b32 s5, src_execz
// CHECK: [0xfc,0x05,0x85,0xbe]

s_cmov_b32 s5, src_scc
// CHECK: [0xfd,0x05,0x85,0xbe]

s_cmov_b32 s5, 0xaf123456
// CHECK: [0xff,0x05,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b32 s5, 0x3f717273
// CHECK: [0xff,0x05,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x06,0x8a,0xbe]

s_cmov_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x06,0x8c,0xbe]

s_cmov_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x06,0xe6,0xbe]

s_cmov_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x06,0xe8,0xbe]

s_cmov_b64 vcc, s[2:3]
// CHECK: [0x02,0x06,0xea,0xbe]

s_cmov_b64 tba, s[2:3]
// CHECK: [0x02,0x06,0xec,0xbe]

s_cmov_b64 tma, s[2:3]
// CHECK: [0x02,0x06,0xee,0xbe]

s_cmov_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x06,0xfa,0xbe]

s_cmov_b64 exec, s[2:3]
// CHECK: [0x02,0x06,0xfe,0xbe]

s_cmov_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], vcc
// CHECK: [0x6a,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], tba
// CHECK: [0x6c,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], tma
// CHECK: [0x6e,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], exec
// CHECK: [0x7e,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], 0
// CHECK: [0x80,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], -1
// CHECK: [0xc1,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], 0.5
// CHECK: [0xf0,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], -4.0
// CHECK: [0xf7,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], src_execz
// CHECK: [0xfc,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], src_scc
// CHECK: [0xfd,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x06,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x06,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_not_b32 s5, s1
// CHECK: [0x01,0x07,0x85,0xbe]

s_not_b32 s103, s1
// CHECK: [0x01,0x07,0xe7,0xbe]

s_not_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x07,0xe8,0xbe]

s_not_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x07,0xe9,0xbe]

s_not_b32 vcc_lo, s1
// CHECK: [0x01,0x07,0xea,0xbe]

s_not_b32 vcc_hi, s1
// CHECK: [0x01,0x07,0xeb,0xbe]

s_not_b32 tba_lo, s1
// CHECK: [0x01,0x07,0xec,0xbe]

s_not_b32 tba_hi, s1
// CHECK: [0x01,0x07,0xed,0xbe]

s_not_b32 tma_lo, s1
// CHECK: [0x01,0x07,0xee,0xbe]

s_not_b32 tma_hi, s1
// CHECK: [0x01,0x07,0xef,0xbe]

s_not_b32 ttmp11, s1
// CHECK: [0x01,0x07,0xfb,0xbe]

s_not_b32 m0, s1
// CHECK: [0x01,0x07,0xfc,0xbe]

s_not_b32 exec_lo, s1
// CHECK: [0x01,0x07,0xfe,0xbe]

s_not_b32 exec_hi, s1
// CHECK: [0x01,0x07,0xff,0xbe]

s_not_b32 s5, s103
// CHECK: [0x67,0x07,0x85,0xbe]

s_not_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x07,0x85,0xbe]

s_not_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x07,0x85,0xbe]

s_not_b32 s5, vcc_lo
// CHECK: [0x6a,0x07,0x85,0xbe]

s_not_b32 s5, vcc_hi
// CHECK: [0x6b,0x07,0x85,0xbe]

s_not_b32 s5, tba_lo
// CHECK: [0x6c,0x07,0x85,0xbe]

s_not_b32 s5, tba_hi
// CHECK: [0x6d,0x07,0x85,0xbe]

s_not_b32 s5, tma_lo
// CHECK: [0x6e,0x07,0x85,0xbe]

s_not_b32 s5, tma_hi
// CHECK: [0x6f,0x07,0x85,0xbe]

s_not_b32 s5, ttmp11
// CHECK: [0x7b,0x07,0x85,0xbe]

s_not_b32 s5, m0
// CHECK: [0x7c,0x07,0x85,0xbe]

s_not_b32 s5, exec_lo
// CHECK: [0x7e,0x07,0x85,0xbe]

s_not_b32 s5, exec_hi
// CHECK: [0x7f,0x07,0x85,0xbe]

s_not_b32 s5, 0
// CHECK: [0x80,0x07,0x85,0xbe]

s_not_b32 s5, -1
// CHECK: [0xc1,0x07,0x85,0xbe]

s_not_b32 s5, 0.5
// CHECK: [0xf0,0x07,0x85,0xbe]

s_not_b32 s5, -4.0
// CHECK: [0xf7,0x07,0x85,0xbe]

s_not_b32 s5, src_vccz
// CHECK: [0xfb,0x07,0x85,0xbe]

s_not_b32 s5, src_execz
// CHECK: [0xfc,0x07,0x85,0xbe]

s_not_b32 s5, src_scc
// CHECK: [0xfd,0x07,0x85,0xbe]

s_not_b32 s5, 0xaf123456
// CHECK: [0xff,0x07,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_not_b32 s5, 0x3f717273
// CHECK: [0xff,0x07,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_not_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x08,0x8a,0xbe]

s_not_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x08,0x8c,0xbe]

s_not_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x08,0xe6,0xbe]

s_not_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x08,0xe8,0xbe]

s_not_b64 vcc, s[2:3]
// CHECK: [0x02,0x08,0xea,0xbe]

s_not_b64 tba, s[2:3]
// CHECK: [0x02,0x08,0xec,0xbe]

s_not_b64 tma, s[2:3]
// CHECK: [0x02,0x08,0xee,0xbe]

s_not_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x08,0xfa,0xbe]

s_not_b64 exec, s[2:3]
// CHECK: [0x02,0x08,0xfe,0xbe]

s_not_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x08,0x8a,0xbe]

s_not_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x08,0x8a,0xbe]

s_not_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x08,0x8a,0xbe]

s_not_b64 s[10:11], vcc
// CHECK: [0x6a,0x08,0x8a,0xbe]

s_not_b64 s[10:11], tba
// CHECK: [0x6c,0x08,0x8a,0xbe]

s_not_b64 s[10:11], tma
// CHECK: [0x6e,0x08,0x8a,0xbe]

s_not_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x08,0x8a,0xbe]

s_not_b64 s[10:11], exec
// CHECK: [0x7e,0x08,0x8a,0xbe]

s_not_b64 s[10:11], 0
// CHECK: [0x80,0x08,0x8a,0xbe]

s_not_b64 s[10:11], -1
// CHECK: [0xc1,0x08,0x8a,0xbe]

s_not_b64 s[10:11], 0.5
// CHECK: [0xf0,0x08,0x8a,0xbe]

s_not_b64 s[10:11], -4.0
// CHECK: [0xf7,0x08,0x8a,0xbe]

s_not_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x08,0x8a,0xbe]

s_not_b64 s[10:11], src_execz
// CHECK: [0xfc,0x08,0x8a,0xbe]

s_not_b64 s[10:11], src_scc
// CHECK: [0xfd,0x08,0x8a,0xbe]

s_not_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x08,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_not_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x08,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b32 s5, s1
// CHECK: [0x01,0x09,0x85,0xbe]

s_wqm_b32 s103, s1
// CHECK: [0x01,0x09,0xe7,0xbe]

s_wqm_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x09,0xe8,0xbe]

s_wqm_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x09,0xe9,0xbe]

s_wqm_b32 vcc_lo, s1
// CHECK: [0x01,0x09,0xea,0xbe]

s_wqm_b32 vcc_hi, s1
// CHECK: [0x01,0x09,0xeb,0xbe]

s_wqm_b32 tba_lo, s1
// CHECK: [0x01,0x09,0xec,0xbe]

s_wqm_b32 tba_hi, s1
// CHECK: [0x01,0x09,0xed,0xbe]

s_wqm_b32 tma_lo, s1
// CHECK: [0x01,0x09,0xee,0xbe]

s_wqm_b32 tma_hi, s1
// CHECK: [0x01,0x09,0xef,0xbe]

s_wqm_b32 ttmp11, s1
// CHECK: [0x01,0x09,0xfb,0xbe]

s_wqm_b32 m0, s1
// CHECK: [0x01,0x09,0xfc,0xbe]

s_wqm_b32 exec_lo, s1
// CHECK: [0x01,0x09,0xfe,0xbe]

s_wqm_b32 exec_hi, s1
// CHECK: [0x01,0x09,0xff,0xbe]

s_wqm_b32 s5, s103
// CHECK: [0x67,0x09,0x85,0xbe]

s_wqm_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x09,0x85,0xbe]

s_wqm_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x09,0x85,0xbe]

s_wqm_b32 s5, vcc_lo
// CHECK: [0x6a,0x09,0x85,0xbe]

s_wqm_b32 s5, vcc_hi
// CHECK: [0x6b,0x09,0x85,0xbe]

s_wqm_b32 s5, tba_lo
// CHECK: [0x6c,0x09,0x85,0xbe]

s_wqm_b32 s5, tba_hi
// CHECK: [0x6d,0x09,0x85,0xbe]

s_wqm_b32 s5, tma_lo
// CHECK: [0x6e,0x09,0x85,0xbe]

s_wqm_b32 s5, tma_hi
// CHECK: [0x6f,0x09,0x85,0xbe]

s_wqm_b32 s5, ttmp11
// CHECK: [0x7b,0x09,0x85,0xbe]

s_wqm_b32 s5, m0
// CHECK: [0x7c,0x09,0x85,0xbe]

s_wqm_b32 s5, exec_lo
// CHECK: [0x7e,0x09,0x85,0xbe]

s_wqm_b32 s5, exec_hi
// CHECK: [0x7f,0x09,0x85,0xbe]

s_wqm_b32 s5, 0
// CHECK: [0x80,0x09,0x85,0xbe]

s_wqm_b32 s5, -1
// CHECK: [0xc1,0x09,0x85,0xbe]

s_wqm_b32 s5, 0.5
// CHECK: [0xf0,0x09,0x85,0xbe]

s_wqm_b32 s5, -4.0
// CHECK: [0xf7,0x09,0x85,0xbe]

s_wqm_b32 s5, src_vccz
// CHECK: [0xfb,0x09,0x85,0xbe]

s_wqm_b32 s5, src_execz
// CHECK: [0xfc,0x09,0x85,0xbe]

s_wqm_b32 s5, src_scc
// CHECK: [0xfd,0x09,0x85,0xbe]

s_wqm_b32 s5, 0xaf123456
// CHECK: [0xff,0x09,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b32 s5, 0x3f717273
// CHECK: [0xff,0x09,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x0a,0x8a,0xbe]

s_wqm_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x0a,0x8c,0xbe]

s_wqm_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x0a,0xe6,0xbe]

s_wqm_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x0a,0xe8,0xbe]

s_wqm_b64 vcc, s[2:3]
// CHECK: [0x02,0x0a,0xea,0xbe]

s_wqm_b64 tba, s[2:3]
// CHECK: [0x02,0x0a,0xec,0xbe]

s_wqm_b64 tma, s[2:3]
// CHECK: [0x02,0x0a,0xee,0xbe]

s_wqm_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x0a,0xfa,0xbe]

s_wqm_b64 exec, s[2:3]
// CHECK: [0x02,0x0a,0xfe,0xbe]

s_wqm_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], vcc
// CHECK: [0x6a,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], tba
// CHECK: [0x6c,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], tma
// CHECK: [0x6e,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], exec
// CHECK: [0x7e,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], 0
// CHECK: [0x80,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], -1
// CHECK: [0xc1,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], 0.5
// CHECK: [0xf0,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], -4.0
// CHECK: [0xf7,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], src_execz
// CHECK: [0xfc,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], src_scc
// CHECK: [0xfd,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x0a,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x0a,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b32 s5, s1
// CHECK: [0x01,0x0b,0x85,0xbe]

s_brev_b32 s103, s1
// CHECK: [0x01,0x0b,0xe7,0xbe]

s_brev_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x0b,0xe8,0xbe]

s_brev_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x0b,0xe9,0xbe]

s_brev_b32 vcc_lo, s1
// CHECK: [0x01,0x0b,0xea,0xbe]

s_brev_b32 vcc_hi, s1
// CHECK: [0x01,0x0b,0xeb,0xbe]

s_brev_b32 tba_lo, s1
// CHECK: [0x01,0x0b,0xec,0xbe]

s_brev_b32 tba_hi, s1
// CHECK: [0x01,0x0b,0xed,0xbe]

s_brev_b32 tma_lo, s1
// CHECK: [0x01,0x0b,0xee,0xbe]

s_brev_b32 tma_hi, s1
// CHECK: [0x01,0x0b,0xef,0xbe]

s_brev_b32 ttmp11, s1
// CHECK: [0x01,0x0b,0xfb,0xbe]

s_brev_b32 m0, s1
// CHECK: [0x01,0x0b,0xfc,0xbe]

s_brev_b32 exec_lo, s1
// CHECK: [0x01,0x0b,0xfe,0xbe]

s_brev_b32 exec_hi, s1
// CHECK: [0x01,0x0b,0xff,0xbe]

s_brev_b32 s5, s103
// CHECK: [0x67,0x0b,0x85,0xbe]

s_brev_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x0b,0x85,0xbe]

s_brev_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x0b,0x85,0xbe]

s_brev_b32 s5, vcc_lo
// CHECK: [0x6a,0x0b,0x85,0xbe]

s_brev_b32 s5, vcc_hi
// CHECK: [0x6b,0x0b,0x85,0xbe]

s_brev_b32 s5, tba_lo
// CHECK: [0x6c,0x0b,0x85,0xbe]

s_brev_b32 s5, tba_hi
// CHECK: [0x6d,0x0b,0x85,0xbe]

s_brev_b32 s5, tma_lo
// CHECK: [0x6e,0x0b,0x85,0xbe]

s_brev_b32 s5, tma_hi
// CHECK: [0x6f,0x0b,0x85,0xbe]

s_brev_b32 s5, ttmp11
// CHECK: [0x7b,0x0b,0x85,0xbe]

s_brev_b32 s5, m0
// CHECK: [0x7c,0x0b,0x85,0xbe]

s_brev_b32 s5, exec_lo
// CHECK: [0x7e,0x0b,0x85,0xbe]

s_brev_b32 s5, exec_hi
// CHECK: [0x7f,0x0b,0x85,0xbe]

s_brev_b32 s5, 0
// CHECK: [0x80,0x0b,0x85,0xbe]

s_brev_b32 s5, -1
// CHECK: [0xc1,0x0b,0x85,0xbe]

s_brev_b32 s5, 0.5
// CHECK: [0xf0,0x0b,0x85,0xbe]

s_brev_b32 s5, -4.0
// CHECK: [0xf7,0x0b,0x85,0xbe]

s_brev_b32 s5, src_vccz
// CHECK: [0xfb,0x0b,0x85,0xbe]

s_brev_b32 s5, src_execz
// CHECK: [0xfc,0x0b,0x85,0xbe]

s_brev_b32 s5, src_scc
// CHECK: [0xfd,0x0b,0x85,0xbe]

s_brev_b32 s5, 0xaf123456
// CHECK: [0xff,0x0b,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b32 s5, 0x3f717273
// CHECK: [0xff,0x0b,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x0c,0x8a,0xbe]

s_brev_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x0c,0x8c,0xbe]

s_brev_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x0c,0xe6,0xbe]

s_brev_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x0c,0xe8,0xbe]

s_brev_b64 vcc, s[2:3]
// CHECK: [0x02,0x0c,0xea,0xbe]

s_brev_b64 tba, s[2:3]
// CHECK: [0x02,0x0c,0xec,0xbe]

s_brev_b64 tma, s[2:3]
// CHECK: [0x02,0x0c,0xee,0xbe]

s_brev_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x0c,0xfa,0xbe]

s_brev_b64 exec, s[2:3]
// CHECK: [0x02,0x0c,0xfe,0xbe]

s_brev_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], vcc
// CHECK: [0x6a,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], tba
// CHECK: [0x6c,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], tma
// CHECK: [0x6e,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], exec
// CHECK: [0x7e,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], 0
// CHECK: [0x80,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], -1
// CHECK: [0xc1,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], 0.5
// CHECK: [0xf0,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], -4.0
// CHECK: [0xf7,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], src_execz
// CHECK: [0xfc,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], src_scc
// CHECK: [0xfd,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x0c,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x0c,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b32 s5, s1
// CHECK: [0x01,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s103, s1
// CHECK: [0x01,0x0d,0xe7,0xbe]

s_bcnt0_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x0d,0xe8,0xbe]

s_bcnt0_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x0d,0xe9,0xbe]

s_bcnt0_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x0d,0xea,0xbe]

s_bcnt0_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x0d,0xeb,0xbe]

s_bcnt0_i32_b32 tba_lo, s1
// CHECK: [0x01,0x0d,0xec,0xbe]

s_bcnt0_i32_b32 tba_hi, s1
// CHECK: [0x01,0x0d,0xed,0xbe]

s_bcnt0_i32_b32 tma_lo, s1
// CHECK: [0x01,0x0d,0xee,0xbe]

s_bcnt0_i32_b32 tma_hi, s1
// CHECK: [0x01,0x0d,0xef,0xbe]

s_bcnt0_i32_b32 ttmp11, s1
// CHECK: [0x01,0x0d,0xfb,0xbe]

s_bcnt0_i32_b32 m0, s1
// CHECK: [0x01,0x0d,0xfc,0xbe]

s_bcnt0_i32_b32 exec_lo, s1
// CHECK: [0x01,0x0d,0xfe,0xbe]

s_bcnt0_i32_b32 exec_hi, s1
// CHECK: [0x01,0x0d,0xff,0xbe]

s_bcnt0_i32_b32 s5, s103
// CHECK: [0x67,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, tba_lo
// CHECK: [0x6c,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, tba_hi
// CHECK: [0x6d,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, tma_lo
// CHECK: [0x6e,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, tma_hi
// CHECK: [0x6f,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, ttmp11
// CHECK: [0x7b,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, m0
// CHECK: [0x7c,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, 0
// CHECK: [0x80,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, -1
// CHECK: [0xc1,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, 0.5
// CHECK: [0xf0,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, -4.0
// CHECK: [0xf7,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, src_vccz
// CHECK: [0xfb,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, src_execz
// CHECK: [0xfc,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, src_scc
// CHECK: [0xfd,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x0d,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x0d,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s103, s[2:3]
// CHECK: [0x02,0x0e,0xe7,0xbe]

s_bcnt0_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x0e,0xe8,0xbe]

s_bcnt0_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x0e,0xe9,0xbe]

s_bcnt0_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x0e,0xea,0xbe]

s_bcnt0_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x0e,0xeb,0xbe]

s_bcnt0_i32_b64 tba_lo, s[2:3]
// CHECK: [0x02,0x0e,0xec,0xbe]

s_bcnt0_i32_b64 tba_hi, s[2:3]
// CHECK: [0x02,0x0e,0xed,0xbe]

s_bcnt0_i32_b64 tma_lo, s[2:3]
// CHECK: [0x02,0x0e,0xee,0xbe]

s_bcnt0_i32_b64 tma_hi, s[2:3]
// CHECK: [0x02,0x0e,0xef,0xbe]

s_bcnt0_i32_b64 ttmp11, s[2:3]
// CHECK: [0x02,0x0e,0xfb,0xbe]

s_bcnt0_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x0e,0xfc,0xbe]

s_bcnt0_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x0e,0xfe,0xbe]

s_bcnt0_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x0e,0xff,0xbe]

s_bcnt0_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, s[102:103]
// CHECK: [0x66,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, flat_scratch
// CHECK: [0x68,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, vcc
// CHECK: [0x6a,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, tba
// CHECK: [0x6c,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, tma
// CHECK: [0x6e,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, ttmp[10:11]
// CHECK: [0x7a,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, exec
// CHECK: [0x7e,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, 0
// CHECK: [0x80,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, -1
// CHECK: [0xc1,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, 0.5
// CHECK: [0xf0,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, -4.0
// CHECK: [0xf7,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, src_vccz
// CHECK: [0xfb,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, src_execz
// CHECK: [0xfc,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, src_scc
// CHECK: [0xfd,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x0e,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x0e,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b32 s5, s1
// CHECK: [0x01,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s103, s1
// CHECK: [0x01,0x0f,0xe7,0xbe]

s_bcnt1_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x0f,0xe8,0xbe]

s_bcnt1_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x0f,0xe9,0xbe]

s_bcnt1_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x0f,0xea,0xbe]

s_bcnt1_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x0f,0xeb,0xbe]

s_bcnt1_i32_b32 tba_lo, s1
// CHECK: [0x01,0x0f,0xec,0xbe]

s_bcnt1_i32_b32 tba_hi, s1
// CHECK: [0x01,0x0f,0xed,0xbe]

s_bcnt1_i32_b32 tma_lo, s1
// CHECK: [0x01,0x0f,0xee,0xbe]

s_bcnt1_i32_b32 tma_hi, s1
// CHECK: [0x01,0x0f,0xef,0xbe]

s_bcnt1_i32_b32 ttmp11, s1
// CHECK: [0x01,0x0f,0xfb,0xbe]

s_bcnt1_i32_b32 m0, s1
// CHECK: [0x01,0x0f,0xfc,0xbe]

s_bcnt1_i32_b32 exec_lo, s1
// CHECK: [0x01,0x0f,0xfe,0xbe]

s_bcnt1_i32_b32 exec_hi, s1
// CHECK: [0x01,0x0f,0xff,0xbe]

s_bcnt1_i32_b32 s5, s103
// CHECK: [0x67,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, tba_lo
// CHECK: [0x6c,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, tba_hi
// CHECK: [0x6d,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, tma_lo
// CHECK: [0x6e,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, tma_hi
// CHECK: [0x6f,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, ttmp11
// CHECK: [0x7b,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, m0
// CHECK: [0x7c,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, 0
// CHECK: [0x80,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, -1
// CHECK: [0xc1,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, 0.5
// CHECK: [0xf0,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, -4.0
// CHECK: [0xf7,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, src_vccz
// CHECK: [0xfb,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, src_execz
// CHECK: [0xfc,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, src_scc
// CHECK: [0xfd,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x0f,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x0f,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s103, s[2:3]
// CHECK: [0x02,0x10,0xe7,0xbe]

s_bcnt1_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x10,0xe8,0xbe]

s_bcnt1_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x10,0xe9,0xbe]

s_bcnt1_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x10,0xea,0xbe]

s_bcnt1_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x10,0xeb,0xbe]

s_bcnt1_i32_b64 tba_lo, s[2:3]
// CHECK: [0x02,0x10,0xec,0xbe]

s_bcnt1_i32_b64 tba_hi, s[2:3]
// CHECK: [0x02,0x10,0xed,0xbe]

s_bcnt1_i32_b64 tma_lo, s[2:3]
// CHECK: [0x02,0x10,0xee,0xbe]

s_bcnt1_i32_b64 tma_hi, s[2:3]
// CHECK: [0x02,0x10,0xef,0xbe]

s_bcnt1_i32_b64 ttmp11, s[2:3]
// CHECK: [0x02,0x10,0xfb,0xbe]

s_bcnt1_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x10,0xfc,0xbe]

s_bcnt1_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x10,0xfe,0xbe]

s_bcnt1_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x10,0xff,0xbe]

s_bcnt1_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, s[102:103]
// CHECK: [0x66,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, flat_scratch
// CHECK: [0x68,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, vcc
// CHECK: [0x6a,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, tba
// CHECK: [0x6c,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, tma
// CHECK: [0x6e,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, ttmp[10:11]
// CHECK: [0x7a,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, exec
// CHECK: [0x7e,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, 0
// CHECK: [0x80,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, -1
// CHECK: [0xc1,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, 0.5
// CHECK: [0xf0,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, -4.0
// CHECK: [0xf7,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, src_vccz
// CHECK: [0xfb,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, src_execz
// CHECK: [0xfc,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, src_scc
// CHECK: [0xfd,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x10,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x10,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff0_i32_b32 s5, s1
// CHECK: [0x01,0x11,0x85,0xbe]

s_ff0_i32_b32 s103, s1
// CHECK: [0x01,0x11,0xe7,0xbe]

s_ff0_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x11,0xe8,0xbe]

s_ff0_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x11,0xe9,0xbe]

s_ff0_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x11,0xea,0xbe]

s_ff0_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x11,0xeb,0xbe]

s_ff0_i32_b32 tba_lo, s1
// CHECK: [0x01,0x11,0xec,0xbe]

s_ff0_i32_b32 tba_hi, s1
// CHECK: [0x01,0x11,0xed,0xbe]

s_ff0_i32_b32 tma_lo, s1
// CHECK: [0x01,0x11,0xee,0xbe]

s_ff0_i32_b32 tma_hi, s1
// CHECK: [0x01,0x11,0xef,0xbe]

s_ff0_i32_b32 ttmp11, s1
// CHECK: [0x01,0x11,0xfb,0xbe]

s_ff0_i32_b32 m0, s1
// CHECK: [0x01,0x11,0xfc,0xbe]

s_ff0_i32_b32 exec_lo, s1
// CHECK: [0x01,0x11,0xfe,0xbe]

s_ff0_i32_b32 exec_hi, s1
// CHECK: [0x01,0x11,0xff,0xbe]

s_ff0_i32_b32 s5, s103
// CHECK: [0x67,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, tba_lo
// CHECK: [0x6c,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, tba_hi
// CHECK: [0x6d,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, tma_lo
// CHECK: [0x6e,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, tma_hi
// CHECK: [0x6f,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, ttmp11
// CHECK: [0x7b,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, m0
// CHECK: [0x7c,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, 0
// CHECK: [0x80,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, -1
// CHECK: [0xc1,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, 0.5
// CHECK: [0xf0,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, -4.0
// CHECK: [0xf7,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, src_vccz
// CHECK: [0xfb,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, src_execz
// CHECK: [0xfc,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, src_scc
// CHECK: [0xfd,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x11,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff0_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x11,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff0_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x12,0x85,0xbe]

s_ff0_i32_b64 s103, s[2:3]
// CHECK: [0x02,0x12,0xe7,0xbe]

s_ff0_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x12,0xe8,0xbe]

s_ff0_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x12,0xe9,0xbe]

s_ff0_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x12,0xea,0xbe]

s_ff0_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x12,0xeb,0xbe]

s_ff0_i32_b64 tba_lo, s[2:3]
// CHECK: [0x02,0x12,0xec,0xbe]

s_ff0_i32_b64 tba_hi, s[2:3]
// CHECK: [0x02,0x12,0xed,0xbe]

s_ff0_i32_b64 tma_lo, s[2:3]
// CHECK: [0x02,0x12,0xee,0xbe]

s_ff0_i32_b64 tma_hi, s[2:3]
// CHECK: [0x02,0x12,0xef,0xbe]

s_ff0_i32_b64 ttmp11, s[2:3]
// CHECK: [0x02,0x12,0xfb,0xbe]

s_ff0_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x12,0xfc,0xbe]

s_ff0_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x12,0xfe,0xbe]

s_ff0_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x12,0xff,0xbe]

s_ff0_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, s[102:103]
// CHECK: [0x66,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, flat_scratch
// CHECK: [0x68,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, vcc
// CHECK: [0x6a,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, tba
// CHECK: [0x6c,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, tma
// CHECK: [0x6e,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, ttmp[10:11]
// CHECK: [0x7a,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, exec
// CHECK: [0x7e,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, 0
// CHECK: [0x80,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, -1
// CHECK: [0xc1,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, 0.5
// CHECK: [0xf0,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, -4.0
// CHECK: [0xf7,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, src_vccz
// CHECK: [0xfb,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, src_execz
// CHECK: [0xfc,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, src_scc
// CHECK: [0xfd,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x12,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff0_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x12,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b32 s5, s1
// CHECK: [0x01,0x13,0x85,0xbe]

s_ff1_i32_b32 s103, s1
// CHECK: [0x01,0x13,0xe7,0xbe]

s_ff1_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x13,0xe8,0xbe]

s_ff1_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x13,0xe9,0xbe]

s_ff1_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x13,0xea,0xbe]

s_ff1_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x13,0xeb,0xbe]

s_ff1_i32_b32 tba_lo, s1
// CHECK: [0x01,0x13,0xec,0xbe]

s_ff1_i32_b32 tba_hi, s1
// CHECK: [0x01,0x13,0xed,0xbe]

s_ff1_i32_b32 tma_lo, s1
// CHECK: [0x01,0x13,0xee,0xbe]

s_ff1_i32_b32 tma_hi, s1
// CHECK: [0x01,0x13,0xef,0xbe]

s_ff1_i32_b32 ttmp11, s1
// CHECK: [0x01,0x13,0xfb,0xbe]

s_ff1_i32_b32 m0, s1
// CHECK: [0x01,0x13,0xfc,0xbe]

s_ff1_i32_b32 exec_lo, s1
// CHECK: [0x01,0x13,0xfe,0xbe]

s_ff1_i32_b32 exec_hi, s1
// CHECK: [0x01,0x13,0xff,0xbe]

s_ff1_i32_b32 s5, s103
// CHECK: [0x67,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, tba_lo
// CHECK: [0x6c,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, tba_hi
// CHECK: [0x6d,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, tma_lo
// CHECK: [0x6e,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, tma_hi
// CHECK: [0x6f,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, ttmp11
// CHECK: [0x7b,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, m0
// CHECK: [0x7c,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, 0
// CHECK: [0x80,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, -1
// CHECK: [0xc1,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, 0.5
// CHECK: [0xf0,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, -4.0
// CHECK: [0xf7,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, src_vccz
// CHECK: [0xfb,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, src_execz
// CHECK: [0xfc,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, src_scc
// CHECK: [0xfd,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x13,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x13,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x14,0x85,0xbe]

s_ff1_i32_b64 s103, s[2:3]
// CHECK: [0x02,0x14,0xe7,0xbe]

s_ff1_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x14,0xe8,0xbe]

s_ff1_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x14,0xe9,0xbe]

s_ff1_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x14,0xea,0xbe]

s_ff1_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x14,0xeb,0xbe]

s_ff1_i32_b64 tba_lo, s[2:3]
// CHECK: [0x02,0x14,0xec,0xbe]

s_ff1_i32_b64 tba_hi, s[2:3]
// CHECK: [0x02,0x14,0xed,0xbe]

s_ff1_i32_b64 tma_lo, s[2:3]
// CHECK: [0x02,0x14,0xee,0xbe]

s_ff1_i32_b64 tma_hi, s[2:3]
// CHECK: [0x02,0x14,0xef,0xbe]

s_ff1_i32_b64 ttmp11, s[2:3]
// CHECK: [0x02,0x14,0xfb,0xbe]

s_ff1_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x14,0xfc,0xbe]

s_ff1_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x14,0xfe,0xbe]

s_ff1_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x14,0xff,0xbe]

s_ff1_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, s[102:103]
// CHECK: [0x66,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, flat_scratch
// CHECK: [0x68,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, vcc
// CHECK: [0x6a,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, tba
// CHECK: [0x6c,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, tma
// CHECK: [0x6e,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, ttmp[10:11]
// CHECK: [0x7a,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, exec
// CHECK: [0x7e,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, 0
// CHECK: [0x80,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, -1
// CHECK: [0xc1,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, 0.5
// CHECK: [0xf0,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, -4.0
// CHECK: [0xf7,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, src_vccz
// CHECK: [0xfb,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, src_execz
// CHECK: [0xfc,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, src_scc
// CHECK: [0xfd,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x14,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x14,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b32 s5, s1
// CHECK: [0x01,0x15,0x85,0xbe]

s_flbit_i32_b32 s103, s1
// CHECK: [0x01,0x15,0xe7,0xbe]

s_flbit_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x15,0xe8,0xbe]

s_flbit_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x15,0xe9,0xbe]

s_flbit_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x15,0xea,0xbe]

s_flbit_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x15,0xeb,0xbe]

s_flbit_i32_b32 tba_lo, s1
// CHECK: [0x01,0x15,0xec,0xbe]

s_flbit_i32_b32 tba_hi, s1
// CHECK: [0x01,0x15,0xed,0xbe]

s_flbit_i32_b32 tma_lo, s1
// CHECK: [0x01,0x15,0xee,0xbe]

s_flbit_i32_b32 tma_hi, s1
// CHECK: [0x01,0x15,0xef,0xbe]

s_flbit_i32_b32 ttmp11, s1
// CHECK: [0x01,0x15,0xfb,0xbe]

s_flbit_i32_b32 m0, s1
// CHECK: [0x01,0x15,0xfc,0xbe]

s_flbit_i32_b32 exec_lo, s1
// CHECK: [0x01,0x15,0xfe,0xbe]

s_flbit_i32_b32 exec_hi, s1
// CHECK: [0x01,0x15,0xff,0xbe]

s_flbit_i32_b32 s5, s103
// CHECK: [0x67,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, tba_lo
// CHECK: [0x6c,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, tba_hi
// CHECK: [0x6d,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, tma_lo
// CHECK: [0x6e,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, tma_hi
// CHECK: [0x6f,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, ttmp11
// CHECK: [0x7b,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, m0
// CHECK: [0x7c,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, 0
// CHECK: [0x80,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, -1
// CHECK: [0xc1,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, 0.5
// CHECK: [0xf0,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, -4.0
// CHECK: [0xf7,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, src_vccz
// CHECK: [0xfb,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, src_execz
// CHECK: [0xfc,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, src_scc
// CHECK: [0xfd,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x15,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x15,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x16,0x85,0xbe]

s_flbit_i32_b64 s103, s[2:3]
// CHECK: [0x02,0x16,0xe7,0xbe]

s_flbit_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x16,0xe8,0xbe]

s_flbit_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x16,0xe9,0xbe]

s_flbit_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x16,0xea,0xbe]

s_flbit_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x16,0xeb,0xbe]

s_flbit_i32_b64 tba_lo, s[2:3]
// CHECK: [0x02,0x16,0xec,0xbe]

s_flbit_i32_b64 tba_hi, s[2:3]
// CHECK: [0x02,0x16,0xed,0xbe]

s_flbit_i32_b64 tma_lo, s[2:3]
// CHECK: [0x02,0x16,0xee,0xbe]

s_flbit_i32_b64 tma_hi, s[2:3]
// CHECK: [0x02,0x16,0xef,0xbe]

s_flbit_i32_b64 ttmp11, s[2:3]
// CHECK: [0x02,0x16,0xfb,0xbe]

s_flbit_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x16,0xfc,0xbe]

s_flbit_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x16,0xfe,0xbe]

s_flbit_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x16,0xff,0xbe]

s_flbit_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, s[102:103]
// CHECK: [0x66,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, flat_scratch
// CHECK: [0x68,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, vcc
// CHECK: [0x6a,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, tba
// CHECK: [0x6c,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, tma
// CHECK: [0x6e,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, ttmp[10:11]
// CHECK: [0x7a,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, exec
// CHECK: [0x7e,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, 0
// CHECK: [0x80,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, -1
// CHECK: [0xc1,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, 0.5
// CHECK: [0xf0,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, -4.0
// CHECK: [0xf7,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, src_vccz
// CHECK: [0xfb,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, src_execz
// CHECK: [0xfc,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, src_scc
// CHECK: [0xfd,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x16,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x16,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32 s5, s1
// CHECK: [0x01,0x17,0x85,0xbe]

s_flbit_i32 s103, s1
// CHECK: [0x01,0x17,0xe7,0xbe]

s_flbit_i32 flat_scratch_lo, s1
// CHECK: [0x01,0x17,0xe8,0xbe]

s_flbit_i32 flat_scratch_hi, s1
// CHECK: [0x01,0x17,0xe9,0xbe]

s_flbit_i32 vcc_lo, s1
// CHECK: [0x01,0x17,0xea,0xbe]

s_flbit_i32 vcc_hi, s1
// CHECK: [0x01,0x17,0xeb,0xbe]

s_flbit_i32 tba_lo, s1
// CHECK: [0x01,0x17,0xec,0xbe]

s_flbit_i32 tba_hi, s1
// CHECK: [0x01,0x17,0xed,0xbe]

s_flbit_i32 tma_lo, s1
// CHECK: [0x01,0x17,0xee,0xbe]

s_flbit_i32 tma_hi, s1
// CHECK: [0x01,0x17,0xef,0xbe]

s_flbit_i32 ttmp11, s1
// CHECK: [0x01,0x17,0xfb,0xbe]

s_flbit_i32 m0, s1
// CHECK: [0x01,0x17,0xfc,0xbe]

s_flbit_i32 exec_lo, s1
// CHECK: [0x01,0x17,0xfe,0xbe]

s_flbit_i32 exec_hi, s1
// CHECK: [0x01,0x17,0xff,0xbe]

s_flbit_i32 s5, s103
// CHECK: [0x67,0x17,0x85,0xbe]

s_flbit_i32 s5, flat_scratch_lo
// CHECK: [0x68,0x17,0x85,0xbe]

s_flbit_i32 s5, flat_scratch_hi
// CHECK: [0x69,0x17,0x85,0xbe]

s_flbit_i32 s5, vcc_lo
// CHECK: [0x6a,0x17,0x85,0xbe]

s_flbit_i32 s5, vcc_hi
// CHECK: [0x6b,0x17,0x85,0xbe]

s_flbit_i32 s5, tba_lo
// CHECK: [0x6c,0x17,0x85,0xbe]

s_flbit_i32 s5, tba_hi
// CHECK: [0x6d,0x17,0x85,0xbe]

s_flbit_i32 s5, tma_lo
// CHECK: [0x6e,0x17,0x85,0xbe]

s_flbit_i32 s5, tma_hi
// CHECK: [0x6f,0x17,0x85,0xbe]

s_flbit_i32 s5, ttmp11
// CHECK: [0x7b,0x17,0x85,0xbe]

s_flbit_i32 s5, m0
// CHECK: [0x7c,0x17,0x85,0xbe]

s_flbit_i32 s5, exec_lo
// CHECK: [0x7e,0x17,0x85,0xbe]

s_flbit_i32 s5, exec_hi
// CHECK: [0x7f,0x17,0x85,0xbe]

s_flbit_i32 s5, 0
// CHECK: [0x80,0x17,0x85,0xbe]

s_flbit_i32 s5, -1
// CHECK: [0xc1,0x17,0x85,0xbe]

s_flbit_i32 s5, 0.5
// CHECK: [0xf0,0x17,0x85,0xbe]

s_flbit_i32 s5, -4.0
// CHECK: [0xf7,0x17,0x85,0xbe]

s_flbit_i32 s5, src_vccz
// CHECK: [0xfb,0x17,0x85,0xbe]

s_flbit_i32 s5, src_execz
// CHECK: [0xfc,0x17,0x85,0xbe]

s_flbit_i32 s5, src_scc
// CHECK: [0xfd,0x17,0x85,0xbe]

s_flbit_i32 s5, 0xaf123456
// CHECK: [0xff,0x17,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32 s5, 0x3f717273
// CHECK: [0xff,0x17,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_i64 s5, s[2:3]
// CHECK: [0x02,0x18,0x85,0xbe]

s_flbit_i32_i64 s103, s[2:3]
// CHECK: [0x02,0x18,0xe7,0xbe]

s_flbit_i32_i64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x18,0xe8,0xbe]

s_flbit_i32_i64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x18,0xe9,0xbe]

s_flbit_i32_i64 vcc_lo, s[2:3]
// CHECK: [0x02,0x18,0xea,0xbe]

s_flbit_i32_i64 vcc_hi, s[2:3]
// CHECK: [0x02,0x18,0xeb,0xbe]

s_flbit_i32_i64 tba_lo, s[2:3]
// CHECK: [0x02,0x18,0xec,0xbe]

s_flbit_i32_i64 tba_hi, s[2:3]
// CHECK: [0x02,0x18,0xed,0xbe]

s_flbit_i32_i64 tma_lo, s[2:3]
// CHECK: [0x02,0x18,0xee,0xbe]

s_flbit_i32_i64 tma_hi, s[2:3]
// CHECK: [0x02,0x18,0xef,0xbe]

s_flbit_i32_i64 ttmp11, s[2:3]
// CHECK: [0x02,0x18,0xfb,0xbe]

s_flbit_i32_i64 m0, s[2:3]
// CHECK: [0x02,0x18,0xfc,0xbe]

s_flbit_i32_i64 exec_lo, s[2:3]
// CHECK: [0x02,0x18,0xfe,0xbe]

s_flbit_i32_i64 exec_hi, s[2:3]
// CHECK: [0x02,0x18,0xff,0xbe]

s_flbit_i32_i64 s5, s[4:5]
// CHECK: [0x04,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, s[102:103]
// CHECK: [0x66,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, flat_scratch
// CHECK: [0x68,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, vcc
// CHECK: [0x6a,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, tba
// CHECK: [0x6c,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, tma
// CHECK: [0x6e,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, ttmp[10:11]
// CHECK: [0x7a,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, exec
// CHECK: [0x7e,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, 0
// CHECK: [0x80,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, -1
// CHECK: [0xc1,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, 0.5
// CHECK: [0xf0,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, -4.0
// CHECK: [0xf7,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, src_vccz
// CHECK: [0xfb,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, src_execz
// CHECK: [0xfc,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, src_scc
// CHECK: [0xfd,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, 0xaf123456
// CHECK: [0xff,0x18,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_i64 s5, 0x3f717273
// CHECK: [0xff,0x18,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_sext_i32_i8 s5, s1
// CHECK: [0x01,0x19,0x85,0xbe]

s_sext_i32_i8 s103, s1
// CHECK: [0x01,0x19,0xe7,0xbe]

s_sext_i32_i8 flat_scratch_lo, s1
// CHECK: [0x01,0x19,0xe8,0xbe]

s_sext_i32_i8 flat_scratch_hi, s1
// CHECK: [0x01,0x19,0xe9,0xbe]

s_sext_i32_i8 vcc_lo, s1
// CHECK: [0x01,0x19,0xea,0xbe]

s_sext_i32_i8 vcc_hi, s1
// CHECK: [0x01,0x19,0xeb,0xbe]

s_sext_i32_i8 tba_lo, s1
// CHECK: [0x01,0x19,0xec,0xbe]

s_sext_i32_i8 tba_hi, s1
// CHECK: [0x01,0x19,0xed,0xbe]

s_sext_i32_i8 tma_lo, s1
// CHECK: [0x01,0x19,0xee,0xbe]

s_sext_i32_i8 tma_hi, s1
// CHECK: [0x01,0x19,0xef,0xbe]

s_sext_i32_i8 ttmp11, s1
// CHECK: [0x01,0x19,0xfb,0xbe]

s_sext_i32_i8 m0, s1
// CHECK: [0x01,0x19,0xfc,0xbe]

s_sext_i32_i8 exec_lo, s1
// CHECK: [0x01,0x19,0xfe,0xbe]

s_sext_i32_i8 exec_hi, s1
// CHECK: [0x01,0x19,0xff,0xbe]

s_sext_i32_i8 s5, s103
// CHECK: [0x67,0x19,0x85,0xbe]

s_sext_i32_i8 s5, flat_scratch_lo
// CHECK: [0x68,0x19,0x85,0xbe]

s_sext_i32_i8 s5, flat_scratch_hi
// CHECK: [0x69,0x19,0x85,0xbe]

s_sext_i32_i8 s5, vcc_lo
// CHECK: [0x6a,0x19,0x85,0xbe]

s_sext_i32_i8 s5, vcc_hi
// CHECK: [0x6b,0x19,0x85,0xbe]

s_sext_i32_i8 s5, tba_lo
// CHECK: [0x6c,0x19,0x85,0xbe]

s_sext_i32_i8 s5, tba_hi
// CHECK: [0x6d,0x19,0x85,0xbe]

s_sext_i32_i8 s5, tma_lo
// CHECK: [0x6e,0x19,0x85,0xbe]

s_sext_i32_i8 s5, tma_hi
// CHECK: [0x6f,0x19,0x85,0xbe]

s_sext_i32_i8 s5, ttmp11
// CHECK: [0x7b,0x19,0x85,0xbe]

s_sext_i32_i8 s5, m0
// CHECK: [0x7c,0x19,0x85,0xbe]

s_sext_i32_i8 s5, exec_lo
// CHECK: [0x7e,0x19,0x85,0xbe]

s_sext_i32_i8 s5, exec_hi
// CHECK: [0x7f,0x19,0x85,0xbe]

s_sext_i32_i8 s5, 0
// CHECK: [0x80,0x19,0x85,0xbe]

s_sext_i32_i8 s5, -1
// CHECK: [0xc1,0x19,0x85,0xbe]

s_sext_i32_i8 s5, src_vccz
// CHECK: [0xfb,0x19,0x85,0xbe]

s_sext_i32_i8 s5, src_execz
// CHECK: [0xfc,0x19,0x85,0xbe]

s_sext_i32_i8 s5, src_scc
// CHECK: [0xfd,0x19,0x85,0xbe]

s_sext_i32_i8 s5, 0x71
// CHECK: [0xff,0x19,0x85,0xbe,0x71,0x00,0x00,0x00]

s_sext_i32_i8 s5, 0xf0
// CHECK: [0xff,0x19,0x85,0xbe,0xf0,0x00,0x00,0x00]

s_sext_i32_i16 s5, s1
// CHECK: [0x01,0x1a,0x85,0xbe]

s_sext_i32_i16 s103, s1
// CHECK: [0x01,0x1a,0xe7,0xbe]

s_sext_i32_i16 flat_scratch_lo, s1
// CHECK: [0x01,0x1a,0xe8,0xbe]

s_sext_i32_i16 flat_scratch_hi, s1
// CHECK: [0x01,0x1a,0xe9,0xbe]

s_sext_i32_i16 vcc_lo, s1
// CHECK: [0x01,0x1a,0xea,0xbe]

s_sext_i32_i16 vcc_hi, s1
// CHECK: [0x01,0x1a,0xeb,0xbe]

s_sext_i32_i16 tba_lo, s1
// CHECK: [0x01,0x1a,0xec,0xbe]

s_sext_i32_i16 tba_hi, s1
// CHECK: [0x01,0x1a,0xed,0xbe]

s_sext_i32_i16 tma_lo, s1
// CHECK: [0x01,0x1a,0xee,0xbe]

s_sext_i32_i16 tma_hi, s1
// CHECK: [0x01,0x1a,0xef,0xbe]

s_sext_i32_i16 ttmp11, s1
// CHECK: [0x01,0x1a,0xfb,0xbe]

s_sext_i32_i16 m0, s1
// CHECK: [0x01,0x1a,0xfc,0xbe]

s_sext_i32_i16 exec_lo, s1
// CHECK: [0x01,0x1a,0xfe,0xbe]

s_sext_i32_i16 exec_hi, s1
// CHECK: [0x01,0x1a,0xff,0xbe]

s_sext_i32_i16 s5, s103
// CHECK: [0x67,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, flat_scratch_lo
// CHECK: [0x68,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, flat_scratch_hi
// CHECK: [0x69,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, vcc_lo
// CHECK: [0x6a,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, vcc_hi
// CHECK: [0x6b,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, tba_lo
// CHECK: [0x6c,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, tba_hi
// CHECK: [0x6d,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, tma_lo
// CHECK: [0x6e,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, tma_hi
// CHECK: [0x6f,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, ttmp11
// CHECK: [0x7b,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, m0
// CHECK: [0x7c,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, exec_lo
// CHECK: [0x7e,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, exec_hi
// CHECK: [0x7f,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, 0
// CHECK: [0x80,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, -1
// CHECK: [0xc1,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, src_vccz
// CHECK: [0xfb,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, src_execz
// CHECK: [0xfc,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, src_scc
// CHECK: [0xfd,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, 0xfe0b
// CHECK: [0xff,0x1a,0x85,0xbe,0x0b,0xfe,0x00,0x00]

s_sext_i32_i16 s5, 0x3456
// CHECK: [0xff,0x1a,0x85,0xbe,0x56,0x34,0x00,0x00]

s_bitset0_b32 s5, s1
// CHECK: [0x01,0x1b,0x85,0xbe]

s_bitset0_b32 s103, s1
// CHECK: [0x01,0x1b,0xe7,0xbe]

s_bitset0_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x1b,0xe8,0xbe]

s_bitset0_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x1b,0xe9,0xbe]

s_bitset0_b32 vcc_lo, s1
// CHECK: [0x01,0x1b,0xea,0xbe]

s_bitset0_b32 vcc_hi, s1
// CHECK: [0x01,0x1b,0xeb,0xbe]

s_bitset0_b32 tba_lo, s1
// CHECK: [0x01,0x1b,0xec,0xbe]

s_bitset0_b32 tba_hi, s1
// CHECK: [0x01,0x1b,0xed,0xbe]

s_bitset0_b32 tma_lo, s1
// CHECK: [0x01,0x1b,0xee,0xbe]

s_bitset0_b32 tma_hi, s1
// CHECK: [0x01,0x1b,0xef,0xbe]

s_bitset0_b32 ttmp11, s1
// CHECK: [0x01,0x1b,0xfb,0xbe]

s_bitset0_b32 m0, s1
// CHECK: [0x01,0x1b,0xfc,0xbe]

s_bitset0_b32 exec_lo, s1
// CHECK: [0x01,0x1b,0xfe,0xbe]

s_bitset0_b32 exec_hi, s1
// CHECK: [0x01,0x1b,0xff,0xbe]

s_bitset0_b32 s5, s103
// CHECK: [0x67,0x1b,0x85,0xbe]

s_bitset0_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x1b,0x85,0xbe]

s_bitset0_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x1b,0x85,0xbe]

s_bitset0_b32 s5, vcc_lo
// CHECK: [0x6a,0x1b,0x85,0xbe]

s_bitset0_b32 s5, vcc_hi
// CHECK: [0x6b,0x1b,0x85,0xbe]

s_bitset0_b32 s5, tba_lo
// CHECK: [0x6c,0x1b,0x85,0xbe]

s_bitset0_b32 s5, tba_hi
// CHECK: [0x6d,0x1b,0x85,0xbe]

s_bitset0_b32 s5, tma_lo
// CHECK: [0x6e,0x1b,0x85,0xbe]

s_bitset0_b32 s5, tma_hi
// CHECK: [0x6f,0x1b,0x85,0xbe]

s_bitset0_b32 s5, ttmp11
// CHECK: [0x7b,0x1b,0x85,0xbe]

s_bitset0_b32 s5, m0
// CHECK: [0x7c,0x1b,0x85,0xbe]

s_bitset0_b32 s5, exec_lo
// CHECK: [0x7e,0x1b,0x85,0xbe]

s_bitset0_b32 s5, exec_hi
// CHECK: [0x7f,0x1b,0x85,0xbe]

s_bitset0_b32 s5, 0
// CHECK: [0x80,0x1b,0x85,0xbe]

s_bitset0_b32 s5, -1
// CHECK: [0xc1,0x1b,0x85,0xbe]

s_bitset0_b32 s5, 0.5
// CHECK: [0xf0,0x1b,0x85,0xbe]

s_bitset0_b32 s5, -4.0
// CHECK: [0xf7,0x1b,0x85,0xbe]

s_bitset0_b32 s5, src_vccz
// CHECK: [0xfb,0x1b,0x85,0xbe]

s_bitset0_b32 s5, src_execz
// CHECK: [0xfc,0x1b,0x85,0xbe]

s_bitset0_b32 s5, src_scc
// CHECK: [0xfd,0x1b,0x85,0xbe]

s_bitset0_b32 s5, 0xaf123456
// CHECK: [0xff,0x1b,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b32 s5, 0x3f717273
// CHECK: [0xff,0x1b,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bitset0_b64 s[10:11], s1
// CHECK: [0x01,0x1c,0x8a,0xbe]

s_bitset0_b64 s[12:13], s1
// CHECK: [0x01,0x1c,0x8c,0xbe]

s_bitset0_b64 s[102:103], s1
// CHECK: [0x01,0x1c,0xe6,0xbe]

s_bitset0_b64 flat_scratch, s1
// CHECK: [0x01,0x1c,0xe8,0xbe]

s_bitset0_b64 vcc, s1
// CHECK: [0x01,0x1c,0xea,0xbe]

s_bitset0_b64 tba, s1
// CHECK: [0x01,0x1c,0xec,0xbe]

s_bitset0_b64 tma, s1
// CHECK: [0x01,0x1c,0xee,0xbe]

s_bitset0_b64 ttmp[10:11], s1
// CHECK: [0x01,0x1c,0xfa,0xbe]

s_bitset0_b64 exec, s1
// CHECK: [0x01,0x1c,0xfe,0xbe]

s_bitset0_b64 s[10:11], s103
// CHECK: [0x67,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], flat_scratch_lo
// CHECK: [0x68,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], flat_scratch_hi
// CHECK: [0x69,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], vcc_lo
// CHECK: [0x6a,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], vcc_hi
// CHECK: [0x6b,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], tba_lo
// CHECK: [0x6c,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], tba_hi
// CHECK: [0x6d,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], tma_lo
// CHECK: [0x6e,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], tma_hi
// CHECK: [0x6f,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], ttmp11
// CHECK: [0x7b,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], m0
// CHECK: [0x7c,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], exec_lo
// CHECK: [0x7e,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], exec_hi
// CHECK: [0x7f,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], 0
// CHECK: [0x80,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], -1
// CHECK: [0xc1,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], 0.5
// CHECK: [0xf0,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], -4.0
// CHECK: [0xf7,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], src_execz
// CHECK: [0xfc,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], src_scc
// CHECK: [0xfd,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x1c,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x1c,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b32 s5, s1
// CHECK: [0x01,0x1d,0x85,0xbe]

s_bitset1_b32 s103, s1
// CHECK: [0x01,0x1d,0xe7,0xbe]

s_bitset1_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x1d,0xe8,0xbe]

s_bitset1_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x1d,0xe9,0xbe]

s_bitset1_b32 vcc_lo, s1
// CHECK: [0x01,0x1d,0xea,0xbe]

s_bitset1_b32 vcc_hi, s1
// CHECK: [0x01,0x1d,0xeb,0xbe]

s_bitset1_b32 tba_lo, s1
// CHECK: [0x01,0x1d,0xec,0xbe]

s_bitset1_b32 tba_hi, s1
// CHECK: [0x01,0x1d,0xed,0xbe]

s_bitset1_b32 tma_lo, s1
// CHECK: [0x01,0x1d,0xee,0xbe]

s_bitset1_b32 tma_hi, s1
// CHECK: [0x01,0x1d,0xef,0xbe]

s_bitset1_b32 ttmp11, s1
// CHECK: [0x01,0x1d,0xfb,0xbe]

s_bitset1_b32 m0, s1
// CHECK: [0x01,0x1d,0xfc,0xbe]

s_bitset1_b32 exec_lo, s1
// CHECK: [0x01,0x1d,0xfe,0xbe]

s_bitset1_b32 exec_hi, s1
// CHECK: [0x01,0x1d,0xff,0xbe]

s_bitset1_b32 s5, s103
// CHECK: [0x67,0x1d,0x85,0xbe]

s_bitset1_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x1d,0x85,0xbe]

s_bitset1_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x1d,0x85,0xbe]

s_bitset1_b32 s5, vcc_lo
// CHECK: [0x6a,0x1d,0x85,0xbe]

s_bitset1_b32 s5, vcc_hi
// CHECK: [0x6b,0x1d,0x85,0xbe]

s_bitset1_b32 s5, tba_lo
// CHECK: [0x6c,0x1d,0x85,0xbe]

s_bitset1_b32 s5, tba_hi
// CHECK: [0x6d,0x1d,0x85,0xbe]

s_bitset1_b32 s5, tma_lo
// CHECK: [0x6e,0x1d,0x85,0xbe]

s_bitset1_b32 s5, tma_hi
// CHECK: [0x6f,0x1d,0x85,0xbe]

s_bitset1_b32 s5, ttmp11
// CHECK: [0x7b,0x1d,0x85,0xbe]

s_bitset1_b32 s5, m0
// CHECK: [0x7c,0x1d,0x85,0xbe]

s_bitset1_b32 s5, exec_lo
// CHECK: [0x7e,0x1d,0x85,0xbe]

s_bitset1_b32 s5, exec_hi
// CHECK: [0x7f,0x1d,0x85,0xbe]

s_bitset1_b32 s5, 0
// CHECK: [0x80,0x1d,0x85,0xbe]

s_bitset1_b32 s5, -1
// CHECK: [0xc1,0x1d,0x85,0xbe]

s_bitset1_b32 s5, 0.5
// CHECK: [0xf0,0x1d,0x85,0xbe]

s_bitset1_b32 s5, -4.0
// CHECK: [0xf7,0x1d,0x85,0xbe]

s_bitset1_b32 s5, src_vccz
// CHECK: [0xfb,0x1d,0x85,0xbe]

s_bitset1_b32 s5, src_execz
// CHECK: [0xfc,0x1d,0x85,0xbe]

s_bitset1_b32 s5, src_scc
// CHECK: [0xfd,0x1d,0x85,0xbe]

s_bitset1_b32 s5, 0xaf123456
// CHECK: [0xff,0x1d,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b32 s5, 0x3f717273
// CHECK: [0xff,0x1d,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b64 s[10:11], s1
// CHECK: [0x01,0x1e,0x8a,0xbe]

s_bitset1_b64 s[12:13], s1
// CHECK: [0x01,0x1e,0x8c,0xbe]

s_bitset1_b64 s[102:103], s1
// CHECK: [0x01,0x1e,0xe6,0xbe]

s_bitset1_b64 flat_scratch, s1
// CHECK: [0x01,0x1e,0xe8,0xbe]

s_bitset1_b64 vcc, s1
// CHECK: [0x01,0x1e,0xea,0xbe]

s_bitset1_b64 tba, s1
// CHECK: [0x01,0x1e,0xec,0xbe]

s_bitset1_b64 tma, s1
// CHECK: [0x01,0x1e,0xee,0xbe]

s_bitset1_b64 ttmp[10:11], s1
// CHECK: [0x01,0x1e,0xfa,0xbe]

s_bitset1_b64 exec, s1
// CHECK: [0x01,0x1e,0xfe,0xbe]

s_bitset1_b64 s[10:11], s103
// CHECK: [0x67,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], flat_scratch_lo
// CHECK: [0x68,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], flat_scratch_hi
// CHECK: [0x69,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], vcc_lo
// CHECK: [0x6a,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], vcc_hi
// CHECK: [0x6b,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], tba_lo
// CHECK: [0x6c,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], tba_hi
// CHECK: [0x6d,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], tma_lo
// CHECK: [0x6e,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], tma_hi
// CHECK: [0x6f,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], ttmp11
// CHECK: [0x7b,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], m0
// CHECK: [0x7c,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], exec_lo
// CHECK: [0x7e,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], exec_hi
// CHECK: [0x7f,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], 0
// CHECK: [0x80,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], -1
// CHECK: [0xc1,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], 0.5
// CHECK: [0xf0,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], -4.0
// CHECK: [0xf7,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], src_execz
// CHECK: [0xfc,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], src_scc
// CHECK: [0xfd,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x1e,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x1e,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_getpc_b64 s[10:11]
// CHECK: [0x00,0x1f,0x8a,0xbe]

s_getpc_b64 s[12:13]
// CHECK: [0x00,0x1f,0x8c,0xbe]

s_getpc_b64 s[102:103]
// CHECK: [0x00,0x1f,0xe6,0xbe]

s_getpc_b64 flat_scratch
// CHECK: [0x00,0x1f,0xe8,0xbe]

s_getpc_b64 vcc
// CHECK: [0x00,0x1f,0xea,0xbe]

s_getpc_b64 tba
// CHECK: [0x00,0x1f,0xec,0xbe]

s_getpc_b64 tma
// CHECK: [0x00,0x1f,0xee,0xbe]

s_getpc_b64 ttmp[10:11]
// CHECK: [0x00,0x1f,0xfa,0xbe]

s_getpc_b64 exec
// CHECK: [0x00,0x1f,0xfe,0xbe]

s_setpc_b64 s[2:3]
// CHECK: [0x02,0x20,0x80,0xbe]

s_setpc_b64 s[4:5]
// CHECK: [0x04,0x20,0x80,0xbe]

s_setpc_b64 s[102:103]
// CHECK: [0x66,0x20,0x80,0xbe]

s_setpc_b64 flat_scratch
// CHECK: [0x68,0x20,0x80,0xbe]

s_setpc_b64 vcc
// CHECK: [0x6a,0x20,0x80,0xbe]

s_setpc_b64 tba
// CHECK: [0x6c,0x20,0x80,0xbe]

s_setpc_b64 tma
// CHECK: [0x6e,0x20,0x80,0xbe]

s_setpc_b64 ttmp[10:11]
// CHECK: [0x7a,0x20,0x80,0xbe]

s_swappc_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x21,0x8a,0xbe]

s_swappc_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x21,0x8c,0xbe]

s_swappc_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x21,0xe6,0xbe]

s_swappc_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x21,0xe8,0xbe]

s_swappc_b64 vcc, s[2:3]
// CHECK: [0x02,0x21,0xea,0xbe]

s_swappc_b64 tba, s[2:3]
// CHECK: [0x02,0x21,0xec,0xbe]

s_swappc_b64 tma, s[2:3]
// CHECK: [0x02,0x21,0xee,0xbe]

s_swappc_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x21,0xfa,0xbe]

s_swappc_b64 exec, s[2:3]
// CHECK: [0x02,0x21,0xfe,0xbe]

s_swappc_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], vcc
// CHECK: [0x6a,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], tba
// CHECK: [0x6c,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], tma
// CHECK: [0x6e,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x21,0x8a,0xbe]

s_rfe_b64 s[2:3]
// CHECK: [0x02,0x22,0x80,0xbe]

s_rfe_b64 s[4:5]
// CHECK: [0x04,0x22,0x80,0xbe]

s_rfe_b64 s[102:103]
// CHECK: [0x66,0x22,0x80,0xbe]

s_rfe_b64 flat_scratch
// CHECK: [0x68,0x22,0x80,0xbe]

s_rfe_b64 vcc
// CHECK: [0x6a,0x22,0x80,0xbe]

s_rfe_b64 tba
// CHECK: [0x6c,0x22,0x80,0xbe]

s_rfe_b64 tma
// CHECK: [0x6e,0x22,0x80,0xbe]

s_rfe_b64 ttmp[10:11]
// CHECK: [0x7a,0x22,0x80,0xbe]

s_and_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x24,0x8c,0xbe]

s_and_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x24,0xe6,0xbe]

s_and_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x24,0xe8,0xbe]

s_and_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x24,0xea,0xbe]

s_and_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x24,0xec,0xbe]

s_and_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x24,0xee,0xbe]

s_and_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x24,0xfa,0xbe]

s_and_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x24,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_and_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x24,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_or_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x25,0x8c,0xbe]

s_or_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x25,0xe6,0xbe]

s_or_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x25,0xe8,0xbe]

s_or_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x25,0xea,0xbe]

s_or_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x25,0xec,0xbe]

s_or_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x25,0xee,0xbe]

s_or_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x25,0xfa,0xbe]

s_or_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x25,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_or_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x25,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_xor_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x26,0x8c,0xbe]

s_xor_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x26,0xe6,0xbe]

s_xor_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x26,0xe8,0xbe]

s_xor_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x26,0xea,0xbe]

s_xor_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x26,0xec,0xbe]

s_xor_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x26,0xee,0xbe]

s_xor_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x26,0xfa,0xbe]

s_xor_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x26,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_xor_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x26,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x27,0x8c,0xbe]

s_andn2_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x27,0xe6,0xbe]

s_andn2_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x27,0xe8,0xbe]

s_andn2_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x27,0xea,0xbe]

s_andn2_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x27,0xec,0xbe]

s_andn2_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x27,0xee,0xbe]

s_andn2_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x27,0xfa,0xbe]

s_andn2_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x27,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x27,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_orn2_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x28,0x8c,0xbe]

s_orn2_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x28,0xe6,0xbe]

s_orn2_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x28,0xe8,0xbe]

s_orn2_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x28,0xea,0xbe]

s_orn2_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x28,0xec,0xbe]

s_orn2_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x28,0xee,0xbe]

s_orn2_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x28,0xfa,0xbe]

s_orn2_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x28,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_orn2_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x28,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_nand_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x29,0x8c,0xbe]

s_nand_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x29,0xe6,0xbe]

s_nand_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x29,0xe8,0xbe]

s_nand_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x29,0xea,0xbe]

s_nand_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x29,0xec,0xbe]

s_nand_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x29,0xee,0xbe]

s_nand_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x29,0xfa,0xbe]

s_nand_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x29,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_nand_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x29,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_nor_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x2a,0x8c,0xbe]

s_nor_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x2a,0xe6,0xbe]

s_nor_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x2a,0xe8,0xbe]

s_nor_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x2a,0xea,0xbe]

s_nor_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x2a,0xec,0xbe]

s_nor_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x2a,0xee,0xbe]

s_nor_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x2a,0xfa,0xbe]

s_nor_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x2a,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_nor_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x2a,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_xnor_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x2b,0x8c,0xbe]

s_xnor_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x2b,0xe6,0xbe]

s_xnor_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x2b,0xe8,0xbe]

s_xnor_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x2b,0xea,0xbe]

s_xnor_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x2b,0xec,0xbe]

s_xnor_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x2b,0xee,0xbe]

s_xnor_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x2b,0xfa,0xbe]

s_xnor_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x2b,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_xnor_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x2b,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b32 s5, s1
// CHECK: [0x01,0x2c,0x85,0xbe]

s_quadmask_b32 s103, s1
// CHECK: [0x01,0x2c,0xe7,0xbe]

s_quadmask_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x2c,0xe8,0xbe]

s_quadmask_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x2c,0xe9,0xbe]

s_quadmask_b32 vcc_lo, s1
// CHECK: [0x01,0x2c,0xea,0xbe]

s_quadmask_b32 vcc_hi, s1
// CHECK: [0x01,0x2c,0xeb,0xbe]

s_quadmask_b32 tba_lo, s1
// CHECK: [0x01,0x2c,0xec,0xbe]

s_quadmask_b32 tba_hi, s1
// CHECK: [0x01,0x2c,0xed,0xbe]

s_quadmask_b32 tma_lo, s1
// CHECK: [0x01,0x2c,0xee,0xbe]

s_quadmask_b32 tma_hi, s1
// CHECK: [0x01,0x2c,0xef,0xbe]

s_quadmask_b32 ttmp11, s1
// CHECK: [0x01,0x2c,0xfb,0xbe]

s_quadmask_b32 m0, s1
// CHECK: [0x01,0x2c,0xfc,0xbe]

s_quadmask_b32 exec_lo, s1
// CHECK: [0x01,0x2c,0xfe,0xbe]

s_quadmask_b32 exec_hi, s1
// CHECK: [0x01,0x2c,0xff,0xbe]

s_quadmask_b32 s5, s103
// CHECK: [0x67,0x2c,0x85,0xbe]

s_quadmask_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x2c,0x85,0xbe]

s_quadmask_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x2c,0x85,0xbe]

s_quadmask_b32 s5, vcc_lo
// CHECK: [0x6a,0x2c,0x85,0xbe]

s_quadmask_b32 s5, vcc_hi
// CHECK: [0x6b,0x2c,0x85,0xbe]

s_quadmask_b32 s5, tba_lo
// CHECK: [0x6c,0x2c,0x85,0xbe]

s_quadmask_b32 s5, tba_hi
// CHECK: [0x6d,0x2c,0x85,0xbe]

s_quadmask_b32 s5, tma_lo
// CHECK: [0x6e,0x2c,0x85,0xbe]

s_quadmask_b32 s5, tma_hi
// CHECK: [0x6f,0x2c,0x85,0xbe]

s_quadmask_b32 s5, ttmp11
// CHECK: [0x7b,0x2c,0x85,0xbe]

s_quadmask_b32 s5, m0
// CHECK: [0x7c,0x2c,0x85,0xbe]

s_quadmask_b32 s5, exec_lo
// CHECK: [0x7e,0x2c,0x85,0xbe]

s_quadmask_b32 s5, exec_hi
// CHECK: [0x7f,0x2c,0x85,0xbe]

s_quadmask_b32 s5, 0
// CHECK: [0x80,0x2c,0x85,0xbe]

s_quadmask_b32 s5, -1
// CHECK: [0xc1,0x2c,0x85,0xbe]

s_quadmask_b32 s5, 0.5
// CHECK: [0xf0,0x2c,0x85,0xbe]

s_quadmask_b32 s5, -4.0
// CHECK: [0xf7,0x2c,0x85,0xbe]

s_quadmask_b32 s5, src_vccz
// CHECK: [0xfb,0x2c,0x85,0xbe]

s_quadmask_b32 s5, src_execz
// CHECK: [0xfc,0x2c,0x85,0xbe]

s_quadmask_b32 s5, src_scc
// CHECK: [0xfd,0x2c,0x85,0xbe]

s_quadmask_b32 s5, 0xaf123456
// CHECK: [0xff,0x2c,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b32 s5, 0x3f717273
// CHECK: [0xff,0x2c,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x2d,0x8a,0xbe]

s_quadmask_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x2d,0x8c,0xbe]

s_quadmask_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x2d,0xe6,0xbe]

s_quadmask_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x2d,0xe8,0xbe]

s_quadmask_b64 vcc, s[2:3]
// CHECK: [0x02,0x2d,0xea,0xbe]

s_quadmask_b64 tba, s[2:3]
// CHECK: [0x02,0x2d,0xec,0xbe]

s_quadmask_b64 tma, s[2:3]
// CHECK: [0x02,0x2d,0xee,0xbe]

s_quadmask_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x2d,0xfa,0xbe]

s_quadmask_b64 exec, s[2:3]
// CHECK: [0x02,0x2d,0xfe,0xbe]

s_quadmask_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], vcc
// CHECK: [0x6a,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], tba
// CHECK: [0x6c,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], tma
// CHECK: [0x6e,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], exec
// CHECK: [0x7e,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], 0
// CHECK: [0x80,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], -1
// CHECK: [0xc1,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], 0.5
// CHECK: [0xf0,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], -4.0
// CHECK: [0xf7,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], src_execz
// CHECK: [0xfc,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], src_scc
// CHECK: [0xfd,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x2d,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x2d,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_movrels_b32 s5, s1
// CHECK: [0x01,0x2e,0x85,0xbe]

s_movrels_b32 s103, s1
// CHECK: [0x01,0x2e,0xe7,0xbe]

s_movrels_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x2e,0xe8,0xbe]

s_movrels_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x2e,0xe9,0xbe]

s_movrels_b32 vcc_lo, s1
// CHECK: [0x01,0x2e,0xea,0xbe]

s_movrels_b32 vcc_hi, s1
// CHECK: [0x01,0x2e,0xeb,0xbe]

s_movrels_b32 tba_lo, s1
// CHECK: [0x01,0x2e,0xec,0xbe]

s_movrels_b32 tba_hi, s1
// CHECK: [0x01,0x2e,0xed,0xbe]

s_movrels_b32 tma_lo, s1
// CHECK: [0x01,0x2e,0xee,0xbe]

s_movrels_b32 tma_hi, s1
// CHECK: [0x01,0x2e,0xef,0xbe]

s_movrels_b32 ttmp11, s1
// CHECK: [0x01,0x2e,0xfb,0xbe]

s_movrels_b32 m0, s1
// CHECK: [0x01,0x2e,0xfc,0xbe]

s_movrels_b32 exec_lo, s1
// CHECK: [0x01,0x2e,0xfe,0xbe]

s_movrels_b32 exec_hi, s1
// CHECK: [0x01,0x2e,0xff,0xbe]

s_movrels_b32 s5, s103
// CHECK: [0x67,0x2e,0x85,0xbe]

s_movrels_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x2e,0x85,0xbe]

s_movrels_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x2e,0x85,0xbe]

s_movrels_b32 s5, vcc_lo
// CHECK: [0x6a,0x2e,0x85,0xbe]

s_movrels_b32 s5, vcc_hi
// CHECK: [0x6b,0x2e,0x85,0xbe]

s_movrels_b32 s5, tba_lo
// CHECK: [0x6c,0x2e,0x85,0xbe]

s_movrels_b32 s5, tba_hi
// CHECK: [0x6d,0x2e,0x85,0xbe]

s_movrels_b32 s5, tma_lo
// CHECK: [0x6e,0x2e,0x85,0xbe]

s_movrels_b32 s5, tma_hi
// CHECK: [0x6f,0x2e,0x85,0xbe]

s_movrels_b32 s5, ttmp11
// CHECK: [0x7b,0x2e,0x85,0xbe]

s_movrels_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x2f,0x8a,0xbe]

s_movrels_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x2f,0x8c,0xbe]

s_movrels_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x2f,0xe6,0xbe]

s_movrels_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x2f,0xe8,0xbe]

s_movrels_b64 vcc, s[2:3]
// CHECK: [0x02,0x2f,0xea,0xbe]

s_movrels_b64 tba, s[2:3]
// CHECK: [0x02,0x2f,0xec,0xbe]

s_movrels_b64 tma, s[2:3]
// CHECK: [0x02,0x2f,0xee,0xbe]

s_movrels_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x2f,0xfa,0xbe]

s_movrels_b64 exec, s[2:3]
// CHECK: [0x02,0x2f,0xfe,0xbe]

s_movrels_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], vcc
// CHECK: [0x6a,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], tba
// CHECK: [0x6c,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], tma
// CHECK: [0x6e,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x2f,0x8a,0xbe]

s_movreld_b32 s5, s1
// CHECK: [0x01,0x30,0x85,0xbe]

s_movreld_b32 s103, s1
// CHECK: [0x01,0x30,0xe7,0xbe]

s_movreld_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x30,0xe8,0xbe]

s_movreld_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x30,0xe9,0xbe]

s_movreld_b32 vcc_lo, s1
// CHECK: [0x01,0x30,0xea,0xbe]

s_movreld_b32 vcc_hi, s1
// CHECK: [0x01,0x30,0xeb,0xbe]

s_movreld_b32 tba_lo, s1
// CHECK: [0x01,0x30,0xec,0xbe]

s_movreld_b32 tba_hi, s1
// CHECK: [0x01,0x30,0xed,0xbe]

s_movreld_b32 tma_lo, s1
// CHECK: [0x01,0x30,0xee,0xbe]

s_movreld_b32 tma_hi, s1
// CHECK: [0x01,0x30,0xef,0xbe]

s_movreld_b32 ttmp11, s1
// CHECK: [0x01,0x30,0xfb,0xbe]

s_movreld_b32 s5, s103
// CHECK: [0x67,0x30,0x85,0xbe]

s_movreld_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x30,0x85,0xbe]

s_movreld_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x30,0x85,0xbe]

s_movreld_b32 s5, vcc_lo
// CHECK: [0x6a,0x30,0x85,0xbe]

s_movreld_b32 s5, vcc_hi
// CHECK: [0x6b,0x30,0x85,0xbe]

s_movreld_b32 s5, tba_lo
// CHECK: [0x6c,0x30,0x85,0xbe]

s_movreld_b32 s5, tba_hi
// CHECK: [0x6d,0x30,0x85,0xbe]

s_movreld_b32 s5, tma_lo
// CHECK: [0x6e,0x30,0x85,0xbe]

s_movreld_b32 s5, tma_hi
// CHECK: [0x6f,0x30,0x85,0xbe]

s_movreld_b32 s5, ttmp11
// CHECK: [0x7b,0x30,0x85,0xbe]

s_movreld_b32 s5, m0
// CHECK: [0x7c,0x30,0x85,0xbe]

s_movreld_b32 s5, 0
// CHECK: [0x80,0x30,0x85,0xbe]

s_movreld_b32 s5, -1
// CHECK: [0xc1,0x30,0x85,0xbe]

s_movreld_b32 s5, 0.5
// CHECK: [0xf0,0x30,0x85,0xbe]

s_movreld_b32 s5, -4.0
// CHECK: [0xf7,0x30,0x85,0xbe]

s_movreld_b32 s5, src_vccz
// CHECK: [0xfb,0x30,0x85,0xbe]

s_movreld_b32 s5, src_execz
// CHECK: [0xfc,0x30,0x85,0xbe]

s_movreld_b32 s5, src_scc
// CHECK: [0xfd,0x30,0x85,0xbe]

s_movreld_b32 s5, 0xaf123456
// CHECK: [0xff,0x30,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_movreld_b32 s5, 0x3f717273
// CHECK: [0xff,0x30,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_movreld_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x31,0x8a,0xbe]

s_movreld_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x31,0x8c,0xbe]

s_movreld_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x31,0xe6,0xbe]

s_movreld_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x31,0xe8,0xbe]

s_movreld_b64 vcc, s[2:3]
// CHECK: [0x02,0x31,0xea,0xbe]

s_movreld_b64 tba, s[2:3]
// CHECK: [0x02,0x31,0xec,0xbe]

s_movreld_b64 tma, s[2:3]
// CHECK: [0x02,0x31,0xee,0xbe]

s_movreld_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x31,0xfa,0xbe]

s_movreld_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], vcc
// CHECK: [0x6a,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], tba
// CHECK: [0x6c,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], tma
// CHECK: [0x6e,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], 0
// CHECK: [0x80,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], -1
// CHECK: [0xc1,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], 0.5
// CHECK: [0xf0,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], -4.0
// CHECK: [0xf7,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], src_execz
// CHECK: [0xfc,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], src_scc
// CHECK: [0xfd,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x31,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_movreld_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x31,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_cbranch_join s1
// CHECK: [0x01,0x32,0x80,0xbe]

s_cbranch_join s103
// CHECK: [0x67,0x32,0x80,0xbe]

s_cbranch_join flat_scratch_lo
// CHECK: [0x68,0x32,0x80,0xbe]

s_cbranch_join flat_scratch_hi
// CHECK: [0x69,0x32,0x80,0xbe]

s_cbranch_join vcc_lo
// CHECK: [0x6a,0x32,0x80,0xbe]

s_cbranch_join vcc_hi
// CHECK: [0x6b,0x32,0x80,0xbe]

s_cbranch_join tba_lo
// CHECK: [0x6c,0x32,0x80,0xbe]

s_cbranch_join tba_hi
// CHECK: [0x6d,0x32,0x80,0xbe]

s_cbranch_join tma_lo
// CHECK: [0x6e,0x32,0x80,0xbe]

s_cbranch_join tma_hi
// CHECK: [0x6f,0x32,0x80,0xbe]

s_cbranch_join ttmp11
// CHECK: [0x7b,0x32,0x80,0xbe]

s_cbranch_join m0
// CHECK: [0x7c,0x32,0x80,0xbe]

s_cbranch_join exec_lo
// CHECK: [0x7e,0x32,0x80,0xbe]

s_cbranch_join exec_hi
// CHECK: [0x7f,0x32,0x80,0xbe]

s_cbranch_join src_vccz
// CHECK: [0xfb,0x32,0x80,0xbe]

s_cbranch_join src_execz
// CHECK: [0xfc,0x32,0x80,0xbe]

s_cbranch_join src_scc
// CHECK: [0xfd,0x32,0x80,0xbe]

s_abs_i32 s5, s1
// CHECK: [0x01,0x34,0x85,0xbe]

s_abs_i32 s103, s1
// CHECK: [0x01,0x34,0xe7,0xbe]

s_abs_i32 flat_scratch_lo, s1
// CHECK: [0x01,0x34,0xe8,0xbe]

s_abs_i32 flat_scratch_hi, s1
// CHECK: [0x01,0x34,0xe9,0xbe]

s_abs_i32 vcc_lo, s1
// CHECK: [0x01,0x34,0xea,0xbe]

s_abs_i32 vcc_hi, s1
// CHECK: [0x01,0x34,0xeb,0xbe]

s_abs_i32 tba_lo, s1
// CHECK: [0x01,0x34,0xec,0xbe]

s_abs_i32 tba_hi, s1
// CHECK: [0x01,0x34,0xed,0xbe]

s_abs_i32 tma_lo, s1
// CHECK: [0x01,0x34,0xee,0xbe]

s_abs_i32 tma_hi, s1
// CHECK: [0x01,0x34,0xef,0xbe]

s_abs_i32 ttmp11, s1
// CHECK: [0x01,0x34,0xfb,0xbe]

s_abs_i32 m0, s1
// CHECK: [0x01,0x34,0xfc,0xbe]

s_abs_i32 exec_lo, s1
// CHECK: [0x01,0x34,0xfe,0xbe]

s_abs_i32 exec_hi, s1
// CHECK: [0x01,0x34,0xff,0xbe]

s_abs_i32 s5, s103
// CHECK: [0x67,0x34,0x85,0xbe]

s_abs_i32 s5, flat_scratch_lo
// CHECK: [0x68,0x34,0x85,0xbe]

s_abs_i32 s5, flat_scratch_hi
// CHECK: [0x69,0x34,0x85,0xbe]

s_abs_i32 s5, vcc_lo
// CHECK: [0x6a,0x34,0x85,0xbe]

s_abs_i32 s5, vcc_hi
// CHECK: [0x6b,0x34,0x85,0xbe]

s_abs_i32 s5, tba_lo
// CHECK: [0x6c,0x34,0x85,0xbe]

s_abs_i32 s5, tba_hi
// CHECK: [0x6d,0x34,0x85,0xbe]

s_abs_i32 s5, tma_lo
// CHECK: [0x6e,0x34,0x85,0xbe]

s_abs_i32 s5, tma_hi
// CHECK: [0x6f,0x34,0x85,0xbe]

s_abs_i32 s5, ttmp11
// CHECK: [0x7b,0x34,0x85,0xbe]

s_abs_i32 s5, m0
// CHECK: [0x7c,0x34,0x85,0xbe]

s_abs_i32 s5, exec_lo
// CHECK: [0x7e,0x34,0x85,0xbe]

s_abs_i32 s5, exec_hi
// CHECK: [0x7f,0x34,0x85,0xbe]

s_abs_i32 s5, 0
// CHECK: [0x80,0x34,0x85,0xbe]

s_abs_i32 s5, -1
// CHECK: [0xc1,0x34,0x85,0xbe]

s_abs_i32 s5, 0.5
// CHECK: [0xf0,0x34,0x85,0xbe]

s_abs_i32 s5, -4.0
// CHECK: [0xf7,0x34,0x85,0xbe]

s_abs_i32 s5, src_vccz
// CHECK: [0xfb,0x34,0x85,0xbe]

s_abs_i32 s5, src_execz
// CHECK: [0xfc,0x34,0x85,0xbe]

s_abs_i32 s5, src_scc
// CHECK: [0xfd,0x34,0x85,0xbe]

s_abs_i32 s5, 0xaf123456
// CHECK: [0xff,0x34,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_abs_i32 s5, 0x3f717273
// CHECK: [0xff,0x34,0x85,0xbe,0x73,0x72,0x71,0x3f]
