; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=memcpyopt -S -verify-memoryssa | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.8.0"

%struct.foo = type { i8, [7 x i8], i32 }

; Check that the memcpy is removed.
define i32 @test1(ptr nocapture %foobie) nounwind noinline ssp uwtable {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[BLETCH_SROA_1:%.*]] = alloca [7 x i8], align 1
; CHECK-NEXT:    store i8 98, ptr [[FOOBIE:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[STRUCT_FOO:%.*]], ptr [[FOOBIE]], i64 0, i32 1, i64 0
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[STRUCT_FOO]], ptr [[FOOBIE]], i64 0, i32 2
; CHECK-NEXT:    store i32 20, ptr [[TMP2]], align 4
; CHECK-NEXT:    ret i32 undef
;
  %bletch.sroa.1 = alloca [7 x i8], align 1
  store i8 98, ptr %foobie, align 4
  %1 = getelementptr inbounds %struct.foo, ptr %foobie, i64 0, i32 1, i64 0
  call void @llvm.memcpy.p0.p0.i64(ptr %1, ptr %bletch.sroa.1, i64 7, i1 false)
  %2 = getelementptr inbounds %struct.foo, ptr %foobie, i64 0, i32 2
  store i32 20, ptr %2, align 4
  ret i32 undef
}

; Check that the memcpy is removed.
define void @test2(ptr sret(i8) noalias nocapture %out, ptr %in) nounwind noinline ssp uwtable {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 8, ptr [[IN:%.*]])
; CHECK-NEXT:    ret void
;
  call void @llvm.lifetime.start.p0(i64 8, ptr %in)
  call void @llvm.memcpy.p0.p0.i64(ptr %out, ptr %in, i64 8, i1 false)
  ret void
}

; Check that the memcpy is not removed.
define void @test3(ptr sret(i8) noalias nocapture %out, ptr %in) nounwind noinline ssp uwtable {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 4, ptr [[IN:%.*]])
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr [[OUT:%.*]], ptr [[IN]], i64 8, i1 false)
; CHECK-NEXT:    ret void
;
  call void @llvm.lifetime.start.p0(i64 4, ptr %in)
  call void @llvm.memcpy.p0.p0.i64(ptr %out, ptr %in, i64 8, i1 false)
  ret void
}

; Check that the memcpy is not removed.
define void @test_lifetime_may_alias(ptr %lifetime, ptr %src, ptr %dst) {
; CHECK-LABEL: @test_lifetime_may_alias(
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 8, ptr [[LIFETIME:%.*]])
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr [[DST:%.*]], ptr [[SRC:%.*]], i64 8, i1 false)
; CHECK-NEXT:    ret void
;
  call void @llvm.lifetime.start.p0(i64 8, ptr %lifetime)
  call void @llvm.memcpy.p0.p0.i64(ptr %dst, ptr %src, i64 8, i1 false)
  ret void
}

; lifetime.start on full alloca size, copy in range.
define void @test_lifetime_partial_alias_1(ptr noalias %dst) {
; CHECK-LABEL: @test_lifetime_partial_alias_1(
; CHECK-NEXT:    [[A:%.*]] = alloca [16 x i8], align 1
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr [[A]])
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[A]], i64 8
; CHECK-NEXT:    ret void
;
  %a = alloca [16 x i8]
  call void @llvm.lifetime.start.p0(i64 16, ptr %a)
  %gep = getelementptr i8, ptr %a, i64 8
  call void @llvm.memcpy.p0.p0.i64(ptr %dst, ptr %gep, i64 8, i1 false)
  ret void
}

; lifetime.start on full alloca size, copy out of range.
define void @test_lifetime_partial_alias_2(ptr noalias %dst) {
; CHECK-LABEL: @test_lifetime_partial_alias_2(
; CHECK-NEXT:    [[A:%.*]] = alloca [16 x i8], align 1
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 16, ptr [[A]])
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[A]], i64 8
; CHECK-NEXT:    ret void
;
  %a = alloca [16 x i8]
  call void @llvm.lifetime.start.p0(i64 16, ptr %a)
  %gep = getelementptr i8, ptr %a, i64 8
  call void @llvm.memcpy.p0.p0.i64(ptr %dst, ptr %gep, i64 16, i1 false)
  ret void
}

; lifetime.start on part of alloca, copy in range.
define void @test_lifetime_partial_alias_3(ptr noalias %dst) {
; CHECK-LABEL: @test_lifetime_partial_alias_3(
; CHECK-NEXT:    [[A:%.*]] = alloca [16 x i8], align 1
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 12, ptr [[A]])
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[A]], i64 8
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr [[DST:%.*]], ptr [[GEP]], i64 4, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca [16 x i8]
  call void @llvm.lifetime.start.p0(i64 12, ptr %a)
  %gep = getelementptr i8, ptr %a, i64 8
  call void @llvm.memcpy.p0.p0.i64(ptr %dst, ptr %gep, i64 4, i1 false)
  ret void
}

; lifetime.start on part of alloca, copy out of range.
define void @test_lifetime_partial_alias_4(ptr noalias %dst) {
; CHECK-LABEL: @test_lifetime_partial_alias_4(
; CHECK-NEXT:    [[A:%.*]] = alloca [16 x i8], align 1
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 12, ptr [[A]])
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[A]], i64 8
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr [[DST:%.*]], ptr [[GEP]], i64 8, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca [16 x i8]
  call void @llvm.lifetime.start.p0(i64 12, ptr %a)
  %gep = getelementptr i8, ptr %a, i64 8
  call void @llvm.memcpy.p0.p0.i64(ptr %dst, ptr %gep, i64 8, i1 false)
  ret void
}

declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1) nounwind

declare void @llvm.lifetime.start.p0(i64, ptr nocapture) nounwind
