; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @load_i8_stride7_vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i8_stride7_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movdqa (%rdi), %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3],xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm4[8],xmm2[9],xmm4[9],xmm2[10],xmm4[10],xmm2[11],xmm4[11],xmm2[12],xmm4[12],xmm2[13],xmm4[13],xmm2[14],xmm4[14],xmm2[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,2,2,2]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[2,3,2,3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    psrlq $48, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm2[0],xmm7[1],xmm2[1],xmm7[2],xmm2[2],xmm7[3],xmm2[3]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movd %xmm3, %edi
; SSE-NEXT:    movw %di, (%rsi)
; SSE-NEXT:    movd %xmm4, %esi
; SSE-NEXT:    movw %si, (%rdx)
; SSE-NEXT:    movd %xmm6, %edx
; SSE-NEXT:    movw %dx, (%rcx)
; SSE-NEXT:    movd %xmm5, %ecx
; SSE-NEXT:    movw %cx, (%r8)
; SSE-NEXT:    movd %xmm7, %ecx
; SSE-NEXT:    movw %cx, (%r9)
; SSE-NEXT:    movd %xmm0, %ecx
; SSE-NEXT:    movw %cx, (%r10)
; SSE-NEXT:    movd %xmm1, %ecx
; SSE-NEXT:    movw %cx, (%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride7_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX-NEXT:    vpextrw $0, %xmm5, (%r9)
; AVX-NEXT:    vpextrw $0, %xmm6, (%r10)
; AVX-NEXT:    vpextrw $0, %xmm0, (%rax)
; AVX-NEXT:    retq
  %wide.vec = load <14 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <14 x i8> %wide.vec, <14 x i8> poison, <2 x i32> <i32 0, i32 7>
  %strided.vec1 = shufflevector <14 x i8> %wide.vec, <14 x i8> poison, <2 x i32> <i32 1, i32 8>
  %strided.vec2 = shufflevector <14 x i8> %wide.vec, <14 x i8> poison, <2 x i32> <i32 2, i32 9>
  %strided.vec3 = shufflevector <14 x i8> %wide.vec, <14 x i8> poison, <2 x i32> <i32 3, i32 10>
  %strided.vec4 = shufflevector <14 x i8> %wide.vec, <14 x i8> poison, <2 x i32> <i32 4, i32 11>
  %strided.vec5 = shufflevector <14 x i8> %wide.vec, <14 x i8> poison, <2 x i32> <i32 5, i32 12>
  %strided.vec6 = shufflevector <14 x i8> %wide.vec, <14 x i8> poison, <2 x i32> <i32 6, i32 13>
  store <2 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <2 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <2 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <2 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <2 x i8> %strided.vec4, ptr %out.vec4, align 64
  store <2 x i8> %strided.vec5, ptr %out.vec5, align 64
  store <2 x i8> %strided.vec6, ptr %out.vec6, align 64
  ret void
}

define void @load_i8_stride7_vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i8_stride7_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm3
; SSE-NEXT:    movdqa 16(%rdi), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3],xmm4[4],xmm1[4],xmm4[5],xmm1[5],xmm4[6],xmm1[6],xmm4[7],xmm1[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,0],xmm3[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm3[2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,0,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    pand %xmm6, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,0,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm9
; SSE-NEXT:    pand %xmm8, %xmm9
; SSE-NEXT:    pandn %xmm3, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm11
; SSE-NEXT:    pand %xmm10, %xmm11
; SSE-NEXT:    pandn %xmm3, %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm3[1,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm0[0,2,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm14
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3],xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm5, %xmm4
; SSE-NEXT:    por %xmm7, %xmm6
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1],xmm6[2],xmm1[2],xmm6[3],xmm1[3],xmm6[4],xmm1[4],xmm6[5],xmm1[5],xmm6[6],xmm1[6],xmm6[7],xmm1[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm6[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[1,1,0,3,4,5,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm6, %xmm5
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    por %xmm5, %xmm6
; SSE-NEXT:    por %xmm9, %xmm8
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm1[0],xmm8[1],xmm1[1],xmm8[2],xmm1[2],xmm8[3],xmm1[3],xmm8[4],xmm1[4],xmm8[5],xmm1[5],xmm8[6],xmm1[6],xmm8[7],xmm1[7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm3[0],xmm8[1],xmm3[1],xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    por %xmm11, %xmm10
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm1[0],xmm10[1],xmm1[1],xmm10[2],xmm1[2],xmm10[3],xmm1[3],xmm10[4],xmm1[4],xmm10[5],xmm1[5],xmm10[6],xmm1[6],xmm10[7],xmm1[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[1,0,3,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm8[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,0,2,3]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm13[0],xmm12[1],xmm13[1]
; SSE-NEXT:    movdqa %xmm12, %xmm7
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm1[8],xmm7[9],xmm1[9],xmm7[10],xmm1[10],xmm7[11],xmm1[11],xmm7[12],xmm1[12],xmm7[13],xmm1[13],xmm7[14],xmm1[14],xmm7[15],xmm1[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm1[0],xmm12[1],xmm1[1],xmm12[2],xmm1[2],xmm12[3],xmm1[3],xmm12[4],xmm1[4],xmm12[5],xmm1[5],xmm12[6],xmm1[6],xmm12[7],xmm1[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm12[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; SSE-NEXT:    packuswb %xmm8, %xmm8
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,4,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm14 = xmm14[8],xmm1[8],xmm14[9],xmm1[9],xmm14[10],xmm1[10],xmm14[11],xmm1[11],xmm14[12],xmm1[12],xmm14[13],xmm1[13],xmm14[14],xmm1[14],xmm14[15],xmm1[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm14[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movd %xmm2, (%rsi)
; SSE-NEXT:    movd %xmm3, (%rdx)
; SSE-NEXT:    movd %xmm6, (%rcx)
; SSE-NEXT:    movd %xmm4, (%r8)
; SSE-NEXT:    movd %xmm5, (%r9)
; SSE-NEXT:    movd %xmm8, (%rdi)
; SSE-NEXT:    movd %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride7_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm1[5,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[0,7,14],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm1[6,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[1,8,15],zero,xmm0[u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX-NEXT:    vmovdqa {{.*#+}} xmm4 = <2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX-NEXT:    vpshufb %xmm4, %xmm0, %xmm5
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[0,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm6 = <3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX-NEXT:    vpshufb %xmm6, %xmm0, %xmm7
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = xmm1[1,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX-NEXT:    vpshufb %xmm4, %xmm1, %xmm4
; AVX-NEXT:    vmovdqa {{.*#+}} xmm8 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX-NEXT:    vpshufb %xmm8, %xmm0, %xmm9
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm9[0],xmm4[0],xmm9[1],xmm4[1],xmm9[2],xmm4[2],xmm9[3],xmm4[3]
; AVX-NEXT:    vpshufb %xmm6, %xmm1, %xmm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm9 = xmm0[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm9[0],xmm6[0],xmm9[1],xmm6[1],xmm9[2],xmm6[2],xmm9[3],xmm6[3]
; AVX-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX-NEXT:    vmovd %xmm2, (%rsi)
; AVX-NEXT:    vmovd %xmm3, (%rdx)
; AVX-NEXT:    vmovd %xmm5, (%rcx)
; AVX-NEXT:    vmovd %xmm7, (%r8)
; AVX-NEXT:    vmovd %xmm4, (%r9)
; AVX-NEXT:    vmovd %xmm6, (%r10)
; AVX-NEXT:    vmovd %xmm0, (%rax)
; AVX-NEXT:    retq
  %wide.vec = load <28 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <28 x i8> %wide.vec, <28 x i8> poison, <4 x i32> <i32 0, i32 7, i32 14, i32 21>
  %strided.vec1 = shufflevector <28 x i8> %wide.vec, <28 x i8> poison, <4 x i32> <i32 1, i32 8, i32 15, i32 22>
  %strided.vec2 = shufflevector <28 x i8> %wide.vec, <28 x i8> poison, <4 x i32> <i32 2, i32 9, i32 16, i32 23>
  %strided.vec3 = shufflevector <28 x i8> %wide.vec, <28 x i8> poison, <4 x i32> <i32 3, i32 10, i32 17, i32 24>
  %strided.vec4 = shufflevector <28 x i8> %wide.vec, <28 x i8> poison, <4 x i32> <i32 4, i32 11, i32 18, i32 25>
  %strided.vec5 = shufflevector <28 x i8> %wide.vec, <28 x i8> poison, <4 x i32> <i32 5, i32 12, i32 19, i32 26>
  %strided.vec6 = shufflevector <28 x i8> %wide.vec, <28 x i8> poison, <4 x i32> <i32 6, i32 13, i32 20, i32 27>
  store <4 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <4 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <4 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <4 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <4 x i8> %strided.vec4, ptr %out.vec4, align 64
  store <4 x i8> %strided.vec5, ptr %out.vec5, align 64
  store <4 x i8> %strided.vec6, ptr %out.vec6, align 64
  ret void
}

define void @load_i8_stride7_vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i8_stride7_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    movdqa 16(%rdi), %xmm2
; SSE-NEXT:    movdqa 32(%rdi), %xmm5
; SSE-NEXT:    movdqa 48(%rdi), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,0,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    pxor %xmm13, %xmm13
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm13[8],xmm6[9],xmm13[9],xmm6[10],xmm13[10],xmm6[11],xmm13[11],xmm6[12],xmm13[12],xmm6[13],xmm13[13],xmm6[14],xmm13[14],xmm6[15],xmm13[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,65535,0,65535,0,65535]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm13[0],xmm4[1],xmm13[1],xmm4[2],xmm13[2],xmm4[3],xmm13[3],xmm4[4],xmm13[4],xmm4[5],xmm13[5],xmm4[6],xmm13[6],xmm4[7],xmm13[7]
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm6, %xmm7
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm4[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,255,255,255,255,0,0,0,255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm11, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [0,65535,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm8
; SSE-NEXT:    por %xmm6, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm13[0],xmm8[1],xmm13[1],xmm8[2],xmm13[2],xmm8[3],xmm13[3],xmm8[4],xmm13[4],xmm8[5],xmm13[5],xmm8[6],xmm13[6],xmm8[7],xmm13[7]
; SSE-NEXT:    movdqa %xmm5, %xmm9
; SSE-NEXT:    movss {{.*#+}} xmm9 = xmm0[0],xmm9[1,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,0,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    pand %xmm6, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,65535,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm0, %xmm12
; SSE-NEXT:    movaps %xmm0, %xmm14
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[1,0],xmm5[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[2,0],xmm5[2,3]
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm5, %xmm6
; SSE-NEXT:    movdqa %xmm5, %xmm15
; SSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8],xmm13[8],xmm15[9],xmm13[9],xmm15[10],xmm13[10],xmm15[11],xmm13[11],xmm15[12],xmm13[12],xmm15[13],xmm13[13],xmm15[14],xmm13[14],xmm15[15],xmm13[15]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm15[0],xmm8[1],xmm15[1],xmm8[2],xmm15[2],xmm8[3],xmm15[3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm8[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm5[0,1,2,3,4,4,5,6]
; SSE-NEXT:    packuswb %xmm8, %xmm8
; SSE-NEXT:    movdqa %xmm11, %xmm5
; SSE-NEXT:    pandn %xmm8, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    por %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm13[0],xmm8[1],xmm13[1],xmm8[2],xmm13[2],xmm8[3],xmm13[3],xmm8[4],xmm13[4],xmm8[5],xmm13[5],xmm8[6],xmm13[6],xmm8[7],xmm13[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm13[8],xmm1[9],xmm13[9],xmm1[10],xmm13[10],xmm1[11],xmm13[11],xmm1[12],xmm13[12],xmm1[13],xmm13[13],xmm1[14],xmm13[14],xmm1[15],xmm13[15]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm9 = xmm9[0],xmm13[0],xmm9[1],xmm13[1],xmm9[2],xmm13[2],xmm9[3],xmm13[3],xmm9[4],xmm13[4],xmm9[5],xmm13[5],xmm9[6],xmm13[6],xmm9[7],xmm13[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm9, %xmm8
; SSE-NEXT:    pand %xmm2, %xmm8
; SSE-NEXT:    pandn %xmm15, %xmm2
; SSE-NEXT:    por %xmm8, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,6]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm11, %xmm8
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por %xmm1, %xmm8
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    por %xmm1, %xmm10
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm13[8],xmm1[9],xmm13[9],xmm1[10],xmm13[10],xmm1[11],xmm13[11],xmm1[12],xmm13[12],xmm1[13],xmm13[13],xmm1[14],xmm13[14],xmm1[15],xmm13[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm13[0],xmm10[1],xmm13[1],xmm10[2],xmm13[2],xmm10[3],xmm13[3],xmm10[4],xmm13[4],xmm10[5],xmm13[5],xmm10[6],xmm13[6],xmm10[7],xmm13[7]
; SSE-NEXT:    pand %xmm0, %xmm10
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm10, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    pand %xmm1, %xmm9
; SSE-NEXT:    pandn %xmm15, %xmm1
; SSE-NEXT:    por %xmm9, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm11, %xmm9
; SSE-NEXT:    pandn %xmm1, %xmm9
; SSE-NEXT:    por %xmm0, %xmm9
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm13[0],xmm1[1],xmm13[1],xmm1[2],xmm13[2],xmm1[3],xmm13[3],xmm1[4],xmm13[4],xmm1[5],xmm13[5],xmm1[6],xmm13[6],xmm1[7],xmm13[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm13[8],xmm0[9],xmm13[9],xmm0[10],xmm13[10],xmm0[11],xmm13[11],xmm0[12],xmm13[12],xmm0[13],xmm13[13],xmm0[14],xmm13[14],xmm0[15],xmm13[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,0,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[3,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,7,7,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm13[0],xmm12[1],xmm13[1],xmm12[2],xmm13[2],xmm12[3],xmm13[3],xmm12[4],xmm13[4],xmm12[5],xmm13[5],xmm12[6],xmm13[6],xmm12[7],xmm13[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm12[0,1,2,3,7,5,6,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4],xmm15[4],xmm12[5],xmm15[5],xmm12[6],xmm15[6],xmm12[7],xmm15[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm12[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,6]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pandn %xmm2, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm13[8],xmm2[9],xmm13[9],xmm2[10],xmm13[10],xmm2[11],xmm13[11],xmm2[12],xmm13[12],xmm2[13],xmm13[13],xmm2[14],xmm13[14],xmm2[15],xmm13[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm13[0],xmm0[1],xmm13[1],xmm0[2],xmm13[2],xmm0[3],xmm13[3],xmm0[4],xmm13[4],xmm0[5],xmm13[5],xmm0[6],xmm13[6],xmm0[7],xmm13[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,4,6,5]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm15, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[1,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm13[8],xmm1[9],xmm13[9],xmm1[10],xmm13[10],xmm1[11],xmm13[11],xmm1[12],xmm13[12],xmm1[13],xmm13[13],xmm1[14],xmm13[14],xmm1[15],xmm13[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm13[0],xmm2[1],xmm13[1],xmm2[2],xmm13[2],xmm2[3],xmm13[3],xmm2[4],xmm13[4],xmm2[5],xmm13[5],xmm2[6],xmm13[6],xmm2[7],xmm13[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm14 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3],xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; SSE-NEXT:    pand %xmm1, %xmm14
; SSE-NEXT:    pandn %xmm15, %xmm1
; SSE-NEXT:    por %xmm14, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,4,7,6]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,3,2,3]
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm10, %xmm7
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm13[0],xmm2[1],xmm13[1],xmm2[2],xmm13[2],xmm2[3],xmm13[3],xmm2[4],xmm13[4],xmm2[5],xmm13[5],xmm2[6],xmm13[6],xmm2[7],xmm13[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,4,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm13[8],xmm7[9],xmm13[9],xmm7[10],xmm13[10],xmm7[11],xmm13[11],xmm7[12],xmm13[12],xmm7[13],xmm13[13],xmm7[14],xmm13[14],xmm7[15],xmm13[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm7[4],xmm2[5],xmm7[5],xmm2[6],xmm7[6],xmm2[7],xmm7[7]
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm13[0],xmm6[1],xmm13[1],xmm6[2],xmm13[2],xmm6[3],xmm13[3],xmm6[4],xmm13[4],xmm6[5],xmm13[5],xmm6[6],xmm13[6],xmm6[7],xmm13[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    pandn %xmm15, %xmm3
; SSE-NEXT:    por %xmm6, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE-NEXT:    movq %xmm5, (%rsi)
; SSE-NEXT:    movq %xmm8, (%rdx)
; SSE-NEXT:    movq %xmm9, (%rcx)
; SSE-NEXT:    movq %xmm11, (%r8)
; SSE-NEXT:    movq %xmm0, (%r9)
; SSE-NEXT:    movq %xmm1, (%rdi)
; SSE-NEXT:    movq %xmm2, (%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: load_i8_stride7_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[0,7,14],zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm5 = xmm2[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm3[0,1,2]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,0,7,14,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm5, %xmm5
; AVX1-ONLY-NEXT:    vmovddup {{.*#+}} xmm7 = [1099511627775,1099511627775]
; AVX1-ONLY-NEXT:    # xmm7 = mem[0,0]
; AVX1-ONLY-NEXT:    vpblendvb %xmm7, %xmm4, %xmm5, %xmm4
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm8 = xmm0[1,8,15],zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm5, %xmm8, %xmm5
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = xmm2[4,5,6,7,8,9,10,11,12,13,14,15],xmm3[0,1,2,3]
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm8, %xmm8
; AVX1-ONLY-NEXT:    vpblendvb %xmm7, %xmm5, %xmm8, %xmm5
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm8 = xmm0[2,9],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,xmm1[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm9 = xmm2[5,6,7,8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4]
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm9, %xmm9
; AVX1-ONLY-NEXT:    vpblendvb %xmm7, %xmm8, %xmm9, %xmm8
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm9 = xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,xmm1[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm9, %xmm10, %xmm9
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm10 = xmm2[6,7,8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5]
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm10, %xmm6
; AVX1-ONLY-NEXT:    vpblendvb %xmm7, %xmm9, %xmm6, %xmm6
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm7 = xmm3[u,u,u,u],zero,zero,zero,xmm3[5,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm9 = xmm2[u,u,u,u,0,7,14],zero,xmm2[u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm7, %xmm9, %xmm7
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm9 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm9, %xmm0, %xmm10
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm1[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm10[0],xmm11[0],xmm10[1],xmm11[1],xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3],xmm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm10 = xmm3[u,u,u,u],zero,zero,zero,xmm3[6,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm2[u,u,u,u,1,8,15],zero,xmm2[u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm10, %xmm11, %xmm10
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm1[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm0[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm11[0,1],xmm10[2,3],xmm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,0,7,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,2,9,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpshufb %xmm9, %xmm1, %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovq %xmm4, (%rsi)
; AVX1-ONLY-NEXT:    vmovq %xmm5, (%rdx)
; AVX1-ONLY-NEXT:    vmovq %xmm8, (%rcx)
; AVX1-ONLY-NEXT:    vmovq %xmm6, (%r8)
; AVX1-ONLY-NEXT:    vmovq %xmm7, (%r9)
; AVX1-ONLY-NEXT:    vmovq %xmm10, (%r10)
; AVX1-ONLY-NEXT:    vmovq %xmm0, (%rax)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: load_i8_stride7_vf8:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,u,u,u,u,255,255,u,u>
; AVX2-ONLY-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm2
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[5,12],zero,zero,xmm3[1,u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,7,14],zero,zero,xmm2[3,10],zero,xmm2[u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX2-ONLY-NEXT:    vpblendw {{.*#+}} ymm3 = ymm0[0],ymm1[1,2],ymm0[3,4],ymm1[5],ymm0[6,7,8],ymm1[9,10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm4[6,13],zero,zero,xmm4[2,u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[1,8,15],zero,zero,xmm3[4,11],zero,xmm3[u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,u,u,u,u,255,255>
; AVX2-ONLY-NEXT:    vpblendvb %ymm4, %ymm0, %ymm1, %ymm4
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm5[0,7,14],zero,zero,xmm5[3,u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[2,9],zero,zero,zero,xmm4[5,12],zero,xmm4[u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[1,8,15],zero,zero,xmm6[4,u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[3,10],zero,zero,zero,xmm5[6,13],zero,xmm5[u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm6 = <255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,u,u,u,u>
; AVX2-ONLY-NEXT:    vpblendvb %ymm6, %ymm1, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,xmm7[2,9],zero,zero,zero,xmm7[5,u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[4,11],zero,zero,xmm6[0,7,14],zero,xmm6[u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX2-ONLY-NEXT:    vpblendw {{.*#+}} ymm7 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7,8],ymm0[9,10],ymm1[11,12],ymm0[13,14],ymm1[15]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm8[3,10],zero,zero,zero,xmm8[6,u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[5,12],zero,zero,xmm7[1,8,15],zero,xmm7[u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm8 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,u,u>
; AVX2-ONLY-NEXT:    vpblendvb %ymm8, %ymm1, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,11,0,7,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,13,2,9,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-ONLY-NEXT:    vmovq %xmm2, (%rsi)
; AVX2-ONLY-NEXT:    vmovq %xmm3, (%rdx)
; AVX2-ONLY-NEXT:    vmovq %xmm4, (%rcx)
; AVX2-ONLY-NEXT:    vmovq %xmm5, (%r8)
; AVX2-ONLY-NEXT:    vmovq %xmm6, (%r9)
; AVX2-ONLY-NEXT:    vmovq %xmm7, (%r10)
; AVX2-ONLY-NEXT:    vmovq %xmm0, (%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: load_i8_stride7_vf8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm2 = [65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,65535,65535,65535,65535]
; AVX512F-NEXT:    vpternlogq $202, %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[5,12],zero,zero,xmm3[1,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,7,14],zero,zero,xmm2[3,10],zero,xmm2[u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendw {{.*#+}} ymm3 = ymm0[0],ymm1[1,2],ymm0[3,4],ymm1[5],ymm0[6,7,8],ymm1[9,10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX512F-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm4[6,13],zero,zero,xmm4[2,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[1,8,15],zero,zero,xmm3[4,11],zero,xmm3[u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,65535,65535,65535]
; AVX512F-NEXT:    vpternlogq $202, %ymm1, %ymm0, %ymm4
; AVX512F-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm5[0,7,14],zero,zero,xmm5[3,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[2,9],zero,zero,zero,xmm4[5,12],zero,xmm4[u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm5 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6,7]
; AVX512F-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[1,8,15],zero,zero,xmm6[4,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[3,10],zero,zero,zero,xmm5[6,13],zero,xmm5[u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = [65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535]
; AVX512F-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm6
; AVX512F-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,xmm7[2,9],zero,zero,zero,xmm7[5,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[4,11],zero,zero,xmm6[0,7,14],zero,xmm6[u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512F-NEXT:    vpblendw {{.*#+}} ymm7 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7,8],ymm0[9,10],ymm1[11,12],ymm0[13,14],ymm1[15]
; AVX512F-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm8[3,10],zero,zero,zero,xmm8[6,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[5,12],zero,zero,xmm7[1,8,15],zero,xmm7[u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512F-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,11,0,7,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,13,2,9,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512F-NEXT:    vmovq %xmm2, (%rsi)
; AVX512F-NEXT:    vmovq %xmm3, (%rdx)
; AVX512F-NEXT:    vmovq %xmm4, (%rcx)
; AVX512F-NEXT:    vmovq %xmm5, (%r8)
; AVX512F-NEXT:    vmovq %xmm6, (%r9)
; AVX512F-NEXT:    vmovq %xmm7, (%r10)
; AVX512F-NEXT:    vmovq %xmm0, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_i8_stride7_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-NEXT:    vmovdqa 32(%rdi), %ymm0
; AVX512BW-NEXT:    movw $290, %di # imm = 0x122
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm2 {%k1}
; AVX512BW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[5,12],zero,zero,xmm3[1,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,7,14],zero,zero,xmm2[3,10],zero,xmm2[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5],ymm1[6,7,8],ymm0[9,10],ymm1[11,12],ymm0[13],ymm1[14,15]
; AVX512BW-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm4[6,13],zero,zero,xmm4[2,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[1,8,15],zero,zero,xmm3[4,11],zero,xmm3[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX512BW-NEXT:    movw $580, %di # imm = 0x244
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm4 {%k1}
; AVX512BW-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm5[0,7,14],zero,zero,xmm5[3,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[2,9],zero,zero,zero,xmm4[5,12],zero,xmm4[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6,7]
; AVX512BW-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[1,8,15],zero,zero,xmm6[4,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[3,10],zero,zero,zero,xmm5[6,13],zero,xmm5[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512BW-NEXT:    movw $4644, %di # imm = 0x1224
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vpblendmw %ymm1, %ymm0, %ymm6 {%k1}
; AVX512BW-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,xmm7[2,9],zero,zero,zero,xmm7[5,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[4,11],zero,zero,xmm6[0,7,14],zero,xmm6[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512BW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm0[0],ymm1[1,2],ymm0[3,4],ymm1[5,6],ymm0[7,8],ymm1[9,10],ymm0[11,12],ymm1[13,14],ymm0[15]
; AVX512BW-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm8[3,10],zero,zero,zero,xmm8[6,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[5,12],zero,zero,xmm7[1,8,15],zero,xmm7[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512BW-NEXT:    movw $9288, %di # imm = 0x2448
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k1}
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,11,0,7,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,13,2,9,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512BW-NEXT:    vmovq %xmm2, (%rsi)
; AVX512BW-NEXT:    vmovq %xmm3, (%rdx)
; AVX512BW-NEXT:    vmovq %xmm4, (%rcx)
; AVX512BW-NEXT:    vmovq %xmm5, (%r8)
; AVX512BW-NEXT:    vmovq %xmm6, (%r9)
; AVX512BW-NEXT:    vmovq %xmm7, (%r10)
; AVX512BW-NEXT:    vmovq %xmm0, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %wide.vec = load <56 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <56 x i8> %wide.vec, <56 x i8> poison, <8 x i32> <i32 0, i32 7, i32 14, i32 21, i32 28, i32 35, i32 42, i32 49>
  %strided.vec1 = shufflevector <56 x i8> %wide.vec, <56 x i8> poison, <8 x i32> <i32 1, i32 8, i32 15, i32 22, i32 29, i32 36, i32 43, i32 50>
  %strided.vec2 = shufflevector <56 x i8> %wide.vec, <56 x i8> poison, <8 x i32> <i32 2, i32 9, i32 16, i32 23, i32 30, i32 37, i32 44, i32 51>
  %strided.vec3 = shufflevector <56 x i8> %wide.vec, <56 x i8> poison, <8 x i32> <i32 3, i32 10, i32 17, i32 24, i32 31, i32 38, i32 45, i32 52>
  %strided.vec4 = shufflevector <56 x i8> %wide.vec, <56 x i8> poison, <8 x i32> <i32 4, i32 11, i32 18, i32 25, i32 32, i32 39, i32 46, i32 53>
  %strided.vec5 = shufflevector <56 x i8> %wide.vec, <56 x i8> poison, <8 x i32> <i32 5, i32 12, i32 19, i32 26, i32 33, i32 40, i32 47, i32 54>
  %strided.vec6 = shufflevector <56 x i8> %wide.vec, <56 x i8> poison, <8 x i32> <i32 6, i32 13, i32 20, i32 27, i32 34, i32 41, i32 48, i32 55>
  store <8 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <8 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <8 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <8 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <8 x i8> %strided.vec4, ptr %out.vec4, align 64
  store <8 x i8> %strided.vec5, ptr %out.vec5, align 64
  store <8 x i8> %strided.vec6, ptr %out.vec6, align 64
  ret void
}

define void @load_i8_stride7_vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i8_stride7_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $184, %rsp
; SSE-NEXT:    movdqa 96(%rdi), %xmm14
; SSE-NEXT:    movdqa 80(%rdi), %xmm6
; SSE-NEXT:    movdqa 64(%rdi), %xmm7
; SSE-NEXT:    movdqa (%rdi), %xmm5
; SSE-NEXT:    movdqa 16(%rdi), %xmm4
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    movdqa 48(%rdi), %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,0,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm11
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm8
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm8[8],xmm2[9],xmm8[9],xmm2[10],xmm8[10],xmm2[11],xmm8[11],xmm2[12],xmm8[12],xmm2[13],xmm8[13],xmm2[14],xmm8[14],xmm2[15],xmm8[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1],xmm1[2],xmm8[2],xmm1[3],xmm8[3],xmm1[4],xmm8[4],xmm1[5],xmm8[5],xmm1[6],xmm8[6],xmm1[7],xmm8[7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,5,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,255,0,0,0,0,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535,0,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm4, %xmm12
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm5, %xmm13
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm9, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm8[8],xmm1[9],xmm8[9],xmm1[10],xmm8[10],xmm1[11],xmm8[11],xmm1[12],xmm8[12],xmm1[13],xmm8[13],xmm1[14],xmm8[14],xmm1[15],xmm8[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [65535,65535,65535,65535,0,65535,0,65535]
; SSE-NEXT:    movdqa %xmm15, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm5
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3],xmm4[4],xmm8[4],xmm4[5],xmm8[5],xmm4[6],xmm8[6],xmm4[7],xmm8[7]
; SSE-NEXT:    pand %xmm15, %xmm4
; SSE-NEXT:    por %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    pandn %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3],xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,4,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm4[8],xmm3[9],xmm4[9],xmm3[10],xmm4[10],xmm3[11],xmm4[11],xmm3[12],xmm4[12],xmm3[13],xmm4[13],xmm3[14],xmm4[14],xmm3[15],xmm4[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,7,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    movdqa %xmm14, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm4[8],xmm5[9],xmm4[9],xmm5[10],xmm4[10],xmm5[11],xmm4[11],xmm5[12],xmm4[12],xmm5[13],xmm4[13],xmm5[14],xmm4[14],xmm5[15],xmm4[15]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm14 = xmm14[0],xmm4[0],xmm14[1],xmm4[1],xmm14[2],xmm4[2],xmm14[3],xmm4[3],xmm14[4],xmm4[4],xmm14[5],xmm4[5],xmm14[6],xmm4[6],xmm14[7],xmm4[7]
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm12, %xmm1
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm8, %xmm8
; SSE-NEXT:    pand %xmm5, %xmm8
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    pand %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm15
; SSE-NEXT:    por %xmm1, %xmm15
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm10, %xmm9
; SSE-NEXT:    por %xmm0, %xmm9
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,0,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm5
; SSE-NEXT:    pand %xmm1, %xmm5
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm10[0,2,2,3]
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm11, %xmm15
; SSE-NEXT:    por %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, %xmm10
; SSE-NEXT:    pslld $16, %xmm10
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm9 = xmm9[0],xmm1[0],xmm9[1],xmm1[1],xmm9[2],xmm1[2],xmm9[3],xmm1[3],xmm9[4],xmm1[4],xmm9[5],xmm1[5],xmm9[6],xmm1[6],xmm9[7],xmm1[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm9[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm2[0,1,2,3,6,4,6,5]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm13, %xmm9
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    pand %xmm13, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, (%rsp) # 16-byte Spill
; SSE-NEXT:    pandn %xmm0, %xmm13
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm1[0],xmm11[1],xmm1[1],xmm11[2],xmm1[2],xmm11[3],xmm1[3],xmm11[4],xmm1[4],xmm11[5],xmm1[5],xmm11[6],xmm1[6],xmm11[7],xmm1[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm1, %xmm11
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm14, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm14 = xmm14[0],xmm10[0],xmm14[1],xmm10[1],xmm14[2],xmm10[2],xmm14[3],xmm10[3]
; SSE-NEXT:    packuswb %xmm14, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    pshufd $236, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    # xmm10 = mem[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm10[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,5,4,6,7]
; SSE-NEXT:    packuswb %xmm10, %xmm10
; SSE-NEXT:    pand %xmm12, %xmm10
; SSE-NEXT:    por %xmm10, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pand %xmm14, %xmm8
; SSE-NEXT:    por %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1],xmm1[2],xmm8[2],xmm1[3],xmm8[3],xmm1[4],xmm8[4],xmm1[5],xmm8[5],xmm1[6],xmm8[6],xmm1[7],xmm8[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm8[8],xmm0[9],xmm8[9],xmm0[10],xmm8[10],xmm0[11],xmm8[11],xmm0[12],xmm8[12],xmm0[13],xmm8[13],xmm0[14],xmm8[14],xmm0[15],xmm8[15]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    pandn %xmm12, %xmm6
; SSE-NEXT:    por %xmm6, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm8[8],xmm1[9],xmm8[9],xmm1[10],xmm8[10],xmm1[11],xmm8[11],xmm1[12],xmm8[12],xmm1[13],xmm8[13],xmm1[14],xmm8[14],xmm1[15],xmm8[15]
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm8[0],xmm5[1],xmm8[1],xmm5[2],xmm8[2],xmm5[3],xmm8[3],xmm5[4],xmm8[4],xmm5[5],xmm8[5],xmm5[6],xmm8[6],xmm5[7],xmm8[7]
; SSE-NEXT:    pand %xmm10, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm15[1,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm1[0],xmm7[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm8[8],xmm1[9],xmm8[9],xmm1[10],xmm8[10],xmm1[11],xmm8[11],xmm1[12],xmm8[12],xmm1[13],xmm8[13],xmm1[14],xmm8[14],xmm1[15],xmm8[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3],xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    pand %xmm2, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm7, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    pandn %xmm15, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm4
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm8[8],xmm0[9],xmm8[9],xmm0[10],xmm8[10],xmm0[11],xmm8[11],xmm0[12],xmm8[12],xmm0[13],xmm8[13],xmm0[14],xmm8[14],xmm0[15],xmm8[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3],xmm4[4],xmm8[4],xmm4[5],xmm8[5],xmm4[6],xmm8[6],xmm4[7],xmm8[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm4[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,0,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm12, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3],xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,0,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm8[8],xmm3[9],xmm8[9],xmm3[10],xmm8[10],xmm3[11],xmm8[11],xmm3[12],xmm8[12],xmm3[13],xmm8[13],xmm3[14],xmm8[14],xmm3[15],xmm8[15]
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm6, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm3[3,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,7,7,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn %xmm7, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm8[8],xmm2[9],xmm8[9],xmm2[10],xmm8[10],xmm2[11],xmm8[11],xmm2[12],xmm8[12],xmm2[13],xmm8[13],xmm2[14],xmm8[14],xmm2[15],xmm8[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm8[0],xmm6[1],xmm8[1],xmm6[2],xmm8[2],xmm6[3],xmm8[3],xmm6[4],xmm8[4],xmm6[5],xmm8[5],xmm6[6],xmm8[6],xmm6[7],xmm8[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm6, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm15[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[0,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,7,6,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm6, %xmm3
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm8[8],xmm0[9],xmm8[9],xmm0[10],xmm8[10],xmm0[11],xmm8[11],xmm0[12],xmm8[12],xmm0[13],xmm8[13],xmm0[14],xmm8[14],xmm0[15],xmm8[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3],xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm8[8],xmm0[9],xmm8[9],xmm0[10],xmm8[10],xmm0[11],xmm8[11],xmm0[12],xmm8[12],xmm0[13],xmm8[13],xmm0[14],xmm8[14],xmm0[15],xmm8[15]
; SSE-NEXT:    movdqa (%rsp), %xmm6 # 16-byte Reload
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    por %xmm6, %xmm9
; SSE-NEXT:    packuswb %xmm0, %xmm9
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm9[0,1,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm4 = xmm2[0],xmm4[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,0,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm7, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3],xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm8[8],xmm2[9],xmm8[9],xmm2[10],xmm8[10],xmm2[11],xmm8[11],xmm2[12],xmm8[12],xmm2[13],xmm8[13],xmm2[14],xmm8[14],xmm2[15],xmm8[15]
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm15[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pandn %xmm2, %xmm5
; SSE-NEXT:    por %xmm0, %xmm5
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    andps %xmm14, %xmm4
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm11, %xmm2
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm8[8],xmm4[9],xmm8[9],xmm4[10],xmm8[10],xmm4[11],xmm8[11],xmm4[12],xmm8[12],xmm4[13],xmm8[13],xmm4[14],xmm8[14],xmm4[15],xmm8[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3],xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm2[0,1,2,3,5,4,7,6]
; SSE-NEXT:    psrldq {{.*#+}} xmm4 = xmm4[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    packuswb %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[0,2,2,3]
; SSE-NEXT:    pand %xmm11, %xmm10
; SSE-NEXT:    pandn %xmm12, %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm12[1,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm8[8],xmm4[9],xmm8[9],xmm4[10],xmm8[10],xmm4[11],xmm8[11],xmm4[12],xmm8[12],xmm4[13],xmm8[13],xmm4[14],xmm8[14],xmm4[15],xmm8[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3],xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1],xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movss {{.*#+}} xmm5 = xmm2[0],xmm5[1,2,3]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm6, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm15
; SSE-NEXT:    pandn %xmm7, %xmm6
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3],xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm8[8],xmm6[9],xmm8[9],xmm6[10],xmm8[10],xmm6[11],xmm8[11],xmm6[12],xmm8[12],xmm6[13],xmm8[13],xmm6[14],xmm8[14],xmm6[15],xmm8[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,0,65535,0,65535,65535,65535]
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    por %xmm6, %xmm4
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm13[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,6]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm6, %xmm2
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    pandn %xmm7, %xmm2
; SSE-NEXT:    andps %xmm14, %xmm5
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    por %xmm10, %xmm11
; SSE-NEXT:    movdqa %xmm11, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3],xmm4[4],xmm8[4],xmm4[5],xmm8[5],xmm4[6],xmm8[6],xmm4[7],xmm8[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,4,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm11 = xmm11[8],xmm8[8],xmm11[9],xmm8[9],xmm11[10],xmm8[10],xmm11[11],xmm8[11],xmm11[12],xmm8[12],xmm11[13],xmm8[13],xmm11[14],xmm8[14],xmm11[15],xmm8[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm11[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm5[4],xmm4[5],xmm5[5],xmm4[6],xmm5[6],xmm4[7],xmm5[7]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm8[8],xmm5[9],xmm8[9],xmm5[10],xmm8[10],xmm5[11],xmm8[11],xmm5[12],xmm8[12],xmm5[13],xmm8[13],xmm5[14],xmm8[14],xmm5[15],xmm8[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pandn %xmm5, %xmm9
; SSE-NEXT:    movdqa %xmm5, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    por %xmm9, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[3,3,3,3]
; SSE-NEXT:    packuswb %xmm7, %xmm5
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    movss {{.*#+}} xmm5 = xmm4[0],xmm5[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm15[1,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm12[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm4[0],xmm7[1],xmm4[1]
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3],xmm4[4],xmm8[4],xmm4[5],xmm8[5],xmm4[6],xmm8[6],xmm4[7],xmm8[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm8[8],xmm7[9],xmm8[9],xmm7[10],xmm8[10],xmm7[11],xmm8[11],xmm7[12],xmm8[12],xmm7[13],xmm8[13],xmm7[14],xmm8[14],xmm7[15],xmm8[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535,65535,0,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pandn %xmm4, %xmm8
; SSE-NEXT:    por %xmm7, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm8[2,1,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm9[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    pandn %xmm7, %xmm6
; SSE-NEXT:    por %xmm6, %xmm4
; SSE-NEXT:    andps %xmm14, %xmm5
; SSE-NEXT:    pandn %xmm4, %xmm14
; SSE-NEXT:    por %xmm5, %xmm14
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, (%rdx)
; SSE-NEXT:    movdqa %xmm1, (%rcx)
; SSE-NEXT:    movdqa %xmm3, (%r8)
; SSE-NEXT:    movdqa %xmm0, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm2, (%rax)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm14, (%rax)
; SSE-NEXT:    addq $184, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: load_i8_stride7_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,zero,xmm6[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[0,7,14],zero,zero,xmm2[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm3[u,u,u,u,u,3,10],zero,zero,zero,xmm3[u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = xmm4[u,u,u,u,u],zero,zero,xmm4[1,8,15,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm5, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm5 = <255,255,255,255,255,0,0,0,0,0,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm5, %xmm0, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm6[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm9 = xmm2[1,8,15],zero,zero,xmm2[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm9 = xmm4[u,u,u,u,u],zero,zero,xmm4[2,9,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm10 = xmm3[u,u,u,u,u,4,11],zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm9, %xmm10, %xmm9
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = <255,255,255,255,255,0,0,0,0,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm11, %xmm8, %xmm9, %xmm8
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm9 = xmm1[u,u,u,u,5,12,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm10 = xmm5[u,u,u,u,u,0,7,14,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm9 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX1-ONLY-NEXT:    vpxor %xmm12, %xmm12, %xmm12
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1,2,3,4,5,6],xmm12[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm10 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm7[3,10]
; AVX1-ONLY-NEXT:    vpor %xmm10, %xmm9, %xmm10
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm9 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendvb %xmm9, %xmm8, %xmm10, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm10 = xmm2[2,9],zero,zero,zero,xmm2[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,xmm6[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm10, %xmm13, %xmm10
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm4[u,u,u,u,u],zero,zero,xmm4[3,10,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm3[u,u,u,u,u,5,12],zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm13, %xmm14, %xmm13
; AVX1-ONLY-NEXT:    vpblendvb %xmm11, %xmm10, %xmm13, %xmm10
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm1[u,u,u,u,u,u,u,u,u,u,u,u,6,13,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm5[u,u,u,u,u,u,u,u,u,u,u,u,u,1,8,15]
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm13 = xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,5,6],xmm12[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm7[4,11]
; AVX1-ONLY-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX1-ONLY-NEXT:    vpblendvb %xmm9, %xmm10, %xmm13, %xmm10
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm2[3,10],zero,zero,zero,xmm2[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,xmm6[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm13, %xmm14, %xmm13
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm4[u,u,u,u,u],zero,zero,xmm4[4,11,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm15 = xmm3[u,u,u,u,u,6,13],zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX1-ONLY-NEXT:    vpblendvb %xmm11, %xmm13, %xmm14, %xmm11
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm5[u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm5[u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm1[u,u,u,u,u,u,u,u,u],zero,zero,xmm1[0,7,14,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm13, %xmm14, %xmm13
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,5,6],xmm12[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm7[5,12]
; AVX1-ONLY-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX1-ONLY-NEXT:    vpblendvb %xmm9, %xmm11, %xmm13, %xmm11
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm13 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm2, %xmm14
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm15 = xmm6[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm14[0],xmm15[0],xmm14[1],xmm15[1],xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm15 = xmm4[u,u,u,u],zero,zero,zero,xmm4[5,12,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm3[u,u,u,u,0,7,14],zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm15, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm14[0,1],xmm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm5[u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm5[u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm15 = xmm1[u,u,u,u,u,u,u,u,u],zero,zero,xmm1[1,8,15,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm14[0,1,2,3,4,5,6],xmm12[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm7[6,13]
; AVX1-ONLY-NEXT:    vpor %xmm14, %xmm12, %xmm12
; AVX1-ONLY-NEXT:    vpblendvb %xmm9, %xmm0, %xmm12, %xmm12
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm6[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm2[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm14[0],xmm0[0],xmm14[1],xmm0[1],xmm14[2],xmm0[2],xmm14[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm4[u,u,u,u],zero,zero,zero,xmm4[6,13,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm15 = xmm3[u,u,u,u,1,8,15],zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm14[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm1[u,u,u,u,u,u,u,u,u],zero,zero,xmm1[2,9,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm15 = xmm5[u,u,u,u,u,u,u,u,u,4,11],zero,zero,xmm5[u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm15 = <u,u,u,u,u,u,u,u,u,9,10,11,12,128,128,128>
; AVX1-ONLY-NEXT:    vpshufb %xmm15, %xmm14, %xmm14
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm7[0,7,14]
; AVX1-ONLY-NEXT:    vpor %xmm8, %xmm14, %xmm8
; AVX1-ONLY-NEXT:    vpblendvb %xmm9, %xmm0, %xmm8, %xmm0
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm6, %xmm6
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,2,9],zero,zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u],zero,zero,xmm4[0,7,14,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,u,u,u,u,u,u,u],zero,zero,xmm1[3,10,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm5[u,u,u,u,u,u,u,u,u,5,12],zero,zero,xmm5[u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-ONLY-NEXT:    vpshufb %xmm15, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm7[1,8,15]
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vpblendvb %xmm9, %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,4,11,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm5[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u,u,u,u,u,0,1,2,3,8,15]
; AVX1-ONLY-NEXT:    vpblendw $31, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[0,1,2,3,4],xmm1[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, (%rsi)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm1, (%rdx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, (%rcx)
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, (%r8)
; AVX1-ONLY-NEXT:    vmovdqa %xmm12, (%r9)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, (%rax)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, (%rax)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: load_i8_stride7_vf16:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-ONLY-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm2
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[5,12],zero,zero,xmm3[1,8,15,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm3, %xmm2, %xmm3
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm9[0],xmm10[1],xmm9[2],xmm10[3]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u,u,u,u,u,u,u,6,13],zero,zero,xmm2[2,9]
; AVX2-ONLY-NEXT:    vmovdqa 80(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u,u,u,u,u,u,u,u,u,u],zero,zero,xmm2[4,11],zero,zero
; AVX2-ONLY-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX2-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3,4],xmm4[5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm4 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-ONLY-NEXT:    vpblendvb %ymm4, %ymm0, %ymm1, %ymm4
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[6,13],zero,zero,xmm5[2,9,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[1,8,15],zero,zero,xmm4[4,11],zero,zero,xmm4[u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm5, %xmm4, %xmm6
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm5[0],xmm4[1],xmm5[2,3,4],xmm4[5],xmm5[6,7]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u,u,u,0,7,14],zero,zero,xmm7[3,10]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm8 = xmm2[u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm2[5,12],zero,zero
; AVX2-ONLY-NEXT:    vpor %xmm7, %xmm8, %xmm8
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; AVX2-ONLY-NEXT:    vpblendvb %xmm7, %xmm6, %xmm8, %xmm6
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm8 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-ONLY-NEXT:    vpblendvb %ymm8, %ymm0, %ymm1, %ymm8
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm8[2,9],zero,zero,zero,xmm8[5,12],zero,zero,xmm8[u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm8[0,7,14],zero,zero,xmm8[3,10,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm11, %xmm8, %xmm8
; AVX2-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm5[0,1],xmm4[2],xmm5[3,4],xmm4[5],xmm5[6,7]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,u,u,u,u,u,u,u,1,8,15],zero,zero,xmm11[4,11]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm2[u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm2[6,13],zero,zero
; AVX2-ONLY-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX2-ONLY-NEXT:    vpblendvb %xmm7, %xmm8, %xmm11, %xmm8
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-ONLY-NEXT:    vpblendvb %ymm11, %ymm0, %ymm1, %ymm11
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm11[3,10],zero,zero,zero,xmm11[6,13],zero,zero,xmm11[u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm11, %xmm11
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,xmm11[1,8,15],zero,zero,xmm11[4,11,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm10 = xmm10[0],xmm9[1],xmm10[2],xmm9[3]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm9 = xmm10[u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm10[5,12]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm2[u,u,u,u,u,u,u,u,u],zero,zero,xmm2[0,7,14],zero,zero
; AVX2-ONLY-NEXT:    vpor %xmm12, %xmm9, %xmm9
; AVX2-ONLY-NEXT:    vpblendvb %xmm7, %xmm11, %xmm9, %xmm9
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm11 = <255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u>
; AVX2-ONLY-NEXT:    vpblendvb %ymm11, %ymm1, %ymm0, %ymm11
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm11, %xmm12
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = zero,zero,xmm12[2,9],zero,zero,zero,xmm12[5,12,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[4,11],zero,zero,xmm11[0,7,14],zero,zero,xmm11[u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm10[6,13]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm2[u,u,u,u,u,u,u,u,u],zero,zero,xmm2[1,8,15],zero,zero
; AVX2-ONLY-NEXT:    vpor %xmm12, %xmm10, %xmm10
; AVX2-ONLY-NEXT:    vpblendvb %xmm7, %xmm11, %xmm10, %xmm10
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm11 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-ONLY-NEXT:    vpblendvb %ymm11, %ymm1, %ymm0, %ymm11
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm11, %xmm12
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = zero,zero,xmm12[3,10],zero,zero,zero,xmm12[6,13,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[5,12],zero,zero,xmm11[1,8,15],zero,zero,xmm11[u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX2-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm4[0],xmm5[1,2],xmm4[3],xmm5[4,5,6],xmm4[7]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u,u,u,u,u,u,u,u,4,11],zero,zero,xmm12[0,7,14]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm2[u,u,u,u,u,u,u,u,u],zero,zero,xmm2[2,9],zero,zero,zero
; AVX2-ONLY-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX2-ONLY-NEXT:    vpblendvb %xmm7, %xmm11, %xmm12, %xmm11
; AVX2-ONLY-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-ONLY-NEXT:    vpblendvb %ymm12, %ymm1, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[6,13],zero,zero,xmm0[2,9],zero,zero,zero,xmm0[u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u,u,u,u,u,u]
; AVX2-ONLY-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm4[0],xmm5[1,2,3],xmm4[4],xmm5[5,6],xmm4[7]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u,u,u,u,5,12],zero,zero,xmm1[1,8,15]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u,u,u],zero,zero,xmm2[3,10],zero,zero,zero
; AVX2-ONLY-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX2-ONLY-NEXT:    vpblendvb %xmm7, %xmm0, %xmm1, %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm3, (%rsi)
; AVX2-ONLY-NEXT:    vmovdqa %xmm6, (%rdx)
; AVX2-ONLY-NEXT:    vmovdqa %xmm8, (%rcx)
; AVX2-ONLY-NEXT:    vmovdqa %xmm9, (%r8)
; AVX2-ONLY-NEXT:    vmovdqa %xmm10, (%r9)
; AVX2-ONLY-NEXT:    vmovdqa %xmm11, (%r10)
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, (%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: load_i8_stride7_vf16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovdqa 80(%rdi), %xmm0
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[u,u,u,u,u,u,u,u,u,u],zero,zero,xmm0[4,11],zero,zero
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm5 = [65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0]
; AVX512F-NEXT:    vpternlogq $202, %ymm2, %ymm1, %ymm5
; AVX512F-NEXT:    vextracti128 $1, %ymm5, %xmm4
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm4[5,12],zero,zero,xmm4[1,8,15,u,u,u,u,u,u]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm6 = xmm4[0,1,2,3,4],xmm3[5,6,7]
; AVX512F-NEXT:    vmovdqa 96(%rdi), %xmm3
; AVX512F-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm7 = xmm3[0],xmm4[1],xmm3[2],xmm4[3]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u,u,u,u,6,13],zero,zero,xmm7[2,9]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,7,14],zero,zero,xmm5[3,10],zero,zero,zero,xmm5[u,u,u,u,u,u]
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4],xmm7[5,6,7]
; AVX512F-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm8 = [65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535]
; AVX512F-NEXT:    vmovdqa %ymm8, %ymm6
; AVX512F-NEXT:    vpternlogq $202, %ymm2, %ymm1, %ymm6
; AVX512F-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[6,13],zero,zero,xmm7[2,9,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[1,8,15],zero,zero,xmm6[4,11],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm7, %xmm6, %xmm9
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm6 = xmm4[0],xmm3[1],xmm4[2,3,4],xmm3[5],xmm4[6,7]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u,u,u,0,7,14],zero,zero,xmm6[3,10]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[5,12],zero,zero
; AVX512F-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; AVX512F-NEXT:    vpternlogq $184, %xmm9, %xmm7, %xmm6
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm9 = [65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535]
; AVX512F-NEXT:    vmovdqa %ymm9, %ymm10
; AVX512F-NEXT:    vpternlogq $202, %ymm2, %ymm1, %ymm10
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[2,9],zero,zero,zero,xmm10[5,12],zero,zero,xmm10[u,u,u,u,u,u,u]
; AVX512F-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,xmm10[0,7,14],zero,zero,xmm10[3,10,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm11, %xmm10, %xmm10
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm11 = xmm4[0,1],xmm3[2],xmm4[3,4],xmm3[5],xmm4[6,7]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,u,u,u,u,u,u,u,1,8,15],zero,zero,xmm11[4,11]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm12 = xmm0[u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[6,13],zero,zero
; AVX512F-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX512F-NEXT:    vpternlogq $184, %xmm10, %xmm7, %xmm11
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm10 = [65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535]
; AVX512F-NEXT:    vmovdqa %ymm10, %ymm12
; AVX512F-NEXT:    vpternlogq $202, %ymm2, %ymm1, %ymm12
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm13 = xmm12[3,10],zero,zero,zero,xmm12[6,13],zero,zero,xmm12[u,u,u,u,u,u,u]
; AVX512F-NEXT:    vextracti128 $1, %ymm12, %xmm12
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm12 = zero,zero,xmm12[1,8,15],zero,zero,xmm12[4,11,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm13 = xmm4[0],xmm3[1],xmm4[2],xmm3[3]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm13[5,12]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm15 = xmm0[u,u,u,u,u,u,u,u,u],zero,zero,xmm0[0,7,14],zero,zero
; AVX512F-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512F-NEXT:    vpternlogq $184, %xmm12, %xmm7, %xmm14
; AVX512F-NEXT:    vpternlogq $202, %ymm1, %ymm2, %ymm8
; AVX512F-NEXT:    vextracti128 $1, %ymm8, %xmm12
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm12 = zero,zero,xmm12[2,9],zero,zero,zero,xmm12[5,12,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[4,11],zero,zero,xmm8[0,7,14],zero,zero,xmm8[u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm12, %xmm8, %xmm8
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm12 = xmm13[u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm13[6,13]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[u,u,u,u,u,u,u,u,u],zero,zero,xmm0[1,8,15],zero,zero
; AVX512F-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX512F-NEXT:    vpternlogq $184, %xmm8, %xmm7, %xmm12
; AVX512F-NEXT:    vpternlogq $202, %ymm1, %ymm2, %ymm9
; AVX512F-NEXT:    vextracti128 $1, %ymm9, %xmm8
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm8[3,10],zero,zero,zero,xmm8[6,13,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[5,12],zero,zero,xmm9[1,8,15],zero,zero,xmm9[u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm9 = xmm3[0],xmm4[1,2],xmm3[3],xmm4[4,5,6],xmm3[7]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,u,u,u,u,u,u,u,u,4,11],zero,zero,xmm9[0,7,14]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[u,u,u,u,u,u,u,u,u],zero,zero,xmm0[2,9],zero,zero,zero
; AVX512F-NEXT:    vpor %xmm13, %xmm9, %xmm9
; AVX512F-NEXT:    vpternlogq $184, %xmm8, %xmm7, %xmm9
; AVX512F-NEXT:    vpternlogq $202, %ymm1, %ymm2, %ymm10
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm1 = xmm10[6,13],zero,zero,xmm10[2,9],zero,zero,zero,xmm10[u,u,u,u,u,u,u]
; AVX512F-NEXT:    vextracti128 $1, %ymm10, %xmm2
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14,u,u,u,u,u,u,u]
; AVX512F-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm4[1,2,3],xmm3[4],xmm4[5,6],xmm3[7]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u,u,u,5,12],zero,zero,xmm2[1,8,15]
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u],zero,zero,xmm0[3,10],zero,zero,zero
; AVX512F-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512F-NEXT:    vpternlogq $184, %xmm1, %xmm7, %xmm0
; AVX512F-NEXT:    vmovdqa %xmm5, (%rsi)
; AVX512F-NEXT:    vmovdqa %xmm6, (%rdx)
; AVX512F-NEXT:    vmovdqa %xmm11, (%rcx)
; AVX512F-NEXT:    vmovdqa %xmm14, (%r8)
; AVX512F-NEXT:    vmovdqa %xmm12, (%r9)
; AVX512F-NEXT:    vmovdqa %xmm9, (%r10)
; AVX512F-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_i8_stride7_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa 96(%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm2 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u,u,u,u,u,u,u,6,13],zero,zero,xmm2[2,9]
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512BW-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512BW-NEXT:    movw $-28382, %r11w # imm = 0x9122
; AVX512BW-NEXT:    kmovd %r11d, %k1
; AVX512BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm5 {%k1}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[0,7,14],zero,zero,xmm5[3,10],zero,zero,zero,xmm5[u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm6[0,1,2,3,4],xmm4[5,6,7]
; AVX512BW-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u,u,u,u,u]
; AVX512BW-NEXT:    vmovdqa 80(%rdi), %xmm5
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm5[u,u,u,u,u,u,u,u,u,u],zero,zero,xmm5[4,11],zero,zero
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2,3,4],xmm7[5,6,7]
; AVX512BW-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX512BW-NEXT:    movw $4644, %di # imm = 0x1224
; AVX512BW-NEXT:    kmovd %edi, %k2
; AVX512BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm6 {%k2}
; AVX512BW-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[6,13],zero,zero,xmm7[2,9,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[1,8,15],zero,zero,xmm6[4,11],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm7 = xmm1[0],xmm0[1],xmm1[2,3,4],xmm0[5],xmm1[6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u,u,u,0,7,14],zero,zero,xmm7[3,10]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm5[u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm5[5,12],zero,zero
; AVX512BW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512BW-NEXT:    movw $-512, %di # imm = 0xFE00
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vmovdqu8 %xmm7, %xmm6 {%k1}
; AVX512BW-NEXT:    movw $8772, %di # imm = 0x2244
; AVX512BW-NEXT:    kmovd %edi, %k3
; AVX512BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm7 {%k3}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[2,9],zero,zero,zero,xmm7[5,12],zero,zero,xmm7[u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,xmm7[0,7,14],zero,zero,xmm7[3,10,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm8 = xmm1[0,1],xmm0[2],xmm1[3,4],xmm0[5],xmm1[6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u,u,u,u,u,u,u,1,8,15],zero,zero,xmm8[4,11]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm5[u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm5[6,13],zero,zero
; AVX512BW-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512BW-NEXT:    vmovdqu8 %xmm8, %xmm7 {%k1}
; AVX512BW-NEXT:    movw $9288, %di # imm = 0x2448
; AVX512BW-NEXT:    kmovd %edi, %k4
; AVX512BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm8 {%k4}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm8[3,10],zero,zero,zero,xmm8[6,13],zero,zero,xmm8[u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm8[1,8,15],zero,zero,xmm8[4,11,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm9 = xmm1[0],xmm0[1],xmm1[2],xmm0[3]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm10 = xmm9[u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm9[5,12]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm5[u,u,u,u,u,u,u,u,u],zero,zero,xmm5[0,7,14],zero,zero
; AVX512BW-NEXT:    vpor %xmm11, %xmm10, %xmm10
; AVX512BW-NEXT:    vmovdqu8 %xmm10, %xmm8 {%k1}
; AVX512BW-NEXT:    vpblendmw %ymm3, %ymm2, %ymm10 {%k2}
; AVX512BW-NEXT:    vextracti128 $1, %ymm10, %xmm11
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,xmm11[2,9],zero,zero,zero,xmm11[5,12,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[4,11],zero,zero,xmm10[0,7,14],zero,zero,xmm10[u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm11, %xmm10, %xmm10
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm9[6,13]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm5[u,u,u,u,u,u,u,u,u],zero,zero,xmm5[1,8,15],zero,zero
; AVX512BW-NEXT:    vpor %xmm11, %xmm9, %xmm9
; AVX512BW-NEXT:    vmovdqu8 %xmm9, %xmm10 {%k1}
; AVX512BW-NEXT:    vpblendmw %ymm3, %ymm2, %ymm9 {%k3}
; AVX512BW-NEXT:    vextracti128 $1, %ymm9, %xmm11
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,xmm11[3,10],zero,zero,zero,xmm11[6,13,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[5,12],zero,zero,xmm9[1,8,15],zero,zero,xmm9[u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm11, %xmm9, %xmm9
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm11 = xmm0[0],xmm1[1,2],xmm0[3],xmm1[4,5,6],xmm0[7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,u,u,u,u,u,u,u,4,11],zero,zero,xmm11[0,7,14]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm5[u,u,u,u,u,u,u,u,u],zero,zero,xmm5[2,9],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX512BW-NEXT:    vmovdqu8 %xmm11, %xmm9 {%k1}
; AVX512BW-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k4}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[6,13],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3],xmm0[4],xmm1[5,6],xmm0[7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,5,12],zero,zero,xmm0[1,8,15]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm5[u,u,u,u,u,u,u,u,u],zero,zero,xmm5[3,10],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovdqu8 %xmm0, %xmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX512BW-NEXT:    vmovdqa %xmm6, (%rdx)
; AVX512BW-NEXT:    vmovdqa %xmm7, (%rcx)
; AVX512BW-NEXT:    vmovdqa %xmm8, (%r8)
; AVX512BW-NEXT:    vmovdqa %xmm10, (%r9)
; AVX512BW-NEXT:    vmovdqa %xmm9, (%r10)
; AVX512BW-NEXT:    vmovdqa %xmm2, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %wide.vec = load <112 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <112 x i8> %wide.vec, <112 x i8> poison, <16 x i32> <i32 0, i32 7, i32 14, i32 21, i32 28, i32 35, i32 42, i32 49, i32 56, i32 63, i32 70, i32 77, i32 84, i32 91, i32 98, i32 105>
  %strided.vec1 = shufflevector <112 x i8> %wide.vec, <112 x i8> poison, <16 x i32> <i32 1, i32 8, i32 15, i32 22, i32 29, i32 36, i32 43, i32 50, i32 57, i32 64, i32 71, i32 78, i32 85, i32 92, i32 99, i32 106>
  %strided.vec2 = shufflevector <112 x i8> %wide.vec, <112 x i8> poison, <16 x i32> <i32 2, i32 9, i32 16, i32 23, i32 30, i32 37, i32 44, i32 51, i32 58, i32 65, i32 72, i32 79, i32 86, i32 93, i32 100, i32 107>
  %strided.vec3 = shufflevector <112 x i8> %wide.vec, <112 x i8> poison, <16 x i32> <i32 3, i32 10, i32 17, i32 24, i32 31, i32 38, i32 45, i32 52, i32 59, i32 66, i32 73, i32 80, i32 87, i32 94, i32 101, i32 108>
  %strided.vec4 = shufflevector <112 x i8> %wide.vec, <112 x i8> poison, <16 x i32> <i32 4, i32 11, i32 18, i32 25, i32 32, i32 39, i32 46, i32 53, i32 60, i32 67, i32 74, i32 81, i32 88, i32 95, i32 102, i32 109>
  %strided.vec5 = shufflevector <112 x i8> %wide.vec, <112 x i8> poison, <16 x i32> <i32 5, i32 12, i32 19, i32 26, i32 33, i32 40, i32 47, i32 54, i32 61, i32 68, i32 75, i32 82, i32 89, i32 96, i32 103, i32 110>
  %strided.vec6 = shufflevector <112 x i8> %wide.vec, <112 x i8> poison, <16 x i32> <i32 6, i32 13, i32 20, i32 27, i32 34, i32 41, i32 48, i32 55, i32 62, i32 69, i32 76, i32 83, i32 90, i32 97, i32 104, i32 111>
  store <16 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <16 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <16 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <16 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <16 x i8> %strided.vec4, ptr %out.vec4, align 64
  store <16 x i8> %strided.vec5, ptr %out.vec5, align 64
  store <16 x i8> %strided.vec6, ptr %out.vec6, align 64
  ret void
}

define void @load_i8_stride7_vf32(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i8_stride7_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $632, %rsp # imm = 0x278
; SSE-NEXT:    movdqa 96(%rdi), %xmm9
; SSE-NEXT:    movdqa 80(%rdi), %xmm6
; SSE-NEXT:    movdqa 64(%rdi), %xmm13
; SSE-NEXT:    movdqa (%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    movdqa 48(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [65535,0,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm12
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm14, %xmm14
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm14[8],xmm0[9],xmm14[9],xmm0[10],xmm14[10],xmm0[11],xmm14[11],xmm0[12],xmm14[12],xmm0[13],xmm14[13],xmm0[14],xmm14[14],xmm0[15],xmm14[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm14[0],xmm1[1],xmm14[1],xmm1[2],xmm14[2],xmm1[3],xmm14[3],xmm1[4],xmm14[4],xmm1[5],xmm14[5],xmm1[6],xmm14[6],xmm1[7],xmm14[7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm1[0,1,2,3,4,4,5,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,255,0,0,0,0,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [65535,65535,0,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm14[8],xmm1[9],xmm14[9],xmm1[10],xmm14[10],xmm1[11],xmm14[11],xmm1[12],xmm14[12],xmm1[13],xmm14[13],xmm1[14],xmm14[14],xmm1[15],xmm14[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,0,65535,0,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm14[0],xmm3[1],xmm14[1],xmm3[2],xmm14[2],xmm3[3],xmm14[3],xmm3[4],xmm14[4],xmm3[5],xmm14[5],xmm3[6],xmm14[6],xmm3[7],xmm14[7]
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm5, %xmm7
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm13, %xmm2
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm10
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm14[0],xmm2[1],xmm14[1],xmm2[2],xmm14[2],xmm2[3],xmm14[3],xmm2[4],xmm14[4],xmm2[5],xmm14[5],xmm2[6],xmm14[6],xmm2[7],xmm14[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,4,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm14[8],xmm3[9],xmm14[9],xmm3[10],xmm14[10],xmm3[11],xmm14[11],xmm3[12],xmm14[12],xmm3[13],xmm14[13],xmm3[14],xmm14[14],xmm3[15],xmm14[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,7,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm14[8],xmm4[9],xmm14[9],xmm4[10],xmm14[10],xmm4[11],xmm14[11],xmm4[12],xmm14[12],xmm4[13],xmm14[13],xmm4[14],xmm14[14],xmm4[15],xmm14[15]
; SSE-NEXT:    movdqa %xmm4, (%rsp) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm14[0],xmm3[1],xmm14[1],xmm3[2],xmm14[2],xmm3[3],xmm14[3],xmm3[4],xmm14[4],xmm3[5],xmm14[5],xmm3[6],xmm14[6],xmm3[7],xmm14[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    pand %xmm6, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 144(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    movdqa 160(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm11, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm14[8],xmm1[9],xmm14[9],xmm1[10],xmm14[10],xmm1[11],xmm14[11],xmm1[12],xmm14[12],xmm1[13],xmm14[13],xmm1[14],xmm14[14],xmm1[15],xmm14[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm14[0],xmm2[1],xmm14[1],xmm2[2],xmm14[2],xmm2[3],xmm14[3],xmm2[4],xmm14[4],xmm2[5],xmm14[5],xmm2[6],xmm14[6],xmm2[7],xmm14[7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,5,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa 128(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa 112(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm14[8],xmm1[9],xmm14[9],xmm1[10],xmm14[10],xmm1[11],xmm14[11],xmm1[12],xmm14[12],xmm1[13],xmm14[13],xmm1[14],xmm14[14],xmm1[15],xmm14[15]
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm14[0],xmm3[1],xmm14[1],xmm3[2],xmm14[2],xmm3[3],xmm14[3],xmm3[4],xmm14[4],xmm3[5],xmm14[5],xmm3[6],xmm14[6],xmm3[7],xmm14[7]
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa 176(%rdi), %xmm14
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm14, %xmm0
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 192(%rdi), %xmm11
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm7, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1],xmm0[2],xmm7[2],xmm0[3],xmm7[3],xmm0[4],xmm7[4],xmm0[5],xmm7[5],xmm0[6],xmm7[6],xmm0[7],xmm7[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,4,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm7[8],xmm2[9],xmm7[9],xmm2[10],xmm7[10],xmm2[11],xmm7[11],xmm2[12],xmm7[12],xmm2[13],xmm7[13],xmm2[14],xmm7[14],xmm2[15],xmm7[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,7,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    movdqa 208(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm7[8],xmm3[9],xmm7[9],xmm3[10],xmm7[10],xmm3[11],xmm7[11],xmm3[12],xmm7[12],xmm3[13],xmm7[13],xmm3[14],xmm7[14],xmm3[15],xmm7[15]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm7[0],xmm2[1],xmm7[1],xmm2[2],xmm7[2],xmm2[3],xmm7[3],xmm2[4],xmm7[4],xmm2[5],xmm7[5],xmm2[6],xmm7[6],xmm2[7],xmm7[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    pand %xmm6, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    por %xmm1, %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    pandn %xmm12, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm6, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm7[8],xmm2[9],xmm7[9],xmm2[10],xmm7[10],xmm2[11],xmm7[11],xmm2[12],xmm7[12],xmm2[13],xmm7[13],xmm2[14],xmm7[14],xmm2[15],xmm7[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[1],xmm7[1],xmm1[2],xmm7[2],xmm1[3],xmm7[3],xmm1[4],xmm7[4],xmm1[5],xmm7[5],xmm1[6],xmm7[6],xmm1[7],xmm7[7]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    packuswb %xmm2, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[1],xmm7[1],xmm1[2],xmm7[2],xmm1[3],xmm7[3],xmm1[4],xmm7[4],xmm1[5],xmm7[5],xmm1[6],xmm7[6],xmm1[7],xmm7[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm8, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm7[8],xmm3[9],xmm7[9],xmm3[10],xmm7[10],xmm3[11],xmm7[11],xmm3[12],xmm7[12],xmm3[13],xmm7[13],xmm3[14],xmm7[14],xmm3[15],xmm7[15]
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm15, %xmm2
; SSE-NEXT:    pandn %xmm10, %xmm2
; SSE-NEXT:    pand %xmm15, %xmm13
; SSE-NEXT:    por %xmm2, %xmm13
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm7[8],xmm2[9],xmm7[9],xmm2[10],xmm7[10],xmm2[11],xmm7[11],xmm2[12],xmm7[12],xmm2[13],xmm7[13],xmm2[14],xmm7[14],xmm2[15],xmm7[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,65535,65535,0,65535,0,65535]
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm13 = xmm13[0],xmm7[0],xmm13[1],xmm7[1],xmm13[2],xmm7[2],xmm13[3],xmm7[3],xmm13[4],xmm7[4],xmm13[5],xmm7[5],xmm13[6],xmm7[6],xmm13[7],xmm7[7]
; SSE-NEXT:    pand %xmm10, %xmm13
; SSE-NEXT:    por %xmm4, %xmm13
; SSE-NEXT:    movdqa (%rsp), %xmm2 # 16-byte Reload
; SSE-NEXT:    pslld $16, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE-NEXT:    packuswb %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm13[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,4,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pand %xmm6, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm3, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm3[8],xmm1[9],xmm3[9],xmm1[10],xmm3[10],xmm1[11],xmm3[11],xmm1[12],xmm3[12],xmm1[13],xmm3[13],xmm1[14],xmm3[14],xmm1[15],xmm3[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3],xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3],xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm4[8],xmm2[9],xmm4[9],xmm2[10],xmm4[10],xmm2[11],xmm4[11],xmm2[12],xmm4[12],xmm2[13],xmm4[13],xmm2[14],xmm4[14],xmm2[15],xmm4[15]
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pandn %xmm11, %xmm0
; SSE-NEXT:    pand %xmm15, %xmm14
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm14 = xmm14[0],xmm2[0],xmm14[1],xmm2[1],xmm14[2],xmm2[2],xmm14[3],xmm2[3],xmm14[4],xmm2[4],xmm14[5],xmm2[5],xmm14[6],xmm2[6],xmm14[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pand %xmm10, %xmm14
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm14, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm10
; SSE-NEXT:    pand %xmm15, %xmm10
; SSE-NEXT:    por %xmm0, %xmm10
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm13, %xmm15
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,2,2,3]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm12, %xmm4
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm5
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm1, %xmm12
; SSE-NEXT:    por %xmm0, %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm14, %xmm5
; SSE-NEXT:    pslld $16, %xmm5
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm13, %xmm8
; SSE-NEXT:    psrldq {{.*#+}} xmm8 = xmm8[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm14[0],xmm8[1],xmm14[1],xmm8[2],xmm14[2],xmm8[3],xmm14[3]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm0[4],xmm7[5],xmm0[5],xmm7[6],xmm0[6],xmm7[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, %xmm7
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm14[4],xmm7[5],xmm14[5],xmm7[6],xmm14[6],xmm7[7],xmm14[7]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm7
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pxor %xmm14, %xmm14
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm14[0],xmm10[1],xmm14[1],xmm10[2],xmm14[2],xmm10[3],xmm14[3],xmm10[4],xmm14[4],xmm10[5],xmm14[5],xmm10[6],xmm14[6],xmm10[7],xmm14[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm10[0,1,2,3,6,4,6,5]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm15 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3],xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm14 = xmm15[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm14 = xmm14[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm14 = xmm14[0,1,2,3,6,4,6,5]
; SSE-NEXT:    movdqa %xmm10, %xmm15
; SSE-NEXT:    pand %xmm10, %xmm14
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm15, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, %xmm10
; SSE-NEXT:    pand %xmm15, %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm10
; SSE-NEXT:    pandn %xmm7, %xmm15
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pxor %xmm7, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm15 = xmm15[0],xmm7[0],xmm15[1],xmm7[1],xmm15[2],xmm7[2],xmm15[3],xmm7[3],xmm15[4],xmm7[4],xmm15[5],xmm7[5],xmm15[6],xmm7[6],xmm15[7],xmm7[7]
; SSE-NEXT:    pand %xmm12, %xmm15
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1],xmm0[2],xmm7[2],xmm0[3],xmm7[3],xmm0[4],xmm7[4],xmm0[5],xmm7[5],xmm0[6],xmm7[6],xmm0[7],xmm7[7]
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm12, %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm13, %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm13 = xmm13[0],xmm5[0],xmm13[1],xmm5[1],xmm13[2],xmm5[2],xmm13[3],xmm5[3]
; SSE-NEXT:    packuswb %xmm13, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm10, %xmm15
; SSE-NEXT:    pandn %xmm2, %xmm15
; SSE-NEXT:    pshufd $236, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,4,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    por %xmm2, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    pandn %xmm15, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    pand %xmm0, %xmm15
; SSE-NEXT:    por %xmm2, %xmm15
; SSE-NEXT:    movdqa %xmm15, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8],xmm1[8],xmm15[9],xmm1[9],xmm15[10],xmm1[10],xmm15[11],xmm1[11],xmm15[12],xmm1[12],xmm15[13],xmm1[13],xmm15[14],xmm1[14],xmm15[15],xmm1[15]
; SSE-NEXT:    pand %xmm13, %xmm15
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    packuswb %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm15[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pxor %xmm15, %xmm15
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm15[0],xmm4[1],xmm15[1],xmm4[2],xmm15[2],xmm4[3],xmm15[3],xmm4[4],xmm15[4],xmm4[5],xmm15[5],xmm4[6],xmm15[6],xmm4[7],xmm15[7]
; SSE-NEXT:    pand %xmm13, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[1,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm9 = xmm9[0],xmm1[0],xmm9[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm12
; SSE-NEXT:    pandn %xmm1, %xmm12
; SSE-NEXT:    punpcklbw {{.*#+}} xmm9 = xmm9[0],xmm15[0],xmm9[1],xmm15[1],xmm9[2],xmm15[2],xmm9[3],xmm15[3],xmm9[4],xmm15[4],xmm9[5],xmm15[5],xmm9[6],xmm15[6],xmm9[7],xmm15[7]
; SSE-NEXT:    pand %xmm2, %xmm9
; SSE-NEXT:    por %xmm12, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm9[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE-NEXT:    packuswb %xmm1, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm9, %xmm7
; SSE-NEXT:    pandn %xmm12, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    movdqa %xmm9, %xmm12
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pand %xmm5, %xmm7
; SSE-NEXT:    por %xmm0, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm15[0],xmm0[1],xmm15[1],xmm0[2],xmm15[2],xmm0[3],xmm15[3],xmm0[4],xmm15[4],xmm0[5],xmm15[5],xmm0[6],xmm15[6],xmm0[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm13, %xmm9
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    packuswb %xmm8, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pandn %xmm13, %xmm0
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1],xmm6[2],xmm15[2],xmm6[3],xmm15[3],xmm6[4],xmm15[4],xmm6[5],xmm15[5],xmm6[6],xmm15[6],xmm6[7],xmm15[7]
; SSE-NEXT:    pand %xmm9, %xmm6
; SSE-NEXT:    movdqa %xmm9, %xmm8
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm15[0],xmm3[1],xmm15[1],xmm3[2],xmm15[2],xmm3[3],xmm15[3],xmm3[4],xmm15[4],xmm3[5],xmm15[5],xmm3[6],xmm15[6],xmm3[7],xmm15[7]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    packuswb %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn %xmm10, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm15[0],xmm0[1],xmm15[1],xmm0[2],xmm15[2],xmm0[3],xmm15[3],xmm0[4],xmm15[4],xmm0[5],xmm15[5],xmm0[6],xmm15[6],xmm0[7],xmm15[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    pandn %xmm10, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm15[0],xmm2[1],xmm15[1],xmm2[2],xmm15[2],xmm2[3],xmm15[3],xmm2[4],xmm15[4],xmm2[5],xmm15[5],xmm2[6],xmm15[6],xmm2[7],xmm15[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,0,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm15[8],xmm3[9],xmm15[9],xmm3[10],xmm15[10],xmm3[11],xmm15[11],xmm3[12],xmm15[12],xmm3[13],xmm15[13],xmm3[14],xmm15[14],xmm3[15],xmm15[15]
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[3,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm2[0,1,2,3,7,7,7,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm15[0],xmm11[1],xmm15[1],xmm11[2],xmm15[2],xmm11[3],xmm15[3],xmm11[4],xmm15[4],xmm11[5],xmm15[5],xmm11[6],xmm15[6],xmm11[7],xmm15[7]
; SSE-NEXT:    pand %xmm8, %xmm11
; SSE-NEXT:    por %xmm2, %xmm11
; SSE-NEXT:    pshuflw $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm8, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm11[0,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,6,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm8, %xmm11
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm5, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm15[0],xmm0[1],xmm15[1],xmm0[2],xmm15[2],xmm0[3],xmm15[3],xmm0[4],xmm15[4],xmm0[5],xmm15[5],xmm0[6],xmm15[6],xmm0[7],xmm15[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    packuswb %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pandn %xmm13, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pand %xmm12, %xmm4
; SSE-NEXT:    movdqa %xmm12, %xmm13
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm7, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm15[8],xmm4[9],xmm15[9],xmm4[10],xmm15[10],xmm4[11],xmm15[11],xmm4[12],xmm15[12],xmm4[13],xmm15[13],xmm4[14],xmm15[14],xmm4[15],xmm15[15]
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    por %xmm5, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm4[3,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm1[0,1,2,3,7,7,7,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pandn %xmm8, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm15[0],xmm5[1],xmm15[1],xmm5[2],xmm15[2],xmm5[3],xmm15[3],xmm5[4],xmm15[4],xmm5[5],xmm15[5],xmm5[6],xmm15[6],xmm5[7],xmm15[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm12[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm5[0,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,6,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm10, %xmm3
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm5, %xmm9
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm15[8],xmm3[9],xmm15[9],xmm3[10],xmm15[10],xmm3[11],xmm15[11],xmm3[12],xmm15[12],xmm3[13],xmm15[13],xmm3[14],xmm15[14],xmm3[15],xmm15[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm15[0],xmm4[1],xmm15[1],xmm4[2],xmm15[2],xmm4[3],xmm15[3],xmm4[4],xmm15[4],xmm4[5],xmm15[5],xmm4[6],xmm15[6],xmm4[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm15[8],xmm3[9],xmm15[9],xmm3[10],xmm15[10],xmm3[11],xmm15[11],xmm3[12],xmm15[12],xmm3[13],xmm15[13],xmm3[14],xmm15[14],xmm3[15],xmm15[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    packuswb %xmm3, %xmm1
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[0,1,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm5 = xmm4[0],xmm5[1,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm6, %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm15[0],xmm3[1],xmm15[1],xmm3[2],xmm15[2],xmm3[3],xmm15[3],xmm3[4],xmm15[4],xmm3[5],xmm15[5],xmm3[6],xmm15[6],xmm3[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm15[8],xmm4[9],xmm15[9],xmm4[10],xmm15[10],xmm4[11],xmm15[11],xmm4[12],xmm15[12],xmm4[13],xmm15[13],xmm4[14],xmm15[14],xmm4[15],xmm15[15]
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    por %xmm6, %xmm4
; SSE-NEXT:    pshufd $100, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    movdqa %xmm11, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[0,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm6, %xmm3
; SSE-NEXT:    andps %xmm1, %xmm5
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    pand %xmm9, %xmm5
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm15[8],xmm4[9],xmm15[9],xmm4[10],xmm15[10],xmm4[11],xmm15[11],xmm4[12],xmm15[12],xmm4[13],xmm15[13],xmm4[14],xmm15[14],xmm4[15],xmm15[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm15[0],xmm5[1],xmm15[1],xmm5[2],xmm15[2],xmm5[3],xmm15[3],xmm5[4],xmm15[4],xmm5[5],xmm15[5],xmm5[6],xmm15[6],xmm5[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm2, %xmm14
; SSE-NEXT:    packuswb %xmm1, %xmm14
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm14[0,1,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm6 = xmm5[0],xmm6[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,0,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm15[0],xmm4[1],xmm15[1],xmm4[2],xmm15[2],xmm4[3],xmm15[3],xmm4[4],xmm15[4],xmm4[5],xmm15[5],xmm4[6],xmm15[6],xmm4[7],xmm15[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    pand %xmm11, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm12[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pandn %xmm5, %xmm11
; SSE-NEXT:    por %xmm4, %xmm11
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm11, %xmm4
; SSE-NEXT:    andps %xmm0, %xmm6
; SSE-NEXT:    por %xmm6, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm0, %xmm5
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm15[8],xmm6[9],xmm15[9],xmm6[10],xmm15[10],xmm6[11],xmm15[11],xmm6[12],xmm15[12],xmm6[13],xmm15[13],xmm6[14],xmm15[14],xmm6[15],xmm15[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm11, %xmm7
; SSE-NEXT:    pandn %xmm6, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm15[0],xmm5[1],xmm15[1],xmm5[2],xmm15[2],xmm5[3],xmm15[3],xmm5[4],xmm15[4],xmm5[5],xmm15[5],xmm5[6],xmm15[6],xmm5[7],xmm15[7]
; SSE-NEXT:    pand %xmm11, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm5[0,1,2,3,5,4,7,6]
; SSE-NEXT:    psrldq {{.*#+}} xmm6 = xmm6[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    packuswb %xmm6, %xmm12
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[1,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm2[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; SSE-NEXT:    movdqa %xmm6, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm15[8],xmm5[9],xmm15[9],xmm5[10],xmm15[10],xmm5[11],xmm15[11],xmm5[12],xmm15[12],xmm5[13],xmm15[13],xmm5[14],xmm15[14],xmm5[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1],xmm6[2],xmm15[2],xmm6[3],xmm15[3],xmm6[4],xmm15[4],xmm6[5],xmm15[5],xmm6[6],xmm15[6],xmm6[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    movss {{.*#+}} xmm12 = xmm6[0],xmm12[1,2,3]
; SSE-NEXT:    movdqa %xmm9, %xmm5
; SSE-NEXT:    pandn %xmm10, %xmm5
; SSE-NEXT:    movdqa %xmm13, %xmm6
; SSE-NEXT:    pand %xmm9, %xmm6
; SSE-NEXT:    por %xmm5, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm15[0],xmm7[1],xmm15[1],xmm7[2],xmm15[2],xmm7[3],xmm15[3],xmm7[4],xmm15[4],xmm7[5],xmm15[5],xmm7[6],xmm15[6],xmm7[7],xmm15[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,0,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm13
; SSE-NEXT:    pandn %xmm7, %xmm13
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm15[8],xmm6[9],xmm15[9],xmm6[10],xmm15[10],xmm6[11],xmm15[11],xmm6[12],xmm15[12],xmm6[13],xmm15[13],xmm6[14],xmm15[14],xmm6[15],xmm15[15]
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    por %xmm13, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,7,6]
; SSE-NEXT:    packuswb %xmm7, %xmm13
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0]
; SSE-NEXT:    movdqa %xmm7, %xmm14
; SSE-NEXT:    pandn %xmm13, %xmm14
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    pand %xmm7, %xmm6
; SSE-NEXT:    por %xmm6, %xmm14
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm10, %xmm6
; SSE-NEXT:    pandn %xmm14, %xmm6
; SSE-NEXT:    andps %xmm10, %xmm12
; SSE-NEXT:    por %xmm12, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    pand %xmm0, %xmm12
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm12, %xmm13
; SSE-NEXT:    punpckhbw {{.*#+}} xmm13 = xmm13[8],xmm15[8],xmm13[9],xmm15[9],xmm13[10],xmm15[10],xmm13[11],xmm15[11],xmm13[12],xmm15[12],xmm13[13],xmm15[13],xmm13[14],xmm15[14],xmm13[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm15[0],xmm12[1],xmm15[1],xmm12[2],xmm15[2],xmm12[3],xmm15[3],xmm12[4],xmm15[4],xmm12[5],xmm15[5],xmm12[6],xmm15[6],xmm12[7],xmm15[7]
; SSE-NEXT:    pand %xmm11, %xmm12
; SSE-NEXT:    pandn %xmm13, %xmm11
; SSE-NEXT:    por %xmm12, %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,5,4,7,6]
; SSE-NEXT:    psrldq {{.*#+}} xmm13 = xmm13[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    packuswb %xmm13, %xmm11
; SSE-NEXT:    movdqa %xmm2, %xmm14
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pand %xmm0, %xmm14
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm0[0,2,2,3]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pandn %xmm13, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm13[1,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm13[0],xmm12[1],xmm13[1]
; SSE-NEXT:    movdqa %xmm12, %xmm13
; SSE-NEXT:    punpckhbw {{.*#+}} xmm13 = xmm13[8],xmm15[8],xmm13[9],xmm15[9],xmm13[10],xmm15[10],xmm13[11],xmm15[11],xmm13[12],xmm15[12],xmm13[13],xmm15[13],xmm13[14],xmm15[14],xmm13[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm13[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm13 = xmm13[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm15[0],xmm12[1],xmm15[1],xmm12[2],xmm15[2],xmm12[3],xmm15[3],xmm12[4],xmm15[4],xmm12[5],xmm15[5],xmm12[6],xmm15[6],xmm12[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm12[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm12 = xmm12[0],xmm13[0],xmm12[1],xmm13[1],xmm12[2],xmm13[2],xmm12[3],xmm13[3]
; SSE-NEXT:    packuswb %xmm12, %xmm12
; SSE-NEXT:    movss {{.*#+}} xmm11 = xmm12[0],xmm11[1,2,3]
; SSE-NEXT:    movdqa %xmm1, %xmm12
; SSE-NEXT:    pand %xmm9, %xmm12
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pandn %xmm1, %xmm9
; SSE-NEXT:    por %xmm12, %xmm9
; SSE-NEXT:    movdqa %xmm9, %xmm12
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm15[0],xmm12[1],xmm15[1],xmm12[2],xmm15[2],xmm12[3],xmm15[3],xmm12[4],xmm15[4],xmm12[5],xmm15[5],xmm12[6],xmm15[6],xmm12[7],xmm15[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm15[8],xmm9[9],xmm15[9],xmm9[10],xmm15[10],xmm9[11],xmm15[11],xmm9[12],xmm15[12],xmm9[13],xmm15[13],xmm9[14],xmm15[14],xmm9[15],xmm15[15]
; SSE-NEXT:    pand %xmm5, %xmm9
; SSE-NEXT:    pandn %xmm12, %xmm5
; SSE-NEXT:    por %xmm9, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,4,7,6]
; SSE-NEXT:    packuswb %xmm10, %xmm10
; SSE-NEXT:    movdqa %xmm7, %xmm12
; SSE-NEXT:    pandn %xmm10, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pand %xmm7, %xmm5
; SSE-NEXT:    por %xmm5, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm9, %xmm5
; SSE-NEXT:    pandn %xmm12, %xmm5
; SSE-NEXT:    andps %xmm9, %xmm11
; SSE-NEXT:    por %xmm11, %xmm5
; SSE-NEXT:    movdqa %xmm14, %xmm10
; SSE-NEXT:    por %xmm8, %xmm10
; SSE-NEXT:    movdqa %xmm10, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm15[0],xmm8[1],xmm15[1],xmm8[2],xmm15[2],xmm8[3],xmm15[3],xmm8[4],xmm15[4],xmm8[5],xmm15[5],xmm8[6],xmm15[6],xmm8[7],xmm15[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,6,4,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm15[8],xmm10[9],xmm15[9],xmm10[10],xmm15[10],xmm10[11],xmm15[11],xmm10[12],xmm15[12],xmm10[13],xmm15[13],xmm10[14],xmm15[14],xmm10[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4],xmm10[4],xmm8[5],xmm10[5],xmm8[6],xmm10[6],xmm8[7],xmm10[7]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm15[8],xmm10[9],xmm15[9],xmm10[10],xmm15[10],xmm10[11],xmm15[11],xmm10[12],xmm15[12],xmm10[13],xmm15[13],xmm10[14],xmm15[14],xmm10[15],xmm15[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    pandn %xmm10, %xmm12
; SSE-NEXT:    movdqa %xmm10, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    por %xmm12, %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[3,3,3,3]
; SSE-NEXT:    packuswb %xmm11, %xmm10
; SSE-NEXT:    packuswb %xmm8, %xmm8
; SSE-NEXT:    movss {{.*#+}} xmm10 = xmm8[0],xmm10[1,2,3]
; SSE-NEXT:    movdqa (%rsp), %xmm8 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm8, %xmm8
; SSE-NEXT:    movdqa %xmm7, %xmm11
; SSE-NEXT:    pandn %xmm8, %xmm11
; SSE-NEXT:    pshufd $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = mem[1,3,2,3]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    # xmm12 = mem[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm8[0],xmm12[1],xmm8[1]
; SSE-NEXT:    movdqa %xmm12, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm15[0],xmm8[1],xmm15[1],xmm8[2],xmm15[2],xmm8[3],xmm15[3],xmm8[4],xmm15[4],xmm8[5],xmm15[5],xmm8[6],xmm15[6],xmm8[7],xmm15[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,65535,65535,0,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm13, %xmm14
; SSE-NEXT:    pandn %xmm8, %xmm14
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm15[8],xmm12[9],xmm15[9],xmm12[10],xmm15[10],xmm12[11],xmm15[11],xmm12[12],xmm15[12],xmm12[13],xmm15[13],xmm12[14],xmm15[14],xmm12[15],xmm15[15]
; SSE-NEXT:    pand %xmm13, %xmm12
; SSE-NEXT:    por %xmm14, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm12[2,1,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[0,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm8, %xmm12
; SSE-NEXT:    pand %xmm7, %xmm12
; SSE-NEXT:    por %xmm11, %xmm12
; SSE-NEXT:    movdqa %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm12, %xmm8
; SSE-NEXT:    andps %xmm9, %xmm10
; SSE-NEXT:    por %xmm10, %xmm8
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm15[0],xmm10[1],xmm15[1],xmm10[2],xmm15[2],xmm10[3],xmm15[3],xmm10[4],xmm15[4],xmm10[5],xmm15[5],xmm10[6],xmm15[6],xmm10[7],xmm15[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,6,4,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4],xmm11[4],xmm10[5],xmm11[5],xmm10[6],xmm11[6],xmm10[7],xmm11[7]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    pxor %xmm14, %xmm14
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pandn %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm0[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm2[3,3,3,3]
; SSE-NEXT:    packuswb %xmm12, %xmm11
; SSE-NEXT:    packuswb %xmm10, %xmm10
; SSE-NEXT:    movss {{.*#+}} xmm11 = xmm10[0],xmm11[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[1,3,2,3]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    # xmm12 = mem[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm10[0],xmm12[1],xmm10[1]
; SSE-NEXT:    movdqa %xmm12, %xmm10
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm14[0],xmm10[1],xmm14[1],xmm10[2],xmm14[2],xmm10[3],xmm14[3],xmm10[4],xmm14[4],xmm10[5],xmm14[5],xmm10[6],xmm14[6],xmm10[7],xmm14[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm14[8],xmm12[9],xmm14[9],xmm12[10],xmm14[10],xmm12[11],xmm14[11],xmm12[12],xmm14[12],xmm12[13],xmm14[13],xmm12[14],xmm14[14],xmm12[15],xmm14[15]
; SSE-NEXT:    pand %xmm13, %xmm12
; SSE-NEXT:    pandn %xmm10, %xmm13
; SSE-NEXT:    por %xmm12, %xmm13
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm13[2,1,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm10[0,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm10, %xmm10
; SSE-NEXT:    pand %xmm7, %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm12, %xmm12
; SSE-NEXT:    pandn %xmm12, %xmm7
; SSE-NEXT:    por %xmm7, %xmm10
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    andps %xmm9, %xmm11
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    movdqa %xmm4, 16(%r9)
; SSE-NEXT:    movdqa %xmm3, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm5, 16(%rax)
; SSE-NEXT:    movdqa %xmm6, (%rax)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm7, 16(%rax)
; SSE-NEXT:    movdqa %xmm8, (%rax)
; SSE-NEXT:    addq $632, %rsp # imm = 0x278
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: load_i8_stride7_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $200, %rsp
; AVX1-ONLY-NEXT:    vmovdqa 176(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm4[u,u,u,u,u,u,u],zero,zero,zero,xmm4[6,13,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa 160(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm5[u,u,u,u,u,u,u,1,8,15],zero,zero,xmm5[u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm1, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 144(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm7[u,u,u],zero,zero,xmm7[3,10,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa 128(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,u,5,12],zero,zero,xmm8[u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,0,0,0,0,255,255,255,255,255,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm15
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm2[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, %xmm10
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[0,7,14],zero,zero,xmm3[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, %xmm11
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm6[u,u,u,u,u,3,10],zero,zero,zero,xmm6[u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm9[u,u,u,u,u],zero,zero,xmm9[1,8,15,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = <255,255,255,255,255,0,0,0,0,0,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm3, %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm5[u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm5[u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm4[u,u,u,u,u,u,u],zero,zero,xmm4[0,7,14,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm7[u,u,u],zero,zero,xmm7[4,11,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm8[u,u,u,6,13],zero,zero,xmm8[u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,zero,xmm10[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm11[1,8,15],zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm1, %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm9[u,u,u,u,u],zero,zero,xmm9[2,9,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm6[u,u,u,u,u,4,11],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <255,255,255,255,255,0,0,0,0,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm7[u,u],zero,zero,zero,xmm7[5,12,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,0,7,14],zero,zero,xmm8[u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm5[u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm5[u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm4[u,u,u,u,u,u,u],zero,zero,xmm4[1,8,15,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,255,255,255,255,255,0,0,0,0,0,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm3, %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm11[2,9],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm10[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm9[u,u,u,u,u],zero,zero,xmm9[3,10,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm6[u,u,u,u,u,5,12],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm11[3,10],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm10[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm9[u,u,u,u,u],zero,zero,xmm9[4,11,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm6[u,u,u,u,u,6,13],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm7[u,u],zero,zero,zero,xmm7[6,13,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm8[u,u,1,8,15],zero,zero,xmm8[u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm1, %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm4[u,u,u,u,u,u,u],zero,zero,xmm4[2,9,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm5[u,u,u,u,u,u,u,4,11],zero,zero,xmm5[u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,255,255,255,255,255,0,0,0,0,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm3
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm8[u,u,2,9],zero,zero,zero,xmm8[u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm7[u,u],zero,zero,xmm7[0,7,14,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm4[u,u,u,u,u,u,u],zero,zero,xmm4[3,10,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm5[u,u,u,u,u,u,u,5,12],zero,zero,xmm5[u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm12, %xmm2
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm12
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm8[u,u,3,10],zero,zero,zero,xmm8[u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm7[u,u],zero,zero,xmm7[1,8,15,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm4[u,u,u,u,u,u,u],zero,zero,xmm4[4,11,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm5[u,u,u,u,u,u,u,6,13],zero,zero,xmm5[u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm13, %xmm2
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm13
; AVX1-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 208(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm1[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm1[5,12]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm2[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm14, %xmm14
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,255,255,255,255,255,255,255,255,255,0,0,0,0,0>
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm3, %xmm14, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm1[6,13]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm2[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm14, %xmm3
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm12, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm1[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm1[0,7,14]
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm12, %xmm3
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm13, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = <2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm7, %xmm3
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm7 = xmm8[u,u,4,11,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm7[0],xmm3[0],xmm7[1],xmm3[1]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u,u],zero,zero,zero,xmm4[5,12,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u,u,0,7,14],zero,zero,xmm5[u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0],xmm3[1,2],xmm4[3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = xmm1[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm1[1,8,15]
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-ONLY-NEXT:    vpblendvb %xmm0, %xmm3, %xmm4, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm10, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm1[u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm15[0,1,2,3,4,5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vpshufb %xmm9, %xmm6, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm7 = xmm8[u,u,u,u,4,11,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm0[u,u,u,u,u,u,u,u,u,u,0,1,2,3,8,15]
; AVX1-ONLY-NEXT:    vmovdqa 112(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm15 = xmm5[0,7,14,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm15 = [65535,65535,65535,65535,65535,0,0,0,0,0,65535,65535,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm3 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm15, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm12, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm15 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-ONLY-NEXT:    vandnps %ymm4, %ymm15, %ymm4
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm15, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm4, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpblendw $63, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1,2,3,4,5],xmm3[6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm8[u,u,u,u,5,12,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm6[u,u,u,u,u,0,7,14,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm14[0],xmm4[0],xmm14[1],xmm4[1]
; AVX1-ONLY-NEXT:    vpxor %xmm14, %xmm14, %xmm14
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,6],xmm14[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm7[3,10]
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm13, %xmm4
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm5[1,8,15,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm13 = [0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX1-ONLY-NEXT:    vandnps {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm3 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm13, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vandnps %ymm4, %ymm15, %ymm4
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm15, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm4, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm10, %xmm1, %xmm1
; AVX1-ONLY-NEXT:    vpshufb %xmm9, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpblendw $63, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[0,1,2,3,4,5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,u,u,u,u,u,u,u,u,u,u,6,13,u,u]
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, %xmm4
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm6[u,u,u,u,u,u,u,u,u,u,u,u,u,1,8,15]
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,6],xmm14[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm7[4,11]
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm5, %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX1-ONLY-NEXT:    vandps (%rsp), %ymm2, %ymm6 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm6, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm1 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,0,0]
; AVX1-ONLY-NEXT:    vandnps %ymm6, %ymm1, %ymm6
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm6 = xmm4[u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm4[u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm9 = xmm8[u,u,u,u,u,u,u,u,u],zero,zero,xmm8[0,7,14,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm6, %xmm9, %xmm6
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,5,6],xmm14[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm9 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm7[5,12]
; AVX1-ONLY-NEXT:    vpor %xmm6, %xmm9, %xmm6
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm10 = xmm5[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm10 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm6, %ymm2, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm10, %ymm6
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm10 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm10, %ymm1, %ymm10
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm10, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm10, %xmm6
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm15 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm15, %xmm11, %xmm13
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm13[0],xmm6[0],xmm13[1],xmm6[1],xmm13[2],xmm6[2],xmm13[3],xmm6[3]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[u,u,u,u],zero,zero,zero,xmm0[5,12,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm3[u,u,u,u,0,7,14],zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1],xmm12[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm4[u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm4[u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm8[u,u,u,u,u,u,u,u,u],zero,zero,xmm8[1,8,15,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm12, %xmm13, %xmm12
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,5,6],xmm14[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm7[6,13]
; AVX1-ONLY-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX1-ONLY-NEXT:    vpshufb %xmm15, %xmm5, %xmm13
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm2, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm12, %ymm6
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm12 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm1, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm12, %ymm6
; AVX1-ONLY-NEXT:    vmovups %ymm6, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm10[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm12 = <5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm12, %xmm11, %xmm13
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, %xmm6
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm13[0],xmm14[0],xmm13[1],xmm14[1],xmm13[2],xmm14[2],xmm13[3],xmm14[3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[u,u,u,u],zero,zero,zero,xmm0[6,13,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm3[u,u,u,u,1,8,15],zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm13, %xmm14, %xmm13
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm11[0,1],xmm13[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm8[u,u,u,u,u,u,u,u,u],zero,zero,xmm8[2,9,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm14 = xmm4[u,u,u,u,u,u,u,u,u,4,11],zero,zero,xmm4[u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm13, %xmm14, %xmm13
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm14 = <u,u,u,u,u,u,u,u,u,9,10,11,12,128,128,128>
; AVX1-ONLY-NEXT:    vpshufb %xmm14, %xmm13, %xmm13
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm7[0,7,14]
; AVX1-ONLY-NEXT:    vpor %xmm11, %xmm13, %xmm11
; AVX1-ONLY-NEXT:    vpshufb %xmm12, %xmm5, %xmm12
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm9, %ymm9
; AVX1-ONLY-NEXT:    vandnps %ymm11, %ymm2, %ymm11
; AVX1-ONLY-NEXT:    vorps %ymm11, %ymm9, %ymm9
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm9, %ymm9
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm11 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm11, %ymm1, %ymm11
; AVX1-ONLY-NEXT:    vorps %ymm11, %ymm9, %ymm9
; AVX1-ONLY-NEXT:    vpshufb %xmm15, %xmm10, %xmm10
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = <6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm6, %xmm12
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm12[0],xmm10[0],xmm12[1],xmm10[1],xmm12[2],xmm10[2],xmm12[3],xmm10[3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm3[u,u,u,u,2,9],zero,zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[u,u,u,u],zero,zero,xmm0[0,7,14,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm12, %xmm13, %xmm12
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1],xmm12[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm5, %xmm0
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u,u,u,u,u,u,u],zero,zero,xmm8[3,10,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = xmm4[u,u,u,u,u,u,u,u,u,5,12],zero,zero,xmm4[u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm5, %xmm8, %xmm5
; AVX1-ONLY-NEXT:    vpshufb %xmm14, %xmm5, %xmm5
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm7[1,8,15]
; AVX1-ONLY-NEXT:    vpor %xmm7, %xmm5, %xmm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm5, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm10, %ymm5
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm5, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%r8)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%r9)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm9, (%rax)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    addq $200, %rsp
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: load_i8_stride7_vf32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $104, %rsp
; AVX2-SLOW-NEXT:    vmovdqa 160(%rdi), %ymm5
; AVX2-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm14
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm3, %ymm4, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm7
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[5,12],zero,zero,xmm7[1,8,15,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm7, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm14, %ymm2, %ymm7
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, %ymm13
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0,1],ymm8[2],ymm7[3,4],ymm8[5],ymm7[6,7,8,9],ymm8[10],ymm7[11,12],ymm8[13],ymm7[14,15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = <255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm0, %ymm7, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm5, %ymm6, %ymm7
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u],zero,zero,xmm8[3,10],zero,zero,zero,xmm8[6,13,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,5,12],zero,zero,xmm7[1,8,15],zero,zero,xmm7[u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm3, %ymm4, %ymm8
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm9
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm9[6,13],zero,zero,xmm9[2,9,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[1,8,15],zero,zero,xmm8[4,11],zero,zero,xmm8[u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm2, %ymm14, %ymm9
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm9[0,1],ymm10[2],ymm9[3,4,5],ymm10[6],ymm9[7,8,9],ymm10[10],ymm9[11,12,13],ymm10[14],ymm9[15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = <0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm9, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm10
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm10[u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vmovdqa 208(%rdi), %xmm11
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm11[u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm9[0],xmm12[0],xmm9[1],xmm12[1],xmm9[2],xmm12[2],xmm9[3],xmm12[3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5,6],ymm9[7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm0, %ymm7, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm5, %ymm6, %ymm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero,xmm0[u,u,u,u]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm7, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm11[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm10[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm12[0],xmm7[0],xmm12[1],xmm7[1],xmm12[2],xmm7[2],xmm12[3],xmm7[3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm7[7]
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm8, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm6, %ymm5, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm7
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u],zero,zero,zero,xmm7[6,13],zero,zero,xmm7[2,9,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm7, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm11[5,12]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm10[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX2-SLOW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm8
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX2-SLOW-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm8, %ymm7, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm6, %ymm5, %ymm7
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[u,u,2,9],zero,zero,zero,xmm7[5,12],zero,zero,xmm7[u,u,u,u,u]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u],zero,zero,xmm7[0,7,14],zero,zero,xmm7[3,10,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm11[6,13]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm10[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX2-SLOW-NEXT:    vpor %xmm8, %xmm12, %xmm8
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm7, %ymm8, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm6, %ymm5, %ymm8
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm8[u,u,3,10],zero,zero,zero,xmm8[6,13],zero,zero,xmm8[u,u,u,u,u]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u],zero,zero,xmm8[1,8,15],zero,zero,xmm8[4,11,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm0, %xmm8, %xmm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm10[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm11[0,7,14]
; AVX2-SLOW-NEXT:    vpor %xmm8, %xmm13, %xmm8
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm0, %ymm8, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm6, %ymm5, %ymm13
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = <255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm5, %ymm6, %ymm5
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u],zero,zero,xmm6[2,9],zero,zero,zero,xmm6[5,12,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,4,11],zero,zero,xmm5[0,7,14],zero,zero,xmm5[u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm10[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm11[1,8,15]
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm15, %xmm6
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm5, %ymm6, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm4, %ymm3, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm3, %ymm4, %ymm6
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm3, %ymm4, %ymm15
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm4, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm4, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vmovdqu (%rsp), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm0, %ymm14, %ymm4
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm0, %ymm14, %ymm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm0, %ymm14, %ymm9
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm14, %ymm0, %ymm7
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm14, %ymm0, %ymm8
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm6[2,9],zero,zero,zero,xmm6[5,12],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[0,7,14],zero,zero,xmm6[3,10,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm14, %xmm6
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm14
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1,2],ymm14[3],ymm4[4,5],ymm14[6],ymm4[7,8,9,10],ymm14[11],ymm4[12,13],ymm14[14],ymm4[15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,18,25,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm14 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm6, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm15[3,10],zero,zero,zero,xmm15[6,13],zero,zero,xmm15[u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm15, %xmm15
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,xmm15[1,8,15],zero,zero,xmm15[4,11,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm15, %xmm6
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm15
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm15[0],ymm1[1,2],ymm15[3],ymm1[4,5,6],ymm15[7,8],ymm1[9,10],ymm15[11],ymm1[12,13,14],ymm15[15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,19,26,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm6, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm6
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[2,9],zero,zero,zero,xmm6[5,12,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[4,11],zero,zero,xmm2[0,7,14],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm9, %xmm6
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0],ymm9[1,2,3],ymm6[4],ymm9[5,6],ymm6[7,8],ymm9[9,10,11],ymm6[12],ymm9[13,14],ymm6[15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,20,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm1, %ymm6, %ymm1
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm6
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[3,10],zero,zero,zero,xmm6[6,13,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[5,12],zero,zero,xmm3[1,8,15],zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm6
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2,3],ymm6[4],ymm7[5,6,7,8],ymm6[9],ymm7[10,11],ymm6[12],ymm7[13,14,15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,21,28,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm3, %ymm6, %ymm3
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[6,13],zero,zero,xmm5[2,9],zero,zero,zero,xmm5[u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm5[4,11],zero,zero,xmm5[0,7,14,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm6
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm8[0],ymm6[1],ymm8[2,3,4],ymm6[5],ymm8[6,7,8],ymm6[9],ymm8[10,11,12],ymm6[13],ymm8[14,15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,22,29,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm5, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm5
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u],zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm13[u,u,0,7,14],zero,zero,xmm13[3,10],zero,zero,zero,xmm13[u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm11[u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm10[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5,6],ymm6[7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm4[0],ymm5[1,2,3,4,5,6,7],ymm4[8],ymm5[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm5 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm5 = ymm0[0],mem[1,2,3,4,5,6,7],ymm0[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm5 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm5 = ymm1[0],mem[1,2,3,4,5,6,7],ymm1[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm5[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm5 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm5 = ymm3[0],mem[1,2,3,4,5,6,7],ymm3[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm5[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm5 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm5 = ymm2[0],mem[1,2,3,4,5,6,7],ymm2[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm5[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm5, (%rsi)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm5, (%rdx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, (%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, (%rax)
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, (%rax)
; AVX2-SLOW-NEXT:    addq $104, %rsp
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: load_i8_stride7_vf32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    pushq %rax
; AVX2-FAST-NEXT:    vmovdqa 192(%rdi), %ymm9
; AVX2-FAST-NEXT:    vmovdqa 160(%rdi), %ymm6
; AVX2-FAST-NEXT:    vmovdqa 128(%rdi), %ymm7
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm4, %ymm5, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm13
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[5,12],zero,zero,xmm1[1,8,15,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm3, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa %ymm8, %ymm10
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm8
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm8[2],ymm1[3,4],ymm8[5],ymm1[6,7,8,9],ymm8[10],ymm1[11,12],ymm8[13],ymm1[14,15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = <255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm6, %ymm7, %ymm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u],zero,zero,xmm8[3,10],zero,zero,zero,xmm8[6,13,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,5,12],zero,zero,xmm1[1,8,15],zero,zero,xmm1[u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm8, %xmm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = <u,u,u,u,1,2,4,6>
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vmovdqa %ymm9, %ymm11
; AVX2-FAST-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,23,26,29]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5,6],ymm8[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm4, %ymm5, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm12
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[6,13],zero,zero,xmm1[2,9,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm2, %ymm3, %ymm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm9
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm9[2],ymm1[3,4,5],ymm9[6],ymm1[7,8,9],ymm9[10],ymm1[11,12,13],ymm9[14],ymm1[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm6, %ymm7, %ymm1
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = xmm1[u,u,u,6,13],zero,zero,xmm1[2,9],zero,zero,zero,xmm1[u,u,u,u]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u],zero,zero,xmm1[4,11],zero,zero,xmm1[0,7,14,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm9, %xmm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,u,u,1,3,4,6>
; AVX2-FAST-NEXT:    vpermd %ymm11, %ymm9, %ymm9
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,17,20,27,30]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5,6],ymm9[7]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm7, %ymm6, %ymm0
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u],zero,zero,zero,xmm1[6,13],zero,zero,xmm1[2,9,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm0, %xmm1
; AVX2-FAST-NEXT:    vmovdqa 208(%rdi), %xmm15
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = xmm15[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm15[5,12]
; AVX2-FAST-NEXT:    vmovdqa 192(%rdi), %xmm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = xmm0[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX2-FAST-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm9
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX2-FAST-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm9, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm7, %ymm6, %ymm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = xmm8[u,u,2,9],zero,zero,zero,xmm8[5,12],zero,zero,xmm8[u,u,u,u,u]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u],zero,zero,xmm8[0,7,14],zero,zero,xmm8[3,10,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = xmm15[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm15[6,13]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm10 = xmm0[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX2-FAST-NEXT:    vpor %xmm9, %xmm10, %xmm9
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm8, %ymm9, %ymm14
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm7, %ymm6, %ymm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm10 = xmm8[u,u,3,10],zero,zero,zero,xmm8[6,13],zero,zero,xmm8[u,u,u,u,u]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u],zero,zero,xmm8[1,8,15],zero,zero,xmm8[4,11,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm10, %xmm8, %xmm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm10 = xmm0[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm15[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm15[0,7,14]
; AVX2-FAST-NEXT:    vpor %xmm10, %xmm13, %xmm10
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm8, %ymm10, %ymm12
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm7, %ymm6, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm6, %ymm7, %ymm6
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u],zero,zero,xmm7[2,9],zero,zero,zero,xmm7[5,12,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,4,11],zero,zero,xmm6[0,7,14],zero,zero,xmm6[u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm15[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm15[1,8,15]
; AVX2-FAST-NEXT:    vpor %xmm0, %xmm7, %xmm0
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm6, %ymm0, %ymm10
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm0, %ymm5, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm4, %ymm5, %ymm6
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm4, %ymm5, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm5, %ymm4, %ymm15
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm0, %ymm5, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm2, %ymm3, %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm2, %ymm3, %ymm11
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm2, %ymm3, %ymm9
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm3, %ymm2, %ymm13
; AVX2-FAST-NEXT:    vpblendvb %ymm0, %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm6[2,9],zero,zero,zero,xmm6[5,12],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[0,7,14],zero,zero,xmm6[3,10,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm3, %xmm6, %xmm3
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1,2],ymm6[3],ymm5[4,5],ymm6[6],ymm5[7,8,9,10],ymm6[11],ymm5[12,13],ymm6[14],ymm5[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,18,25,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm3, %ymm5, %ymm3
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm7[3,10],zero,zero,zero,xmm7[6,13],zero,zero,xmm7[u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,xmm7[1,8,15],zero,zero,xmm7[4,11,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm5, %xmm7, %xmm5
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm7
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0],ymm11[1,2],ymm7[3],ymm11[4,5,6],ymm7[7,8],ymm11[9,10],ymm7[11],ymm11[12,13,14],ymm7[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,19,26,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm5, %ymm7, %ymm5
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm15, %xmm7
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,xmm7[2,9],zero,zero,zero,xmm7[5,12,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm15[4,11],zero,zero,xmm15[0,7,14],zero,zero,xmm15[u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm7, %xmm11, %xmm7
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm9, %xmm11
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm9 = ymm11[0],ymm9[1,2,3],ymm11[4],ymm9[5,6],ymm11[7,8],ymm9[9,10,11],ymm11[12],ymm9[13,14],ymm11[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,20,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm7, %ymm9, %ymm7
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm9
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,xmm9[3,10],zero,zero,zero,xmm9[6,13,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[5,12],zero,zero,xmm4[1,8,15],zero,zero,xmm4[u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm4, %xmm9, %xmm4
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm9
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm9 = ymm13[0],ymm9[1],ymm13[2,3],ymm9[4],ymm13[5,6,7,8],ymm9[9],ymm13[10,11],ymm9[12],ymm13[13,14,15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,21,28,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm4, %ymm9, %ymm4
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = xmm1[6,13],zero,zero,xmm1[2,9],zero,zero,zero,xmm1[u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[4,11],zero,zero,xmm1[0,7,14,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm9, %xmm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm9
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm9[1],ymm2[2,3,4],ymm9[5],ymm2[6,7,8],ymm9[9],ymm2[10,11,12],ymm9[13],ymm2[14,15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,22,29,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm8, %xmm2
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[1,8,15,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm8[u,u,0,7,14],zero,zero,xmm8[3,10],zero,zero,zero,xmm8[u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,u,u,1,3,5,6>
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm6 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,21,24,31]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm6[7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0],ymm2[1,2,3,4,5,6,7],ymm3[8],ymm2[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm3 = ymm5[0],mem[1,2,3,4,5,6,7],ymm5[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm7[0],ymm14[1,2,3,4,5,6,7],ymm7[8],ymm14[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm7[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm4[0],ymm12[1,2,3,4,5,6,7],ymm4[8],ymm12[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm10[1,2,3,4,5,6,7],ymm1[8],ymm10[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, (%r8)
; AVX2-FAST-NEXT:    vmovdqa %ymm5, (%r9)
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa %ymm4, (%rax)
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-FAST-NEXT:    popq %rax
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: load_i8_stride7_vf32:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $104, %rsp
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%rdi), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm3, %ymm4, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[5,12],zero,zero,xmm7[1,8,15,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm7, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm1 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm14, %ymm2, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0,1],ymm8[2],ymm7[3,4],ymm8[5],ymm7[6,7,8,9],ymm8[10],ymm7[11,12],ymm8[13],ymm7[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = <255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm0, %ymm7, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm5, %ymm6, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u],zero,zero,xmm8[3,10],zero,zero,zero,xmm8[6,13,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,5,12],zero,zero,xmm7[1,8,15],zero,zero,xmm7[u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm3, %ymm4, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm8, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm9[6,13],zero,zero,xmm9[2,9,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[1,8,15],zero,zero,xmm8[4,11],zero,zero,xmm8[u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm2, %ymm14, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm9 = ymm9[0,1],ymm10[2],ymm9[3,4,5],ymm10[6],ymm9[7,8,9],ymm10[10],ymm9[11,12,13],ymm10[14],ymm9[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = <0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm9, %ymm8, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%rdi), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm9 = xmm10[u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 208(%rdi), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm12 = xmm11[u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm9[0],xmm12[0],xmm9[1],xmm12[1],xmm9[2],xmm12[2],xmm9[3],xmm12[3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5,6],ymm9[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm0, %ymm7, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm5, %ymm6, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero,xmm0[u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm7, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm7 = xmm11[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm12 = xmm10[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm12[0],xmm7[0],xmm12[1],xmm7[1],xmm12[2],xmm7[2],xmm12[3],xmm7[3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm7[7]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm8, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm6, %ymm5, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u],zero,zero,zero,xmm7[6,13],zero,zero,xmm7[2,9,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm7, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm7 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm11[5,12]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm8 = xmm10[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX2-FAST-PERLANE-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm8, %ymm7, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm6, %ymm5, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[u,u,2,9],zero,zero,zero,xmm7[5,12],zero,zero,xmm7[u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u],zero,zero,xmm7[0,7,14],zero,zero,xmm7[3,10,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm8 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm11[6,13]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm12 = xmm10[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm8, %xmm12, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm7, %ymm8, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm6, %ymm5, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm8[u,u,3,10],zero,zero,zero,xmm8[6,13],zero,zero,xmm8[u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u],zero,zero,xmm8[1,8,15],zero,zero,xmm8[4,11,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm0, %xmm8, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm8 = xmm10[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm13 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm11[0,7,14]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm8, %xmm13, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm0, %ymm8, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm6, %ymm5, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = <255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm5, %ymm6, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u],zero,zero,xmm6[2,9],zero,zero,zero,xmm6[5,12,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,4,11],zero,zero,xmm5[0,7,14],zero,zero,xmm5[u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = xmm10[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm15 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm11[1,8,15]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm15, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm5, %ymm6, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm4, %ymm3, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm3, %ymm4, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm3, %ymm4, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm4, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm4, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqu (%rsp), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm0, %ymm14, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm14, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm0, %ymm14, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm14, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm14, %ymm0, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm14 = xmm6[2,9],zero,zero,zero,xmm6[5,12],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[0,7,14],zero,zero,xmm6[3,10,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm14, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm4, %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1,2],ymm14[3],ymm4[4,5],ymm14[6],ymm4[7,8,9,10],ymm14[11],ymm4[12,13],ymm14[14],ymm4[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,18,25,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm14 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm6, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = xmm15[3,10],zero,zero,zero,xmm15[6,13],zero,zero,xmm15[u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm15, %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,xmm15[1,8,15],zero,zero,xmm15[4,11,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm15, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm1, %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm15[0],ymm1[1,2],ymm15[3],ymm1[4,5,6],ymm15[7,8],ymm1[9,10],ymm15[11],ymm1[12,13,14],ymm15[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,19,26,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm6, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm2, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[2,9],zero,zero,zero,xmm6[5,12,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[4,11],zero,zero,xmm2[0,7,14],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm9, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0],ymm9[1,2,3],ymm6[4],ymm9[5,6],ymm6[7,8],ymm9[9,10,11],ymm6[12],ymm9[13,14],ymm6[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,20,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm1, %ymm6, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm3, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[3,10],zero,zero,zero,xmm6[6,13,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[5,12],zero,zero,xmm3[1,8,15],zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm7, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2,3],ymm6[4],ymm7[5,6,7,8],ymm6[9],ymm7[10,11],ymm6[12],ymm7[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,21,28,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm3, %ymm6, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[6,13],zero,zero,xmm5[2,9],zero,zero,zero,xmm5[u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm5[4,11],zero,zero,xmm5[0,7,14,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm8, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm8[0],ymm6[1],ymm8[2,3,4],ymm6[5],ymm8[6,7,8],ymm6[9],ymm8[10,11,12],ymm6[13],ymm8[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,22,29,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm5, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm13, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u],zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = xmm13[u,u,0,7,14],zero,zero,xmm13[3,10],zero,zero,zero,xmm13[u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = xmm11[u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm7 = xmm10[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5,6],ymm6[7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm4[0],ymm5[1,2,3,4,5,6,7],ymm4[8],ymm5[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm5 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm5 = ymm0[0],mem[1,2,3,4,5,6,7],ymm0[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm5 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm5 = ymm1[0],mem[1,2,3,4,5,6,7],ymm1[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm5 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm5 = ymm3[0],mem[1,2,3,4,5,6,7],ymm3[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm5 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm5 = ymm2[0],mem[1,2,3,4,5,6,7],ymm2[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm5, (%rsi)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm5, (%rdx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, (%rax)
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, (%rax)
; AVX2-FAST-PERLANE-NEXT:    addq $104, %rsp
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: load_i8_stride7_vf32:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535]
; AVX512F-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa 160(%rdi), %ymm3
; AVX512F-SLOW-NEXT:    vmovdqa %ymm0, %ymm1
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm2, %ymm3, %ymm1
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u],zero,zero,xmm4[3,10],zero,zero,zero,xmm4[6,13,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,5,12],zero,zero,xmm1[1,8,15],zero,zero,xmm1[u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm4, %xmm1, %xmm1
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm4
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX512F-SLOW-NEXT:    vpshufb %xmm5, %xmm4, %xmm6
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm5, %xmm20
; AVX512F-SLOW-NEXT:    vmovdqa 208(%rdi), %xmm5
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm5[u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm1[0,1,2,3,4,5,6],ymm6[7]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = [65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0]
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm7
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa %ymm14, %ymm9
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm7, %ymm6, %ymm9
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[5,12],zero,zero,xmm10[1,8,15,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[0,7,14],zero,zero,xmm9[3,10],zero,zero,zero,xmm9[u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm10, %xmm9, %xmm13
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535]
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm9
; AVX512F-SLOW-NEXT:    vmovdqa %ymm11, %ymm15
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm1, %ymm9, %ymm15
; AVX512F-SLOW-NEXT:    vmovdqa 80(%rdi), %xmm10
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm15 = ymm15[0,1],ymm10[2],ymm15[3,4],ymm10[5],ymm15[6,7,8,9],ymm10[10],ymm15[11,12],ymm10[13],ymm15[14,15]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm8 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm15[6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm13, %ymm8
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm16 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %ymm12, %ymm16, %ymm8
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm8, %ymm18
; AVX512F-SLOW-NEXT:    vmovdqa %ymm11, %ymm12
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm2, %ymm3, %ymm12
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm12[u,u,u,6,13],zero,zero,xmm12[2,9],zero,zero,zero,xmm12[u,u,u,u]
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm12, %xmm12
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u,u],zero,zero,xmm12[4,11],zero,zero,xmm12[0,7,14,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm5[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm4[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm13[0],xmm8[1],xmm13[1],xmm8[2],xmm13[2],xmm8[3],xmm13[3]
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm12[0,1,2,3,4,5,6],ymm8[7]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = [65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vmovdqa %ymm13, %ymm12
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm7, %ymm6, %ymm12
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm12, %xmm15
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,zero,xmm15[6,13],zero,zero,xmm15[2,9,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[1,8,15],zero,zero,xmm12[4,11],zero,zero,xmm12[u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm15, %xmm12, %xmm15
; AVX512F-SLOW-NEXT:    vmovdqa %ymm14, %ymm12
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm9, %ymm1, %ymm12
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm12[0,1],ymm10[2],ymm12[3,4,5],ymm10[6],ymm12[7,8,9],ymm10[10],ymm12[11,12,13],ymm10[14],ymm12[15]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm12 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm12[0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm15, %ymm12
; AVX512F-SLOW-NEXT:    vpternlogq $226, %ymm8, %ymm16, %ymm12
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm12, %ymm19
; AVX512F-SLOW-NEXT:    vmovdqa %ymm0, %ymm8
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm7, %ymm6, %ymm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm8[2,9],zero,zero,zero,xmm8[5,12],zero,zero,xmm8[u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm8[0,7,14],zero,zero,xmm8[3,10,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm15, %xmm8, %xmm8
; AVX512F-SLOW-NEXT:    vmovdqa %ymm13, %ymm15
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm9, %ymm1, %ymm15
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm15 = ymm15[0,1,2],ymm10[3],ymm15[4,5],ymm10[6],ymm15[7,8,9,10],ymm10[11],ymm15[12,13],ymm10[14],ymm15[15]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm15 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm15[1,8,15,6,13,4,11,18,25],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm17 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-SLOW-NEXT:    vpternlogq $248, %ymm17, %ymm8, %ymm15
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm3, %ymm2, %ymm14
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm14, %xmm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u],zero,zero,zero,xmm8[5,12],zero,zero,xmm8[1,8,15,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,0,7,14],zero,zero,xmm14[3,10],zero,zero,zero,xmm14[u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm8, %xmm14, %xmm8
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm20, %xmm12
; AVX512F-SLOW-NEXT:    vpshufb %xmm12, %xmm5, %xmm14
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm4[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm12[0],xmm14[0],xmm12[1],xmm14[1],xmm12[2],xmm14[2],xmm12[3],xmm14[3]
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5,6],ymm12[7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm15[0],ymm8[1,2,3,4,5,6,7],ymm15[8],ymm8[9,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm15[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm8, %ymm20
; AVX512F-SLOW-NEXT:    vmovdqa %ymm13, %ymm8
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm3, %ymm2, %ymm8
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm12
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u],zero,zero,zero,xmm12[6,13],zero,zero,xmm12[2,9,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,1,8,15],zero,zero,xmm8[4,11],zero,zero,xmm8[u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm12, %xmm8, %xmm8
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm5[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm5[5,12]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm4[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512F-SLOW-NEXT:    vpor %xmm12, %xmm14, %xmm12
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm16 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %ymm8, %ymm16, %ymm12
; AVX512F-SLOW-NEXT:    vmovdqa %ymm11, %ymm8
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm7, %ymm6, %ymm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm8[3,10],zero,zero,zero,xmm8[6,13],zero,zero,xmm8[u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm8[1,8,15],zero,zero,xmm8[4,11,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm14, %xmm8, %xmm8
; AVX512F-SLOW-NEXT:    vmovdqa %ymm0, %ymm14
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm9, %ymm1, %ymm14
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm14 = ymm10[0],ymm14[1,2],ymm10[3],ymm14[4,5,6],ymm10[7,8],ymm14[9,10],ymm10[11],ymm14[12,13,14],ymm10[15]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm14 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm14[2,9,0,7,14,5,12,19,26],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vpternlogq $248, %ymm17, %ymm8, %ymm14
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm14[0],ymm12[1,2,3,4,5,6,7],ymm14[8],ymm12[9,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm14[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm8, %ymm21
; AVX512F-SLOW-NEXT:    vmovdqa %ymm0, %ymm8
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm3, %ymm2, %ymm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,2,9],zero,zero,zero,xmm8[5,12],zero,zero,xmm8[u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u],zero,zero,xmm8[0,7,14],zero,zero,xmm8[3,10,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm12, %xmm8, %xmm8
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm5[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm5[6,13]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm4[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512F-SLOW-NEXT:    vpor %xmm12, %xmm14, %xmm12
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512F-SLOW-NEXT:    vpternlogq $184, %ymm8, %ymm16, %ymm12
; AVX512F-SLOW-NEXT:    vmovdqa %ymm13, %ymm8
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm6, %ymm7, %ymm8
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm14
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,xmm14[2,9],zero,zero,zero,xmm14[5,12,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[4,11],zero,zero,xmm8[0,7,14],zero,zero,xmm8[u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm14, %xmm8, %xmm8
; AVX512F-SLOW-NEXT:    vmovdqa %ymm11, %ymm14
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm9, %ymm1, %ymm14
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm14 = ymm10[0],ymm14[1,2,3],ymm10[4],ymm14[5,6],ymm10[7,8],ymm14[9,10,11],ymm10[12],ymm14[13,14],ymm10[15]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm14 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm14[3,10,1,8,15,6,13,20,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vpternlogq $248, %ymm17, %ymm8, %ymm14
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm14[0],ymm12[1,2,3,4,5,6,7],ymm14[8],ymm12[9,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa %ymm11, %ymm8
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm3, %ymm2, %ymm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,3,10],zero,zero,zero,xmm8[6,13],zero,zero,xmm8[u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u],zero,zero,xmm8[1,8,15],zero,zero,xmm8[4,11,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm12, %xmm8, %xmm8
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm4[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm5[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm5[0,7,14]
; AVX512F-SLOW-NEXT:    vpor %xmm12, %xmm15, %xmm12
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512F-SLOW-NEXT:    vpternlogq $184, %ymm8, %ymm16, %ymm12
; AVX512F-SLOW-NEXT:    vmovdqa %ymm0, %ymm8
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm6, %ymm7, %ymm8
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm15
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,xmm15[3,10],zero,zero,zero,xmm15[6,13,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[5,12],zero,zero,xmm8[1,8,15],zero,zero,xmm8[u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm15, %xmm8, %xmm8
; AVX512F-SLOW-NEXT:    vmovdqa %ymm13, %ymm15
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm1, %ymm9, %ymm15
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm15 = ymm15[0],ymm10[1],ymm15[2,3],ymm10[4],ymm15[5,6,7,8],ymm10[9],ymm15[10,11],ymm10[12],ymm15[13,14,15]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm15 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm15[4,11,2,9,0,7,14,21,28],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vpternlogq $248, %ymm17, %ymm8, %ymm15
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm15[0],ymm12[1,2,3,4,5,6,7],ymm15[8],ymm12[9,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm15[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm2, %ymm3, %ymm13
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm2
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[5,12,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm13[u,u,4,11],zero,zero,xmm13[0,7,14],zero,zero,xmm13[u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm4[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm5[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm5[1,8,15]
; AVX512F-SLOW-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-SLOW-NEXT:    vpternlogq $184, %ymm2, %ymm16, %ymm3
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm6, %ymm7, %ymm11
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm11[6,13],zero,zero,xmm11[2,9],zero,zero,zero,xmm11[u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm4
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,xmm4[4,11],zero,zero,xmm4[0,7,14,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %xmm2, %xmm4, %xmm2
; AVX512F-SLOW-NEXT:    vpternlogq $202, %ymm1, %ymm9, %ymm0
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm10[1],ymm0[2,3,4],ymm10[5],ymm0[6,7,8],ymm10[9],ymm0[10,11,12],ymm10[13],ymm0[14,15]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm0[5,12,3,10,1,8,15,22,29],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vpternlogq $248, %ymm17, %ymm2, %ymm0
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm0[0],ymm3[1,2,3,4,5,6,7],ymm0[8],ymm3[9,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm18, (%rsi)
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm19, (%rdx)
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm20, (%rcx)
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm21, (%r8)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm14, (%r9)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm8, (%r10)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: load_i8_stride7_vf32:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535]
; AVX512F-FAST-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512F-FAST-NEXT:    vmovdqa 160(%rdi), %ymm3
; AVX512F-FAST-NEXT:    vmovdqa %ymm0, %ymm1
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm2, %ymm3, %ymm1
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u],zero,zero,xmm4[3,10],zero,zero,zero,xmm4[6,13,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,5,12],zero,zero,xmm1[1,8,15],zero,zero,xmm1[u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm4, %xmm1, %xmm1
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,u,u,1,2,4,6>
; AVX512F-FAST-NEXT:    vmovdqa 192(%rdi), %ymm12
; AVX512F-FAST-NEXT:    vpermd %ymm12, %ymm4, %ymm4
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,23,26,29]
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm1[0,1,2,3,4,5,6],ymm4[7]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = [65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0]
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %ymm4
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512F-FAST-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512F-FAST-NEXT:    vmovdqa %ymm13, %ymm7
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm7
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm8[5,12],zero,zero,xmm8[1,8,15,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[0,7,14],zero,zero,xmm7[3,10],zero,zero,zero,xmm7[u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm7, %xmm8, %xmm10
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535]
; AVX512F-FAST-NEXT:    vmovdqa 96(%rdi), %ymm7
; AVX512F-FAST-NEXT:    vmovdqa %ymm9, %ymm11
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm1, %ymm7, %ymm11
; AVX512F-FAST-NEXT:    vmovdqa 80(%rdi), %xmm8
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm11 = ymm11[0,1],ymm8[2],ymm11[3,4],ymm8[5],ymm11[6,7,8,9],ymm8[10],ymm11[11,12],ymm8[13],ymm11[14,15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm11[6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm10, %ymm11
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm16 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512F-FAST-NEXT:    vpternlogq $226, %ymm6, %ymm16, %ymm11
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm11, %ymm18
; AVX512F-FAST-NEXT:    vmovdqa %ymm9, %ymm6
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm2, %ymm3, %ymm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm10 = xmm6[u,u,u,6,13],zero,zero,xmm6[2,9],zero,zero,zero,xmm6[u,u,u,u]
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u],zero,zero,xmm6[4,11],zero,zero,xmm6[0,7,14,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm6, %xmm10, %xmm6
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = <u,u,u,u,1,3,4,6>
; AVX512F-FAST-NEXT:    vpermd %ymm12, %ymm10, %ymm10
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,17,20,27,30]
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5,6],ymm10[7]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = [65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535]
; AVX512F-FAST-NEXT:    vmovdqa %ymm11, %ymm10
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm10
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm14
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm14[6,13],zero,zero,xmm14[2,9,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[1,8,15],zero,zero,xmm10[4,11],zero,zero,xmm10[u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm14, %xmm10, %xmm14
; AVX512F-FAST-NEXT:    vmovdqa %ymm13, %ymm10
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm7, %ymm1, %ymm10
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm10 = ymm10[0,1],ymm8[2],ymm10[3,4,5],ymm8[6],ymm10[7,8,9],ymm8[10],ymm10[11,12,13],ymm8[14],ymm10[15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm10 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm10[0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm14, %ymm10
; AVX512F-FAST-NEXT:    vpternlogq $226, %ymm6, %ymm16, %ymm10
; AVX512F-FAST-NEXT:    vmovdqa %ymm0, %ymm6
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm6[2,9],zero,zero,zero,xmm6[5,12],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[0,7,14],zero,zero,xmm6[3,10,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm6, %xmm14, %xmm6
; AVX512F-FAST-NEXT:    vmovdqa %ymm11, %ymm14
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm7, %ymm1, %ymm14
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm14 = ymm14[0,1,2],ymm8[3],ymm14[4,5],ymm8[6],ymm14[7,8,9,10],ymm8[11],ymm14[12,13],ymm8[14],ymm14[15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm14 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm14[1,8,15,6,13,4,11,18,25],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm17 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-FAST-NEXT:    vpternlogq $248, %ymm17, %ymm6, %ymm14
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm3, %ymm2, %ymm13
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u],zero,zero,zero,xmm6[5,12],zero,zero,xmm6[1,8,15,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,0,7,14],zero,zero,xmm13[3,10],zero,zero,zero,xmm13[u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm6, %xmm13, %xmm6
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,u,u,1,3,5,6>
; AVX512F-FAST-NEXT:    vpermd %ymm12, %ymm13, %ymm12
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,21,24,31]
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5,6],ymm12[7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm14[0],ymm6[1,2,3,4,5,6,7],ymm14[8],ymm6[9,10,11,12,13,14,15]
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm14[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm6, %ymm19
; AVX512F-FAST-NEXT:    vmovdqa %ymm11, %ymm6
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm3, %ymm2, %ymm6
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm12
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u],zero,zero,zero,xmm12[6,13],zero,zero,xmm12[2,9,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,1,8,15],zero,zero,xmm6[4,11],zero,zero,xmm6[u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm6, %xmm12, %xmm6
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512F-FAST-NEXT:    vmovdqa 208(%rdi), %xmm14
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm14[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm14[5,12]
; AVX512F-FAST-NEXT:    vmovdqa 192(%rdi), %xmm12
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm12[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512F-FAST-NEXT:    vpor %xmm13, %xmm15, %xmm13
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm16 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX512F-FAST-NEXT:    vpternlogq $184, %ymm6, %ymm16, %ymm13
; AVX512F-FAST-NEXT:    vmovdqa %ymm9, %ymm6
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm6[3,10],zero,zero,zero,xmm6[6,13],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm6[1,8,15],zero,zero,xmm6[4,11,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm6, %xmm15, %xmm6
; AVX512F-FAST-NEXT:    vmovdqa %ymm0, %ymm15
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm7, %ymm1, %ymm15
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm15 = ymm8[0],ymm15[1,2],ymm8[3],ymm15[4,5,6],ymm8[7,8],ymm15[9,10],ymm8[11],ymm15[12,13,14],ymm8[15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm15 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm15[2,9,0,7,14,5,12,19,26],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vpternlogq $248, %ymm17, %ymm6, %ymm15
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm15[0],ymm13[1,2,3,4,5,6,7],ymm15[8],ymm13[9,10,11,12,13,14,15]
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm15[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm6, %ymm20
; AVX512F-FAST-NEXT:    vmovdqa %ymm0, %ymm6
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm3, %ymm2, %ymm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm6[u,u,2,9],zero,zero,zero,xmm6[5,12],zero,zero,xmm6[u,u,u,u,u]
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u],zero,zero,xmm6[0,7,14],zero,zero,xmm6[3,10,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm6, %xmm13, %xmm6
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm14[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm14[6,13]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm12[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512F-FAST-NEXT:    vpor %xmm13, %xmm15, %xmm13
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX512F-FAST-NEXT:    vpternlogq $184, %ymm6, %ymm16, %ymm13
; AVX512F-FAST-NEXT:    vmovdqa %ymm11, %ymm6
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm6
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm15
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,xmm15[2,9],zero,zero,zero,xmm15[5,12,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[4,11],zero,zero,xmm6[0,7,14],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm6, %xmm15, %xmm6
; AVX512F-FAST-NEXT:    vmovdqa %ymm9, %ymm15
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm7, %ymm1, %ymm15
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm15 = ymm8[0],ymm15[1,2,3],ymm8[4],ymm15[5,6],ymm8[7,8],ymm15[9,10,11],ymm8[12],ymm15[13,14],ymm8[15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm15 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm15[3,10,1,8,15,6,13,20,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vpternlogq $248, %ymm17, %ymm6, %ymm15
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm15[0],ymm13[1,2,3,4,5,6,7],ymm15[8],ymm13[9,10,11,12,13,14,15]
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm15[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm6, %ymm21
; AVX512F-FAST-NEXT:    vmovdqa %ymm9, %ymm6
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm3, %ymm2, %ymm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm6[u,u,3,10],zero,zero,zero,xmm6[6,13],zero,zero,xmm6[u,u,u,u,u]
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u],zero,zero,xmm6[1,8,15],zero,zero,xmm6[4,11,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm6, %xmm15, %xmm6
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm12[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm14[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm14[0,7,14]
; AVX512F-FAST-NEXT:    vpor %xmm15, %xmm13, %xmm13
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX512F-FAST-NEXT:    vpternlogq $184, %ymm6, %ymm16, %ymm13
; AVX512F-FAST-NEXT:    vmovdqa %ymm0, %ymm6
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm6
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm15
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,xmm15[3,10],zero,zero,zero,xmm15[6,13,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[5,12],zero,zero,xmm6[1,8,15],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm6, %xmm15, %xmm6
; AVX512F-FAST-NEXT:    vmovdqa %ymm11, %ymm15
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm1, %ymm7, %ymm15
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm15 = ymm15[0],ymm8[1],ymm15[2,3],ymm8[4],ymm15[5,6,7,8],ymm8[9],ymm15[10,11],ymm8[12],ymm15[13,14,15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm15 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm15[4,11,2,9,0,7,14,21,28],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vpternlogq $248, %ymm17, %ymm6, %ymm15
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm15[0],ymm13[1,2,3,4,5,6,7],ymm15[8],ymm13[9,10,11,12,13,14,15]
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm15[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm2, %ymm3, %ymm11
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm2
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[5,12,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[u,u,4,11],zero,zero,xmm11[0,7,14],zero,zero,xmm11[u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm12[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm14[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm14[1,8,15]
; AVX512F-FAST-NEXT:    vpor %xmm3, %xmm11, %xmm3
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-FAST-NEXT:    vpternlogq $184, %ymm2, %ymm16, %ymm3
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm9
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm9[6,13],zero,zero,xmm9[2,9],zero,zero,zero,xmm9[u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vextracti128 $1, %ymm9, %xmm4
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,xmm4[4,11],zero,zero,xmm4[0,7,14,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %xmm2, %xmm4, %xmm2
; AVX512F-FAST-NEXT:    vpternlogq $202, %ymm1, %ymm7, %ymm0
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm8[1],ymm0[2,3,4],ymm8[5],ymm0[6,7,8],ymm8[9],ymm0[10,11,12],ymm8[13],ymm0[14,15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm0[5,12,3,10,1,8,15,22,29],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vpternlogq $248, %ymm17, %ymm2, %ymm0
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm0[0],ymm3[1,2,3,4,5,6,7],ymm0[8],ymm3[9,10,11,12,13,14,15]
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm18, (%rsi)
; AVX512F-FAST-NEXT:    vmovdqa %ymm10, (%rdx)
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm19, (%rcx)
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm20, (%r8)
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm21, (%r9)
; AVX512F-FAST-NEXT:    vmovdqa %ymm6, (%r10)
; AVX512F-FAST-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-SLOW-LABEL: load_i8_stride7_vf32:
; AVX512BW-SLOW:       # %bb.0:
; AVX512BW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-SLOW-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512BW-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512BW-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm4
; AVX512BW-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX512BW-SLOW-NEXT:    movw $-28382, %r11w # imm = 0x9122
; AVX512BW-SLOW-NEXT:    kmovd %r11d, %k5
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm1, %ymm2, %ymm0 {%k5}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm5
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX512BW-SLOW-NEXT:    movw $9288, %r11w # imm = 0x2448
; AVX512BW-SLOW-NEXT:    kmovd %r11d, %k1
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm4, %ymm3, %ymm5 {%k1}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm6[2],ymm5[3,4],ymm6[5],ymm5[6,7,8,9],ymm6[10],ymm5[11,12],ymm6[13],ymm5[14,15]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    movw $992, %r11w # imm = 0x3E0
; AVX512BW-SLOW-NEXT:    kmovd %r11d, %k2
; AVX512BW-SLOW-NEXT:    vmovdqu16 %ymm5, %ymm0 {%k2}
; AVX512BW-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512BW-SLOW-NEXT:    vmovdqa 160(%rdi), %ymm5
; AVX512BW-SLOW-NEXT:    movw $8772, %r11w # imm = 0x2244
; AVX512BW-SLOW-NEXT:    kmovd %r11d, %k2
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm6, %ymm5, %ymm7 {%k2}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u],zero,zero,xmm8[3,10],zero,zero,zero,xmm8[6,13,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,5,12],zero,zero,xmm7[1,8,15],zero,zero,xmm7[u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm9
; AVX512BW-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm7
; AVX512BW-SLOW-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX512BW-SLOW-NEXT:    vpshufb %xmm10, %xmm7, %xmm11
; AVX512BW-SLOW-NEXT:    vmovdqa 208(%rdi), %xmm8
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5,6],ymm11[7]
; AVX512BW-SLOW-NEXT:    movl $-524288, %edi # imm = 0xFFF80000
; AVX512BW-SLOW-NEXT:    kmovd %edi, %k4
; AVX512BW-SLOW-NEXT:    vmovdqu8 %ymm9, %ymm0 {%k4}
; AVX512BW-SLOW-NEXT:    movw $4644, %di # imm = 0x1224
; AVX512BW-SLOW-NEXT:    kmovd %edi, %k3
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm1, %ymm2, %ymm9 {%k3}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm9, %xmm11
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,zero,xmm11[6,13],zero,zero,xmm11[2,9,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[1,8,15],zero,zero,xmm9[4,11],zero,zero,xmm9[u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm11, %xmm9, %xmm11
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm3, %ymm4, %ymm9 {%k5}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm9, %xmm12
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm9[0,1],ymm12[2],ymm9[3,4,5],ymm12[6],ymm9[7,8,9],ymm12[10],ymm9[11,12,13],ymm12[14],ymm9[15]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    movl $511, %edi # imm = 0x1FF
; AVX512BW-SLOW-NEXT:    kmovd %edi, %k6
; AVX512BW-SLOW-NEXT:    vmovdqu8 %ymm11, %ymm9 {%k6}
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm6, %ymm5, %ymm11 {%k1}
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm11[u,u,u,6,13],zero,zero,xmm11[2,9],zero,zero,zero,xmm11[u,u,u,u]
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm11
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,u],zero,zero,xmm11[4,11],zero,zero,xmm11[0,7,14,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm7[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1],xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5,6],ymm12[7]
; AVX512BW-SLOW-NEXT:    vmovdqu8 %ymm11, %ymm9 {%k4}
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm3, %ymm4, %ymm11 {%k3}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm12
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm11[0,1,2],ymm12[3],ymm11[4,5],ymm12[6],ymm11[7,8,9,10],ymm12[11],ymm11[12,13],ymm12[14],ymm11[15]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm1, %ymm2, %ymm12 {%k2}
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm12[2,9],zero,zero,zero,xmm12[5,12],zero,zero,xmm12[u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm12, %xmm12
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = zero,zero,xmm12[0,7,14],zero,zero,xmm12[3,10,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX512BW-SLOW-NEXT:    movl $261632, %edi # imm = 0x3FE00
; AVX512BW-SLOW-NEXT:    kmovd %edi, %k4
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} ymm12 {%k4} = ymm11[u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,18,25,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm5, %ymm6, %ymm11 {%k5}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm13
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u],zero,zero,zero,xmm13[5,12],zero,zero,xmm13[1,8,15,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,0,7,14],zero,zero,xmm11[3,10],zero,zero,zero,xmm11[u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm13, %xmm11, %xmm11
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-SLOW-NEXT:    vpshufb %xmm10, %xmm8, %xmm10
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm7[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm13[0],xmm10[0],xmm13[1],xmm10[1],xmm13[2],xmm10[2],xmm13[3],xmm10[3]
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm11[0,1,2,3,4,5,6],ymm10[7]
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm12[0],ymm10[1,2,3,4,5,6,7],ymm12[8],ymm10[9,10,11,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm12[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm3, %ymm4, %ymm11 {%k2}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm12
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm12[0],ymm11[1,2],ymm12[3],ymm11[4,5,6],ymm12[7,8],ymm11[9,10],ymm12[11],ymm11[12,13,14],ymm12[15]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm1, %ymm2, %ymm12 {%k1}
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm12[3,10],zero,zero,zero,xmm12[6,13],zero,zero,xmm12[u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm12, %xmm12
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = zero,zero,xmm12[1,8,15],zero,zero,xmm12[4,11,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} ymm12 {%k4} = ymm11[u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,19,26,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm5, %ymm6, %ymm11 {%k3}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm13
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u],zero,zero,zero,xmm13[6,13],zero,zero,xmm13[2,9,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,1,8,15],zero,zero,xmm11[4,11],zero,zero,xmm11[u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm13, %xmm11, %xmm11
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm8[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[5,12]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm7[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512BW-SLOW-NEXT:    vpor %xmm13, %xmm14, %xmm13
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX512BW-SLOW-NEXT:    movl $-134217728, %edi # imm = 0xF8000000
; AVX512BW-SLOW-NEXT:    kmovd %edi, %k5
; AVX512BW-SLOW-NEXT:    vmovdqu8 %ymm13, %ymm11 {%k5}
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm12[0],ymm11[1,2,3,4,5,6,7],ymm12[8],ymm11[9,10,11,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm12[0,1,2,3],ymm11[4,5,6,7]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm3, %ymm4, %ymm12 {%k1}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm12, %xmm13
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm13[0],ymm12[1,2,3],ymm13[4],ymm12[5,6],ymm13[7,8],ymm12[9,10,11],ymm13[12],ymm12[13,14],ymm13[15]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm2, %ymm1, %ymm13 {%k3}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm14
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,xmm14[2,9],zero,zero,zero,xmm14[5,12,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[4,11],zero,zero,xmm13[0,7,14],zero,zero,xmm13[u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} ymm13 {%k4} = ymm12[u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,20,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm5, %ymm6, %ymm12 {%k2}
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm12[u,u,2,9],zero,zero,zero,xmm12[5,12],zero,zero,xmm12[u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm12, %xmm12
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u],zero,zero,xmm12[0,7,14],zero,zero,xmm12[3,10,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm14, %xmm12, %xmm12
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm8[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[6,13]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm7[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512BW-SLOW-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-SLOW-NEXT:    vmovdqu8 %ymm14, %ymm12 {%k5}
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm13[0],ymm12[1,2,3,4,5,6,7],ymm13[8],ymm12[9,10,11,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0,1,2,3],ymm12[4,5,6,7]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm4, %ymm3, %ymm13 {%k3}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm14
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm13 = ymm13[0],ymm14[1],ymm13[2,3],ymm14[4],ymm13[5,6,7,8],ymm14[9],ymm13[10,11],ymm14[12],ymm13[13,14,15]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm2, %ymm1, %ymm14 {%k2}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm14, %xmm15
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,xmm15[3,10],zero,zero,zero,xmm15[6,13,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[5,12],zero,zero,xmm14[1,8,15],zero,zero,xmm14[u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} ymm14 {%k4} = ymm13[u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,21,28,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpblendmw %ymm5, %ymm6, %ymm13 {%k1}
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm13[u,u,3,10],zero,zero,zero,xmm13[6,13],zero,zero,xmm13[u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u],zero,zero,xmm13[1,8,15],zero,zero,xmm13[4,11,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm15, %xmm13, %xmm13
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm7[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm8[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm8[0,7,14]
; AVX512BW-SLOW-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512BW-SLOW-NEXT:    vmovdqu8 %ymm15, %ymm13 {%k5}
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm13 = ymm14[0],ymm13[1,2,3,4,5,6,7],ymm14[8],ymm13[9,10,11,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm13 = ymm14[0,1,2,3],ymm13[4,5,6,7]
; AVX512BW-SLOW-NEXT:    vmovdqu16 %ymm4, %ymm3 {%k2}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3,4],ymm4[5],ymm3[6,7,8],ymm4[9],ymm3[10,11,12],ymm4[13],ymm3[14,15]
; AVX512BW-SLOW-NEXT:    vmovdqu16 %ymm2, %ymm1 {%k1}
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm1[6,13],zero,zero,xmm1[2,9],zero,zero,zero,xmm1[u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[4,11],zero,zero,xmm1[0,7,14,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 {%k4} = ymm3[u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,22,29,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vmovdqu16 %ymm6, %ymm5 {%k3}
; AVX512BW-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm2
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[5,12,u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm5[u,u,4,11],zero,zero,xmm5[0,7,14],zero,zero,xmm5[u,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512BW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm8[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm8[1,8,15]
; AVX512BW-SLOW-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512BW-SLOW-NEXT:    vmovdqu8 %ymm3, %ymm2 {%k5}
; AVX512BW-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm1[0],ymm2[1,2,3,4,5,6,7],ymm1[8],ymm2[9,10,11,12,13,14,15]
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm9, (%rdx)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm10, (%rcx)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm11, (%r8)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm12, (%r9)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm13, (%r10)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm1, (%rax)
; AVX512BW-SLOW-NEXT:    vzeroupper
; AVX512BW-SLOW-NEXT:    retq
;
; AVX512BW-FAST-LABEL: load_i8_stride7_vf32:
; AVX512BW-FAST:       # %bb.0:
; AVX512BW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [16,9,2,19,20,13,6,23,24,17,26,27,28,21,30,31]
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FAST-NEXT:    vpermw %zmm1, %zmm0, %zmm0
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [16,9,2,19,12,5,22,23,24,17,26,27,20,29,30,31]
; AVX512BW-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm4
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,1,2,19,12,5,22,15,0,9,26,11,4,29,14,7]
; AVX512BW-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm5
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,1,18,11,4,5,22,15,0,25,10,3,12,29,14,7]
; AVX512BW-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm9
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,18,11,4,21,14,7,8,25,10,3,28,13,6,15]
; AVX512BW-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm10
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,17,10,3,4,21,14,7,24,9,2,11,28,13,6,31]
; AVX512BW-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm8
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [16,17,10,3,20,13,6,23,24,25,18,27,28,21,30,31]
; AVX512BW-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm6
; AVX512BW-FAST-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512BW-FAST-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512BW-FAST-NEXT:    movw $-28382, %r11w # imm = 0x9122
; AVX512BW-FAST-NEXT:    kmovd %r11d, %k5
; AVX512BW-FAST-NEXT:    vpblendmw %ymm2, %ymm3, %ymm1 {%k5}
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm7
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[5,12],zero,zero,xmm7[1,8,15,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[0,7,14],zero,zero,xmm1[3,10],zero,zero,zero,xmm1[u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm7, %xmm1, %xmm1
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    movw $992, %r11w # imm = 0x3E0
; AVX512BW-FAST-NEXT:    kmovd %r11d, %k1
; AVX512BW-FAST-NEXT:    vmovdqu16 %ymm6, %ymm1 {%k1}
; AVX512BW-FAST-NEXT:    vmovdqa 128(%rdi), %ymm7
; AVX512BW-FAST-NEXT:    vmovdqa 160(%rdi), %ymm6
; AVX512BW-FAST-NEXT:    movw $8772, %r11w # imm = 0x2244
; AVX512BW-FAST-NEXT:    kmovd %r11d, %k1
; AVX512BW-FAST-NEXT:    vpblendmw %ymm7, %ymm6, %ymm11 {%k1}
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm12
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u,u],zero,zero,xmm12[3,10],zero,zero,zero,xmm12[6,13,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,u,5,12],zero,zero,xmm11[1,8,15],zero,zero,xmm11[u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,u,u,u,1,2,4,6>
; AVX512BW-FAST-NEXT:    vmovdqa 192(%rdi), %ymm13
; AVX512BW-FAST-NEXT:    vpermd %ymm13, %ymm12, %ymm12
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,23,26,29]
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5,6],ymm12[7]
; AVX512BW-FAST-NEXT:    movl $-524288, %r11d # imm = 0xFFF80000
; AVX512BW-FAST-NEXT:    kmovd %r11d, %k4
; AVX512BW-FAST-NEXT:    vmovdqu8 %ymm11, %ymm1 {%k4}
; AVX512BW-FAST-NEXT:    movw $4644, %r11w # imm = 0x1224
; AVX512BW-FAST-NEXT:    kmovd %r11d, %k2
; AVX512BW-FAST-NEXT:    vpblendmw %ymm2, %ymm3, %ymm11 {%k2}
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm12
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = zero,zero,zero,xmm12[6,13],zero,zero,xmm12[2,9,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[1,8,15],zero,zero,xmm11[4,11],zero,zero,xmm11[u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    movl $511, %r11d # imm = 0x1FF
; AVX512BW-FAST-NEXT:    kmovd %r11d, %k3
; AVX512BW-FAST-NEXT:    vmovdqu8 %ymm11, %ymm8 {%k3}
; AVX512BW-FAST-NEXT:    movw $9288, %r11w # imm = 0x2448
; AVX512BW-FAST-NEXT:    kmovd %r11d, %k3
; AVX512BW-FAST-NEXT:    vpblendmw %ymm7, %ymm6, %ymm11 {%k3}
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm11[u,u,u,6,13],zero,zero,xmm11[2,9],zero,zero,zero,xmm11[u,u,u,u]
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm11
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,u],zero,zero,xmm11[4,11],zero,zero,xmm11[0,7,14,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,u,u,u,1,3,4,6>
; AVX512BW-FAST-NEXT:    vpermd %ymm13, %ymm12, %ymm12
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,17,20,27,30]
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5,6],ymm12[7]
; AVX512BW-FAST-NEXT:    vmovdqu8 %ymm11, %ymm8 {%k4}
; AVX512BW-FAST-NEXT:    vpblendmw %ymm2, %ymm3, %ymm11 {%k1}
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm11[2,9],zero,zero,zero,xmm11[5,12],zero,zero,xmm11[u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm11
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,xmm11[0,7,14],zero,zero,xmm11[3,10,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX512BW-FAST-NEXT:    movl $261632, %r11d # imm = 0x3FE00
; AVX512BW-FAST-NEXT:    kmovd %r11d, %k4
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} ymm11 {%k4} = ymm10[u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,18,25,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpblendmw %ymm6, %ymm7, %ymm10 {%k5}
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm12
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u],zero,zero,zero,xmm12[5,12],zero,zero,xmm12[1,8,15,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[u,u,0,7,14],zero,zero,xmm10[3,10],zero,zero,zero,xmm10[u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm12, %xmm10, %xmm10
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,u,u,u,1,3,5,6>
; AVX512BW-FAST-NEXT:    vpermd %ymm13, %ymm12, %ymm12
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,21,24,31]
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5,6],ymm12[7]
; AVX512BW-FAST-NEXT:    vpblendw {{.*#+}} ymm10 = ymm11[0],ymm10[1,2,3,4,5,6,7],ymm11[8],ymm10[9,10,11,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-FAST-NEXT:    vpblendmw %ymm6, %ymm7, %ymm11 {%k2}
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm12
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u],zero,zero,zero,xmm12[6,13],zero,zero,xmm12[2,9,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,1,8,15],zero,zero,xmm11[4,11],zero,zero,xmm11[u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm12, %xmm11, %xmm11
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm13
; AVX512BW-FAST-NEXT:    vmovdqa 208(%rdi), %xmm11
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm11[5,12]
; AVX512BW-FAST-NEXT:    vmovdqa 192(%rdi), %xmm12
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm12[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512BW-FAST-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-FAST-NEXT:    movl $-134217728, %edi # imm = 0xF8000000
; AVX512BW-FAST-NEXT:    kmovd %edi, %k5
; AVX512BW-FAST-NEXT:    vmovdqu8 %ymm14, %ymm13 {%k5}
; AVX512BW-FAST-NEXT:    vpblendmw %ymm2, %ymm3, %ymm14 {%k3}
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[3,10],zero,zero,zero,xmm14[6,13],zero,zero,xmm14[u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,xmm14[1,8,15],zero,zero,xmm14[4,11,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} ymm14 {%k4} = ymm9[u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,19,26,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpblendw {{.*#+}} ymm9 = ymm14[0],ymm13[1,2,3,4,5,6,7],ymm14[8],ymm13[9,10,11,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm14[0,1,2,3],ymm9[4,5,6,7]
; AVX512BW-FAST-NEXT:    vpblendmw %ymm6, %ymm7, %ymm13 {%k1}
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[u,u,2,9],zero,zero,zero,xmm13[5,12],zero,zero,xmm13[u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u],zero,zero,xmm13[0,7,14],zero,zero,xmm13[3,10,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm11[6,13]
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm12[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512BW-FAST-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-FAST-NEXT:    vmovdqu8 %ymm14, %ymm13 {%k5}
; AVX512BW-FAST-NEXT:    vpblendmw %ymm3, %ymm2, %ymm14 {%k2}
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm15
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,xmm15[2,9],zero,zero,zero,xmm15[5,12,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[4,11],zero,zero,xmm14[0,7,14],zero,zero,xmm14[u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} ymm14 {%k4} = ymm5[u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,20,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm14[0],ymm13[1,2,3,4,5,6,7],ymm14[8],ymm13[9,10,11,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm14[0,1,2,3],ymm5[4,5,6,7]
; AVX512BW-FAST-NEXT:    vpblendmw %ymm6, %ymm7, %ymm13 {%k3}
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[u,u,3,10],zero,zero,zero,xmm13[6,13],zero,zero,xmm13[u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u],zero,zero,xmm13[1,8,15],zero,zero,xmm13[4,11,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm12[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm11[0,7,14]
; AVX512BW-FAST-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-FAST-NEXT:    vmovdqu8 %ymm14, %ymm13 {%k5}
; AVX512BW-FAST-NEXT:    vpblendmw %ymm3, %ymm2, %ymm14 {%k1}
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm15
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,xmm15[3,10],zero,zero,zero,xmm15[6,13,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[5,12],zero,zero,xmm14[1,8,15],zero,zero,xmm14[u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} ymm14 {%k4} = ymm4[u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,21,28,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm14[0],ymm13[1,2,3,4,5,6,7],ymm14[8],ymm13[9,10,11,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm14[0,1,2,3],ymm4[4,5,6,7]
; AVX512BW-FAST-NEXT:    vmovdqu16 %ymm7, %ymm6 {%k2}
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u],zero,zero,xmm7[2,9],zero,zero,zero,xmm7[5,12,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,4,11],zero,zero,xmm6[0,7,14],zero,zero,xmm6[u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm12[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm11[1,8,15]
; AVX512BW-FAST-NEXT:    vpor %xmm7, %xmm11, %xmm7
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512BW-FAST-NEXT:    vmovdqu8 %ymm7, %ymm6 {%k5}
; AVX512BW-FAST-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k3}
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[6,13],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512BW-FAST-NEXT:    vpshufb {{.*#+}} ymm2 {%k4} = ymm0[u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,22,29,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm2[0],ymm6[1,2,3,4,5,6,7],ymm2[8],ymm6[9,10,11,12,13,14,15]
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX512BW-FAST-NEXT:    vmovdqa %ymm1, (%rsi)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm8, (%rdx)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm10, (%rcx)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm9, (%r8)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm5, (%r9)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm4, (%r10)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512BW-FAST-NEXT:    vzeroupper
; AVX512BW-FAST-NEXT:    retq
  %wide.vec = load <224 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <224 x i8> %wide.vec, <224 x i8> poison, <32 x i32> <i32 0, i32 7, i32 14, i32 21, i32 28, i32 35, i32 42, i32 49, i32 56, i32 63, i32 70, i32 77, i32 84, i32 91, i32 98, i32 105, i32 112, i32 119, i32 126, i32 133, i32 140, i32 147, i32 154, i32 161, i32 168, i32 175, i32 182, i32 189, i32 196, i32 203, i32 210, i32 217>
  %strided.vec1 = shufflevector <224 x i8> %wide.vec, <224 x i8> poison, <32 x i32> <i32 1, i32 8, i32 15, i32 22, i32 29, i32 36, i32 43, i32 50, i32 57, i32 64, i32 71, i32 78, i32 85, i32 92, i32 99, i32 106, i32 113, i32 120, i32 127, i32 134, i32 141, i32 148, i32 155, i32 162, i32 169, i32 176, i32 183, i32 190, i32 197, i32 204, i32 211, i32 218>
  %strided.vec2 = shufflevector <224 x i8> %wide.vec, <224 x i8> poison, <32 x i32> <i32 2, i32 9, i32 16, i32 23, i32 30, i32 37, i32 44, i32 51, i32 58, i32 65, i32 72, i32 79, i32 86, i32 93, i32 100, i32 107, i32 114, i32 121, i32 128, i32 135, i32 142, i32 149, i32 156, i32 163, i32 170, i32 177, i32 184, i32 191, i32 198, i32 205, i32 212, i32 219>
  %strided.vec3 = shufflevector <224 x i8> %wide.vec, <224 x i8> poison, <32 x i32> <i32 3, i32 10, i32 17, i32 24, i32 31, i32 38, i32 45, i32 52, i32 59, i32 66, i32 73, i32 80, i32 87, i32 94, i32 101, i32 108, i32 115, i32 122, i32 129, i32 136, i32 143, i32 150, i32 157, i32 164, i32 171, i32 178, i32 185, i32 192, i32 199, i32 206, i32 213, i32 220>
  %strided.vec4 = shufflevector <224 x i8> %wide.vec, <224 x i8> poison, <32 x i32> <i32 4, i32 11, i32 18, i32 25, i32 32, i32 39, i32 46, i32 53, i32 60, i32 67, i32 74, i32 81, i32 88, i32 95, i32 102, i32 109, i32 116, i32 123, i32 130, i32 137, i32 144, i32 151, i32 158, i32 165, i32 172, i32 179, i32 186, i32 193, i32 200, i32 207, i32 214, i32 221>
  %strided.vec5 = shufflevector <224 x i8> %wide.vec, <224 x i8> poison, <32 x i32> <i32 5, i32 12, i32 19, i32 26, i32 33, i32 40, i32 47, i32 54, i32 61, i32 68, i32 75, i32 82, i32 89, i32 96, i32 103, i32 110, i32 117, i32 124, i32 131, i32 138, i32 145, i32 152, i32 159, i32 166, i32 173, i32 180, i32 187, i32 194, i32 201, i32 208, i32 215, i32 222>
  %strided.vec6 = shufflevector <224 x i8> %wide.vec, <224 x i8> poison, <32 x i32> <i32 6, i32 13, i32 20, i32 27, i32 34, i32 41, i32 48, i32 55, i32 62, i32 69, i32 76, i32 83, i32 90, i32 97, i32 104, i32 111, i32 118, i32 125, i32 132, i32 139, i32 146, i32 153, i32 160, i32 167, i32 174, i32 181, i32 188, i32 195, i32 202, i32 209, i32 216, i32 223>
  store <32 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <32 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <32 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <32 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <32 x i8> %strided.vec4, ptr %out.vec4, align 64
  store <32 x i8> %strided.vec5, ptr %out.vec5, align 64
  store <32 x i8> %strided.vec6, ptr %out.vec6, align 64
  ret void
}

define void @load_i8_stride7_vf64(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i8_stride7_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1512, %rsp # imm = 0x5E8
; SSE-NEXT:    movdqa 208(%rdi), %xmm10
; SSE-NEXT:    movdqa 192(%rdi), %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 176(%rdi), %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 128(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 160(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 144(%rdi), %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,0,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm14
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm6[8],xmm0[9],xmm6[9],xmm0[10],xmm6[10],xmm0[11],xmm6[11],xmm0[12],xmm6[12],xmm0[13],xmm6[13],xmm0[14],xmm6[14],xmm0[15],xmm6[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3],xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm1[0,1,2,3,4,4,5,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,255,255,255,255,0,0,0,0,0,255,255,255,255,255,255]
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [65535,65535,0,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,65535,65535,65535,0,65535,0,65535]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1],xmm3[2],xmm6[2],xmm3[3],xmm6[3],xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm7, %xmm2
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,4,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm6[8],xmm3[9],xmm6[9],xmm3[10],xmm6[10],xmm3[11],xmm6[11],xmm3[12],xmm6[12],xmm3[13],xmm6[13],xmm3[14],xmm6[14],xmm3[15],xmm6[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,7,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm6[8],xmm0[9],xmm6[9],xmm0[10],xmm6[10],xmm0[11],xmm6[11],xmm0[12],xmm6[12],xmm0[13],xmm6[13],xmm0[14],xmm6[14],xmm0[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1],xmm3[2],xmm6[2],xmm3[3],xmm6[3],xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm5, %xmm7
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 256(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa 272(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,5,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa 240(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa 224(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm15, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    pand %xmm13, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa 288(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    movdqa 304(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,4,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm6[8],xmm3[9],xmm6[9],xmm3[10],xmm6[10],xmm3[11],xmm6[11],xmm3[12],xmm6[12],xmm3[13],xmm6[13],xmm3[14],xmm6[14],xmm3[15],xmm6[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,7,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    movdqa 320(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm6[8],xmm0[9],xmm6[9],xmm0[10],xmm6[10],xmm0[11],xmm6[11],xmm0[12],xmm6[12],xmm0[13],xmm6[13],xmm0[14],xmm6[14],xmm0[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1],xmm3[2],xmm6[2],xmm3[3],xmm6[3],xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 368(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa 384(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,5,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa 352(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa 336(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm15, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    pand %xmm13, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa 400(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    movdqa 416(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,4,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm6[8],xmm3[9],xmm6[9],xmm3[10],xmm6[10],xmm3[11],xmm6[11],xmm3[12],xmm6[12],xmm3[13],xmm6[13],xmm3[14],xmm6[14],xmm3[15],xmm6[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,7,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    movdqa 432(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm6[8],xmm0[9],xmm6[9],xmm0[10],xmm6[10],xmm0[11],xmm6[11],xmm0[12],xmm6[12],xmm0[13],xmm6[13],xmm0[14],xmm6[14],xmm0[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1],xmm3[2],xmm6[2],xmm3[3],xmm6[3],xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa 48(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,5,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa 16(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa (%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1],xmm3[2],xmm6[2],xmm3[3],xmm6[3],xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm11
; SSE-NEXT:    por %xmm11, %xmm1
; SSE-NEXT:    movdqa 64(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    movdqa 80(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3],xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,4,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,7,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    movdqa 96(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm6[8],xmm3[9],xmm6[9],xmm3[10],xmm6[10],xmm3[11],xmm6[11],xmm3[12],xmm6[12],xmm3[13],xmm6[13],xmm3[14],xmm6[14],xmm3[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm14, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3],xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    packuswb %xmm2, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm12, %xmm14
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3],xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm6[8],xmm3[9],xmm6[9],xmm3[10],xmm6[10],xmm3[11],xmm6[11],xmm3[12],xmm6[12],xmm3[13],xmm6[13],xmm3[14],xmm6[14],xmm3[15],xmm6[15]
; SSE-NEXT:    pand %xmm9, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm15, %xmm10
; SSE-NEXT:    movdqa %xmm15, %xmm2
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1],xmm3[2],xmm6[2],xmm3[3],xmm6[3],xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pslld $16, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE-NEXT:    packuswb %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,4,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm15
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm11
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    movdqa (%rsp), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3],xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1],xmm3[2],xmm6[2],xmm3[3],xmm6[3],xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pslld $16, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE-NEXT:    packuswb %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm15, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,4,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm15, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm5, %xmm12
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm14, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3],xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pandn %xmm5, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1],xmm3[2],xmm6[2],xmm3[3],xmm6[3],xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pslld $16, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE-NEXT:    packuswb %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm15, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,4,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm15, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    pandn %xmm12, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm14, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3],xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    pandn %xmm15, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm6[8],xmm0[9],xmm6[9],xmm0[10],xmm6[10],xmm0[11],xmm6[11],xmm0[12],xmm6[12],xmm0[13],xmm6[13],xmm0[14],xmm6[14],xmm0[15],xmm6[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3],xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm13
; SSE-NEXT:    por %xmm1, %xmm13
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    movdqa (%rsp), %xmm8 # 16-byte Reload
; SSE-NEXT:    pandn %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pandn %xmm9, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm13
; SSE-NEXT:    pand %xmm10, %xmm13
; SSE-NEXT:    movdqa %xmm10, %xmm7
; SSE-NEXT:    por %xmm0, %xmm13
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm10
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    pandn %xmm11, %xmm7
; SSE-NEXT:    por %xmm0, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,0,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm14, %xmm4
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pandn %xmm6, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm6[0,2,2,3]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm8[0,2,2,3]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    pandn %xmm9, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[0,2,2,3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm7, %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm7, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm7, %xmm15
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm11, %xmm14
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm11[0,2,2,3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm7, %xmm11
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm10, %xmm7
; SSE-NEXT:    por %xmm11, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pandn %xmm7, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    movdqa %xmm7, %xmm12
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm9
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pandn %xmm13, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm14
; SSE-NEXT:    pslld $16, %xmm14
; SSE-NEXT:    psrldq {{.*#+}} xmm6 = xmm6[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm10[0],xmm6[1],xmm10[1],xmm6[2],xmm10[2],xmm6[3],xmm10[3]
; SSE-NEXT:    psrldq {{.*#+}} xmm9 = xmm9[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm15[0],xmm9[1],xmm15[1],xmm9[2],xmm15[2],xmm9[3],xmm15[3]
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrldq {{.*#+}} xmm1 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm9
; SSE-NEXT:    psrldq {{.*#+}} xmm9 = xmm9[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm3[0],xmm9[1],xmm3[1],xmm9[2],xmm3[2],xmm9[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4],xmm10[4],xmm12[5],xmm10[5],xmm12[6],xmm10[6],xmm12[7],xmm10[7]
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm12
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm15[4],xmm2[5],xmm15[5],xmm2[6],xmm15[6],xmm2[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm0[4],xmm11[5],xmm0[5],xmm11[6],xmm0[6],xmm11[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm9
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pxor %xmm3, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3],xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm0[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm10[0,1,2,3,6,4,6,5]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3],xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm15 = xmm0[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm15 = xmm15[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm15[0,1,2,3,6,4,6,5]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3],xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm15 = xmm0[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm15 = xmm15[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm15[0,1,2,3,6,4,6,5]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3],xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm15 = xmm0[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm15 = xmm15[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm15[0,1,2,3,6,4,6,5]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm10, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm10, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm10, %xmm13
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm15
; SSE-NEXT:    pandn %xmm2, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3],xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm13, %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3],xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3],xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm13, %xmm11
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3],xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm13, %xmm15
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm9, %xmm13
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm14[0],xmm9[1],xmm14[1],xmm9[2],xmm14[2],xmm9[3],xmm14[3]
; SSE-NEXT:    packuswb %xmm9, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm5, %xmm15
; SSE-NEXT:    pandn %xmm3, %xmm15
; SSE-NEXT:    pshufd $236, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,4,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm3, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm0, %xmm9
; SSE-NEXT:    pandn %xmm15, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm9
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm15
; SSE-NEXT:    por %xmm3, %xmm15
; SSE-NEXT:    movdqa %xmm15, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,0,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8],xmm2[8],xmm15[9],xmm2[9],xmm15[10],xmm2[10],xmm15[11],xmm2[11],xmm15[12],xmm2[12],xmm15[13],xmm2[13],xmm15[14],xmm2[14],xmm15[15],xmm2[15]
; SSE-NEXT:    pand %xmm9, %xmm15
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    packuswb %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm15[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm5, %xmm7
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm15, %xmm15
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm15[0],xmm4[1],xmm15[1],xmm4[2],xmm15[2],xmm4[3],xmm15[3],xmm4[4],xmm15[4],xmm4[5],xmm15[5],xmm4[6],xmm15[6],xmm4[7],xmm15[7]
; SSE-NEXT:    pand %xmm9, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pshufd $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[1,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm13
; SSE-NEXT:    pandn %xmm2, %xmm13
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm13, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm1[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-NEXT:    packuswb %xmm2, %xmm13
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [255,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm13, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    pand %xmm6, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm14
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm9, %xmm13
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    packuswb {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm2, %xmm8
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm15[0],xmm8[1],xmm15[1],xmm8[2],xmm15[2],xmm8[3],xmm15[3],xmm8[4],xmm15[4],xmm8[5],xmm15[5],xmm8[6],xmm15[6],xmm8[7],xmm15[7]
; SSE-NEXT:    pand %xmm9, %xmm8
; SSE-NEXT:    por %xmm3, %xmm8
; SSE-NEXT:    pshufd $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[1,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm15[0],xmm4[1],xmm15[1],xmm4[2],xmm15[2],xmm4[3],xmm15[3],xmm4[4],xmm15[4],xmm4[5],xmm15[5],xmm4[6],xmm15[6],xmm4[7],xmm15[7]
; SSE-NEXT:    pand %xmm0, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-NEXT:    packuswb %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm8[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    packuswb {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm15[0],xmm4[1],xmm15[1],xmm4[2],xmm15[2],xmm4[3],xmm15[3],xmm4[4],xmm15[4],xmm4[5],xmm15[5],xmm4[6],xmm15[6],xmm4[7],xmm15[7]
; SSE-NEXT:    pand %xmm9, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1],xmm6[2],xmm15[2],xmm6[3],xmm15[3],xmm6[4],xmm15[4],xmm6[5],xmm15[5],xmm6[6],xmm15[6],xmm6[7],xmm15[7]
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-NEXT:    packuswb %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    pand %xmm14, %xmm6
; SSE-NEXT:    por %xmm1, %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    packuswb {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1],xmm6[2],xmm15[2],xmm6[3],xmm15[3],xmm6[4],xmm15[4],xmm6[5],xmm15[5],xmm6[6],xmm15[6],xmm6[7],xmm15[7]
; SSE-NEXT:    pand %xmm9, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm11[1,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm15[0],xmm3[1],xmm15[1],xmm3[2],xmm15[2],xmm3[3],xmm15[3],xmm3[4],xmm15[4],xmm3[5],xmm15[5],xmm3[6],xmm15[6],xmm3[7],xmm15[7]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    pand %xmm14, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,0,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    pandn %xmm8, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,0,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm2[3,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,7,7,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm15[0],xmm3[1],xmm15[1],xmm3[2],xmm15[2],xmm3[3],xmm15[3],xmm3[4],xmm15[4],xmm3[5],xmm15[5],xmm3[6],xmm15[6],xmm3[7],xmm15[7]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pshuflw $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm3[0,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,6,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm2[3,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,7,7,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm15[0],xmm3[1],xmm15[1],xmm3[2],xmm15[2],xmm3[3],xmm15[3],xmm3[4],xmm15[4],xmm3[5],xmm15[5],xmm3[6],xmm15[6],xmm3[7],xmm15[7]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pshuflw $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm3[0,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,6,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm2[3,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,7,7,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pandn %xmm14, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm15[0],xmm3[1],xmm15[1],xmm3[2],xmm15[2],xmm3[3],xmm15[3],xmm3[4],xmm15[4],xmm3[5],xmm15[5],xmm3[6],xmm15[6],xmm3[7],xmm15[7]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pshuflw $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm3[0,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,6,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm11, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,6]
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm15[0],xmm0[1],xmm15[1],xmm0[2],xmm15[2],xmm0[3],xmm15[3],xmm0[4],xmm15[4],xmm0[5],xmm15[5],xmm0[6],xmm15[6],xmm0[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[3,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,7,7,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm5
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm15[0],xmm3[1],xmm15[1],xmm3[2],xmm15[2],xmm3[3],xmm15[3],xmm3[4],xmm15[4],xmm3[5],xmm15[5],xmm3[6],xmm15[6],xmm3[7],xmm15[7]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm13
; SSE-NEXT:    por %xmm3, %xmm13
; SSE-NEXT:    pshuflw $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm13[0,2,1,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,6,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm13
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm8, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    packuswb %xmm0, %xmm2
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,1,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd $100, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    andps %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    packuswb %xmm0, %xmm2
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,1,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd $100, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    andps %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1],xmm6[2],xmm15[2],xmm6[3],xmm15[3],xmm6[4],xmm15[4],xmm6[5],xmm15[5],xmm6[6],xmm15[6],xmm6[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    packuswb %xmm0, %xmm2
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,1,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn %xmm14, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd $100, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    andps %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm15[8],xmm0[9],xmm15[9],xmm0[10],xmm15[10],xmm0[11],xmm15[11],xmm0[12],xmm15[12],xmm0[13],xmm15[13],xmm0[14],xmm15[14],xmm0[15],xmm15[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    packuswb %xmm0, %xmm2
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,1,3,3]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm15[8],xmm7[9],xmm15[9],xmm7[10],xmm15[10],xmm7[11],xmm15[11],xmm7[12],xmm15[12],xmm7[13],xmm15[13],xmm7[14],xmm15[14],xmm7[15],xmm15[15]
; SSE-NEXT:    pand %xmm9, %xmm7
; SSE-NEXT:    pandn %xmm1, %xmm9
; SSE-NEXT:    por %xmm7, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[0,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    pshufd $100, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pandn %xmm2, %xmm13
; SSE-NEXT:    por %xmm1, %xmm13
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm13, %xmm2
; SSE-NEXT:    andps %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm13
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm6, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,4,7,6]
; SSE-NEXT:    psrldq {{.*#+}} xmm2 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    packuswb %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,3,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm12[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1],xmm6[2],xmm15[2],xmm6[3],xmm15[3],xmm6[4],xmm15[4],xmm6[5],xmm15[5],xmm6[6],xmm15[6],xmm6[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm6[0],xmm1[1,2,3]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm11, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm7
; SSE-NEXT:    pand %xmm5, %xmm7
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm15[0],xmm2[1],xmm15[1],xmm2[2],xmm15[2],xmm2[3],xmm15[3],xmm2[4],xmm15[4],xmm2[5],xmm15[5],xmm2[6],xmm15[6],xmm2[7],xmm15[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,0,65535,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm8
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm15[8],xmm7[9],xmm15[9],xmm7[10],xmm15[10],xmm7[11],xmm15[11],xmm7[12],xmm15[12],xmm7[13],xmm15[13],xmm7[14],xmm15[14],xmm7[15],xmm15[15]
; SSE-NEXT:    pand %xmm3, %xmm7
; SSE-NEXT:    por %xmm8, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,6]
; SSE-NEXT:    packuswb %xmm2, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0]
; SSE-NEXT:    movdqa %xmm11, %xmm12
; SSE-NEXT:    pandn %xmm8, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    pand %xmm11, %xmm7
; SSE-NEXT:    por %xmm7, %xmm12
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm12, %xmm2
; SSE-NEXT:    andps %xmm13, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm1, %xmm7
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm15[8],xmm7[9],xmm15[9],xmm7[10],xmm15[10],xmm7[11],xmm15[11],xmm7[12],xmm15[12],xmm7[13],xmm15[13],xmm7[14],xmm15[14],xmm7[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pandn %xmm7, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm8, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm1[0,1,2,3,5,4,7,6]
; SSE-NEXT:    psrldq {{.*#+}} xmm7 = xmm7[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    packuswb %xmm7, %xmm8
; SSE-NEXT:    movdqa %xmm4, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pandn %xmm1, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[1,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm5[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm7[0],xmm12[1],xmm7[1]
; SSE-NEXT:    movdqa %xmm12, %xmm7
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm15[8],xmm7[9],xmm15[9],xmm7[10],xmm15[10],xmm7[11],xmm15[11],xmm7[12],xmm15[12],xmm7[13],xmm15[13],xmm7[14],xmm15[14],xmm7[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm15[0],xmm12[1],xmm15[1],xmm12[2],xmm15[2],xmm12[3],xmm15[3],xmm12[4],xmm15[4],xmm12[5],xmm15[5],xmm12[6],xmm15[6],xmm12[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm12[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm12 = xmm12[0],xmm7[0],xmm12[1],xmm7[1],xmm12[2],xmm7[2],xmm12[3],xmm7[3]
; SSE-NEXT:    packuswb %xmm12, %xmm12
; SSE-NEXT:    movss {{.*#+}} xmm8 = xmm12[0],xmm8[1,2,3]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    pand %xmm6, %xmm12
; SSE-NEXT:    por %xmm7, %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm15[0],xmm7[1],xmm15[1],xmm7[2],xmm15[2],xmm7[3],xmm15[3],xmm7[4],xmm15[4],xmm7[5],xmm15[5],xmm7[6],xmm15[6],xmm7[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm3, %xmm14
; SSE-NEXT:    pandn %xmm7, %xmm14
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm15[8],xmm12[9],xmm15[9],xmm12[10],xmm15[10],xmm12[11],xmm15[11],xmm12[12],xmm15[12],xmm12[13],xmm15[13],xmm12[14],xmm15[14],xmm12[15],xmm15[15]
; SSE-NEXT:    pand %xmm3, %xmm12
; SSE-NEXT:    por %xmm14, %xmm12
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,7,6]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    movdqa %xmm11, %xmm14
; SSE-NEXT:    pandn %xmm7, %xmm14
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm12[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    pand %xmm11, %xmm7
; SSE-NEXT:    por %xmm7, %xmm14
; SSE-NEXT:    movdqa %xmm13, %xmm7
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm14, %xmm2
; SSE-NEXT:    andps %xmm13, %xmm8
; SSE-NEXT:    por %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm8, %xmm12
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm15[8],xmm12[9],xmm15[9],xmm12[10],xmm15[10],xmm12[11],xmm15[11],xmm12[12],xmm15[12],xmm12[13],xmm15[13],xmm12[14],xmm15[14],xmm12[15],xmm15[15]
; SSE-NEXT:    movdqa %xmm0, %xmm14
; SSE-NEXT:    pandn %xmm12, %xmm14
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm15[0],xmm8[1],xmm15[1],xmm8[2],xmm15[2],xmm8[3],xmm15[3],xmm8[4],xmm15[4],xmm8[5],xmm15[5],xmm8[6],xmm15[6],xmm8[7],xmm15[7]
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pand %xmm0, %xmm8
; SSE-NEXT:    por %xmm14, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,5,4,7,6]
; SSE-NEXT:    psrldq {{.*#+}} xmm12 = xmm12[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    packuswb %xmm12, %xmm8
; SSE-NEXT:    movdqa %xmm4, %xmm14
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pandn %xmm1, %xmm14
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm1[1,3,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm15 = xmm1[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm15 = xmm15[0],xmm12[0],xmm15[1],xmm12[1]
; SSE-NEXT:    movdqa %xmm15, %xmm12
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm2[8],xmm12[9],xmm2[9],xmm12[10],xmm2[10],xmm12[11],xmm2[11],xmm12[12],xmm2[12],xmm12[13],xmm2[13],xmm12[14],xmm2[14],xmm12[15],xmm2[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm12[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm15 = xmm15[0],xmm2[0],xmm15[1],xmm2[1],xmm15[2],xmm2[2],xmm15[3],xmm2[3],xmm15[4],xmm2[4],xmm15[5],xmm2[5],xmm15[6],xmm2[6],xmm15[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm15 = xmm15[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm15 = xmm15[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm12[0],xmm15[1],xmm12[1],xmm15[2],xmm12[2],xmm15[3],xmm12[3]
; SSE-NEXT:    packuswb %xmm15, %xmm15
; SSE-NEXT:    movss {{.*#+}} xmm8 = xmm15[0],xmm8[1,2,3]
; SSE-NEXT:    movdqa %xmm6, %xmm12
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    pand %xmm6, %xmm15
; SSE-NEXT:    por %xmm12, %xmm15
; SSE-NEXT:    movdqa %xmm15, %xmm12
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm2[0],xmm12[1],xmm2[1],xmm12[2],xmm2[2],xmm12[3],xmm2[3],xmm12[4],xmm2[4],xmm12[5],xmm2[5],xmm12[6],xmm2[6],xmm12[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pandn %xmm12, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8],xmm2[8],xmm15[9],xmm2[9],xmm15[10],xmm2[10],xmm15[11],xmm2[11],xmm15[12],xmm2[12],xmm15[13],xmm2[13],xmm15[14],xmm2[14],xmm15[15],xmm2[15]
; SSE-NEXT:    pand %xmm3, %xmm15
; SSE-NEXT:    por %xmm6, %xmm15
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm2[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,7,6]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm6, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm15[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    pand %xmm11, %xmm6
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm12
; SSE-NEXT:    pandn %xmm2, %xmm12
; SSE-NEXT:    andps %xmm7, %xmm8
; SSE-NEXT:    por %xmm8, %xmm12
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pxor %xmm15, %xmm15
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm15[8],xmm6[9],xmm15[9],xmm6[10],xmm15[10],xmm6[11],xmm15[11],xmm6[12],xmm15[12],xmm6[13],xmm15[13],xmm6[14],xmm15[14],xmm6[15],xmm15[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm15[0],xmm2[1],xmm15[1],xmm2[2],xmm15[2],xmm2[3],xmm15[3],xmm2[4],xmm15[4],xmm2[5],xmm15[5],xmm2[6],xmm15[6],xmm2[7],xmm15[7]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,4,7,6]
; SSE-NEXT:    psrldq {{.*#+}} xmm6 = xmm6[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    packuswb %xmm6, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    pand %xmm4, %xmm13
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[0,2,2,3]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[1,3,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1]
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm15[8],xmm6[9],xmm15[9],xmm6[10],xmm15[10],xmm6[11],xmm15[11],xmm6[12],xmm15[12],xmm6[13],xmm15[13],xmm6[14],xmm15[14],xmm6[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm15[0],xmm2[1],xmm15[1],xmm2[2],xmm15[2],xmm2[3],xmm15[3],xmm2[4],xmm15[4],xmm2[5],xmm15[5],xmm2[6],xmm15[6],xmm2[7],xmm15[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm2[0],xmm0[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm15[0],xmm2[1],xmm15[1],xmm2[2],xmm15[2],xmm2[3],xmm15[3],xmm2[4],xmm15[4],xmm2[5],xmm15[5],xmm2[6],xmm15[6],xmm2[7],xmm15[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,6]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm11, %xmm8
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,3,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm2
; SSE-NEXT:    por %xmm2, %xmm8
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    pandn %xmm8, %xmm6
; SSE-NEXT:    andps %xmm7, %xmm0
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm15[0],xmm0[1],xmm15[1],xmm0[2],xmm15[2],xmm0[3],xmm15[3],xmm0[4],xmm15[4],xmm0[5],xmm15[5],xmm0[6],xmm15[6],xmm0[7],xmm15[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,4,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm15[8],xmm1[9],xmm15[9],xmm1[10],xmm15[10],xmm1[11],xmm15[11],xmm1[12],xmm15[12],xmm1[13],xmm15[13],xmm1[14],xmm15[14],xmm1[15],xmm15[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[3,3,3,3]
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    pshufd $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[1,3,2,3]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    # xmm10 = mem[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm0[0],xmm10[1],xmm0[1]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm15[0],xmm0[1],xmm15[1],xmm0[2],xmm15[2],xmm0[3],xmm15[3],xmm0[4],xmm15[4],xmm0[5],xmm15[5],xmm0[6],xmm15[6],xmm0[7],xmm15[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535,65535,0,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm8, %xmm13
; SSE-NEXT:    pandn %xmm0, %xmm13
; SSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm15[8],xmm10[9],xmm15[9],xmm10[10],xmm15[10],xmm10[11],xmm15[11],xmm10[12],xmm15[12],xmm10[13],xmm15[13],xmm10[14],xmm15[14],xmm10[15],xmm15[15]
; SSE-NEXT:    pand %xmm8, %xmm10
; SSE-NEXT:    por %xmm13, %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm10[2,1,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm10
; SSE-NEXT:    pand %xmm11, %xmm10
; SSE-NEXT:    por %xmm3, %xmm10
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    andps %xmm7, %xmm2
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,4,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm15[8],xmm2[9],xmm15[9],xmm2[10],xmm15[10],xmm2[11],xmm15[11],xmm2[12],xmm15[12],xmm2[13],xmm15[13],xmm2[14],xmm15[14],xmm2[15],xmm15[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pandn %xmm2, %xmm9
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    movdqa (%rsp), %xmm2 # 16-byte Reload
; SSE-NEXT:    por %xmm9, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,3,3,3]
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufd $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[1,3,2,3]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    # xmm10 = mem[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm1[0],xmm10[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1],xmm1[2],xmm15[2],xmm1[3],xmm15[3],xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm8, %xmm13
; SSE-NEXT:    pandn %xmm1, %xmm13
; SSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm15[8],xmm10[9],xmm15[9],xmm10[10],xmm15[10],xmm10[11],xmm15[11],xmm10[12],xmm15[12],xmm10[13],xmm15[13],xmm10[14],xmm15[14],xmm10[15],xmm15[15]
; SSE-NEXT:    pand %xmm8, %xmm10
; SSE-NEXT:    por %xmm13, %xmm10
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[2,1,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm10
; SSE-NEXT:    pand %xmm11, %xmm10
; SSE-NEXT:    por %xmm3, %xmm10
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn %xmm10, %xmm1
; SSE-NEXT:    andps %xmm7, %xmm2
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    por %xmm14, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm15[0],xmm2[1],xmm15[1],xmm2[2],xmm15[2],xmm2[3],xmm15[3],xmm2[4],xmm15[4],xmm2[5],xmm15[5],xmm2[6],xmm15[6],xmm2[7],xmm15[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,4,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm15[8],xmm3[9],xmm15[9],xmm3[10],xmm15[10],xmm3[11],xmm15[11],xmm3[12],xmm15[12],xmm3[13],xmm15[13],xmm3[14],xmm15[14],xmm3[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm15[8],xmm3[9],xmm15[9],xmm3[10],xmm15[10],xmm3[11],xmm15[11],xmm3[12],xmm15[12],xmm3[13],xmm15[13],xmm3[14],xmm15[14],xmm3[15],xmm15[15]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    pandn %xmm3, %xmm10
; SSE-NEXT:    movdqa %xmm3, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    por %xmm10, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[3,3,3,3]
; SSE-NEXT:    packuswb %xmm10, %xmm3
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movss {{.*#+}} xmm3 = xmm2[0],xmm3[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm11, %xmm10
; SSE-NEXT:    pandn %xmm2, %xmm10
; SSE-NEXT:    pshufd $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[1,3,2,3]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    # xmm13 = mem[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm2[0],xmm13[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm15[0],xmm2[1],xmm15[1],xmm2[2],xmm15[2],xmm2[3],xmm15[3],xmm2[4],xmm15[4],xmm2[5],xmm15[5],xmm2[6],xmm15[6],xmm2[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm8, %xmm14
; SSE-NEXT:    pandn %xmm2, %xmm14
; SSE-NEXT:    punpckhbw {{.*#+}} xmm13 = xmm13[8],xmm15[8],xmm13[9],xmm15[9],xmm13[10],xmm15[10],xmm13[11],xmm15[11],xmm13[12],xmm15[12],xmm13[13],xmm15[13],xmm13[14],xmm15[14],xmm13[15],xmm15[15]
; SSE-NEXT:    pand %xmm8, %xmm13
; SSE-NEXT:    por %xmm14, %xmm13
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm13[2,1,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm2
; SSE-NEXT:    por %xmm10, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm10
; SSE-NEXT:    pandn %xmm2, %xmm10
; SSE-NEXT:    andps %xmm7, %xmm3
; SSE-NEXT:    por %xmm3, %xmm10
; SSE-NEXT:    por %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm15[0],xmm2[1],xmm15[1],xmm2[2],xmm15[2],xmm2[3],xmm15[3],xmm2[4],xmm15[4],xmm2[5],xmm15[5],xmm2[6],xmm15[6],xmm2[7],xmm15[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,4,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm15[8],xmm4[9],xmm15[9],xmm4[10],xmm15[10],xmm4[11],xmm15[11],xmm4[12],xmm15[12],xmm4[13],xmm15[13],xmm4[14],xmm15[14],xmm4[15],xmm15[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm15[8],xmm3[9],xmm15[9],xmm3[10],xmm15[10],xmm3[11],xmm15[11],xmm3[12],xmm15[12],xmm3[13],xmm15[13],xmm3[14],xmm15[14],xmm3[15],xmm15[15]
; SSE-NEXT:    pxor %xmm14, %xmm14
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pandn %xmm3, %xmm9
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    por %xmm9, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[3,3,3,3]
; SSE-NEXT:    packuswb %xmm13, %xmm3
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movss {{.*#+}} xmm3 = xmm2[0],xmm3[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    pshufd $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[1,3,2,3]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    # xmm13 = mem[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm2[0],xmm13[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm14[0],xmm2[1],xmm14[1],xmm2[2],xmm14[2],xmm2[3],xmm14[3],xmm2[4],xmm14[4],xmm2[5],xmm14[5],xmm2[6],xmm14[6],xmm2[7],xmm14[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm13 = xmm13[8],xmm14[8],xmm13[9],xmm14[9],xmm13[10],xmm14[10],xmm13[11],xmm14[11],xmm13[12],xmm14[12],xmm13[13],xmm14[13],xmm13[14],xmm14[14],xmm13[15],xmm14[15]
; SSE-NEXT:    pand %xmm8, %xmm13
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    por %xmm13, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm8[2,1,1,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,0,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm9[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm8, %xmm8
; SSE-NEXT:    pandn %xmm8, %xmm11
; SSE-NEXT:    por %xmm11, %xmm2
; SSE-NEXT:    andps %xmm7, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm7
; SSE-NEXT:    por %xmm3, %xmm7
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm6, (%rax)
; SSE-NEXT:    movdqa %xmm12, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rax)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm7, (%rax)
; SSE-NEXT:    movdqa %xmm10, 48(%rax)
; SSE-NEXT:    movdqa %xmm1, 32(%rax)
; SSE-NEXT:    movdqa %xmm0, 16(%rax)
; SSE-NEXT:    addq $1512, %rsp # imm = 0x5E8
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: load_i8_stride7_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $728, %rsp # imm = 0x2D8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,u,128,128,128,6,13,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa 400(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm13, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm9
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm2 = <128,128,128,5,12,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa 240(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm3, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = <0,7,14,128,128,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa 224(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm5, %xmm5
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm5, %xmm7
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,u,3,10,128,128,128,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa 256(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm5, %xmm6
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,u,u,128,128,1,8,15,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa 272(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm5, %xmm8, %xmm8
; AVX1-ONLY-NEXT:    vpor %xmm6, %xmm8, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <255,255,255,255,255,0,0,0,0,0,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm6, %xmm7, %xmm8, %xmm7
; AVX1-ONLY-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm8, %xmm2
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm9, %xmm3
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vpshufb %xmm5, %xmm7, %xmm4
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,u,u,u,u,1,8,15,128,128,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm6, %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 384(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vpshufb %xmm8, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, %xmm5
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,u,128,128,3,10,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa 368(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm4, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, %xmm11
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,5,12,128,128,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa 352(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm4, %xmm9
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, %xmm14
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm9, %xmm9
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,u,0,0,0,0,255,255,255,255,255,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm10, %xmm2, %xmm9, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 176(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, %xmm7
; AVX1-ONLY-NEXT:    vmovdqa 160(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpshufb %xmm8, %xmm4, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, %xmm9
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa 144(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm4, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, %xmm15
; AVX1-ONLY-NEXT:    vmovdqa 128(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm12, %xmm3
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vpblendvb %xmm10, %xmm0, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,u,2,9,128,128,128,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm5, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,u,u,u,128,128,0,7,14,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa %xmm13, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm13, %xmm6
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm6, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,128,128,4,11,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm5, %xmm11, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, %xmm6
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm13 = <u,u,u,6,13,128,128,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm14, %xmm11
; AVX1-ONLY-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpor %xmm8, %xmm11, %xmm8
; AVX1-ONLY-NEXT:    vpblendvb %xmm10, %xmm3, %xmm8, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm9, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm7, %xmm2
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm5, %xmm15, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm12, %xmm3
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vpblendvb %xmm10, %xmm0, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,128,128,128,5,12,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm6, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,0,7,14,128,128,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm14, %xmm3
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,u,u,u,3,10,128,128,128,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm1, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,u,u,128,128,1,8,15,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm4, %xmm10
; AVX1-ONLY-NEXT:    vpor %xmm8, %xmm10, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,255,255,255,255,255,0,0,0,0,0,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm10, %xmm3, %xmm8, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm15, %xmm0
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm12, %xmm1
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm9, %xmm1
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm7, %xmm2
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpblendvb %xmm10, %xmm0, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = <128,128,128,6,13,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm13, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm2 = <1,8,15,128,128,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm4, %xmm3
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,128,128,2,9,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm9, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,u,u,4,11,128,128,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm8, %xmm15, %xmm10
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm10, %xmm10
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm7 = <255,255,255,255,255,0,0,0,0,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm7, %xmm3, %xmm10, %xmm0
; AVX1-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm12, %xmm2
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm2, %xmm11
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm0, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm8, %xmm10, %xmm3
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vpblendvb %xmm7, %xmm11, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm14 = <2,9,128,128,128,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm14, %xmm4, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, %xmm7
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = <128,128,0,7,14,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm13, %xmm6
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,128,128,3,10,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm9, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,u,5,12,128,128,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm15, %xmm11
; AVX1-ONLY-NEXT:    vpor %xmm8, %xmm11, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = <255,255,255,255,255,0,0,0,0,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm11, %xmm2, %xmm8, %xmm2
; AVX1-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm14, %xmm12, %xmm5
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm1, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, %xmm14
; AVX1-ONLY-NEXT:    vpor %xmm5, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm0, %xmm2
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm10, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, %xmm4
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vpblendvb %xmm11, %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, %xmm5
; AVX1-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm1 = <3,10,128,128,128,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm7, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm2 = <128,128,1,8,15,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm13, %xmm6
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm6, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,u,u,u,128,128,4,11,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm9, %xmm10
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,6,13,128,128,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm15, %xmm11
; AVX1-ONLY-NEXT:    vpor %xmm10, %xmm11, %xmm10
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, %xmm7
; AVX1-ONLY-NEXT:    vpblendvb %xmm5, %xmm8, %xmm10, %xmm5
; AVX1-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm12, %xmm1
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm14, %xmm2
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm0, %xmm2
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm4, %xmm3
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX1-ONLY-NEXT:    vpblendvb %xmm7, %xmm1, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,128,128,128,6,13,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm10, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,1,8,15,128,128,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm15, %xmm3
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,u,u,u,u,u,128,128,2,9,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm7, %xmm6
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,u,u,u,4,11,128,128,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm9, %xmm8
; AVX1-ONLY-NEXT:    vpor %xmm6, %xmm8, %xmm6
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,255,255,255,255,255,0,0,0,0,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpblendvb %xmm8, %xmm1, %xmm6, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm5, %xmm1
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm13, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm14, %xmm2
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpblendvb %xmm8, %xmm0, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,2,9,128,128,128,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm15, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,128,128,0,7,14,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm10, %xmm3
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,u,u,128,128,3,10,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm7, %xmm11
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,u,5,12,128,128,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm9, %xmm12
; AVX1-ONLY-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX1-ONLY-NEXT:    vpblendvb %xmm8, %xmm3, %xmm11, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, (%rsp) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm5, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, %xmm11
; AVX1-ONLY-NEXT:    vpshufb %xmm2, %xmm4, %xmm2
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm13, %xmm2
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm14, %xmm0
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendvb %xmm8, %xmm1, %xmm0, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,3,10,128,128,128,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm15, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,128,128,1,8,15,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, %xmm5
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm10, %xmm2
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,u,u,u,u,128,128,4,11,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm12, %xmm7, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,u,6,13,128,128,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm9, %xmm10
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm10, %xmm3
; AVX1-ONLY-NEXT:    vpblendvb %xmm8, %xmm2, %xmm3, %xmm7
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm11, %xmm1
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm4, %xmm2
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vpshufb %xmm12, %xmm13, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm13, %xmm15
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm14, %xmm0
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendvb %xmm8, %xmm1, %xmm0, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa 432(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vmovdqa 416(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,u,u,u,u,u,u,128,128,128,5,12>
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm11, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,u,u,u,u,u,0,7,14,128,128>
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm12, %xmm10
; AVX1-ONLY-NEXT:    vpor %xmm8, %xmm10, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,255,255,255,255,255,255,255,255,255,0,0,0,0,0>
; AVX1-ONLY-NEXT:    vpblendvb %xmm2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 208(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm8, %xmm6
; AVX1-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX1-ONLY-NEXT:    vpor %xmm6, %xmm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendvb %xmm2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,u,u,u,u,u,u,u,u,u,128,128,128,6,13>
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm11, %xmm6
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,u,u,u,u,u,1,8,15,128,128>
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm12, %xmm10
; AVX1-ONLY-NEXT:    vpor %xmm6, %xmm10, %xmm6
; AVX1-ONLY-NEXT:    vpblendvb %xmm2, (%rsp), %xmm6, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm8, %xmm1
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendvb %xmm2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,u,u,u,u,u,2,9,128,128,128>
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm12, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,u,u,u,u,u,u,128,128,0,7,14>
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm11, %xmm9
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm9, %xmm1
; AVX1-ONLY-NEXT:    vpblendvb %xmm2, %xmm7, %xmm1, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm8, %xmm1
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vpblendvb %xmm2, %xmm4, %xmm0, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm14 = <2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm14, %xmm5, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,4,11,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm3, %xmm4
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,u,u,u,u,128,128,128,5,12,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm3, %xmm6
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,u,u,0,7,14,128,128,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm3, %xmm7
; AVX1-ONLY-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0],xmm5[1,2],xmm6[3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,u,u,u,u,u,u,u,u,3,10,128,128,128>
; AVX1-ONLY-NEXT:    vpshufb %xmm5, %xmm12, %xmm9
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm7 = <u,u,u,u,u,u,u,u,u,u,u,128,128,1,8,15>
; AVX1-ONLY-NEXT:    vpshufb %xmm7, %xmm11, %xmm10
; AVX1-ONLY-NEXT:    vpor %xmm9, %xmm10, %xmm9
; AVX1-ONLY-NEXT:    vpblendvb %xmm2, %xmm6, %xmm9, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm14, %xmm3, %xmm6
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm15, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm4, %xmm1
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb %xmm5, %xmm13, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm7, %xmm8, %xmm4
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm4, %xmm1
; AVX1-ONLY-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm14 = <u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm14, %xmm11, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm12, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, %xmm5
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpblendw $63, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1,2,3,4,5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 304(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm1[u,u,u,u,4,11,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa 288(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vpshufb %xmm1, %xmm7, %xmm9
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, %xmm6
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm9[0],xmm4[0],xmm9[1],xmm4[1]
; AVX1-ONLY-NEXT:    vmovdqa 320(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm4 = xmm4[10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm10 = xmm4[u,u,u,u,u,u,u,u,u,u,0,1,2,3,8,15]
; AVX1-ONLY-NEXT:    vmovdqa 336(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm15 = xmm2[0,7,14,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535,65535,0,0,0,0,0,65535,65535,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm10, %ymm2, %ymm10
; AVX1-ONLY-NEXT:    vorps %ymm10, %ymm15, %ymm10
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm15
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX1-ONLY-NEXT:    vandnps %ymm15, %ymm4, %ymm15
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vorps %ymm15, %ymm10, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm14, %xmm8, %xmm10
; AVX1-ONLY-NEXT:    vpshufb %xmm5, %xmm13, %xmm14
; AVX1-ONLY-NEXT:    vmovdqa %xmm13, %xmm5
; AVX1-ONLY-NEXT:    vmovdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm14[0],xmm10[0],xmm14[1],xmm10[1],xmm14[2],xmm10[2],xmm14[3],xmm10[3]
; AVX1-ONLY-NEXT:    vpblendw $63, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = mem[0,1,2,3,4,5],xmm10[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm15 = xmm0[u,u,u,u,4,11,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm9, %xmm6
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm6 = xmm6[10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm6[u,u,u,u,u,u,u,u,u,u,0,1,2,3,8,15]
; AVX1-ONLY-NEXT:    vmovdqa 112(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm6[0,7,14,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, %xmm14
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm13 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm13, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm4, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm11[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm12[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm13[0],xmm2[0],xmm13[1],xmm2[1],xmm13[2],xmm2[2],xmm13[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpblendw $63, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm13 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm13 = mem[0,1,2,3,4,5],xmm2[6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm6[u,u,u,u,5,12,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[u,u,u,u,u,0,7,14,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX1-ONLY-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6],xmm0[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm1[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm1[3,10]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, %xmm2
; AVX1-ONLY-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm15[1,8,15,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm3 = [0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX1-ONLY-NEXT:    vandnps {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm4, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm10[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm5[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpblendw $63, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1,2,3,4,5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm5[u,u,u,u,5,12,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm9[u,u,u,u,u,0,7,14,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm13[0],xmm1[0],xmm13[1],xmm1[1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6],mem[7]
; AVX1-ONLY-NEXT:    vpxor %xmm9, %xmm9, %xmm9
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm8[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm8[3,10]
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm13, %xmm1
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm14[1,8,15,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vandnps {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm13 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm13, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm11[u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm12[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpblendw $63, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1,2,3,4,5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,u,u,u,u,u,u,u,u,u,u,6,13,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm6, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,u,u,u,u,u,u,u,u,u,1,8,15>
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, %xmm6
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm7, %xmm11
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm11[2],xmm1[2],xmm11[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6],xmm9[7]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,u,u,u,u,u,128,128,128,128,128,4,11>
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, %xmm7
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm2, %xmm12
; AVX1-ONLY-NEXT:    vpor %xmm1, %xmm12, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm9 = <2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm9, %xmm15, %xmm12
; AVX1-ONLY-NEXT:    vmovdqa %xmm15, %xmm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm1, %ymm12
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm1 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX1-ONLY-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm13 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm1, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm13
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm0 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,0,0]
; AVX1-ONLY-NEXT:    vandnps %ymm13, %ymm0, %ymm13
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm13, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vmovups %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm10[u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm10[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1],xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX1-ONLY-NEXT:    vpblendw $63, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm12 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm12 = mem[0,1,2,3,4,5],xmm12[6,7]
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm5, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, %xmm15
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpxor %xmm13, %xmm13, %xmm13
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6],xmm13[7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm10, %xmm4
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm9, %xmm14, %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm4 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm1, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vandnps %ymm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm4, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,u,u,u,u,u,2,9,128,128,128,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm6, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, %xmm9
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,u,u,u,u,u,128,128,0,7,14,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm8, %xmm12
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm12, %xmm3
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6],xmm13[7]
; AVX1-ONLY-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,u,u,u,u,u,u,128,128,128,128,128,5,12>
; AVX1-ONLY-NEXT:    vpshufb %xmm12, %xmm7, %xmm13
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm13, %xmm13
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm2, %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm13, %ymm3
; AVX1-ONLY-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm13 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm1, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm13, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm13, %ymm0, %ymm13
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm13, %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm5, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, %xmm2
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm15, %xmm4
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6],xmm8[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm12, %xmm10, %xmm4
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm14, %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm4 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm1, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm4 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm4, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm15 = <2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm15, %xmm8, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm10 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm10, %xmm5, %xmm11
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm11[0],xmm3[0],xmm11[1],xmm3[1],xmm11[2],xmm3[2],xmm11[3],xmm3[3]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm7[u,u,u,u],zero,zero,zero,xmm7[5,12,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[u,u,u,u,0,7,14],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm12, %xmm4
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm9[u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm9[u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,u,u,u,u,u,128,128,1,8,15,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm9, %xmm13
; AVX1-ONLY-NEXT:    vpor %xmm12, %xmm13, %xmm12
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,5,6],mem[7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm9[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm9[6,13]
; AVX1-ONLY-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm10, %xmm9, %xmm12
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vandnps %ymm11, %ymm1, %ymm11
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm11, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm11 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm11, %ymm0, %ymm11
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm11, %ymm3
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm15, %xmm14, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm10, %xmm9, %xmm11
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, %xmm13
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm11[0],xmm3[0],xmm11[1],xmm3[1],xmm11[2],xmm3[2],xmm11[3],xmm3[3]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[u,u,u,u],zero,zero,zero,xmm10[5,12,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm15[u,u,u,u,0,7,14],zero,zero,xmm15[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm11[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm2[u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm2[u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm12, %xmm4
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1,2,3,4,5,6],mem[7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,zero,xmm4[6,13]
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm13, %xmm4, %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rsp), %ymm0, %ymm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = <5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm5, %xmm4
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm7[u,u,u,u],zero,zero,zero,xmm7[6,13,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm6[u,u,u,u,1,8,15],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, %xmm8
; AVX1-ONLY-NEXT:    vpor %xmm11, %xmm13, %xmm11
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm11[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm7[u,u,u,u,u,u,u,u,u],zero,zero,xmm7[2,9,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,u,u,u,u,4,11,128,128,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm4, %xmm13
; AVX1-ONLY-NEXT:    vpor %xmm11, %xmm13, %xmm13
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,u,u,u,u,u,u,u,9,10,11,12],zero,zero,zero
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,u,u,u,u,u,128,128,128,128,0,7,14>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm5, %xmm11
; AVX1-ONLY-NEXT:    vpor %xmm11, %xmm13, %xmm11
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm13, %xmm13
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vandnps %ymm11, %ymm1, %ymm11
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm11, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm11 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm11, %ymm0, %ymm11
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm11, %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm9, %xmm11
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm11[0],xmm2[0],xmm11[1],xmm2[1],xmm11[2],xmm2[2],xmm11[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[u,u,u,u],zero,zero,zero,xmm10[6,13,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm13 = xmm15[u,u,u,u,1,8,15],zero,zero,xmm15[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vpor %xmm11, %xmm13, %xmm11
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm11[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm11 = xmm12[u,u,u,u,u,u,u,u,u],zero,zero,xmm12[2,9,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm10, %xmm12
; AVX1-ONLY-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,u,u,u,u,u,u,9,10,11,12,128,128,128>
; AVX1-ONLY-NEXT:    vpshufb %xmm9, %xmm11, %xmm11
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm6, %xmm4
; AVX1-ONLY-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm13, %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm1, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm4 = <6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm2, %xmm11
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm11[0],xmm3[0],xmm11[1],xmm3[1],xmm11[2],xmm3[2],xmm11[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,2,9],zero,zero,zero,xmm8[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,128,128,0,7,14,u,u,u,u,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm2, %xmm2
; AVX1-ONLY-NEXT:    vpor %xmm2, %xmm12, %xmm2
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1],xmm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,u,u,u,u,u,u,u,128,128,3,10,u,u,u>
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm7, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,u,u,u,u,u,u,5,12,128,128,u,u,u>
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm12, %xmm7, %xmm7
; AVX1-ONLY-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX1-ONLY-NEXT:    vpshufb %xmm9, %xmm7, %xmm7
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,u,u,u,u,u,u,128,128,128,128,1,8,15>
; AVX1-ONLY-NEXT:    vpshufb %xmm8, %xmm5, %xmm9
; AVX1-ONLY-NEXT:    vpor %xmm7, %xmm9, %xmm7
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm5, %xmm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vandnps %ymm5, %ymm1, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm5, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm5 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm5, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = xmm14[4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm7, %xmm7
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm7 = xmm15[u,u,u,u,2,9],zero,zero,zero,xmm15[u,u,u,u,u,u,u]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm11, %xmm9, %xmm9
; AVX1-ONLY-NEXT:    vpor %xmm7, %xmm9, %xmm7
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm7[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm7, %xmm3
; AVX1-ONLY-NEXT:    vpshufb %xmm12, %xmm10, %xmm7
; AVX1-ONLY-NEXT:    vpor %xmm3, %xmm7, %xmm3
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u,u,u,u,9,10,11,12],zero,zero,zero
; AVX1-ONLY-NEXT:    vpshufb %xmm8, %xmm6, %xmm7
; AVX1-ONLY-NEXT:    vpor %xmm7, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vpshufb %xmm4, %xmm13, %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm5, %ymm4
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm4, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%r9)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%rax)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 32(%rax)
; AVX1-ONLY-NEXT:    addq $728, %rsp # imm = 0x2D8
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: load_i8_stride7_vf64:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $760, %rsp # imm = 0x2F8
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm8
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm6
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX2-SLOW-NEXT:    vmovdqa 320(%rdi), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa 288(%rdi), %ymm5
; AVX2-SLOW-NEXT:    vmovdqa 224(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqa 256(%rdi), %ymm10
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm1, %ymm10, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, %ymm14
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, %ymm12
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm1 = <128,128,128,5,12,128,128,1,8,15,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm2 = <0,7,14,128,128,3,10,128,128,128,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm4, %ymm5, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa %ymm9, %ymm15
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, %ymm9
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, %ymm11
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7,8,9],ymm4[10],ymm3[11,12],ymm4[13],ymm3[14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,0,7,14,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm4, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm0, %ymm5, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm8, %ymm6, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, %ymm13
; AVX2-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-SLOW-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm6
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; AVX2-SLOW-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm6, %ymm7, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, %ymm8
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm5[2],ymm2[3,4],ymm5[5],ymm2[6,7,8,9],ymm5[10],ymm2[11,12],ymm5[13],ymm2[14,15]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm9, %ymm11, %ymm1
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7,8,9],ymm2[10],ymm1[11,12,13],ymm2[14],ymm1[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm12, %ymm10, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, %ymm6
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm1 = <128,128,128,6,13,128,128,2,9,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm1, %xmm5, %xmm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm10 = <1,8,15,128,128,4,11,128,128,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm10, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,1,8,15,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm5, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = <0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm2, %ymm4, %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm7, %ymm8, %ymm2
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4,5],ymm4[6],ymm2[7,8,9],ymm4[10],ymm2[11,12,13],ymm4[14],ymm2[15]
; AVX2-SLOW-NEXT:    vpshufb %ymm5, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm13, %ymm0, %ymm4
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-SLOW-NEXT:    vpshufb %xmm1, %xmm5, %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm10, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vpor %xmm1, %xmm4, %xmm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm2, %ymm1, %ymm11
; AVX2-SLOW-NEXT:    vmovdqa 384(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqa 352(%rdi), %ymm13
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm13, %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, %ymm7
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, %ymm10
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,128,128,3,10,128,128,128,6,13,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm5, %xmm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,5,12,128,128,1,8,15,128,128,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm12, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vmovdqa 432(%rdi), %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm1, %xmm5
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vmovdqa 416(%rdi), %xmm3
; AVX2-SLOW-NEXT:    vpshufb %xmm0, %xmm3, %xmm14
; AVX2-SLOW-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, %xmm8
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm14[0],xmm5[0],xmm14[1],xmm5[1],xmm14[2],xmm5[2],xmm14[3],xmm5[3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5,6],ymm5[7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 160(%rdi), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm5
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm4, %ymm5, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm15
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm15, %xmm9
; AVX2-SLOW-NEXT:    vpshufb %xmm12, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpor %xmm0, %xmm9, %xmm0
; AVX2-SLOW-NEXT:    vmovdqa 208(%rdi), %xmm10
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm10, %xmm9
; AVX2-SLOW-NEXT:    vmovdqa %xmm10, %xmm2
; AVX2-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm10
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm10, %xmm12
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm12[0],xmm9[0],xmm12[1],xmm9[1],xmm12[2],xmm9[2],xmm12[3],xmm9[3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm9[7]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm7, %ymm13, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm7 = <u,u,u,6,13,128,128,2,9,128,128,128,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm0, %xmm9
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,128,128,4,11,128,128,0,7,14,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm12, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpor %xmm0, %xmm9, %xmm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm1, %xmm13
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm15 = <u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm15, %xmm3, %xmm8
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm13[0],xmm8[1],xmm13[1],xmm8[2],xmm13[2],xmm8[3],xmm13[3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm8[7]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm0
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm0, %xmm3
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-SLOW-NEXT:    vpshufb %xmm12, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm2, %xmm3
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, %xmm13
; AVX2-SLOW-NEXT:    vpshufb %xmm15, %xmm10, %xmm6
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm3[7]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm11, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm11, %ymm7, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,128,128,128,6,13,128,128,2,9,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,1,8,15,128,128,4,11,128,128,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,u,u,u,u,u,u,u,u,u,128,128,128,5,12>
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm1, %xmm15, %xmm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,u,u,u,u,u,u,u,u,0,7,14,128,128>
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm14, %xmm12
; AVX2-SLOW-NEXT:    vpor %xmm8, %xmm12, %xmm8
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm12
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX2-SLOW-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm12, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm5, %ymm4, %ymm8
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm12
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm12, %xmm3
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm8, %xmm6
; AVX2-SLOW-NEXT:    vpor %xmm3, %xmm6, %xmm3
; AVX2-SLOW-NEXT:    vmovdqa %xmm13, %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshufb %xmm1, %xmm13, %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm10, %xmm6
; AVX2-SLOW-NEXT:    vpor %xmm1, %xmm6, %xmm1
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm3, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm11, %ymm7, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm7 = <u,u,2,9,128,128,128,5,12,128,128,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm1, %xmm6
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,128,128,0,7,14,128,128,3,10,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,u,u,u,u,u,u,128,128,128,6,13>
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm15, %xmm9
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,u,u,u,u,u,u,u,u,1,8,15,128,128>
; AVX2-SLOW-NEXT:    vpshufb %xmm12, %xmm14, %xmm13
; AVX2-SLOW-NEXT:    vpor %xmm9, %xmm13, %xmm9
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm9, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm1
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm1, %xmm3
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm2, %xmm3
; AVX2-SLOW-NEXT:    vpshufb %xmm12, %xmm10, %xmm6
; AVX2-SLOW-NEXT:    vmovdqa %xmm10, %xmm2
; AVX2-SLOW-NEXT:    vpor %xmm3, %xmm6, %xmm3
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm11, %ymm7, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, %ymm15
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,3,10,128,128,128,6,13,128,128,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm1, %xmm6
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,128,128,1,8,15,128,128,4,11,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,u,u,u,u,u,u,2,9,128,128,128>
; AVX2-SLOW-NEXT:    vmovdqa %xmm14, %xmm9
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm14, %xmm12
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm13 = <u,u,u,u,u,u,u,u,u,u,u,128,128,0,7,14>
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm13, %xmm10, %xmm14
; AVX2-SLOW-NEXT:    vpor %xmm12, %xmm14, %xmm12
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm12, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm5, %ymm4, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, %ymm15
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm1, %xmm3
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm2, %xmm3
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, %xmm5
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm13, %xmm14, %xmm6
; AVX2-SLOW-NEXT:    vpor %xmm3, %xmm6, %xmm3
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-SLOW-NEXT:    vmovdqa %ymm11, %ymm3
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm11, %ymm7, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = <255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm7, %ymm3, %ymm1
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,128,128,2,9,128,128,128,5,12,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,4,11,128,128,0,7,14,128,128,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,u,u,u,u,u,u,u,3,10,128,128,128>
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm9, %xmm7
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,u,u,u,u,u,u,u,u,128,128,1,8,15>
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm10, %xmm13
; AVX2-SLOW-NEXT:    vpor %xmm7, %xmm13, %xmm7
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm7, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm15, %ymm4, %ymm7
; AVX2-SLOW-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %ymm11, %ymm12
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm4, %ymm15, %ymm1
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm14, %xmm3
; AVX2-SLOW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm1, %ymm10, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm1, %ymm10, %ymm15
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm10, %ymm1, %ymm11
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm10, %ymm1, %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm10, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm1, %ymm10, %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm10, %ymm1, %ymm3
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm10, %ymm1, %ymm7
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm1, %ymm10, %ymm14
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm1, %ymm10, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm2, %ymm1, %ymm9
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm2, %ymm1, %ymm5
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm2, %ymm1, %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm1, %ymm2, %ymm10
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm2, %ymm4, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm2, %ymm4, %ymm6
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm2, %ymm4, %ymm10
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm4, %ymm2, %ymm12
; AVX2-SLOW-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm4, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm12 = <2,9,128,128,128,5,12,128,128,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm12, %xmm0, %xmm2
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm13 = <128,128,0,7,14,128,128,3,10,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm13, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm4
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm9, %xmm0
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm9[0,1,2],ymm0[3],ymm9[4,5],ymm0[6],ymm9[7,8,9,10],ymm0[11],ymm9[12,13],ymm0[14],ymm9[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm9, %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm4, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb %xmm12, %xmm3, %xmm2
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX2-SLOW-NEXT:    vpshufb %xmm13, %xmm3, %xmm3
; AVX2-SLOW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm3
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1,2],ymm3[3],ymm1[4,5],ymm3[6],ymm1[7,8,9,10],ymm3[11],ymm1[12,13],ymm3[14],ymm1[15]
; AVX2-SLOW-NEXT:    vpshufb %ymm9, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm2, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm1 = <3,10,128,128,128,6,13,128,128,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm1, %xmm15, %xmm2
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm15, %xmm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = <128,128,1,8,15,128,128,4,11,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX2-SLOW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm3
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm5[1,2],ymm3[3],ymm5[4,5,6],ymm3[7,8],ymm5[9,10],ymm3[11],ymm5[12,13,14],ymm3[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm5, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vpshufb %xmm1, %xmm7, %xmm1
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm3
; AVX2-SLOW-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX2-SLOW-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm6, %xmm3
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm6[1,2],ymm3[3],ymm6[4,5,6],ymm3[7,8],ymm6[9,10],ymm3[11],ymm6[12,13,14],ymm3[15]
; AVX2-SLOW-NEXT:    vpshufb %ymm5, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm15
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = <128,128,2,9,128,128,128,5,12,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm5 = <4,11,128,128,0,7,14,128,128,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm11, %xmm3
; AVX2-SLOW-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm3
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm8[1,2,3],ymm3[4],ymm8[5,6],ymm3[7,8],ymm8[9,10,11],ymm3[12],ymm8[13,14],ymm3[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm6, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm14, %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm14, %xmm4
; AVX2-SLOW-NEXT:    vpor %xmm1, %xmm4, %xmm1
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm10, %xmm4
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm10[1,2,3],ymm4[4],ymm10[5,6],ymm4[7,8],ymm10[9,10,11],ymm4[12],ymm10[13,14],ymm4[15]
; AVX2-SLOW-NEXT:    vpshufb %ymm6, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm4, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm5 = <128,128,3,10,128,128,128,6,13,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm6 = <5,12,128,128,1,8,15,128,128,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm7, %xmm7
; AVX2-SLOW-NEXT:    vpor %xmm4, %xmm7, %xmm4
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm7
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2,3],ymm7[4],ymm8[5,6,7,8],ymm7[9],ymm8[10,11],ymm7[12],ymm8[13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = <u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm8, %ymm7, %ymm7
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm4, %ymm7, %ymm4
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm9, %xmm7
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm7, %xmm5
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm9, %xmm6
; AVX2-SLOW-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm6
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2,3],ymm6[4],ymm7[5,6,7,8],ymm6[9],ymm7[10,11],ymm6[12],ymm7[13,14,15]
; AVX2-SLOW-NEXT:    vpshufb %ymm8, %ymm6, %ymm6
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm5, %ymm6, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm6 = <6,13,128,128,2,9,128,128,128,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm8, %xmm7
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = <128,128,4,11,128,128,0,7,14,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm8, %xmm8
; AVX2-SLOW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm10, %xmm8
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm10[0],ymm8[1],ymm10[2,3,4],ymm8[5],ymm10[6,7,8],ymm8[9],ymm10[10,11,12],ymm8[13],ymm10[14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = <u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm10, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm7, %ymm8, %ymm7
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm8, %xmm6
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm8, %xmm8
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm8, %xmm6
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm9, %xmm8
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2,3,4],ymm8[5],ymm9[6,7,8],ymm8[9],ymm9[10,11,12],ymm8[13],ymm9[14,15]
; AVX2-SLOW-NEXT:    vpshufb %ymm10, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm6, %ymm8, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm10, %xmm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,128,128,128,5,12,128,128,1,8,15,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm6, %xmm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,0,7,14,128,128,3,10,128,128,128,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm10, %xmm10
; AVX2-SLOW-NEXT:    vpor %xmm6, %xmm10, %xmm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm13 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm13, %xmm10, %xmm10
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm11, %xmm12, %xmm12
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm12[0],xmm10[0],xmm12[1],xmm10[1],xmm12[2],xmm10[2],xmm12[3],xmm10[3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5,6],ymm10[7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm10[0],ymm6[1,2,3,4,5,6,7],ymm10[8],ymm6[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm10[0,1,2,3],ymm6[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm12, %xmm10
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm10, %xmm8
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm12, %xmm9
; AVX2-SLOW-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm13, %xmm9, %xmm9
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm11, %xmm10, %xmm10
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5,6],ymm9[7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1,2,3,4,5,6,7],ymm9[8],ymm8[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm9 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm9 = ymm2[0],mem[1,2,3,4,5,6,7],ymm2[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm9[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm9 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm9 = ymm15[0],mem[1,2,3,4,5,6,7],ymm15[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm15[0,1,2,3],ymm9[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = ymm3[0],mem[1,2,3,4,5,6,7],ymm3[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm10[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = ymm1[0],mem[1,2,3,4,5,6,7],ymm1[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm10[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = ymm4[0],mem[1,2,3,4,5,6,7],ymm4[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm10[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = ymm5[0],mem[1,2,3,4,5,6,7],ymm5[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm10[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = ymm7[0],mem[1,2,3,4,5,6,7],ymm7[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm10[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = ymm0[0],mem[1,2,3,4,5,6,7],ymm0[8],mem[9,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm10[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm10, (%rsi)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm10, 32(%rsi)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm10, (%rdx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm10, 32(%rdx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, (%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm9, (%r8)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, 32(%r8)
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, 32(%r9)
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, (%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, 32(%rax)
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, 32(%rax)
; AVX2-SLOW-NEXT:    addq $760, %rsp # imm = 0x2F8
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: load_i8_stride7_vf64:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $728, %rsp # imm = 0x2D8
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm6
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm8
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX2-FAST-NEXT:    vmovdqa 320(%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqa 288(%rdi), %ymm5
; AVX2-FAST-NEXT:    vmovdqa 224(%rdi), %ymm1
; AVX2-FAST-NEXT:    vmovdqa 256(%rdi), %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm3, %ymm14
; AVX2-FAST-NEXT:    vmovdqa %ymm2, %ymm9
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm10
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm1 = <128,128,128,5,12,128,128,1,8,15,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = <0,7,14,128,128,3,10,128,128,128,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm4, %ymm5, %ymm3
; AVX2-FAST-NEXT:    vmovdqa %ymm5, %ymm11
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa %ymm4, %ymm13
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7,8,9],ymm4[10],ymm3[11,12],ymm4[13],ymm3[14,15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,0,7,14,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm12 = [255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm6, %ymm8, %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa %ymm6, %ymm5
; AVX2-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm6
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %ymm6
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm4, %xmm2
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX2-FAST-NEXT:    vmovdqa %ymm7, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm6, %ymm7, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4],ymm4[5],ymm2[6,7,8,9],ymm4[10],ymm2[11,12],ymm4[13],ymm2[14,15]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm1, %ymm2, %ymm12
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm11, %ymm13, %ymm2
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4,5],ymm3[6],ymm2[7,8,9],ymm3[10],ymm2[11,12,13],ymm3[14],ymm2[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm10, %ymm9, %ymm3
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm10
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = <128,128,128,6,13,128,128,2,9,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm4, %xmm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm7 = <1,8,15,128,128,4,11,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm7, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,1,8,15,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm4, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm2, %ymm3, %ymm13
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm0, %ymm6, %ymm2
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4,5],ymm3[6],ymm2[7,8,9],ymm3[10],ymm2[11,12,13],ymm3[14],ymm2[15]
; AVX2-FAST-NEXT:    vpshufb %ymm4, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm5, %ymm8, %ymm3
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm4, %xmm4
; AVX2-FAST-NEXT:    vpshufb %xmm7, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm2, %ymm3, %ymm7
; AVX2-FAST-NEXT:    vmovdqa 384(%rdi), %ymm1
; AVX2-FAST-NEXT:    vmovdqa 352(%rdi), %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm4
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm2
; AVX2-FAST-NEXT:    vmovdqa %ymm0, %ymm14
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,128,128,3,10,128,128,128,6,13,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm5, %xmm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,5,12,128,128,1,8,15,128,128,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm4, %xmm4
; AVX2-FAST-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FAST-NEXT:    vmovdqa 416(%rdi), %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [1,2,0,2,1,2,4,6]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm10, %ymm5
; AVX2-FAST-NEXT:    vmovdqa %ymm0, %ymm6
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,0,7,10,13>
; AVX2-FAST-NEXT:    vpshufb %ymm11, %ymm5, %ymm5
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5,6],ymm5[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 160(%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqa 128(%rdi), %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm4, %ymm5, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm14
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm14, %xmm8
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpor %xmm0, %xmm8, %xmm0
; AVX2-FAST-NEXT:    vmovdqa 192(%rdi), %ymm9
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm10, %ymm8
; AVX2-FAST-NEXT:    vmovdqa %ymm9, %ymm14
; AVX2-FAST-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm11, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm8[7]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm12, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm2, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,6,13,128,128,2,9,128,128,128,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm0, %xmm9
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,u,128,128,4,11,128,128,0,7,14,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpor %xmm0, %xmm9, %xmm0
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [1,3,0,2,1,3,4,6]
; AVX2-FAST-NEXT:    vpermd %ymm6, %ymm9, %ymm11
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,1,4,11,14>
; AVX2-FAST-NEXT:    vpshufb %ymm12, %ymm11, %ymm11
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm11[7]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm13, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm4, %ymm5, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm0, %xmm6
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpor %xmm6, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpermd %ymm14, %ymm9, %ymm6
; AVX2-FAST-NEXT:    vpshufb %ymm12, %ymm6, %ymm6
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm6[7]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm7, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-FAST-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm3, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,128,128,128,6,13,128,128,2,9,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,1,8,15,128,128,4,11,128,128,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,u,u,u,u,u,u,u,u,128,128,128,5,12>
; AVX2-FAST-NEXT:    vmovdqa 432(%rdi), %xmm1
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm1, %xmm10
; AVX2-FAST-NEXT:    vmovdqa %xmm1, %xmm14
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,u,u,u,u,u,u,u,0,7,14,128,128>
; AVX2-FAST-NEXT:    vmovdqa 416(%rdi), %xmm15
; AVX2-FAST-NEXT:    vpshufb %xmm11, %xmm15, %xmm12
; AVX2-FAST-NEXT:    vpor %xmm10, %xmm12, %xmm10
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm12
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX2-FAST-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm12, %ymm10, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm0, %ymm4, %ymm10
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm12
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm12, %xmm6
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm10, %xmm8
; AVX2-FAST-NEXT:    vpor %xmm6, %xmm8, %xmm10
; AVX2-FAST-NEXT:    vmovdqa 208(%rdi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm1, %xmm9
; AVX2-FAST-NEXT:    vmovdqa 192(%rdi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm11, %xmm1, %xmm11
; AVX2-FAST-NEXT:    vpor %xmm9, %xmm11, %xmm9
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm10, %ymm9, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm3, %ymm2, %ymm9
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,2,9,128,128,128,5,12,128,128,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm9, %xmm11
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,128,128,0,7,14,128,128,3,10,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm12, %xmm9, %xmm9
; AVX2-FAST-NEXT:    vpor %xmm11, %xmm9, %xmm9
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,u,u,u,u,u,u,u,128,128,128,6,13>
; AVX2-FAST-NEXT:    vmovdqa %xmm14, %xmm13
; AVX2-FAST-NEXT:    vpshufb %xmm11, %xmm14, %xmm14
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,u,u,u,u,u,u,u,u,u,1,8,15,128,128>
; AVX2-FAST-NEXT:    vmovdqa %xmm15, %xmm4
; AVX2-FAST-NEXT:    vmovdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm15, %xmm15
; AVX2-FAST-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm9, %ymm14, %ymm9
; AVX2-FAST-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm0, %ymm6, %ymm9
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm9, %xmm10
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX2-FAST-NEXT:    vpshufb %xmm12, %xmm9, %xmm9
; AVX2-FAST-NEXT:    vpor %xmm10, %xmm9, %xmm9
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm11, %xmm8, %xmm10
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm0, %xmm1
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm10, %xmm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm9, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm3, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,3,10,128,128,128,6,13,128,128,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm1, %xmm11
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,128,128,1,8,15,128,128,4,11,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm12, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm11, %xmm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,u,u,u,u,u,u,u,2,9,128,128,128>
; AVX2-FAST-NEXT:    vpshufb %xmm11, %xmm4, %xmm14
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm15 = <u,u,u,u,u,u,u,u,u,u,u,128,128,0,7,14>
; AVX2-FAST-NEXT:    vpshufb %xmm15, %xmm13, %xmm10
; AVX2-FAST-NEXT:    vpor %xmm14, %xmm10, %xmm10
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm10, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm4, %ymm6, %ymm1
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm1, %xmm9
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-FAST-NEXT:    vpshufb %xmm12, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm9, %xmm1
; AVX2-FAST-NEXT:    vpshufb %xmm11, %xmm0, %xmm9
; AVX2-FAST-NEXT:    vpshufb %xmm15, %xmm8, %xmm10
; AVX2-FAST-NEXT:    vpor %xmm9, %xmm10, %xmm9
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm9, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm3, %ymm7, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = <255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm7, %ymm3, %ymm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,128,128,2,9,128,128,128,5,12,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,4,11,128,128,0,7,14,128,128,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,u,u,u,u,u,u,u,3,10,128,128,128>
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm7, %xmm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,u,u,u,u,u,u,u,u,128,128,1,8,15>
; AVX2-FAST-NEXT:    vpshufb %xmm12, %xmm13, %xmm11
; AVX2-FAST-NEXT:    vpor %xmm7, %xmm11, %xmm7
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm7, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa %ymm6, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm4, %ymm6, %ymm6
; AVX2-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX2-FAST-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm0, %xmm2
; AVX2-FAST-NEXT:    vpshufb %xmm12, %xmm8, %xmm3
; AVX2-FAST-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm0, %ymm1, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm0, %ymm1, %ymm12
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm1, %ymm0, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm0, %ymm1, %ymm9
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm0, %ymm1, %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm1, %ymm0, %ymm11
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm1, %ymm0, %ymm10
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm1, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm1, %ymm0, %ymm6
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm0, %ymm1, %ymm14
; AVX2-FAST-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm1, %ymm14, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm1, %ymm14, %ymm4
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm1, %ymm14, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm14, %ymm1, %ymm13
; AVX2-FAST-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm14, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm15 = <2,9,128,128,128,5,12,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm15, %xmm3, %xmm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm14 = <128,128,0,7,14,128,128,3,10,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm14, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm3
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm10[0,1,2],ymm3[3],ymm10[4,5],ymm3[6],ymm10[7,8,9,10],ymm3[11],ymm10[12,13],ymm3[14],ymm10[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm13, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm10 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm1, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpshufb %xmm15, %xmm9, %xmm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX2-FAST-NEXT:    vpshufb %xmm14, %xmm9, %xmm9
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm9, %xmm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm9
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1,2],ymm9[3],ymm0[4,5],ymm9[6],ymm0[7,8,9,10],ymm9[11],ymm0[12,13],ymm9[14],ymm0[15]
; AVX2-FAST-NEXT:    vpshufb %ymm13, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm1, %ymm0, %ymm15
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = <3,10,128,128,128,6,13,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm12, %xmm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm12, %xmm9
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm12 = <128,128,1,8,15,128,128,4,11,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm12, %xmm9, %xmm9
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm9, %xmm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm9
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm9[0],ymm2[1,2],ymm9[3],ymm2[4,5,6],ymm9[7,8],ymm2[9,10],ymm9[11],ymm2[12,13,14],ymm9[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm13, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm1, %ymm2, %ymm9
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm5, %xmm0
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm5, %xmm1
; AVX2-FAST-NEXT:    vpshufb %xmm12, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm1
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm4[1,2],ymm1[3],ymm4[4,5,6],ymm1[7,8],ymm4[9,10],ymm1[11],ymm4[12,13,14],ymm1[15]
; AVX2-FAST-NEXT:    vpshufb %ymm13, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm0, %ymm1, %ymm12
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm8, %xmm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = <128,128,2,9,128,128,128,5,12,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = <4,11,128,128,0,7,14,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm8, %xmm1
; AVX2-FAST-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm1
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm6[1,2,3],ymm1[4],ymm6[5,6],ymm1[7,8],ymm6[9,10,11],ymm1[12],ymm6[13,14],ymm1[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm0, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm0
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm11, %xmm2
; AVX2-FAST-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm7, %xmm2
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm7[1,2,3],ymm2[4],ymm7[5,6],ymm2[7,8],ymm7[9,10,11],ymm2[12],ymm7[13,14],ymm2[15]
; AVX2-FAST-NEXT:    vpshufb %ymm5, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = <128,128,3,10,128,128,128,6,13,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = <5,12,128,128,1,8,15,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm6, %xmm6
; AVX2-FAST-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm7, %xmm6
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2,3],ymm6[4],ymm7[5,6,7,8],ymm6[9],ymm7[10,11],ymm6[12],ymm7[13,14,15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = <u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm6, %ymm6
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm2, %ymm6, %ymm2
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm8, %xmm6
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm6, %xmm4
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm8, %xmm5
; AVX2-FAST-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm5
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1],ymm6[2,3],ymm5[4],ymm6[5,6,7,8],ymm5[9],ymm6[10,11],ymm5[12],ymm6[13,14,15]
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm5, %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm4, %ymm5, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = <6,13,128,128,2,9,128,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm7, %xmm6
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm8 = <128,128,4,11,128,128,0,7,14,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm7, %xmm7
; AVX2-FAST-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm7
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm11[0],ymm7[1],ymm11[2,3,4],ymm7[5],ymm11[6,7,8],ymm7[9],ymm11[10,11,12],ymm7[13],ymm11[14,15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm11, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm6, %ymm7, %ymm6
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm7, %xmm5
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm7, %xmm7
; AVX2-FAST-NEXT:    vpor %xmm5, %xmm7, %xmm5
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm8, %xmm7
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2,3,4],ymm7[5],ymm8[6,7,8],ymm7[9],ymm8[10,11,12],ymm7[13],ymm8[14,15]
; AVX2-FAST-NEXT:    vpshufb %ymm11, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm5, %ymm7, %ymm5
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,128,128,128,5,12,128,128,1,8,15,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm7, %xmm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,0,7,14,128,128,3,10,128,128,128,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm11, %xmm11
; AVX2-FAST-NEXT:    vpor %xmm7, %xmm11, %xmm7
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = [1,3,1,2,1,3,5,6]
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm13 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,2,5,8,15>
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm13, %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5,6],ymm13[7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm3[0],ymm7[1,2,3,4,5,6,7],ymm3[8],ymm7[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm7
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm7, %xmm7
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm13, %xmm8
; AVX2-FAST-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm8 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5,6],ymm8[7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm15[0],ymm7[1,2,3,4,5,6,7],ymm15[8],ymm7[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm15[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm8 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm8 = ymm9[0],mem[1,2,3,4,5,6,7],ymm9[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm9 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm9 = ymm12[0],mem[1,2,3,4,5,6,7],ymm12[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm12[0,1,2,3],ymm9[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm10 = ymm1[0],mem[1,2,3,4,5,6,7],ymm1[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm10 = ymm0[0],mem[1,2,3,4,5,6,7],ymm0[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm10 = ymm2[0],mem[1,2,3,4,5,6,7],ymm2[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm10 = ymm4[0],mem[1,2,3,4,5,6,7],ymm4[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm10 = ymm6[0],mem[1,2,3,4,5,6,7],ymm6[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm10 = ymm5[0],mem[1,2,3,4,5,6,7],ymm5[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm10, (%rsi)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm10, 32(%rsi)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm10, (%rdx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm10, 32(%rdx)
; AVX2-FAST-NEXT:    vmovdqa %ymm7, (%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, 32(%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm9, (%r8)
; AVX2-FAST-NEXT:    vmovdqa %ymm8, 32(%r8)
; AVX2-FAST-NEXT:    vmovdqa %ymm0, (%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, 32(%r9)
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa %ymm4, (%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, 32(%rax)
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa %ymm5, (%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm6, 32(%rax)
; AVX2-FAST-NEXT:    addq $728, %rsp # imm = 0x2D8
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: load_i8_stride7_vf64:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $760, %rsp # imm = 0x2F8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 320(%rdi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 288(%rdi), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 224(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 256(%rdi), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm1, %ymm10, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm1 = <128,128,128,5,12,128,128,1,8,15,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm2 = <0,7,14,128,128,3,10,128,128,128,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm4, %ymm5, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm9, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm4 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7,8,9],ymm4[10],ymm3[11,12],ymm4[13],ymm3[14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,0,7,14,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm3, %ymm4, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm0, %ymm5, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm8, %ymm6, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm6, %ymm7, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm5[2],ymm2[3,4],ymm5[5],ymm2[6,7,8,9],ymm5[10],ymm2[11,12],ymm5[13],ymm2[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm9, %ymm11, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm1[0,1],ymm2[2],ymm1[3,4,5],ymm2[6],ymm1[7,8,9],ymm2[10],ymm1[11,12,13],ymm2[14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm1 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm12, %ymm10, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm1 = <128,128,128,6,13,128,128,2,9,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm5, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm10 = <1,8,15,128,128,4,11,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm10, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,1,8,15,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm5, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = <0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm2, %ymm4, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm7, %ymm8, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4,5],ymm4[6],ymm2[7,8,9],ymm4[10],ymm2[11,12,13],ymm4[14],ymm2[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm5, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm13, %ymm0, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm5, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm10, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm1, %xmm4, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm2, %ymm1, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 384(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 352(%rdi), %ymm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm13, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,128,128,3,10,128,128,128,6,13,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm5, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,5,12,128,128,1,8,15,128,128,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm12, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 432(%rdi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm1, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 416(%rdi), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm3, %xmm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm14[0],xmm5[0],xmm14[1],xmm5[1],xmm14[2],xmm5[2],xmm14[3],xmm5[3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5,6],ymm5[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 160(%rdi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 128(%rdi), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm4, %ymm5, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm15
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm15, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm12, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm0, %xmm9, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 208(%rdi), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm10, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm10, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 192(%rdi), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm10, %xmm12
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm12[0],xmm9[0],xmm12[1],xmm9[1],xmm12[2],xmm9[2],xmm12[3],xmm9[3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm9[7]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm7, %ymm13, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm7 = <u,u,u,6,13,128,128,2,9,128,128,128,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm7, %xmm0, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,128,128,4,11,128,128,0,7,14,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm12, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm0, %xmm9, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm1, %xmm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm15 = <u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm15, %xmm3, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm13[0],xmm8[1],xmm13[1],xmm8[2],xmm13[2],xmm8[3],xmm13[3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm8[7]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm7, %xmm0, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm12, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm2, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, %xmm13
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm15, %xmm10, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm3[7]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm11, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm11, %ymm7, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,128,128,128,6,13,128,128,2,9,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,1,8,15,128,128,4,11,128,128,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,u,u,u,u,u,u,u,u,u,128,128,128,5,12>
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm15, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,u,u,u,u,u,u,u,u,u,0,7,14,128,128>
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm14, %xmm12
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm8, %xmm12, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX2-FAST-PERLANE-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm12, %ymm8, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm5, %ymm4, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm8, %xmm12
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm12, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm8, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm3, %xmm6, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm13, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm13, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm10, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm1, %xmm6, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm3, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm11, %ymm7, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm7 = <u,u,2,9,128,128,128,5,12,128,128,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm7, %xmm1, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,128,128,0,7,14,128,128,3,10,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,u,u,u,u,u,u,128,128,128,6,13>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm15, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,u,u,u,u,u,u,u,u,1,8,15,128,128>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm12, %xmm14, %xmm13
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm9, %xmm13, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm9, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm7, %xmm1, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm2, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm12, %xmm10, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm10, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm3, %xmm6, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm11, %ymm7, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,3,10,128,128,128,6,13,128,128,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm1, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,128,128,1,8,15,128,128,4,11,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,u,u,u,u,u,u,2,9,128,128,128>
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm14, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm14, %xmm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm13 = <u,u,u,u,u,u,u,u,u,u,u,128,128,0,7,14>
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm13, %xmm10, %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm12, %xmm14, %xmm12
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm12, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm5, %ymm4, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm1, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm2, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm13, %xmm14, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm3, %xmm6, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = <255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0>
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm11, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm11, %ymm7, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = <255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm7, %ymm3, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,u,128,128,2,9,128,128,128,5,12,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,4,11,128,128,0,7,14,128,128,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,u,u,u,u,u,u,u,u,u,u,3,10,128,128,128>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm9, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,u,u,u,u,u,u,u,u,128,128,1,8,15>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm10, %xmm13
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm7, %xmm13, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm7, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm15, %ymm4, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm11, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm4, %ymm15, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm14, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm1, %ymm10, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm1, %ymm10, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm10, %ymm1, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm10, %ymm1, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm10, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm1, %ymm10, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm10, %ymm1, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm10, %ymm1, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm1, %ymm10, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm1, %ymm10, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = <255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm2, %ymm1, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm2, %ymm1, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm2, %ymm1, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm1, %ymm2, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm2, %ymm4, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255,0,0,u,u,255,255,u,u,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm2, %ymm4, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm2, %ymm4, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm4, %ymm2, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = <255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u,0,0,u,u,255,255,u,u,0,0,255,255,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm4, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm12 = <2,9,128,128,128,5,12,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm12, %xmm0, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm13 = <128,128,0,7,14,128,128,3,10,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm13, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm2, %xmm0, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm9, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm9[0,1,2],ymm0[3],ymm9[4,5],ymm0[6],ymm9[7,8,9,10],ymm0[11],ymm9[12,13],ymm0[14],ymm9[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm9, %ymm0, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm0 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm4, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm12, %xmm3, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm13, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm1, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1,2],ymm3[3],ymm1[4,5],ymm3[6],ymm1[7,8,9,10],ymm3[11],ymm1[12,13],ymm3[14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm9, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm2, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm1 = <3,10,128,128,128,6,13,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm15, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm15, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm4 = <128,128,1,8,15,128,128,4,11,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm5, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm5[1,2],ymm3[3],ymm5[4,5,6],ymm3[7,8],ymm5[9,10],ymm3[11],ymm5[12,13,14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm5, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm7, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm7, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm6, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm6[1,2],ymm3[3],ymm6[4,5,6],ymm3[7,8],ymm6[9,10],ymm3[11],ymm6[12,13,14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm5, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm11, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm4 = <128,128,2,9,128,128,128,5,12,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm5 = <4,11,128,128,0,7,14,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm11, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm8, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm8[1,2,3],ymm3[4],ymm8[5,6],ymm3[7,8],ymm8[9,10,11],ymm3[12],ymm8[13,14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm6, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm14, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm14, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm1, %xmm4, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm10, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm10[1,2,3],ymm4[4],ymm10[5,6],ymm4[7,8],ymm10[9,10,11],ymm4[12],ymm10[13,14],ymm4[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm6, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm4, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm7, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm5 = <128,128,3,10,128,128,128,6,13,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm6 = <5,12,128,128,1,8,15,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm7, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm4, %xmm7, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm8, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2,3],ymm7[4],ymm8[5,6,7,8],ymm7[9],ymm8[10,11],ymm7[12],ymm8[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = <u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm8, %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm4, %ymm7, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm9, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm7, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm9, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm7, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2,3],ymm6[4],ymm7[5,6,7,8],ymm6[9],ymm7[10,11],ymm6[12],ymm7[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm8, %ymm6, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm5, %ymm6, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm6 = <6,13,128,128,2,9,128,128,128,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm8, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm9 = <128,128,4,11,128,128,0,7,14,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm8, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm10, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm8 = ymm10[0],ymm8[1],ymm10[2,3,4],ymm8[5],ymm10[6,7,8],ymm8[9],ymm10[10,11,12],ymm8[13],ymm10[14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = <u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm10, %ymm8, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm6, %xmm8, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm8, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm8, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm9, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2,3,4],ymm8[5],ymm9[6,7,8],ymm8[9],ymm9[10,11,12],ymm8[13],ymm9[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm10, %ymm8, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm6, %ymm8, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm10, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,128,128,128,5,12,128,128,1,8,15,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm6, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm9 = <u,u,0,7,14,128,128,3,10,128,128,128,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm10, %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm6, %xmm10, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm13 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm13, %xmm10, %xmm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm11 = <u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u>
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm11, %xmm12, %xmm12
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm12[0],xmm10[0],xmm12[1],xmm10[1],xmm12[2],xmm10[2],xmm12[3],xmm10[3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5,6],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm10[0],ymm6[1,2,3,4,5,6,7],ymm10[8],ymm6[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm6 = ymm10[0,1,2,3],ymm6[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm12, %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm10, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm12, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm13, %xmm9, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm11, %xmm10, %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5,6],ymm9[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1,2,3,4,5,6,7],ymm9[8],ymm8[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm9 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm9 = ymm2[0],mem[1,2,3,4,5,6,7],ymm2[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm9[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm9 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm9 = ymm15[0],mem[1,2,3,4,5,6,7],ymm15[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm9 = ymm15[0,1,2,3],ymm9[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = ymm3[0],mem[1,2,3,4,5,6,7],ymm3[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = ymm1[0],mem[1,2,3,4,5,6,7],ymm1[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = ymm4[0],mem[1,2,3,4,5,6,7],ymm4[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = ymm5[0],mem[1,2,3,4,5,6,7],ymm5[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = ymm7[0],mem[1,2,3,4,5,6,7],ymm7[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm10 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = ymm0[0],mem[1,2,3,4,5,6,7],ymm0[8],mem[9,10,11,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm10, (%rsi)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm10, 32(%rsi)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm10, (%rdx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm10, 32(%rdx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm9, (%r8)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, 32(%r8)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, 32(%r9)
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm7, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    addq $760, %rsp # imm = 0x2F8
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-ONLY-SLOW-LABEL: load_i8_stride7_vf64:
; AVX512F-ONLY-SLOW:       # %bb.0:
; AVX512F-ONLY-SLOW-NEXT:    pushq %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm23 = [65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %ymm24
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 32(%rdi), %ymm29
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdi), %ymm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %ymm23, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm29, %ymm24, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[5,12],zero,zero,xmm1[1,8,15,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm1, %xmm0, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm18, %ymm11, %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 80(%rdi), %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm3[2],ymm1[3,4],ymm3[5],ymm1[6,7,8,9],ymm3[10],ymm1[11,12],ymm3[13],ymm1[14,15]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm3, %ymm13
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm1[6,13,4,11,2,9,16,23,30,u],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdi), %ymm31
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 160(%rdi), %ymm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm31, %ymm16, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u],zero,zero,xmm3[3,10],zero,zero,zero,xmm3[6,13,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,5,12],zero,zero,xmm2[1,8,15],zero,zero,xmm2[u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX512F-ONLY-SLOW-NEXT:    vpshufb %xmm0, %xmm8, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %xmm0, %xmm28
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 208(%rdi), %xmm7
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm10 = xmm7[u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm3[0],xmm10[0],xmm3[1],xmm10[1],xmm3[2],xmm10[2],xmm3[3],xmm10[3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm3[7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 240(%rdi), %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm5[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %xmm5, %xmm25
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 224(%rdi), %xmm10
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm10[0,7,14],zero,zero,xmm10[u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm14, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %zmm1, %zmm22, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 288(%rdi), %ymm19
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 256(%rdi), %ymm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm19, %ymm14, %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,u,u,u,3,10],zero,zero,zero,xmm1[6,13],zero,zero,xmm1[u,u]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u],zero,zero,xmm1[1,8,15],zero,zero,xmm1[4,11,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 352(%rdi), %ymm17
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 320(%rdi), %ymm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm12, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm17, %ymm15, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm3[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm5[2],ymm3[3,4,5],ymm5[6],ymm3[7,8,9],ymm5[10],ymm3[11,12,13],ymm5[14],ymm3[15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[2,9,16,23,30,21,28,19,26,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm26 = [65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,65535,65535,65535,65535]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, %ymm26, %ymm1, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = [65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 416(%rdi), %ymm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 384(%rdi), %ymm21
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm1, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm20, %ymm21, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u],zero,zero,zero,xmm6[6,13],zero,zero,xmm6[2,9]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u,u,u,1,8,15],zero,zero,xmm5[4,11],zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %ymm3, %ymm9, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm30 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %zmm2, %zmm30, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm29, %ymm24, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[6,13],zero,zero,xmm3[2,9,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[1,8,15],zero,zero,xmm2[4,11],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %ymm23, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm11, %ymm18, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm13[2],ymm3[3,4,5],ymm13[6],ymm3[7,8,9],ymm13[10],ymm3[11,12,13],ymm13[14],ymm3[15]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm13, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm31, %ymm16, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u,u,u,6,13],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u],zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm7[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm8[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm5[7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %xmm25, %xmm13
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm13[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm10[1,8,15],zero,zero,xmm10[u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm2, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %zmm3, %zmm22, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm1, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm14, %ymm19, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u],zero,zero,xmm5[2,9],zero,zero,zero,xmm5[5,12,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,4,11],zero,zero,xmm3[0,7,14],zero,zero,xmm3[u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm17, %ymm15, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm5[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1,2],ymm6[3],ymm5[4,5],ymm6[6],ymm5[7,8,9,10],ymm6[11],ymm5[12,13],ymm6[14],ymm5[15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[3,10,17,24,31,22,29,20,27,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, %ymm26, %ymm3, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm12, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm20, %ymm21, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm3[5,12],zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u,u],zero,zero,xmm3[0,7,14],zero,zero,xmm3[3,10]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %ymm5, %ymm9, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %zmm2, %zmm30, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm29, %ymm24, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[2,9],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm1, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm11, %ymm18, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1,2],ymm0[3],ymm3[4,5],ymm0[6],ymm3[7,8,9,10],ymm0[11],ymm3[12,13],ymm0[14],ymm3[15]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[1,8,15,6,13,4,11,18,25],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, %ymm5, %ymm2, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %ymm5, %ymm27
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %ymm23, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm16, %ymm31, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm6
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u],zero,zero,zero,xmm6[5,12],zero,zero,xmm6[1,8,15,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm6, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %xmm28, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vpshufb %xmm5, %xmm7, %xmm6
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm8[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm5[7]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm10[2,9],zero,zero,zero,xmm10[u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm13[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %xmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm2, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = [0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $226, %zmm3, %zmm28, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm12, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm14, %ymm19, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u],zero,zero,xmm5[3,10],zero,zero,zero,xmm5[6,13,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,5,12],zero,zero,xmm3[1,8,15],zero,zero,xmm3[u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm1, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm15, %ymm17, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm5[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1,2],ymm6[3],ymm5[4,5,6],ymm6[7,8],ymm5[9,10],ymm6[11],ymm5[12,13,14],ymm6[15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[4,11,18,25,16,23,30,21,28,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, %ymm26, %ymm3, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm20, %ymm21, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm3[6,13],zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u,u],zero,zero,xmm3[1,8,15],zero,zero,xmm3[4,11]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %ymm5, %ymm9, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %zmm2, %zmm30, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm29, %ymm24, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[3,10],zero,zero,zero,xmm2[6,13],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[1,8,15],zero,zero,xmm2[4,11,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm12, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm11, %ymm18, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm0[0],ymm3[1,2],ymm0[3],ymm3[4,5,6],ymm0[7,8],ymm3[9,10],ymm0[11],ymm3[12,13,14],ymm0[15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[2,9,0,7,14,5,12,19,26],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, %ymm27, %ymm2, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm16, %ymm31, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u],zero,zero,zero,xmm5[6,13],zero,zero,xmm5[2,9,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,1,8,15],zero,zero,xmm2[4,11],zero,zero,xmm2[u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm7[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm7[5,12]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm8[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %xmm8, %xmm7
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm27 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %ymm2, %ymm27, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm10[3,10],zero,zero,zero,xmm10[u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,xmm13[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm2, %zmm5, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $226, %zmm3, %zmm28, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm14, %ymm19, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm3[u,u,u,u,u,6,13],zero,zero,xmm3[2,9],zero,zero,zero,xmm3[u,u]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u],zero,zero,xmm3[4,11],zero,zero,xmm3[0,7,14,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm12, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm15, %ymm17, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm5[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1,2,3],ymm6[4],ymm5[5,6],ymm6[7,8],ymm5[9,10,11],ymm6[12],ymm5[13,14],ymm6[15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[5,12,19,26,17,24,31,22,29,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, %ymm26, %ymm3, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm1, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm21, %ymm20, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm6
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u],zero,zero,xmm6[2,9],zero,zero,zero,xmm6[5,12]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u,u,4,11],zero,zero,xmm3[0,7,14],zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %ymm5, %ymm9, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %zmm2, %zmm30, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm24, %ymm29, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,xmm3[2,9],zero,zero,zero,xmm3[5,12,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,11],zero,zero,xmm2[0,7,14],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm2, %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %ymm23, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm19, %ymm14, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u],zero,zero,zero,xmm3[5,12],zero,zero,xmm3[1,8,15,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm15, %ymm17, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm3[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm5[1],ymm3[2,3],ymm5[4],ymm3[5,6,7,8],ymm5[9],ymm3[10,11],ymm5[12],ymm3[13,14,15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[6,13,20,27,18,25,16,23,30,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, %ymm26, %ymm2, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm21, %ymm20, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u,u,u],zero,zero,xmm5[3,10],zero,zero,zero,xmm5[6,13]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u,5,12],zero,zero,xmm2[1,8,15],zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm2, %ymm0, %ymm26
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %ymm3, %ymm9, %ymm26
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm19, %ymm14, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u],zero,zero,zero,xmm3[6,13],zero,zero,xmm3[2,9,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,1,8,15],zero,zero,xmm2[4,11],zero,zero,xmm2[u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %ymm23, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm17, %ymm15, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm3[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm5[1],ymm3[2,3,4],ymm5[5],ymm3[6,7,8],ymm5[9],ymm3[10,11,12],ymm5[13],ymm3[14,15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[0,7,14,21,28,19,26,17,24,31,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm21, %ymm20, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u,u,u,u,u,u,u,6,13],zero,zero,xmm2[2,9],zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm2, %ymm0, %ymm30
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %ymm3, %ymm9, %ymm30
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm16, %ymm31, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[u,u,2,9],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm2, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm20, %ymm21, %ymm23
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm12, %ymm6
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm24, %ymm29, %ymm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm4, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm24, %ymm29, %ymm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm9[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm9[6,13]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %xmm7, %xmm13
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm11, %ymm18, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $226, %ymm19, %ymm12, %ymm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa %ymm1, %ymm8
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm18, %ymm11, %ymm8
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm18, %ymm11, %ymm12
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm11[0],ymm2[1,2,3],ymm11[4],ymm2[5,6],ymm11[7,8],ymm2[9,10,11],ymm11[12],ymm2[13,14],ymm11[15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[3,10,1,8,15,6,13,20,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm18 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, %ymm18, %ymm0, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %ymm5, %ymm27, %ymm7
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm6, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm5[3,10],zero,zero,zero,xmm5[6,13,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[5,12],zero,zero,xmm6[1,8,15],zero,zero,xmm6[u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm8[0],ymm11[1],ymm8[2,3],ymm11[4],ymm8[5,6,7,8],ymm11[9],ymm8[10,11],ymm11[12],ymm8[13,14,15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[4,11,2,9,0,7,14,21,28],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, %ymm18, %ymm5, %ymm6
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm4[6,13],zero,zero,xmm4[2,9],zero,zero,zero,xmm4[u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm12[0],ymm11[1],ymm12[2,3,4],ymm11[5],ymm12[6,7,8],ymm11[9],ymm12[10,11,12],ymm11[13],ymm12[14,15]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} xmm8 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[5,12,3,10,1,8,15,22,29],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, %ymm18, %ymm0, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vpshufb %xmm8, %xmm10, %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm4[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm11[0],xmm0[1],xmm11[1],xmm0[2],xmm11[2],xmm0[3],xmm11[3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm7, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %zmm2, %zmm7, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm16, %ymm31, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[u,u,3,10],zero,zero,zero,xmm3[6,13],zero,zero,xmm3[u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u],zero,zero,xmm3[1,8,15],zero,zero,xmm3[4,11,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $226, %ymm17, %ymm1, %ymm15
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $202, %ymm31, %ymm16, %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm13[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm9[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm9[0,7,14]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm11, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %ymm2, %ymm27, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[5,12,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,4,11],zero,zero,xmm1[0,7,14],zero,zero,xmm1[u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm13[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm9[1,8,15]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm9, %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %ymm1, %ymm27, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm4[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm10[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm9[0],xmm1[0],xmm9[1],xmm1[1],xmm9[2],xmm1[2],xmm9[3],xmm1[3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %zmm6, %zmm7, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpshufb %xmm8, %xmm4, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm10[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $184, %zmm5, %zmm7, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm26, %zmm0, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    movw $-512, %ax # imm = 0xFE00
; AVX512F-ONLY-SLOW-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm3, %zmm0 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm30, %zmm0, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm3, %zmm1 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm14[u,u,u,u,2,9],zero,zero,zero,xmm14[5,12],zero,zero,xmm14[u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm14, %xmm5
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u],zero,zero,xmm5[0,7,14],zero,zero,xmm5[3,10,u,u,u]
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm5, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm15[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm15[0,1],ymm5[2],ymm15[3,4],ymm5[5],ymm15[6,7,8,9],ymm5[10],ymm15[11,12],ymm5[13],ymm15[14,15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[1,8,15,22,29,20,27,18,25],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %ymm23, %ymm4
; AVX512F-ONLY-SLOW-NEXT:    vextracti32x4 $1, %ymm23, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u],zero,zero,zero,xmm3[5,12],zero,zero,xmm3[1,8,15]
; AVX512F-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u,u,0,7,14],zero,zero,xmm4[3,10],zero,zero,zero
; AVX512F-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm5[0,1,2],ymm3[3,4,5,6,7],ymm5[8,9,10],ymm3[11,12,13,14,15]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa32 %zmm3, %zmm2 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm3, (%rsi)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm22, (%rdx)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm25, (%rcx)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, (%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512F-ONLY-SLOW-NEXT:    popq %rax
; AVX512F-ONLY-SLOW-NEXT:    vzeroupper
; AVX512F-ONLY-SLOW-NEXT:    retq
;
; AVX512F-ONLY-FAST-LABEL: load_i8_stride7_vf64:
; AVX512F-ONLY-FAST:       # %bb.0:
; AVX512F-ONLY-FAST-NEXT:    pushq %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = [65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdi), %ymm20
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 32(%rdi), %ymm16
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rdi), %ymm25
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm15, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm16, %ymm20, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[5,12],zero,zero,xmm1[1,8,15,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm1, %xmm0, %xmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 96(%rdi), %ymm11
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm25, %ymm11, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 80(%rdi), %xmm3
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7,8,9],ymm3[10],ymm2[11,12],ymm3[13],ymm2[14,15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[6,13,4,11,2,9,16,23,30,u],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = [65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rdi), %ymm26
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 160(%rdi), %ymm31
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm12, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm26, %ymm31, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[6,13,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,5,12],zero,zero,xmm1[1,8,15],zero,zero,xmm1[u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,1,2,4,6>
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 192(%rdi), %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpermd %ymm1, %ymm5, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,23,26,29]
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm5[7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 240(%rdi), %xmm6
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm6[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %xmm6, %xmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 224(%rdi), %xmm6
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm10 = xmm6[0,7,14],zero,zero,xmm6[u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %xmm6, %xmm9
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm5, %xmm10, %xmm5
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm2, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %zmm4, %zmm8, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 288(%rdi), %ymm17
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 256(%rdi), %ymm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm17, %ymm10, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm4[u,u,u,u,u,3,10],zero,zero,zero,xmm4[6,13],zero,zero,xmm4[u,u]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u],zero,zero,xmm4[1,8,15],zero,zero,xmm4[4,11,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm13, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 352(%rdi), %ymm22
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 320(%rdi), %ymm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm12, %ymm14
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm22, %ymm13, %ymm14
; AVX512F-ONLY-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm14[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm14[0,1],ymm2[2],ymm14[3,4,5],ymm2[6],ymm14[7,8,9],ymm2[10],ymm14[11,12,13],ymm2[14],ymm14[15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[2,9,16,23,30,21,28,19,26,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm24 = [65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,65535,65535,65535,65535]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, %ymm24, %ymm4, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = [65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 416(%rdi), %ymm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 384(%rdi), %ymm19
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm14, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm18, %ymm19, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm6
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u],zero,zero,zero,xmm6[6,13],zero,zero,xmm6[2,9]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u,u,u,1,8,15],zero,zero,xmm4[4,11],zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm27 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %ymm2, %ymm27, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm29 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %zmm5, %zmm29, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm14, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm16, %ymm20, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm4[6,13],zero,zero,xmm4[2,9,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[1,8,15],zero,zero,xmm2[4,11],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm15, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm11, %ymm25, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1],ymm3[2],ymm4[3,4,5],ymm3[6],ymm4[7,8,9],ymm3[10],ymm4[11,12,13],ymm3[14],ymm4[15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm4[0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm26, %ymm31, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u,u,u,6,13],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u],zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,1,3,4,6>
; AVX512F-ONLY-FAST-NEXT:    vpermd %ymm1, %ymm5, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,17,20,27,30]
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm5[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm7[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm9[1,8,15],zero,zero,xmm9[u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm2, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %zmm4, %zmm8, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm14, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm10, %ymm17, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u],zero,zero,xmm5[2,9],zero,zero,zero,xmm5[5,12,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u,4,11],zero,zero,xmm4[0,7,14],zero,zero,xmm4[u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm22, %ymm13, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm5[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1,2],ymm6[3],ymm5[4,5],ymm6[6],ymm5[7,8,9,10],ymm6[11],ymm5[12,13],ymm6[14],ymm5[15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[3,10,17,24,31,22,29,20,27,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, %ymm24, %ymm4, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm12, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm18, %ymm19, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm4[u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm4[5,12],zero,zero
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u,u,u],zero,zero,xmm4[0,7,14],zero,zero,xmm4[3,10]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %ymm5, %ymm27, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %zmm2, %zmm29, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm16, %ymm20, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[2,9],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm14, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm11, %ymm25, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1,2],ymm3[3],ymm4[4,5],ymm3[6],ymm4[7,8,9,10],ymm3[11],ymm4[12,13],ymm3[14],ymm4[15]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm4[1,8,15,6,13,4,11,18,25],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, %ymm5, %ymm2, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm5, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm15, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm31, %ymm26, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u],zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,1,3,5,6>
; AVX512F-ONLY-FAST-NEXT:    vpermd %ymm1, %ymm5, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,21,24,31]
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5,6],ymm1[7]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm9[2,9],zero,zero,zero,xmm9[u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %xmm9, %xmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %xmm7, %xmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm7[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm2, %xmm5, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm28 = [0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $226, %zmm4, %zmm28, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm10, %ymm17, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u],zero,zero,xmm4[3,10],zero,zero,zero,xmm4[6,13,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,5,12],zero,zero,xmm2[1,8,15],zero,zero,xmm2[u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm14, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm13, %ymm22, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0],ymm4[1,2],ymm5[3],ymm4[4,5,6],ymm5[7,8],ymm4[9,10],ymm5[11],ymm4[12,13,14],ymm5[15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm4[4,11,18,25,16,23,30,21,28,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, %ymm24, %ymm2, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm18, %ymm19, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm2[6,13],zero,zero
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[1,8,15],zero,zero,xmm2[4,11]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %ymm4, %ymm27, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %zmm1, %zmm29, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm16, %ymm20, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm1[3,10],zero,zero,zero,xmm1[6,13],zero,zero,xmm1[u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[1,8,15],zero,zero,xmm1[4,11,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm11, %ymm25, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0],ymm2[1,2],ymm3[3],ymm2[4,5,6],ymm3[7,8],ymm2[9,10],ymm3[11],ymm2[12,13,14],ymm3[15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[2,9,0,7,14,5,12,19,26],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, %ymm6, %ymm1, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm14, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm31, %ymm26, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u],zero,zero,zero,xmm4[6,13],zero,zero,xmm4[2,9,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,1,8,15],zero,zero,xmm1[4,11],zero,zero,xmm1[u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm1, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 208(%rdi), %xmm5
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm5[5,12]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 192(%rdi), %xmm1
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm1[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm8[3,10],zero,zero,zero,xmm8[u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,xmm9[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm7, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm6, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $226, %zmm2, %zmm28, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm10, %ymm17, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm2[u,u,u,u,u,6,13],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[u,u]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u],zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm6, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm12, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm13, %ymm22, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0],ymm6[1,2,3],ymm7[4],ymm6[5,6],ymm7[7,8],ymm6[9,10,11],ymm7[12],ymm6[13,14],ymm7[15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[5,12,19,26,17,24,31,22,29,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, %ymm24, %ymm2, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm14, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm19, %ymm18, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm7
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u],zero,zero,xmm7[2,9],zero,zero,zero,xmm7[5,12]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u,4,11],zero,zero,xmm2[0,7,14],zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm7, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %ymm6, %ymm27, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %zmm4, %zmm29, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm14, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm20, %ymm16, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,xmm4[2,9],zero,zero,zero,xmm4[5,12,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,11],zero,zero,xmm2[0,7,14],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vporq %xmm4, %xmm2, %xmm29
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm15, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm17, %ymm10, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u],zero,zero,zero,xmm4[5,12],zero,zero,xmm4[1,8,15,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm13, %ymm22, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm6[1],ymm4[2,3],ymm6[4],ymm4[5,6,7,8],ymm6[9],ymm4[10,11],ymm6[12],ymm4[13,14,15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm4[6,13,20,27,18,25,16,23,30,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, %ymm24, %ymm2, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm19, %ymm18, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm6
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u],zero,zero,xmm6[3,10],zero,zero,zero,xmm6[6,13]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u,5,12],zero,zero,xmm2[1,8,15],zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm6, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm2, %ymm0, %ymm24
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %ymm4, %ymm27, %ymm24
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm14, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm17, %ymm10, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u],zero,zero,zero,xmm4[6,13],zero,zero,xmm4[2,9,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,1,8,15],zero,zero,xmm2[4,11],zero,zero,xmm2[u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm15, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm22, %ymm13, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm6[1],ymm4[2,3,4],ymm6[5],ymm4[6,7,8],ymm6[9],ymm4[10,11,12],ymm6[13],ymm4[14,15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm4[0,7,14,21,28,19,26,17,24,31,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm19, %ymm18, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm2[u,u,u,u,u,u,u,6,13],zero,zero,xmm2[2,9],zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm6, %xmm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm2, %ymm0, %ymm30
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %ymm4, %ymm27, %ymm30
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm31, %ymm26, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,2,9],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm2, %xmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm18, %ymm19, %ymm15
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm12, %ymm7
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm20, %ymm16, %ymm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm0, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm20, %ymm16, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = xmm5[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm5[6,13]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = xmm1[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm11, %ymm25, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $226, %ymm17, %ymm12, %ymm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa %ymm14, %ymm9
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm25, %ymm11, %ymm9
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm25, %ymm11, %ymm12
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm7, %xmm11
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,xmm11[3,10],zero,zero,zero,xmm11[6,13,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[5,12],zero,zero,xmm7[1,8,15],zero,zero,xmm7[u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm7, %xmm11, %xmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm11[0],ymm2[1,2,3],ymm11[4],ymm2[5,6],ymm11[7,8],ymm2[9,10,11],ymm11[12],ymm2[13,14],ymm11[15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[3,10,1,8,15,6,13,20,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, %ymm3, %ymm29, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm16 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %ymm6, %ymm16, %ymm8
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm9[0],ymm11[1],ymm9[2,3],ymm11[4],ymm9[5,6,7,8],ymm11[9],ymm9[10,11],ymm11[12],ymm9[13,14,15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[4,11,2,9,0,7,14,21,28],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, %ymm3, %ymm7, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[6,13],zero,zero,xmm0[2,9],zero,zero,zero,xmm0[u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm7, %xmm0, %xmm0
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm12[0],ymm11[1],ymm12[2,3,4],ymm11[5],ymm12[6,7,8],ymm11[9],ymm12[10,11,12],ymm11[13],ymm12[14,15]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm7[5,12,3,10,1,8,15,22,29],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, %ymm3, %ymm0, %ymm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpshufb %xmm9, %xmm12, %xmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm3[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm11[0],xmm0[1],xmm11[1],xmm0[2],xmm11[2],xmm0[3],xmm11[3]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm8, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %zmm2, %zmm8, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm31, %ymm26, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm4[u,u,3,10],zero,zero,zero,xmm4[6,13],zero,zero,xmm4[u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u],zero,zero,xmm4[1,8,15],zero,zero,xmm4[4,11,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm2, %xmm4, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $226, %ymm22, %ymm14, %ymm13
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $202, %ymm26, %ymm31, %ymm14
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm1[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm5[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm5[0,7,14]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %ymm2, %ymm16, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[5,12,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm14[u,u,4,11],zero,zero,xmm14[0,7,14],zero,zero,xmm14[u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm2, %xmm11, %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm5[1,8,15]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm1, %xmm5, %xmm1
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %ymm2, %ymm16, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm12[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm4, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %zmm6, %zmm8, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpshufb %xmm9, %xmm3, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm12[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $184, %zmm7, %zmm8, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm24, %zmm0, %zmm4
; AVX512F-ONLY-FAST-NEXT:    movw $-512, %ax # imm = 0xFE00
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm4, %zmm0 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm30, %zmm0, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm4, %zmm2 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm10[u,u,u,u,2,9],zero,zero,zero,xmm10[5,12],zero,zero,xmm10[u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm5
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u],zero,zero,xmm5[0,7,14],zero,zero,xmm5[3,10,u,u,u]
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm13[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm13[0,1],ymm5[2],ymm13[3,4],ymm5[5],ymm13[6,7,8,9],ymm5[10],ymm13[11,12],ymm5[13],ymm13[14,15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[1,8,15,22,29,20,27,18,25],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm15, %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u,u],zero,zero,zero,xmm4[5,12],zero,zero,xmm4[1,8,15]
; AVX512F-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm15[u,u,u,u,u,u,0,7,14],zero,zero,xmm15[3,10],zero,zero,zero
; AVX512F-ONLY-FAST-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-ONLY-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm5[0,1,2],ymm3[3,4,5,6,7],ymm5[8,9,10],ymm3[11,12,13,14,15]
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa32 %zmm3, %zmm1 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm3, (%rsi)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm21, (%rdx)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, (%rcx)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, (%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512F-ONLY-FAST-NEXT:    popq %rax
; AVX512F-ONLY-FAST-NEXT:    vzeroupper
; AVX512F-ONLY-FAST-NEXT:    retq
;
; AVX512DQ-SLOW-LABEL: load_i8_stride7_vf64:
; AVX512DQ-SLOW:       # %bb.0:
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm16 = [65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rdi), %ymm23
; AVX512DQ-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rdi), %ymm22
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %ymm16, %ymm1
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm8, %ymm23, %ymm1
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm2[5,12],zero,zero,xmm2[1,8,15,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[0,7,14],zero,zero,xmm1[3,10],zero,zero,zero,xmm1[u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm2, %xmm1, %xmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535]
; AVX512DQ-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm11
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm1
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm22, %ymm11, %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqa 80(%rdi), %xmm0
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7,8,9],ymm0[10],ymm1[11,12],ymm0[13],ymm1[14,15]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %ymm0, %ymm25
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm1[6,13,4,11,2,9,16,23,30,u],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rdi), %ymm31
; AVX512DQ-SLOW-NEXT:    vmovdqa64 160(%rdi), %ymm18
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm9, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm31, %ymm18, %ymm2
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm7
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u],zero,zero,xmm7[3,10],zero,zero,zero,xmm7[6,13,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,5,12],zero,zero,xmm2[1,8,15],zero,zero,xmm2[u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm7, %xmm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX512DQ-SLOW-NEXT:    vpshufb %xmm4, %xmm0, %xmm10
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %xmm4, %xmm28
; AVX512DQ-SLOW-NEXT:    vmovdqa 208(%rdi), %xmm7
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm7[u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm10[0],xmm12[0],xmm10[1],xmm12[1],xmm10[2],xmm12[2],xmm10[3],xmm12[3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm10[7]
; AVX512DQ-SLOW-NEXT:    vmovdqa 240(%rdi), %xmm10
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm10[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vmovdqa 224(%rdi), %xmm12
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm12[0,7,14],zero,zero,xmm12[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm14, %zmm2, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm26 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %zmm1, %zmm26, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 288(%rdi), %ymm19
; AVX512DQ-SLOW-NEXT:    vmovdqa 256(%rdi), %ymm14
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm1
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm19, %ymm14, %ymm1
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm1[u,u,u,u,u,3,10],zero,zero,zero,xmm1[6,13],zero,zero,xmm1[u,u]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u],zero,zero,xmm1[1,8,15],zero,zero,xmm1[4,11,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm1, %xmm15, %xmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 352(%rdi), %ymm17
; AVX512DQ-SLOW-NEXT:    vmovdqa 320(%rdi), %ymm15
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm9, %ymm13
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm17, %ymm15, %ymm13
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm13[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm13[0,1],ymm5[2],ymm13[3,4,5],ymm5[6],ymm13[7,8,9],ymm5[10],ymm13[11,12,13],ymm5[14],ymm13[15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[2,9,16,23,30,21,28,19,26,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm27 = [65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,65535,65535,65535,65535]
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, %ymm27, %ymm1, %ymm5
; AVX512DQ-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = [65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 416(%rdi), %ymm20
; AVX512DQ-SLOW-NEXT:    vmovdqa64 384(%rdi), %ymm21
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm1, %ymm13
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm20, %ymm21, %ymm13
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm6
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u],zero,zero,zero,xmm6[6,13],zero,zero,xmm6[2,9]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,u,u,u,u,u,1,8,15],zero,zero,xmm13[4,11],zero,zero
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm13, %xmm6
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm24 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0]
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %ymm5, %ymm24, %ymm6
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm6, %zmm0, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm29 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %zmm2, %zmm29, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm8, %ymm23, %ymm2
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[6,13],zero,zero,xmm5[2,9,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[1,8,15],zero,zero,xmm2[4,11],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %ymm16, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm11, %ymm22, %ymm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %ymm25, %ymm4
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm4[2],ymm5[3,4,5],ymm4[6],ymm5[7,8,9],ymm4[10],ymm5[11,12,13],ymm4[14],ymm5[15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm5
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm31, %ymm18, %ymm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm2[u,u,u,6,13],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u],zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm7[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm13[0],xmm6[0],xmm13[1],xmm6[1],xmm13[2],xmm6[2],xmm13[3],xmm6[3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm6[7]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm10[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm12[1,8,15],zero,zero,xmm12[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm13, %xmm6
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm6, %zmm2, %zmm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %zmm5, %zmm26, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm1, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm14, %ymm19, %ymm5
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u],zero,zero,xmm6[2,9],zero,zero,zero,xmm6[5,12,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u,4,11],zero,zero,xmm5[0,7,14],zero,zero,xmm5[u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm6
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm17, %ymm15, %ymm6
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm6[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0,1,2],ymm13[3],ymm6[4,5],ymm13[6],ymm6[7,8,9,10],ymm13[11],ymm6[12,13],ymm13[14],ymm6[15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[3,10,17,24,31,22,29,20,27,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, %ymm27, %ymm5, %ymm6
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm9, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm20, %ymm21, %ymm5
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm5[u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm5[5,12],zero,zero
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u,u,u],zero,zero,xmm5[0,7,14],zero,zero,xmm5[3,10]
; AVX512DQ-SLOW-NEXT:    vpor %xmm5, %xmm13, %xmm5
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %ymm6, %ymm24, %ymm5
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm26
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %zmm2, %zmm29, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm9, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm8, %ymm23, %ymm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[2,9],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm1, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm11, %ymm22, %ymm5
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1,2],ymm4[3],ymm5[4,5],ymm4[6],ymm5[7,8,9,10],ymm4[11],ymm5[12,13],ymm4[14],ymm5[15]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %ymm25, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[1,8,15,6,13,4,11,18,25],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, %ymm5, %ymm2, %ymm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %ymm5, %ymm30
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %ymm16, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm18, %ymm31, %ymm2
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm13
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u],zero,zero,zero,xmm13[5,12],zero,zero,xmm13[1,8,15,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm2, %xmm13, %xmm2
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %xmm28, %xmm5
; AVX512DQ-SLOW-NEXT:    vpshufb %xmm5, %xmm7, %xmm13
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm5[0],xmm13[0],xmm5[1],xmm13[1],xmm5[2],xmm13[2],xmm5[3],xmm13[3]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm5[7]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm12[2,9],zero,zero,zero,xmm12[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,xmm10[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm5, %xmm13, %xmm5
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm2, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = [0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX512DQ-SLOW-NEXT:    vpternlogq $226, %zmm6, %zmm28, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm9, %ymm6
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm14, %ymm19, %ymm6
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm6, %xmm13
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,u,u,u],zero,zero,xmm13[3,10],zero,zero,zero,xmm13[6,13,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,5,12],zero,zero,xmm6[1,8,15],zero,zero,xmm6[u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm13, %xmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm1, %ymm13
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm15, %ymm17, %ymm13
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm13[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm13[1,2],ymm2[3],ymm13[4,5,6],ymm2[7,8],ymm13[9,10],ymm2[11],ymm13[12,13,14],ymm2[15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[4,11,18,25,16,23,30,21,28,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, %ymm27, %ymm6, %ymm2
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm6
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm20, %ymm21, %ymm6
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm6[u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm6[6,13],zero,zero
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u],zero,zero,xmm6[1,8,15],zero,zero,xmm6[4,11]
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm13, %xmm6
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %ymm2, %ymm24, %ymm6
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm6, %zmm0, %zmm25
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %zmm5, %zmm29, %zmm25
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm8, %ymm23, %ymm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[3,10],zero,zero,zero,xmm2[6,13],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[1,8,15],zero,zero,xmm2[4,11,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm9, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm11, %ymm22, %ymm5
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm4[0],ymm5[1,2],ymm4[3],ymm5[4,5,6],ymm4[7,8],ymm5[9,10],ymm4[11],ymm5[12,13,14],ymm4[15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[2,9,0,7,14,5,12,19,26],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, %ymm30, %ymm2, %ymm5
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm18, %ymm31, %ymm2
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm6
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u],zero,zero,zero,xmm6[6,13],zero,zero,xmm6[2,9,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,1,8,15],zero,zero,xmm2[4,11],zero,zero,xmm2[u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm7[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm7[5,12]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm13, %xmm6
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm6
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm12[3,10],zero,zero,zero,xmm12[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,xmm10[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm2, %xmm13, %xmm2
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm2, %zmm6, %zmm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $226, %zmm5, %zmm28, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm14, %ymm19, %ymm5
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[u,u,u,u,u,6,13],zero,zero,xmm5[2,9],zero,zero,zero,xmm5[u,u]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u],zero,zero,xmm5[4,11],zero,zero,xmm5[0,7,14,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm9, %ymm6
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm15, %ymm17, %ymm6
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm6[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm13[0],ymm6[1,2,3],ymm13[4],ymm6[5,6],ymm13[7,8],ymm6[9,10,11],ymm13[12],ymm6[13,14],ymm13[15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[5,12,19,26,17,24,31,22,29,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, %ymm27, %ymm5, %ymm6
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm1, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm21, %ymm20, %ymm5
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm13
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,u,u,u,u,u],zero,zero,xmm13[2,9],zero,zero,zero,xmm13[5,12]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u,u,u,4,11],zero,zero,xmm5[0,7,14],zero,zero
; AVX512DQ-SLOW-NEXT:    vpor %xmm5, %xmm13, %xmm5
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %ymm6, %ymm24, %ymm5
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm28
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %zmm2, %zmm29, %zmm28
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %ymm16, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm19, %ymm14, %ymm2
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u],zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm15, %ymm17, %ymm5
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm5[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3],ymm6[4],ymm5[5,6,7,8],ymm6[9],ymm5[10,11],ymm6[12],ymm5[13,14,15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[6,13,20,27,18,25,16,23,30,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, %ymm27, %ymm2, %ymm5
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm9, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm21, %ymm20, %ymm2
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm6
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u],zero,zero,xmm6[3,10],zero,zero,zero,xmm6[6,13]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u,5,12],zero,zero,xmm2[1,8,15],zero,zero
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm2, %ymm0, %ymm27
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %ymm5, %ymm24, %ymm27
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm23, %ymm8, %ymm2
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm5[2,9],zero,zero,zero,xmm5[5,12,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,11],zero,zero,xmm2[0,7,14],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vporq %xmm5, %xmm2, %xmm29
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm19, %ymm14, %ymm2
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u],zero,zero,zero,xmm5[6,13],zero,zero,xmm5[2,9,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,1,8,15],zero,zero,xmm2[4,11],zero,zero,xmm2[u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %ymm16, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm17, %ymm15, %ymm5
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm5[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3,4],ymm6[5],ymm5[6,7,8],ymm6[9],ymm5[10,11,12],ymm6[13],ymm5[14,15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[0,7,14,21,28,19,26,17,24,31,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm5
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm21, %ymm20, %ymm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm2[u,u,u,u,u,u,u,6,13],zero,zero,xmm2[2,9],zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14]
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm2, %ymm0, %ymm30
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %ymm5, %ymm24, %ymm30
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm9, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm18, %ymm31, %ymm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u,u,2,9],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vporq %xmm5, %xmm2, %xmm24
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm20, %ymm21, %ymm16
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm9, %ymm5
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm23, %ymm8, %ymm5
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm3, %ymm6
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm23, %ymm8, %ymm3
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm7[6,13]
; AVX512DQ-SLOW-NEXT:    vmovdqa %xmm0, %xmm4
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512DQ-SLOW-NEXT:    vpor %xmm8, %xmm13, %xmm8
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm11, %ymm22, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $226, %ymm19, %ymm9, %ymm14
; AVX512DQ-SLOW-NEXT:    vmovdqa %ymm1, %ymm13
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm22, %ymm11, %ymm13
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm22, %ymm11, %ymm9
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm0[0],ymm2[1,2,3],ymm0[4],ymm2[5,6],ymm0[7,8],ymm2[9,10,11],ymm0[12],ymm2[13,14],ymm0[15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[3,10,1,8,15,6,13,20,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm19 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, %ymm19, %ymm29, %ymm2
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $1, %xmm24, %ymm0, %ymm11
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm20 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %ymm11, %ymm20, %ymm8
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm11
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,xmm11[3,10],zero,zero,zero,xmm11[6,13,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[5,12],zero,zero,xmm5[1,8,15],zero,zero,xmm5[u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm5, %xmm11, %xmm5
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm13[0],ymm0[1],ymm13[2,3],ymm0[4],ymm13[5,6,7,8],ymm0[9],ymm13[10,11],ymm0[12],ymm13[13,14,15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm11[4,11,2,9,0,7,14,21,28],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, %ymm19, %ymm5, %ymm11
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm3[6,13],zero,zero,xmm3[2,9],zero,zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,xmm3[4,11],zero,zero,xmm3[0,7,14,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm9[0],ymm0[1],ymm9[2,3,4],ymm0[5],ymm9[6,7,8],ymm0[9],ymm9[10,11,12],ymm0[13],ymm9[14,15]
; AVX512DQ-SLOW-NEXT:    vmovdqa {{.*#+}} xmm5 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm0[5,12,3,10,1,8,15,22,29],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, %ymm19, %ymm3, %ymm0
; AVX512DQ-SLOW-NEXT:    vpshufb %xmm5, %xmm12, %xmm3
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm10[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm3[0],xmm13[0],xmm3[1],xmm13[1],xmm3[2],xmm13[2],xmm3[3],xmm13[3]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm8, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %zmm2, %zmm8, %zmm3
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm18, %ymm31, %ymm6
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm6[u,u,3,10],zero,zero,zero,xmm6[6,13],zero,zero,xmm6[u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u],zero,zero,xmm6[1,8,15],zero,zero,xmm6[4,11,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $226, %ymm17, %ymm1, %ymm15
; AVX512DQ-SLOW-NEXT:    vpternlogq $202, %ymm31, %ymm18, %ymm1
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm4[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm7[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm7[0,7,14]
; AVX512DQ-SLOW-NEXT:    vpor %xmm6, %xmm13, %xmm6
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %ymm2, %ymm20, %ymm6
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[5,12,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,4,11],zero,zero,xmm1[0,7,14],zero,zero,xmm1[u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm4[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm7[1,8,15]
; AVX512DQ-SLOW-NEXT:    vpor %xmm2, %xmm7, %xmm2
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %ymm1, %ymm20, %ymm2
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm10[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm12[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm7[0],xmm1[0],xmm7[1],xmm1[1],xmm7[2],xmm1[2],xmm7[3],xmm1[3]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm6, %zmm1
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %zmm11, %zmm8, %zmm1
; AVX512DQ-SLOW-NEXT:    vpshufb %xmm5, %xmm10, %xmm5
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm12[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm2, %zmm2
; AVX512DQ-SLOW-NEXT:    vpternlogq $184, %zmm0, %zmm8, %zmm2
; AVX512DQ-SLOW-NEXT:    movw $-512, %ax # imm = 0xFE00
; AVX512DQ-SLOW-NEXT:    kmovw %eax, %k1
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm27, %zmm0, %zmm3 {%k1}
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm30, %zmm0, %zmm1 {%k1}
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm14[u,u,u,u,2,9],zero,zero,zero,xmm14[5,12],zero,zero,xmm14[u,u,u]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm14, %xmm5
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u],zero,zero,xmm5[0,7,14],zero,zero,xmm5[3,10,u,u,u]
; AVX512DQ-SLOW-NEXT:    vpor %xmm0, %xmm5, %xmm0
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm15[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm15[0,1],ymm5[2],ymm15[3,4],ymm5[5],ymm15[6,7,8,9],ymm5[10],ymm15[11,12],ymm5[13],ymm15[14,15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[1,8,15,22,29,20,27,18,25],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %ymm16, %ymm4
; AVX512DQ-SLOW-NEXT:    vextracti32x4 $1, %ymm16, %xmm0
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u],zero,zero,zero,xmm0[5,12],zero,zero,xmm0[1,8,15]
; AVX512DQ-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u,u,0,7,14],zero,zero,xmm4[3,10],zero,zero,zero
; AVX512DQ-SLOW-NEXT:    vpor %xmm0, %xmm4, %xmm0
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm5[0,1,2],ymm0[3,4,5,6,7],ymm5[8,9,10],ymm0[11,12,13,14,15]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti32x8 $1, %ymm0, %zmm0, %zmm2 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, (%rsi)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm26, (%rdx)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm25, (%rcx)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm28, (%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512DQ-SLOW-NEXT:    vzeroupper
; AVX512DQ-SLOW-NEXT:    retq
;
; AVX512DQ-FAST-LABEL: load_i8_stride7_vf64:
; AVX512DQ-FAST:       # %bb.0:
; AVX512DQ-FAST-NEXT:    pushq %rax
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = [65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0]
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdi), %ymm16
; AVX512DQ-FAST-NEXT:    vmovdqa 32(%rdi), %ymm8
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rdi), %ymm24
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm15, %ymm1
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm8, %ymm16, %ymm1
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm2[5,12],zero,zero,xmm2[1,8,15,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[0,7,14],zero,zero,xmm1[3,10],zero,zero,zero,xmm1[u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535]
; AVX512DQ-FAST-NEXT:    vmovdqa 96(%rdi), %ymm10
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm24, %ymm10, %ymm2
; AVX512DQ-FAST-NEXT:    vmovdqa 80(%rdi), %xmm0
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm0[2],ymm2[3,4],ymm0[5],ymm2[6,7,8,9],ymm0[10],ymm2[11,12],ymm0[13],ymm2[14,15]
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm0, %ymm7
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[6,13,4,11,2,9,16,23,30,u],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm2
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = [65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535]
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rdi), %ymm25
; AVX512DQ-FAST-NEXT:    vmovdqa64 160(%rdi), %ymm31
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm12, %ymm1
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm25, %ymm31, %ymm1
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm3
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u],zero,zero,xmm3[3,10],zero,zero,zero,xmm3[6,13,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,5,12],zero,zero,xmm1[1,8,15],zero,zero,xmm1[u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,u,u,1,2,4,6>
; AVX512DQ-FAST-NEXT:    vmovdqa 192(%rdi), %ymm1
; AVX512DQ-FAST-NEXT:    vpermd %ymm1, %ymm6, %ymm6
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,23,26,29]
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5,6],ymm6[7]
; AVX512DQ-FAST-NEXT:    vmovdqa 240(%rdi), %xmm0
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,zero,xmm0[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vmovdqa %xmm0, %xmm6
; AVX512DQ-FAST-NEXT:    vmovdqa 224(%rdi), %xmm0
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[0,7,14],zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %xmm0, %xmm23
; AVX512DQ-FAST-NEXT:    vpor %xmm11, %xmm13, %xmm11
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm11, %zmm3, %zmm20
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm21 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %zmm2, %zmm21, %zmm20
; AVX512DQ-FAST-NEXT:    vmovdqa64 288(%rdi), %ymm17
; AVX512DQ-FAST-NEXT:    vmovdqa 256(%rdi), %ymm11
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm17, %ymm11, %ymm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm13 = xmm2[u,u,u,u,u,3,10],zero,zero,zero,xmm2[6,13],zero,zero,xmm2[u,u]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u],zero,zero,xmm2[1,8,15],zero,zero,xmm2[4,11,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm2, %xmm13, %xmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 352(%rdi), %ymm29
; AVX512DQ-FAST-NEXT:    vmovdqa 320(%rdi), %ymm13
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm12, %ymm14
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm29, %ymm13, %ymm14
; AVX512DQ-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm14[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm14[0,1],ymm3[2],ymm14[3,4,5],ymm3[6],ymm14[7,8,9],ymm3[10],ymm14[11,12,13],ymm3[14],ymm14[15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[2,9,16,23,30,21,28,19,26,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm27 = [65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,65535,65535,65535,65535]
; AVX512DQ-FAST-NEXT:    vpternlogq $248, %ymm27, %ymm2, %ymm3
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = [65535,65535,0,65535,65535,0,65535,65535,65535,0,65535,65535,0,65535,65535,65535]
; AVX512DQ-FAST-NEXT:    vmovdqa64 416(%rdi), %ymm18
; AVX512DQ-FAST-NEXT:    vmovdqa64 384(%rdi), %ymm19
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm14, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm18, %ymm19, %ymm2
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u,u,u],zero,zero,zero,xmm5[6,13],zero,zero,xmm5[2,9]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u,1,8,15],zero,zero,xmm2[4,11],zero,zero
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm22 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0]
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %ymm3, %ymm22, %ymm2
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm30 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %zmm20, %zmm30, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm14, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm8, %ymm16, %ymm2
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[6,13],zero,zero,xmm3[2,9,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[1,8,15],zero,zero,xmm2[4,11],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm15, %ymm3
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm10, %ymm24, %ymm3
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm7[2],ymm3[3,4,5],ymm7[6],ymm3[7,8,9],ymm7[10],ymm3[11,12,13],ymm7[14],ymm3[15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm3
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm25, %ymm31, %ymm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u,u,u,6,13],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u],zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,1,3,4,6>
; AVX512DQ-FAST-NEXT:    vpermd %ymm1, %ymm5, %ymm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,17,20,27,30]
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm5[7]
; AVX512DQ-FAST-NEXT:    vmovdqa %xmm6, %xmm9
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm6[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %xmm23, %xmm0
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[1,8,15],zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm2, %zmm2
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %zmm3, %zmm21, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm14, %ymm3
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm11, %ymm17, %ymm3
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u],zero,zero,xmm5[2,9],zero,zero,zero,xmm5[5,12,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,4,11],zero,zero,xmm3[0,7,14],zero,zero,xmm3[u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm5
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm29, %ymm13, %ymm5
; AVX512DQ-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm5[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1,2],ymm6[3],ymm5[4,5],ymm6[6],ymm5[7,8,9,10],ymm6[11],ymm5[12,13],ymm6[14],ymm5[15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[3,10,17,24,31,22,29,20,27,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpternlogq $248, %ymm27, %ymm3, %ymm5
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm12, %ymm3
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm18, %ymm19, %ymm3
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm3[5,12],zero,zero
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u,u],zero,zero,xmm3[0,7,14],zero,zero,xmm3[3,10]
; AVX512DQ-FAST-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %ymm5, %ymm22, %ymm3
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm20
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %zmm2, %zmm30, %zmm20
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm8, %ymm16, %ymm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm2[2,9],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm14, %ymm3
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm10, %ymm24, %ymm3
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1,2],ymm7[3],ymm3[4,5],ymm7[6],ymm3[7,8,9,10],ymm7[11],ymm3[12,13],ymm7[14],ymm3[15]
; AVX512DQ-FAST-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[1,8,15,6,13,4,11,18,25],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm21 = [255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512DQ-FAST-NEXT:    vpternlogq $248, %ymm21, %ymm2, %ymm3
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm15, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm31, %ymm25, %ymm2
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u],zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,1,3,5,6>
; AVX512DQ-FAST-NEXT:    vpermd %ymm1, %ymm5, %ymm1
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,21,24,31]
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5,6],ymm1[7]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[2,9],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %xmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm9[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512DQ-FAST-NEXT:    vpor %xmm2, %xmm5, %xmm2
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm28 = [0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX512DQ-FAST-NEXT:    vpternlogq $226, %zmm3, %zmm28, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm12, %ymm3
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm11, %ymm17, %ymm3
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u],zero,zero,xmm5[3,10],zero,zero,zero,xmm5[6,13,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,5,12],zero,zero,xmm3[1,8,15],zero,zero,xmm3[u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm14, %ymm5
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm13, %ymm29, %ymm5
; AVX512DQ-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm5[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1,2],ymm6[3],ymm5[4,5,6],ymm6[7,8],ymm5[9,10],ymm6[11],ymm5[12,13,14],ymm6[15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[4,11,18,25,16,23,30,21,28,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpternlogq $248, %ymm27, %ymm3, %ymm5
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm3
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm18, %ymm19, %ymm3
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm3[6,13],zero,zero
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u,u],zero,zero,xmm3[1,8,15],zero,zero,xmm3[4,11]
; AVX512DQ-FAST-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %ymm5, %ymm22, %ymm3
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm23
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %zmm1, %zmm30, %zmm23
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm1
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm8, %ymm16, %ymm1
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[3,10],zero,zero,zero,xmm1[6,13],zero,zero,xmm1[u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[1,8,15],zero,zero,xmm1[4,11,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm12, %ymm3
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm10, %ymm24, %ymm3
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm7[0],ymm3[1,2],ymm7[3],ymm3[4,5,6],ymm7[7,8],ymm3[9,10],ymm7[11],ymm3[12,13,14],ymm7[15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm3[2,9,0,7,14,5,12,19,26],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-FAST-NEXT:    vpternlogq $248, %ymm21, %ymm1, %ymm5
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm14, %ymm1
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm31, %ymm25, %ymm1
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm3
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u],zero,zero,zero,xmm3[6,13],zero,zero,xmm3[2,9,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,1,8,15],zero,zero,xmm1[4,11],zero,zero,xmm1[u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm3, %xmm1, %xmm6
; AVX512DQ-FAST-NEXT:    vmovdqa 208(%rdi), %xmm1
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm1[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm1[5,12]
; AVX512DQ-FAST-NEXT:    vmovdqa 192(%rdi), %xmm3
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm3[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512DQ-FAST-NEXT:    vpor %xmm2, %xmm7, %xmm2
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm26 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %ymm6, %ymm26, %ymm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,xmm9[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm2, %zmm2
; AVX512DQ-FAST-NEXT:    vpternlogq $226, %zmm5, %zmm28, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm5
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm11, %ymm17, %ymm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[u,u,u,u,u,6,13],zero,zero,xmm5[2,9],zero,zero,zero,xmm5[u,u]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u],zero,zero,xmm5[4,11],zero,zero,xmm5[0,7,14,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm12, %ymm6
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm13, %ymm29, %ymm6
; AVX512DQ-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0],ymm6[1,2,3],ymm7[4],ymm6[5,6],ymm7[7,8],ymm6[9,10,11],ymm7[12],ymm6[13,14],ymm7[15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[5,12,19,26,17,24,31,22,29,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpternlogq $248, %ymm27, %ymm5, %ymm6
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm14, %ymm5
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm19, %ymm18, %ymm5
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm5, %xmm7
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u],zero,zero,xmm7[2,9],zero,zero,zero,xmm7[5,12]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u,u,u,4,11],zero,zero,xmm5[0,7,14],zero,zero
; AVX512DQ-FAST-NEXT:    vpor %xmm7, %xmm5, %xmm5
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %ymm6, %ymm22, %ymm5
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm28
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %zmm2, %zmm30, %zmm28
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm15, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm17, %ymm11, %ymm2
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u],zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm5
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm13, %ymm29, %ymm5
; AVX512DQ-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm5[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3],ymm6[4],ymm5[5,6,7,8],ymm6[9],ymm5[10,11],ymm6[12],ymm5[13,14,15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[6,13,20,27,18,25,16,23,30,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpternlogq $248, %ymm27, %ymm2, %ymm5
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm19, %ymm18, %ymm2
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm6
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u],zero,zero,xmm6[3,10],zero,zero,zero,xmm6[6,13]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u,5,12],zero,zero,xmm2[1,8,15],zero,zero
; AVX512DQ-FAST-NEXT:    vpor %xmm6, %xmm2, %xmm2
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm2, %ymm0, %ymm27
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %ymm5, %ymm22, %ymm27
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm14, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm16, %ymm8, %ymm2
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,xmm5[2,9],zero,zero,zero,xmm5[5,12,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,11],zero,zero,xmm2[0,7,14],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm9
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm14, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm17, %ymm11, %ymm2
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u],zero,zero,zero,xmm5[6,13],zero,zero,xmm5[2,9,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,1,8,15],zero,zero,xmm2[4,11],zero,zero,xmm2[u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm15, %ymm5
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm29, %ymm13, %ymm5
; AVX512DQ-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm5[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3,4],ymm6[5],ymm5[6,7,8],ymm6[9],ymm5[10,11,12],ymm6[13],ymm5[14,15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[0,7,14,21,28,19,26,17,24,31,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpternlogq $244, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm5
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm19, %ymm18, %ymm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm2[u,u,u,u,u,u,u,6,13],zero,zero,xmm2[2,9],zero,zero,zero
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[4,11],zero,zero,xmm2[0,7,14]
; AVX512DQ-FAST-NEXT:    vpor %xmm6, %xmm2, %xmm2
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm2, %ymm0, %ymm30
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %ymm5, %ymm22, %ymm30
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm12, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm31, %ymm25, %ymm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u,u,2,9],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vporq %xmm5, %xmm2, %xmm22
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm18, %ymm19, %ymm15
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm12, %ymm5
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm16, %ymm8, %ymm5
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm4, %ymm6
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm16, %ymm8, %ymm4
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm1[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm1[6,13]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = xmm3[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512DQ-FAST-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm10, %ymm24, %ymm2
; AVX512DQ-FAST-NEXT:    vpternlogq $226, %ymm17, %ymm12, %ymm11
; AVX512DQ-FAST-NEXT:    vmovdqa %ymm14, %ymm8
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm24, %ymm10, %ymm8
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm24, %ymm10, %ymm12
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm5, %xmm10
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,xmm10[3,10],zero,zero,zero,xmm10[6,13,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[5,12],zero,zero,xmm5[1,8,15],zero,zero,xmm5[u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm10, %xmm5
; AVX512DQ-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm0[0],ymm2[1,2,3],ymm0[4],ymm2[5,6],ymm0[7,8],ymm2[9,10,11],ymm0[12],ymm2[13,14],ymm0[15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[3,10,1,8,15,6,13,20,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-FAST-NEXT:    vpternlogq $248, %ymm21, %ymm9, %ymm2
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm22, %ymm0, %ymm10
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %ymm10, %ymm26, %ymm7
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm8 = ymm8[0],ymm0[1],ymm8[2,3],ymm0[4],ymm8[5,6,7,8],ymm0[9],ymm8[10,11],ymm0[12],ymm8[13,14,15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm8[4,11,2,9,0,7,14,21,28],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-FAST-NEXT:    vpternlogq $248, %ymm21, %ymm5, %ymm8
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm4[6,13],zero,zero,xmm4[2,9],zero,zero,zero,xmm4[u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,xmm4[4,11],zero,zero,xmm4[0,7,14,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm12[0],ymm0[1],ymm12[2,3,4],ymm0[5],ymm12[6,7,8],ymm0[9],ymm12[10,11,12],ymm0[13],ymm12[14,15]
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} xmm10 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[5,12,3,10,1,8,15,22,29],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-FAST-NEXT:    vpternlogq $248, %ymm21, %ymm4, %ymm5
; AVX512DQ-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX512DQ-FAST-NEXT:    vpshufb %xmm10, %xmm9, %xmm4
; AVX512DQ-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm0[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm4[0],xmm12[0],xmm4[1],xmm12[1],xmm4[2],xmm12[2],xmm4[3],xmm12[3]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm7, %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %zmm2, %zmm7, %zmm4
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm31, %ymm25, %ymm6
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm6[u,u,3,10],zero,zero,zero,xmm6[6,13],zero,zero,xmm6[u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u],zero,zero,xmm6[1,8,15],zero,zero,xmm6[4,11,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX512DQ-FAST-NEXT:    vpternlogq $226, %ymm29, %ymm14, %ymm13
; AVX512DQ-FAST-NEXT:    vpternlogq $202, %ymm25, %ymm31, %ymm14
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm1[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm1[0,7,14]
; AVX512DQ-FAST-NEXT:    vpor %xmm6, %xmm12, %xmm6
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %ymm2, %ymm26, %ymm6
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[5,12,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm14[u,u,4,11],zero,zero,xmm14[0,7,14],zero,zero,xmm14[u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm2, %xmm12, %xmm2
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm1[1,8,15]
; AVX512DQ-FAST-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %ymm2, %ymm26, %ymm1
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm9[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm6, %zmm2
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %zmm8, %zmm7, %zmm2
; AVX512DQ-FAST-NEXT:    vpshufb %xmm10, %xmm0, %xmm3
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm9[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm1, %zmm1
; AVX512DQ-FAST-NEXT:    vpternlogq $184, %zmm5, %zmm7, %zmm1
; AVX512DQ-FAST-NEXT:    movw $-512, %ax # imm = 0xFE00
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k1
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm27, %zmm0, %zmm4 {%k1}
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm30, %zmm0, %zmm2 {%k1}
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[u,u,u,u,2,9],zero,zero,zero,xmm11[5,12],zero,zero,xmm11[u,u,u]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm5
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u],zero,zero,xmm5[0,7,14],zero,zero,xmm5[3,10,u,u,u]
; AVX512DQ-FAST-NEXT:    vpor %xmm3, %xmm5, %xmm3
; AVX512DQ-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm13[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm13[0,1],ymm5[2],ymm13[3,4],ymm5[5],ymm13[6,7,8,9],ymm5[10],ymm13[11,12],ymm5[13],ymm13[14,15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm5[1,8,15,22,29,20,27,18,25],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512DQ-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm5
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm15, %xmm3
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u],zero,zero,zero,xmm3[5,12],zero,zero,xmm3[1,8,15]
; AVX512DQ-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm15[u,u,u,u,u,u,0,7,14],zero,zero,xmm15[3,10],zero,zero,zero
; AVX512DQ-FAST-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm5[0,1,2],ymm0[3,4,5,6,7],ymm5[8,9,10],ymm0[11,12,13,14,15]
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vinserti32x8 $1, %ymm0, %zmm0, %zmm1 {%k1}
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovaps %zmm0, (%rsi)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm20, (%rdx)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm23, (%rcx)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm28, (%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, (%r9)
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512DQ-FAST-NEXT:    popq %rax
; AVX512DQ-FAST-NEXT:    vzeroupper
; AVX512DQ-FAST-NEXT:    retq
;
; AVX512BW-ONLY-SLOW-LABEL: load_i8_stride7_vf64:
; AVX512BW-ONLY-SLOW:       # %bb.0:
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %ymm24
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdi), %ymm23
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX512BW-ONLY-SLOW-NEXT:    movw $-28382, %ax # imm = 0x9122
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm1, %ymm24, %ymm0 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    kmovq %k1, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm5, %xmm0, %xmm22
; AVX512BW-ONLY-SLOW-NEXT:    movw $9288, %ax # imm = 0x2448
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k5
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm23, %ymm3, %ymm0 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm5[2],ymm0[3,4],ymm5[5],ymm0[6,7,8,9],ymm5[10],ymm0[11,12],ymm5[13],ymm0[14,15]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    movw $992, %ax # imm = 0x3E0
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm0, %ymm22 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm8
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 160(%rdi), %ymm7
; AVX512BW-ONLY-SLOW-NEXT:    movw $8772, %ax # imm = 0x2244
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k7
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm8, %ymm7, %ymm0 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u],zero,zero,xmm5[3,10],zero,zero,zero,xmm5[6,13,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,5,12],zero,zero,xmm0[1,8,15],zero,zero,xmm0[u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} xmm18 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb %xmm18, %xmm11, %xmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 208(%rdi), %xmm13
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm13[u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm5[7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 240(%rdi), %xmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm5[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 224(%rdi), %xmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm10 = xmm6[0,7,14],zero,zero,xmm6[u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm9, %xmm10, %xmm9
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    movabsq $137438429184, %rax # imm = 0x1FFFF80000
; AVX512BW-ONLY-SLOW-NEXT:    kmovq %rax, %k3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm22 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 288(%rdi), %ymm10
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 256(%rdi), %ymm9
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm10, %ymm9, %ymm0 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm0[u,u,u,u,u,3,10],zero,zero,zero,xmm0[6,13],zero,zero,xmm0[u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u],zero,zero,xmm0[1,8,15],zero,zero,xmm0[4,11,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm12, %xmm0, %xmm20
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 352(%rdi), %ymm14
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 320(%rdi), %ymm15
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm14, %ymm15, %ymm0 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm0[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm12[2],ymm0[3,4,5],ymm12[6],ymm0[7,8,9],ymm12[10],ymm0[11,12,13],ymm12[14],ymm0[15]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,2,9,16,23,30,21,28,19,26,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    movw $3968, %ax # imm = 0xF80
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-SLOW-NEXT:    kmovw %k1, {{[-0-9]+}}(%r{{[sb]}}p) # 2-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm0, %ymm20 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 416(%rdi), %ymm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 384(%rdi), %ymm12
; AVX512BW-ONLY-SLOW-NEXT:    movw $4644, %ax # imm = 0x1224
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k4
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm16, %ymm12, %ymm0 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti32x4 $1, %ymm0, %xmm17
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm17 = xmm17[u,u,u,u,u,u,u],zero,zero,zero,xmm17[6,13],zero,zero,xmm17[2,9]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,1,8,15],zero,zero,xmm0[4,11],zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm17, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm21
; AVX512BW-ONLY-SLOW-NEXT:    movl $-8388608, %eax # imm = 0xFF800000
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm1, %ymm24, %ymm0 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti32x4 $1, %ymm0, %xmm17
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm17 = zero,zero,zero,xmm17[6,13],zero,zero,xmm17[2,9,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm17, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm3, %ymm23, %ymm2 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    kmovw %k2, {{[-0-9]+}}(%r{{[sb]}}p) # 2-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4,5],ymm4[6],ymm2[7,8,9],ymm4[10],ymm2[11,12,13],ymm4[14],ymm2[15]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm17 = ymm2[u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    movl $511, %edi # imm = 0x1FF
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %edi, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm0, %ymm17 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm8, %ymm7, %ymm0 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero,xmm0[u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm13[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm11[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm2[7]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm5[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[1,8,15],zero,zero,xmm6[u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm4, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm17 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm3, %ymm23, %ymm0 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1,2],ymm2[3],ymm0[4,5],ymm2[6],ymm0[7,8,9,10],ymm2[11],ymm0[12,13],ymm2[14],ymm0[15]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm1, %ymm24, %ymm2 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[2,9],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    movl $261632, %edi # imm = 0x3FE00
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %edi, %k6
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 {%k6} = ymm0[u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,18,25,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm7, %ymm8, %ymm0 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u],zero,zero,zero,xmm4[5,12],zero,zero,xmm4[1,8,15,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm4, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb %xmm18, %xmm13, %xmm4
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm18 = xmm11[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm18[0],xmm4[0],xmm18[1],xmm4[1],xmm18[2],xmm4[2],xmm18[3],xmm4[3]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm4[7]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[2,9],zero,zero,zero,xmm6[u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm18 = zero,zero,xmm5[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm4, %xmm18, %xmm4
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %zmm2, %zmm18 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm3, %ymm23, %ymm0 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm2[0],ymm0[1,2],ymm2[3],ymm0[4,5,6],ymm2[7,8],ymm0[9,10],ymm2[11],ymm0[12,13,14],ymm2[15]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm1, %ymm24, %ymm2 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[3,10],zero,zero,zero,xmm2[6,13],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[1,8,15],zero,zero,xmm2[4,11,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 {%k6} = ymm0[u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,19,26,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm7, %ymm8, %ymm0 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u],zero,zero,zero,xmm4[6,13],zero,zero,xmm4[2,9,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm4, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm13[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm13[5,12]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm19 = xmm11[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm4, %xmm19, %xmm4
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512BW-ONLY-SLOW-NEXT:    movl $-134217728, %edi # imm = 0xF8000000
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %edi, %k2
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %k2, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm4, %ymm0 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[3,10],zero,zero,zero,xmm6[u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm19 = zero,zero,xmm5[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm4, %xmm19, %xmm4
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm19
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %zmm2, %zmm19 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm21, %ymm20 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm20, %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    movabsq $-137438953472, %rax # imm = 0xFFFFFFE000000000
; AVX512BW-ONLY-SLOW-NEXT:    kmovq %rax, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm22 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm9, %ymm10, %ymm0 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[5,12,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,4,11],zero,zero,xmm0[0,7,14],zero,zero,xmm0[u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm14, %ymm15, %ymm2 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1,2],ymm4[3],ymm2[4,5],ymm4[6],ymm2[7,8,9,10],ymm4[11],ymm2[12,13],ymm4[14],ymm2[15]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,3,10,17,24,31,22,29,20,27,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    kmovw {{[-0-9]+}}(%r{{[sb]}}p), %k3 # 2-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm2, %ymm0 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm16, %ymm12, %ymm2 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm2[5,12],zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm2, %ymm0 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm17 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm9, %ymm10, %ymm0 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[6,13,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,5,12],zero,zero,xmm0[1,8,15],zero,zero,xmm0[u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm15, %ymm14, %ymm2 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1,2],ymm4[3],ymm2[4,5,6],ymm4[7,8],ymm2[9,10],ymm4[11],ymm2[12,13,14],ymm4[15]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,4,11,18,25,16,23,30,21,28,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm2, %ymm0 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm16, %ymm12, %ymm2 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm2[6,13],zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[1,8,15],zero,zero,xmm2[4,11]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm2, %ymm0 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm18 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm9, %ymm10, %ymm0 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[u,u,u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero,xmm0[u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm15, %ymm14, %ymm2 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1,2,3],ymm4[4],ymm2[5,6],ymm4[7,8],ymm2[9,10,11],ymm4[12],ymm2[13,14],ymm4[15]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,5,12,19,26,17,24,31,22,29,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm2, %ymm0 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm12, %ymm16, %ymm2 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u,u,u],zero,zero,xmm4[2,9],zero,zero,zero,xmm4[5,12]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u,4,11],zero,zero,xmm2[0,7,14],zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm2, %ymm0 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm19 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    kmovw {{[-0-9]+}}(%r{{[sb]}}p), %k1 # 2-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm10, %ymm9, %ymm0 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[1,8,15,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm2, %xmm0, %xmm20
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm15, %ymm14, %ymm0 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2,3],ymm2[4],ymm0[5,6,7,8],ymm2[9],ymm0[10,11],ymm2[12],ymm0[13,14,15]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,6,13,20,27,18,25,16,23,30,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm0, %ymm20 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm10, %ymm9, %ymm0 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u],zero,zero,zero,xmm2[6,13],zero,zero,xmm2[2,9,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm14, %ymm15, %ymm2 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    kmovq %k1, %k3
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3,4],ymm4[5],ymm2[6,7,8],ymm4[9],ymm2[10,11,12],ymm4[13],ymm2[14,15]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm21 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,0,7,14,21,28,19,26,17,24,31,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    movl $8176, %eax # imm = 0x1FF0
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm0, %ymm21 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm12, %ymm16, %ymm0 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[6,13]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,5,12],zero,zero,xmm0[1,8,15],zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm0, %ymm20 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm12, %ymm16, %ymm0 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[u,u,u,u,u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm0, %ymm21 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm3, %ymm23, %ymm0 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm24, %ymm1, %ymm2 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm24, %ymm1, %ymm4 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm7, %ymm8, %ymm25 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm24, %ymm1 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm7, %ymm8, %ymm24 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm26 = xmm24[u,u,2,9],zero,zero,zero,xmm24[5,12],zero,zero,xmm24[u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti32x4 $1, %ymm24, %xmm24
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm24 = xmm24[u,u],zero,zero,xmm24[0,7,14],zero,zero,xmm24[3,10,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm26, %xmm24, %xmm24
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm24, %ymm0, %ymm24
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm26 = xmm13[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm13[6,13]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm27 = xmm11[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm26, %xmm27, %xmm26
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm26, %ymm0, %ymm26
; AVX512BW-ONLY-SLOW-NEXT:    kmovd {{[-0-9]+}}(%r{{[sb]}}p), %k1 # 4-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm26, %ymm24 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm26 = xmm25[u,u,3,10],zero,zero,zero,xmm25[6,13],zero,zero,xmm25[u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti32x4 $1, %ymm25, %xmm25
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm25 = xmm25[u,u],zero,zero,xmm25[1,8,15],zero,zero,xmm25[4,11,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm26, %xmm25, %xmm25
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm26 = xmm11[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm27 = xmm13[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm13[0,7,14]
; AVX512BW-ONLY-SLOW-NEXT:    vporq %xmm26, %xmm27, %xmm26
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm25, %ymm0, %ymm25
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm26, %ymm0, %ymm26
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm26, %ymm25 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm8, %ymm7 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u],zero,zero,xmm8[2,9],zero,zero,zero,xmm8[5,12,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,4,11],zero,zero,xmm7[0,7,14],zero,zero,xmm7[u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm11[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm13[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm13[1,8,15]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm8, %xmm11, %xmm8
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu8 %ymm8, %ymm7 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm8[0],ymm0[1,2,3],ymm8[4],ymm0[5,6],ymm8[7,8],ymm0[9,10,11],ymm8[12],ymm0[13,14],ymm8[15]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm8[2,9],zero,zero,zero,xmm8[5,12,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,11],zero,zero,xmm2[0,7,14],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm2, %xmm8, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 {%k6} = ymm0[u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,20,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb %xmm0, %xmm6, %xmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm5[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm11[0],xmm8[1],xmm11[1],xmm8[2],xmm11[2],xmm8[3],xmm11[3]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm8, %zmm24, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %zmm8, %zmm2 {%k6}
; AVX512BW-ONLY-SLOW-NEXT:    vpblendmw %ymm23, %ymm3, %ymm8 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm11
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm8[0],ymm11[1],ymm8[2,3],ymm11[4],ymm8[5,6,7,8],ymm11[9],ymm8[10,11],ymm11[12],ymm8[13,14,15]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm11
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,xmm11[3,10],zero,zero,zero,xmm11[6,13,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[5,12],zero,zero,xmm4[1,8,15],zero,zero,xmm4[u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 {%k6} = ymm8[u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,21,28,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm5[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm6[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm11[0],xmm8[0],xmm11[1],xmm8[1],xmm11[2],xmm8[2],xmm11[3],xmm8[3]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm8, %zmm25, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %zmm8, %zmm4 {%k6}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm23, %ymm3 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm8[1],ymm3[2,3,4],ymm8[5],ymm3[6,7,8],ymm8[9],ymm3[10,11,12],ymm8[13],ymm3[14,15]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm1[6,13],zero,zero,xmm1[2,9],zero,zero,zero,xmm1[u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[4,11],zero,zero,xmm1[0,7,14,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm1, %xmm8, %xmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 {%k6} = ymm3[u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,22,29,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb %xmm0, %xmm5, %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm6[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm7, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k6}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm14, %ymm15 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm15[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm15[0,1],ymm0[2],ymm15[3,4],ymm0[5],ymm15[6,7,8,9],ymm0[10],ymm15[11,12],ymm0[13],ymm15[14,15]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm10, %ymm9 {%k7}
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm9[u,u,u,u,2,9],zero,zero,zero,xmm9[5,12],zero,zero,xmm9[u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm9, %xmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u],zero,zero,xmm5[0,7,14],zero,zero,xmm5[3,10,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm5, %xmm3
; AVX512BW-ONLY-SLOW-NEXT:    movl $4186112, %eax # imm = 0x3FE000
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 {%k1} = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,1,8,15,22,29,20,27,18,25,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm20, %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    movw $-512, %ax # imm = 0xFE00
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu16 %ymm16, %ymm12 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa32 %zmm0, %zmm2 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm21, %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa32 %zmm0, %zmm4 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm12, %xmm3
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u],zero,zero,zero,xmm3[5,12],zero,zero,xmm3[1,8,15]
; AVX512BW-ONLY-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm12[u,u,u,u,u,u,0,7,14],zero,zero,xmm12[3,10],zero,zero,zero
; AVX512BW-ONLY-SLOW-NEXT:    vpor %xmm3, %xmm5, %xmm3
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,17,18,19,20,21,22,23,24,25,26,43,44,45,46,47]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2w %zmm3, %zmm0, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm22, (%rsi)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, (%rdx)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm19, (%r8)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, (%r9)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, (%rdi)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vzeroupper
; AVX512BW-ONLY-SLOW-NEXT:    retq
;
; AVX512BW-ONLY-FAST-LABEL: load_i8_stride7_vf64:
; AVX512BW-ONLY-FAST:       # %bb.0:
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 320(%rdi), %zmm26
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [24,17,2,19,28,21,6,31,16,9,26,27,20,13,30,23]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm26, %zmm2, %zmm24
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,1,18,11,4,5,22,15,0,25,10,3,12,29,14,7]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [24,17,2,27,20,5,22,31,16,9,26,19,12,29,30,23]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm26, %zmm2, %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,18,11,4,21,14,7,8,25,10,3,28,13,6,15]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm25
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,2,11,4,5,14,7,8,9,26,19,12,29,22,15]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm26, %zmm2, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,17,10,3,4,21,14,7,24,9,2,11,28,13,6,31]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,10,3,4,5,14,7,8,25,18,11,12,29,22,15]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm26, %zmm2, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [16,17,10,3,20,13,6,23,24,25,18,27,28,21,30,31]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa (%rdi), %ymm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 32(%rdi), %ymm3
; AVX512BW-ONLY-FAST-NEXT:    movw $-28382, %ax # imm = 0x9122
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm3, %ymm9, %ymm2 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    kmovq %k1, %k2
; AVX512BW-ONLY-FAST-NEXT:    kmovw %k1, {{[-0-9]+}}(%r{{[sb]}}p) # 2-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    movw $992, %ax # imm = 0x3E0
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %ymm4, %ymm2 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 128(%rdi), %ymm11
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 160(%rdi), %ymm8
; AVX512BW-ONLY-FAST-NEXT:    movw $8772, %ax # imm = 0x2244
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm11, %ymm8, %ymm4 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    kmovq %k1, %k3
; AVX512BW-ONLY-FAST-NEXT:    kmovw %k1, {{[-0-9]+}}(%r{{[sb]}}p) # 2-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u],zero,zero,xmm5[3,10],zero,zero,zero,xmm5[6,13,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,5,12],zero,zero,xmm4[1,8,15],zero,zero,xmm4[u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,1,2,4,6>
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 192(%rdi), %ymm19
; AVX512BW-ONLY-FAST-NEXT:    vpermd %ymm19, %ymm5, %ymm5
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,23,26,29]
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm4[0,1,2,3,4,5,6],ymm5[7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 240(%rdi), %xmm4
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm4[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 224(%rdi), %xmm7
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm7[0,7,14],zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm6, %xmm12, %xmm6
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm5, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    movabsq $137438429184, %rax # imm = 0x1FFFF80000
; AVX512BW-ONLY-FAST-NEXT:    kmovq %rax, %k5
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %zmm5, %zmm2 {%k5}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 288(%rdi), %ymm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 256(%rdi), %ymm5
; AVX512BW-ONLY-FAST-NEXT:    movw $9288, %ax # imm = 0x2448
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k7
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm6, %ymm5, %ymm12 {%k7}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm12[u,u,u,u,u,3,10],zero,zero,zero,xmm12[6,13],zero,zero,xmm12[u,u]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm12, %xmm12
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u,u,u,u],zero,zero,xmm12[1,8,15],zero,zero,xmm12[4,11,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm20, %xmm12, %xmm21
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,2,9,16,23,30,21,28,19,26,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    movw $3968, %ax # imm = 0xF80
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    kmovw %k1, {{[-0-9]+}}(%r{{[sb]}}p) # 2-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %ymm10, %ymm21 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 416(%rdi), %ymm12
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 384(%rdi), %ymm10
; AVX512BW-ONLY-FAST-NEXT:    movw $4644, %ax # imm = 0x1224
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k6
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm12, %ymm10, %ymm20 {%k6}
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm20, %xmm22
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm22 = xmm22[u,u,u,u,u,u,u],zero,zero,zero,xmm22[6,13],zero,zero,xmm22[2,9]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm20[u,u,u,u,u,u,u,1,8,15],zero,zero,xmm20[4,11],zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm22, %xmm20, %xmm20
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm22
; AVX512BW-ONLY-FAST-NEXT:    movl $-8388608, %eax # imm = 0xFF800000
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm3, %ymm9, %ymm20 {%k6}
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm20, %xmm23
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm23 = zero,zero,zero,xmm23[6,13],zero,zero,xmm23[2,9,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm20[1,8,15],zero,zero,xmm20[4,11],zero,zero,xmm20[u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm23, %xmm20, %xmm20
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    movl $511, %r10d # imm = 0x1FF
; AVX512BW-ONLY-FAST-NEXT:    kmovd %r10d, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm20, %ymm13 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm11, %ymm8, %ymm20 {%k7}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm23 = xmm20[u,u,u,6,13],zero,zero,xmm20[2,9],zero,zero,zero,xmm20[u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm20, %xmm20
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm20[u,u,u],zero,zero,xmm20[4,11],zero,zero,xmm20[0,7,14,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm23, %xmm20, %xmm20
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm20 = <u,u,u,u,1,3,4,6>
; AVX512BW-ONLY-FAST-NEXT:    vpermd %ymm19, %ymm20, %ymm20
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm15 = ymm20[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,17,20,27,30]
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5,6],ymm15[7]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,zero,xmm4[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm7[1,8,15],zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm15, %xmm20, %xmm15
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm14, %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %zmm14, %zmm13 {%k5}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm3, %ymm9, %ymm14 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[2,9],zero,zero,zero,xmm14[5,12],zero,zero,xmm14[u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,xmm14[0,7,14],zero,zero,xmm14[3,10,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    movl $261632, %r10d # imm = 0x3FE00
; AVX512BW-ONLY-FAST-NEXT:    kmovd %r10d, %k5
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm14 {%k5} = ymm25[u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,18,25,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm8, %ymm11, %ymm15 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm15, %xmm20
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm20[u,u],zero,zero,zero,xmm20[5,12],zero,zero,xmm20[1,8,15,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[u,u,0,7,14],zero,zero,xmm15[3,10],zero,zero,zero,xmm15[u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm20, %xmm15, %xmm15
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm20 = <u,u,u,u,1,3,5,6>
; AVX512BW-ONLY-FAST-NEXT:    vpermd %ymm19, %ymm20, %ymm19
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm19[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,21,24,31]
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3,4,5,6],ymm0[7]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm7[2,9],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm19 = zero,zero,xmm4[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm15, %xmm19, %xmm15
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm15
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %zmm14, %zmm15 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm3, %ymm9, %ymm0 {%k7}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm0[3,10],zero,zero,zero,xmm0[6,13],zero,zero,xmm0[u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[1,8,15],zero,zero,xmm0[4,11,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm0, %xmm14, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm0 {%k5} = ymm18[u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,19,26,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm8, %ymm11, %ymm14 {%k6}
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm14, %xmm18
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm18 = xmm18[u,u],zero,zero,zero,xmm18[6,13],zero,zero,xmm18[2,9,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,1,8,15],zero,zero,xmm14[4,11],zero,zero,xmm14[u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm18, %xmm14, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 208(%rdi), %xmm19
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm18 = xmm19[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm19[5,12]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 192(%rdi), %xmm20
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm23 = xmm20[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm18, %xmm23, %xmm18
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm18, %ymm0, %ymm18
; AVX512BW-ONLY-FAST-NEXT:    movl $-134217728, %edi # imm = 0xF8000000
; AVX512BW-ONLY-FAST-NEXT:    kmovd %edi, %k2
; AVX512BW-ONLY-FAST-NEXT:    kmovd %k2, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm18, %ymm14 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm18 = xmm7[3,10],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm23 = zero,zero,xmm4[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm18, %xmm23, %xmm18
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm18, %zmm14, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %zmm0, %zmm18 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm22, %ymm21 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm21, %zmm0, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    movabsq $-137438953472, %rax # imm = 0xFFFFFFE000000000
; AVX512BW-ONLY-FAST-NEXT:    kmovq %rax, %k2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %zmm0, %zmm2 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm5, %ymm6, %ymm0 {%k6}
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,u],zero,zero,xmm14[2,9],zero,zero,zero,xmm14[5,12,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,4,11],zero,zero,xmm0[0,7,14],zero,zero,xmm0[u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm0, %xmm14, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm14 = ymm17[u,u,u,u,u,u,u,u,u,u,u,u,u,u,3,10,17,24,31,22,29,20,27,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    kmovw {{[-0-9]+}}(%r{{[sb]}}p), %k3 # 2-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %ymm14, %ymm0 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    kmovw {{[-0-9]+}}(%r{{[sb]}}p), %k1 # 2-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm12, %ymm10, %ymm14 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm14[u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm14[5,12],zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,u,u,u],zero,zero,xmm14[0,7,14],zero,zero,xmm14[3,10]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm17, %xmm14, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm14, %ymm0 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %zmm0, %zmm13 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm5, %ymm6, %ymm0 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,u],zero,zero,xmm14[3,10],zero,zero,zero,xmm14[6,13,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,5,12],zero,zero,xmm0[1,8,15],zero,zero,xmm0[u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm0, %xmm14, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm14 = ymm16[u,u,u,u,u,u,u,u,u,u,u,u,u,u,4,11,18,25,16,23,30,21,28,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %ymm14, %ymm0 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm12, %ymm10, %ymm14 {%k7}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm16 = xmm14[u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm14[6,13],zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,u,u,u],zero,zero,xmm14[1,8,15],zero,zero,xmm14[4,11]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm16, %xmm14, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm14, %ymm0 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %zmm0, %zmm15 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm5, %ymm6, %ymm0 {%k7}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm0[u,u,u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero,xmm0[u,u]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm0, %xmm14, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm14 = ymm24[u,u,u,u,u,u,u,u,u,u,u,u,u,u,5,12,19,26,17,24,31,22,29,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %ymm14, %ymm0 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm10, %ymm12, %ymm14 {%k6}
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm14, %xmm16
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm16 = xmm16[u,u,u,u,u,u,u],zero,zero,xmm16[2,9],zero,zero,zero,xmm16[5,12]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,u,u,u,4,11],zero,zero,xmm14[0,7,14],zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm16, %xmm14, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm14, %ymm0 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %zmm0, %zmm18 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [0,9,2,3,4,13,6,7,24,17,10,11,28,21,14,31]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm26, %zmm0, %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [16,25,18,3,28,21,6,23,24,17,10,27,20,13,30,31]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm26, %zmm0, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    kmovw {{[-0-9]+}}(%r{{[sb]}}p), %k2 # 2-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm6, %ymm5, %ymm14 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm14, %xmm17
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm17[u,u,u,u],zero,zero,zero,xmm17[5,12],zero,zero,xmm17[1,8,15,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,0,7,14],zero,zero,xmm14[3,10],zero,zero,zero,xmm14[u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm17, %xmm14, %xmm14
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,6,13,20,27,18,25,16,23,30,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %ymm0, %ymm14 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm6, %ymm5, %ymm0 {%k6}
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm0, %xmm17
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm17[u,u,u,u],zero,zero,zero,xmm17[6,13],zero,zero,xmm17[2,9,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm17, %xmm0, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm16 = ymm16[u,u,u,u,u,u,u,u,u,u,u,u,u,0,7,14,21,28,19,26,17,24,31,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    movl $8176, %eax # imm = 0x1FF0
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm0, %ymm16 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    kmovw {{[-0-9]+}}(%r{{[sb]}}p), %k1 # 2-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm10, %ymm12, %ymm0 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm0, %xmm17
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm17[u,u,u,u,u,u,u],zero,zero,xmm17[3,10],zero,zero,zero,xmm17[6,13]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,5,12],zero,zero,xmm0[1,8,15],zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm17, %xmm0, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm0, %ymm14 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm10, %ymm12, %ymm0 {%k7}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm0[u,u,u,u,u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm17, %xmm0, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm0, %ymm16 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm9, %ymm3, %ymm0 {%k6}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm9, %ymm3, %ymm17 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm8, %ymm11, %ymm21 {%k7}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %ymm9, %ymm3 {%k7}
; AVX512BW-ONLY-FAST-NEXT:    vpblendmw %ymm8, %ymm11, %ymm9 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %ymm11, %ymm8 {%k6}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm9[u,u,2,9],zero,zero,zero,xmm9[5,12],zero,zero,xmm9[u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,u],zero,zero,xmm9[0,7,14],zero,zero,xmm9[3,10,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm11, %xmm9, %xmm9
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm19[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm19[6,13]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm22 = xmm20[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm11, %xmm22, %xmm11
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-ONLY-FAST-NEXT:    kmovd {{[-0-9]+}}(%r{{[sb]}}p), %k3 # 4-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm11, %ymm9 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm21[u,u,3,10],zero,zero,zero,xmm21[6,13],zero,zero,xmm21[u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm21, %xmm21
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm21 = xmm21[u,u],zero,zero,xmm21[1,8,15],zero,zero,xmm21[4,11,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm11, %xmm21, %xmm11
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm21 = xmm20[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm22 = xmm19[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm19[0,7,14]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm21, %xmm22, %xmm21
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm21, %ymm0, %ymm21
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm21, %ymm11 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm8, %xmm21
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm21 = xmm21[u,u],zero,zero,xmm21[2,9],zero,zero,zero,xmm21[5,12,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,4,11],zero,zero,xmm8[0,7,14],zero,zero,xmm8[u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm21, %xmm8, %xmm8
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm20[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm19 = xmm19[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm19[1,8,15]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm20, %xmm19, %xmm19
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm19, %ymm0, %ymm19
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu8 %ymm19, %ymm8 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm19 = [16,9,2,19,20,13,6,23,24,17,26,27,28,21,30,31]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm1, %zmm19, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm20 = [16,9,2,19,12,5,22,23,24,17,26,27,20,29,30,31]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm1, %zmm20, %zmm20
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm21 = [8,1,2,19,12,5,22,15,0,9,26,11,4,29,14,7]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm1, %zmm21, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm0, %xmm21
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm21 = zero,zero,xmm21[2,9],zero,zero,zero,xmm21[5,12,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,11],zero,zero,xmm0[0,7,14],zero,zero,xmm0[u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm21, %xmm0, %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm0 {%k5} = ymm1[u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,20,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} xmm1 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512BW-ONLY-FAST-NEXT:    vpshufb %xmm1, %xmm7, %xmm21
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm22 = xmm4[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm21 = xmm21[0],xmm22[0],xmm21[1],xmm22[1],xmm21[2],xmm22[2],xmm21[3],xmm22[3]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm21, %zmm9, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %zmm9, %zmm0 {%k5}
; AVX512BW-ONLY-FAST-NEXT:    vextracti32x4 $1, %ymm17, %xmm9
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,xmm9[3,10],zero,zero,zero,xmm9[6,13,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm17[5,12],zero,zero,xmm17[1,8,15],zero,zero,xmm17[u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vporq %xmm9, %xmm17, %xmm9
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm9 {%k5} = ymm20[u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,21,28,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm4[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm7[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm17 = xmm20[0],xmm17[0],xmm20[1],xmm17[1],xmm20[2],xmm17[2],xmm20[3],xmm17[3]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm17, %zmm11, %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %zmm11, %zmm9 {%k5}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm3[6,13],zero,zero,xmm3[2,9],zero,zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,xmm3[4,11],zero,zero,xmm3[0,7,14,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm3, %xmm11, %xmm3
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm3 {%k5} = ymm19[u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,22,29,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm7[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm8, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %zmm1, %zmm3 {%k5}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %ymm12, %ymm10 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,10,3,4,13,6,7,8,25,18,11,28,21,14,15]
; AVX512BW-ONLY-FAST-NEXT:    vpermw %zmm26, %zmm1, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm14, %zmm0, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    movw $-512, %ax # imm = 0xFE00
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu16 %ymm6, %ymm5 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[u,u,u,u,2,9],zero,zero,zero,xmm5[5,12],zero,zero,xmm5[u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u],zero,zero,xmm5[0,7,14],zero,zero,xmm5[3,10,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512BW-ONLY-FAST-NEXT:    movl $4186112, %edi # imm = 0x3FE000
; AVX512BW-ONLY-FAST-NEXT:    kmovd %edi, %k1
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} ymm5 {%k1} = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,1,8,15,22,29,20,27,18,25,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa32 %zmm4, %zmm0 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm16, %zmm0, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa32 %zmm1, %zmm9 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm1
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u],zero,zero,zero,xmm1[5,12],zero,zero,xmm1[1,8,15]
; AVX512BW-ONLY-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm10[u,u,u,u,u,u,0,7,14],zero,zero,xmm10[3,10],zero,zero,zero
; AVX512BW-ONLY-FAST-NEXT:    vpor %xmm1, %xmm4, %xmm1
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,17,18,19,20,21,22,23,24,25,26,43,44,45,46,47]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2w %zmm1, %zmm4, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa32 %zmm1, %zmm3 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, (%rdx)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm15, (%rcx)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, (%r8)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, (%rdi)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512BW-ONLY-FAST-NEXT:    vzeroupper
; AVX512BW-ONLY-FAST-NEXT:    retq
;
; AVX512DQBW-SLOW-LABEL: load_i8_stride7_vf64:
; AVX512DQBW-SLOW:       # %bb.0:
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rdi), %ymm26
; AVX512DQBW-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rdi), %ymm25
; AVX512DQBW-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX512DQBW-SLOW-NEXT:    movw $-28382, %ax # imm = 0x9122
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k1
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm1, %ymm26, %ymm0 {%k1}
; AVX512DQBW-SLOW-NEXT:    kmovq %k1, %k2
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm5
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vporq %xmm5, %xmm0, %xmm24
; AVX512DQBW-SLOW-NEXT:    movw $9288, %ax # imm = 0x2448
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k3
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm25, %ymm3, %ymm0 {%k3}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm5
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm5[2],ymm0[3,4],ymm5[5],ymm0[6,7,8,9],ymm5[10],ymm0[11,12],ymm5[13],ymm0[14,15]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    movw $992, %ax # imm = 0x3E0
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm0, %ymm24 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm8
; AVX512DQBW-SLOW-NEXT:    vmovdqa 160(%rdi), %ymm7
; AVX512DQBW-SLOW-NEXT:    movw $8772, %ax # imm = 0x2244
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k6
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm8, %ymm7, %ymm0 {%k6}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm5
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u],zero,zero,xmm5[3,10],zero,zero,zero,xmm5[6,13,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,5,12],zero,zero,xmm0[1,8,15],zero,zero,xmm0[u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} xmm18 = <u,u,u,u,u,u,4,11,u,u,u,u,u,u,u,u>
; AVX512DQBW-SLOW-NEXT:    vpshufb %xmm18, %xmm11, %xmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa 208(%rdi), %xmm12
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm12[u,u,u,u,u,u,2,9,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm5[7]
; AVX512DQBW-SLOW-NEXT:    vmovdqa 240(%rdi), %xmm5
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm5[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vmovdqa 224(%rdi), %xmm6
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm10 = xmm6[0,7,14],zero,zero,xmm6[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm9, %xmm10, %xmm9
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm0, %zmm0
; AVX512DQBW-SLOW-NEXT:    movabsq $137438429184, %rax # imm = 0x1FFFF80000
; AVX512DQBW-SLOW-NEXT:    kmovq %rax, %k5
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm24 {%k5}
; AVX512DQBW-SLOW-NEXT:    vmovdqa 288(%rdi), %ymm10
; AVX512DQBW-SLOW-NEXT:    vmovdqa 256(%rdi), %ymm9
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm10, %ymm9, %ymm0 {%k3}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm0[u,u,u,u,u,3,10],zero,zero,zero,xmm0[6,13],zero,zero,xmm0[u,u]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u],zero,zero,xmm0[1,8,15],zero,zero,xmm0[4,11,u,u]
; AVX512DQBW-SLOW-NEXT:    vporq %xmm13, %xmm0, %xmm20
; AVX512DQBW-SLOW-NEXT:    vmovdqa 352(%rdi), %ymm14
; AVX512DQBW-SLOW-NEXT:    vmovdqa 320(%rdi), %ymm15
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm14, %ymm15, %ymm0 {%k6}
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm0[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm13[2],ymm0[3,4,5],ymm13[6],ymm0[7,8,9],ymm13[10],ymm0[11,12,13],ymm13[14],ymm0[15]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,2,9,16,23,30,21,28,19,26,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    movw $3968, %ax # imm = 0xF80
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k7
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm0, %ymm20 {%k7}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 416(%rdi), %ymm16
; AVX512DQBW-SLOW-NEXT:    vmovdqa 384(%rdi), %ymm13
; AVX512DQBW-SLOW-NEXT:    movw $4644, %ax # imm = 0x1224
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k4
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm16, %ymm13, %ymm0 {%k4}
; AVX512DQBW-SLOW-NEXT:    vextracti32x4 $1, %ymm0, %xmm17
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm17 = xmm17[u,u,u,u,u,u,u],zero,zero,zero,xmm17[6,13],zero,zero,xmm17[2,9]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,1,8,15],zero,zero,xmm0[4,11],zero,zero
; AVX512DQBW-SLOW-NEXT:    vporq %xmm17, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm21
; AVX512DQBW-SLOW-NEXT:    movl $-8388608, %eax # imm = 0xFF800000
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm1, %ymm26, %ymm0 {%k4}
; AVX512DQBW-SLOW-NEXT:    vextracti32x4 $1, %ymm0, %xmm17
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm17 = zero,zero,zero,xmm17[6,13],zero,zero,xmm17[2,9,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vporq %xmm17, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm3, %ymm25, %ymm2 {%k2}
; AVX512DQBW-SLOW-NEXT:    kmovw %k2, {{[-0-9]+}}(%r{{[sb]}}p) # 2-byte Spill
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4,5],ymm4[6],ymm2[7,8,9],ymm4[10],ymm2[11,12,13],ymm4[14],ymm2[15]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm17 = ymm2[u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    movl $511, %edi # imm = 0x1FF
; AVX512DQBW-SLOW-NEXT:    kmovd %edi, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm0, %ymm17 {%k1}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm8, %ymm7, %ymm0 {%k3}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero,xmm0[u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm12[u,u,u,u,u,u,3,10,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm11[u,u,u,u,u,u,5,12,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm2[7]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm5[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[1,8,15],zero,zero,xmm6[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm2, %xmm4, %xmm2
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm17 {%k5}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm3, %ymm25, %ymm0 {%k4}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1,2],ymm2[3],ymm0[4,5],ymm2[6],ymm0[7,8,9,10],ymm2[11],ymm0[12,13],ymm2[14],ymm0[15]
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm1, %ymm26, %ymm2 {%k6}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[2,9],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    movl $261632, %edi # imm = 0x3FE00
; AVX512DQBW-SLOW-NEXT:    kmovd %edi, %k5
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 {%k5} = ymm0[u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,18,25,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm7, %ymm8, %ymm0 {%k2}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u],zero,zero,zero,xmm4[5,12],zero,zero,xmm4[1,8,15,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm4, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQBW-SLOW-NEXT:    vpshufb %xmm18, %xmm12, %xmm4
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm18 = xmm11[u,u,u,u,u,u,6,13,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm18[0],xmm4[0],xmm18[1],xmm4[1],xmm18[2],xmm4[2],xmm18[3],xmm4[3]
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5,6],ymm4[7]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[2,9],zero,zero,zero,xmm6[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm18 = zero,zero,xmm5[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vporq %xmm4, %xmm18, %xmm4
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm18
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %zmm2, %zmm18 {%k1}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm3, %ymm25, %ymm0 {%k6}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm2[0],ymm0[1,2],ymm2[3],ymm0[4,5,6],ymm2[7,8],ymm0[9,10],ymm2[11],ymm0[12,13,14],ymm2[15]
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm1, %ymm26, %ymm2 {%k3}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[3,10],zero,zero,zero,xmm2[6,13],zero,zero,xmm2[u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,xmm2[1,8,15],zero,zero,xmm2[4,11,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 {%k5} = ymm0[u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,19,26,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm7, %ymm8, %ymm0 {%k4}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u],zero,zero,zero,xmm4[6,13],zero,zero,xmm4[2,9,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm4, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm12[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[5,12]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm19 = xmm11[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512DQBW-SLOW-NEXT:    vporq %xmm4, %xmm19, %xmm4
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512DQBW-SLOW-NEXT:    movl $-134217728, %edi # imm = 0xF8000000
; AVX512DQBW-SLOW-NEXT:    kmovd %edi, %k2
; AVX512DQBW-SLOW-NEXT:    kmovd %k2, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm4, %ymm0 {%k2}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[3,10],zero,zero,zero,xmm6[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm19 = zero,zero,xmm5[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vporq %xmm4, %xmm19, %xmm4
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm19
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %zmm2, %zmm19 {%k1}
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k2
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm21, %ymm20 {%k2}
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm20, %zmm0, %zmm0
; AVX512DQBW-SLOW-NEXT:    movabsq $-137438953472, %rax # imm = 0xFFFFFFE000000000
; AVX512DQBW-SLOW-NEXT:    kmovq %rax, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm24 {%k1}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm9, %ymm10, %ymm0 {%k4}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u],zero,zero,xmm2[2,9],zero,zero,zero,xmm2[5,12,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,4,11],zero,zero,xmm0[0,7,14],zero,zero,xmm0[u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm14, %ymm15, %ymm2 {%k3}
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1,2],ymm4[3],ymm2[4,5],ymm4[6],ymm2[7,8,9,10],ymm4[11],ymm2[12,13],ymm4[14],ymm2[15]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,3,10,17,24,31,22,29,20,27,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm2, %ymm0 {%k7}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm16, %ymm13, %ymm2 {%k6}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm2[5,12],zero,zero
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[0,7,14],zero,zero,xmm2[3,10]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm2, %ymm0 {%k2}
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm17 {%k1}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm9, %ymm10, %ymm0 {%k6}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[6,13,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,5,12],zero,zero,xmm0[1,8,15],zero,zero,xmm0[u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm15, %ymm14, %ymm2 {%k4}
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1,2],ymm4[3],ymm2[4,5,6],ymm4[7,8],ymm2[9,10],ymm4[11],ymm2[12,13,14],ymm4[15]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,4,11,18,25,16,23,30,21,28,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm2, %ymm0 {%k7}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm16, %ymm13, %ymm2 {%k3}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm2[6,13],zero,zero
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[1,8,15],zero,zero,xmm2[4,11]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm2, %ymm0 {%k2}
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm18 {%k1}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm9, %ymm10, %ymm0 {%k3}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[u,u,u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero,xmm0[u,u]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm15, %ymm14, %ymm2 {%k6}
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1,2,3],ymm4[4],ymm2[5,6],ymm4[7,8],ymm2[9,10,11],ymm4[12],ymm2[13,14],ymm4[15]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,5,12,19,26,17,24,31,22,29,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm2, %ymm0 {%k7}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm13, %ymm16, %ymm2 {%k4}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u,u,u,u],zero,zero,xmm4[2,9],zero,zero,zero,xmm4[5,12]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u,4,11],zero,zero,xmm2[0,7,14],zero,zero
; AVX512DQBW-SLOW-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm2, %ymm0 {%k2}
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %zmm0, %zmm19 {%k1}
; AVX512DQBW-SLOW-NEXT:    kmovw {{[-0-9]+}}(%r{{[sb]}}p), %k1 # 2-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm10, %ymm9, %ymm0 {%k1}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[1,8,15,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,0,7,14],zero,zero,xmm0[3,10],zero,zero,zero,xmm0[u,u]
; AVX512DQBW-SLOW-NEXT:    vporq %xmm2, %xmm0, %xmm20
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm15, %ymm14, %ymm0 {%k3}
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2,3],ymm2[4],ymm0[5,6,7,8],ymm2[9],ymm0[10,11],ymm2[12],ymm0[13,14,15]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,u,6,13,20,27,18,25,16,23,30,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm0, %ymm20 {%k7}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm10, %ymm9, %ymm0 {%k4}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u],zero,zero,zero,xmm2[6,13],zero,zero,xmm2[2,9,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,1,8,15],zero,zero,xmm0[4,11],zero,zero,xmm0[u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm14, %ymm15, %ymm2 {%k1}
; AVX512DQBW-SLOW-NEXT:    kmovq %k1, %k7
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3,4],ymm4[5],ymm2[6,7,8],ymm4[9],ymm2[10,11,12],ymm4[13],ymm2[14,15]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm21 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,0,7,14,21,28,19,26,17,24,31,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    movl $8176, %eax # imm = 0x1FF0
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm0, %ymm21 {%k1}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm13, %ymm16, %ymm0 {%k6}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u,u],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[6,13]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,5,12],zero,zero,xmm0[1,8,15],zero,zero
; AVX512DQBW-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm0, %ymm20 {%k2}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm13, %ymm16, %ymm0 {%k3}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[u,u,u,u,u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm0, %ymm21 {%k2}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm3, %ymm25, %ymm0 {%k3}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm26, %ymm1, %ymm23 {%k4}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm26, %ymm1, %ymm22 {%k6}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm7, %ymm8, %ymm2 {%k3}
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm26, %ymm1 {%k3}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm7, %ymm8, %ymm4 {%k6}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm26 = xmm4[u,u,2,9],zero,zero,zero,xmm4[5,12],zero,zero,xmm4[u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u],zero,zero,xmm4[0,7,14],zero,zero,xmm4[3,10,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vporq %xmm26, %xmm4, %xmm4
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm26 = xmm12[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[6,13]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm27 = xmm11[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512DQBW-SLOW-NEXT:    vporq %xmm26, %xmm27, %xmm26
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $1, %xmm26, %ymm0, %ymm26
; AVX512DQBW-SLOW-NEXT:    kmovd {{[-0-9]+}}(%r{{[sb]}}p), %k1 # 4-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm26, %ymm4 {%k1}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm26 = xmm2[u,u,3,10],zero,zero,zero,xmm2[6,13],zero,zero,xmm2[u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u],zero,zero,xmm2[1,8,15],zero,zero,xmm2[4,11,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vporq %xmm26, %xmm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm26 = xmm11[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm27 = xmm12[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm12[0,7,14]
; AVX512DQBW-SLOW-NEXT:    vporq %xmm26, %xmm27, %xmm26
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $1, %xmm26, %ymm0, %ymm26
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm26, %ymm2 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm8, %ymm7 {%k4}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u],zero,zero,xmm8[2,9],zero,zero,zero,xmm8[5,12,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,4,11],zero,zero,xmm7[0,7,14],zero,zero,xmm7[u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm11[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm12[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm12[1,8,15]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm8, %xmm11, %xmm8
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQBW-SLOW-NEXT:    vmovdqu8 %ymm8, %ymm7 {%k1}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm8
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm8[0],ymm0[1,2,3],ymm8[4],ymm0[5,6],ymm8[7,8],ymm0[9,10,11],ymm8[12],ymm0[13,14],ymm8[15]
; AVX512DQBW-SLOW-NEXT:    vextracti32x4 $1, %ymm23, %xmm8
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,xmm8[2,9],zero,zero,zero,xmm8[5,12,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm23[4,11],zero,zero,xmm23[0,7,14],zero,zero,xmm23[u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm8, %xmm11, %xmm8
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm8 {%k5} = ymm0[u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,20,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512DQBW-SLOW-NEXT:    vpshufb %xmm0, %xmm6, %xmm11
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm5[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm11, %zmm4, %zmm4
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %zmm4, %zmm8 {%k5}
; AVX512DQBW-SLOW-NEXT:    vpblendmw %ymm25, %ymm3, %ymm4 {%k4}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm11
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm11[1],ymm4[2,3],ymm11[4],ymm4[5,6,7,8],ymm11[9],ymm4[10,11],ymm11[12],ymm4[13,14,15]
; AVX512DQBW-SLOW-NEXT:    vextracti32x4 $1, %ymm22, %xmm11
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm11 = zero,zero,xmm11[3,10],zero,zero,zero,xmm11[6,13,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm22[5,12],zero,zero,xmm22[1,8,15],zero,zero,xmm22[u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm11 {%k5} = ymm4[u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,21,28,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm5[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm6[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm12[0],xmm4[0],xmm12[1],xmm4[1],xmm12[2],xmm4[2],xmm12[3],xmm4[3]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm2
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %zmm2, %zmm11 {%k5}
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm25, %ymm3 {%k6}
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3,4],ymm2[5],ymm3[6,7,8],ymm2[9],ymm3[10,11,12],ymm2[13],ymm3[14,15]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[6,13],zero,zero,xmm1[2,9],zero,zero,zero,xmm1[u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,xmm1[4,11],zero,zero,xmm1[0,7,14,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 {%k5} = ymm2[u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,22,29,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpshufb %xmm0, %xmm5, %xmm0
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm6[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm7, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k5}
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm14, %ymm15 {%k4}
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm15[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm15[0,1],ymm0[2],ymm15[3,4],ymm0[5],ymm15[6,7,8,9],ymm0[10],ymm15[11,12],ymm0[13],ymm15[14,15]
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm10, %ymm9 {%k6}
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm9[u,u,u,u,2,9],zero,zero,zero,xmm9[5,12],zero,zero,xmm9[u,u,u]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm9, %xmm3
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u],zero,zero,xmm3[0,7,14],zero,zero,xmm3[3,10,u,u,u]
; AVX512DQBW-SLOW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQBW-SLOW-NEXT:    movl $4186112, %eax # imm = 0x3FE000
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k1
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 {%k1} = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,1,8,15,22,29,20,27,18,25,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-SLOW-NEXT:    movw $-512, %ax # imm = 0xFE00
; AVX512DQBW-SLOW-NEXT:    vmovdqu16 %ymm16, %ymm13 {%k7}
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k1
; AVX512DQBW-SLOW-NEXT:    vinserti32x8 $1, %ymm20, %zmm0, %zmm8 {%k1}
; AVX512DQBW-SLOW-NEXT:    vinserti32x8 $1, %ymm21, %zmm0, %zmm11 {%k1}
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm2
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,u,u],zero,zero,zero,xmm2[5,12],zero,zero,xmm2[1,8,15]
; AVX512DQBW-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm13[u,u,u,u,u,u,0,7,14],zero,zero,xmm13[3,10],zero,zero,zero
; AVX512DQBW-SLOW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQBW-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [16,17,18,19,20,21,22,23,24,25,26,43,44,45,46,47]
; AVX512DQBW-SLOW-NEXT:    vpermi2w %zmm2, %zmm0, %zmm3
; AVX512DQBW-SLOW-NEXT:    vinserti32x8 $1, %ymm3, %zmm0, %zmm1 {%k1}
; AVX512DQBW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm24, (%rsi)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm17, (%rdx)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm19, (%r8)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, (%r9)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, (%rdi)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512DQBW-SLOW-NEXT:    vzeroupper
; AVX512DQBW-SLOW-NEXT:    retq
;
; AVX512DQBW-FAST-LABEL: load_i8_stride7_vf64:
; AVX512DQBW-FAST:       # %bb.0:
; AVX512DQBW-FAST-NEXT:    vmovdqa64 320(%rdi), %zmm26
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [24,17,2,19,28,21,6,31,16,9,26,27,20,13,30,23]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm26, %zmm2, %zmm24
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [8,1,18,11,4,5,22,15,0,25,10,3,12,29,14,7]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm18
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [24,17,2,27,20,5,22,31,16,9,26,19,12,29,30,23]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm26, %zmm2, %zmm16
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,18,11,4,21,14,7,8,25,10,3,28,13,6,15]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm25
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,2,11,4,5,14,7,8,9,26,19,12,29,22,15]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm26, %zmm2, %zmm17
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,17,10,3,4,21,14,7,24,9,2,11,28,13,6,31]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,10,3,4,5,14,7,8,25,18,11,12,29,22,15]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm26, %zmm2, %zmm10
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [16,17,10,3,20,13,6,23,24,25,18,27,28,21,30,31]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm1, %zmm2, %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqa (%rdi), %ymm9
; AVX512DQBW-FAST-NEXT:    vmovdqa 32(%rdi), %ymm3
; AVX512DQBW-FAST-NEXT:    movw $-28382, %ax # imm = 0x9122
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm3, %ymm9, %ymm2 {%k1}
; AVX512DQBW-FAST-NEXT:    kmovq %k1, %k2
; AVX512DQBW-FAST-NEXT:    kmovw %k1, {{[-0-9]+}}(%r{{[sb]}}p) # 2-byte Spill
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm5
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[5,12],zero,zero,xmm5[1,8,15,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,7,14],zero,zero,xmm2[3,10],zero,zero,zero,xmm2[u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,u,u,u,u,u,u,6,13,4,11,2,9,16,23,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    movw $992, %ax # imm = 0x3E0
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %ymm4, %ymm2 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqa 128(%rdi), %ymm11
; AVX512DQBW-FAST-NEXT:    vmovdqa 160(%rdi), %ymm8
; AVX512DQBW-FAST-NEXT:    movw $8772, %ax # imm = 0x2244
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm11, %ymm8, %ymm4 {%k1}
; AVX512DQBW-FAST-NEXT:    kmovq %k1, %k3
; AVX512DQBW-FAST-NEXT:    kmovw %k1, {{[-0-9]+}}(%r{{[sb]}}p) # 2-byte Spill
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u],zero,zero,xmm5[3,10],zero,zero,zero,xmm5[6,13,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,5,12],zero,zero,xmm4[1,8,15],zero,zero,xmm4[u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,u,u,1,2,4,6>
; AVX512DQBW-FAST-NEXT:    vmovdqa64 192(%rdi), %ymm19
; AVX512DQBW-FAST-NEXT:    vpermd %ymm19, %ymm5, %ymm5
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,23,26,29]
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm4[0,1,2,3,4,5,6],ymm5[7]
; AVX512DQBW-FAST-NEXT:    vmovdqa 240(%rdi), %xmm4
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm4[5,12,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vmovdqa 224(%rdi), %xmm7
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm7[0,7,14],zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm6, %xmm12, %xmm6
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm5, %zmm5
; AVX512DQBW-FAST-NEXT:    movabsq $137438429184, %rax # imm = 0x1FFFF80000
; AVX512DQBW-FAST-NEXT:    kmovq %rax, %k5
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %zmm5, %zmm2 {%k5}
; AVX512DQBW-FAST-NEXT:    vmovdqa 288(%rdi), %ymm6
; AVX512DQBW-FAST-NEXT:    vmovdqa 256(%rdi), %ymm5
; AVX512DQBW-FAST-NEXT:    movw $9288, %ax # imm = 0x2448
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k6
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm6, %ymm5, %ymm12 {%k6}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm12[u,u,u,u,u,3,10],zero,zero,zero,xmm12[6,13],zero,zero,xmm12[u,u]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm12, %xmm12
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u,u,u,u],zero,zero,xmm12[1,8,15],zero,zero,xmm12[4,11,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm20, %xmm12, %xmm21
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,2,9,16,23,30,21,28,19,26,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    movw $3968, %ax # imm = 0xF80
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k7
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %ymm10, %ymm21 {%k7}
; AVX512DQBW-FAST-NEXT:    vmovdqa 416(%rdi), %ymm12
; AVX512DQBW-FAST-NEXT:    vmovdqa 384(%rdi), %ymm10
; AVX512DQBW-FAST-NEXT:    movw $4644, %ax # imm = 0x1224
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k4
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm12, %ymm10, %ymm20 {%k4}
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm20, %xmm22
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm22 = xmm22[u,u,u,u,u,u,u],zero,zero,zero,xmm22[6,13],zero,zero,xmm22[2,9]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm20[u,u,u,u,u,u,u,1,8,15],zero,zero,xmm20[4,11],zero,zero
; AVX512DQBW-FAST-NEXT:    vporq %xmm22, %xmm20, %xmm20
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm22
; AVX512DQBW-FAST-NEXT:    movl $-8388608, %eax # imm = 0xFF800000
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm3, %ymm9, %ymm20 {%k4}
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm20, %xmm23
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm23 = zero,zero,zero,xmm23[6,13],zero,zero,xmm23[2,9,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm20[1,8,15],zero,zero,xmm20[4,11],zero,zero,xmm20[u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm23, %xmm20, %xmm20
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u,u,u,u,u,u,u,0,7,14,5,12,3,10,17,24,31,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    movl $511, %r10d # imm = 0x1FF
; AVX512DQBW-FAST-NEXT:    kmovd %r10d, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm20, %ymm13 {%k1}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm11, %ymm8, %ymm20 {%k6}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm23 = xmm20[u,u,u,6,13],zero,zero,xmm20[2,9],zero,zero,zero,xmm20[u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm20, %xmm20
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm20[u,u,u],zero,zero,xmm20[4,11],zero,zero,xmm20[0,7,14,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm23, %xmm20, %xmm20
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm14
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm20 = <u,u,u,u,1,3,4,6>
; AVX512DQBW-FAST-NEXT:    vpermd %ymm19, %ymm20, %ymm20
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm15 = ymm20[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,17,20,27,30]
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5,6],ymm15[7]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,zero,xmm4[6,13,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm7[1,8,15],zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm15, %xmm20, %xmm15
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm14, %zmm14
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %zmm14, %zmm13 {%k5}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm3, %ymm9, %ymm14 {%k3}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[2,9],zero,zero,zero,xmm14[5,12],zero,zero,xmm14[u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,xmm14[0,7,14],zero,zero,xmm14[3,10,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512DQBW-FAST-NEXT:    movl $261632, %r10d # imm = 0x3FE00
; AVX512DQBW-FAST-NEXT:    kmovd %r10d, %k5
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm14 {%k5} = ymm25[u,u,u,u,u,u,u,u,u,1,8,15,6,13,4,11,18,25,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm8, %ymm11, %ymm15 {%k2}
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm15, %xmm20
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = xmm20[u,u],zero,zero,zero,xmm20[5,12],zero,zero,xmm20[1,8,15,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[u,u,0,7,14],zero,zero,xmm15[3,10],zero,zero,zero,xmm15[u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm20, %xmm15, %xmm15
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm20 = <u,u,u,u,1,3,5,6>
; AVX512DQBW-FAST-NEXT:    vpermd %ymm19, %ymm20, %ymm19
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm19[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,21,24,31]
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3,4,5,6],ymm0[7]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm7[2,9],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm19 = zero,zero,xmm4[0,7,14,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm15, %xmm19, %xmm15
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm15, %zmm0, %zmm15
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %zmm14, %zmm15 {%k1}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm3, %ymm9, %ymm0 {%k6}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm0[3,10],zero,zero,zero,xmm0[6,13],zero,zero,xmm0[u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[1,8,15],zero,zero,xmm0[4,11,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm0, %xmm14, %xmm0
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm0 {%k5} = ymm18[u,u,u,u,u,u,u,u,u,2,9,0,7,14,5,12,19,26,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm8, %ymm11, %ymm14 {%k4}
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm14, %xmm18
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm18 = xmm18[u,u],zero,zero,zero,xmm18[6,13],zero,zero,xmm18[2,9,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,1,8,15],zero,zero,xmm14[4,11],zero,zero,xmm14[u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm18, %xmm14, %xmm14
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512DQBW-FAST-NEXT:    vmovdqa64 208(%rdi), %xmm19
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm18 = xmm19[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm19[5,12]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 192(%rdi), %xmm20
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm23 = xmm20[u,u,u,u,u,u,u,u,u,u,u,0,7,14],zero,zero
; AVX512DQBW-FAST-NEXT:    vporq %xmm18, %xmm23, %xmm18
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $1, %xmm18, %ymm0, %ymm18
; AVX512DQBW-FAST-NEXT:    movl $-134217728, %edi # imm = 0xF8000000
; AVX512DQBW-FAST-NEXT:    kmovd %edi, %k2
; AVX512DQBW-FAST-NEXT:    kmovd %k2, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm18, %ymm14 {%k2}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm18 = xmm7[3,10],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm23 = zero,zero,xmm4[1,8,15,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm18, %xmm23, %xmm18
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm18, %zmm14, %zmm18
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %zmm0, %zmm18 {%k1}
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k3
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm22, %ymm21 {%k3}
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm21, %zmm0, %zmm0
; AVX512DQBW-FAST-NEXT:    movabsq $-137438953472, %rax # imm = 0xFFFFFFE000000000
; AVX512DQBW-FAST-NEXT:    kmovq %rax, %k2
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %zmm0, %zmm2 {%k2}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm5, %ymm6, %ymm0 {%k4}
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm14
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,u],zero,zero,xmm14[2,9],zero,zero,zero,xmm14[5,12,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,4,11],zero,zero,xmm0[0,7,14],zero,zero,xmm0[u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm0, %xmm14, %xmm0
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm14 = ymm17[u,u,u,u,u,u,u,u,u,u,u,u,u,u,3,10,17,24,31,22,29,20,27,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %ymm14, %ymm0 {%k7}
; AVX512DQBW-FAST-NEXT:    kmovw {{[-0-9]+}}(%r{{[sb]}}p), %k1 # 2-byte Reload
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm12, %ymm10, %ymm14 {%k1}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm14[u,u,u,u,u,u,u,2,9],zero,zero,zero,xmm14[5,12],zero,zero
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,u,u,u],zero,zero,xmm14[0,7,14],zero,zero,xmm14[3,10]
; AVX512DQBW-FAST-NEXT:    vporq %xmm17, %xmm14, %xmm14
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm14, %ymm0 {%k3}
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %zmm0, %zmm13 {%k2}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm5, %ymm6, %ymm0 {%k1}
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm14
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,u],zero,zero,xmm14[3,10],zero,zero,zero,xmm14[6,13,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,5,12],zero,zero,xmm0[1,8,15],zero,zero,xmm0[u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm0, %xmm14, %xmm0
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm14 = ymm16[u,u,u,u,u,u,u,u,u,u,u,u,u,u,4,11,18,25,16,23,30,21,28,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %ymm14, %ymm0 {%k7}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm12, %ymm10, %ymm14 {%k6}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm16 = xmm14[u,u,u,u,u,u,u,3,10],zero,zero,zero,xmm14[6,13],zero,zero
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,u,u,u],zero,zero,xmm14[1,8,15],zero,zero,xmm14[4,11]
; AVX512DQBW-FAST-NEXT:    vporq %xmm16, %xmm14, %xmm14
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm14, %ymm0 {%k3}
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %zmm0, %zmm15 {%k2}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm5, %ymm6, %ymm0 {%k6}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm0[u,u,u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero,xmm0[u,u]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm0, %xmm14, %xmm0
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm14 = ymm24[u,u,u,u,u,u,u,u,u,u,u,u,u,u,5,12,19,26,17,24,31,22,29,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %ymm14, %ymm0 {%k7}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm10, %ymm12, %ymm14 {%k4}
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm14, %xmm16
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm16 = xmm16[u,u,u,u,u,u,u],zero,zero,xmm16[2,9],zero,zero,zero,xmm16[5,12]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,u,u,u,4,11],zero,zero,xmm14[0,7,14],zero,zero
; AVX512DQBW-FAST-NEXT:    vporq %xmm16, %xmm14, %xmm14
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm14, %ymm0 {%k3}
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %zmm0, %zmm18 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [0,9,2,3,4,13,6,7,24,17,10,11,28,21,14,31]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm26, %zmm0, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = [16,25,18,3,28,21,6,23,24,17,10,27,20,13,30,31]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm26, %zmm14, %zmm16
; AVX512DQBW-FAST-NEXT:    kmovw {{[-0-9]+}}(%r{{[sb]}}p), %k2 # 2-byte Reload
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm6, %ymm5, %ymm14 {%k2}
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm14, %xmm17
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm17[u,u,u,u],zero,zero,zero,xmm17[5,12],zero,zero,xmm17[1,8,15,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,0,7,14],zero,zero,xmm14[3,10],zero,zero,zero,xmm14[u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm17, %xmm14, %xmm14
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm16 = ymm16[u,u,u,u,u,u,u,u,u,u,u,u,u,u,6,13,20,27,18,25,16,23,30,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %ymm16, %ymm14 {%k7}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm6, %ymm5, %ymm16 {%k4}
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm16, %xmm17
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm17[u,u,u,u],zero,zero,zero,xmm17[6,13],zero,zero,xmm17[2,9,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm16 = xmm16[u,u,u,u,1,8,15],zero,zero,xmm16[4,11],zero,zero,xmm16[u,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm17, %xmm16, %xmm17
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm16 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,u,0,7,14,21,28,19,26,17,24,31,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    movl $8176, %eax # imm = 0x1FF0
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm17, %ymm16 {%k1}
; AVX512DQBW-FAST-NEXT:    kmovw {{[-0-9]+}}(%r{{[sb]}}p), %k1 # 2-byte Reload
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm10, %ymm12, %ymm0 {%k1}
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm0, %xmm17
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm17[u,u,u,u,u,u,u],zero,zero,xmm17[3,10],zero,zero,zero,xmm17[6,13]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,5,12],zero,zero,xmm0[1,8,15],zero,zero
; AVX512DQBW-FAST-NEXT:    vporq %xmm17, %xmm0, %xmm0
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm0, %ymm14 {%k3}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm10, %ymm12, %ymm0 {%k6}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm0[u,u,u,u,u,u,u,6,13],zero,zero,xmm0[2,9],zero,zero,zero
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u],zero,zero,xmm0[4,11],zero,zero,xmm0[0,7,14]
; AVX512DQBW-FAST-NEXT:    vporq %xmm17, %xmm0, %xmm0
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm0, %ymm16 {%k3}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm9, %ymm3, %ymm21 {%k4}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm9, %ymm3, %ymm17 {%k1}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm8, %ymm11, %ymm0 {%k6}
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %ymm9, %ymm3 {%k6}
; AVX512DQBW-FAST-NEXT:    vpblendmw %ymm8, %ymm11, %ymm9 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %ymm11, %ymm8 {%k4}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm9[u,u,2,9],zero,zero,zero,xmm9[5,12],zero,zero,xmm9[u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[u,u],zero,zero,xmm9[0,7,14],zero,zero,xmm9[3,10,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm11, %xmm9, %xmm9
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm19[u,u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm19[6,13]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm22 = xmm20[u,u,u,u,u,u,u,u,u,u,u,1,8,15],zero,zero
; AVX512DQBW-FAST-NEXT:    vporq %xmm11, %xmm22, %xmm11
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQBW-FAST-NEXT:    kmovd {{[-0-9]+}}(%r{{[sb]}}p), %k3 # 4-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm11, %ymm9 {%k3}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm0[u,u,3,10],zero,zero,zero,xmm0[6,13],zero,zero,xmm0[u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u],zero,zero,xmm0[1,8,15],zero,zero,xmm0[4,11,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm0, %xmm11, %xmm0
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm20[u,u,u,u,u,u,u,u,u,u,u,2,9],zero,zero,zero
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm22 = xmm19[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm19[0,7,14]
; AVX512DQBW-FAST-NEXT:    vporq %xmm11, %xmm22, %xmm11
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm11, %ymm0 {%k3}
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm8, %xmm11
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm11[u,u],zero,zero,xmm11[2,9],zero,zero,zero,xmm11[5,12,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,4,11],zero,zero,xmm8[0,7,14],zero,zero,xmm8[u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm11, %xmm8, %xmm8
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm11 = xmm20[u,u,u,u,u,u,u,u,u,u,u,3,10],zero,zero,zero
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm19 = xmm19[u,u,u,u,u,u,u,u,u,u,u],zero,zero,xmm19[1,8,15]
; AVX512DQBW-FAST-NEXT:    vporq %xmm11, %xmm19, %xmm11
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQBW-FAST-NEXT:    vmovdqu8 %ymm11, %ymm8 {%k3}
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = [16,9,2,19,20,13,6,23,24,17,26,27,28,21,30,31]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm1, %zmm11, %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm19 = [16,9,2,19,12,5,22,23,24,17,26,27,20,29,30,31]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm1, %zmm19, %zmm19
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm20 = [8,1,2,19,12,5,22,15,0,9,26,11,4,29,14,7]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm1, %zmm20, %zmm1
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm21, %xmm20
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm20 = zero,zero,xmm20[2,9],zero,zero,zero,xmm20[5,12,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm21 = xmm21[4,11],zero,zero,xmm21[0,7,14],zero,zero,xmm21[u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm20, %xmm21, %xmm20
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm20 {%k5} = ymm1[u,u,u,u,u,u,u,u,u,3,10,1,8,15,6,13,20,27,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} xmm1 = <4,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX512DQBW-FAST-NEXT:    vpshufb %xmm1, %xmm7, %xmm21
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm22 = xmm4[2,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm21 = xmm21[0],xmm22[0],xmm21[1],xmm22[1],xmm21[2],xmm22[2],xmm21[3],xmm22[3]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm21, %zmm9, %zmm9
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %zmm9, %zmm20 {%k5}
; AVX512DQBW-FAST-NEXT:    vextracti32x4 $1, %ymm17, %xmm9
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,xmm9[3,10],zero,zero,zero,xmm9[6,13,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm17[5,12],zero,zero,xmm17[1,8,15],zero,zero,xmm17[u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vporq %xmm9, %xmm17, %xmm9
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm9 {%k5} = ymm19[u,u,u,u,u,u,u,u,u,4,11,2,9,0,7,14,21,28,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm17 = xmm4[3,10,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm19 = xmm7[5,12,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm17 = xmm19[0],xmm17[0],xmm19[1],xmm17[1],xmm19[2],xmm17[2],xmm19[3],xmm17[3]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm17, %zmm0, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %zmm0, %zmm9 {%k5}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm3[6,13],zero,zero,xmm3[2,9],zero,zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,xmm3[4,11],zero,zero,xmm3[0,7,14,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm0 {%k5} = ymm11[u,u,u,u,u,u,u,u,u,5,12,3,10,1,8,15,22,29,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[6,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm8, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %zmm1, %zmm0 {%k5}
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %ymm12, %ymm10 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,10,3,4,13,6,7,8,25,18,11,28,21,14,15]
; AVX512DQBW-FAST-NEXT:    vpermw %zmm26, %zmm1, %zmm1
; AVX512DQBW-FAST-NEXT:    movw $-512, %ax # imm = 0xFE00
; AVX512DQBW-FAST-NEXT:    vmovdqu16 %ymm6, %ymm5 {%k1}
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm5[u,u,u,u,2,9],zero,zero,zero,xmm5[5,12],zero,zero,xmm5[u,u,u]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm5, %xmm4
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,u,u],zero,zero,xmm4[0,7,14],zero,zero,xmm4[3,10,u,u,u]
; AVX512DQBW-FAST-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512DQBW-FAST-NEXT:    movl $4186112, %edi # imm = 0x3FE000
; AVX512DQBW-FAST-NEXT:    kmovd %edi, %k1
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} ymm3 {%k1} = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,u,1,8,15,22,29,20,27,18,25,u,u,u,u,u,u,u,u,u,u]
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vinserti32x8 $1, %ymm14, %zmm0, %zmm20 {%k1}
; AVX512DQBW-FAST-NEXT:    vinserti32x8 $1, %ymm16, %zmm0, %zmm9 {%k1}
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm1
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u],zero,zero,zero,xmm1[5,12],zero,zero,xmm1[1,8,15]
; AVX512DQBW-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm10[u,u,u,u,u,u,0,7,14],zero,zero,xmm10[3,10],zero,zero,zero
; AVX512DQBW-FAST-NEXT:    vpor %xmm1, %xmm4, %xmm1
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm3
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [16,17,18,19,20,21,22,23,24,25,26,43,44,45,46,47]
; AVX512DQBW-FAST-NEXT:    vpermi2w %zmm1, %zmm3, %zmm4
; AVX512DQBW-FAST-NEXT:    vinserti32x8 $1, %ymm4, %zmm0, %zmm0 {%k1}
; AVX512DQBW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm13, (%rdx)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm15, (%rcx)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm18, (%r8)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm20, (%r9)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm9, (%rdi)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, (%rax)
; AVX512DQBW-FAST-NEXT:    vzeroupper
; AVX512DQBW-FAST-NEXT:    retq
  %wide.vec = load <448 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <448 x i8> %wide.vec, <448 x i8> poison, <64 x i32> <i32 0, i32 7, i32 14, i32 21, i32 28, i32 35, i32 42, i32 49, i32 56, i32 63, i32 70, i32 77, i32 84, i32 91, i32 98, i32 105, i32 112, i32 119, i32 126, i32 133, i32 140, i32 147, i32 154, i32 161, i32 168, i32 175, i32 182, i32 189, i32 196, i32 203, i32 210, i32 217, i32 224, i32 231, i32 238, i32 245, i32 252, i32 259, i32 266, i32 273, i32 280, i32 287, i32 294, i32 301, i32 308, i32 315, i32 322, i32 329, i32 336, i32 343, i32 350, i32 357, i32 364, i32 371, i32 378, i32 385, i32 392, i32 399, i32 406, i32 413, i32 420, i32 427, i32 434, i32 441>
  %strided.vec1 = shufflevector <448 x i8> %wide.vec, <448 x i8> poison, <64 x i32> <i32 1, i32 8, i32 15, i32 22, i32 29, i32 36, i32 43, i32 50, i32 57, i32 64, i32 71, i32 78, i32 85, i32 92, i32 99, i32 106, i32 113, i32 120, i32 127, i32 134, i32 141, i32 148, i32 155, i32 162, i32 169, i32 176, i32 183, i32 190, i32 197, i32 204, i32 211, i32 218, i32 225, i32 232, i32 239, i32 246, i32 253, i32 260, i32 267, i32 274, i32 281, i32 288, i32 295, i32 302, i32 309, i32 316, i32 323, i32 330, i32 337, i32 344, i32 351, i32 358, i32 365, i32 372, i32 379, i32 386, i32 393, i32 400, i32 407, i32 414, i32 421, i32 428, i32 435, i32 442>
  %strided.vec2 = shufflevector <448 x i8> %wide.vec, <448 x i8> poison, <64 x i32> <i32 2, i32 9, i32 16, i32 23, i32 30, i32 37, i32 44, i32 51, i32 58, i32 65, i32 72, i32 79, i32 86, i32 93, i32 100, i32 107, i32 114, i32 121, i32 128, i32 135, i32 142, i32 149, i32 156, i32 163, i32 170, i32 177, i32 184, i32 191, i32 198, i32 205, i32 212, i32 219, i32 226, i32 233, i32 240, i32 247, i32 254, i32 261, i32 268, i32 275, i32 282, i32 289, i32 296, i32 303, i32 310, i32 317, i32 324, i32 331, i32 338, i32 345, i32 352, i32 359, i32 366, i32 373, i32 380, i32 387, i32 394, i32 401, i32 408, i32 415, i32 422, i32 429, i32 436, i32 443>
  %strided.vec3 = shufflevector <448 x i8> %wide.vec, <448 x i8> poison, <64 x i32> <i32 3, i32 10, i32 17, i32 24, i32 31, i32 38, i32 45, i32 52, i32 59, i32 66, i32 73, i32 80, i32 87, i32 94, i32 101, i32 108, i32 115, i32 122, i32 129, i32 136, i32 143, i32 150, i32 157, i32 164, i32 171, i32 178, i32 185, i32 192, i32 199, i32 206, i32 213, i32 220, i32 227, i32 234, i32 241, i32 248, i32 255, i32 262, i32 269, i32 276, i32 283, i32 290, i32 297, i32 304, i32 311, i32 318, i32 325, i32 332, i32 339, i32 346, i32 353, i32 360, i32 367, i32 374, i32 381, i32 388, i32 395, i32 402, i32 409, i32 416, i32 423, i32 430, i32 437, i32 444>
  %strided.vec4 = shufflevector <448 x i8> %wide.vec, <448 x i8> poison, <64 x i32> <i32 4, i32 11, i32 18, i32 25, i32 32, i32 39, i32 46, i32 53, i32 60, i32 67, i32 74, i32 81, i32 88, i32 95, i32 102, i32 109, i32 116, i32 123, i32 130, i32 137, i32 144, i32 151, i32 158, i32 165, i32 172, i32 179, i32 186, i32 193, i32 200, i32 207, i32 214, i32 221, i32 228, i32 235, i32 242, i32 249, i32 256, i32 263, i32 270, i32 277, i32 284, i32 291, i32 298, i32 305, i32 312, i32 319, i32 326, i32 333, i32 340, i32 347, i32 354, i32 361, i32 368, i32 375, i32 382, i32 389, i32 396, i32 403, i32 410, i32 417, i32 424, i32 431, i32 438, i32 445>
  %strided.vec5 = shufflevector <448 x i8> %wide.vec, <448 x i8> poison, <64 x i32> <i32 5, i32 12, i32 19, i32 26, i32 33, i32 40, i32 47, i32 54, i32 61, i32 68, i32 75, i32 82, i32 89, i32 96, i32 103, i32 110, i32 117, i32 124, i32 131, i32 138, i32 145, i32 152, i32 159, i32 166, i32 173, i32 180, i32 187, i32 194, i32 201, i32 208, i32 215, i32 222, i32 229, i32 236, i32 243, i32 250, i32 257, i32 264, i32 271, i32 278, i32 285, i32 292, i32 299, i32 306, i32 313, i32 320, i32 327, i32 334, i32 341, i32 348, i32 355, i32 362, i32 369, i32 376, i32 383, i32 390, i32 397, i32 404, i32 411, i32 418, i32 425, i32 432, i32 439, i32 446>
  %strided.vec6 = shufflevector <448 x i8> %wide.vec, <448 x i8> poison, <64 x i32> <i32 6, i32 13, i32 20, i32 27, i32 34, i32 41, i32 48, i32 55, i32 62, i32 69, i32 76, i32 83, i32 90, i32 97, i32 104, i32 111, i32 118, i32 125, i32 132, i32 139, i32 146, i32 153, i32 160, i32 167, i32 174, i32 181, i32 188, i32 195, i32 202, i32 209, i32 216, i32 223, i32 230, i32 237, i32 244, i32 251, i32 258, i32 265, i32 272, i32 279, i32 286, i32 293, i32 300, i32 307, i32 314, i32 321, i32 328, i32 335, i32 342, i32 349, i32 356, i32 363, i32 370, i32 377, i32 384, i32 391, i32 398, i32 405, i32 412, i32 419, i32 426, i32 433, i32 440, i32 447>
  store <64 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <64 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <64 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <64 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <64 x i8> %strided.vec4, ptr %out.vec4, align 64
  store <64 x i8> %strided.vec5, ptr %out.vec5, align 64
  store <64 x i8> %strided.vec6, ptr %out.vec6, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX1: {{.*}}
; AVX2: {{.*}}
; AVX512: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
