; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=aarch64--linux-gnu -mattr=+sve < %s | FileCheck %s

; This regression test is verifying that a GEP instruction performed on a
; scalable vector does not produce a 'assumption that TypeSize is not scalable'
; warning when performing cost analysis.

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define ptr @gep_scalable_vector(ptr %ptr) {
; CHECK-LABEL: 'gep_scalable_vector'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %retval = getelementptr <vscale x 16 x i8>, ptr %ptr, i32 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret ptr %retval
;
  %retval = getelementptr <vscale x 16 x i8>, ptr %ptr, i32 2
  ret ptr %retval
}

define ptr @sext_gep(ptr %p, i32 %a) {
; CHECK-LABEL: 'sext_gep'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %b = sext i32 %a to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r = getelementptr <vscale x 8 x half>, ptr %p, i64 %b
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret ptr %r
;
  %b = sext i32 %a to i64
  %r = getelementptr <vscale x 8 x half>, ptr %p, i64 %b
  ret ptr %r
}
