; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-unknown-linux-gnu | FileCheck %s --check-prefix=I386
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu | FileCheck %s --check-prefix=X86-64

@result = dso_local global i32 0, align 4

define dso_local i32 @skip(i32 returned %x) local_unnamed_addr #0 "zero-call-used-regs"="skip" {
; I386-LABEL: skip:
; I386:       # %bb.0: # %entry
; I386-NEXT:    movl {{[0-9]+}}(%esp), %eax
; I386-NEXT:    retl
;
; X86-64-LABEL: skip:
; X86-64:       # %bb.0: # %entry
; X86-64-NEXT:    movl %edi, %eax
; X86-64-NEXT:    retq

entry:
  ret i32 %x
}

define dso_local i32 @used_gpr_arg(i32 returned %x) local_unnamed_addr #0 "zero-call-used-regs"="used-gpr-arg" {
; I386-LABEL: used_gpr_arg:
; I386:       # %bb.0: # %entry
; I386-NEXT:    movl {{[0-9]+}}(%esp), %eax
; I386-NEXT:    retl
;
; X86-64-LABEL: used_gpr_arg:
; X86-64:       # %bb.0: # %entry
; X86-64-NEXT:    movl %edi, %eax
; X86-64-NEXT:    xorl %edi, %edi
; X86-64-NEXT:    retq

entry:
  ret i32 %x
}

define dso_local i32 @used_gpr(i32 returned %x) local_unnamed_addr #0 "zero-call-used-regs"="used-gpr" {
; I386-LABEL: used_gpr:
; I386:       # %bb.0: # %entry
; I386-NEXT:    movl {{[0-9]+}}(%esp), %eax
; I386-NEXT:    retl
;
; X86-64-LABEL: used_gpr:
; X86-64:       # %bb.0: # %entry
; X86-64-NEXT:    movl %edi, %eax
; X86-64-NEXT:    xorl %edi, %edi
; X86-64-NEXT:    retq

entry:
  ret i32 %x
}

define dso_local i32 @used_arg(i32 returned %x) local_unnamed_addr #0 "zero-call-used-regs"="used-arg" {
; I386-LABEL: used_arg:
; I386:       # %bb.0: # %entry
; I386-NEXT:    movl {{[0-9]+}}(%esp), %eax
; I386-NEXT:    retl
;
; X86-64-LABEL: used_arg:
; X86-64:       # %bb.0: # %entry
; X86-64-NEXT:    movl %edi, %eax
; X86-64-NEXT:    xorl %edi, %edi
; X86-64-NEXT:    retq

entry:
  ret i32 %x
}

define dso_local i32 @used(i32 returned %x) local_unnamed_addr #0 "zero-call-used-regs"="used" {
; I386-LABEL: used:
; I386:       # %bb.0: # %entry
; I386-NEXT:    movl {{[0-9]+}}(%esp), %eax
; I386-NEXT:    retl
;
; X86-64-LABEL: used:
; X86-64:       # %bb.0: # %entry
; X86-64-NEXT:    movl %edi, %eax
; X86-64-NEXT:    xorl %edi, %edi
; X86-64-NEXT:    retq

entry:
  ret i32 %x
}

define dso_local i32 @all_gpr_arg(i32 returned %x) local_unnamed_addr #0 "zero-call-used-regs"="all-gpr-arg" {
; I386-LABEL: all_gpr_arg:
; I386:       # %bb.0: # %entry
; I386-NEXT:    movl {{[0-9]+}}(%esp), %eax
; I386-NEXT:    xorl %ecx, %ecx
; I386-NEXT:    xorl %edx, %edx
; I386-NEXT:    retl
;
; X86-64-LABEL: all_gpr_arg:
; X86-64:       # %bb.0: # %entry
; X86-64-NEXT:    movl %edi, %eax
; X86-64-NEXT:    xorl %ecx, %ecx
; X86-64-NEXT:    xorl %edi, %edi
; X86-64-NEXT:    xorl %edx, %edx
; X86-64-NEXT:    xorl %esi, %esi
; X86-64-NEXT:    xorl %r8d, %r8d
; X86-64-NEXT:    xorl %r9d, %r9d
; X86-64-NEXT:    retq

entry:
  ret i32 %x
}

define dso_local i32 @all_gpr(i32 returned %x) local_unnamed_addr #0 "zero-call-used-regs"="all-gpr" {
; I386-LABEL: all_gpr:
; I386:       # %bb.0: # %entry
; I386-NEXT:    movl {{[0-9]+}}(%esp), %eax
; I386-NEXT:    xorl %ecx, %ecx
; I386-NEXT:    xorl %edx, %edx
; I386-NEXT:    retl
;
; X86-64-LABEL: all_gpr:
; X86-64:       # %bb.0: # %entry
; X86-64-NEXT:    movl %edi, %eax
; X86-64-NEXT:    xorl %ecx, %ecx
; X86-64-NEXT:    xorl %edi, %edi
; X86-64-NEXT:    xorl %edx, %edx
; X86-64-NEXT:    xorl %esi, %esi
; X86-64-NEXT:    xorl %r8d, %r8d
; X86-64-NEXT:    xorl %r9d, %r9d
; X86-64-NEXT:    xorl %r10d, %r10d
; X86-64-NEXT:    xorl %r11d, %r11d
; X86-64-NEXT:    retq

entry:
  ret i32 %x
}

define dso_local i32 @all_arg(i32 returned %x) local_unnamed_addr #0 "zero-call-used-regs"="all-arg" {
; I386-LABEL: all_arg:
; I386:       # %bb.0: # %entry
; I386-NEXT:    movl {{[0-9]+}}(%esp), %eax
; I386-NEXT:    xorl %ecx, %ecx
; I386-NEXT:    xorl %edx, %edx
; I386-NEXT:    retl
;
; X86-64-LABEL: all_arg:
; X86-64:       # %bb.0: # %entry
; X86-64-NEXT:    movl %edi, %eax
; X86-64-NEXT:    xorl %ecx, %ecx
; X86-64-NEXT:    xorl %edi, %edi
; X86-64-NEXT:    xorl %edx, %edx
; X86-64-NEXT:    xorl %esi, %esi
; X86-64-NEXT:    xorl %r8d, %r8d
; X86-64-NEXT:    xorl %r9d, %r9d
; X86-64-NEXT:    xorps %xmm0, %xmm0
; X86-64-NEXT:    xorps %xmm1, %xmm1
; X86-64-NEXT:    xorps %xmm2, %xmm2
; X86-64-NEXT:    xorps %xmm3, %xmm3
; X86-64-NEXT:    xorps %xmm4, %xmm4
; X86-64-NEXT:    xorps %xmm5, %xmm5
; X86-64-NEXT:    xorps %xmm6, %xmm6
; X86-64-NEXT:    xorps %xmm7, %xmm7
; X86-64-NEXT:    retq

entry:
  ret i32 %x
}

define dso_local i32 @all(i32 returned %x) local_unnamed_addr #0 "zero-call-used-regs"="all" {
; I386-LABEL: all:
; I386:       # %bb.0: # %entry
; I386-NEXT:    movl {{[0-9]+}}(%esp), %eax
; I386-NEXT:    fldz
; I386-NEXT:    fldz
; I386-NEXT:    fldz
; I386-NEXT:    fldz
; I386-NEXT:    fldz
; I386-NEXT:    fldz
; I386-NEXT:    fldz
; I386-NEXT:    fstp %st(0)
; I386-NEXT:    fstp %st(0)
; I386-NEXT:    fstp %st(0)
; I386-NEXT:    fstp %st(0)
; I386-NEXT:    fstp %st(0)
; I386-NEXT:    fstp %st(0)
; I386-NEXT:    fstp %st(0)
; I386-NEXT:    xorl %ecx, %ecx
; I386-NEXT:    xorl %edx, %edx
; I386-NEXT:    xorps %xmm0, %xmm0
; I386-NEXT:    xorps %xmm1, %xmm1
; I386-NEXT:    xorps %xmm2, %xmm2
; I386-NEXT:    xorps %xmm3, %xmm3
; I386-NEXT:    xorps %xmm4, %xmm4
; I386-NEXT:    xorps %xmm5, %xmm5
; I386-NEXT:    xorps %xmm6, %xmm6
; I386-NEXT:    xorps %xmm7, %xmm7
; I386-NEXT:    retl
;
; X86-64-LABEL: all:
; X86-64:       # %bb.0: # %entry
; X86-64-NEXT:    movl %edi, %eax
; X86-64-NEXT:    fldz
; X86-64-NEXT:    fldz
; X86-64-NEXT:    fldz
; X86-64-NEXT:    fldz
; X86-64-NEXT:    fldz
; X86-64-NEXT:    fldz
; X86-64-NEXT:    fldz
; X86-64-NEXT:    fldz
; X86-64-NEXT:    fstp %st(0)
; X86-64-NEXT:    fstp %st(0)
; X86-64-NEXT:    fstp %st(0)
; X86-64-NEXT:    fstp %st(0)
; X86-64-NEXT:    fstp %st(0)
; X86-64-NEXT:    fstp %st(0)
; X86-64-NEXT:    fstp %st(0)
; X86-64-NEXT:    fstp %st(0)
; X86-64-NEXT:    xorl %ecx, %ecx
; X86-64-NEXT:    xorl %edi, %edi
; X86-64-NEXT:    xorl %edx, %edx
; X86-64-NEXT:    xorl %esi, %esi
; X86-64-NEXT:    xorl %r8d, %r8d
; X86-64-NEXT:    xorl %r9d, %r9d
; X86-64-NEXT:    xorl %r10d, %r10d
; X86-64-NEXT:    xorl %r11d, %r11d
; X86-64-NEXT:    xorps %xmm0, %xmm0
; X86-64-NEXT:    xorps %xmm1, %xmm1
; X86-64-NEXT:    xorps %xmm2, %xmm2
; X86-64-NEXT:    xorps %xmm3, %xmm3
; X86-64-NEXT:    xorps %xmm4, %xmm4
; X86-64-NEXT:    xorps %xmm5, %xmm5
; X86-64-NEXT:    xorps %xmm6, %xmm6
; X86-64-NEXT:    xorps %xmm7, %xmm7
; X86-64-NEXT:    xorps %xmm8, %xmm8
; X86-64-NEXT:    xorps %xmm9, %xmm9
; X86-64-NEXT:    xorps %xmm10, %xmm10
; X86-64-NEXT:    xorps %xmm11, %xmm11
; X86-64-NEXT:    xorps %xmm12, %xmm12
; X86-64-NEXT:    xorps %xmm13, %xmm13
; X86-64-NEXT:    xorps %xmm14, %xmm14
; X86-64-NEXT:    xorps %xmm15, %xmm15
; X86-64-NEXT:    retq

entry:
  ret i32 %x
}

; Don't emit zeroing registers in "main" function.
define dso_local i32 @main() local_unnamed_addr #1 {
; I386-LABEL: main:
; I386:       # %bb.0: # %entry
; I386-NEXT:    xorl %eax, %eax
; I386-NEXT:    retl
;
; X86-64-LABEL: main:
; X86-64:       # %bb.0: # %entry
; X86-64-NEXT:    xorl %eax, %eax
; X86-64-NEXT:    retq

entry:
  ret i32 0
}

attributes #0 = { mustprogress nofree norecurse nosync nounwind readnone uwtable willreturn "frame-pointer"="none" "min-legal-vector-width"="0" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-cpu"="x86-64" "target-features"="+cx8,+fxsr,+mmx,+sse,+sse2,+x87" "tune-cpu"="generic" }
attributes #1 = { nofree norecurse nounwind uwtable "frame-pointer"="none" "min-legal-vector-width"="0" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-cpu"="x86-64" "target-features"="+cx8,+fxsr,+mmx,+sse,+sse2,+x87" "tune-cpu"="generic" }
