; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-- -amdgpu-codegenprepare -amdgpu-codegenprepare-force-break-large-phis -verify %s | FileCheck  %s --check-prefixes=OPT
; RUN: opt -S -mtriple=amdgcn-- -amdgpu-codegenprepare --global-isel %s | FileCheck  %s --check-prefixes=NOOPT
; RUN: opt -S -mtriple=amdgcn-- -amdgpu-codegenprepare -amdgpu-codegenprepare-break-large-phis=0 %s | FileCheck  %s --check-prefixes=NOOPT

define amdgpu_kernel void @phi_v5f64(<5 x double> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v5f64(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <5 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = extractelement <5 x double> [[X]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = extractelement <5 x double> [[X]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = extractelement <5 x double> [[X]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = extractelement <5 x double> [[X]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE8:%.*]] = extractelement <5 x double> [[X]], i64 4
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <5 x double> [[IN]], double 9.140000e+00, i32 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = extractelement <5 x double> [[Y]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = extractelement <5 x double> [[Y]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = extractelement <5 x double> [[Y]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = extractelement <5 x double> [[Y]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = extractelement <5 x double> [[Y]], i64 4
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE2]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE8]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE9]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = insertelement <5 x double> poison, double [[TMP0]], i64 0
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE0]], double [[TMP1]], i64 1
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE1]], double [[TMP2]], i64 2
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE2]], double [[TMP3]], i64 3
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE3]], double [[TMP4]], i64 4
; OPT-NEXT:    store <5 x double> [[LARGEPHI_INSERTSLICE4]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v5f64(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <5 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <5 x double> [[IN]], double 9.140000e+00, i32 2
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <5 x double> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <5 x double> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <5 x double> %in, double 3.14, i32 3
  br label %finally
else:
  %y = insertelement <5 x double> %in, double 9.14, i32 2
  br label %finally
finally:
  %val = phi <5 x double> [%x, %then], [%y, %else]
  store <5 x double> %val, ptr %out, align 1
  ret void
}

define amdgpu_kernel void @phi_v7f64(<7 x double> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v7f64(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <7 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = extractelement <7 x double> [[X]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = extractelement <7 x double> [[X]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = extractelement <7 x double> [[X]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = extractelement <7 x double> [[X]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE8:%.*]] = extractelement <7 x double> [[X]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = extractelement <7 x double> [[X]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE12:%.*]] = extractelement <7 x double> [[X]], i64 6
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <7 x double> [[IN]], double 9.140000e+00, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = extractelement <7 x double> [[Y]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = extractelement <7 x double> [[Y]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = extractelement <7 x double> [[Y]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = extractelement <7 x double> [[Y]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = extractelement <7 x double> [[Y]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE11:%.*]] = extractelement <7 x double> [[Y]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE13:%.*]] = extractelement <7 x double> [[Y]], i64 6
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE2]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE8]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE9]], [[ELSE]] ]
; OPT-NEXT:    [[TMP5:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE10]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE11]], [[ELSE]] ]
; OPT-NEXT:    [[TMP6:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE12]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = insertelement <7 x double> poison, double [[TMP0]], i64 0
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = insertelement <7 x double> [[LARGEPHI_INSERTSLICE0]], double [[TMP1]], i64 1
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = insertelement <7 x double> [[LARGEPHI_INSERTSLICE1]], double [[TMP2]], i64 2
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <7 x double> [[LARGEPHI_INSERTSLICE2]], double [[TMP3]], i64 3
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = insertelement <7 x double> [[LARGEPHI_INSERTSLICE3]], double [[TMP4]], i64 4
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE5:%.*]] = insertelement <7 x double> [[LARGEPHI_INSERTSLICE4]], double [[TMP5]], i64 5
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE6:%.*]] = insertelement <7 x double> [[LARGEPHI_INSERTSLICE5]], double [[TMP6]], i64 6
; OPT-NEXT:    store <7 x double> [[LARGEPHI_INSERTSLICE6]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v7f64(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <7 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <7 x double> [[IN]], double 9.140000e+00, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <7 x double> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <7 x double> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <7 x double> %in, double 3.14, i32 3
  br label %finally
else:
  %y = insertelement <7 x double> %in, double 9.14, i32 6
  br label %finally
finally:
  %val = phi <7 x double> [%x, %then], [%y, %else]
  store <7 x double> %val, ptr %out, align 1
  ret void
}

define amdgpu_kernel void @phi_v11f64(<11 x double> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v11f64(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <11 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = extractelement <11 x double> [[X]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = extractelement <11 x double> [[X]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = extractelement <11 x double> [[X]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = extractelement <11 x double> [[X]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE8:%.*]] = extractelement <11 x double> [[X]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = extractelement <11 x double> [[X]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE12:%.*]] = extractelement <11 x double> [[X]], i64 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE14:%.*]] = extractelement <11 x double> [[X]], i64 7
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE16:%.*]] = extractelement <11 x double> [[X]], i64 8
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE18:%.*]] = extractelement <11 x double> [[X]], i64 9
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE20:%.*]] = extractelement <11 x double> [[X]], i64 10
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <11 x double> [[IN]], double 9.140000e+00, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = extractelement <11 x double> [[Y]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = extractelement <11 x double> [[Y]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = extractelement <11 x double> [[Y]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = extractelement <11 x double> [[Y]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = extractelement <11 x double> [[Y]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE11:%.*]] = extractelement <11 x double> [[Y]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE13:%.*]] = extractelement <11 x double> [[Y]], i64 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE15:%.*]] = extractelement <11 x double> [[Y]], i64 7
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE17:%.*]] = extractelement <11 x double> [[Y]], i64 8
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE19:%.*]] = extractelement <11 x double> [[Y]], i64 9
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE21:%.*]] = extractelement <11 x double> [[Y]], i64 10
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE2]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE8]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE9]], [[ELSE]] ]
; OPT-NEXT:    [[TMP5:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE10]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE11]], [[ELSE]] ]
; OPT-NEXT:    [[TMP6:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE12]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ]
; OPT-NEXT:    [[TMP7:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE14]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE15]], [[ELSE]] ]
; OPT-NEXT:    [[TMP8:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE16]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE17]], [[ELSE]] ]
; OPT-NEXT:    [[TMP9:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE18]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE19]], [[ELSE]] ]
; OPT-NEXT:    [[TMP10:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE20]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE21]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = insertelement <11 x double> poison, double [[TMP0]], i64 0
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE0]], double [[TMP1]], i64 1
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE1]], double [[TMP2]], i64 2
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE2]], double [[TMP3]], i64 3
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE3]], double [[TMP4]], i64 4
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE5:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE4]], double [[TMP5]], i64 5
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE6:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE5]], double [[TMP6]], i64 6
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE7:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE6]], double [[TMP7]], i64 7
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE8:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE7]], double [[TMP8]], i64 8
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE9:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE8]], double [[TMP9]], i64 9
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE10:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE9]], double [[TMP10]], i64 10
; OPT-NEXT:    store <11 x double> [[LARGEPHI_INSERTSLICE10]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v11f64(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <11 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <11 x double> [[IN]], double 9.140000e+00, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <11 x double> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <11 x double> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <11 x double> %in, double 3.14, i32 3
  br label %finally
else:
  %y = insertelement <11 x double> %in, double 9.14, i32 6
  br label %finally
finally:
  %val = phi <11 x double> [%x, %then], [%y, %else]
  store <11 x double> %val, ptr %out, align 1
  ret void
}

define amdgpu_kernel void @phi_v11f64_cst(<11 x double> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v11f64_cst(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[FINALLY:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <11 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = extractelement <11 x double> [[X]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = extractelement <11 x double> [[X]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = extractelement <11 x double> [[X]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = extractelement <11 x double> [[X]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE8:%.*]] = extractelement <11 x double> [[X]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = extractelement <11 x double> [[X]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE12:%.*]] = extractelement <11 x double> [[X]], i64 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE14:%.*]] = extractelement <11 x double> [[X]], i64 7
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE16:%.*]] = extractelement <11 x double> [[X]], i64 8
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE18:%.*]] = extractelement <11 x double> [[X]], i64 9
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE20:%.*]] = extractelement <11 x double> [[X]], i64 10
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ 0.000000e+00, [[ENTRY:%.*]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE2]], [[THEN]] ], [ 0.000000e+00, [[ENTRY]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN]] ], [ 0.000000e+00, [[ENTRY]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ 0.000000e+00, [[ENTRY]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE8]], [[THEN]] ], [ 0.000000e+00, [[ENTRY]] ]
; OPT-NEXT:    [[TMP5:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE10]], [[THEN]] ], [ 0.000000e+00, [[ENTRY]] ]
; OPT-NEXT:    [[TMP6:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE12]], [[THEN]] ], [ 0.000000e+00, [[ENTRY]] ]
; OPT-NEXT:    [[TMP7:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE14]], [[THEN]] ], [ 0.000000e+00, [[ENTRY]] ]
; OPT-NEXT:    [[TMP8:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE16]], [[THEN]] ], [ 0.000000e+00, [[ENTRY]] ]
; OPT-NEXT:    [[TMP9:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE18]], [[THEN]] ], [ 0.000000e+00, [[ENTRY]] ]
; OPT-NEXT:    [[TMP10:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE20]], [[THEN]] ], [ 0.000000e+00, [[ENTRY]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = insertelement <11 x double> poison, double [[TMP0]], i64 0
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE0]], double [[TMP1]], i64 1
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE1]], double [[TMP2]], i64 2
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE2]], double [[TMP3]], i64 3
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE3]], double [[TMP4]], i64 4
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE5:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE4]], double [[TMP5]], i64 5
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE6:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE5]], double [[TMP6]], i64 6
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE7:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE6]], double [[TMP7]], i64 7
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE8:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE7]], double [[TMP8]], i64 8
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE9:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE8]], double [[TMP9]], i64 9
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE10:%.*]] = insertelement <11 x double> [[LARGEPHI_INSERTSLICE9]], double [[TMP10]], i64 10
; OPT-NEXT:    store <11 x double> [[LARGEPHI_INSERTSLICE10]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v11f64_cst(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[FINALLY:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <11 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <11 x double> [ [[X]], [[THEN]] ], [ zeroinitializer, [[ENTRY:%.*]] ]
; NOOPT-NEXT:    store <11 x double> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %finally
then:
  %x = insertelement <11 x double> %in, double 3.14, i32 3
  br label %finally
finally:
  %val = phi <11 x double> [%x, %then], [zeroinitializer, %entry]
  store <11 x double> %val, ptr %out, align 1
  ret void
}

define amdgpu_kernel void @phi_v15i64(<15 x i64> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v15i64(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <15 x i64> [[IN:%.*]], i64 42, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = extractelement <15 x i64> [[X]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = extractelement <15 x i64> [[X]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = extractelement <15 x i64> [[X]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = extractelement <15 x i64> [[X]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE8:%.*]] = extractelement <15 x i64> [[X]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = extractelement <15 x i64> [[X]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE12:%.*]] = extractelement <15 x i64> [[X]], i64 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE14:%.*]] = extractelement <15 x i64> [[X]], i64 7
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE16:%.*]] = extractelement <15 x i64> [[X]], i64 8
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE18:%.*]] = extractelement <15 x i64> [[X]], i64 9
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE20:%.*]] = extractelement <15 x i64> [[X]], i64 10
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE22:%.*]] = extractelement <15 x i64> [[X]], i64 11
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE24:%.*]] = extractelement <15 x i64> [[X]], i64 12
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE26:%.*]] = extractelement <15 x i64> [[X]], i64 13
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE28:%.*]] = extractelement <15 x i64> [[X]], i64 14
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <15 x i64> [[IN]], i64 64, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = extractelement <15 x i64> [[Y]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = extractelement <15 x i64> [[Y]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = extractelement <15 x i64> [[Y]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = extractelement <15 x i64> [[Y]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = extractelement <15 x i64> [[Y]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE11:%.*]] = extractelement <15 x i64> [[Y]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE13:%.*]] = extractelement <15 x i64> [[Y]], i64 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE15:%.*]] = extractelement <15 x i64> [[Y]], i64 7
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE17:%.*]] = extractelement <15 x i64> [[Y]], i64 8
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE19:%.*]] = extractelement <15 x i64> [[Y]], i64 9
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE21:%.*]] = extractelement <15 x i64> [[Y]], i64 10
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE23:%.*]] = extractelement <15 x i64> [[Y]], i64 11
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE25:%.*]] = extractelement <15 x i64> [[Y]], i64 12
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE27:%.*]] = extractelement <15 x i64> [[Y]], i64 13
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE29:%.*]] = extractelement <15 x i64> [[Y]], i64 14
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE2]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE8]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE9]], [[ELSE]] ]
; OPT-NEXT:    [[TMP5:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE10]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE11]], [[ELSE]] ]
; OPT-NEXT:    [[TMP6:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE12]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ]
; OPT-NEXT:    [[TMP7:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE14]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE15]], [[ELSE]] ]
; OPT-NEXT:    [[TMP8:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE16]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE17]], [[ELSE]] ]
; OPT-NEXT:    [[TMP9:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE18]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE19]], [[ELSE]] ]
; OPT-NEXT:    [[TMP10:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE20]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE21]], [[ELSE]] ]
; OPT-NEXT:    [[TMP11:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE22]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE23]], [[ELSE]] ]
; OPT-NEXT:    [[TMP12:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE24]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE25]], [[ELSE]] ]
; OPT-NEXT:    [[TMP13:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE26]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE27]], [[ELSE]] ]
; OPT-NEXT:    [[TMP14:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE28]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE29]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = insertelement <15 x i64> poison, i64 [[TMP0]], i64 0
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE0]], i64 [[TMP1]], i64 1
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE1]], i64 [[TMP2]], i64 2
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE2]], i64 [[TMP3]], i64 3
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE3]], i64 [[TMP4]], i64 4
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE5:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE4]], i64 [[TMP5]], i64 5
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE6:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE5]], i64 [[TMP6]], i64 6
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE7:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE6]], i64 [[TMP7]], i64 7
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE8:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE7]], i64 [[TMP8]], i64 8
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE9:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE8]], i64 [[TMP9]], i64 9
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE10:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE9]], i64 [[TMP10]], i64 10
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE11:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE10]], i64 [[TMP11]], i64 11
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE12:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE11]], i64 [[TMP12]], i64 12
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE13:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE12]], i64 [[TMP13]], i64 13
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE14:%.*]] = insertelement <15 x i64> [[LARGEPHI_INSERTSLICE13]], i64 [[TMP14]], i64 14
; OPT-NEXT:    store <15 x i64> [[LARGEPHI_INSERTSLICE14]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v15i64(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <15 x i64> [[IN:%.*]], i64 42, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <15 x i64> [[IN]], i64 64, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <15 x i64> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <15 x i64> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <15 x i64> %in, i64 42, i32 3
  br label %finally
else:
  %y = insertelement <15 x i64> %in, i64 64, i32 6
  br label %finally
finally:
  %val = phi <15 x i64> [%x, %then], [%y, %else]
  store <15 x i64> %val, ptr %out, align 1
  ret void
}

define amdgpu_kernel void @phi_v27i16(<27 x i16> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v27i16(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <27 x i16> [[IN:%.*]], i16 42, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 0, i32 1>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 4, i32 5>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 6, i32 7>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE8:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 8, i32 9>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 10, i32 11>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE12:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 12, i32 13>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE14:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 14, i32 15>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE16:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 16, i32 17>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE18:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 18, i32 19>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE20:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 20, i32 21>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE22:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 22, i32 23>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE24:%.*]] = shufflevector <27 x i16> [[X]], <27 x i16> poison, <2 x i32> <i32 24, i32 25>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE26:%.*]] = extractelement <27 x i16> [[X]], i64 26
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <27 x i16> [[IN]], i16 64, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 0, i32 1>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 4, i32 5>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 6, i32 7>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 8, i32 9>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE11:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 10, i32 11>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE13:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 12, i32 13>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE15:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 14, i32 15>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE17:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 16, i32 17>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE19:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 18, i32 19>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE21:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 20, i32 21>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE23:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 22, i32 23>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE25:%.*]] = shufflevector <27 x i16> [[Y]], <27 x i16> poison, <2 x i32> <i32 24, i32 25>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE27:%.*]] = extractelement <27 x i16> [[Y]], i64 26
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE2]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE8]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE9]], [[ELSE]] ]
; OPT-NEXT:    [[TMP5:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE10]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE11]], [[ELSE]] ]
; OPT-NEXT:    [[TMP6:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE12]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ]
; OPT-NEXT:    [[TMP7:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE14]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE15]], [[ELSE]] ]
; OPT-NEXT:    [[TMP8:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE16]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE17]], [[ELSE]] ]
; OPT-NEXT:    [[TMP9:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE18]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE19]], [[ELSE]] ]
; OPT-NEXT:    [[TMP10:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE20]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE21]], [[ELSE]] ]
; OPT-NEXT:    [[TMP11:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE22]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE23]], [[ELSE]] ]
; OPT-NEXT:    [[TMP12:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE24]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE25]], [[ELSE]] ]
; OPT-NEXT:    [[TMP13:%.*]] = phi i16 [ [[LARGEPHI_EXTRACTSLICE26]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE27]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> poison, <2 x i16> [[TMP0]], i64 0)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE0]], <2 x i16> [[TMP1]], i64 2)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE1]], <2 x i16> [[TMP2]], i64 4)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE2]], <2 x i16> [[TMP3]], i64 6)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE3]], <2 x i16> [[TMP4]], i64 8)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE5:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE4]], <2 x i16> [[TMP5]], i64 10)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE6:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE5]], <2 x i16> [[TMP6]], i64 12)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE7:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE6]], <2 x i16> [[TMP7]], i64 14)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE8:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE7]], <2 x i16> [[TMP8]], i64 16)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE9:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE8]], <2 x i16> [[TMP9]], i64 18)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE10:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE9]], <2 x i16> [[TMP10]], i64 20)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE11:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE10]], <2 x i16> [[TMP11]], i64 22)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE12:%.*]] = call <27 x i16> @llvm.vector.insert.v27i16.v2i16(<27 x i16> [[LARGEPHI_INSERTSLICE11]], <2 x i16> [[TMP12]], i64 24)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE13:%.*]] = insertelement <27 x i16> [[LARGEPHI_INSERTSLICE12]], i16 [[TMP13]], i64 26
; OPT-NEXT:    store <27 x i16> [[LARGEPHI_INSERTSLICE13]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v27i16(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <27 x i16> [[IN:%.*]], i16 42, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <27 x i16> [[IN]], i16 64, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <27 x i16> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <27 x i16> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <27 x i16> %in, i16 42, i32 3
  br label %finally
else:
  %y = insertelement <27 x i16> %in, i16 64, i32 6
  br label %finally
finally:
  %val = phi <27 x i16> [%x, %then], [%y, %else]
  store <27 x i16> %val, ptr %out, align 1
  ret void
}


define amdgpu_kernel void @phi_v23i8(<23 x i8> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v23i8(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <23 x i8> [[IN:%.*]], i8 42, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = shufflevector <23 x i8> [[X]], <23 x i8> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = shufflevector <23 x i8> [[X]], <23 x i8> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = shufflevector <23 x i8> [[X]], <23 x i8> poison, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = shufflevector <23 x i8> [[X]], <23 x i8> poison, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE8:%.*]] = shufflevector <23 x i8> [[X]], <23 x i8> poison, <4 x i32> <i32 16, i32 17, i32 18, i32 19>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = extractelement <23 x i8> [[X]], i64 20
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE12:%.*]] = extractelement <23 x i8> [[X]], i64 21
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE14:%.*]] = extractelement <23 x i8> [[X]], i64 22
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <23 x i8> [[IN]], i8 64, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = shufflevector <23 x i8> [[Y]], <23 x i8> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = shufflevector <23 x i8> [[Y]], <23 x i8> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = shufflevector <23 x i8> [[Y]], <23 x i8> poison, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = shufflevector <23 x i8> [[Y]], <23 x i8> poison, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = shufflevector <23 x i8> [[Y]], <23 x i8> poison, <4 x i32> <i32 16, i32 17, i32 18, i32 19>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE11:%.*]] = extractelement <23 x i8> [[Y]], i64 20
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE13:%.*]] = extractelement <23 x i8> [[Y]], i64 21
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE15:%.*]] = extractelement <23 x i8> [[Y]], i64 22
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi <4 x i8> [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi <4 x i8> [ [[LARGEPHI_EXTRACTSLICE2]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi <4 x i8> [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi <4 x i8> [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi <4 x i8> [ [[LARGEPHI_EXTRACTSLICE8]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE9]], [[ELSE]] ]
; OPT-NEXT:    [[TMP5:%.*]] = phi i8 [ [[LARGEPHI_EXTRACTSLICE10]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE11]], [[ELSE]] ]
; OPT-NEXT:    [[TMP6:%.*]] = phi i8 [ [[LARGEPHI_EXTRACTSLICE12]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ]
; OPT-NEXT:    [[TMP7:%.*]] = phi i8 [ [[LARGEPHI_EXTRACTSLICE14]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE15]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = call <23 x i8> @llvm.vector.insert.v23i8.v4i8(<23 x i8> poison, <4 x i8> [[TMP0]], i64 0)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = call <23 x i8> @llvm.vector.insert.v23i8.v4i8(<23 x i8> [[LARGEPHI_INSERTSLICE0]], <4 x i8> [[TMP1]], i64 4)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = call <23 x i8> @llvm.vector.insert.v23i8.v4i8(<23 x i8> [[LARGEPHI_INSERTSLICE1]], <4 x i8> [[TMP2]], i64 8)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = call <23 x i8> @llvm.vector.insert.v23i8.v4i8(<23 x i8> [[LARGEPHI_INSERTSLICE2]], <4 x i8> [[TMP3]], i64 12)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = call <23 x i8> @llvm.vector.insert.v23i8.v4i8(<23 x i8> [[LARGEPHI_INSERTSLICE3]], <4 x i8> [[TMP4]], i64 16)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE5:%.*]] = insertelement <23 x i8> [[LARGEPHI_INSERTSLICE4]], i8 [[TMP5]], i64 20
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE6:%.*]] = insertelement <23 x i8> [[LARGEPHI_INSERTSLICE5]], i8 [[TMP6]], i64 21
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE7:%.*]] = insertelement <23 x i8> [[LARGEPHI_INSERTSLICE6]], i8 [[TMP7]], i64 22
; OPT-NEXT:    store <23 x i8> [[LARGEPHI_INSERTSLICE7]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v23i8(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <23 x i8> [[IN:%.*]], i8 42, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <23 x i8> [[IN]], i8 64, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <23 x i8> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <23 x i8> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <23 x i8> %in, i8 42, i32 3
  br label %finally
else:
  %y = insertelement <23 x i8> %in, i8 64, i32 6
  br label %finally
finally:
  %val = phi <23 x i8> [%x, %then], [%y, %else]
  store <23 x i8> %val, ptr %out, align 1
  ret void
}


define amdgpu_kernel void @phi_v23i8_zeroinit(<23 x i8> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v23i8_zeroinit(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <23 x i8> [[IN:%.*]], i8 64, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = shufflevector <23 x i8> [[Y]], <23 x i8> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = shufflevector <23 x i8> [[Y]], <23 x i8> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = shufflevector <23 x i8> [[Y]], <23 x i8> poison, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = shufflevector <23 x i8> [[Y]], <23 x i8> poison, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = shufflevector <23 x i8> [[Y]], <23 x i8> poison, <4 x i32> <i32 16, i32 17, i32 18, i32 19>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE11:%.*]] = extractelement <23 x i8> [[Y]], i64 20
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE13:%.*]] = extractelement <23 x i8> [[Y]], i64 21
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE15:%.*]] = extractelement <23 x i8> [[Y]], i64 22
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi <4 x i8> [ zeroinitializer, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi <4 x i8> [ zeroinitializer, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi <4 x i8> [ zeroinitializer, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi <4 x i8> [ zeroinitializer, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi <4 x i8> [ zeroinitializer, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE9]], [[ELSE]] ]
; OPT-NEXT:    [[TMP5:%.*]] = phi i8 [ 0, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE11]], [[ELSE]] ]
; OPT-NEXT:    [[TMP6:%.*]] = phi i8 [ 0, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ]
; OPT-NEXT:    [[TMP7:%.*]] = phi i8 [ 0, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE15]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = call <23 x i8> @llvm.vector.insert.v23i8.v4i8(<23 x i8> poison, <4 x i8> [[TMP0]], i64 0)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = call <23 x i8> @llvm.vector.insert.v23i8.v4i8(<23 x i8> [[LARGEPHI_INSERTSLICE0]], <4 x i8> [[TMP1]], i64 4)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = call <23 x i8> @llvm.vector.insert.v23i8.v4i8(<23 x i8> [[LARGEPHI_INSERTSLICE1]], <4 x i8> [[TMP2]], i64 8)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = call <23 x i8> @llvm.vector.insert.v23i8.v4i8(<23 x i8> [[LARGEPHI_INSERTSLICE2]], <4 x i8> [[TMP3]], i64 12)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = call <23 x i8> @llvm.vector.insert.v23i8.v4i8(<23 x i8> [[LARGEPHI_INSERTSLICE3]], <4 x i8> [[TMP4]], i64 16)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE5:%.*]] = insertelement <23 x i8> [[LARGEPHI_INSERTSLICE4]], i8 [[TMP5]], i64 20
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE6:%.*]] = insertelement <23 x i8> [[LARGEPHI_INSERTSLICE5]], i8 [[TMP6]], i64 21
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE7:%.*]] = insertelement <23 x i8> [[LARGEPHI_INSERTSLICE6]], i8 [[TMP7]], i64 22
; OPT-NEXT:    store <23 x i8> [[LARGEPHI_INSERTSLICE7]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v23i8_zeroinit(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <23 x i8> [[IN:%.*]], i8 64, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <23 x i8> [ zeroinitializer, [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <23 x i8> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  br label %finally
else:
  %y = insertelement <23 x i8> %in, i8 64, i32 6
  br label %finally
finally:
  %val = phi <23 x i8> [zeroinitializer, %then], [%y, %else]
  store <23 x i8> %val, ptr %out, align 1
  ret void
}

define amdgpu_kernel void @phi_v15i8_random_constant_init(<15 x i8> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v15i8_random_constant_init(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <15 x i8> [[IN:%.*]], i8 64, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = shufflevector <15 x i8> [[Y]], <15 x i8> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = shufflevector <15 x i8> [[Y]], <15 x i8> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = shufflevector <15 x i8> [[Y]], <15 x i8> poison, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = extractelement <15 x i8> [[Y]], i64 12
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = extractelement <15 x i8> [[Y]], i64 13
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE11:%.*]] = extractelement <15 x i8> [[Y]], i64 14
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi <4 x i8> [ <i8 poison, i8 1, i8 2, i8 3>, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi <4 x i8> [ <i8 4, i8 undef, i8 6, i8 7>, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi <4 x i8> [ <i8 9, i8 10, i8 11, i8 12>, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi i8 [ 13, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi i8 [ 14, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE9]], [[ELSE]] ]
; OPT-NEXT:    [[TMP5:%.*]] = phi i8 [ undef, [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE11]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = call <15 x i8> @llvm.vector.insert.v15i8.v4i8(<15 x i8> poison, <4 x i8> [[TMP0]], i64 0)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = call <15 x i8> @llvm.vector.insert.v15i8.v4i8(<15 x i8> [[LARGEPHI_INSERTSLICE0]], <4 x i8> [[TMP1]], i64 4)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = call <15 x i8> @llvm.vector.insert.v15i8.v4i8(<15 x i8> [[LARGEPHI_INSERTSLICE1]], <4 x i8> [[TMP2]], i64 8)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <15 x i8> [[LARGEPHI_INSERTSLICE2]], i8 [[TMP3]], i64 12
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = insertelement <15 x i8> [[LARGEPHI_INSERTSLICE3]], i8 [[TMP4]], i64 13
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE5:%.*]] = insertelement <15 x i8> [[LARGEPHI_INSERTSLICE4]], i8 [[TMP5]], i64 14
; OPT-NEXT:    store <15 x i8> [[LARGEPHI_INSERTSLICE5]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v15i8_random_constant_init(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <15 x i8> [[IN:%.*]], i8 64, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <15 x i8> [ <i8 poison, i8 1, i8 2, i8 3, i8 4, i8 undef, i8 6, i8 7, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 undef>, [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <15 x i8> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  br label %finally
else:
  %y = insertelement <15 x i8> %in, i8 64, i32 6
  br label %finally
finally:
  %val = phi <15 x i8> [<i8 poison, i8 1, i8 2, i8 3, i8 4, i8 undef, i8 6, i8 7, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 undef>, %then], [%y, %else]
  store <15 x i8> %val, ptr %out, align 1
  ret void
}

define amdgpu_kernel void @phi_v23i32(<23 x i32> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v23i32(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <23 x i32> [[IN:%.*]], i32 42, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = extractelement <23 x i32> [[X]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = extractelement <23 x i32> [[X]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = extractelement <23 x i32> [[X]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = extractelement <23 x i32> [[X]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE8:%.*]] = extractelement <23 x i32> [[X]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = extractelement <23 x i32> [[X]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE12:%.*]] = extractelement <23 x i32> [[X]], i64 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE14:%.*]] = extractelement <23 x i32> [[X]], i64 7
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE16:%.*]] = extractelement <23 x i32> [[X]], i64 8
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE18:%.*]] = extractelement <23 x i32> [[X]], i64 9
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE20:%.*]] = extractelement <23 x i32> [[X]], i64 10
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE22:%.*]] = extractelement <23 x i32> [[X]], i64 11
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE24:%.*]] = extractelement <23 x i32> [[X]], i64 12
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE26:%.*]] = extractelement <23 x i32> [[X]], i64 13
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE28:%.*]] = extractelement <23 x i32> [[X]], i64 14
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE30:%.*]] = extractelement <23 x i32> [[X]], i64 15
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE32:%.*]] = extractelement <23 x i32> [[X]], i64 16
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE34:%.*]] = extractelement <23 x i32> [[X]], i64 17
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE36:%.*]] = extractelement <23 x i32> [[X]], i64 18
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE38:%.*]] = extractelement <23 x i32> [[X]], i64 19
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE40:%.*]] = extractelement <23 x i32> [[X]], i64 20
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE42:%.*]] = extractelement <23 x i32> [[X]], i64 21
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE44:%.*]] = extractelement <23 x i32> [[X]], i64 22
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <23 x i32> [[IN]], i32 64, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = extractelement <23 x i32> [[Y]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = extractelement <23 x i32> [[Y]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = extractelement <23 x i32> [[Y]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = extractelement <23 x i32> [[Y]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = extractelement <23 x i32> [[Y]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE11:%.*]] = extractelement <23 x i32> [[Y]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE13:%.*]] = extractelement <23 x i32> [[Y]], i64 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE15:%.*]] = extractelement <23 x i32> [[Y]], i64 7
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE17:%.*]] = extractelement <23 x i32> [[Y]], i64 8
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE19:%.*]] = extractelement <23 x i32> [[Y]], i64 9
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE21:%.*]] = extractelement <23 x i32> [[Y]], i64 10
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE23:%.*]] = extractelement <23 x i32> [[Y]], i64 11
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE25:%.*]] = extractelement <23 x i32> [[Y]], i64 12
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE27:%.*]] = extractelement <23 x i32> [[Y]], i64 13
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE29:%.*]] = extractelement <23 x i32> [[Y]], i64 14
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE31:%.*]] = extractelement <23 x i32> [[Y]], i64 15
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE33:%.*]] = extractelement <23 x i32> [[Y]], i64 16
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE35:%.*]] = extractelement <23 x i32> [[Y]], i64 17
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE37:%.*]] = extractelement <23 x i32> [[Y]], i64 18
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE39:%.*]] = extractelement <23 x i32> [[Y]], i64 19
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE41:%.*]] = extractelement <23 x i32> [[Y]], i64 20
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE43:%.*]] = extractelement <23 x i32> [[Y]], i64 21
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE45:%.*]] = extractelement <23 x i32> [[Y]], i64 22
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE2]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE8]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE9]], [[ELSE]] ]
; OPT-NEXT:    [[TMP5:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE10]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE11]], [[ELSE]] ]
; OPT-NEXT:    [[TMP6:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE12]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ]
; OPT-NEXT:    [[TMP7:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE14]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE15]], [[ELSE]] ]
; OPT-NEXT:    [[TMP8:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE16]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE17]], [[ELSE]] ]
; OPT-NEXT:    [[TMP9:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE18]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE19]], [[ELSE]] ]
; OPT-NEXT:    [[TMP10:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE20]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE21]], [[ELSE]] ]
; OPT-NEXT:    [[TMP11:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE22]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE23]], [[ELSE]] ]
; OPT-NEXT:    [[TMP12:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE24]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE25]], [[ELSE]] ]
; OPT-NEXT:    [[TMP13:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE26]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE27]], [[ELSE]] ]
; OPT-NEXT:    [[TMP14:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE28]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE29]], [[ELSE]] ]
; OPT-NEXT:    [[TMP15:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE30]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE31]], [[ELSE]] ]
; OPT-NEXT:    [[TMP16:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE32]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE33]], [[ELSE]] ]
; OPT-NEXT:    [[TMP17:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE34]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE35]], [[ELSE]] ]
; OPT-NEXT:    [[TMP18:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE36]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE37]], [[ELSE]] ]
; OPT-NEXT:    [[TMP19:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE38]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE39]], [[ELSE]] ]
; OPT-NEXT:    [[TMP20:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE40]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE41]], [[ELSE]] ]
; OPT-NEXT:    [[TMP21:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE42]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE43]], [[ELSE]] ]
; OPT-NEXT:    [[TMP22:%.*]] = phi i32 [ [[LARGEPHI_EXTRACTSLICE44]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE45]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = insertelement <23 x i32> poison, i32 [[TMP0]], i64 0
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE0]], i32 [[TMP1]], i64 1
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE1]], i32 [[TMP2]], i64 2
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE2]], i32 [[TMP3]], i64 3
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE3]], i32 [[TMP4]], i64 4
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE5:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE4]], i32 [[TMP5]], i64 5
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE6:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE5]], i32 [[TMP6]], i64 6
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE7:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE6]], i32 [[TMP7]], i64 7
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE8:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE7]], i32 [[TMP8]], i64 8
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE9:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE8]], i32 [[TMP9]], i64 9
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE10:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE9]], i32 [[TMP10]], i64 10
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE11:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE10]], i32 [[TMP11]], i64 11
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE12:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE11]], i32 [[TMP12]], i64 12
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE13:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE12]], i32 [[TMP13]], i64 13
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE14:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE13]], i32 [[TMP14]], i64 14
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE15:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE14]], i32 [[TMP15]], i64 15
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE16:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE15]], i32 [[TMP16]], i64 16
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE17:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE16]], i32 [[TMP17]], i64 17
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE18:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE17]], i32 [[TMP18]], i64 18
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE19:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE18]], i32 [[TMP19]], i64 19
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE20:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE19]], i32 [[TMP20]], i64 20
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE21:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE20]], i32 [[TMP21]], i64 21
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE22:%.*]] = insertelement <23 x i32> [[LARGEPHI_INSERTSLICE21]], i32 [[TMP22]], i64 22
; OPT-NEXT:    store <23 x i32> [[LARGEPHI_INSERTSLICE22]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v23i32(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <23 x i32> [[IN:%.*]], i32 42, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <23 x i32> [[IN]], i32 64, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <23 x i32> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <23 x i32> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <23 x i32> %in, i32 42, i32 3
  br label %finally
else:
  %y = insertelement <23 x i32> %in, i32 64, i32 6
  br label %finally
finally:
  %val = phi <23 x i32> [%x, %then], [%y, %else]
  store <23 x i32> %val, ptr %out, align 1
  ret void
}

define amdgpu_kernel void @phi_v16i64(<16 x i64> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v16i64(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <16 x i64> [[IN:%.*]], i64 42, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = extractelement <16 x i64> [[X]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = extractelement <16 x i64> [[X]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = extractelement <16 x i64> [[X]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = extractelement <16 x i64> [[X]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE8:%.*]] = extractelement <16 x i64> [[X]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = extractelement <16 x i64> [[X]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE12:%.*]] = extractelement <16 x i64> [[X]], i64 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE14:%.*]] = extractelement <16 x i64> [[X]], i64 7
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE16:%.*]] = extractelement <16 x i64> [[X]], i64 8
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE18:%.*]] = extractelement <16 x i64> [[X]], i64 9
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE20:%.*]] = extractelement <16 x i64> [[X]], i64 10
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE22:%.*]] = extractelement <16 x i64> [[X]], i64 11
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE24:%.*]] = extractelement <16 x i64> [[X]], i64 12
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE26:%.*]] = extractelement <16 x i64> [[X]], i64 13
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE28:%.*]] = extractelement <16 x i64> [[X]], i64 14
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE30:%.*]] = extractelement <16 x i64> [[X]], i64 15
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <16 x i64> [[IN]], i64 64, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = extractelement <16 x i64> [[Y]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = extractelement <16 x i64> [[Y]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = extractelement <16 x i64> [[Y]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = extractelement <16 x i64> [[Y]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = extractelement <16 x i64> [[Y]], i64 4
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE11:%.*]] = extractelement <16 x i64> [[Y]], i64 5
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE13:%.*]] = extractelement <16 x i64> [[Y]], i64 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE15:%.*]] = extractelement <16 x i64> [[Y]], i64 7
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE17:%.*]] = extractelement <16 x i64> [[Y]], i64 8
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE19:%.*]] = extractelement <16 x i64> [[Y]], i64 9
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE21:%.*]] = extractelement <16 x i64> [[Y]], i64 10
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE23:%.*]] = extractelement <16 x i64> [[Y]], i64 11
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE25:%.*]] = extractelement <16 x i64> [[Y]], i64 12
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE27:%.*]] = extractelement <16 x i64> [[Y]], i64 13
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE29:%.*]] = extractelement <16 x i64> [[Y]], i64 14
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE31:%.*]] = extractelement <16 x i64> [[Y]], i64 15
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE2]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE8]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE9]], [[ELSE]] ]
; OPT-NEXT:    [[TMP5:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE10]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE11]], [[ELSE]] ]
; OPT-NEXT:    [[TMP6:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE12]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ]
; OPT-NEXT:    [[TMP7:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE14]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE15]], [[ELSE]] ]
; OPT-NEXT:    [[TMP8:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE16]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE17]], [[ELSE]] ]
; OPT-NEXT:    [[TMP9:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE18]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE19]], [[ELSE]] ]
; OPT-NEXT:    [[TMP10:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE20]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE21]], [[ELSE]] ]
; OPT-NEXT:    [[TMP11:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE22]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE23]], [[ELSE]] ]
; OPT-NEXT:    [[TMP12:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE24]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE25]], [[ELSE]] ]
; OPT-NEXT:    [[TMP13:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE26]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE27]], [[ELSE]] ]
; OPT-NEXT:    [[TMP14:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE28]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE29]], [[ELSE]] ]
; OPT-NEXT:    [[TMP15:%.*]] = phi i64 [ [[LARGEPHI_EXTRACTSLICE30]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE31]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = insertelement <16 x i64> poison, i64 [[TMP0]], i64 0
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE0]], i64 [[TMP1]], i64 1
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE1]], i64 [[TMP2]], i64 2
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE2]], i64 [[TMP3]], i64 3
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE3]], i64 [[TMP4]], i64 4
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE5:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE4]], i64 [[TMP5]], i64 5
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE6:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE5]], i64 [[TMP6]], i64 6
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE7:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE6]], i64 [[TMP7]], i64 7
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE8:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE7]], i64 [[TMP8]], i64 8
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE9:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE8]], i64 [[TMP9]], i64 9
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE10:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE9]], i64 [[TMP10]], i64 10
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE11:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE10]], i64 [[TMP11]], i64 11
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE12:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE11]], i64 [[TMP12]], i64 12
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE13:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE12]], i64 [[TMP13]], i64 13
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE14:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE13]], i64 [[TMP14]], i64 14
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE15:%.*]] = insertelement <16 x i64> [[LARGEPHI_INSERTSLICE14]], i64 [[TMP15]], i64 15
; OPT-NEXT:    store <16 x i64> [[LARGEPHI_INSERTSLICE15]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v16i64(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <16 x i64> [[IN:%.*]], i64 42, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <16 x i64> [[IN]], i64 64, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <16 x i64> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <16 x i64> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <16 x i64> %in, i64 42, i32 3
  br label %finally
else:
  %y = insertelement <16 x i64> %in, i64 64, i32 6
  br label %finally
finally:
  %val = phi <16 x i64> [%x, %then], [%y, %else]
  store <16 x i64> %val, ptr %out, align 1
  ret void
}

define amdgpu_kernel void @phi_v7i16(<7 x i16> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @phi_v7i16(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <7 x i16> [[IN:%.*]], i16 3, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = shufflevector <7 x i16> [[X]], <7 x i16> poison, <2 x i32> <i32 0, i32 1>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = shufflevector <7 x i16> [[X]], <7 x i16> poison, <2 x i32> <i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = shufflevector <7 x i16> [[X]], <7 x i16> poison, <2 x i32> <i32 4, i32 5>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = extractelement <7 x i16> [[X]], i64 6
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <7 x i16> [[IN]], i16 9, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = shufflevector <7 x i16> [[Y]], <7 x i16> poison, <2 x i32> <i32 0, i32 1>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = shufflevector <7 x i16> [[Y]], <7 x i16> poison, <2 x i32> <i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = shufflevector <7 x i16> [[Y]], <7 x i16> poison, <2 x i32> <i32 4, i32 5>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = extractelement <7 x i16> [[Y]], i64 6
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE2]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE3]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi i16 [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = call <7 x i16> @llvm.vector.insert.v7i16.v2i16(<7 x i16> poison, <2 x i16> [[TMP0]], i64 0)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = call <7 x i16> @llvm.vector.insert.v7i16.v2i16(<7 x i16> [[LARGEPHI_INSERTSLICE0]], <2 x i16> [[TMP1]], i64 2)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = call <7 x i16> @llvm.vector.insert.v7i16.v2i16(<7 x i16> [[LARGEPHI_INSERTSLICE1]], <2 x i16> [[TMP2]], i64 4)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <7 x i16> [[LARGEPHI_INSERTSLICE2]], i16 [[TMP3]], i64 6
; OPT-NEXT:    store <7 x i16> [[LARGEPHI_INSERTSLICE3]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v7i16(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <7 x i16> [[IN:%.*]], i16 3, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <7 x i16> [[IN]], i16 9, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <7 x i16> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <7 x i16> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <7 x i16> %in, i16 3, i32 3
  br label %finally
else:
  %y = insertelement <7 x i16> %in, i16 9, i32 6
  br label %finally
finally:
  %val = phi <7 x i16> [%x, %then], [%y, %else]
  store <7 x i16> %val, ptr %out, align 1
  ret void
}


define amdgpu_kernel void @phi_v7i16_switch(<7 x i16> %in, ptr %out, i8 %cond) {
; OPT-LABEL: @phi_v7i16_switch(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[X:%.*]] = insertelement <7 x i16> [[IN:%.*]], i16 3, i32 3
; OPT-NEXT:    switch i8 [[COND:%.*]], label [[ELSE:%.*]] [
; OPT-NEXT:    i8 0, label [[THEN_1:%.*]]
; OPT-NEXT:    i8 3, label [[THEN_2:%.*]]
; OPT-NEXT:    ]
; OPT:       then.1:
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = shufflevector <7 x i16> [[X]], <7 x i16> poison, <2 x i32> <i32 0, i32 1>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = shufflevector <7 x i16> [[X]], <7 x i16> poison, <2 x i32> <i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = shufflevector <7 x i16> [[X]], <7 x i16> poison, <2 x i32> <i32 4, i32 5>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = extractelement <7 x i16> [[X]], i64 6
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       then.2:
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = shufflevector <7 x i16> [[X]], <7 x i16> poison, <2 x i32> <i32 0, i32 1>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = shufflevector <7 x i16> [[X]], <7 x i16> poison, <2 x i32> <i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = shufflevector <7 x i16> [[X]], <7 x i16> poison, <2 x i32> <i32 4, i32 5>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = extractelement <7 x i16> [[X]], i64 6
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <7 x i16> [[IN]], i16 9, i32 6
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE2:%.*]] = shufflevector <7 x i16> [[Y]], <7 x i16> poison, <2 x i32> <i32 0, i32 1>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE5:%.*]] = shufflevector <7 x i16> [[Y]], <7 x i16> poison, <2 x i32> <i32 2, i32 3>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE8:%.*]] = shufflevector <7 x i16> [[Y]], <7 x i16> poison, <2 x i32> <i32 4, i32 5>
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE11:%.*]] = extractelement <7 x i16> [[Y]], i64 6
; OPT-NEXT:    br label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN_1]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[THEN_2]] ], [ [[LARGEPHI_EXTRACTSLICE2]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE3]], [[THEN_1]] ], [ [[LARGEPHI_EXTRACTSLICE4]], [[THEN_2]] ], [ [[LARGEPHI_EXTRACTSLICE5]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi <2 x i16> [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN_1]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[THEN_2]] ], [ [[LARGEPHI_EXTRACTSLICE8]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi i16 [ [[LARGEPHI_EXTRACTSLICE9]], [[THEN_1]] ], [ [[LARGEPHI_EXTRACTSLICE10]], [[THEN_2]] ], [ [[LARGEPHI_EXTRACTSLICE11]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = call <7 x i16> @llvm.vector.insert.v7i16.v2i16(<7 x i16> poison, <2 x i16> [[TMP0]], i64 0)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = call <7 x i16> @llvm.vector.insert.v7i16.v2i16(<7 x i16> [[LARGEPHI_INSERTSLICE0]], <2 x i16> [[TMP1]], i64 2)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = call <7 x i16> @llvm.vector.insert.v7i16.v2i16(<7 x i16> [[LARGEPHI_INSERTSLICE1]], <2 x i16> [[TMP2]], i64 4)
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <7 x i16> [[LARGEPHI_INSERTSLICE2]], i16 [[TMP3]], i64 6
; OPT-NEXT:    store <7 x i16> [[LARGEPHI_INSERTSLICE3]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @phi_v7i16_switch(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <7 x i16> [[IN:%.*]], i16 3, i32 3
; NOOPT-NEXT:    switch i8 [[COND:%.*]], label [[ELSE:%.*]] [
; NOOPT-NEXT:    i8 0, label [[THEN_1:%.*]]
; NOOPT-NEXT:    i8 3, label [[THEN_2:%.*]]
; NOOPT-NEXT:    ]
; NOOPT:       then.1:
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       then.2:
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <7 x i16> [[IN]], i16 9, i32 6
; NOOPT-NEXT:    br label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <7 x i16> [ [[X]], [[THEN_1]] ], [ [[X]], [[THEN_2]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <7 x i16> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  %x = insertelement <7 x i16> %in, i16 3, i32 3
  switch i8 %cond, label %else [
  i8 0, label %then.1
  i8 3, label %then.2
  ]
then.1:
  br label %finally
then.2:
  br label %finally
else:
  %y = insertelement <7 x i16> %in, i16 9, i32 6
  br label %finally
finally:
  %val = phi <7 x i16> [%x, %then.1], [%x, %then.2], [%y, %else]
  store <7 x i16> %val, ptr %out, align 1
  ret void
}

; Checks that we can deal with PHIs that have the  same basic block/incoming value
; pair appear more than once in the incoming blocks.
; It's not illegal IR. However, if the pass lazily transforms all incoming values
; without checking for duplicates, it could create a PHI with the same basic block
; appearing multiple times, but with different incoming values, which is then illegal
; IR.
; The error was:
;   PHI node has multiple entries for the same basic block with different incoming values!
define amdgpu_kernel void @multi_inc_same_bb(<5 x double> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @multi_inc_same_bb(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <5 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = extractelement <5 x double> [[X]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = extractelement <5 x double> [[X]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = extractelement <5 x double> [[X]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = extractelement <5 x double> [[X]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE12:%.*]] = extractelement <5 x double> [[X]], i64 4
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <5 x double> [[IN]], double 9.140000e+00, i32 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = extractelement <5 x double> [[Y]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = extractelement <5 x double> [[Y]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = extractelement <5 x double> [[Y]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = extractelement <5 x double> [[Y]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE13:%.*]] = extractelement <5 x double> [[Y]], i64 4
; OPT-NEXT:    br i1 [[COND]], label [[FINALLY]], label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE3]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE4]], [[ELSE]] ], [ [[LARGEPHI_EXTRACTSLICE4]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE9]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE10]], [[ELSE]] ], [ [[LARGEPHI_EXTRACTSLICE10]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE12]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = insertelement <5 x double> poison, double [[TMP0]], i64 0
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE0]], double [[TMP1]], i64 1
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE1]], double [[TMP2]], i64 2
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE2]], double [[TMP3]], i64 3
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE3]], double [[TMP4]], i64 4
; OPT-NEXT:    store <5 x double> [[LARGEPHI_INSERTSLICE4]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @multi_inc_same_bb(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <5 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <5 x double> [[IN]], double 9.140000e+00, i32 2
; NOOPT-NEXT:    br i1 [[COND]], label [[FINALLY]], label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <5 x double> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    store <5 x double> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <5 x double> %in, double 3.14, i32 3
  br label %finally
else:
  %y = insertelement <5 x double> %in, double 9.14, i32 2
  br i1 %cond, label %finally, label %finally
finally:
  %val = phi <5 x double> [%x, %then], [%y, %else], [%y, %else]
  store <5 x double> %val, ptr %out, align 1
  ret void
}

; Checks that we can ndeal with blocks that just have a PHI + terminator.
define amdgpu_kernel void @minimal_block_with_only_phi(<5 x double> %in, ptr %out, i1 %cond) {
; OPT-LABEL: @minimal_block_with_only_phi(
; OPT-NEXT:  entry:
; OPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; OPT:       then:
; OPT-NEXT:    [[X:%.*]] = insertelement <5 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE0:%.*]] = extractelement <5 x double> [[X]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE3:%.*]] = extractelement <5 x double> [[X]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE6:%.*]] = extractelement <5 x double> [[X]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE9:%.*]] = extractelement <5 x double> [[X]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE12:%.*]] = extractelement <5 x double> [[X]], i64 4
; OPT-NEXT:    br label [[FINALLY:%.*]]
; OPT:       else:
; OPT-NEXT:    [[Y:%.*]] = insertelement <5 x double> [[IN]], double 9.140000e+00, i32 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE1:%.*]] = extractelement <5 x double> [[Y]], i64 0
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE4:%.*]] = extractelement <5 x double> [[Y]], i64 1
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE7:%.*]] = extractelement <5 x double> [[Y]], i64 2
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE10:%.*]] = extractelement <5 x double> [[Y]], i64 3
; OPT-NEXT:    [[LARGEPHI_EXTRACTSLICE13:%.*]] = extractelement <5 x double> [[Y]], i64 4
; OPT-NEXT:    br i1 [[COND]], label [[FINALLY]], label [[FINALLY]]
; OPT:       finally:
; OPT-NEXT:    [[TMP0:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE0]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ], [ [[LARGEPHI_EXTRACTSLICE1]], [[ELSE]] ]
; OPT-NEXT:    [[TMP1:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE3]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE4]], [[ELSE]] ], [ [[LARGEPHI_EXTRACTSLICE4]], [[ELSE]] ]
; OPT-NEXT:    [[TMP2:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE6]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ], [ [[LARGEPHI_EXTRACTSLICE7]], [[ELSE]] ]
; OPT-NEXT:    [[TMP3:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE9]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE10]], [[ELSE]] ], [ [[LARGEPHI_EXTRACTSLICE10]], [[ELSE]] ]
; OPT-NEXT:    [[TMP4:%.*]] = phi double [ [[LARGEPHI_EXTRACTSLICE12]], [[THEN]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ], [ [[LARGEPHI_EXTRACTSLICE13]], [[ELSE]] ]
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE0:%.*]] = insertelement <5 x double> poison, double [[TMP0]], i64 0
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE1:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE0]], double [[TMP1]], i64 1
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE2:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE1]], double [[TMP2]], i64 2
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE3:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE2]], double [[TMP3]], i64 3
; OPT-NEXT:    [[LARGEPHI_INSERTSLICE4:%.*]] = insertelement <5 x double> [[LARGEPHI_INSERTSLICE3]], double [[TMP4]], i64 4
; OPT-NEXT:    br label [[REALLYFINALLY:%.*]]
; OPT:       reallyfinally:
; OPT-NEXT:    store <5 x double> [[LARGEPHI_INSERTSLICE4]], ptr [[OUT:%.*]], align 1
; OPT-NEXT:    ret void
;
; NOOPT-LABEL: @minimal_block_with_only_phi(
; NOOPT-NEXT:  entry:
; NOOPT-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; NOOPT:       then:
; NOOPT-NEXT:    [[X:%.*]] = insertelement <5 x double> [[IN:%.*]], double 3.140000e+00, i32 3
; NOOPT-NEXT:    br label [[FINALLY:%.*]]
; NOOPT:       else:
; NOOPT-NEXT:    [[Y:%.*]] = insertelement <5 x double> [[IN]], double 9.140000e+00, i32 2
; NOOPT-NEXT:    br i1 [[COND]], label [[FINALLY]], label [[FINALLY]]
; NOOPT:       finally:
; NOOPT-NEXT:    [[VAL:%.*]] = phi <5 x double> [ [[X]], [[THEN]] ], [ [[Y]], [[ELSE]] ], [ [[Y]], [[ELSE]] ]
; NOOPT-NEXT:    br label [[REALLYFINALLY:%.*]]
; NOOPT:       reallyfinally:
; NOOPT-NEXT:    store <5 x double> [[VAL]], ptr [[OUT:%.*]], align 1
; NOOPT-NEXT:    ret void
;
entry:
  br i1 %cond, label %then, label %else
then:
  %x = insertelement <5 x double> %in, double 3.14, i32 3
  br label %finally
else:
  %y = insertelement <5 x double> %in, double 9.14, i32 2
  br i1 %cond, label %finally, label %finally
finally:
  %val = phi <5 x double> [%x, %then], [%y, %else], [%y, %else]
  br label %reallyfinally
reallyfinally:
  store <5 x double> %val, ptr %out, align 1
  ret void
}
