; Test that the strncpy folder avoids simplifying a call to the function
; declared with an incompatible type.
;
; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test that the strncpy library call simplifier works correctly.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64-f80:128:128"

@hello = constant [6 x i8] c"hello\00"
@a = common global [32 x i8] zeroinitializer, align 1

declare i16 @strncpy(ptr, ptr, i32)

; Check that 'strncpy' functions with the wrong prototype aren't simplified.

define void @test_no_simplify1() {
; CHECK-LABEL: @test_no_simplify1(
; CHECK-NEXT:    [[TMP1:%.*]] = call i16 @strncpy(ptr nonnull @a, ptr nonnull @hello, i32 6)
; CHECK-NEXT:    ret void
;

  call i16 @strncpy(ptr @a, ptr @hello, i32 6)
  ret void
}
