; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt -S -O3 -o - %s | FileCheck %s

; PR44154: LLVM c3b06d0c393e caused the body of @main to be replaced with
; unreachable. Check that we perform the expected calls and optimizations.

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define i32 @main(i32 %argc, ptr %argv) #0 {
; CHECK-LABEL: define {{[^@]+}}@main
; CHECK-SAME: (i32 [[ARGC:%.*]], ptr nocapture readnone [[ARGV:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp slt i32 [[ARGC]], 2
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[TMP0]], i32 0, i32 [[ARGC]]
; CHECK-NEXT:    ret i32 [[SPEC_SELECT]]
;
entry:
  %ptr = load ptr, ptr %argv
  %0 = call i32 @compute(ptr %ptr, i32 %argc)
  %1 = icmp slt i32 %argc, 2
  br i1 %1, label %done, label %do_work

do_work:
  %2 = icmp eq ptr %ptr, null
  br i1 %2, label %null, label %done

null:
  call void @call_if_null(ptr %ptr)
  br label %done

done:
  %retval = phi i32 [0, %entry], [%0, %do_work], [%0, %null]
  ret i32 %retval
}

define i32 @compute(ptr noundef nonnull %ptr, i32 %x) #1 {
; CHECK-LABEL: define {{[^@]+}}@compute
; CHECK-SAME: (ptr nocapture noundef nonnull readnone [[PTR:%.*]], i32 returned [[X:%.*]]) local_unnamed_addr #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    ret i32 [[X]]
;
  ret i32 %x
}

declare void @call_if_null(ptr %ptr) #0

attributes #0 = { nounwind }
attributes #1 = { noinline nounwind readonly }
