; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='default<O3>' -S | FileCheck %s

target datalayout = "e-m:e-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64"
target triple = "thumbv8.1m.main-arm-none-eabi"

; This should, after inlining and simplification, be a single tail predicated
; 16x vector loop handling llvm.sadd.sat.  __SSAT is inlined and so is DCE'd.

; Function Attrs: nounwind
define dso_local void @arm_add_q7(ptr %pSrcA, ptr %pSrcB, ptr noalias %pDst, i32 %blockSize) #0 {
; CHECK-LABEL: @arm_add_q7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP_NOT3:%.*]] = icmp eq i32 [[BLOCKSIZE:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP_NOT3]], label [[WHILE_END:%.*]], label [[VECTOR_PH:%.*]]
; CHECK:       vector.ph:
; CHECK-NEXT:    [[N_RND_UP:%.*]] = add i32 [[BLOCKSIZE]], 15
; CHECK-NEXT:    [[N_VEC:%.*]] = and i32 [[N_RND_UP]], -16
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i32 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[NEXT_GEP:%.*]] = getelementptr i8, ptr [[PSRCA:%.*]], i32 [[INDEX]]
; CHECK-NEXT:    [[NEXT_GEP14:%.*]] = getelementptr i8, ptr [[PDST:%.*]], i32 [[INDEX]]
; CHECK-NEXT:    [[NEXT_GEP15:%.*]] = getelementptr i8, ptr [[PSRCB:%.*]], i32 [[INDEX]]
; CHECK-NEXT:    [[ACTIVE_LANE_MASK:%.*]] = tail call <16 x i1> @llvm.get.active.lane.mask.v16i1.i32(i32 [[INDEX]], i32 [[BLOCKSIZE]])
; CHECK-NEXT:    [[WIDE_MASKED_LOAD:%.*]] = tail call <16 x i8> @llvm.masked.load.v16i8.p0(ptr [[NEXT_GEP]], i32 1, <16 x i1> [[ACTIVE_LANE_MASK]], <16 x i8> poison)
; CHECK-NEXT:    [[WIDE_MASKED_LOAD16:%.*]] = tail call <16 x i8> @llvm.masked.load.v16i8.p0(ptr [[NEXT_GEP15]], i32 1, <16 x i1> [[ACTIVE_LANE_MASK]], <16 x i8> poison)
; CHECK-NEXT:    [[TMP2:%.*]] = tail call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> [[WIDE_MASKED_LOAD]], <16 x i8> [[WIDE_MASKED_LOAD16]])
; CHECK-NEXT:    tail call void @llvm.masked.store.v16i8.p0(<16 x i8> [[TMP2]], ptr [[NEXT_GEP14]], i32 1, <16 x i1> [[ACTIVE_LANE_MASK]])
; CHECK-NEXT:    [[INDEX_NEXT]] = add i32 [[INDEX]], 16
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i32 [[INDEX_NEXT]], [[N_VEC]]
; CHECK-NEXT:    br i1 [[TMP4]], label [[WHILE_END]], label [[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       while.end:
; CHECK-NEXT:    ret void
;
entry:
  %pSrcA.addr = alloca ptr, align 4
  %pSrcB.addr = alloca ptr, align 4
  %pDst.addr = alloca ptr, align 4
  %blockSize.addr = alloca i32, align 4
  %blkCnt = alloca i32, align 4
  store ptr %pSrcA, ptr %pSrcA.addr, align 4
  store ptr %pSrcB, ptr %pSrcB.addr, align 4
  store ptr %pDst, ptr %pDst.addr, align 4
  store i32 %blockSize, ptr %blockSize.addr, align 4
  call void @llvm.lifetime.start.p0(i64 4, ptr %blkCnt)
  %0 = load i32, ptr %blockSize.addr, align 4
  store i32 %0, ptr %blkCnt, align 4
  br label %while.cond

while.cond:                                       ; preds = %while.body, %entry
  %1 = load i32, ptr %blkCnt, align 4
  %cmp = icmp ugt i32 %1, 0
  br i1 %cmp, label %while.body, label %while.end

while.body:                                       ; preds = %while.cond
  %2 = load ptr, ptr %pSrcA.addr, align 4
  %incdec.ptr = getelementptr inbounds i8, ptr %2, i32 1
  store ptr %incdec.ptr, ptr %pSrcA.addr, align 4
  %3 = load i8, ptr %2, align 1
  %conv = sext i8 %3 to i16
  %conv1 = sext i16 %conv to i32
  %4 = load ptr, ptr %pSrcB.addr, align 4
  %incdec.ptr2 = getelementptr inbounds i8, ptr %4, i32 1
  store ptr %incdec.ptr2, ptr %pSrcB.addr, align 4
  %5 = load i8, ptr %4, align 1
  %conv3 = sext i8 %5 to i32
  %add = add nsw i32 %conv1, %conv3
  %call = call i32 @__SSAT(i32 %add, i32 8)
  %conv4 = trunc i32 %call to i8
  %6 = load ptr, ptr %pDst.addr, align 4
  %incdec.ptr5 = getelementptr inbounds i8, ptr %6, i32 1
  store ptr %incdec.ptr5, ptr %pDst.addr, align 4
  store i8 %conv4, ptr %6, align 1
  %7 = load i32, ptr %blkCnt, align 4
  %dec = add i32 %7, -1
  store i32 %dec, ptr %blkCnt, align 4
  br label %while.cond

while.end:                                        ; preds = %while.cond
  call void @llvm.lifetime.end.p0(i64 4, ptr %blkCnt)
  ret void
}

define internal i32 @__SSAT(i32 %val, i32 %sat) #1 {
entry:
  %retval = alloca i32, align 4
  %val.addr = alloca i32, align 4
  %sat.addr = alloca i32, align 4
  %max = alloca i32, align 4
  %min = alloca i32, align 4
  %cleanup.dest.slot = alloca i32, align 4
  store i32 %val, ptr %val.addr, align 4
  store i32 %sat, ptr %sat.addr, align 4
  %0 = load i32, ptr %sat.addr, align 4
  %cmp = icmp uge i32 %0, 1
  br i1 %cmp, label %land.lhs.true, label %if.end10

land.lhs.true:                                    ; preds = %entry
  %1 = load i32, ptr %sat.addr, align 4
  %cmp1 = icmp ule i32 %1, 32
  br i1 %cmp1, label %if.then, label %if.end10

if.then:                                          ; preds = %land.lhs.true
  call void @llvm.lifetime.start.p0(i64 4, ptr %max)
  %2 = load i32, ptr %sat.addr, align 4
  %sub = sub i32 %2, 1
  %shl = shl i32 1, %sub
  %sub2 = sub i32 %shl, 1
  store i32 %sub2, ptr %max, align 4
  call void @llvm.lifetime.start.p0(i64 4, ptr %min)
  %3 = load i32, ptr %max, align 4
  %sub3 = sub nsw i32 -1, %3
  store i32 %sub3, ptr %min, align 4
  %4 = load i32, ptr %val.addr, align 4
  %5 = load i32, ptr %max, align 4
  %cmp4 = icmp sgt i32 %4, %5
  br i1 %cmp4, label %if.then5, label %if.else

if.then5:                                         ; preds = %if.then
  %6 = load i32, ptr %max, align 4
  store i32 %6, ptr %retval, align 4
  store i32 1, ptr %cleanup.dest.slot, align 4
  br label %cleanup

if.else:                                          ; preds = %if.then
  %7 = load i32, ptr %val.addr, align 4
  %8 = load i32, ptr %min, align 4
  %cmp6 = icmp slt i32 %7, %8
  br i1 %cmp6, label %if.then7, label %if.end

if.then7:                                         ; preds = %if.else
  %9 = load i32, ptr %min, align 4
  store i32 %9, ptr %retval, align 4
  store i32 1, ptr %cleanup.dest.slot, align 4
  br label %cleanup

if.end:                                           ; preds = %if.else
  br label %if.end8

if.end8:                                          ; preds = %if.end
  store i32 0, ptr %cleanup.dest.slot, align 4
  br label %cleanup

cleanup:                                          ; preds = %if.end8, %if.then7, %if.then5
  call void @llvm.lifetime.end.p0(i64 4, ptr %min)
  call void @llvm.lifetime.end.p0(i64 4, ptr %max)
  %cleanup.dest = load i32, ptr %cleanup.dest.slot, align 4
  switch i32 %cleanup.dest, label %unreachable [
  i32 0, label %cleanup.cont
  i32 1, label %return
  ]

cleanup.cont:                                     ; preds = %cleanup
  br label %if.end10

if.end10:                                         ; preds = %cleanup.cont, %land.lhs.true, %entry
  %10 = load i32, ptr %val.addr, align 4
  store i32 %10, ptr %retval, align 4
  br label %return

return:                                           ; preds = %if.end10, %cleanup
  %11 = load i32, ptr %retval, align 4
  ret i32 %11

unreachable:                                      ; preds = %cleanup
  unreachable
}

declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture)
declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture)

attributes #0 = { nounwind "frame-pointer"="all" "min-legal-vector-width"="0" "no-infs-fp-math"="true" "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-cpu"="cortex-m55" "target-features"="+armv8.1-m.main,+dsp,+fp-armv8d16,+fp-armv8d16sp,+fp16,+fp64,+fullfp16,+hwdiv,+lob,+mve,+mve.fp,+ras,+strict-align,+thumb-mode,+vfp2,+vfp2sp,+vfp3d16,+vfp3d16sp,+vfp4d16,+vfp4d16sp,-aes,-bf16,-cdecp0,-cdecp1,-cdecp2,-cdecp3,-cdecp4,-cdecp5,-cdecp6,-cdecp7,-crc,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8sp,-fp16fml,-hwdiv-arm,-i8mm,-neon,-sb,-sha2,-vfp3,-vfp3sp,-vfp4,-vfp4sp" "unsafe-fp-math"="true" }
attributes #1 = { alwaysinline nounwind "frame-pointer"="all" "min-legal-vector-width"="0" "no-infs-fp-math"="true" "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-cpu"="cortex-m55" "target-features"="+armv8.1-m.main,+dsp,+fp-armv8d16,+fp-armv8d16sp,+fp16,+fp64,+fullfp16,+hwdiv,+lob,+mve,+mve.fp,+ras,+strict-align,+thumb-mode,+vfp2,+vfp2sp,+vfp3d16,+vfp3d16sp,+vfp4d16,+vfp4d16sp,-aes,-bf16,-cdecp0,-cdecp1,-cdecp2,-cdecp3,-cdecp4,-cdecp5,-cdecp6,-cdecp7,-crc,-crypto,-d32,-dotprod,-fp-armv8,-fp-armv8sp,-fp16fml,-hwdiv-arm,-i8mm,-neon,-sb,-sha2,-vfp3,-vfp3sp,-vfp4,-vfp4sp" "unsafe-fp-math"="true" }
