// Generated by CoffeeScript 2.5.1
var AnsiPainter, Layout, RenderKid, Styles, blockStyleApplier, cloneAndMergeDeep, inlineStyleApplier, isPlainObject, stripAnsi, terminalWidth, tools;

inlineStyleApplier = require('./renderKid/styleApplier/inline');

blockStyleApplier = require('./renderKid/styleApplier/block');

isPlainObject = require('lodash/isPlainObject');

({cloneAndMergeDeep} = require('./tools'));

AnsiPainter = require('./AnsiPainter');

Styles = require('./renderKid/Styles');

Layout = require('./Layout');

tools = require('./tools');

stripAnsi = require('strip-ansi');

terminalWidth = require('./tools').getCols();

module.exports = RenderKid = (function() {
  var self;

  class RenderKid {
    constructor(config = {}) {
      this.tools = self.tools;
      this._config = cloneAndMergeDeep(self._defaultConfig, config);
      this._initStyles();
    }

    _initStyles() {
      return this._styles = new Styles();
    }

    style() {
      return this._styles.setRule.apply(this._styles, arguments);
    }

    _getStyleFor(el) {
      return this._styles.getStyleFor(el);
    }

    render(input, withColors = true) {
      return this._paint(this._renderDom(this._toDom(input)), withColors);
    }

    _toDom(input) {
      if (typeof input === 'string') {
        return this._parse(input);
      } else if (isPlainObject(input) || Array.isArray(input)) {
        return this._objToDom(input);
      } else {
        throw Error("Invalid input type. Only strings, arrays and objects are accepted");
      }
    }

    _objToDom(o, injectFakeRoot = true) {
      if (injectFakeRoot) {
        o = {
          body: o
        };
      }
      return tools.objectToDom(o);
    }

    _paint(text, withColors) {
      var painted;
      painted = AnsiPainter.paint(text);
      if (withColors) {
        return painted;
      } else {
        return stripAnsi(painted);
      }
    }

    _parse(string, injectFakeRoot = true) {
      if (injectFakeRoot) {
        string = '<body>' + string + '</body>';
      }
      return tools.stringToDom(string);
    }

    _renderDom(dom) {
      var bodyTag, layout, rootBlock;
      bodyTag = dom[0];
      layout = new Layout(this._config.layout);
      rootBlock = layout.getRootBlock();
      this._renderBlockNode(bodyTag, null, rootBlock);
      return layout.get();
    }

    _renderChildrenOf(parentNode, parentBlock) {
      var i, len, node, nodes;
      nodes = parentNode.children;
      for (i = 0, len = nodes.length; i < len; i++) {
        node = nodes[i];
        this._renderNode(node, parentNode, parentBlock);
      }
    }

    _renderNode(node, parentNode, parentBlock) {
      if (node.type === 'text') {
        this._renderText(node, parentNode, parentBlock);
      } else if (node.name === 'br') {
        this._renderBr(node, parentNode, parentBlock);
      } else if (this._isBlock(node)) {
        this._renderBlockNode(node, parentNode, parentBlock);
      } else if (this._isNone(node)) {
        return;
      } else {
        this._renderInlineNode(node, parentNode, parentBlock);
      }
    }

    _renderText(node, parentNode, parentBlock) {
      var ref, text;
      text = node.data;
      text = text.replace(/\s+/g, ' ');
      // let's only trim if the parent is an inline element
      if ((parentNode != null ? (ref = parentNode.styles) != null ? ref.display : void 0 : void 0) !== 'inline') {
        text = text.trim();
      }
      if (text.length === 0) {
        return;
      }
      text = text.replace(/&nl;/g, "\n");
      return parentBlock.write(text);
    }

    _renderBlockNode(node, parentNode, parentBlock) {
      var after, before, block, blockConfig;
      ({before, after, blockConfig} = blockStyleApplier.applyTo(node, this._getStyleFor(node)));
      block = parentBlock.openBlock(blockConfig);
      if (before !== '') {
        block.write(before);
      }
      this._renderChildrenOf(node, block);
      if (after !== '') {
        block.write(after);
      }
      return block.close();
    }

    _renderInlineNode(node, parentNode, parentBlock) {
      var after, before;
      ({before, after} = inlineStyleApplier.applyTo(node, this._getStyleFor(node)));
      if (before !== '') {
        parentBlock.write(before);
      }
      this._renderChildrenOf(node, parentBlock);
      if (after !== '') {
        return parentBlock.write(after);
      }
    }

    _renderBr(node, parentNode, parentBlock) {
      return parentBlock.write("\n");
    }

    _isBlock(node) {
      return !(node.type === 'text' || node.name === 'br' || this._getStyleFor(node).display !== 'block');
    }

    _isNone(node) {
      return !(node.type === 'text' || node.name === 'br' || this._getStyleFor(node).display !== 'none');
    }

  };

  self = RenderKid;

  RenderKid.AnsiPainter = AnsiPainter;

  RenderKid.Layout = Layout;

  RenderKid.quote = tools.quote;

  RenderKid.tools = tools;

  RenderKid._defaultConfig = {
    layout: {
      terminalWidth: terminalWidth
    }
  };

  return RenderKid;

}).call(this);
