; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN:  sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v,+zfh,+xsfvcp \
; RUN:    -verify-machineinstrs | FileCheck %s
; RUN:  sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v,+zfh,+xsfvcp \
; RUN:    -verify-machineinstrs | FileCheck %s

define void @test_sf_vc_vv_se_e8mf8(<vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i8.nxv1i8.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i8.nxv1i8.iXLen(iXLen, iXLen, <vscale x 1 x i8>, <vscale x 1 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8mf4(<vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i8.nxv2i8.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i8.nxv2i8.iXLen(iXLen, iXLen, <vscale x 2 x i8>, <vscale x 2 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8mf2(<vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i8.nxv4i8.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i8.nxv4i8.iXLen(iXLen, iXLen, <vscale x 4 x i8>, <vscale x 4 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8m1(<vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i8.nxv8i8.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i8.nxv8i8.iXLen(iXLen, iXLen, <vscale x 8 x i8>, <vscale x 8 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8m2(<vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i8.nxv16i8.iXLen(iXLen 3, iXLen 31, <vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i8.nxv16i8.iXLen(iXLen, iXLen, <vscale x 16 x i8>, <vscale x 16 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8m4(<vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv32i8.nxv32i8.iXLen(iXLen 3, iXLen 31, <vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv32i8.nxv32i8.iXLen(iXLen, iXLen, <vscale x 32 x i8>, <vscale x 32 x i8>, iXLen)

define void @test_sf_vc_vv_se_e8m8(<vscale x 64 x i8> %vs2, <vscale x 64 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv64i8.nxv64i8.iXLen(iXLen 3, iXLen 31, <vscale x 64 x i8> %vs2, <vscale x 64 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv64i8.nxv64i8.iXLen(iXLen, iXLen, <vscale x 64 x i8>, <vscale x 64 x i8>, iXLen)

define void @test_sf_vc_vv_se_e16mf4(<vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i16.nxv1i16.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i16.nxv1i16.iXLen(iXLen, iXLen, <vscale x 1 x i16>, <vscale x 1 x i16>, iXLen)

define void @test_sf_vc_vv_se_e16mf2(<vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i16.nxv2i16.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i16.nxv2i16.iXLen(iXLen, iXLen, <vscale x 2 x i16>, <vscale x 2 x i16>, iXLen)

define void @test_sf_vc_vv_se_e16m1(<vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i16.nxv4i16.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i16.nxv4i16.iXLen(iXLen, iXLen, <vscale x 4 x i16>, <vscale x 4 x i16>, iXLen)

define void @test_sf_vc_vv_se_e16m2(<vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i16.nxv8i16.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i16.nxv8i16.iXLen(iXLen, iXLen, <vscale x 8 x i16>, <vscale x 8 x i16>, iXLen)

define void @test_sf_vc_vv_se_e16m4(<vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i16.nxv16i16.iXLen(iXLen 3, iXLen 31, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i16.nxv16i16.iXLen(iXLen, iXLen, <vscale x 16 x i16>, <vscale x 16 x i16>, iXLen)

define void @test_sf_vc_vv_se_e16m8(<vscale x 32 x i16> %vs2, <vscale x 32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv32i16.nxv32i16.iXLen(iXLen 3, iXLen 31, <vscale x 32 x i16> %vs2, <vscale x 32 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv32i16.nxv32i16.iXLen(iXLen, iXLen, <vscale x 32 x i16>, <vscale x 32 x i16>, iXLen)

define void @test_sf_vc_vv_se_e32mf2(<vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i32.nxv1i32.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i32.nxv1i32.iXLen(iXLen, iXLen, <vscale x 1 x i32>, <vscale x 1 x i32>, iXLen)

define void @test_sf_vc_vv_se_e32m1(<vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i32.nxv2i32.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i32.nxv2i32.iXLen(iXLen, iXLen, <vscale x 2 x i32>, <vscale x 2 x i32>, iXLen)

define void @test_sf_vc_vv_se_e32m2(<vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i32.nxv4i32.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i32.nxv4i32.iXLen(iXLen, iXLen, <vscale x 4 x i32>, <vscale x 4 x i32>, iXLen)

define void @test_sf_vc_vv_se_e32m4(<vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i32.nxv8i32.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i32.nxv8i32.iXLen(iXLen, iXLen, <vscale x 8 x i32>, <vscale x 8 x i32>, iXLen)

define void @test_sf_vc_vv_se_e32m8(<vscale x 16 x i32> %vs2, <vscale x 16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i32.nxv16i32.iXLen(iXLen 3, iXLen 31, <vscale x 16 x i32> %vs2, <vscale x 16 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv16i32.nxv16i32.iXLen(iXLen, iXLen, <vscale x 16 x i32>, <vscale x 16 x i32>, iXLen)

define void @test_sf_vc_vv_se_e64m1(<vscale x 1 x i64> %vs2, <vscale x 1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i64.nxv1i64.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i64> %vs2, <vscale x 1 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv1i64.nxv1i64.iXLen(iXLen, iXLen, <vscale x 1 x i64>, <vscale x 1 x i64>, iXLen)

define void @test_sf_vc_vv_se_e64m2(<vscale x 2 x i64> %vs2, <vscale x 2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i64.nxv2i64.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i64> %vs2, <vscale x 2 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv2i64.nxv2i64.iXLen(iXLen, iXLen, <vscale x 2 x i64>, <vscale x 2 x i64>, iXLen)

define void @test_sf_vc_vv_se_e64m4(<vscale x 4 x i64> %vs2, <vscale x 4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i64.nxv4i64.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i64> %vs2, <vscale x 4 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv4i64.nxv4i64.iXLen(iXLen, iXLen, <vscale x 4 x i64>, <vscale x 4 x i64>, iXLen)

define void @test_sf_vc_vv_se_e64m8(<vscale x 8 x i64> %vs2, <vscale x 8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    sf.vc.vv 3, 31, v8, v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i64.nxv8i64.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i64> %vs2, <vscale x 8 x i64> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vv.se.iXLen.nxv8i64.nxv8i64.iXLen(iXLen, iXLen, <vscale x 8 x i64>, <vscale x 8 x i64>, iXLen)

define <vscale x 1 x i8> @test_sf_vc_v_vv_se_e8mf8(<vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv1i8.iXLen.nxv1i8.iXLen(iXLen 3, <vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl)
  ret <vscale x 1 x i8> %0
}

declare <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv1i8.iXLen.nxv1i8.iXLen(iXLen, <vscale x 1 x i8>, <vscale x 1 x i8>, iXLen)

define <vscale x 2 x i8> @test_sf_vc_v_vv_se_e8mf4(<vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv2i8.iXLen.nxv2i8.iXLen(iXLen 3, <vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl)
  ret <vscale x 2 x i8> %0
}

declare <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv2i8.iXLen.nxv2i8.iXLen(iXLen, <vscale x 2 x i8>, <vscale x 2 x i8>, iXLen)

define <vscale x 4 x i8> @test_sf_vc_v_vv_se_e8mf2(<vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv4i8.iXLen.nxv4i8.iXLen(iXLen 3, <vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl)
  ret <vscale x 4 x i8> %0
}

declare <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv4i8.iXLen.nxv4i8.iXLen(iXLen, <vscale x 4 x i8>, <vscale x 4 x i8>, iXLen)

define <vscale x 8 x i8> @test_sf_vc_v_vv_se_e8m1(<vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv8i8.iXLen.nxv8i8.iXLen(iXLen 3, <vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl)
  ret <vscale x 8 x i8> %0
}

declare <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv8i8.iXLen.nxv8i8.iXLen(iXLen, <vscale x 8 x i8>, <vscale x 8 x i8>, iXLen)

define <vscale x 16 x i8> @test_sf_vc_v_vv_se_e8m2(<vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv16i8.iXLen.nxv16i8.iXLen(iXLen 3, <vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl)
  ret <vscale x 16 x i8> %0
}

declare <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv16i8.iXLen.nxv16i8.iXLen(iXLen, <vscale x 16 x i8>, <vscale x 16 x i8>, iXLen)

define <vscale x 32 x i8> @test_sf_vc_v_vv_se_e8m4(<vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv32i8.iXLen.nxv32i8.iXLen(iXLen 3, <vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl)
  ret <vscale x 32 x i8> %0
}

declare <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv32i8.iXLen.nxv32i8.iXLen(iXLen, <vscale x 32 x i8>, <vscale x 32 x i8>, iXLen)

define <vscale x 64 x i8> @test_sf_vc_v_vv_se_e8m8(<vscale x 64 x i8> %vs2, <vscale x 64 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv64i8.iXLen.nxv64i8.iXLen(iXLen 3, <vscale x 64 x i8> %vs2, <vscale x 64 x i8> %vs1, iXLen %vl)
  ret <vscale x 64 x i8> %0
}

declare <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vv.se.nxv64i8.iXLen.nxv64i8.iXLen(iXLen, <vscale x 64 x i8>, <vscale x 64 x i8>, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_vv_se_e16mf4(<vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv1i16.iXLen.nxv1i16.iXLen(iXLen 3, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv1i16.iXLen.nxv1i16.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i16>, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_vv_se_e16mf2(<vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv2i16.iXLen.nxv2i16.iXLen(iXLen 3, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv2i16.iXLen.nxv2i16.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i16>, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_vv_se_e16m1(<vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv4i16.iXLen.nxv4i16.iXLen(iXLen 3, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv4i16.iXLen.nxv4i16.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i16>, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_vv_se_e16m2(<vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv8i16.iXLen.nxv8i16.iXLen(iXLen 3, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv8i16.iXLen.nxv8i16.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i16>, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_vv_se_e16m4(<vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv16i16.iXLen.nxv16i16.iXLen(iXLen 3, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv16i16.iXLen.nxv16i16.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i16>, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_vv_se_e16m8(<vscale x 32 x i16> %vs2, <vscale x 32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv32i16.iXLen.nxv32i16.iXLen(iXLen 3, <vscale x 32 x i16> %vs2, <vscale x 32 x i16> %vs1, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vv.se.nxv32i16.iXLen.nxv32i16.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i16>, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_vv_se_e32mf2(<vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv1i32.iXLen.nxv1i32.iXLen(iXLen 3, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv1i32.iXLen.nxv1i32.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i32>, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_vv_se_e32m1(<vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv2i32.iXLen.nxv2i32.iXLen(iXLen 3, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv2i32.iXLen.nxv2i32.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i32>, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_vv_se_e32m2(<vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv4i32.iXLen.nxv4i32.iXLen(iXLen 3, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv4i32.iXLen.nxv4i32.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i32>, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_vv_se_e32m4(<vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv8i32.iXLen.nxv8i32.iXLen(iXLen 3, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv8i32.iXLen.nxv8i32.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i32>, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_vv_se_e32m8(<vscale x 16 x i32> %vs2, <vscale x 16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv16i32.iXLen.nxv16i32.iXLen(iXLen 3, <vscale x 16 x i32> %vs2, <vscale x 16 x i32> %vs1, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vv.se.nxv16i32.iXLen.nxv16i32.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i32>, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_vv_se_e64m1(<vscale x 1 x i64> %vs2, <vscale x 1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv1i64.iXLen.nxv1i64.iXLen(iXLen 3, <vscale x 1 x i64> %vs2, <vscale x 1 x i64> %vs1, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv1i64.iXLen.nxv1i64.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i64>, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_vv_se_e64m2(<vscale x 2 x i64> %vs2, <vscale x 2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv2i64.iXLen.nxv2i64.iXLen(iXLen 3, <vscale x 2 x i64> %vs2, <vscale x 2 x i64> %vs1, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv2i64.iXLen.nxv2i64.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i64>, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_vv_se_e64m4(<vscale x 4 x i64> %vs2, <vscale x 4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv4i64.iXLen.nxv4i64.iXLen(iXLen 3, <vscale x 4 x i64> %vs2, <vscale x 4 x i64> %vs1, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv4i64.iXLen.nxv4i64.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i64>, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_vv_se_e64m8(<vscale x 8 x i64> %vs2, <vscale x 8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv8i64.iXLen.nxv8i64.iXLen(iXLen 3, <vscale x 8 x i64> %vs2, <vscale x 8 x i64> %vs1, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vv.se.nxv8i64.iXLen.nxv8i64.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i64>, iXLen)

define <vscale x 1 x i8> @test_sf_vc_v_vv_e8mf8(<vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vv.nxv1i8.iXLen.nxv1i8.iXLen(iXLen 3, <vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl)
  ret <vscale x 1 x i8> %0
}

declare <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vv.nxv1i8.iXLen.nxv1i8.iXLen(iXLen, <vscale x 1 x i8>, <vscale x 1 x i8>, iXLen)

define <vscale x 2 x i8> @test_sf_vc_v_vv_e8mf4(<vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vv.nxv2i8.iXLen.nxv2i8.iXLen(iXLen 3, <vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl)
  ret <vscale x 2 x i8> %0
}

declare <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vv.nxv2i8.iXLen.nxv2i8.iXLen(iXLen, <vscale x 2 x i8>, <vscale x 2 x i8>, iXLen)

define <vscale x 4 x i8> @test_sf_vc_v_vv_e8mf2(<vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vv.nxv4i8.iXLen.nxv4i8.iXLen(iXLen 3, <vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl)
  ret <vscale x 4 x i8> %0
}

declare <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vv.nxv4i8.iXLen.nxv4i8.iXLen(iXLen, <vscale x 4 x i8>, <vscale x 4 x i8>, iXLen)

define <vscale x 8 x i8> @test_sf_vc_v_vv_e8m1(<vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vv.nxv8i8.iXLen.nxv8i8.iXLen(iXLen 3, <vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl)
  ret <vscale x 8 x i8> %0
}

declare <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vv.nxv8i8.iXLen.nxv8i8.iXLen(iXLen, <vscale x 8 x i8>, <vscale x 8 x i8>, iXLen)

define <vscale x 16 x i8> @test_sf_vc_v_vv_e8m2(<vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vv.nxv16i8.iXLen.nxv16i8.iXLen(iXLen 3, <vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl)
  ret <vscale x 16 x i8> %0
}

declare <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vv.nxv16i8.iXLen.nxv16i8.iXLen(iXLen, <vscale x 16 x i8>, <vscale x 16 x i8>, iXLen)

define <vscale x 32 x i8> @test_sf_vc_v_vv_e8m4(<vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vv.nxv32i8.iXLen.nxv32i8.iXLen(iXLen 3, <vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl)
  ret <vscale x 32 x i8> %0
}

declare <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vv.nxv32i8.iXLen.nxv32i8.iXLen(iXLen, <vscale x 32 x i8>, <vscale x 32 x i8>, iXLen)

define <vscale x 64 x i8> @test_sf_vc_v_vv_e8m8(<vscale x 64 x i8> %vs2, <vscale x 64 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vv.nxv64i8.iXLen.nxv64i8.iXLen(iXLen 3, <vscale x 64 x i8> %vs2, <vscale x 64 x i8> %vs1, iXLen %vl)
  ret <vscale x 64 x i8> %0
}

declare <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vv.nxv64i8.iXLen.nxv64i8.iXLen(iXLen, <vscale x 64 x i8>, <vscale x 64 x i8>, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_vv_e16mf4(<vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vv.nxv1i16.iXLen.nxv1i16.iXLen(iXLen 3, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vv.nxv1i16.iXLen.nxv1i16.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i16>, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_vv_e16mf2(<vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vv.nxv2i16.iXLen.nxv2i16.iXLen(iXLen 3, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vv.nxv2i16.iXLen.nxv2i16.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i16>, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_vv_e16m1(<vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vv.nxv4i16.iXLen.nxv4i16.iXLen(iXLen 3, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vv.nxv4i16.iXLen.nxv4i16.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i16>, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_vv_e16m2(<vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vv.nxv8i16.iXLen.nxv8i16.iXLen(iXLen 3, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vv.nxv8i16.iXLen.nxv8i16.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i16>, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_vv_e16m4(<vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vv.nxv16i16.iXLen.nxv16i16.iXLen(iXLen 3, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vv.nxv16i16.iXLen.nxv16i16.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i16>, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_vv_e16m8(<vscale x 32 x i16> %vs2, <vscale x 32 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vv.nxv32i16.iXLen.nxv32i16.iXLen(iXLen 3, <vscale x 32 x i16> %vs2, <vscale x 32 x i16> %vs1, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vv.nxv32i16.iXLen.nxv32i16.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i16>, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_vv_e32mf2(<vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vv.nxv1i32.iXLen.nxv1i32.iXLen(iXLen 3, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vv.nxv1i32.iXLen.nxv1i32.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i32>, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_vv_e32m1(<vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vv.nxv2i32.iXLen.nxv2i32.iXLen(iXLen 3, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vv.nxv2i32.iXLen.nxv2i32.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i32>, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_vv_e32m2(<vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vv.nxv4i32.iXLen.nxv4i32.iXLen(iXLen 3, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vv.nxv4i32.iXLen.nxv4i32.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i32>, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_vv_e32m4(<vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vv.nxv8i32.iXLen.nxv8i32.iXLen(iXLen 3, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vv.nxv8i32.iXLen.nxv8i32.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i32>, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_vv_e32m8(<vscale x 16 x i32> %vs2, <vscale x 16 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vv.nxv16i32.iXLen.nxv16i32.iXLen(iXLen 3, <vscale x 16 x i32> %vs2, <vscale x 16 x i32> %vs1, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vv.nxv16i32.iXLen.nxv16i32.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i32>, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_vv_e64m1(<vscale x 1 x i64> %vs2, <vscale x 1 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vv.nxv1i64.iXLen.nxv1i64.iXLen(iXLen 3, <vscale x 1 x i64> %vs2, <vscale x 1 x i64> %vs1, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vv.nxv1i64.iXLen.nxv1i64.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i64>, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_vv_e64m2(<vscale x 2 x i64> %vs2, <vscale x 2 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vv.nxv2i64.iXLen.nxv2i64.iXLen(iXLen 3, <vscale x 2 x i64> %vs2, <vscale x 2 x i64> %vs1, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vv.nxv2i64.iXLen.nxv2i64.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i64>, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_vv_e64m4(<vscale x 4 x i64> %vs2, <vscale x 4 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vv.nxv4i64.iXLen.nxv4i64.iXLen(iXLen 3, <vscale x 4 x i64> %vs2, <vscale x 4 x i64> %vs1, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vv.nxv4i64.iXLen.nxv4i64.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i64>, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_vv_e64m8(<vscale x 8 x i64> %vs2, <vscale x 8 x i64> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vv_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.vv 3, v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vv.nxv8i64.iXLen.nxv8i64.iXLen(iXLen 3, <vscale x 8 x i64> %vs2, <vscale x 8 x i64> %vs1, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vv.nxv8i64.iXLen.nxv8i64.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i64>, iXLen)

define void @test_sf_vc_xv_se_e8mf8(<vscale x 1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i8.i8.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i8.i8.iXLen(iXLen, iXLen, <vscale x 1 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8mf4(<vscale x 2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i8.i8.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i8.i8.iXLen(iXLen, iXLen, <vscale x 2 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8mf2(<vscale x 4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i8.i8.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i8.i8.iXLen(iXLen, iXLen, <vscale x 4 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8m1(<vscale x 8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i8.i8.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i8.i8.iXLen(iXLen, iXLen, <vscale x 8 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8m2(<vscale x 16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i8.i8.iXLen(iXLen 3, iXLen 31, <vscale x 16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i8.i8.iXLen(iXLen, iXLen, <vscale x 16 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8m4(<vscale x 32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv32i8.i8.iXLen(iXLen 3, iXLen 31, <vscale x 32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv32i8.i8.iXLen(iXLen, iXLen, <vscale x 32 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e8m8(<vscale x 64 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv64i8.i8.iXLen(iXLen 3, iXLen 31, <vscale x 64 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv64i8.i8.iXLen(iXLen, iXLen, <vscale x 64 x i8>, i8, iXLen)

define void @test_sf_vc_xv_se_e16mf4(<vscale x 1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i16.i16.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i16.i16.iXLen(iXLen, iXLen, <vscale x 1 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e16mf2(<vscale x 2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i16.i16.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i16.i16.iXLen(iXLen, iXLen, <vscale x 2 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e16m1(<vscale x 4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i16.i16.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i16.i16.iXLen(iXLen, iXLen, <vscale x 4 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e16m2(<vscale x 8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i16.i16.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i16.i16.iXLen(iXLen, iXLen, <vscale x 8 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e16m4(<vscale x 16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i16.i16.iXLen(iXLen 3, iXLen 31, <vscale x 16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i16.i16.iXLen(iXLen, iXLen, <vscale x 16 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e16m8(<vscale x 32 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv32i16.i16.iXLen(iXLen 3, iXLen 31, <vscale x 32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv32i16.i16.iXLen(iXLen, iXLen, <vscale x 32 x i16>, i16, iXLen)

define void @test_sf_vc_xv_se_e32mf2(<vscale x 1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i32.i32.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv1i32.i32.iXLen(iXLen, iXLen, <vscale x 1 x i32>, i32, iXLen)

define void @test_sf_vc_xv_se_e32m1(<vscale x 2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i32.i32.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv2i32.i32.iXLen(iXLen, iXLen, <vscale x 2 x i32>, i32, iXLen)

define void @test_sf_vc_xv_se_e32m2(<vscale x 4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i32.i32.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv4i32.i32.iXLen(iXLen, iXLen, <vscale x 4 x i32>, i32, iXLen)

define void @test_sf_vc_xv_se_e32m4(<vscale x 8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i32.i32.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv8i32.i32.iXLen(iXLen, iXLen, <vscale x 8 x i32>, i32, iXLen)

define void @test_sf_vc_xv_se_e32m8(<vscale x 16 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.xv 3, 31, v8, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i32.i32.iXLen(iXLen 3, iXLen 31, <vscale x 16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xv.se.iXLen.nxv16i32.i32.iXLen(iXLen, iXLen, <vscale x 16 x i32>, i32, iXLen)

define <vscale x 1 x i8> @test_sf_vc_v_xv_se_e8mf8(<vscale x 1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv1i8.iXLen.i8.iXLen(iXLen 3, <vscale x 1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 1 x i8> %0
}

declare <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv1i8.iXLen.i8.iXLen(iXLen, <vscale x 1 x i8>, i8, iXLen)

define <vscale x 2 x i8> @test_sf_vc_v_xv_se_e8mf4(<vscale x 2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv2i8.iXLen.i8.iXLen(iXLen 3, <vscale x 2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 2 x i8> %0
}

declare <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv2i8.iXLen.i8.iXLen(iXLen, <vscale x 2 x i8>, i8, iXLen)

define <vscale x 4 x i8> @test_sf_vc_v_xv_se_e8mf2(<vscale x 4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv4i8.iXLen.i8.iXLen(iXLen 3, <vscale x 4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 4 x i8> %0
}

declare <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv4i8.iXLen.i8.iXLen(iXLen, <vscale x 4 x i8>, i8, iXLen)

define <vscale x 8 x i8> @test_sf_vc_v_xv_se_e8m1(<vscale x 8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv8i8.iXLen.i8.iXLen(iXLen 3, <vscale x 8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 8 x i8> %0
}

declare <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv8i8.iXLen.i8.iXLen(iXLen, <vscale x 8 x i8>, i8, iXLen)

define <vscale x 16 x i8> @test_sf_vc_v_xv_se_e8m2(<vscale x 16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv16i8.iXLen.i8.iXLen(iXLen 3, <vscale x 16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 16 x i8> %0
}

declare <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv16i8.iXLen.i8.iXLen(iXLen, <vscale x 16 x i8>, i8, iXLen)

define <vscale x 32 x i8> @test_sf_vc_v_xv_se_e8m4(<vscale x 32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv32i8.iXLen.i8.iXLen(iXLen 3, <vscale x 32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 32 x i8> %0
}

declare <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv32i8.iXLen.i8.iXLen(iXLen, <vscale x 32 x i8>, i8, iXLen)

define <vscale x 64 x i8> @test_sf_vc_v_xv_se_e8m8(<vscale x 64 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv64i8.iXLen.i8.iXLen(iXLen 3, <vscale x 64 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 64 x i8> %0
}

declare <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xv.se.nxv64i8.iXLen.i8.iXLen(iXLen, <vscale x 64 x i8>, i8, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_xv_se_e16mf4(<vscale x 1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv1i16.iXLen.i16.iXLen(iXLen 3, <vscale x 1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv1i16.iXLen.i16.iXLen(iXLen, <vscale x 1 x i16>, i16, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_xv_se_e16mf2(<vscale x 2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv2i16.iXLen.i16.iXLen(iXLen 3, <vscale x 2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv2i16.iXLen.i16.iXLen(iXLen, <vscale x 2 x i16>, i16, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_xv_se_e16m1(<vscale x 4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv4i16.iXLen.i16.iXLen(iXLen 3, <vscale x 4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv4i16.iXLen.i16.iXLen(iXLen, <vscale x 4 x i16>, i16, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_xv_se_e16m2(<vscale x 8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv8i16.iXLen.i16.iXLen(iXLen 3, <vscale x 8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv8i16.iXLen.i16.iXLen(iXLen, <vscale x 8 x i16>, i16, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_xv_se_e16m4(<vscale x 16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv16i16.iXLen.i16.iXLen(iXLen 3, <vscale x 16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv16i16.iXLen.i16.iXLen(iXLen, <vscale x 16 x i16>, i16, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_xv_se_e16m8(<vscale x 32 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv32i16.iXLen.i16.iXLen(iXLen 3, <vscale x 32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xv.se.nxv32i16.iXLen.i16.iXLen(iXLen, <vscale x 32 x i16>, i16, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_xv_se_e32mf2(<vscale x 1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv1i32.i32.i32.iXLen(iXLen 3, <vscale x 1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv1i32.i32.i32.iXLen(iXLen, <vscale x 1 x i32>, i32, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_xv_se_e32m1(<vscale x 2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv2i32.i32.i32.iXLen(iXLen 3, <vscale x 2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv2i32.i32.i32.iXLen(iXLen, <vscale x 2 x i32>, i32, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_xv_se_e32m2(<vscale x 4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv4i32.i32.i32.iXLen(iXLen 3, <vscale x 4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv4i32.i32.i32.iXLen(iXLen, <vscale x 4 x i32>, i32, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_xv_se_e32m4(<vscale x 8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv8i32.i32.i32.iXLen(iXLen 3, <vscale x 8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv8i32.i32.i32.iXLen(iXLen, <vscale x 8 x i32>, i32, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_xv_se_e32m8(<vscale x 16 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv16i32.i32.i32.iXLen(iXLen 3, <vscale x 16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xv.se.nxv16i32.i32.i32.iXLen(iXLen, <vscale x 16 x i32>, i32, iXLen)

define <vscale x 1 x i8> @test_sf_vc_v_xv_e8mf8(<vscale x 1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xv.nxv1i8.iXLen.i8.iXLen(iXLen 3, <vscale x 1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 1 x i8> %0
}

declare <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xv.nxv1i8.iXLen.i8.iXLen(iXLen, <vscale x 1 x i8>, i8, iXLen)

define <vscale x 2 x i8> @test_sf_vc_v_xv_e8mf4(<vscale x 2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xv.nxv2i8.iXLen.i8.iXLen(iXLen 3, <vscale x 2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 2 x i8> %0
}

declare <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xv.nxv2i8.iXLen.i8.iXLen(iXLen, <vscale x 2 x i8>, i8, iXLen)

define <vscale x 4 x i8> @test_sf_vc_v_xv_e8mf2(<vscale x 4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xv.nxv4i8.iXLen.i8.iXLen(iXLen 3, <vscale x 4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 4 x i8> %0
}

declare <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xv.nxv4i8.iXLen.i8.iXLen(iXLen, <vscale x 4 x i8>, i8, iXLen)

define <vscale x 8 x i8> @test_sf_vc_v_xv_e8m1(<vscale x 8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xv.nxv8i8.iXLen.i8.iXLen(iXLen 3, <vscale x 8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 8 x i8> %0
}

declare <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xv.nxv8i8.iXLen.i8.iXLen(iXLen, <vscale x 8 x i8>, i8, iXLen)

define <vscale x 16 x i8> @test_sf_vc_v_xv_e8m2(<vscale x 16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xv.nxv16i8.iXLen.i8.iXLen(iXLen 3, <vscale x 16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 16 x i8> %0
}

declare <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xv.nxv16i8.iXLen.i8.iXLen(iXLen, <vscale x 16 x i8>, i8, iXLen)

define <vscale x 32 x i8> @test_sf_vc_v_xv_e8m4(<vscale x 32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xv.nxv32i8.iXLen.i8.iXLen(iXLen 3, <vscale x 32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 32 x i8> %0
}

declare <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xv.nxv32i8.iXLen.i8.iXLen(iXLen, <vscale x 32 x i8>, i8, iXLen)

define <vscale x 64 x i8> @test_sf_vc_v_xv_e8m8(<vscale x 64 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xv.nxv64i8.iXLen.i8.iXLen(iXLen 3, <vscale x 64 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 64 x i8> %0
}

declare <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xv.nxv64i8.iXLen.i8.iXLen(iXLen, <vscale x 64 x i8>, i8, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_xv_e16mf4(<vscale x 1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xv.nxv1i16.iXLen.i16.iXLen(iXLen 3, <vscale x 1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xv.nxv1i16.iXLen.i16.iXLen(iXLen, <vscale x 1 x i16>, i16, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_xv_e16mf2(<vscale x 2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xv.nxv2i16.iXLen.i16.iXLen(iXLen 3, <vscale x 2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xv.nxv2i16.iXLen.i16.iXLen(iXLen, <vscale x 2 x i16>, i16, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_xv_e16m1(<vscale x 4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xv.nxv4i16.iXLen.i16.iXLen(iXLen 3, <vscale x 4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xv.nxv4i16.iXLen.i16.iXLen(iXLen, <vscale x 4 x i16>, i16, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_xv_e16m2(<vscale x 8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xv.nxv8i16.iXLen.i16.iXLen(iXLen 3, <vscale x 8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xv.nxv8i16.iXLen.i16.iXLen(iXLen, <vscale x 8 x i16>, i16, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_xv_e16m4(<vscale x 16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xv.nxv16i16.iXLen.i16.iXLen(iXLen 3, <vscale x 16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xv.nxv16i16.iXLen.i16.iXLen(iXLen, <vscale x 16 x i16>, i16, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_xv_e16m8(<vscale x 32 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xv.nxv32i16.iXLen.i16.iXLen(iXLen 3, <vscale x 32 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xv.nxv32i16.iXLen.i16.iXLen(iXLen, <vscale x 32 x i16>, i16, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_xv_e32mf2(<vscale x 1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xv.nxv1i32.i32.i32.iXLen(iXLen 3, <vscale x 1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xv.nxv1i32.i32.i32.iXLen(iXLen, <vscale x 1 x i32>, i32, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_xv_e32m1(<vscale x 2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xv.nxv2i32.i32.i32.iXLen(iXLen 3, <vscale x 2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xv.nxv2i32.i32.i32.iXLen(iXLen, <vscale x 2 x i32>, i32, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_xv_e32m2(<vscale x 4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xv.nxv4i32.i32.i32.iXLen(iXLen 3, <vscale x 4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xv.nxv4i32.i32.i32.iXLen(iXLen, <vscale x 4 x i32>, i32, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_xv_e32m4(<vscale x 8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xv.nxv8i32.i32.i32.iXLen(iXLen 3, <vscale x 8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xv.nxv8i32.i32.i32.iXLen(iXLen, <vscale x 8 x i32>, i32, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_xv_e32m8(<vscale x 16 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xv_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.xv 3, v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xv.nxv16i32.i32.i32.iXLen(iXLen 3, <vscale x 16 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xv.nxv16i32.i32.i32.iXLen(iXLen, <vscale x 16 x i32>, i32, iXLen)

define void @test_sf_vc_iv_se_e8mf8(<vscale x 1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i8.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i8.iXLen.iXLen(iXLen, iXLen, <vscale x 1 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8mf4(<vscale x 2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i8.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i8.iXLen.iXLen(iXLen, iXLen, <vscale x 2 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8mf2(<vscale x 4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i8.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i8.iXLen.iXLen(iXLen, iXLen, <vscale x 4 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8m1(<vscale x 8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i8.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i8.iXLen.iXLen(iXLen, iXLen, <vscale x 8 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8m2(<vscale x 16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i8.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i8.iXLen.iXLen(iXLen, iXLen, <vscale x 16 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8m4(<vscale x 32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv32i8.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv32i8.iXLen.iXLen(iXLen, iXLen, <vscale x 32 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e8m8(<vscale x 64 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv64i8.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 64 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv64i8.iXLen.iXLen(iXLen, iXLen, <vscale x 64 x i8>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16mf4(<vscale x 1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i16.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i16.iXLen.iXLen(iXLen, iXLen, <vscale x 1 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16mf2(<vscale x 2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i16.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i16.iXLen.iXLen(iXLen, iXLen, <vscale x 2 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16m1(<vscale x 4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i16.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i16.iXLen.iXLen(iXLen, iXLen, <vscale x 4 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16m2(<vscale x 8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i16.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i16.iXLen.iXLen(iXLen, iXLen, <vscale x 8 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16m4(<vscale x 16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i16.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i16.iXLen.iXLen(iXLen, iXLen, <vscale x 16 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e16m8(<vscale x 32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv32i16.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 32 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv32i16.iXLen.iXLen(iXLen, iXLen, <vscale x 32 x i16>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e32mf2(<vscale x 1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i32.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i32.iXLen.iXLen(iXLen, iXLen, <vscale x 1 x i32>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e32m1(<vscale x 2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i32.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i32.iXLen.iXLen(iXLen, iXLen, <vscale x 2 x i32>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e32m2(<vscale x 4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i32.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i32.iXLen.iXLen(iXLen, iXLen, <vscale x 4 x i32>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e32m4(<vscale x 8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i32.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i32.iXLen.iXLen(iXLen, iXLen, <vscale x 8 x i32>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e32m8(<vscale x 16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i32.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 16 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv16i32.iXLen.iXLen(iXLen, iXLen, <vscale x 16 x i32>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e64m1(<vscale x 1 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i64.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 1 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv1i64.iXLen.iXLen(iXLen, iXLen, <vscale x 1 x i64>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e64m2(<vscale x 2 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i64.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 2 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv2i64.iXLen.iXLen(iXLen, iXLen, <vscale x 2 x i64>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e64m4(<vscale x 4 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i64.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 4 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv4i64.iXLen.iXLen(iXLen, iXLen, <vscale x 4 x i64>, iXLen, iXLen)

define void @test_sf_vc_iv_se_e64m8(<vscale x 8 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_iv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    sf.vc.iv 3, 31, v8, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i64.iXLen.iXLen(iXLen 3, iXLen 31, <vscale x 8 x i64> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.iv.se.iXLen.nxv8i64.iXLen.iXLen(iXLen, iXLen, <vscale x 8 x i64>, iXLen, iXLen)

define <vscale x 1 x i8> @test_sf_vc_v_iv_se_e8mf8(<vscale x 1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv1i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i8> %0
}

declare <vscale x 1 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv1i8.iXLen.iXLen.iXLen(iXLen, <vscale x 1 x i8>, iXLen, iXLen)

define <vscale x 2 x i8> @test_sf_vc_v_iv_se_e8mf4(<vscale x 2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv2i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i8> %0
}

declare <vscale x 2 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv2i8.iXLen.iXLen.iXLen(iXLen, <vscale x 2 x i8>, iXLen, iXLen)

define <vscale x 4 x i8> @test_sf_vc_v_iv_se_e8mf2(<vscale x 4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv4i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i8> %0
}

declare <vscale x 4 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv4i8.iXLen.iXLen.iXLen(iXLen, <vscale x 4 x i8>, iXLen, iXLen)

define <vscale x 8 x i8> @test_sf_vc_v_iv_se_e8m1(<vscale x 8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv8i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i8> %0
}

declare <vscale x 8 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv8i8.iXLen.iXLen.iXLen(iXLen, <vscale x 8 x i8>, iXLen, iXLen)

define <vscale x 16 x i8> @test_sf_vc_v_iv_se_e8m2(<vscale x 16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv16i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 16 x i8> %0
}

declare <vscale x 16 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv16i8.iXLen.iXLen.iXLen(iXLen, <vscale x 16 x i8>, iXLen, iXLen)

define <vscale x 32 x i8> @test_sf_vc_v_iv_se_e8m4(<vscale x 32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv32i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 32 x i8> %0
}

declare <vscale x 32 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv32i8.iXLen.iXLen.iXLen(iXLen, <vscale x 32 x i8>, iXLen, iXLen)

define <vscale x 64 x i8> @test_sf_vc_v_iv_se_e8m8(<vscale x 64 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv64i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 64 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 64 x i8> %0
}

declare <vscale x 64 x i8> @llvm.riscv.sf.vc.v.iv.se.nxv64i8.iXLen.iXLen.iXLen(iXLen, <vscale x 64 x i8>, iXLen, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_iv_se_e16mf4(<vscale x 1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv1i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv1i16.iXLen.iXLen.iXLen(iXLen, <vscale x 1 x i16>, iXLen, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_iv_se_e16mf2(<vscale x 2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv2i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv2i16.iXLen.iXLen.iXLen(iXLen, <vscale x 2 x i16>, iXLen, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_iv_se_e16m1(<vscale x 4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv4i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv4i16.iXLen.iXLen.iXLen(iXLen, <vscale x 4 x i16>, iXLen, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_iv_se_e16m2(<vscale x 8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv8i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv8i16.iXLen.iXLen.iXLen(iXLen, <vscale x 8 x i16>, iXLen, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_iv_se_e16m4(<vscale x 16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv16i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv16i16.iXLen.iXLen.iXLen(iXLen, <vscale x 16 x i16>, iXLen, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_iv_se_e16m8(<vscale x 32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv32i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 32 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.iv.se.nxv32i16.iXLen.iXLen.iXLen(iXLen, <vscale x 32 x i16>, iXLen, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_iv_se_e32mf2(<vscale x 1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv1i32.iXLen.iXLen.iXLen(iXLen 3, <vscale x 1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv1i32.iXLen.iXLen.iXLen(iXLen, <vscale x 1 x i32>, iXLen, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_iv_se_e32m1(<vscale x 2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv2i32.iXLen.iXLen.iXLen(iXLen 3, <vscale x 2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv2i32.iXLen.iXLen.iXLen(iXLen, <vscale x 2 x i32>, iXLen, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_iv_se_e32m2(<vscale x 4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv4i32.iXLen.iXLen.iXLen(iXLen 3, <vscale x 4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv4i32.iXLen.iXLen.iXLen(iXLen, <vscale x 4 x i32>, iXLen, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_iv_se_e32m4(<vscale x 8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv8i32.iXLen.iXLen.iXLen(iXLen 3, <vscale x 8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv8i32.iXLen.iXLen.iXLen(iXLen, <vscale x 8 x i32>, iXLen, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_iv_se_e32m8(<vscale x 16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv16i32.iXLen.iXLen.iXLen(iXLen 3, <vscale x 16 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.iv.se.nxv16i32.iXLen.iXLen.iXLen(iXLen, <vscale x 16 x i32>, iXLen, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_iv_se_e64m1(<vscale x 1 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv1i64.iXLen.iXLen.iXLen(iXLen 3, <vscale x 1 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv1i64.iXLen.iXLen.iXLen(iXLen, <vscale x 1 x i64>, iXLen, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_iv_se_e64m2(<vscale x 2 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv2i64.iXLen.iXLen.iXLen(iXLen 3, <vscale x 2 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv2i64.iXLen.iXLen.iXLen(iXLen, <vscale x 2 x i64>, iXLen, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_iv_se_e64m4(<vscale x 4 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv4i64.iXLen.iXLen.iXLen(iXLen 3, <vscale x 4 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv4i64.iXLen.iXLen.iXLen(iXLen, <vscale x 4 x i64>, iXLen, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_iv_se_e64m8(<vscale x 8 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv8i64.iXLen.iXLen.iXLen(iXLen 3, <vscale x 8 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.iv.se.nxv8i64.iXLen.iXLen.iXLen(iXLen, <vscale x 8 x i64>, iXLen, iXLen)

define <vscale x 1 x i8> @test_sf_vc_v_iv_e8mf8(<vscale x 1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.iv.nxv1i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i8> %0
}

declare <vscale x 1 x i8> @llvm.riscv.sf.vc.v.iv.nxv1i8.iXLen.iXLen.iXLen(iXLen, <vscale x 1 x i8>, iXLen, iXLen)

define <vscale x 2 x i8> @test_sf_vc_v_iv_e8mf4(<vscale x 2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.iv.nxv2i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i8> %0
}

declare <vscale x 2 x i8> @llvm.riscv.sf.vc.v.iv.nxv2i8.iXLen.iXLen.iXLen(iXLen, <vscale x 2 x i8>, iXLen, iXLen)

define <vscale x 4 x i8> @test_sf_vc_v_iv_e8mf2(<vscale x 4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.iv.nxv4i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i8> %0
}

declare <vscale x 4 x i8> @llvm.riscv.sf.vc.v.iv.nxv4i8.iXLen.iXLen.iXLen(iXLen, <vscale x 4 x i8>, iXLen, iXLen)

define <vscale x 8 x i8> @test_sf_vc_v_iv_e8m1(<vscale x 8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.iv.nxv8i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i8> %0
}

declare <vscale x 8 x i8> @llvm.riscv.sf.vc.v.iv.nxv8i8.iXLen.iXLen.iXLen(iXLen, <vscale x 8 x i8>, iXLen, iXLen)

define <vscale x 16 x i8> @test_sf_vc_v_iv_e8m2(<vscale x 16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.iv.nxv16i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 16 x i8> %0
}

declare <vscale x 16 x i8> @llvm.riscv.sf.vc.v.iv.nxv16i8.iXLen.iXLen.iXLen(iXLen, <vscale x 16 x i8>, iXLen, iXLen)

define <vscale x 32 x i8> @test_sf_vc_v_iv_e8m4(<vscale x 32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.iv.nxv32i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 32 x i8> %0
}

declare <vscale x 32 x i8> @llvm.riscv.sf.vc.v.iv.nxv32i8.iXLen.iXLen.iXLen(iXLen, <vscale x 32 x i8>, iXLen, iXLen)

define <vscale x 64 x i8> @test_sf_vc_v_iv_e8m8(<vscale x 64 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.iv.nxv64i8.iXLen.iXLen.iXLen(iXLen 3, <vscale x 64 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 64 x i8> %0
}

declare <vscale x 64 x i8> @llvm.riscv.sf.vc.v.iv.nxv64i8.iXLen.iXLen.iXLen(iXLen, <vscale x 64 x i8>, iXLen, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_iv_e16mf4(<vscale x 1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.iv.nxv1i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.iv.nxv1i16.iXLen.iXLen.iXLen(iXLen, <vscale x 1 x i16>, iXLen, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_iv_e16mf2(<vscale x 2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.iv.nxv2i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.iv.nxv2i16.iXLen.iXLen.iXLen(iXLen, <vscale x 2 x i16>, iXLen, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_iv_e16m1(<vscale x 4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.iv.nxv4i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.iv.nxv4i16.iXLen.iXLen.iXLen(iXLen, <vscale x 4 x i16>, iXLen, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_iv_e16m2(<vscale x 8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.iv.nxv8i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.iv.nxv8i16.iXLen.iXLen.iXLen(iXLen, <vscale x 8 x i16>, iXLen, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_iv_e16m4(<vscale x 16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.iv.nxv16i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.iv.nxv16i16.iXLen.iXLen.iXLen(iXLen, <vscale x 16 x i16>, iXLen, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_iv_e16m8(<vscale x 32 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.iv.nxv32i16.iXLen.iXLen.iXLen(iXLen 3, <vscale x 32 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.iv.nxv32i16.iXLen.iXLen.iXLen(iXLen, <vscale x 32 x i16>, iXLen, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_iv_e32mf2(<vscale x 1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.iv.nxv1i32.iXLen.iXLen.iXLen(iXLen 3, <vscale x 1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.iv.nxv1i32.iXLen.iXLen.iXLen(iXLen, <vscale x 1 x i32>, iXLen, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_iv_e32m1(<vscale x 2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.iv.nxv2i32.iXLen.iXLen.iXLen(iXLen 3, <vscale x 2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.iv.nxv2i32.iXLen.iXLen.iXLen(iXLen, <vscale x 2 x i32>, iXLen, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_iv_e32m2(<vscale x 4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.iv.nxv4i32.iXLen.iXLen.iXLen(iXLen 3, <vscale x 4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.iv.nxv4i32.iXLen.iXLen.iXLen(iXLen, <vscale x 4 x i32>, iXLen, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_iv_e32m4(<vscale x 8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.iv.nxv8i32.iXLen.iXLen.iXLen(iXLen 3, <vscale x 8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.iv.nxv8i32.iXLen.iXLen.iXLen(iXLen, <vscale x 8 x i32>, iXLen, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_iv_e32m8(<vscale x 16 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.iv.nxv16i32.iXLen.iXLen.iXLen(iXLen 3, <vscale x 16 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.iv.nxv16i32.iXLen.iXLen.iXLen(iXLen, <vscale x 16 x i32>, iXLen, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_iv_e64m1(<vscale x 1 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.iv.nxv1i64.iXLen.iXLen.iXLen(iXLen 3, <vscale x 1 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.iv.nxv1i64.iXLen.iXLen.iXLen(iXLen, <vscale x 1 x i64>, iXLen, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_iv_e64m2(<vscale x 2 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.iv.nxv2i64.iXLen.iXLen.iXLen(iXLen 3, <vscale x 2 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.iv.nxv2i64.iXLen.iXLen.iXLen(iXLen, <vscale x 2 x i64>, iXLen, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_iv_e64m4(<vscale x 4 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.iv.nxv4i64.iXLen.iXLen.iXLen(iXLen 3, <vscale x 4 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.iv.nxv4i64.iXLen.iXLen.iXLen(iXLen, <vscale x 4 x i64>, iXLen, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_iv_e64m8(<vscale x 8 x i64> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_iv_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.iv 3, v8, v8, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.iv.nxv8i64.iXLen.iXLen.iXLen(iXLen 3, <vscale x 8 x i64> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.iv.nxv8i64.iXLen.iXLen.iXLen(iXLen, <vscale x 8 x i64>, iXLen, iXLen)

define void @test_sf_vc_fv_se_e16mf4(<vscale x 1 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv1i16.f16.iXLen(iXLen 1, iXLen 31, <vscale x 1 x i16> %vs2, half %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv1i16.f16.iXLen(iXLen, iXLen, <vscale x 1 x i16>, half, iXLen)

define void @test_sf_vc_fv_se_e16mf2(<vscale x 2 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv2i16.f16.iXLen(iXLen 1, iXLen 31, <vscale x 2 x i16> %vs2, half %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv2i16.f16.iXLen(iXLen, iXLen, <vscale x 2 x i16>, half, iXLen)

define void @test_sf_vc_fv_se_e16m1(<vscale x 4 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv4i16.f16.iXLen(iXLen 1, iXLen 31, <vscale x 4 x i16> %vs2, half %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv4i16.f16.iXLen(iXLen, iXLen, <vscale x 4 x i16>, half, iXLen)

define void @test_sf_vc_fv_se_e16m2(<vscale x 8 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv8i16.f16.iXLen(iXLen 1, iXLen 31, <vscale x 8 x i16> %vs2, half %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv8i16.f16.iXLen(iXLen, iXLen, <vscale x 8 x i16>, half, iXLen)

define void @test_sf_vc_fv_se_e16m4(<vscale x 16 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv16i16.f16.iXLen(iXLen 1, iXLen 31, <vscale x 16 x i16> %vs2, half %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv16i16.f16.iXLen(iXLen, iXLen, <vscale x 16 x i16>, half, iXLen)

define void @test_sf_vc_fv_se_e16m8(<vscale x 32 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv32i16.f16.iXLen(iXLen 1, iXLen 31, <vscale x 32 x i16> %vs2, half %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv32i16.f16.iXLen(iXLen, iXLen, <vscale x 32 x i16>, half, iXLen)

define void @test_sf_vc_fv_se_e32mf2(<vscale x 1 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv1i32.f32.iXLen(iXLen 1, iXLen 31, <vscale x 1 x i32> %vs2, float %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv1i32.f32.iXLen(iXLen, iXLen, <vscale x 1 x i32>, float, iXLen)

define void @test_sf_vc_fv_se_e32m1(<vscale x 2 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv2i32.f32.iXLen(iXLen 1, iXLen 31, <vscale x 2 x i32> %vs2, float %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv2i32.f32.iXLen(iXLen, iXLen, <vscale x 2 x i32>, float, iXLen)

define void @test_sf_vc_fv_se_e32m2(<vscale x 4 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv4i32.f32.iXLen(iXLen 1, iXLen 31, <vscale x 4 x i32> %vs2, float %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv4i32.f32.iXLen(iXLen, iXLen, <vscale x 4 x i32>, float, iXLen)

define void @test_sf_vc_fv_se_e32m4(<vscale x 8 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv8i32.f32.iXLen(iXLen 1, iXLen 31, <vscale x 8 x i32> %vs2, float %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv8i32.f32.iXLen(iXLen, iXLen, <vscale x 8 x i32>, float, iXLen)

define void @test_sf_vc_fv_se_e32m8(<vscale x 16 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv16i32.f32.iXLen(iXLen 1, iXLen 31, <vscale x 16 x i32> %vs2, float %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv16i32.f32.iXLen(iXLen, iXLen, <vscale x 16 x i32>, float, iXLen)

define void @test_sf_vc_fv_se_e64m1(<vscale x 1 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv1i64.f64.iXLen(iXLen 1, iXLen 31, <vscale x 1 x i64> %vs2, double %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv1i64.f64.iXLen(iXLen, iXLen, <vscale x 1 x i64>, double, iXLen)

define void @test_sf_vc_fv_se_e64m2(<vscale x 2 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv2i64.f64.iXLen(iXLen 1, iXLen 31, <vscale x 2 x i64> %vs2, double %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv2i64.f64.iXLen(iXLen, iXLen, <vscale x 2 x i64>, double, iXLen)

define void @test_sf_vc_fv_se_e64m4(<vscale x 4 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv4i64.f64.iXLen(iXLen 1, iXLen 31, <vscale x 4 x i64> %vs2, double %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv4i64.f64.iXLen(iXLen, iXLen, <vscale x 4 x i64>, double, iXLen)

define void @test_sf_vc_fv_se_e64m8(<vscale x 8 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    sf.vc.fv 1, 31, v8, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fv.se.iXLen.nxv8i64.f64.iXLen(iXLen 1, iXLen 31, <vscale x 8 x i64> %vs2, double %fs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fv.se.iXLen.nxv8i64.f64.iXLen(iXLen, iXLen, <vscale x 8 x i64>, double, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_fv_se_e16mf4(<vscale x 1 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv1i16.iXLen.f16.iXLen(iXLen 1, <vscale x 1 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv1i16.iXLen.f16.iXLen(iXLen, <vscale x 1 x i16>, half, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_fv_se_e16mf2(<vscale x 2 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv2i16.iXLen.f16.iXLen(iXLen 1, <vscale x 2 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv2i16.iXLen.f16.iXLen(iXLen, <vscale x 2 x i16>, half, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_fv_se_e16m1(<vscale x 4 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv4i16.iXLen.f16.iXLen(iXLen 1, <vscale x 4 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv4i16.iXLen.f16.iXLen(iXLen, <vscale x 4 x i16>, half, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_fv_se_e16m2(<vscale x 8 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv8i16.iXLen.f16.iXLen(iXLen 1, <vscale x 8 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv8i16.iXLen.f16.iXLen(iXLen, <vscale x 8 x i16>, half, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_fv_se_e16m4(<vscale x 16 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv16i16.iXLen.f16.iXLen(iXLen 1, <vscale x 16 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv16i16.iXLen.f16.iXLen(iXLen, <vscale x 16 x i16>, half, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_fv_se_e16m8(<vscale x 32 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv32i16.iXLen.f16.iXLen(iXLen 1, <vscale x 32 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fv.se.nxv32i16.iXLen.f16.iXLen(iXLen, <vscale x 32 x i16>, half, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_fv_se_e32mf2(<vscale x 1 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv1i32.iXLen.f32.iXLen(iXLen 1, <vscale x 1 x i32> %vs2, float %fs1, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv1i32.iXLen.f32.iXLen(iXLen, <vscale x 1 x i32>, float, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_fv_se_e32m1(<vscale x 2 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv2i32.iXLen.f32.iXLen(iXLen 1, <vscale x 2 x i32> %vs2, float %fs1, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv2i32.iXLen.f32.iXLen(iXLen, <vscale x 2 x i32>, float, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_fv_se_e32m2(<vscale x 4 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv4i32.iXLen.f32.iXLen(iXLen 1, <vscale x 4 x i32> %vs2, float %fs1, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv4i32.iXLen.f32.iXLen(iXLen, <vscale x 4 x i32>, float, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_fv_se_e32m4(<vscale x 8 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv8i32.iXLen.f32.iXLen(iXLen 1, <vscale x 8 x i32> %vs2, float %fs1, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv8i32.iXLen.f32.iXLen(iXLen, <vscale x 8 x i32>, float, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_fv_se_e32m8(<vscale x 16 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv16i32.iXLen.f32.iXLen(iXLen 1, <vscale x 16 x i32> %vs2, float %fs1, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fv.se.nxv16i32.iXLen.f32.iXLen(iXLen, <vscale x 16 x i32>, float, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_fv_se_e64m1(<vscale x 1 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv1i64.iXLen.f64.iXLen(iXLen 1, <vscale x 1 x i64> %vs2, double %fs1, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv1i64.iXLen.f64.iXLen(iXLen, <vscale x 1 x i64>, double, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_fv_se_e64m2(<vscale x 2 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv2i64.iXLen.f64.iXLen(iXLen 1, <vscale x 2 x i64> %vs2, double %fs1, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv2i64.iXLen.f64.iXLen(iXLen, <vscale x 2 x i64>, double, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_fv_se_e64m4(<vscale x 4 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv4i64.iXLen.f64.iXLen(iXLen 1, <vscale x 4 x i64> %vs2, double %fs1, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv4i64.iXLen.f64.iXLen(iXLen, <vscale x 4 x i64>, double, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_fv_se_e64m8(<vscale x 8 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv8i64.iXLen.f64.iXLen(iXLen 1, <vscale x 8 x i64> %vs2, double %fs1, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fv.se.nxv8i64.iXLen.f64.iXLen(iXLen, <vscale x 8 x i64>, double, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_fv_e16mf4(<vscale x 1 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fv.nxv1i16.iXLen.f16.iXLen(iXLen 1, <vscale x 1 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fv.nxv1i16.iXLen.f16.iXLen(iXLen, <vscale x 1 x i16>, half, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_fv_e16mf2(<vscale x 2 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fv.nxv2i16.iXLen.f16.iXLen(iXLen 1, <vscale x 2 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fv.nxv2i16.iXLen.f16.iXLen(iXLen, <vscale x 2 x i16>, half, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_fv_e16m1(<vscale x 4 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fv.nxv4i16.iXLen.f16.iXLen(iXLen 1, <vscale x 4 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fv.nxv4i16.iXLen.f16.iXLen(iXLen, <vscale x 4 x i16>, half, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_fv_e16m2(<vscale x 8 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fv.nxv8i16.iXLen.f16.iXLen(iXLen 1, <vscale x 8 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fv.nxv8i16.iXLen.f16.iXLen(iXLen, <vscale x 8 x i16>, half, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_fv_e16m4(<vscale x 16 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fv.nxv16i16.iXLen.f16.iXLen(iXLen 1, <vscale x 16 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fv.nxv16i16.iXLen.f16.iXLen(iXLen, <vscale x 16 x i16>, half, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_fv_e16m8(<vscale x 32 x i16> %vs2, half %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fv.nxv32i16.iXLen.f16.iXLen(iXLen 1, <vscale x 32 x i16> %vs2, half %fs1, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fv.nxv32i16.iXLen.f16.iXLen(iXLen, <vscale x 32 x i16>, half, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_fv_e32mf2(<vscale x 1 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fv.nxv1i32.iXLen.f32.iXLen(iXLen 1, <vscale x 1 x i32> %vs2, float %fs1, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fv.nxv1i32.iXLen.f32.iXLen(iXLen, <vscale x 1 x i32>, float, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_fv_e32m1(<vscale x 2 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fv.nxv2i32.iXLen.f32.iXLen(iXLen 1, <vscale x 2 x i32> %vs2, float %fs1, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fv.nxv2i32.iXLen.f32.iXLen(iXLen, <vscale x 2 x i32>, float, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_fv_e32m2(<vscale x 4 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fv.nxv4i32.iXLen.f32.iXLen(iXLen 1, <vscale x 4 x i32> %vs2, float %fs1, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fv.nxv4i32.iXLen.f32.iXLen(iXLen, <vscale x 4 x i32>, float, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_fv_e32m4(<vscale x 8 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fv.nxv8i32.iXLen.f32.iXLen(iXLen 1, <vscale x 8 x i32> %vs2, float %fs1, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fv.nxv8i32.iXLen.f32.iXLen(iXLen, <vscale x 8 x i32>, float, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_fv_e32m8(<vscale x 16 x i32> %vs2, float %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fv.nxv16i32.iXLen.f32.iXLen(iXLen 1, <vscale x 16 x i32> %vs2, float %fs1, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fv.nxv16i32.iXLen.f32.iXLen(iXLen, <vscale x 16 x i32>, float, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_fv_e64m1(<vscale x 1 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fv.nxv1i64.iXLen.f64.iXLen(iXLen 1, <vscale x 1 x i64> %vs2, double %fs1, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fv.nxv1i64.iXLen.f64.iXLen(iXLen, <vscale x 1 x i64>, double, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_fv_e64m2(<vscale x 2 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fv.nxv2i64.iXLen.f64.iXLen(iXLen 1, <vscale x 2 x i64> %vs2, double %fs1, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fv.nxv2i64.iXLen.f64.iXLen(iXLen, <vscale x 2 x i64>, double, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_fv_e64m4(<vscale x 4 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fv.nxv4i64.iXLen.f64.iXLen(iXLen 1, <vscale x 4 x i64> %vs2, double %fs1, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fv.nxv4i64.iXLen.f64.iXLen(iXLen, <vscale x 4 x i64>, double, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_fv_e64m8(<vscale x 8 x i64> %vs2, double %fs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_fv_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    sf.vc.v.fv 1, v8, v8, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fv.nxv8i64.iXLen.f64.iXLen(iXLen 1, <vscale x 8 x i64> %vs2, double %fs1, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fv.nxv8i64.iXLen.f64.iXLen(iXLen, <vscale x 8 x i64>, double, iXLen)
