/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_SW64_UNCORE_IO_XUELANG_H
#define _ASM_SW64_UNCORE_IO_XUELANG_H

#include <asm/platform.h>

#define IO_BASE			(0x1UL << 47)
#define PCI_BASE		(0x1UL << 43)
#define PCI_IOR0_BASE		(0x2UL << 32)
#define PCI_IOR1_BASE		(0x3UL << 32)

#define PCI_RC_CFG		(0x5UL << 32)

#define PCI_EP_CFG		(0x3UL << 33)
#define PCI_LEGACY_IO		(0x1UL << 32)
#define PCI_LEGACY_IO_SIZE	(0x100000000UL)
#define PCI_MEM_UNPRE		0x0UL
#define PCI_32BIT_MEMIO		(0xe0000000UL)
#define PCI_32BIT_MEMIO_SIZE	(0x20000000UL)
#define PCI_64BIT_MEMIO		(0x1UL << 39)
#define PCI_64BIT_MEMIO_SIZE	(0x8000000000UL)

#define IO_RC_SHIFT		40
#define IO_NODE_SHIFT		44
#define IO_MARK_BIT		47

#define VT_MAX_CPUS_SHIFT	0
#define VT_MAX_CPUS_MASK	0x3ff
#define VT_CORES_SHIFT		10
#define VT_CORES_MASK		0x3ff
#define VT_THREADS_SHIFT	20
#define VT_THREADS_MASK		0xfff

#define QEMU_PRINTF_BUFF_BASE	(IO_BASE | MCU_BASE | 0x40000UL)

/* MSIConfig */
#define MSICONFIG_VALID		(0x1UL << 63)
#define MSICONFIG_EN		(0x1UL << 62)
#define MSICONFIG_VECTOR_SHIFT	10

#define MSIX_MSG_ADDR		(0x91abc0UL)

#define SW64_PCI_IO_BASE(m, n)	\
	(IO_BASE | ((m) << IO_NODE_SHIFT) | PCI_BASE | ((n) << IO_RC_SHIFT))
#define SW64_IO_BASE(x)		(IO_BASE | ((x) << IO_NODE_SHIFT))

#define SW64_PCI0_BUS		0
#define PCI0_BUS		SW64_PCI0_BUS

#define MAX_NR_NODES		0x2
#define MAX_NR_RCS		0x6

#define MCU_BASE		(0x3UL << 36)
#define CAB0_BASE		(0x10UL << 32)
#define INTPU_BASE		(0x2aUL << 32)
#define IIC0_BASE		(0x31UL << 32)
#define SPI_BASE		(0x32UL << 32)
#define UART_BASE		(0x33UL << 32)
#define IIC1_BASE		(0x34UL << 32)
#define IIC2_BASE		(0x35UL << 32)
#define GPIO_BASE		(0x36UL << 32)
#define LPC_BASE		(0x37UL << 32)
#define LPC_LEGACY_IO		(0x1UL << 28 | IO_BASE | LPC_BASE)
#define LPC_MEM_IO		(0x2UL << 28 | IO_BASE | LPC_BASE)
#define LPC_FIRMWARE_IO		(0x3UL << 28 | IO_BASE | LPC_BASE)
#define DLIA_BASE		(0x20UL << 32)
#define DLIB_BASE		(0x21UL << 32)
#define DLIC_BASE		(0x22UL << 32)
#define DLI_PHY_CTL		(0x10UL << 24)
#define PCI_VT_LEGACY_IO	(IO_BASE | PCI_BASE | PCI_LEGACY_IO)

#define PME_ENABLE_INTD_CORE0	(0x1UL << 62 | 0x1UL << 10)
#define AER_ENABLE_INTD_CORE0	(0x1UL << 62 | 0x1UL << 10)

#define PIUCONFIG0_INIT_VAL	0x38056

/*-----------------------addr-----------------------*/
/* CAB0 REG */
enum {
	TRKMODE =		CAB0_BASE | 0x80UL,
};

/* DLIA IO REG */
enum {
	DLIA_BWTEST_PAT =	DLIA_BASE | 0x100980UL,
	DLIA_PHY_VLDLANE =	DLIA_BASE | DLI_PHY_CTL | 0x300UL,
};

/* DLIB IO REG */
enum {
	DLIB_BWTEST_PAT =	DLIB_BASE | 0x100980UL,
	DLIB_PHY_VLDLANE =	DLIB_BASE | DLI_PHY_CTL | 0x300UL,
};

/* DLIC IO REG */
enum {
	DLIC_BWTEST_PAT =	DLIC_BASE | 0x100980UL,
	DLIC_PHY_VLDLANE =	DLIC_BASE | DLI_PHY_CTL | 0x300UL,
};
/* INTPU REG */
enum {
	LCORE_SLEEPY =		INTPU_BASE | 0x0UL,
	LCORE_SLEEP =		INTPU_BASE | 0x80UL,
	DEVICE_MISS =		INTPU_BASE | 0x100UL,
	LONG_TIME =		INTPU_BASE | 0x180UL,
	LCORE_IDLE =		INTPU_BASE | 0x280UL,
	MT_INT_CONFIG =		INTPU_BASE | 0x300UL,
	DEV_INT_CONFIG =	INTPU_BASE | 0x480UL,
	FMT_ERR	=		INTPU_BASE | 0x700UL,
	FAULT_INT_CONFIG =	INTPU_BASE | 0x780UL,
	SERR_CNTTH =		INTPU_BASE | 0x880UL,
	MCUSERR_CNT =		INTPU_BASE | 0x900UL,
	IRUSERR_CNT =		INTPU_BASE | 0xa80UL,
	ERRRPT_EN =		INTPU_BASE | 0xb00UL,
	IINT_MISS_VECTOR =	INTPU_BASE | 0x1100UL,
	IINT_MIS =		INTPU_BASE | 0x1180UL,
	IINT_MISS_RPTEN =	INTPU_BASE | 0x1200UL,
	DEVINT_MISS_RPTEN =	INTPU_BASE | 0x1280UL,
	ECCSERR =		INTPU_BASE | 0x1300UL,
	ECCSERR_RPTEN =		INTPU_BASE | 0x1380UL,
	ECCMERR =		INTPU_BASE | 0x1400UL,
	ECCMERR_RPTEN =		INTPU_BASE | 0x1480UL,
	DEVINT_WKEN =		INTPU_BASE | 0x1500UL,
	NMI_INT_CONFIG =	INTPU_BASE | 0x1580UL,
	DEVINTWK_INTEN =	INTPU_BASE | 0x1600UL,
};

/* MC IO REG */
enum {
	CFGDEC =		0x400UL,
	CFGCR =			0x480UL,
	INIT_CTRL =		0x580UL,
	CFGERR =		0xd00UL,
	FSMSTAT =		0xe00UL,
	PUB_INTERFACE =		0x1000UL,
	POWERCTRL =		0x1080UL,
	CFGMR0 =		0x1280UL,
	CFGMR1 =		0x1300UL,
	CFGMR2 =		0x1380UL,
	CFGMR3 =		0x1400UL,
	PERF_CTRL =		0x1480UL,
	MC_PERF0 =		0x1500UL,
	CFGMR4 =		0x1800UL,
	CFGMR5 =		0x1880UL,
	CFGMR6 =		0x1900UL,
	MC_CTRL =		0x1c00UL,
	MEMSERR_P =		0x1c80UL,
	MEMSERR =		0x1d00UL,
};

/* MCU CSR */
enum {
	SMP_INFO =		MCU_BASE | 0x80UL,
	INIT_CTL =		MCU_BASE | 0x680UL,
	MT_STATE =		MCU_BASE | 0x700UL,
	CORE_ONLINE =		MCU_BASE | 0x780UL,
	MT_INT =		MCU_BASE | 0x800UL,
	MT_INT_END =		MCU_BASE | 0x880UL,
	CPU_ID =		MCU_BASE | 0x900UL,
	DLI_RLTD_FAULT =	MCU_BASE | 0x980UL,
	DLI_RLTD_FAULT_EN =	MCU_BASE | 0xa00UL,
	DLI_RLTD_FAULT_INTEN =	MCU_BASE | 0xa80UL,
	FAULT_SOURCE =		MCU_BASE | 0xb00UL,
	INT_SOURCE =		MCU_BASE | 0xb80UL,
	CORE_STATE0 =		MCU_BASE | 0xc00UL,
	CORE_STATE1 =		MCU_BASE | 0xc80UL,
	CFG_INFO =		MCU_BASE | 0x1100UL,
	MC_CAP_CFG =		MCU_BASE | 0x1180UL,
	IO_START =		MCU_BASE | 0x1300UL,
	UART_ONLINE =		MCU_BASE | 0x1780UL,
	I2C0_SRST_L =		MCU_BASE | 0x1900UL,
	I2C1_SRST_L =		MCU_BASE | 0x1980UL,
	I2C2_SRST_L =		MCU_BASE | 0x1a00UL,
	MCU_DVC_INT =		MCU_BASE | 0x3000UL,
	MCU_DVC_INT_EN =	MCU_BASE | 0x3080UL,
	SI_FAULT_STAT =		MCU_BASE | 0x3100UL,
	SI_FAULT_EN =		MCU_BASE | 0x3180UL,
	SI_FAULT_INT_EN =	MCU_BASE | 0x3200UL,
	FIFO_SYNSEL =		MCU_BASE | 0x3400UL,
	CPU_INFO =		MCU_BASE | 0x3480UL,
	WAKEUP_CTL =		MCU_BASE | 0x3500UL,
	FLAGREG =		MCU_BASE | 0x3580UL,
	NMI_CTL =		MCU_BASE | 0x3600UL,
	PIUPLL_CNT =		MCU_BASE | 0x3680UL,
	MC_ONLINE =		MCU_BASE | 0x3780UL,
	FLASH_INFO =		MCU_BASE | 0x3800UL,
	RTPUSROMCNT =		MCU_BASE | 0x3880UL,
	CLU_LV1_SEL =		MCU_BASE | 0x3a80UL,
	CLU_LV2_SEL =		MCU_BASE | 0x3b00UL,
	CLK_CTL =		MCU_BASE | 0x3b80UL,
	SLEEP_WAIT_CNT =	MCU_BASE | 0x4980UL,
	CHIP_ID =		MCU_BASE | 0x4b00UL,
	PIU_TOP0_CONFIG =	MCU_BASE | 0x4c80UL,
	PIU_TOP1_CONFIG =	MCU_BASE | 0x4d00UL,
	LVDS_CTL =		MCU_BASE | 0x4d80UL,
	LPC_DMAREQ_TOTH =	MCU_BASE | 0x5100UL,
	DLI_ONLINE =		MCU_BASE | 0x6180UL,
	LPC_DMAREQ_HADR =	MCU_BASE | 0x6200UL,
	PIU_PHY_SRST_H =	MCU_BASE | 0x6280UL,
	CLK_SEL_PCIE0 =		MCU_BASE | 0x6280UL,
	CLK_SEL_PCIE1 =		MCU_BASE | 0x6300UL,
	CLK_SEL_PCIE2 =		MCU_BASE | 0x6380UL,
	CLK_SEL_PCIE3 =		MCU_BASE | 0x6400UL,
	CLK_SEL_PCIE4 =		MCU_BASE | 0x6480UL,
	CLK_SEL_PCIE5 =		MCU_BASE | 0x6500UL,
	PERST_N_PCIE0 =		MCU_BASE | 0x6680UL,
	PERST_N_PCIE1 =		MCU_BASE | 0x6700UL,
	PERST_N_PCIE2 =		MCU_BASE | 0x6780UL,
	PERST_N_PCIE3 =		MCU_BASE | 0x6800UL,
	PERST_N_PCIE4 =		MCU_BASE | 0x6880UL,
	PERST_N_PCIE5 =		MCU_BASE | 0x6900UL,
	BUTTON_RST_N_PCIE0 =	MCU_BASE | 0x6a80UL,
	BUTTON_RST_N_PCIE1 =	MCU_BASE | 0x6b00UL,
	BUTTON_RST_N_PCIE2 =	MCU_BASE | 0x6b80UL,
	BUTTON_RST_N_PCIE3 =	MCU_BASE | 0x6c00UL,
	BUTTON_RST_N_PCIE4 =	MCU_BASE | 0x6c80UL,
	BUTTON_RST_N_PCIE5 =	MCU_BASE | 0x6d00UL,
	DUAL_CG0_FAULT =	MCU_BASE | 0x6d80UL,
	DUAL_CG1_FAULT =	MCU_BASE | 0x6e00UL,
	DUAL_CG2_FAULT =	MCU_BASE | 0x6e80UL,
	DUAL_CG3_FAULT =	MCU_BASE | 0x6f00UL,
	DUAL_CG4_FAULT =	MCU_BASE | 0x6f80UL,
	DUAL_CG5_FAULT =	MCU_BASE | 0x7000UL,
	DUAL_CG6_FAULT =	MCU_BASE | 0x7080UL,
	DUAL_CG7_FAULT =	MCU_BASE | 0x7100UL,
	DUAL_CG0_FAULT_EN =	MCU_BASE | 0x7180UL,
	DUAL_CG1_FAULT_EN =	MCU_BASE | 0x7200UL,
	DUAL_CG2_FAULT_EN =	MCU_BASE | 0x7280UL,
	DUAL_CG3_FAULT_EN =	MCU_BASE | 0x7300UL,
	DUAL_CG4_FAULT_EN =	MCU_BASE | 0x7380UL,
	DUAL_CG5_FAULT_EN =	MCU_BASE | 0x7400UL,
	DUAL_CG6_FAULT_EN =	MCU_BASE | 0x7480UL,
	DUAL_CG7_FAULT_EN =	MCU_BASE | 0x7500UL,
	DUAL_CG0_FAULT_INTEN =	MCU_BASE | 0x7580UL,
	DUAL_CG1_FAULT_INTEN =	MCU_BASE | 0x7600UL,
	DUAL_CG2_FAULT_INTEN =	MCU_BASE | 0x7680UL,
	DUAL_CG3_FAULT_INTEN =	MCU_BASE | 0x7700UL,
	DUAL_CG4_FAULT_INTEN =	MCU_BASE | 0x7780UL,
	DUAL_CG5_FAULT_INTEN =	MCU_BASE | 0x7800UL,
	DUAL_CG6_FAULT_INTEN =	MCU_BASE | 0x7880UL,
	DUAL_CG7_FAULT_INTEN =	MCU_BASE | 0x7900UL,
	SOFT_INFO0 =		MCU_BASE | 0x7f00UL,
	LONG_TIME_START_EN =    MCU_BASE | 0x9000UL,
};

/*--------------------------offset-----------------------------------*/
/* PIU IOR0 */
enum {
	PIUCONFIG0 =		0x0UL,
	EPDMABAR =		0x80UL,
	IOMMUSEGITEM0 =		0x100UL,
	IOMMUEXCPT_CTRL =	0x2100UL,
	MSIADDR =		0x2180UL,
	MSICONFIG0 =		0x2200UL,
	INTACONFIG =		0xa200UL,
	INTBCONFIG =		0xa280UL,
	INTCCONFIG =		0xa300UL,
	INTDCONFIG =		0xa380UL,
	AERERRINTCONFIG =	0xa400UL,
	AERERRMSICONFIG =	0xa480UL,
	PMEINTCONFIG =		0xa500UL,
	PMEMSICONFIG =		0xa580UL,
	HPINTCONFIG =		0xa600UL,
	HPMSICONFIG =		0xa680UL,
	DTBASEADDR =		0xb000UL,
	DTLB_FLUSHALL =		0xb080UL,
	DTLB_FLUSHDEV =		0xb100UL,
	PTLB_FLUSHALL =		0xb180UL,
	PTLB_FLUSHDEV =		0xb200UL,
	PTLB_FLUSHVADDR =	0xb280UL,
	PCACHE_FLUSHALL =	0xb300UL,
	PCACHE_FLUSHDEV =	0xb380UL,
	PCACHE_FLUSHPADDR =	0xb400UL,
	TIMEOUT_CONFIG =	0xb480UL,
	IOMMUEXCPT_STATUS =	0xb500UL,
	IOMMUPAGE_PADDR1 =	0xb580UL,
	IOMMUPAGE_PADDR2 =	0xb600UL,
	IOMMUPAGE_PADDR3 =	0xb680UL,
	PTLB_ACCESS =		0xb700UL,
	PTLB_ITEM_TAG =		0xb780UL,
	PTLB_ITEM_DATA =	0xb800UL,
	PCACHE_ACCESS =		0xb880UL,
	PCACHE_ITEM_TAG =	0xb900UL,
	PCACHE_ITEM_DATA0 =	0xb980UL,
};

/* PIU IOR1 */
enum {
	PIUCONFIG1 =		0x0UL,
	ERRENABLE =		0x880UL,
	RCDEBUGINF1 =		0xc80UL,
	DCACONTROL =		0x1a00UL,
	DEVICEID0 =		0x1a80UL,
};

/* RC */
enum {
	RC_VENDOR_ID =		0x0UL,
	RC_COMMAND =		0x80UL,
	RC_REVISION_ID =	0x100UL,
	RC_PRIMARY_BUS =	0x300UL,
	RC_MSI_CONTROL =	0xa00UL,
	RC_EXP_DEVCAP =		0xe80UL,
	RC_EXP_DEVCTL =		0xf00UL,
	RC_SLOT_CTRL =		0x1100UL,
	RC_LINK_STAT =		0x1000UL,
	RC_CONTROL =		0X1180UL,
	RC_STATUS =		0X1200UL,
	RC_EXP_DEVCTL2 =	0x1300UL,
	RC_PORT_LINK_CTL =	0xe200UL,
	RC_ORDER_RULE_CTL =     0x11680UL,
	RC_MISC_CONTROL_1 =	0x11780UL,
	RC_PHY_INT_REG =	0x80000UL,
	RC_PHY_EXT_GEN1 =	0x82400UL,
	RC_PHY_EXT_GEN2 =	0x82480UL,
};
/* GPIO */
enum {
	GPIO_SWPORTA_DR =	GPIO_BASE | 0x0UL,
	GPIO_SWPORTA_DDR =	GPIO_BASE | 0x200UL,
};
/*--------------------------------------------------------------------------*/
#endif /* _ASM_SW64_UNCORE_IO_XUELANG_H */
