#!/bin/bash
# packages = nfs-utils

. $SHARED/partition.sh

# Add nodev option to all records in fstab to ensure that test will
# run on environment where everything is set correctly for rule check.
cp /etc/fstab /etc/fstab.backup
sed -e 's/\bnodev\b/,/g' -e 's/,,//g' -e 's/\s,\s/defaults/g' /etc/fstab.backup
awk '{$4 = $4",nodev"; print}' /etc/fstab.backup > /etc/fstab
# Remount all partitions. (--all option can't be used because it doesn't
# mount e.g. /boot partition
declare -a partitions=( $(awk '{print $2}' /etc/fstab | grep "^/\w") )
for partition in ${partitions[@]}; do
    mount -o remount "$partition"
done

mkdir /tmp/testdir
mkdir /tmp/testmount
chown 2 /tmp/testdir
chmod 777 /tmp/testdir

echo '/tmp/testdir localhost(rw)' > /etc/exports
systemctl restart nfs-server
mount.nfs localhost:/tmp/testdir /tmp/testmount
