import lldb
from lldbsuite.test.decorators import *
from lldbsuite.test.lldbtest import *
from lldbsuite.test import lldbutil

class TestCase(TestBase):

    mydir = TestBase.compute_mydir(__file__)

    @no_debug_info_test
    def test(self):
        """
        This tests a static member with a type which size depends on the
        surrounding class. LLDB should *not* try to generate the record layout
        for those types while parsing the members from debug info.
        """
        self.build()
        self.dbg.CreateTarget(self.getBuildArtifact("a.out"))

        # Force the record layout for 'ToLayout' to be generated by printing
        # a value of it's type.
        self.expect("target variable test_var")
