# coding: utf-8

# generated from quicktype

"""
Classes in this file
1. Product.
2. Version
3. CaseAttachment
4. CaseGroup
5. Entitlement
6. Comment
7. CaseResourceLink
8. Case
9. KCSDescription
10. Contact
11. Values
12. KCSSearch
13. CaseFilter
14. Solution
15. Article
16. Recommendation
"""


def from_str(x):
    assert isinstance(x, (str, unicode))
    return x


def from_none(x):
    assert x is None
    return x


def from_union(fs, x):
    for f in fs:
        try:
            return f(x)
        except:
            pass
    assert False


def from_int(x):
    assert isinstance(x, int) and not isinstance(x, bool)
    return x


def from_bool(x):
    assert isinstance(x, bool)
    return x


def from_list(f, x):
    assert isinstance(x, list)
    return [f(y) for y in x]


def to_class(c, x):
    assert isinstance(x, c)
    return x.to_dict()


def from_any(x):
    return x


class Product(object):
    """
    Product class

    """
    def __init__(self, productId=None, name=None, supportedForCustomer=None, openShiftClusterIdRelevantInCases=None,
                 recentlyFiledAgainst=None):
        self.productId = productId
        self.name = name
        self.supportedForCustomer = supportedForCustomer
        self.openShiftClusterIdRelevantInCases = openShiftClusterIdRelevantInCases
        self.recentlyFiledAgainst = recentlyFiledAgainst

    def get_productId(self): return self.productId
    def get_name(self): return self.name
    def get_supportedForCustomer(self): return self.supportedForCustomer
    def get_openShiftClusterIdRelevantInCases(self): return self.openShiftClusterIdRelevantInCases
    def get_recentlyFiledAgainst(self): return self.recentlyFiledAgainst
    def set_productId(self, productId): self.productId = productId
    def set_name(self, name): self.name = name
    def set_supportedForCustomer(self, supportedForCustomer): self.supportedForCustomer = supportedForCustomer
    def set_openShiftClusterIdRelevantInCases(self, openShiftClusterIdRelevantInCases):
        self.openShiftClusterIdRelevantInCases = openShiftClusterIdRelevantInCases
    def set_recentlyFiledAgainst(self, recentlyFiledAgainst): self.recentlyFiledAgainst = recentlyFiledAgainst

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        productId = from_union([from_str, from_none], obj.get(u"productId"))
        name = from_union([from_str, from_none], obj.get(u"name"))
        supportedForCustomer = from_union([from_bool, from_none], obj.get(u"supportedForCustomer"))
        openShiftClusterIdRelevantInCases = from_union([from_bool, from_none], obj.get(u"openShiftClusterIdRelevantInCases"))
        recentlyFiledAgainst = from_union([from_bool, from_none], obj.get(u"recentlyFiledAgainst"))
        return Product(productId, name, supportedForCustomer, openShiftClusterIdRelevantInCases, recentlyFiledAgainst)

    def to_dict(self):
        result = {}
        result[u"productId"] = from_union([from_str, from_none], self.productId)
        result[u"name"] = from_union([from_str, from_none], self.name)
        result[u"supportedForCustomer"] = from_union([from_bool, from_none], self.supportedForCustomer)
        result[u"openShiftClusterIdRelevantInCases"] = from_union([from_bool, from_none], self.openShiftClusterIdRelevantInCases)
        result[u"recentlyFiledAgainst"] = from_union([from_bool, from_none], self.recentlyFiledAgainst)
        return result


def Productsfromdict(s):
    return from_list(Product.from_dict, s)


def Productstodict(x):
    return from_list(lambda x: to_class(Product, x), x)


def Productfromdict(s):
    return Product.from_dict(s)


def Producttodict(x):
    return to_class(Product, x)


class Version(object):
    """
    Used for product versions.

    """
    def __init__(self, id=None, name=None, availableForCertifications=None, doNotShowIRT=None):
        self.id = id
        self.name = name
        self.availableForCertifications = availableForCertifications
        self.doNotShowIRT = doNotShowIRT

    def get_id(self): return self.id
    def get_name(self): return self.name
    def get_availableForCertifications(self): return self.availableForCertifications
    def get_doNotShowIRT(self): return self.doNotShowIRT
    def set_id(self, id): self.id=id
    def set_name(self, name): self.name=name
    def set_availableForCertifications(self, availableForCertifications):
        self.availableForCertifications=availableForCertifications
    def set_doNotShowIRT(self, doNotShowIRT): self.doNotShowIRT=doNotShowIRT


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        id = from_union([from_str, from_none], obj.get(u"id"))
        name = from_union([from_str, from_none], obj.get(u"name"))
        availableForCertifications = from_union([from_bool, from_none], obj.get(u"availableForCertifications"))
        doNotShowIRT = from_union([from_bool, from_none], obj.get(u"doNotShowIRT"))
        return Version(id, name, availableForCertifications, doNotShowIRT)

    def to_dict(self):
        result = {}
        result[u"id"] = from_union([from_str, from_none], self.id)
        result[u"name"] = from_union([from_str, from_none], self.name)
        result[u"availableForCertifications"] = from_union([from_bool, from_none], self.availableForCertifications)
        result[u"doNotShowIRT"] = from_union([from_bool, from_none], self.doNotShowIRT)
        return result


def Versionsfromdict(s):
    return from_list(Version.from_dict, s)


def Versionstodict(x):
    return from_list(lambda x: to_class(Version, x), x)


def Versionfromdict(s):
    return Version.from_dict(s)


def Versiontodict(x):
    return to_class(Version, x)


def version_list(f, x):
    assert isinstance(x, list)
    return [f(y).name for y in x]


def get_version(s):
    return version_list(Version.from_dict, s)


class CaseAttachment(object):
    """
    Case Attachment class
    """
    def __init__(self, caseNumber=None, uuid=None, checksum=None, createdDate=None, createdBy=None, description=None,
                 fileName=None, fileType=None, id=None, isArchived=None, isDeprecated=None, isPrivate=None,
                 lastModifiedDate=None, link=None, modifiedBy=None, size=None, sizeKB=None, downloadRestricted=None):
        self.caseNumber = caseNumber
        self.uuid = uuid
        self.checksum = checksum
        self.createdDate = createdDate
        self.createdBy = createdBy
        self.description = description
        self.fileName = fileName
        self.fileType = fileType
        self.id = id
        self.isArchived = isArchived
        self.isDeprecated = isDeprecated
        self.isPrivate = isPrivate
        self.lastModifiedDate = lastModifiedDate
        self.link = link
        self.modifiedBy = modifiedBy
        self.size = size
        self.sizeKB = sizeKB
        self.downloadRestricted = downloadRestricted

    def get_caseNumber(self): return self.caseNumber
    def get_uuid(self): return self.uuid
    def get_checksum(self): return self.checksum
    def get_createdDate(self): return self.createdDate
    def get_createdBy(self): return self.createdBy
    def get_description(self): return self.description
    def get_fileName(self): return self.fileName
    def get_fileType(self): return self.fileType
    def get_id(self): return self.id
    def get_isArchived(self): return self.isArchived
    def get_isDeprecated(self): return self.isDeprecated
    def get_isPrivate(self): return self.isPrivate
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_link(self): return self.link
    def get_modifiedBy(self): return self.modifiedBy
    def get_size(self): return self.size
    def get_sizeKB(self): return self.sizeKB
    def get_downloadRestricted(self): return self.downloadRestricted
    def set_caseNumber(self, caseNumber): self.caseNumber = caseNumber
    def set_uuid(self, uuid): self.uuid = uuid
    def set_checksum(self, checksum): self.checksum = checksum
    def set_createdDate(self, createdDate): self.createdDate = createdDate
    def set_createdBy(self, createdBy): self.createdBy = createdBy
    def set_fileName(self, fileName): self.fileName = fileName
    def set_fileType(self, fileType): self.fileType = fileType
    def set_id(self, id): self.id = id
    def set_isArchived(self, isArchived): self.isArchived = isArchived
    def set_isDeprecated(self, isDeprecated): self.isDeprecated = isDeprecated
    def set_isPrivate(self, isPrivate): self.isPrivate = isPrivate
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate = lastModifiedDate
    def set_link(self, link): self.link = link
    def set_modifiedBy(self, modifiedBy): self.modifiedBy = modifiedBy
    def set_description(self, description): self.description = description
    def set_size(self, size): self.size = size
    def set_sizeKB(self, sizeKB): self.sizeKB = sizeKB
    def set_downloadRestricted(self, downloadRestricted): self.downloadRestricted = downloadRestricted

    # to maintain consistency
    def get_length(self): return self.size
    def get_uri(self): return self.link
    def set_length(self, length): self.size = length
    def set_uri(self, uri): self.link = uri


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        caseNumber = from_union([from_str, from_none], obj.get(u"caseNumber"))
        uuid = from_union([from_str, from_none], obj.get(u"uuid"))
        checksum = from_union([from_str, from_none], obj.get(u"checksum"))
        createdDate = from_union([from_any, from_none], obj.get(u"createdDate"))
        createdBy = from_union([from_str, from_none], obj.get(u"createdBy"))
        description = from_union([from_str, from_none], obj.get(u"description"))
        fileName = from_union([from_str, from_none], obj.get(u"fileName"))
        fileType = from_union([from_str, from_none], obj.get(u"fileType"))
        id = from_union([from_str, from_none], obj.get(u"id"))
        isArchived = from_union([from_bool, from_none], obj.get(u"isArchived"))
        isDeprecated = from_union([from_bool, from_none], obj.get(u"isDeprecated"))
        isPrivate = from_union([from_bool, from_none], obj.get(u"isPrivate"))
        lastModifiedDate = from_union([from_any, from_none], obj.get(u"lastModifiedDate"))
        link = from_union([from_str, from_none], obj.get(u"link"))
        modifiedBy = from_union([from_str, from_none], obj.get(u"modifiedBy"))
        size = from_union([from_any, from_none], obj.get(u"size"))
        sizeKB = from_union([from_any, from_none], obj.get(u"sizeKB"))
        downloadRestricted = from_union([from_bool, from_none], obj.get(u"downloadRestricted"))
        return CaseAttachment(caseNumber, uuid, checksum, createdDate, createdBy, description,
                              fileName, fileType, id, isArchived, isDeprecated, isPrivate, lastModifiedDate,
                              link, modifiedBy, size, sizeKB, downloadRestricted)

    def to_dict(self):
        result = {}
        result[u"caseNumber"] = from_union([from_str, from_none], self.caseNumber)
        result[u"uuid"] = from_union([from_str, from_none], self.uuid)
        result[u"checksum"] = from_union([from_str, from_none], self.checksum)
        result[u"createdDate"] = from_union([from_any, from_none], self.createdDate)
        result[u"createdBy"] = from_union([from_str, from_none], self.createdBy)
        result[u"description"] = from_union([from_str, from_none], self.description)
        result[u"fileName"] = from_union([from_str, from_none], self.fileName)
        result[u"fileType"] = from_union([from_str, from_none], self.fileType)
        result[u"id"] = from_union([from_str, from_none], self.id)
        result[u"isArchived"] = from_union([from_bool, from_none], self.isArchived)
        result[u"isDeprecated"] = from_union([from_bool, from_none], self.isDeprecated)
        result[u"isPrivate"] = from_union([from_bool, from_none], self.isPrivate)
        result[u"lastModifiedDate"] = from_union([from_any, from_none], self.lastModifiedDate)
        result[u"link"] = from_union([from_str, from_none], self.link)
        result[u"modifiedBy"] = from_union([from_str, from_none], self.modifiedBy)
        result[u"size"] = from_union([from_any, from_none], self.size)
        result[u"sizeKB"] = from_union([from_any, from_none], self.sizeKB)
        result[u"downloadRestricted"] = from_union([from_bool, from_none], self.downloadRestricted)
        return result


def CaseAttachmentsfromdict(s):
    return from_list(CaseAttachment.from_dict, s)


def CaseAttachmentstodict(x):
    return from_list(lambda x: to_class(CaseAttachment, x), x)


def CaseAttachmentfromdict(s):
    return CaseAttachment.from_dict(s)


def CaseAttachmenttodict(x):
    return to_class(CaseAttachment, x)


class CaseGroup(object):
    """
    Case Group class
    """
    def __init__(self, groupNum=None, isDefault=None, isPrivate=None, name=None):
        self.groupNum = groupNum
        self.isDefault = isDefault
        self.isPrivate = isPrivate
        self.name = name

    def get_groupNum(self): return self.groupNum
    def get_isDefault(self): return self.isDefault
    def get_isPrivate(self): return self.isPrivate
    def get_name(self): return self.name
    def set_groupNum(self, groupNum): self.groupNum=groupNum
    def set_isDefault(self, isDefault): self.isDefault=isDefault
    def set_isPrivate(self, isPrivate): self.isPrivate=isPrivate
    def set_name(self, name): self.name=name


    ## to keep consistency
    def get_number(self): return self.groupNum
    def set_number(self, groupNum): self.groupNum=groupNum

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        groupNum = from_union([from_str, from_none], obj.get(u"groupNum"))
        isDefault = from_union([from_bool, from_none], obj.get(u"isDefault"))
        isPrivate = from_union([from_bool, from_none], obj.get(u"isPrivate"))
        name = from_union([from_str, from_none], obj.get(u"name"))
        return CaseGroup(groupNum, isDefault, isPrivate, name)

    def to_dict(self):
        result = {}
        result[u"groupNum"] = from_union([from_str, from_none], self.groupNum)
        result[u"isDefault"] = from_union([from_bool, from_none], self.isDefault)
        result[u"isPrivate"] = from_union([from_bool, from_none], self.isPrivate)
        result[u"name"] = from_union([from_str, from_none], self.name)
        return result


def CaseGroupsfromdict(s):
    return from_list(CaseGroup.from_dict, s)


def CaseGroupstodict(x):
    return from_list(lambda x: to_class(CaseGroup, x), x)


def CaseGroupfromdict(s):
    return CaseGroup.from_dict(s)


def CaseGrouptodict(x):
    return to_class(CaseGroup, x)


class Entitlement(object):
    """
    Entitlement class
    """
    def __init__(self, id=None, name=None, endDate=None, serviceLevel=None, slaProcessId=None,
                 startDate=None, supportLevel=None):
        self.id = id
        self.name = name
        self.endDate = endDate
        self.serviceLevel = serviceLevel
        self.slaProcessId = slaProcessId
        self.startDate = startDate
        self.supportLevel = supportLevel

    def get_id(self): return self.id
    def get_name(self): return self.name
    def get_endDate(self): return self.endDate
    def get_serviceLevel(self): return self.serviceLevel
    def get_slaProcessId(self): return self.slaProcessId
    def get_sla(self): return self.slaProcessId  # to maintain consistency
    def get_startDate(self): return self.startDate
    def get_supportLevel(self): return self.supportLevel
    def set_id(self, id): self.id = id
    def set_name(self, name): self.name = name
    def set_endDate(self, endDate): self.endDate = endDate
    def set_serviceLevel(self, serviceLevel): self.serviceLevel = serviceLevel
    def set_slaProcessId(self, slaProcessId): self.slaProcessId = slaProcessId
    def set_sla(self, slaProcessId): self.slaProcessId = slaProcessId
    def set_startDate(self, startDate): self.startDate = startDate
    def set_supportLevel(self, supportLevel): self.supportLevel = supportLevel

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        id = from_union([from_str, from_none], obj.get(u"id"))
        name = from_union([from_str, from_none], obj.get(u"name"))
        endDate = from_union([from_str, from_none], obj.get(u"endDate"))
        serviceLevel = from_union([from_str, from_none], obj.get(u"serviceLevel"))
        slaProcessId = from_union([from_str, from_none], obj.get(u"slaProcessId"))
        startDate = from_union([from_str, from_none], obj.get(u"startDate"))
        supportLevel = from_union([from_str, from_none], obj.get(u"supportLevel"))
        return Entitlement(id, name, endDate, serviceLevel, slaProcessId, startDate, supportLevel)

    def to_dict(self):
        result = {}
        result[u"id"] = from_union([from_str, from_none], self.id)
        result[u"name"] = from_union([from_str, from_none], self.name)
        result[u"endDate"] = from_union([from_str, from_none], self.endDate)
        result[u"serviceLevel"] = from_union([from_str, from_none], self.serviceLevel)
        result[u"slaProcessId"] = from_union([from_str, from_none], self.slaProcessId)
        result[u"startDate"] = from_union([from_str, from_none], self.startDate)
        result[u"supportLevel"] = from_union([from_str, from_none], self.supportLevel)
        return result


def Entitlementsfromdict(s):
    return from_list(Entitlement.from_dict, s)


def Entitlementstodict(x):
    return from_list(lambda x: to_class(Entitlement, x), x)


def Entitlementfromdict(s):
    return Entitlement.from_dict(s)


def Entitlementtodict(x):
    return to_class(Entitlement, x)


class Comment(object):
    """
    Comment class
    """
    def __init__(self, doNotChangeSBT=None, isPublic=None, id=None, caseNumber=None, commentBody=None, createdDate=None,
                 createdByType=None, isDraft=None, lastModifiedById=None, lastModifiedDate=None, publishedDate=None,
                 createdBy=None, contentType=None):
        self.doNotChangeSBT = doNotChangeSBT
        self.isPublic = isPublic
        self.id = id
        self.caseNumber = caseNumber
        self.commentBody = commentBody
        self.createdDate = createdDate
        self.createdByType = createdByType
        self.isDraft = isDraft
        self.lastModifiedById = lastModifiedById
        self.lastModifiedDate = lastModifiedDate
        self.publishedDate = publishedDate
        self.createdBy = createdBy
        self.contentType = contentType

    def get_doNotChangeSBT(self): return self.doNotChangeSBT
    def get_isPublic(self): return self.isPublic
    def get_id(self): return self.id
    def get_caseNumber(self): return self.caseNumber
    def get_commentBody(self): return self.commentBody
    def get_createdDate(self): return self.createdDate
    def get_createdByType(self): return self.createdByType
    def get_isDraft(self): return self.isDraft
    def get_lastModifiedById(self): return self.lastModifiedById
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_publishedDate(self): return self.publishedDate
    def get_createdBy(self): return self.createdBy
    def get_contentType(self): return self.contentType
    def set_doNotChangeSBT(self, doNotChangeSBT): self.doNotChangeSBT=doNotChangeSBT
    def set_isPublic(self, isPublic): self.isPublic=isPublic
    def set_id(self, id): self.id = id
    def set_caseNumber(self, caseNumber): self.caseNumber = caseNumber
    def set_commentBody(self, commentBody): self.commentBody=commentBody
    def set_createdDate(self, createdDate): self.createdDate=createdDate
    def set_createdByType(self, createdByType): self.createdByType=createdByType
    def set_isDraft(self, isDraft): self.isDraft=isDraft
    def set_lastModifiedById(self, lastModifiedById): self.lastModifiedById=lastModifiedById
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate=lastModifiedDate
    def set_publishedDate(self, publishedDate): self.publishedDate=publishedDate
    def set_createdBy(self, createdBy): self.createdBy=createdBy
    def set_contentType(self, contentType): self.contentType=contentType

    ####maintain consistency
    def get_lastModifiedBy(self): return self.lastModifiedById

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        doNotChangeSBT = from_union([from_bool, from_none], obj.get(u"doNotChangeSBT"))
        isPublic = from_union([from_bool, from_none], obj.get(u"isPublic"))
        id = from_union([from_str, from_none], obj.get(u"id"))
        caseNumber = from_union([from_str, from_none], obj.get(u"caseNumber"))
        commentBody = from_union([from_str, from_none], obj.get(u"commentBody"))
        createdDate = from_union([from_str, from_none], obj.get(u"createdDate"))
        createdByType = from_union([from_str, from_none], obj.get(u"createdByType"))
        isDraft = from_union([from_bool, from_none], obj.get(u"isDraft"))
        lastModifiedById = from_union([from_str, from_none], obj.get(u"lastModifiedById"))
        lastModifiedDate = from_union([from_str, from_none], obj.get(u"lastModifiedDate"))
        publishedDate = from_union([from_str, from_none], obj.get(u"publishedDate"))
        createdBy = from_union([from_str, from_none], obj.get(u"createdBy"))
        contentType = from_union([from_str, from_none], obj.get(u"contentType"))
        return Comment(doNotChangeSBT, isPublic, id, caseNumber, commentBody, createdDate, createdByType,
                       isDraft, lastModifiedById, lastModifiedDate, publishedDate, createdBy, contentType)

    def to_dict(self):
        result = {}
        result[u"doNotChangeSBT"] = from_union([from_bool, from_none], self.doNotChangeSBT)
        result[u"isPublic"] = from_union([from_bool, from_none], self.isPublic)
        result[u"id"] = from_union([from_str, from_none], self.id)
        result[u"caseNumber"] = from_union([from_str, from_none], self.caseNumber)
        result[u"commentBody"] = from_union([from_str, from_none], self.commentBody)
        result[u"createdDate"] = from_union([from_str, from_none], self.createdDate)
        result[u"createdByType"] = from_union([from_str, from_none], self.createdByType)
        result[u"isDraft"] = from_union([from_bool, from_none], self.isDraft)
        result[u"lastModifiedById"] = from_union([from_str, from_none], self.lastModifiedById)
        result[u"lastModifiedDate"] = from_union([from_str, from_none], self.lastModifiedDate)
        result[u"publishedDate"] = from_union([from_str, from_none], self.publishedDate)
        result[u"createdBy"] = from_union([from_str, from_none], self.createdBy)
        result[u"contentType"] = from_union([from_str, from_none], self.contentType)
        return result


def Commentfromdict(s):
    return Comment.from_dict(s)


def Commenttodict(x):
    return to_class(Comment, x)


def Commentsfromdict(s):
    return from_list(Comment.from_dict, s)


def Commentstodict(x):
    return from_list(lambda x: to_class(Comment, x), x)


class CaseResourceLink(object):
    """
    CaseResourceLink Class
    """
    def __init__(self, bucket=None, caseNumber=None, caseURI=None, externalCaseURI=None, isExact=None, linked=None,
                 linkedAt=None, linkedBy=None, origin=None, resourceId=None, resourceType=None, resourceURI=None,
                 resourceViewURI=None, title=None, solutionAbstract=None, solutionKcsState=None):
        self.bucket = bucket
        self.caseNumber = caseNumber
        self.caseURI = caseURI
        self.externalCaseURI = externalCaseURI
        self.isExact = isExact
        self.linked = linked
        self.linkedAt = linkedAt
        self.linkedBy = linkedBy
        self.origin = origin
        self.resourceId = resourceId
        self.resourceType = resourceType
        self.resourceURI = resourceURI
        self.resourceViewURI = resourceViewURI
        self.title = title
        self.solutionAbstract = solutionAbstract
        self.solutionKcsState = solutionKcsState

    def get_bucket(self): return self.bucket
    def get_caseNumber(self): return self.caseNumber
    def get_caseURI(self): return self.caseURI
    def get_externalCaseURI(self): return self.externalCaseURI
    def get_isExact(self): return self.isExact
    def get_linked(self): return self.linked
    def get_linkedAt(self): return self.linkedAt
    def get_linkedBy(self): return self.linkedBy
    def get_origin(self): return self.origin
    def get_resourceId(self): return self.resourceId
    def get_resourceType(self): return self.resourceType
    def get_resourceURI(self): return self.resourceURI
    def get_resourceViewURI(self): return self.resourceViewURI
    def get_title(self): return self.title
    def set_bucket(self, bucket): self.bucket=bucket
    def set_caseNumber(self, caseNumber): self.caseNumber=caseNumber
    def set_caseURI(self, caseURI): self.caseURI=caseURI
    def set_externalCaseURI(self, externalCaseURI): self.externalCaseURI=externalCaseURI
    def set_isExact(self, isExact): self.isExact=isExact
    def set_linked(self, linked): self.linked=linked
    def set_linkedAt(self, linkedAt): self.linkedAt=linkedAt
    def set_linkedBy(self, linkedBy): self.linkedBy=linkedBy
    def set_origin(self, origin): self.origin=origin
    def set_resourceId(self, resourceId): self.resourceId=resourceId
    def set_resourceType(self, resourceType): self.resourceType=resourceType
    def set_resourceURI(self, resourceURI): self.resourceURI=resourceURI
    def set_resourceViewURI(self, resourceViewURI): self.resourceViewURI=resourceViewURI
    def set_title(self, title): self.title=title
    def get_solutionKcsState(self): return self.solutionKcsState
    def get_solutionAbstract(self): return self.solutionAbstract
    def set_solutionKcsState(self, solutionKcsState): self.solutionKcsState=solutionKcsState
    def set_solutionAbstract(self, solutionAbstract): self.solutionAbstract=solutionAbstract

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        bucket = from_union([from_str, from_none], obj.get(u"bucket"))
        caseNumber = from_union([from_str, from_none], obj.get(u"caseNumber"))
        caseURI = from_union([from_str, from_none], obj.get(u"caseURI"))
        externalCaseURI = from_union([from_str, from_none], obj.get(u"externalCaseURI"))
        isExact = from_union([from_bool, from_none], obj.get(u"isExact"))
        linked = from_union([from_bool, from_none], obj.get(u"linked"))
        linkedAt = from_union([from_str, from_none], obj.get(u"linkedAt"))
        linkedBy = from_union([from_str, from_none], obj.get(u"linkedBy"))
        origin = from_union([from_str, from_none], obj.get(u"origin"))
        resourceId = from_union([from_str, from_none], obj.get(u"resourceId"))
        resourceType = from_union([from_str, from_none], obj.get(u"resourceType"))
        resourceURI = from_union([from_str, from_none], obj.get(u"resourceURI"))
        resourceViewURI = from_union([from_str, from_none], obj.get(u"resourceViewURI"))
        title = from_union([from_str, from_none], obj.get(u"title"))
        solutionAbstract = from_union([from_str, from_none], obj.get(u"solutionAbstract"))
        solutionKcsState = from_union([from_str, from_none], obj.get(u"solutionKcsState"))
        return CaseResourceLink(bucket, caseNumber, caseURI, externalCaseURI, isExact, linked, linkedAt, linkedBy,
                                origin, resourceId, resourceType, resourceURI, resourceViewURI, title, solutionAbstract,
                                solutionKcsState)

    def to_dict(self):
        result = {}
        result[u"bucket"] = from_union([from_str, from_none], self.bucket)
        result[u"caseNumber"] = from_union([from_str, from_none], self.caseNumber)
        result[u"caseURI"] = from_union([from_str, from_none], self.caseURI)
        result[u"externalCaseURI"] = from_union([from_str, from_none], self.externalCaseURI)
        result[u"isExact"] = from_union([from_bool, from_none], self.isExact)
        result[u"linked"] = from_union([from_bool, from_none], self.linked)
        result[u"linkedAt"] = from_union([from_str, from_none], self.linkedAt)
        result[u"linkedBy"] = from_union([from_str, from_none], self.linkedBy)
        result[u"origin"] = from_union([from_str, from_none], self.origin)
        result[u"resourceId"] = from_union([from_str, from_none], self.resourceId)
        result[u"resourceType"] = from_union([from_str, from_none], self.resourceType)
        result[u"resourceURI"] = from_union([from_str, from_none], self.resourceURI)
        result[u"resourceViewURI"] = from_union([from_str, from_none], self.resourceViewURI)
        result[u"title"] = from_union([from_str, from_none], self.title)
        result[u"solutionAbstract"] = from_union([from_str, from_none], self.solutionAbstract)
        result[u"solutionKcsState"] = from_union([from_str, from_none], self.solutionKcsState)
        return result


def CaseResourceLinkfromdict(s):
    return CaseResourceLink.from_dict(s)


def CaseResourceLinktodict(x):
    return to_class(CaseResourceLink, x)


class Case(object):
    """
    Case class
    """
    def __init__(self, alternateId=None, caseNumber=None, isClosed=None, id=None, summary=None, status=None,
                 product=None, version=None, caseType=None, accountNumberRef=None, description=None, uri=None,
                 internalStatus=None, comments=None, fts=None, entitlementSla=None, severity=None, groupNumber=None,
                 groupName=None, caseResourceLinks=None, origin=None, contactSSOName=None, contactName=None,
                 createdById=None, createdDate=None, lastModifiedById=None, lastModifiedDate=None, ownerId=None):
        self.alternateId = alternateId
        self.caseNumber = caseNumber
        self.isClosed = isClosed
        self.id = id
        self.summary = summary
        self.status = status
        self.product = product
        self.version = version
        self.caseType = caseType
        self.accountNumberRef = accountNumberRef
        self.description = description
        self.uri = uri
        self.internalStatus = internalStatus
        self.comments = comments
        self.fts = fts
        self.entitlementSla = entitlementSla
        self.severity = severity
        self.groupNumber = groupNumber
        self.groupName = groupName
        self.caseResourceLinks = caseResourceLinks
        self.origin = origin
        self.contactSSOName = contactSSOName
        self.contactName = contactName
        self.createdById = createdById
        self.createdDate = createdDate
        self.lastModifiedById = lastModifiedById
        self.lastModifiedDate = lastModifiedDate
        self.ownerId = ownerId

    def get_alternateId(self): return self.alternateId
    def get_caseNumber(self): return self.caseNumber
    def get_isClosed(self): return self.isClosed
    def get_id(self): return self.id
    def get_summary(self): return self.summary
    def get_status(self): return self.status
    def get_product(self): return self.product
    def get_version(self): return self.version
    def get_caseType(self): return self.caseType
    def get_accountNumberRef(self): return self.accountNumberRef
    def get_description(self): return self.description
    def get_uri(self): return self.uri
    def get_internalStatus(self): return self.internalStatus
    def get_comments(self): return self.comments
    def get_fts(self): return self.fts
    def get_entitlementSla(self): return self.entitlementSla
    def get_severity(self): return self.severity
    def get_groupNumber(self): return self.groupNumber
    def get_groupName(self): return self.groupName
    def get_caseResourceLinks(self): return self.caseResourceLinks
    def get_origin(self): return self.origin
    def get_contactSSOName(self): return self.contactSSOName
    def get_contactName(self): return self.contactName
    def get_createdById(self): return self.createdById
    def get_createdDate(self): return self.createdDate
    def get_lastModifiedById(self): return self.lastModifiedById
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_ownerId(self): return self.ownerId
    def set_alternateId(self, alternateId): self.alternateId=alternateId
    def set_caseNumber(self, caseNumber): self.caseNumber=caseNumber
    def set_isClosed(self, isClosed): self.isClosed=isClosed
    def set_id(self, id): self.id=id
    def set_summary(self, summary): self.summary=summary
    def set_status(self, status): self.status=status
    def set_product(self, product): self.product=product
    def set_version(self, version): self.version=version
    def set_caseType(self, caseType): self.caseType=caseType
    def set_accountNumberRef(self, accountNumberRef): self.accountNumberRef=accountNumberRef
    def set_description(self, description): self.description=description
    def set_uri(self, uri): self.uri=uri
    def set_internalStatus(self, internalStatus): self.internalStatus=internalStatus
    def set_comments(self, comments): self.comments=comments
    def set_fts(self, fts): self.fts=fts
    def set_entitlementSla(self, entitlementSla): self.entitlementSla=entitlementSla
    def set_severity(self, severity): self.severity=severity
    def set_groupNumber(self, groupNumber): self.groupNumber=groupNumber
    def set_groupName(self, groupName): self.groupName=groupName
    def set_caseResourceLinks(self, caseResourceLinks): self.caseResourceLinks=caseResourceLinks
    def set_origin(self, origin): self.origin=origin
    def set_contactSSOName(self, contactSSOName): self.contactSSOName=contactSSOName
    def set_contactName(self, contactName): self.contactName=contactName
    def set_createdById(self, createdById): self.createdById=createdById
    def set_createdDate(self, createdDate): self.createdDate=createdDate
    def set_lastModifiedById(self, lastModifiedById): self.lastModifiedById=lastModifiedById
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate=lastModifiedDate
    def set_ownerId(self, ownerId): self.ownerId=ownerId
    def get_view_uri(self): return None # to maintain consistency.

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        alternateId = from_union([from_str, from_none], obj.get(u"alternateId"))
        caseNumber = from_union([from_str, from_none], obj.get(u"caseNumber"))
        isClosed = from_union([from_bool, from_none], obj.get(u"isClosed"))
        id = from_union([from_str, from_none], obj.get(u"id"))
        summary = from_union([from_str, from_none], obj.get(u"summary"))
        status = from_union([from_str, from_none], obj.get(u"status"))
        product = from_union([from_str, from_none], obj.get(u"product"))
        version = from_union([from_str, from_none], obj.get(u"version"))
        caseType = from_union([from_str, from_none], obj.get(u"caseType"))
        accountNumberRef = from_union([from_str, from_none], obj.get(u"accountNumberRef"))
        description = from_union([from_str, from_none], obj.get(u"description"))
        uri = from_union([from_str, from_none], obj.get(u"uri"))
        internalStatus = from_union([from_str, from_none], obj.get(u"internalStatus"))
        comments = from_union([lambda x: from_list(Comment.from_dict, x), from_none], obj.get(u"comments"))
        fts = from_union([from_bool, from_none], obj.get(u"fts"))
        entitlementSla = from_union([from_str, from_none], obj.get(u"entitlementSla"))
        severity = from_union([from_str, from_none], obj.get(u"severity"))
        groupNumber = from_union([from_str, from_none], obj.get(u"groupNumber"))
        groupName = from_union([from_str, from_none], obj.get(u"groupName"))
        caseResourceLinks = from_union([lambda x: from_list(CaseResourceLink.from_dict, x), from_none], obj.get(u"caseResourceLinks"))
        origin = from_union([from_str, from_none], obj.get(u"origin"))
        contactSSOName = from_union([from_str, from_none], obj.get(u"contactSSOName"))
        contactName = from_union([from_str, from_none], obj.get(u"contactName"))
        createdById = from_union([from_str, from_none], obj.get(u"createdById"))
        createdDate = from_union([from_str, from_none], obj.get(u"createdDate"))
        lastModifiedById = from_union([from_str, from_none], obj.get(u"lastModifiedById"))
        lastModifiedDate = from_union([from_str, from_none], obj.get(u"lastModifiedDate"))
        ownerId = from_union([from_str, from_none], obj.get(u"ownerId"))
        return Case(alternateId, caseNumber, isClosed, id, summary, status, product, version, caseType,
                    accountNumberRef, description, uri, internalStatus, comments, fts, entitlementSla, severity,
                    groupNumber, groupName, caseResourceLinks, origin, contactSSOName, contactName, createdById,
                    createdDate, lastModifiedById, lastModifiedDate, ownerId)

    def to_dict(self):
        result = {}
        result[u"alternateId"] = from_union([from_str, from_none], self.alternateId)
        result[u"caseNumber"] = from_union([from_str, from_none], self.caseNumber)
        result[u"isClosed"] = from_union([from_bool, from_none], self.isClosed)
        result[u"id"] = from_union([from_str, from_none], self.id)
        result[u"summary"] = from_union([from_str, from_none], self.summary)
        result[u"status"] = from_union([from_str, from_none], self.status)
        result[u"product"] = from_union([from_str, from_none], self.product)
        result[u"version"] = from_union([from_str, from_none], self.version)
        result[u"caseType"] = from_union([from_str, from_none], self.caseType)
        result[u"accountNumberRef"] = from_union([from_str, from_none], self.accountNumberRef)
        result[u"description"] = from_union([from_str, from_none], self.description)
        result[u"uri"] = from_union([from_str, from_none], self.uri)
        result[u"internalStatus"] = from_union([from_str, from_none], self.internalStatus)
        result[u"comments"] = from_union([lambda x: from_list(lambda x: to_class(Comment, x), x), from_none], self.comments)
        result[u"fts"] = from_union([from_bool, from_none], self.fts)
        result[u"entitlementSla"] = from_union([from_str, from_none], self.entitlementSla)
        result[u"severity"] = from_union([from_str, from_none], self.severity)
        result[u"groupNumber"] = from_union([from_str, from_none], self.groupNumber)
        result[u"groupName"] = from_union([from_str, from_none], self.groupName)
        result[u"caseResourceLinks"] = from_union([lambda x: from_list(lambda x: to_class(CaseResourceLink, x), x), from_none], self.caseResourceLinks)
        result[u"origin"] = from_union([from_str, from_none], self.origin)
        result[u"contactSSOName"] = from_union([from_str, from_none], self.contactSSOName)
        result[u"contactName"] = from_union([from_str, from_none], self.contactName)
        result[u"createdById"] = from_union([from_str, from_none], self.createdById)
        result[u"createdDate"] = from_union([from_str, from_none], self.createdDate)
        result[u"lastModifiedById"] = from_union([from_str, from_none], self.lastModifiedById)
        result[u"lastModifiedDate"] = from_union([from_str, from_none], self.lastModifiedDate)
        result[u"ownerId"] = from_union([from_str, from_none], self.ownerId)
        return result

    def convert_to_dict(self):
        return Casetodict(self)


def Casefromdict(s):
    return Case.from_dict(s)


def Casetodict(x):
    return to_class(Case, x)


def Casesfromdict(s):
    return from_list(Case.from_dict, s)


def Casestodict(x):
    return from_list(lambda x: to_class(Case, x), x)


class KCSDescription(object):
    def __init__(self, text=None, html=None):
        self.text = text
        self.html = html

    def get_text(self): return self.text
    def get_html(self): return self.html
    def set_text(self, text): self.text=text
    def set_html(self, html): self.html=html


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        text = from_union([from_str, from_none], obj.get(u"text"))
        html = from_union([from_str, from_none], obj.get(u"html"))
        return KCSDescription(text, html)

    def to_dict(self):
        result = {}
        result[u"text"] = from_union([from_str, from_none], self.text)
        result[u"html"] = from_union([from_str, from_none], self.html)
        return result


def KCSDescriptionfromdict(s):
    return KCSDescription.from_dict(s)


def KCSDescriptiontodict(x):
    return to_class(KCSDescription, x)


class Contact(object):
    def __init__(self, canAccessAllAccounts=None, canAddAttachments=None, email=None, firstName=None, hasChat=None,
                 hasUser=None, isEntitled=None, isInternal=None, isOrgAdmin=None, lastName=None, name=None,
                 normalizedTZ=None, phone=None, secureSupportTech=None, ssoUsername=None, timezone=None):
        self.canAccessAllAccounts = canAccessAllAccounts
        self.canAddAttachments = canAddAttachments
        self.email = email
        self.firstName = firstName
        self.hasChat = hasChat
        self.hasUser = hasUser
        self.isEntitled = isEntitled
        self.isInternal = isInternal
        self.isOrgAdmin = isOrgAdmin
        self.lastName = lastName
        self.name = name
        self.normalizedTZ = normalizedTZ
        self.phone = phone
        self.secureSupportTech = secureSupportTech
        self.ssoUsername = ssoUsername
        self.timezone = timezone

    def get_canAccessAllAccounts(self): return self.canAccessAllAccounts
    def get_canAddAttachments(self): return self.canAddAttachments
    def get_email(self): return self.email
    def get_firstName(self): return self.firstName
    def get_hasChat(self): return self.hasChat
    def get_hasUser(self): return self.hasUser
    def get_isEntitled(self): return self.isEntitled
    def get_isInternal(self): return self.isInternal
    def get_isOrgAdmin(self): return self.isOrgAdmin
    def get_lastName(self): return self.lastName
    def get_name(self): return self.name
    def get_normalizedTZ(self): return self.normalizedTZ
    def get_phone(self): return self.phone
    def get_secureSupportTech(self): return self.secureSupportTech
    def get_ssoUsername(self): return self.ssoUsername
    def get_timezone(self): return self.timezone
    def set_canAccessAllAccounts(self, canAccessAllAccounts): self.canAccessAllAccounts=canAccessAllAccounts
    def set_canAddAttachments(self, canAddAttachments): self.canAddAttachments=canAddAttachments
    def set_email(self, email): self.email=email
    def set_firstName(self, firstName): self.firstName=firstName
    def set_hasChat(self, hasChat): self.hasChat=hasChat
    def set_hasUser(self, hasUser): self.hasUser=hasUser
    def set_isEntitled(self, isEntitled): self.isEntitled=isEntitled
    def set_isInternal(self, isInternal): self.isInternal=isInternal
    def set_isOrgAdmin(self, isOrgAdmin): self.isOrgAdmin=isOrgAdmin
    def set_lastName(self, lastName): self.lastName=lastName
    def set_name(self, name): self.name=name
    def set_normalizedTZ(self, normalizedTZ): self.normalizedTZ=normalizedTZ
    def set_phone(self, phone): self.phone=phone
    def set_secureSupportTech(self, secureSupportTech): self.secureSupportTech=secureSupportTech
    def set_ssoUsername(self, ssoUsername): self.ssoUsername=ssoUsername
    def set_timezone(self, timezone): self.timezone=timezone

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        canAccessAllAccounts = from_union([from_bool, from_none], obj.get(u"canAccessAllAccounts"))
        canAddAttachments = from_union([from_bool, from_none], obj.get(u"canAddAttachments"))
        email = from_union([from_str, from_none], obj.get(u"email"))
        firstName = from_union([from_str, from_none], obj.get(u"firstName"))
        hasChat = from_union([from_bool, from_none], obj.get(u"hasChat"))
        hasUser = from_union([from_bool, from_none], obj.get(u"hasUser"))
        isEntitled = from_union([from_bool, from_none], obj.get(u"isEntitled"))
        isInternal = from_union([from_bool, from_none], obj.get(u"isInternal"))
        isOrgAdmin = from_union([from_bool, from_none], obj.get(u"isOrgAdmin"))
        lastName = from_union([from_str, from_none], obj.get(u"lastName"))
        name = from_union([from_str, from_none], obj.get(u"name"))
        normalizedTZ = from_union([from_str, from_none], obj.get(u"normalizedTZ"))
        phone = from_union([from_str, from_none], obj.get(u"phone"))
        secureSupportTech = from_union([from_bool, from_none], obj.get(u"secureSupportTech"))
        ssoUsername = from_union([from_str, from_none], obj.get(u"ssoUsername"))
        timezone = from_union([from_str, from_none], obj.get(u"timezone"))
        return Contact(canAccessAllAccounts, canAddAttachments, email, firstName, hasChat, hasUser,
                       isEntitled, isInternal, isOrgAdmin, lastName, name, normalizedTZ, phone, secureSupportTech,
                       ssoUsername, timezone)

    def to_dict(self):
        result = {}
        result[u"canAccessAllAccounts"] = from_union([from_bool, from_none], self.canAccessAllAccounts)
        result[u"canAddAttachments"] = from_union([from_bool, from_none], self.canAddAttachments)
        result[u"email"] = from_union([from_str, from_none], self.email)
        result[u"firstName"] = from_union([from_str, from_none], self.firstName)
        result[u"hasChat"] = from_union([from_bool, from_none], self.hasChat)
        result[u"hasUser"] = from_union([from_bool, from_none], self.hasUser)
        result[u"isEntitled"] = from_union([from_bool, from_none], self.isEntitled)
        result[u"isInternal"] = from_union([from_bool, from_none], self.isInternal)
        result[u"isOrgAdmin"] = from_union([from_bool, from_none], self.isOrgAdmin)
        result[u"lastName"] = from_union([from_str, from_none], self.lastName)
        result[u"name"] = from_union([from_str, from_none], self.name)
        result[u"normalizedTZ"] = from_union([from_str, from_none], self.normalizedTZ)
        result[u"phone"] = from_union([from_str, from_none], self.phone)
        result[u"secureSupportTech"] = from_union([from_bool, from_none], self.secureSupportTech)
        result[u"ssoUsername"] = from_union([from_str, from_none], self.ssoUsername)
        result[u"timezone"] = from_union([from_str, from_none], self.timezone)
        return result


def Contactfromdict(s):
    return Contact.from_dict(s)


def Contacttodict(x):
    return to_class(Contact, x)


def Contactsfromdict(s):
    return from_list(Contact.from_dict, s)


def Contactstodict(x):
    return from_list(lambda x: to_class(Contact, x), x)


class Values(object):
    """
    Values Class for mapping list of strings
    """
    def __init__(self, items=None):
        self.items = items

    def get_values(self): return self.items

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        items = from_union([lambda x: from_list(from_str, x), from_none], obj.get(u"items"))
        return Values(items)

    def to_dict(self):
        result = {}
        result[u"items"] = from_union([lambda x: from_list(from_str, x), from_none], self.items)
        return result


def Valuesfromdict(s):
    return Values.from_dict(s)


def Valuestodict(x):
    return to_class(Values, x)


class KCSSearch(object):
    def __init__(self, documentKind=None, uri=None, path=None, viewuri=None, title=None,
                 allTitle=None, sortTitle=None, id=None, solutionid=None, authorSSOName=None, lastModifiedBySSOName=None,
                 hasPublishedRevision=None, body=None, issue=None, issueTag=None, lastModifiedDate=None, displayDate=None,
                 createdDate=None, kcsState=None, ModerationState=None, accessState=None, abstract=None, publishedTitle=None,
                 publishedAbstract=None, publicationstate=None, titlestring=None, issuestring=None, resourceuri=None):
        self.documentKind = documentKind
        self.uri = uri
        self.path = path
        self.viewuri = viewuri
        self.title = title
        self.allTitle = allTitle
        self.sortTitle = sortTitle
        self.id = id
        self.solutionid = solutionid
        self.authorSSOName = authorSSOName
        self.lastModifiedBySSOName = lastModifiedBySSOName
        self.hasPublishedRevision = hasPublishedRevision
        self.body = body
        self.issue = issue
        self.issueTag = issueTag
        self.lastModifiedDate = lastModifiedDate
        self.displayDate = displayDate
        self.createdDate = createdDate
        self.kcsState = kcsState
        self.ModerationState = ModerationState
        self.accessState = accessState
        self.abstract = abstract
        self.publishedTitle = publishedTitle
        self.publishedAbstract = publishedAbstract
        self.publicationstate = publicationstate
        self.titlestring = titlestring
        self.issuestring = issuestring
        self.resourceuri = resourceuri

    def get_title(self): return self.title
    def get_abstract(self): return self.abstract
    def get_id(self): return self.id
    def get_kcsState(self): return self.kcsState
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_view_uri(self): return self.viewuri
    def get_uri(self): return self.uri
    def get_resource_uri(self): return self.resourceuri
    def get_ModerationState(self): return self.ModerationState
    def get_publishedAbstract(self): return self.publishedAbstract
    def get_documentKind(self): return self.documentKind
    def get_path(self): return self.path
    def get_allTitle(self): return self.allTitle
    def get_sortTitle(self): return self.sortTitle
    def get_solutionid(self): return self.solutionid
    def get_authorSSOName(self): return self.authorSSOName
    def get_lastModifiedBySSOName(self): return self.lastModifiedBySSOName
    def get_hasPublishedRevision(self): return self.hasPublishedRevision
    def get_body(self): return self.body
    def get_issue(self): return self.issue
    def get_issueTag(self): return self.issueTag
    def get_displayDate(self): return self.displayDate
    def get_createdDate(self): return self.createdDate
    def get_accessState(self): return self.accessState
    def get_publishedTitle(self): return self.publishedTitle
    def get_publication_state(self): return self.publicationstate
    def get_title_string(self): return self.titlestring
    def get_issue_string(self): return self.issuestring
    def set_documentKind(self, documentKind): self.documentKind=documentKind
    def set_uri(self, uri): self.uri=uri
    def set_path(self, path): self.path=path
    def set_view_uri(self, view_uri): self.viewuri=view_uri
    def set_resource_uri(self, resource_uri): self.resourceuri = resource_uri
    def set_title(self, title): self.title=title
    def set_allTitle(self, allTitle): self.allTitle=allTitle
    def set_sortTitle(self, sortTitle): self.sortTitle=sortTitle
    def set_id(self, id): self.id=id
    def set_solutionid(self, solutionid): self.solutionid=solutionid
    def set_authorSSOName(self, authorSSOName): self.authorSSOName=authorSSOName
    def set_lastModifiedBySSOName(self, lastModifiedBySSOName): self.lastModifiedBySSOName=lastModifiedBySSOName
    def set_hasPublishedRevision(self, hasPublishedRevision): self.hasPublishedRevision=hasPublishedRevision
    def set_body(self, body): self.body=body
    def set_issue(self, issue): self.issue=issue
    def set_issueTag(self, issueTag): self.issueTag=issueTag
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate=lastModifiedDate
    def set_displayDate(self, displayDate): self.displayDate=displayDate
    def set_createdDate(self, createdDate): self.createdDate=createdDate
    def set_kcsState(self, kcsState): self.kcsState=kcsState
    def set_ModerationState(self, ModerationState): self.ModerationState=ModerationState
    def set_accessState(self, accessState): self.accessState=accessState
    def set_abstract(self, abstract): self.abstract=abstract
    def set_publishedTitle(self, publishedTitle): self.publishedTitle=publishedTitle
    def set_publishedAbstract(self, publishedAbstract): self.publishedAbstract=publishedAbstract
    def set_publication_state(self, publication_state): self.publicationstate=publication_state
    def set_title_string(self, title_string): self.titlestring=title_string
    def set_issue_string(self, issue_string): self.issuestring=issue_string

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        documentKind = from_union([from_str, from_none], obj.get(u"documentKind"))
        uri = from_union([from_str, from_none], obj.get(u"uri"))
        path = from_union([from_str, from_none], obj.get(u"path"))
        viewuri = from_union([from_str, from_none], obj.get(u"view_uri"))
        resourceuri = from_union([from_str, from_none], obj.get(u"resource_uri"))
        title = from_union([from_str, from_none], obj.get(u"title"))
        allTitle = from_union([from_str, from_none], obj.get(u"allTitle"))
        sortTitle = from_union([from_str, from_none], obj.get(u"sortTitle"))
        id = from_union([from_str, from_none], obj.get(u"id"))
        solutionid = from_union([from_str, from_none], obj.get(u"solution.id"))
        authorSSOName = from_union([from_str, from_none], obj.get(u"authorSSOName"))
        lastModifiedBySSOName = from_union([from_str, from_none], obj.get(u"lastModifiedBySSOName"))
        hasPublishedRevision = from_union([from_any, from_none], obj.get(u"hasPublishedRevision"))
        body = from_union([lambda x: from_list(from_str, x), from_none], obj.get(u"body"))
        issue = from_union([lambda x: from_list(from_str, x), from_none], obj.get(u"issue"))
        issueTag = from_union([lambda x: from_list(from_str, x), from_none], obj.get(u"issueTag"))
        lastModifiedDate = from_union([from_str, from_none], obj.get(u"lastModifiedDate"))
        displayDate = from_union([from_str, from_none], obj.get(u"displayDate"))
        createdDate = from_union([from_str, from_none], obj.get(u"createdDate"))
        kcsState = from_union([from_str, from_none], obj.get(u"kcsState"))
        ModerationState = from_union([from_str, from_none], obj.get(u"ModerationState"))
        accessState = from_union([from_str, from_none], obj.get(u"accessState"))
        abstract = from_union([from_str, from_none], obj.get(u"abstract"))
        publishedTitle = from_union([from_str, from_none], obj.get(u"publishedTitle"))
        publishedAbstract = from_union([from_str, from_none], obj.get(u"publishedAbstract"))
        publicationstate = from_union([from_str, from_none], obj.get(u"publication_state"))
        titlestring = from_union([from_str, from_none], obj.get(u"title_string"))
        issuestring = from_union([from_str, from_none], obj.get(u"issue_string"))
        return KCSSearch(documentKind, uri, path, viewuri, title, allTitle, sortTitle, id, solutionid,
                         authorSSOName, lastModifiedBySSOName, hasPublishedRevision, body, issue, issueTag,
                         lastModifiedDate, displayDate, createdDate, kcsState, ModerationState, accessState, abstract,
                         publishedTitle, publishedAbstract, publicationstate, titlestring, issuestring, resourceuri)

    def to_dict(self):
        result = {}
        result[u"documentKind"] = from_union([from_str, from_none], self.documentKind)
        result[u"uri"] = from_union([from_str, from_none], self.uri)
        result[u"path"] = from_union([from_str, from_none], self.path)
        result[u"view_uri"] = from_union([from_str, from_none], self.viewuri)
        result[u"resource_uri"] = from_union([from_str, from_none], self.resourceuri)
        result[u"title"] = from_union([from_str, from_none], self.title)
        result[u"allTitle"] = from_union([from_str, from_none], self.allTitle)
        result[u"sortTitle"] = from_union([from_str, from_none], self.sortTitle)
        result[u"id"] = from_union([from_str, from_none], self.id)
        result[u"solution.id"] = from_union([from_str, from_none], self.solutionid)
        result[u"authorSSOName"] = from_union([from_str, from_none], self.authorSSOName)
        result[u"lastModifiedBySSOName"] = from_union([from_str, from_none], self.lastModifiedBySSOName)
        result[u"hasPublishedRevision"] = from_union([from_any, from_none], self.hasPublishedRevision)
        result[u"body"] = from_union([lambda x: from_list(from_str, x), from_none], self.body)
        result[u"issue"] = from_union([lambda x: from_list(from_str, x), from_none], self.issue)
        result[u"issueTag"] = from_union([lambda x: from_list(from_str, x), from_none], self.issueTag)
        result[u"lastModifiedDate"] = from_union([from_str, from_none], self.lastModifiedDate)
        result[u"displayDate"] = from_union([from_str, from_none], self.displayDate)
        result[u"createdDate"] = from_union([from_str, from_none], self.createdDate)
        result[u"kcsState"] = from_union([from_str, from_none], self.kcsState)
        result[u"ModerationState"] = from_union([from_str, from_none], self.ModerationState)
        result[u"accessState"] = from_union([from_str, from_none], self.accessState)
        result[u"abstract"] = from_union([from_str, from_none], self.abstract)
        result[u"publishedTitle"] = from_union([from_str, from_none], self.publishedTitle)
        result[u"publishedAbstract"] = from_union([from_str, from_none], self.publishedAbstract)
        result[u"publication_state"] = from_union([from_str, from_none], self.publicationstate)
        result[u"title_string"] = from_union([from_str, from_none], self.titlestring)
        result[u"issue_string"] = from_union([from_str, from_none], self.issuestring)
        return result


def KCSSearchfromdict(s):
    return KCSSearch.from_dict(s)


def KCSSearchtodict(x):
    return to_class(KCSSearch, x)


def KCSSearchesfromdict(s):
    return from_list(KCSSearch.from_dict, s)


def KCSSearchestodict(x):
    return from_list(lambda x: to_class(KCSSearch, x), x)


class CaseFilter(object):
    def __init__(self, associateSSOName=None, endDate=None, includeClosed=None, maxResults=None, offset=None,
                 severity=None, sortField=None, sortOrder=None, startDate=None, status=None, view=None, accountNumber=None,
                 groupNumber=None, groupNumbers=None, includePrivate=None, keyword=None, onlyUngrouped=None,
                 ownerSSOName=None, product=None, type=None):
        self.associateSSOName = associateSSOName
        self.endDate = endDate
        self.includeClosed = includeClosed
        self.maxResults = maxResults
        self.offset = offset
        self.severity = severity
        self.sortField = sortField
        self.sortOrder = sortOrder
        self.startDate = startDate
        self.status = status
        self.view = view
        self.accountNumber = accountNumber
        self.groupNumber = groupNumber
        self.groupNumbers = groupNumbers
        self.includePrivate = includePrivate
        self.keyword = keyword
        self.onlyUngrouped = onlyUngrouped
        self.ownerSSOName = ownerSSOName
        self.product = product
        self.type = type

    def get_associateSSOName(self): return self.associateSSOName
    def get_endDate(self): return self.endDate
    def get_includeClosed(self): return self.includeClosed
    def get_maxResults(self): return self.maxResults
    def get_offset(self): return self.offset
    def get_severity(self): return self.severity
    def get_sortField(self): return self.sortField
    def get_sortOrder(self): return self.sortOrder
    def get_startDate(self): return self.startDate
    def get_status(self): return self.status
    def get_view(self): return self.view
    def get_accountNumber(self): return self.accountNumber
    def get_groupNumber(self): return self.groupNumber
    def get_groupNumbers(self): return self.groupNumbers
    def get_includePrivate(self): return self.includePrivate
    def get_keyword(self): return self.keyword
    def get_onlyUngrouped(self): return self.onlyUngrouped
    def get_ownerSSOName(self): return self.ownerSSOName
    def get_product(self): return self.product
    def get_type(self): return self.type
    def set_associateSSOName(self, associateSSOName): self.associateSSOName=associateSSOName
    def set_endDate(self, endDate): self.endDate=endDate
    def set_includeClosed(self, includeClosed): self.includeClosed=includeClosed
    def set_maxResults(self, maxResults): self.maxResults=maxResults
    def set_offset(self, offset): self.offset=offset
    def set_severity(self, severity): self.severity=severity
    def set_sortField(self, sortField): self.sortField=sortField
    def set_sortOrder(self, sortOrder): self.sortOrder=sortOrder
    def set_startDate(self, startDate): self.startDate=startDate
    def set_status(self, status): self.status=status
    def set_view(self, view): self.view=view
    def set_accountNumber(self, accountNumber): self.accountNumber=accountNumber
    def set_groupNumber(self, groupNumber): self.groupNumber=groupNumber
    def set_groupNumbers(self, groupNumbers): self.groupNumbers=groupNumbers
    def set_includePrivate(self, includePrivate): self.includePrivate=includePrivate
    def set_keyword(self, keyword): self.keyword=keyword
    def set_onlyUngrouped(self, onlyUngrouped): self.onlyUngrouped=onlyUngrouped
    def set_ownerSSOName(self, ownerSSOName): self.ownerSSOName=ownerSSOName
    def set_product(self, product): self.product=product
    def set_type(self, type): self.type=type


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        associateSSOName = from_union([from_str, from_none], obj.get(u"associateSSOName"))
        endDate = from_union([from_str, from_none], obj.get(u"endDate"))
        includeClosed = from_union([from_bool, from_none], obj.get(u"includeClosed"))
        maxResults = from_union([from_any, from_none], obj.get(u"maxResults"))
        offset = from_union([from_any, from_none], obj.get(u"offset"))
        severity = from_union([from_str, from_none], obj.get(u"severity"))
        sortField = from_union([from_str, from_none], obj.get(u"sortField"))
        sortOrder = from_union([from_str, from_none], obj.get(u"sortOrder"))
        startDate = from_union([from_str, from_none], obj.get(u"startDate"))
        status = from_union([from_str, from_none], obj.get(u"status"))
        view = from_union([from_str, from_none], obj.get(u"view"))
        accountNumber = from_union([from_str, from_none], obj.get(u"accountNumber"))
        groupNumber = from_union([from_str, from_none], obj.get(u"groupNumber"))
        groupNumbers = from_union([lambda x: from_list(from_str, x), from_none], obj.get(u"groupNumbers"))
        includePrivate = from_union([from_bool, from_none], obj.get(u"includePrivate"))
        keyword = from_union([from_str, from_none], obj.get(u"keyword"))
        onlyUngrouped = from_union([from_bool, from_none], obj.get(u"onlyUngrouped"))
        ownerSSOName = from_union([from_str, from_none], obj.get(u"ownerSSOName"))
        product = from_union([from_str, from_none], obj.get(u"product"))
        type = from_union([from_str, from_none], obj.get(u"type"))
        return CaseFilter(associateSSOName, endDate, includeClosed, maxResults, offset, severity, sortField, sortOrder,
                          startDate, status, view, accountNumber, groupNumber, groupNumbers, includePrivate, keyword,
                          onlyUngrouped, ownerSSOName, product, type)

    def to_dict(self):
        result = {}
        result[u"associateSSOName"] = from_union([from_str, from_none], self.associateSSOName)
        result[u"endDate"] = from_union([from_str, from_none], self.endDate)
        result[u"includeClosed"] = from_union([from_bool, from_none], self.includeClosed)
        result[u"maxResults"] = from_union([from_any, from_none], self.maxResults)
        result[u"offset"] = from_union([from_any, from_none], self.offset)
        result[u"severity"] = from_union([from_str, from_none], self.severity)
        result[u"sortField"] = from_union([from_str, from_none], self.sortField)
        result[u"sortOrder"] = from_union([from_str, from_none], self.sortOrder)
        result[u"startDate"] = from_union([from_str, from_none], self.startDate)
        result[u"status"] = from_union([from_str, from_none], self.status)
        result[u"view"] = from_union([from_str, from_none], self.view)
        result[u"accountNumber"] = from_union([from_str, from_none], self.accountNumber)
        result[u"groupNumber"] = from_union([from_str, from_none], self.groupNumber)
        result[u"groupNumbers"] = from_union([lambda x: from_list(from_str, x), from_none], self.groupNumbers)
        result[u"includePrivate"] = from_union([from_bool, from_none], self.includePrivate)
        result[u"keyword"] = from_union([from_str, from_none], self.keyword)
        result[u"onlyUngrouped"] = from_union([from_bool, from_none], self.onlyUngrouped)
        result[u"ownerSSOName"] = from_union([from_str, from_none], self.ownerSSOName)
        result[u"product"] = from_union([from_str, from_none], self.product)
        result[u"type"] = from_union([from_str, from_none], self.type)
        return result


def CaseFilterfromdict(s):
    return CaseFilter.from_dict(s)


def CaseFiltertodict(x):
    return to_class(CaseFilter, x)


def CaseFiltersfromdict(s):
    return from_list(CaseFilter.from_dict, s)


def CaseFilterstodict(x):
    return from_list(lambda x: to_class(CaseFilter, x), x)


class Solution(object):
    def __init__(self, issue=None, environment=None, resolution=None, rootCause=None, diagnosticSteps=None,
                 kcsState=None, uri=None, id=None, title=None, language=None, authorSSOName=None,
                 lastModifiedBySSOName=None, viewURI=None, privateNotes=None, hasPublishedRevision=None,
                 moderationState=None, accessState=None, lastModifiedDate=None, createdDate=None):
        self.issue = issue
        self.environment = environment
        self.resolution = resolution
        self.rootCause = rootCause
        self.diagnosticSteps = diagnosticSteps
        self.kcsState = kcsState
        self.uri = uri
        self.id = id
        self.title = title
        self.language = language
        self.authorSSOName = authorSSOName
        self.lastModifiedBySSOName = lastModifiedBySSOName
        self.viewURI = viewURI
        self.privateNotes = privateNotes
        self.hasPublishedRevision = hasPublishedRevision
        self.moderationState = moderationState
        self.accessState = accessState
        self.lastModifiedDate = lastModifiedDate
        self.createdDate = createdDate

    def get_issue(self): return self.issue
    def get_environment(self): return self.environment
    def get_resolution(self): return self.resolution
    def get_rootCause(self): return self.rootCause
    def get_diagnosticSteps(self): return self.diagnosticSteps
    def get_kcsState(self): return self.kcsState
    def get_uri(self): return self.uri
    def get_id(self): return self.id
    def get_title(self): return self.title
    def get_language(self): return self.language
    def get_authorSSOName(self): return self.authorSSOName
    def get_lastModifiedBySSOName(self): return self.lastModifiedBySSOName
    def get_viewURI(self): return self.viewURI
    def get_privateNotes(self): return self.privateNotes
    def get_hasPublishedRevision(self): return self.hasPublishedRevision
    def get_moderationState(self): return self.moderationState
    def get_accessState(self): return self.accessState
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_createdDate(self): return self.createdDate
    def set_issue(self, issue): self.issue=issue
    def set_environment(self, environment): self.environment=environment
    def set_resolution(self, resolution): self.resolution=resolution
    def set_rootCause(self, rootCause): self.rootCause=rootCause
    def set_diagnosticSteps(self, diagnosticSteps): self.diagnosticSteps=diagnosticSteps
    def set_kcsState(self, kcsState): self.kcsState=kcsState
    def set_uri(self, uri): self.uri=uri
    def set_id(self, id): self.id=id
    def set_title(self, title): self.title=title
    def set_language(self, language): self.language=language
    def set_authorSSOName(self, authorSSOName): self.authorSSOName=authorSSOName
    def set_lastModifiedBySSOName(self, lastModifiedBySSOName): self.lastModifiedBySSOName=lastModifiedBySSOName
    def set_viewURI(self, viewURI): self.viewURI=viewURI
    def set_privateNotes(self, privateNotes): self.privateNotes=privateNotes
    def set_hasPublishedRevision(self, hasPublishedRevision): self.hasPublishedRevision=hasPublishedRevision
    def set_moderationState(self, moderationState): self.moderationState=moderationState
    def set_accessState(self, accessState): self.accessState=accessState
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate=lastModifiedDate
    def set_createdDate(self, createdDate): self.createdDate=createdDate


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        issue = from_union([KCSDescription.from_dict, from_none], obj.get(u"issue"))
        environment = from_union([KCSDescription.from_dict, from_none], obj.get(u"environment"))
        resolution = from_union([KCSDescription.from_dict, from_none], obj.get(u"resolution"))
        rootCause = from_union([KCSDescription.from_dict, from_none], obj.get(u"rootCause"))
        diagnosticSteps = from_union([KCSDescription.from_dict, from_none], obj.get(u"diagnosticSteps"))
        kcsState = from_union([from_str, from_none], obj.get(u"kcsState"))
        uri = from_union([from_str, from_none], obj.get(u"uri"))
        id = from_union([from_any, from_none], obj.get(u"id"))
        title = from_union([from_str, from_none], obj.get(u"title"))
        language = from_union([from_str, from_none], obj.get(u"language"))
        authorSSOName = from_union([from_str, from_none], obj.get(u"authorSSOName"))
        lastModifiedBySSOName = from_union([from_str, from_none], obj.get(u"lastModifiedBySSOName"))
        viewURI = from_union([from_str, from_none], obj.get(u"viewURI"))
        privateNotes = from_union([KCSDescription.from_dict, from_none], obj.get(u"privateNotes"))
        hasPublishedRevision = from_union([from_bool, from_none], obj.get(u"hasPublishedRevision"))
        moderationState = from_union([from_str, from_none], obj.get(u"moderationState"))
        accessState = from_union([from_str, from_none], obj.get(u"accessState"))
        lastModifiedDate = from_union([from_str, from_none], obj.get(u"lastModifiedDate"))
        createdDate = from_union([from_str, from_none], obj.get(u"createdDate"))
        return Solution(issue, environment, resolution, rootCause, diagnosticSteps, kcsState, uri, id, title, language,
                        authorSSOName, lastModifiedBySSOName, viewURI, privateNotes, hasPublishedRevision,
                        moderationState, accessState, lastModifiedDate, createdDate)

    def to_dict(self):
        result = {}
        result[u"issue"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.issue)
        result[u"environment"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.environment)
        result[u"resolution"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.resolution)
        result[u"rootCause"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.rootCause)
        result[u"diagnosticSteps"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.diagnosticSteps)
        result[u"kcsState"] = from_union([from_str, from_none], self.kcsState)
        result[u"uri"] = from_union([from_str, from_none], self.uri)
        result[u"id"] = from_union([from_any, from_none], self.id)
        result[u"title"] = from_union([from_str, from_none], self.title)
        result[u"language"] = from_union([from_str, from_none], self.language)
        result[u"authorSSOName"] = from_union([from_str, from_none], self.authorSSOName)
        result[u"lastModifiedBySSOName"] = from_union([from_str, from_none], self.lastModifiedBySSOName)
        result[u"viewURI"] = from_union([from_str, from_none], self.viewURI)
        result[u"privateNotes"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.privateNotes)
        result[u"hasPublishedRevision"] = from_union([from_bool, from_none], self.hasPublishedRevision)
        result[u"moderationState"] = from_union([from_str, from_none], self.moderationState)
        result[u"accessState"] = from_union([from_str, from_none], self.accessState)
        result[u"lastModifiedDate"] = from_union([from_str, from_none], self.lastModifiedDate)
        result[u"createdDate"] = from_union([from_str, from_none], self.createdDate)
        return result


def Solutionfromdict(s):
    return Solution.from_dict(s)


def Solutiontodict(x):
    return to_class(Solution, x)


def Solutionsfromdict(s):
    return from_list(Solution.from_dict, s)


def Solutionstodict(x):
    return from_list(lambda x: to_class(Solution, x), x)


class Article(object):
    def __init__(self, body=None, bodyAbstract=None, uri=None, id=None, title=None, language=None, authorSSOName=None,
                 lastModifiedBySSOName=None, viewURI=None, privateNotes=None, hasPublishedRevision=None,
                 moderationState=None, accessState=None, lastModifiedDate=None, createdDate=None):
        self.body = body
        self.bodyAbstract = bodyAbstract
        self.uri = uri
        self.id = id
        self.title = title
        self.language = language
        self.authorSSOName = authorSSOName
        self.lastModifiedBySSOName = lastModifiedBySSOName
        self.viewURI = viewURI
        self.privateNotes = privateNotes
        self.hasPublishedRevision = hasPublishedRevision
        self.moderationState = moderationState
        self.accessState = accessState
        self.lastModifiedDate = lastModifiedDate
        self.createdDate = createdDate

    def get_body(self): return self.body
    def get_bodyAbstract(self): return self.bodyAbstract
    def get_uri(self): return self.uri
    def get_id(self): return self.id
    def get_title(self): return self.title
    def get_language(self): return self.language
    def get_authorSSOName(self): return self.authorSSOName
    def get_lastModifiedBySSOName(self): return self.lastModifiedBySSOName
    def get_viewURI(self): return self.viewURI
    def get_privateNotes(self): return self.privateNotes
    def get_hasPublishedRevision(self): return self.hasPublishedRevision
    def get_moderationState(self): return self.moderationState
    def get_accessState(self): return self.accessState
    def get_lastModifiedDate(self): return self.lastModifiedDate
    def get_createdDate(self): return self.createdDate
    def set_body(self, body): self.body=body
    def set_bodyAbstract(self, bodyAbstract): self.bodyAbstract=bodyAbstract
    def set_uri(self, uri): self.uri=uri
    def set_id(self, id): self.id=id
    def set_title(self, title): self.title=title
    def set_language(self, language): self.language=language
    def set_authorSSOName(self, authorSSOName): self.authorSSOName=authorSSOName
    def set_lastModifiedBySSOName(self, lastModifiedBySSOName): self.lastModifiedBySSOName=lastModifiedBySSOName
    def set_viewURI(self, viewURI): self.viewURI=viewURI
    def set_privateNotes(self, privateNotes): self.privateNotes=privateNotes
    def set_hasPublishedRevision(self, hasPublishedRevision): self.hasPublishedRevision=hasPublishedRevision
    def set_moderationState(self, moderationState): self.moderationState=moderationState
    def set_accessState(self, accessState): self.accessState=accessState
    def set_lastModifiedDate(self, lastModifiedDate): self.lastModifiedDate=lastModifiedDate
    def set_createdDate(self, createdDate): self.createdDate=createdDate


    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        body = from_union([KCSDescription.from_dict, from_none], obj.get(u"body"))
        bodyAbstract = from_union([KCSDescription.from_dict, from_none], obj.get(u"bodyAbstract"))
        uri = from_union([from_str, from_none], obj.get(u"uri"))
        id = from_union([from_any, from_none], obj.get(u"id"))
        title = from_union([from_str, from_none], obj.get(u"title"))
        language = from_union([from_str, from_none], obj.get(u"language"))
        authorSSOName = from_union([from_str, from_none], obj.get(u"authorSSOName"))
        lastModifiedBySSOName = from_union([from_str, from_none], obj.get(u"lastModifiedBySSOName"))
        viewURI = from_union([from_str, from_none], obj.get(u"viewURI"))
        privateNotes = from_union([KCSDescription.from_dict, from_none], obj.get(u"privateNotes"))
        hasPublishedRevision = from_union([from_bool, from_none], obj.get(u"hasPublishedRevision"))
        moderationState = from_union([from_str, from_none], obj.get(u"moderationState"))
        accessState = from_union([from_str, from_none], obj.get(u"accessState"))
        lastModifiedDate = from_union([from_str, from_none], obj.get(u"lastModifiedDate"))
        createdDate = from_union([from_str, from_none], obj.get(u"createdDate"))
        return Article(body, bodyAbstract, uri, id, title, language, authorSSOName, lastModifiedBySSOName, viewURI,
                       privateNotes, hasPublishedRevision, moderationState, accessState, lastModifiedDate, createdDate)

    def to_dict(self):
        result = {}
        result[u"body"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.body)
        result[u"bodyAbstract"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.bodyAbstract)
        result[u"uri"] = from_union([from_str, from_none], self.uri)
        result[u"id"] = from_union([from_any, from_none], self.id)
        result[u"title"] = from_union([from_str, from_none], self.title)
        result[u"language"] = from_union([from_str, from_none], self.language)
        result[u"authorSSOName"] = from_union([from_str, from_none], self.authorSSOName)
        result[u"lastModifiedBySSOName"] = from_union([from_str, from_none], self.lastModifiedBySSOName)
        result[u"viewURI"] = from_union([from_str, from_none], self.viewURI)
        result[u"privateNotes"] = from_union([lambda x: to_class(KCSDescription, x), from_none], self.privateNotes)
        result[u"hasPublishedRevision"] = from_union([from_bool, from_none], self.hasPublishedRevision)
        result[u"moderationState"] = from_union([from_str, from_none], self.moderationState)
        result[u"accessState"] = from_union([from_str, from_none], self.accessState)
        result[u"lastModifiedDate"] = from_union([from_str, from_none], self.lastModifiedDate)
        result[u"createdDate"] = from_union([from_str, from_none], self.createdDate)
        return result


def Articlefromdict(s):
    return Article.from_dict(s)


def Articletodict(x):
    return to_class(Article, x)


def Articlesfromdict(s):
    return from_list(Article.from_dict, s)


def Articlestodict(x):
    return from_list(lambda x: to_class(Article, x), x)


class Recommendation(object):
    def __init__(self, documentKind=None, allTitle=None, kcsState=None, uri=None, viewuri=None, resourceuri=None,
                 id=None, abstract=None, linked=None):
        self.documentKind = documentKind
        self.allTitle = allTitle
        self.kcsState = kcsState
        self.uri = uri
        self.viewuri = viewuri
        self.resourceuri = resourceuri
        self.id = id
        self.abstract = abstract
        self.linked = linked

    def get_documentKind(self): return self.documentKind
    def get_allTitle(self): return self.allTitle
    def get_kcsState(self): return self.kcsState
    def get_uri(self): return self.uri
    def get_view_uri(self): return self.viewuri
    def get_resource_uri(self): return self.resourceuri
    def get_id(self): return self.id
    def get_abstract(self): return self.abstract
    def get_linked(self): return self.linked
    def set_documentKind(self, documentKind): self.documentKind=documentKind
    def set_allTitle(self, allTitle): self.allTitle=allTitle
    def set_kcsState(self, kcsState): self.kcsState=kcsState
    def set_uri(self, uri): self.uri=uri
    def set_view_uri(self, view_uri): self.viewuri=view_uri
    def set_resource_uri(self, resource_uri): self.resourceuri=resource_uri
    def set_id(self, id): self.id=id
    def set_abstract(self, abstract): self.abstract=abstract
    def set_linked(self, linked): self.linked=linked

    # to maintain consistency with the recommendationprompter.py
    def get_title(self): return self.allTitle
    def get_resourceViewURI(self): return self.viewuri
    def get_solutionAbstract(self): return self.abstract
    def get_solutionKcsState(self): return self.kcsState
    def get_resourceId(self): return self.id

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        documentKind = from_union([from_str, from_none], obj.get(u"documentKind"))
        allTitle = from_union([from_str, from_none], obj.get(u"allTitle"))
        kcsState = from_union([from_str, from_none], obj.get(u"kcsState"))
        uri = from_union([from_str, from_none], obj.get(u"uri"))
        viewuri = from_union([from_str, from_none], obj.get(u"view_uri"))
        resourceuri = from_union([from_str, from_none], obj.get(u"resource_uri"))
        id = from_union([from_any, from_none], obj.get(u"id"))
        abstract = from_union([from_str, from_none], obj.get(u"abstract"))
        linked = from_union([from_bool, from_none], obj.get(u"linked"))
        return Recommendation(documentKind, allTitle, kcsState, uri, viewuri, resourceuri, id, abstract, linked)

    def to_dict(self):
        result = {}
        result[u"documentKind"] = from_union([from_str, from_none], self.documentKind)
        result[u"allTitle"] = from_union([from_str, from_none], self.allTitle)
        result[u"kcsState"] = from_union([from_str, from_none], self.kcsState)
        result[u"uri"] = from_union([from_str, from_none], self.uri)
        result[u"view_uri"] = from_union([from_str, from_none], self.viewuri)
        result[u"resource_uri"] = from_union([from_str, from_none], self.resourceuri)
        result[u"id"] = from_union([from_any, from_none], self.id)
        result[u"abstract"] = from_union([from_str, from_none], self.abstract)
        result[u"linked"] = from_union([from_bool, from_none], self.linked)
        return result


def Recommendationsfromdict(s):
    return from_list(Recommendation.from_dict, s)


def Recommendationstodict(x):
    return from_list(lambda x: to_class(Recommendation, x), x)


def Recommendationfromdict(s):
    return Recommendation.from_dict(s)


def Recommendationtodict(x):
    return to_class(Recommendation, x)
