; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown                                                  | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=haswell                                  | FileCheck %s --check-prefixes=X64,X64-HSW
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=btver2                                   | FileCheck %s --check-prefixes=X64,X64-JAG
; RUN: llc < %s -mtriple=i686-unknown -mul-constant-optimization=false                 | FileCheck %s --check-prefix=X86-NOOPT
; RUN: llc < %s -mtriple=x86_64-unknown -mul-constant-optimization=false -mcpu=haswell | FileCheck %s --check-prefixes=X64-NOOPT,HSW-NOOPT
; RUN: llc < %s -mtriple=x86_64-unknown -mul-constant-optimization=false -mcpu=btver2  | FileCheck %s --check-prefixes=X64-NOOPT,JAG-NOOPT
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=slm                                      | FileCheck %s --check-prefixes=X64,X64-SLM
; RUN: llc < %s -mtriple=x86_64-unknown -mul-constant-optimization=false -mcpu=slm     | FileCheck %s --check-prefixes=X64-NOOPT,SLM-NOOPT

define i32 @test_mul_by_1(i32 %x) {
; X86-LABEL: test_mul_by_1:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_1:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_1:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    movl %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 1
  ret i32 %mul
}

define i32 @test_mul_by_2(i32 %x) {
; X86-LABEL: test_mul_by_2:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl %eax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_2:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rdi), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_2:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    addl %eax, %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_2:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NOOPT-NEXT:    leal (%rdi,%rdi), %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 2
  ret i32 %mul
}

define i32 @test_mul_by_3(i32 %x) {
; X86-LABEL: test_mul_by_3:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,2), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_3:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rdi,2), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_3:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $3, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_3:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NOOPT-NEXT:    leal (%rdi,%rdi,2), %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 3
  ret i32 %mul
}

define i32 @test_mul_by_4(i32 %x) {
; X86-LABEL: test_mul_by_4:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $2, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_4:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (,%rdi,4), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_4:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    shll $2, %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_4:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NOOPT-NEXT:    leal (,%rdi,4), %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 4
  ret i32 %mul
}

define i32 @test_mul_by_5(i32 %x) {
; X86-LABEL: test_mul_by_5:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_5:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_5:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $5, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_5:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NOOPT-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 5
  ret i32 %mul
}

define i32 @test_mul_by_6(i32 %x) {
; X86-LABEL: test_mul_by_6:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl %eax, %eax
; X86-NEXT:    leal (%eax,%eax,2), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_6:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    addl %edi, %edi
; X64-NEXT:    leal (%rdi,%rdi,2), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_6:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $6, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_6:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $6, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 6
  ret i32 %mul
}

define i32 @test_mul_by_7(i32 %x) {
; X86-LABEL: test_mul_by_7:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    leal (,%ecx,8), %eax
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_7:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (,%rdi,8), %eax
; X64-NEXT:    subl %edi, %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_7:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $7, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_7:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $7, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 7
  ret i32 %mul
}

define i32 @test_mul_by_8(i32 %x) {
; X86-LABEL: test_mul_by_8:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $3, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_8:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (,%rdi,8), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_8:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    shll $3, %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_8:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NOOPT-NEXT:    leal (,%rdi,8), %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 8
  ret i32 %mul
}

define i32 @test_mul_by_9(i32 %x) {
; X86-LABEL: test_mul_by_9:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_9:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_9:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $9, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_9:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NOOPT-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 9
  ret i32 %mul
}

define i32 @test_mul_by_10(i32 %x) {
; X86-LABEL: test_mul_by_10:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl %eax, %eax
; X86-NEXT:    leal (%eax,%eax,4), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_10:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    addl %edi, %edi
; X64-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_10:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $10, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_10:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $10, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 10
  ret i32 %mul
}

define i32 @test_mul_by_11(i32 %x) {
; X86-LABEL: test_mul_by_11:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_11:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-HSW-NEXT:    leal (%rdi,%rax,2), %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_11:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-JAG-NEXT:    leal (%rdi,%rax,2), %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_11:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $11, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_11:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $11, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_11:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $11, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 11
  ret i32 %mul
}

define i32 @test_mul_by_12(i32 %x) {
; X86-LABEL: test_mul_by_12:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $2, %eax
; X86-NEXT:    leal (%eax,%eax,2), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_12:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    shll $2, %edi
; X64-NEXT:    leal (%rdi,%rdi,2), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_12:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $12, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_12:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $12, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 12
  ret i32 %mul
}

define i32 @test_mul_by_13(i32 %x) {
; X86-LABEL: test_mul_by_13:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,2), %ecx
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_13:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,2), %eax
; X64-HSW-NEXT:    leal (%rdi,%rax,4), %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_13:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,2), %eax
; X64-JAG-NEXT:    leal (%rdi,%rax,4), %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_13:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $13, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_13:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $13, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_13:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $13, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 13
  ret i32 %mul
}

define i32 @test_mul_by_14(i32 %x) {
; X86-LABEL: test_mul_by_14:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax), %ecx
; X86-NEXT:    shll $4, %eax
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_14:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    leal (%rax,%rax), %ecx
; X64-NEXT:    shll $4, %eax
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_14:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $14, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_14:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $14, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 14
  ret i32 %mul
}

define i32 @test_mul_by_15(i32 %x) {
; X86-LABEL: test_mul_by_15:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %eax
; X86-NEXT:    leal (%eax,%eax,2), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_15:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-NEXT:    leal (%rax,%rax,2), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_15:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $15, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_15:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $15, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 15
  ret i32 %mul
}

define i32 @test_mul_by_16(i32 %x) {
; X86-LABEL: test_mul_by_16:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $4, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_16:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $4, %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_16:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    shll $4, %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_16:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    movl %edi, %eax
; X64-NOOPT-NEXT:    shll $4, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 16
  ret i32 %mul
}

define i32 @test_mul_by_17(i32 %x) {
; X86-LABEL: test_mul_by_17:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    shll $4, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_17:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $4, %eax
; X64-NEXT:    addl %edi, %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_17:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $17, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_17:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $17, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 17
  ret i32 %mul
}

define i32 @test_mul_by_18(i32 %x) {
; X86-LABEL: test_mul_by_18:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl %eax, %eax
; X86-NEXT:    leal (%eax,%eax,8), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_18:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    addl %edi, %edi
; X64-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_18:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $18, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_18:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $18, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 18
  ret i32 %mul
}

define i32 @test_mul_by_19(i32 %x) {
; X86-LABEL: test_mul_by_19:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_19:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-HSW-NEXT:    leal (%rdi,%rax,2), %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_19:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-JAG-NEXT:    leal (%rdi,%rax,2), %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_19:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $19, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_19:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $19, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_19:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $19, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 19
  ret i32 %mul
}

define i32 @test_mul_by_20(i32 %x) {
; X86-LABEL: test_mul_by_20:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $2, %eax
; X86-NEXT:    leal (%eax,%eax,4), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_20:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    shll $2, %edi
; X64-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_20:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $20, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_20:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $20, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 20
  ret i32 %mul
}

define i32 @test_mul_by_21(i32 %x) {
; X86-LABEL: test_mul_by_21:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_21:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-HSW-NEXT:    leal (%rdi,%rax,4), %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_21:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-JAG-NEXT:    leal (%rdi,%rax,4), %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_21:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $21, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_21:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $21, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_21:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $21, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 21
  ret i32 %mul
}

define i32 @test_mul_by_22(i32 %x) {
; X86-LABEL: test_mul_by_22:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    leal (%ecx,%ecx,4), %eax
; X86-NEXT:    leal (%ecx,%eax,4), %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_22:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-HSW-NEXT:    leal (%rdi,%rax,4), %eax
; X64-HSW-NEXT:    addl %edi, %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_22:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-JAG-NEXT:    leal (%rdi,%rax,4), %eax
; X64-JAG-NEXT:    addl %edi, %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_22:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $22, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_22:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $22, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_22:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $22, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 22
  ret i32 %mul
}

define i32 @test_mul_by_23(i32 %x) {
; X86-LABEL: test_mul_by_23:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    leal (%ecx,%ecx,2), %eax
; X86-NEXT:    shll $3, %eax
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_23:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,2), %eax
; X64-HSW-NEXT:    shll $3, %eax
; X64-HSW-NEXT:    subl %edi, %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_23:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,2), %eax
; X64-JAG-NEXT:    shll $3, %eax
; X64-JAG-NEXT:    subl %edi, %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_23:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $23, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_23:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $23, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_23:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $23, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 23
  ret i32 %mul
}

define i32 @test_mul_by_24(i32 %x) {
; X86-LABEL: test_mul_by_24:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $3, %eax
; X86-NEXT:    leal (%eax,%eax,2), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_24:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    shll $3, %edi
; X64-NEXT:    leal (%rdi,%rdi,2), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_24:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $24, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_24:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $24, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 24
  ret i32 %mul
}

define i32 @test_mul_by_25(i32 %x) {
; X86-LABEL: test_mul_by_25:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %eax
; X86-NEXT:    leal (%eax,%eax,4), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_25:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-NEXT:    leal (%rax,%rax,4), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_25:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $25, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_25:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $25, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 25
  ret i32 %mul
}

define i32 @test_mul_by_26(i32 %x) {
; X86-LABEL: test_mul_by_26:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    leal (%ecx,%ecx,4), %eax
; X86-NEXT:    leal (%eax,%eax,4), %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_26:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-HSW-NEXT:    leal (%rax,%rax,4), %eax
; X64-HSW-NEXT:    addl %edi, %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_26:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-JAG-NEXT:    leal (%rax,%rax,4), %eax
; X64-JAG-NEXT:    addl %edi, %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_26:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $26, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_26:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $26, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_26:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $26, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 26
  ret i32 %mul
}

define i32 @test_mul_by_27(i32 %x) {
; X86-LABEL: test_mul_by_27:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %eax
; X86-NEXT:    leal (%eax,%eax,2), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_27:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-NEXT:    leal (%rax,%rax,2), %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_27:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $27, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_27:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $27, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 27
  ret i32 %mul
}

define i32 @test_mul_by_28(i32 %x) {
; X86-LABEL: test_mul_by_28:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    leal (%ecx,%ecx,8), %eax
; X86-NEXT:    leal (%eax,%eax,2), %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_28:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-HSW-NEXT:    leal (%rax,%rax,2), %eax
; X64-HSW-NEXT:    addl %edi, %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_28:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-JAG-NEXT:    leal (%rax,%rax,2), %eax
; X64-JAG-NEXT:    addl %edi, %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_28:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $28, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_28:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $28, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_28:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $28, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 28
  ret i32 %mul
}

define i32 @test_mul_by_29(i32 %x) {
; X86-LABEL: test_mul_by_29:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    leal (%ecx,%ecx,2), %ecx
; X86-NEXT:    addl %eax, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_29:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-HSW-NEXT:    leal (%rax,%rax,2), %eax
; X64-HSW-NEXT:    addl %edi, %eax
; X64-HSW-NEXT:    addl %edi, %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_29:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-JAG-NEXT:    leal (%rax,%rax,2), %eax
; X64-JAG-NEXT:    addl %edi, %eax
; X64-JAG-NEXT:    addl %edi, %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_29:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $29, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_29:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $29, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_29:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $29, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 29
  ret i32 %mul
}

define i32 @test_mul_by_30(i32 %x) {
; X86-LABEL: test_mul_by_30:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax), %ecx
; X86-NEXT:    shll $5, %eax
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_30:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    leal (%rax,%rax), %ecx
; X64-NEXT:    shll $5, %eax
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_30:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $30, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_30:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $30, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 30
  ret i32 %mul
}

define i32 @test_mul_by_31(i32 %x) {
; X86-LABEL: test_mul_by_31:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    shll $5, %eax
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_31:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $5, %eax
; X64-NEXT:    subl %edi, %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_31:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $31, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_31:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $31, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 31
  ret i32 %mul
}

define i32 @test_mul_by_32(i32 %x) {
; X86-LABEL: test_mul_by_32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $5, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $5, %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_32:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    shll $5, %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_32:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    movl %edi, %eax
; X64-NOOPT-NEXT:    shll $5, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 32
  ret i32 %mul
}

define i32 @test_mul_by_37(i32 %x) {
; X86-LABEL: test_mul_by_37:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_37:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-HSW-NEXT:    leal (%rdi,%rax,4), %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_37:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-JAG-NEXT:    leal (%rdi,%rax,4), %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_37:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $37, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_37:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $37, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_37:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $37, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 37
  ret i32 %mul
}

define i32 @test_mul_by_41(i32 %x) {
; X86-LABEL: test_mul_by_41:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    leal (%eax,%ecx,8), %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_41:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-HSW-NEXT:    leal (%rdi,%rax,8), %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_41:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-JAG-NEXT:    leal (%rdi,%rax,8), %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_41:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $41, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_41:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $41, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_41:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $41, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 41
  ret i32 %mul
}

define i32 @test_mul_by_62(i32 %x) {
; X86-LABEL: test_mul_by_62:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax), %ecx
; X86-NEXT:    shll $6, %eax
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_62:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    leal (%rax,%rax), %ecx
; X64-NEXT:    shll $6, %eax
; X64-NEXT:    subl %ecx, %eax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_62:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $62, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_62:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $62, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 62
  ret i32 %mul
}

define i32 @test_mul_by_66(i32 %x) {
; X86-LABEL: test_mul_by_66:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    shll $6, %ecx
; X86-NEXT:    leal (%ecx,%eax,2), %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_66:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    movl %edi, %eax
; X64-HSW-NEXT:    shll $6, %eax
; X64-HSW-NEXT:    leal (%rax,%rdi,2), %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_66:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    movl %edi, %eax
; X64-JAG-NEXT:    shll $6, %eax
; X64-JAG-NEXT:    leal (%rax,%rdi,2), %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_66:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $66, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_66:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $66, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_66:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-SLM-NEXT:    leal (%rdi,%rdi), %eax
; X64-SLM-NEXT:    shll $6, %edi
; X64-SLM-NEXT:    addl %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 66
  ret i32 %mul
}

define i32 @test_mul_by_73(i32 %x) {
; X86-LABEL: test_mul_by_73:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    leal (%eax,%ecx,8), %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_73:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-HSW-NEXT:    leal (%rdi,%rax,8), %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_73:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-JAG-NEXT:    leal (%rdi,%rax,8), %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_73:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $73, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_73:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $73, %edi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_73:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $73, %edi, %eax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 73
  ret i32 %mul
}

define i32 @test_mul_by_520(i32 %x) {
; X86-LABEL: test_mul_by_520:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    shll $9, %ecx
; X86-NEXT:    leal (%ecx,%eax,8), %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_520:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    movl %edi, %eax
; X64-HSW-NEXT:    shll $9, %eax
; X64-HSW-NEXT:    leal (%rax,%rdi,8), %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_520:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    movl %edi, %eax
; X64-JAG-NEXT:    shll $9, %eax
; X64-JAG-NEXT:    leal (%rax,%rdi,8), %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_520:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $520, {{[0-9]+}}(%esp), %eax # imm = 0x208
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_520:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $520, %edi, %eax # imm = 0x208
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_520:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imull $520, %edi, %eax # imm = 0x208
; X64-SLM-NEXT:    retq
  %mul = mul nsw i32 %x, 520
  ret i32 %mul
}

define i32 @test_mul_by_neg10(i32 %x) {
; X86-LABEL: test_mul_by_neg10:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl %eax, %eax
; X86-NEXT:    leal (%eax,%eax,4), %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_neg10:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    addl %edi, %edi
; X64-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_neg10:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $-10, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_neg10:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $-10, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, -10
  ret i32 %mul
}

define i32 @test_mul_by_neg36(i32 %x) {
; X86-LABEL: test_mul_by_neg36:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $2, %eax
; X86-NEXT:    leal (%eax,%eax,8), %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mul_by_neg36:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    shll $2, %edi
; X64-NEXT:    leal (%rdi,%rdi,8), %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_neg36:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $-36, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_neg36:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $-36, %edi, %eax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, -36
  ret i32 %mul
}

; (x*9+42)*(x*5+2)
define i32 @test_mul_spec(i32 %x) nounwind {
; X86-LABEL: test_mul_spec:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal 42(%eax,%eax,8), %ecx
; X86-NEXT:    leal 2(%eax,%eax,4), %eax
; X86-NEXT:    imull %ecx, %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_spec:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,8), %ecx
; X64-HSW-NEXT:    addl $42, %ecx
; X64-HSW-NEXT:    leal (%rdi,%rdi,4), %eax
; X64-HSW-NEXT:    addl $2, %eax
; X64-HSW-NEXT:    imull %ecx, %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_spec:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal 42(%rdi,%rdi,8), %ecx
; X64-JAG-NEXT:    leal 2(%rdi,%rdi,4), %eax
; X64-JAG-NEXT:    imull %ecx, %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_spec:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    leal 42(%eax,%eax,8), %ecx
; X86-NOOPT-NEXT:    leal 2(%eax,%eax,4), %eax
; X86-NOOPT-NEXT:    imull %ecx, %eax
; X86-NOOPT-NEXT:    retl
;
; HSW-NOOPT-LABEL: test_mul_spec:
; HSW-NOOPT:       # %bb.0:
; HSW-NOOPT-NEXT:    # kill: def $edi killed $edi def $rdi
; HSW-NOOPT-NEXT:    leal (%rdi,%rdi,8), %ecx
; HSW-NOOPT-NEXT:    addl $42, %ecx
; HSW-NOOPT-NEXT:    leal (%rdi,%rdi,4), %eax
; HSW-NOOPT-NEXT:    addl $2, %eax
; HSW-NOOPT-NEXT:    imull %ecx, %eax
; HSW-NOOPT-NEXT:    retq
;
; JAG-NOOPT-LABEL: test_mul_spec:
; JAG-NOOPT:       # %bb.0:
; JAG-NOOPT-NEXT:    # kill: def $edi killed $edi def $rdi
; JAG-NOOPT-NEXT:    leal 42(%rdi,%rdi,8), %ecx
; JAG-NOOPT-NEXT:    leal 2(%rdi,%rdi,4), %eax
; JAG-NOOPT-NEXT:    imull %ecx, %eax
; JAG-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_spec:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-SLM-NEXT:    leal 42(%rdi,%rdi,8), %ecx
; X64-SLM-NEXT:    leal 2(%rdi,%rdi,4), %eax
; X64-SLM-NEXT:    imull %ecx, %eax
; X64-SLM-NEXT:    retq
;
; SLM-NOOPT-LABEL: test_mul_spec:
; SLM-NOOPT:       # %bb.0:
; SLM-NOOPT-NEXT:    # kill: def $edi killed $edi def $rdi
; SLM-NOOPT-NEXT:    leal 42(%rdi,%rdi,8), %ecx
; SLM-NOOPT-NEXT:    leal 2(%rdi,%rdi,4), %eax
; SLM-NOOPT-NEXT:    imull %ecx, %eax
; SLM-NOOPT-NEXT:    retq
  %mul = mul nsw i32 %x, 9
  %add = add nsw i32 %mul, 42
  %mul2 = mul nsw i32 %x, 5
  %add2 = add nsw i32 %mul2, 2
  %mul3 = mul nsw i32 %add, %add2
  ret i32 %mul3
}

; This makes sure we are able to fold the negate generated by the mul expansion
; into the next instruction.
; FIXME: We make this work.
define i32 @mul_neg_fold(i32 %a, i32 %b) {
; X86-LABEL: mul_neg_fold:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    leal (%ecx,%ecx,8), %ecx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    retl
;
; X64-HSW-LABEL: mul_neg_fold:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    movl %esi, %eax
; X64-HSW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-HSW-NEXT:    leal (%rdi,%rdi,8), %ecx
; X64-HSW-NEXT:    subl %ecx, %eax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: mul_neg_fold:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-JAG-NEXT:    leal (%rdi,%rdi,8), %ecx
; X64-JAG-NEXT:    movl %esi, %eax
; X64-JAG-NEXT:    subl %ecx, %eax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: mul_neg_fold:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    imull $-9, {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: mul_neg_fold:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imull $-9, %edi, %eax
; X64-NOOPT-NEXT:    addl %esi, %eax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: mul_neg_fold:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-SLM-NEXT:    movl %esi, %eax
; X64-SLM-NEXT:    leal (%rdi,%rdi,8), %ecx
; X64-SLM-NEXT:    subl %ecx, %eax
; X64-SLM-NEXT:    retq
  %c = mul i32 %a, -9
  %d = add i32 %b, %c
  ret i32 %d
}
