// Generated by CoffeeScript 2.5.1
var Arbitrary, DeclarationBlock, declarationClasses;

module.exports = DeclarationBlock = (function() {
  var self;

  class DeclarationBlock {
    constructor() {
      this._declarations = {};
    }

    set(prop, value) {
      var key, val;
      if (typeof prop === 'object') {
        for (key in prop) {
          val = prop[key];
          this.set(key, val);
        }
        return this;
      }
      prop = self.sanitizeProp(prop);
      this._getDeclarationClass(prop).setOnto(this._declarations, prop, value);
      return this;
    }

    _getDeclarationClass(prop) {
      var cls;
      if (prop[0] === '_') {
        return Arbitrary;
      }
      if (!(cls = declarationClasses[prop])) {
        throw Error(`Unknown property \`${prop}\`. Write it as \`_${prop}\` if you're defining a custom property`);
      }
      return cls;
    }

    static sanitizeProp(prop) {
      return String(prop).trim();
    }

  };

  self = DeclarationBlock;

  return DeclarationBlock;

}).call(this);

Arbitrary = require('./declarationBlock/Arbitrary');

declarationClasses = {
  color: require('./declarationBlock/Color'),
  background: require('./declarationBlock/Background'),
  width: require('./declarationBlock/Width'),
  height: require('./declarationBlock/Height'),
  bullet: require('./declarationBlock/Bullet'),
  display: require('./declarationBlock/Display'),
  margin: require('./declarationBlock/Margin'),
  marginTop: require('./declarationBlock/MarginTop'),
  marginLeft: require('./declarationBlock/MarginLeft'),
  marginRight: require('./declarationBlock/MarginRight'),
  marginBottom: require('./declarationBlock/MarginBottom'),
  padding: require('./declarationBlock/Padding'),
  paddingTop: require('./declarationBlock/PaddingTop'),
  paddingLeft: require('./declarationBlock/PaddingLeft'),
  paddingRight: require('./declarationBlock/PaddingRight'),
  paddingBottom: require('./declarationBlock/PaddingBottom')
};
