*DMPREC
      DOUBLE PRECISION FUNCTION DMPREC()
C***BEGIN PROLOGUE  DPREC
C***REFER TO  DODR,DODRC
C***ROUTINES CALLED  (NONE)
C***DATE WRITTEN   860529   (YYMMDD)
C***REVISION DATE  920304   (YYMMDD)
C***PURPOSE  DETERMINE MACHINE PRECISION FOR TARGET MACHINE AND COMPILER
C            ASSUMING FLOATING-POINT NUMBERS ARE REPRESENTED IN THE
C            T-DIGIT, BASE-B FORM
C                  SIGN (B**E)*( (X(1)/B) + ... + (X(T)/B**T) )
C            WHERE 0 .LE. X(I) .LT. B FOR I=1,...,T, AND
C                  0 .LT. X(1).
C            TO ALTER THIS FUNCTION FOR A PARTICULAR TARGET MACHINE,
C            EITHER
C                  ACTIVATE THE DESIRED SET OF DATA STATEMENTS BY
C                  REMOVING THE C FROM COLUMN 1 
C            OR
C                  SET B, TD AND TS USING I1MACH BY ACTIVATING
C                  THE DECLARATION STATEMENTS FOR I1MACH 
C                  AND THE STATEMENTS PRECEDING THE FIRST 
C                  EXECUTABLE STATEMENT BELOW.
C***END PROLOGUE  DPREC

C...LOCAL SCALARS
      DOUBLE PRECISION
     +   B
      INTEGER 
     +   TD,TS

C...EXTERNAL FUNCTIONS 
C     INTEGER
C    +   I1MACH
C     EXTERNAL
C    +   I1MACH

C...VARIABLE DEFINITIONS (ALPHABETICALLY)

C     DOUBLE PRECISION B
C        THE BASE OF THE TARGET MACHINE.
C        (MAY BE DEFINED USING I1MACH(10).)
C     INTEGER TD
C        THE NUMBER OF BASE-B DIGITS IN DOUBLE PRECISION.
C        (MAY BE DEFINED USING I1MACH(14).)
C     INTEGER TS
C        THE NUMBER OF BASE-B DIGITS IN SINGLE PRECISION.
C        (MAY BE DEFINED USING I1MACH(11).)


C   MACHINE CONSTANTS FOR COMPUTERS FOLLOWING IEEE ARITHMETIC STANDARD
C   (E.G., MOTOROLA 68000 BASED MACHINES SUCH AS SUN AND SPARC 
C   WORKSTATIONS, AND AT&T PC 7300; AND 8087 BASED MICROS SUCH AS THE
C   IBM PC AND THE AT&T 6300).
      DATA B  /   2 /
      DATA TS /  24 /
      DATA TD /  53 /

C   MACHINE CONSTANTS FOR THE BURROUGHS 1700 SYSTEM.
C     DATA B  /   2 /
C     DATA TS /  24 /
C     DATA TD /  60 /

C   MACHINE CONSTANTS FOR THE BURROUGHS 5700 SYSTEM
C                         THE BURROUGHS 6700/7700 SYSTEMS 
C     DATA B  /   8 /
C     DATA TS /  13 /
C     DATA TD /  26 /

C   MACHINE CONSTANTS FOR THE CDC 6000/7000 (FTN5 COMPILER)
C                         THE CYBER 170/180 SERIES UNDER NOS
C     DATA B  /   2 /
C     DATA TS /  48 /
C     DATA TD /  96 /

C   MACHINE CONSTANTS FOR THE CDC 6000/7000 (FTN COMPILER)
C                         THE CYBER 170/180 SERIES UNDER NOS/VE
C                         THE CYBER 200 SERIES
C     DATA B  /   2 /
C     DATA TS /  47 /
C     DATA TD /  94 /

C   MACHINE CONSTANTS FOR THE CRAY 
C     DATA B  /   2 /
C     DATA TS /  47 /
C     DATA TD /  94 /

C   MACHINE CONSTANTS FOR THE DATA GENERAL ECLIPSE S/200
C     DATA B  /  16 /
C     DATA TS /   6 /
C     DATA TD /  14 /

C   MACHINE CONSTANTS FOR THE HARRIS COMPUTER
C     DATA B  /   2 /
C     DATA TS /  23 /
C     DATA TD /  38 /

C   MACHINE CONSTANTS FOR THE HONEYWELL DPS 8/70
C                         THE HONEYWELL 600/6000 SERIES
C     DATA B  /   2 /
C     DATA TS /  27 /
C     DATA TD /  63 /

C   MACHINE CONSTANTS FOR THE HP 2100
C      (3 WORD DOUBLE PRECISION OPTION WITH FTN4)
C     DATA B  /   2 /
C     DATA TS /  23 /
C     DATA TD /  39 /

C   MACHINE CONSTANTS FOR THE HP 2100
C      (4 WORD DOUBLE PRECISION OPTION WITH FTN4)
C     DATA B  /   2 /
C     DATA TS /  23 /
C     DATA TD /  55 /

C   MACHINE CONSTANTS FOR THE IBM 360/370 SERIES
C     DATA B  /  16 /
C     DATA TS /   6 /
C     DATA TD /  14 /

C   MACHINE CONSTANTS FOR THE IBM PC
C     DATA B  /   2 /
C     DATA TS /  24 /
C     DATA TD /  53 /

C   MACHINE CONSTANTS FOR THE INTERDATA (PERKIN ELMER) 7/32
C                             INTERDATA (PERKIN ELMER) 8/32
C     DATA B  /  16 /
C     DATA TS /   6 /
C     DATA TD /  14 /

C   MACHINE CONSTANTS FOR THE PDP-10 (KA PROCESSOR).
C     DATA B  /   2 /
C     DATA TS /  27 /
C     DATA TD /  54 /

C   MACHINE CONSTANTS FOR THE PDP-10 (KI PROCESSOR).
C     DATA B  /   2 /
C     DATA TS /  27 /
C     DATA TD /  62 /

C   MACHINE CONSTANTS FOR THE PDP-11 SYSTEM
C     DATA B  /   2 /
C     DATA TS /  24 /
C     DATA TD /  56 /

C   MACHINE CONSTANTS FOR THE PERKIN-ELMER 3230
C     DATA B  /  16 /
C     DATA TS /   6 /
C     DATA TD /  14 /

C   MACHINE CONSTANTS FOR THE PRIME 850 AND PRIME 4050
C     DATA B  /   2 /
C     DATA TS /  23 /
C     DATA TD /  47 /

C   MACHINE CONSTANTS FOR THE SEL SYSTEMS 85/86
C     DATA B  /  16 /
C     DATA TS /   6 /
C     DATA TD /  14 /

C   MACHINE CONSTANTS FOR SUN AND SPARC WORKSTATIONS
C     DATA B  /   2 /
C     DATA TS /  24 /
C     DATA TD /  53 /

C   MACHINE CONSTANTS FOR THE UNIVAC 1100 SERIES
C     DATA B  /   2 /
C     DATA TS /  27 /
C     DATA TD /  60 /

C   MACHINE CONSTANTS FOR THE VAX-11 WITH FORTRAN IV-PLUS COMPILER
C     DATA B  /   2 /
C     DATA TS /  24 /
C     DATA TD /  56 /

C   MACHINE CONSTANTS FOR THE VAX/VMS SYSTEM WITHOUT  G_FLOATING
C     DATA B  /   2 /
C     DATA TS /  24 /
C     DATA TD /  56 /

C   MACHINE CONSTANTS FOR THE VAX/VMS SYSTEM WITH G_FLOATING
C     DATA B  /   2 /
C     DATA TS /  24 /
C     DATA TD /  53 /

C   MACHINE CONSTANTS FOR THE XEROX SIGMA 5/7/9
C     DATA B  /  16 /
C     DATA TS /   6 /
C     DATA TD /  14 /


C***FIRST EXECUTABLE STATEMENT  DMPREC


C     B = I1MACH(10)
C     TS = I1MACH(11)
C     TD = I1MACH(14)

      DMPREC = B ** (1-TD)

      RETURN

      END
