; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;
; Test that the fls library call simplifier works correctly even for
; targets with 16-bit int.  Although fls is available on a number of
; targets it's supported (hardcoded as available) only on FreeBSD.
;
; RUN: opt < %s -mtriple=avr-freebsd -passes=instcombine -S | FileCheck %s
; RUN: opt < %s -mtriple=msp430-freebsd -passes=instcombine -S | FileCheck %s

declare i16 @fls(i16)

declare void @sink(i16)


define void @fold_fls(i16 %x) {
; CHECK-LABEL: @fold_fls(
; CHECK-NEXT:    call void @sink(i16 0)
; CHECK-NEXT:    call void @sink(i16 1)
; CHECK-NEXT:    [[CTLZ:%.*]] = call i16 @llvm.ctlz.i16(i16 [[X:%.*]], i1 false), !range [[RNG0:![0-9]+]]
; CHECK-NEXT:    [[TMP1:%.*]] = sub nuw nsw i16 16, [[CTLZ]]
; CHECK-NEXT:    call void @sink(i16 [[TMP1]])
; CHECK-NEXT:    ret void
;
  %n0 = call i16 @fls(i16 0)
  call void @sink(i16 %n0)

  %n1 = call i16 @fls(i16 1)
  call void @sink(i16 %n1)

  %nx = call i16 @fls(i16 %x)
  call void @sink(i16 %nx)

  ret void
}
