; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming-compatible-sve < %s | FileCheck %s


target triple = "aarch64-unknown-linux-gnu"

define i1 @ptest_v16i1(ptr %a, ptr %b) {
; CHECK-LABEL: ptest_v16i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q1, q0, [x0, #32]
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    fcmne p1.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    fcmne p2.s, p0/z, z1.s, #0.0
; CHECK-NEXT:    fcmne p3.s, p0/z, z3.s, #0.0
; CHECK-NEXT:    fcmne p0.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    mov z0.s, p1/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z1.s, p2/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z2.s, p3/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z3.s, p0/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    ptrue p1.b, vl16
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    splice z1.h, p0, z1.h, z0.h
; CHECK-NEXT:    splice z3.h, p0, z3.h, z2.h
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    uzp1 z0.b, z1.b, z1.b
; CHECK-NEXT:    uzp1 z1.b, z3.b, z3.b
; CHECK-NEXT:    splice z1.b, p0, z1.b, z0.b
; CHECK-NEXT:    umaxv b0, p1, z1.b
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    and w0, w8, #0x1
; CHECK-NEXT:    ret
  %v0 = bitcast ptr %a to <16 x float>*
  %v1 = load <16 x float>, <16 x float>* %v0, align 4
  %v2 = fcmp une <16 x float> %v1, zeroinitializer
  %v3 = call i1 @llvm.vector.reduce.or.i1.v16i1 (<16 x i1> %v2)
  ret i1 %v3
}

define i1 @ptest_or_v16i1(ptr %a, ptr %b) {
; CHECK-LABEL: ptest_or_v16i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ldp q2, q3, [x0, #32]
; CHECK-NEXT:    ldp q4, q5, [x1]
; CHECK-NEXT:    ldp q6, q7, [x1, #32]
; CHECK-NEXT:    fcmne p1.s, p0/z, z3.s, #0.0
; CHECK-NEXT:    fcmne p2.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    fcmne p3.s, p0/z, z1.s, #0.0
; CHECK-NEXT:    fcmne p4.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    fcmne p5.s, p0/z, z7.s, #0.0
; CHECK-NEXT:    fcmne p6.s, p0/z, z6.s, #0.0
; CHECK-NEXT:    fcmne p7.s, p0/z, z5.s, #0.0
; CHECK-NEXT:    fcmne p0.s, p0/z, z4.s, #0.0
; CHECK-NEXT:    mov z0.s, p1/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z1.s, p2/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z2.s, p3/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z3.s, p4/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z4.s, p5/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z5.s, p6/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z6.s, p7/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z7.s, p0/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    uzp1 z5.h, z5.h, z5.h
; CHECK-NEXT:    uzp1 z6.h, z6.h, z6.h
; CHECK-NEXT:    uzp1 z7.h, z7.h, z7.h
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    splice z1.h, p1, z1.h, z0.h
; CHECK-NEXT:    splice z3.h, p1, z3.h, z2.h
; CHECK-NEXT:    splice z5.h, p1, z5.h, z4.h
; CHECK-NEXT:    splice z7.h, p1, z7.h, z6.h
; CHECK-NEXT:    uzp1 z0.b, z1.b, z1.b
; CHECK-NEXT:    uzp1 z1.b, z3.b, z3.b
; CHECK-NEXT:    uzp1 z2.b, z5.b, z5.b
; CHECK-NEXT:    uzp1 z3.b, z7.b, z7.b
; CHECK-NEXT:    splice z1.b, p0, z1.b, z0.b
; CHECK-NEXT:    splice z3.b, p0, z3.b, z2.b
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    orr z0.d, z1.d, z3.d
; CHECK-NEXT:    umaxv b0, p0, z0.b
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    and w0, w8, #0x1
; CHECK-NEXT:    ret
  %v0 = bitcast ptr %a to <16 x float>*
  %v1 = load <16 x float>, <16 x float>* %v0, align 4
  %v2 = fcmp une <16 x float> %v1, zeroinitializer
  %v3 = bitcast float* %b to <16 x float>*
  %v4 = load <16 x float>, <16 x float>* %v3, align 4
  %v5 = fcmp une <16 x float> %v4, zeroinitializer
  %v6 = or <16 x i1> %v2, %v5
  %v7 = call i1 @llvm.vector.reduce.or.i1.v16i1 (<16 x i1> %v6)
  ret i1 %v7
}

declare i1 @llvm.vector.reduce.or.i1.v16i1(<16 x i1>)

;
; AND reduction.
;

define i1 @ptest_and_v16i1(ptr %a, ptr %b) {
; CHECK-LABEL: ptest_and_v16i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ldp q2, q3, [x0, #32]
; CHECK-NEXT:    ldp q4, q5, [x1]
; CHECK-NEXT:    ldp q6, q7, [x1, #32]
; CHECK-NEXT:    fcmne p1.s, p0/z, z3.s, #0.0
; CHECK-NEXT:    fcmne p2.s, p0/z, z2.s, #0.0
; CHECK-NEXT:    fcmne p3.s, p0/z, z1.s, #0.0
; CHECK-NEXT:    fcmne p4.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    fcmne p5.s, p0/z, z7.s, #0.0
; CHECK-NEXT:    fcmne p6.s, p0/z, z6.s, #0.0
; CHECK-NEXT:    fcmne p7.s, p0/z, z5.s, #0.0
; CHECK-NEXT:    fcmne p0.s, p0/z, z4.s, #0.0
; CHECK-NEXT:    mov z0.s, p1/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z1.s, p2/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z2.s, p3/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z3.s, p4/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z4.s, p5/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z5.s, p6/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z6.s, p7/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    mov z7.s, p0/z, #-1 // =0xffffffffffffffff
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    uzp1 z5.h, z5.h, z5.h
; CHECK-NEXT:    uzp1 z6.h, z6.h, z6.h
; CHECK-NEXT:    uzp1 z7.h, z7.h, z7.h
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    splice z1.h, p1, z1.h, z0.h
; CHECK-NEXT:    splice z3.h, p1, z3.h, z2.h
; CHECK-NEXT:    splice z5.h, p1, z5.h, z4.h
; CHECK-NEXT:    splice z7.h, p1, z7.h, z6.h
; CHECK-NEXT:    uzp1 z0.b, z1.b, z1.b
; CHECK-NEXT:    uzp1 z1.b, z3.b, z3.b
; CHECK-NEXT:    uzp1 z2.b, z5.b, z5.b
; CHECK-NEXT:    uzp1 z3.b, z7.b, z7.b
; CHECK-NEXT:    splice z1.b, p0, z1.b, z0.b
; CHECK-NEXT:    splice z3.b, p0, z3.b, z2.b
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    and z0.d, z1.d, z3.d
; CHECK-NEXT:    uminv b0, p0, z0.b
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    and w0, w8, #0x1
; CHECK-NEXT:    ret
  %v0 = bitcast ptr %a to <16 x float>*
  %v1 = load <16 x float>, <16 x float>* %v0, align 4
  %v2 = fcmp une <16 x float> %v1, zeroinitializer
  %v3 = bitcast float* %b to <16 x float>*
  %v4 = load <16 x float>, <16 x float>* %v3, align 4
  %v5 = fcmp une <16 x float> %v4, zeroinitializer
  %v6 = and <16 x i1> %v2, %v5
  %v7 = call i1 @llvm.vector.reduce.and.i1.v16i1 (<16 x i1> %v6)
  ret i1 %v7
}

declare i1 @llvm.vector.reduce.and.i1.v16i1(<16 x i1>)
