; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi ilp32f < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi lp64f < %s | FileCheck %s
; RUN: llc -mtriple=riscv32 -mattr=+zhinx -verify-machineinstrs \
; RUN:   -target-abi ilp32 < %s | FileCheck -check-prefix=CHECKIZHINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinx -verify-machineinstrs \
; RUN:   -target-abi lp64 < %s | FileCheck -check-prefix=CHECKIZHINX %s
; RUN: llc -mtriple=riscv32 -mattr=+zfhmin -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32f | FileCheck -check-prefix=CHECKIZFHMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zfhmin -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64f | FileCheck -check-prefix=CHECKIZFHMIN %s
; RUN: llc -mtriple=riscv32 -mattr=+zhinxmin -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32 | FileCheck -check-prefix=CHECKIZHINXMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinxmin -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64 | FileCheck -check-prefix=CHECKIZHINXMIN %s

define half @select_icmp_eq(i32 signext %a, i32 signext %b, half %c, half %d) {
; CHECK-LABEL: select_icmp_eq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    beq a0, a1, .LBB0_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.h fa0, fa1
; CHECK-NEXT:  .LBB0_2:
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_eq:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    beq a0, a1, .LBB0_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    mv a2, a3
; CHECKIZHINX-NEXT:  .LBB0_2:
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_eq:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    beq a0, a1, .LBB0_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
; CHECKIZFHMIN-NEXT:  .LBB0_2:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_eq:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    beq a0, a1, .LBB0_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a3
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
; CHECKIZHINXMIN-NEXT:  .LBB0_2:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp eq i32 %a, %b
  %2 = select i1 %1, half %c, half %d
  ret half %2
}

define half @select_icmp_ne(i32 signext %a, i32 signext %b, half %c, half %d) {
; CHECK-LABEL: select_icmp_ne:
; CHECK:       # %bb.0:
; CHECK-NEXT:    bne a0, a1, .LBB1_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.h fa0, fa1
; CHECK-NEXT:  .LBB1_2:
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_ne:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    bne a0, a1, .LBB1_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    mv a2, a3
; CHECKIZHINX-NEXT:  .LBB1_2:
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_ne:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    bne a0, a1, .LBB1_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
; CHECKIZFHMIN-NEXT:  .LBB1_2:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_ne:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    bne a0, a1, .LBB1_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a3
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
; CHECKIZHINXMIN-NEXT:  .LBB1_2:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp ne i32 %a, %b
  %2 = select i1 %1, half %c, half %d
  ret half %2
}

define half @select_icmp_ugt(i32 signext %a, i32 signext %b, half %c, half %d) {
; CHECK-LABEL: select_icmp_ugt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    bltu a1, a0, .LBB2_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.h fa0, fa1
; CHECK-NEXT:  .LBB2_2:
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_ugt:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    bltu a1, a0, .LBB2_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    mv a2, a3
; CHECKIZHINX-NEXT:  .LBB2_2:
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_ugt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    bltu a1, a0, .LBB2_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
; CHECKIZFHMIN-NEXT:  .LBB2_2:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_ugt:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    bltu a1, a0, .LBB2_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a3
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
; CHECKIZHINXMIN-NEXT:  .LBB2_2:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp ugt i32 %a, %b
  %2 = select i1 %1, half %c, half %d
  ret half %2
}

define half @select_icmp_uge(i32 signext %a, i32 signext %b, half %c, half %d) {
; CHECK-LABEL: select_icmp_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    bgeu a0, a1, .LBB3_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.h fa0, fa1
; CHECK-NEXT:  .LBB3_2:
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_uge:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    bgeu a0, a1, .LBB3_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    mv a2, a3
; CHECKIZHINX-NEXT:  .LBB3_2:
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_uge:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    bgeu a0, a1, .LBB3_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
; CHECKIZFHMIN-NEXT:  .LBB3_2:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_uge:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    bgeu a0, a1, .LBB3_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a3
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
; CHECKIZHINXMIN-NEXT:  .LBB3_2:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp uge i32 %a, %b
  %2 = select i1 %1, half %c, half %d
  ret half %2
}

define half @select_icmp_ult(i32 signext %a, i32 signext %b, half %c, half %d) {
; CHECK-LABEL: select_icmp_ult:
; CHECK:       # %bb.0:
; CHECK-NEXT:    bltu a0, a1, .LBB4_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.h fa0, fa1
; CHECK-NEXT:  .LBB4_2:
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_ult:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    bltu a0, a1, .LBB4_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    mv a2, a3
; CHECKIZHINX-NEXT:  .LBB4_2:
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_ult:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    bltu a0, a1, .LBB4_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
; CHECKIZFHMIN-NEXT:  .LBB4_2:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_ult:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    bltu a0, a1, .LBB4_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a3
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
; CHECKIZHINXMIN-NEXT:  .LBB4_2:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp ult i32 %a, %b
  %2 = select i1 %1, half %c, half %d
  ret half %2
}

define half @select_icmp_ule(i32 signext %a, i32 signext %b, half %c, half %d) {
; CHECK-LABEL: select_icmp_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    bgeu a1, a0, .LBB5_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.h fa0, fa1
; CHECK-NEXT:  .LBB5_2:
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_ule:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    bgeu a1, a0, .LBB5_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    mv a2, a3
; CHECKIZHINX-NEXT:  .LBB5_2:
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_ule:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    bgeu a1, a0, .LBB5_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
; CHECKIZFHMIN-NEXT:  .LBB5_2:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_ule:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    bgeu a1, a0, .LBB5_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a3
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
; CHECKIZHINXMIN-NEXT:  .LBB5_2:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp ule i32 %a, %b
  %2 = select i1 %1, half %c, half %d
  ret half %2
}

define half @select_icmp_sgt(i32 signext %a, i32 signext %b, half %c, half %d) {
; CHECK-LABEL: select_icmp_sgt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blt a1, a0, .LBB6_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.h fa0, fa1
; CHECK-NEXT:  .LBB6_2:
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_sgt:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    blt a1, a0, .LBB6_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    mv a2, a3
; CHECKIZHINX-NEXT:  .LBB6_2:
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_sgt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    blt a1, a0, .LBB6_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
; CHECKIZFHMIN-NEXT:  .LBB6_2:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_sgt:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    blt a1, a0, .LBB6_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a3
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
; CHECKIZHINXMIN-NEXT:  .LBB6_2:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp sgt i32 %a, %b
  %2 = select i1 %1, half %c, half %d
  ret half %2
}

define half @select_icmp_sge(i32 signext %a, i32 signext %b, half %c, half %d) {
; CHECK-LABEL: select_icmp_sge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    bge a0, a1, .LBB7_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.h fa0, fa1
; CHECK-NEXT:  .LBB7_2:
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_sge:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    bge a0, a1, .LBB7_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    mv a2, a3
; CHECKIZHINX-NEXT:  .LBB7_2:
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_sge:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    bge a0, a1, .LBB7_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
; CHECKIZFHMIN-NEXT:  .LBB7_2:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_sge:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    bge a0, a1, .LBB7_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a3
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
; CHECKIZHINXMIN-NEXT:  .LBB7_2:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp sge i32 %a, %b
  %2 = select i1 %1, half %c, half %d
  ret half %2
}

define half @select_icmp_slt(i32 signext %a, i32 signext %b, half %c, half %d) {
; CHECK-LABEL: select_icmp_slt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    blt a0, a1, .LBB8_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.h fa0, fa1
; CHECK-NEXT:  .LBB8_2:
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_slt:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    blt a0, a1, .LBB8_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    mv a2, a3
; CHECKIZHINX-NEXT:  .LBB8_2:
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_slt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    blt a0, a1, .LBB8_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
; CHECKIZFHMIN-NEXT:  .LBB8_2:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_slt:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    blt a0, a1, .LBB8_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a3
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
; CHECKIZHINXMIN-NEXT:  .LBB8_2:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp slt i32 %a, %b
  %2 = select i1 %1, half %c, half %d
  ret half %2
}

define half @select_icmp_sle(i32 signext %a, i32 signext %b, half %c, half %d) {
; CHECK-LABEL: select_icmp_sle:
; CHECK:       # %bb.0:
; CHECK-NEXT:    bge a1, a0, .LBB9_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.h fa0, fa1
; CHECK-NEXT:  .LBB9_2:
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_sle:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    bge a1, a0, .LBB9_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    mv a2, a3
; CHECKIZHINX-NEXT:  .LBB9_2:
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_sle:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    bge a1, a0, .LBB9_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa1
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
; CHECKIZFHMIN-NEXT:  .LBB9_2:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_sle:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    bge a1, a0, .LBB9_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a3
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
; CHECKIZHINXMIN-NEXT:  .LBB9_2:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a2
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp sle i32 %a, %b
  %2 = select i1 %1, half %c, half %d
  ret half %2
}

define half @select_icmp_slt_one(i32 signext %a) {
; CHECK-LABEL: select_icmp_slt_one:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slti a0, a0, 1
; CHECK-NEXT:    fcvt.h.w fa0, a0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_slt_one:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    slti a0, a0, 1
; CHECKIZHINX-NEXT:    fcvt.h.w a0, a0
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_slt_one:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    slti a0, a0, 1
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_slt_one:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    slti a0, a0, 1
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp slt i32 %a, 1
  %2 = select i1 %1, half 1.000000e+00, half 0.000000e+00
  ret half %2
}

define half @select_icmp_sgt_zero(i32 signext %a) {
; CHECK-LABEL: select_icmp_sgt_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slti a0, a0, 1
; CHECK-NEXT:    fcvt.h.w fa0, a0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: select_icmp_sgt_zero:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    slti a0, a0, 1
; CHECKIZHINX-NEXT:    fcvt.h.w a0, a0
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: select_icmp_sgt_zero:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    slti a0, a0, 1
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: select_icmp_sgt_zero:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    slti a0, a0, 1
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = icmp sgt i32 %a, 0
  %2 = select i1 %1, half 0.000000e+00, half 1.000000e+00
  ret half %2
}
