; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+zbb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64ZBB

declare i32 @llvm.riscv.orc.b.i32(i32)

define signext i32 @orcb32(i32 signext %a) nounwind {
; RV64ZBB-LABEL: orcb32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    orc.b a0, a0
; RV64ZBB-NEXT:    sext.w a0, a0
; RV64ZBB-NEXT:    ret
  %tmp = call i32 @llvm.riscv.orc.b.i32(i32 %a)
  ret i32 %tmp
}

define zeroext i32 @orcb32_zext(i32 zeroext %a) nounwind {
; RV64ZBB-LABEL: orcb32_zext:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    orc.b a0, a0
; RV64ZBB-NEXT:    ret
  %tmp = call i32 @llvm.riscv.orc.b.i32(i32 %a)
  ret i32 %tmp
}

; Second and+or is redundant with the first, make sure we remove them.
define signext i32 @orcb32_knownbits(i32 signext %a) nounwind {
; RV64ZBB-LABEL: orcb32_knownbits:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lui a1, 1044480
; RV64ZBB-NEXT:    and a0, a0, a1
; RV64ZBB-NEXT:    lui a1, 2048
; RV64ZBB-NEXT:    addi a1, a1, 1
; RV64ZBB-NEXT:    or a0, a0, a1
; RV64ZBB-NEXT:    orc.b a0, a0
; RV64ZBB-NEXT:    sext.w a0, a0
; RV64ZBB-NEXT:    ret
  %tmp = and i32 %a, 4278190080 ; 0xFF000000
  %tmp2 = or i32 %tmp, 8388609 ; 0x800001
  %tmp3 = call i32 @llvm.riscv.orc.b.i32(i32 %tmp2)
  %tmp4 = and i32 %tmp3, 4278190080 ; 0xFF000000
  %tmp5 = or i32 %tmp4, 16711935 ; 0xFF00FF
  ret i32 %tmp5
}

declare i64 @llvm.riscv.orc.b.i64(i64)

define i64 @orcb64(i64 %a) nounwind {
; RV64ZBB-LABEL: orcb64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    orc.b a0, a0
; RV64ZBB-NEXT:    ret
  %tmp = call i64 @llvm.riscv.orc.b.i64(i64 %a)
  ret i64 %tmp
}

; Second and+or is redundant with the first, make sure we remove them.
define i64 @orcb64_knownbits(i64 %a) nounwind {
; RV64ZBB-LABEL: orcb64_knownbits:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lui a1, 65535
; RV64ZBB-NEXT:    slli a1, a1, 12
; RV64ZBB-NEXT:    and a0, a0, a1
; RV64ZBB-NEXT:    lui a1, 256
; RV64ZBB-NEXT:    addiw a1, a1, 8
; RV64ZBB-NEXT:    slli a2, a1, 42
; RV64ZBB-NEXT:    add a1, a1, a2
; RV64ZBB-NEXT:    or a0, a0, a1
; RV64ZBB-NEXT:    orc.b a0, a0
; RV64ZBB-NEXT:    ret
  %tmp = and i64 %a, 1099494850560 ; 0x000000ffff000000
  %tmp2 = or i64 %tmp, 4611721202800525320 ; 0x4000200000100008
  %tmp3 = call i64 @llvm.riscv.orc.b.i64(i64 %tmp2)
  %tmp4 = and i64 %tmp3, 1099494850560 ; 0x000000ffff000000
  %tmp5 = or i64 %tmp4, 18374966855153418495 ; 0xff00ff0000ff00ff
  ret i64 %tmp5
}
