; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zfh,+zvfh -verify-machineinstrs | FileCheck %s -check-prefixes=CHECK,RV32
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zfh,+zvfh -verify-machineinstrs | FileCheck %s -check-prefixes=CHECK,RV64

define <vscale x 1 x i1> @nxv1i1(i1 %x, i1 %y) {
; CHECK-LABEL: nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetvli a2, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v8, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v9, a1
; CHECK-NEXT:    vmsne.vi v9, v9, 0
; CHECK-NEXT:    vmxor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 1 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <vscale x 1 x i1> %head.x, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %head.y = insertelement <vscale x 1 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <vscale x 1 x i1> %head.y, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = add <vscale x 1 x i1> %splat.x, %splat.y
  ret <vscale x 1 x i1> %v
}

define <vscale x 2 x i1> @nxv2i1(i1 %x, i1 %y) {
; CHECK-LABEL: nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetvli a2, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v8, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v9, a1
; CHECK-NEXT:    vmsne.vi v9, v9, 0
; CHECK-NEXT:    vmxor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 2 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <vscale x 2 x i1> %head.x, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %head.y = insertelement <vscale x 2 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <vscale x 2 x i1> %head.y, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = add <vscale x 2 x i1> %splat.x, %splat.y
  ret <vscale x 2 x i1> %v
}

define <vscale x 4 x i1> @nxv4i1(i1 %x, i1 %y) {
; CHECK-LABEL: nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetvli a2, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v8, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v9, a1
; CHECK-NEXT:    vmsne.vi v9, v9, 0
; CHECK-NEXT:    vmxor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 4 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <vscale x 4 x i1> %head.x, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %head.y = insertelement <vscale x 4 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <vscale x 4 x i1> %head.y, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = add <vscale x 4 x i1> %splat.x, %splat.y
  ret <vscale x 4 x i1> %v
}

define <vscale x 8 x i1> @nxv8i1(i1 %x, i1 %y) {
; CHECK-LABEL: nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v8, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v9, a1
; CHECK-NEXT:    vmsne.vi v9, v9, 0
; CHECK-NEXT:    vmxor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 8 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <vscale x 8 x i1> %head.x, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %head.y = insertelement <vscale x 8 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <vscale x 8 x i1> %head.y, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = add <vscale x 8 x i1> %splat.x, %splat.y
  ret <vscale x 8 x i1> %v
}

define <vscale x 16 x i1> @nxv16i1(i1 %x, i1 %y) {
; CHECK-LABEL: nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetvli a2, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v10, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vmsne.vi v11, v8, 0
; CHECK-NEXT:    vmxor.mm v0, v10, v11
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 16 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <vscale x 16 x i1> %head.x, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %head.y = insertelement <vscale x 16 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <vscale x 16 x i1> %head.y, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = add <vscale x 16 x i1> %splat.x, %splat.y
  ret <vscale x 16 x i1> %v
}

define <vscale x 32 x i1> @nxv32i1(i1 %x, i1 %y) {
; CHECK-LABEL: nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetvli a2, zero, e8, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v12, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vmsne.vi v13, v8, 0
; CHECK-NEXT:    vmxor.mm v0, v12, v13
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 32 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <vscale x 32 x i1> %head.x, <vscale x 32 x i1> poison, <vscale x 32 x i32> zeroinitializer
  %head.y = insertelement <vscale x 32 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <vscale x 32 x i1> %head.y, <vscale x 32 x i1> poison, <vscale x 32 x i32> zeroinitializer
  %v = add <vscale x 32 x i1> %splat.x, %splat.y
  ret <vscale x 32 x i1> %v
}

define <vscale x 64 x i1> @nxv64i1(i1 %x, i1 %y) {
; CHECK-LABEL: nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetvli a2, zero, e8, m8, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v16, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vmsne.vi v17, v8, 0
; CHECK-NEXT:    vmxor.mm v0, v16, v17
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 64 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <vscale x 64 x i1> %head.x, <vscale x 64 x i1> poison, <vscale x 64 x i32> zeroinitializer
  %head.y = insertelement <vscale x 64 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <vscale x 64 x i1> %head.y, <vscale x 64 x i1> poison, <vscale x 64 x i32> zeroinitializer
  %v = add <vscale x 64 x i1> %splat.x, %splat.y
  ret <vscale x 64 x i1> %v
}

define <vscale x 1 x i8> @nxv1i8(i8 %x, i8 %y) {
; CHECK-LABEL: nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 1 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <vscale x 1 x i8> %head.x, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %head.y = insertelement <vscale x 1 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <vscale x 1 x i8> %head.y, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %v = add <vscale x 1 x i8> %splat.x, %splat.y
  ret <vscale x 1 x i8> %v
}

define <vscale x 2 x i8> @nxv2i8(i8 %x, i8 %y) {
; CHECK-LABEL: nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 2 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <vscale x 2 x i8> %head.x, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %head.y = insertelement <vscale x 2 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <vscale x 2 x i8> %head.y, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %v = add <vscale x 2 x i8> %splat.x, %splat.y
  ret <vscale x 2 x i8> %v
}

define <vscale x 4 x i8> @nxv4i8(i8 %x, i8 %y) {
; CHECK-LABEL: nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 4 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <vscale x 4 x i8> %head.x, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %head.y = insertelement <vscale x 4 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <vscale x 4 x i8> %head.y, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %v = add <vscale x 4 x i8> %splat.x, %splat.y
  ret <vscale x 4 x i8> %v
}

define <vscale x 8 x i8> @nxv8i8(i8 %x, i8 %y) {
; CHECK-LABEL: nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 8 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <vscale x 8 x i8> %head.x, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %head.y = insertelement <vscale x 8 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <vscale x 8 x i8> %head.y, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %v = add <vscale x 8 x i8> %splat.x, %splat.y
  ret <vscale x 8 x i8> %v
}

define <vscale x 16 x i8> @nxv16i8(i8 %x, i8 %y) {
; CHECK-LABEL: nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 16 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <vscale x 16 x i8> %head.x, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %head.y = insertelement <vscale x 16 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <vscale x 16 x i8> %head.y, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %v = add <vscale x 16 x i8> %splat.x, %splat.y
  ret <vscale x 16 x i8> %v
}

define <vscale x 32 x i8> @nxv32i8(i8 %x, i8 %y) {
; CHECK-LABEL: nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 32 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <vscale x 32 x i8> %head.x, <vscale x 32 x i8> poison, <vscale x 32 x i32> zeroinitializer
  %head.y = insertelement <vscale x 32 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <vscale x 32 x i8> %head.y, <vscale x 32 x i8> poison, <vscale x 32 x i32> zeroinitializer
  %v = add <vscale x 32 x i8> %splat.x, %splat.y
  ret <vscale x 32 x i8> %v
}

define <vscale x 64 x i8> @nxv64i8(i8 %x, i8 %y) {
; CHECK-LABEL: nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m8, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 64 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <vscale x 64 x i8> %head.x, <vscale x 64 x i8> poison, <vscale x 64 x i32> zeroinitializer
  %head.y = insertelement <vscale x 64 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <vscale x 64 x i8> %head.y, <vscale x 64 x i8> poison, <vscale x 64 x i32> zeroinitializer
  %v = add <vscale x 64 x i8> %splat.x, %splat.y
  ret <vscale x 64 x i8> %v
}

define <vscale x 1 x i16> @nxv1i16(i16 %x, i16 %y) {
; CHECK-LABEL: nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 1 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <vscale x 1 x i16> %head.x, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %head.y = insertelement <vscale x 1 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <vscale x 1 x i16> %head.y, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %v = add <vscale x 1 x i16> %splat.x, %splat.y
  ret <vscale x 1 x i16> %v
}

define <vscale x 2 x i16> @nxv2i16(i16 %x, i16 %y) {
; CHECK-LABEL: nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 2 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <vscale x 2 x i16> %head.x, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %head.y = insertelement <vscale x 2 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <vscale x 2 x i16> %head.y, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %v = add <vscale x 2 x i16> %splat.x, %splat.y
  ret <vscale x 2 x i16> %v
}

define <vscale x 4 x i16> @nxv4i16(i16 %x, i16 %y) {
; CHECK-LABEL: nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 4 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <vscale x 4 x i16> %head.x, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %head.y = insertelement <vscale x 4 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <vscale x 4 x i16> %head.y, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %v = add <vscale x 4 x i16> %splat.x, %splat.y
  ret <vscale x 4 x i16> %v
}

define <vscale x 8 x i16> @nxv8i16(i16 %x, i16 %y) {
; CHECK-LABEL: nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 8 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <vscale x 8 x i16> %head.x, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %head.y = insertelement <vscale x 8 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <vscale x 8 x i16> %head.y, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %v = add <vscale x 8 x i16> %splat.x, %splat.y
  ret <vscale x 8 x i16> %v
}

define <vscale x 16 x i16> @nxv16i16(i16 %x, i16 %y) {
; CHECK-LABEL: nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 16 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <vscale x 16 x i16> %head.x, <vscale x 16 x i16> poison, <vscale x 16 x i32> zeroinitializer
  %head.y = insertelement <vscale x 16 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <vscale x 16 x i16> %head.y, <vscale x 16 x i16> poison, <vscale x 16 x i32> zeroinitializer
  %v = add <vscale x 16 x i16> %splat.x, %splat.y
  ret <vscale x 16 x i16> %v
}

define <vscale x 32 x i16> @nxv32i16(i16 %x, i16 %y) {
; CHECK-LABEL: nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 32 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <vscale x 32 x i16> %head.x, <vscale x 32 x i16> poison, <vscale x 32 x i32> zeroinitializer
  %head.y = insertelement <vscale x 32 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <vscale x 32 x i16> %head.y, <vscale x 32 x i16> poison, <vscale x 32 x i32> zeroinitializer
  %v = add <vscale x 32 x i16> %splat.x, %splat.y
  ret <vscale x 32 x i16> %v
}

define <vscale x 1 x i32> @nxv1i32(i32 %x, i32 %y) {
; RV32-LABEL: nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    add a0, a0, a1
; RV32-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; RV32-NEXT:    vmv.v.x v8, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e32, mf2, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    vadd.vx v8, v8, a1
; RV64-NEXT:    ret
  %head.x = insertelement <vscale x 1 x i32> poison, i32 %x, i32 0
  %splat.x = shufflevector <vscale x 1 x i32> %head.x, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %head.y = insertelement <vscale x 1 x i32> poison, i32 %y, i32 0
  %splat.y = shufflevector <vscale x 1 x i32> %head.y, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %v = add <vscale x 1 x i32> %splat.x, %splat.y
  ret <vscale x 1 x i32> %v
}

define <vscale x 2 x i32> @nxv2i32(i32 %x, i32 %y) {
; RV32-LABEL: nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    add a0, a0, a1
; RV32-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v8, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e32, m1, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    vadd.vx v8, v8, a1
; RV64-NEXT:    ret
  %head.x = insertelement <vscale x 2 x i32> poison, i32 %x, i32 0
  %splat.x = shufflevector <vscale x 2 x i32> %head.x, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %head.y = insertelement <vscale x 2 x i32> poison, i32 %y, i32 0
  %splat.y = shufflevector <vscale x 2 x i32> %head.y, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %v = add <vscale x 2 x i32> %splat.x, %splat.y
  ret <vscale x 2 x i32> %v
}

define <vscale x 4 x i32> @nxv4i32(i32 %x, i32 %y) {
; RV32-LABEL: nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    add a0, a0, a1
; RV32-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32-NEXT:    vmv.v.x v8, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    vadd.vx v8, v8, a1
; RV64-NEXT:    ret
  %head.x = insertelement <vscale x 4 x i32> poison, i32 %x, i32 0
  %splat.x = shufflevector <vscale x 4 x i32> %head.x, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %head.y = insertelement <vscale x 4 x i32> poison, i32 %y, i32 0
  %splat.y = shufflevector <vscale x 4 x i32> %head.y, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %v = add <vscale x 4 x i32> %splat.x, %splat.y
  ret <vscale x 4 x i32> %v
}

define <vscale x 8 x i32> @nxv8i32(i32 %x, i32 %y) {
; RV32-LABEL: nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    add a0, a0, a1
; RV32-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32-NEXT:    vmv.v.x v8, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e32, m4, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    vadd.vx v8, v8, a1
; RV64-NEXT:    ret
  %head.x = insertelement <vscale x 8 x i32> poison, i32 %x, i32 0
  %splat.x = shufflevector <vscale x 8 x i32> %head.x, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %head.y = insertelement <vscale x 8 x i32> poison, i32 %y, i32 0
  %splat.y = shufflevector <vscale x 8 x i32> %head.y, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %v = add <vscale x 8 x i32> %splat.x, %splat.y
  ret <vscale x 8 x i32> %v
}

define <vscale x 16 x i32> @nxv16i32(i32 %x, i32 %y) {
; RV32-LABEL: nxv16i32:
; RV32:       # %bb.0:
; RV32-NEXT:    add a0, a0, a1
; RV32-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32-NEXT:    vmv.v.x v8, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv16i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e32, m8, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    vadd.vx v8, v8, a1
; RV64-NEXT:    ret
  %head.x = insertelement <vscale x 16 x i32> poison, i32 %x, i32 0
  %splat.x = shufflevector <vscale x 16 x i32> %head.x, <vscale x 16 x i32> poison, <vscale x 16 x i32> zeroinitializer
  %head.y = insertelement <vscale x 16 x i32> poison, i32 %y, i32 0
  %splat.y = shufflevector <vscale x 16 x i32> %head.y, <vscale x 16 x i32> poison, <vscale x 16 x i32> zeroinitializer
  %v = add <vscale x 16 x i32> %splat.x, %splat.y
  ret <vscale x 16 x i32> %v
}

define <vscale x 1 x i64> @nxv1i64(i64 %x, i64 %y) {
; RV32-LABEL: nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v8, (a0), zero
; RV32-NEXT:    sw a3, 4(sp)
; RV32-NEXT:    sw a2, 0(sp)
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vadd.vv v8, v8, v9
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    ret
  %head.x = insertelement <vscale x 1 x i64> poison, i64 %x, i32 0
  %splat.x = shufflevector <vscale x 1 x i64> %head.x, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %head.y = insertelement <vscale x 1 x i64> poison, i64 %y, i32 0
  %splat.y = shufflevector <vscale x 1 x i64> %head.y, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %v = add <vscale x 1 x i64> %splat.x, %splat.y
  ret <vscale x 1 x i64> %v
}

define <vscale x 2 x i64> @nxv2i64(i64 %x, i64 %y) {
; RV32-LABEL: nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV32-NEXT:    vlse64.v v8, (a0), zero
; RV32-NEXT:    sw a3, 4(sp)
; RV32-NEXT:    sw a2, 0(sp)
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vadd.vv v8, v8, v10
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    ret
  %head.x = insertelement <vscale x 2 x i64> poison, i64 %x, i32 0
  %splat.x = shufflevector <vscale x 2 x i64> %head.x, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %head.y = insertelement <vscale x 2 x i64> poison, i64 %y, i32 0
  %splat.y = shufflevector <vscale x 2 x i64> %head.y, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %v = add <vscale x 2 x i64> %splat.x, %splat.y
  ret <vscale x 2 x i64> %v
}

define <vscale x 4 x i64> @nxv4i64(i64 %x, i64 %y) {
; RV32-LABEL: nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV32-NEXT:    vlse64.v v8, (a0), zero
; RV32-NEXT:    sw a3, 4(sp)
; RV32-NEXT:    sw a2, 0(sp)
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vadd.vv v8, v8, v12
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    ret
  %head.x = insertelement <vscale x 4 x i64> poison, i64 %x, i32 0
  %splat.x = shufflevector <vscale x 4 x i64> %head.x, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %head.y = insertelement <vscale x 4 x i64> poison, i64 %y, i32 0
  %splat.y = shufflevector <vscale x 4 x i64> %head.y, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %v = add <vscale x 4 x i64> %splat.x, %splat.y
  ret <vscale x 4 x i64> %v
}

define <vscale x 8 x i64> @nxv8i64(i64 %x, i64 %y) {
; RV32-LABEL: nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v8, (a0), zero
; RV32-NEXT:    sw a3, 4(sp)
; RV32-NEXT:    sw a2, 0(sp)
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    ret
  %head.x = insertelement <vscale x 8 x i64> poison, i64 %x, i32 0
  %splat.x = shufflevector <vscale x 8 x i64> %head.x, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %head.y = insertelement <vscale x 8 x i64> poison, i64 %y, i32 0
  %splat.y = shufflevector <vscale x 8 x i64> %head.y, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %v = add <vscale x 8 x i64> %splat.x, %splat.y
  ret <vscale x 8 x i64> %v
}

define <vscale x 4 x half> @nxv4f16(half %x, half %y) {
; CHECK-LABEL: nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fadd.h fa5, fa0, fa1
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v8, fa5
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 4 x half> poison, half %x, i32 0
  %splat.x = shufflevector <vscale x 4 x half> %head.x, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %head.y = insertelement <vscale x 4 x half> poison, half %y, i32 0
  %splat.y = shufflevector <vscale x 4 x half> %head.y, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %v = fadd <vscale x 4 x half> %splat.x, %splat.y
  ret <vscale x 4 x half> %v
}

define <vscale x 2 x float> @nxv2f32(float %x, float %y) {
; CHECK-LABEL: nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fadd.s fa5, fa0, fa1
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v8, fa5
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 2 x float> poison, float %x, i32 0
  %splat.x = shufflevector <vscale x 2 x float> %head.x, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %head.y = insertelement <vscale x 2 x float> poison, float %y, i32 0
  %splat.y = shufflevector <vscale x 2 x float> %head.y, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %v = fadd <vscale x 2 x float> %splat.x, %splat.y
  ret <vscale x 2 x float> %v
}

define <vscale x 1 x double> @nxv2f64(double %x, double %y) {
; CHECK-LABEL: nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fadd.d fa5, fa0, fa1
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v8, fa5
; CHECK-NEXT:    ret
  %head.x = insertelement <vscale x 1 x double> poison, double %x, i32 0
  %splat.x = shufflevector <vscale x 1 x double> %head.x, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %head.y = insertelement <vscale x 1 x double> poison, double %y, i32 0
  %splat.y = shufflevector <vscale x 1 x double> %head.y, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = fadd <vscale x 1 x double> %splat.x, %splat.y
  ret <vscale x 1 x double> %v
}
