; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-ONLY,AVX512-SLOW,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-ONLY,AVX512-FAST,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512DQ-ONLY,AVX512-SLOW,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512DQ-ONLY,AVX512-FAST,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-ONLY,AVX512-SLOW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-ONLY,AVX512-FAST,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512DQBW-ONLY,AVX512-SLOW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512DQBW-ONLY,AVX512-FAST,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i16_stride7_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride7_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm1
; SSE-NEXT:    movdqa (%r8), %xmm2
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,6,6,6,6]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535,0,0,0,65535]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,6,4,7,7]
; SSE-NEXT:    pandn %xmm5, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,2,0,3,4,5,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, 16(%rax)
; SSE-NEXT:    movdqa %xmm4, (%rax)
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE-NEXT:    movd %xmm0, 24(%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride7_vf2:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa (%r8), %xmm2
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[0,1,4,5,8,9,12,13,u,u,u,u,u,u,2,3]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,u,u,u,u,u,u,0,1,4,5,8,9,u,u]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm3[4,5,6],xmm2[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,7,10,11,14,15,u,u,u,u,u,u,12,13,14,15]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u,2,3,6,7,10,11,u,u,u,u]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3,4,5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX1-ONLY-NEXT:    vmovq %xmm0, 16(%rax)
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, (%rax)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i16_stride7_vf2:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX2-ONLY-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-ONLY-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,ymm0[2,3],zero,zero,zero,zero,zero,zero,ymm0[18,19,22,23,26,27],zero,zero,zero,zero
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-ONLY-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1,4,5,8,9],zero,zero,ymm0[22,23,26,27,30,31],zero,zero,zero,zero,zero,zero,ymm0[24,25,20,21]
; AVX2-ONLY-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-ONLY-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-ONLY-NEXT:    vmovq %xmm1, 16(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, (%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i16_stride7_vf2:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512F-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512F-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512F-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX512F-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512F-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512F-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,ymm0[2,3],zero,zero,zero,zero,zero,zero,ymm0[18,19,22,23,26,27,u,u,u,u]
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512F-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1,4,5,8,9],zero,zero,ymm0[22,23,26,27,30,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-NEXT:    vpextrd $2, %xmm1, 24(%rax)
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vmovq %xmm1, 16(%rax)
; AVX512F-NEXT:    vmovdqa %xmm0, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride7_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512BW-NEXT:    vinserti128 $1, (%r9), %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX512BW-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512BW-NEXT:    vinserti128 $1, (%r10), %ymm2, %ymm1
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,16,18,8,10,24,1,3,17,19,9,11,25,u,u]
; AVX512BW-NEXT:    vpermi2w %ymm1, %ymm0, %ymm2
; AVX512BW-NEXT:    vextracti128 $1, %ymm2, %xmm0
; AVX512BW-NEXT:    vpextrd $2, %xmm0, 24(%rax)
; AVX512BW-NEXT:    vmovq %xmm0, 16(%rax)
; AVX512BW-NEXT:    vmovdqa %xmm2, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <2 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <2 x i16>, ptr %in.vecptr4, align 64
  %in.vec5 = load <2 x i16>, ptr %in.vecptr5, align 64
  %in.vec6 = load <2 x i16>, ptr %in.vecptr6, align 64
  %1 = shufflevector <2 x i16> %in.vec0, <2 x i16> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i16> %in.vec2, <2 x i16> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <2 x i16> %in.vec4, <2 x i16> %in.vec5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <4 x i16> %1, <4 x i16> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = shufflevector <2 x i16> %in.vec6, <2 x i16> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %6 = shufflevector <4 x i16> %3, <4 x i16> %5, <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
  %7 = shufflevector <6 x i16> %6, <6 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 undef, i32 undef>
  %8 = shufflevector <8 x i16> %4, <8 x i16> %7, <14 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13>
  %interleaved.vec = shufflevector <14 x i16> %8, <14 x i16> poison, <14 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13>
  store <14 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride7_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride7_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movq {{.*#+}} xmm3 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm5 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm4 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm6 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm6[0]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[0,1,0,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm2[0,0,2,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pand %xmm6, %xmm8
; SSE-NEXT:    pandn %xmm7, %xmm6
; SSE-NEXT:    por %xmm8, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm4[0,1,1,3,4,5,6,7]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm8 = xmm8[0],xmm3[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,0,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm10
; SSE-NEXT:    movdqa %xmm3, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm3[1,1,1,1,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm0[0],xmm5[1],xmm0[1],xmm5[2],xmm0[2],xmm5[3],xmm0[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,2,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm5[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm7, %xmm12
; SSE-NEXT:    pandn %xmm8, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    por %xmm12, %xmm7
; SSE-NEXT:    pand %xmm5, %xmm7
; SSE-NEXT:    pandn %xmm6, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    psrld $16, %xmm10
; SSE-NEXT:    punpckldq {{.*#+}} xmm9 = xmm9[0],xmm10[0],xmm9[1],xmm10[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,65535,65535,0,0,65535]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm0[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,1,2,3]
; SSE-NEXT:    pand %xmm7, %xmm6
; SSE-NEXT:    pandn %xmm9, %xmm7
; SSE-NEXT:    por %xmm6, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,0,0,0,65535,65535,65535]
; SSE-NEXT:    pand %xmm6, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm2[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm8[0,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[1,1,1,1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm9 = xmm9[0],xmm10[0]
; SSE-NEXT:    pandn %xmm9, %xmm6
; SSE-NEXT:    por %xmm7, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[0,3,1,3,4,5,6,7]
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm8
; SSE-NEXT:    psrlq $48, %xmm4
; SSE-NEXT:    por %xmm8, %xmm4
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm7
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm11[2,1]
; SSE-NEXT:    movaps {{.*#+}} xmm3 = [65535,65535,65535,65535,0,0,0,65535]
; SSE-NEXT:    andps %xmm3, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    andnps %xmm2, %xmm3
; SSE-NEXT:    orps %xmm0, %xmm3
; SSE-NEXT:    movaps %xmm3, (%rax)
; SSE-NEXT:    movq %xmm7, 48(%rax)
; SSE-NEXT:    movdqa %xmm6, 32(%rax)
; SSE-NEXT:    movdqa %xmm5, 16(%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride7_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm1[0,1,1,3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,7,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm2[3,1,2,1]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[2,0,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1,2,3,4],xmm3[5,6],xmm4[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[3,1,2,3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm4[0,1,2,0,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovddup {{.*#+}} xmm6 = mem[0,0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm7 = xmm6[1,1,1,1]
; AVX1-ONLY-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm7[0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm5[2,3,4],xmm3[5,6,7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[0,3,1,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2],xmm6[3],xmm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm2[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0],xmm4[1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = xmm1[0,1,8,9,u,u,u,u,u,u,u,u,2,3,2,3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm2[0,1,0,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm7[2,3],xmm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vpxor %xmm7, %xmm7, %xmm7
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm0[0],xmm7[1,2,3],xmm0[4],xmm7[5,6,7]
; AVX1-ONLY-NEXT:    vpmovzxwq {{.*#+}} xmm8 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero
; AVX1-ONLY-NEXT:    vpackusdw %xmm8, %xmm7, %xmm7
; AVX1-ONLY-NEXT:    vpackusdw %xmm7, %xmm7, %xmm7
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3],xmm7[4,5,6],xmm5[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[10,11,u,u,u,u,u,u,u,u,u,u,4,5,12,13]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1,2],xmm1[3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovsldup {{.*#+}} xmm0 = xmm0[0,0,2,2]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4],xmm6[5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[3,4,5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, 16(%rax)
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, (%rax)
; AVX1-ONLY-NEXT:    vmovq %xmm4, 48(%rax)
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, 32(%rax)
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride7_vf4:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[2],ymm4[2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[2,3],zero,zero,ymm2[18,19,26,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm2[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,ymm5[0,1,8,9,4,5,6,7,4,5],zero,zero,ymm5[26,27],zero,zero,zero,zero,ymm5[24,25,20,21,22,23,20,21,28,29]
; AVX2-SLOW-NEXT:    vpor %ymm5, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm0[2,3,2,3,2,3,2,3],zero,zero,zero,zero,ymm0[0,1,2,3,18,19,18,19,18,19,18,19,26,27],zero,zero,ymm0[16,17,18,19]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,ymm1[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm1[18,19],zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpor %ymm5, %ymm6, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[12,13,6,7],zero,zero,zero,zero,ymm0[4,5,4,5,4,5,4,5,28,29,22,23,30,31],zero,zero,ymm0[20,21,20,21,20,21,20,21]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,zero,ymm1[4,5,12,13],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm1[22,23],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[14,15,14,15,14,15,14,15,4,5,6,7,14,15,14,15,30,31,30,31,30,31,30,31,20,21,22,23,30,31,30,31]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm3[3,1,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,0,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,0,0,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, (%rax)
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vmovq %xmm1, 48(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, 32(%rax)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride7_vf4:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [5,7,1,3,7,u,u,u]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,1,4,5],zero,zero,zero,zero,zero,zero,ymm1[10,11,14,15,2,3,18,19],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [1,3,5,7,1,3,5,7]
; AVX2-FAST-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,ymm3[0,1,4,5,8,9],zero,zero,zero,zero,zero,zero,zero,zero,ymm3[18,19,22,23,26,27],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpor %ymm3, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm2[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[2,3],zero,zero,ymm2[18,19,26,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,ymm2[0,1,8,9,4,5,6,7,4,5],zero,zero,ymm2[26,27],zero,zero,zero,zero,ymm2[24,25,20,21,22,23,20,21,28,29]
; AVX2-FAST-NEXT:    vpor %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,2,4,6,0,2,4,6]
; AVX2-FAST-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,0,1,4,5,8,9,u,u,u,u,u,u,u,u,18,19,22,23,26,27,u,u,u,u]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX2-FAST-NEXT:    vmovq %xmm0, 48(%rax)
; AVX2-FAST-NEXT:    vmovdqa %xmm1, 32(%rax)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride7_vf4:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[2],ymm4[2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,2,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm2[2,3],zero,zero,ymm2[18,19,26,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm2[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,ymm5[0,1,8,9,4,5,6,7,4,5],zero,zero,ymm5[26,27],zero,zero,zero,zero,ymm5[24,25,20,21,22,23,20,21,28,29]
; AVX2-FAST-PERLANE-NEXT:    vpor %ymm5, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm5 = ymm0[2,3,2,3,2,3,2,3],zero,zero,zero,zero,ymm0[0,1,2,3,18,19,18,19,18,19,18,19,26,27],zero,zero,ymm0[16,17,18,19]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,ymm1[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm1[18,19],zero,zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpor %ymm5, %ymm6, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[12,13,6,7],zero,zero,zero,zero,ymm0[4,5,4,5,4,5,4,5,28,29,22,23,30,31],zero,zero,ymm0[20,21,20,21,20,21,20,21]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,zero,ymm1[4,5,12,13],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm1[22,23],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[14,15,14,15,14,15,14,15,4,5,6,7,14,15,14,15,30,31,30,31,30,31,30,31,20,21,22,23,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[4,5,12,13,4,5,6,7,8,9,10,11,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,0,0,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovq %xmm1, 48(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride7_vf4:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512F-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512F-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512F-SLOW-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[2],ymm4[2]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,2,1,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm0[u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm0[0,1,u,u,u,u,u,u,u,u,18,19,26,27],zero,zero,ymm0[u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u],zero,zero,zero,zero,ymm0[4,5,u,u,u,u,u,u,u,u,22,23,30,31],zero,zero,ymm0[u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm4, %zmm0
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm1[u,u,u,u,u,u,u,u,0,1,8,9],zero,zero,ymm1[u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm1[18,19,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,4,5,12,13],zero,zero,ymm1[u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm1[22,23,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm4, %zmm1
; AVX512F-SLOW-NEXT:    vporq %zmm0, %zmm1, %zmm0
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm2[2,3,0,1]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,zero,ymm1[0,1,8,9,u,u,u,u,u,u],zero,zero,ymm1[26,27],zero,zero,zero,zero,ymm1[u,u,u,u,u,u,20,21,28,29]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,zero,zero,ymm2[u,u,u,u,u,u,6,7,14,15],zero,zero,ymm2[30,31,u,u,u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[0,1,8,9],zero,zero,zero,zero,ymm2[u,u,u,u,u,u,2,3],zero,zero,ymm2[18,19,26,27,u,u,u,u,u,u],zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[4,5,12,13,u,u,u,u,u,u],zero,zero,zero,zero,ymm3[6,7],zero,zero,ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512F-SLOW-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512F-SLOW-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm1
; AVX512F-SLOW-NEXT:    vextracti32x4 $2, %zmm1, 32(%rax)
; AVX512F-SLOW-NEXT:    vextracti32x4 $3, %zmm1, %xmm0
; AVX512F-SLOW-NEXT:    vmovq %xmm0, 48(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm1, (%rax)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride7_vf4:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512F-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512F-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512F-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,2,4,u]
; AVX512F-FAST-NEXT:    vpermi2q %ymm3, %ymm0, %ymm1
; AVX512F-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [0,2,4,6,0,2,4,6]
; AVX512F-FAST-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512F-FAST-NEXT:    vpermd %ymm1, %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1,4,5,8,9],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[18,19,22,23,26,27],zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [1,3,5,7,1,3,5,7]
; AVX512F-FAST-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512F-FAST-NEXT:    vpermd %ymm1, %ymm3, %ymm1
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,zero,ymm1[0,1,4,5,8,9],zero,zero,zero,zero,zero,zero,zero,zero,ymm1[18,19,22,23,26,27],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[0,1,8,9],zero,zero,zero,zero,ymm2[u,u,u,u,u,u,2,3],zero,zero,ymm2[18,19,26,27,u,u,u,u,u,u],zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm2[2,3,0,1]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,ymm3[0,1,8,9,u,u,u,u,u,u],zero,zero,ymm3[26,27],zero,zero,zero,zero,ymm3[u,u,u,u,u,u,20,21,28,29]
; AVX512F-FAST-NEXT:    vpternlogq $168, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm3
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [5,7,1,3,7,u,u,u]
; AVX512F-FAST-NEXT:    vpermd %ymm2, %ymm1, %ymm1
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,1,4,5],zero,zero,zero,zero,zero,zero,ymm1[10,11,14,15,2,3,18,19],zero,zero,zero,zero,zero,zero,ymm1[u,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm1
; AVX512F-FAST-NEXT:    vporq %zmm0, %zmm1, %zmm0
; AVX512F-FAST-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512F-FAST-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512F-FAST-NEXT:    vmovq %xmm1, 48(%rax)
; AVX512F-FAST-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-SLOW-LABEL: store_i16_stride7_vf4:
; AVX512BW-SLOW:       # %bb.0:
; AVX512BW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-SLOW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-SLOW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512BW-SLOW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-SLOW-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512BW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512BW-SLOW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512BW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[2]
; AVX512BW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,4,8,12,32,40,36,1,5,9,13,33,41,37,2,6,10,14,34,42,38,3,7,11,15,35,43,39,u,u,u,u]
; AVX512BW-SLOW-NEXT:    vpermi2w %zmm0, %zmm2, %zmm1
; AVX512BW-SLOW-NEXT:    vextracti32x4 $2, %zmm1, 32(%rax)
; AVX512BW-SLOW-NEXT:    vextracti32x4 $3, %zmm1, %xmm0
; AVX512BW-SLOW-NEXT:    vmovq %xmm0, 48(%rax)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm1, (%rax)
; AVX512BW-SLOW-NEXT:    vzeroupper
; AVX512BW-SLOW-NEXT:    retq
;
; AVX512BW-FAST-LABEL: store_i16_stride7_vf4:
; AVX512BW-FAST:       # %bb.0:
; AVX512BW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FAST-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-FAST-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512BW-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-FAST-NEXT:    vmovq {{.*#+}} xmm4 = mem[0],zero
; AVX512BW-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512BW-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,2,4,u]
; AVX512BW-FAST-NEXT:    vpermi2q %ymm3, %ymm0, %ymm1
; AVX512BW-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm0
; AVX512BW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,4,8,12,16,20,24,1,5,9,13,17,21,25,2,6,10,14,18,22,26,3,7,11,15,19,23,27,u,u,u,u]
; AVX512BW-FAST-NEXT:    vpermw %zmm0, %zmm1, %zmm0
; AVX512BW-FAST-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512BW-FAST-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512BW-FAST-NEXT:    vmovq %xmm1, 48(%rax)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm0, (%rax)
; AVX512BW-FAST-NEXT:    vzeroupper
; AVX512BW-FAST-NEXT:    retq
  %in.vec0 = load <4 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <4 x i16>, ptr %in.vecptr4, align 64
  %in.vec5 = load <4 x i16>, ptr %in.vecptr5, align 64
  %in.vec6 = load <4 x i16>, ptr %in.vecptr6, align 64
  %1 = shufflevector <4 x i16> %in.vec0, <4 x i16> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i16> %in.vec2, <4 x i16> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <4 x i16> %in.vec4, <4 x i16> %in.vec5, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = shufflevector <8 x i16> %1, <8 x i16> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %5 = shufflevector <4 x i16> %in.vec6, <4 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <8 x i16> %3, <8 x i16> %5, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %7 = shufflevector <12 x i16> %6, <12 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <16 x i16> %4, <16 x i16> %7, <28 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27>
  %interleaved.vec = shufflevector <28 x i16> %8, <28 x i16> poison, <28 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27>
  store <28 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride7_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride7_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm3
; SSE-NEXT:    movdqa (%rsi), %xmm8
; SSE-NEXT:    movdqa (%rdx), %xmm5
; SSE-NEXT:    movdqa (%rcx), %xmm11
; SSE-NEXT:    movdqa (%r8), %xmm4
; SSE-NEXT:    movdqa (%r9), %xmm10
; SSE-NEXT:    movdqa (%rax), %xmm2
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm11[4],xmm0[5],xmm11[5],xmm0[6],xmm11[6],xmm0[7],xmm11[7]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4],xmm8[4],xmm6[5],xmm8[5],xmm6[6],xmm8[6],xmm6[7],xmm8[7]
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm0[2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[2,3,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm10[0],xmm7[1],xmm10[1],xmm7[2],xmm10[2],xmm7[3],xmm10[3]
; SSE-NEXT:    movdqa %xmm10, %xmm13
; SSE-NEXT:    punpckhwd {{.*#+}} xmm13 = xmm13[4],xmm4[4],xmm13[5],xmm4[5],xmm13[6],xmm4[6],xmm13[7],xmm4[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm13 = xmm13[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm12, %xmm13
; SSE-NEXT:    pandn %xmm9, %xmm12
; SSE-NEXT:    por %xmm13, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,2],xmm12[0,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pandn %xmm2, %xmm9
; SSE-NEXT:    movdqa %xmm7, %xmm12
; SSE-NEXT:    movdqa %xmm7, %xmm13
; SSE-NEXT:    psrldq {{.*#+}} xmm13 = xmm13[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm9, %xmm13
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    pshufhw {{.*#+}} xmm15 = xmm11[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm14, %xmm15
; SSE-NEXT:    pandn %xmm9, %xmm14
; SSE-NEXT:    movaps {{.*#+}} xmm9 = [65535,0,0,0,65535,65535,65535,65535]
; SSE-NEXT:    por %xmm15, %xmm14
; SSE-NEXT:    movdqa %xmm6, %xmm15
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm14[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm14 = xmm11[3,3,3,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,1],xmm15[0,2]
; SSE-NEXT:    andps %xmm9, %xmm14
; SSE-NEXT:    andnps %xmm13, %xmm9
; SSE-NEXT:    orps %xmm14, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm2[0,1,0,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    pslldq {{.*#+}} xmm12 = zero,zero,xmm12[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm14, %xmm12
; SSE-NEXT:    pandn %xmm13, %xmm14
; SSE-NEXT:    por %xmm12, %xmm14
; SSE-NEXT:    movdqa %xmm11, %xmm12
; SSE-NEXT:    psrld $16, %xmm12
; SSE-NEXT:    movdqa %xmm5, %xmm13
; SSE-NEXT:    punpckldq {{.*#+}} xmm13 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm8, %xmm15
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm3[0],xmm15[1],xmm3[1],xmm15[2],xmm3[2],xmm15[3],xmm3[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm15 = xmm15[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm15 = xmm15[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm12, %xmm15
; SSE-NEXT:    pandn %xmm13, %xmm12
; SSE-NEXT:    movdqa %xmm5, %xmm13
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm11[0],xmm5[1],xmm11[1],xmm5[2],xmm11[2],xmm5[3],xmm11[3]
; SSE-NEXT:    por %xmm15, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    pand %xmm15, %xmm12
; SSE-NEXT:    pandn %xmm14, %xmm15
; SSE-NEXT:    movdqa %xmm4, %xmm14
; SSE-NEXT:    punpckhwd {{.*#+}} xmm14 = xmm14[4],xmm10[4],xmm14[5],xmm10[5],xmm14[6],xmm10[6],xmm14[7],xmm10[7]
; SSE-NEXT:    por %xmm12, %xmm15
; SSE-NEXT:    psrlq $48, %xmm11
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm13 = xmm13[1],xmm11[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    pandn %xmm13, %xmm11
; SSE-NEXT:    movdqa %xmm6, %xmm13
; SSE-NEXT:    psrldq {{.*#+}} xmm13 = xmm13[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm11, %xmm13
; SSE-NEXT:    psrld $16, %xmm10
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    punpckhdq {{.*#+}} xmm11 = xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,65535,0,0,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm12
; SSE-NEXT:    pandn %xmm11, %xmm12
; SSE-NEXT:    por %xmm13, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    pand %xmm10, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm2[3,3,3,3]
; SSE-NEXT:    pandn %xmm11, %xmm10
; SSE-NEXT:    por %xmm12, %xmm10
; SSE-NEXT:    movdqa %xmm3, %xmm12
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm3[1,1,1,1,4,5,6,7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm8[0],xmm3[1],xmm8[1],xmm3[2],xmm8[2],xmm3[3],xmm8[3]
; SSE-NEXT:    psrld $16, %xmm8
; SSE-NEXT:    punpckldq {{.*#+}} xmm12 = xmm12[0],xmm8[0],xmm12[1],xmm8[1]
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pandn %xmm12, %xmm8
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm5[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[2,1,2,3]
; SSE-NEXT:    pand %xmm0, %xmm12
; SSE-NEXT:    por %xmm8, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535,0,0,0,65535,65535,65535]
; SSE-NEXT:    pand %xmm8, %xmm12
; SSE-NEXT:    movdqa %xmm7, %xmm13
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,2],xmm2[1,1]
; SSE-NEXT:    pandn %xmm13, %xmm8
; SSE-NEXT:    por %xmm12, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm12 = zero,zero,zero,zero,zero,zero,xmm12[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    pslldq {{.*#+}} xmm6 = zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm12, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm6
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,3],xmm14[0,1]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm4[2,1]
; SSE-NEXT:    movaps {{.*#+}} xmm4 = [65535,65535,65535,0,0,0,0,65535]
; SSE-NEXT:    andps %xmm4, %xmm6
; SSE-NEXT:    andnps %xmm0, %xmm4
; SSE-NEXT:    orps %xmm6, %xmm4
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm3[0]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm11[2,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movaps {{.*#+}} xmm2 = [65535,65535,65535,65535,0,0,0,65535]
; SSE-NEXT:    andps %xmm2, %xmm5
; SSE-NEXT:    andnps %xmm0, %xmm2
; SSE-NEXT:    orps %xmm5, %xmm2
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm2, (%rax)
; SSE-NEXT:    movaps %xmm4, 64(%rax)
; SSE-NEXT:    movdqa %xmm15, 16(%rax)
; SSE-NEXT:    movdqa %xmm8, 32(%rax)
; SSE-NEXT:    movaps %xmm9, 48(%rax)
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0,1,3]
; SSE-NEXT:    movaps %xmm1, 80(%rax)
; SSE-NEXT:    movdqa %xmm10, 96(%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride7_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm8
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm4
; AVX1-ONLY-NEXT:    vmovdqa (%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa (%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa (%r10), %xmm1
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm4, %xmm5
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm6[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0],xmm5[1,2],xmm6[3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm2[0],xmm4[0],xmm2[1],xmm4[1],xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm9[0,0,1,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm10[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[0,1,2,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm10[0,1],xmm6[2,3],xmm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm6 = [65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm11 = zero,zero,xmm10[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm1[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2,3,4],xmm12[5],xmm11[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm10[0,1,0,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm1[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,5],xmm13[6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm12, %ymm11
; AVX1-ONLY-NEXT:    vandnps %ymm11, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm2[2,2,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm4[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,5],xmm6[6],xmm11[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm6[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2,3],xmm12[4,5],xmm11[6,7]
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm8, %xmm8
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm9[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[2,1,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm8[0,1,2,3,4],xmm7[5,6],xmm8[7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm8 = [65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm8, %ymm7
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm9 = xmm10[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1,2],xmm1[3],xmm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm10 = xmm10[0,2],xmm1[1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX1-ONLY-NEXT:    vandnps %ymm9, %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm8, %ymm7
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm2[4],xmm4[4],xmm2[5],xmm4[5],xmm2[6],xmm4[6],xmm2[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1,2,3],xmm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm8 = zero,zero,zero,zero,zero,zero,xmm8[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm10 = zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm10[0,1,2,3,4],xmm8[5,6],xmm10[7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm9 = [65535,65535,65535,0,0,0,0,65535,65535,65535,0,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm8, %ymm9, %ymm8
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm10[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0],xmm11[1],xmm10[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm11[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm1[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1],xmm12[2,3],xmm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX1-ONLY-NEXT:    vandps %ymm9, %ymm10, %ymm9
; AVX1-ONLY-NEXT:    vorps %ymm8, %ymm9, %ymm8
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm4, %xmm4
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm4[1]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm4 = xmm6[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1,2],xmm2[3,4],xmm4[5,6,7]
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm3, %xmm3
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[8,9,u,u,u,u,u,u,u,u,6,7,10,11,12,13]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1,2,3,4],xmm0[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, (%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride7_vf8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm4
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm5
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %xmm3
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm7
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm4, %ymm8
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm9
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = ymm8[4,5,u,u,u,u,u,u,u,u,u,u,u,u,6,7,22,23,u,u,u,u,u,u,u,u,u,u,u,u,24,25]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm8[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm10 = ymm10[2,2,2,2,4,5,6,7,10,10,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm10[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0],ymm10[1],ymm6[2,3,4,5],ymm10[6],ymm6[7,8],ymm10[9],ymm6[10,11,12,13],ymm10[14],ymm6[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm7[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,6,7,14,15,u,u,u,u,u,u,u,u,u,u,16,17,24,25,u,u,u,u]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm6, %ymm10, %ymm6
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm9[0,2,0,2]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm11 = ymm10[u,u,u,u,4,5,12,13,u,u,u,u,u,u,u,u,u,u,22,23,30,31,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpbroadcastd 4(%r10), %ymm12
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm6, %ymm11, %ymm6
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm8[1,3,1,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm11[2,3,10,11],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm11[20,21,28,29],zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm7[1,3,1,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm12 = zero,zero,zero,zero,zero,zero,ymm12[2,3,10,11],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm12[20,21,28,29],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[1,3,3,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[0,1,8,9,u,u,u,u,u,u,u,u,u,u,2,3,18,19,u,u,u,u,u,u,u,u,u,u,28,29,20,21]
; AVX2-SLOW-NEXT:    vpbroadcastd 8(%r10), %ymm12
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm9, %ymm12, %ymm9
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm9, %ymm11, %ymm9
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,0,2]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm8 = zero,zero,zero,zero,ymm8[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm8[18,19,26,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,2,2,0]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm7[2,3,18,19],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm7[28,29,20,21]
; AVX2-SLOW-NEXT:    vpor %ymm7, %ymm8, %ymm7
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm8 = ymm10[u,u,u,u,u,u,u,u,0,1,8,9,u,u,u,u,u,u,u,u,u,u,18,19,26,27,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpbroadcastd (%r10), %ymm10
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm8, %ymm10, %ymm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm7, %ymm8, %ymm7
; AVX2-SLOW-NEXT:    vpsrlq $48, %xmm5, %xmm5
; AVX2-SLOW-NEXT:    vpunpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm5[1]
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; AVX2-SLOW-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm4[3,4],xmm0[5,6,7]
; AVX2-SLOW-NEXT:    vpsrld $16, %xmm3, %xmm2
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-SLOW-NEXT:    vpbroadcastd 12(%r10), %xmm2
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3,4],xmm1[5,6],xmm2[7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4],xmm1[5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, (%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm9, 64(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, 32(%rax)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride7_vf8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm2
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm4
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm5
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm1
; AVX2-FAST-NEXT:    vmovdqa (%r9), %xmm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm7
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm4, %ymm8
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm9
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm7[0,2,1,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[6,7,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm6[16,17,24,25],zero,zero,zero,zero
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [1,5,u,u,5,2,6,u]
; AVX2-FAST-NEXT:    vpermd %ymm8, %ymm10, %ymm10
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[0,1,4,5],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm10[2,3,18,19],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm10[20,21,24,25]
; AVX2-FAST-NEXT:    vpor %ymm6, %ymm10, %ymm6
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm10 = ymm9[0,2,0,2]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm11 = ymm10[u,u,u,u,4,5,12,13,u,u,u,u,u,u,u,u,u,u,22,23,30,31,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpbroadcastd 4(%r10), %ymm12
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm6, %ymm11, %ymm6
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm8[1,3,1,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm11[2,3,10,11],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm11[20,21,28,29],zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm7[1,3,1,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm12 = zero,zero,zero,zero,zero,zero,ymm12[2,3,10,11],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm12[20,21,28,29],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[1,3,3,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[0,1,8,9,u,u,u,u,u,u,u,u,u,u,2,3,18,19,u,u,u,u,u,u,u,u,u,u,28,29,20,21]
; AVX2-FAST-NEXT:    vpbroadcastd 8(%r10), %ymm12
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm9, %ymm12, %ymm9
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm9, %ymm11, %ymm9
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,0,2]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = zero,zero,zero,zero,ymm8[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm8[18,19,26,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,2,2,0]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm7[2,3,18,19],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm7[28,29,20,21]
; AVX2-FAST-NEXT:    vpor %ymm7, %ymm8, %ymm7
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = ymm10[u,u,u,u,u,u,u,u,0,1,8,9,u,u,u,u,u,u,u,u,u,u,18,19,26,27,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpbroadcastd (%r10), %ymm10
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm8, %ymm10, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm7, %ymm8, %ymm7
; AVX2-FAST-NEXT:    vpsrlq $48, %xmm5, %xmm5
; AVX2-FAST-NEXT:    vpunpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm5[1]
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; AVX2-FAST-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm4[3,4],xmm0[5,6,7]
; AVX2-FAST-NEXT:    vpsrld $16, %xmm3, %xmm2
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-FAST-NEXT:    vpbroadcastd 12(%r10), %xmm2
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3,4],xmm1[5,6],xmm2[7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4],xmm1[5,6,7]
; AVX2-FAST-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm7, (%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm9, 64(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm6, 32(%rax)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride7_vf8:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm5, %ymm4, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm6 = ymm8[4,5,u,u,u,u,u,u,u,u,u,u,u,u,6,7,22,23,u,u,u,u,u,u,u,u,u,u,u,u,24,25]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm8[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,4,5,u,u,u,u,u,u,u,u,8,9,u,u,u,u,20,21,u,u,u,u,u,u,u,u,24,25,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0],ymm10[1],ymm6[2,3,4,5],ymm10[6],ymm6[7,8],ymm10[9],ymm6[10,11,12,13],ymm10[14],ymm6[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm7[0,2,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,6,7,14,15,u,u,u,u,u,u,u,u,u,u,16,17,24,25,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm6, %ymm10, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm9[0,2,0,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm11 = ymm10[u,u,u,u,4,5,12,13,u,u,u,u,u,u,u,u,u,u,22,23,30,31,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 4(%r10), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm6, %ymm11, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm8[1,3,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm11 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm11[2,3,10,11],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm11[20,21,28,29],zero,zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm7[1,3,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm12 = zero,zero,zero,zero,zero,zero,ymm12[2,3,10,11],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm12[20,21,28,29],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpor %ymm11, %ymm12, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[1,3,3,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm9 = ymm9[0,1,8,9,u,u,u,u,u,u,u,u,u,u,2,3,18,19,u,u,u,u,u,u,u,u,u,u,28,29,20,21]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 8(%r10), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm9, %ymm12, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm9, %ymm11, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,0,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm8 = zero,zero,zero,zero,ymm8[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm8[18,19,26,27],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,2,2,0]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[0,1,8,9],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm7[2,3,18,19],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm7[28,29,20,21]
; AVX2-FAST-PERLANE-NEXT:    vpor %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm8 = ymm10[u,u,u,u,u,u,u,u,0,1,8,9,u,u,u,u,u,u,u,u,u,u,18,19,26,27,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%r10), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm8, %ymm10, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpsrlq $48, %xmm5, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpunpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm5[1]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; AVX2-FAST-PERLANE-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm4[3,4],xmm0[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpsrld $16, %xmm3, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 12(%r10), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3,4],xmm1[5,6],xmm2[7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4],xmm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm7, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm9, 64(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride7_vf8:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %xmm3
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %xmm4
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %xmm5
; AVX512F-SLOW-NEXT:    vmovdqa (%r9), %xmm6
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm7
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm2
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm5, %ymm8
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm2[0,2,0,2]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm9 = zero,zero,zero,zero,ymm9[0,1,8,9,u,u,u,u,u,u],zero,zero,zero,zero,ymm9[18,19,26,27,u,u,u,u,u,u],zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm7[0,2,1,3]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm10 = zero,zero,zero,zero,ymm10[u,u,u,u,u,u,6,7,14,15],zero,zero,zero,zero,ymm10[u,u,u,u,u,u,16,17,24,25],zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm9
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm10 = ymm2[4,5,u,u,u,u,u,u,u,u,u,u,u,u,6,7,22,23,u,u,u,u,u,u,u,u,u,u,u,u,24,25]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm2[2,3,0,1]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm11 = ymm11[2,2,2,2,4,5,6,7,10,10,10,10,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm11[0,1,2,2,4,5,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm10[0],ymm11[1],ymm10[2,3,4,5],ymm11[6],ymm10[7,8],ymm11[9],ymm10[10,11,12,13],ymm11[14],ymm10[15]
; AVX512F-SLOW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm10, %ymm10
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm7[0,2,2,0]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[0,1,8,9],zero,zero,zero,zero,ymm11[u,u,u,u,u,u,2,3,18,19],zero,zero,zero,zero,ymm11[u,u,u,u,u,u,28,29,20,21]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm10, %zmm11, %zmm10
; AVX512F-SLOW-NEXT:    vporq %zmm9, %zmm10, %zmm9
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm8[0,2,0,2]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm11 = ymm10[u,u,u,u,u,u,u,u,0,1,8,9],zero,zero,ymm10[u,u,u,u,u,u,u,u,18,19,26,27],zero,zero,ymm10[u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,4,5,12,13],zero,zero,ymm10[u,u,u,u,u,u,u,u,22,23,30,31],zero,zero,ymm10[u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm10, %zmm11, %zmm10
; AVX512F-SLOW-NEXT:    vpbroadcastd (%r10), %ymm11
; AVX512F-SLOW-NEXT:    vpbroadcastd 4(%r10), %ymm12
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm12, %zmm11, %zmm11
; AVX512F-SLOW-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm11
; AVX512F-SLOW-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm11
; AVX512F-SLOW-NEXT:    vpsrlq $48, %xmm4, %xmm4
; AVX512F-SLOW-NEXT:    vpunpckhqdq {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512F-SLOW-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3,4],xmm0[5,6,7]
; AVX512F-SLOW-NEXT:    vpsrld $16, %xmm6, %xmm1
; AVX512F-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX512F-SLOW-NEXT:    vpbroadcastd 12(%r10), %xmm3
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm3[0,1,2,3,4],xmm1[5,6],xmm3[7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4],xmm1[5,6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm2[1,3,1,3]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u],zero,zero,zero,zero,ymm1[2,3,10,11,u,u,u,u,u,u],zero,zero,zero,zero,ymm1[20,21,28,29,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm7[1,3,1,3]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,2,3,10,11],zero,zero,zero,zero,ymm2[u,u,u,u,u,u,20,21,28,29],zero,zero,zero,zero,ymm2[u,u,u,u]
; AVX512F-SLOW-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm8[1,3,3,1]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[0,1,8,9],zero,zero,ymm2[u,u,u,u,u,u,u,u,2,3,18,19],zero,zero,ymm2[u,u,u,u,u,u,u,u,28,29,20,21]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogd $206, 8(%r10){1to8}, %ymm2, %ymm3
; AVX512F-SLOW-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm3
; AVX512F-SLOW-NEXT:    vinserti32x4 $2, %xmm0, %zmm3, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride7_vf8:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %xmm4
; AVX512F-FAST-NEXT:    vmovdqa (%r9), %xmm5
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm6
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm7
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm4, %ymm8
; AVX512F-FAST-NEXT:    vpsrlq $48, %xmm3, %xmm3
; AVX512F-FAST-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX512F-FAST-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm2[3,4],xmm0[5,6,7]
; AVX512F-FAST-NEXT:    vpsrld $16, %xmm5, %xmm1
; AVX512F-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; AVX512F-FAST-NEXT:    vpbroadcastd 12(%r10), %xmm2
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3,4],xmm1[5,6],xmm2[7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4],xmm1[5,6,7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm7[1,3,1,3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u],zero,zero,zero,zero,ymm1[2,3,10,11,u,u,u,u,u,u],zero,zero,zero,zero,ymm1[20,21,28,29,u,u,u,u]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm6[1,3,1,3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,2,3,10,11],zero,zero,zero,zero,ymm2[u,u,u,u,u,u,20,21,28,29],zero,zero,zero,zero,ymm2[u,u,u,u]
; AVX512F-FAST-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm8[1,3,3,1]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[0,1,8,9],zero,zero,ymm2[u,u,u,u,u,u,u,u,2,3,18,19],zero,zero,ymm2[u,u,u,u,u,u,u,u,28,29,20,21]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogd $206, 8(%r10){1to8}, %ymm2, %ymm3
; AVX512F-FAST-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm3
; AVX512F-FAST-NEXT:    vinserti32x4 $2, %xmm0, %zmm3, %zmm1
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm7[0,2,0,2]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,ymm2[0,1,8,9,u,u,u,u,u,u],zero,zero,zero,zero,ymm2[18,19,26,27,u,u,u,u,u,u],zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm6[0,2,1,3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,zero,zero,ymm3[u,u,u,u,u,u,6,7,14,15],zero,zero,zero,zero,ymm3[u,u,u,u,u,u,16,17,24,25],zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm6[0,2,2,0]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[0,1,8,9],zero,zero,zero,zero,ymm3[u,u,u,u,u,u,2,3,18,19],zero,zero,zero,zero,ymm3[u,u,u,u,u,u,28,29,20,21]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [1,5,u,u,5,2,6,u]
; AVX512F-FAST-NEXT:    vpermd %ymm7, %ymm4, %ymm4
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[0,1,4,5,u,u,u,u,u,u],zero,zero,zero,zero,ymm4[2,3,18,19,u,u,u,u,u,u],zero,zero,zero,zero,ymm4[20,21,24,25]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512F-FAST-NEXT:    vporq %zmm2, %zmm3, %zmm2
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm8[0,2,0,2]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm3[u,u,u,u,u,u,u,u,0,1,8,9],zero,zero,ymm3[u,u,u,u,u,u,u,u,18,19,26,27],zero,zero,ymm3[u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,4,5,12,13],zero,zero,ymm3[u,u,u,u,u,u,u,u,22,23,30,31],zero,zero,ymm3[u,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm3
; AVX512F-FAST-NEXT:    vpbroadcastd (%r10), %ymm4
; AVX512F-FAST-NEXT:    vpbroadcastd 4(%r10), %ymm5
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm4, %zmm4
; AVX512F-FAST-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm4
; AVX512F-FAST-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm4
; AVX512F-FAST-NEXT:    vmovdqa %xmm0, 96(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512F-FAST-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride7_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm1
; AVX512BW-NEXT:    vinserti32x4 $2, (%r10), %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,8,16,24,32,40,48,1,9,17,25,33,41,49,2,10,18,26,34,42,50,3,11,19,27,35,43,51,4,12,20,28]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [36,44,52,5,13,21,29,37,45,53,6,14,22,30,38,46,54,7,15,23,31,39,47,55,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm3, 96(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512BW-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <8 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <8 x i16>, ptr %in.vecptr4, align 64
  %in.vec5 = load <8 x i16>, ptr %in.vecptr5, align 64
  %in.vec6 = load <8 x i16>, ptr %in.vecptr6, align 64
  %1 = shufflevector <8 x i16> %in.vec0, <8 x i16> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i16> %in.vec2, <8 x i16> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <8 x i16> %in.vec4, <8 x i16> %in.vec5, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <16 x i16> %1, <16 x i16> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %5 = shufflevector <8 x i16> %in.vec6, <8 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <16 x i16> %3, <16 x i16> %5, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %7 = shufflevector <24 x i16> %6, <24 x i16> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <32 x i16> %4, <32 x i16> %7, <56 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55>
  %interleaved.vec = shufflevector <56 x i16> %8, <56 x i16> poison, <56 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 40, i32 48, i32 1, i32 9, i32 17, i32 25, i32 33, i32 41, i32 49, i32 2, i32 10, i32 18, i32 26, i32 34, i32 42, i32 50, i32 3, i32 11, i32 19, i32 27, i32 35, i32 43, i32 51, i32 4, i32 12, i32 20, i32 28, i32 36, i32 44, i32 52, i32 5, i32 13, i32 21, i32 29, i32 37, i32 45, i32 53, i32 6, i32 14, i32 22, i32 30, i32 38, i32 46, i32 54, i32 7, i32 15, i32 23, i32 31, i32 39, i32 47, i32 55>
  store <56 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride7_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride7_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $216, %rsp
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa 16(%rdi), %xmm6
; SSE-NEXT:    movdqa 16(%rsi), %xmm4
; SSE-NEXT:    movdqa 16(%rdx), %xmm15
; SSE-NEXT:    movdqa 16(%rcx), %xmm1
; SSE-NEXT:    movdqa 16(%r8), %xmm8
; SSE-NEXT:    movdqa 16(%r9), %xmm7
; SSE-NEXT:    movdqa 16(%rax), %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm10
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm9
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[2,2,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[1],xmm7[1],xmm1[2],xmm7[2],xmm1[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,0],xmm2[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,0]
; SSE-NEXT:    movaps {{.*#+}} xmm6 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    andps %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[3,3,3,3]
; SSE-NEXT:    andnps %xmm1, %xmm6
; SSE-NEXT:    orps %xmm0, %xmm6
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,1,0,1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    movdqa %xmm15, %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm10[0],xmm3[1],xmm10[1],xmm3[2],xmm10[2],xmm3[3],xmm10[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por %xmm6, %xmm3
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rax), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[2,3,2,3]
; SSE-NEXT:    movdqa %xmm3, %xmm9
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa (%r8), %xmm2
; SSE-NEXT:    movdqa (%r9), %xmm10
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm1[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm11, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    movdqa (%rdx), %xmm13
; SSE-NEXT:    movdqa (%rcx), %xmm5
; SSE-NEXT:    movdqa %xmm13, %xmm14
; SSE-NEXT:    punpckhwd {{.*#+}} xmm14 = xmm14[4],xmm5[4],xmm14[5],xmm5[5],xmm14[6],xmm5[6],xmm14[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rdi), %xmm11
; SSE-NEXT:    movdqa (%rsi), %xmm1
; SSE-NEXT:    movdqa %xmm11, %xmm12
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4],xmm1[4],xmm12[5],xmm1[5],xmm12[6],xmm1[6],xmm12[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,2],xmm14[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,2],xmm6[0,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm10[0],xmm2[1],xmm10[1],xmm2[2],xmm10[2],xmm2[3],xmm10[3]
; SSE-NEXT:    movdqa %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm2 = zero,zero,xmm2[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm9[0,1,0,1]
; SSE-NEXT:    movdqa %xmm9, %xmm14
; SSE-NEXT:    pandn %xmm6, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    psrld $16, %xmm3
; SSE-NEXT:    movdqa %xmm13, %xmm6
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm11[0],xmm1[1],xmm11[1],xmm1[2],xmm11[2],xmm1[3],xmm11[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    por %xmm0, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,0,0,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm8, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm15[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm5[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm3[3,3]
; SSE-NEXT:    movdqa %xmm15, %xmm10
; SSE-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4],xmm5[4],xmm10[5],xmm5[5],xmm10[6],xmm5[6],xmm10[7],xmm5[7]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm5[0],xmm15[1],xmm5[1],xmm15[2],xmm5[2],xmm15[3],xmm5[3]
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm5[3,3,3,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm9[0,2]
; SSE-NEXT:    andps %xmm8, %xmm1
; SSE-NEXT:    orps %xmm6, %xmm1
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm11
; SSE-NEXT:    pandn %xmm14, %xmm7
; SSE-NEXT:    movdqa (%rsp), %xmm3 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm7, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm2[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm0, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm13[2,2,2,2]
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[3,3,3,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm4[0,2]
; SSE-NEXT:    andps %xmm8, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm8
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    punpcklwd {{.*#+}} xmm13 = xmm13[0],xmm2[0],xmm13[1],xmm2[1],xmm13[2],xmm2[2],xmm13[3],xmm2[3]
; SSE-NEXT:    psrlq $48, %xmm2
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm3[4],xmm1[5],xmm3[5],xmm1[6],xmm3[6],xmm1[7],xmm3[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [0,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,5,4]
; SSE-NEXT:    pandn %xmm1, %xmm8
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm10[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm0[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,6,6,7]
; SSE-NEXT:    movaps {{.*#+}} xmm2 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    andps %xmm2, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    andnps %xmm0, %xmm2
; SSE-NEXT:    orps %xmm1, %xmm2
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    andps %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[2,3,2,3]
; SSE-NEXT:    andnps %xmm0, %xmm1
; SSE-NEXT:    orps %xmm2, %xmm1
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,65535,0,0,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm15[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    movaps %xmm14, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,2],xmm7[1,1]
; SSE-NEXT:    movaps {{.*#+}} xmm6 = [65535,65535,0,0,0,65535,65535,65535]
; SSE-NEXT:    movaps %xmm6, %xmm3
; SSE-NEXT:    andnps %xmm5, %xmm3
; SSE-NEXT:    pand %xmm6, %xmm1
; SSE-NEXT:    orps %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm15[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm9[0],xmm15[1],xmm9[1],xmm15[2],xmm9[2],xmm15[3],xmm9[3]
; SSE-NEXT:    psrld $16, %xmm9
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm9[0],xmm1[1],xmm9[1]
; SSE-NEXT:    movdqa %xmm0, %xmm9
; SSE-NEXT:    pandn %xmm1, %xmm9
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm13[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm9, %xmm1
; SSE-NEXT:    movaps (%rsp), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, %xmm9
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,2],xmm11[1,1]
; SSE-NEXT:    pand %xmm6, %xmm1
; SSE-NEXT:    andnps %xmm9, %xmm6
; SSE-NEXT:    orps %xmm1, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm9 = zero,zero,zero,zero,zero,zero,xmm9[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm9, %xmm1
; SSE-NEXT:    pslldq {{.*#+}} xmm12 = zero,zero,xmm12[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm0, %xmm12
; SSE-NEXT:    por %xmm1, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,0,0,0,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm9
; SSE-NEXT:    pandn %xmm12, %xmm9
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; SSE-NEXT:    # xmm11 = xmm11[1],mem[0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,0],xmm12[2,1]
; SSE-NEXT:    andps %xmm1, %xmm11
; SSE-NEXT:    orps %xmm9, %xmm11
; SSE-NEXT:    pslldq {{.*#+}} xmm10 = zero,zero,zero,zero,zero,zero,xmm10[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm9 = zero,zero,xmm9[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm0, %xmm9
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    por %xmm9, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm4[0,1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm4[2,1]
; SSE-NEXT:    andps %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm13 = xmm13[0],xmm15[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    # xmm13 = xmm13[2,0],mem[2,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535,0,0,0,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    andps %xmm4, %xmm13
; SSE-NEXT:    por %xmm13, %xmm5
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[2,0],mem[2,1]
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm14[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm9[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1]
; SSE-NEXT:    andps %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm4, 112(%rax)
; SSE-NEXT:    movdqa %xmm5, (%rax)
; SSE-NEXT:    movdqa %xmm1, 176(%rax)
; SSE-NEXT:    movaps %xmm11, 64(%rax)
; SSE-NEXT:    movaps %xmm6, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps %xmm3, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movdqa %xmm8, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    addq $216, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride7_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $40, %rsp
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm14
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm15
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm15, %xmm0
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm14[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm14[4],xmm15[4],xmm14[5],xmm15[5],xmm14[6],xmm15[6],xmm14[7],xmm15[7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm0 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm9[2,2,3,3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm6 = xmm9[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm6 = [0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535]
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa 16(%r8), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa 16(%r9), %xmm8
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm8, %xmm10
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm10 = xmm3[2],xmm10[2],xmm3[3],xmm10[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm12 = xmm8[4],xmm3[4],xmm8[5],xmm3[5],xmm8[6],xmm3[6],xmm8[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm12[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm12, %ymm10
; AVX1-ONLY-NEXT:    vandnps %ymm10, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm10
; AVX1-ONLY-NEXT:    vmovdqa 16(%rax), %xmm13
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm13[3,3,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm12[0],xmm10[1,2,3,4,5,6],xmm12[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm13[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm10[1],xmm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm9[0,1,0,1]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm9 = zero,zero,xmm9[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm2, %ymm9
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm14[2,2,2,2]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm15[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,5],xmm2[6],xmm10[7]
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm6
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,zero,zero,zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-ONLY-NEXT:    vandnps %ymm9, %ymm0, %ymm9
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm10, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm9, %ymm0
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm3[4],xmm8[4],xmm3[5],xmm8[5],xmm3[6],xmm8[6],xmm3[7],xmm8[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm9 = xmm9[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm13[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1],xmm10[2,3],xmm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm10 = [65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0]
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm10, %ymm0
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm3[0],xmm8[0],xmm3[1],xmm8[1],xmm3[2],xmm8[2],xmm3[3],xmm8[3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm8[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2],xmm13[3],xmm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm10, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm6, %xmm0
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm9[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm7[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm5[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm3[0,1,2,3,4,5],xmm10[6],xmm3[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm5[0],xmm7[0],xmm5[1],xmm7[1],xmm5[2],xmm7[2],xmm5[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm3[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm12, %ymm10
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm1 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm10, %ymm1
; AVX1-ONLY-NEXT:    vmovdqa (%r8), %xmm10
; AVX1-ONLY-NEXT:    vmovdqa (%r9), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa (%rax), %xmm12
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm10[0],xmm5[0],xmm10[1],xmm5[1],xmm10[2],xmm5[2],xmm10[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm11 = xmm4[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2],xmm12[3],xmm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm7 = xmm4[0,2],xmm12[1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm11 = [65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm11, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm7, %ymm11, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm15, %xmm1
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm14[0],xmm1[0],xmm14[1],xmm1[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm14[0],xmm15[0],xmm14[1],xmm15[1],xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm15[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm11, %xmm7
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm0[0],xmm7[0],xmm0[1],xmm7[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm11[0],xmm0[0],xmm11[1],xmm0[1],xmm11[2],xmm0[2],xmm11[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm11[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm11, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm11 = [65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0]
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm11, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm11, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm7, %ymm1
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm7 = zero,zero,xmm8[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm13[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1,2,3,4],xmm11[5],xmm7[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm11 = xmm8[0,2],xmm13[1,3]
; AVX1-ONLY-NEXT:    vmovaps %xmm8, %xmm14
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm11 = [65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm11, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm7, %ymm11, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm1, %ymm7
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm11, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm8[0],xmm1[0],xmm8[1],xmm1[1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm3 = [65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,xmm4[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm12[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3,4],xmm3[5],xmm2[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm4[0,1,0,1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm12[0,0,0,0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm8[4],xmm11[4],xmm8[5],xmm11[5],xmm8[6],xmm11[6],xmm8[7],xmm11[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,xmm9[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm9[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm3 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm5[4],xmm10[4],xmm5[5],xmm10[5],xmm5[6],xmm10[6],xmm5[7],xmm10[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm12[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1],xmm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm10[4],xmm5[4],xmm10[5],xmm5[5],xmm10[6],xmm5[6],xmm10[7],xmm5[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm12[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3],xmm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm3 = [65535,65535,65535,0,0,0,0,65535,65535,65535,0,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm11, %xmm2
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm8[1],xmm2[1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm15[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1],xmm3[2],mem[2],xmm3[3],mem[3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm4 = xmm9[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm4 = [65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm4, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm14[0,1,0,1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm4 = xmm13[0,0,0,0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1,2],xmm4[3]
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm5, %xmm4
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm10[2],xmm4[2],xmm10[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm12[4],xmm4[4],xmm12[5],xmm4[5],xmm12[6],xmm4[6],xmm12[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[8,9,u,u,u,u,u,u,u,u,6,7,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm4 = [0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535]
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 96(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 208(%rax)
; AVX1-ONLY-NEXT:    addq $40, %rsp
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride7_vf16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $40, %rsp
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm7
; AVX2-SLOW-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm6
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm5
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm13
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm3
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa (%rax), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,u,u,u,4,u,u,4]
; AVX2-SLOW-NEXT:    vpermd %ymm7, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm6[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, %ymm7
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm8 = ymm8[0,0,3,3,4,5,6,7,8,8,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,3,u,u,u,4,u,u]
; AVX2-SLOW-NEXT:    vpermd %ymm5, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, %ymm6
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm13[0,0,0,0,4,5,6,7,8,8,8,8,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm9[0,1,2,3,7,7,7,7,8,9,10,11,15,15,15,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,u,3,u,u,u,4,u]
; AVX2-SLOW-NEXT:    vpermd %ymm3, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, %ymm4
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm2[0,1,0,3,4,5,4,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm9[0,1,2,3,4,4,7,7,8,9,10,11,12,12,15,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [3,u,u,3,u,u,u,4]
; AVX2-SLOW-NEXT:    vpermd %ymm1, %ymm9, %ymm9
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm10
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm11
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,2,1]
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm12
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm5
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm5[4],xmm12[4],xmm5[5],xmm12[5],xmm5[6],xmm12[6],xmm5[7],xmm12[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm8[2,1,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,5,4]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,0,1,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm8, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %xmm9
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm14
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm14[4],xmm9[4],xmm14[5],xmm9[5],xmm14[6],xmm9[6],xmm14[7],xmm9[7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,0,1,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 8(%rax), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm8, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm10[u,u,4,5,u,u,u,u,6,7,u,u,u,u,8,9]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm11[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3],xmm0[4],xmm1[5,6],xmm0[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm5[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm12[1,1,2,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm15[0,1],xmm1[2],xmm15[3,4],xmm1[5],xmm15[6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm0, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm14[0],xmm9[0],xmm14[1],xmm9[1],xmm14[2],xmm9[2],xmm14[3],xmm9[3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm0[0,1,2,3,4,5,7,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[0,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,1,3]
; AVX2-SLOW-NEXT:    vpbroadcastd 4(%rax), %ymm14
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm9, %ymm14, %ymm9
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm1, %ymm9, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, %ymm8
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm7[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm3[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm14[0,1,2],ymm1[3],ymm14[4,5],ymm1[6],ymm14[7,8,9,10],ymm1[11],ymm14[12,13],ymm1[14],ymm14[15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm14 = ymm13[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, %ymm9
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm6[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2,3],ymm14[4],ymm15[5,6,7,8],ymm14[9],ymm15[10,11],ymm14[12],ymm15[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm1, %ymm14, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm14 = ymm2[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[2,2,2,3,6,6,6,7]
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, %ymm2
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm4[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4],ymm15[5],ymm14[6,7,8,9],ymm15[10],ymm14[11,12],ymm15[13],ymm14[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = [0,0,u,u,255,255,255,255,255,255,255,255,0,0,0,0,u,u,255,255,255,255,255,255,255,255,0,0,0,0,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm1, %ymm14, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm4[2,3,3,3,6,7,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm15, %ymm1, %ymm14, %ymm14
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm12[0],xmm5[0],xmm12[1],xmm5[1],xmm12[2],xmm5[2],xmm12[3],xmm5[3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm10[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,1,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm1, %ymm10, %ymm1
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-SLOW-NEXT:    vpbroadcastd (%rax), %ymm10
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm0, %ymm10, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm1, %ymm0, %ymm10
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm6[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm13[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-SLOW-NEXT:    vmovdqa %ymm13, %ymm6
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7,8,9],ymm0[10],ymm1[11,12],ymm0[13],ymm1[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm0[2,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm3[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm8[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm11[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm11[1],ymm1[2,3],ymm11[4],ymm1[5,6,7,8],ymm11[9],ymm1[10,11],ymm11[12],ymm1[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm12, %ymm1, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, %ymm15
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm2[1,2,2,3,5,6,6,7]
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, %ymm2
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm11 = ymm7[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm11[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm11[2],ymm1[3,4],ymm11[5],ymm1[6,7,8,9],ymm11[10],ymm1[11,12],ymm11[13],ymm1[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, %ymm13
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm4[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,1,3,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm1, %ymm11, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm3, %ymm1, %ymm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm0[1,1,1,1,5,5,5,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm5 = ymm8[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm5[0,1],ymm1[2],ymm5[3,4],ymm1[5],ymm5[6,7,8,9],ymm1[10],ymm5[11,12],ymm1[13],ymm5[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm9[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm6[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7,8,9],ymm4[10],ymm3[11,12],ymm4[13],ymm3[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm15[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm2[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1,2],ymm3[3],ymm2[4,5],ymm3[6],ymm2[7,8,9,10],ymm3[11],ymm2[12,13],ymm3[14],ymm2[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,3,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm13[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovups (%rsp), %ymm2 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm2, 96(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, 128(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, 160(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm10, (%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm14, 192(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-SLOW-NEXT:    addq $40, %rsp
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride7_vf16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    pushq %rax
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm5
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm7
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm4
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm6
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm15
; AVX2-FAST-NEXT:    vmovdqa (%r9), %ymm3
; AVX2-FAST-NEXT:    vmovdqa (%rax), %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm4[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm8[0,1],ymm0[2],ymm8[3,4],ymm0[5],ymm8[6,7,8,9],ymm0[10],ymm8[11,12],ymm0[13],ymm8[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = ymm7[u,u,8,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,u,u,u,u,26,27,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm5[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2,3],ymm8[4],ymm9[5,6,7,8],ymm8[9],ymm9[10,11],ymm8[12],ymm9[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [4,5,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm9 = ymm3[u,u,u,u,u,u,u,u,u,u,8,9,u,u,u,u,u,u,u,u,22,23,u,u,u,u,24,25,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm10 = ymm15[1,2,2,3,5,6,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm9 = ymm10[0,1],ymm9[2],ymm10[3,4],ymm9[5],ymm10[6,7,8,9],ymm9[10],ymm10[11,12],ymm9[13],ymm10[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,3,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm9, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm5[1,1,1,1,5,5,5,5]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,u,u,20,21,24,25,u,u,22,23,22,23]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm8[0,1],ymm0[2],ymm8[3,4],ymm0[5],ymm8[6,7,8,9],ymm0[10],ymm8[11,12],ymm0[13],ymm8[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm8 = ymm6[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm4[0,1,1,3,4,5,5,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0,1],ymm8[2],ymm9[3,4],ymm8[5],ymm9[6,7,8,9],ymm8[10],ymm9[11,12],ymm8[13],ymm9[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,3,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,1,4,5,4,5,5,7]
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm15[0,0,2,1,4,4,6,5]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm10 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,u,u,18,19,20,21,u,u,20,21]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm9 = ymm10[0,1,2],ymm9[3],ymm10[4,5],ymm9[6],ymm10[7,8,9,10],ymm9[11],ymm10[12,13],ymm9[14],ymm10[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,3,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm9, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,u,u,u,4,u,u,4]
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = ymm7[0,1,0,1,14,15,14,15,8,9,10,11,12,13,14,15,16,17,16,17,30,31,30,31,24,25,26,27,28,29,30,31]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,3,u,u,u,4,u,u]
; AVX2-FAST-NEXT:    vpermd %ymm4, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm9 = ymm6[0,1,0,1,0,1,0,1,14,15,14,15,14,15,14,15,16,17,16,17,16,17,16,17,30,31,30,31,30,31,30,31]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,u,3,u,u,u,4,u]
; AVX2-FAST-NEXT:    vpermd %ymm15, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm9 = ymm3[0,1,2,3,4,5,6,7,0,1,0,1,14,15,14,15,16,17,18,19,20,21,22,23,16,17,16,17,30,31,30,31]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [3,u,u,3,u,u,u,4]
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm9, %ymm9
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm10
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm12
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm12[4],xmm10[4],xmm12[5],xmm10[5],xmm12[6],xmm10[6],xmm12[7],xmm10[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,2,3,4,5,6,7,8,9,10,11,10,11,8,9]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,3]
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm13
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm14
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm8[0,2,3,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,0,2,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm0, %ymm8, %ymm11
; AVX2-FAST-NEXT:    vmovdqa (%r9), %xmm8
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,0,1,1]
; AVX2-FAST-NEXT:    vpbroadcastd 8(%rax), %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm0, %ymm11, %ymm11
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm13[u,u,4,5,u,u,u,u,6,7,u,u,u,u,8,9]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm14[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3],xmm0[4],xmm1[5,6],xmm0[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm12[u,u,u,u,6,7,u,u,u,u,8,9,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm10[1,1,2,3]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm9[0,1],xmm1[2],xmm9[3,4],xmm1[5],xmm9[6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm0, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[0,1,2,3,8,9,10,11,14,15,12,13,14,15,12,13]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,1,3]
; AVX2-FAST-NEXT:    vpbroadcastd 4(%rax), %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm2, %ymm8, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm1, %ymm2, %ymm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,14,15,u,u,u,u,u,u,u,u,28,29,u,u,u,u,30,31,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm5[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5],ymm1[6],ymm2[7,8,9,10],ymm1[11],ymm2[12,13],ymm1[14],ymm2[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm6[u,u,12,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,u,u,u,u,30,31,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2,3],ymm2[4],ymm4[5,6,7,8],ymm2[9],ymm4[10,11],ymm2[12],ymm4[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm15[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,u,u,28,29,26,27,u,u,30,31,30,31]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0,1],ymm2[2],ymm3[3,4],ymm2[5],ymm3[6,7,8,9],ymm2[10],ymm3[11,12],ymm2[13],ymm3[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,0,u,u,255,255,255,255,255,255,255,255,0,0,0,0,u,u,255,255,255,255,255,255,255,255,0,0,0,0,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [6,7,3,3,7,7,6,7]
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm10[0],xmm12[0],xmm10[1],xmm12[1],xmm10[2],xmm12[2],xmm10[3],xmm12[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,1,2,3,0,1,2,3,6,7,4,5,6,7,4,5]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,2,3,6,7,4,5,6,7,4,5,12,13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-FAST-NEXT:    vpbroadcastd (%rax), %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm0, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, 96(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, 128(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, 160(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, 192(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm8, 32(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm11, 64(%rax)
; AVX2-FAST-NEXT:    popq %rax
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride7_vf16:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $40, %rsp
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rax), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,u,u,u,4,u,u,4]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm7, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm8 = ymm6[0,1,0,1,14,15,14,15,8,9,10,11,12,13,14,15,16,17,16,17,30,31,30,31,24,25,26,27,28,29,30,31]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,3,u,u,u,4,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm4, %ymm8, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm9 = ymm5[0,1,0,1,0,1,0,1,14,15,14,15,14,15,14,15,16,17,16,17,16,17,16,17,30,31,30,31,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,u,3,u,u,u,4,u]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm3, %ymm8, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm9 = ymm2[0,1,2,3,4,5,6,7,0,1,0,1,14,15,14,15,16,17,18,19,20,21,22,23,16,17,16,17,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = [3,u,u,3,u,u,u,4]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm1, %ymm9, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,2,3,4,5,6,7,8,9,10,11,10,11,8,9]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm5[4],xmm3[4],xmm5[5],xmm3[5],xmm5[6],xmm3[6],xmm5[7],xmm3[7]
; AVX2-FAST-PERLANE-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm8[0,2,3,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm0, %ymm8, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %xmm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm14[4],xmm9[4],xmm14[5],xmm9[5],xmm14[6],xmm9[6],xmm14[7],xmm9[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 8(%rax), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm8, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm3[u,u,4,5,u,u,u,u,6,7,u,u,u,u,8,9]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm1 = xmm5[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3],xmm0[4],xmm1[5,6],xmm0[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm1 = xmm11[u,u,u,u,6,7,u,u,u,u,8,9,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm15 = xmm10[1,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm1 = xmm15[0,1],xmm1[2],xmm15[3,4],xmm1[5],xmm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm0, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm14[0],xmm9[0],xmm14[1],xmm9[1],xmm14[2],xmm9[2],xmm14[3],xmm9[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm9 = xmm0[0,1,2,3,8,9,10,11,14,15,12,13,14,15,12,13]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 4(%rax), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm9, %ymm14, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm14, %ymm1, %ymm9, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,14,15,u,u,u,u,u,u,u,u,28,29,u,u,u,u,30,31,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm7[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm7, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm14[0,1,2],ymm1[3],ymm14[4,5],ymm1[6],ymm14[7,8,9,10],ymm1[11],ymm14[12,13],ymm1[14],ymm14[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm14 = ymm4[u,u,12,13,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,u,u,u,u,30,31,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm12, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm12[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2,3],ymm14[4],ymm15[5,6,7,8],ymm14[9],ymm15[10,11],ymm14[12],ymm15[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm1, %ymm14, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm6[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm15 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,u,u,28,29,26,27,u,u,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm14 = ymm15[0,1],ymm14[2],ymm15[3,4],ymm14[5],ymm15[6,7,8,9],ymm14[10],ymm15[11,12],ymm14[13],ymm15[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [0,0,u,u,255,255,255,255,255,255,255,255,0,0,0,0,u,u,255,255,255,255,255,255,255,255,0,0,0,0,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm1, %ymm14, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm13[2,3,3,3,6,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm1, %ymm14, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm10[0],xmm11[0],xmm10[1],xmm11[1],xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[0,1,2,3,0,1,2,3,6,7,4,5,6,7,4,5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm1, %ymm10, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,2,3,6,7,4,5,6,7,4,5,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rax), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm0, %ymm10, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm1, %ymm0, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm7[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7,8,9],ymm0[10],ymm1[11,12],ymm0[13],ymm1[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm9[u,u,8,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,u,u,u,u,26,27,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm11 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm11[0],ymm1[1],ymm11[2,3],ymm1[4],ymm11[5,6,7,8],ymm1[9],ymm11[10,11],ymm1[12],ymm11[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm2, %ymm1, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm12, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm12[u,u,u,u,u,u,u,u,u,u,8,9,u,u,u,u,u,u,u,u,22,23,u,u,u,u,24,25,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm11 = ymm6[1,2,2,3,5,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm11[0,1],ymm1[2],ymm11[3,4],ymm1[5],ymm11[6,7,8,9],ymm1[10],ymm11[11,12],ymm1[13],ymm11[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm11 = ymm13[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = [u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm1, %ymm11, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm3, %ymm1, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm5 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,u,u,20,21,24,25,u,u,22,23,22,23]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm5[0,1],ymm1[2],ymm5[3,4],ymm1[5],ymm5[6,7,8,9],ymm1[10],ymm5[11,12],ymm1[13],ymm5[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} ymm4 = ymm4[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm7[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7,8,9],ymm4[10],ymm3[11,12],ymm4[13],ymm3[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm15[0,0,2,1,4,4,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,u,u,18,19,20,21,u,u,20,21]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1,2],ymm3[3],ymm2[4,5],ymm3[6],ymm2[7,8,9,10],ymm3[11],ymm2[12,13],ymm3[14],ymm2[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm13[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovups (%rsp), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm2, 96(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, 128(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, 160(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm10, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm14, 192(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FAST-PERLANE-NEXT:    addq $40, %rsp
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride7_vf16:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %ymm8
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %ymm9
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %ymm6
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %ymm7
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa (%r9), %ymm3
; AVX512F-SLOW-NEXT:    vmovdqa (%rax), %ymm13
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm7[u,u,u,u,u,u],zero,zero,ymm7[14,15,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm7[16,17,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm6[u,u,u,u,u,u,14,15],zero,zero,ymm6[u,u,u,u,u,u,u,u,u,u,16,17],zero,zero,ymm6[u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vporq %ymm1, %ymm4, %ymm16
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %xmm14
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm0, %xmm21
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = zero,zero,zero,zero,ymm9[14,15,u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero,ymm9[16,17,u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm8[12,13,14,15],zero,zero,ymm8[u,u,u,u,u,u,u,u,u,u,16,17],zero,zero,ymm8[u,u,u,u,u,u,u,u,16,17,18,19]
; AVX512F-SLOW-NEXT:    vporq %ymm1, %ymm4, %ymm17
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %xmm4
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm3[u,u,u,u,u,u,u,u,u,u],zero,zero,ymm3[14,15,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm3[16,17,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm10 = ymm2[u,u,u,u,u,u,u,u,u,u,14,15],zero,zero,ymm2[u,u,u,u,u,u,u,u,u,u,16,17],zero,zero,ymm2[u,u,u,u]
; AVX512F-SLOW-NEXT:    vporq %ymm5, %ymm10, %ymm19
; AVX512F-SLOW-NEXT:    vpbroadcastd 8(%rax), %ymm5
; AVX512F-SLOW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm5, %ymm5
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm10 = ymm13[12,13,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm13[14,15,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm13[16,17,u,u]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm10, %zmm5, %zmm5
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm6[0,1,1,3,4,5,5,7]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm12 = ymm7[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm10[0,1],ymm12[2],ymm10[3,4],ymm12[5],ymm10[6,7,8,9],ymm12[10],ymm10[11,12],ymm12[13],ymm10[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm0, %ymm22
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm6[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm12 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm12[0,1],ymm10[2],ymm12[3,4],ymm10[5],ymm12[6,7,8,9],ymm10[10],ymm12[11,12],ymm10[13],ymm12[14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm8[1,1,1,1,5,5,5,5]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm11 = ymm9[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm11[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm11[0,1],ymm10[2],ymm11[3,4],ymm10[5],ymm11[6,7,8,9],ymm10[10],ymm11[11,12],ymm10[13],ymm11[14,15]
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm4[4],xmm1[4],xmm4[5],xmm1[5],xmm4[6],xmm1[6],xmm4[7],xmm1[7]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm12, %zmm11, %zmm20
; AVX512F-SLOW-NEXT:    vprold $16, %xmm4, %xmm11
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm12 = xmm1[1,1,2,3]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm11 = xmm12[0,1],xmm11[2],xmm12[3,4],xmm11[5],xmm12[6,7]
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm12[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [0,16,0,1,17,17,2,0,0,16,0,1,17,17,2,0]
; AVX512F-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm12, %zmm11, %zmm18
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm8[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm12 = ymm9[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm11[0],ymm12[1],ymm11[2,3],ymm12[4],ymm11[5,6,7,8],ymm12[9],ymm11[10,11],ymm12[12],ymm11[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqa (%r9), %xmm11
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,4,5,u,u,u,u,6,7,u,u,u,u,8,9]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm14 = xmm15[0],xmm14[1],xmm15[2,3],xmm14[4],xmm15[5,6],xmm14[7]
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %xmm15
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3]
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm15[4],xmm11[4],xmm15[5],xmm11[5],xmm15[6],xmm11[6],xmm15[7],xmm11[7]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm14, %zmm0, %zmm1
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm2[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm14 = ymm3[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm14 = ymm14[0,1,2],ymm0[3],ymm14[4,5],ymm0[6],ymm14[7,8,9,10],ymm0[11],ymm14[12,13],ymm0[14],ymm14[15]
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm11[0],xmm15[1],xmm11[1],xmm15[2],xmm11[2],xmm15[3],xmm11[3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm11 = xmm0[0,1,2,3,4,5,7,6]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm15 = [0,1,0,1,0,1,1,3,16,18,19,19,19,19,u,u]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm11, %zmm0, %zmm15
; AVX512F-SLOW-NEXT:    vprold $16, %ymm3, %ymm0
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm2[1,2,2,3,5,6,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm11[0,1],ymm0[2],ymm11[3,4],ymm0[5],ymm11[6,7,8,9],ymm0[10],ymm11[11,12],ymm0[13],ymm11[14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm9[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm8[0,1,2],ymm9[3],ymm8[4,5],ymm9[6],ymm8[7,8,9,10],ymm9[11],ymm8[12,13],ymm9[14],ymm8[15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm7 = ymm7[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3],ymm7[4],ymm6[5,6,7,8],ymm7[9],ymm6[10,11],ymm7[12],ymm6[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm21, %xmm7
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[0,2,3,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,0,2,1]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm9 = xmm10[2,1,2,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,4,5,5,4]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,0,1,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm22[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm12[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm14[2,2,3,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,3,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm3[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,2,2,3,6,6,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0,1],ymm2[2],ymm3[3,4],ymm2[5],ymm3[6,7,8,9],ymm2[10],ymm3[11,12],ymm2[13],ymm3[14,15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,2,3]
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,4,0,0,6,5,0,0,5,4,0,0,6,5,0]
; AVX512F-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermd %zmm13, %zmm3, %zmm3
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = ymm13[2,3,3,3,6,7,7,7]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm16, %zmm7, %zmm7
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm17, %zmm9, %zmm9
; AVX512F-SLOW-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm7, %zmm9
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm19, %zmm4, %zmm4
; AVX512F-SLOW-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm4, %zmm5
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm5
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm4
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} zmm7 = zmm20[2,2,2,3,6,6,6,7]
; AVX512F-SLOW-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm4, %zmm7
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm12, %zmm0
; AVX512F-SLOW-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm3
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm7, %zmm3
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} zmm0 = zmm1[0,0,1,1,4,4,5,5]
; AVX512F-SLOW-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm18, %zmm0
; AVX512F-SLOW-NEXT:    vpbroadcastd (%rax), %ymm1
; AVX512F-SLOW-NEXT:    vpbroadcastd 4(%rax), %ymm4
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512F-SLOW-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm15, %zmm1
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm1
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm6
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm13[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm0
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm6, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa %ymm0, 192(%rcx)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm1, (%rcx)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm3, 128(%rcx)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride7_vf16:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %ymm5
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %ymm7
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %ymm4
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %ymm6
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %ymm1
; AVX512F-FAST-NEXT:    vmovdqa (%r9), %ymm2
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm7[14,15,u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero,ymm7[16,17,u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm5[12,13,14,15],zero,zero,ymm5[u,u,u,u,u,u,u,u,u,u,16,17],zero,zero,ymm5[u,u,u,u,u,u,u,u,16,17,18,19]
; AVX512F-FAST-NEXT:    vporq %ymm0, %ymm3, %ymm16
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %xmm11
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %xmm12
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm6[u,u,u,u,u,u],zero,zero,ymm6[14,15,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm6[16,17,u,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm4[u,u,u,u,u,u,14,15],zero,zero,ymm4[u,u,u,u,u,u,u,u,u,u,16,17],zero,zero,ymm4[u,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vporq %ymm0, %ymm3, %ymm17
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %xmm14
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm2[u,u,u,u,u,u,u,u,u,u],zero,zero,ymm2[14,15,u,u,u,u,u,u,u,u,u,u],zero,zero,ymm2[16,17,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm1[u,u,u,u,u,u,u,u,u,u,14,15],zero,zero,ymm1[u,u,u,u,u,u,u,u,u,u,16,17],zero,zero,ymm1[u,u,u,u]
; AVX512F-FAST-NEXT:    vporq %ymm0, %ymm3, %ymm18
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,u,u,u,u,26,27,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm5[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2,3],ymm0[4],ymm3[5,6,7,8],ymm0[9],ymm3[10,11],ymm0[12],ymm3[13,14,15]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm3 = ymm6[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm4[0,1,1,3,4,5,5,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm9[0,1],ymm3[2],ymm9[3,4],ymm3[5],ymm9[6,7,8,9],ymm3[10],ymm9[11,12],ymm3[13],ymm9[14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [2,u,3,2,u,10,10,11]
; AVX512F-FAST-NEXT:    vpermi2q %zmm0, %zmm3, %zmm9
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm4[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0,1],ymm0[2],ymm3[3,4],ymm0[5],ymm3[6,7,8,9],ymm0[10],ymm3[11,12],ymm0[13],ymm3[14,15]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm5[1,1,1,1,5,5,5,5]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm10 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,u,u,20,21,24,25,u,u,22,23,22,23]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm10[0,1],ymm3[2],ymm10[3,4],ymm3[5],ymm10[6,7,8,9],ymm3[10],ymm10[11,12],ymm3[13],ymm10[14,15]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm19
; AVX512F-FAST-NEXT:    vprold $16, %ymm2, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm1[1,2,2,3,5,6,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0,1],ymm0[2],ymm3[3,4],ymm0[5],ymm3[6,7,8,9],ymm0[10],ymm3[11,12],ymm0[13],ymm3[14,15]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm1[0,0,2,1,4,4,6,5]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm13 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,u,u,18,19,20,21,u,u,20,21]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm13[0,1,2],ymm3[3],ymm13[4,5],ymm3[6],ymm13[7,8,9,10],ymm3[11],ymm13[12,13],ymm3[14],ymm13[15]
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %xmm8
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm13 = [2,2,3,3,10,9,11,10]
; AVX512F-FAST-NEXT:    vpermi2q %zmm0, %zmm3, %zmm13
; AVX512F-FAST-NEXT:    vprold $16, %xmm12, %xmm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm11[1,1,2,3]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1],xmm0[2],xmm3[3,4],xmm0[5],xmm3[6,7]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm8[0],xmm14[0],xmm8[1],xmm14[1],xmm8[2],xmm14[2],xmm8[3],xmm14[3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,1,2,3,0,1,2,3,6,7,4,5,6,7,4,5]
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [0,8,1,9,0,8,1,9]
; AVX512F-FAST-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermi2q %zmm0, %zmm3, %zmm15
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm8[4],xmm14[4],xmm8[5],xmm14[5],xmm8[6],xmm14[6],xmm8[7],xmm14[7]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,4,5,u,u,u,u,6,7,u,u,u,u,8,9]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0],xmm14[1],xmm8[2,3],xmm14[4],xmm8[5,6],xmm14[7]
; AVX512F-FAST-NEXT:    vmovdqa (%r9), %xmm14
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm12 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-FAST-NEXT:    vpshufb %xmm12, %xmm11, %xmm11
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm8, %zmm11, %zmm11
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %xmm8
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm8[4],xmm14[4],xmm8[5],xmm14[5],xmm8[6],xmm14[6],xmm8[7],xmm14[7]
; AVX512F-FAST-NEXT:    vpshufb %xmm12, %xmm10, %xmm12
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    vpbroadcastd 8(%rax), %ymm10
; AVX512F-FAST-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm10, %ymm10
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm8[0],xmm14[0],xmm8[1],xmm14[1],xmm8[2],xmm14[2],xmm8[3],xmm14[3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm8[0,1,2,3,8,9,10,11,14,15,12,13,14,15,12,13]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[0,1,2,3,6,7,4,5,6,7,4,5,12,13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [0,0,0,1,8,9,9,11]
; AVX512F-FAST-NEXT:    vpermi2q %zmm14, %zmm8, %zmm20
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm14 = ymm8[12,13,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm8[14,15,u,u,u,u,u,u,u,u],zero,zero,zero,zero,ymm8[16,17,u,u]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm14, %zmm10, %zmm10
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,14,15,u,u,u,u,u,u,u,u,28,29,u,u,u,u,30,31,u,u]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1,2],ymm7[3],ymm5[4,5],ymm7[6],ymm5[7,8,9,10],ymm7[11],ymm5[12,13],ymm7[14],ymm5[15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,28,29,u,u,u,u,30,31,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm6[1],ymm4[2,3],ymm6[4],ymm4[5,6,7,8],ymm6[9],ymm4[10,11],ymm6[12],ymm4[13,14,15]
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,13,4,0,0,14,5,0,0,13,4,0,0,14,5,0]
; AVX512F-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermd %zmm8, %zmm6, %zmm6
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [6,u,u,u,7,u,u,7]
; AVX512F-FAST-NEXT:    vpermd %ymm8, %ymm7, %ymm7
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[4,5,2,3,4,5,6,7,8,9,10,11,10,11,8,9]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,3]
; AVX512F-FAST-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,3,3,4,5,6,7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,2,1]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm12[0,0,1,1]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,1,3,3]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,2,2,3]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,u,u,28,29,26,27,u,u,30,31,30,31]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7,8,9],ymm1[10],ymm2[11,12],ymm1[13],ymm2[14,15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm16, %zmm3, %zmm2
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm17, %zmm0, %zmm0
; AVX512F-FAST-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm0
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm18, %zmm8, %zmm2
; AVX512F-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm10
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm10
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} zmm0 = zmm19[2,2,2,3,6,6,6,7]
; AVX512F-FAST-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm0
; AVX512F-FAST-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm13, %zmm6
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm6
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} zmm0 = zmm11[0,0,1,1,4,4,5,5]
; AVX512F-FAST-NEXT:    vpternlogd $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm15, %zmm0
; AVX512F-FAST-NEXT:    vpbroadcastd (%rax), %ymm2
; AVX512F-FAST-NEXT:    vpbroadcastd 4(%rax), %ymm3
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512F-FAST-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm20, %zmm2
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm2
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm5, %ymm4
; AVX512F-FAST-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm7, %ymm1
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa %ymm1, 192(%rcx)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm2, (%rcx)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm6, 128(%rcx)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm10, 64(%rcx)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride7_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512BW-NEXT:    vmovdqa (%r10), %ymm3
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,14,30,46,62,u,u,u,15,31,47,63,u,u,u]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm4
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm5 = [29,45,u,u,u,u,14,30,46,u,u,u,u,15,31,47]
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm5
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [u,u,u,u,0,16,32,u,u,u,u,1,17,33,u,u,u,u,2,18,34,u,u,u,u,3,19,35,u,u,u,u]
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm6
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,16,32,48,u,u,u,1,17,33,49,u,u,u,2,18,34,50,u,u,u,3,19,35,51,u,u,u,4,20,36,52]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm7
; AVX512BW-NEXT:    movl $236730480, %ecx # imm = 0xE1C3870
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm6, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [4,20,36,u,u,u,u,5,21,37,u,u,u,u,6,22,38,u,u,u,u,7,23,39,u,u,u,u,8,24,40,u]
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm6
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [u,u,u,5,21,37,53,u,u,u,6,22,38,54,u,u,u,7,23,39,55,u,u,u,8,24,40,56,u,u,u,9]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm8
; AVX512BW-NEXT:    movl $1893843847, %ecx # imm = 0x70E1C387
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm6, %zmm8 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [u,u,u,9,25,41,u,u,u,u,10,26,42,u,u,u,u,11,27,43,u,u,u,u,12,28,44,u,u,u,u,13]
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm6
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [57,9,25,u,u,u,42,58,10,26,u,u,u,43,59,11,27,u,u,u,44,60,12,28,u,u,u,45,61,13,29,u]
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm1, %zmm2
; AVX512BW-NEXT:    movl $-2029118408, %ecx # imm = 0x870E1C38
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm6, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512BW-NEXT:    movw $-7741, %cx # imm = 0xE1C3
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu16 %ymm5, %ymm4 {%k1}
; AVX512BW-NEXT:    vmovdqa %ymm4, 192(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <16 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <16 x i16>, ptr %in.vecptr4, align 64
  %in.vec5 = load <16 x i16>, ptr %in.vecptr5, align 64
  %in.vec6 = load <16 x i16>, ptr %in.vecptr6, align 64
  %1 = shufflevector <16 x i16> %in.vec0, <16 x i16> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i16> %in.vec2, <16 x i16> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <16 x i16> %in.vec4, <16 x i16> %in.vec5, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = shufflevector <32 x i16> %1, <32 x i16> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %5 = shufflevector <16 x i16> %in.vec6, <16 x i16> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <32 x i16> %3, <32 x i16> %5, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %7 = shufflevector <48 x i16> %6, <48 x i16> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <64 x i16> %4, <64 x i16> %7, <112 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111>
  %interleaved.vec = shufflevector <112 x i16> %8, <112 x i16> poison, <112 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 80, i32 96, i32 1, i32 17, i32 33, i32 49, i32 65, i32 81, i32 97, i32 2, i32 18, i32 34, i32 50, i32 66, i32 82, i32 98, i32 3, i32 19, i32 35, i32 51, i32 67, i32 83, i32 99, i32 4, i32 20, i32 36, i32 52, i32 68, i32 84, i32 100, i32 5, i32 21, i32 37, i32 53, i32 69, i32 85, i32 101, i32 6, i32 22, i32 38, i32 54, i32 70, i32 86, i32 102, i32 7, i32 23, i32 39, i32 55, i32 71, i32 87, i32 103, i32 8, i32 24, i32 40, i32 56, i32 72, i32 88, i32 104, i32 9, i32 25, i32 41, i32 57, i32 73, i32 89, i32 105, i32 10, i32 26, i32 42, i32 58, i32 74, i32 90, i32 106, i32 11, i32 27, i32 43, i32 59, i32 75, i32 91, i32 107, i32 12, i32 28, i32 44, i32 60, i32 76, i32 92, i32 108, i32 13, i32 29, i32 45, i32 61, i32 77, i32 93, i32 109, i32 14, i32 30, i32 46, i32 62, i32 78, i32 94, i32 110, i32 15, i32 31, i32 47, i32 63, i32 79, i32 95, i32 111>
  store <112 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride7_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride7_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $680, %rsp # imm = 0x2A8
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa 48(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rsi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdx), %xmm1
; SSE-NEXT:    movdqa 48(%rcx), %xmm5
; SSE-NEXT:    movdqa 48(%r8), %xmm9
; SSE-NEXT:    movdqa 48(%r9), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rax), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,2,2,2]
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm5[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm5, %xmm11
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[3,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm9[1,1,1,1]
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,0],xmm3[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm1[0,2]
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    andps %xmm1, %xmm2
; SSE-NEXT:    andnps %xmm7, %xmm1
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    orps %xmm2, %xmm1
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    psrldq {{.*#+}} xmm2 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm9[2,2,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm4[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[3,3,3,3]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    andps %xmm1, %xmm2
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rax), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,1,0,1]
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    movdqa (%r8), %xmm0
; SSE-NEXT:    movdqa (%r9), %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm12
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm1, %xmm13
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    movdqa (%rcx), %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm14
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm15, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa (%rdi), %xmm11
; SSE-NEXT:    movdqa (%rsi), %xmm9
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm11[0],xmm3[1],xmm11[1],xmm3[2],xmm11[2],xmm3[3],xmm11[3]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pandn %xmm7, %xmm2
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,0,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm14[2,2,2,2]
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm1[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm9[4],xmm11[5],xmm9[5],xmm11[6],xmm9[6],xmm11[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm11, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0,2]
; SSE-NEXT:    andps %xmm0, %xmm3
; SSE-NEXT:    orps %xmm2, %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[2,3,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm12[4],xmm2[5],xmm12[5],xmm2[6],xmm12[6],xmm2[7],xmm12[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm14, %xmm4
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm1[4],xmm4[5],xmm1[5],xmm4[6],xmm1[6],xmm4[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,2],xmm4[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,2],xmm2[0,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rax), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,1,0,1]
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    movdqa %xmm8, %xmm5
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa 16(%r8), %xmm10
; SSE-NEXT:    movdqa 16(%r9), %xmm8
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm8, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm12
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm2 = zero,zero,xmm2[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa 16(%rcx), %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    movdqa 16(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm9
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm15, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    movdqa 16(%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rsi), %xmm13
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    movdqa %xmm13, %xmm14
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm0, %xmm13
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm15, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pandn %xmm7, %xmm2
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,0,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm9[2,2,2,2]
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm5[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm13 = xmm13[4],xmm14[4],xmm13[5],xmm14[5],xmm13[6],xmm14[6],xmm13[7],xmm14[7]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0,2]
; SSE-NEXT:    andps %xmm0, %xmm3
; SSE-NEXT:    orps %xmm2, %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[2,3,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4],xmm10[4],xmm8[5],xmm10[5],xmm8[6],xmm10[6],xmm8[7],xmm10[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm8[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm5[4],xmm4[5],xmm5[5],xmm4[6],xmm5[6],xmm4[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,2],xmm4[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,2],xmm2[0,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rax), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,1,0,1]
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa 32(%r8), %xmm10
; SSE-NEXT:    movdqa 32(%r9), %xmm9
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3]
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm14
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm2 = zero,zero,xmm2[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa 32(%rcx), %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    movdqa 32(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm15, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    movdqa 32(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm15, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pandn %xmm7, %xmm3
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    psrldq {{.*#+}} xmm2 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm12[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm8[2,2,2,2]
; SSE-NEXT:    pandn %xmm4, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm6[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm12[3,3,3,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[0,2]
; SSE-NEXT:    movaps {{.*#+}} xmm5 = [65535,0,0,0,65535,65535,65535,65535]
; SSE-NEXT:    andps %xmm5, %xmm4
; SSE-NEXT:    andnps %xmm2, %xmm5
; SSE-NEXT:    orps %xmm4, %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[2,3,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm9[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm9
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm12[4],xmm0[5],xmm12[5],xmm0[6],xmm12[6],xmm0[7],xmm12[7]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm0[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,2],xmm2[0,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm2 = zero,zero,xmm2[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[0,1,0,1]
; SSE-NEXT:    pandn %xmm3, %xmm10
; SSE-NEXT:    por %xmm2, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4],xmm3[4],xmm6[5],xmm3[5],xmm6[6],xmm3[6],xmm6[7],xmm3[7]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[0],mem[0],xmm3[1],mem[1],xmm3[2],mem[2],xmm3[3],mem[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm15
; SSE-NEXT:    por %xmm3, %xmm15
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    pand %xmm2, %xmm15
; SSE-NEXT:    pandn %xmm10, %xmm2
; SSE-NEXT:    por %xmm15, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,2,2,2]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,0],xmm6[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535,65535,0,0,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm6, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm3 = zero,zero,xmm3[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    psrldq {{.*#+}} xmm8 = xmm8[6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm8, %xmm3
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[2,2,3,3]
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm15[0],xmm8[1],xmm15[1],xmm8[2],xmm15[2],xmm8[3],xmm15[3]
; SSE-NEXT:    psrlq $48, %xmm15
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm15[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[3,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,5,4]
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [0,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm14[0],xmm9[1],xmm14[1],xmm9[2],xmm14[2],xmm9[3],xmm14[3]
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm14
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm14[1]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    movdqa (%rsp), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[3,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,5,4]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm12[0],xmm1[1],xmm12[1],xmm1[2],xmm12[2],xmm1[3],xmm12[3]
; SSE-NEXT:    movdqa %xmm1, %xmm14
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm12
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm12[1]
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[3,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,5,4]
; SSE-NEXT:    pandn %xmm2, %xmm15
; SSE-NEXT:    por %xmm0, %xmm15
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm8[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,2],xmm5[1,1]
; SSE-NEXT:    movaps %xmm5, %xmm3
; SSE-NEXT:    movaps {{.*#+}} xmm12 = [65535,65535,0,0,0,65535,65535,65535]
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    andnps %xmm2, %xmm1
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    orps %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm9[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,2],xmm10[1,1]
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    andnps %xmm2, %xmm1
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    orps %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm14[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm7[1,1]
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    movaps %xmm12, %xmm10
; SSE-NEXT:    andnps %xmm1, %xmm10
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    orps %xmm0, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw $164, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm14[1,1]
; SSE-NEXT:    andnps %xmm1, %xmm12
; SSE-NEXT:    orps %xmm0, %xmm12
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps $42, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[2,2],mem[2,0]
; SSE-NEXT:    pshufhw $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,2,3,5,6,6,7]
; SSE-NEXT:    movaps {{.*#+}} xmm2 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    andps %xmm2, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    andnps %xmm0, %xmm2
; SSE-NEXT:    orps %xmm1, %xmm2
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    andps %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm14[2,3,2,3]
; SSE-NEXT:    andnps %xmm0, %xmm1
; SSE-NEXT:    orps %xmm2, %xmm1
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,zero,zero,zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    pslldq {{.*#+}} xmm11 = zero,zero,xmm11[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,0,0,0,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    movaps %xmm3, %xmm11
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; SSE-NEXT:    # xmm11 = xmm11[1],mem[0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,0],xmm0[2,1]
; SSE-NEXT:    andps %xmm2, %xmm11
; SSE-NEXT:    orps %xmm1, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pslldq {{.*#+}} xmm13 = zero,zero,xmm13[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm13
; SSE-NEXT:    por %xmm1, %xmm13
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm13, %xmm1
; SSE-NEXT:    movapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movapd %xmm7, %xmm13
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    # xmm13 = xmm13[1],mem[0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,0],xmm0[2,1]
; SSE-NEXT:    andps %xmm2, %xmm13
; SSE-NEXT:    orps %xmm1, %xmm13
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm1
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1],mem[0]
; SSE-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm6[2,1]
; SSE-NEXT:    andps %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = xmm8[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = xmm8[2,0],mem[2,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,65535,65535,0,0,0,65535]
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    andps %xmm6, %xmm8
; SSE-NEXT:    por %xmm8, %xmm1
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[2,0],mem[2,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1]
; SSE-NEXT:    movdqa %xmm6, %xmm8
; SSE-NEXT:    pandn %xmm4, %xmm8
; SSE-NEXT:    andps %xmm6, %xmm3
; SSE-NEXT:    por %xmm3, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[2,0],mem[2,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm9[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1]
; SSE-NEXT:    movdqa %xmm6, %xmm9
; SSE-NEXT:    pandn %xmm4, %xmm9
; SSE-NEXT:    andps %xmm6, %xmm0
; SSE-NEXT:    por %xmm0, %xmm9
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[2,0],mem[2,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm14[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm7[0],xmm4[1],xmm7[1]
; SSE-NEXT:    andps %xmm6, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm6
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm6, 336(%rax)
; SSE-NEXT:    movdqa %xmm9, 224(%rax)
; SSE-NEXT:    movdqa %xmm8, 112(%rax)
; SSE-NEXT:    movdqa %xmm1, (%rax)
; SSE-NEXT:    movdqa %xmm2, 288(%rax)
; SSE-NEXT:    movaps %xmm13, 176(%rax)
; SSE-NEXT:    movaps %xmm11, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps %xmm12, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps %xmm10, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movdqa %xmm15, 320(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    addq $680, %rsp # imm = 0x2A8
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride7_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $584, %rsp # imm = 0x248
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm12
; AVX1-ONLY-NEXT:    vmovdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 48(%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,1,0,1]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm11 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm11, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm4[2,2,2,2]
; AVX1-ONLY-NEXT:    vmovdqa 48(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm3[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5],xmm1[6],xmm5[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm11, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm5, %ymm6
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm6, %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 48(%r8), %xmm2
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm2[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0],xmm5[1,2,3,4,5,6],xmm7[7]
; AVX1-ONLY-NEXT:    vmovdqa 48(%r9), %xmm13
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm8 = xmm13[6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0],xmm8[1],xmm7[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa 48(%rax), %xmm5
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm5[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1],xmm8[2],xmm7[3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm2[1,1,1,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0],xmm7[1],xmm6[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm13, %xmm7
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1],xmm7[2,3],xmm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm3, %xmm6
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm6 = xmm4[1],xmm6[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm11, %ymm1
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm6, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm11, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm2[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm6[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5],xmm7[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[3,3,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm6[0],xmm1[1,2,3,4,5,6],xmm6[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5],xmm2[6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm13[0,1,2,3,5,6,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4,5,6],xmm1[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm10[4],xmm12[4],xmm10[5],xmm12[5],xmm10[6],xmm12[6],xmm10[7],xmm12[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[0,1,0,1]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm7[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm8
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm8[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5],xmm6[6],xmm1[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX1-ONLY-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm11, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm11, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 16(%r8), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 16(%r9), %xmm11
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm7[4],xmm11[4],xmm7[5],xmm11[5],xmm7[6],xmm11[6],xmm7[7],xmm11[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; AVX1-ONLY-NEXT:    vmovdqa 16(%rax), %xmm8
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm8[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm6[2,3],xmm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm11[0],xmm7[1],xmm11[1],xmm7[2],xmm11[2],xmm7[3],xmm11[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm6 = xmm6[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2],xmm8[3],xmm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm6, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm6 = [65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0]
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm6, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 32(%rsi), %xmm11
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm11, %xmm0
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm12[0],xmm0[0],xmm12[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 32(%rcx), %xmm7
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm7[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm10[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm1[0,1,2,3,4,5],xmm6[6],xmm1[7]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm10[0],xmm7[0],xmm10[1],xmm7[1],xmm10[2],xmm7[2],xmm10[3],xmm7[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm8[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm7 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm7, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vmovdqa 32(%r8), %xmm14
; AVX1-ONLY-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 32(%rax), %xmm6
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm14[0],xmm0[0],xmm14[1],xmm0[1],xmm14[2],xmm0[2],xmm14[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm15 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm15 = xmm15[0,1,2],xmm6[3],xmm15[4,5,6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm14 = xmm0[0,2],xmm6[1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm14, %ymm14
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm15 = [65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm15, %ymm7
; AVX1-ONLY-NEXT:    vandnps %ymm14, %ymm15, %ymm14
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm14, %ymm7
; AVX1-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm3, %xmm7
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm4[0],xmm7[0],xmm4[1],xmm7[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm7, %ymm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm9, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm7[0],xmm4[0],xmm7[1],xmm4[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm7, %ymm4
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm7 = [65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0]
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm7, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm2[0],xmm13[0],xmm2[1],xmm13[1],xmm2[2],xmm13[2],xmm2[3],xmm13[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,xmm7[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3,4],xmm4[5],xmm2[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm4 = xmm7[0,2],xmm5[1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm4 = [65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm4, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm3, %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm1, %xmm2
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm10[0],xmm2[0],xmm10[1],xmm2[1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm8[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm5 = [65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm5, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm6[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3,4],xmm3[5],xmm2[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm6[0,0,0,0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm4 = [65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm9
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm7
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm7, %xmm0
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm9[0],xmm0[0],xmm9[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm9[0],xmm7[0],xmm9[1],xmm7[1],xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm3[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm14
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm11 = xmm14[0],xmm0[0],xmm14[1],xmm0[1],xmm14[2],xmm0[2],xmm14[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm11[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[0,1,2,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm0[0],xmm14[0],xmm0[1],xmm14[1],xmm0[2],xmm14[2],xmm0[3],xmm14[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm12[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm5, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm11, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm5, %ymm15
; AVX1-ONLY-NEXT:    vmovdqa (%r8), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa (%r9), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa (%rax), %xmm2
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm5[0],xmm1[1],xmm5[1],xmm1[2],xmm5[2],xmm1[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,xmm5[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm2[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm12[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm2[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm12[0,1,2,3,4,5],xmm11[6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm11, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm15, %ymm11
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm4, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm11, %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm0, %xmm1
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm14[0],xmm1[0],xmm14[1],xmm1[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm14[4],xmm0[4],xmm14[5],xmm0[5],xmm14[6],xmm0[6],xmm14[7],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm7[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm9[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5],xmm11[6],xmm1[7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm12 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm12, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm1 = xmm5[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[3],xmm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm5[0,2],xmm2[1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm13, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm1[0],xmm13[0],xmm1[1],xmm13[1],xmm1[2],xmm13[2],xmm1[3],xmm13[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa %xmm13, %xmm2
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm3[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm5, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm3 = [65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,xmm5[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm13[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm3[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm5[0,2],xmm13[1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm3 = [65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm3, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm4[1],xmm0[1]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[2,2,3,3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm2, %xmm1
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm13[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm5[1],xmm3[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm13[4],xmm1[4],xmm13[5],xmm1[5],xmm13[6],xmm1[6],xmm13[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[8,9,8,9,8,9,8,9,12,13,6,7,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm5 = [0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0]
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm5, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm10, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm10[4],xmm2[4],xmm10[5],xmm2[5],xmm10[6],xmm2[6],xmm10[7],xmm2[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm3 = zero,zero,xmm8[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm8[2,2,3,3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, %xmm10
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm12, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm1[4],xmm11[4],xmm1[5],xmm11[5],xmm1[6],xmm11[6],xmm1[7],xmm11[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm6[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm5[1],xmm3[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm11[4],xmm1[4],xmm11[5],xmm1[5],xmm11[6],xmm1[6],xmm11[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm8[2,3],xmm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm3
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm15 = [65535,65535,65535,0,0,0,0,65535,65535,65535,0,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm15, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm15, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm2, %xmm0
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm4[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpermilps $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = mem[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm10[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm3
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm8 = [65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm8, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm8, %ymm3
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpblendw $247, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm14 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm14 = mem[0,1,2],xmm2[3],mem[4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd $68, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm5 = mem[0,1,0,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm2[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5],xmm10[6,7]
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm1, %xmm10
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm10 = xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm6[4],xmm10[4],xmm6[5],xmm10[5],xmm6[6],xmm10[6],xmm6[7],xmm10[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[8,9,8,9,8,9,8,9,12,13,6,7,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm5
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm6 = [0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535]
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vandnps %ymm5, %ymm6, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm5, %ymm3, %ymm5
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm9[4],xmm7[4],xmm9[5],xmm7[5],xmm9[6],xmm7[6],xmm9[7],xmm7[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm10 = zero,zero,zero,zero,zero,zero,xmm3[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm10, %ymm3
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm10 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm1[2,2,3,3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm12, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm12, %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm10, %ymm3
; AVX1-ONLY-NEXT:    vmovdqa (%rsp), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm10 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm10[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0],xmm11[1],xmm10[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm11[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1],xmm12[2,3],xmm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm15, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm15, %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm10, %ymm3
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm7, %xmm7
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm7 = xmm9[1],xmm7[1]
; AVX1-ONLY-NEXT:    vpermilps $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm9 = mem[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm9 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm9 = xmm9[0],mem[0],xmm9[1],mem[1],xmm9[2],mem[2],xmm9[3],mem[3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm4 = xmm4[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm9 = xmm9[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[0,1,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vandnps %ymm7, %ymm8, %ymm7
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm8, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm7 = mem[0,1,0,1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm8 = xmm13[0,0,0,0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1,2],xmm8[3]
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm2, %xmm8
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm8 = xmm1[2],xmm8[2],xmm1[3],xmm8[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; AVX1-ONLY-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[8,9,8,9,8,9,8,9,12,13,6,7,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm4, %ymm2
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm6, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 96(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 320(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 352(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 256(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 160(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm1, 416(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm1, 432(%rax)
; AVX1-ONLY-NEXT:    vmovdqa %xmm14, 384(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 400(%rax)
; AVX1-ONLY-NEXT:    addq $584, %rsp # imm = 0x248
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride7_vf32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $616, %rsp # imm = 0x268
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm13
; AVX2-SLOW-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm8
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm15
; AVX2-SLOW-NEXT:    vmovdqu %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm10
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm12
; AVX2-SLOW-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm5
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm14
; AVX2-SLOW-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm9
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %ymm6
; AVX2-SLOW-NEXT:    vmovdqa 32(%r9), %ymm7
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,u,u,u,4,u,u,4]
; AVX2-SLOW-NEXT:    vpermd %ymm8, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm10[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm2[0,0,3,3,4,5,6,7,8,8,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,3,u,u,u,4,u,u]
; AVX2-SLOW-NEXT:    vpermd %ymm5, %ymm2, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, %ymm11
; AVX2-SLOW-NEXT:    vpermd %ymm13, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm15[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm5 = ymm5[0,0,3,3,4,5,6,7,8,8,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm0, %ymm5, %ymm0
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm3 = ymm9[0,0,0,0,4,5,6,7,8,8,8,8,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm3[0,1,2,3,7,7,7,7,8,9,10,11,15,15,15,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm4, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm1
; AVX2-SLOW-NEXT:    vpermd %ymm12, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm3 = ymm14[0,0,0,0,4,5,6,7,8,8,8,8,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm3[0,1,2,3,7,7,7,7,8,9,10,11,15,15,15,15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,3,u,u,u,4,u]
; AVX2-SLOW-NEXT:    vpermd %ymm6, %ymm3, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, %ymm12
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm7[0,1,0,3,4,5,4,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm2[0,1,2,3,4,4,7,7,8,9,10,11,12,12,15,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm5, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm5
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermd %ymm5, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %ymm5
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[0,1,0,3,4,5,4,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm5[0,1,2,3,4,4,7,7,8,9,10,11,12,12,15,15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm3, %ymm5, %ymm3
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa 32(%rax), %ymm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [3,u,u,3,u,u,u,4]
; AVX2-SLOW-NEXT:    vpermd %ymm6, %ymm4, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, %ymm13
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm2, %ymm5, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa (%rax), %ymm5
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermd %ymm5, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm0, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-SLOW-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm11[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm10[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm12[1,2,2,3,5,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm7[2,1,2,3,6,5,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm1[0,0,3,3,4,5,6,7,8,8,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm13[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm10[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm8[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm9[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm11[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpbroadcastd 60(%r8), %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm7[0,1,2,3,5,5,7,6,8,9,10,11,13,13,15,14]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm13[2,3,3,3,6,7,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm11
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm10
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm10[0],xmm11[0],xmm10[1],xmm11[1],xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,1,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm0, %ymm1, %ymm12
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm13
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm13[0],xmm0[1],xmm13[1],xmm0[2],xmm13[2],xmm0[3],xmm13[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm8
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm7
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,1,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm9, %ymm0, %ymm1, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm4[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 32(%rax), %ymm9
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm0, %ymm9, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %xmm5
; AVX2-SLOW-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm5[0],xmm1[1],xmm5[1],xmm1[2],xmm5[2],xmm1[3],xmm5[3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm15 = xmm1[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[0,1,1,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,0,0,1]
; AVX2-SLOW-NEXT:    vpbroadcastd (%rax), %ymm14
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm15, %ymm14, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm12, %ymm0, %ymm15
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm2, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} xmm0 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX2-SLOW-NEXT:    vpshufb %xmm0, %xmm11, %xmm2
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm10[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm2[1],xmm3[2,3],xmm2[4],xmm3[5,6],xmm2[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm6[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm12 = xmm5[1,1,2,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm12[0,1],xmm3[2],xmm12[3,4],xmm3[5],xmm12[6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm2, %ymm3, %ymm9
; AVX2-SLOW-NEXT:    vpshufb %xmm0, %xmm8, %xmm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm7[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0],xmm0[1],xmm3[2,3],xmm0[4],xmm3[5,6],xmm0[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm13[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm2[1,1,2,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm14[0,1],xmm3[2],xmm14[3,4],xmm3[5],xmm14[6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm0, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm4[0,1,2,3,4,5,7,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-SLOW-NEXT:    vpbroadcastd 36(%rax), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,7,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,1,3]
; AVX2-SLOW-NEXT:    vpbroadcastd 4(%rax), %ymm4
; AVX2-SLOW-NEXT:    vpblendvb %ymm12, %ymm1, %ymm4, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm9, %ymm3, %ymm14
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm10[4],xmm11[4],xmm10[5],xmm11[5],xmm10[6],xmm11[6],xmm10[7],xmm11[7]
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,4]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm13[4],xmm2[4],xmm13[5],xmm2[5],xmm13[6],xmm2[6],xmm13[7],xmm2[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[2,1,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm3, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm2 = xmm2[4],mem[4],xmm2[5],mem[5],xmm2[6],mem[6],xmm2[7],mem[7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 40(%rax), %ymm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm3 = xmm3[4],mem[4],xmm3[5],mem[5],xmm3[6],mem[6],xmm3[7],mem[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 8(%rax), %ymm5
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm3, %ymm5, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm2, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm3, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm10[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm7[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0,1,2],ymm2[3],ymm3[4,5],ymm2[6],ymm3[7,8,9,10],ymm2[11],ymm3[12,13],ymm2[14],ymm3[15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm9[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm8[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6,7,8],ymm3[9],ymm4[10,11],ymm3[12],ymm4[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,1,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm12[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,2,2,3,6,6,6,7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm11[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7,8,9],ymm4[10],ymm3[11,12],ymm4[13],ymm3[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm13[2,3,3,3,6,7,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7,8,9],ymm4[10],ymm3[11,12],ymm4[13],ymm3[14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm10[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm7[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2,3],ymm4[4],ymm5[5,6,7,8],ymm4[9],ymm5[10,11],ymm4[12],ymm5[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm12[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm11[1,2,2,3,5,6,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7,8,9],ymm4[10],ymm5[11,12],ymm4[13],ymm5[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,1,3,2]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm13[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,1,3,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = [u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm4 = mem[1,1,1,1,5,5,5,5]
; AVX2-SLOW-NEXT:    vpshuflw $249, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm5 = mem[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7,8,9],ymm4[10],ymm5[11,12],ymm4[13],ymm5[14,15]
; AVX2-SLOW-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm5 = mem[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpshuflw $233, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm6 = mem[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm6[2],ymm5[3,4],ymm6[5],ymm5[6,7,8,9],ymm6[10],ymm5[11,12],ymm6[13],ymm5[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm7[1,1,1,1,5,5,5,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm7 = ymm10[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm7[0,1],ymm5[2],ymm7[3,4],ymm5[5],ymm7[6,7,8,9],ymm5[10],ymm7[11,12],ymm5[13],ymm7[14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm8[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm8 = ymm9[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0,1],ymm8[2],ymm7[3,4],ymm8[5],ymm7[6,7,8,9],ymm8[10],ymm7[11,12],ymm8[13],ymm7[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,1,3,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm5, %ymm7, %ymm5
; AVX2-SLOW-NEXT:    vpshufd $96, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm6 = mem[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpshuflw $233, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm7 = mem[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0,1,2],ymm6[3],ymm7[4,5],ymm6[6],ymm7[7,8,9,10],ymm6[11],ymm7[12,13],ymm6[14],ymm7[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,3,3]
; AVX2-SLOW-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm7 = mem[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm6, %ymm7, %ymm6
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm11[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm12[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm9[0,1,2],ymm7[3],ymm9[4,5],ymm7[6],ymm9[7,8,9,10],ymm7[11],ymm9[12,13],ymm7[14],ymm9[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,3,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm13[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm7, %ymm9, %ymm7
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm4, %ymm6, %ymm4
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm5, %ymm7, %ymm5
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm6, 96(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm6, 320(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, 128(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, 352(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, 160(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, 192(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm1, 32(%rax)
; AVX2-SLOW-NEXT:    vmovups (%rsp), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm1, (%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm15, 224(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 288(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm14, 256(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-SLOW-NEXT:    addq $616, %rsp # imm = 0x268
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride7_vf32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $312, %rsp # imm = 0x138
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm7
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm6
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm2
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm4
; AVX2-FAST-NEXT:    vmovdqa (%r9), %ymm10
; AVX2-FAST-NEXT:    vmovdqa (%rax), %ymm3
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm1[u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm11
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm7[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vmovdqa %ymm7, %ymm9
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm2[14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX2-FAST-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm6[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vmovdqa %ymm6, %ymm8
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [6,7,3,3,7,7,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa %ymm3, %ymm6
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm4[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,u,u,28,29,26,27,u,u,30,31,30,31]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0,1],ymm2[2],ymm3[3,4],ymm2[5],ymm3[6,7,8,9],ymm2[10],ymm3[11,12],ymm2[13],ymm3[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [4,5,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpermd %ymm6, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm10[u,u,u,u,u,u,u,u,u,u,8,9,u,u,u,u,u,u,u,u,22,23,u,u,u,u,24,25,u,u,u,u]
; AVX2-FAST-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm4[1,2,2,3,5,6,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7,8,9],ymm1[10],ymm2[11,12],ymm1[13],ymm2[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm7, %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-FAST-NEXT:    vmovdqa %ymm8, %ymm5
; AVX2-FAST-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4],ymm2[5],ymm1[6,7,8,9],ymm2[10],ymm1[11,12],ymm2[13],ymm1[14,15]
; AVX2-FAST-NEXT:    vmovdqa %ymm11, %ymm6
; AVX2-FAST-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm11[10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX2-FAST-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm9[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3],ymm2[4],ymm3[5,6,7,8],ymm2[9],ymm3[10,11],ymm2[12],ymm3[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm15
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %ymm12
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX2-FAST-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm12, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm15[1,1,1,1,5,5,5,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4],ymm2[5],ymm1[6,7,8,9],ymm2[10],ymm1[11,12],ymm2[13],ymm1[14,15]
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %ymm14
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %ymm11
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm2 = ymm11[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm7 = ymm14[0,1,1,3,4,5,5,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm7[0,1],ymm2[2],ymm7[3,4],ymm2[5],ymm7[6,7,8,9],ymm2[10],ymm7[11,12],ymm2[13],ymm7[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,1,3,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm7
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm6, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm9[1,1,1,1,5,5,5,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4],ymm2[5],ymm1[6,7,8,9],ymm2[10],ymm1[11,12],ymm2[13],ymm1[14,15]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm2 = ymm4[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm8 = ymm5[0,1,1,3,4,5,5,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm8[0,1],ymm2[2],ymm8[3,4],ymm2[5],ymm8[6,7,8,9],ymm2[10],ymm8[11,12],ymm2[13],ymm8[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,1,3,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm8
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %ymm9
; AVX2-FAST-NEXT:    vmovdqa 32(%r9), %ymm6
; AVX2-FAST-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm6, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm13 = ymm9[0,0,2,1,4,4,6,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1,2],ymm13[3],ymm1[4,5],ymm13[6],ymm1[7,8,9,10],ymm13[11],ymm1[12,13],ymm13[14],ymm1[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm1[2,2,3,3]
; AVX2-FAST-NEXT:    vmovdqa 32(%rax), %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,4,5,4,5,5,7]
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm13, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm10, %ymm3
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm13 = ymm4[0,0,2,1,4,4,6,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1,2],ymm13[3],ymm3[4,5],ymm13[6],ymm3[7,8,9,10],ymm13[11],ymm3[12,13],ymm13[14],ymm3[15]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-NEXT:    vpermd %ymm10, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,3,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm3, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm7, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm8, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,u,u,u,4,u,u,4]
; AVX2-FAST-NEXT:    vpermd %ymm15, %ymm0, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,0,1,14,15,14,15,8,9,10,11,12,13,14,15,16,17,16,17,30,31,30,31,24,25,26,27,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm2, %ymm12, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm1, %ymm3, %ymm7
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [u,3,u,u,u,4,u,u]
; AVX2-FAST-NEXT:    vpermd %ymm14, %ymm1, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,0,1,0,1,0,1,14,15,14,15,14,15,14,15,16,17,16,17,16,17,16,17,30,31,30,31,30,31,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm11, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm2, %ymm8, %ymm2
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm8, %ymm3
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm1, %ymm3, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm7, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [u,u,3,u,u,u,4,u]
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm1, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [0,1,2,3,4,5,6,7,0,1,0,1,14,15,14,15,16,17,18,19,20,21,22,23,16,17,16,17,30,31,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm6, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm3, %ymm8, %ymm3
; AVX2-FAST-NEXT:    vpermd %ymm4, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm4, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm1, %ymm7, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [3,u,u,3,u,u,u,4]
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm7, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = [0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm3, %ymm8, %ymm3
; AVX2-FAST-NEXT:    vpermd %ymm10, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm13, %ymm1, %ymm7, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm14[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm12[10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm15[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [5,6,2,3,6,7,5,6]
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25,22,23,22,23,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [4,5,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm15[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm11[14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm14[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpbroadcastd 60(%r8), %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm6[0,1,2,3,5,5,7,6,8,9,10,11,13,13,15,14]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [6,7,3,3,7,7,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %xmm2
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %xmm3
; AVX2-FAST-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FAST-NEXT:    vpshufb %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm5, %xmm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-FAST-NEXT:    vmovdqa %xmm2, %xmm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,2,3,0,1,2,3,6,7,4,5,6,7,4,5]
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,1,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm0, %ymm1, %ymm12
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm13
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm9
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm9[0],xmm13[0],xmm9[1],xmm13[1],xmm9[2],xmm13[2],xmm9[3],xmm13[3]
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm0, %xmm1
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm15
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm8
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm8[0],xmm15[0],xmm8[1],xmm15[1],xmm8[2],xmm15[2],xmm8[3],xmm15[3]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,1,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm2, %ymm1, %ymm10
; AVX2-FAST-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,2,3,6,7,4,5,6,7,4,5,12,13,14,15]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm5, %xmm1
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,0,1]
; AVX2-FAST-NEXT:    vpbroadcastd 32(%rax), %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vmovdqa (%r9), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm14
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm14[0],xmm1[0],xmm14[1],xmm1[1],xmm14[2],xmm1[2],xmm14[3],xmm1[3]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm6, %xmm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,0,1]
; AVX2-FAST-NEXT:    vpbroadcastd (%rax), %ymm11
; AVX2-FAST-NEXT:    vpblendvb %ymm3, %ymm4, %ymm11, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm12, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm10, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq {{.*#+}} xmm0 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm7, %xmm3
; AVX2-FAST-NEXT:    vmovdqa %xmm7, %xmm10
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm7[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0],xmm3[1],xmm4[2,3],xmm3[4],xmm4[5,6],xmm3[7]
; AVX2-FAST-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [6,7,8,9,6,7,8,9,6,7,8,9,6,7,8,9]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm2, %xmm11
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm12 = xmm1[1,1,2,3]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm11 = xmm12[0,1],xmm11[2],xmm12[3,4],xmm11[5],xmm12[6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,0,2,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm3, %ymm11, %ymm3
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm11 = xmm9[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm11[0],xmm0[1],xmm11[2,3],xmm0[4],xmm11[5,6],xmm0[7]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm15, %xmm4
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm11 = xmm8[1,1,2,3]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm11[0,1],xmm4[2],xmm11[3,4],xmm4[5],xmm11[6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,2,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,2,3,8,9,10,11,14,15,12,13,14,15,12,13]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm5, %xmm5
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,1,3]
; AVX2-FAST-NEXT:    vpbroadcastd 36(%rax), %ymm11
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm5, %ymm11, %ymm5
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm6, %xmm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,1,3]
; AVX2-FAST-NEXT:    vpbroadcastd 4(%rax), %ymm6
; AVX2-FAST-NEXT:    vpblendvb %ymm12, %ymm4, %ymm6, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm3, %ymm5, %ymm6
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm0, %ymm4, %ymm5
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm7[4],xmm10[4],xmm7[5],xmm10[5],xmm7[6],xmm10[6],xmm7[7],xmm10[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = [4,5,2,3,4,5,6,7,8,9,10,11,10,11,8,9]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,3]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,2,3,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm0, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm15[4],xmm8[4],xmm15[5],xmm8[5],xmm15[6],xmm8[6],xmm15[7],xmm8[7]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm9[4],xmm13[4],xmm9[5],xmm13[5],xmm9[6],xmm13[6],xmm9[7],xmm13[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,3]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[0,2,3,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,2,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm11, %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm4 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm4 = xmm1[4],mem[4],xmm1[5],mem[5],xmm1[6],mem[6],xmm1[7],mem[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm4, %xmm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,1,1]
; AVX2-FAST-NEXT:    vpbroadcastd 40(%rax), %ymm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm4, %ymm7, %ymm4
; AVX2-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm1 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm1 = xmm14[4],mem[4],xmm14[5],mem[5],xmm14[6],mem[6],xmm14[7],mem[7]
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-FAST-NEXT:    vpbroadcastd 8(%rax), %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm1, %ymm3, %ymm1
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, 96(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, 320(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, 128(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, 352(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, 160(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, 192(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm5, 32(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm1, (%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm1, 224(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 288(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm6, 256(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FAST-NEXT:    addq $312, %rsp # imm = 0x138
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride7_vf32:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $616, %rsp # imm = 0x268
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,u,u,u,4,u,u,4]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm8, %ymm0, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,0,1,14,15,14,15,8,9,10,11,12,13,14,15,16,17,16,17,30,31,30,31,24,25,26,27,28,29,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm2, %ymm9, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,3,u,u,u,4,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm6, %ymm3, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,1,0,1,0,1,0,1,14,15,14,15,14,15,14,15,16,17,16,17,16,17,16,17,30,31,30,31,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm11, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm2, %ymm14, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm0, %ymm2, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm6, %ymm10, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm5, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r9), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm13, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm6, %ymm15, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,3,u,u,u,4,u]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm7, %ymm3, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm0, %ymm2, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,2,3,4,5,6,7,0,1,0,1,14,15,14,15,16,17,18,19,20,21,22,23,16,17,16,17,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm2, %ymm11, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm5, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm2, %ymm5, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm3, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rax), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = [3,u,u,3,u,u,u,4]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm6, %ymm3, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rax), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm5, %ymm3, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm1, %ymm4, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm0 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm12[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm9[10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm7[1,2,2,3,5,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25,22,23,22,23,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm13[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm0 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm8[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm10[14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm12[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 60(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm11[0,1,2,3,5,5,7,6,8,9,10,11,13,13,15,14]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm13[2,3,3,3,6,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm3, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %xmm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm11[0],xmm12[0],xmm11[1],xmm12[1],xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,2,3,0,1,2,3,6,7,4,5,6,7,4,5]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm13
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm13[0],xmm14[0],xmm13[1],xmm14[1],xmm13[2],xmm14[2],xmm13[3],xmm14[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm1, %ymm0, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,6,7,4,5,6,7,4,5,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm5, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 32(%rax), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm0, %ymm10, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm10[0],xmm1[0],xmm10[1],xmm1[1],xmm10[2],xmm1[2],xmm10[3],xmm1[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm1, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rax), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm3, %ymm15, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm9, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} xmm0 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm12, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm3 = xmm11[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm2[1],xmm3[2,3],xmm2[4],xmm3[5,6],xmm2[7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [6,7,8,9,6,7,8,9,6,7,8,9,6,7,8,9]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm6, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm6, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm15 = xmm6[1,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm4 = xmm15[0,1],xmm4[2],xmm15[3,4],xmm4[5],xmm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm2, %ymm4, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm14, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm13[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm4[0],xmm0[1],xmm4[2,3],xmm0[4],xmm4[5,6],xmm0[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm8, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm7[1,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1],xmm3[2],xmm4[3,4],xmm3[5],xmm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm0, %ymm3, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,8,9,10,11,14,15,12,13,14,15,12,13]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm5, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 36(%rax), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm4, %ymm5, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 4(%rax), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm1, %ymm3, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm2, %ymm4, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm9[4],xmm6[4],xmm9[5],xmm6[5],xmm9[6],xmm6[6],xmm9[7],xmm6[7]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm2 = [4,5,2,3,4,5,6,7,8,9,10,11,10,11,8,9]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm13[4],xmm14[4],xmm13[5],xmm14[5],xmm13[6],xmm14[6],xmm13[7],xmm14[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,2,3,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm2 = xmm2[4],mem[4],xmm2[5],mem[5],xmm2[6],mem[6],xmm2[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm2, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 40(%rax), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm3 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm3 = xmm10[4],mem[4],xmm10[5],mem[5],xmm10[6],mem[6],xmm10[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 8(%rax), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm3, %ymm5, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm3, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm2 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm8[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0,1,2],ymm2[3],ymm3[4,5],ymm2[6],ymm3[7,8,9,10],ymm2[11],ymm3[12,13],ymm2[14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm3 = ymm11[14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm4 = ymm9[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6,7,8],ymm3[9],ymm4[10,11],ymm3[12],ymm4[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm12[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm4 = ymm13[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,u,u,28,29,26,27,u,u,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0,1],ymm3[2],ymm4[3,4],ymm3[5],ymm4[6,7,8,9],ymm3[10],ymm4[11,12],ymm3[13],ymm4[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm4 = ymm14[2,3,3,3,6,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm3 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm4 = ymm9[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7,8,9],ymm4[10],ymm3[11,12],ymm4[13],ymm3[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm4 = ymm10[10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm5 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0],ymm4[1],ymm5[2,3],ymm4[4],ymm5[5,6,7,8],ymm4[9],ymm5[10,11],ymm4[12],ymm5[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm4 = ymm13[u,u,u,u,u,u,u,u,u,u,8,9,u,u,u,u,u,u,u,u,22,23,u,u,u,u,24,25,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm5 = ymm12[1,2,2,3,5,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7,8,9],ymm4[10],ymm5[11,12],ymm4[13],ymm5[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm5 = ymm14[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX2-FAST-PERLANE-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm6 = mem[1,1,1,1,5,5,5,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1],ymm6[2],ymm4[3,4],ymm6[5],ymm4[6,7,8,9],ymm6[10],ymm4[11,12],ymm6[13],ymm4[14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} ymm6 = ymm6[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-PERLANE-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm7 = mem[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0,1],ymm6[2],ymm7[3,4],ymm6[5],ymm7[6,7,8,9],ymm6[10],ymm7[11,12],ymm6[13],ymm7[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm4, %ymm6, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm5, %ymm10, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm6 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm6[2],ymm5[3,4],ymm6[5],ymm5[6,7,8,9],ymm6[10],ymm5[11,12],ymm6[13],ymm5[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} ymm6 = ymm11[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm8 = ymm9[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm8[0,1],ymm6[2],ymm8[3,4],ymm6[5],ymm8[6,7,8,9],ymm6[10],ymm8[11,12],ymm6[13],ymm8[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{.*#+}} ymm6 = [18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm6, %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufd $96, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm8 = mem[0,0,2,1,4,4,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0,1,2],ymm8[3],ymm7[4,5],ymm8[6],ymm7[7,8,9,10],ymm8[11],ymm7[12,13],ymm8[14],ymm7[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm8 = mem[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = [u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm6, %ymm13, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm8 = ymm12[0,0,2,1,4,4,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0,1,2],ymm8[3],ymm6[4,5],ymm8[6],ymm6[7,8,9,10],ymm8[11],ymm6[12,13],ymm8[14],ymm6[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm8 = ymm14[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm9, %ymm6, %ymm8, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm4, %ymm7, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm5, %ymm6, %ymm5
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm6, 96(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm6, 320(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, 128(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm4, 352(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm3, 160(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, 192(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm1, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm1, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups (%rsp), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm1, 224(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 288(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm15, 256(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FAST-PERLANE-NEXT:    addq $616, %rsp # imm = 0x268
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride7_vf32:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    subq $632, %rsp # imm = 0x278
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm9 = [128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128,128,128]
; AVX512F-SLOW-NEXT:    vpshufb %ymm9, %ymm1, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm16
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,u,12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb %ymm13, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm2, %ymm29
; AVX512F-SLOW-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX512F-SLOW-NEXT:    vpshufb %ymm12, %ymm1, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa %ymm1, %ymm15
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = [12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u,u,u,u,u,16,17,18,19]
; AVX512F-SLOW-NEXT:    vpshufb %ymm14, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm2, %ymm17
; AVX512F-SLOW-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%r9), %ymm10
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = [128,128,128,128,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128]
; AVX512F-SLOW-NEXT:    vpshufb %ymm1, %ymm10, %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %ymm11
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,u,u,u,u,u,u,12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb %ymm0, %ymm11, %ymm3
; AVX512F-SLOW-NEXT:    vpor %ymm2, %ymm3, %ymm2
; AVX512F-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 32(%r9), %xmm3
; AVX512F-SLOW-NEXT:    vmovdqa 32(%r8), %xmm6
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm11[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm10[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,2,2,3,6,6,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1],ymm2[2],ymm4[3,4],ymm2[5],ymm4[6,7,8,9],ymm2[10],ymm4[11,12],ymm2[13],ymm4[14,15]
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [4,5,4,5,4,5,6,7,16,17,16,17,16,17,17,19]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm2[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %xmm8
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm6[4],xmm3[4],xmm6[5],xmm3[5],xmm6[6],xmm3[6],xmm6[7],xmm3[7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,7,6]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [16,18,19,19,19,19,u,u,0,1,0,1,2,3,2,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm3
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm6
; AVX512F-SLOW-NEXT:    vpshufb %ymm12, %ymm6, %ymm2
; AVX512F-SLOW-NEXT:    vpshufb %ymm14, %ymm3, %ymm4
; AVX512F-SLOW-NEXT:    vpor %ymm2, %ymm4, %ymm2
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm12
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm7
; AVX512F-SLOW-NEXT:    vpshufb %ymm9, %ymm12, %ymm2
; AVX512F-SLOW-NEXT:    vpshufb %ymm13, %ymm7, %ymm4
; AVX512F-SLOW-NEXT:    vpor %ymm2, %ymm4, %ymm2
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 32(%r9), %ymm13
; AVX512F-SLOW-NEXT:    vmovdqa 32(%r8), %ymm14
; AVX512F-SLOW-NEXT:    vpshufb %ymm1, %ymm13, %ymm1
; AVX512F-SLOW-NEXT:    vpshufb %ymm0, %ymm14, %ymm0
; AVX512F-SLOW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %xmm0
; AVX512F-SLOW-NEXT:    vpbroadcastq {{.*#+}} xmm2 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX512F-SLOW-NEXT:    vpshufb %xmm2, %xmm8, %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm2, %xmm20
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0],xmm1[1],xmm2[2,3],xmm1[4],xmm2[5,6],xmm1[7]
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [u,16,u,u,17,17,u,u,0,u,u,1,2,u,u,3]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm2, %zmm1, %zmm4
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%r9), %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm4[0,1,2,3,4,5,7,6]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [0,1,0,1,0,1,1,3,16,18,19,19,19,19,u,u]
; AVX512F-SLOW-NEXT:    vpermi2d %zmm5, %zmm4, %zmm9
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vprold $16, %ymm10, %ymm4
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm11[1,2,2,3,5,6,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7,8,9],ymm4[10],ymm5[11,12],ymm4[13],ymm5[14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm11[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm10[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm9[0,1,2],ymm5[3],ymm9[4,5],ymm5[6],ymm9[7,8,9,10],ymm5[11],ymm9[12,13],ymm5[14],ymm9[15]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm27 = [2,2,3,3,10,9,11,10]
; AVX512F-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm27
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm0, %xmm31
; AVX512F-SLOW-NEXT:    vmovdqa (%rax), %ymm4
; AVX512F-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpbroadcastd 8(%rax), %ymm0
; AVX512F-SLOW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [12,13,128,128,128,128,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128]
; AVX512F-SLOW-NEXT:    vpshufb %ymm5, %ymm4, %ymm4
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm5, %ymm28
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm0
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm7[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm0, %ymm30
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm12[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm7[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6,7,8],ymm0[9],ymm1[10,11],ymm0[12],ymm1[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm0, %ymm23
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm6[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm3[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6,7,8],ymm0[9],ymm1[10,11],ymm0[12],ymm1[13,14,15]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm6[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm3[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm0, %ymm19
; AVX512F-SLOW-NEXT:    vprold $16, %ymm13, %ymm0
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm14[1,2,2,3,5,6,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7,8,9],ymm0[10],ymm1[11,12],ymm0[13],ymm1[14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm13[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,2,2,3,6,6,6,7]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm14[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm16, %ymm4
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm4[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm29[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6,7,8],ymm0[9],ymm1[10,11],ymm0[12],ymm1[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm5, %ymm18
; AVX512F-SLOW-NEXT:    vmovdqa %ymm15, %ymm8
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm15[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm17[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm9
; AVX512F-SLOW-NEXT:    vprold $16, %xmm9, %xmm1
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm0[1,1,2,3]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm15[0,1],xmm1[2],xmm15[3,4],xmm1[5],xmm15[6,7]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm0[0],xmm9[0],xmm0[1],xmm9[1],xmm0[2],xmm9[2],xmm0[3],xmm9[3]
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm9[4],xmm0[4],xmm9[5],xmm0[5],xmm9[6],xmm0[6],xmm9[7],xmm0[7]
; AVX512F-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm9
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm20, %xmm0
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm9, %xmm0
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm15
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm10 = xmm15[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm10[0],xmm0[1],xmm10[2,3],xmm0[4],xmm10[5,6],xmm0[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm0, %ymm26
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm15[0],xmm9[0],xmm15[1],xmm9[1],xmm15[2],xmm9[2],xmm15[3],xmm9[3]
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm15[4],xmm9[4],xmm15[5],xmm9[5],xmm15[6],xmm9[6],xmm15[7],xmm9[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm9, %xmm25
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[1,1,1,1,5,5,5,5]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm6 = ymm6[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm6[0,1],ymm3[2],ymm6[3,4],ymm3[5],ymm6[6,7,8,9],ymm3[10],ymm6[11,12],ymm3[13],ymm6[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm3, %ymm24
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm7[0,1,1,3,4,5,5,7]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm6 = ymm12[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm6[2],ymm3[3,4],ymm6[5],ymm3[6,7,8,9],ymm6[10],ymm3[11,12],ymm6[13],ymm3[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm3, %ymm22
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm14[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm6 = ymm13[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm6[0,1,2],ymm3[3],ymm6[4,5],ymm3[6],ymm6[7,8,9,10],ymm3[11],ymm6[12,13],ymm3[14],ymm6[15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm3, %ymm21
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [6,5,0,0,7,6,0,7,6,5,0,0,7,6,0,7]
; AVX512F-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rax), %ymm6
; AVX512F-SLOW-NEXT:    vpermd %zmm6, %zmm3, %zmm3
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm28, %ymm7
; AVX512F-SLOW-NEXT:    vpshufb %ymm7, %ymm6, %ymm10
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[0,1,1,3,4,5,5,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm6, %ymm6
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm6, %zmm10, %zmm6
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm7 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-SLOW-NEXT:    vpshufb %xmm7, %xmm2, %xmm10
; AVX512F-SLOW-NEXT:    vpshufb %xmm7, %xmm1, %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %xmm13
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %xmm14
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm13[0],xmm14[0],xmm13[1],xmm14[1],xmm13[2],xmm14[2],xmm13[3],xmm14[3]
; AVX512F-SLOW-NEXT:    vpshufb %xmm7, %xmm2, %xmm2
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm2, %ymm20
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm15 = xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; AVX512F-SLOW-NEXT:    vprold $16, %xmm14, %xmm14
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[1,1,2,3]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm13[0,1],xmm14[2],xmm13[3,4],xmm14[5],xmm13[6,7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm2, %ymm16
; AVX512F-SLOW-NEXT:    vmovdqa %ymm4, %ymm2
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm14 = ymm4[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm29, %ymm12
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm29[0,1,1,3,4,5,5,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm14 = ymm9[0,1],ymm14[2],ymm9[3,4],ymm14[5],ymm9[6,7,8,9],ymm14[10],ymm9[11,12],ymm14[13],ymm9[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm31, %xmm4
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm9 = xmm4[0,2,3,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,0,2,1]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm15 = xmm15[2,1,2,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm15 = xmm15[0,1,2,3,4,5,5,4]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,0,1,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm28 = ymm30[2,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm29 = ymm23[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm19[2,1,3,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm30 = ymm18[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm31 = ymm5[2,1,3,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm12[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4],ymm4[5],ymm2[6,7,8,9],ymm4[10],ymm2[11,12],ymm4[13],ymm2[14,15]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm8[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm17[1,1,1,1,5,5,5,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7,8,9],ymm5[10],ymm4[11,12],ymm5[13],ymm4[14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm17[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm12 = ymm8[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0],ymm12[1],ymm5[2,3],ymm12[4],ymm5[5,6,7,8],ymm12[9],ymm5[10,11],ymm12[12],ymm5[13,14,15]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm29, %zmm28, %zmm12
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm7, %zmm11, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm12, %zmm11, %zmm7
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm30, %zmm0
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm31, %zmm1
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm0, %zmm11, %zmm1
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm0 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm15, %zmm9 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm0, %zmm11, %zmm9
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm10[0,1,2,3],zmm0[4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermq $182, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm10 = mem[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpermq $234, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm12 = mem[2,2,2,3]
; AVX512F-SLOW-NEXT:    vpshufd $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm15 = mem[2,3,3,3,6,7,7,7]
; AVX512F-SLOW-NEXT:    vpermq $96, {{[-0-9]+}}(%r{{[sb]}}p), %ymm17 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm17 = mem[0,0,2,1]
; AVX512F-SLOW-NEXT:    vpshuflw $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; AVX512F-SLOW-NEXT:    # xmm8 = mem[2,1,2,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,5,4]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,0,1,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm18 = ymm26[0,0,1,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm25, %xmm13
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm13[0,2,3,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,0,2,1]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm19 = ymm24[2,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm28 = ymm22[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm29 = ymm21[2,2,3,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm30 = ymm20[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm31 = ymm16[0,0,2,1]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,2,2,3]
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm16, %zmm0
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm0
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm12, %zmm10, %zmm9
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm7, %zmm9
; AVX512F-SLOW-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm3
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm15[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpbroadcastd 32(%rax), %ymm9
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm7, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm7
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm7
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm8, %zmm17, %zmm1
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm13, %zmm18, %zmm8
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm1, %zmm11, %zmm8
; AVX512F-SLOW-NEXT:    vpbroadcastd 36(%rax), %ymm1
; AVX512F-SLOW-NEXT:    vpbroadcastd 40(%rax), %ymm9
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm1, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm1
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm19, %zmm8, %zmm8
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm28, %zmm9, %zmm9
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm9
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm8[0,1,2,3],zmm29[0,1,2,3]
; AVX512F-SLOW-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm6
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm6
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm31, %zmm30, %zmm8
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm8
; AVX512F-SLOW-NEXT:    vpbroadcastd (%rax), %ymm9
; AVX512F-SLOW-NEXT:    vpbroadcastd 4(%rax), %ymm10
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm10, %zmm9, %zmm9
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm9
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm9
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm2, %zmm14, %zmm2
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm4, %zmm4
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm4
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,5,4,0,0,6,5,0,0,5,4,0,0,6,5,0]
; AVX512F-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermd (%rax), %zmm2, %zmm2
; AVX512F-SLOW-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm27, %zmm2
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm4, %zmm2
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm2, 128(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm9, (%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm6, 320(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm1, 256(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm7, 192(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm3, 384(%rax)
; AVX512F-SLOW-NEXT:    addq $632, %rsp # imm = 0x278
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride7_vf32:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    subq $248, %rsp
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %ymm1
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128,128,128]
; AVX512F-FAST-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512F-FAST-NEXT:    vmovdqa %ymm1, %ymm10
; AVX512F-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %ymm4
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [u,u,u,u,12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm4, %ymm3
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm4, %ymm18
; AVX512F-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpor %ymm2, %ymm3, %ymm2
; AVX512F-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %ymm4
; AVX512F-FAST-NEXT:    vmovdqa 32(%rsi), %ymm11
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX512F-FAST-NEXT:    vpshufb %ymm3, %ymm4, %ymm2
; AVX512F-FAST-NEXT:    vmovdqa %ymm4, %ymm9
; AVX512F-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u,u,u,u,u,16,17,18,19]
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm6, %ymm4
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm6, %ymm16
; AVX512F-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpor %ymm2, %ymm4, %ymm2
; AVX512F-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa (%r9), %ymm13
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [128,128,128,128,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128]
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm13, %ymm6
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %ymm14
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,u,u,12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb %ymm4, %ymm14, %ymm7
; AVX512F-FAST-NEXT:    vporq %ymm6, %ymm7, %ymm25
; AVX512F-FAST-NEXT:    vpshufb %ymm3, %ymm11, %ymm6
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdi), %ymm8
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm8, %ymm5
; AVX512F-FAST-NEXT:    vpor %ymm6, %ymm5, %ymm3
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 32(%rcx), %ymm3
; AVX512F-FAST-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm3, %ymm29
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdx), %ymm12
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm12, %ymm1
; AVX512F-FAST-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 32(%r9), %ymm15
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm15, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa 32(%r8), %ymm6
; AVX512F-FAST-NEXT:    vpshufb %ymm4, %ymm6, %ymm1
; AVX512F-FAST-NEXT:    vporq %ymm0, %ymm1, %ymm21
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX512F-FAST-NEXT:    vpshufb %ymm0, %ymm11, %ymm1
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm8[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5],ymm1[6],ymm2[7,8,9,10],ymm1[11],ymm2[12,13],ymm1[14],ymm2[15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm11[10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm11, %ymm30
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm8[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2,3],ymm2[4],ymm4[5,6,7,8],ymm2[9],ymm4[10,11],ymm2[12],ymm4[13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm24 = [u,2,2,3,10,u,11,u]
; AVX512F-FAST-NEXT:    vpermi2q %zmm1, %zmm2, %zmm24
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm10[14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm18[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa 32(%rcx), %xmm10
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdx), %xmm5
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm5[0],xmm10[0],xmm5[1],xmm10[1],xmm5[2],xmm10[2],xmm5[3],xmm10[3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,1,2,3,0,1,2,3,6,7,4,5,6,7,4,5]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm23 = [u,2,2,3,8,u,9,u]
; AVX512F-FAST-NEXT:    vpermi2q %zmm2, %zmm1, %zmm23
; AVX512F-FAST-NEXT:    vpshufb %ymm0, %ymm9, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm16[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm11 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-FAST-NEXT:    vmovdqa 32(%rsi), %xmm2
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm11, %xmm4, %xmm4
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [2,1,3,3,8,8,9,9]
; AVX512F-FAST-NEXT:    vpermi2q %zmm4, %zmm0, %zmm20
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm13[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,26,27,28,29,26,27,28,29,30,31,30,31]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm14[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm0[0,1],ymm4[2],ymm0[3,4],ymm4[5],ymm0[6,7,8,9],ymm4[10],ymm0[11,12],ymm4[13],ymm0[14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [2,2,2,3,8,8,8,9]
; AVX512F-FAST-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX512F-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 32(%r8), %xmm3
; AVX512F-FAST-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512F-FAST-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [0,1,2,3,6,7,4,5,6,7,4,5,12,13,14,15]
; AVX512F-FAST-NEXT:    vpshufb %xmm0, %xmm3, %xmm7
; AVX512F-FAST-NEXT:    vpermi2q %zmm7, %zmm4, %zmm22
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512F-FAST-NEXT:    vprold $16, %xmm2, %xmm2
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3,4],xmm2[5],xmm1[6,7]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm7 = [4,5,2,3,4,5,6,7,8,9,10,11,10,11,8,9]
; AVX512F-FAST-NEXT:    vpshufb %xmm7, %xmm4, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm26 = [u,0,u,1,8,8,9,u]
; AVX512F-FAST-NEXT:    vpermi2q %zmm2, %zmm1, %zmm26
; AVX512F-FAST-NEXT:    vmovdqa (%r9), %xmm2
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %xmm9
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm9[0],xmm2[0],xmm9[1],xmm2[1],xmm9[2],xmm2[2],xmm9[3],xmm2[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,1,2,3,8,9,10,11,14,15,12,13,14,15,12,13]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm27 = [0,0,0,1,8,9,9,11]
; AVX512F-FAST-NEXT:    vpermi2q %zmm4, %zmm0, %zmm27
; AVX512F-FAST-NEXT:    vprold $16, %ymm13, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm14[1,2,2,3,5,6,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm4[0,1],ymm0[2],ymm4[3,4],ymm0[5],ymm4[6,7,8,9],ymm0[10],ymm4[11,12],ymm0[13],ymm4[14,15]
; AVX512F-FAST-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21]
; AVX512F-FAST-NEXT:    vpshufb %ymm3, %ymm13, %ymm4
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm13 = ymm14[0,0,2,1,4,4,6,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1,2],ymm13[3],ymm4[4,5],ymm13[6],ymm4[7,8,9,10],ymm13[11],ymm4[12,13],ymm13[14],ymm4[15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm28 = [2,2,3,3,10,9,11,10]
; AVX512F-FAST-NEXT:    vpermi2q %zmm0, %zmm4, %zmm28
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %xmm14
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm14[4],xmm0[4],xmm14[5],xmm0[5],xmm14[6],xmm0[6],xmm14[7],xmm0[7]
; AVX512F-FAST-NEXT:    vpshufb %xmm7, %xmm4, %xmm1
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm1, %ymm19
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm9[4],xmm2[4],xmm9[5],xmm2[5],xmm9[6],xmm2[6],xmm9[7],xmm2[7]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm25, %zmm0, %zmm4
; AVX512F-FAST-NEXT:    vpshufb %xmm11, %xmm2, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm25 = [0,0,1,1,12,13,u,15]
; AVX512F-FAST-NEXT:    vpermi2q %zmm4, %zmm2, %zmm25
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    vpbroadcastd 8(%rax), %ymm2
; AVX512F-FAST-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-FAST-NEXT:    vmovdqa (%rax), %ymm9
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [12,13,128,128,128,128,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128]
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm9, %ymm4
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm31
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm30, %ymm2
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm8[1,1,1,1,5,5,5,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4],ymm4[5],ymm2[6,7,8,9],ymm4[10],ymm2[11,12],ymm4[13],ymm2[14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm2, %ymm18
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm29, %ymm7
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm2 = ymm7[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm12[0,1,1,3,4,5,5,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0,1],ymm2[2],ymm4[3,4],ymm2[5],ymm4[6,7,8,9],ymm2[10],ymm4[11,12],ymm2[13],ymm4[14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm2, %ymm17
; AVX512F-FAST-NEXT:    vpshufb %ymm3, %ymm15, %ymm2
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm6[0,0,2,1,4,4,6,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1,2],ymm3[3],ymm2[4,5],ymm3[6],ymm2[7,8,9,10],ymm3[11],ymm2[12,13],ymm3[14],ymm2[15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm29 = [0,1,u,3,10,10,11,11]
; AVX512F-FAST-NEXT:    vpermi2q %zmm2, %zmm21, %zmm29
; AVX512F-FAST-NEXT:    vmovdqa 32(%rax), %ymm8
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm8, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm21 = [0,1,4,5,4,5,5,7,12,13,10,10,14,14,14,14]
; AVX512F-FAST-NEXT:    vpermd %ymm8, %ymm21, %ymm2
; AVX512F-FAST-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm16
; AVX512F-FAST-NEXT:    vmovdqa %ymm7, %ymm4
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm7[14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm12[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm2[1],ymm3[2,3],ymm2[4],ymm3[5,6,7,8],ymm2[9],ymm3[10,11],ymm2[12],ymm3[13,14,15]
; AVX512F-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27,22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27]
; AVX512F-FAST-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512F-FAST-NEXT:    vpshufb %ymm7, %ymm4, %ymm13
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7,8,9],ymm12[10],ymm13[11,12],ymm12[13],ymm13[14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm30 = [2,2,2,3,8,10,10,11]
; AVX512F-FAST-NEXT:    vpermt2q %zmm3, %zmm30, %zmm12
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,26,27,28,29,26,27,28,29,30,31,30,31]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm13 = ymm6[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm13[2],ymm3[3,4],ymm13[5],ymm3[6,7,8,9],ymm13[10],ymm3[11,12],ymm13[13],ymm3[14,15]
; AVX512F-FAST-NEXT:    vprold $16, %ymm15, %ymm13
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[1,2,2,3,5,6,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0,1],ymm13[2],ymm6[3,4],ymm13[5],ymm6[6,7,8,9],ymm13[10],ymm6[11,12],ymm13[13],ymm6[14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm13 = [2,1,3,2,10,10,10,11]
; AVX512F-FAST-NEXT:    vpermt2q %zmm3, %zmm13, %zmm6
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm5[4],xmm10[4],xmm5[5],xmm10[5],xmm5[6],xmm10[6],xmm5[7],xmm10[7]
; AVX512F-FAST-NEXT:    vpbroadcastq {{.*#+}} xmm15 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX512F-FAST-NEXT:    vpshufb %xmm15, %xmm10, %xmm10
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0],xmm10[1],xmm5[2,3],xmm10[4],xmm5[5,6],xmm10[7]
; AVX512F-FAST-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,2,3,3,4,5,6,7]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,0,1,1,8,8,10,9]
; AVX512F-FAST-NEXT:    vpermt2q %zmm3, %zmm2, %zmm5
; AVX512F-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX512F-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm3 # 16-byte Folded Reload
; AVX512F-FAST-NEXT:    # xmm3 = xmm1[4],mem[4],xmm1[5],mem[5],xmm1[6],mem[6],xmm1[7],mem[7]
; AVX512F-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm10 = xmm1[0,1,2,3,8,9,10,11,14,15,12,13,14,15,12,13]
; AVX512F-FAST-NEXT:    vmovdqa %xmm11, %xmm1
; AVX512F-FAST-NEXT:    vpshufb %xmm11, %xmm3, %xmm3
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,1,3,8,8,9,9]
; AVX512F-FAST-NEXT:    vpermt2q %zmm3, %zmm4, %zmm10
; AVX512F-FAST-NEXT:    vprold $16, %xmm14, %xmm3
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[1,1,2,3]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm11[0,1],xmm3[2],xmm11[3,4],xmm3[5],xmm11[6,7]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm14[0],xmm0[1],xmm14[1],xmm0[2],xmm14[2],xmm0[3],xmm14[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm1, %xmm0, %xmm11
; AVX512F-FAST-NEXT:    vpermt2q %zmm3, %zmm2, %zmm11
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %xmm0
; AVX512F-FAST-NEXT:    vpshufb %xmm15, %xmm0, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %xmm3
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm14 = xmm3[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm14[0],xmm2[1],xmm14[2,3],xmm2[4],xmm14[5,6],xmm2[7]
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,2,3,0,1,2,3,6,7,4,5,6,7,4,5]
; AVX512F-FAST-NEXT:    vpermt2q %zmm2, %zmm4, %zmm0
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm24, %zmm2, %zmm12
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm12, %zmm6
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufb %ymm7, %ymm12, %ymm3
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm1[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7,8,9],ymm4[10],ymm3[11,12],ymm4[13],ymm3[14,15]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm4 = ymm12[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm7 = ymm1[0,1,1,3,4,5,5,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm7[0,1],ymm4[2],ymm7[3,4],ymm4[5],ymm7[6,7,8,9],ymm4[10],ymm7[11,12],ymm4[13],ymm7[14,15]
; AVX512F-FAST-NEXT:    vpermt2q %zmm3, %zmm13, %zmm4
; AVX512F-FAST-NEXT:    vmovdqa64 (%rax), %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [4,5,2,2,6,6,6,6,30,31,27,27,31,31,30,31]
; AVX512F-FAST-NEXT:    vpermi2d %zmm3, %zmm8, %zmm7
; AVX512F-FAST-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm6, %zmm7
; AVX512F-FAST-NEXT:    vpbroadcastd 36(%rax), %ymm6
; AVX512F-FAST-NEXT:    vpbroadcastd 40(%rax), %ymm8
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm8, %zmm6, %zmm6
; AVX512F-FAST-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm10, %zmm6
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm26, %zmm8, %zmm5
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm5, %zmm6
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm11, %zmm0
; AVX512F-FAST-NEXT:    vpbroadcastd (%rax), %ymm5
; AVX512F-FAST-NEXT:    vpbroadcastd 4(%rax), %ymm10
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm10, %zmm5, %zmm5
; AVX512F-FAST-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm14[0,2,3,3,4,5,6,7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,0,2,1]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm19[0,0,1,3]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm18[2,2,2,3]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm17[2,1,3,2]
; AVX512F-FAST-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm27, %zmm5
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm5
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm15[10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm1[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm14[0],ymm0[1],ymm14[2,3],ymm0[4],ymm14[5,6,7,8],ymm0[9],ymm14[10,11],ymm0[12],ymm14[13,14,15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm14 = ymm15[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm15 = ymm1[1,1,1,1,5,5,5,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4],ymm15[5],ymm14[6,7,8,9],ymm15[10],ymm14[11,12],ymm15[13],ymm14[14,15]
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm30, %zmm14
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm4, %zmm14
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [6,u,u,u,7,u,u,7]
; AVX512F-FAST-NEXT:    vpermd %ymm9, %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm9, %zmm3, %zmm3
; AVX512F-FAST-NEXT:    vpermd %zmm3, %zmm21, %zmm3
; AVX512F-FAST-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm28, %zmm3
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm14, %zmm3
; AVX512F-FAST-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm4 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm9 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm4, %zmm8, %zmm9
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm23, %zmm2, %zmm20
; AVX512F-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm25, %zmm31
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm9, %zmm31
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm12, %zmm2, %zmm2
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm13, %zmm4, %zmm4
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm4
; AVX512F-FAST-NEXT:    vpternlogq $248, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm29, %zmm16
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm4, %zmm16
; AVX512F-FAST-NEXT:    vpbroadcastd 32(%rax), %ymm2
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-FAST-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm22, %zmm0
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm20, %zmm0
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, 128(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm16, 320(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm6, 256(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm31, 64(%rax)
; AVX512F-FAST-NEXT:    addq $248, %rsp
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride7_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%r10), %zmm0
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [0,0,30,62,28,60,0,0,0,31,63,29,61,0,0,0,0,0,30,62,28,60,0,0,0,31,63,29,61,0,0,0]
; AVX512BW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm3, %zmm5
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [27,0,0,0,62,30,60,28,0,0,0,63,31,61,29,0,27,0,0,0,62,30,60,28,0,0,0,63,31,61,29,0]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm6, %zmm7, %zmm8
; AVX512BW-NEXT:    movl $101455920, %ecx # imm = 0x60C1830
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm5, %zmm8 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [61,27,59,0,0,0,30,62,28,60,0,0,0,31,63,29,61,27,59,0,0,0,30,62,28,60,0,0,0,31,63,29]
; AVX512BW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm1, %zmm5
; AVX512BW-NEXT:    movl $1623294726, %ecx # imm = 0x60C18306
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqu16 %zmm5, %zmm8 {%k2}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [0,1,2,59,4,5,6,7,8,9,60,11,12,13,14,15,16,61,18,19,20,21,22,23,62,25,26,27,28,29,30,63]
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm8, %zmm5
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [2,34,0,32,0,0,0,3,35,1,33,0,0,0,4,36,2,34,0,32,0,0,0,3,35,1,33,0,0,0,4,36]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm6, %zmm9
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,32,0,0,0,3,35,1,33,0,0,0,4,36,2,34,0,32,0,0,0,3,35,1,33,0,0,0,4,36,2,34]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm3, %zmm8
; AVX512BW-NEXT:    movl $-1048377844, %ecx # imm = 0xC183060C
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqu16 %zmm9, %zmm8 {%k2}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,0,2,34,0,32,0,0,0,3,35,1,33,0,0,0,0,0,2,34,0,32,0,0,0,3,35,1,33,0,0,0]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm1, %zmm9
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [u,u,u,u,4,5,32,u,u,u,u,11,12,33,u,u,u,u,18,19,34,u,u,u,u,25,26,35,u,u,u,u]
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm9, %zmm10
; AVX512BW-NEXT:    movl $236730480, %ecx # imm = 0xE1C3870
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqu16 %zmm10, %zmm8 {%k2}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [0,0,0,7,39,5,37,0,0,0,8,40,6,38,0,0,0,0,0,7,39,5,37,0,0,0,8,40,6,38,0,0]
; AVX512BW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm6, %zmm10
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,7,39,5,37,0,0,0,8,40,6,38,0,0,0,9,0,7,39,5,37,0,0,0,8,40,6,38,0,0,0,9]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm3, %zmm9
; AVX512BW-NEXT:    movl $202911840, %ecx # imm = 0xC183060
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqu16 %zmm10, %zmm9 {%k2}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [4,36,0,0,0,7,39,5,37,0,0,0,8,40,6,38,4,36,0,0,0,7,39,5,37,0,0,0,8,40,6,38]
; AVX512BW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm1, %zmm10
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [0,1,36,u,u,u,u,7,8,37,u,u,u,u,14,15,38,u,u,u,u,21,22,39,u,u,u,u,28,29,40,u]
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm10, %zmm11
; AVX512BW-NEXT:    movl $1893843847, %ecx # imm = 0x70E1C387
; AVX512BW-NEXT:    kmovd %ecx, %k3
; AVX512BW-NEXT:    vmovdqu16 %zmm11, %zmm9 {%k3}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [9,0,0,0,44,12,42,10,0,0,0,45,13,43,11,0,9,0,0,0,44,12,42,10,0,0,0,45,13,43,11,0]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm4, %zmm11
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [43,9,41,0,0,0,12,44,10,42,0,0,0,13,45,11,43,9,41,0,0,0,12,44,10,42,0,0,0,13,45,11]
; AVX512BW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm6, %zmm10
; AVX512BW-NEXT:    movl $405823681, %ecx # imm = 0x183060C1
; AVX512BW-NEXT:    kmovd %ecx, %k3
; AVX512BW-NEXT:    vmovdqu16 %zmm11, %zmm10 {%k3}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [0,11,43,9,41,0,0,0,12,44,10,42,0,0,0,13,0,11,43,9,41,0,0,0,12,44,10,42,0,0,0,13]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm1, %zmm11
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [u,u,u,3,4,41,u,u,u,u,10,11,42,u,u,u,u,17,18,43,u,u,u,u,24,25,44,u,u,u,u,31]
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm11, %zmm12
; AVX512BW-NEXT:    movl $-2029118408, %ecx # imm = 0x870E1C38
; AVX512BW-NEXT:    kmovd %ecx, %k3
; AVX512BW-NEXT:    vmovdqu16 %zmm12, %zmm10 {%k3}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [0,0,16,48,14,46,0,0,0,17,49,15,47,0,0,0,0,0,16,48,14,46,0,0,0,17,49,15,47,0,0,0]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm6, %zmm11
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [16,48,14,46,0,0,0,17,49,15,47,0,0,0,18,50,16,48,14,46,0,0,0,17,49,15,47,0,0,0,18,50]
; AVX512BW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm3, %zmm12
; AVX512BW-NEXT:    vmovdqu16 %zmm11, %zmm12 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [13,0,0,0,48,16,46,14,0,0,0,49,17,47,15,0,13,0,0,0,48,16,46,14,0,0,0,49,17,47,15,0]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm2, %zmm11
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = [0,45,u,u,u,u,6,7,46,u,u,u,u,13,14,47,u,u,u,u,20,21,48,u,u,u,u,27,28,49,u,u]
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm11, %zmm13
; AVX512BW-NEXT:    movl $946921923, %ecx # imm = 0x3870E1C3
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm13, %zmm12 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [0,0,0,21,53,19,51,0,0,0,22,54,20,52,0,0,0,0,0,21,53,19,51,0,0,0,22,54,20,52,0,0]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm3, %zmm11
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [18,50,0,0,0,21,53,19,51,0,0,0,22,54,20,52,18,50,0,0,0,21,53,19,51,0,0,0,22,54,20,52]
; AVX512BW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm6, %zmm13
; AVX512BW-NEXT:    vmovdqu16 %zmm11, %zmm13 {%k2}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [20,52,18,50,0,0,0,21,53,19,51,0,0,0,22,54,20,52,18,50,0,0,0,21,53,19,51,0,0,0,22,54]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm1, %zmm11
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [u,u,2,3,50,u,u,u,u,9,10,51,u,u,u,u,16,17,52,u,u,u,u,23,24,53,u,u,u,u,30,31]
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm11, %zmm14
; AVX512BW-NEXT:    movl $-1014559204, %ecx # imm = 0xC3870E1C
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm14, %zmm13 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [0,25,57,23,55,0,0,0,26,58,24,56,0,0,0,27,0,25,57,23,55,0,0,0,26,58,24,56,0,0,0,27]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm7, %zmm6, %zmm11
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [57,23,55,0,0,0,26,58,24,56,0,0,0,27,59,25,57,23,55,0,0,0,26,58,24,56,0,0,0,27,59,25]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm3, %zmm6
; AVX512BW-NEXT:    movl $-2096755688, %ecx # imm = 0x83060C18
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm11, %zmm6 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,0,0,25,57,23,55,0,0,0,26,58,24,56,0,0,0,0,0,25,57,23,55,0,0,0,26,58,24,56,0,0]
; AVX512BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm2, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [54,u,u,u,u,5,6,55,u,u,u,u,12,13,56,u,u,u,u,19,20,57,u,u,u,u,26,27,58,u,u,u]
; AVX512BW-NEXT:    vpermi2w %zmm0, %zmm3, %zmm1
; AVX512BW-NEXT:    movl $473460961, %ecx # imm = 0x1C3870E1
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm1, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 384(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <32 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <32 x i16>, ptr %in.vecptr4, align 64
  %in.vec5 = load <32 x i16>, ptr %in.vecptr5, align 64
  %in.vec6 = load <32 x i16>, ptr %in.vecptr6, align 64
  %1 = shufflevector <32 x i16> %in.vec0, <32 x i16> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i16> %in.vec2, <32 x i16> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <32 x i16> %in.vec4, <32 x i16> %in.vec5, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = shufflevector <64 x i16> %1, <64 x i16> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %5 = shufflevector <32 x i16> %in.vec6, <32 x i16> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <64 x i16> %3, <64 x i16> %5, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %7 = shufflevector <96 x i16> %6, <96 x i16> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <128 x i16> %4, <128 x i16> %7, <224 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223>
  %interleaved.vec = shufflevector <224 x i16> %8, <224 x i16> poison, <224 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 160, i32 192, i32 1, i32 33, i32 65, i32 97, i32 129, i32 161, i32 193, i32 2, i32 34, i32 66, i32 98, i32 130, i32 162, i32 194, i32 3, i32 35, i32 67, i32 99, i32 131, i32 163, i32 195, i32 4, i32 36, i32 68, i32 100, i32 132, i32 164, i32 196, i32 5, i32 37, i32 69, i32 101, i32 133, i32 165, i32 197, i32 6, i32 38, i32 70, i32 102, i32 134, i32 166, i32 198, i32 7, i32 39, i32 71, i32 103, i32 135, i32 167, i32 199, i32 8, i32 40, i32 72, i32 104, i32 136, i32 168, i32 200, i32 9, i32 41, i32 73, i32 105, i32 137, i32 169, i32 201, i32 10, i32 42, i32 74, i32 106, i32 138, i32 170, i32 202, i32 11, i32 43, i32 75, i32 107, i32 139, i32 171, i32 203, i32 12, i32 44, i32 76, i32 108, i32 140, i32 172, i32 204, i32 13, i32 45, i32 77, i32 109, i32 141, i32 173, i32 205, i32 14, i32 46, i32 78, i32 110, i32 142, i32 174, i32 206, i32 15, i32 47, i32 79, i32 111, i32 143, i32 175, i32 207, i32 16, i32 48, i32 80, i32 112, i32 144, i32 176, i32 208, i32 17, i32 49, i32 81, i32 113, i32 145, i32 177, i32 209, i32 18, i32 50, i32 82, i32 114, i32 146, i32 178, i32 210, i32 19, i32 51, i32 83, i32 115, i32 147, i32 179, i32 211, i32 20, i32 52, i32 84, i32 116, i32 148, i32 180, i32 212, i32 21, i32 53, i32 85, i32 117, i32 149, i32 181, i32 213, i32 22, i32 54, i32 86, i32 118, i32 150, i32 182, i32 214, i32 23, i32 55, i32 87, i32 119, i32 151, i32 183, i32 215, i32 24, i32 56, i32 88, i32 120, i32 152, i32 184, i32 216, i32 25, i32 57, i32 89, i32 121, i32 153, i32 185, i32 217, i32 26, i32 58, i32 90, i32 122, i32 154, i32 186, i32 218, i32 27, i32 59, i32 91, i32 123, i32 155, i32 187, i32 219, i32 28, i32 60, i32 92, i32 124, i32 156, i32 188, i32 220, i32 29, i32 61, i32 93, i32 125, i32 157, i32 189, i32 221, i32 30, i32 62, i32 94, i32 126, i32 158, i32 190, i32 222, i32 31, i32 63, i32 95, i32 127, i32 159, i32 191, i32 223>
  store <224 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i16_stride7_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i16_stride7_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1640, %rsp # imm = 0x668
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa 112(%rdi), %xmm15
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rsi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rdx), %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdx), %xmm1
; SSE-NEXT:    movdqa 96(%rcx), %xmm12
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rcx), %xmm6
; SSE-NEXT:    movdqa 112(%r8), %xmm4
; SSE-NEXT:    movdqa 112(%r9), %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rax), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,2,2,2]
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm6[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    punpckhwd {{.*#+}} xmm15 = xmm15[4],xmm2[4],xmm15[5],xmm2[5],xmm15[6],xmm2[6],xmm15[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[3,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,1,1]
; SSE-NEXT:    movdqa %xmm4, %xmm9
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,0],xmm3[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm1[0,2]
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    andps %xmm1, %xmm4
; SSE-NEXT:    andnps %xmm7, %xmm1
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    orps %xmm4, %xmm1
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa 96(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rsi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa 96(%r8), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm5, %xmm14
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa 96(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,0],xmm4[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm1[2,0]
; SSE-NEXT:    movdqa 96(%rax), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,3,3,3]
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    andps %xmm5, %xmm3
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm15, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[2,2,3,3]
; SSE-NEXT:    movdqa %xmm14, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm4[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[3,3,3,3]
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    andps %xmm5, %xmm3
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rax), %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[0,1,0,1]
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa (%r8), %xmm8
; SSE-NEXT:    movdqa (%r9), %xmm7
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm7[0],xmm3[1],xmm7[1],xmm3[2],xmm7[2],xmm3[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa (%rcx), %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm12
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa (%rdi), %xmm9
; SSE-NEXT:    movdqa (%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm15
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm9[0],xmm3[1],xmm9[1],xmm3[2],xmm9[2],xmm3[3],xmm9[3]
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm12, %xmm3
; SSE-NEXT:    movdqa %xmm12, %xmm9
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,0,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,2,2,2]
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm5[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm13, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm15[4],xmm0[5],xmm15[5],xmm0[6],xmm15[6],xmm0[7],xmm15[7]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0,2]
; SSE-NEXT:    andps %xmm12, %xmm3
; SSE-NEXT:    orps %xmm1, %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm11[2,3,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm7[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm15
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm5[4],xmm2[5],xmm5[5],xmm2[6],xmm5[6],xmm2[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,2],xmm2[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[0,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rax), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,1,0,1]
; SSE-NEXT:    movdqa %xmm3, %xmm11
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 16(%r8), %xmm14
; SSE-NEXT:    movdqa 16(%r9), %xmm1
; SSE-NEXT:    movdqa %xmm14, %xmm5
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm1, %xmm13
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 16(%rcx), %xmm8
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa 16(%rdx), %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    movdqa 16(%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rsi), %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    movdqa %xmm6, %xmm9
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pand %xmm10, %xmm4
; SSE-NEXT:    movdqa %xmm10, %xmm6
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm11, %xmm1
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrldq {{.*#+}} xmm5 = xmm5[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm8[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm8[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0,2]
; SSE-NEXT:    andps %xmm12, %xmm3
; SSE-NEXT:    orps %xmm1, %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm11[2,3,2,3]
; SSE-NEXT:    movdqa %xmm15, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm14[4],xmm1[5],xmm14[5],xmm1[6],xmm14[6],xmm1[7],xmm14[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm15, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,2],xmm7[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[0,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rax), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[0,1,0,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 32(%r8), %xmm14
; SSE-NEXT:    movdqa 32(%r9), %xmm4
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    movdqa %xmm4, %xmm13
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm6, %xmm8
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 32(%rcx), %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa 32(%rdx), %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    movdqa 32(%rdi), %xmm9
; SSE-NEXT:    movdqa 32(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3]
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm4[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm15
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,0,0,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[2,2,2,2]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm2[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm4[0,2]
; SSE-NEXT:    andps %xmm10, %xmm0
; SSE-NEXT:    orps %xmm1, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[2,3,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm14[4],xmm1[5],xmm14[5],xmm1[6],xmm14[6],xmm1[7],xmm14[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm2[4],xmm5[5],xmm2[5],xmm5[6],xmm2[6],xmm5[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,2],xmm5[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[0,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rax), %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,1,0,1]
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 48(%r8), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%r9), %xmm12
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm12[0],xmm0[1],xmm12[1],xmm0[2],xmm12[2],xmm0[3],xmm12[3]
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm8, %xmm7
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 48(%rcx), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm9
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa 48(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm10
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    movdqa 48(%rdi), %xmm6
; SSE-NEXT:    movdqa 48(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm6[0],xmm4[1],xmm6[1],xmm4[2],xmm6[2],xmm4[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm4[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm5, %xmm15
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm15, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,0,0,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm9[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm9[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm4[0,2]
; SSE-NEXT:    andps %xmm2, %xmm0
; SSE-NEXT:    orps %xmm1, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[2,3,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    punpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    # xmm12 = xmm12[4],mem[4],xmm12[5],mem[5],xmm12[6],mem[6],xmm12[7],mem[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm12[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm9[4],xmm3[5],xmm9[5],xmm3[6],xmm9[6],xmm3[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,2],xmm3[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[0,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rax), %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,1,0,1]
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 64(%r8), %xmm1
; SSE-NEXT:    movdqa 64(%r9), %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm7
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm2, %xmm10
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 64(%rcx), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm11
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa 64(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm13
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    movdqa 64(%rdi), %xmm8
; SSE-NEXT:    movdqa 64(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm4[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,0,0,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm13[2,2,2,2]
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm11[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm11[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm4[0,2]
; SSE-NEXT:    andps %xmm9, %xmm0
; SSE-NEXT:    orps %xmm1, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[2,3,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm7[4],xmm1[5],xmm7[5],xmm1[6],xmm7[6],xmm1[7],xmm7[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm11[4],xmm3[5],xmm11[5],xmm3[6],xmm11[6],xmm3[7],xmm11[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,2],xmm3[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[0,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rax), %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[0,1,0,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 80(%r8), %xmm1
; SSE-NEXT:    movdqa 80(%r9), %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm2[0],xmm8[1],xmm2[1],xmm8[2],xmm2[2],xmm8[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm2, %xmm11
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa 80(%rcx), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm13
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa 80(%rdx), %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    movdqa 80(%rdi), %xmm7
; SSE-NEXT:    movdqa 80(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm7[0],xmm4[1],xmm7[1],xmm4[2],xmm7[2],xmm4[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm4[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    movdqa %xmm9, %xmm5
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm9, %xmm1
; SSE-NEXT:    psrldq {{.*#+}} xmm8 = xmm8[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,0,0,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    pandn %xmm8, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,2,2,2]
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm13[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[3,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[3,3,3,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm13, %xmm6
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm4[0,2]
; SSE-NEXT:    andps %xmm9, %xmm0
; SSE-NEXT:    movaps %xmm9, %xmm13
; SSE-NEXT:    orps %xmm1, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[2,3,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm10[4],xmm1[5],xmm10[5],xmm1[6],xmm10[6],xmm1[7],xmm10[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm11
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4],xmm6[4],xmm8[5],xmm6[5],xmm8[6],xmm6[6],xmm8[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,2],xmm8[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm1[0,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,1,0,1]
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    psrld $16, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpcklwd (%rsp), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[0],mem[0],xmm4[1],mem[1],xmm4[2],mem[2],xmm4[3],mem[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm14, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    pand %xmm10, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm10
; SSE-NEXT:    por %xmm4, %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm3
; SSE-NEXT:    movdqa %xmm15, %xmm12
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm5, %xmm10
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psrldq {{.*#+}} xmm1 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm7, %xmm14
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[2,2,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm2[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pand %xmm9, %xmm5
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm5[3,3]
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm14 = xmm14[0],xmm2[0],xmm14[1],xmm2[1],xmm14[2],xmm2[2],xmm14[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm2[3,3,3,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm13, %xmm3
; SSE-NEXT:    andps %xmm13, %xmm4
; SSE-NEXT:    andnps %xmm1, %xmm3
; SSE-NEXT:    orps %xmm4, %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[2,3,2,3]
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm8[4],xmm3[5],xmm8[5],xmm3[6],xmm8[6],xmm3[7],xmm8[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,5,4]
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    movdqa %xmm11, %xmm15
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm5[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,2],xmm3[0,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm4[0],xmm9[1],xmm4[1],xmm9[2],xmm4[2],xmm9[3],xmm4[3]
; SSE-NEXT:    psrld $16, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm10[0],xmm4[1],xmm10[1],xmm4[2],xmm10[2],xmm4[3],xmm10[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,5,4]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[0,0,0,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,5,5,5]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,1],xmm4[3,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm11[0,0,1,1]
; SSE-NEXT:    movdqa %xmm12, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm5[0,2]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,1,0,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    andps %xmm5, %xmm4
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm11[2,2,2,2]
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,0],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,zero,zero,zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535,65535,0,0,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm7, %xmm5
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    por %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    psrldq {{.*#+}} xmm1 = xmm1[6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero
; SSE-NEXT:    movdqa %xmm15, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pand %xmm15, %xmm5
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[2,2,3,3]
; SSE-NEXT:    pandn %xmm1, %xmm5
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm10[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm13[0],xmm3[1],xmm13[1],xmm3[2],xmm13[2],xmm3[3],xmm13[3]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    psrld $16, %xmm3
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm9[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm9[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSE-NEXT:    andps %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    pandn %xmm1, %xmm12
; SSE-NEXT:    por %xmm0, %xmm12
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535,0,65535,65535,65535]
; SSE-NEXT:    pand %xmm1, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,1,1,3]
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm12, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, %xmm13
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,5,4]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [0,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1],xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm8, %xmm15
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,5,4]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm2[0],xmm7[1],xmm2[1],xmm7[2],xmm2[2],xmm7[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,5,4]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,5,4]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,5,4]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,5,4]
; SSE-NEXT:    pandn %xmm1, %xmm5
; SSE-NEXT:    por %xmm0, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm13[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm11[1,1]
; SSE-NEXT:    movaps {{.*#+}} xmm5 = [65535,65535,0,0,0,65535,65535,65535]
; SSE-NEXT:    movaps %xmm5, %xmm2
; SSE-NEXT:    andnps %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    orps %xmm0, %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm6[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm8[1,1]
; SSE-NEXT:    movaps %xmm8, %xmm12
; SSE-NEXT:    movaps %xmm5, %xmm2
; SSE-NEXT:    andnps %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    orps %xmm0, %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm7[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm14[1,1]
; SSE-NEXT:    movaps %xmm14, %xmm11
; SSE-NEXT:    movaps %xmm5, %xmm2
; SSE-NEXT:    andnps %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    orps %xmm0, %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw $164, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm3[1,1]
; SSE-NEXT:    movaps %xmm3, %xmm14
; SSE-NEXT:    movaps %xmm5, %xmm2
; SSE-NEXT:    andnps %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    orps %xmm0, %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw $164, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm10, %xmm13
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm10[1,1]
; SSE-NEXT:    movaps %xmm5, %xmm2
; SSE-NEXT:    andnps %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    orps %xmm0, %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw $164, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm15[1,1]
; SSE-NEXT:    movaps %xmm5, %xmm2
; SSE-NEXT:    andnps %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    orps %xmm0, %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm1[1,1,1,1,4,5,6,7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufhw $164, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,2,3,4,5,6,6]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,2],xmm3[1,1]
; SSE-NEXT:    andnps %xmm1, %xmm5
; SSE-NEXT:    orps %xmm0, %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    # xmm9 = xmm9[0],mem[0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0,1],mem[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0],xmm0[0,2]
; SSE-NEXT:    movaps {{.*#+}} xmm2 = [65535,65535,65535,65535,65535,0,65535,65535]
; SSE-NEXT:    andps %xmm2, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm1[0,1,2,3,5,6,6,7]
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm1[0,1,2,3,4,5]
; SSE-NEXT:    andnps %xmm1, %xmm2
; SSE-NEXT:    orps %xmm9, %xmm2
; SSE-NEXT:    movaps {{.*#+}} xmm5 = [65535,65535,65535,65535,65535,65535,0,65535]
; SSE-NEXT:    andps %xmm5, %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,0,0,0]
; SSE-NEXT:    andnps %xmm1, %xmm5
; SSE-NEXT:    orps %xmm7, %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    shufps $42, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = xmm5[2,2],mem[2,0]
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [0,65535,65535,65535,65535,65535,65535,0]
; SSE-NEXT:    andps %xmm1, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,2]
; SSE-NEXT:    andnps %xmm0, %xmm1
; SSE-NEXT:    orps %xmm5, %xmm1
; SSE-NEXT:    movaps {{.*#+}} xmm5 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    andps %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,2,3]
; SSE-NEXT:    andnps %xmm0, %xmm5
; SSE-NEXT:    orps %xmm1, %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,zero,zero,zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,0,0,0,0,65535]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    movapd %xmm10, %xmm5
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = xmm5[1],mem[0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm0[2,1]
; SSE-NEXT:    andps %xmm2, %xmm5
; SSE-NEXT:    orps %xmm1, %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    # xmm12 = xmm12[1],mem[0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,0],xmm0[2,1]
; SSE-NEXT:    andps %xmm2, %xmm12
; SSE-NEXT:    orps %xmm1, %xmm12
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm11, %xmm6
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; SSE-NEXT:    # xmm11 = xmm11[1],mem[0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,0],xmm0[2,1]
; SSE-NEXT:    andps %xmm2, %xmm11
; SSE-NEXT:    orps %xmm1, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm14, %xmm15
; SSE-NEXT:    movaps %xmm14, %xmm9
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    # xmm9 = xmm9[1],mem[0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0],xmm0[2,1]
; SSE-NEXT:    andps %xmm2, %xmm9
; SSE-NEXT:    orps %xmm1, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm7
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = xmm7[1],mem[0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm0[2,1]
; SSE-NEXT:    andps %xmm2, %xmm7
; SSE-NEXT:    orps %xmm1, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    movapd %xmm14, %xmm5
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = xmm5[1],mem[0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm0[2,1]
; SSE-NEXT:    andps %xmm2, %xmm5
; SSE-NEXT:    orps %xmm1, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,zero,zero,zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pslldq {{.*#+}} xmm0 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    shufpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[1],mem[0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm0[2,1]
; SSE-NEXT:    andps %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[2,0],mem[2,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535,0,0,0,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm10
; SSE-NEXT:    pandn %xmm1, %xmm10
; SSE-NEXT:    andps %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm10
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[2,0],mem[2,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm8[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    movdqa %xmm4, %xmm8
; SSE-NEXT:    pandn %xmm1, %xmm8
; SSE-NEXT:    andps %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[2,0],mem[2,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pandn %xmm1, %xmm6
; SSE-NEXT:    andps %xmm4, %xmm0
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    # xmm13 = xmm13[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    # xmm13 = xmm13[2,0],mem[2,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm15[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    andps %xmm4, %xmm13
; SSE-NEXT:    por %xmm13, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[2,0],mem[2,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,0,1,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    # xmm13 = mem[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; SSE-NEXT:    movdqa %xmm4, %xmm13
; SSE-NEXT:    pandn %xmm0, %xmm13
; SSE-NEXT:    andps %xmm4, %xmm1
; SSE-NEXT:    por %xmm1, %xmm13
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[2,0],mem[2,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,0,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm15[0],xmm0[1],xmm15[1]
; SSE-NEXT:    movdqa %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm0, %xmm15
; SSE-NEXT:    andps %xmm4, %xmm1
; SSE-NEXT:    por %xmm1, %xmm15
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklpd (%rsp), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[0],mem[0]
; SSE-NEXT:    shufps $98, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[2,0],mem[2,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,0,1,1]
; SSE-NEXT:    pshufd $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; SSE-NEXT:    # xmm14 = mem[0,0,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm14[0],xmm0[1],xmm14[1]
; SSE-NEXT:    andps %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm4, 672(%rax)
; SSE-NEXT:    movdqa %xmm15, 560(%rax)
; SSE-NEXT:    movdqa %xmm13, 448(%rax)
; SSE-NEXT:    movdqa %xmm3, 336(%rax)
; SSE-NEXT:    movdqa %xmm6, 224(%rax)
; SSE-NEXT:    movdqa %xmm8, 112(%rax)
; SSE-NEXT:    movdqa %xmm10, (%rax)
; SSE-NEXT:    movdqa %xmm2, 736(%rax)
; SSE-NEXT:    movaps %xmm5, 624(%rax)
; SSE-NEXT:    movaps %xmm7, 512(%rax)
; SSE-NEXT:    movaps %xmm9, 400(%rax)
; SSE-NEXT:    movaps %xmm11, 288(%rax)
; SSE-NEXT:    movaps %xmm12, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rax)
; SSE-NEXT:    addq $1640, %rsp # imm = 0x668
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i16_stride7_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $1496, %rsp # imm = 0x5D8
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovdqa 112(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 112(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm4[4],xmm1[4],xmm4[5],xmm1[5],xmm4[6],xmm1[6],xmm4[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,xmm5[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm14 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm14, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 112(%rdx), %xmm6
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm6[2,2,2,2]
; AVX1-ONLY-NEXT:    vmovdqa 112(%rcx), %xmm8
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm8[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1,2,3,4,5],xmm2[6],xmm3[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm6[4],xmm8[4],xmm6[5],xmm8[5],xmm6[6],xmm8[6],xmm6[7],xmm8[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,xmm9[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm14, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm2, %ymm7
; AVX1-ONLY-NEXT:    vmovdqa 112(%r8), %xmm0
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[1,1,1,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm7[0],xmm2[1],xmm7[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa 112(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 112(%rax), %xmm3
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm11[0],xmm7[1,2,3,4,5,6],xmm11[7]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm11 = xmm2[6,7,8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0],xmm11[1],xmm7[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm3[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1],xmm11[2],xmm7[3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm8, %xmm7
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm11 = xmm6[0],xmm7[0],xmm6[1],xmm7[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm6[0],xmm8[0],xmm6[1],xmm8[1],xmm6[2],xmm8[2],xmm6[3],xmm8[3]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm7[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm1, %xmm12
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm4[0],xmm12[0],xmm4[1],xmm12[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm13[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm13 = [65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0]
; AVX1-ONLY-NEXT:    vandnps %ymm11, %ymm13, %ymm11
; AVX1-ONLY-NEXT:    vandps %ymm13, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vmovaps %ymm13, %ymm15
; AVX1-ONLY-NEXT:    vorps %ymm11, %ymm12, %ymm11
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm0[0,0,1,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm11[0,1,2],xmm12[3],xmm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vpmovzxwq {{.*#+}} xmm13 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0,1,2,3],xmm13[4,5],xmm12[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm3[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0,1,2,3,4],xmm13[5],xmm12[6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm11, %xmm11
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1],xmm0[2,3],xmm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vpslld $16, %xmm2, %xmm12
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2],xmm12[3],xmm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm12 = xmm3[0],zero,xmm3[1],zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2,3],xmm12[4],xmm11[5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm8, %xmm8
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm8 = xmm6[1],xmm8[1]
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm2, %xmm11
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm10[0,1],xmm11[2,3],xmm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm9, %ymm8
; AVX1-ONLY-NEXT:    vandnps %ymm8, %ymm14, %ymm8
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm5[2,2,3,3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm5[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm9, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm14, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm5, %ymm8, %ymm5
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm5[0,1,2,3,4,5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm2[0,1,2,3,5,6,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm9[0],xmm8[1,2,3,4,5,6],xmm9[7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm9 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0],xmm9[1],xmm8[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4],xmm8[5],xmm5[6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5],xmm11[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm3[3,3,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm5 = xmm8[0],xmm5[1,2,3,4,5,6],xmm8[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdx), %xmm8
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 96(%rcx), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm5, %xmm5
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm5 = xmm8[1],xmm5[1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rsi), %xmm4
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm7[4],xmm4[4],xmm7[5],xmm4[5],xmm7[6],xmm4[6],xmm7[7],xmm4[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm4 = xmm4[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm4, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm7 = [65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm5, %ymm7, %ymm4
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm4, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vmovdqa 96(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm1[0,1,2,3,4],xmm4[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 96(%r9), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm5, %xmm5
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5],xmm5[6,7]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rax), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[3,3,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0],xmm4[1,2,3,4,5,6],xmm5[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2,3],xmm0[4,5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4,5]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4],xmm1[5],xmm0[6,7]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm6[0,1,2],xmm3[3],xmm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm3[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5],xmm1[6],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa (%rdx), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa (%rcx), %xmm3
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm3, %xmm0
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, %xmm9
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, %xmm10
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovdqa (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,1,2,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm11 = [65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm11, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm11, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm4, %ymm5
; AVX1-ONLY-NEXT:    vmovdqa (%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa (%r8), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm6 = zero,zero,xmm3[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vmovdqa (%rax), %xmm4
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm4[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2,3,4],xmm7[5],xmm6[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm3[0,1,0,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm4[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,5],xmm8[6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm7 = [65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vandnps %ymm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm1, %xmm5
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm5, %ymm1
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm9[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm10[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5],xmm5[6],xmm2[7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm12 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm12, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm1 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2],xmm4[3],xmm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm3[0,2],xmm4[1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm4 = [65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm4, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdx), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm5[0],xmm0[0],xmm5[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, %xmm6
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm2[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm3, %xmm1
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm7[0],xmm1[0],xmm7[1],xmm1[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm7[0],xmm3[1],xmm7[1],xmm3[2],xmm7[2],xmm3[3],xmm7[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, %xmm9
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, %xmm10
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm15, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm15, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 16(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 16(%r8), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 16(%rax), %xmm3
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, %xmm7
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,xmm13[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm3[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm2[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm13[0,2],xmm3[1,3]
; AVX1-ONLY-NEXT:    vmovaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm14 = [65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm14, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm14, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[0,1,0,1]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm6[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm5[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5],xmm2[6],xmm1[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm5[4],xmm6[4],xmm5[5],xmm6[5],xmm5[6],xmm6[6],xmm5[7],xmm6[7]
; AVX1-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm3[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm13[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm3[3],xmm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0]
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 32(%rcx), %xmm5
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm5, %xmm0
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, %xmm13
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, %xmm15
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vmovdqa 32(%rsi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm7[0],xmm2[0],xmm7[1],xmm2[1],xmm7[2],xmm2[2],xmm7[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,1,2,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm2[0],xmm7[0],xmm2[1],xmm7[1],xmm2[2],xmm7[2],xmm2[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm8[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm11, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm11, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm5, %ymm8
; AVX1-ONLY-NEXT:    vmovdqa 32(%r9), %xmm6
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 32(%r8), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 32(%rax), %xmm5
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm9 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1,2,3,4],xmm10[5],xmm9[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm1[0,1,0,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm11 = xmm5[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,5],xmm11[6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm10, %ymm9
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm3 = [65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vandnps %ymm9, %ymm3, %ymm9
; AVX1-ONLY-NEXT:    vorps %ymm9, %ymm8, %ymm6
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm2, %xmm8
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm7[0],xmm8[0],xmm7[1],xmm8[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm7[4],xmm2[4],xmm7[5],xmm2[5],xmm7[6],xmm2[6],xmm7[7],xmm2[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm8, %ymm2
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm13[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm15[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,5],xmm8[6],xmm7[7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm12, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm5[3],xmm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm5[1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm4, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdx), %xmm6
; AVX1-ONLY-NEXT:    vmovdqa 48(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm1, %xmm0
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm1[0],xmm6[1],xmm1[1],xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, %xmm8
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm2[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 48(%rsi), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm7, %xmm1
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm9[0],xmm1[0],xmm9[1],xmm1[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm7[0],xmm9[0],xmm7[1],xmm9[1],xmm7[2],xmm9[2],xmm7[3],xmm9[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, %xmm13
; AVX1-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm4 = [65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 48(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 48(%r8), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 48(%rax), %xmm11
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, %xmm9
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, %xmm10
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, %xmm2
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,xmm7[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm11[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm7[5],xmm1[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm7 = xmm2[0,2],xmm11[1,3]
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm14, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm14, %ymm1
; AVX1-ONLY-NEXT:    vmovaps %ymm14, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm13[4],xmm3[4],xmm13[5],xmm3[5],xmm13[6],xmm3[6],xmm13[7],xmm3[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[0,1,0,1]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm1 = zero,zero,xmm1[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm8[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5],xmm7[6],xmm1[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm6[4],xmm8[4],xmm6[5],xmm8[5],xmm6[6],xmm8[6],xmm6[7],xmm8[7]
; AVX1-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,xmm3[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm3 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm9[4],xmm10[4],xmm9[5],xmm10[5],xmm9[6],xmm10[6],xmm9[7],xmm10[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm11[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm7[2,3],xmm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm7 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1,2],xmm11[3],xmm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm7, %ymm1
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0]
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 64(%rcx), %xmm7
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm7, %xmm0
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm2[0],xmm7[0],xmm2[1],xmm7[1],xmm2[2],xmm7[2],xmm2[3],xmm7[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm3[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm7, %ymm1
; AVX1-ONLY-NEXT:    vmovdqa 64(%rsi), %xmm8
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,1,2,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm8[0],xmm9[0],xmm8[1],xmm9[1],xmm8[2],xmm9[2],xmm8[3],xmm9[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm10[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm6 = [65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm6, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm7, %ymm10
; AVX1-ONLY-NEXT:    vmovdqa 64(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 64(%r8), %xmm6
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm6[0],xmm1[0],xmm6[1],xmm1[1],xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm13 = zero,zero,xmm7[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vmovdqa 64(%rax), %xmm6
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm6[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm13[0,1,2,3,4],xmm14[5],xmm13[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm7[0,1,0,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm6[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm14 = xmm14[0,1,2,3,4,5],xmm15[6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm1 = [65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vandnps %ymm13, %ymm1, %ymm13
; AVX1-ONLY-NEXT:    vorps %ymm13, %ymm10, %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm8, %xmm10
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm9[0],xmm10[0],xmm9[1],xmm10[1]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm1[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm10, %ymm8
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm9 = xmm0[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm10 = xmm2[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1,2,3,4,5],xmm10[6],xmm9[7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm3[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm1 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm8, %ymm1, %ymm8
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm8, %ymm0
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm8 = xmm7[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm8[0,1,2],xmm6[3],xmm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,2],xmm6[1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm1 = [65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandnps %ymm7, %ymm1, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 80(%rcx), %xmm9
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm9, %xmm0
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm1[0],xmm9[0],xmm1[1],xmm9[1],xmm1[2],xmm9[2],xmm1[3],xmm9[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm2[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa 80(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa 80(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm3, %xmm7
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm2[0],xmm7[0],xmm2[1],xmm7[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, %xmm12
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm10[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm10, %ymm7
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vmovdqa 80(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa 80(%r8), %xmm2
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 80(%rax), %xmm2
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, %xmm0
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm15 = zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm2[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm15[0,1,2,3,4],xmm6[5],xmm15[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm15 = xmm0[0,2],xmm2[1,3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, %xmm10
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vandnps %ymm6, %ymm5, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm7, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm8[4],xmm12[4],xmm8[5],xmm12[5],xmm8[6],xmm12[6],xmm8[7],xmm12[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[0,1,0,1]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm7 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm9[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm1[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,5],xmm15[6],xmm7[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm9[4],xmm1[5],xmm9[5],xmm1[6],xmm9[6],xmm1[7],xmm9[7]
; AVX1-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm15 = zero,zero,zero,zero,zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm0 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm3[4],xmm4[4],xmm3[5],xmm4[5],xmm3[6],xmm4[6],xmm3[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,1,2,1]
; AVX1-ONLY-NEXT:    vmovaps %xmm2, (%rsp) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm2[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1],xmm15[2,3],xmm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm15 = xmm10[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm15 = xmm15[0,1,2],xmm2[3],xmm15[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm15, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm0 = [65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0]
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vandnps %ymm7, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm6, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm13, %xmm6
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm2[0],xmm6[0],xmm2[1],xmm6[1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm2[0],xmm13[0],xmm2[1],xmm13[1],xmm2[2],xmm13[2],xmm2[3],xmm13[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm13, %xmm8
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm6[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm15, %ymm7
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm15 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm15 = xmm15[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[0,1,2,1]
; AVX1-ONLY-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, %xmm1
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm14[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm14 = xmm14[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm15, %ymm14
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm0 = [65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm7, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm14, %ymm14
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm14, %ymm14
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm7 = xmm7[0],mem[0],xmm7[1],mem[1],xmm7[2],mem[2],xmm7[3],mem[3]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm15 = zero,zero,xmm7[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm0[0,1,0,1]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm15[0,1,2,3,4],xmm13[5],xmm15[6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm7[0,1,0,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm0[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm15[0,1,2,3,4,5],xmm12[6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm3 = [65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm14, %ymm13
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm3, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm12, %ymm13, %ymm3
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm1, %xmm12
; AVX1-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm4[0],xmm12[0],xmm4[1],xmm12[1]
; AVX1-ONLY-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm13 = mem[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm8[3,3,3,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,4,4,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm2[2,2,2,2]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,5],xmm14[6],xmm13[7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,5,6,6]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,1,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm10 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm10, %ymm12
; AVX1-ONLY-NEXT:    vandps %ymm6, %ymm10, %ymm6
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm12, %ymm6
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm12 = xmm7[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0,1,2],xmm0[3],xmm12[4,5,6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,2],xmm0[1,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm0 = [65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vandnps %ymm7, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm7, %ymm6, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm14[4],xmm15[4],xmm14[5],xmm15[5],xmm14[6],xmm15[6],xmm14[7],xmm15[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm7 = zero,zero,xmm0[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, %xmm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vandnps %ymm6, %ymm10, %ymm6
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm10, %ymm7
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm13[4],xmm1[4],xmm13[5],xmm1[5],xmm13[6],xmm1[6],xmm13[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0],xmm12[1],xmm7[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm12 = xmm1[4],xmm13[4],xmm1[5],xmm13[5],xmm1[6],xmm13[6],xmm1[7],xmm13[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm13, %xmm0
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm12[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm3[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0,1],xmm13[2,3],xmm12[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm5 = [65535,65535,65535,0,0,0,0,65535,65535,65535,0,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm6, %ymm5, %ymm6
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm12, %ymm4
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm15, %xmm6
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm6 = xmm14[1],xmm6[1]
; AVX1-ONLY-NEXT:    vpermilps $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm12 = mem[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm12 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm12 = xmm7[0],mem[0],xmm7[1],mem[1],xmm7[2],mem[2],xmm7[3],mem[3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm13 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm12[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[0,1,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm6, %ymm2, %ymm6
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm6, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vpshufd $68, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm6 = mem[0,1,0,1]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm2[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm6[0,1,2,3,4,5],xmm13[6,7]
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm0, %xmm6
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm6 = xmm1[2],xmm6[2],xmm1[3],xmm6[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm0 = [8,9,8,9,8,9,8,9,12,13,6,7,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm4, %ymm13
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm8 = [0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535]
; AVX1-ONLY-NEXT:    vandps %ymm8, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vandnps %ymm13, %ymm8, %ymm13
; AVX1-ONLY-NEXT:    vorps %ymm13, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm0, %xmm12
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm12 = xmm0[1],xmm12[1]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm14 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm0 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm0, %ymm12
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vorps %ymm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm0, %xmm13
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm13 = xmm1[2],xmm13[2],xmm1[3],xmm13[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm2[4],xmm13[4],xmm2[5],xmm13[5],xmm2[6],xmm13[6],xmm2[7],xmm13[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm14[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm14 = xmm14[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm14[0],xmm3[1],xmm14[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb %xmm6, %xmm13, %xmm13
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm3, %ymm13
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm7 = [0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0]
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vandnps %ymm13, %ymm7, %ymm13
; AVX1-ONLY-NEXT:    vorps %ymm13, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm12 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm13 = zero,zero,zero,zero,zero,zero,xmm12[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm13 = zero,zero,xmm4[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm4[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm10, %ymm12
; AVX1-ONLY-NEXT:    vandps %ymm10, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vorps %ymm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm13[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm6[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm13[0],xmm14[1],xmm13[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm14 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm14[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm14 = xmm14[0,1],xmm15[2,3],xmm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm5, %ymm12
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vorps %ymm12, %ymm13, %ymm5
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm2, %xmm12
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm12 = xmm3[1],xmm12[1]
; AVX1-ONLY-NEXT:    vpermilps $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm13 = mem[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm13 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm13 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm14 = xmm4[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm13[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[0,1,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm12, %ymm2, %ymm12
; AVX1-ONLY-NEXT:    vandps %ymm2, %ymm13, %ymm13
; AVX1-ONLY-NEXT:    vorps %ymm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vpermilps $68, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm13 = mem[0,1,0,1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm14 = xmm11[0,0,0,0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm13 = xmm13[0,1,2],xmm14[3]
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm0, %xmm14
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm14 = xmm1[2],xmm14[2],xmm1[3],xmm14[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm6[4],xmm14[4],xmm6[5],xmm14[5],xmm6[6],xmm14[6],xmm6[7],xmm14[7]
; AVX1-ONLY-NEXT:    vmovdqa {{.*#+}} xmm3 = [8,9,8,9,8,9,8,9,12,13,6,7,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm5, %xmm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm8, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vandnps %ymm5, %ymm8, %ymm5
; AVX1-ONLY-NEXT:    vorps %ymm5, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm0, %xmm5
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm5 = xmm0[1],xmm5[1]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm13 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm0 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm5, %ymm12, %ymm5
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm1, %xmm12
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm12 = xmm0[2],xmm12[2],xmm0[3],xmm12[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm12 = xmm11[4],xmm12[4],xmm11[5],xmm12[5],xmm11[6],xmm12[6],xmm11[7],xmm12[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm13[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm2 = xmm11[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm13[0],xmm2[1],xmm13[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufb %xmm3, %xmm12, %xmm12
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, %xmm15
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm7, %ymm2
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm5, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm3[4],xmm4[4],xmm3[5],xmm4[5],xmm3[6],xmm4[6],xmm3[7],xmm4[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm12 = zero,zero,zero,zero,zero,zero,xmm2[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm12, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm12 = zero,zero,xmm5[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm5[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm10, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm10, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm12, %ymm2
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm12 = xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm12[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm11[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm12[0],xmm13[1],xmm12[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm13 = xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, %xmm1
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm13[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm13 = xmm13[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm11[2,2,3,3]
; AVX1-ONLY-NEXT:    vmovdqa %xmm11, %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm13 = xmm13[0,1],xmm14[2,3],xmm13[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm14 = [65535,65535,65535,0,0,0,0,65535,65535,65535,0,0,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm2, %ymm14, %ymm2
; AVX1-ONLY-NEXT:    vandps %ymm14, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm2, %ymm12, %ymm2
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm4, %xmm11
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm11 = xmm3[1],xmm11[1]
; AVX1-ONLY-NEXT:    vpermilps $80, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm12 = mem[0,0,1,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm12 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm12 = xmm3[0],mem[0],xmm3[1],mem[1],xmm3[2],mem[2],xmm3[3],mem[3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm13 = xmm5[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm12[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[0,1,2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm13, %ymm12
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm3 = [65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm11, %ymm3, %ymm11
; AVX1-ONLY-NEXT:    vandps %ymm3, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vorps %ymm11, %ymm12, %ymm11
; AVX1-ONLY-NEXT:    vpshufd $68, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm10 = mem[0,1,0,1]
; AVX1-ONLY-NEXT:    vmovdqa (%rsp), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm12 = xmm5[0,0,0,0]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,5],xmm12[6,7]
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm1, %xmm12
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm12 = xmm6[2],xmm12[2],xmm6[3],xmm12[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm0[4],xmm12[4],xmm0[5],xmm12[5],xmm0[6],xmm12[6],xmm0[7],xmm12[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm15, %xmm1, %xmm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vandps %ymm8, %ymm11, %ymm10
; AVX1-ONLY-NEXT:    vandnps %ymm1, %ymm8, %ymm1
; AVX1-ONLY-NEXT:    vorps %ymm1, %ymm10, %ymm1
; AVX1-ONLY-NEXT:    vpsrlq $48, %xmm9, %xmm4
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm4 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm0[2,2,3,3]
; AVX1-ONLY-NEXT:    vpsrldq {{.*#+}} xmm9 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm0 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vandps %ymm0, %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vorps %ymm4, %ymm8, %ymm4
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpsrld $16, %xmm3, %xmm8
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm8 = xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm5[4],xmm8[4],xmm5[5],xmm8[5],xmm5[6],xmm8[6],xmm5[7],xmm8[7]
; AVX1-ONLY-NEXT:    vpshufb %xmm15, %xmm8, %xmm6
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm8[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm0 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm0 = xmm8[0],xmm0[1],xmm8[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vandps %ymm7, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vandnps %ymm0, %ymm7, %ymm0
; AVX1-ONLY-NEXT:    vorps %ymm0, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = xmm3[4],mem[4],xmm3[5],mem[5],xmm3[6],mem[6],xmm3[7],mem[7]
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm4 = zero,zero,zero,zero,zero,zero,xmm3[0,1,2,3,4,5,6,7,8,9]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpslldq {{.*#+}} xmm4 = zero,zero,xmm6[0,1,2,3,4,5,6,7,8,9,10,11,12,13]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,2,3,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vmovaps {{.*#+}} ymm5 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535]
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm5, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm5, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[2,2,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,5,4]
; AVX1-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0],xmm6[1],xmm4[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm9[4],xmm8[5],xmm9[5],xmm8[6],xmm9[6],xmm8[7],xmm9[7]
; AVX1-ONLY-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm6[0,1,2,2,4,5,6,7]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,1,2,1]
; AVX1-ONLY-NEXT:    vpshufd {{.*#+}} xmm8 = xmm5[2,2,3,3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1],xmm8[2,3],xmm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm6, %ymm4
; AVX1-ONLY-NEXT:    vandnps %ymm3, %ymm14, %ymm3
; AVX1-ONLY-NEXT:    vandps %ymm4, %ymm14, %ymm4
; AVX1-ONLY-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 736(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 544(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 512(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 784(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 768(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 880(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 864(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 816(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 800(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 848(%rax)
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 832(%rax)
; AVX1-ONLY-NEXT:    addq $1496, %rsp # imm = 0x5D8
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i16_stride7_vf64:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $1688, %rsp # imm = 0x698
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa 64(%r8), %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %ymm3
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%r9), %ymm5
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%r9), %ymm8
; AVX2-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rax), %ymm9
; AVX2-SLOW-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rax), %ymm7
; AVX2-SLOW-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rax), %ymm6
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,3,u,u,u,4,u]
; AVX2-SLOW-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, %ymm11
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,1,0,3,4,5,4,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm1[0,1,2,3,4,4,7,7,8,9,10,11,12,12,15,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = [u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [3,u,u,3,u,u,u,4]
; AVX2-SLOW-NEXT:    vpermd %ymm3, %ymm11, %ymm2
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm8[0,1,0,3,4,5,4,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm3[0,1,2,3,4,4,7,7,8,9,10,11,12,12,15,15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vpermd %ymm4, %ymm11, %ymm3
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm5[0,1,0,3,4,5,4,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,4,4,7,7,8,9,10,11,12,12,15,15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vpermd %ymm9, %ymm10, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm0, %ymm1, %ymm5
; AVX2-SLOW-NEXT:    vpermd %ymm7, %ymm10, %ymm0
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm2, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vpermd %ymm6, %ymm10, %ymm0
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm2[0,0,3,3,4,5,6,7,8,8,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [3,u,u,u,4,u,u,4]
; AVX2-SLOW-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, %ymm7
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, %ymm6
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm3
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm3 = ymm3[0,0,0,0,4,5,6,7,8,8,8,8,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm3[0,1,2,3,7,7,7,7,8,9,10,11,15,15,15,15]
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,3,u,u,u,4,u,u]
; AVX2-SLOW-NEXT:    vpermd %ymm4, %ymm8, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, %ymm9
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm4, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, %ymm10
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm2, %ymm5, %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm2[0,0,3,3,4,5,6,7,8,8,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermd %ymm4, %ymm7, %ymm4
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm4, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm4[0,0,0,0,4,5,6,7,8,8,8,8,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,7,7,7,7,8,9,10,11,15,15,15,15]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm5
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermd %ymm5, %ymm9, %ymm5
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm5, %ymm4, %ymm4
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm2, %ymm4, %ymm2
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rsi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm1[0,0,3,3,4,5,6,7,8,8,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermd %ymm2, %ymm7, %ymm2
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm2, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa 64(%rcx), %ymm2
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm2[0,0,0,0,4,5,6,7,8,8,8,8,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm2[0,1,2,3,7,7,7,7,8,9,10,11,15,15,15,15]
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdx), %ymm4
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermd %ymm4, %ymm9, %ymm4
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm4, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 96(%rsi), %ymm1
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm0 = ymm1[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, %ymm3
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm2
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, %ymm5
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rcx), %ymm2
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm2[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, %ymm4
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdx), %ymm6
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm6[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7,8,9],ymm1[10],ymm2[11,12],ymm1[13],ymm2[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 96(%r8), %ymm2
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm2[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 96(%r9), %ymm2
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm2[1,1,2,2,4,5,6,7,9,9,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, %ymm8
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 96(%rax), %ymm2
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm2[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, %ymm9
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm6[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm3[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm5[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm7[1,2,2,3,5,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm8[2,1,2,3,6,5,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm1[0,0,3,3,4,5,6,7,8,8,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm9[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm3[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm5[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm4[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm6[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpbroadcastd 124(%r8), %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm8[0,1,2,3,5,5,7,6,8,9,10,11,13,13,15,14]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm9[2,3,3,3,6,7,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-SLOW-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, %xmm3
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,0,1,1]
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, (%rsp) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[0,1,1,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm13
; AVX2-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm11
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm11[0],xmm2[0],xmm11[1],xmm2[1],xmm11[2],xmm2[2],xmm11[3],xmm2[3]
; AVX2-SLOW-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,1,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rsi), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-SLOW-NEXT:    vmovdqa 64(%rcx), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm9
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm9[0],xmm2[0],xmm9[1],xmm2[1],xmm9[2],xmm2[2],xmm9[3],xmm2[3]
; AVX2-SLOW-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,1,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 96(%rsi), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-SLOW-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-SLOW-NEXT:    vmovdqa 96(%rcx), %xmm5
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdx), %xmm8
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm8[0],xmm5[0],xmm8[1],xmm5[1],xmm8[2],xmm5[2],xmm8[3],xmm5[3]
; AVX2-SLOW-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,1,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,1,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,0,1]
; AVX2-SLOW-NEXT:    vpbroadcastd (%rax), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%r8), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm0[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,1,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,0,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 32(%rax), %ymm3
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm2, %ymm3, %ymm7
; AVX2-SLOW-NEXT:    vmovdqa 64(%r9), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%r8), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm3[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,1,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,0,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 64(%rax), %ymm12
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm2, %ymm12, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 96(%r9), %xmm10
; AVX2-SLOW-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 96(%r8), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm10[0],xmm2[1],xmm10[1],xmm2[2],xmm10[2],xmm2[3],xmm10[3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm15 = xmm2[0,1,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm15[0,1,1,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,0,0,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 96(%rax), %ymm14
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm15, %ymm14, %ymm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm13, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm1 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm4, %ymm6, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpshufd $165, (%rsp), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2,3],xmm0[4],xmm1[5,6],xmm0[7]
; AVX2-SLOW-NEXT:    vpshuflw $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = mem[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm12[1,1,2,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm6[0,1],xmm1[2],xmm6[3,4],xmm1[5],xmm6[6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm0[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm6, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm11[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm6[0],xmm1[1],xmm6[2,3],xmm1[4],xmm6[5,6],xmm1[7]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm13[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm10[1,1,2,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm6 = xmm14[0,1],xmm6[2],xmm14[3,4],xmm6[5],xmm14[6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,0,2,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm6, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm9[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm14[0],xmm1[1],xmm14[2,3],xmm1[4],xmm14[5,6],xmm1[7]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm11[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm14 = xmm14[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm7[1,1,2,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm14 = xmm15[0,1],xmm14[2],xmm15[3,4],xmm14[5],xmm15[6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,0,2,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm14, %ymm1
; AVX2-SLOW-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm8[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm14[0],xmm4[1],xmm14[2,3],xmm4[4],xmm14[5,6],xmm4[7]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm14 = xmm9[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm14 = xmm14[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm15 = xmm6[1,1,2,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm14 = xmm15[0,1],xmm14[2],xmm15[3,4],xmm14[5],xmm15[6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,1,1]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,0,2,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm4, %ymm14, %ymm0
; AVX2-SLOW-NEXT:    vpshufhw $180, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm4 = mem[0,1,2,3,4,5,7,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,1,3]
; AVX2-SLOW-NEXT:    vpbroadcastd 4(%rax), %ymm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm4, %ymm8, %ymm4
; AVX2-SLOW-NEXT:    vpshufhw $180, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm5 = mem[0,1,2,3,4,5,7,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,1,3]
; AVX2-SLOW-NEXT:    vpbroadcastd 36(%rax), %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm5, %ymm8, %ymm5
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,7,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-SLOW-NEXT:    vpbroadcastd 68(%rax), %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm3, %ymm8, %ymm3
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,7,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,2,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,1,3]
; AVX2-SLOW-NEXT:    vpbroadcastd 100(%rax), %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm2, %ymm8, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm1, %ymm3, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rsp), %xmm0 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm0 = xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm12[4],xmm1[5],xmm12[5],xmm1[6],xmm12[6],xmm1[7],xmm12[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,4]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm1 = xmm1[4],mem[4],xmm1[5],mem[5],xmm1[6],mem[6],xmm1[7],mem[7]
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm13[4],xmm10[4],xmm13[5],xmm10[5],xmm13[6],xmm10[6],xmm13[7],xmm10[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[2,1,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,5,4]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm2, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm2 = xmm2[4],mem[4],xmm2[5],mem[5],xmm2[6],mem[6],xmm2[7],mem[7]
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm11[4],xmm7[4],xmm11[5],xmm7[5],xmm11[6],xmm7[6],xmm11[7],xmm7[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,2,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[2,1,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,5,4]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,1,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm4, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm4 = xmm4[4],mem[4],xmm4[5],mem[5],xmm4[6],mem[6],xmm4[7],mem[7]
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm9[4],xmm6[4],xmm9[5],xmm6[5],xmm9[6],xmm6[6],xmm9[7],xmm6[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[0,2,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[2,1,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5,5,4]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,1,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm4 = xmm4[4],mem[4],xmm4[5],mem[5],xmm4[6],mem[6],xmm4[7],mem[7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm8 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,1,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 8(%rax), %ymm5
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm5 = xmm5[4],mem[4],xmm5[5],mem[5],xmm5[6],mem[6],xmm5[7],mem[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm5, %xmm5
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,1,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 40(%rax), %ymm7
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm5, %ymm7, %ymm5
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm7 = xmm7[4],mem[4],xmm7[5],mem[5],xmm7[6],mem[6],xmm7[7],mem[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm7, %xmm7
; AVX2-SLOW-NEXT:    vmovdqa %xmm8, %xmm9
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,0,1,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 72(%rax), %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm7, %ymm8, %ymm7
; AVX2-SLOW-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm8 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm8 = xmm8[4],mem[4],xmm8[5],mem[5],xmm8[6],mem[6],xmm8[7],mem[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm8, %xmm8
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,0,1,1]
; AVX2-SLOW-NEXT:    vpbroadcastd 104(%rax), %ymm9
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm8, %ymm9, %ymm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm4, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm5, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm7, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, %ymm6, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,u,u,u,4,u,u,4]
; AVX2-SLOW-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm1 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vpshufd $236, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm2 = mem[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm2[0,0,3,3,4,5,6,7,8,8,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,3,u,u,u,4,u,u]
; AVX2-SLOW-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vpshuflw $0, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm3 = mem[0,0,0,0,4,5,6,7,8,8,8,8,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm3[0,1,2,3,7,7,7,7,8,9,10,11,15,15,15,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,3,u,u,u,4,u]
; AVX2-SLOW-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vpshufd $196, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm2 = mem[0,1,0,3,4,5,4,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm2[0,1,2,3,4,4,7,7,8,9,10,11,12,12,15,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,u,u,3,u,u,u,4]
; AVX2-SLOW-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm3, %ymm1, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw $249, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm2 = mem[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm3 = mem[1,1,1,1,5,5,5,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7,8,9],ymm3[10],ymm2[11,12],ymm3[13],ymm2[14,15]
; AVX2-SLOW-NEXT:    vpshuflw $233, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm3 = mem[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm4 = mem[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0,1],ymm3[2],ymm4[3,4],ymm3[5],ymm4[6,7,8,9],ymm3[10],ymm4[11,12],ymm3[13],ymm4[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm2, %ymm3, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw $249, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm3 = mem[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm4 = mem[1,1,1,1,5,5,5,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7,8,9],ymm4[10],ymm3[11,12],ymm4[13],ymm3[14,15]
; AVX2-SLOW-NEXT:    vpshuflw $233, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm4 = mem[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm5 = mem[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7,8,9],ymm4[10],ymm5[11,12],ymm4[13],ymm5[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,1,3,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm3, %ymm4, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw $249, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm4 = mem[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm5 = mem[1,1,1,1,5,5,5,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7,8,9],ymm5[10],ymm4[11,12],ymm5[13],ymm4[14,15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm5 = ymm2[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm1[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0,1],ymm5[2],ymm6[3,4],ymm5[5],ymm6[6,7,8,9],ymm5[10],ymm6[11,12],ymm5[13],ymm6[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,1,3,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm4, %ymm5, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm5 = ymm0[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm5[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm15[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1,2],ymm6[3],ymm5[4,5],ymm6[6],ymm5[7,8,9,10],ymm6[11],ymm5[12,13],ymm6[14],ymm5[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,3,3]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm10[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm7 = [u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm6 = ymm11[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm4[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0,1,2],ymm8[3],ymm6[4,5],ymm8[6],ymm6[7,8,9,10],ymm8[11],ymm6[12,13],ymm8[14],ymm6[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,3,3]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm12[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm6, %ymm8, %ymm6
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm8 = ymm3[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[0,0,0,0,4,4,4,4]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm13[0,0,2,1,4,4,6,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm8[0,1,2],ymm9[3],ymm8[4,5],ymm9[6],ymm8[7,8,9,10],ymm9[11],ymm8[12,13],ymm9[14],ymm8[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,2,3,3]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm14[0,1,1,3,4,5,5,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm8, %ymm9, %ymm7
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27,22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27]
; AVX2-SLOW-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %ymm8, %ymm0, %ymm5
; AVX2-SLOW-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm6 = mem[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm6[2],ymm5[3,4],ymm6[5],ymm5[6,7,8,9],ymm6[10],ymm5[11,12],ymm6[13],ymm5[14,15]
; AVX2-SLOW-NEXT:    vpshufhw $225, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm6 = mem[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm7 = mem[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0],ymm6[1],ymm7[2,3],ymm6[4],ymm7[5,6,7,8],ymm6[9],ymm7[10,11],ymm6[12],ymm7[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm5, %ymm6, %ymm5
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %ymm8, %ymm5, %ymm6
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, %ymm9
; AVX2-SLOW-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm7 = mem[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0,1],ymm7[2],ymm6[3,4],ymm7[5],ymm6[6,7,8,9],ymm7[10],ymm6[11,12],ymm7[13],ymm6[14,15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm7 = ymm5[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm8 = mem[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0],ymm7[1],ymm8[2,3],ymm7[4],ymm8[5,6,7,8],ymm7[9],ymm8[10,11],ymm7[12],ymm8[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm0, %ymm6, %ymm7, %ymm6
; AVX2-SLOW-NEXT:    vpshufb %ymm9, %ymm2, %ymm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm1[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0,1],ymm8[2],ymm7[3,4],ymm8[5],ymm7[6,7,8,9],ymm8[10],ymm7[11,12],ymm8[13],ymm7[14,15]
; AVX2-SLOW-NEXT:    vpshufhw $225, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm8 = mem[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm0[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2,3],ymm8[4],ymm9[5,6,7,8],ymm8[9],ymm9[10,11],ymm8[12],ymm9[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,2,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm1, %ymm7, %ymm8, %ymm7
; AVX2-SLOW-NEXT:    vpshuflw $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm8 = mem[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm8 = ymm8[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm15[1,2,2,3,5,6,6,7]
; AVX2-SLOW-NEXT:    vmovdqa %ymm15, %ymm2
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0,1],ymm8[2],ymm9[3,4],ymm8[5],ymm9[6,7,8,9],ymm8[10],ymm9[11,12],ymm8[13],ymm9[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,3,2]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm10[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,3,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm11[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm9[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm4[1,2,2,3,5,6,6,7]
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, %ymm1
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm11[0,1],ymm9[2],ymm11[3,4],ymm9[5],ymm11[6,7,8,9],ymm9[10],ymm11[11,12],ymm9[13],ymm11[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,3,2]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm12[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,1,3,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm9, %ymm11, %ymm9
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm11 = ymm3[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm11[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm13[1,2,2,3,5,6,6,7]
; AVX2-SLOW-NEXT:    vmovdqa %ymm13, %ymm15
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm12[0,1],ymm11[2],ymm12[3,4],ymm11[5],ymm12[6,7,8,9],ymm11[10],ymm12[11,12],ymm11[13],ymm12[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,1,3,2]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm14[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vmovdqa %ymm14, %ymm3
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,1,3,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm11, %ymm12, %ymm10
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm6, %ymm9, %ymm6
; AVX2-SLOW-NEXT:    vpblendvb %ymm11, %ymm7, %ymm10, %ymm7
; AVX2-SLOW-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm8 = mem[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpshufhw $235, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm9 = mem[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm8[0,1,2],ymm9[3],ymm8[4,5],ymm9[6],ymm8[7,8,9,10],ymm9[11],ymm8[12,13],ymm9[14],ymm8[15]
; AVX2-SLOW-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm9 = mem[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpshufhw $235, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = mem[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm10[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm9[0],ymm10[1],ymm9[2,3],ymm10[4],ymm9[5,6,7,8],ymm10[9],ymm9[10,11],ymm10[12],ymm9[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm8, %ymm9, %ymm8
; AVX2-SLOW-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm9 = mem[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm10 = ymm5[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm10[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm9[0,1,2],ymm10[3],ymm9[4,5],ymm10[6],ymm9[7,8,9,10],ymm10[11],ymm9[12,13],ymm10[14],ymm9[15]
; AVX2-SLOW-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = mem[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpshufhw $235, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm11 = mem[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm11[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm10[0],ymm11[1],ymm10[2,3],ymm11[4],ymm10[5,6,7,8],ymm11[9],ymm10[10,11],ymm11[12],ymm10[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm9, %ymm10, %ymm9
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm0[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpshufhw $235, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm11 = mem[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm11[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm10[0,1,2],ymm11[3],ymm10[4,5],ymm11[6],ymm10[7,8,9,10],ymm11[11],ymm10[12,13],ymm11[14],ymm10[15]
; AVX2-SLOW-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm11 = mem[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpshufhw $235, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm12 = mem[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,2,2,2,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm11[0],ymm12[1],ymm11[2,3],ymm12[4],ymm11[5,6,7,8],ymm12[9],ymm11[10,11],ymm12[12],ymm11[13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,3,3]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm10, %ymm11, %ymm10
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm2[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpshufhw $249, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm12 = mem[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[2,2,2,3,6,6,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm12[0,1],ymm11[2],ymm12[3,4],ymm11[5],ymm12[6,7,8,9],ymm11[10],ymm12[11,12],ymm11[13],ymm12[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-SLOW-NEXT:    vpshufd $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm12 = mem[2,3,3,3,6,7,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,1,3,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm1[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpshufhw $249, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm14 = mem[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[2,2,2,3,6,6,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm14[0,1],ymm12[2],ymm14[3,4],ymm12[5],ymm14[6,7,8,9],ymm12[10],ymm14[11,12],ymm12[13],ymm14[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,2,2,3]
; AVX2-SLOW-NEXT:    vpshufd $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm14 = mem[2,3,3,3,6,7,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,3,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm12, %ymm14, %ymm12
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm15[3,3,3,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpshufhw $249, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm15 = mem[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm15[2,2,2,3,6,6,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm14 = ymm15[0,1],ymm14[2],ymm15[3,4],ymm14[5],ymm15[6,7,8,9],ymm14[10],ymm15[11,12],ymm14[13],ymm15[14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm3[2,3,3,3,6,7,7,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,1,3,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm13, %ymm14, %ymm15, %ymm13
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm14 = [0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm8, %ymm11, %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm9, %ymm12, %ymm9
; AVX2-SLOW-NEXT:    vpblendvb %ymm14, %ymm10, %ymm13, %ymm10
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm10, 640(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm7, 608(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm9, 416(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, 384(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, 192(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-SLOW-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-SLOW-NEXT:    addq $1688, %rsp # imm = 0x698
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i16_stride7_vf64:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $1256, %rsp # imm = 0x4E8
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rdx), %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rcx), %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%r8), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [3,u,u,u,4,u,u,4]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm5, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,1,0,1,14,15,14,15,8,9,10,11,12,13,14,15,16,17,16,17,30,31,30,31,24,25,26,27,28,29,30,31]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [u,3,u,u,u,4,u,u]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm4[0,1,0,1,0,1,0,1,14,15,14,15,14,15,14,15,16,17,16,17,16,17,16,17,30,31,30,31,30,31,30,31]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [u,u,3,u,u,u,4,u]
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa 96(%r9), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5,6,7,0,1,0,1,14,15,14,15,16,17,18,19,20,21,22,23,16,17,16,17,30,31,30,31]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa 96(%rax), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [3,u,u,3,u,u,u,4]
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm3
; AVX2-FAST-NEXT:    vmovdqa (%r9), %ymm2
; AVX2-FAST-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21]
; AVX2-FAST-NEXT:    vpshufb %ymm1, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm2, %ymm10
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm3[0,0,2,1,4,4,6,5]
; AVX2-FAST-NEXT:    vmovdqa %ymm3, %ymm11
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1,2],ymm2[3],ymm0[4,5],ymm2[6],ymm0[7,8,9,10],ymm2[11],ymm0[12,13],ymm2[14],ymm0[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,3,3]
; AVX2-FAST-NEXT:    vmovdqa (%rax), %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,4,5,5,7]
; AVX2-FAST-NEXT:    vpermd %ymm4, %ymm2, %ymm3
; AVX2-FAST-NEXT:    vmovdqa %ymm4, %ymm12
; AVX2-FAST-NEXT:    vmovdqa %ymm2, %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %ymm6
; AVX2-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%r9), %ymm4
; AVX2-FAST-NEXT:    vpshufb %ymm1, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm4, %ymm7
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm6[0,0,2,1,4,4,6,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1,2],ymm4[3],ymm0[4,5],ymm4[6],ymm0[7,8,9,10],ymm4[11],ymm0[12,13],ymm4[14],ymm0[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,3,3]
; AVX2-FAST-NEXT:    vmovdqa 32(%rax), %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermd %ymm4, %ymm5, %ymm4
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm4, %ymm6
; AVX2-FAST-NEXT:    vmovdqa 64(%r9), %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa 64(%r8), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,2,1,4,4,6,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7,8,9,10],ymm1[11],ymm0[12,13],ymm1[14],ymm0[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,3,3]
; AVX2-FAST-NEXT:    vmovdqa 64(%rax), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm5, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm4
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm5
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX2-FAST-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa %ymm0, %ymm8
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm5[1,1,1,1,5,5,5,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4],ymm2[5],ymm1[6,7,8,9],ymm2[10],ymm1[11,12],ymm2[13],ymm1[14,15]
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm15
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm13
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm2 = ymm13[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm15[0,1,1,3,4,5,5,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm5[0,1],ymm2[2],ymm5[3,4],ymm2[5],ymm5[6,7,8,9],ymm2[10],ymm5[11,12],ymm2[13],ymm5[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,1,3,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm0, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa %ymm0, %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm1, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm0[1,1,1,1,5,5,5,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm3[2],ymm1[3,4],ymm3[5],ymm1[6,7,8,9],ymm3[10],ymm1[11,12],ymm3[13],ymm1[14,15]
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm3 = ymm3[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm0[0,1,1,3,4,5,5,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm9[0,1],ymm3[2],ymm9[3,4],ymm3[5],ymm9[6,7,8,9],ymm3[10],ymm9[11,12],ymm3[13],ymm9[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,1,3,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm3, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm1, %ymm6, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm0[1,1,1,1,5,5,5,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm9[2],ymm1[3,4],ymm9[5],ymm1[6,7,8,9],ymm9[10],ymm1[11,12],ymm9[13],ymm1[14,15]
; AVX2-FAST-NEXT:    vmovdqa 64(%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rcx), %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm3[0,1,1,3,4,5,5,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm14[0,1],ymm0[2],ymm14[3,4],ymm0[5],ymm14[6,7,8,9],ymm0[10],ymm14[11,12],ymm0[13],ymm14[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,2]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,u,u,u,u,u,u,u,u,8,9,u,u,u,u,u,u,u,u,22,23,u,u,u,u,24,25,u,u,u,u]
; AVX2-FAST-NEXT:    vmovdqa %ymm10, %ymm5
; AVX2-FAST-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm10, %ymm1
; AVX2-FAST-NEXT:    vmovdqa %ymm11, %ymm6
; AVX2-FAST-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm11[1,2,2,3,5,6,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7,8,9],ymm1[10],ymm2[11,12],ymm1[13],ymm2[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [4,5,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vmovdqa %ymm12, %ymm8
; AVX2-FAST-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermd %ymm12, %ymm9, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm1, %ymm2, %ymm12
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm7, %ymm2
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm3[1,2,2,3,5,6,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm14[0,1],ymm2[2],ymm14[3,4],ymm2[5],ymm14[6,7,8,9],ymm2[10],ymm14[11,12],ymm2[13],ymm14[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,1,3,2]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-NEXT:    vpermd %ymm7, %ymm9, %ymm14
; AVX2-FAST-NEXT:    vmovdqa %ymm9, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm2, %ymm14, %ymm2
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm10, %ymm0
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm11[1,2,2,3,5,6,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm14[0,1],ymm0[2],ymm14[3,4],ymm0[5],ymm14[6,7,8,9],ymm0[10],ymm14[11,12],ymm0[13],ymm14[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,2]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm1, %ymm14
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm0, %ymm14, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27,22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27]
; AVX2-FAST-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpshufb %ymm1, %ymm13, %ymm4
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm13
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm15[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1],ymm14[2],ymm4[3,4],ymm14[5],ymm4[6,7,8,9],ymm14[10],ymm4[11,12],ymm14[13],ymm4[14,15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm1, %ymm0, %ymm14
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm15 = mem[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2,3],ymm14[4],ymm15[5,6,7,8],ymm14[9],ymm15[10,11],ymm14[12],ymm15[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm4, %ymm14, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = [255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm4, %ymm12, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm13, %ymm12, %ymm1
; AVX2-FAST-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm4 = mem[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm4[2],ymm1[3,4],ymm4[5],ymm1[6,7,8,9],ymm4[10],ymm1[11,12],ymm4[13],ymm1[14,15]
; AVX2-FAST-NEXT:    vmovdqu (%rsp), %ymm4 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm15 = mem[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm15[0],ymm4[1],ymm15[2,3],ymm4[4],ymm15[5,6,7,8],ymm4[9],ymm15[10,11],ymm4[12],ymm15[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm13, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm13[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4],ymm2[5],ymm1[6,7,8,9],ymm2[10],ymm1[11,12],ymm2[13],ymm1[14,15]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm4 = mem[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2,3],ymm2[4],ymm4[5,6,7,8],ymm2[9],ymm4[10,11],ymm2[12],ymm4[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm15, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [26,27,28,29,26,27,28,29,26,27,28,29,30,31,30,31,26,27,28,29,26,27,28,29,26,27,28,29,30,31,30,31]
; AVX2-FAST-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpshufb %ymm2, %ymm5, %ymm0
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm6[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [6,7,3,3,7,7,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm8, %ymm5, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm0, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm3[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm14[2],ymm0[3,4],ymm14[5],ymm0[6,7,8,9],ymm14[10],ymm0[11,12],ymm14[13],ymm0[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-NEXT:    vpermd %ymm7, %ymm5, %ymm14
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm0, %ymm14, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm2, %ymm10, %ymm2
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm11[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm14[2],ymm2[3,4],ymm14[5],ymm2[6,7,8,9],ymm14[10],ymm2[11,12],ymm14[13],ymm2[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,2,3]
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm5, %ymm14
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm2, %ymm14, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm5, %ymm3, %ymm4
; AVX2-FAST-NEXT:    vmovdqa %ymm5, %ymm6
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm8[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm14[0,1,2],ymm4[3],ymm14[4,5],ymm4[6],ymm14[7,8,9,10],ymm4[11],ymm14[12,13],ymm4[14],ymm14[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm9, %ymm2, %ymm14
; AVX2-FAST-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm15 = mem[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm14 = ymm15[0],ymm14[1],ymm15[2,3],ymm14[4],ymm15[5,6,7,8],ymm14[9],ymm15[10,11],ymm14[12],ymm15[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,1,3,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm4, %ymm14, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm4, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu (%rsp), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm6, %ymm5, %ymm1
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm14[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm4[0,1,2],ymm1[3],ymm4[4,5],ymm1[6],ymm4[7,8,9,10],ymm1[11],ymm4[12,13],ymm1[14],ymm4[15]
; AVX2-FAST-NEXT:    vpshufb %ymm9, %ymm12, %ymm4
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm15 = ymm11[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm15[0],ymm4[1],ymm15[2,3],ymm4[4],ymm15[5,6,7,8],ymm4[9],ymm15[10,11],ymm4[12],ymm15[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,2,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm6, %ymm7, %ymm0
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm6[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm9, %ymm15, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm13[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm4[0],ymm1[1],ymm4[2,3],ymm1[4],ymm4[5,6,7,8],ymm1[9],ymm4[10,11],ymm1[12],ymm4[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [3,u,u,u,4,u,u,4]
; AVX2-FAST-NEXT:    vpermd %ymm8, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,1,0,1,14,15,14,15,8,9,10,11,12,13,14,15,16,17,16,17,30,31,30,31,24,25,26,27,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm3, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm14, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa %ymm2, %ymm4
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm5, %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vpermd %ymm6, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm7, %ymm3
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,3,u,u,u,4,u,u]
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [0,1,0,1,0,1,0,1,14,15,14,15,14,15,14,15,16,17,16,17,16,17,16,17,30,31,30,31,30,31,30,31]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vpermd %ymm11, %ymm5, %ymm4
; AVX2-FAST-NEXT:    vmovdqa %ymm5, %ymm6
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm12, %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm4, %ymm5, %ymm4
; AVX2-FAST-NEXT:    vpermd %ymm13, %ymm6, %ymm5
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm15, %ymm6
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm5, %ymm6, %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm0, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm2, %ymm5, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = [u,u,3,u,u,u,4,u]
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,1,2,3,4,5,6,7,0,1,0,1,14,15,14,15,16,17,18,19,20,21,22,23,16,17,16,17,30,31,30,31]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqa %ymm6, %ymm7
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm6, %ymm6
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm4, %ymm6, %ymm4
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm6 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm6, %ymm7, %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [3,u,u,3,u,u,u,4]
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm6 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm3, %ymm6, %ymm3
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm6 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm4, %ymm6, %ymm4
; AVX2-FAST-NEXT:    vpermd {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm6 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = [0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm0, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm1, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm2, %ymm5, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm3[1,1,1,1,5,5,5,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm6[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm4[0,1,1,3,4,5,5,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7,8,9],ymm1[10],ymm2[11,12],ymm1[13],ymm2[14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [4,4,2,1,6,5,6,5]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-NEXT:    vpermd %ymm7, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm8[1,1,2,2,4,5,6,7,9,9,10,10,12,13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,4,5,4,5,5,7]
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm4[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm3[2,2,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [5,6,2,3,6,7,5,6]
; AVX2-FAST-NEXT:    vpermd %ymm7, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25,22,23,22,23,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [4,5,2,2,6,6,6,6]
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm3[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm6[14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm4[3,3,3,3,7,7,7,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpbroadcastd 124(%r8), %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm8[0,1,2,3,5,5,7,6,8,9,10,11,13,13,15,14]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [6,7,3,3,7,7,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm9, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FAST-NEXT:    vmovdqa %xmm1, %xmm15
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm1, %xmm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[0,0,1,1]
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm0
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FAST-NEXT:    vmovdqa %xmm0, %xmm9
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [0,1,2,3,0,1,2,3,6,7,4,5,6,7,4,5]
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm1[0,1,1,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm2, %ymm3, %ymm10
; AVX2-FAST-NEXT:    vmovdqa 32(%rsi), %xmm3
; AVX2-FAST-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-FAST-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-FAST-NEXT:    vmovdqa 32(%rcx), %xmm5
; AVX2-FAST-NEXT:    vmovdqa 32(%rdx), %xmm3
; AVX2-FAST-NEXT:    vmovdqa %xmm3, (%rsp) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; AVX2-FAST-NEXT:    vmovdqa %xmm5, %xmm13
; AVX2-FAST-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rsi), %xmm2
; AVX2-FAST-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX2-FAST-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-FAST-NEXT:    vmovdqa 64(%rcx), %xmm3
; AVX2-FAST-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%rdx), %xmm8
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm8[0],xmm3[0],xmm8[1],xmm3[1],xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; AVX2-FAST-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rcx), %xmm2
; AVX2-FAST-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rdx), %xmm3
; AVX2-FAST-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX2-FAST-NEXT:    vmovdqa 96(%rsi), %xmm3
; AVX2-FAST-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %xmm2
; AVX2-FAST-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm7
; AVX2-FAST-NEXT:    vmovdqa (%r9), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,2,3,6,7,4,5,6,7,4,5,12,13,14,15]
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm0, %xmm1
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,0,1]
; AVX2-FAST-NEXT:    vpbroadcastd (%rax), %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm1, %ymm3, %ymm6
; AVX2-FAST-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 32(%r8), %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm12 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm12, %xmm3
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,0,1]
; AVX2-FAST-NEXT:    vpbroadcastd 32(%rax), %ymm5
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm3, %ymm5, %ymm1
; AVX2-FAST-NEXT:    vmovdqa 64(%r9), %xmm0
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 64(%r8), %xmm3
; AVX2-FAST-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm5, %xmm3
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,0,1]
; AVX2-FAST-NEXT:    vpbroadcastd 64(%rax), %ymm11
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm3, %ymm11, %ymm0
; AVX2-FAST-NEXT:    vmovdqa 96(%r9), %xmm11
; AVX2-FAST-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 96(%r8), %xmm3
; AVX2-FAST-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm3[0],xmm11[0],xmm3[1],xmm11[1],xmm3[2],xmm11[2],xmm3[3],xmm11[3]
; AVX2-FAST-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,0,1]
; AVX2-FAST-NEXT:    vpbroadcastd 96(%rax), %ymm14
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm2, %ymm14, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm10, %ymm6, %ymm6
; AVX2-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm4, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm4, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm7, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm9, %xmm0
; AVX2-FAST-NEXT:    vpshufd $165, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm2 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm2[0],xmm0[1],xmm2[2,3],xmm0[4],xmm2[5,6],xmm0[7]
; AVX2-FAST-NEXT:    vpbroadcastd {{.*#+}} xmm6 = [6,7,8,9,6,7,8,9,6,7,8,9,6,7,8,9]
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm15, %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm15[1,1,2,3]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1],xmm2[2],xmm4[3,4],xmm2[5],xmm4[6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm13, %xmm0
; AVX2-FAST-NEXT:    vpshufd $165, (%rsp), %xmm2 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm2 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm2[0],xmm0[1],xmm2[2,3],xmm0[4],xmm2[5,6],xmm0[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm13, %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm14 = xmm10[1,1,2,3]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm14[0,1],xmm2[2],xmm14[3,4],xmm2[5],xmm14[6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm0, %ymm2, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm14 = xmm8[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm14[0],xmm0[1],xmm14[2,3],xmm0[4],xmm14[5,6],xmm0[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm8, %xmm14
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm11 = xmm9[1,1,2,3]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1],xmm14[2],xmm11[3,4],xmm14[5],xmm11[6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,0,2,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm0, %ymm11, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm0, %xmm1
; AVX2-FAST-NEXT:    vpshufd $165, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm11 = mem[1,1,2,2]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm11[0],xmm1[1],xmm11[2,3],xmm1[4],xmm11[5,6],xmm1[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm8, %xmm6
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm11 = xmm0[1,1,2,3]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm6 = xmm11[0,1],xmm6[2],xmm11[3,4],xmm6[5],xmm11[6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,0,2,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm1, %ymm6, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,2,3,8,9,10,11,14,15,12,13,14,15,12,13]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm7, %xmm7
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,1,3]
; AVX2-FAST-NEXT:    vpbroadcastd 4(%rax), %ymm11
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm7, %ymm11, %ymm7
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm12, %xmm11
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,1,1,3]
; AVX2-FAST-NEXT:    vpbroadcastd 36(%rax), %ymm12
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm11, %ymm12, %ymm11
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm5, %xmm5
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,1,3]
; AVX2-FAST-NEXT:    vpbroadcastd 68(%rax), %ymm12
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm5, %ymm12, %ymm5
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FAST-NEXT:    vpbroadcastd 100(%rax), %ymm6
; AVX2-FAST-NEXT:    vpblendvb %ymm14, %ymm3, %ymm6, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm4, %ymm11, %ymm11
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm2, %ymm5, %ymm12
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm1, %ymm3, %ymm14
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm15[4],xmm1[5],xmm15[5],xmm1[6],xmm15[6],xmm1[7],xmm15[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm2 = xmm2[4],mem[4],xmm2[5],mem[5],xmm2[6],mem[6],xmm2[7],mem[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = [4,5,2,3,4,5,6,7,8,9,10,11,10,11,8,9]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,3]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,2,3,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm13[4],xmm10[4],xmm13[5],xmm10[5],xmm13[6],xmm10[6],xmm13[7],xmm10[7]
; AVX2-FAST-NEXT:    vmovdqa (%rsp), %xmm3 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm3 = xmm3[4],mem[4],xmm3[5],mem[5],xmm3[6],mem[6],xmm3[7],mem[7]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,3]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,2,3,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm3[4],xmm9[4],xmm3[5],xmm9[5],xmm3[6],xmm9[6],xmm3[7],xmm9[7]
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm6 = xmm6[4],mem[4],xmm6[5],mem[5],xmm6[6],mem[6],xmm6[7],mem[7]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,3]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm6[0,2,3,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,0,2,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm3, %ymm6, %ymm3
; AVX2-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm8[4],xmm0[4],xmm8[5],xmm0[5],xmm8[6],xmm0[6],xmm8[7],xmm0[7]
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm6, %xmm4
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm6 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm6 = xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,1,3]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm6[0,2,3,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,0,2,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm4, %ymm6, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm5 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm5 = xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm5, %xmm5
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,1,1]
; AVX2-FAST-NEXT:    vpbroadcastd 8(%rax), %ymm6
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm6 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm6 = xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm6, %xmm6
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,0,1,1]
; AVX2-FAST-NEXT:    vpbroadcastd 40(%rax), %ymm8
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm6, %ymm8, %ymm6
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm8 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm8 = xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm8, %xmm8
; AVX2-FAST-NEXT:    vmovdqa %xmm9, %xmm10
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,0,1,1]
; AVX2-FAST-NEXT:    vpbroadcastd 72(%rax), %ymm9
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm8, %ymm9, %ymm8
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm9 # 16-byte Folded Reload
; AVX2-FAST-NEXT:    # xmm9 = xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm9, %xmm9
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,0,1,1]
; AVX2-FAST-NEXT:    vpbroadcastd 104(%rax), %ymm10
; AVX2-FAST-NEXT:    vpblendvb %ymm7, %ymm9, %ymm10, %ymm7
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm6, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm8, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm7, %ymm4, %ymm4
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 544(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 320(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 96(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 640(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 608(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 576(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 416(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 384(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 352(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 192(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 160(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 128(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm5, 768(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm4, 736(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm14, 704(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, 512(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm12, 480(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, 288(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm11, 256(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FAST-NEXT:    addq $1256, %rsp # imm = 0x4E8
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i16_stride7_vf64:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $1544, %rsp # imm = 0x608
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rsi), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdx), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rcx), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r8), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm14 = [3,u,u,u,4,u,u,4]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm14, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [0,1,0,1,14,15,14,15,8,9,10,11,12,13,14,15,16,17,16,17,30,31,30,31,24,25,26,27,28,29,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm15, %ymm2, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm1, %ymm4, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,3,u,u,u,4,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm3, %ymm10, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [0,1,0,1,0,1,0,1,14,15,14,15,14,15,14,15,16,17,16,17,16,17,16,17,30,31,30,31,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm11, %ymm5, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm4, %ymm6, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = [u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm1, %ymm4, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,3,u,u,u,4,u]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm7, %ymm0, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm1, %ymm4, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r9), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm9 = [0,1,2,3,4,5,6,7,0,1,0,1,14,15,14,15,16,17,18,19,20,21,22,23,16,17,16,17,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm9, %ymm4, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm1, %ymm6, %ymm1
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rax), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = [3,u,u,3,u,u,u,4]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm6, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm1, %ymm7, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm14, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm15, %ymm3, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm1, %ymm7, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm1, %ymm14, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm15, %ymm0, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm14, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rsi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm15, %ymm0, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm8, %ymm14, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm10, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm11, %ymm2, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm8, %ymm14, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm2, %ymm10, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm11, %ymm0, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm14, %ymm15, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm0, %ymm10, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rcx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm11, %ymm0, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm10, %ymm11, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm3, %ymm8, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm7, %ymm14, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm1, %ymm10, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = [u,u,3,u,u,u,4,u]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm1, %ymm12, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm9, %ymm2, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u,u,u,u,u,u,u,255,255,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm8, %ymm10, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r9), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm2, %ymm12, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm12, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm9, %ymm1, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm10, %ymm12, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm1, %ymm2, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r9), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm9, %ymm1, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm12, %ymm9, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rax), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [3,u,u,3,u,u,u,4]
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm1, %ymm2, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm12 = [0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm8, %ymm11, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rax), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm1, %ymm2, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rax), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermd %ymm1, %ymm2, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm12, %ymm9, %ymm11, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm11 = [0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm3, %ymm8, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm7, %ymm10, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm11, %ymm0, %ymm9, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm0 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm3[1,1,1,1,5,5,5,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm5[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu (%rsp), %ymm8 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm7 = ymm8[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm7[0,1],ymm1[2],ymm7[3,4],ymm1[5],ymm7[6,7,8,9],ymm1[10],ymm7[11,12],ymm1[13],ymm7[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm10[0,0,2,1,4,4,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm4[1,1,2,2,4,5,6,7,9,9,10,10,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm6[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm0 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm8[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm9[10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm7 = ymm3[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm7[0],ymm1[1],ymm7[2,3],ymm1[4],ymm7[5,6,7,8],ymm1[9],ymm7[10,11],ymm1[12],ymm7[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm10[1,2,2,3,5,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25,22,23,22,23,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm6[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm0 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm3[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm5[14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm2 = ymm8[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 124(%r8), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u,255,255,255,255,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm4[0,1,2,3,5,5,7,6,8,9,10,11,13,13,15,14]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u,255,255,255,255,255,255,255,255,255,255,0,0,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm6[2,3,3,3,6,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm12[0],xmm1[1],xmm12[1],xmm1[2],xmm12[2],xmm1[3],xmm12[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm0 = [0,1,2,3,0,1,2,3,6,7,4,5,6,7,4,5]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm1[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rsi), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rcx), %xmm14
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdx), %xmm11
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm11[0],xmm14[0],xmm11[1],xmm14[1],xmm11[2],xmm14[2],xmm11[3],xmm14[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rsi), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rcx), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%rdx), %xmm10
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm10[0],xmm3[0],xmm10[1],xmm3[1],xmm10[2],xmm3[2],xmm10[3],xmm3[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rcx), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdx), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rsi), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%rdi), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm2, %ymm0, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,2,3,6,7,4,5,6,7,4,5,12,13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm9, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd (%rax), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm1, %ymm2, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%r8), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm8, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 32(%rax), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm2, %ymm3, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r9), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 64(%r8), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm3, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 64(%rax), %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm2, %ymm13, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r8), %xmm13
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 96(%r9), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm13[0],xmm2[0],xmm13[1],xmm2[1],xmm13[2],xmm2[2],xmm13[3],xmm2[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm4, %xmm2, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 96(%rax), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm4, %ymm15, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm7, %ymm4, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm12, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd $165, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm4 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm4[0],xmm0[1],xmm4[2,3],xmm0[4],xmm4[5,6],xmm0[7]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{.*#+}} xmm5 = [6,7,8,9,6,7,8,9,6,7,8,9,6,7,8,9]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsp), %xmm4 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpshufd $229, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm6 = mem[1,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm4 = xmm6[0,1],xmm4[2],xmm6[3,4],xmm4[5],xmm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm4, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm14, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm4 = xmm11[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm4[0],xmm0[1],xmm4[2,3],xmm0[4],xmm4[5,6],xmm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm15 = xmm14[1,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm4 = xmm15[0,1],xmm4[2],xmm15[3,4],xmm4[5],xmm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm4, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm15 = xmm10[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm15[0],xmm0[1],xmm15[2,3],xmm0[4],xmm15[5,6],xmm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm10, %xmm15
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm13 = xmm12[1,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm13 = xmm13[0,1],xmm15[2],xmm13[3,4],xmm15[5],xmm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm13, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm1, %xmm13, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm13 = xmm15[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm1 = xmm13[0],xmm1[1],xmm13[2,3],xmm1[4],xmm13[5,6],xmm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm11, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm13 = xmm10[1,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm5 = xmm13[0,1],xmm5[2],xmm13[3,4],xmm5[5],xmm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm1, %ymm5, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,2,3,8,9,10,11,14,15,12,13,14,15,12,13]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm9, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 4(%rax), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm7, %ymm9, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm8, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 36(%rax), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm8, %ymm9, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 68(%rax), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm3, %ymm9, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm5, %xmm2, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 100(%rax), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm2, %ymm5, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm6, %ymm7, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm4, %ymm8, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm0, %ymm3, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm5, %ymm1, %ymm2, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsp), %xmm0 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm0 = xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm1 = xmm1[4],mem[4],xmm1[5],mem[5],xmm1[6],mem[6],xmm1[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,5,2,3,4,5,6,7,8,9,10,11,10,11,8,9]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,2,3,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm4 = [u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm14[4],xmm1[5],xmm14[5],xmm1[6],xmm14[6],xmm1[7],xmm14[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm2 = xmm2[4],mem[4],xmm2[5],mem[5],xmm2[6],mem[6],xmm2[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,2,3,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm2[4],xmm12[4],xmm2[5],xmm12[5],xmm2[6],xmm12[6],xmm2[7],xmm12[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm5 = xmm5[4],mem[4],xmm5[5],mem[5],xmm5[6],mem[6],xmm5[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,2,3,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm2, %ymm5, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm3, %xmm5, %xmm3
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm5 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm5 = xmm15[4],mem[4],xmm15[5],mem[5],xmm15[6],mem[6],xmm15[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,3]
; AVX2-FAST-PERLANE-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,2,3,3,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm4, %ymm3, %ymm5, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm4 = xmm4[4],mem[4],xmm4[5],mem[5],xmm4[6],mem[6],xmm4[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} xmm8 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm4, %xmm4
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 8(%rax), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm6 = [255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm4, %ymm5, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm5 = xmm5[4],mem[4],xmm5[5],mem[5],xmm5[6],mem[6],xmm5[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm5, %xmm5
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 40(%rax), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm5, %ymm7, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm7 = xmm7[4],mem[4],xmm7[5],mem[5],xmm7[6],mem[6],xmm7[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm8, %xmm7, %xmm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm8, %xmm9
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 72(%rax), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm8 # 16-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # xmm8 = xmm8[4],mem[4],xmm8[5],mem[5],xmm8[6],mem[6],xmm8[7],mem[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %xmm9, %xmm8, %xmm8
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,0,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd 104(%rax), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm6, %ymm8, %ymm9, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm8 = [255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm4, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm5, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm7, %ymm2, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm8, %ymm6, %ymm3, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX2-FAST-PERLANE-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm1, %ymm0, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm5 = mem[1,1,1,1,5,5,5,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7,8,9],ymm5[10],ymm4[11,12],ymm5[13],ymm4[14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} ymm5 = ymm0[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-PERLANE-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm6 = mem[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0,1],ymm5[2],ymm6[3,4],ymm5[5],ymm6[6,7,8,9],ymm5[10],ymm6[11,12],ymm5[13],ymm6[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm4, %ymm5, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm1, %ymm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm6 = mem[1,1,1,1,5,5,5,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm6[2],ymm5[3,4],ymm6[5],ymm5[6,7,8,9],ymm6[10],ymm5[11,12],ymm6[13],ymm5[14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} ymm6 = ymm0[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-PERLANE-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm7 = mem[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0,1],ymm6[2],ymm7[3,4],ymm6[5],ymm7[6,7,8,9],ymm6[10],ymm7[11,12],ymm6[13],ymm7[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm2, %ymm5, %ymm6, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm1, %ymm12, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm7 = mem[1,1,1,1,5,5,5,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0,1],ymm7[2],ymm6[3,4],ymm7[5],ymm6[6,7,8,9],ymm7[10],ymm6[11,12],ymm7[13],ymm6[14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} ymm7 = ymm2[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm8 = ymm4[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0,1],ymm7[2],ymm8[3,4],ymm7[5],ymm8[6,7,8,9],ymm7[10],ymm8[11,12],ymm7[13],ymm8[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm3, %ymm6, %ymm7, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{.*#+}} ymm7 = [18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm7, %ymm6, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm9 = ymm14[0,0,2,1,4,4,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm8 = ymm8[0,1,2],ymm9[3],ymm8[4,5],ymm9[6],ymm8[7,8,9,10],ymm9[11],ymm8[12,13],ymm9[14],ymm8[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm9 = ymm13[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm8, %ymm9, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm7, %ymm1, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm11 = ymm5[0,0,2,1,4,4,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm9 = ymm9[0,1,2],ymm11[3],ymm9[4,5],ymm11[6],ymm9[7,8,9,10],ymm11[11],ymm9[12,13],ymm11[14],ymm9[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm11 = mem[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm9, %ymm11, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm7, %ymm15, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm11 = ymm3[0,0,2,1,4,4,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0,1,2],ymm11[3],ymm7[4,5],ymm11[6],ymm7[7,8,9,10],ymm11[11],ymm7[12,13],ymm11[14],ymm7[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm11 = mem[0,1,1,3,4,5,5,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm7, %ymm11, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm0, %ymm7, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vbroadcasti128 {{.*#+}} ymm10 = [22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27,22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27]
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm10, %ymm7, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm8 = mem[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0,1],ymm8[2],ymm7[3,4],ymm8[5],ymm7[6,7,8,9],ymm8[10],ymm7[11,12],ymm8[13],ymm7[14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = [10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm1, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm9 = mem[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2,3],ymm8[4],ymm9[5,6,7,8],ymm8[9],ymm9[10,11],ymm8[12],ymm9[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u,u,u,u,u,0,0,0,0,255,255,255,255,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm7, %ymm8, %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm10, %ymm7, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm10, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm9 = ymm7[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm8 = ymm8[0,1],ymm9[2],ymm8[3,4],ymm9[5],ymm8[6,7,8,9],ymm9[10],ymm8[11,12],ymm9[13],ymm8[14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm9, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm10 = mem[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm9 = ymm10[0],ymm9[1],ymm10[2,3],ymm9[4],ymm10[5,6,7,8],ymm9[9],ymm10[10,11],ymm9[12],ymm10[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm8, %ymm9, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm11, %ymm2, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm10 = ymm4[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm9 = ymm9[0,1],ymm10[2],ymm9[3,4],ymm10[5],ymm9[6,7,8,9],ymm10[10],ymm9[11,12],ymm10[13],ymm9[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm0, %ymm12, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm12, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd $170, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm11 = mem[2,2,2,2,6,6,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm10 = ymm11[0],ymm10[1],ymm11[2,3],ymm10[4],ymm11[5,6,7,8],ymm10[9],ymm11[10,11],ymm10[12],ymm11[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm1, %ymm9, %ymm10, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = [u,u,u,u,u,u,u,u,u,u,8,9,u,u,u,u,u,u,u,u,22,23,u,u,u,u,24,25,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm10, %ymm6, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm12 = ymm14[1,2,2,3,5,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm11 = ymm12[0,1],ymm11[2],ymm12[3,4],ymm11[5],ymm12[6,7,8,9],ymm11[10],ymm12[11,12],ymm11[13],ymm12[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm12 = ymm13[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = [u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm10, %ymm4, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm5[1,2,2,3,5,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm12 = ymm14[0,1],ymm12[2],ymm14[3,4],ymm12[5],ymm14[6,7,8,9],ymm12[10],ymm14[11,12],ymm12[13],ymm14[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm5[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm12, %ymm14, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm10, %ymm15, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm3[1,2,2,3,5,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm10 = ymm14[0,1],ymm10[2],ymm14[3,4],ymm10[5],ymm14[6,7,8,9],ymm10[10],ymm14[11,12],ymm10[13],ymm14[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm14 = ymm2[0,1,2,2,4,5,6,6]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm10, %ymm14, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = [255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm1 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm8, %ymm12, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm9, %ymm10, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm14 = [u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm14, %ymm1, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm11 = mem[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm10 = ymm11[0,1,2],ymm10[3],ymm11[4,5],ymm10[6],ymm11[7,8,9,10],ymm10[11],ymm11[12,13],ymm10[14],ymm11[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = [14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm13, %ymm1, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm12 = mem[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm11 = ymm12[0],ymm11[1],ymm12[2,3],ymm11[4],ymm12[5,6,7,8],ymm11[9],ymm12[10,11],ymm11[12],ymm12[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm15 = [u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u,255,255,255,255,0,0,0,0,u,u,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm10, %ymm11, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm14, %ymm1, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm12 = mem[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm11 = ymm12[0,1,2],ymm11[3],ymm12[4,5],ymm11[6],ymm12[7,8,9,10],ymm11[11],ymm12[12,13],ymm11[14],ymm12[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm13, %ymm1, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm13, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm13 = ymm7[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm12 = ymm13[0],ymm12[1],ymm13[2,3],ymm12[4],ymm13[5,6,7,8],ymm12[9],ymm13[10,11],ymm12[12],ymm13[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm11, %ymm12, %ymm11
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm14, %ymm0, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm13 = mem[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm12 = ymm13[0,1,2],ymm12[3],ymm13[4,5],ymm12[6],ymm13[7,8,9,10],ymm12[11],ymm13[12,13],ymm12[14],ymm13[15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm1, %ymm0, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm14 = mem[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm13 = ymm14[0],ymm13[1],ymm14[2,3],ymm13[4],ymm14[5,6,7,8],ymm13[9],ymm14[10,11],ymm13[12],ymm14[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm15, %ymm12, %ymm13, %ymm12
; AVX2-FAST-PERLANE-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [26,27,28,29,26,27,28,29,26,27,28,29,30,31,30,31,26,27,28,29,26,27,28,29,26,27,28,29,30,31,30,31]
; AVX2-FAST-PERLANE-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm13, %ymm6, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm15 = mem[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4],ymm15[5],ymm14[6,7,8,9],ymm15[10],ymm14[11,12],ymm15[13],ymm14[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd $254, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm15 = mem[2,3,3,3,6,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm0 = [255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0,u,u,u,u,u,u,u,u,255,255,255,255,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm14, %ymm15, %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm13, %ymm4, %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpshufd $255, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm1 = mem[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm15[0,1],ymm1[2],ymm15[3,4],ymm1[5],ymm15[6,7,8,9],ymm1[10],ymm15[11,12],ymm1[13],ymm15[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm5[2,3,3,3,6,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm1, %ymm15, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vpshufb %ymm13, %ymm4, %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm3[3,3,3,3,7,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4],ymm15[5],ymm13[6,7,8,9],ymm15[10],ymm13[11,12],ymm15[13],ymm13[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm15 = ymm2[2,3,3,3,6,7,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,1,3,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm0, %ymm13, %ymm15, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm13 = [0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm10, %ymm14, %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm11, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm13, %ymm12, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm2, 544(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm2, 320(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm2, 96(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 640(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm9, 608(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, 416(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, 384(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm10, 192(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FAST-PERLANE-NEXT:    addq $1544, %rsp # imm = 0x608
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-SLOW-LABEL: store_i16_stride7_vf64:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    subq $2168, %rsp # imm = 0x878
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rcx), %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rdx), %ymm9
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm7
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rsi), %ymm8
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128,128,128]
; AVX512F-SLOW-NEXT:    vpshufb %ymm0, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm2, %ymm18
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm11 = [u,u,u,u,12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb %ymm11, %ymm9, %ymm2
; AVX512F-SLOW-NEXT:    vporq %ymm1, %ymm2, %ymm16
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX512F-SLOW-NEXT:    vpshufb %ymm12, %ymm8, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = [12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u,u,u,u,u,16,17,18,19]
; AVX512F-SLOW-NEXT:    vpshufb %ymm13, %ymm7, %ymm2
; AVX512F-SLOW-NEXT:    vporq %ymm1, %ymm2, %ymm17
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [128,128,128,128,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128]
; AVX512F-SLOW-NEXT:    vmovdqa 64(%r9), %ymm2
; AVX512F-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa %ymm3, %ymm10
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm2, %ymm21
; AVX512F-SLOW-NEXT:    vmovdqa 64(%r8), %ymm3
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = [u,u,u,u,u,u,u,u,12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u]
; AVX512F-SLOW-NEXT:    vpshufb %ymm15, %ymm3, %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm3, %ymm20
; AVX512F-SLOW-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rcx), %ymm2
; AVX512F-SLOW-NEXT:    vpshufb %ymm0, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm2, %ymm23
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rdx), %ymm6
; AVX512F-SLOW-NEXT:    vpshufb %ymm11, %ymm6, %ymm2
; AVX512F-SLOW-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rsi), %ymm5
; AVX512F-SLOW-NEXT:    vpshufb %ymm12, %ymm5, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm4
; AVX512F-SLOW-NEXT:    vpshufb %ymm13, %ymm4, %ymm2
; AVX512F-SLOW-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%r9), %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufb %ymm10, %ymm1, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa %ymm10, %ymm3
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512F-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufb %ymm15, %ymm2, %ymm2
; AVX512F-SLOW-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufb %ymm0, %ymm1, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512F-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufb %ymm11, %ymm2, %ymm2
; AVX512F-SLOW-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %ymm2
; AVX512F-SLOW-NEXT:    vpshufb %ymm12, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm2, %ymm28
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %ymm10
; AVX512F-SLOW-NEXT:    vpshufb %ymm13, %ymm10, %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm10, %ymm22
; AVX512F-SLOW-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rcx), %ymm2
; AVX512F-SLOW-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdx), %ymm1
; AVX512F-SLOW-NEXT:    vpshufb %ymm11, %ymm1, %ymm11
; AVX512F-SLOW-NEXT:    vpor %ymm0, %ymm11, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rsi), %ymm0
; AVX512F-SLOW-NEXT:    vpshufb %ymm12, %ymm0, %ymm12
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm11
; AVX512F-SLOW-NEXT:    vpshufb %ymm13, %ymm11, %ymm13
; AVX512F-SLOW-NEXT:    vpor %ymm12, %ymm13, %ymm10
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 32(%r8), %ymm13
; AVX512F-SLOW-NEXT:    vpshufb %ymm15, %ymm13, %ymm12
; AVX512F-SLOW-NEXT:    vmovdqa 32(%r9), %ymm15
; AVX512F-SLOW-NEXT:    vpshufb %ymm3, %ymm15, %ymm14
; AVX512F-SLOW-NEXT:    vpor %ymm14, %ymm12, %ymm10
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vprold $16, %ymm15, %ymm12
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm13[1,2,2,3,5,6,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm12 = ymm14[0,1],ymm12[2],ymm14[3,4],ymm12[5],ymm14[6,7,8,9],ymm12[10],ymm14[11,12],ymm12[13],ymm14[14,15]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm14 = ymm15[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm14[2,2,2,3,6,6,6,7]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm13[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm14[0,1],ymm10[2],ymm14[3,4],ymm10[5],ymm14[6,7,8,9],ymm10[10],ymm14[11,12],ymm10[13],ymm14[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [2,1,3,2,10,10,10,11]
; AVX512F-SLOW-NEXT:    vpermi2q %zmm10, %zmm12, %zmm14
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27,22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27]
; AVX512F-SLOW-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm18, %ymm14
; AVX512F-SLOW-NEXT:    vpshufb %ymm12, %ymm14, %ymm10
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm12, %ymm19
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm9[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm10[0,1],ymm12[2],ymm10[3,4],ymm12[5],ymm10[6,7,8,9],ymm12[10],ymm10[11,12],ymm12[13],ymm10[14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm10 = ymm14[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm10[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm9[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm12[0],ymm10[1],ymm12[2,3],ymm10[4],ymm12[5,6,7,8],ymm10[9],ymm12[10,11],ymm10[12],ymm12[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm10 = ymm8[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm10[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm7[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm12[0],ymm10[1],ymm12[2,3],ymm10[4],ymm12[5,6,7,8],ymm10[9],ymm12[10,11],ymm10[12],ymm12[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm10 = ymm8[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm10[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm7[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm10 = ymm12[0,1,2],ymm10[3],ymm12[4,5],ymm10[6],ymm12[7,8,9,10],ymm10[11],ymm12[12,13],ymm10[14],ymm12[15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[0,1,1,3,4,5,5,7]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm10 = ymm14[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm10[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm9[0,1],ymm10[2],ymm9[3,4],ymm10[5],ymm9[6,7,8,9],ymm10[10],ymm9[11,12],ymm10[13],ymm9[14,15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm7[1,1,1,1,5,5,5,5]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm8 = ymm8[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm8[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0,1],ymm7[2],ymm8[3,4],ymm7[5],ymm8[6,7,8,9],ymm7[10],ymm8[11,12],ymm7[13],ymm8[14,15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,2,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm16, %zmm8
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm7, %zmm17, %zmm7
; AVX512F-SLOW-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm26 = [65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vmovdqa 96(%r8), %ymm10
; AVX512F-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufb {{.*#+}} ymm8 = ymm10[u,u],zero,zero,zero,zero,zero,zero,zero,zero,ymm10[14,15,u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero,ymm10[16,17,u,u,u,u],zero,zero
; AVX512F-SLOW-NEXT:    vpternlogq $248, %ymm26, %ymm7, %ymm8
; AVX512F-SLOW-NEXT:    vmovdqa 96(%r9), %ymm12
; AVX512F-SLOW-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufb %ymm3, %ymm12, %ymm9
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $248, %ymm14, %ymm8, %ymm9
; AVX512F-SLOW-NEXT:    vextracti64x4 $1, %zmm7, %ymm7
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm8 = ymm10[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,1,3,3]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %ymm7, %ymm10, %ymm8
; AVX512F-SLOW-NEXT:    vprold $16, %ymm12, %ymm7
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,2,2]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %ymm8, %ymm14, %ymm7
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm7, %zmm0, %zmm7
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm7 = zmm9[0,1,2,3],zmm7[4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [6,5,0,0,7,6,0,7,6,5,0,0,7,6,0,7]
; AVX512F-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rax), %ymm7
; AVX512F-SLOW-NEXT:    vpermd %zmm7, %zmm18, %zmm9
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm7[0,1,1,3,4,5,5,7]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = [12,13,128,128,128,128,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128]
; AVX512F-SLOW-NEXT:    vpshufb %ymm10, %ymm7, %ymm7
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpandnq %ymm9, %ymm26, %ymm9
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm7, %zmm7
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm16 = [65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535]
; AVX512F-SLOW-NEXT:    vpbroadcastd 72(%rax), %ymm7
; AVX512F-SLOW-NEXT:    vpandnq %ymm7, %ymm16, %ymm9
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rax), %ymm7
; AVX512F-SLOW-NEXT:    vpshufb %ymm10, %ymm7, %ymm12
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm12, %zmm9, %zmm9
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpbroadcastd 8(%rax), %ymm9
; AVX512F-SLOW-NEXT:    vpandnq %ymm9, %ymm16, %ymm9
; AVX512F-SLOW-NEXT:    vmovdqa (%rax), %ymm8
; AVX512F-SLOW-NEXT:    vpshufb %ymm10, %ymm8, %ymm12
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm8, %ymm24
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm12, %zmm9, %zmm9
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm2[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm1[0,1,1,3,4,5,5,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm12[0,1],ymm9[2],ymm12[3,4],ymm9[5],ymm12[6,7,8,9],ymm9[10],ymm12[11,12],ymm9[13],ymm12[14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm0[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm11[1,1,1,1,5,5,5,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm9 = ymm9[0,1],ymm12[2],ymm9[3,4],ymm12[5],ymm9[6,7,8,9],ymm12[10],ymm9[11,12],ymm12[13],ymm9[14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rax), %ymm9
; AVX512F-SLOW-NEXT:    vpshufb %ymm10, %ymm9, %ymm10
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm9[0,1,1,3,4,5,5,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpandnq %ymm12, %ymm26, %ymm12
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm12, %zmm10, %zmm10
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm13[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm12 = ymm15[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm12[0,1,2],ymm10[3],ymm12[4,5],ymm10[6],ymm12[7,8,9,10],ymm10[11],ymm12[12,13],ymm10[14],ymm12[15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm19, %ymm13
; AVX512F-SLOW-NEXT:    vpshufb %ymm13, %ymm2, %ymm10
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm12 = ymm1[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm10[0,1],ymm12[2],ymm10[3,4],ymm12[5],ymm10[6,7,8,9],ymm12[10],ymm10[11,12],ymm12[13],ymm10[14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm2[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5,6,7,8],ymm2[9],ymm1[10,11],ymm2[12],ymm1[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm0[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm11[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm31
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm11[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm0[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8,9,10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpermd %zmm9, %zmm18, %zmm0
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm0 = ymm5[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm4[1,1,1,1,5,5,5,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm5[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm4[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6,7,8],ymm0[9],ymm1[10,11],ymm0[12],ymm1[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm23, %ymm2
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm0 = ymm2[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm6[0,1,1,3,4,5,5,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7,8,9],ymm0[10],ymm1[11,12],ymm0[13],ymm1[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm0, %ymm30
; AVX512F-SLOW-NEXT:    vpshufb %ymm13, %ymm2, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm23, %ymm3
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm6[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7,8,9],ymm1[10],ymm0[11,12],ymm1[13],ymm0[14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm21, %ymm8
; AVX512F-SLOW-NEXT:    vprold $16, %ymm21, %ymm0
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm20[1,2,2,3,5,6,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7,8,9],ymm0[10],ymm1[11,12],ymm0[13],ymm1[14,15]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm8[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm20[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1,2],ymm2[3],ymm1[4,5],ymm2[6],ymm1[7,8,9,10],ymm2[11],ymm1[12,13],ymm2[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [2,2,3,3,10,9,11,10]
; AVX512F-SLOW-NEXT:    vpermt2q %zmm0, %zmm10, %zmm1
; AVX512F-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [0,5,4,0,0,6,5,0,0,5,4,0,0,6,5,0]
; AVX512F-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512F-SLOW-NEXT:    vpermd 64(%rax), %zmm11, %zmm0
; AVX512F-SLOW-NEXT:    vpternlogd $184, %zmm1, %zmm26, %zmm0
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm6[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm3[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6,7,8],ymm1[9],ymm0[10,11],ymm1[12],ymm0[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm4[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm5[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7,8,9,10],ymm1[11],ymm0[12,13],ymm1[14],ymm0[15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm20[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm8[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,2,2,3,6,6,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7,8,9],ymm0[10],ymm1[11,12],ymm0[13],ymm1[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [4,5,4,5,4,5,6,7,16,17,16,17,16,17,17,19]
; AVX512F-SLOW-NEXT:    vmovdqa 96(%r9), %xmm0
; AVX512F-SLOW-NEXT:    vmovdqa 96(%r8), %xmm1
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm2[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm4, %zmm12, %zmm3
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm7[2,3,3,3,6,7,7,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpbroadcastd 96(%rax), %ymm5
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm4, %zmm4
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogd $184, %zmm3, %zmm5, %zmm4
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm15
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rsi), %xmm3
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rdi), %xmm4
; AVX512F-SLOW-NEXT:    vprold $16, %xmm3, %xmm5
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm4[1,1,2,3]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0,1],xmm5[2],xmm6[3,4],xmm5[5],xmm6[6,7]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm5, %xmm23
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm3[4],xmm4[4],xmm3[5],xmm4[5],xmm3[6],xmm4[6],xmm3[7],xmm4[7]
; AVX512F-SLOW-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rcx), %xmm3
; AVX512F-SLOW-NEXT:    vmovdqa 96(%rdx), %xmm4
; AVX512F-SLOW-NEXT:    vpbroadcastq {{.*#+}} xmm6 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX512F-SLOW-NEXT:    vpshufb %xmm6, %xmm3, %xmm5
; AVX512F-SLOW-NEXT:    vmovdqa %xmm6, %xmm7
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm4[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0],xmm5[1],xmm6[2,3],xmm5[4],xmm6[5,6],xmm5[7]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX512F-SLOW-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX512F-SLOW-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,7,6]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm1, %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm29 = [16,18,19,19,19,19,u,u,0,1,0,1,2,3,2,3]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm2, %zmm29, %zmm1
; AVX512F-SLOW-NEXT:    vpbroadcastd 100(%rax), %ymm2
; AVX512F-SLOW-NEXT:    vpbroadcastd 104(%rax), %ymm3
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512F-SLOW-NEXT:    vpternlogd $184, %zmm1, %zmm14, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rcx), %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm2
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm3, %xmm27
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX512F-SLOW-NEXT:    vpshufb %xmm7, %xmm1, %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa %xmm7, %xmm8
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0],xmm1[1],xmm2[2,3],xmm1[4],xmm2[5,6],xmm1[7]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm3[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [16,16,17,17,17,17,u,u,0,1,0,1,2,3,2,3]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm2, %zmm3, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rdi), %xmm2
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rsi), %xmm4
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm2[0],xmm4[0],xmm2[1],xmm4[1],xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm6, %xmm25
; AVX512F-SLOW-NEXT:    vprold $16, %xmm4, %xmm4
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[1,1,2,3]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm4[2],xmm2[3,4],xmm4[5],xmm2[6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm2, %zmm5, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm1, %zmm4, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa 64(%r9), %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa 64(%r8), %xmm2
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm5, %xmm17
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm1[0,1,2,3,4,5,7,6]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,1,0,1,0,1,1,3,16,18,19,19,19,19,u,u]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm2, %zmm6, %zmm1
; AVX512F-SLOW-NEXT:    vpbroadcastd 64(%rax), %ymm2
; AVX512F-SLOW-NEXT:    vpbroadcastd 68(%rax), %ymm5
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm2, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogd $184, %zmm1, %zmm9, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%rcx), %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm2, %xmm20
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX512F-SLOW-NEXT:    vpshufb %xmm8, %xmm1, %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa %xmm8, %xmm14
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm5[0],xmm1[1],xmm5[2,3],xmm1[4],xmm5[5,6],xmm1[7]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm7[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm5, %zmm3, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa (%rdi), %xmm3
; AVX512F-SLOW-NEXT:    vmovdqa (%rsi), %xmm5
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm7, %xmm7
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm5[4],xmm3[4],xmm5[5],xmm3[5],xmm5[6],xmm3[6],xmm5[7],xmm3[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm2, %xmm19
; AVX512F-SLOW-NEXT:    vprold $16, %xmm5, %xmm5
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,2,3]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm5[2],xmm3[3,4],xmm5[5],xmm3[6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm3, %zmm7, %zmm2
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm1, %zmm4, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa (%r9), %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa (%r8), %xmm3
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm1[0,1,2,3,4,5,7,6]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512F-SLOW-NEXT:    vpbroadcastd (%rax), %ymm3
; AVX512F-SLOW-NEXT:    vpbroadcastd 4(%rax), %ymm4
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm2
; AVX512F-SLOW-NEXT:    vpternlogd $184, %zmm1, %zmm9, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm28, %ymm7
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm7[1,2,3,3,4,5,6,7,9,10,11,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm22, %ymm2
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm22[1,1,1,1,5,5,5,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm4[2],ymm1[3,4],ymm4[5],ymm1[6,7,8,9],ymm4[10],ymm1[11,12],ymm4[13],ymm1[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm22
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm7[0,1,2,3,5,4,6,7,8,9,10,11,13,12,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm2[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vmovdqa %ymm2, %ymm9
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm4[0],ymm1[1],ymm4[2,3],ymm1[4],ymm4[5,6,7,8],ymm1[9],ymm4[10,11],ymm1[12],ymm4[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm21
; AVX512F-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX512F-SLOW-NEXT:    vprold $16, %ymm2, %ymm1
; AVX512F-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm3[1,2,2,3,5,6,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm4[0,1],ymm1[2],ymm4[3,4],ymm1[5],ymm4[6,7,8,9],ymm1[10],ymm4[11,12],ymm1[13],ymm4[14,15]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm2[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm3[0,0,2,1,4,4,6,5]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0,1,2],ymm6[3],ymm4[4,5],ymm6[6],ymm4[7,8,9,10],ymm6[11],ymm4[12,13],ymm6[14],ymm4[15]
; AVX512F-SLOW-NEXT:    vpermt2q %zmm1, %zmm10, %zmm4
; AVX512F-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm8[1,2,2,3,4,5,6,7,9,10,10,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[0,0,0,0,4,4,4,4]
; AVX512F-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm10[0,1,1,3,4,5,5,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm6[0,1],ymm1[2],ymm6[3,4],ymm1[5],ymm6[6,7,8,9],ymm1[10],ymm6[11,12],ymm1[13],ymm6[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm16
; AVX512F-SLOW-NEXT:    vpshufb %ymm13, %ymm8, %ymm1
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm10[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm6[2],ymm1[3,4],ymm6[5],ymm1[6,7,8,9],ymm6[10],ymm1[11,12],ymm6[13],ymm1[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa64 %ymm1, %ymm18
; AVX512F-SLOW-NEXT:    vpermd (%rax), %zmm11, %zmm1
; AVX512F-SLOW-NEXT:    vpternlogd $184, %zmm4, %zmm26, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm10[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm8[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm4[1],ymm1[2,3],ymm4[4],ymm1[5,6,7,8],ymm4[9],ymm1[10,11],ymm4[12],ymm1[13,14,15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm9[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm7[0,1,2,3,7,6,6,7,8,9,10,11,15,14,14,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,2,2,2,6,6,6,6]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1,2],ymm4[3],ymm1[4,5],ymm4[6],ymm1[7,8,9,10],ymm4[11],ymm1[12,13],ymm4[14],ymm1[15]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm3[3,3,3,3,7,7,7,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm2[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,2,2,3,6,6,6,7]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm4[0,1],ymm1[2],ymm4[3,4],ymm1[5],ymm4[6,7,8,9],ymm1[10],ymm4[11,12],ymm1[13],ymm4[14,15]
; AVX512F-SLOW-NEXT:    vmovdqa 32(%r9), %xmm7
; AVX512F-SLOW-NEXT:    vmovdqa 32(%r8), %xmm4
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm4[0],xmm7[0],xmm4[1],xmm7[1],xmm4[2],xmm7[2],xmm4[3],xmm7[3]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm6[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm11, %zmm12, %zmm1
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm24[2,3,3,3,6,7,7,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpbroadcastd 32(%rax), %ymm12
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm12, %zmm11, %zmm26
; AVX512F-SLOW-NEXT:    vpternlogd $184, %zmm1, %zmm15, %zmm26
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rsi), %xmm12
; AVX512F-SLOW-NEXT:    vprold $16, %xmm12, %xmm15
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm13 = xmm1[1,1,2,3]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm13[0,1],xmm15[2],xmm13[3,4],xmm15[5],xmm13[6,7]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm1[0],xmm12[0],xmm1[1],xmm12[1],xmm1[2],xmm12[2],xmm1[3],xmm12[3]
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm12[4],xmm1[4],xmm12[5],xmm1[5],xmm12[6],xmm1[6],xmm12[7],xmm1[7]
; AVX512F-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm4[4],xmm7[4],xmm4[5],xmm7[5],xmm4[6],xmm7[6],xmm4[7],xmm7[7]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm17, %xmm1
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm1, %xmm2
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm5, %xmm3
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm23, %xmm1
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm1, %xmm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm13, %xmm1
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512F-SLOW-NEXT:    vpermq $234, {{[-0-9]+}}(%r{{[sb]}}p), %ymm24 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm24 = mem[2,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq $232, {{[-0-9]+}}(%r{{[sb]}}p), %ymm23 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm23 = mem[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq $232, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm7 = mem[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq $246, {{[-0-9]+}}(%r{{[sb]}}p), %ymm17 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm17 = mem[2,1,3,3]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm6[0,1,2,3,4,5,7,6]
; AVX512F-SLOW-NEXT:    vpermt2d %zmm0, %zmm29, %zmm4
; AVX512F-SLOW-NEXT:    vpbroadcastd 36(%rax), %ymm0
; AVX512F-SLOW-NEXT:    vpbroadcastd 40(%rax), %ymm6
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm6, %zmm0, %zmm28
; AVX512F-SLOW-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm4, %zmm28
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rcx), %xmm6
; AVX512F-SLOW-NEXT:    vpshufb %xmm14, %xmm6, %xmm4
; AVX512F-SLOW-NEXT:    vmovdqa 32(%rdx), %xmm0
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm12 = xmm0[1,1,2,2]
; AVX512F-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm12[0],xmm4[1],xmm12[2,3],xmm4[4],xmm12[5,6],xmm4[7]
; AVX512F-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; AVX512F-SLOW-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; AVX512F-SLOW-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm1[0,1,2,3,5,5,7,6,8,9,10,11,13,13,15,14]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm29 = ymm0[3,3,3,3]
; AVX512F-SLOW-NEXT:    vpshufd $233, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm0 = mem[1,2,2,3,5,6,6,7]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm1[2,1,2,3,6,5,6,7]
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} ymm14 = ymm14[0,0,3,3,4,5,6,7,8,8,11,11,12,13,14,15]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,2,2]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,1,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm27, %xmm1
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm10 = xmm1[0,2,3,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,0,2,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm25, %xmm1
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm8 = xmm1[2,1,2,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,5,5,4]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,0,1,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,1,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm20, %xmm1
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm15 = xmm1[0,2,3,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,0,2,1]
; AVX512F-SLOW-NEXT:    vmovdqa64 %xmm19, %xmm1
; AVX512F-SLOW-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm1[2,1,2,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,5,5,4]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,0,1,3]
; AVX512F-SLOW-NEXT:    vpermq $182, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm4 = mem[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpermq $234, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm5 = mem[2,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq $250, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm6 = mem[2,2,3,3]
; AVX512F-SLOW-NEXT:    vpermpd $234, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm1 = mem[2,2,2,3]
; AVX512F-SLOW-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-SLOW-NEXT:    vpermpd $232, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm1 = mem[0,2,2,3]
; AVX512F-SLOW-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm31 = ymm31[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq $246, {{[-0-9]+}}(%r{{[sb]}}p), %ymm27 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm27 = mem[2,1,3,3]
; AVX512F-SLOW-NEXT:    vpermq $234, {{[-0-9]+}}(%r{{[sb]}}p), %ymm20 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm20 = mem[2,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq $232, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm11 = mem[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm19 = ymm30[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpermq $234, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm1 = mem[2,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm25 = ymm22[2,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm21[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm16 = ymm16[2,1,3,2]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm18[2,2,2,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm23, %zmm24, %zmm23
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm17, %zmm7, %zmm24
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm30 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm23, %zmm30, %zmm24
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,2]
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %ymm24, %ymm7, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm18 = [65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %ymm0, %ymm18, %ymm14
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm0[4,5,6,7]
; AVX512F-SLOW-NEXT:    vpternlogq $234, {{[-0-9]+}}(%r{{[sb]}}p), %zmm18, %zmm2 # 64-byte Folded Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm3[0,1,2,3],zmm0[4,5,6,7]
; AVX512F-SLOW-NEXT:    vpternlogq $234, {{[-0-9]+}}(%r{{[sb]}}p), %zmm18, %zmm3 # 64-byte Folded Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm8 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm23 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm10, %zmm23, %zmm8
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm2, %zmm17, %zmm8
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm15, %zmm2 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm12, %zmm10 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm2, %zmm23, %zmm10
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm3, %zmm17, %zmm10
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm2
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm21
; AVX512F-SLOW-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm21
; AVX512F-SLOW-NEXT:    vextracti64x4 $1, %zmm24, %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogd $226, 124(%r8){1to8}, %ymm0, %ymm2
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $184, %ymm2, %ymm3, %ymm29
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $248, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm22 # 64-byte Folded Reload
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm24 = zmm0[0,1,2,3],zmm6[0,1,2,3]
; AVX512F-SLOW-NEXT:    vpternlogq $234, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm24 # 64-byte Folded Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm29, %zmm0, %zmm2
; AVX512F-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm14[0,1,2,3],zmm2[4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0]
; AVX512F-SLOW-NEXT:    vpternlogd $184, %zmm2, %zmm0, %zmm29
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogd $184, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm7 # 64-byte Folded Reload
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $184, {{[-0-9]+}}(%r{{[sb]}}p), %zmm2, %zmm18 # 64-byte Folded Reload
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $184, {{[-0-9]+}}(%r{{[sb]}}p), %zmm2, %zmm17 # 64-byte Folded Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm11, %zmm20, %zmm2
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm19, %zmm3
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm2, %zmm4, %zmm3
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm13, %zmm25, %zmm2
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm16, %zmm5
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm2, %zmm4, %zmm5
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0]
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm3, %zmm2, %zmm20
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm5, %zmm2, %zmm25
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm2 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm27, %zmm31, %zmm3
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm2, %zmm30, %zmm3
; AVX512F-SLOW-NEXT:    vpermq $232, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm2 = mem[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpshuflw $180, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; AVX512F-SLOW-NEXT:    # xmm4 = mem[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,1,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm2
; AVX512F-SLOW-NEXT:    vpermq $246, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm4 = mem[2,1,3,3]
; AVX512F-SLOW-NEXT:    vpermq $80, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm5 = mem[0,0,1,1]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm5, %zmm4, %zmm4
; AVX512F-SLOW-NEXT:    vpermq $96, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm5 = mem[0,0,2,1]
; AVX512F-SLOW-NEXT:    vpshuflw $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; AVX512F-SLOW-NEXT:    # xmm6 = mem[2,1,2,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,5,5,4]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,0,1,3]
; AVX512F-SLOW-NEXT:    vpermq $80, {{[-0-9]+}}(%r{{[sb]}}p), %ymm19 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm19 = mem[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpshuflw $248, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; AVX512F-SLOW-NEXT:    # xmm9 = mem[0,2,3,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,0,2,1]
; AVX512F-SLOW-NEXT:    vpermq $232, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm11 = mem[0,2,2,3]
; AVX512F-SLOW-NEXT:    vpshuflw $180, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; AVX512F-SLOW-NEXT:    # xmm12 = mem[0,1,3,2,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpermq $246, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm13 = mem[2,1,3,3]
; AVX512F-SLOW-NEXT:    vpermq $80, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm14 = mem[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpermq $96, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm15 = mem[0,0,2,1]
; AVX512F-SLOW-NEXT:    vpshuflw $230, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; AVX512F-SLOW-NEXT:    # xmm0 = mem[2,1,2,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,5,4]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,1,3]
; AVX512F-SLOW-NEXT:    vpermq $80, {{[-0-9]+}}(%r{{[sb]}}p), %ymm16 # 32-byte Folded Reload
; AVX512F-SLOW-NEXT:    # ymm16 = mem[0,0,1,1]
; AVX512F-SLOW-NEXT:    vpshuflw $248, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX512F-SLOW-NEXT:    # xmm1 = mem[0,2,3,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm2, %zmm30, %zmm4
; AVX512F-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm12[0,1,1,3]
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm2, %zmm11, %zmm2
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm14, %zmm13, %zmm11
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm2, %zmm30, %zmm11
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535]
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm4, %zmm2, %zmm12
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm11, %zmm2, %zmm26
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm6, %zmm5, %zmm2
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm9, %zmm19, %zmm4
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm2, %zmm23, %zmm4
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm0, %zmm15, %zmm0
; AVX512F-SLOW-NEXT:    vinserti64x4 $1, %ymm1, %zmm16, %zmm1
; AVX512F-SLOW-NEXT:    vpternlogq $226, %zmm0, %zmm23, %zmm1
; AVX512F-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0]
; AVX512F-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm4, %zmm0, %zmm2
; AVX512F-SLOW-NEXT:    vpternlogq $184, %zmm1, %zmm0, %zmm28
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm21, %zmm24
; AVX512F-SLOW-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm7
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm24, 320(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm28, 256(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm26, 192(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm25, 128(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm10, 64(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm17, (%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm2, 704(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm12, 640(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm20, 576(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm8, 512(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm22, 768(%rax)
; AVX512F-SLOW-NEXT:    vmovdqa64 %zmm29, 832(%rax)
; AVX512F-SLOW-NEXT:    addq $2168, %rsp # imm = 0x878
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: store_i16_stride7_vf64:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    subq $1496, %rsp # imm = 0x5D8
; AVX512F-FAST-NEXT:    vmovdqa 96(%rcx), %ymm0
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = [128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128,128,128]
; AVX512F-FAST-NEXT:    vpshufb %ymm15, %ymm0, %ymm2
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm0, %ymm20
; AVX512F-FAST-NEXT:    vmovdqa 96(%rdx), %ymm9
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm0 = [u,u,u,u,12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb %ymm0, %ymm9, %ymm3
; AVX512F-FAST-NEXT:    vmovdqa %ymm0, %ymm10
; AVX512F-FAST-NEXT:    vporq %ymm2, %ymm3, %ymm16
; AVX512F-FAST-NEXT:    vmovdqa 96(%rsi), %ymm6
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = [128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX512F-FAST-NEXT:    vpshufb %ymm14, %ymm6, %ymm2
; AVX512F-FAST-NEXT:    vmovdqa 96(%rdi), %ymm7
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm11 = [12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u,u,u,u,u,16,17,18,19]
; AVX512F-FAST-NEXT:    vpshufb %ymm11, %ymm7, %ymm3
; AVX512F-FAST-NEXT:    vporq %ymm2, %ymm3, %ymm17
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [128,128,128,128,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128,128,128]
; AVX512F-FAST-NEXT:    vmovdqa 64(%r9), %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm2
; AVX512F-FAST-NEXT:    vmovdqa 64(%r8), %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [u,u,u,u,u,u,u,u,12,13,14,15,128,128,u,u,u,u,u,u,u,u,u,u,16,17,128,128,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm0, %ymm4
; AVX512F-FAST-NEXT:    vporq %ymm2, %ymm4, %ymm18
; AVX512F-FAST-NEXT:    vmovdqa 64(%rcx), %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm15, %ymm0, %ymm8
; AVX512F-FAST-NEXT:    vmovdqa 64(%rdx), %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm10, %ymm0, %ymm12
; AVX512F-FAST-NEXT:    vpor %ymm8, %ymm12, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 64(%rsi), %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm14, %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512F-FAST-NEXT:    vpshufb %ymm11, %ymm1, %ymm13
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm1, %ymm28
; AVX512F-FAST-NEXT:    vpor %ymm0, %ymm13, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa (%r9), %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %ymm1
; AVX512F-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm1, %ymm13
; AVX512F-FAST-NEXT:    vporq %ymm0, %ymm13, %ymm19
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm15, %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512F-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa %ymm10, %ymm2
; AVX512F-FAST-NEXT:    vpshufb %ymm10, %ymm1, %ymm13
; AVX512F-FAST-NEXT:    vpor %ymm0, %ymm13, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm14, %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm11, %ymm1, %ymm13
; AVX512F-FAST-NEXT:    vpor %ymm0, %ymm13, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 32(%rcx), %ymm10
; AVX512F-FAST-NEXT:    vpshufb %ymm15, %ymm10, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdx), %ymm15
; AVX512F-FAST-NEXT:    vpshufb %ymm2, %ymm15, %ymm13
; AVX512F-FAST-NEXT:    vpor %ymm0, %ymm13, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 32(%rsi), %ymm8
; AVX512F-FAST-NEXT:    vpshufb %ymm14, %ymm8, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX512F-FAST-NEXT:    vpshufb %ymm11, %ymm4, %ymm11
; AVX512F-FAST-NEXT:    vpor %ymm0, %ymm11, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 32(%r8), %ymm13
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm13, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa 32(%r9), %ymm14
; AVX512F-FAST-NEXT:    vpshufb %ymm3, %ymm14, %ymm5
; AVX512F-FAST-NEXT:    vmovdqa %ymm3, %ymm12
; AVX512F-FAST-NEXT:    vporq %ymm5, %ymm0, %ymm21
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm20, %ymm2
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm2[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm11 = ymm9[0,1,1,3,4,5,5,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm11[0,1],ymm0[2],ymm11[3,4],ymm0[5],ymm11[6,7,8,9],ymm0[10],ymm11[11,12],ymm0[13],ymm11[14,15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,1,3,2]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm11 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm7[1,1,1,1,5,5,5,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm11[0,1],ymm3[2],ymm11[3,4],ymm3[5],ymm11[6,7,8,9],ymm3[10],ymm11[11,12],ymm3[13],ymm11[14,15]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,3]
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm16, %zmm0
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm17, %zmm3
; AVX512F-FAST-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm25 = [65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vmovdqa 96(%r8), %ymm11
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm11[u,u],zero,zero,zero,zero,zero,zero,zero,zero,ymm11[14,15,u,u,u,u],zero,zero,zero,zero,zero,zero,zero,zero,ymm11[16,17,u,u,u,u],zero,zero
; AVX512F-FAST-NEXT:    vpternlogq $248, %ymm25, %ymm3, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa 96(%r9), %ymm5
; AVX512F-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm12, %ymm5, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = [65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $248, %ymm12, %ymm0, %ymm1
; AVX512F-FAST-NEXT:    vextracti64x4 $1, %zmm3, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,4,u,u,u,5,u,u]
; AVX512F-FAST-NEXT:    vpermd %ymm11, %ymm3, %ymm3
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0]
; AVX512F-FAST-NEXT:    vpternlogq $184, %ymm0, %ymm17, %ymm3
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm17, %zmm22
; AVX512F-FAST-NEXT:    vprold $16, %ymm5, %ymm0
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $184, %ymm3, %ymm5, %ymm0
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512F-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm1[0,1,2,3],zmm0[4,5,6,7]
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,4,5,4,5,5,7]
; AVX512F-FAST-NEXT:    vmovdqa 96(%rax), %ymm0
; AVX512F-FAST-NEXT:    vpermd %ymm0, %ymm1, %ymm1
; AVX512F-FAST-NEXT:    vpandnq %ymm1, %ymm25, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [12,13,128,128,128,128,128,128,128,128,128,128,128,128,14,15,128,128,128,128,128,128,128,128,128,128,128,128,16,17,128,128]
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm0, %ymm3
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm5, %ymm20
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm1, %zmm3, %zmm1
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX512F-FAST-NEXT:    vpshufb %ymm3, %ymm6, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm3, %ymm26
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm7[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm3[0,1,2],ymm1[3],ymm3[4,5],ymm1[6],ymm3[7,8,9,10],ymm1[11],ymm3[12,13],ymm1[14],ymm3[15]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm6, %ymm3
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm5, %ymm29
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm6 = ymm7[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm6[0],ymm3[1],ymm6[2,3],ymm3[4],ymm6[5,6,7,8],ymm3[9],ymm6[10,11],ymm3[12],ymm6[13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,2,2,3,10,9,11,11]
; AVX512F-FAST-NEXT:    vpermt2q %zmm1, %zmm6, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = [14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufb %ymm7, %ymm2, %ymm1
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm7, %ymm27
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm7 = ymm9[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm7[0],ymm1[1],ymm7[2,3],ymm1[4],ymm7[5,6,7,8],ymm1[9],ymm7[10,11],ymm1[12],ymm7[13,14,15]
; AVX512F-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27,22,23,26,27,0,0,24,25,26,27,0,0,26,27,26,27]
; AVX512F-FAST-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm2, %ymm7
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm5, %ymm16
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm9[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0,1],ymm9[2],ymm7[3,4],ymm9[5],ymm7[6,7,8,9],ymm9[10],ymm7[11,12],ymm9[13],ymm7[14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [2,2,2,3,8,10,10,11]
; AVX512F-FAST-NEXT:    vpermt2q %zmm1, %zmm17, %zmm7
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm3, %zmm1, %zmm7
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [5,u,u,u,6,u,u,6]
; AVX512F-FAST-NEXT:    vpermd %ymm11, %ymm1, %ymm1
; AVX512F-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rax), %zmm12
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [30,5,0,0,31,6,0,31,30,5,0,0,31,6,0,31]
; AVX512F-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermi2d %zmm12, %zmm0, %zmm3
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm23 = [65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535]
; AVX512F-FAST-NEXT:    vpbroadcastd 72(%rax), %ymm0
; AVX512F-FAST-NEXT:    vpandnq %ymm0, %ymm23, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa 64(%rax), %ymm7
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm20, %ymm5
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm7, %ymm3
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm7, %ymm30
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm11
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm18, %zmm0, %zmm0
; AVX512F-FAST-NEXT:    vmovdqa 64(%r9), %xmm1
; AVX512F-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 64(%r8), %xmm2
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm2, %xmm20
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-FAST-NEXT:    vpshufb %xmm9, %xmm3, %xmm3
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm18 = [0,0,1,1,12,13,14,15]
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm18, %zmm3
; AVX512F-FAST-NEXT:    vpternlogq $248, %zmm23, %zmm3, %zmm11
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpbroadcastd 8(%rax), %ymm0
; AVX512F-FAST-NEXT:    vpandnq %ymm0, %ymm23, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa (%rax), %ymm1
; AVX512F-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm5, %ymm1, %ymm3
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm5
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm19, %zmm0, %zmm0
; AVX512F-FAST-NEXT:    vmovdqa (%r9), %xmm1
; AVX512F-FAST-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa (%r8), %xmm2
; AVX512F-FAST-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX512F-FAST-NEXT:    vpshufb %xmm9, %xmm3, %xmm3
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm18, %zmm3
; AVX512F-FAST-NEXT:    vpternlogq $248, %zmm23, %zmm3, %zmm5
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpbroadcastd {{.*#+}} ymm7 = [18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21]
; AVX512F-FAST-NEXT:    vpshufb %ymm7, %ymm14, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm13[0,0,2,1,4,4,6,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3],ymm0[4,5],ymm3[6],ymm0[7,8,9,10],ymm3[11],ymm0[12,13],ymm3[14],ymm0[15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,1,u,3,10,10,11,11]
; AVX512F-FAST-NEXT:    vpermi2q %zmm0, %zmm21, %zmm3
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm26, %ymm9
; AVX512F-FAST-NEXT:    vpshufb %ymm9, %ymm8, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm4[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0,1,2],ymm0[3],ymm3[4,5],ymm0[6],ymm3[7,8,9,10],ymm0[11],ymm3[12,13],ymm0[14],ymm3[15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm29, %ymm1
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm8, %ymm3
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm4[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm5[0],ymm3[1],ymm5[2,3],ymm3[4],ymm5[5,6,7,8],ymm3[9],ymm5[10,11],ymm3[12],ymm5[13,14,15]
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm6, %zmm3
; AVX512F-FAST-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm27, %ymm11
; AVX512F-FAST-NEXT:    vpshufb %ymm11, %ymm10, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm15[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm5[0],ymm0[1],ymm5[2,3],ymm0[4],ymm5[5,6,7,8],ymm0[9],ymm5[10,11],ymm0[12],ymm5[13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm16, %ymm4
; AVX512F-FAST-NEXT:    vpshufb %ymm4, %ymm10, %ymm5
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm6 = ymm15[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm5[0,1],ymm6[2],ymm5[3,4],ymm6[5],ymm5[6,7,8,9],ymm6[10],ymm5[11,12],ymm6[13],ymm5[14,15]
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm17, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm24, %zmm16
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm3, %zmm24, %zmm2
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm15 = [26,27,28,29,26,27,28,29,26,27,28,29,30,31,30,31,26,27,28,29,26,27,28,29,26,27,28,29,30,31,30,31]
; AVX512F-FAST-NEXT:    # ymm15 = mem[0,1,0,1]
; AVX512F-FAST-NEXT:    vpshufb %ymm15, %ymm14, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm13[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm3[2],ymm0[3,4],ymm3[5],ymm0[6,7,8,9],ymm3[10],ymm0[11,12],ymm3[13],ymm0[14,15]
; AVX512F-FAST-NEXT:    vprold $16, %ymm14, %ymm3
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm13[1,2,2,3,5,6,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm5[0,1],ymm3[2],ymm5[3,4],ymm3[5],ymm5[6,7,8,9],ymm3[10],ymm5[11,12],ymm3[13],ymm5[14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm18 = [2,1,3,2,10,10,10,11]
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm18, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 (%rax), %zmm19
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [14,21,0,0,15,22,0,15,14,21,0,0,15,22,0,15]
; AVX512F-FAST-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vmovdqa 32(%rax), %ymm0
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpermi2d %zmm0, %zmm19, %zmm2
; AVX512F-FAST-NEXT:    vpternlogd $184, %zmm3, %zmm22, %zmm2
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufb %ymm1, %ymm13, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm28[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2,3],ymm0[4],ymm3[5,6,7,8],ymm0[9],ymm3[10,11],ymm0[12],ymm3[13,14,15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm13[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm28[1,1,1,1,5,5,5,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm5[2],ymm3[3,4],ymm5[5],ymm3[6,7,8,9],ymm5[10],ymm3[11,12],ymm5[13],ymm3[14,15]
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm17, %zmm3
; AVX512F-FAST-NEXT:    vmovdqu (%rsp), %ymm1 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufb %ymm4, %ymm1, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0,1],ymm5[2],ymm0[3,4],ymm5[5],ymm0[6,7,8,9],ymm5[10],ymm0[11,12],ymm5[13],ymm0[14,15]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm5 = ymm1[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm6 = ymm2[0,1,1,3,4,5,5,7]
; AVX512F-FAST-NEXT:    vmovdqa %ymm2, %ymm4
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0,1],ymm5[2],ymm6[3,4],ymm5[5],ymm6[6,7,8,9],ymm5[10],ymm6[11,12],ymm5[13],ymm6[14,15]
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm18, %zmm5
; AVX512F-FAST-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm3, %zmm5
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512F-FAST-NEXT:    vprold $16, %ymm8, %ymm0
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm2[1,2,2,3,5,6,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0,1],ymm0[2],ymm3[3,4],ymm0[5],ymm3[6,7,8,9],ymm0[10],ymm3[11,12],ymm0[13],ymm3[14,15]
; AVX512F-FAST-NEXT:    vpshufb %ymm7, %ymm8, %ymm3
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm6 = ymm2[0,0,2,1,4,4,6,5]
; AVX512F-FAST-NEXT:    vmovdqa %ymm2, %ymm14
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1,2],ymm6[3],ymm3[4,5],ymm6[6],ymm3[7,8,9,10],ymm6[11],ymm3[12,13],ymm6[14],ymm3[15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [2,2,3,3,10,9,11,10]
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm2, %zmm3
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm30, %zmm12, %zmm0
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,4,0,0,14,5,0,0,13,4,0,0,14,5,0]
; AVX512F-FAST-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermd %zmm0, %zmm2, %zmm0
; AVX512F-FAST-NEXT:    vpternlogd $184, %zmm3, %zmm25, %zmm0
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm5, %zmm0
; AVX512F-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %ymm11, %ymm1, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm1 = ymm4[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6,7,8],ymm0[9],ymm1[10,11],ymm0[12],ymm1[13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa 96(%rcx), %xmm3
; AVX512F-FAST-NEXT:    vmovdqa 96(%rdx), %xmm0
; AVX512F-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm3, %xmm29
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,2,3,0,1,2,3,6,7,4,5,6,7,4,5]
; AVX512F-FAST-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX512F-FAST-NEXT:    vmovdqa %xmm2, %xmm7
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm31 = [0,2,2,3,8,9,9,11]
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm31, %zmm1
; AVX512F-FAST-NEXT:    vpshufb %ymm9, %ymm13, %ymm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm28[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3],ymm2[4,5],ymm0[6],ymm2[7,8,9,10],ymm0[11],ymm2[12,13],ymm0[14],ymm2[15]
; AVX512F-FAST-NEXT:    vmovdqa 96(%rsi), %xmm4
; AVX512F-FAST-NEXT:    vmovdqa 96(%rdi), %xmm3
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm4, %xmm26
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm3, %xmm24
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = [0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-FAST-NEXT:    vpshufb %xmm9, %xmm2, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [2,1,3,3,8,8,9,9]
; AVX512F-FAST-NEXT:    vpermt2q %zmm2, %zmm3, %zmm0
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm1, %zmm16, %zmm0
; AVX512F-FAST-NEXT:    vpshufb %ymm15, %ymm8, %ymm1
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm14[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm13 = ymm1[0,1],ymm2[2],ymm1[3,4],ymm2[5],ymm1[6,7,8,9],ymm2[10],ymm1[11,12],ymm2[13],ymm1[14,15]
; AVX512F-FAST-NEXT:    vmovdqa 64(%rcx), %xmm2
; AVX512F-FAST-NEXT:    vmovdqa 64(%rdx), %xmm1
; AVX512F-FAST-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX512F-FAST-NEXT:    vpshufb %xmm4, %xmm2, %xmm5
; AVX512F-FAST-NEXT:    vmovdqa %xmm4, %xmm8
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm1[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0],xmm5[1],xmm6[2,3],xmm5[4],xmm6[5,6],xmm5[7]
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX512F-FAST-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX512F-FAST-NEXT:    vmovdqa %xmm7, %xmm14
; AVX512F-FAST-NEXT:    vpshufb %xmm7, %xmm1, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,1,1,3,8,8,9,9]
; AVX512F-FAST-NEXT:    vpermt2q %zmm5, %zmm1, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512F-FAST-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX512F-FAST-NEXT:    vmovdqa %xmm4, (%rsp) # 16-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa 64(%rsi), %xmm6
; AVX512F-FAST-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vprold $16, %xmm6, %xmm1
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[1,1,2,3]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm1[2],xmm5[3,4],xmm1[5],xmm5[6,7]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm6[0],xmm4[1],xmm6[1],xmm4[2],xmm6[2],xmm4[3],xmm6[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm9, %xmm1, %xmm1
; AVX512F-FAST-NEXT:    vmovdqa %xmm9, %xmm3
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm27 = [0,0,1,1,8,8,10,9]
; AVX512F-FAST-NEXT:    vpermt2q %zmm5, %zmm27, %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0]
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm2, %zmm5, %zmm1
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm20, %xmm2
; AVX512F-FAST-NEXT:    vpunpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX512F-FAST-NEXT:    # xmm2 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm7 = [0,1,2,3,6,7,4,5,6,7,4,5,12,13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm10 = [0,1,2,3,8,9,10,11,14,15,12,13,14,15,12,13]
; AVX512F-FAST-NEXT:    vpshufb %xmm10, %xmm2, %xmm6
; AVX512F-FAST-NEXT:    vpshufb %xmm7, %xmm2, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm16 = [0,0,0,1,8,9,9,11]
; AVX512F-FAST-NEXT:    vpermt2q %zmm6, %zmm16, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa (%rcx), %xmm4
; AVX512F-FAST-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa (%rdx), %xmm9
; AVX512F-FAST-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vpshufb %xmm8, %xmm4, %xmm6
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm9[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm6 = xmm8[0],xmm6[1],xmm8[2,3],xmm6[4],xmm8[5,6],xmm6[7]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm9[0],xmm4[0],xmm9[1],xmm4[1],xmm9[2],xmm4[2],xmm9[3],xmm4[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm14, %xmm8, %xmm8
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm14, %xmm21
; AVX512F-FAST-NEXT:    vpermt2q %zmm6, %zmm11, %zmm8
; AVX512F-FAST-NEXT:    vmovdqa (%rdi), %xmm4
; AVX512F-FAST-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vmovdqa (%rsi), %xmm11
; AVX512F-FAST-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX512F-FAST-NEXT:    vprold $16, %xmm11, %xmm6
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm4[1,1,2,3]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm6 = xmm9[0,1],xmm6[2],xmm9[3,4],xmm6[5],xmm9[6,7]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm9 = xmm4[0],xmm11[0],xmm4[1],xmm11[1],xmm4[2],xmm11[2],xmm4[3],xmm11[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm3, %xmm9, %xmm9
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm3, %xmm28
; AVX512F-FAST-NEXT:    vpermt2q %zmm6, %zmm27, %zmm9
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm8, %zmm5, %zmm9
; AVX512F-FAST-NEXT:    vpbroadcastd 64(%rax), %ymm5
; AVX512F-FAST-NEXT:    vpbroadcastd 68(%rax), %ymm6
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm5, %zmm23
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogd $184, %zmm2, %zmm4, %zmm23
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $184, %zmm1, %zmm2, %zmm23
; AVX512F-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX512F-FAST-NEXT:    vpunpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX512F-FAST-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm10, %xmm1, %xmm5
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm10, %xmm22
; AVX512F-FAST-NEXT:    vpshufb %xmm7, %xmm1, %xmm1
; AVX512F-FAST-NEXT:    vmovdqa %xmm7, %xmm3
; AVX512F-FAST-NEXT:    vpermt2q %zmm5, %zmm16, %zmm1
; AVX512F-FAST-NEXT:    vpbroadcastd (%rax), %ymm5
; AVX512F-FAST-NEXT:    vpbroadcastd 4(%rax), %ymm6
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm5, %zmm20
; AVX512F-FAST-NEXT:    vpternlogd $184, %zmm1, %zmm4, %zmm20
; AVX512F-FAST-NEXT:    vpternlogq $184, %zmm9, %zmm2, %zmm20
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[10,11,8,9,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,u,u,u,u,26,27,24,25,u,u,u,u]
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %ymm17 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm17[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3],ymm1[4],ymm2[5,6,7,8],ymm1[9],ymm2[10,11],ymm1[12],ymm2[13,14,15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm17[1,1,1,1,5,5,5,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm5[2],ymm2[3,4],ymm5[5],ymm2[6,7,8,9],ymm5[10],ymm2[11,12],ymm5[13],ymm2[14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [2,2,2,3,8,10,10,11]
; AVX512F-FAST-NEXT:    vpermt2q %zmm1, %zmm5, %zmm2
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,26,27,u,u,24,25,26,27,u,u,26,27,26,27]
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm7[2,2,2,2,6,6,6,6]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0,1],ymm5[2],ymm1[3,4],ymm5[5],ymm1[6,7,8,9],ymm5[10],ymm1[11,12],ymm5[13],ymm1[14,15]
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm5 = ymm9[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm6 = ymm7[0,1,1,3,4,5,5,7]
; AVX512F-FAST-NEXT:    vmovdqa %ymm7, %ymm15
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm8 = ymm6[0,1],ymm5[2],ymm6[3,4],ymm5[5],ymm6[6,7,8,9],ymm5[10],ymm6[11,12],ymm5[13],ymm6[14,15]
; AVX512F-FAST-NEXT:    vpermt2q %zmm1, %zmm18, %zmm8
; AVX512F-FAST-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm8
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX512F-FAST-NEXT:    vprold $16, %ymm5, %ymm1
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %ymm16 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm16[1,2,2,3,5,6,6,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7,8,9],ymm1[10],ymm2[11,12],ymm1[13],ymm2[14,15]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,20,21,18,19,20,21,18,19,20,21]
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm5, %ymm18
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm16[0,0,2,1,4,4,6,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1,2],ymm5[3],ymm2[4,5],ymm5[6],ymm2[7,8,9,10],ymm5[11],ymm2[12,13],ymm5[14],ymm2[15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [2,2,3,3,10,9,11,10]
; AVX512F-FAST-NEXT:    vpermt2q %zmm1, %zmm5, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [2,2,2,3,8,8,8,9]
; AVX512F-FAST-NEXT:    vmovdqa 96(%r9), %xmm11
; AVX512F-FAST-NEXT:    vmovdqa 96(%r8), %xmm7
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm10 = xmm7[0],xmm11[0],xmm7[1],xmm11[1],xmm7[2],xmm11[2],xmm7[3],xmm11[3]
; AVX512F-FAST-NEXT:    vpshufb %xmm3, %xmm10, %xmm1
; AVX512F-FAST-NEXT:    vpermt2q %zmm1, %zmm5, %zmm13
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm14, %zmm19, %zmm1
; AVX512F-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [0,13,4,0,0,14,5,0,0,13,4,0,0,14,5,0]
; AVX512F-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-FAST-NEXT:    vpermd %zmm1, %zmm5, %zmm19
; AVX512F-FAST-NEXT:    vpternlogd $184, %zmm2, %zmm25, %zmm19
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm8, %zmm19
; AVX512F-FAST-NEXT:    vmovdqa 32(%rcx), %xmm12
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdx), %xmm8
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm8[0],xmm12[0],xmm8[1],xmm12[1],xmm8[2],xmm12[2],xmm8[3],xmm12[3]
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm21, %xmm2
; AVX512F-FAST-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm9[14,15,12,13,u,u,u,u,u,u,u,u,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29,u,u,u,u]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm15[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm15 = ymm9[0],ymm2[1],ymm9[2,3],ymm2[4],ymm9[5,6,7,8],ymm2[9],ymm9[10,11],ymm2[12],ymm9[13,14,15]
; AVX512F-FAST-NEXT:    vpermt2q %zmm1, %zmm31, %zmm15
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm31 = [6,7,3,3,7,7,6,7]
; AVX512F-FAST-NEXT:    vpermd %ymm30, %ymm31, %ymm1
; AVX512F-FAST-NEXT:    vpbroadcastd 96(%rax), %ymm2
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm21
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm30 = [65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogd $184, %zmm13, %zmm30, %zmm21
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm21
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm24, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm26, %xmm1
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX512F-FAST-NEXT:    vprold $16, %xmm26, %xmm1
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm24[1,1,2,3]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm2[0,1],xmm1[2],xmm2[3,4],xmm1[5],xmm2[6,7]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,14,15,12,13,u,u,u,u,30,31,28,29,u,u,u,u,30,31,28,29]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm17[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3],ymm2[4,5],ymm1[6],ymm2[7,8,9,10],ymm1[11],ymm2[12,13],ymm1[14],ymm2[15]
; AVX512F-FAST-NEXT:    vmovdqa 32(%rdi), %xmm5
; AVX512F-FAST-NEXT:    vmovdqa 32(%rsi), %xmm4
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm13 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm28, %xmm6
; AVX512F-FAST-NEXT:    vpshufb %xmm6, %xmm13, %xmm13
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [2,1,3,3,8,8,9,9]
; AVX512F-FAST-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,2,3,4,5,6,7,8,9,10,11,10,11,8,9]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [0,0,2,1,8,8,9,11]
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm17, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm29, %xmm0
; AVX512F-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm9[4],xmm0[4],xmm9[5],xmm0[5],xmm9[6],xmm0[6],xmm9[7],xmm0[7]
; AVX512F-FAST-NEXT:    vpbroadcastq {{.*#+}} xmm24 = [6,7,4,5,0,0,8,9,6,7,4,5,0,0,8,9]
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm24, %xmm13
; AVX512F-FAST-NEXT:    vpshufb %xmm13, %xmm0, %xmm0
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm9 = xmm9[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm9[0],xmm0[1],xmm9[2,3],xmm0[4],xmm9[5,6],xmm0[7]
; AVX512F-FAST-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,2,3,3,4,5,6,7]
; AVX512F-FAST-NEXT:    vpermt2q %zmm2, %zmm27, %zmm0
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm25 = [65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535,65535,0,0,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm3, %zmm25, %zmm0
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm7[4],xmm11[4],xmm7[5],xmm11[5],xmm7[6],xmm11[6],xmm7[7],xmm11[7]
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-FAST-NEXT:    vpternlogq $184, %ymm3, %ymm30, %ymm7
; AVX512F-FAST-NEXT:    vextracti64x4 $1, %zmm3, %ymm11
; AVX512F-FAST-NEXT:    vpshufb %xmm6, %xmm2, %xmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm22, %xmm13
; AVX512F-FAST-NEXT:    vpshufb %xmm13, %xmm10, %xmm3
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm28 = [0,1,1,3,8,8,9,9]
; AVX512F-FAST-NEXT:    vpermt2q %zmm2, %zmm28, %zmm3
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm6[0,1,2,3,5,5,7,6,8,9,10,11,13,13,15,14]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm26 = ymm2[3,3,3,3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,24,25,22,23,22,23,u,u,u,u,u,u,u,u]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm29 = ymm2[2,2,2,2]
; AVX512F-FAST-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm15, %zmm1
; AVX512F-FAST-NEXT:    vpbroadcastd 100(%rax), %ymm2
; AVX512F-FAST-NEXT:    vpbroadcastd 104(%rax), %ymm6
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm2, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm22 = [65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogd $184, %zmm3, %zmm22, %zmm2
; AVX512F-FAST-NEXT:    vmovdqa64 %ymm18, %ymm3
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,28,29,26,27,28,29,26,27,28,29,30,31,30,31]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} ymm6 = ymm16[3,3,3,3,7,7,7,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm10 = ymm3[0,1],ymm6[2],ymm3[3,4],ymm6[5],ymm3[6,7,8,9],ymm6[10],ymm3[11,12],ymm6[13],ymm3[14,15]
; AVX512F-FAST-NEXT:    vmovdqa 32(%r9), %xmm15
; AVX512F-FAST-NEXT:    vmovdqa 32(%r8), %xmm3
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm3[0],xmm15[0],xmm3[1],xmm15[1],xmm3[2],xmm15[2],xmm3[3],xmm15[3]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm9 = xmm6[0,1,2,3,6,7,4,5,6,7,4,5,12,13,14,15]
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm16 = [2,2,2,3,8,8,8,9]
; AVX512F-FAST-NEXT:    vpermt2q %zmm9, %zmm16, %zmm10
; AVX512F-FAST-NEXT:    vpermd %ymm14, %ymm31, %ymm9
; AVX512F-FAST-NEXT:    vpbroadcastd 32(%rax), %ymm18
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm18, %zmm9, %zmm9
; AVX512F-FAST-NEXT:    vpternlogd $184, %zmm10, %zmm30, %zmm9
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm9
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0]
; AVX512F-FAST-NEXT:    vpternlogq $184, %zmm0, %zmm1, %zmm2
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm4[4],xmm5[4],xmm4[5],xmm5[5],xmm4[6],xmm5[6],xmm4[7],xmm5[7]
; AVX512F-FAST-NEXT:    vprold $16, %xmm4, %xmm4
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[1,1,2,3]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0,1],xmm4[2],xmm5[3,4],xmm4[5],xmm5[6,7]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm10 = [4,5,2,3,4,5,6,7,8,9,10,11,10,11,8,9]
; AVX512F-FAST-NEXT:    vpshufb %xmm10, %xmm0, %xmm0
; AVX512F-FAST-NEXT:    vpermt2q %zmm0, %zmm17, %zmm4
; AVX512F-FAST-NEXT:    vmovdqa64 %xmm24, %xmm0
; AVX512F-FAST-NEXT:    vpshufb %xmm0, %xmm12, %xmm0
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm8[4],xmm12[4],xmm8[5],xmm12[5],xmm8[6],xmm12[6],xmm8[7],xmm12[7]
; AVX512F-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm8[1,1,2,2]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm8[0],xmm0[1],xmm8[2,3],xmm0[4],xmm8[5,6],xmm0[7]
; AVX512F-FAST-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,2,3,3,4,5,6,7]
; AVX512F-FAST-NEXT:    vpermt2q %zmm5, %zmm27, %zmm0
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm4, %zmm25, %zmm0
; AVX512F-FAST-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm3[4],xmm15[4],xmm3[5],xmm15[5],xmm3[6],xmm15[6],xmm3[7],xmm15[7]
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,5,6,7,10,11,8,9,10,11]
; AVX512F-FAST-NEXT:    vpshufb %xmm13, %xmm6, %xmm4
; AVX512F-FAST-NEXT:    vpermt2q %zmm3, %zmm28, %zmm4
; AVX512F-FAST-NEXT:    vpbroadcastd 36(%rax), %ymm3
; AVX512F-FAST-NEXT:    vpbroadcastd 40(%rax), %ymm5
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm5, %zmm3, %zmm3
; AVX512F-FAST-NEXT:    vpternlogd $184, %zmm4, %zmm22, %zmm3
; AVX512F-FAST-NEXT:    vpternlogq $184, %zmm0, %zmm1, %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535]
; AVX512F-FAST-NEXT:    vpternlogq $184, %ymm7, %ymm0, %ymm29
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogd $226, 124(%r8){1to8}, %ymm0, %ymm11
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpternlogq $184, %ymm11, %ymm0, %ymm26
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm26, %zmm0, %zmm1
; AVX512F-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm29[0,1,2,3],zmm1[4,5,6,7]
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512F-FAST-NEXT:    vpternlogd $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm1, %zmm12
; AVX512F-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX512F-FAST-NEXT:    vpunpckhwd (%rsp), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX512F-FAST-NEXT:    # xmm1 = xmm1[4],mem[4],xmm1[5],mem[5],xmm1[6],mem[6],xmm1[7],mem[7]
; AVX512F-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX512F-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX512F-FAST-NEXT:    # xmm4 = xmm4[4],mem[4],xmm4[5],mem[5],xmm4[6],mem[6],xmm4[7],mem[7]
; AVX512F-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX512F-FAST-NEXT:    vpunpckhwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX512F-FAST-NEXT:    # xmm5 = xmm5[4],mem[4],xmm5[5],mem[5],xmm5[6],mem[6],xmm5[7],mem[7]
; AVX512F-FAST-NEXT:    vpshufb %xmm10, %xmm1, %xmm1
; AVX512F-FAST-NEXT:    vpshufb %xmm10, %xmm5, %xmm5
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpunpcklwd {{.*#+}} ymm6 = ymm6[0,0,1,1,2,2,3,3,8,8,9,9,10,10,11,11]
; AVX512F-FAST-NEXT:    vpshufd $212, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    # ymm7 = mem[0,1,1,3,4,5,5,7]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0,1],ymm6[2],ymm7[3,4],ymm6[5],ymm7[6,7,8,9],ymm6[10],ymm7[11,12],ymm6[13],ymm7[14,15]
; AVX512F-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm7 = ymm7[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,20,21,18,19,20,21,24,25,26,27,22,23,22,23]
; AVX512F-FAST-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    # ymm8 = mem[1,1,1,1,5,5,5,5]
; AVX512F-FAST-NEXT:    vpblendw {{.*#+}} ymm7 = ymm7[0,1],ymm8[2],ymm7[3,4],ymm8[5],ymm7[6,7,8,9],ymm8[10],ymm7[11,12],ymm8[13],ymm7[14,15]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,1,4,5,4,5,5,7]
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-FAST-NEXT:    vpermd %ymm10, %ymm8, %ymm8
; AVX512F-FAST-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[12,13],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm10[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm10[16,17],zero,zero
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535,65535,0,65535,65535,65535,65535,65535]
; AVX512F-FAST-NEXT:    vpandn %ymm8, %ymm11, %ymm8
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm8, %zmm10, %zmm8
; AVX512F-FAST-NEXT:    vpshuflw $248, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; AVX512F-FAST-NEXT:    # xmm10 = mem[0,2,3,3,4,5,6,7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[0,0,2,1]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,1,3]
; AVX512F-FAST-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[0,2,3,3,4,5,6,7]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,2,1]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,1,3]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,1,3,2]
; AVX512F-FAST-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[2,2,2,3]
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm11, %zmm13
; AVX512F-FAST-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm1 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm10, %zmm25, %zmm1
; AVX512F-FAST-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm4 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    vinserti64x4 $1, {{[-0-9]+}}(%r{{[sb]}}p), %zmm5, %zmm5 # 32-byte Folded Reload
; AVX512F-FAST-NEXT:    vpternlogq $226, %zmm4, %zmm25, %zmm5
; AVX512F-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535,65535,65535,65535,0,0,0,65535]
; AVX512F-FAST-NEXT:    vpternlogq $226, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm1 # 64-byte Folded Reload
; AVX512F-FAST-NEXT:    vpternlogq $226, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm5 # 64-byte Folded Reload
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm6, %zmm4, %zmm4
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-FAST-NEXT:    vinserti64x4 $1, %ymm7, %zmm6, %zmm6
; AVX512F-FAST-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm4, %zmm6
; AVX512F-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-FAST-NEXT:    vpternlogq $248, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm4 # 64-byte Folded Reload
; AVX512F-FAST-NEXT:    vpternlogq $248, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm8 # 64-byte Folded Reload
; AVX512F-FAST-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm6, %zmm8
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm8, 320(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm3, 256(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm9, 192(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm19, 128(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm20, (%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm23, 448(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm2, 704(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm21, 640(%rax)
; AVX512F-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-FAST-NEXT:    vmovaps %zmm0, 576(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm13, 384(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm1, 512(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm12, 832(%rax)
; AVX512F-FAST-NEXT:    vmovdqa64 %zmm4, 768(%rax)
; AVX512F-FAST-NEXT:    addq $1496, %rsp # imm = 0x5D8
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-LABEL: store_i16_stride7_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $136, %rsp
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm29
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm15
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm9
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm25
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm12
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm30
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm26
; AVX512BW-NEXT:    vmovdqa64 (%rax), %zmm20
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [0,0,30,62,28,60,0,0,0,31,63,29,61,0,0,0,0,0,30,62,28,60,0,0,0,31,63,29,61,0,0,0]
; AVX512BW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512BW-NEXT:    vpermt2w %zmm9, %zmm21, %zmm0
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [27,0,0,0,62,30,60,28,0,0,0,63,31,61,29,0,27,0,0,0,62,30,60,28,0,0,0,63,31,61,29,0]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm3
; AVX512BW-NEXT:    vpermt2w %zmm25, %zmm6, %zmm3
; AVX512BW-NEXT:    movl $101455920, %ecx # imm = 0x60C1830
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,59,u,u,4,5,6,7,60,u,u,11,12,13,14,61,u,u,18,19,20,21,62,u,u,25,26,27,28,63,u,u]
; AVX512BW-NEXT:    vpermi2w %zmm30, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm24 = [0,25,57,23,55,0,0,0,26,58,24,56,0,0,0,27,0,25,57,23,55,0,0,0,26,58,24,56,0,0,0,27]
; AVX512BW-NEXT:    # zmm24 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm24, %zmm0
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [57,23,55,0,0,0,26,58,24,56,0,0,0,27,59,25,57,23,55,0,0,0,26,58,24,56,0,0,0,27,59,25]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512BW-NEXT:    vpermt2w %zmm9, %zmm11, %zmm3
; AVX512BW-NEXT:    movl $-2096755688, %ecx # imm = 0x83060C18
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm3 {%k2}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [u,1,2,3,4,55,u,u,8,9,10,11,56,u,u,15,16,17,18,57,u,u,22,23,24,25,58,u,u,29,30,31]
; AVX512BW-NEXT:    vpermi2w %zmm30, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [2,34,0,32,0,0,0,3,35,1,33,0,0,0,4,36,2,34,0,32,0,0,0,3,35,1,33,0,0,0,4,36]
; AVX512BW-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2w %zmm12, %zmm19, %zmm0
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [0,32,0,0,0,3,35,1,33,0,0,0,4,36,2,34,0,32,0,0,0,3,35,1,33,0,0,0,4,36,2,34]
; AVX512BW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512BW-NEXT:    vpermt2w %zmm15, %zmm28, %zmm7
; AVX512BW-NEXT:    movl $-1048377844, %ecx # imm = 0xC183060C
; AVX512BW-NEXT:    kmovd %ecx, %k3
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm7 {%k3}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,0,2,34,0,32,0,0,0,3,35,1,33,0,0,0,0,0,2,34,0,32,0,0,0,3,35,1,33,0,0,0]
; AVX512BW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512BW-NEXT:    vpermt2w %zmm8, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm17
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [9,0,0,0,44,12,42,10,0,0,0,45,13,43,11,0,9,0,0,0,44,12,42,10,0,0,0,45,13,43,11,0]
; AVX512BW-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm31
; AVX512BW-NEXT:    vpermt2w %zmm29, %zmm23, %zmm31
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm18
; AVX512BW-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm19, %zmm25
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm19
; AVX512BW-NEXT:    vpermt2w %zmm9, %zmm28, %zmm29
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [u,u,u,u,4,5,32,u,u,u,u,11,12,33,u,u,u,u,18,19,34,u,u,u,u,25,26,35,u,u,u,u]
; AVX512BW-NEXT:    vpermt2w %zmm20, %zmm2, %zmm0
; AVX512BW-NEXT:    movl $236730480, %ecx # imm = 0xE1C3870
; AVX512BW-NEXT:    vmovdqu16 %zmm25, %zmm29 {%k3}
; AVX512BW-NEXT:    kmovd %ecx, %k3
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm7 {%k3}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [13,0,0,0,48,16,46,14,0,0,0,49,17,47,15,0,13,0,0,0,48,16,46,14,0,0,0,49,17,47,15,0]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm10
; AVX512BW-NEXT:    vpermt2w %zmm30, %zmm0, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm28
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2w %zmm26, %zmm25, %zmm30
; AVX512BW-NEXT:    vmovdqa64 64(%rax), %zmm25
; AVX512BW-NEXT:    vpermt2w %zmm25, %zmm2, %zmm30
; AVX512BW-NEXT:    vmovdqu16 %zmm30, %zmm29 {%k3}
; AVX512BW-NEXT:    vpermi2w %zmm15, %zmm14, %zmm21
; AVX512BW-NEXT:    vpermi2w %zmm5, %zmm12, %zmm6
; AVX512BW-NEXT:    vmovdqu16 %zmm21, %zmm6 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [61,27,59,0,0,0,30,62,28,60,0,0,0,31,63,29,61,27,59,0,0,0,30,62,28,60,0,0,0,31,63,29]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm8, %zmm4, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm21 = [u,1,2,59,u,u,u,u,8,9,60,u,u,u,u,15,16,61,u,u,u,u,22,23,62,u,u,u,u,29,30,63]
; AVX512BW-NEXT:    vpermi2w %zmm20, %zmm2, %zmm21
; AVX512BW-NEXT:    movl $-507279602, %eax # imm = 0xE1C3870E
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqu16 %zmm21, %zmm6 {%k3}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,0,0,21,53,19,51,0,0,0,22,54,20,52,0,0,0,0,0,21,53,19,51,0,0,0,22,54,20,52,0,0]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2w %zmm9, %zmm2, %zmm3
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [18,50,0,0,0,21,53,19,51,0,0,0,22,54,20,52,18,50,0,0,0,21,53,19,51,0,0,0,22,54,20,52]
; AVX512BW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm21, %zmm16
; AVX512BW-NEXT:    movl $202911840, %eax # imm = 0xC183060
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqu16 %zmm3, %zmm16 {%k3}
; AVX512BW-NEXT:    vpermi2w %zmm12, %zmm5, %zmm24
; AVX512BW-NEXT:    vpermi2w %zmm15, %zmm14, %zmm11
; AVX512BW-NEXT:    vmovdqu16 %zmm24, %zmm11 {%k2}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,0,0,25,57,23,55,0,0,0,26,58,24,56,0,0,0,0,0,25,57,23,55,0,0,0,26,58,24,56,0,0]
; AVX512BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2w %zmm8, %zmm4, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm24 = [54,u,u,u,u,5,6,55,u,u,u,u,12,13,56,u,u,u,u,19,20,57,u,u,u,u,26,27,58,u,u,u]
; AVX512BW-NEXT:    vpermi2w %zmm20, %zmm3, %zmm24
; AVX512BW-NEXT:    movl $473460961, %eax # imm = 0x1C3870E1
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu16 %zmm24, %zmm11 {%k2}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [20,52,18,50,0,0,0,21,53,19,51,0,0,0,22,54,20,52,18,50,0,0,0,21,53,19,51,0,0,0,22,54]
; AVX512BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2w %zmm26, %zmm3, %zmm22
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm24 = [u,u,2,3,50,u,u,u,u,9,10,51,u,u,u,u,16,17,52,u,u,u,u,23,24,53,u,u,u,u,30,31]
; AVX512BW-NEXT:    vpermt2w %zmm25, %zmm24, %zmm22
; AVX512BW-NEXT:    movl $-1014559204, %eax # imm = 0xC3870E1C
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu16 %zmm22, %zmm16 {%k2}
; AVX512BW-NEXT:    vpermi2w %zmm15, %zmm14, %zmm2
; AVX512BW-NEXT:    vpermi2w %zmm12, %zmm5, %zmm21
; AVX512BW-NEXT:    vmovdqu16 %zmm2, %zmm21 {%k3}
; AVX512BW-NEXT:    vpermi2w %zmm8, %zmm4, %zmm3
; AVX512BW-NEXT:    vpermt2w %zmm20, %zmm24, %zmm3
; AVX512BW-NEXT:    vmovdqu16 %zmm3, %zmm21 {%k2}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,0,16,48,14,46,0,0,0,17,49,15,47,0,0,0,0,0,16,48,14,46,0,0,0,17,49,15,47,0,0,0]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm2, %zmm27
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [16,48,14,46,0,0,0,17,49,15,47,0,0,0,18,50,16,48,14,46,0,0,0,17,49,15,47,0,0,0,18,50]
; AVX512BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2w %zmm9, %zmm3, %zmm17
; AVX512BW-NEXT:    vmovdqu16 %zmm27, %zmm17 {%k1}
; AVX512BW-NEXT:    vpermi2w %zmm12, %zmm5, %zmm2
; AVX512BW-NEXT:    vpermi2w %zmm15, %zmm14, %zmm3
; AVX512BW-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,45,u,u,u,u,6,7,46,u,u,u,u,13,14,47,u,u,u,u,20,21,48,u,u,u,u,27,28,49,u,u]
; AVX512BW-NEXT:    vpermt2w %zmm25, %zmm2, %zmm10
; AVX512BW-NEXT:    movl $946921923, %eax # imm = 0x3870E1C3
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm10, %zmm17 {%k1}
; AVX512BW-NEXT:    vpermi2w %zmm4, %zmm8, %zmm0
; AVX512BW-NEXT:    vpermt2w %zmm20, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [43,9,41,0,0,0,12,44,10,42,0,0,0,13,45,11,43,9,41,0,0,0,12,44,10,42,0,0,0,13,45,11]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm0, %zmm18
; AVX512BW-NEXT:    movl $405823681, %eax # imm = 0x183060C1
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm31, %zmm18 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,11,43,9,41,0,0,0,12,44,10,42,0,0,0,13,0,11,43,9,41,0,0,0,12,44,10,42,0,0,0,13]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2w %zmm26, %zmm2, %zmm1
; AVX512BW-NEXT:    vpermi2w %zmm14, %zmm15, %zmm23
; AVX512BW-NEXT:    vpermi2w %zmm12, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqu16 %zmm23, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [u,u,u,3,4,41,u,u,u,u,10,11,42,u,u,u,u,17,18,43,u,u,u,u,24,25,44,u,u,u,u,31]
; AVX512BW-NEXT:    vpermt2w %zmm25, %zmm10, %zmm1
; AVX512BW-NEXT:    movl $-2029118408, %eax # imm = 0x870E1C38
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm1, %zmm18 {%k1}
; AVX512BW-NEXT:    vpermi2w %zmm8, %zmm4, %zmm2
; AVX512BW-NEXT:    vpermt2w %zmm20, %zmm10, %zmm2
; AVX512BW-NEXT:    vmovdqu16 %zmm2, %zmm0 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,0,0,7,39,5,37,0,0,0,8,40,6,38,0,0,0,0,0,7,39,5,37,0,0,0,8,40,6,38,0,0]
; AVX512BW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2w %zmm13, %zmm1, %zmm2
; AVX512BW-NEXT:    vpermt2w %zmm12, %zmm1, %zmm5
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,7,39,5,37,0,0,0,8,40,6,38,0,0,0,9,0,7,39,5,37,0,0,0,8,40,6,38,0,0,0,9]
; AVX512BW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2w %zmm9, %zmm1, %zmm19
; AVX512BW-NEXT:    vpermt2w %zmm15, %zmm1, %zmm14
; AVX512BW-NEXT:    vmovdqu16 %zmm2, %zmm19 {%k3}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [4,36,0,0,0,7,39,5,37,0,0,0,8,40,6,38,4,36,0,0,0,7,39,5,37,0,0,0,8,40,6,38]
; AVX512BW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2w %zmm8, %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2w %zmm26, %zmm1, %zmm28
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,1,36,u,u,u,u,7,8,37,u,u,u,u,14,15,38,u,u,u,u,21,22,39,u,u,u,u,28,29,40,u]
; AVX512BW-NEXT:    vpermt2w %zmm20, %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2w %zmm25, %zmm1, %zmm28
; AVX512BW-NEXT:    vmovdqu16 %zmm5, %zmm14 {%k3}
; AVX512BW-NEXT:    movl $1893843847, %eax # imm = 0x70E1C387
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm28, %zmm19 {%k1}
; AVX512BW-NEXT:    vmovdqu16 %zmm4, %zmm14 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,1,59,u,4,5,6,7,8,60,u,11,12,13,14,15,61,u,18,19,20,21,22,62,u,25,26,27,28,29,63,u]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermi2w %zmm26, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [u,1,2,3,4,5,55,u,8,9,10,11,12,56,u,15,16,17,18,19,57,u,22,23,24,25,26,58,u,29,30,31]
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermi2w %zmm26, %zmm4, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,2,59,4,5,6,7,8,9,60,11,12,13,14,15,16,61,18,19,20,21,22,23,62,25,26,27,28,29,30,63]
; AVX512BW-NEXT:    vpermi2w %zmm25, %zmm1, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [54,1,2,3,4,5,6,55,8,9,10,11,12,13,56,15,16,17,18,19,20,57,22,23,24,25,26,27,58,29,30,31]
; AVX512BW-NEXT:    vpermi2w %zmm25, %zmm2, %zmm1
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, 448(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 512(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 576(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 640(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 704(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 768(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512BW-NEXT:    addq $136, %rsp
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <64 x i16>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i16>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i16>, ptr %in.vecptr2, align 64
  %in.vec3 = load <64 x i16>, ptr %in.vecptr3, align 64
  %in.vec4 = load <64 x i16>, ptr %in.vecptr4, align 64
  %in.vec5 = load <64 x i16>, ptr %in.vecptr5, align 64
  %in.vec6 = load <64 x i16>, ptr %in.vecptr6, align 64
  %1 = shufflevector <64 x i16> %in.vec0, <64 x i16> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i16> %in.vec2, <64 x i16> %in.vec3, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %3 = shufflevector <64 x i16> %in.vec4, <64 x i16> %in.vec5, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %4 = shufflevector <128 x i16> %1, <128 x i16> %2, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %5 = shufflevector <64 x i16> %in.vec6, <64 x i16> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <128 x i16> %3, <128 x i16> %5, <192 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191>
  %7 = shufflevector <192 x i16> %6, <192 x i16> poison, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <256 x i16> %4, <256 x i16> %7, <448 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255, i32 256, i32 257, i32 258, i32 259, i32 260, i32 261, i32 262, i32 263, i32 264, i32 265, i32 266, i32 267, i32 268, i32 269, i32 270, i32 271, i32 272, i32 273, i32 274, i32 275, i32 276, i32 277, i32 278, i32 279, i32 280, i32 281, i32 282, i32 283, i32 284, i32 285, i32 286, i32 287, i32 288, i32 289, i32 290, i32 291, i32 292, i32 293, i32 294, i32 295, i32 296, i32 297, i32 298, i32 299, i32 300, i32 301, i32 302, i32 303, i32 304, i32 305, i32 306, i32 307, i32 308, i32 309, i32 310, i32 311, i32 312, i32 313, i32 314, i32 315, i32 316, i32 317, i32 318, i32 319, i32 320, i32 321, i32 322, i32 323, i32 324, i32 325, i32 326, i32 327, i32 328, i32 329, i32 330, i32 331, i32 332, i32 333, i32 334, i32 335, i32 336, i32 337, i32 338, i32 339, i32 340, i32 341, i32 342, i32 343, i32 344, i32 345, i32 346, i32 347, i32 348, i32 349, i32 350, i32 351, i32 352, i32 353, i32 354, i32 355, i32 356, i32 357, i32 358, i32 359, i32 360, i32 361, i32 362, i32 363, i32 364, i32 365, i32 366, i32 367, i32 368, i32 369, i32 370, i32 371, i32 372, i32 373, i32 374, i32 375, i32 376, i32 377, i32 378, i32 379, i32 380, i32 381, i32 382, i32 383, i32 384, i32 385, i32 386, i32 387, i32 388, i32 389, i32 390, i32 391, i32 392, i32 393, i32 394, i32 395, i32 396, i32 397, i32 398, i32 399, i32 400, i32 401, i32 402, i32 403, i32 404, i32 405, i32 406, i32 407, i32 408, i32 409, i32 410, i32 411, i32 412, i32 413, i32 414, i32 415, i32 416, i32 417, i32 418, i32 419, i32 420, i32 421, i32 422, i32 423, i32 424, i32 425, i32 426, i32 427, i32 428, i32 429, i32 430, i32 431, i32 432, i32 433, i32 434, i32 435, i32 436, i32 437, i32 438, i32 439, i32 440, i32 441, i32 442, i32 443, i32 444, i32 445, i32 446, i32 447>
  %interleaved.vec = shufflevector <448 x i16> %8, <448 x i16> poison, <448 x i32> <i32 0, i32 64, i32 128, i32 192, i32 256, i32 320, i32 384, i32 1, i32 65, i32 129, i32 193, i32 257, i32 321, i32 385, i32 2, i32 66, i32 130, i32 194, i32 258, i32 322, i32 386, i32 3, i32 67, i32 131, i32 195, i32 259, i32 323, i32 387, i32 4, i32 68, i32 132, i32 196, i32 260, i32 324, i32 388, i32 5, i32 69, i32 133, i32 197, i32 261, i32 325, i32 389, i32 6, i32 70, i32 134, i32 198, i32 262, i32 326, i32 390, i32 7, i32 71, i32 135, i32 199, i32 263, i32 327, i32 391, i32 8, i32 72, i32 136, i32 200, i32 264, i32 328, i32 392, i32 9, i32 73, i32 137, i32 201, i32 265, i32 329, i32 393, i32 10, i32 74, i32 138, i32 202, i32 266, i32 330, i32 394, i32 11, i32 75, i32 139, i32 203, i32 267, i32 331, i32 395, i32 12, i32 76, i32 140, i32 204, i32 268, i32 332, i32 396, i32 13, i32 77, i32 141, i32 205, i32 269, i32 333, i32 397, i32 14, i32 78, i32 142, i32 206, i32 270, i32 334, i32 398, i32 15, i32 79, i32 143, i32 207, i32 271, i32 335, i32 399, i32 16, i32 80, i32 144, i32 208, i32 272, i32 336, i32 400, i32 17, i32 81, i32 145, i32 209, i32 273, i32 337, i32 401, i32 18, i32 82, i32 146, i32 210, i32 274, i32 338, i32 402, i32 19, i32 83, i32 147, i32 211, i32 275, i32 339, i32 403, i32 20, i32 84, i32 148, i32 212, i32 276, i32 340, i32 404, i32 21, i32 85, i32 149, i32 213, i32 277, i32 341, i32 405, i32 22, i32 86, i32 150, i32 214, i32 278, i32 342, i32 406, i32 23, i32 87, i32 151, i32 215, i32 279, i32 343, i32 407, i32 24, i32 88, i32 152, i32 216, i32 280, i32 344, i32 408, i32 25, i32 89, i32 153, i32 217, i32 281, i32 345, i32 409, i32 26, i32 90, i32 154, i32 218, i32 282, i32 346, i32 410, i32 27, i32 91, i32 155, i32 219, i32 283, i32 347, i32 411, i32 28, i32 92, i32 156, i32 220, i32 284, i32 348, i32 412, i32 29, i32 93, i32 157, i32 221, i32 285, i32 349, i32 413, i32 30, i32 94, i32 158, i32 222, i32 286, i32 350, i32 414, i32 31, i32 95, i32 159, i32 223, i32 287, i32 351, i32 415, i32 32, i32 96, i32 160, i32 224, i32 288, i32 352, i32 416, i32 33, i32 97, i32 161, i32 225, i32 289, i32 353, i32 417, i32 34, i32 98, i32 162, i32 226, i32 290, i32 354, i32 418, i32 35, i32 99, i32 163, i32 227, i32 291, i32 355, i32 419, i32 36, i32 100, i32 164, i32 228, i32 292, i32 356, i32 420, i32 37, i32 101, i32 165, i32 229, i32 293, i32 357, i32 421, i32 38, i32 102, i32 166, i32 230, i32 294, i32 358, i32 422, i32 39, i32 103, i32 167, i32 231, i32 295, i32 359, i32 423, i32 40, i32 104, i32 168, i32 232, i32 296, i32 360, i32 424, i32 41, i32 105, i32 169, i32 233, i32 297, i32 361, i32 425, i32 42, i32 106, i32 170, i32 234, i32 298, i32 362, i32 426, i32 43, i32 107, i32 171, i32 235, i32 299, i32 363, i32 427, i32 44, i32 108, i32 172, i32 236, i32 300, i32 364, i32 428, i32 45, i32 109, i32 173, i32 237, i32 301, i32 365, i32 429, i32 46, i32 110, i32 174, i32 238, i32 302, i32 366, i32 430, i32 47, i32 111, i32 175, i32 239, i32 303, i32 367, i32 431, i32 48, i32 112, i32 176, i32 240, i32 304, i32 368, i32 432, i32 49, i32 113, i32 177, i32 241, i32 305, i32 369, i32 433, i32 50, i32 114, i32 178, i32 242, i32 306, i32 370, i32 434, i32 51, i32 115, i32 179, i32 243, i32 307, i32 371, i32 435, i32 52, i32 116, i32 180, i32 244, i32 308, i32 372, i32 436, i32 53, i32 117, i32 181, i32 245, i32 309, i32 373, i32 437, i32 54, i32 118, i32 182, i32 246, i32 310, i32 374, i32 438, i32 55, i32 119, i32 183, i32 247, i32 311, i32 375, i32 439, i32 56, i32 120, i32 184, i32 248, i32 312, i32 376, i32 440, i32 57, i32 121, i32 185, i32 249, i32 313, i32 377, i32 441, i32 58, i32 122, i32 186, i32 250, i32 314, i32 378, i32 442, i32 59, i32 123, i32 187, i32 251, i32 315, i32 379, i32 443, i32 60, i32 124, i32 188, i32 252, i32 316, i32 380, i32 444, i32 61, i32 125, i32 189, i32 253, i32 317, i32 381, i32 445, i32 62, i32 126, i32 190, i32 254, i32 318, i32 382, i32 446, i32 63, i32 127, i32 191, i32 255, i32 319, i32 383, i32 447>
  store <448 x i16> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
; AVX1: {{.*}}
; AVX2: {{.*}}
; AVX512: {{.*}}
; AVX512-FAST: {{.*}}
; AVX512-SLOW: {{.*}}
; AVX512BW-ONLY: {{.*}}
; AVX512BW-ONLY-FAST: {{.*}}
; AVX512BW-ONLY-SLOW: {{.*}}
; AVX512DQ-FAST: {{.*}}
; AVX512DQ-ONLY: {{.*}}
; AVX512DQ-SLOW: {{.*}}
; AVX512DQBW-FAST: {{.*}}
; AVX512DQBW-ONLY: {{.*}}
; AVX512DQBW-SLOW: {{.*}}
; AVX512F-ONLY: {{.*}}
; AVX512F-ONLY-FAST: {{.*}}
; AVX512F-ONLY-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
