; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2-SSSE3,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSE2-SSSE3,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2,AVX2-SLOW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX2-FAST,AVX2-FAST-ALL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX2-FAST,AVX2-FAST-PERLANE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BWVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512,AVX512BWVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=skx | FileCheck %s --check-prefixes=SKX

;
; Signed saturation truncation to vXi32
;

define <2 x i32> @trunc_ssat_v2i64_v2i32(<2 x i64> %a0) {
; SSE2-SSSE3-LABEL: trunc_ssat_v2i64_v2i32:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [4294967295,4294967295]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v2i64_v2i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [2147483647,2147483647]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [4294967295,4294967295]
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [18446744069414584320,18446744069414584320]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v2i64_v2i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [2147483647,2147483647]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v2i64_v2i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [2147483647,2147483647]
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v2i64_v2i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpmovsqd %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v2i64_v2i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqd %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v2i64_v2i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqd %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v2i64_v2i32:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqd %xmm0, %xmm0
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v2i64_v2i32:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqd %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 2147483647, i64 2147483647>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 2147483647, i64 2147483647>
  %3 = icmp sgt <2 x i64> %2, <i64 -2147483648, i64 -2147483648>
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> <i64 -2147483648, i64 -2147483648>
  %5 = trunc <2 x i64> %4 to <2 x i32>
  ret <2 x i32> %5
}

define void @trunc_ssat_v2i64_v2i32_store(<2 x i64> %a0, ptr %p1) {
; SSE2-SSSE3-LABEL: trunc_ssat_v2i64_v2i32_store:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [4294967295,4294967295]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-SSSE3-NEXT:    movq %xmm0, (%rdi)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v2i64_v2i32_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [2147483647,2147483647]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [4294967295,4294967295]
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [18446744069414584320,18446744069414584320]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE41-NEXT:    movq %xmm0, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v2i64_v2i32_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [2147483647,2147483647]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vmovlpd %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v2i64_v2i32_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [2147483647,2147483647]
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    vmovlpd %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v2i64_v2i32_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpmovsqd %zmm0, %ymm0
; AVX512F-NEXT:    vmovq %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v2i64_v2i32_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqd %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v2i64_v2i32_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqd %zmm0, %ymm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v2i64_v2i32_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqd %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v2i64_v2i32_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqd %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 2147483647, i64 2147483647>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 2147483647, i64 2147483647>
  %3 = icmp sgt <2 x i64> %2, <i64 -2147483648, i64 -2147483648>
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> <i64 -2147483648, i64 -2147483648>
  %5 = trunc <2 x i64> %4 to <2 x i32>
  store <2 x i32> %5, ptr %p1
  ret void
}

define <4 x i32> @trunc_ssat_v4i64_v4i32(<4 x i64> %a0) {
; SSE2-SSSE3-LABEL: trunc_ssat_v4i64_v4i32:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483647,2147483647]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [4294967295,4294967295]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [18446744069414584320,18446744069414584320]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v4i64_v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [2147483647,2147483647]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [4294967295,4294967295]
; SSE41-NEXT:    movdqa %xmm6, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [18446744069414584320,18446744069414584320]
; SSE41-NEXT:    movapd %xmm2, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm5, %xmm3
; SSE41-NEXT:    movapd %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm2[0,2]
; SSE41-NEXT:    movaps %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [2147483647,2147483647]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[0,2],xmm0[0,2]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_ssat_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-SLOW-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744071562067968,18446744071562067968,18446744071562067968,18446744071562067968]
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: trunc_ssat_v4i64_v4i32:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744071562067968,18446744071562067968,18446744071562067968,18446744071562067968]
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-FAST-ALL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-ALL-NEXT:    vzeroupper
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: trunc_ssat_v4i64_v4i32:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744071562067968,18446744071562067968,18446744071562067968,18446744071562067968]
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-FAST-PERLANE-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v4i64_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovsqd %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v4i64_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqd %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v4i64_v4i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqd %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v4i64_v4i32:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqd %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v4i64_v4i32:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqd %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %2 = select <4 x i1> %1, <4 x i64> %a0, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %3 = icmp sgt <4 x i64> %2, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %4 = select <4 x i1> %3, <4 x i64> %2, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %5 = trunc <4 x i64> %4 to <4 x i32>
  ret <4 x i32> %5
}


define <8 x i32> @trunc_ssat_v8i64_v8i32(ptr %p0) "min-legal-vector-width"="256" {
; SSE2-SSSE3-LABEL: trunc_ssat_v8i64_v8i32:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa (%rdi), %xmm3
; SSE2-SSSE3-NEXT:    movdqa 16(%rdi), %xmm5
; SSE2-SSSE3-NEXT:    movdqa 32(%rdi), %xmm7
; SSE2-SSSE3-NEXT:    movdqa 48(%rdi), %xmm1
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [2147483647,2147483647]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm8, %xmm8
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm6 = [4294967295,4294967295]
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm7
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm7
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm8
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [18446744071562067968,18446744071562067968]
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [18446744069414584320,18446744069414584320]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm9
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm8
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm9
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm9[0,2]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm9, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm3
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm0
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm5[0,2]
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v8i64_v8i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm5
; SSE41-NEXT:    movdqa 16(%rdi), %xmm8
; SSE41-NEXT:    movdqa 32(%rdi), %xmm7
; SSE41-NEXT:    movdqa 48(%rdi), %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [2147483647,2147483647]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [4294967295,4294967295]
; SSE41-NEXT:    movdqa %xmm6, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm4
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm5
; SSE41-NEXT:    movdqa %xmm7, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm8
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm8
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [18446744071562067968,18446744071562067968]
; SSE41-NEXT:    movapd %xmm1, %xmm7
; SSE41-NEXT:    xorpd %xmm3, %xmm7
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [18446744069414584320,18446744069414584320]
; SSE41-NEXT:    movapd %xmm7, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm2, %xmm7
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm7
; SSE41-NEXT:    movapd %xmm8, %xmm1
; SSE41-NEXT:    xorpd %xmm3, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    movapd %xmm2, %xmm1
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm1
; SSE41-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm7[0,2]
; SSE41-NEXT:    movapd %xmm5, %xmm7
; SSE41-NEXT:    xorpd %xmm3, %xmm7
; SSE41-NEXT:    movapd %xmm7, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm2, %xmm7
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm7
; SSE41-NEXT:    xorpd %xmm4, %xmm3
; SSE41-NEXT:    movapd %xmm3, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm7[0,2]
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v8i64_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [2147483647,2147483647]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [18446744071562067968,18446744071562067968]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_ssat_v8i64_v8i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-SLOW-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-SLOW-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [18446744071562067968,18446744071562067968,18446744071562067968,18446744071562067968]
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-SLOW-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: trunc_ssat_v8i64_v8i32:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FAST-ALL-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [18446744071562067968,18446744071562067968,18446744071562067968,18446744071562067968]
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm3
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vmovapd {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm2, %ymm1
; AVX2-FAST-ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: trunc_ssat_v8i64_v8i32:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [18446744071562067968,18446744071562067968,18446744071562067968,18446744071562067968]
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v8i64_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpmovsqd %zmm0, %ymm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v8i64_v8i32:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vmovdqa 32(%rdi), %ymm1
; SKX-NEXT:    vpmovsqd %ymm0, %xmm0
; SKX-NEXT:    vpmovsqd %ymm1, %xmm1
; SKX-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; SKX-NEXT:    retq
  %a0 = load <8 x i64>, ptr %p0
  %1 = icmp slt <8 x i64> %a0, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %2 = select <8 x i1> %1, <8 x i64> %a0, <8 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %3 = icmp sgt <8 x i64> %2, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %4 = select <8 x i1> %3, <8 x i64> %2, <8 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %5 = trunc <8 x i64> %4 to <8 x i32>
  ret <8 x i32> %5
}

;
; Signed saturation truncation to vXi16
;

define <2 x i16> @trunc_ssat_v2i64_v2i16(<2 x i64> %a0) {
; SSE2-SSSE3-LABEL: trunc_ssat_v2i64_v2i16:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147516415,2147516415]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-SSSE3-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v2i64_v2i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [32767,32767]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [2147516415,2147516415]
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [18446744071562035200,18446744071562035200]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v2i64_v2i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [32767,32767]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_ssat_v2i64_v2i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [32767,32767]
; AVX2-SLOW-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-SLOW-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; AVX2-SLOW-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-SLOW-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_ssat_v2i64_v2i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [32767,32767]
; AVX2-FAST-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-FAST-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; AVX2-FAST-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-FAST-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,8,9,10,11,8,9,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v2i64_v2i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpmovsqw %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v2i64_v2i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqw %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v2i64_v2i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqw %zmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v2i64_v2i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqw %xmm0, %xmm0
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v2i64_v2i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqw %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 32767, i64 32767>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 32767, i64 32767>
  %3 = icmp sgt <2 x i64> %2, <i64 -32768, i64 -32768>
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> <i64 -32768, i64 -32768>
  %5 = trunc <2 x i64> %4 to <2 x i16>
  ret <2 x i16> %5
}

define void @trunc_ssat_v2i64_v2i16_store(<2 x i64> %a0, ptr%p1) {
; SSE2-SSSE3-LABEL: trunc_ssat_v2i64_v2i16_store:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147516415,2147516415]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-SSSE3-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-SSSE3-NEXT:    movd %xmm0, (%rdi)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v2i64_v2i16_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [32767,32767]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [2147516415,2147516415]
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [18446744071562035200,18446744071562035200]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE41-NEXT:    movd %xmm0, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v2i64_v2i16_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [32767,32767]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX1-NEXT:    vmovd %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_ssat_v2i64_v2i16_store:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [32767,32767]
; AVX2-SLOW-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-SLOW-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; AVX2-SLOW-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-SLOW-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_ssat_v2i64_v2i16_store:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [32767,32767]
; AVX2-FAST-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-FAST-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; AVX2-FAST-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-FAST-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,8,9,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-FAST-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v2i64_v2i16_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpmovsqw %zmm0, %xmm0
; AVX512F-NEXT:    vmovd %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v2i64_v2i16_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqw %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v2i64_v2i16_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqw %zmm0, %xmm0
; AVX512BW-NEXT:    vmovd %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v2i64_v2i16_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqw %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v2i64_v2i16_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqw %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 32767, i64 32767>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 32767, i64 32767>
  %3 = icmp sgt <2 x i64> %2, <i64 -32768, i64 -32768>
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> <i64 -32768, i64 -32768>
  %5 = trunc <2 x i64> %4 to <2 x i16>
  store <2 x i16> %5, ptr%p1
  ret void
}

define <4 x i16> @trunc_ssat_v4i64_v4i16(<4 x i64> %a0) {
; SSE2-SSSE3-LABEL: trunc_ssat_v4i64_v4i16:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [32767,32767]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147516415,2147516415]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [18446744071562035200,18446744071562035200]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v4i64_v4i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [32767,32767]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [2147516415,2147516415]
; SSE41-NEXT:    movdqa %xmm6, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [18446744071562035200,18446744071562035200]
; SSE41-NEXT:    movapd %xmm2, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm5, %xmm3
; SSE41-NEXT:    movapd %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    packssdw %xmm2, %xmm1
; SSE41-NEXT:    packssdw %xmm1, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v4i64_v4i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [32767,32767]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v4i64_v4i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32767,32767,32767,32767]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744073709518848,18446744073709518848,18446744073709518848,18446744073709518848]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v4i64_v4i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovsqw %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v4i64_v4i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v4i64_v4i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqw %zmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v4i64_v4i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqw %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v4i64_v4i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqw %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, <i64 32767, i64 32767, i64 32767, i64 32767>
  %2 = select <4 x i1> %1, <4 x i64> %a0, <4 x i64> <i64 32767, i64 32767, i64 32767, i64 32767>
  %3 = icmp sgt <4 x i64> %2, <i64 -32768, i64 -32768, i64 -32768, i64 -32768>
  %4 = select <4 x i1> %3, <4 x i64> %2, <4 x i64> <i64 -32768, i64 -32768, i64 -32768, i64 -32768>
  %5 = trunc <4 x i64> %4 to <4 x i16>
  ret <4 x i16> %5
}

define void @trunc_ssat_v4i64_v4i16_store(<4 x i64> %a0, ptr%p1) {
; SSE2-SSSE3-LABEL: trunc_ssat_v4i64_v4i16_store:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [32767,32767]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147516415,2147516415]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm9, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm0 = [18446744073709518848,18446744073709518848]
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [18446744071562035200,18446744071562035200]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    packssdw %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    packssdw %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    movq %xmm2, (%rdi)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v4i64_v4i16_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [32767,32767]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [2147516415,2147516415]
; SSE41-NEXT:    movdqa %xmm6, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [18446744071562035200,18446744071562035200]
; SSE41-NEXT:    movapd %xmm2, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm5, %xmm3
; SSE41-NEXT:    movapd %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    packssdw %xmm2, %xmm1
; SSE41-NEXT:    packssdw %xmm1, %xmm1
; SSE41-NEXT:    movq %xmm1, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v4i64_v4i16_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [32767,32767]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744073709518848,18446744073709518848]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v4i64_v4i16_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [32767,32767,32767,32767]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744073709518848,18446744073709518848,18446744073709518848,18446744073709518848]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v4i64_v4i16_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovsqw %zmm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v4i64_v4i16_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqw %ymm0, (%rdi)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v4i64_v4i16_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqw %zmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v4i64_v4i16_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqw %ymm0, (%rdi)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v4i64_v4i16_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqw %ymm0, (%rdi)
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, <i64 32767, i64 32767, i64 32767, i64 32767>
  %2 = select <4 x i1> %1, <4 x i64> %a0, <4 x i64> <i64 32767, i64 32767, i64 32767, i64 32767>
  %3 = icmp sgt <4 x i64> %2, <i64 -32768, i64 -32768, i64 -32768, i64 -32768>
  %4 = select <4 x i1> %3, <4 x i64> %2, <4 x i64> <i64 -32768, i64 -32768, i64 -32768, i64 -32768>
  %5 = trunc <4 x i64> %4 to <4 x i16>
  store <4 x i16> %5, ptr%p1
  ret void
}

define <8 x i16> @trunc_ssat_v8i64_v8i16(ptr %p0) "min-legal-vector-width"="256" {
; SSE2-SSSE3-LABEL: trunc_ssat_v8i64_v8i16:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa (%rdi), %xmm6
; SSE2-SSSE3-NEXT:    movdqa 16(%rdi), %xmm0
; SSE2-SSSE3-NEXT:    movdqa 32(%rdi), %xmm3
; SSE2-SSSE3-NEXT:    movdqa 48(%rdi), %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [32767,32767]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm8, %xmm8
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147516415,2147516415]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm6
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm8
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [18446744073709518848,18446744073709518848]
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [18446744071562035200,18446744071562035200]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm9
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm8
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm9
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm0
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm9, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm9, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm3
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    packssdw %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    packssdw %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v8i64_v8i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm7
; SSE41-NEXT:    movdqa 16(%rdi), %xmm5
; SSE41-NEXT:    movdqa 32(%rdi), %xmm4
; SSE41-NEXT:    movdqa 48(%rdi), %xmm8
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [32767,32767]
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [2147516415,2147516415]
; SSE41-NEXT:    movdqa %xmm6, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm3
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm4
; SSE41-NEXT:    movdqa %xmm7, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm8
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm8
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm5 = [18446744073709518848,18446744073709518848]
; SSE41-NEXT:    movapd %xmm1, %xmm7
; SSE41-NEXT:    xorpd %xmm2, %xmm7
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [18446744071562035200,18446744071562035200]
; SSE41-NEXT:    movapd %xmm7, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm5, %xmm7
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm7
; SSE41-NEXT:    movapd %xmm8, %xmm1
; SSE41-NEXT:    xorpd %xmm2, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    movapd %xmm5, %xmm1
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm1
; SSE41-NEXT:    packssdw %xmm7, %xmm1
; SSE41-NEXT:    movapd %xmm4, %xmm7
; SSE41-NEXT:    xorpd %xmm2, %xmm7
; SSE41-NEXT:    movapd %xmm7, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm5, %xmm7
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm7
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm5
; SSE41-NEXT:    packssdw %xmm7, %xmm5
; SSE41-NEXT:    packssdw %xmm5, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [32767,32767]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [18446744073709518848,18446744073709518848]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm3, %xmm1
; AVX1-NEXT:    vblendvpd %xmm1, %xmm3, %xmm4, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpackssdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v8i64_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [32767,32767,32767,32767]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [18446744073709518848,18446744073709518848,18446744073709518848,18446744073709518848]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpmovsqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v8i64_v8i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vmovdqa 32(%rdi), %ymm1
; SKX-NEXT:    vpmovsqw %ymm1, %xmm1
; SKX-NEXT:    vpmovsqw %ymm0, %xmm0
; SKX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <8 x i64>, ptr %p0
  %1 = icmp slt <8 x i64> %a0, <i64 32767, i64 32767, i64 32767, i64 32767, i64 32767, i64 32767, i64 32767, i64 32767>
  %2 = select <8 x i1> %1, <8 x i64> %a0, <8 x i64> <i64 32767, i64 32767, i64 32767, i64 32767, i64 32767, i64 32767, i64 32767, i64 32767>
  %3 = icmp sgt <8 x i64> %2, <i64 -32768, i64 -32768, i64 -32768, i64 -32768, i64 -32768, i64 -32768, i64 -32768, i64 -32768>
  %4 = select <8 x i1> %3, <8 x i64> %2, <8 x i64> <i64 -32768, i64 -32768, i64 -32768, i64 -32768, i64 -32768, i64 -32768, i64 -32768, i64 -32768>
  %5 = trunc <8 x i64> %4 to <8 x i16>
  ret <8 x i16> %5
}

define <4 x i16> @trunc_ssat_v4i32_v4i16(<4 x i32> %a0) {
; SSE-LABEL: trunc_ssat_v4i32_v4i16:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_ssat_v4i32_v4i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v4i32_v4i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v4i32_v4i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i32> %a0, <i32 32767, i32 32767, i32 32767, i32 32767>
  %2 = select <4 x i1> %1, <4 x i32> %a0, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
  %3 = icmp sgt <4 x i32> %2, <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %4 = select <4 x i1> %3, <4 x i32> %2, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %5 = trunc <4 x i32> %4 to <4 x i16>
  ret <4 x i16> %5
}

define void @trunc_ssat_v4i32_v4i16_store(<4 x i32> %a0, ptr%p1) {
; SSE-LABEL: trunc_ssat_v4i32_v4i16_store:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    movq %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_ssat_v4i32_v4i16_store:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v4i32_v4i16_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v4i32_v4i16_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsdw %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v4i32_v4i16_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rdi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v4i32_v4i16_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsdw %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v4i32_v4i16_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsdw %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i32> %a0, <i32 32767, i32 32767, i32 32767, i32 32767>
  %2 = select <4 x i1> %1, <4 x i32> %a0, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
  %3 = icmp sgt <4 x i32> %2, <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %4 = select <4 x i1> %3, <4 x i32> %2, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %5 = trunc <4 x i32> %4 to <4 x i16>
  store <4 x i16> %5, ptr%p1
  ret void
}

define <8 x i16> @trunc_ssat_v8i32_v8i16(<8 x i32> %a0) {
; SSE-LABEL: trunc_ssat_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v8i32_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v8i32_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v8i32_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v8i32_v8i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsdw %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v8i32_v8i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsdw %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <8 x i32> %a0, <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %2 = select <8 x i1> %1, <8 x i32> %a0, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %3 = icmp sgt <8 x i32> %2, <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %4 = select <8 x i1> %3, <8 x i32> %2, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %5 = trunc <8 x i32> %4 to <8 x i16>
  ret <8 x i16> %5
}

define <16 x i16> @trunc_ssat_v16i32_v16i16(ptr %p0) "min-legal-vector-width"="256" {
; SSE-LABEL: trunc_ssat_v16i32_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    packssdw 16(%rdi), %xmm0
; SSE-NEXT:    packssdw 48(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v16i32_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vpackssdw 48(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw 16(%rdi), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v16i32_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpackssdw 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v16i32_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpmovsdw %zmm0, %ymm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v16i32_v16i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vpackssdw 32(%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; SKX-NEXT:    retq
  %a0 = load <16 x i32>, ptr %p0
  %1 = icmp slt <16 x i32> %a0, <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %2 = select <16 x i1> %1, <16 x i32> %a0, <16 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %3 = icmp sgt <16 x i32> %2, <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %4 = select <16 x i1> %3, <16 x i32> %2, <16 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %5 = trunc <16 x i32> %4 to <16 x i16>
  ret <16 x i16> %5
}

;
; Signed saturation truncation to vXi8
;

define <2 x i8> @trunc_ssat_v2i64_v2i8(<2 x i64> %a0) {
; SSE2-LABEL: trunc_ssat_v2i64_v2i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483775,2147483775]
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    pxor %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[0,0,2,2]
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm1
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    packssdw %xmm0, %xmm0
; SSE2-NEXT:    packssdw %xmm0, %xmm0
; SSE2-NEXT:    packsswb %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc_ssat_v2i64_v2i8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483775,2147483775]
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSSE3-NEXT:    pand %xmm4, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm3
; SSSE3-NEXT:    pand %xmm3, %xmm0
; SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSSE3-NEXT:    por %xmm3, %xmm0
; SSSE3-NEXT:    pxor %xmm0, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm3
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm3
; SSSE3-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[0,0,2,2]
; SSSE3-NEXT:    pand %xmm3, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm1
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSSE3-NEXT:    por %xmm1, %xmm0
; SSSE3-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v2i64_v2i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [127,127]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [2147483775,2147483775]
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [18446744071562067840,18446744071562067840]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v2i64_v2i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [127,127]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v2i64_v2i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [127,127]
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v2i64_v2i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpmovsqb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v2i64_v2i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqb %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v2i64_v2i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqb %zmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v2i64_v2i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqb %xmm0, %xmm0
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v2i64_v2i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqb %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 127, i64 127>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 127, i64 127>
  %3 = icmp sgt <2 x i64> %2, <i64 -128, i64 -128>
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> <i64 -128, i64 -128>
  %5 = trunc <2 x i64> %4 to <2 x i8>
  ret <2 x i8> %5
}

define void @trunc_ssat_v2i64_v2i8_store(<2 x i64> %a0, ptr%p1) {
; SSE2-LABEL: trunc_ssat_v2i64_v2i8_store:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483775,2147483775]
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm3
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    por %xmm0, %xmm3
; SSE2-NEXT:    pxor %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    por %xmm3, %xmm1
; SSE2-NEXT:    packssdw %xmm1, %xmm1
; SSE2-NEXT:    packssdw %xmm1, %xmm1
; SSE2-NEXT:    packsswb %xmm1, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: trunc_ssat_v2i64_v2i8_store:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm2
; SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483775,2147483775]
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSSE3-NEXT:    pand %xmm4, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm3
; SSSE3-NEXT:    pand %xmm3, %xmm0
; SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSSE3-NEXT:    por %xmm0, %xmm3
; SSSE3-NEXT:    pxor %xmm3, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm2
; SSSE3-NEXT:    pcmpeqd %xmm0, %xmm2
; SSSE3-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSSE3-NEXT:    pand %xmm2, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSSE3-NEXT:    por %xmm0, %xmm1
; SSSE3-NEXT:    pand %xmm1, %xmm3
; SSSE3-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSSE3-NEXT:    por %xmm3, %xmm1
; SSSE3-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; SSSE3-NEXT:    movd %xmm1, %eax
; SSSE3-NEXT:    movw %ax, (%rdi)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v2i64_v2i8_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [127,127]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [2147483775,2147483775]
; SSE41-NEXT:    movdqa %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [18446744071562067840,18446744071562067840]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pshufb {{.*#+}} xmm1 = xmm1[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; SSE41-NEXT:    pextrw $0, %xmm1, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v2i64_v2i8_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [127,127]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v2i64_v2i8_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [127,127]
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v2i64_v2i8_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpmovsqb %zmm0, %xmm0
; AVX512F-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v2i64_v2i8_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqb %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v2i64_v2i8_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqb %zmm0, %xmm0
; AVX512BW-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v2i64_v2i8_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqb %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v2i64_v2i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqb %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, <i64 127, i64 127>
  %2 = select <2 x i1> %1, <2 x i64> %a0, <2 x i64> <i64 127, i64 127>
  %3 = icmp sgt <2 x i64> %2, <i64 -128, i64 -128>
  %4 = select <2 x i1> %3, <2 x i64> %2, <2 x i64> <i64 -128, i64 -128>
  %5 = trunc <2 x i64> %4 to <2 x i8>
  store <2 x i8> %5, ptr%p1
  ret void
}

define <4 x i8> @trunc_ssat_v4i64_v4i8(<4 x i64> %a0) {
; SSE2-SSSE3-LABEL: trunc_ssat_v4i64_v4i8:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [127,127]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147483775,2147483775]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [18446744071562067840,18446744071562067840]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm3[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    packsswb %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v4i64_v4i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [127,127]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [2147483775,2147483775]
; SSE41-NEXT:    movdqa %xmm6, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [18446744071562067840,18446744071562067840]
; SSE41-NEXT:    movapd %xmm2, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm5, %xmm3
; SSE41-NEXT:    movapd %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    packssdw %xmm2, %xmm1
; SSE41-NEXT:    packssdw %xmm1, %xmm1
; SSE41-NEXT:    packsswb %xmm1, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v4i64_v4i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [127,127]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v4i64_v4i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [127,127,127,127]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744073709551488,18446744073709551488,18446744073709551488,18446744073709551488]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v4i64_v4i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovsqb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v4i64_v4i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqb %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v4i64_v4i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqb %zmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v4i64_v4i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqb %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v4i64_v4i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqb %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, <i64 127, i64 127, i64 127, i64 127>
  %2 = select <4 x i1> %1, <4 x i64> %a0, <4 x i64> <i64 127, i64 127, i64 127, i64 127>
  %3 = icmp sgt <4 x i64> %2, <i64 -128, i64 -128, i64 -128, i64 -128>
  %4 = select <4 x i1> %3, <4 x i64> %2, <4 x i64> <i64 -128, i64 -128, i64 -128, i64 -128>
  %5 = trunc <4 x i64> %4 to <4 x i8>
  ret <4 x i8> %5
}

define void @trunc_ssat_v4i64_v4i8_store(<4 x i64> %a0, ptr%p1) {
; SSE2-SSSE3-LABEL: trunc_ssat_v4i64_v4i8_store:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [127,127]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147483775,2147483775]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm9, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm0 = [18446744073709551488,18446744073709551488]
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [18446744071562067840,18446744071562067840]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    packssdw %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    packssdw %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    packsswb %xmm2, %xmm2
; SSE2-SSSE3-NEXT:    movd %xmm2, (%rdi)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v4i64_v4i8_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [127,127]
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648]
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [2147483775,2147483775]
; SSE41-NEXT:    movdqa %xmm6, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [18446744071562067840,18446744071562067840]
; SSE41-NEXT:    movapd %xmm2, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    xorpd %xmm5, %xmm3
; SSE41-NEXT:    movapd %xmm3, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    packssdw %xmm2, %xmm1
; SSE41-NEXT:    packssdw %xmm1, %xmm1
; SSE41-NEXT:    packsswb %xmm1, %xmm1
; SSE41-NEXT:    movd %xmm1, (%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v4i64_v4i8_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [127,127]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [18446744073709551488,18446744073709551488]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v4i64_v4i8_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [127,127,127,127]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744073709551488,18446744073709551488,18446744073709551488,18446744073709551488]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v4i64_v4i8_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovsqb %zmm0, %xmm0
; AVX512F-NEXT:    vmovd %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v4i64_v4i8_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsqb %ymm0, (%rdi)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v4i64_v4i8_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovsqb %zmm0, %xmm0
; AVX512BW-NEXT:    vmovd %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v4i64_v4i8_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsqb %ymm0, (%rdi)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v4i64_v4i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsqb %ymm0, (%rdi)
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, <i64 127, i64 127, i64 127, i64 127>
  %2 = select <4 x i1> %1, <4 x i64> %a0, <4 x i64> <i64 127, i64 127, i64 127, i64 127>
  %3 = icmp sgt <4 x i64> %2, <i64 -128, i64 -128, i64 -128, i64 -128>
  %4 = select <4 x i1> %3, <4 x i64> %2, <4 x i64> <i64 -128, i64 -128, i64 -128, i64 -128>
  %5 = trunc <4 x i64> %4 to <4 x i8>
  store <4 x i8> %5, ptr%p1
  ret void
}

define <8 x i8> @trunc_ssat_v8i64_v8i8(ptr %p0) "min-legal-vector-width"="256" {
; SSE2-SSSE3-LABEL: trunc_ssat_v8i64_v8i8:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa (%rdi), %xmm6
; SSE2-SSSE3-NEXT:    movdqa 16(%rdi), %xmm0
; SSE2-SSSE3-NEXT:    movdqa 32(%rdi), %xmm3
; SSE2-SSSE3-NEXT:    movdqa 48(%rdi), %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [127,127]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm8, %xmm8
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147483775,2147483775]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm6
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm8
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [18446744073709551488,18446744073709551488]
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [18446744071562067840,18446744071562067840]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm9
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm8
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm9
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm0
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm9, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm9, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm6, %xmm3
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    packssdw %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    packssdw %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    packsswb %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v8i64_v8i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm7
; SSE41-NEXT:    movdqa 16(%rdi), %xmm5
; SSE41-NEXT:    movdqa 32(%rdi), %xmm4
; SSE41-NEXT:    movdqa 48(%rdi), %xmm8
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [127,127]
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [2147483775,2147483775]
; SSE41-NEXT:    movdqa %xmm6, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm3
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm4
; SSE41-NEXT:    movdqa %xmm7, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm8
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm8
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm5 = [18446744073709551488,18446744073709551488]
; SSE41-NEXT:    movapd %xmm1, %xmm7
; SSE41-NEXT:    xorpd %xmm2, %xmm7
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [18446744071562067840,18446744071562067840]
; SSE41-NEXT:    movapd %xmm7, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm5, %xmm7
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm7
; SSE41-NEXT:    movapd %xmm8, %xmm1
; SSE41-NEXT:    xorpd %xmm2, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    movapd %xmm5, %xmm1
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm1
; SSE41-NEXT:    packssdw %xmm7, %xmm1
; SSE41-NEXT:    movapd %xmm4, %xmm7
; SSE41-NEXT:    xorpd %xmm2, %xmm7
; SSE41-NEXT:    movapd %xmm7, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm5, %xmm7
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm7
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm5
; SSE41-NEXT:    packssdw %xmm7, %xmm5
; SSE41-NEXT:    packssdw %xmm5, %xmm1
; SSE41-NEXT:    packsswb %xmm1, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v8i64_v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [127,127]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [18446744073709551488,18446744073709551488]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm3, %xmm1
; AVX1-NEXT:    vblendvpd %xmm1, %xmm3, %xmm4, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpackssdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v8i64_v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [127,127,127,127]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [18446744073709551488,18446744073709551488,18446744073709551488,18446744073709551488]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v8i64_v8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpmovsqb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v8i64_v8i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vmovdqa 32(%rdi), %ymm1
; SKX-NEXT:    vpmovsqb %ymm1, %xmm1
; SKX-NEXT:    vpmovsqb %ymm0, %xmm0
; SKX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <8 x i64>, ptr %p0
  %1 = icmp slt <8 x i64> %a0, <i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127>
  %2 = select <8 x i1> %1, <8 x i64> %a0, <8 x i64> <i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127>
  %3 = icmp sgt <8 x i64> %2, <i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128>
  %4 = select <8 x i1> %3, <8 x i64> %2, <8 x i64> <i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128>
  %5 = trunc <8 x i64> %4 to <8 x i8>
  ret <8 x i8> %5
}

; TODO: The AVX1 codegen shows a missed opportunity to narrow blendv+logic to 128-bit.

define void @trunc_ssat_v8i64_v8i8_store(ptr %p0, ptr%p1) "min-legal-vector-width"="256" {
; SSE2-SSSE3-LABEL: trunc_ssat_v8i64_v8i8_store:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa (%rdi), %xmm6
; SSE2-SSSE3-NEXT:    movdqa 16(%rdi), %xmm3
; SSE2-SSSE3-NEXT:    movdqa 32(%rdi), %xmm2
; SSE2-SSSE3-NEXT:    movdqa 48(%rdi), %xmm5
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [127,127]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm8, %xmm8
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147483775,2147483775]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm6
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm6
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm6[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm6
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pand %xmm7, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm4, %xmm7
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm7
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [18446744073709551488,18446744073709551488]
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm4, %xmm9
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm6 = [18446744071562067840,18446744071562067840]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm6, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm8[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm8
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm7
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm8
; SSE2-SSSE3-NEXT:    por %xmm7, %xmm8
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm7
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm4, %xmm9
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm9, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm7
; SSE2-SSSE3-NEXT:    pand %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm7
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm7
; SSE2-SSSE3-NEXT:    packssdw %xmm8, %xmm7
; SSE2-SSSE3-NEXT:    movdqa %xmm2, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm0, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm4, %xmm8
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm9, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm4, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm3, %xmm0
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm0, %xmm7
; SSE2-SSSE3-NEXT:    packsswb %xmm7, %xmm7
; SSE2-SSSE3-NEXT:    movq %xmm7, (%rsi)
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v8i64_v8i8_store:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm7
; SSE41-NEXT:    movdqa 16(%rdi), %xmm5
; SSE41-NEXT:    movdqa 32(%rdi), %xmm3
; SSE41-NEXT:    movdqa 48(%rdi), %xmm8
; SSE41-NEXT:    movapd {{.*#+}} xmm4 = [127,127]
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [2147483775,2147483775]
; SSE41-NEXT:    movdqa %xmm6, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm2
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm3
; SSE41-NEXT:    movdqa %xmm7, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm8
; SSE41-NEXT:    movdqa %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm4, %xmm8
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm8
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm4
; SSE41-NEXT:    movapd {{.*#+}} xmm5 = [18446744073709551488,18446744073709551488]
; SSE41-NEXT:    movapd %xmm4, %xmm7
; SSE41-NEXT:    xorpd %xmm1, %xmm7
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [18446744071562067840,18446744071562067840]
; SSE41-NEXT:    movapd %xmm7, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm5, %xmm7
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm7
; SSE41-NEXT:    movapd %xmm8, %xmm4
; SSE41-NEXT:    xorpd %xmm1, %xmm4
; SSE41-NEXT:    movapd %xmm4, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    movapd %xmm5, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm4
; SSE41-NEXT:    packssdw %xmm7, %xmm4
; SSE41-NEXT:    movapd %xmm3, %xmm7
; SSE41-NEXT:    xorpd %xmm1, %xmm7
; SSE41-NEXT:    movapd %xmm7, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm8
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm5, %xmm7
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm7
; SSE41-NEXT:    xorpd %xmm2, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm3
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm5
; SSE41-NEXT:    packssdw %xmm7, %xmm5
; SSE41-NEXT:    packssdw %xmm5, %xmm4
; SSE41-NEXT:    packsswb %xmm4, %xmm4
; SSE41-NEXT:    movq %xmm4, (%rsi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v8i64_v8i8_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [127,127]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [18446744073709551488,18446744073709551488]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm3, %xmm1
; AVX1-NEXT:    vblendvpd %xmm1, %xmm3, %xmm4, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpackssdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rsi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v8i64_v8i8_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [127,127,127,127]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [18446744073709551488,18446744073709551488,18446744073709551488,18446744073709551488]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rsi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v8i64_v8i8_store:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpmovsqb %zmm0, (%rsi)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v8i64_v8i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vmovdqa 32(%rdi), %ymm1
; SKX-NEXT:    vpmovsqb %ymm1, %xmm1
; SKX-NEXT:    vpmovsqb %ymm0, %xmm0
; SKX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SKX-NEXT:    vmovq %xmm0, (%rsi)
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <8 x i64>, ptr %p0
  %1 = icmp slt <8 x i64> %a0, <i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127>
  %2 = select <8 x i1> %1, <8 x i64> %a0, <8 x i64> <i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127>
  %3 = icmp sgt <8 x i64> %2, <i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128>
  %4 = select <8 x i1> %3, <8 x i64> %2, <8 x i64> <i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128>
  %5 = trunc <8 x i64> %4 to <8 x i8>
  store <8 x i8> %5, ptr%p1
  ret void
}

define <16 x i8> @trunc_ssat_v16i64_v16i8(ptr %p0) "min-legal-vector-width"="256" {
; SSE2-SSSE3-LABEL: trunc_ssat_v16i64_v16i8:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    movdqa (%rdi), %xmm8
; SSE2-SSSE3-NEXT:    movdqa 16(%rdi), %xmm0
; SSE2-SSSE3-NEXT:    movdqa 32(%rdi), %xmm12
; SSE2-SSSE3-NEXT:    movdqa 48(%rdi), %xmm11
; SSE2-SSSE3-NEXT:    movdqa 80(%rdi), %xmm7
; SSE2-SSSE3-NEXT:    movdqa 64(%rdi), %xmm5
; SSE2-SSSE3-NEXT:    movdqa 112(%rdi), %xmm4
; SSE2-SSSE3-NEXT:    movdqa 96(%rdi), %xmm3
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm6 = [127,127]
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm2[1,1,3,3]
; SSE2-SSSE3-NEXT:    pxor %xmm10, %xmm10
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm10, %xmm13
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm9 = [2147483775,2147483775]
; SSE2-SSSE3-NEXT:    movdqa %xmm9, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm3[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm10, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm9, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm10, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm9, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm4, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm4
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm10, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm9, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm7
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm12, %xmm7
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm10, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm9, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm7, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm7
; SSE2-SSSE3-NEXT:    pand %xmm7, %xmm12
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    por %xmm12, %xmm7
; SSE2-SSSE3-NEXT:    movdqa %xmm11, %xmm12
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm12
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm12[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm10, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm9, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm12, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm12 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm12
; SSE2-SSSE3-NEXT:    pand %xmm12, %xmm11
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm12
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm12
; SSE2-SSSE3-NEXT:    movdqa %xmm8, %xmm11
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm11[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm10, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm9, %xmm14
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm11, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm15 = xmm14[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm15
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm14[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm15, %xmm11
; SSE2-SSSE3-NEXT:    pand %xmm11, %xmm8
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm11
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm11
; SSE2-SSSE3-NEXT:    movdqa %xmm0, %xmm8
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm8[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm10, %xmm13
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm8, %xmm9
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm8 = xmm9[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm8
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pand %xmm10, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm10
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm6 = [18446744073709551488,18446744073709551488]
; SSE2-SSSE3-NEXT:    movdqa %xmm10, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm8
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm13
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm9 = [18446744071562067840,18446744071562067840]
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm9, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm14 = xmm0[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm14, %xmm13
; SSE2-SSSE3-NEXT:    pand %xmm13, %xmm10
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm13
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm13
; SSE2-SSSE3-NEXT:    movdqa %xmm11, %xmm0
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm9, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm14 = xmm0[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm10, %xmm14
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm14, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm0, %xmm11
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm0
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm13, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm12, %xmm10
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm11
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm9, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm10[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm11, %xmm13
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm13, %xmm10
; SSE2-SSSE3-NEXT:    pand %xmm10, %xmm12
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm10
; SSE2-SSSE3-NEXT:    por %xmm12, %xmm10
; SSE2-SSSE3-NEXT:    movdqa %xmm7, %xmm11
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm12 = xmm11[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm12
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm9, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm13 = xmm11[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm12, %xmm13
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm13, %xmm11
; SSE2-SSSE3-NEXT:    pand %xmm11, %xmm7
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm11
; SSE2-SSSE3-NEXT:    por %xmm7, %xmm11
; SSE2-SSSE3-NEXT:    packssdw %xmm10, %xmm11
; SSE2-SSSE3-NEXT:    packssdw %xmm11, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm7
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm9, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm7[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm10, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm7
; SSE2-SSSE3-NEXT:    pand %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm7
; SSE2-SSSE3-NEXT:    por %xmm5, %xmm7
; SSE2-SSSE3-NEXT:    movdqa %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm10
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm9, %xmm5
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm5[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm10, %xmm11
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm11, %xmm5
; SSE2-SSSE3-NEXT:    pand %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm5
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm5
; SSE2-SSSE3-NEXT:    packssdw %xmm7, %xmm5
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm1, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm7
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm9, %xmm4
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm4[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm7, %xmm10
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm10, %xmm4
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm4
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pxor %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm8, %xmm3
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm9, %xmm1
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[0,0,2,2]
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm7
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-SSSE3-NEXT:    por %xmm7, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pandn %xmm6, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    packssdw %xmm4, %xmm1
; SSE2-SSSE3-NEXT:    packssdw %xmm1, %xmm5
; SSE2-SSSE3-NEXT:    packsswb %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v16i64_v16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm8
; SSE41-NEXT:    movdqa 16(%rdi), %xmm7
; SSE41-NEXT:    movdqa 32(%rdi), %xmm12
; SSE41-NEXT:    movdqa 48(%rdi), %xmm11
; SSE41-NEXT:    movdqa 80(%rdi), %xmm10
; SSE41-NEXT:    movdqa 64(%rdi), %xmm6
; SSE41-NEXT:    movdqa 112(%rdi), %xmm5
; SSE41-NEXT:    movdqa 96(%rdi), %xmm4
; SSE41-NEXT:    movapd {{.*#+}} xmm1 = [127,127]
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm9 = [2147483775,2147483775]
; SSE41-NEXT:    movdqa %xmm9, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm13
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm3
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm9, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm13
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm4
; SSE41-NEXT:    movdqa %xmm6, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm9, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm13
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm6, %xmm5
; SSE41-NEXT:    movdqa %xmm10, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm9, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm6
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm13
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm6, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm10, %xmm6
; SSE41-NEXT:    movdqa %xmm12, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm9, %xmm10
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm10
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm13
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm10, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm10
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm10
; SSE41-NEXT:    movdqa %xmm11, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm9, %xmm12
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm12
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm13
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm12, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm12
; SSE41-NEXT:    blendvpd %xmm0, %xmm11, %xmm12
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm9, %xmm11
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm11
; SSE41-NEXT:    movdqa %xmm9, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm13
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,0,2,2]
; SSE41-NEXT:    pand %xmm11, %xmm0
; SSE41-NEXT:    por %xmm13, %xmm0
; SSE41-NEXT:    movapd %xmm1, %xmm11
; SSE41-NEXT:    blendvpd %xmm0, %xmm8, %xmm11
; SSE41-NEXT:    movdqa %xmm7, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm9, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm8
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm8, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm7, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm7 = [18446744073709551488,18446744073709551488]
; SSE41-NEXT:    movapd %xmm1, %xmm9
; SSE41-NEXT:    xorpd %xmm2, %xmm9
; SSE41-NEXT:    movdqa {{.*#+}} xmm8 = [18446744071562067840,18446744071562067840]
; SSE41-NEXT:    movapd %xmm9, %xmm13
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm13, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm9
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm9
; SSE41-NEXT:    movapd %xmm11, %xmm1
; SSE41-NEXT:    xorpd %xmm2, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm13
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm13
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,2,2]
; SSE41-NEXT:    pand %xmm13, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm1
; SSE41-NEXT:    blendvpd %xmm0, %xmm11, %xmm1
; SSE41-NEXT:    packssdw %xmm9, %xmm1
; SSE41-NEXT:    movapd %xmm12, %xmm9
; SSE41-NEXT:    xorpd %xmm2, %xmm9
; SSE41-NEXT:    movapd %xmm9, %xmm11
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm11
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm11, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm9
; SSE41-NEXT:    blendvpd %xmm0, %xmm12, %xmm9
; SSE41-NEXT:    movapd %xmm10, %xmm11
; SSE41-NEXT:    xorpd %xmm2, %xmm11
; SSE41-NEXT:    movapd %xmm11, %xmm12
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm12
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm11
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[0,0,2,2]
; SSE41-NEXT:    pand %xmm12, %xmm0
; SSE41-NEXT:    por %xmm11, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm11
; SSE41-NEXT:    blendvpd %xmm0, %xmm10, %xmm11
; SSE41-NEXT:    packssdw %xmm9, %xmm11
; SSE41-NEXT:    packssdw %xmm11, %xmm1
; SSE41-NEXT:    movapd %xmm6, %xmm9
; SSE41-NEXT:    xorpd %xmm2, %xmm9
; SSE41-NEXT:    movapd %xmm9, %xmm10
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm10
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm9
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[0,0,2,2]
; SSE41-NEXT:    pand %xmm10, %xmm0
; SSE41-NEXT:    por %xmm9, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm9
; SSE41-NEXT:    blendvpd %xmm0, %xmm6, %xmm9
; SSE41-NEXT:    movapd %xmm5, %xmm6
; SSE41-NEXT:    xorpd %xmm2, %xmm6
; SSE41-NEXT:    movapd %xmm6, %xmm10
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm10
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm10, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm6
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm6
; SSE41-NEXT:    packssdw %xmm9, %xmm6
; SSE41-NEXT:    movapd %xmm4, %xmm5
; SSE41-NEXT:    xorpd %xmm2, %xmm5
; SSE41-NEXT:    movapd %xmm5, %xmm9
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,0,2,2]
; SSE41-NEXT:    pand %xmm9, %xmm0
; SSE41-NEXT:    por %xmm5, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm5
; SSE41-NEXT:    xorpd %xmm3, %xmm2
; SSE41-NEXT:    movapd %xmm2, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm8, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm7
; SSE41-NEXT:    packssdw %xmm5, %xmm7
; SSE41-NEXT:    packssdw %xmm7, %xmm6
; SSE41-NEXT:    packsswb %xmm6, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa 96(%rdi), %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm2 = [127,127]
; AVX1-NEXT:    # xmm2 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm1
; AVX1-NEXT:    vblendvpd %xmm1, %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vmovdqa 112(%rdi), %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vmovdqa 80(%rdi), %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm2, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm4, %xmm2, %xmm4
; AVX1-NEXT:    vmovdqa (%rdi), %xmm5
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm6
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm7
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm8
; AVX1-NEXT:    vpcmpgtq %xmm7, %xmm2, %xmm9
; AVX1-NEXT:    vblendvpd %xmm9, %xmm7, %xmm2, %xmm7
; AVX1-NEXT:    vpcmpgtq %xmm8, %xmm2, %xmm9
; AVX1-NEXT:    vblendvpd %xmm9, %xmm8, %xmm2, %xmm8
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm2, %xmm9
; AVX1-NEXT:    vblendvpd %xmm9, %xmm5, %xmm2, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm2, %xmm9
; AVX1-NEXT:    vblendvpd %xmm9, %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vmovddup {{.*#+}} xmm6 = [18446744073709551488,18446744073709551488]
; AVX1-NEXT:    # xmm6 = mem[0,0]
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm2, %xmm9
; AVX1-NEXT:    vblendvpd %xmm9, %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm5, %xmm9
; AVX1-NEXT:    vblendvpd %xmm9, %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpackssdw %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm8, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm8, %xmm6, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm7, %xmm8
; AVX1-NEXT:    vblendvpd %xmm8, %xmm7, %xmm6, %xmm7
; AVX1-NEXT:    vpackssdw %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpackssdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm4, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm3, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpackssdw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm1, %xmm4
; AVX1-NEXT:    vblendvpd %xmm4, %xmm1, %xmm6, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm0, %xmm4
; AVX1-NEXT:    vblendvpd %xmm4, %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v16i64_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [127,127,127,127]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm4, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm4, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm4, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm4, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [18446744073709551488,18446744073709551488,18446744073709551488,18446744073709551488]
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm1, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm0, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm3, %ymm1
; AVX2-NEXT:    vblendvpd %ymm1, %ymm3, %ymm4, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm2, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpackssdw %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vpmovsqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovsqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v16i64_v16i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vmovdqa 32(%rdi), %ymm1
; SKX-NEXT:    vmovdqa 64(%rdi), %ymm2
; SKX-NEXT:    vmovdqa 96(%rdi), %ymm3
; SKX-NEXT:    vpmovsqb %ymm3, %xmm3
; SKX-NEXT:    vpmovsqb %ymm2, %xmm2
; SKX-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SKX-NEXT:    vpmovsqb %ymm1, %xmm1
; SKX-NEXT:    vpmovsqb %ymm0, %xmm0
; SKX-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SKX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <16 x i64>, ptr %p0
  %1 = icmp slt <16 x i64> %a0, <i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127>
  %2 = select <16 x i1> %1, <16 x i64> %a0, <16 x i64> <i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127, i64 127>
  %3 = icmp sgt <16 x i64> %2, <i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128>
  %4 = select <16 x i1> %3, <16 x i64> %2, <16 x i64> <i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128, i64 -128>
  %5 = trunc <16 x i64> %4 to <16 x i8>
  ret <16 x i8> %5
}

define <4 x i8> @trunc_ssat_v4i32_v4i8(<4 x i32> %a0) {
; SSE-LABEL: trunc_ssat_v4i32_v4i8:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_ssat_v4i32_v4i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v4i32_v4i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v4i32_v4i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; SKX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i32> %a0, <i32 127, i32 127, i32 127, i32 127>
  %2 = select <4 x i1> %1, <4 x i32> %a0, <4 x i32> <i32 127, i32 127, i32 127, i32 127>
  %3 = icmp sgt <4 x i32> %2, <i32 -128, i32 -128, i32 -128, i32 -128>
  %4 = select <4 x i1> %3, <4 x i32> %2, <4 x i32> <i32 -128, i32 -128, i32 -128, i32 -128>
  %5 = trunc <4 x i32> %4 to <4 x i8>
  ret <4 x i8> %5
}

define void @trunc_ssat_v4i32_v4i8_store(<4 x i32> %a0, ptr%p1) {
; SSE-LABEL: trunc_ssat_v4i32_v4i8_store:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    movd %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_ssat_v4i32_v4i8_store:
; AVX:       # %bb.0:
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovd %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v4i32_v4i8_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vmovd %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v4i32_v4i8_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsdb %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v4i32_v4i8_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovd %xmm0, (%rdi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v4i32_v4i8_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsdb %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v4i32_v4i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsdb %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <4 x i32> %a0, <i32 127, i32 127, i32 127, i32 127>
  %2 = select <4 x i1> %1, <4 x i32> %a0, <4 x i32> <i32 127, i32 127, i32 127, i32 127>
  %3 = icmp sgt <4 x i32> %2, <i32 -128, i32 -128, i32 -128, i32 -128>
  %4 = select <4 x i1> %3, <4 x i32> %2, <4 x i32> <i32 -128, i32 -128, i32 -128, i32 -128>
  %5 = trunc <4 x i32> %4 to <4 x i8>
  store <4 x i8> %5, ptr%p1
  ret void
}

define <8 x i8> @trunc_ssat_v8i32_v8i8(<8 x i32> %a0) {
; SSE-LABEL: trunc_ssat_v8i32_v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v8i32_v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v8i32_v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v8i32_v8i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v8i32_v8i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsdb %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v8i32_v8i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v8i32_v8i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsdb %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v8i32_v8i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsdb %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <8 x i32> %a0, <i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127>
  %2 = select <8 x i1> %1, <8 x i32> %a0, <8 x i32> <i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127>
  %3 = icmp sgt <8 x i32> %2, <i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128>
  %4 = select <8 x i1> %3, <8 x i32> %2, <8 x i32> <i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128>
  %5 = trunc <8 x i32> %4 to <8 x i8>
  ret <8 x i8> %5
}

define void @trunc_ssat_v8i32_v8i8_store(<8 x i32> %a0, ptr%p1) {
; SSE-LABEL: trunc_ssat_v8i32_v8i8_store:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    movq %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v8i32_v8i8_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v8i32_v8i8_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v8i32_v8i8_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, (%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v8i32_v8i8_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsdb %ymm0, (%rdi)
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v8i32_v8i8_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rdi)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v8i32_v8i8_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovsdb %ymm0, (%rdi)
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v8i32_v8i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovsdb %ymm0, (%rdi)
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <8 x i32> %a0, <i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127>
  %2 = select <8 x i1> %1, <8 x i32> %a0, <8 x i32> <i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127>
  %3 = icmp sgt <8 x i32> %2, <i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128>
  %4 = select <8 x i1> %3, <8 x i32> %2, <8 x i32> <i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128>
  %5 = trunc <8 x i32> %4 to <8 x i8>
  store <8 x i8> %5, ptr%p1
  ret void
}

define <16 x i8> @trunc_ssat_v16i32_v16i8(ptr %p0) "min-legal-vector-width"="256" {
; SSE-LABEL: trunc_ssat_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    packssdw 48(%rdi), %xmm1
; SSE-NEXT:    packssdw 16(%rdi), %xmm0
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vpackssdw 48(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw 16(%rdi), %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpackssdw 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpmovsdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v16i32_v16i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vmovdqa 32(%rdi), %ymm1
; SKX-NEXT:    vpmovsdb %ymm1, %xmm1
; SKX-NEXT:    vpmovsdb %ymm0, %xmm0
; SKX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <16 x i32>, ptr %p0
  %1 = icmp slt <16 x i32> %a0, <i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127>
  %2 = select <16 x i1> %1, <16 x i32> %a0, <16 x i32> <i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127>
  %3 = icmp sgt <16 x i32> %2, <i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128>
  %4 = select <16 x i1> %3, <16 x i32> %2, <16 x i32> <i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128>
  %5 = trunc <16 x i32> %4 to <16 x i8>
  ret <16 x i8> %5
}

define void @trunc_ssat_v16i32_v16i8_store(ptr %p0, ptr %p1) "min-legal-vector-width"="256" {
; SSE-LABEL: trunc_ssat_v16i32_v16i8_store:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    packssdw 48(%rdi), %xmm1
; SSE-NEXT:    packssdw 16(%rdi), %xmm0
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v16i32_v16i8_store:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vpackssdw 48(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw 16(%rdi), %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v16i32_v16i8_store:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpackssdw 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v16i32_v16i8_store:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpmovsdb %zmm0, (%rsi)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v16i32_v16i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vmovdqa 32(%rdi), %ymm1
; SKX-NEXT:    vpmovsdb %ymm1, %xmm1
; SKX-NEXT:    vpmovsdb %ymm0, %xmm0
; SKX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SKX-NEXT:    vmovdqa %xmm0, (%rsi)
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a0 = load <16 x i32>, ptr %p0
  %1 = icmp slt <16 x i32> %a0, <i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127>
  %2 = select <16 x i1> %1, <16 x i32> %a0, <16 x i32> <i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127>
  %3 = icmp sgt <16 x i32> %2, <i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128>
  %4 = select <16 x i1> %3, <16 x i32> %2, <16 x i32> <i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128>
  %5 = trunc <16 x i32> %4 to <16 x i8>
  store <16 x i8> %5, ptr %p1
  ret void
}

define <8 x i8> @trunc_ssat_v8i16_v8i8(<8 x i16> %a0) {
; SSE-LABEL: trunc_ssat_v8i16_v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_ssat_v8i16_v8i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v8i16_v8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v8i16_v8i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; SKX-NEXT:    retq
  %1 = icmp slt <8 x i16> %a0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %2 = select <8 x i1> %1, <8 x i16> %a0, <8 x i16> <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %3 = icmp sgt <8 x i16> %2, <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %4 = select <8 x i1> %3, <8 x i16> %2, <8 x i16> <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %5 = trunc <8 x i16> %4 to <8 x i8>
  ret <8 x i8> %5
}

define void @trunc_ssat_v8i16_v8i8_store(<8 x i16> %a0, ptr%p1) {
; SSE-LABEL: trunc_ssat_v8i16_v8i8_store:
; SSE:       # %bb.0:
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    movq %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_ssat_v8i16_v8i8_store:
; AVX:       # %bb.0:
; AVX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v8i16_v8i8_store:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v8i16_v8i8_store:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovq %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v8i16_v8i8_store:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm0, (%rdi)
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v8i16_v8i8_store:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovswb %xmm0, (%rdi)
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v8i16_v8i8_store:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovswb %xmm0, (%rdi)
; SKX-NEXT:    retq
  %1 = icmp slt <8 x i16> %a0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %2 = select <8 x i1> %1, <8 x i16> %a0, <8 x i16> <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %3 = icmp sgt <8 x i16> %2, <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %4 = select <8 x i1> %3, <8 x i16> %2, <8 x i16> <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %5 = trunc <8 x i16> %4 to <8 x i8>
  store <8 x i8> %5, ptr%p1
  ret void
}

define <16 x i8> @trunc_ssat_v16i16_v16i8(<16 x i16> %a0) {
; SSE-LABEL: trunc_ssat_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v16i16_v16i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512VL-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512BW-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v16i16_v16i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vpmovswb %ymm0, %xmm0
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v16i16_v16i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpmovswb %ymm0, %xmm0
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %1 = icmp slt <16 x i16> %a0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %2 = select <16 x i1> %1, <16 x i16> %a0, <16 x i16> <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %3 = icmp sgt <16 x i16> %2, <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %4 = select <16 x i1> %3, <16 x i16> %2, <16 x i16> <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %5 = trunc <16 x i16> %4 to <16 x i8>
  ret <16 x i8> %5
}

define <32 x i8> @trunc_ssat_v32i16_v32i8(ptr %p0) "min-legal-vector-width"="256" {
; SSE-LABEL: trunc_ssat_v32i16_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    packsswb 16(%rdi), %xmm0
; SSE-NEXT:    packsswb 48(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v32i16_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vpacksswb 48(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vpacksswb 16(%rdi), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v32i16_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpacksswb 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_ssat_v32i16_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vpacksswb 32(%rdi), %ymm0, %ymm0
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: trunc_ssat_v32i16_v32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vpacksswb 32(%rdi), %ymm0, %ymm0
; AVX512VL-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: trunc_ssat_v32i16_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vpmovswb %zmm0, %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: trunc_ssat_v32i16_v32i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BWVL-NEXT:    vpmovswb %zmm0, %ymm0
; AVX512BWVL-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v32i16_v32i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vpacksswb 32(%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; SKX-NEXT:    retq
  %a0 = load <32 x i16>, ptr %p0
  %1 = icmp slt <32 x i16> %a0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %2 = select <32 x i1> %1, <32 x i16> %a0, <32 x i16> <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %3 = icmp sgt <32 x i16> %2, <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %4 = select <32 x i1> %3, <32 x i16> %2, <32 x i16> <i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128, i16 -128>
  %5 = trunc <32 x i16> %4 to <32 x i8>
  ret <32 x i8> %5
}

define <32 x i8> @trunc_ssat_v32i32_v32i8(ptr %p0) "min-legal-vector-width"="256" {
; SSE-LABEL: trunc_ssat_v32i32_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 32(%rdi), %xmm2
; SSE-NEXT:    movdqa 64(%rdi), %xmm1
; SSE-NEXT:    movdqa 96(%rdi), %xmm3
; SSE-NEXT:    packssdw 48(%rdi), %xmm2
; SSE-NEXT:    packssdw 16(%rdi), %xmm0
; SSE-NEXT:    packsswb %xmm2, %xmm0
; SSE-NEXT:    packssdw 112(%rdi), %xmm3
; SSE-NEXT:    packssdw 80(%rdi), %xmm1
; SSE-NEXT:    packsswb %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v32i32_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 96(%rdi), %xmm3
; AVX1-NEXT:    vpackssdw 112(%rdi), %xmm3, %xmm3
; AVX1-NEXT:    vpackssdw 80(%rdi), %xmm2, %xmm2
; AVX1-NEXT:    vpacksswb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpackssdw 48(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw 16(%rdi), %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v32i32_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-NEXT:    vpackssdw 96(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpackssdw 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v32i32_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vpmovsdb %zmm0, %xmm0
; AVX512-NEXT:    vpmovsdb %zmm1, %xmm1
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v32i32_v32i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovdqa (%rdi), %ymm0
; SKX-NEXT:    vmovdqa 64(%rdi), %ymm1
; SKX-NEXT:    vpackssdw 96(%rdi), %ymm1, %ymm1
; SKX-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; SKX-NEXT:    vpackssdw 32(%rdi), %ymm0, %ymm0
; SKX-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; SKX-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; SKX-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; SKX-NEXT:    retq
  %a0 = load <32 x i32>, ptr %p0
  %1 = icmp slt <32 x i32> %a0, <i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127>
  %2 = select <32 x i1> %1, <32 x i32> %a0, <32 x i32> <i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127, i32 127>
  %3 = icmp sgt <32 x i32> %2, <i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128>
  %4 = select <32 x i1> %3, <32 x i32> %2, <32 x i32> <i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128, i32 -128>
  %5 = trunc <32 x i32> %4 to <32 x i8>
  ret <32 x i8> %5
}

; This used to crash with avx512 due because we were missing a check for
; unsupported element types like i24.
define void @trunc_ssat_v16i32_v16i24(<16 x i32> %x, ptr %y) nounwind {
; SSE2-SSSE3-LABEL: trunc_ssat_v16i32_v16i24:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    pushq %rbp
; SSE2-SSSE3-NEXT:    pushq %r15
; SSE2-SSSE3-NEXT:    pushq %r14
; SSE2-SSSE3-NEXT:    pushq %r12
; SSE2-SSSE3-NEXT:    pushq %rbx
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [8388607,8388607,8388607,8388607]
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pand %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm5, %xmm4
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pandn %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pandn %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [4286578688,4286578688,4286578688,4286578688]
; SSE2-SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm0, %xmm1
; SSE2-SSSE3-NEXT:    pandn %xmm5, %xmm0
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    movdqa %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm2
; SSE2-SSSE3-NEXT:    pandn %xmm5, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm1
; SSE2-SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm3
; SSE2-SSSE3-NEXT:    pandn %xmm5, %xmm2
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm2
; SSE2-SSSE3-NEXT:    movdqa %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    pcmpgtd %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm4
; SSE2-SSSE3-NEXT:    pandn %xmm5, %xmm3
; SSE2-SSSE3-NEXT:    por %xmm4, %xmm3
; SSE2-SSSE3-NEXT:    movd %xmm3, %r8d
; SSE2-SSSE3-NEXT:    movw %r8w, 36(%rdi)
; SSE2-SSSE3-NEXT:    movd %xmm2, %r11d
; SSE2-SSSE3-NEXT:    movw %r11w, 24(%rdi)
; SSE2-SSSE3-NEXT:    movd %xmm1, %r14d
; SSE2-SSSE3-NEXT:    movw %r14w, 12(%rdi)
; SSE2-SSSE3-NEXT:    movd %xmm0, %eax
; SSE2-SSSE3-NEXT:    movw %ax, (%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[3,3,3,3]
; SSE2-SSSE3-NEXT:    movd %xmm4, %ecx
; SSE2-SSSE3-NEXT:    movw %cx, 45(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[2,3,2,3]
; SSE2-SSSE3-NEXT:    movd %xmm4, %edx
; SSE2-SSSE3-NEXT:    movw %dx, 42(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,1,1]
; SSE2-SSSE3-NEXT:    movd %xmm3, %esi
; SSE2-SSSE3-NEXT:    movw %si, 39(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %r8d
; SSE2-SSSE3-NEXT:    movb %r8b, 38(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[3,3,3,3]
; SSE2-SSSE3-NEXT:    movd %xmm3, %r8d
; SSE2-SSSE3-NEXT:    movw %r8w, 33(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; SSE2-SSSE3-NEXT:    movd %xmm3, %r9d
; SSE2-SSSE3-NEXT:    movw %r9w, 30(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,1,1]
; SSE2-SSSE3-NEXT:    movd %xmm2, %r10d
; SSE2-SSSE3-NEXT:    movw %r10w, 27(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %r11d
; SSE2-SSSE3-NEXT:    movb %r11b, 26(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[3,3,3,3]
; SSE2-SSSE3-NEXT:    movd %xmm2, %r11d
; SSE2-SSSE3-NEXT:    movw %r11w, 21(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,2,3]
; SSE2-SSSE3-NEXT:    movd %xmm2, %ebx
; SSE2-SSSE3-NEXT:    movw %bx, 18(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; SSE2-SSSE3-NEXT:    movd %xmm1, %ebp
; SSE2-SSSE3-NEXT:    movw %bp, 15(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %r14d
; SSE2-SSSE3-NEXT:    movb %r14b, 14(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[3,3,3,3]
; SSE2-SSSE3-NEXT:    movd %xmm1, %r14d
; SSE2-SSSE3-NEXT:    movw %r14w, 9(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SSE2-SSSE3-NEXT:    movd %xmm1, %r15d
; SSE2-SSSE3-NEXT:    movw %r15w, 6(%rdi)
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE2-SSSE3-NEXT:    movd %xmm0, %r12d
; SSE2-SSSE3-NEXT:    movw %r12w, 3(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %eax
; SSE2-SSSE3-NEXT:    movb %al, 2(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %ecx
; SSE2-SSSE3-NEXT:    movb %cl, 47(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %edx
; SSE2-SSSE3-NEXT:    movb %dl, 44(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %esi
; SSE2-SSSE3-NEXT:    movb %sil, 41(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %r8d
; SSE2-SSSE3-NEXT:    movb %r8b, 35(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %r9d
; SSE2-SSSE3-NEXT:    movb %r9b, 32(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %r10d
; SSE2-SSSE3-NEXT:    movb %r10b, 29(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %r11d
; SSE2-SSSE3-NEXT:    movb %r11b, 23(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %ebx
; SSE2-SSSE3-NEXT:    movb %bl, 20(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %ebp
; SSE2-SSSE3-NEXT:    movb %bpl, 17(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %r14d
; SSE2-SSSE3-NEXT:    movb %r14b, 11(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %r15d
; SSE2-SSSE3-NEXT:    movb %r15b, 8(%rdi)
; SSE2-SSSE3-NEXT:    shrl $16, %r12d
; SSE2-SSSE3-NEXT:    movb %r12b, 5(%rdi)
; SSE2-SSSE3-NEXT:    popq %rbx
; SSE2-SSSE3-NEXT:    popq %r12
; SSE2-SSSE3-NEXT:    popq %r14
; SSE2-SSSE3-NEXT:    popq %r15
; SSE2-SSSE3-NEXT:    popq %rbp
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_ssat_v16i32_v16i24:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [8388607,8388607,8388607,8388607]
; SSE41-NEXT:    pminsd %xmm4, %xmm3
; SSE41-NEXT:    pminsd %xmm4, %xmm2
; SSE41-NEXT:    pminsd %xmm4, %xmm1
; SSE41-NEXT:    pminsd %xmm4, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [4286578688,4286578688,4286578688,4286578688]
; SSE41-NEXT:    pmaxsd %xmm4, %xmm0
; SSE41-NEXT:    pmaxsd %xmm4, %xmm1
; SSE41-NEXT:    pmaxsd %xmm4, %xmm2
; SSE41-NEXT:    pmaxsd %xmm4, %xmm3
; SSE41-NEXT:    pextrd $3, %xmm3, %eax
; SSE41-NEXT:    movw %ax, 45(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 47(%rdi)
; SSE41-NEXT:    pextrd $2, %xmm3, %eax
; SSE41-NEXT:    movw %ax, 42(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 44(%rdi)
; SSE41-NEXT:    pextrd $1, %xmm3, %eax
; SSE41-NEXT:    movw %ax, 39(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 41(%rdi)
; SSE41-NEXT:    movd %xmm3, %eax
; SSE41-NEXT:    movw %ax, 36(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 38(%rdi)
; SSE41-NEXT:    pextrd $3, %xmm2, %eax
; SSE41-NEXT:    movw %ax, 33(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 35(%rdi)
; SSE41-NEXT:    pextrd $2, %xmm2, %eax
; SSE41-NEXT:    movw %ax, 30(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 32(%rdi)
; SSE41-NEXT:    pextrd $1, %xmm2, %eax
; SSE41-NEXT:    movw %ax, 27(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 29(%rdi)
; SSE41-NEXT:    movd %xmm2, %eax
; SSE41-NEXT:    movw %ax, 24(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 26(%rdi)
; SSE41-NEXT:    pextrd $3, %xmm1, %eax
; SSE41-NEXT:    movw %ax, 21(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 23(%rdi)
; SSE41-NEXT:    pextrd $2, %xmm1, %eax
; SSE41-NEXT:    movw %ax, 18(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 20(%rdi)
; SSE41-NEXT:    pextrd $1, %xmm1, %eax
; SSE41-NEXT:    movw %ax, 15(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 17(%rdi)
; SSE41-NEXT:    movd %xmm1, %eax
; SSE41-NEXT:    movw %ax, 12(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 14(%rdi)
; SSE41-NEXT:    pextrd $3, %xmm0, %eax
; SSE41-NEXT:    movw %ax, 9(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 11(%rdi)
; SSE41-NEXT:    pextrd $2, %xmm0, %eax
; SSE41-NEXT:    movw %ax, 6(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 8(%rdi)
; SSE41-NEXT:    pextrd $1, %xmm0, %eax
; SSE41-NEXT:    movw %ax, 3(%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 5(%rdi)
; SSE41-NEXT:    movd %xmm0, %eax
; SSE41-NEXT:    movw %ax, (%rdi)
; SSE41-NEXT:    shrl $16, %eax
; SSE41-NEXT:    movb %al, 2(%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_ssat_v16i32_v16i24:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [8388607,8388607,8388607,8388607]
; AVX1-NEXT:    vpminsd %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpminsd %xmm3, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpminsd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpminsd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [4286578688,4286578688,4286578688,4286578688]
; AVX1-NEXT:    vpmaxsd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpmaxsd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpmaxsd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpmaxsd %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpextrd $3, %xmm3, %eax
; AVX1-NEXT:    movw %ax, 45(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 47(%rdi)
; AVX1-NEXT:    vpextrd $2, %xmm3, %eax
; AVX1-NEXT:    movw %ax, 42(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 44(%rdi)
; AVX1-NEXT:    vpextrd $1, %xmm3, %eax
; AVX1-NEXT:    movw %ax, 39(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 41(%rdi)
; AVX1-NEXT:    vmovd %xmm3, %eax
; AVX1-NEXT:    movw %ax, 36(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 38(%rdi)
; AVX1-NEXT:    vpextrd $3, %xmm2, %eax
; AVX1-NEXT:    movw %ax, 33(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 35(%rdi)
; AVX1-NEXT:    vpextrd $2, %xmm2, %eax
; AVX1-NEXT:    movw %ax, 30(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 32(%rdi)
; AVX1-NEXT:    vpextrd $1, %xmm2, %eax
; AVX1-NEXT:    movw %ax, 27(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 29(%rdi)
; AVX1-NEXT:    vmovd %xmm2, %eax
; AVX1-NEXT:    movw %ax, 24(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 26(%rdi)
; AVX1-NEXT:    vpextrd $3, %xmm1, %eax
; AVX1-NEXT:    movw %ax, 21(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 23(%rdi)
; AVX1-NEXT:    vpextrd $2, %xmm1, %eax
; AVX1-NEXT:    movw %ax, 18(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 20(%rdi)
; AVX1-NEXT:    vpextrd $1, %xmm1, %eax
; AVX1-NEXT:    movw %ax, 15(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 17(%rdi)
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    movw %ax, 12(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 14(%rdi)
; AVX1-NEXT:    vpextrd $3, %xmm0, %eax
; AVX1-NEXT:    movw %ax, 9(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 11(%rdi)
; AVX1-NEXT:    vpextrd $2, %xmm0, %eax
; AVX1-NEXT:    movw %ax, 6(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 8(%rdi)
; AVX1-NEXT:    vpextrd $1, %xmm0, %eax
; AVX1-NEXT:    movw %ax, 3(%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 5(%rdi)
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    movw %ax, (%rdi)
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    movb %al, 2(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_ssat_v16i32_v16i24:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [8388607,8388607,8388607,8388607,8388607,8388607,8388607,8388607]
; AVX2-NEXT:    vpminsd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpminsd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [4286578688,4286578688,4286578688,4286578688,4286578688,4286578688,4286578688,4286578688]
; AVX2-NEXT:    vpmaxsd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpmaxsd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpextrd $3, %xmm2, %eax
; AVX2-NEXT:    movw %ax, 45(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 47(%rdi)
; AVX2-NEXT:    vpextrd $2, %xmm2, %eax
; AVX2-NEXT:    movw %ax, 42(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 44(%rdi)
; AVX2-NEXT:    vpextrd $1, %xmm2, %eax
; AVX2-NEXT:    movw %ax, 39(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 41(%rdi)
; AVX2-NEXT:    vmovd %xmm2, %eax
; AVX2-NEXT:    movw %ax, 36(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 38(%rdi)
; AVX2-NEXT:    vpextrd $3, %xmm1, %eax
; AVX2-NEXT:    movw %ax, 33(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 35(%rdi)
; AVX2-NEXT:    vpextrd $2, %xmm1, %eax
; AVX2-NEXT:    movw %ax, 30(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 32(%rdi)
; AVX2-NEXT:    vpextrd $1, %xmm1, %eax
; AVX2-NEXT:    movw %ax, 27(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 29(%rdi)
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    movw %ax, 24(%rdi)
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 26(%rdi)
; AVX2-NEXT:    vpextrd $3, %xmm1, %eax
; AVX2-NEXT:    movw %ax, 21(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 23(%rdi)
; AVX2-NEXT:    vpextrd $2, %xmm1, %eax
; AVX2-NEXT:    movw %ax, 18(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 20(%rdi)
; AVX2-NEXT:    vpextrd $1, %xmm1, %eax
; AVX2-NEXT:    movw %ax, 15(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 17(%rdi)
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    movw %ax, 12(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 14(%rdi)
; AVX2-NEXT:    vpextrd $3, %xmm0, %eax
; AVX2-NEXT:    movw %ax, 9(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 11(%rdi)
; AVX2-NEXT:    vpextrd $2, %xmm0, %eax
; AVX2-NEXT:    movw %ax, 6(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 8(%rdi)
; AVX2-NEXT:    vpextrd $1, %xmm0, %eax
; AVX2-NEXT:    movw %ax, 3(%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 5(%rdi)
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    movw %ax, (%rdi)
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    movb %al, 2(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_ssat_v16i32_v16i24:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    pushq %r15
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    vpminsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; AVX512-NEXT:    vpmaxsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; AVX512-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512-NEXT:    vpextrd $3, %xmm1, %r15d
; AVX512-NEXT:    movw %r15w, 45(%rdi)
; AVX512-NEXT:    vpextrd $2, %xmm1, %r14d
; AVX512-NEXT:    movw %r14w, 42(%rdi)
; AVX512-NEXT:    vpextrd $1, %xmm1, %ebp
; AVX512-NEXT:    movw %bp, 39(%rdi)
; AVX512-NEXT:    vmovd %xmm1, %r11d
; AVX512-NEXT:    movw %r11w, 36(%rdi)
; AVX512-NEXT:    vextracti32x4 $2, %zmm0, %xmm1
; AVX512-NEXT:    vpextrd $3, %xmm1, %ebx
; AVX512-NEXT:    movw %bx, 33(%rdi)
; AVX512-NEXT:    vpextrd $2, %xmm1, %r10d
; AVX512-NEXT:    movw %r10w, 30(%rdi)
; AVX512-NEXT:    vpextrd $1, %xmm1, %r9d
; AVX512-NEXT:    movw %r9w, 27(%rdi)
; AVX512-NEXT:    vmovd %xmm1, %r8d
; AVX512-NEXT:    movw %r8w, 24(%rdi)
; AVX512-NEXT:    vpextrd $3, %xmm0, %esi
; AVX512-NEXT:    movw %si, 9(%rdi)
; AVX512-NEXT:    vpextrd $2, %xmm0, %edx
; AVX512-NEXT:    movw %dx, 6(%rdi)
; AVX512-NEXT:    vpextrd $1, %xmm0, %ecx
; AVX512-NEXT:    movw %cx, 3(%rdi)
; AVX512-NEXT:    vmovd %xmm0, %eax
; AVX512-NEXT:    movw %ax, (%rdi)
; AVX512-NEXT:    shrl $16, %r15d
; AVX512-NEXT:    movb %r15b, 47(%rdi)
; AVX512-NEXT:    shrl $16, %r14d
; AVX512-NEXT:    movb %r14b, 44(%rdi)
; AVX512-NEXT:    shrl $16, %ebp
; AVX512-NEXT:    movb %bpl, 41(%rdi)
; AVX512-NEXT:    shrl $16, %r11d
; AVX512-NEXT:    movb %r11b, 38(%rdi)
; AVX512-NEXT:    shrl $16, %ebx
; AVX512-NEXT:    movb %bl, 35(%rdi)
; AVX512-NEXT:    shrl $16, %r10d
; AVX512-NEXT:    movb %r10b, 32(%rdi)
; AVX512-NEXT:    shrl $16, %r9d
; AVX512-NEXT:    movb %r9b, 29(%rdi)
; AVX512-NEXT:    shrl $16, %r8d
; AVX512-NEXT:    movb %r8b, 26(%rdi)
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpextrd $3, %xmm0, %r11d
; AVX512-NEXT:    movw %r11w, 21(%rdi)
; AVX512-NEXT:    vpextrd $2, %xmm0, %r10d
; AVX512-NEXT:    movw %r10w, 18(%rdi)
; AVX512-NEXT:    vpextrd $1, %xmm0, %r9d
; AVX512-NEXT:    movw %r9w, 15(%rdi)
; AVX512-NEXT:    vmovd %xmm0, %r8d
; AVX512-NEXT:    movw %r8w, 12(%rdi)
; AVX512-NEXT:    shrl $16, %esi
; AVX512-NEXT:    movb %sil, 11(%rdi)
; AVX512-NEXT:    shrl $16, %edx
; AVX512-NEXT:    movb %dl, 8(%rdi)
; AVX512-NEXT:    shrl $16, %ecx
; AVX512-NEXT:    movb %cl, 5(%rdi)
; AVX512-NEXT:    shrl $16, %eax
; AVX512-NEXT:    movb %al, 2(%rdi)
; AVX512-NEXT:    shrl $16, %r11d
; AVX512-NEXT:    movb %r11b, 23(%rdi)
; AVX512-NEXT:    shrl $16, %r10d
; AVX512-NEXT:    movb %r10b, 20(%rdi)
; AVX512-NEXT:    shrl $16, %r9d
; AVX512-NEXT:    movb %r9b, 17(%rdi)
; AVX512-NEXT:    shrl $16, %r8d
; AVX512-NEXT:    movb %r8b, 14(%rdi)
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    popq %r15
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; SKX-LABEL: trunc_ssat_v16i32_v16i24:
; SKX:       # %bb.0:
; SKX-NEXT:    pushq %rbp
; SKX-NEXT:    pushq %r15
; SKX-NEXT:    pushq %r14
; SKX-NEXT:    pushq %rbx
; SKX-NEXT:    vpminsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; SKX-NEXT:    vpmaxsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; SKX-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; SKX-NEXT:    vpextrd $3, %xmm1, %r15d
; SKX-NEXT:    movw %r15w, 45(%rdi)
; SKX-NEXT:    vpextrd $2, %xmm1, %r14d
; SKX-NEXT:    movw %r14w, 42(%rdi)
; SKX-NEXT:    vpextrd $1, %xmm1, %ebp
; SKX-NEXT:    movw %bp, 39(%rdi)
; SKX-NEXT:    vmovd %xmm1, %r11d
; SKX-NEXT:    movw %r11w, 36(%rdi)
; SKX-NEXT:    vextracti32x4 $2, %zmm0, %xmm1
; SKX-NEXT:    vpextrd $3, %xmm1, %ebx
; SKX-NEXT:    movw %bx, 33(%rdi)
; SKX-NEXT:    vpextrd $2, %xmm1, %r10d
; SKX-NEXT:    movw %r10w, 30(%rdi)
; SKX-NEXT:    vpextrd $1, %xmm1, %r9d
; SKX-NEXT:    movw %r9w, 27(%rdi)
; SKX-NEXT:    vmovd %xmm1, %r8d
; SKX-NEXT:    vpextrd $3, %xmm0, %edx
; SKX-NEXT:    movw %r8w, 24(%rdi)
; SKX-NEXT:    movw %dx, 9(%rdi)
; SKX-NEXT:    vpextrd $2, %xmm0, %esi
; SKX-NEXT:    vpextrd $1, %xmm0, %eax
; SKX-NEXT:    movw %si, 6(%rdi)
; SKX-NEXT:    movw %ax, 3(%rdi)
; SKX-NEXT:    vmovd %xmm0, %ecx
; SKX-NEXT:    movw %cx, (%rdi)
; SKX-NEXT:    shrl $16, %r15d
; SKX-NEXT:    movb %r15b, 47(%rdi)
; SKX-NEXT:    shrl $16, %r14d
; SKX-NEXT:    movb %r14b, 44(%rdi)
; SKX-NEXT:    shrl $16, %ebp
; SKX-NEXT:    movb %bpl, 41(%rdi)
; SKX-NEXT:    shrl $16, %r11d
; SKX-NEXT:    movb %r11b, 38(%rdi)
; SKX-NEXT:    shrl $16, %ebx
; SKX-NEXT:    movb %bl, 35(%rdi)
; SKX-NEXT:    shrl $16, %r10d
; SKX-NEXT:    movb %r10b, 32(%rdi)
; SKX-NEXT:    shrl $16, %r9d
; SKX-NEXT:    movb %r9b, 29(%rdi)
; SKX-NEXT:    shrl $16, %r8d
; SKX-NEXT:    movb %r8b, 26(%rdi)
; SKX-NEXT:    vextracti128 $1, %ymm0, %xmm0
; SKX-NEXT:    vpextrd $3, %xmm0, %r11d
; SKX-NEXT:    movw %r11w, 21(%rdi)
; SKX-NEXT:    vpextrd $2, %xmm0, %r10d
; SKX-NEXT:    movw %r10w, 18(%rdi)
; SKX-NEXT:    vpextrd $1, %xmm0, %r9d
; SKX-NEXT:    movw %r9w, 15(%rdi)
; SKX-NEXT:    vmovd %xmm0, %r8d
; SKX-NEXT:    movw %r8w, 12(%rdi)
; SKX-NEXT:    shrl $16, %edx
; SKX-NEXT:    movb %dl, 11(%rdi)
; SKX-NEXT:    shrl $16, %esi
; SKX-NEXT:    movb %sil, 8(%rdi)
; SKX-NEXT:    shrl $16, %eax
; SKX-NEXT:    movb %al, 5(%rdi)
; SKX-NEXT:    shrl $16, %ecx
; SKX-NEXT:    movb %cl, 2(%rdi)
; SKX-NEXT:    shrl $16, %r11d
; SKX-NEXT:    movb %r11b, 23(%rdi)
; SKX-NEXT:    shrl $16, %r10d
; SKX-NEXT:    movb %r10b, 20(%rdi)
; SKX-NEXT:    shrl $16, %r9d
; SKX-NEXT:    movb %r9b, 17(%rdi)
; SKX-NEXT:    shrl $16, %r8d
; SKX-NEXT:    movb %r8b, 14(%rdi)
; SKX-NEXT:    popq %rbx
; SKX-NEXT:    popq %r14
; SKX-NEXT:    popq %r15
; SKX-NEXT:    popq %rbp
; SKX-NEXT:    vzeroupper
; SKX-NEXT:    retq
  %a = call <16 x i32> @llvm.smin.v16i32(<16 x i32> %x, <16 x i32> <i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607, i32 8388607>)
  %b = call <16 x i32> @llvm.smax.v16i32(<16 x i32> %a, <16 x i32> <i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608, i32 -8388608>)
  %c = trunc <16 x i32> %b to <16 x i24>
  store <16 x i24> %c, ptr %y
  ret void
}
declare <16 x i32> @llvm.smax.v16i32(<16 x i32>, <16 x i32>)
declare <16 x i32> @llvm.smin.v16i32(<16 x i32>, <16 x i32>)
