/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.container.initialization;

import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.container.initialization.AbstractContainerInitializationPhase;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;

public abstract class AbstractCoreComponentInitializationPhase
extends AbstractContainerInitializationPhase {
    BasicComponentConfigurator configurator = new BasicComponentConfigurator();

    public void execute(ContainerInitializationContext context) throws ContainerInitializationException {
        this.initializeCoreComponent(context);
    }

    protected abstract void initializeCoreComponent(ContainerInitializationContext var1) throws ContainerInitializationException;

    protected void setupCoreComponent(String role, BasicComponentConfigurator configurator, PlexusConfiguration c, PlexusContainer container) throws ContainerInitializationException {
        String implementation = c.getAttribute("implementation", null);
        if (implementation == null) {
            String msg = "Core component: '" + role + "' + which is needed by plexus to function properly cannot " + "be instantiated. Implementation attribute was not specified in plexus.conf." + "This is highly irregular, your plexus JAR is most likely corrupt.";
            throw new ContainerInitializationException(msg);
        }
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setRole(role);
        componentDescriptor.setImplementation(implementation);
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration("containerConfiguration");
        configuration.addChild(c);
        try {
            configurator.configureComponent(container, configuration, container.getContainerRealm());
        }
        catch (ComponentConfigurationException e) {
            String message = "Error configuring component: " + componentDescriptor.getHumanReadableKey();
            throw new ContainerInitializationException(message, e);
        }
    }
}

