The LaTeX `graphics` bundle
===========================

Release 2024-06-01 patch level 0

Overview
--------

This bundle consists of packages supporting basic color, graphics and text
manipulation operations in LaTeX. The packages provided here are

- `color`: Core color support
- `graphics`: The original LaTeX graphics inclusion interface
- `graphicx`: Extended interface for graphics inclusion
- `lscape`: Production of landscape pages
- `keyval`: Core key-value support for LaTeX
- `rotating`: Support for rotating material
- `trig`: Support for fast trigonometric calculations in TeX

plus the legacy stub `epsfig` (now subsumed into `graphics`).

Installation
------------

We no longer distribute installation instructions for the various TeX
implementations. All modern TeX systems include `graphics` as-standard, and end
users should in general use the release versions supplied in this way.

Release distribution is carried out only through the CTAN archives.

Reporting Bugs
--------------

If you wish to report a problem or bug in the `graphics` bundle
please use the [Issue Tracker for LaTeX2e on
GitHub](https://github.com/latex3/latex2e/issues)
and follow the guidelines that pop up if you press the "New issue" button.

In particular, to check that you are really seeing a bug, please write
a short, self-contained document that shows the problem. This should
include the `latexbug` package, which will warn if your test file is
not suitable for one or the other reason. See the [CONTRIBUTING
guide](https://github.com/latex3/latex2e/blob/main/CONTRIBUTING.md)
for further details, or if you need to obtain the `latexbug` package.

If the bug turns out to be with third-party software then please
contact the developer, and not us!

License
-------

The contents of this bundle are distributed under the [LaTeX Project
Public License](https://www.latex-project.org/lppl/lppl-1-3c/),
version 1.3c or later.

Copyright
---------

Copyright is maintained on each of these packages by the author(s)
of the package.

-----

<p>Copyright (C) 1993-2024 The LaTeX Project <br />
