---
documentation_complete: true

hidden: true

title: Default Profile for Ubuntu 22.04

description: |-
    This profile contains all the rules that once belonged to the
    ubuntu2204 product via 'prodtype'. This profile won't
    be rendered into an XCCDF Profile entity, nor it will select any
    of these rules by default. The only purpose of this profile
    is to keep a rule in the product's XCCDF Benchmark.

selections:
    - grub2_enable_iommu_force
    - is_fips_mode_enabled
    - kernel_config_module_sig_key
    - auditd_data_disk_full_action
    - grub2_rng_core_default_quality_argument
    - kernel_config_debug_list
    - package_MFEhiplsm_installed
    - disable_ctrlaltdel_burstaction
    - grub2_nosmep_argument_absent
    - configure_user_data_backups
    - accounts_polyinstantiated_var_tmp
    - kernel_config_page_table_isolation
    - kernel_config_module_sig_sha512
    - dir_ownership_binary_dirs
    - kernel_config_slub_debug
    - kernel_config_page_poisoning_no_sanity
    - rsyslog_encrypt_offload_defaultnetstreamdriver
    - audit_rules_privileged_commands_fdisk
    - file_ownership_library_dirs
    - file_permissions_library_dirs
    - coredump_disable_storage
    - kernel_config_seccomp
    - auditd_data_retention_max_log_file_action_stig
    - sysctl_net_ipv6_conf_default_disable_ipv6
    - audit_rules_usergroup_modification
    - package_mcafeetp_installed
    - kernel_config_security_yama
    - sshd_set_loglevel_verbose
    - audit_rules_session_events_btmp
    - audit_rules_dac_modification_umount
    - no_empty_passwords
    - kernel_module_uvcvideo_disabled
    - sshd_disable_user_known_hosts
    - sudoers_no_command_negation
    - service_kdump_disabled
    - auditd_name_format
    - no_password_auth_for_systemaccounts
    - restrict_serial_port_logins
    - auditd_local_events
    - kernel_config_default_mmap_min_addr
    - kernel_config_hibernation
    - set_iptables_default_rule_forward
    - sysctl_net_ipv4_conf_all_arp_filter
    - account_use_centralized_automated_auth
    - display_login_attempts
    - kernel_config_seccomp_filter
    - file_groupowner_var_log
    - sshd_rekey_limit
    - kernel_config_security
    - sysctl_net_ipv6_conf_all_disable_ipv6
    - sudo_vdsm_nopasswd
    - kernel_config_security_writable_hooks
    - fapolicyd_prevent_home_folder_access
    - audit_rules_session_events_utmp
    - kernel_config_binfmt_misc
    - zipl_audit_argument
    - sshd_enable_warning_banner
    - audit_rules_dac_modification_umount2
    - kernel_config_security_dmesg_restrict
    - package_postfix_installed
    - sysctl_net_ipv4_conf_all_accept_local
    - audit_privileged_commands_poweroff
    - sysctl_kernel_kptr_restrict
    - rsyslog_remote_access_monitoring
    - sudoers_no_root_target
    - auditd_data_retention_space_left_percentage
    - auditd_write_logs
    - grub2_mce_argument
    - coredump_disable_backtraces
    - dir_perms_world_writable_sticky_bits
    - only_allow_dod_certs
    - kernel_config_kexec
    - accounts_polyinstantiated_tmp
    - dconf_gnome_disable_ctrlaltdel_reboot
    - rsyslog_remote_loghost
    - kernel_disable_entropy_contribution_for_solid_state_drives
    - avahi_disable_publishing
    - package_chrony_installed
    - sssd_offline_cred_expiration
    - sshd_use_priv_separation
    - audit_privileged_commands_shutdown
    - file_groupownership_sshd_pub_key
    - account_passwords_pam_faillock_dir
    - kernel_config_devkmem
    - kernel_config_panic_timeout
    - dir_permissions_library_dirs
    - kernel_config_debug_credentials
    - file_ownership_var_log_audit
    - file_permissions_var_log
    - kernel_config_legacy_ptys
    - file_ownership_sshd_private_key
    - sshd_use_approved_ciphers_ordered_stig
    - kernel_config_panic_on_oops
    - file_groupowner_var_log_syslog
    - grub2_systemd_debug-shell_argument_absent
    - dir_group_ownership_library_dirs
    - bios_enable_execution_restrictions
    - service_netfs_disabled
    - ftp_limit_users
    - file_groupownership_sshd_private_key
    - kernel_module_ipv6_option_disabled
    - auditd_audispd_configure_remote_server
    - audit_rules_privileged_commands
    - auditd_data_disk_full_action_stig
    - rsyslog_accept_remote_messages_tcp
    - apt_conf_disallow_unauthenticated
    - file_ownership_sshd_pub_key
    - kernel_config_randomize_memory
    - kernel_module_hfs_disabled
    - sudo_add_requiretty
    - package_ntp_installed
    - ensure_rtc_utc_configuration
    - package_ufw_installed
    - sshd_disable_compression
    - sshd_disable_gssapi_auth
    - enable_dconf_user_profile
    - prevent_direct_root_logins
    - sshd_enable_gssapi_auth
    - kernel_config_debug_sg
    - sshd_print_last_log
    - auditd_data_retention_admin_space_left_percentage
    - grub2_nosmap_argument_absent
    - kernel_config_module_sig_hash
    - policy_temp_passwords_immediate_change
    - kernel_config_randomize_base
    - dir_ownership_library_dirs
    - partition_for_dev_shm
    - sysctl_net_ipv4_conf_default_shared_media
    - grub2_l1tf_argument
    - ftp_configure_firewall
    - auditd_data_disk_error_action
    - kernel_config_x86_vsyscall_emulation
    - chronyd_sync_clock
    - kernel_config_debug_notifiers
    - kernel_config_proc_kcore
    - audit_rules_file_deletion_events_rmdir
    - auditd_overflow_action
    - zipl_audit_backlog_limit_argument
    - sshd_allow_only_protocol2
    - sysctl_net_ipv4_conf_all_arp_ignore
    - grub2_spectre_v2_argument
    - kernel_config_ipv6
    - file_permissions_home_dirs
    - file_ownership_binary_dirs
    - grub2_disable_recovery
    - file_groupownership_system_commands_dirs
    - postfix_client_configure_mail_alias_postmaster
    - securetty_root_login_console_only
    - audit_rules_privileged_commands_kmod
    - file_permissions_var_log_messages
    - no_direct_root_logins
    - package_nftables_removed
    - sshd_set_keepalive_0
    - audit_rules_privileged_commands_apparmor_parser
    - root_permissions_syslibrary_files
    - accounts_password_minlen_login_defs
    - selinux_not_disabled
    - package_nss-tools_installed
    - sysctl_net_ipv4_conf_all_shared_media
    - package_iptables-persistent_installed
    - audit_rules_unsuccessful_file_modification_open_by_handle_at
    - encrypt_partitions
    - sshd_enable_strictmodes
    - sudo_remove_nopasswd
    - kernel_config_bug
    - kernel_config_page_poisoning_zero
    - package_logrotate_installed
    - clean_components_post_updating
    - sshd_enable_pubkey_auth
    - kernel_config_compat_vdso
    - postfix_client_configure_mail_alias
    - package_xorg-x11-server-common_removed
    - service_iptables_enabled
    - postfix_client_configure_relayhost
    - audit_privileged_commands_init
    - iptables_sshd_disabled
    - chronyd_server_directive
    - kernel_config_compat_brk
    - kernel_module_hfsplus_disabled
    - grub2_spec_store_bypass_disable_argument
    - kernel_config_unmap_kernel_at_el0
    - service_postfix_enabled
    - package_openssh-server_removed
    - disable_ctrlaltdel_reboot
    - partition_for_srv
    - sysctl_net_ipv4_conf_all_route_localnet
    - sudo_add_noexec
    - auditd_log_format
    - audit_rules_privileged_commands_unix_update
    - service_syslogng_enabled
    - kernel_config_retpoline
    - kernel_config_debug_fs
    - account_passwords_pam_faillock_audit
    - disallow_bypass_password_sudo
    - sudoers_explicit_command_args
    - accounts_max_concurrent_login_sessions
    - auditd_data_retention_num_logs
    - file_owner_var_log
    - prefer_64bit_os
    - package_rsh-server_removed
    - package_xinetd_removed
    - sshd_enable_x11_forwarding
    - service_nftables_disabled
    - service_sshd_disabled
    - auditd_offload_logs
    - sshd_disable_rhosts_rsa
    - sysctl_kernel_panic_on_oops
    - file_permissions_audit_configuration
    - harden_ssh_client_crypto_policy
    - dhcp_server_minimize_served_info
    - no_all_squash_exports
    - sshd_disable_kerb_auth
    - package_openssh-server_installed
    - accounts_logon_fail_delay
    - selinux_state
    - dir_permissions_binary_dirs
    - file_groupowner_var_log_messages
    - auditd_audispd_syslog_plugin_activated
    - audit_rules_privileged_commands_pam_timestamp_check
    - auditd_audispd_configure_sufficiently_large_partition
    - kernel_config_acpi_custom_method
    - sshd_disable_pubkey_auth
    - package_gnutls-utils_installed
    - apparmor_configured
    - dhcp_client_restrict_options
    - audit_privileged_commands_reboot
    - file_permissions_binary_dirs
    - auditd_freq
    - accounts_passwords_pam_faillock_audit
    - rsyslog_encrypt_offload_actionsendstreamdrivermode
    - audit_rules_privileged_commands_passwd
    - kernel_config_module_sig_all
    - kernel_config_syn_cookies
    - rsyslog_encrypt_offload_actionsendstreamdriverauthmode
    - package_syslogng_installed
    - chronyd_or_ntpd_set_maxpoll
    - auditd_data_disk_error_action_stig
    - kernel_config_ia32_emulation
    - rsyslog_accept_remote_messages_udp
    - file_owner_var_log_messages
    - file_permissions_var_log_syslog
    - installed_OS_is_FIPS_certified
    - chronyd_specify_remote_server
    - grub2_slab_nomerge_argument
    - kernel_config_module_sig
    - sshd_disable_root_password_login
    - audit_rules_mac_modification_usr_share
    - kernel_config_module_sig_force
    - audit_rules_kernel_module_loading_finit
    - file_owner_var_log_syslog
    - service_ip6tables_enabled
    - dir_groupownership_binary_dirs
    - audit_rules_session_events_wtmp
