; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+sve -o - | FileCheck %s

target triple = "aarch64"

; Expected to transform
define <vscale x 4 x half> @complex_mul_v4f16(<vscale x 4 x half> %a, <vscale x 4 x half> %b) {
; CHECK-LABEL: complex_mul_v4f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z2.d, z0.s
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    uunpkhi z3.d, z1.s
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    uzp2 z4.d, z0.d, z2.d
; CHECK-NEXT:    uzp1 z0.d, z0.d, z2.d
; CHECK-NEXT:    uzp2 z2.d, z1.d, z3.d
; CHECK-NEXT:    uzp1 z1.d, z1.d, z3.d
; CHECK-NEXT:    movprfx z3, z2
; CHECK-NEXT:    fmul z3.h, p0/m, z3.h, z0.h
; CHECK-NEXT:    fmul z2.h, p0/m, z2.h, z4.h
; CHECK-NEXT:    fmla z3.h, p0/m, z1.h, z4.h
; CHECK-NEXT:    fnmsb z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    zip2 z1.d, z0.d, z3.d
; CHECK-NEXT:    zip1 z0.d, z0.d, z3.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z1.s
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 2 x half>, <vscale x 2 x half> } @llvm.experimental.vector.deinterleave2.nxv4f16(<vscale x 4 x half> %a)
  %a.real = extractvalue { <vscale x 2 x half>, <vscale x 2 x half> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 2 x half>, <vscale x 2 x half> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 2 x half>, <vscale x 2 x half> } @llvm.experimental.vector.deinterleave2.nxv4f16(<vscale x 4 x half> %b)
  %b.real = extractvalue { <vscale x 2 x half>, <vscale x 2 x half> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 2 x half>, <vscale x 2 x half> } %b.deinterleaved, 1
  %0 = fmul fast <vscale x 2 x half> %b.imag, %a.real
  %1 = fmul fast <vscale x 2 x half> %b.real, %a.imag
  %2 = fadd fast <vscale x 2 x half> %1, %0
  %3 = fmul fast <vscale x 2 x half> %b.real, %a.real
  %4 = fmul fast <vscale x 2 x half> %a.imag, %b.imag
  %5 = fsub fast <vscale x 2 x half> %3, %4
  %interleaved.vec = tail call <vscale x 4 x half> @llvm.experimental.vector.interleave2.nxv4f16(<vscale x 2 x half> %5, <vscale x 2 x half> %2)
  ret <vscale x 4 x half> %interleaved.vec
}

; Expected to transform
define <vscale x 8 x half> @complex_mul_v8f16(<vscale x 8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: complex_mul_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, #0 // =0x0
; CHECK-NEXT:    fcmla z2.h, p0/m, z1.h, z0.h, #0
; CHECK-NEXT:    fcmla z2.h, p0/m, z1.h, z0.h, #90
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 4 x half>, <vscale x 4 x half> } @llvm.experimental.vector.deinterleave2.nxv8f16(<vscale x 8 x half> %a)
  %a.real = extractvalue { <vscale x 4 x half>, <vscale x 4 x half> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 4 x half>, <vscale x 4 x half> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 4 x half>, <vscale x 4 x half> } @llvm.experimental.vector.deinterleave2.nxv8f16(<vscale x 8 x half> %b)
  %b.real = extractvalue { <vscale x 4 x half>, <vscale x 4 x half> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 4 x half>, <vscale x 4 x half> } %b.deinterleaved, 1
  %0 = fmul fast <vscale x 4 x half> %b.imag, %a.real
  %1 = fmul fast <vscale x 4 x half> %b.real, %a.imag
  %2 = fadd fast <vscale x 4 x half> %1, %0
  %3 = fmul fast <vscale x 4 x half> %b.real, %a.real
  %4 = fmul fast <vscale x 4 x half> %a.imag, %b.imag
  %5 = fsub fast <vscale x 4 x half> %3, %4
  %interleaved.vec = tail call <vscale x 8 x half> @llvm.experimental.vector.interleave2.nxv8f16(<vscale x 4 x half> %5, <vscale x 4 x half> %2)
  ret <vscale x 8 x half> %interleaved.vec
}
; Expected to transform
define <vscale x 16 x half> @complex_mul_v16f16(<vscale x 16 x half> %a, <vscale x 16 x half> %b) {
; CHECK-LABEL: complex_mul_v16f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z4.h, #0 // =0x0
; CHECK-NEXT:    mov z5.d, z4.d
; CHECK-NEXT:    fcmla z5.h, p0/m, z2.h, z0.h, #0
; CHECK-NEXT:    fcmla z4.h, p0/m, z3.h, z1.h, #0
; CHECK-NEXT:    fcmla z5.h, p0/m, z2.h, z0.h, #90
; CHECK-NEXT:    fcmla z4.h, p0/m, z3.h, z1.h, #90
; CHECK-NEXT:    mov z0.d, z5.d
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 8 x half>, <vscale x 8 x half> } @llvm.experimental.vector.deinterleave2.nxv16f16(<vscale x 16 x half> %a)
  %a.real = extractvalue { <vscale x 8 x half>, <vscale x 8 x half> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 8 x half>, <vscale x 8 x half> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 8 x half>, <vscale x 8 x half> } @llvm.experimental.vector.deinterleave2.nxv16f16(<vscale x 16 x half> %b)
  %b.real = extractvalue { <vscale x 8 x half>, <vscale x 8 x half> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 8 x half>, <vscale x 8 x half> } %b.deinterleaved, 1
  %0 = fmul fast <vscale x 8 x half> %b.imag, %a.real
  %1 = fmul fast <vscale x 8 x half> %b.real, %a.imag
  %2 = fadd fast <vscale x 8 x half> %1, %0
  %3 = fmul fast <vscale x 8 x half> %b.real, %a.real
  %4 = fmul fast <vscale x 8 x half> %a.imag, %b.imag
  %5 = fsub fast <vscale x 8 x half> %3, %4
  %interleaved.vec = tail call <vscale x 16 x half> @llvm.experimental.vector.interleave2.nxv16f16(<vscale x 8 x half> %5, <vscale x 8 x half> %2)
  ret <vscale x 16 x half> %interleaved.vec
}

; Expected to transform
define <vscale x 32 x half> @complex_mul_v32f16(<vscale x 32 x half> %a, <vscale x 32 x half> %b) {
; CHECK-LABEL: complex_mul_v32f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z24.h, #0 // =0x0
; CHECK-NEXT:    mov z25.d, z24.d
; CHECK-NEXT:    mov z26.d, z24.d
; CHECK-NEXT:    mov z27.d, z24.d
; CHECK-NEXT:    fcmla z25.h, p0/m, z4.h, z0.h, #0
; CHECK-NEXT:    fcmla z26.h, p0/m, z5.h, z1.h, #0
; CHECK-NEXT:    fcmla z27.h, p0/m, z6.h, z2.h, #0
; CHECK-NEXT:    fcmla z24.h, p0/m, z7.h, z3.h, #0
; CHECK-NEXT:    fcmla z25.h, p0/m, z4.h, z0.h, #90
; CHECK-NEXT:    fcmla z26.h, p0/m, z5.h, z1.h, #90
; CHECK-NEXT:    fcmla z27.h, p0/m, z6.h, z2.h, #90
; CHECK-NEXT:    fcmla z24.h, p0/m, z7.h, z3.h, #90
; CHECK-NEXT:    mov z0.d, z25.d
; CHECK-NEXT:    mov z1.d, z26.d
; CHECK-NEXT:    mov z2.d, z27.d
; CHECK-NEXT:    mov z3.d, z24.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 16 x half>, <vscale x 16 x half> } @llvm.experimental.vector.deinterleave2.nxv32f16(<vscale x 32 x half> %a)
  %a.real = extractvalue { <vscale x 16 x half>, <vscale x 16 x half> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 16 x half>, <vscale x 16 x half> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 16 x half>, <vscale x 16 x half> } @llvm.experimental.vector.deinterleave2.nxv32f16(<vscale x 32 x half> %b)
  %b.real = extractvalue { <vscale x 16 x half>, <vscale x 16 x half> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 16 x half>, <vscale x 16 x half> } %b.deinterleaved, 1
  %0 = fmul fast <vscale x 16 x half> %b.imag, %a.real
  %1 = fmul fast <vscale x 16 x half> %b.real, %a.imag
  %2 = fadd fast <vscale x 16 x half> %1, %0
  %3 = fmul fast <vscale x 16 x half> %b.real, %a.real
  %4 = fmul fast <vscale x 16 x half> %a.imag, %b.imag
  %5 = fsub fast <vscale x 16 x half> %3, %4
  %interleaved.vec = tail call <vscale x 32 x half> @llvm.experimental.vector.interleave2.nxv32f16(<vscale x 16 x half> %5, <vscale x 16 x half> %2)
  ret <vscale x 32 x half> %interleaved.vec
}

declare { <vscale x 2 x half>, <vscale x 2 x half> } @llvm.experimental.vector.deinterleave2.nxv4f16(<vscale x 4 x half>)
declare <vscale x 4 x half> @llvm.experimental.vector.interleave2.nxv4f16(<vscale x 2 x half>, <vscale x 2 x half>)

declare { <vscale x 4 x half>, <vscale x 4 x half> } @llvm.experimental.vector.deinterleave2.nxv8f16(<vscale x 8 x half>)
declare <vscale x 8 x half> @llvm.experimental.vector.interleave2.nxv8f16(<vscale x 4 x half>, <vscale x 4 x half>)

declare { <vscale x 8 x half>, <vscale x 8 x half> } @llvm.experimental.vector.deinterleave2.nxv16f16(<vscale x 16 x half>)
declare <vscale x 16 x half> @llvm.experimental.vector.interleave2.nxv16f16(<vscale x 8 x half>, <vscale x 8 x half>)

declare { <vscale x 16 x half>, <vscale x 16 x half> } @llvm.experimental.vector.deinterleave2.nxv32f16(<vscale x 32 x half>)
declare <vscale x 32 x half> @llvm.experimental.vector.interleave2.nxv32f16(<vscale x 16 x half>, <vscale x 16 x half>)


