; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 < %s | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 < %s | FileCheck %s --check-prefix=LA64

declare i8 @llvm.ctlz.i8(i8, i1)
declare i16 @llvm.ctlz.i16(i16, i1)
declare i32 @llvm.ctlz.i32(i32, i1)
declare i64 @llvm.ctlz.i64(i64, i1)
declare i8 @llvm.ctpop.i8(i8)
declare i16 @llvm.ctpop.i16(i16)
declare i32 @llvm.ctpop.i32(i32)
declare i64 @llvm.ctpop.i64(i64)
declare i8 @llvm.cttz.i8(i8, i1)
declare i16 @llvm.cttz.i16(i16, i1)
declare i32 @llvm.cttz.i32(i32, i1)
declare i64 @llvm.cttz.i64(i64, i1)

define i8 @test_ctlz_i8(i8 %a) nounwind {
; LA32-LABEL: test_ctlz_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    andi $a0, $a0, 255
; LA32-NEXT:    clz.w $a0, $a0
; LA32-NEXT:    addi.w $a0, $a0, -24
; LA32-NEXT:    ret
;
; LA64-LABEL: test_ctlz_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    clz.d $a0, $a0
; LA64-NEXT:    addi.d $a0, $a0, -56
; LA64-NEXT:    ret
  %tmp = call i8 @llvm.ctlz.i8(i8 %a, i1 false)
  ret i8 %tmp
}

define i16 @test_ctlz_i16(i16 %a) nounwind {
; LA32-LABEL: test_ctlz_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32-NEXT:    clz.w $a0, $a0
; LA32-NEXT:    addi.w $a0, $a0, -16
; LA32-NEXT:    ret
;
; LA64-LABEL: test_ctlz_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-NEXT:    clz.d $a0, $a0
; LA64-NEXT:    addi.d $a0, $a0, -48
; LA64-NEXT:    ret
  %tmp = call i16 @llvm.ctlz.i16(i16 %a, i1 false)
  ret i16 %tmp
}

define i32 @test_ctlz_i32(i32 %a) nounwind {
; LA32-LABEL: test_ctlz_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    clz.w $a0, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: test_ctlz_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    clz.w $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
  ret i32 %tmp
}

define i64 @test_ctlz_i64(i64 %a) nounwind {
; LA32-LABEL: test_ctlz_i64:
; LA32:       # %bb.0:
; LA32-NEXT:    sltu $a2, $zero, $a1
; LA32-NEXT:    clz.w $a1, $a1
; LA32-NEXT:    maskeqz $a1, $a1, $a2
; LA32-NEXT:    clz.w $a0, $a0
; LA32-NEXT:    addi.w $a0, $a0, 32
; LA32-NEXT:    masknez $a0, $a0, $a2
; LA32-NEXT:    or $a0, $a1, $a0
; LA32-NEXT:    move $a1, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: test_ctlz_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    clz.d $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i64 @llvm.ctlz.i64(i64 %a, i1 false)
  ret i64 %tmp
}

define i8 @test_not_ctlz_i8(i8 %a) nounwind {
; LA32-LABEL: test_not_ctlz_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    ori $a1, $zero, 255
; LA32-NEXT:    andn $a0, $a1, $a0
; LA32-NEXT:    clz.w $a0, $a0
; LA32-NEXT:    addi.w $a0, $a0, -24
; LA32-NEXT:    ret
;
; LA64-LABEL: test_not_ctlz_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    ori $a1, $zero, 255
; LA64-NEXT:    andn $a0, $a1, $a0
; LA64-NEXT:    clz.d $a0, $a0
; LA64-NEXT:    addi.d $a0, $a0, -56
; LA64-NEXT:    ret
  %neg = xor i8 %a, -1
  %tmp = call i8 @llvm.ctlz.i8(i8 %neg, i1 false)
  ret i8 %tmp
}

define i16 @test_not_ctlz_i16(i16 %a) nounwind {
; LA32-LABEL: test_not_ctlz_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    nor $a0, $a0, $zero
; LA32-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32-NEXT:    clz.w $a0, $a0
; LA32-NEXT:    addi.w $a0, $a0, -16
; LA32-NEXT:    ret
;
; LA64-LABEL: test_not_ctlz_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    nor $a0, $a0, $zero
; LA64-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-NEXT:    clz.d $a0, $a0
; LA64-NEXT:    addi.d $a0, $a0, -48
; LA64-NEXT:    ret
  %neg = xor i16 %a, -1
  %tmp = call i16 @llvm.ctlz.i16(i16 %neg, i1 false)
  ret i16 %tmp
}

define i32 @test_not_ctlz_i32(i32 %a) nounwind {
; LA32-LABEL: test_not_ctlz_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    clo.w $a0, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: test_not_ctlz_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    clo.w $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i32 %a, -1
  %tmp = call i32 @llvm.ctlz.i32(i32 %neg, i1 false)
  ret i32 %tmp
}

define i64 @test_not_ctlz_i64(i64 %a) nounwind {
; LA32-LABEL: test_not_ctlz_i64:
; LA32:       # %bb.0:
; LA32-NEXT:    nor $a2, $a1, $zero
; LA32-NEXT:    sltu $a2, $zero, $a2
; LA32-NEXT:    clo.w $a0, $a0
; LA32-NEXT:    addi.w $a0, $a0, 32
; LA32-NEXT:    masknez $a0, $a0, $a2
; LA32-NEXT:    clo.w $a1, $a1
; LA32-NEXT:    maskeqz $a1, $a1, $a2
; LA32-NEXT:    or $a0, $a1, $a0
; LA32-NEXT:    move $a1, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: test_not_ctlz_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    clo.d $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i64 %a, -1
  %tmp = call i64 @llvm.ctlz.i64(i64 %neg, i1 false)
  ret i64 %tmp
}

define i8 @test_ctpop_i8(i8 %a) nounwind {
; LA32-LABEL: test_ctpop_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    srli.w $a1, $a0, 1
; LA32-NEXT:    andi $a1, $a1, 85
; LA32-NEXT:    sub.w $a0, $a0, $a1
; LA32-NEXT:    andi $a1, $a0, 51
; LA32-NEXT:    srli.w $a0, $a0, 2
; LA32-NEXT:    andi $a0, $a0, 51
; LA32-NEXT:    add.w $a0, $a1, $a0
; LA32-NEXT:    srli.w $a1, $a0, 4
; LA32-NEXT:    add.w $a0, $a0, $a1
; LA32-NEXT:    andi $a0, $a0, 15
; LA32-NEXT:    ret
;
; LA64-LABEL: test_ctpop_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    srli.d $a1, $a0, 1
; LA64-NEXT:    andi $a1, $a1, 85
; LA64-NEXT:    sub.d $a0, $a0, $a1
; LA64-NEXT:    andi $a1, $a0, 51
; LA64-NEXT:    srli.d $a0, $a0, 2
; LA64-NEXT:    andi $a0, $a0, 51
; LA64-NEXT:    add.d $a0, $a1, $a0
; LA64-NEXT:    srli.d $a1, $a0, 4
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    andi $a0, $a0, 15
; LA64-NEXT:    ret
  %1 = call i8 @llvm.ctpop.i8(i8 %a)
  ret i8 %1
}

define i16 @test_ctpop_i16(i16 %a) nounwind {
; LA32-LABEL: test_ctpop_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    lu12i.w $a1, 5
; LA32-NEXT:    ori $a1, $a1, 1365
; LA32-NEXT:    srli.w $a2, $a0, 1
; LA32-NEXT:    and $a1, $a2, $a1
; LA32-NEXT:    sub.w $a0, $a0, $a1
; LA32-NEXT:    lu12i.w $a1, 3
; LA32-NEXT:    ori $a1, $a1, 819
; LA32-NEXT:    and $a2, $a0, $a1
; LA32-NEXT:    srli.w $a0, $a0, 2
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    add.w $a0, $a2, $a0
; LA32-NEXT:    srli.w $a1, $a0, 4
; LA32-NEXT:    add.w $a0, $a0, $a1
; LA32-NEXT:    bstrpick.w $a1, $a0, 11, 8
; LA32-NEXT:    andi $a0, $a0, 15
; LA32-NEXT:    add.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: test_ctpop_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    lu12i.w $a1, 5
; LA64-NEXT:    ori $a1, $a1, 1365
; LA64-NEXT:    srli.d $a2, $a0, 1
; LA64-NEXT:    and $a1, $a2, $a1
; LA64-NEXT:    sub.d $a0, $a0, $a1
; LA64-NEXT:    lu12i.w $a1, 3
; LA64-NEXT:    ori $a1, $a1, 819
; LA64-NEXT:    and $a2, $a0, $a1
; LA64-NEXT:    srli.d $a0, $a0, 2
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    add.d $a0, $a2, $a0
; LA64-NEXT:    srli.d $a1, $a0, 4
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    bstrpick.d $a1, $a0, 11, 8
; LA64-NEXT:    andi $a0, $a0, 15
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    ret
  %1 = call i16 @llvm.ctpop.i16(i16 %a)
  ret i16 %1
}

define i32 @test_ctpop_i32(i32 %a) nounwind {
; LA32-LABEL: test_ctpop_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    lu12i.w $a1, 349525
; LA32-NEXT:    ori $a1, $a1, 1365
; LA32-NEXT:    srli.w $a2, $a0, 1
; LA32-NEXT:    and $a1, $a2, $a1
; LA32-NEXT:    sub.w $a0, $a0, $a1
; LA32-NEXT:    lu12i.w $a1, 209715
; LA32-NEXT:    ori $a1, $a1, 819
; LA32-NEXT:    and $a2, $a0, $a1
; LA32-NEXT:    srli.w $a0, $a0, 2
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    add.w $a0, $a2, $a0
; LA32-NEXT:    srli.w $a1, $a0, 4
; LA32-NEXT:    add.w $a0, $a0, $a1
; LA32-NEXT:    lu12i.w $a1, 61680
; LA32-NEXT:    ori $a1, $a1, 3855
; LA32-NEXT:    and $a0, $a0, $a1
; LA32-NEXT:    lu12i.w $a1, 4112
; LA32-NEXT:    ori $a1, $a1, 257
; LA32-NEXT:    mul.w $a0, $a0, $a1
; LA32-NEXT:    srli.w $a0, $a0, 24
; LA32-NEXT:    ret
;
; LA64-LABEL: test_ctpop_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    lu12i.w $a1, 349525
; LA64-NEXT:    ori $a1, $a1, 1365
; LA64-NEXT:    srli.d $a2, $a0, 1
; LA64-NEXT:    and $a1, $a2, $a1
; LA64-NEXT:    sub.d $a0, $a0, $a1
; LA64-NEXT:    lu12i.w $a1, 209715
; LA64-NEXT:    ori $a1, $a1, 819
; LA64-NEXT:    and $a2, $a0, $a1
; LA64-NEXT:    srli.d $a0, $a0, 2
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    add.d $a0, $a2, $a0
; LA64-NEXT:    srli.d $a1, $a0, 4
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    lu12i.w $a1, 61680
; LA64-NEXT:    ori $a1, $a1, 3855
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    lu12i.w $a1, 4112
; LA64-NEXT:    ori $a1, $a1, 257
; LA64-NEXT:    mul.d $a0, $a0, $a1
; LA64-NEXT:    bstrpick.d $a0, $a0, 31, 24
; LA64-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  ret i32 %1
}

define i64 @test_ctpop_i64(i64 %a) nounwind {
; LA32-LABEL: test_ctpop_i64:
; LA32:       # %bb.0:
; LA32-NEXT:    lu12i.w $a2, 349525
; LA32-NEXT:    ori $a2, $a2, 1365
; LA32-NEXT:    srli.w $a3, $a0, 1
; LA32-NEXT:    and $a3, $a3, $a2
; LA32-NEXT:    sub.w $a0, $a0, $a3
; LA32-NEXT:    lu12i.w $a3, 209715
; LA32-NEXT:    ori $a3, $a3, 819
; LA32-NEXT:    and $a4, $a0, $a3
; LA32-NEXT:    srli.w $a0, $a0, 2
; LA32-NEXT:    and $a0, $a0, $a3
; LA32-NEXT:    add.w $a0, $a4, $a0
; LA32-NEXT:    srli.w $a4, $a1, 1
; LA32-NEXT:    and $a2, $a4, $a2
; LA32-NEXT:    sub.w $a1, $a1, $a2
; LA32-NEXT:    srli.w $a2, $a0, 4
; LA32-NEXT:    add.w $a0, $a0, $a2
; LA32-NEXT:    and $a2, $a1, $a3
; LA32-NEXT:    srli.w $a1, $a1, 2
; LA32-NEXT:    and $a1, $a1, $a3
; LA32-NEXT:    add.w $a1, $a2, $a1
; LA32-NEXT:    srli.w $a2, $a1, 4
; LA32-NEXT:    add.w $a1, $a1, $a2
; LA32-NEXT:    lu12i.w $a2, 61680
; LA32-NEXT:    ori $a2, $a2, 3855
; LA32-NEXT:    and $a1, $a1, $a2
; LA32-NEXT:    and $a0, $a0, $a2
; LA32-NEXT:    lu12i.w $a2, 4112
; LA32-NEXT:    ori $a2, $a2, 257
; LA32-NEXT:    mul.w $a0, $a0, $a2
; LA32-NEXT:    mul.w $a1, $a1, $a2
; LA32-NEXT:    srli.w $a1, $a1, 24
; LA32-NEXT:    srli.w $a0, $a0, 24
; LA32-NEXT:    add.w $a0, $a0, $a1
; LA32-NEXT:    move $a1, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: test_ctpop_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    lu12i.w $a1, 349525
; LA64-NEXT:    ori $a1, $a1, 1365
; LA64-NEXT:    lu32i.d $a1, 349525
; LA64-NEXT:    lu52i.d $a1, $a1, 1365
; LA64-NEXT:    srli.d $a2, $a0, 1
; LA64-NEXT:    and $a1, $a2, $a1
; LA64-NEXT:    sub.d $a0, $a0, $a1
; LA64-NEXT:    lu12i.w $a1, 209715
; LA64-NEXT:    ori $a1, $a1, 819
; LA64-NEXT:    lu32i.d $a1, 209715
; LA64-NEXT:    lu52i.d $a1, $a1, 819
; LA64-NEXT:    and $a2, $a0, $a1
; LA64-NEXT:    srli.d $a0, $a0, 2
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    add.d $a0, $a2, $a0
; LA64-NEXT:    srli.d $a1, $a0, 4
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    lu12i.w $a1, 61680
; LA64-NEXT:    ori $a1, $a1, 3855
; LA64-NEXT:    lu32i.d $a1, -61681
; LA64-NEXT:    lu52i.d $a1, $a1, 240
; LA64-NEXT:    and $a0, $a0, $a1
; LA64-NEXT:    lu12i.w $a1, 4112
; LA64-NEXT:    ori $a1, $a1, 257
; LA64-NEXT:    lu32i.d $a1, 65793
; LA64-NEXT:    lu52i.d $a1, $a1, 16
; LA64-NEXT:    mul.d $a0, $a0, $a1
; LA64-NEXT:    srli.d $a0, $a0, 56
; LA64-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  ret i64 %1
}

define i8 @test_cttz_i8(i8 %a) nounwind {
; LA32-LABEL: test_cttz_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    ori $a0, $a0, 256
; LA32-NEXT:    ctz.w $a0, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: test_cttz_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    ori $a0, $a0, 256
; LA64-NEXT:    ctz.d $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i8 @llvm.cttz.i8(i8 %a, i1 false)
  ret i8 %tmp
}

define i16 @test_cttz_i16(i16 %a) nounwind {
; LA32-LABEL: test_cttz_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    lu12i.w $a1, 16
; LA32-NEXT:    or $a0, $a0, $a1
; LA32-NEXT:    ctz.w $a0, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: test_cttz_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    lu12i.w $a1, 16
; LA64-NEXT:    or $a0, $a0, $a1
; LA64-NEXT:    ctz.d $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i16 @llvm.cttz.i16(i16 %a, i1 false)
  ret i16 %tmp
}

define i32 @test_cttz_i32(i32 %a) nounwind {
; LA32-LABEL: test_cttz_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    ctz.w $a0, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: test_cttz_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    ctz.w $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i32 @llvm.cttz.i32(i32 %a, i1 false)
  ret i32 %tmp
}

define i64 @test_cttz_i64(i64 %a) nounwind {
; LA32-LABEL: test_cttz_i64:
; LA32:       # %bb.0:
; LA32-NEXT:    sltu $a2, $zero, $a0
; LA32-NEXT:    ctz.w $a0, $a0
; LA32-NEXT:    maskeqz $a0, $a0, $a2
; LA32-NEXT:    ctz.w $a1, $a1
; LA32-NEXT:    addi.w $a1, $a1, 32
; LA32-NEXT:    masknez $a1, $a1, $a2
; LA32-NEXT:    or $a0, $a0, $a1
; LA32-NEXT:    move $a1, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: test_cttz_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    ctz.d $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i64 @llvm.cttz.i64(i64 %a, i1 false)
  ret i64 %tmp
}

define i8 @test_not_cttz_i8(i8 %a) nounwind {
; LA32-LABEL: test_not_cttz_i8:
; LA32:       # %bb.0:
; LA32-NEXT:    ori $a1, $zero, 256
; LA32-NEXT:    orn $a0, $a1, $a0
; LA32-NEXT:    ctz.w $a0, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: test_not_cttz_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    ori $a1, $zero, 256
; LA64-NEXT:    orn $a0, $a1, $a0
; LA64-NEXT:    ctz.d $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i8 %a, -1
  %tmp = call i8 @llvm.cttz.i8(i8 %neg, i1 false)
  ret i8 %tmp
}

define i16 @test_not_cttz_i16(i16 %a) nounwind {
; LA32-LABEL: test_not_cttz_i16:
; LA32:       # %bb.0:
; LA32-NEXT:    lu12i.w $a1, 16
; LA32-NEXT:    orn $a0, $a1, $a0
; LA32-NEXT:    ctz.w $a0, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: test_not_cttz_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    lu12i.w $a1, 16
; LA64-NEXT:    orn $a0, $a1, $a0
; LA64-NEXT:    ctz.d $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i16 %a, -1
  %tmp = call i16 @llvm.cttz.i16(i16 %neg, i1 false)
  ret i16 %tmp
}

define i32 @test_not_cttz_i32(i32 %a) nounwind {
; LA32-LABEL: test_not_cttz_i32:
; LA32:       # %bb.0:
; LA32-NEXT:    cto.w $a0, $a0
; LA32-NEXT:    ret
;
; LA64-LABEL: test_not_cttz_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    cto.w $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i32 %a, -1
  %tmp = call i32 @llvm.cttz.i32(i32 %neg, i1 false)
  ret i32 %tmp
}

define i64 @test_not_cttz_i64(i64 %a) nounwind {
; LA32-LABEL: test_not_cttz_i64:
; LA32:       # %bb.0:
; LA32-NEXT:    nor $a2, $a0, $zero
; LA32-NEXT:    sltu $a2, $zero, $a2
; LA32-NEXT:    cto.w $a1, $a1
; LA32-NEXT:    addi.w $a1, $a1, 32
; LA32-NEXT:    masknez $a1, $a1, $a2
; LA32-NEXT:    cto.w $a0, $a0
; LA32-NEXT:    maskeqz $a0, $a0, $a2
; LA32-NEXT:    or $a0, $a0, $a1
; LA32-NEXT:    move $a1, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: test_not_cttz_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    cto.d $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i64 %a, -1
  %tmp = call i64 @llvm.cttz.i64(i64 %neg, i1 false)
  ret i64 %tmp
}
