; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs --show-mc-encoding | FileCheck %s

define i8 @shl8ri(i8 noundef %a) {
; CHECK-LABEL: shl8ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlb $4, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xc0,0xe7,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i8 %a, 4
  ret i8 %shl
}

define i16 @shl16ri(i16 noundef %a) {
; CHECK-LABEL: shl16ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shll $4, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xc1,0xe7,0x04]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i16 %a, 4
  ret i16 %shl
}

define i32 @shl32ri(i32 noundef %a) {
; CHECK-LABEL: shl32ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shll $4, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xc1,0xe7,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i32 %a, 4
  ret i32 %shl
}

define i64 @shl64ri(i64 noundef %a) {
; CHECK-LABEL: shl64ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlq $4, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xc1,0xe7,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i64 %a, 4
  ret i64 %shl
}

define i8 @shl8m1(ptr %ptr) {
; CHECK-LABEL: shl8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzbl (%rdi), %eax # encoding: [0x0f,0xb6,0x07]
; CHECK-NEXT:    addb %al, %al # EVEX TO LEGACY Compression encoding: [0x00,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shl = shl i8 %a, 1
  ret i8 %shl
}

define i16 @shl16m1(ptr %ptr) {
; CHECK-LABEL: shl16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzwl (%rdi), %eax # encoding: [0x0f,0xb7,0x07]
; CHECK-NEXT:    addl %eax, %eax # EVEX TO LEGACY Compression encoding: [0x01,0xc0]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shl = shl i16 %a, 1
  ret i16 %shl
}

define i32 @shl32m1(ptr %ptr) {
; CHECK-LABEL: shl32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl (%rdi), %eax # encoding: [0x8b,0x07]
; CHECK-NEXT:    addl %eax, %eax # EVEX TO LEGACY Compression encoding: [0x01,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shl = shl i32 %a, 1
  ret i32 %shl
}

define i64 @shl64m1(ptr %ptr) {
; CHECK-LABEL: shl64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq (%rdi), %rax # encoding: [0x48,0x8b,0x07]
; CHECK-NEXT:    addq %rax, %rax # EVEX TO LEGACY Compression encoding: [0x48,0x01,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shl = shl i64 %a, 1
  ret i64 %shl
}

define i8 @shl8mcl(ptr %ptr, i8 %cl) {
; CHECK-LABEL: shl8mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shlb %cl, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shl = shl i8 %a, %cl
  ret i8 %shl
}

define i8 @shl8mcl_mask(ptr %ptr, i8 %cl) {
; CHECK-LABEL: shl8mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shlb %cl, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shamt = and i8 %cl, 31
  %shl = shl i8 %a, %shamt
  ret i8 %shl
}

define i16 @shl16mcl(ptr %ptr, i16 %cl) {
; CHECK-LABEL: shl16mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    movzwl (%rdi), %eax # encoding: [0x0f,0xb7,0x07]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shll %cl, %eax # EVEX TO LEGACY Compression encoding: [0xd3,0xe0]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shl = shl i16 %a, %cl
  ret i16 %shl
}

define i16 @shl16mcl_mask(ptr %ptr, i16 %cl) {
; CHECK-LABEL: shl16mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    movzwl (%rdi), %eax # encoding: [0x0f,0xb7,0x07]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shll %cl, %eax # EVEX TO LEGACY Compression encoding: [0xd3,0xe0]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shamt = and i16 %cl, 31
  %shl = shl i16 %a, %shamt
  ret i16 %shl
}

define i32 @shl32mcl(ptr %ptr, i32 %cl) {
; CHECK-LABEL: shl32mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shll %cl, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shl = shl i32 %a, %cl
  ret i32 %shl
}

define i32 @shl32mcl_mask(ptr %ptr, i32 %cl) {
; CHECK-LABEL: shl32mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shll %cl, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shamt = and i32 %cl, 31
  %shl = shl i32 %a, %shamt
  ret i32 %shl
}

define i64 @shl64mcl(ptr %ptr, i64 %cl) {
; CHECK-LABEL: shl64mcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    shlq %cl, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shl = shl i64 %a, %cl
  ret i64 %shl
}

define i64 @shl64mcl_mask(ptr %ptr, i64 %cl) {
; CHECK-LABEL: shl64mcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    shlq %cl, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shamt = and i64 %cl, 63
  %shl = shl i64 %a, %shamt
  ret i64 %shl
}

define i8 @shl8mi(ptr %ptr) {
; CHECK-LABEL: shl8mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlb $4, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0xc0,0x27,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shl = shl i8 %a, 4
  ret i8 %shl
}

define i16 @shl16mi(ptr %ptr) {
; CHECK-LABEL: shl16mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzwl (%rdi), %eax # encoding: [0x0f,0xb7,0x07]
; CHECK-NEXT:    shll $4, %eax # EVEX TO LEGACY Compression encoding: [0xc1,0xe0,0x04]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shl = shl i16 %a, 4
  ret i16 %shl
}

define i32 @shl32mi(ptr %ptr) {
; CHECK-LABEL: shl32mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shll $4, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0xc1,0x27,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shl = shl i32 %a, 4
  ret i32 %shl
}

define i64 @shl64mi(ptr %ptr) {
; CHECK-LABEL: shl64mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlq $4, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0xc1,0x27,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shl = shl i64 %a, 4
  ret i64 %shl
}

define i8 @shl8r1(i8 noundef %a) {
; CHECK-LABEL: shl8r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb %dil, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x00,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i8 %a, 1
  ret i8 %shl
}

define i16 @shl16r1(i16 noundef %a) {
; CHECK-LABEL: shl16r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl %edi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x01,0xff]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i16 %a, 1
  ret i16 %shl
}

define i32 @shl32r1(i32 noundef %a) {
; CHECK-LABEL: shl32r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl %edi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x01,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i32 %a, 1
  ret i32 %shl
}

define i64 @shl64r1(i64 noundef %a) {
; CHECK-LABEL: shl64r1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq %rdi, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x01,0xff]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i64 %a, 1
  ret i64 %shl
}

define i8 @shl8rcl(i8 noundef %a, i8 %cl) {
; CHECK-LABEL: shl8rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shlb %cl, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0xe7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i8 %a, %cl
  ret i8 %shl
}

define i8 @shl8rcl_mask(i8 noundef %a, i8 %cl) {
; CHECK-LABEL: shl8rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shlb %cl, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xd2,0xe7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i8 %cl, 31
  %shl = shl i8 %a, %shamt
  ret i8 %shl
}

define i16 @shl16rcl(i16 noundef %a, i16 %cl) {
; CHECK-LABEL: shl16rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shll %cl, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0xe7]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i16 %a, %cl
  ret i16 %shl
}

define i16 @shl16rcl_mask(i16 noundef %a, i16 %cl) {
; CHECK-LABEL: shl16rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shll %cl, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0xe7]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i16 %cl, 31
  %shl = shl i16 %a, %shamt
  ret i16 %shl
}

define i32 @shl32rcl(i32 noundef %a, i32 %cl) {
; CHECK-LABEL: shl32rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shll %cl, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0xe7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i32 %a, %cl
  ret i32 %shl
}

define i32 @shl32rcl_mask(i32 noundef %a, i32 %cl) {
; CHECK-LABEL: shl32rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shll %cl, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0xd3,0xe7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i32 %cl, 31
  %shl = shl i32 %a, %shamt
  ret i32 %shl
}

define i64 @shl64rcl(i64 noundef %a, i64 %cl) {
; CHECK-LABEL: shl64rcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    shlq %cl, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0xe7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shl = shl i64 %a, %cl
  ret i64 %shl
}

define i64 @shl64rcl_mask(i64 noundef %a, i64 %cl) {
; CHECK-LABEL: shl64rcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    shlq %cl, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0xd3,0xe7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %shamt = and i64 %cl, 63
  %shl = shl i64 %a, %shamt
  ret i64 %shl
}

define void @shl8m1_legacy(ptr %ptr) {
; CHECK-LABEL: shl8m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlb (%rdi) # encoding: [0xd0,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shl = shl i8 %a, 1
  store i8 %shl, ptr %ptr
  ret void
}

define void @shl16m1_legacy(ptr %ptr) {
; CHECK-LABEL: shl16m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlw (%rdi) # encoding: [0x66,0xd1,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shl = shl i16 %a, 1
  store i16 %shl, ptr %ptr
  ret void
}

define void @shl32m1_legacy(ptr %ptr) {
; CHECK-LABEL: shl32m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shll (%rdi) # encoding: [0xd1,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shl = shl i32 %a, 1
  store i32 %shl, ptr %ptr
  ret void
}

define void @shl64m1_legacy(ptr %ptr) {
; CHECK-LABEL: shl64m1_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlq (%rdi) # encoding: [0x48,0xd1,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shl = shl i64 %a, 1
  store i64 %shl, ptr %ptr
  ret void
}

define void @shl8mi_legacy(ptr %ptr) {
; CHECK-LABEL: shl8mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlb $4, (%rdi) # encoding: [0xc0,0x27,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shl = shl i8 %a, 4
  store i8 %shl, ptr %ptr
  ret void
}

define void @shl16mi_legacy(ptr %ptr) {
; CHECK-LABEL: shl16mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlw $4, (%rdi) # encoding: [0x66,0xc1,0x27,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shl = shl i16 %a, 4
  store i16 %shl, ptr %ptr
  ret void
}

define void @shl32mi_legacy(ptr %ptr) {
; CHECK-LABEL: shl32mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shll $4, (%rdi) # encoding: [0xc1,0x27,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shl = shl i32 %a, 4
  store i32 %shl, ptr %ptr
  ret void
}

define void @shl64mi_legacy(ptr %ptr) {
; CHECK-LABEL: shl64mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shlq $4, (%rdi) # encoding: [0x48,0xc1,0x27,0x04]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shl = shl i64 %a, 4
  store i64 %shl, ptr %ptr
  ret void
}

define void @shl8mcl_legacy(ptr %ptr, i8 %cl) {
; CHECK-LABEL: shl8mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shlb %cl, (%rdi) # encoding: [0xd2,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i8, ptr %ptr
  %shl = shl i8 %a, %cl
  store i8 %shl, ptr %ptr
  ret void
}

define void @shl16mcl_legacy(ptr %ptr, i16 %cl) {
; CHECK-LABEL: shl16mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shlw %cl, (%rdi) # encoding: [0x66,0xd3,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i16, ptr %ptr
  %shl = shl i16 %a, %cl
  store i16 %shl, ptr %ptr
  ret void
}

define void @shl32mcl_legacy(ptr %ptr, i32 %cl) {
; CHECK-LABEL: shl32mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %esi, %ecx # encoding: [0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shll %cl, (%rdi) # encoding: [0xd3,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i32, ptr %ptr
  %shl = shl i32 %a, %cl
  store i32 %shl, ptr %ptr
  ret void
}

define void @shl64mcl_legacy(ptr %ptr, i64 %cl) {
; CHECK-LABEL: shl64mcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq %rsi, %rcx # encoding: [0x48,0x89,0xf1]
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    shlq %cl, (%rdi) # encoding: [0x48,0xd3,0x27]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %a = load i64, ptr %ptr
  %shl = shl i64 %a, %cl
  store i64 %shl, ptr %ptr
  ret void
}
