// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefix=GFX11 %s
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefix=GFX11 %s

//===----------------------------------------------------------------------===//
// FLAT.
//===----------------------------------------------------------------------===//

flat_atomic_add v[1:2], v2
// GFX11: [0x00,0x00,0xd4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_add v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xd4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_add v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xd4,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_add v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xd4,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_add_f32 v[1:2], v2
// GFX11: [0x00,0x00,0x58,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_add_f32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x58,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_add_f32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0x58,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_add_f32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x58,0xdd,0xfe,0xff,0x7c,0xff]

flat_atomic_add_u32 v[1:2], v2
// GFX11: [0x00,0x00,0xd4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_add_u32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xd4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_add_u32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xd4,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_add_u32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xd4,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_add_u64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x0c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_add_u64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x0c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_add_u64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x0c,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_add_u64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x0c,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_add_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x0c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_add_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x0c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_add_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x0c,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_add_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x0c,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_and v[1:2], v2
// GFX11: [0x00,0x00,0xf0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_and v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xf0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_and v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xf0,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_and v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xf0,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_and_b32 v[1:2], v2
// GFX11: [0x00,0x00,0xf0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_and_b32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xf0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_and_b32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xf0,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_and_b32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xf0,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_and_b64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x24,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_and_b64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x24,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_and_b64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x24,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_and_b64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x24,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_and_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x24,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_and_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x24,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_and_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x24,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_and_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x24,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_cmpswap v[1:2], v[2:3]
// GFX11: [0x00,0x00,0xd0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_cmpswap v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0xd0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_cmpswap v5, v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0xd0,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_cmpswap v255, v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xd0,0xdc,0xfe,0xfe,0x7c,0xff]

flat_atomic_cmpswap_b32 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0xd0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_cmpswap_b32 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0xd0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_cmpswap_b32 v5, v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0xd0,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_cmpswap_b32 v255, v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xd0,0xdc,0xfe,0xfe,0x7c,0xff]

flat_atomic_cmpswap_b64 v[1:2], v[2:5]
// GFX11: [0x00,0x00,0x08,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_cmpswap_b64 v[1:2], v[2:5] offset:4095
// GFX11: [0xff,0x0f,0x08,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_cmpswap_b64 v[5:6], v[1:2], v[2:5] offset:0 glc
// GFX11: [0x00,0x40,0x08,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_cmpswap_b64 v[254:255], v[254:255], v[252:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x08,0xdd,0xfe,0xfc,0x7c,0xfe]

flat_atomic_cmpswap_f32 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x40,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_cmpswap_f32 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x40,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_cmpswap_f32 v5, v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x40,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_cmpswap_f32 v255, v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x40,0xdd,0xfe,0xfe,0x7c,0xff]

flat_atomic_cmpswap_x2 v[1:2], v[2:5]
// GFX11: [0x00,0x00,0x08,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5] offset:4095
// GFX11: [0xff,0x0f,0x08,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_cmpswap_x2 v[5:6], v[1:2], v[2:5] offset:0 glc
// GFX11: [0x00,0x40,0x08,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_cmpswap_x2 v[254:255], v[254:255], v[252:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x08,0xdd,0xfe,0xfc,0x7c,0xfe]

flat_atomic_dec v[1:2], v2
// GFX11: [0x00,0x00,0x00,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_dec v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x00,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_dec v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0x00,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_dec v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x00,0xdd,0xfe,0xff,0x7c,0xff]

flat_atomic_dec_u32 v[1:2], v2
// GFX11: [0x00,0x00,0x00,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_dec_u32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x00,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_dec_u32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0x00,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_dec_u32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x00,0xdd,0xfe,0xff,0x7c,0xff]

flat_atomic_dec_u64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x34,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_dec_u64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x34,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_dec_u64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x34,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_dec_u64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x34,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_dec_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x34,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x34,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_dec_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x34,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_dec_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x34,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_inc v[1:2], v2
// GFX11: [0x00,0x00,0xfc,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_inc v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xfc,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_inc v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xfc,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_inc v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xfc,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_inc_u32 v[1:2], v2
// GFX11: [0x00,0x00,0xfc,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_inc_u32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xfc,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_inc_u32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xfc,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_inc_u32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xfc,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_inc_u64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x30,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_inc_u64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x30,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_inc_u64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x30,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_inc_u64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x30,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_inc_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x30,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x30,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_inc_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x30,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_inc_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x30,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_max_f32 v[1:2], v2
// GFX11: [0x00,0x00,0x48,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_max_f32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x48,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_max_f32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0x48,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_max_f32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x48,0xdd,0xfe,0xff,0x7c,0xff]

flat_atomic_max_i32 v[1:2], v2
// GFX11: [0x00,0x00,0xe8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_max_i32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xe8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_max_i32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xe8,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_max_i32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xe8,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_max_i64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x1c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_max_i64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x1c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_max_i64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x1c,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_max_i64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x1c,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_max_u32 v[1:2], v2
// GFX11: [0x00,0x00,0xec,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_max_u32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xec,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_max_u32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xec,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_max_u32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xec,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_max_u64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x20,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_max_u64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x20,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_max_u64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x20,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_max_u64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x20,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_min_f32 v[1:2], v2
// GFX11: [0x00,0x00,0x44,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_min_f32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x44,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_min_f32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0x44,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_min_f32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x44,0xdd,0xfe,0xff,0x7c,0xff]

flat_atomic_min_i32 v[1:2], v2
// GFX11: [0x00,0x00,0xe0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_min_i32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xe0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_min_i32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xe0,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_min_i32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xe0,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_min_i64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x14,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_min_i64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x14,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_min_i64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x14,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_min_i64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x14,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_min_u32 v[1:2], v2
// GFX11: [0x00,0x00,0xe4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_min_u32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xe4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_min_u32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xe4,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_min_u32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xe4,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_min_u64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x18,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_min_u64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x18,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_min_u64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x18,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_min_u64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x18,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_or v[1:2], v2
// GFX11: [0x00,0x00,0xf4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_or v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xf4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_or v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xf4,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_or v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xf4,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_or_b32 v[1:2], v2
// GFX11: [0x00,0x00,0xf4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_or_b32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xf4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_or_b32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xf4,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_or_b32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xf4,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_or_b64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x28,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_or_b64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x28,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_or_b64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x28,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_or_b64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x28,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_or_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x28,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_or_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x28,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_or_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x28,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_or_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x28,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_smax v[1:2], v2
// GFX11: [0x00,0x00,0xe8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_smax v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xe8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_smax v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xe8,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_smax v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xe8,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_smax_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x1c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x1c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_smax_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x1c,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_smax_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x1c,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_smin v[1:2], v2
// GFX11: [0x00,0x00,0xe0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_smin v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xe0,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_smin v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xe0,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_smin v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xe0,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_smin_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x14,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x14,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_smin_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x14,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_smin_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x14,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_sub v[1:2], v2
// GFX11: [0x00,0x00,0xd8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_sub v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xd8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_sub v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xd8,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_sub v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xd8,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_sub_u32 v[1:2], v2
// GFX11: [0x00,0x00,0xd8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_sub_u32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xd8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_sub_u32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xd8,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_sub_u32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xd8,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_sub_u64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x10,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_sub_u64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x10,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_sub_u64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x10,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_sub_u64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x10,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_sub_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x10,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x10,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_sub_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x10,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_sub_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x10,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_swap v[1:2], v2
// GFX11: [0x00,0x00,0xcc,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_swap v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xcc,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_swap v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xcc,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_swap v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xcc,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_swap_b32 v[1:2], v2
// GFX11: [0x00,0x00,0xcc,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_swap_b32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xcc,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_swap_b32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xcc,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_swap_b32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xcc,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_swap_b64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x04,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_swap_b64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x04,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_swap_b64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x04,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_swap_b64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x04,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_swap_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x04,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x04,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_swap_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x04,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_swap_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x04,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_umax v[1:2], v2
// GFX11: [0x00,0x00,0xec,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_umax v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xec,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_umax v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xec,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_umax v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xec,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_umax_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x20,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x20,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_umax_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x20,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_umax_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x20,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_umin v[1:2], v2
// GFX11: [0x00,0x00,0xe4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_umin v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xe4,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_umin v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xe4,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_umin v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xe4,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_umin_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x18,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x18,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_umin_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x18,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_umin_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x18,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_xor v[1:2], v2
// GFX11: [0x00,0x00,0xf8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_xor v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xf8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_xor v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xf8,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_xor v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xf8,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_xor_b32 v[1:2], v2
// GFX11: [0x00,0x00,0xf8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_xor_b32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0xf8,0xdc,0x01,0x02,0x7c,0x00]

flat_atomic_xor_b32 v5, v[1:2], v2 offset:0 glc
// GFX11: [0x00,0x40,0xf8,0xdc,0x01,0x02,0x7c,0x05]

flat_atomic_xor_b32 v255, v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0xf8,0xdc,0xfe,0xff,0x7c,0xff]

flat_atomic_xor_b64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x2c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_xor_b64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x2c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_xor_b64 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x2c,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_xor_b64 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x2c,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_atomic_xor_x2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x2c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x2c,0xdd,0x01,0x02,0x7c,0x00]

flat_atomic_xor_x2 v[5:6], v[1:2], v[2:3] offset:0 glc
// GFX11: [0x00,0x40,0x2c,0xdd,0x01,0x02,0x7c,0x05]

flat_atomic_xor_x2 v[254:255], v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x2c,0xdd,0xfe,0xfe,0x7c,0xfe]

flat_load_b128 v[5:8], v[1:2]
// GFX11: [0x00,0x00,0x5c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b128 v[5:8], v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x5c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b128 v[5:8], v[1:2] offset:0
// GFX11: [0x00,0x00,0x5c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b128 v[252:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x5c,0xdc,0xfe,0x00,0x7c,0xfc]

flat_load_b32 v5, v[1:2]
// GFX11: [0x00,0x00,0x50,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b32 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x50,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b32 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x50,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b32 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x50,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_b64 v[5:6], v[1:2]
// GFX11: [0x00,0x00,0x54,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b64 v[5:6], v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x54,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b64 v[5:6], v[1:2] offset:0
// GFX11: [0x00,0x00,0x54,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b64 v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x54,0xdc,0xfe,0x00,0x7c,0xfe]

flat_load_b96 v[5:7], v[1:2]
// GFX11: [0x00,0x00,0x58,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b96 v[5:7], v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x58,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b96 v[5:7], v[1:2] offset:0
// GFX11: [0x00,0x00,0x58,0xdc,0x01,0x00,0x7c,0x05]

flat_load_b96 v[253:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x58,0xdc,0xfe,0x00,0x7c,0xfd]

flat_load_d16_b16 v5, v[1:2]
// GFX11: [0x00,0x00,0x80,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_b16 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x80,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_b16 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x80,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_b16 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x80,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_d16_hi_b16 v5, v[1:2]
// GFX11: [0x00,0x00,0x8c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_hi_b16 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x8c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_hi_b16 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x8c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_hi_b16 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x8c,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_d16_hi_i8 v5, v[1:2]
// GFX11: [0x00,0x00,0x88,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_hi_i8 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x88,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_hi_i8 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x88,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_hi_i8 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x88,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_d16_hi_u8 v5, v[1:2]
// GFX11: [0x00,0x00,0x84,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_hi_u8 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x84,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_hi_u8 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x84,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_hi_u8 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x84,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_d16_i8 v5, v[1:2]
// GFX11: [0x00,0x00,0x7c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_i8 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x7c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_i8 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x7c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_i8 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x7c,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_d16_u8 v5, v[1:2]
// GFX11: [0x00,0x00,0x78,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_u8 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x78,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_u8 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x78,0xdc,0x01,0x00,0x7c,0x05]

flat_load_d16_u8 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x78,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_dword v5, v[1:2]
// GFX11: [0x00,0x00,0x50,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dword v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x50,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dword v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x50,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dword v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x50,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_dwordx2 v[5:6], v[1:2]
// GFX11: [0x00,0x00,0x54,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dwordx2 v[5:6], v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x54,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dwordx2 v[5:6], v[1:2] offset:0
// GFX11: [0x00,0x00,0x54,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dwordx2 v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x54,0xdc,0xfe,0x00,0x7c,0xfe]

flat_load_dwordx3 v[5:7], v[1:2]
// GFX11: [0x00,0x00,0x58,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dwordx3 v[5:7], v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x58,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dwordx3 v[5:7], v[1:2] offset:0
// GFX11: [0x00,0x00,0x58,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dwordx3 v[253:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x58,0xdc,0xfe,0x00,0x7c,0xfd]

flat_load_dwordx4 v[5:8], v[1:2]
// GFX11: [0x00,0x00,0x5c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dwordx4 v[5:8], v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x5c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dwordx4 v[5:8], v[1:2] offset:0
// GFX11: [0x00,0x00,0x5c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_dwordx4 v[252:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x5c,0xdc,0xfe,0x00,0x7c,0xfc]

flat_load_i16 v5, v[1:2]
// GFX11: [0x00,0x00,0x4c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_i16 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x4c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_i16 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x4c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_i16 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x4c,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_i8 v5, v[1:2]
// GFX11: [0x00,0x00,0x44,0xdc,0x01,0x00,0x7c,0x05]

flat_load_i8 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x44,0xdc,0x01,0x00,0x7c,0x05]

flat_load_i8 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x44,0xdc,0x01,0x00,0x7c,0x05]

flat_load_i8 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x44,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_sbyte v5, v[1:2]
// GFX11: [0x00,0x00,0x44,0xdc,0x01,0x00,0x7c,0x05]

flat_load_sbyte v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x44,0xdc,0x01,0x00,0x7c,0x05]

flat_load_sbyte v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x44,0xdc,0x01,0x00,0x7c,0x05]

flat_load_sbyte v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x44,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_sshort v5, v[1:2]
// GFX11: [0x00,0x00,0x4c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_sshort v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x4c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_sshort v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x4c,0xdc,0x01,0x00,0x7c,0x05]

flat_load_sshort v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x4c,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_u16 v5, v[1:2]
// GFX11: [0x00,0x00,0x48,0xdc,0x01,0x00,0x7c,0x05]

flat_load_u16 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x48,0xdc,0x01,0x00,0x7c,0x05]

flat_load_u16 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x48,0xdc,0x01,0x00,0x7c,0x05]

flat_load_u16 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x48,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_u8 v5, v[1:2]
// GFX11: [0x00,0x00,0x40,0xdc,0x01,0x00,0x7c,0x05]

flat_load_u8 v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x40,0xdc,0x01,0x00,0x7c,0x05]

flat_load_u8 v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x40,0xdc,0x01,0x00,0x7c,0x05]

flat_load_u8 v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x40,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_ubyte v5, v[1:2]
// GFX11: [0x00,0x00,0x40,0xdc,0x01,0x00,0x7c,0x05]

flat_load_ubyte v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x40,0xdc,0x01,0x00,0x7c,0x05]

flat_load_ubyte v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x40,0xdc,0x01,0x00,0x7c,0x05]

flat_load_ubyte v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x40,0xdc,0xfe,0x00,0x7c,0xff]

flat_load_ushort v5, v[1:2]
// GFX11: [0x00,0x00,0x48,0xdc,0x01,0x00,0x7c,0x05]

flat_load_ushort v5, v[1:2] offset:4095
// GFX11: [0xff,0x0f,0x48,0xdc,0x01,0x00,0x7c,0x05]

flat_load_ushort v5, v[1:2] offset:0
// GFX11: [0x00,0x00,0x48,0xdc,0x01,0x00,0x7c,0x05]

flat_load_ushort v255, v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x48,0xdc,0xfe,0x00,0x7c,0xff]

flat_store_b128 v[1:2], v[2:5]
// GFX11: [0x00,0x00,0x74,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b128 v[1:2], v[2:5] offset:4095
// GFX11: [0xff,0x0f,0x74,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b128 v[1:2], v[2:5] offset:0
// GFX11: [0x00,0x00,0x74,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b128 v[254:255], v[252:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x74,0xdc,0xfe,0xfc,0x7c,0x00]

flat_store_b16 v[1:2], v2
// GFX11: [0x00,0x00,0x64,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b16 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x64,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b16 v[1:2], v2 offset:0
// GFX11: [0x00,0x00,0x64,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b16 v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x64,0xdc,0xfe,0xff,0x7c,0x00]

flat_store_b32 v[1:2], v2
// GFX11: [0x00,0x00,0x68,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b32 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x68,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b32 v[1:2], v2 offset:0
// GFX11: [0x00,0x00,0x68,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b32 v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x68,0xdc,0xfe,0xff,0x7c,0x00]

flat_store_b64 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x6c,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b64 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x6c,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b64 v[1:2], v[2:3] offset:0
// GFX11: [0x00,0x00,0x6c,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b64 v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x6c,0xdc,0xfe,0xfe,0x7c,0x00]

flat_store_b8 v[1:2], v2
// GFX11: [0x00,0x00,0x60,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b8 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x60,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b8 v[1:2], v2 offset:0
// GFX11: [0x00,0x00,0x60,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b8 v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x60,0xdc,0xfe,0xff,0x7c,0x00]

flat_store_b96 v[1:2], v[2:4]
// GFX11: [0x00,0x00,0x70,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b96 v[1:2], v[2:4] offset:4095
// GFX11: [0xff,0x0f,0x70,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b96 v[1:2], v[2:4] offset:0
// GFX11: [0x00,0x00,0x70,0xdc,0x01,0x02,0x7c,0x00]

flat_store_b96 v[254:255], v[253:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x70,0xdc,0xfe,0xfd,0x7c,0x00]

flat_store_byte v[1:2], v2
// GFX11: [0x00,0x00,0x60,0xdc,0x01,0x02,0x7c,0x00]

flat_store_byte v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x60,0xdc,0x01,0x02,0x7c,0x00]

flat_store_byte v[1:2], v2 offset:0
// GFX11: [0x00,0x00,0x60,0xdc,0x01,0x02,0x7c,0x00]

flat_store_byte v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x60,0xdc,0xfe,0xff,0x7c,0x00]

flat_store_d16_hi_b16 v[1:2], v2
// GFX11: [0x00,0x00,0x94,0xdc,0x01,0x02,0x7c,0x00]

flat_store_d16_hi_b16 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x94,0xdc,0x01,0x02,0x7c,0x00]

flat_store_d16_hi_b16 v[1:2], v2 offset:0
// GFX11: [0x00,0x00,0x94,0xdc,0x01,0x02,0x7c,0x00]

flat_store_d16_hi_b16 v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x94,0xdc,0xfe,0xff,0x7c,0x00]

flat_store_d16_hi_b8 v[1:2], v2
// GFX11: [0x00,0x00,0x90,0xdc,0x01,0x02,0x7c,0x00]

flat_store_d16_hi_b8 v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x90,0xdc,0x01,0x02,0x7c,0x00]

flat_store_d16_hi_b8 v[1:2], v2 offset:0
// GFX11: [0x00,0x00,0x90,0xdc,0x01,0x02,0x7c,0x00]

flat_store_d16_hi_b8 v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x90,0xdc,0xfe,0xff,0x7c,0x00]

flat_store_dword v[1:2], v2
// GFX11: [0x00,0x00,0x68,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dword v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x68,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dword v[1:2], v2 offset:0
// GFX11: [0x00,0x00,0x68,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dword v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x68,0xdc,0xfe,0xff,0x7c,0x00]

flat_store_dwordx2 v[1:2], v[2:3]
// GFX11: [0x00,0x00,0x6c,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dwordx2 v[1:2], v[2:3] offset:4095
// GFX11: [0xff,0x0f,0x6c,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dwordx2 v[1:2], v[2:3] offset:0
// GFX11: [0x00,0x00,0x6c,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dwordx2 v[254:255], v[254:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x6c,0xdc,0xfe,0xfe,0x7c,0x00]

flat_store_dwordx3 v[1:2], v[2:4]
// GFX11: [0x00,0x00,0x70,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dwordx3 v[1:2], v[2:4] offset:4095
// GFX11: [0xff,0x0f,0x70,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dwordx3 v[1:2], v[2:4] offset:0
// GFX11: [0x00,0x00,0x70,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dwordx3 v[254:255], v[253:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x70,0xdc,0xfe,0xfd,0x7c,0x00]

flat_store_dwordx4 v[1:2], v[2:5]
// GFX11: [0x00,0x00,0x74,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dwordx4 v[1:2], v[2:5] offset:4095
// GFX11: [0xff,0x0f,0x74,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dwordx4 v[1:2], v[2:5] offset:0
// GFX11: [0x00,0x00,0x74,0xdc,0x01,0x02,0x7c,0x00]

flat_store_dwordx4 v[254:255], v[252:255] offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x74,0xdc,0xfe,0xfc,0x7c,0x00]

flat_store_short v[1:2], v2
// GFX11: [0x00,0x00,0x64,0xdc,0x01,0x02,0x7c,0x00]

flat_store_short v[1:2], v2 offset:4095
// GFX11: [0xff,0x0f,0x64,0xdc,0x01,0x02,0x7c,0x00]

flat_store_short v[1:2], v2 offset:0
// GFX11: [0x00,0x00,0x64,0xdc,0x01,0x02,0x7c,0x00]

flat_store_short v[254:255], v255 offset:7 glc slc dlc
// GFX11: [0x07,0xe0,0x64,0xdc,0xfe,0xff,0x7c,0x00]

//===----------------------------------------------------------------------===//
// GLOBAL.
//===----------------------------------------------------------------------===//

global_atomic_add v[1:2], v2, off
// GFX11: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_add v[254:255], v2, off
// GFX11: [0x00,0x00,0xd6,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_add v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x06,0x00]

global_atomic_add v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x68,0x00]

global_atomic_add v1, v2, vcc
// GFX11: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_add v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_add v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xd6,0xdc,0xff,0x02,0x06,0x00]

global_atomic_add v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xd6,0xdc,0xff,0x02,0x68,0x00]

global_atomic_add v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xd6,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_add v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xd6,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_add_f32 v[1:2], v2, off
// GFX11: [0x00,0x00,0x5a,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_add_f32 v[254:255], v2, off
// GFX11: [0x00,0x00,0x5a,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_add_f32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x5a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add_f32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x5a,0xdd,0x01,0x02,0x68,0x00]

global_atomic_add_f32 v1, v2, vcc
// GFX11: [0x00,0x00,0x5a,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_add_f32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x5a,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_add_f32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x5a,0xdd,0xff,0x02,0x06,0x00]

global_atomic_add_f32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x5a,0xdd,0xff,0x02,0x68,0x00]

global_atomic_add_f32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x5a,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_add_f32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x5a,0xdd,0xff,0xff,0x7a,0xff]

global_atomic_add_u32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_add_u32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xd6,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_add_u32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x06,0x00]

global_atomic_add_u32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x68,0x00]

global_atomic_add_u32 v1, v2, vcc
// GFX11: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_add_u32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_add_u32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xd6,0xdc,0xff,0x02,0x06,0x00]

global_atomic_add_u32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xd6,0xdc,0xff,0x02,0x68,0x00]

global_atomic_add_u32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xd6,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_add_u32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xd6,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_add_u64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x0e,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_add_u64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x0e,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_add_u64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x0e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add_u64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x0e,0xdd,0x01,0x02,0x68,0x00]

global_atomic_add_u64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x0e,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_add_u64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x0e,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_add_u64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x0e,0xdd,0xff,0x02,0x06,0x00]

global_atomic_add_u64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x0e,0xdd,0xff,0x02,0x68,0x00]

global_atomic_add_u64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x0e,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_add_u64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x0e,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_add_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x0e,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_add_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x0e,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_add_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x0e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x0e,0xdd,0x01,0x02,0x68,0x00]

global_atomic_add_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x0e,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_add_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x0e,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_add_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x0e,0xdd,0xff,0x02,0x06,0x00]

global_atomic_add_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x0e,0xdd,0xff,0x02,0x68,0x00]

global_atomic_add_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x0e,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_add_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x0e,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_and v[1:2], v2, off
// GFX11: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_and v[254:255], v2, off
// GFX11: [0x00,0x00,0xf2,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_and v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x06,0x00]

global_atomic_and v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x68,0x00]

global_atomic_and v1, v2, vcc
// GFX11: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_and v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_and v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xf2,0xdc,0xff,0x02,0x06,0x00]

global_atomic_and v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xf2,0xdc,0xff,0x02,0x68,0x00]

global_atomic_and v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xf2,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_and v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xf2,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_and_b32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_and_b32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xf2,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_and_b32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x06,0x00]

global_atomic_and_b32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x68,0x00]

global_atomic_and_b32 v1, v2, vcc
// GFX11: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_and_b32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_and_b32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xf2,0xdc,0xff,0x02,0x06,0x00]

global_atomic_and_b32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xf2,0xdc,0xff,0x02,0x68,0x00]

global_atomic_and_b32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xf2,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_and_b32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xf2,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_and_b64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x26,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_and_b64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x26,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_and_b64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x26,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and_b64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x26,0xdd,0x01,0x02,0x68,0x00]

global_atomic_and_b64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x26,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_and_b64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x26,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_and_b64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x26,0xdd,0xff,0x02,0x06,0x00]

global_atomic_and_b64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x26,0xdd,0xff,0x02,0x68,0x00]

global_atomic_and_b64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x26,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_and_b64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x26,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_and_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x26,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_and_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x26,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_and_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x26,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x26,0xdd,0x01,0x02,0x68,0x00]

global_atomic_and_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x26,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_and_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x26,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_and_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x26,0xdd,0xff,0x02,0x06,0x00]

global_atomic_and_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x26,0xdd,0xff,0x02,0x68,0x00]

global_atomic_and_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x26,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_and_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x26,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_cmpswap v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0xd2,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_cmpswap v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0xd2,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_cmpswap v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0xd2,0xdc,0x01,0x02,0x06,0x00]

global_atomic_cmpswap v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0xd2,0xdc,0x01,0x02,0x68,0x00]

global_atomic_cmpswap v1, v[2:3], vcc
// GFX11: [0x00,0x00,0xd2,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_cmpswap v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0xd2,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_cmpswap v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xd2,0xdc,0xff,0x02,0x06,0x00]

global_atomic_cmpswap v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0xd2,0xdc,0xff,0x02,0x68,0x00]

global_atomic_cmpswap v5, v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xd2,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_cmpswap v255, v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xd2,0xdc,0xff,0xfe,0x7a,0xff]

global_atomic_cmpswap_b32 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0xd2,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_cmpswap_b32 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0xd2,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_cmpswap_b32 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0xd2,0xdc,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_b32 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0xd2,0xdc,0x01,0x02,0x68,0x00]

global_atomic_cmpswap_b32 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0xd2,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_cmpswap_b32 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0xd2,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_cmpswap_b32 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xd2,0xdc,0xff,0x02,0x06,0x00]

global_atomic_cmpswap_b32 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0xd2,0xdc,0xff,0x02,0x68,0x00]

global_atomic_cmpswap_b32 v5, v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xd2,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_cmpswap_b32 v255, v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xd2,0xdc,0xff,0xfe,0x7a,0xff]

global_atomic_cmpswap_b64 v[1:2], v[2:5], off
// GFX11: [0x00,0x00,0x0a,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_cmpswap_b64 v[254:255], v[2:5], off
// GFX11: [0x00,0x00,0x0a,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_cmpswap_b64 v1, v[2:5], s[6:7]
// GFX11: [0x00,0x00,0x0a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_b64 v1, v[2:5], s[104:105]
// GFX11: [0x00,0x00,0x0a,0xdd,0x01,0x02,0x68,0x00]

global_atomic_cmpswap_b64 v1, v[2:5], vcc
// GFX11: [0x00,0x00,0x0a,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_cmpswap_b64 v1, v[2:5], ttmp[14:15]
// GFX11: [0x00,0x00,0x0a,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_cmpswap_b64 v255, v[2:5], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x0a,0xdd,0xff,0x02,0x06,0x00]

global_atomic_cmpswap_b64 v255, v[2:5], s[104:105] offset:0
// GFX11: [0x00,0x00,0x0a,0xdd,0xff,0x02,0x68,0x00]

global_atomic_cmpswap_b64 v[5:6], v255, v[2:5], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x0a,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_cmpswap_b64 v[254:255], v255, v[252:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x0a,0xdd,0xff,0xfc,0x7a,0xfe]

global_atomic_cmpswap_f32 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x42,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_cmpswap_f32 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x42,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_cmpswap_f32 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x42,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_f32 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x42,0xdd,0x01,0x02,0x68,0x00]

global_atomic_cmpswap_f32 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x42,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_cmpswap_f32 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x42,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_cmpswap_f32 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x42,0xdd,0xff,0x02,0x06,0x00]

global_atomic_cmpswap_f32 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x42,0xdd,0xff,0x02,0x68,0x00]

global_atomic_cmpswap_f32 v5, v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x42,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_cmpswap_f32 v255, v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x42,0xdd,0xff,0xfe,0x7a,0xff]

global_atomic_cmpswap_x2 v[1:2], v[2:5], off
// GFX11: [0x00,0x00,0x0a,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_cmpswap_x2 v[254:255], v[2:5], off
// GFX11: [0x00,0x00,0x0a,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], s[6:7]
// GFX11: [0x00,0x00,0x0a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], s[104:105]
// GFX11: [0x00,0x00,0x0a,0xdd,0x01,0x02,0x68,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], vcc
// GFX11: [0x00,0x00,0x0a,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], ttmp[14:15]
// GFX11: [0x00,0x00,0x0a,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_cmpswap_x2 v255, v[2:5], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x0a,0xdd,0xff,0x02,0x06,0x00]

global_atomic_cmpswap_x2 v255, v[2:5], s[104:105] offset:0
// GFX11: [0x00,0x00,0x0a,0xdd,0xff,0x02,0x68,0x00]

global_atomic_cmpswap_x2 v[5:6], v255, v[2:5], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x0a,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_cmpswap_x2 v[254:255], v255, v[252:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x0a,0xdd,0xff,0xfc,0x7a,0xfe]

global_atomic_csub v5, v[1:2], v2, off glc
// GFX11: [0x00,0x40,0xde,0xdc,0x01,0x02,0x7c,0x05]

global_atomic_csub v[1:2], v2, off
// GFX11: [0x00,0x00,0xde,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_csub v5, v[254:255], v2, off glc
// GFX11: [0x00,0x40,0xde,0xdc,0xfe,0x02,0x7c,0x05]

global_atomic_csub v5, v1, v2, s[6:7] glc
// GFX11: [0x00,0x40,0xde,0xdc,0x01,0x02,0x06,0x05]

global_atomic_csub v5, v1, v2, s[104:105] glc
// GFX11: [0x00,0x40,0xde,0xdc,0x01,0x02,0x68,0x05]

global_atomic_csub v5, v1, v2, vcc glc
// GFX11: [0x00,0x40,0xde,0xdc,0x01,0x02,0x6a,0x05]

global_atomic_csub v5, v1, v2, ttmp[14:15] glc
// GFX11: [0x00,0x40,0xde,0xdc,0x01,0x02,0x7a,0x05]

global_atomic_csub v5, v255, v2, s[6:7] offset:-1 glc
// GFX11: [0xff,0x5f,0xde,0xdc,0xff,0x02,0x06,0x05]

global_atomic_csub v5, v255, v2, s[104:105] offset:0 glc
// GFX11: [0x00,0x40,0xde,0xdc,0xff,0x02,0x68,0x05]

global_atomic_csub v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xde,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_csub v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xde,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_csub v255, v255, ttmp[14:15] offset:-4096 slc dlc
// GFX11: [0x00,0xb0,0xde,0xdc,0xff,0xff,0x7a,0x00]

global_atomic_csub_u32 v5, v[1:2], v2, off glc
// GFX11: [0x00,0x40,0xde,0xdc,0x01,0x02,0x7c,0x05]

global_atomic_csub_u32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xde,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_csub_u32 v5, v[254:255], v2, off glc
// GFX11: [0x00,0x40,0xde,0xdc,0xfe,0x02,0x7c,0x05]

global_atomic_csub_u32 v5, v1, v2, s[6:7] glc
// GFX11: [0x00,0x40,0xde,0xdc,0x01,0x02,0x06,0x05]

global_atomic_csub_u32 v5, v1, v2, s[104:105] glc
// GFX11: [0x00,0x40,0xde,0xdc,0x01,0x02,0x68,0x05]

global_atomic_csub_u32 v5, v1, v2, vcc glc
// GFX11: [0x00,0x40,0xde,0xdc,0x01,0x02,0x6a,0x05]

global_atomic_csub_u32 v5, v1, v2, ttmp[14:15] glc
// GFX11: [0x00,0x40,0xde,0xdc,0x01,0x02,0x7a,0x05]

global_atomic_csub_u32 v5, v255, v2, s[6:7] offset:-1 glc
// GFX11: [0xff,0x5f,0xde,0xdc,0xff,0x02,0x06,0x05]

global_atomic_csub_u32 v5, v255, v2, s[104:105] offset:0 glc
// GFX11: [0x00,0x40,0xde,0xdc,0xff,0x02,0x68,0x05]

global_atomic_csub_u32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xde,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_csub_u32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xde,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_csub_u32 v255, v255, ttmp[14:15] offset:-4096 slc dlc
// GFX11: [0x00,0xb0,0xde,0xdc,0xff,0xff,0x7a,0x00]

global_atomic_dec v[1:2], v2, off
// GFX11: [0x00,0x00,0x02,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_dec v[254:255], v2, off
// GFX11: [0x00,0x00,0x02,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_dec v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x02,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x02,0xdd,0x01,0x02,0x68,0x00]

global_atomic_dec v1, v2, vcc
// GFX11: [0x00,0x00,0x02,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_dec v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x02,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_dec v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x02,0xdd,0xff,0x02,0x06,0x00]

global_atomic_dec v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x02,0xdd,0xff,0x02,0x68,0x00]

global_atomic_dec v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x02,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_dec v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x02,0xdd,0xff,0xff,0x7a,0xff]

global_atomic_dec_u32 v[1:2], v2, off
// GFX11: [0x00,0x00,0x02,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_dec_u32 v[254:255], v2, off
// GFX11: [0x00,0x00,0x02,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_dec_u32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x02,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec_u32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x02,0xdd,0x01,0x02,0x68,0x00]

global_atomic_dec_u32 v1, v2, vcc
// GFX11: [0x00,0x00,0x02,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_dec_u32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x02,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_dec_u32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x02,0xdd,0xff,0x02,0x06,0x00]

global_atomic_dec_u32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x02,0xdd,0xff,0x02,0x68,0x00]

global_atomic_dec_u32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x02,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_dec_u32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x02,0xdd,0xff,0xff,0x7a,0xff]

global_atomic_dec_u64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x36,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_dec_u64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x36,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_dec_u64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x36,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec_u64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x36,0xdd,0x01,0x02,0x68,0x00]

global_atomic_dec_u64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x36,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_dec_u64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x36,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_dec_u64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x36,0xdd,0xff,0x02,0x06,0x00]

global_atomic_dec_u64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x36,0xdd,0xff,0x02,0x68,0x00]

global_atomic_dec_u64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x36,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_dec_u64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x36,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_dec_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x36,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_dec_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x36,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_dec_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x36,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x36,0xdd,0x01,0x02,0x68,0x00]

global_atomic_dec_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x36,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_dec_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x36,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_dec_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x36,0xdd,0xff,0x02,0x06,0x00]

global_atomic_dec_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x36,0xdd,0xff,0x02,0x68,0x00]

global_atomic_dec_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x36,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_dec_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x36,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_inc v[1:2], v2, off
// GFX11: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_inc v[254:255], v2, off
// GFX11: [0x00,0x00,0xfe,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_inc v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x06,0x00]

global_atomic_inc v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x68,0x00]

global_atomic_inc v1, v2, vcc
// GFX11: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_inc v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_inc v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xfe,0xdc,0xff,0x02,0x06,0x00]

global_atomic_inc v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xfe,0xdc,0xff,0x02,0x68,0x00]

global_atomic_inc v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xfe,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_inc v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xfe,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_inc_u32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_inc_u32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xfe,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_inc_u32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x06,0x00]

global_atomic_inc_u32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x68,0x00]

global_atomic_inc_u32 v1, v2, vcc
// GFX11: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_inc_u32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_inc_u32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xfe,0xdc,0xff,0x02,0x06,0x00]

global_atomic_inc_u32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xfe,0xdc,0xff,0x02,0x68,0x00]

global_atomic_inc_u32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xfe,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_inc_u32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xfe,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_inc_u64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x32,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_inc_u64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x32,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_inc_u64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x32,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc_u64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x32,0xdd,0x01,0x02,0x68,0x00]

global_atomic_inc_u64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x32,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_inc_u64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x32,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_inc_u64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x32,0xdd,0xff,0x02,0x06,0x00]

global_atomic_inc_u64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x32,0xdd,0xff,0x02,0x68,0x00]

global_atomic_inc_u64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x32,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_inc_u64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x32,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_inc_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x32,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_inc_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x32,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_inc_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x32,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x32,0xdd,0x01,0x02,0x68,0x00]

global_atomic_inc_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x32,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_inc_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x32,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_inc_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x32,0xdd,0xff,0x02,0x06,0x00]

global_atomic_inc_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x32,0xdd,0xff,0x02,0x68,0x00]

global_atomic_inc_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x32,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_inc_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x32,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_max_f32 v[1:2], v2, off
// GFX11: [0x00,0x00,0x4a,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_max_f32 v[254:255], v2, off
// GFX11: [0x00,0x00,0x4a,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_max_f32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x4a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_max_f32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x4a,0xdd,0x01,0x02,0x68,0x00]

global_atomic_max_f32 v1, v2, vcc
// GFX11: [0x00,0x00,0x4a,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_max_f32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x4a,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_max_f32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x4a,0xdd,0xff,0x02,0x06,0x00]

global_atomic_max_f32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x4a,0xdd,0xff,0x02,0x68,0x00]

global_atomic_max_f32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x4a,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_max_f32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x4a,0xdd,0xff,0xff,0x7a,0xff]

global_atomic_max_i32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xea,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_max_i32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xea,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_max_i32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xea,0xdc,0x01,0x02,0x06,0x00]

global_atomic_max_i32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xea,0xdc,0x01,0x02,0x68,0x00]

global_atomic_max_i32 v1, v2, vcc
// GFX11: [0x00,0x00,0xea,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_max_i32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xea,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_max_i32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xea,0xdc,0xff,0x02,0x06,0x00]

global_atomic_max_i32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xea,0xdc,0xff,0x02,0x68,0x00]

global_atomic_max_i32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xea,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_max_i32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xea,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_max_i64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x1e,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_max_i64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x1e,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_max_i64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x1e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_max_i64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x1e,0xdd,0x01,0x02,0x68,0x00]

global_atomic_max_i64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x1e,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_max_i64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x1e,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_max_i64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x1e,0xdd,0xff,0x02,0x06,0x00]

global_atomic_max_i64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x1e,0xdd,0xff,0x02,0x68,0x00]

global_atomic_max_i64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x1e,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_max_i64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x1e,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_max_u32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xee,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_max_u32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xee,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_max_u32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xee,0xdc,0x01,0x02,0x06,0x00]

global_atomic_max_u32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xee,0xdc,0x01,0x02,0x68,0x00]

global_atomic_max_u32 v1, v2, vcc
// GFX11: [0x00,0x00,0xee,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_max_u32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xee,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_max_u32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xee,0xdc,0xff,0x02,0x06,0x00]

global_atomic_max_u32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xee,0xdc,0xff,0x02,0x68,0x00]

global_atomic_max_u32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xee,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_max_u32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xee,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_max_u64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x22,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_max_u64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x22,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_max_u64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x22,0xdd,0x01,0x02,0x06,0x00]

global_atomic_max_u64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x22,0xdd,0x01,0x02,0x68,0x00]

global_atomic_max_u64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x22,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_max_u64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x22,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_max_u64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x22,0xdd,0xff,0x02,0x06,0x00]

global_atomic_max_u64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x22,0xdd,0xff,0x02,0x68,0x00]

global_atomic_max_u64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x22,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_max_u64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x22,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_min_f32 v[1:2], v2, off
// GFX11: [0x00,0x00,0x46,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_min_f32 v[254:255], v2, off
// GFX11: [0x00,0x00,0x46,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_min_f32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x46,0xdd,0x01,0x02,0x06,0x00]

global_atomic_min_f32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x46,0xdd,0x01,0x02,0x68,0x00]

global_atomic_min_f32 v1, v2, vcc
// GFX11: [0x00,0x00,0x46,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_min_f32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x46,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_min_f32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x46,0xdd,0xff,0x02,0x06,0x00]

global_atomic_min_f32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x46,0xdd,0xff,0x02,0x68,0x00]

global_atomic_min_f32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x46,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_min_f32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x46,0xdd,0xff,0xff,0x7a,0xff]

global_atomic_min_i32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_min_i32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xe2,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_min_i32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x06,0x00]

global_atomic_min_i32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x68,0x00]

global_atomic_min_i32 v1, v2, vcc
// GFX11: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_min_i32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_min_i32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xe2,0xdc,0xff,0x02,0x06,0x00]

global_atomic_min_i32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xe2,0xdc,0xff,0x02,0x68,0x00]

global_atomic_min_i32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xe2,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_min_i32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xe2,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_min_i64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x16,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_min_i64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x16,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_min_i64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x16,0xdd,0x01,0x02,0x06,0x00]

global_atomic_min_i64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x16,0xdd,0x01,0x02,0x68,0x00]

global_atomic_min_i64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x16,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_min_i64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x16,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_min_i64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x16,0xdd,0xff,0x02,0x06,0x00]

global_atomic_min_i64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x16,0xdd,0xff,0x02,0x68,0x00]

global_atomic_min_i64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x16,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_min_i64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x16,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_min_u32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_min_u32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xe6,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_min_u32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x06,0x00]

global_atomic_min_u32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x68,0x00]

global_atomic_min_u32 v1, v2, vcc
// GFX11: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_min_u32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_min_u32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xe6,0xdc,0xff,0x02,0x06,0x00]

global_atomic_min_u32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xe6,0xdc,0xff,0x02,0x68,0x00]

global_atomic_min_u32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xe6,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_min_u32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xe6,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_min_u64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x1a,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_min_u64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x1a,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_min_u64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x1a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_min_u64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x1a,0xdd,0x01,0x02,0x68,0x00]

global_atomic_min_u64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x1a,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_min_u64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x1a,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_min_u64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x1a,0xdd,0xff,0x02,0x06,0x00]

global_atomic_min_u64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x1a,0xdd,0xff,0x02,0x68,0x00]

global_atomic_min_u64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x1a,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_min_u64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x1a,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_or v[1:2], v2, off
// GFX11: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_or v[254:255], v2, off
// GFX11: [0x00,0x00,0xf6,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_or v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x06,0x00]

global_atomic_or v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x68,0x00]

global_atomic_or v1, v2, vcc
// GFX11: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_or v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_or v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xf6,0xdc,0xff,0x02,0x06,0x00]

global_atomic_or v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xf6,0xdc,0xff,0x02,0x68,0x00]

global_atomic_or v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xf6,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_or v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xf6,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_or_b32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_or_b32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xf6,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_or_b32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x06,0x00]

global_atomic_or_b32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x68,0x00]

global_atomic_or_b32 v1, v2, vcc
// GFX11: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_or_b32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_or_b32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xf6,0xdc,0xff,0x02,0x06,0x00]

global_atomic_or_b32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xf6,0xdc,0xff,0x02,0x68,0x00]

global_atomic_or_b32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xf6,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_or_b32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xf6,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_or_b64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x2a,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_or_b64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x2a,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_or_b64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x2a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or_b64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x2a,0xdd,0x01,0x02,0x68,0x00]

global_atomic_or_b64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x2a,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_or_b64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x2a,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_or_b64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x2a,0xdd,0xff,0x02,0x06,0x00]

global_atomic_or_b64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x2a,0xdd,0xff,0x02,0x68,0x00]

global_atomic_or_b64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x2a,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_or_b64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x2a,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_or_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x2a,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_or_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x2a,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_or_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x2a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x2a,0xdd,0x01,0x02,0x68,0x00]

global_atomic_or_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x2a,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_or_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x2a,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_or_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x2a,0xdd,0xff,0x02,0x06,0x00]

global_atomic_or_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x2a,0xdd,0xff,0x02,0x68,0x00]

global_atomic_or_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x2a,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_or_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x2a,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_smax v[1:2], v2, off
// GFX11: [0x00,0x00,0xea,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_smax v[254:255], v2, off
// GFX11: [0x00,0x00,0xea,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_smax v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xea,0xdc,0x01,0x02,0x06,0x00]

global_atomic_smax v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xea,0xdc,0x01,0x02,0x68,0x00]

global_atomic_smax v1, v2, vcc
// GFX11: [0x00,0x00,0xea,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_smax v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xea,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_smax v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xea,0xdc,0xff,0x02,0x06,0x00]

global_atomic_smax v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xea,0xdc,0xff,0x02,0x68,0x00]

global_atomic_smax v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xea,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_smax v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xea,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_smax_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x1e,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_smax_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x1e,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_smax_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x1e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x1e,0xdd,0x01,0x02,0x68,0x00]

global_atomic_smax_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x1e,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_smax_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x1e,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_smax_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x1e,0xdd,0xff,0x02,0x06,0x00]

global_atomic_smax_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x1e,0xdd,0xff,0x02,0x68,0x00]

global_atomic_smax_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x1e,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_smax_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x1e,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_smin v[1:2], v2, off
// GFX11: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_smin v[254:255], v2, off
// GFX11: [0x00,0x00,0xe2,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_smin v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x06,0x00]

global_atomic_smin v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x68,0x00]

global_atomic_smin v1, v2, vcc
// GFX11: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_smin v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_smin v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xe2,0xdc,0xff,0x02,0x06,0x00]

global_atomic_smin v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xe2,0xdc,0xff,0x02,0x68,0x00]

global_atomic_smin v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xe2,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_smin v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xe2,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_smin_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x16,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_smin_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x16,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_smin_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x16,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x16,0xdd,0x01,0x02,0x68,0x00]

global_atomic_smin_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x16,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_smin_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x16,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_smin_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x16,0xdd,0xff,0x02,0x06,0x00]

global_atomic_smin_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x16,0xdd,0xff,0x02,0x68,0x00]

global_atomic_smin_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x16,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_smin_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x16,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_sub v[1:2], v2, off
// GFX11: [0x00,0x00,0xda,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_sub v[254:255], v2, off
// GFX11: [0x00,0x00,0xda,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_sub v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xda,0xdc,0x01,0x02,0x06,0x00]

global_atomic_sub v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xda,0xdc,0x01,0x02,0x68,0x00]

global_atomic_sub v1, v2, vcc
// GFX11: [0x00,0x00,0xda,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_sub v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xda,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_sub v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xda,0xdc,0xff,0x02,0x06,0x00]

global_atomic_sub v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xda,0xdc,0xff,0x02,0x68,0x00]

global_atomic_sub v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xda,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_sub v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xda,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_sub_u32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xda,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_sub_u32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xda,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_sub_u32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xda,0xdc,0x01,0x02,0x06,0x00]

global_atomic_sub_u32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xda,0xdc,0x01,0x02,0x68,0x00]

global_atomic_sub_u32 v1, v2, vcc
// GFX11: [0x00,0x00,0xda,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_sub_u32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xda,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_sub_u32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xda,0xdc,0xff,0x02,0x06,0x00]

global_atomic_sub_u32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xda,0xdc,0xff,0x02,0x68,0x00]

global_atomic_sub_u32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xda,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_sub_u32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xda,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_sub_u64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x12,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_sub_u64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x12,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_sub_u64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x12,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub_u64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x12,0xdd,0x01,0x02,0x68,0x00]

global_atomic_sub_u64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x12,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_sub_u64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x12,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_sub_u64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x12,0xdd,0xff,0x02,0x06,0x00]

global_atomic_sub_u64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x12,0xdd,0xff,0x02,0x68,0x00]

global_atomic_sub_u64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x12,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_sub_u64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x12,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_sub_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x12,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_sub_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x12,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_sub_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x12,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x12,0xdd,0x01,0x02,0x68,0x00]

global_atomic_sub_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x12,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_sub_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x12,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_sub_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x12,0xdd,0xff,0x02,0x06,0x00]

global_atomic_sub_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x12,0xdd,0xff,0x02,0x68,0x00]

global_atomic_sub_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x12,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_sub_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x12,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_swap v[1:2], v2, off
// GFX11: [0x00,0x00,0xce,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_swap v[254:255], v2, off
// GFX11: [0x00,0x00,0xce,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_swap v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xce,0xdc,0x01,0x02,0x06,0x00]

global_atomic_swap v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xce,0xdc,0x01,0x02,0x68,0x00]

global_atomic_swap v1, v2, vcc
// GFX11: [0x00,0x00,0xce,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_swap v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xce,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_swap v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xce,0xdc,0xff,0x02,0x06,0x00]

global_atomic_swap v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xce,0xdc,0xff,0x02,0x68,0x00]

global_atomic_swap v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xce,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_swap v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xce,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_swap_b32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xce,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_swap_b32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xce,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_swap_b32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xce,0xdc,0x01,0x02,0x06,0x00]

global_atomic_swap_b32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xce,0xdc,0x01,0x02,0x68,0x00]

global_atomic_swap_b32 v1, v2, vcc
// GFX11: [0x00,0x00,0xce,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_swap_b32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xce,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_swap_b32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xce,0xdc,0xff,0x02,0x06,0x00]

global_atomic_swap_b32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xce,0xdc,0xff,0x02,0x68,0x00]

global_atomic_swap_b32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xce,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_swap_b32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xce,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_swap_b64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x06,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_swap_b64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x06,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_swap_b64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x06,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap_b64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x06,0xdd,0x01,0x02,0x68,0x00]

global_atomic_swap_b64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x06,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_swap_b64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x06,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_swap_b64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x06,0xdd,0xff,0x02,0x06,0x00]

global_atomic_swap_b64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x06,0xdd,0xff,0x02,0x68,0x00]

global_atomic_swap_b64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x06,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_swap_b64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x06,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_swap_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x06,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_swap_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x06,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_swap_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x06,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x06,0xdd,0x01,0x02,0x68,0x00]

global_atomic_swap_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x06,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_swap_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x06,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_swap_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x06,0xdd,0xff,0x02,0x06,0x00]

global_atomic_swap_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x06,0xdd,0xff,0x02,0x68,0x00]

global_atomic_swap_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x06,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_swap_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x06,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_umax v[1:2], v2, off
// GFX11: [0x00,0x00,0xee,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_umax v[254:255], v2, off
// GFX11: [0x00,0x00,0xee,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_umax v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xee,0xdc,0x01,0x02,0x06,0x00]

global_atomic_umax v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xee,0xdc,0x01,0x02,0x68,0x00]

global_atomic_umax v1, v2, vcc
// GFX11: [0x00,0x00,0xee,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_umax v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xee,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_umax v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xee,0xdc,0xff,0x02,0x06,0x00]

global_atomic_umax v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xee,0xdc,0xff,0x02,0x68,0x00]

global_atomic_umax v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xee,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_umax v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xee,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_umax_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x22,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_umax_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x22,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_umax_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x22,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x22,0xdd,0x01,0x02,0x68,0x00]

global_atomic_umax_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x22,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_umax_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x22,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_umax_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x22,0xdd,0xff,0x02,0x06,0x00]

global_atomic_umax_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x22,0xdd,0xff,0x02,0x68,0x00]

global_atomic_umax_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x22,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_umax_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x22,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_umin v[1:2], v2, off
// GFX11: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_umin v[254:255], v2, off
// GFX11: [0x00,0x00,0xe6,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_umin v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x06,0x00]

global_atomic_umin v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x68,0x00]

global_atomic_umin v1, v2, vcc
// GFX11: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_umin v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_umin v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xe6,0xdc,0xff,0x02,0x06,0x00]

global_atomic_umin v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xe6,0xdc,0xff,0x02,0x68,0x00]

global_atomic_umin v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xe6,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_umin v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xe6,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_umin_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x1a,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_umin_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x1a,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_umin_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x1a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x1a,0xdd,0x01,0x02,0x68,0x00]

global_atomic_umin_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x1a,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_umin_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x1a,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_umin_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x1a,0xdd,0xff,0x02,0x06,0x00]

global_atomic_umin_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x1a,0xdd,0xff,0x02,0x68,0x00]

global_atomic_umin_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x1a,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_umin_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x1a,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_xor v[1:2], v2, off
// GFX11: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_xor v[254:255], v2, off
// GFX11: [0x00,0x00,0xfa,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_xor v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x06,0x00]

global_atomic_xor v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x68,0x00]

global_atomic_xor v1, v2, vcc
// GFX11: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_xor v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_xor v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xfa,0xdc,0xff,0x02,0x06,0x00]

global_atomic_xor v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xfa,0xdc,0xff,0x02,0x68,0x00]

global_atomic_xor v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xfa,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_xor v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xfa,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_xor_b32 v[1:2], v2, off
// GFX11: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x7c,0x00]

global_atomic_xor_b32 v[254:255], v2, off
// GFX11: [0x00,0x00,0xfa,0xdc,0xfe,0x02,0x7c,0x00]

global_atomic_xor_b32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x06,0x00]

global_atomic_xor_b32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x68,0x00]

global_atomic_xor_b32 v1, v2, vcc
// GFX11: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x6a,0x00]

global_atomic_xor_b32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x7a,0x00]

global_atomic_xor_b32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0xfa,0xdc,0xff,0x02,0x06,0x00]

global_atomic_xor_b32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0xfa,0xdc,0xff,0x02,0x68,0x00]

global_atomic_xor_b32 v5, v255, v2, vcc offset:4095 glc
// GFX11: [0xff,0x4f,0xfa,0xdc,0xff,0x02,0x6a,0x05]

global_atomic_xor_b32 v255, v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xfa,0xdc,0xff,0xff,0x7a,0xff]

global_atomic_xor_b64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x2e,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_xor_b64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x2e,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_xor_b64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x2e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor_b64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x2e,0xdd,0x01,0x02,0x68,0x00]

global_atomic_xor_b64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x2e,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_xor_b64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x2e,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_xor_b64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x2e,0xdd,0xff,0x02,0x06,0x00]

global_atomic_xor_b64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x2e,0xdd,0xff,0x02,0x68,0x00]

global_atomic_xor_b64 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x2e,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_xor_b64 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x2e,0xdd,0xff,0xfe,0x7a,0xfe]

global_atomic_xor_x2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x2e,0xdd,0x01,0x02,0x7c,0x00]

global_atomic_xor_x2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x2e,0xdd,0xfe,0x02,0x7c,0x00]

global_atomic_xor_x2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x2e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor_x2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x2e,0xdd,0x01,0x02,0x68,0x00]

global_atomic_xor_x2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x2e,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_xor_x2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x2e,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_xor_x2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x2e,0xdd,0xff,0x02,0x06,0x00]

global_atomic_xor_x2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x2e,0xdd,0xff,0x02,0x68,0x00]

global_atomic_xor_x2 v[5:6], v255, v[2:3], vcc offset:4095 glc
// GFX11: [0xff,0x4f,0x2e,0xdd,0xff,0x02,0x6a,0x05]

global_atomic_xor_x2 v[254:255], v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x2e,0xdd,0xff,0xfe,0x7a,0xfe]

global_load_addtid_b32 v5, s[2:3]
// GFX11: [0x00,0x00,0xa2,0xdc,0x00,0x00,0x02,0x05]

global_load_addtid_b32 v5, s[104:105]
// GFX11: [0x00,0x00,0xa2,0xdc,0x00,0x00,0x68,0x05]

global_load_addtid_b32 v5, vcc offset:-1
// GFX11: [0xff,0x1f,0xa2,0xdc,0x00,0x00,0x6a,0x05]

global_load_addtid_b32 v5, ttmp[14:15] offset:0
// GFX11: [0x00,0x00,0xa2,0xdc,0x00,0x00,0x7a,0x05]

global_load_addtid_b32 v5, null offset:4095
// GFX11: [0xff,0x0f,0xa2,0xdc,0x00,0x00,0x7c,0x05]

global_load_addtid_b32 v255, off offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xa2,0xdc,0x00,0x00,0x7c,0xff]

global_load_b128 v[5:8], v[1:2], off
// GFX11: [0x00,0x00,0x5e,0xdc,0x01,0x00,0x7c,0x05]

global_load_b128 v[5:8], v[254:255], off
// GFX11: [0x00,0x00,0x5e,0xdc,0xfe,0x00,0x7c,0x05]

global_load_b128 v[5:8], v1, s[4:5]
// GFX11: [0x00,0x00,0x5e,0xdc,0x01,0x00,0x04,0x05]

global_load_b128 v[5:8], v1, s[104:105]
// GFX11: [0x00,0x00,0x5e,0xdc,0x01,0x00,0x68,0x05]

global_load_b128 v[5:8], v1, vcc
// GFX11: [0x00,0x00,0x5e,0xdc,0x01,0x00,0x6a,0x05]

global_load_b128 v[5:8], v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x5e,0xdc,0x01,0x00,0x7a,0x05]

global_load_b128 v[5:8], v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x5e,0xdc,0xff,0x00,0x04,0x05]

global_load_b128 v[5:8], v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x5e,0xdc,0xff,0x00,0x68,0x05]

global_load_b128 v[5:8], v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x5e,0xdc,0xff,0x00,0x6a,0x05]

global_load_b128 v[252:255], v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x5e,0xdc,0xff,0x00,0x7a,0xfc]

global_load_b32 v5, v[1:2], off
// GFX11: [0x00,0x00,0x52,0xdc,0x01,0x00,0x7c,0x05]

global_load_b32 v5, v[254:255], off
// GFX11: [0x00,0x00,0x52,0xdc,0xfe,0x00,0x7c,0x05]

global_load_b32 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x52,0xdc,0x01,0x00,0x04,0x05]

global_load_b32 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x52,0xdc,0x01,0x00,0x68,0x05]

global_load_b32 v5, v1, vcc
// GFX11: [0x00,0x00,0x52,0xdc,0x01,0x00,0x6a,0x05]

global_load_b32 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x52,0xdc,0x01,0x00,0x7a,0x05]

global_load_b32 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x52,0xdc,0xff,0x00,0x04,0x05]

global_load_b32 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x52,0xdc,0xff,0x00,0x68,0x05]

global_load_b32 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x52,0xdc,0xff,0x00,0x6a,0x05]

global_load_b32 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x52,0xdc,0xff,0x00,0x7a,0xff]

global_load_b64 v[5:6], v[1:2], off
// GFX11: [0x00,0x00,0x56,0xdc,0x01,0x00,0x7c,0x05]

global_load_b64 v[5:6], v[254:255], off
// GFX11: [0x00,0x00,0x56,0xdc,0xfe,0x00,0x7c,0x05]

global_load_b64 v[5:6], v1, s[4:5]
// GFX11: [0x00,0x00,0x56,0xdc,0x01,0x00,0x04,0x05]

global_load_b64 v[5:6], v1, s[104:105]
// GFX11: [0x00,0x00,0x56,0xdc,0x01,0x00,0x68,0x05]

global_load_b64 v[5:6], v1, vcc
// GFX11: [0x00,0x00,0x56,0xdc,0x01,0x00,0x6a,0x05]

global_load_b64 v[5:6], v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x56,0xdc,0x01,0x00,0x7a,0x05]

global_load_b64 v[5:6], v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x56,0xdc,0xff,0x00,0x04,0x05]

global_load_b64 v[5:6], v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x56,0xdc,0xff,0x00,0x68,0x05]

global_load_b64 v[5:6], v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x56,0xdc,0xff,0x00,0x6a,0x05]

global_load_b64 v[254:255], v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x56,0xdc,0xff,0x00,0x7a,0xfe]

global_load_b96 v[5:7], v[1:2], off
// GFX11: [0x00,0x00,0x5a,0xdc,0x01,0x00,0x7c,0x05]

global_load_b96 v[5:7], v[254:255], off
// GFX11: [0x00,0x00,0x5a,0xdc,0xfe,0x00,0x7c,0x05]

global_load_b96 v[5:7], v1, s[4:5]
// GFX11: [0x00,0x00,0x5a,0xdc,0x01,0x00,0x04,0x05]

global_load_b96 v[5:7], v1, s[104:105]
// GFX11: [0x00,0x00,0x5a,0xdc,0x01,0x00,0x68,0x05]

global_load_b96 v[5:7], v1, vcc
// GFX11: [0x00,0x00,0x5a,0xdc,0x01,0x00,0x6a,0x05]

global_load_b96 v[5:7], v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x5a,0xdc,0x01,0x00,0x7a,0x05]

global_load_b96 v[5:7], v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x5a,0xdc,0xff,0x00,0x04,0x05]

global_load_b96 v[5:7], v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x5a,0xdc,0xff,0x00,0x68,0x05]

global_load_b96 v[5:7], v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x5a,0xdc,0xff,0x00,0x6a,0x05]

global_load_b96 v[253:255], v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x5a,0xdc,0xff,0x00,0x7a,0xfd]

global_load_d16_b16 v5, v[1:2], off
// GFX11: [0x00,0x00,0x82,0xdc,0x01,0x00,0x7c,0x05]

global_load_d16_b16 v5, v[254:255], off
// GFX11: [0x00,0x00,0x82,0xdc,0xfe,0x00,0x7c,0x05]

global_load_d16_b16 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x82,0xdc,0x01,0x00,0x04,0x05]

global_load_d16_b16 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x82,0xdc,0x01,0x00,0x68,0x05]

global_load_d16_b16 v5, v1, vcc
// GFX11: [0x00,0x00,0x82,0xdc,0x01,0x00,0x6a,0x05]

global_load_d16_b16 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x82,0xdc,0x01,0x00,0x7a,0x05]

global_load_d16_b16 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x82,0xdc,0xff,0x00,0x04,0x05]

global_load_d16_b16 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x82,0xdc,0xff,0x00,0x68,0x05]

global_load_d16_b16 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x82,0xdc,0xff,0x00,0x6a,0x05]

global_load_d16_b16 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x82,0xdc,0xff,0x00,0x7a,0xff]

global_load_d16_hi_b16 v5, v[1:2], off
// GFX11: [0x00,0x00,0x8e,0xdc,0x01,0x00,0x7c,0x05]

global_load_d16_hi_b16 v5, v[254:255], off
// GFX11: [0x00,0x00,0x8e,0xdc,0xfe,0x00,0x7c,0x05]

global_load_d16_hi_b16 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x8e,0xdc,0x01,0x00,0x04,0x05]

global_load_d16_hi_b16 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x8e,0xdc,0x01,0x00,0x68,0x05]

global_load_d16_hi_b16 v5, v1, vcc
// GFX11: [0x00,0x00,0x8e,0xdc,0x01,0x00,0x6a,0x05]

global_load_d16_hi_b16 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x8e,0xdc,0x01,0x00,0x7a,0x05]

global_load_d16_hi_b16 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x8e,0xdc,0xff,0x00,0x04,0x05]

global_load_d16_hi_b16 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x8e,0xdc,0xff,0x00,0x68,0x05]

global_load_d16_hi_b16 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x8e,0xdc,0xff,0x00,0x6a,0x05]

global_load_d16_hi_b16 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x8e,0xdc,0xff,0x00,0x7a,0xff]

global_load_d16_hi_i8 v5, v[1:2], off
// GFX11: [0x00,0x00,0x8a,0xdc,0x01,0x00,0x7c,0x05]

global_load_d16_hi_i8 v5, v[254:255], off
// GFX11: [0x00,0x00,0x8a,0xdc,0xfe,0x00,0x7c,0x05]

global_load_d16_hi_i8 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x8a,0xdc,0x01,0x00,0x04,0x05]

global_load_d16_hi_i8 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x8a,0xdc,0x01,0x00,0x68,0x05]

global_load_d16_hi_i8 v5, v1, vcc
// GFX11: [0x00,0x00,0x8a,0xdc,0x01,0x00,0x6a,0x05]

global_load_d16_hi_i8 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x8a,0xdc,0x01,0x00,0x7a,0x05]

global_load_d16_hi_i8 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x8a,0xdc,0xff,0x00,0x04,0x05]

global_load_d16_hi_i8 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x8a,0xdc,0xff,0x00,0x68,0x05]

global_load_d16_hi_i8 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x8a,0xdc,0xff,0x00,0x6a,0x05]

global_load_d16_hi_i8 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x8a,0xdc,0xff,0x00,0x7a,0xff]

global_load_d16_hi_u8 v5, v[1:2], off
// GFX11: [0x00,0x00,0x86,0xdc,0x01,0x00,0x7c,0x05]

global_load_d16_hi_u8 v5, v[254:255], off
// GFX11: [0x00,0x00,0x86,0xdc,0xfe,0x00,0x7c,0x05]

global_load_d16_hi_u8 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x86,0xdc,0x01,0x00,0x04,0x05]

global_load_d16_hi_u8 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x86,0xdc,0x01,0x00,0x68,0x05]

global_load_d16_hi_u8 v5, v1, vcc
// GFX11: [0x00,0x00,0x86,0xdc,0x01,0x00,0x6a,0x05]

global_load_d16_hi_u8 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x86,0xdc,0x01,0x00,0x7a,0x05]

global_load_d16_hi_u8 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x86,0xdc,0xff,0x00,0x04,0x05]

global_load_d16_hi_u8 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x86,0xdc,0xff,0x00,0x68,0x05]

global_load_d16_hi_u8 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x86,0xdc,0xff,0x00,0x6a,0x05]

global_load_d16_hi_u8 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x86,0xdc,0xff,0x00,0x7a,0xff]

global_load_d16_i8 v5, v[1:2], off
// GFX11: [0x00,0x00,0x7e,0xdc,0x01,0x00,0x7c,0x05]

global_load_d16_i8 v5, v[254:255], off
// GFX11: [0x00,0x00,0x7e,0xdc,0xfe,0x00,0x7c,0x05]

global_load_d16_i8 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x7e,0xdc,0x01,0x00,0x04,0x05]

global_load_d16_i8 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x7e,0xdc,0x01,0x00,0x68,0x05]

global_load_d16_i8 v5, v1, vcc
// GFX11: [0x00,0x00,0x7e,0xdc,0x01,0x00,0x6a,0x05]

global_load_d16_i8 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x7e,0xdc,0x01,0x00,0x7a,0x05]

global_load_d16_i8 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x7e,0xdc,0xff,0x00,0x04,0x05]

global_load_d16_i8 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x7e,0xdc,0xff,0x00,0x68,0x05]

global_load_d16_i8 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x7e,0xdc,0xff,0x00,0x6a,0x05]

global_load_d16_i8 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x7e,0xdc,0xff,0x00,0x7a,0xff]

global_load_d16_u8 v5, v[1:2], off
// GFX11: [0x00,0x00,0x7a,0xdc,0x01,0x00,0x7c,0x05]

global_load_d16_u8 v5, v[254:255], off
// GFX11: [0x00,0x00,0x7a,0xdc,0xfe,0x00,0x7c,0x05]

global_load_d16_u8 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x7a,0xdc,0x01,0x00,0x04,0x05]

global_load_d16_u8 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x7a,0xdc,0x01,0x00,0x68,0x05]

global_load_d16_u8 v5, v1, vcc
// GFX11: [0x00,0x00,0x7a,0xdc,0x01,0x00,0x6a,0x05]

global_load_d16_u8 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x7a,0xdc,0x01,0x00,0x7a,0x05]

global_load_d16_u8 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x7a,0xdc,0xff,0x00,0x04,0x05]

global_load_d16_u8 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x7a,0xdc,0xff,0x00,0x68,0x05]

global_load_d16_u8 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x7a,0xdc,0xff,0x00,0x6a,0x05]

global_load_d16_u8 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x7a,0xdc,0xff,0x00,0x7a,0xff]

global_load_dword v5, v[1:2], off
// GFX11: [0x00,0x00,0x52,0xdc,0x01,0x00,0x7c,0x05]

global_load_dword v5, v[254:255], off
// GFX11: [0x00,0x00,0x52,0xdc,0xfe,0x00,0x7c,0x05]

global_load_dword v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x52,0xdc,0x01,0x00,0x04,0x05]

global_load_dword v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x52,0xdc,0x01,0x00,0x68,0x05]

global_load_dword v5, v1, vcc
// GFX11: [0x00,0x00,0x52,0xdc,0x01,0x00,0x6a,0x05]

global_load_dword v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x52,0xdc,0x01,0x00,0x7a,0x05]

global_load_dword v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x52,0xdc,0xff,0x00,0x04,0x05]

global_load_dword v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x52,0xdc,0xff,0x00,0x68,0x05]

global_load_dword v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x52,0xdc,0xff,0x00,0x6a,0x05]

global_load_dword v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x52,0xdc,0xff,0x00,0x7a,0xff]

global_load_dwordx2 v[5:6], v[1:2], off
// GFX11: [0x00,0x00,0x56,0xdc,0x01,0x00,0x7c,0x05]

global_load_dwordx2 v[5:6], v[254:255], off
// GFX11: [0x00,0x00,0x56,0xdc,0xfe,0x00,0x7c,0x05]

global_load_dwordx2 v[5:6], v1, s[4:5]
// GFX11: [0x00,0x00,0x56,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx2 v[5:6], v1, s[104:105]
// GFX11: [0x00,0x00,0x56,0xdc,0x01,0x00,0x68,0x05]

global_load_dwordx2 v[5:6], v1, vcc
// GFX11: [0x00,0x00,0x56,0xdc,0x01,0x00,0x6a,0x05]

global_load_dwordx2 v[5:6], v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x56,0xdc,0x01,0x00,0x7a,0x05]

global_load_dwordx2 v[5:6], v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x56,0xdc,0xff,0x00,0x04,0x05]

global_load_dwordx2 v[5:6], v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x56,0xdc,0xff,0x00,0x68,0x05]

global_load_dwordx2 v[5:6], v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x56,0xdc,0xff,0x00,0x6a,0x05]

global_load_dwordx2 v[254:255], v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x56,0xdc,0xff,0x00,0x7a,0xfe]

global_load_dwordx3 v[5:7], v[1:2], off
// GFX11: [0x00,0x00,0x5a,0xdc,0x01,0x00,0x7c,0x05]

global_load_dwordx3 v[5:7], v[254:255], off
// GFX11: [0x00,0x00,0x5a,0xdc,0xfe,0x00,0x7c,0x05]

global_load_dwordx3 v[5:7], v1, s[4:5]
// GFX11: [0x00,0x00,0x5a,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx3 v[5:7], v1, s[104:105]
// GFX11: [0x00,0x00,0x5a,0xdc,0x01,0x00,0x68,0x05]

global_load_dwordx3 v[5:7], v1, vcc
// GFX11: [0x00,0x00,0x5a,0xdc,0x01,0x00,0x6a,0x05]

global_load_dwordx3 v[5:7], v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x5a,0xdc,0x01,0x00,0x7a,0x05]

global_load_dwordx3 v[5:7], v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x5a,0xdc,0xff,0x00,0x04,0x05]

global_load_dwordx3 v[5:7], v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x5a,0xdc,0xff,0x00,0x68,0x05]

global_load_dwordx3 v[5:7], v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x5a,0xdc,0xff,0x00,0x6a,0x05]

global_load_dwordx3 v[253:255], v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x5a,0xdc,0xff,0x00,0x7a,0xfd]

global_load_dwordx4 v[5:8], v[1:2], off
// GFX11: [0x00,0x00,0x5e,0xdc,0x01,0x00,0x7c,0x05]

global_load_dwordx4 v[5:8], v[254:255], off
// GFX11: [0x00,0x00,0x5e,0xdc,0xfe,0x00,0x7c,0x05]

global_load_dwordx4 v[5:8], v1, s[4:5]
// GFX11: [0x00,0x00,0x5e,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx4 v[5:8], v1, s[104:105]
// GFX11: [0x00,0x00,0x5e,0xdc,0x01,0x00,0x68,0x05]

global_load_dwordx4 v[5:8], v1, vcc
// GFX11: [0x00,0x00,0x5e,0xdc,0x01,0x00,0x6a,0x05]

global_load_dwordx4 v[5:8], v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x5e,0xdc,0x01,0x00,0x7a,0x05]

global_load_dwordx4 v[5:8], v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x5e,0xdc,0xff,0x00,0x04,0x05]

global_load_dwordx4 v[5:8], v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x5e,0xdc,0xff,0x00,0x68,0x05]

global_load_dwordx4 v[5:8], v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x5e,0xdc,0xff,0x00,0x6a,0x05]

global_load_dwordx4 v[252:255], v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x5e,0xdc,0xff,0x00,0x7a,0xfc]

global_load_i16 v5, v[1:2], off
// GFX11: [0x00,0x00,0x4e,0xdc,0x01,0x00,0x7c,0x05]

global_load_i16 v5, v[254:255], off
// GFX11: [0x00,0x00,0x4e,0xdc,0xfe,0x00,0x7c,0x05]

global_load_i16 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x4e,0xdc,0x01,0x00,0x04,0x05]

global_load_i16 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x4e,0xdc,0x01,0x00,0x68,0x05]

global_load_i16 v5, v1, vcc
// GFX11: [0x00,0x00,0x4e,0xdc,0x01,0x00,0x6a,0x05]

global_load_i16 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x4e,0xdc,0x01,0x00,0x7a,0x05]

global_load_i16 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x4e,0xdc,0xff,0x00,0x04,0x05]

global_load_i16 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x4e,0xdc,0xff,0x00,0x68,0x05]

global_load_i16 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x4e,0xdc,0xff,0x00,0x6a,0x05]

global_load_i16 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x4e,0xdc,0xff,0x00,0x7a,0xff]

global_load_i8 v5, v[1:2], off
// GFX11: [0x00,0x00,0x46,0xdc,0x01,0x00,0x7c,0x05]

global_load_i8 v5, v[254:255], off
// GFX11: [0x00,0x00,0x46,0xdc,0xfe,0x00,0x7c,0x05]

global_load_i8 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x46,0xdc,0x01,0x00,0x04,0x05]

global_load_i8 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x46,0xdc,0x01,0x00,0x68,0x05]

global_load_i8 v5, v1, vcc
// GFX11: [0x00,0x00,0x46,0xdc,0x01,0x00,0x6a,0x05]

global_load_i8 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x46,0xdc,0x01,0x00,0x7a,0x05]

global_load_i8 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x46,0xdc,0xff,0x00,0x04,0x05]

global_load_i8 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x46,0xdc,0xff,0x00,0x68,0x05]

global_load_i8 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x46,0xdc,0xff,0x00,0x6a,0x05]

global_load_i8 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x46,0xdc,0xff,0x00,0x7a,0xff]

global_load_sbyte v5, v[1:2], off
// GFX11: [0x00,0x00,0x46,0xdc,0x01,0x00,0x7c,0x05]

global_load_sbyte v5, v[254:255], off
// GFX11: [0x00,0x00,0x46,0xdc,0xfe,0x00,0x7c,0x05]

global_load_sbyte v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x46,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x46,0xdc,0x01,0x00,0x68,0x05]

global_load_sbyte v5, v1, vcc
// GFX11: [0x00,0x00,0x46,0xdc,0x01,0x00,0x6a,0x05]

global_load_sbyte v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x46,0xdc,0x01,0x00,0x7a,0x05]

global_load_sbyte v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x46,0xdc,0xff,0x00,0x04,0x05]

global_load_sbyte v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x46,0xdc,0xff,0x00,0x68,0x05]

global_load_sbyte v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x46,0xdc,0xff,0x00,0x6a,0x05]

global_load_sbyte v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x46,0xdc,0xff,0x00,0x7a,0xff]

global_load_sshort v5, v[1:2], off
// GFX11: [0x00,0x00,0x4e,0xdc,0x01,0x00,0x7c,0x05]

global_load_sshort v5, v[254:255], off
// GFX11: [0x00,0x00,0x4e,0xdc,0xfe,0x00,0x7c,0x05]

global_load_sshort v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x4e,0xdc,0x01,0x00,0x04,0x05]

global_load_sshort v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x4e,0xdc,0x01,0x00,0x68,0x05]

global_load_sshort v5, v1, vcc
// GFX11: [0x00,0x00,0x4e,0xdc,0x01,0x00,0x6a,0x05]

global_load_sshort v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x4e,0xdc,0x01,0x00,0x7a,0x05]

global_load_sshort v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x4e,0xdc,0xff,0x00,0x04,0x05]

global_load_sshort v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x4e,0xdc,0xff,0x00,0x68,0x05]

global_load_sshort v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x4e,0xdc,0xff,0x00,0x6a,0x05]

global_load_sshort v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x4e,0xdc,0xff,0x00,0x7a,0xff]

global_load_u16 v5, v[1:2], off
// GFX11: [0x00,0x00,0x4a,0xdc,0x01,0x00,0x7c,0x05]

global_load_u16 v5, v[254:255], off
// GFX11: [0x00,0x00,0x4a,0xdc,0xfe,0x00,0x7c,0x05]

global_load_u16 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x4a,0xdc,0x01,0x00,0x04,0x05]

global_load_u16 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x4a,0xdc,0x01,0x00,0x68,0x05]

global_load_u16 v5, v1, vcc
// GFX11: [0x00,0x00,0x4a,0xdc,0x01,0x00,0x6a,0x05]

global_load_u16 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x4a,0xdc,0x01,0x00,0x7a,0x05]

global_load_u16 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x4a,0xdc,0xff,0x00,0x04,0x05]

global_load_u16 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x4a,0xdc,0xff,0x00,0x68,0x05]

global_load_u16 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x4a,0xdc,0xff,0x00,0x6a,0x05]

global_load_u16 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x4a,0xdc,0xff,0x00,0x7a,0xff]

global_load_u8 v5, v[1:2], off
// GFX11: [0x00,0x00,0x42,0xdc,0x01,0x00,0x7c,0x05]

global_load_u8 v5, v[254:255], off
// GFX11: [0x00,0x00,0x42,0xdc,0xfe,0x00,0x7c,0x05]

global_load_u8 v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x42,0xdc,0x01,0x00,0x04,0x05]

global_load_u8 v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x42,0xdc,0x01,0x00,0x68,0x05]

global_load_u8 v5, v1, vcc
// GFX11: [0x00,0x00,0x42,0xdc,0x01,0x00,0x6a,0x05]

global_load_u8 v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x42,0xdc,0x01,0x00,0x7a,0x05]

global_load_u8 v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x42,0xdc,0xff,0x00,0x04,0x05]

global_load_u8 v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x42,0xdc,0xff,0x00,0x68,0x05]

global_load_u8 v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x42,0xdc,0xff,0x00,0x6a,0x05]

global_load_u8 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x42,0xdc,0xff,0x00,0x7a,0xff]

global_load_ubyte v5, v[1:2], off
// GFX11: [0x00,0x00,0x42,0xdc,0x01,0x00,0x7c,0x05]

global_load_ubyte v5, v[254:255], off
// GFX11: [0x00,0x00,0x42,0xdc,0xfe,0x00,0x7c,0x05]

global_load_ubyte v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x42,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x42,0xdc,0x01,0x00,0x68,0x05]

global_load_ubyte v5, v1, vcc
// GFX11: [0x00,0x00,0x42,0xdc,0x01,0x00,0x6a,0x05]

global_load_ubyte v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x42,0xdc,0x01,0x00,0x7a,0x05]

global_load_ubyte v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x42,0xdc,0xff,0x00,0x04,0x05]

global_load_ubyte v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x42,0xdc,0xff,0x00,0x68,0x05]

global_load_ubyte v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x42,0xdc,0xff,0x00,0x6a,0x05]

global_load_ubyte v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x42,0xdc,0xff,0x00,0x7a,0xff]

global_load_ushort v5, v[1:2], off
// GFX11: [0x00,0x00,0x4a,0xdc,0x01,0x00,0x7c,0x05]

global_load_ushort v5, v[254:255], off
// GFX11: [0x00,0x00,0x4a,0xdc,0xfe,0x00,0x7c,0x05]

global_load_ushort v5, v1, s[4:5]
// GFX11: [0x00,0x00,0x4a,0xdc,0x01,0x00,0x04,0x05]

global_load_ushort v5, v1, s[104:105]
// GFX11: [0x00,0x00,0x4a,0xdc,0x01,0x00,0x68,0x05]

global_load_ushort v5, v1, vcc
// GFX11: [0x00,0x00,0x4a,0xdc,0x01,0x00,0x6a,0x05]

global_load_ushort v5, v1, ttmp[14:15]
// GFX11: [0x00,0x00,0x4a,0xdc,0x01,0x00,0x7a,0x05]

global_load_ushort v5, v255, s[4:5] offset:-1
// GFX11: [0xff,0x1f,0x4a,0xdc,0xff,0x00,0x04,0x05]

global_load_ushort v5, v255, s[104:105] offset:0
// GFX11: [0x00,0x00,0x4a,0xdc,0xff,0x00,0x68,0x05]

global_load_ushort v5, v255, vcc offset:4095
// GFX11: [0xff,0x0f,0x4a,0xdc,0xff,0x00,0x6a,0x05]

global_load_ushort v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x4a,0xdc,0xff,0x00,0x7a,0xff]

global_store_addtid_b32 v1, s[4:5]
// GFX11: [0x00,0x00,0xa6,0xdc,0x00,0x01,0x04,0x00]

global_store_addtid_b32 v1, s[104:105]
// GFX11: [0x00,0x00,0xa6,0xdc,0x00,0x01,0x68,0x00]

global_store_addtid_b32 v1, vcc offset:-1
// GFX11: [0xff,0x1f,0xa6,0xdc,0x00,0x01,0x6a,0x00]

global_store_addtid_b32 v1, ttmp[14:15] offset:0
// GFX11: [0x00,0x00,0xa6,0xdc,0x00,0x01,0x7a,0x00]

global_store_addtid_b32 v1, null offset:4095
// GFX11: [0xff,0x0f,0xa6,0xdc,0x00,0x01,0x7c,0x00]

global_store_addtid_b32 v255, off offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0xa6,0xdc,0x00,0xff,0x7c,0x00]

global_store_b128 v[1:2], v[2:5], off
// GFX11: [0x00,0x00,0x76,0xdc,0x01,0x02,0x7c,0x00]

global_store_b128 v[254:255], v[2:5], off
// GFX11: [0x00,0x00,0x76,0xdc,0xfe,0x02,0x7c,0x00]

global_store_b128 v1, v[2:5], s[6:7]
// GFX11: [0x00,0x00,0x76,0xdc,0x01,0x02,0x06,0x00]

global_store_b128 v1, v[2:5], s[104:105]
// GFX11: [0x00,0x00,0x76,0xdc,0x01,0x02,0x68,0x00]

global_store_b128 v1, v[2:5], vcc
// GFX11: [0x00,0x00,0x76,0xdc,0x01,0x02,0x6a,0x00]

global_store_b128 v1, v[2:5], ttmp[14:15]
// GFX11: [0x00,0x00,0x76,0xdc,0x01,0x02,0x7a,0x00]

global_store_b128 v255, v[2:5], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x76,0xdc,0xff,0x02,0x06,0x00]

global_store_b128 v255, v[2:5], s[104:105] offset:0
// GFX11: [0x00,0x00,0x76,0xdc,0xff,0x02,0x68,0x00]

global_store_b128 v255, v[2:5], vcc offset:4095
// GFX11: [0xff,0x0f,0x76,0xdc,0xff,0x02,0x6a,0x00]

global_store_b128 v255, v[252:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x76,0xdc,0xff,0xfc,0x7a,0x00]

global_store_b16 v[1:2], v2, off
// GFX11: [0x00,0x00,0x66,0xdc,0x01,0x02,0x7c,0x00]

global_store_b16 v[254:255], v2, off
// GFX11: [0x00,0x00,0x66,0xdc,0xfe,0x02,0x7c,0x00]

global_store_b16 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x66,0xdc,0x01,0x02,0x06,0x00]

global_store_b16 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x66,0xdc,0x01,0x02,0x68,0x00]

global_store_b16 v1, v2, vcc
// GFX11: [0x00,0x00,0x66,0xdc,0x01,0x02,0x6a,0x00]

global_store_b16 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x66,0xdc,0x01,0x02,0x7a,0x00]

global_store_b16 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x66,0xdc,0xff,0x02,0x06,0x00]

global_store_b16 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x66,0xdc,0xff,0x02,0x68,0x00]

global_store_b16 v255, v2, vcc offset:4095
// GFX11: [0xff,0x0f,0x66,0xdc,0xff,0x02,0x6a,0x00]

global_store_b16 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x66,0xdc,0xff,0xff,0x7a,0x00]

global_store_b32 v[1:2], v2, off
// GFX11: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x7c,0x00]

global_store_b32 v[254:255], v2, off
// GFX11: [0x00,0x00,0x6a,0xdc,0xfe,0x02,0x7c,0x00]

global_store_b32 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x06,0x00]

global_store_b32 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x68,0x00]

global_store_b32 v1, v2, vcc
// GFX11: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x6a,0x00]

global_store_b32 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x7a,0x00]

global_store_b32 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x6a,0xdc,0xff,0x02,0x06,0x00]

global_store_b32 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x6a,0xdc,0xff,0x02,0x68,0x00]

global_store_b32 v255, v2, vcc offset:4095
// GFX11: [0xff,0x0f,0x6a,0xdc,0xff,0x02,0x6a,0x00]

global_store_b32 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x6a,0xdc,0xff,0xff,0x7a,0x00]

global_store_b64 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x7c,0x00]

global_store_b64 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x6e,0xdc,0xfe,0x02,0x7c,0x00]

global_store_b64 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x06,0x00]

global_store_b64 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x68,0x00]

global_store_b64 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x6a,0x00]

global_store_b64 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x7a,0x00]

global_store_b64 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x6e,0xdc,0xff,0x02,0x06,0x00]

global_store_b64 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x6e,0xdc,0xff,0x02,0x68,0x00]

global_store_b64 v255, v[2:3], vcc offset:4095
// GFX11: [0xff,0x0f,0x6e,0xdc,0xff,0x02,0x6a,0x00]

global_store_b64 v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x6e,0xdc,0xff,0xfe,0x7a,0x00]

global_store_b8 v[1:2], v2, off
// GFX11: [0x00,0x00,0x62,0xdc,0x01,0x02,0x7c,0x00]

global_store_b8 v[254:255], v2, off
// GFX11: [0x00,0x00,0x62,0xdc,0xfe,0x02,0x7c,0x00]

global_store_b8 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x62,0xdc,0x01,0x02,0x06,0x00]

global_store_b8 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x62,0xdc,0x01,0x02,0x68,0x00]

global_store_b8 v1, v2, vcc
// GFX11: [0x00,0x00,0x62,0xdc,0x01,0x02,0x6a,0x00]

global_store_b8 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x62,0xdc,0x01,0x02,0x7a,0x00]

global_store_b8 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x62,0xdc,0xff,0x02,0x06,0x00]

global_store_b8 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x62,0xdc,0xff,0x02,0x68,0x00]

global_store_b8 v255, v2, vcc offset:4095
// GFX11: [0xff,0x0f,0x62,0xdc,0xff,0x02,0x6a,0x00]

global_store_b8 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x62,0xdc,0xff,0xff,0x7a,0x00]

global_store_b96 v[1:2], v[2:4], off
// GFX11: [0x00,0x00,0x72,0xdc,0x01,0x02,0x7c,0x00]

global_store_b96 v[254:255], v[2:4], off
// GFX11: [0x00,0x00,0x72,0xdc,0xfe,0x02,0x7c,0x00]

global_store_b96 v1, v[2:4], s[6:7]
// GFX11: [0x00,0x00,0x72,0xdc,0x01,0x02,0x06,0x00]

global_store_b96 v1, v[2:4], s[104:105]
// GFX11: [0x00,0x00,0x72,0xdc,0x01,0x02,0x68,0x00]

global_store_b96 v1, v[2:4], vcc
// GFX11: [0x00,0x00,0x72,0xdc,0x01,0x02,0x6a,0x00]

global_store_b96 v1, v[2:4], ttmp[14:15]
// GFX11: [0x00,0x00,0x72,0xdc,0x01,0x02,0x7a,0x00]

global_store_b96 v255, v[2:4], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x72,0xdc,0xff,0x02,0x06,0x00]

global_store_b96 v255, v[2:4], s[104:105] offset:0
// GFX11: [0x00,0x00,0x72,0xdc,0xff,0x02,0x68,0x00]

global_store_b96 v255, v[2:4], vcc offset:4095
// GFX11: [0xff,0x0f,0x72,0xdc,0xff,0x02,0x6a,0x00]

global_store_b96 v255, v[253:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x72,0xdc,0xff,0xfd,0x7a,0x00]

global_store_byte v[1:2], v2, off
// GFX11: [0x00,0x00,0x62,0xdc,0x01,0x02,0x7c,0x00]

global_store_byte v[254:255], v2, off
// GFX11: [0x00,0x00,0x62,0xdc,0xfe,0x02,0x7c,0x00]

global_store_byte v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x62,0xdc,0x01,0x02,0x06,0x00]

global_store_byte v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x62,0xdc,0x01,0x02,0x68,0x00]

global_store_byte v1, v2, vcc
// GFX11: [0x00,0x00,0x62,0xdc,0x01,0x02,0x6a,0x00]

global_store_byte v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x62,0xdc,0x01,0x02,0x7a,0x00]

global_store_byte v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x62,0xdc,0xff,0x02,0x06,0x00]

global_store_byte v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x62,0xdc,0xff,0x02,0x68,0x00]

global_store_byte v255, v2, vcc offset:4095
// GFX11: [0xff,0x0f,0x62,0xdc,0xff,0x02,0x6a,0x00]

global_store_byte v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x62,0xdc,0xff,0xff,0x7a,0x00]

global_store_d16_hi_b16 v[1:2], v2, off
// GFX11: [0x00,0x00,0x96,0xdc,0x01,0x02,0x7c,0x00]

global_store_d16_hi_b16 v[254:255], v2, off
// GFX11: [0x00,0x00,0x96,0xdc,0xfe,0x02,0x7c,0x00]

global_store_d16_hi_b16 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x96,0xdc,0x01,0x02,0x06,0x00]

global_store_d16_hi_b16 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x96,0xdc,0x01,0x02,0x68,0x00]

global_store_d16_hi_b16 v1, v2, vcc
// GFX11: [0x00,0x00,0x96,0xdc,0x01,0x02,0x6a,0x00]

global_store_d16_hi_b16 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x96,0xdc,0x01,0x02,0x7a,0x00]

global_store_d16_hi_b16 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x96,0xdc,0xff,0x02,0x06,0x00]

global_store_d16_hi_b16 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x96,0xdc,0xff,0x02,0x68,0x00]

global_store_d16_hi_b16 v255, v2, vcc offset:4095
// GFX11: [0xff,0x0f,0x96,0xdc,0xff,0x02,0x6a,0x00]

global_store_d16_hi_b16 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x96,0xdc,0xff,0xff,0x7a,0x00]

global_store_d16_hi_b8 v[1:2], v2, off
// GFX11: [0x00,0x00,0x92,0xdc,0x01,0x02,0x7c,0x00]

global_store_d16_hi_b8 v[254:255], v2, off
// GFX11: [0x00,0x00,0x92,0xdc,0xfe,0x02,0x7c,0x00]

global_store_d16_hi_b8 v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x92,0xdc,0x01,0x02,0x06,0x00]

global_store_d16_hi_b8 v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x92,0xdc,0x01,0x02,0x68,0x00]

global_store_d16_hi_b8 v1, v2, vcc
// GFX11: [0x00,0x00,0x92,0xdc,0x01,0x02,0x6a,0x00]

global_store_d16_hi_b8 v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x92,0xdc,0x01,0x02,0x7a,0x00]

global_store_d16_hi_b8 v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x92,0xdc,0xff,0x02,0x06,0x00]

global_store_d16_hi_b8 v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x92,0xdc,0xff,0x02,0x68,0x00]

global_store_d16_hi_b8 v255, v2, vcc offset:4095
// GFX11: [0xff,0x0f,0x92,0xdc,0xff,0x02,0x6a,0x00]

global_store_d16_hi_b8 v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x92,0xdc,0xff,0xff,0x7a,0x00]

global_store_dword v[1:2], v2, off
// GFX11: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x7c,0x00]

global_store_dword v[254:255], v2, off
// GFX11: [0x00,0x00,0x6a,0xdc,0xfe,0x02,0x7c,0x00]

global_store_dword v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x06,0x00]

global_store_dword v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x68,0x00]

global_store_dword v1, v2, vcc
// GFX11: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x6a,0x00]

global_store_dword v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x7a,0x00]

global_store_dword v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x6a,0xdc,0xff,0x02,0x06,0x00]

global_store_dword v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x6a,0xdc,0xff,0x02,0x68,0x00]

global_store_dword v255, v2, vcc offset:4095
// GFX11: [0xff,0x0f,0x6a,0xdc,0xff,0x02,0x6a,0x00]

global_store_dword v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x6a,0xdc,0xff,0xff,0x7a,0x00]

global_store_dwordx2 v[1:2], v[2:3], off
// GFX11: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x7c,0x00]

global_store_dwordx2 v[254:255], v[2:3], off
// GFX11: [0x00,0x00,0x6e,0xdc,0xfe,0x02,0x7c,0x00]

global_store_dwordx2 v1, v[2:3], s[6:7]
// GFX11: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx2 v1, v[2:3], s[104:105]
// GFX11: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x68,0x00]

global_store_dwordx2 v1, v[2:3], vcc
// GFX11: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x6a,0x00]

global_store_dwordx2 v1, v[2:3], ttmp[14:15]
// GFX11: [0x00,0x00,0x6e,0xdc,0x01,0x02,0x7a,0x00]

global_store_dwordx2 v255, v[2:3], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x6e,0xdc,0xff,0x02,0x06,0x00]

global_store_dwordx2 v255, v[2:3], s[104:105] offset:0
// GFX11: [0x00,0x00,0x6e,0xdc,0xff,0x02,0x68,0x00]

global_store_dwordx2 v255, v[2:3], vcc offset:4095
// GFX11: [0xff,0x0f,0x6e,0xdc,0xff,0x02,0x6a,0x00]

global_store_dwordx2 v255, v[254:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x6e,0xdc,0xff,0xfe,0x7a,0x00]

global_store_dwordx3 v[1:2], v[2:4], off
// GFX11: [0x00,0x00,0x72,0xdc,0x01,0x02,0x7c,0x00]

global_store_dwordx3 v[254:255], v[2:4], off
// GFX11: [0x00,0x00,0x72,0xdc,0xfe,0x02,0x7c,0x00]

global_store_dwordx3 v1, v[2:4], s[6:7]
// GFX11: [0x00,0x00,0x72,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx3 v1, v[2:4], s[104:105]
// GFX11: [0x00,0x00,0x72,0xdc,0x01,0x02,0x68,0x00]

global_store_dwordx3 v1, v[2:4], vcc
// GFX11: [0x00,0x00,0x72,0xdc,0x01,0x02,0x6a,0x00]

global_store_dwordx3 v1, v[2:4], ttmp[14:15]
// GFX11: [0x00,0x00,0x72,0xdc,0x01,0x02,0x7a,0x00]

global_store_dwordx3 v255, v[2:4], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x72,0xdc,0xff,0x02,0x06,0x00]

global_store_dwordx3 v255, v[2:4], s[104:105] offset:0
// GFX11: [0x00,0x00,0x72,0xdc,0xff,0x02,0x68,0x00]

global_store_dwordx3 v255, v[2:4], vcc offset:4095
// GFX11: [0xff,0x0f,0x72,0xdc,0xff,0x02,0x6a,0x00]

global_store_dwordx3 v255, v[253:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x72,0xdc,0xff,0xfd,0x7a,0x00]

global_store_dwordx4 v[1:2], v[2:5], off
// GFX11: [0x00,0x00,0x76,0xdc,0x01,0x02,0x7c,0x00]

global_store_dwordx4 v[254:255], v[2:5], off
// GFX11: [0x00,0x00,0x76,0xdc,0xfe,0x02,0x7c,0x00]

global_store_dwordx4 v1, v[2:5], s[6:7]
// GFX11: [0x00,0x00,0x76,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx4 v1, v[2:5], s[104:105]
// GFX11: [0x00,0x00,0x76,0xdc,0x01,0x02,0x68,0x00]

global_store_dwordx4 v1, v[2:5], vcc
// GFX11: [0x00,0x00,0x76,0xdc,0x01,0x02,0x6a,0x00]

global_store_dwordx4 v1, v[2:5], ttmp[14:15]
// GFX11: [0x00,0x00,0x76,0xdc,0x01,0x02,0x7a,0x00]

global_store_dwordx4 v255, v[2:5], s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x76,0xdc,0xff,0x02,0x06,0x00]

global_store_dwordx4 v255, v[2:5], s[104:105] offset:0
// GFX11: [0x00,0x00,0x76,0xdc,0xff,0x02,0x68,0x00]

global_store_dwordx4 v255, v[2:5], vcc offset:4095
// GFX11: [0xff,0x0f,0x76,0xdc,0xff,0x02,0x6a,0x00]

global_store_dwordx4 v255, v[252:255], ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x76,0xdc,0xff,0xfc,0x7a,0x00]

global_store_short v[1:2], v2, off
// GFX11: [0x00,0x00,0x66,0xdc,0x01,0x02,0x7c,0x00]

global_store_short v[254:255], v2, off
// GFX11: [0x00,0x00,0x66,0xdc,0xfe,0x02,0x7c,0x00]

global_store_short v1, v2, s[6:7]
// GFX11: [0x00,0x00,0x66,0xdc,0x01,0x02,0x06,0x00]

global_store_short v1, v2, s[104:105]
// GFX11: [0x00,0x00,0x66,0xdc,0x01,0x02,0x68,0x00]

global_store_short v1, v2, vcc
// GFX11: [0x00,0x00,0x66,0xdc,0x01,0x02,0x6a,0x00]

global_store_short v1, v2, ttmp[14:15]
// GFX11: [0x00,0x00,0x66,0xdc,0x01,0x02,0x7a,0x00]

global_store_short v255, v2, s[6:7] offset:-1
// GFX11: [0xff,0x1f,0x66,0xdc,0xff,0x02,0x06,0x00]

global_store_short v255, v2, s[104:105] offset:0
// GFX11: [0x00,0x00,0x66,0xdc,0xff,0x02,0x68,0x00]

global_store_short v255, v2, vcc offset:4095
// GFX11: [0xff,0x0f,0x66,0xdc,0xff,0x02,0x6a,0x00]

global_store_short v255, v255, ttmp[14:15] offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x66,0xdc,0xff,0xff,0x7a,0x00]

//===----------------------------------------------------------------------===//
// SCRATCH.
//===----------------------------------------------------------------------===//

scratch_load_b128 v[5:8], off, off
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_b128 v[5:8], off, null
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_b128 v[5:8], off, s2
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x02,0x05]

scratch_load_b128 v[5:8], off, s105
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x69,0x05]

scratch_load_b128 v[5:8], off, vcc_lo
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_b128 v[5:8], off, vcc_hi
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_b128 v[5:8], off, ttmp15
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_b128 v[5:8], v1, off
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_b128 v[5:8], v255, off
// GFX11: [0x00,0x00,0x5d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_b128 v[5:8], v1, null
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_b128 v[5:8], v255, null
// GFX11: [0x00,0x00,0x5d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_b128 v[5:8], v1, s2
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0x82,0x05]

scratch_load_b128 v[5:8], v1, s105
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_b128 v[5:8], v1, vcc_lo
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xea,0x05]

scratch_load_b128 v[5:8], v1, vcc_hi
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_b128 v[5:8], v1, ttmp15
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_b128 v[5:8], v255, s2
// GFX11: [0x00,0x00,0x5d,0xdc,0xff,0x00,0x82,0x05]

scratch_load_b128 v[5:8], v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x5d,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_b128 v[5:8], v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x5d,0xdc,0xff,0x00,0xea,0x05]

scratch_load_b128 v[5:8], v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x5d,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_b128 v[252:255], v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x5d,0xdc,0xff,0x00,0xfb,0xfc]

scratch_load_b32 v5, off, off
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_b32 v5, off, null
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_b32 v5, off, s2
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x02,0x05]

scratch_load_b32 v5, off, s105
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x69,0x05]

scratch_load_b32 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_b32 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_b32 v5, off, ttmp15
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_b32 v5, v1, off
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_b32 v5, v255, off
// GFX11: [0x00,0x00,0x51,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_b32 v5, v1, null
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_b32 v5, v255, null
// GFX11: [0x00,0x00,0x51,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_b32 v5, v1, s2
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0x82,0x05]

scratch_load_b32 v5, v1, s105
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_b32 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xea,0x05]

scratch_load_b32 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_b32 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_b32 v5, v255, s2
// GFX11: [0x00,0x00,0x51,0xdc,0xff,0x00,0x82,0x05]

scratch_load_b32 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x51,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_b32 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x51,0xdc,0xff,0x00,0xea,0x05]

scratch_load_b32 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x51,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_b32 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x51,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_b64 v[5:6], off, off
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_b64 v[5:6], off, null
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_b64 v[5:6], off, s2
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x02,0x05]

scratch_load_b64 v[5:6], off, s105
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x69,0x05]

scratch_load_b64 v[5:6], off, vcc_lo
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_b64 v[5:6], off, vcc_hi
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_b64 v[5:6], off, ttmp15
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_b64 v[5:6], v1, off
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_b64 v[5:6], v255, off
// GFX11: [0x00,0x00,0x55,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_b64 v[5:6], v1, null
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_b64 v[5:6], v255, null
// GFX11: [0x00,0x00,0x55,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_b64 v[5:6], v1, s2
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0x82,0x05]

scratch_load_b64 v[5:6], v1, s105
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_b64 v[5:6], v1, vcc_lo
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xea,0x05]

scratch_load_b64 v[5:6], v1, vcc_hi
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_b64 v[5:6], v1, ttmp15
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_b64 v[5:6], v255, s2
// GFX11: [0x00,0x00,0x55,0xdc,0xff,0x00,0x82,0x05]

scratch_load_b64 v[5:6], v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x55,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_b64 v[5:6], v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x55,0xdc,0xff,0x00,0xea,0x05]

scratch_load_b64 v[5:6], v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x55,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_b64 v[254:255], v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x55,0xdc,0xff,0x00,0xfb,0xfe]

scratch_load_b96 v[5:7], off, off
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_b96 v[5:7], off, null
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_b96 v[5:7], off, s2
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x02,0x05]

scratch_load_b96 v[5:7], off, s105
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x69,0x05]

scratch_load_b96 v[5:7], off, vcc_lo
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_b96 v[5:7], off, vcc_hi
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_b96 v[5:7], off, ttmp15
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_b96 v[5:7], v1, off
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_b96 v[5:7], v255, off
// GFX11: [0x00,0x00,0x59,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_b96 v[5:7], v1, null
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_b96 v[5:7], v255, null
// GFX11: [0x00,0x00,0x59,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_b96 v[5:7], v1, s2
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0x82,0x05]

scratch_load_b96 v[5:7], v1, s105
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_b96 v[5:7], v1, vcc_lo
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xea,0x05]

scratch_load_b96 v[5:7], v1, vcc_hi
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_b96 v[5:7], v1, ttmp15
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_b96 v[5:7], v255, s2
// GFX11: [0x00,0x00,0x59,0xdc,0xff,0x00,0x82,0x05]

scratch_load_b96 v[5:7], v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x59,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_b96 v[5:7], v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x59,0xdc,0xff,0x00,0xea,0x05]

scratch_load_b96 v[5:7], v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x59,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_b96 v[253:255], v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x59,0xdc,0xff,0x00,0xfb,0xfd]

scratch_load_d16_b16 v5, off, off
// GFX11: [0x00,0x00,0x81,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_b16 v5, off, null
// GFX11: [0x00,0x00,0x81,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_b16 v5, off, s2
// GFX11: [0x00,0x00,0x81,0xdc,0x00,0x00,0x02,0x05]

scratch_load_d16_b16 v5, off, s105
// GFX11: [0x00,0x00,0x81,0xdc,0x00,0x00,0x69,0x05]

scratch_load_d16_b16 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x81,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_d16_b16 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x81,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_d16_b16 v5, off, ttmp15
// GFX11: [0x00,0x00,0x81,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_d16_b16 v5, v1, off
// GFX11: [0x00,0x00,0x81,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_b16 v5, v255, off
// GFX11: [0x00,0x00,0x81,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_b16 v5, v1, null
// GFX11: [0x00,0x00,0x81,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_b16 v5, v255, null
// GFX11: [0x00,0x00,0x81,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_b16 v5, v1, s2
// GFX11: [0x00,0x00,0x81,0xdc,0x01,0x00,0x82,0x05]

scratch_load_d16_b16 v5, v1, s105
// GFX11: [0x00,0x00,0x81,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_d16_b16 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x81,0xdc,0x01,0x00,0xea,0x05]

scratch_load_d16_b16 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x81,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_d16_b16 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x81,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_d16_b16 v5, v255, s2
// GFX11: [0x00,0x00,0x81,0xdc,0xff,0x00,0x82,0x05]

scratch_load_d16_b16 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x81,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_d16_b16 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x81,0xdc,0xff,0x00,0xea,0x05]

scratch_load_d16_b16 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x81,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_d16_b16 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x81,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_d16_hi_b16 v5, off, off
// GFX11: [0x00,0x00,0x8d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_hi_b16 v5, off, null
// GFX11: [0x00,0x00,0x8d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_hi_b16 v5, off, s2
// GFX11: [0x00,0x00,0x8d,0xdc,0x00,0x00,0x02,0x05]

scratch_load_d16_hi_b16 v5, off, s105
// GFX11: [0x00,0x00,0x8d,0xdc,0x00,0x00,0x69,0x05]

scratch_load_d16_hi_b16 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x8d,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_d16_hi_b16 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x8d,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_d16_hi_b16 v5, off, ttmp15
// GFX11: [0x00,0x00,0x8d,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_d16_hi_b16 v5, v1, off
// GFX11: [0x00,0x00,0x8d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_hi_b16 v5, v255, off
// GFX11: [0x00,0x00,0x8d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_hi_b16 v5, v1, null
// GFX11: [0x00,0x00,0x8d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_hi_b16 v5, v255, null
// GFX11: [0x00,0x00,0x8d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_hi_b16 v5, v1, s2
// GFX11: [0x00,0x00,0x8d,0xdc,0x01,0x00,0x82,0x05]

scratch_load_d16_hi_b16 v5, v1, s105
// GFX11: [0x00,0x00,0x8d,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_d16_hi_b16 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x8d,0xdc,0x01,0x00,0xea,0x05]

scratch_load_d16_hi_b16 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x8d,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_d16_hi_b16 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x8d,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_d16_hi_b16 v5, v255, s2
// GFX11: [0x00,0x00,0x8d,0xdc,0xff,0x00,0x82,0x05]

scratch_load_d16_hi_b16 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x8d,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_d16_hi_b16 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x8d,0xdc,0xff,0x00,0xea,0x05]

scratch_load_d16_hi_b16 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x8d,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_d16_hi_b16 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x8d,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_d16_hi_i8 v5, off, off
// GFX11: [0x00,0x00,0x89,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_hi_i8 v5, off, null
// GFX11: [0x00,0x00,0x89,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_hi_i8 v5, off, s2
// GFX11: [0x00,0x00,0x89,0xdc,0x00,0x00,0x02,0x05]

scratch_load_d16_hi_i8 v5, off, s105
// GFX11: [0x00,0x00,0x89,0xdc,0x00,0x00,0x69,0x05]

scratch_load_d16_hi_i8 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x89,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_d16_hi_i8 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x89,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_d16_hi_i8 v5, off, ttmp15
// GFX11: [0x00,0x00,0x89,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_d16_hi_i8 v5, v1, off
// GFX11: [0x00,0x00,0x89,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_hi_i8 v5, v255, off
// GFX11: [0x00,0x00,0x89,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_hi_i8 v5, v1, null
// GFX11: [0x00,0x00,0x89,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_hi_i8 v5, v255, null
// GFX11: [0x00,0x00,0x89,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_hi_i8 v5, v1, s2
// GFX11: [0x00,0x00,0x89,0xdc,0x01,0x00,0x82,0x05]

scratch_load_d16_hi_i8 v5, v1, s105
// GFX11: [0x00,0x00,0x89,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_d16_hi_i8 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x89,0xdc,0x01,0x00,0xea,0x05]

scratch_load_d16_hi_i8 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x89,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_d16_hi_i8 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x89,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_d16_hi_i8 v5, v255, s2
// GFX11: [0x00,0x00,0x89,0xdc,0xff,0x00,0x82,0x05]

scratch_load_d16_hi_i8 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x89,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_d16_hi_i8 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x89,0xdc,0xff,0x00,0xea,0x05]

scratch_load_d16_hi_i8 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x89,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_d16_hi_i8 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x89,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_d16_hi_u8 v5, off, off
// GFX11: [0x00,0x00,0x85,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_hi_u8 v5, off, null
// GFX11: [0x00,0x00,0x85,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_hi_u8 v5, off, s2
// GFX11: [0x00,0x00,0x85,0xdc,0x00,0x00,0x02,0x05]

scratch_load_d16_hi_u8 v5, off, s105
// GFX11: [0x00,0x00,0x85,0xdc,0x00,0x00,0x69,0x05]

scratch_load_d16_hi_u8 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x85,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_d16_hi_u8 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x85,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_d16_hi_u8 v5, off, ttmp15
// GFX11: [0x00,0x00,0x85,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_d16_hi_u8 v5, v1, off
// GFX11: [0x00,0x00,0x85,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_hi_u8 v5, v255, off
// GFX11: [0x00,0x00,0x85,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_hi_u8 v5, v1, null
// GFX11: [0x00,0x00,0x85,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_hi_u8 v5, v255, null
// GFX11: [0x00,0x00,0x85,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_hi_u8 v5, v1, s2
// GFX11: [0x00,0x00,0x85,0xdc,0x01,0x00,0x82,0x05]

scratch_load_d16_hi_u8 v5, v1, s105
// GFX11: [0x00,0x00,0x85,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_d16_hi_u8 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x85,0xdc,0x01,0x00,0xea,0x05]

scratch_load_d16_hi_u8 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x85,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_d16_hi_u8 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x85,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_d16_hi_u8 v5, v255, s2
// GFX11: [0x00,0x00,0x85,0xdc,0xff,0x00,0x82,0x05]

scratch_load_d16_hi_u8 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x85,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_d16_hi_u8 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x85,0xdc,0xff,0x00,0xea,0x05]

scratch_load_d16_hi_u8 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x85,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_d16_hi_u8 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x85,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_d16_i8 v5, off, off
// GFX11: [0x00,0x00,0x7d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_i8 v5, off, null
// GFX11: [0x00,0x00,0x7d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_i8 v5, off, s2
// GFX11: [0x00,0x00,0x7d,0xdc,0x00,0x00,0x02,0x05]

scratch_load_d16_i8 v5, off, s105
// GFX11: [0x00,0x00,0x7d,0xdc,0x00,0x00,0x69,0x05]

scratch_load_d16_i8 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x7d,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_d16_i8 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x7d,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_d16_i8 v5, off, ttmp15
// GFX11: [0x00,0x00,0x7d,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_d16_i8 v5, v1, off
// GFX11: [0x00,0x00,0x7d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_i8 v5, v255, off
// GFX11: [0x00,0x00,0x7d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_i8 v5, v1, null
// GFX11: [0x00,0x00,0x7d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_i8 v5, v255, null
// GFX11: [0x00,0x00,0x7d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_i8 v5, v1, s2
// GFX11: [0x00,0x00,0x7d,0xdc,0x01,0x00,0x82,0x05]

scratch_load_d16_i8 v5, v1, s105
// GFX11: [0x00,0x00,0x7d,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_d16_i8 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x7d,0xdc,0x01,0x00,0xea,0x05]

scratch_load_d16_i8 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x7d,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_d16_i8 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x7d,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_d16_i8 v5, v255, s2
// GFX11: [0x00,0x00,0x7d,0xdc,0xff,0x00,0x82,0x05]

scratch_load_d16_i8 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x7d,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_d16_i8 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x7d,0xdc,0xff,0x00,0xea,0x05]

scratch_load_d16_i8 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x7d,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_d16_i8 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x7d,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_d16_u8 v5, off, off
// GFX11: [0x00,0x00,0x79,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_u8 v5, off, null
// GFX11: [0x00,0x00,0x79,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_d16_u8 v5, off, s2
// GFX11: [0x00,0x00,0x79,0xdc,0x00,0x00,0x02,0x05]

scratch_load_d16_u8 v5, off, s105
// GFX11: [0x00,0x00,0x79,0xdc,0x00,0x00,0x69,0x05]

scratch_load_d16_u8 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x79,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_d16_u8 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x79,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_d16_u8 v5, off, ttmp15
// GFX11: [0x00,0x00,0x79,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_d16_u8 v5, v1, off
// GFX11: [0x00,0x00,0x79,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_u8 v5, v255, off
// GFX11: [0x00,0x00,0x79,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_u8 v5, v1, null
// GFX11: [0x00,0x00,0x79,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_d16_u8 v5, v255, null
// GFX11: [0x00,0x00,0x79,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_d16_u8 v5, v1, s2
// GFX11: [0x00,0x00,0x79,0xdc,0x01,0x00,0x82,0x05]

scratch_load_d16_u8 v5, v1, s105
// GFX11: [0x00,0x00,0x79,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_d16_u8 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x79,0xdc,0x01,0x00,0xea,0x05]

scratch_load_d16_u8 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x79,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_d16_u8 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x79,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_d16_u8 v5, v255, s2
// GFX11: [0x00,0x00,0x79,0xdc,0xff,0x00,0x82,0x05]

scratch_load_d16_u8 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x79,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_d16_u8 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x79,0xdc,0xff,0x00,0xea,0x05]

scratch_load_d16_u8 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x79,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_d16_u8 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x79,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_dword v5, off, off
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_dword v5, off, null
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_dword v5, off, s2
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dword v5, off, s105
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x69,0x05]

scratch_load_dword v5, off, vcc_lo
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_dword v5, off, vcc_hi
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_dword v5, off, ttmp15
// GFX11: [0x00,0x00,0x51,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_dword v5, v1, off
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_dword v5, v255, off
// GFX11: [0x00,0x00,0x51,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_dword v5, v1, null
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_dword v5, v255, null
// GFX11: [0x00,0x00,0x51,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_dword v5, v1, s2
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0x82,0x05]

scratch_load_dword v5, v1, s105
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_dword v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xea,0x05]

scratch_load_dword v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_dword v5, v1, ttmp15
// GFX11: [0x00,0x00,0x51,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_dword v5, v255, s2
// GFX11: [0x00,0x00,0x51,0xdc,0xff,0x00,0x82,0x05]

scratch_load_dword v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x51,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_dword v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x51,0xdc,0xff,0x00,0xea,0x05]

scratch_load_dword v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x51,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_dword v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x51,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_dwordx2 v[5:6], off, off
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_dwordx2 v[5:6], off, null
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_dwordx2 v[5:6], off, s2
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx2 v[5:6], off, s105
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x69,0x05]

scratch_load_dwordx2 v[5:6], off, vcc_lo
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_dwordx2 v[5:6], off, vcc_hi
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_dwordx2 v[5:6], off, ttmp15
// GFX11: [0x00,0x00,0x55,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_dwordx2 v[5:6], v1, off
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_dwordx2 v[5:6], v255, off
// GFX11: [0x00,0x00,0x55,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_dwordx2 v[5:6], v1, null
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_dwordx2 v[5:6], v255, null
// GFX11: [0x00,0x00,0x55,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_dwordx2 v[5:6], v1, s2
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0x82,0x05]

scratch_load_dwordx2 v[5:6], v1, s105
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_dwordx2 v[5:6], v1, vcc_lo
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xea,0x05]

scratch_load_dwordx2 v[5:6], v1, vcc_hi
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_dwordx2 v[5:6], v1, ttmp15
// GFX11: [0x00,0x00,0x55,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_dwordx2 v[5:6], v255, s2
// GFX11: [0x00,0x00,0x55,0xdc,0xff,0x00,0x82,0x05]

scratch_load_dwordx2 v[5:6], v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x55,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_dwordx2 v[5:6], v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x55,0xdc,0xff,0x00,0xea,0x05]

scratch_load_dwordx2 v[5:6], v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x55,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_dwordx2 v[254:255], v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x55,0xdc,0xff,0x00,0xfb,0xfe]

scratch_load_dwordx3 v[5:7], off, off
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_dwordx3 v[5:7], off, null
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_dwordx3 v[5:7], off, s2
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx3 v[5:7], off, s105
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x69,0x05]

scratch_load_dwordx3 v[5:7], off, vcc_lo
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_dwordx3 v[5:7], off, vcc_hi
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_dwordx3 v[5:7], off, ttmp15
// GFX11: [0x00,0x00,0x59,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_dwordx3 v[5:7], v1, off
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_dwordx3 v[5:7], v255, off
// GFX11: [0x00,0x00,0x59,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_dwordx3 v[5:7], v1, null
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_dwordx3 v[5:7], v255, null
// GFX11: [0x00,0x00,0x59,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_dwordx3 v[5:7], v1, s2
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0x82,0x05]

scratch_load_dwordx3 v[5:7], v1, s105
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_dwordx3 v[5:7], v1, vcc_lo
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xea,0x05]

scratch_load_dwordx3 v[5:7], v1, vcc_hi
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_dwordx3 v[5:7], v1, ttmp15
// GFX11: [0x00,0x00,0x59,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_dwordx3 v[5:7], v255, s2
// GFX11: [0x00,0x00,0x59,0xdc,0xff,0x00,0x82,0x05]

scratch_load_dwordx3 v[5:7], v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x59,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_dwordx3 v[5:7], v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x59,0xdc,0xff,0x00,0xea,0x05]

scratch_load_dwordx3 v[5:7], v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x59,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_dwordx3 v[253:255], v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x59,0xdc,0xff,0x00,0xfb,0xfd]

scratch_load_dwordx4 v[5:8], off, off
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_dwordx4 v[5:8], off, null
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_dwordx4 v[5:8], off, s2
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx4 v[5:8], off, s105
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x69,0x05]

scratch_load_dwordx4 v[5:8], off, vcc_lo
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_dwordx4 v[5:8], off, vcc_hi
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_dwordx4 v[5:8], off, ttmp15
// GFX11: [0x00,0x00,0x5d,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_dwordx4 v[5:8], v1, off
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_dwordx4 v[5:8], v255, off
// GFX11: [0x00,0x00,0x5d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_dwordx4 v[5:8], v1, null
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_dwordx4 v[5:8], v255, null
// GFX11: [0x00,0x00,0x5d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_dwordx4 v[5:8], v1, s2
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0x82,0x05]

scratch_load_dwordx4 v[5:8], v1, s105
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_dwordx4 v[5:8], v1, vcc_lo
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xea,0x05]

scratch_load_dwordx4 v[5:8], v1, vcc_hi
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_dwordx4 v[5:8], v1, ttmp15
// GFX11: [0x00,0x00,0x5d,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_dwordx4 v[5:8], v255, s2
// GFX11: [0x00,0x00,0x5d,0xdc,0xff,0x00,0x82,0x05]

scratch_load_dwordx4 v[5:8], v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x5d,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_dwordx4 v[5:8], v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x5d,0xdc,0xff,0x00,0xea,0x05]

scratch_load_dwordx4 v[5:8], v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x5d,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_dwordx4 v[252:255], v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x5d,0xdc,0xff,0x00,0xfb,0xfc]

scratch_load_i16 v5, off, off
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_i16 v5, off, null
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_i16 v5, off, s2
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x02,0x05]

scratch_load_i16 v5, off, s105
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x69,0x05]

scratch_load_i16 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_i16 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_i16 v5, off, ttmp15
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_i16 v5, v1, off
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_i16 v5, v255, off
// GFX11: [0x00,0x00,0x4d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_i16 v5, v1, null
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_i16 v5, v255, null
// GFX11: [0x00,0x00,0x4d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_i16 v5, v1, s2
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0x82,0x05]

scratch_load_i16 v5, v1, s105
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_i16 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xea,0x05]

scratch_load_i16 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_i16 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_i16 v5, v255, s2
// GFX11: [0x00,0x00,0x4d,0xdc,0xff,0x00,0x82,0x05]

scratch_load_i16 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x4d,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_i16 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x4d,0xdc,0xff,0x00,0xea,0x05]

scratch_load_i16 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x4d,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_i16 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x4d,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_i8 v5, off, off
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_i8 v5, off, null
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_i8 v5, off, s2
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x02,0x05]

scratch_load_i8 v5, off, s105
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x69,0x05]

scratch_load_i8 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_i8 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_i8 v5, off, ttmp15
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_i8 v5, v1, off
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_i8 v5, v255, off
// GFX11: [0x00,0x00,0x45,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_i8 v5, v1, null
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_i8 v5, v255, null
// GFX11: [0x00,0x00,0x45,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_i8 v5, v1, s2
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0x82,0x05]

scratch_load_i8 v5, v1, s105
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_i8 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xea,0x05]

scratch_load_i8 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_i8 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_i8 v5, v255, s2
// GFX11: [0x00,0x00,0x45,0xdc,0xff,0x00,0x82,0x05]

scratch_load_i8 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x45,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_i8 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x45,0xdc,0xff,0x00,0xea,0x05]

scratch_load_i8 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x45,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_i8 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x45,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_sbyte v5, off, off
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_sbyte v5, off, null
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_sbyte v5, off, s2
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte v5, off, s105
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x69,0x05]

scratch_load_sbyte v5, off, vcc_lo
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_sbyte v5, off, vcc_hi
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_sbyte v5, off, ttmp15
// GFX11: [0x00,0x00,0x45,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_sbyte v5, v1, off
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_sbyte v5, v255, off
// GFX11: [0x00,0x00,0x45,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_sbyte v5, v1, null
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_sbyte v5, v255, null
// GFX11: [0x00,0x00,0x45,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_sbyte v5, v1, s2
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0x82,0x05]

scratch_load_sbyte v5, v1, s105
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_sbyte v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xea,0x05]

scratch_load_sbyte v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_sbyte v5, v1, ttmp15
// GFX11: [0x00,0x00,0x45,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_sbyte v5, v255, s2
// GFX11: [0x00,0x00,0x45,0xdc,0xff,0x00,0x82,0x05]

scratch_load_sbyte v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x45,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_sbyte v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x45,0xdc,0xff,0x00,0xea,0x05]

scratch_load_sbyte v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x45,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_sbyte v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x45,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_sshort v5, off, off
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_sshort v5, off, null
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_sshort v5, off, s2
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sshort v5, off, s105
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x69,0x05]

scratch_load_sshort v5, off, vcc_lo
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_sshort v5, off, vcc_hi
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_sshort v5, off, ttmp15
// GFX11: [0x00,0x00,0x4d,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_sshort v5, v1, off
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_sshort v5, v255, off
// GFX11: [0x00,0x00,0x4d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_sshort v5, v1, null
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_sshort v5, v255, null
// GFX11: [0x00,0x00,0x4d,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_sshort v5, v1, s2
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0x82,0x05]

scratch_load_sshort v5, v1, s105
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_sshort v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xea,0x05]

scratch_load_sshort v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_sshort v5, v1, ttmp15
// GFX11: [0x00,0x00,0x4d,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_sshort v5, v255, s2
// GFX11: [0x00,0x00,0x4d,0xdc,0xff,0x00,0x82,0x05]

scratch_load_sshort v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x4d,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_sshort v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x4d,0xdc,0xff,0x00,0xea,0x05]

scratch_load_sshort v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x4d,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_sshort v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x4d,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_u16 v5, off, off
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_u16 v5, off, null
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_u16 v5, off, s2
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x02,0x05]

scratch_load_u16 v5, off, s105
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x69,0x05]

scratch_load_u16 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_u16 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_u16 v5, off, ttmp15
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_u16 v5, v1, off
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_u16 v5, v255, off
// GFX11: [0x00,0x00,0x49,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_u16 v5, v1, null
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_u16 v5, v255, null
// GFX11: [0x00,0x00,0x49,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_u16 v5, v1, s2
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0x82,0x05]

scratch_load_u16 v5, v1, s105
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_u16 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xea,0x05]

scratch_load_u16 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_u16 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_u16 v5, v255, s2
// GFX11: [0x00,0x00,0x49,0xdc,0xff,0x00,0x82,0x05]

scratch_load_u16 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x49,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_u16 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x49,0xdc,0xff,0x00,0xea,0x05]

scratch_load_u16 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x49,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_u16 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x49,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_u8 v5, off, off
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_u8 v5, off, null
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_u8 v5, off, s2
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x02,0x05]

scratch_load_u8 v5, off, s105
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x69,0x05]

scratch_load_u8 v5, off, vcc_lo
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_u8 v5, off, vcc_hi
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_u8 v5, off, ttmp15
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_u8 v5, v1, off
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_u8 v5, v255, off
// GFX11: [0x00,0x00,0x41,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_u8 v5, v1, null
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_u8 v5, v255, null
// GFX11: [0x00,0x00,0x41,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_u8 v5, v1, s2
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0x82,0x05]

scratch_load_u8 v5, v1, s105
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_u8 v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xea,0x05]

scratch_load_u8 v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_u8 v5, v1, ttmp15
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_u8 v5, v255, s2
// GFX11: [0x00,0x00,0x41,0xdc,0xff,0x00,0x82,0x05]

scratch_load_u8 v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x41,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_u8 v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x41,0xdc,0xff,0x00,0xea,0x05]

scratch_load_u8 v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x41,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_u8 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x41,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_ubyte v5, off, off
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_ubyte v5, off, null
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_ubyte v5, off, s2
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte v5, off, s105
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x69,0x05]

scratch_load_ubyte v5, off, vcc_lo
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_ubyte v5, off, vcc_hi
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_ubyte v5, off, ttmp15
// GFX11: [0x00,0x00,0x41,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_ubyte v5, v1, off
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_ubyte v5, v255, off
// GFX11: [0x00,0x00,0x41,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_ubyte v5, v1, null
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_ubyte v5, v255, null
// GFX11: [0x00,0x00,0x41,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_ubyte v5, v1, s2
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0x82,0x05]

scratch_load_ubyte v5, v1, s105
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_ubyte v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xea,0x05]

scratch_load_ubyte v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_ubyte v5, v1, ttmp15
// GFX11: [0x00,0x00,0x41,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_ubyte v5, v255, s2
// GFX11: [0x00,0x00,0x41,0xdc,0xff,0x00,0x82,0x05]

scratch_load_ubyte v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x41,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_ubyte v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x41,0xdc,0xff,0x00,0xea,0x05]

scratch_load_ubyte v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x41,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_ubyte v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x41,0xdc,0xff,0x00,0xfb,0xff]

scratch_load_ushort v5, off, off
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_ushort v5, off, null
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x7c,0x05]

scratch_load_ushort v5, off, s2
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ushort v5, off, s105
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x69,0x05]

scratch_load_ushort v5, off, vcc_lo
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_ushort v5, off, vcc_hi
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_ushort v5, off, ttmp15
// GFX11: [0x00,0x00,0x49,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_ushort v5, v1, off
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_ushort v5, v255, off
// GFX11: [0x00,0x00,0x49,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_ushort v5, v1, null
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xfc,0x05]

scratch_load_ushort v5, v255, null
// GFX11: [0x00,0x00,0x49,0xdc,0xff,0x00,0xfc,0x05]

scratch_load_ushort v5, v1, s2
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0x82,0x05]

scratch_load_ushort v5, v1, s105
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xe9,0x05]

scratch_load_ushort v5, v1, vcc_lo
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xea,0x05]

scratch_load_ushort v5, v1, vcc_hi
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xeb,0x05]

scratch_load_ushort v5, v1, ttmp15
// GFX11: [0x00,0x00,0x49,0xdc,0x01,0x00,0xfb,0x05]

scratch_load_ushort v5, v255, s2
// GFX11: [0x00,0x00,0x49,0xdc,0xff,0x00,0x82,0x05]

scratch_load_ushort v5, v255, s105 offset:-1
// GFX11: [0xff,0x1f,0x49,0xdc,0xff,0x00,0xe9,0x05]

scratch_load_ushort v5, v255, vcc_lo offset:0
// GFX11: [0x00,0x00,0x49,0xdc,0xff,0x00,0xea,0x05]

scratch_load_ushort v5, v255, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x49,0xdc,0xff,0x00,0xeb,0x05]

scratch_load_ushort v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x49,0xdc,0xff,0x00,0xfb,0xff]

scratch_store_b128 off, v[2:5], off
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b128 off, v[2:5], null
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b128 off, v[2:5], s3
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x03,0x00]

scratch_store_b128 off, v[2:5], s105
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x69,0x00]

scratch_store_b128 off, v[2:5], vcc_lo
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_b128 off, v[2:5], vcc_hi
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_b128 off, v[2:5], ttmp15
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_b128 v1, v[2:5], off
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b128 v255, v[2:5], off
// GFX11: [0x00,0x00,0x75,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b128 v1, v[2:5], null
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b128 v255, v[2:5], null
// GFX11: [0x00,0x00,0x75,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b128 v1, v[2:5], s3
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b128 v1, v[2:5], s105
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_b128 v1, v[2:5], vcc_lo
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xea,0x00]

scratch_store_b128 v1, v[2:5], vcc_hi
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_b128 v1, v[2:5], ttmp15
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_b128 v255, v[2:5], s3
// GFX11: [0x00,0x00,0x75,0xdc,0xff,0x02,0x83,0x00]

scratch_store_b128 v255, v[2:5], s105 offset:-1
// GFX11: [0xff,0x1f,0x75,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_b128 v255, v[2:5], vcc_lo offset:0
// GFX11: [0x00,0x00,0x75,0xdc,0xff,0x02,0xea,0x00]

scratch_store_b128 v255, v[2:5], vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x75,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_b128 v255, v[252:255], ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x75,0xdc,0xff,0xfc,0xfb,0x00]

scratch_store_b16 off, v2, off
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b16 off, v2, null
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b16 off, v2, s3
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x03,0x00]

scratch_store_b16 off, v2, s105
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x69,0x00]

scratch_store_b16 off, v2, vcc_lo
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_b16 off, v2, vcc_hi
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_b16 off, v2, ttmp15
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_b16 v1, v2, off
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b16 v255, v2, off
// GFX11: [0x00,0x00,0x65,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b16 v1, v2, null
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b16 v255, v2, null
// GFX11: [0x00,0x00,0x65,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b16 v1, v2, s3
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b16 v1, v2, s105
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_b16 v1, v2, vcc_lo
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xea,0x00]

scratch_store_b16 v1, v2, vcc_hi
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_b16 v1, v2, ttmp15
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_b16 v255, v2, s3
// GFX11: [0x00,0x00,0x65,0xdc,0xff,0x02,0x83,0x00]

scratch_store_b16 v255, v2, s105 offset:-1
// GFX11: [0xff,0x1f,0x65,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_b16 v255, v2, vcc_lo offset:0
// GFX11: [0x00,0x00,0x65,0xdc,0xff,0x02,0xea,0x00]

scratch_store_b16 v255, v2, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x65,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_b16 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x65,0xdc,0xff,0xff,0xfb,0x00]

scratch_store_b32 off, v2, off
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b32 off, v2, null
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b32 off, v2, s3
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x03,0x00]

scratch_store_b32 off, v2, s105
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x69,0x00]

scratch_store_b32 off, v2, vcc_lo
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_b32 off, v2, vcc_hi
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_b32 off, v2, ttmp15
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_b32 v1, v2, off
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b32 v255, v2, off
// GFX11: [0x00,0x00,0x69,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b32 v1, v2, null
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b32 v255, v2, null
// GFX11: [0x00,0x00,0x69,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b32 v1, v2, s3
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b32 v1, v2, s105
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_b32 v1, v2, vcc_lo
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xea,0x00]

scratch_store_b32 v1, v2, vcc_hi
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_b32 v1, v2, ttmp15
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_b32 v255, v2, s3
// GFX11: [0x00,0x00,0x69,0xdc,0xff,0x02,0x83,0x00]

scratch_store_b32 v255, v2, s105 offset:-1
// GFX11: [0xff,0x1f,0x69,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_b32 v255, v2, vcc_lo offset:0
// GFX11: [0x00,0x00,0x69,0xdc,0xff,0x02,0xea,0x00]

scratch_store_b32 v255, v2, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x69,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_b32 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x69,0xdc,0xff,0xff,0xfb,0x00]

scratch_store_b64 off, v[2:3], off
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b64 off, v[2:3], null
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b64 off, v[2:3], s3
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x03,0x00]

scratch_store_b64 off, v[2:3], s105
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x69,0x00]

scratch_store_b64 off, v[2:3], vcc_lo
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_b64 off, v[2:3], vcc_hi
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_b64 off, v[2:3], ttmp15
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_b64 v1, v[2:3], off
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b64 v255, v[2:3], off
// GFX11: [0x00,0x00,0x6d,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b64 v1, v[2:3], null
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b64 v255, v[2:3], null
// GFX11: [0x00,0x00,0x6d,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b64 v1, v[2:3], s3
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b64 v1, v[2:3], s105
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_b64 v1, v[2:3], vcc_lo
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xea,0x00]

scratch_store_b64 v1, v[2:3], vcc_hi
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_b64 v1, v[2:3], ttmp15
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_b64 v255, v[2:3], s3
// GFX11: [0x00,0x00,0x6d,0xdc,0xff,0x02,0x83,0x00]

scratch_store_b64 v255, v[2:3], s105 offset:-1
// GFX11: [0xff,0x1f,0x6d,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_b64 v255, v[2:3], vcc_lo offset:0
// GFX11: [0x00,0x00,0x6d,0xdc,0xff,0x02,0xea,0x00]

scratch_store_b64 v255, v[2:3], vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x6d,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_b64 v255, v[254:255], ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x6d,0xdc,0xff,0xfe,0xfb,0x00]

scratch_store_b8 off, v2, off
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b8 off, v2, null
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b8 off, v2, s3
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x03,0x00]

scratch_store_b8 off, v2, s105
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x69,0x00]

scratch_store_b8 off, v2, vcc_lo
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_b8 off, v2, vcc_hi
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_b8 off, v2, ttmp15
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_b8 v1, v2, off
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b8 v255, v2, off
// GFX11: [0x00,0x00,0x61,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b8 v1, v2, null
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b8 v255, v2, null
// GFX11: [0x00,0x00,0x61,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b8 v1, v2, s3
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b8 v1, v2, s105
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_b8 v1, v2, vcc_lo
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xea,0x00]

scratch_store_b8 v1, v2, vcc_hi
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_b8 v1, v2, ttmp15
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_b8 v255, v2, s3
// GFX11: [0x00,0x00,0x61,0xdc,0xff,0x02,0x83,0x00]

scratch_store_b8 v255, v2, s105 offset:-1
// GFX11: [0xff,0x1f,0x61,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_b8 v255, v2, vcc_lo offset:0
// GFX11: [0x00,0x00,0x61,0xdc,0xff,0x02,0xea,0x00]

scratch_store_b8 v255, v2, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x61,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_b8 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x61,0xdc,0xff,0xff,0xfb,0x00]

scratch_store_b96 off, v[2:4], off
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b96 off, v[2:4], null
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_b96 off, v[2:4], s3
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x03,0x00]

scratch_store_b96 off, v[2:4], s105
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x69,0x00]

scratch_store_b96 off, v[2:4], vcc_lo
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_b96 off, v[2:4], vcc_hi
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_b96 off, v[2:4], ttmp15
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_b96 v1, v[2:4], off
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b96 v255, v[2:4], off
// GFX11: [0x00,0x00,0x71,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b96 v1, v[2:4], null
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_b96 v255, v[2:4], null
// GFX11: [0x00,0x00,0x71,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_b96 v1, v[2:4], s3
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0x83,0x00]

scratch_store_b96 v1, v[2:4], s105
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_b96 v1, v[2:4], vcc_lo
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xea,0x00]

scratch_store_b96 v1, v[2:4], vcc_hi
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_b96 v1, v[2:4], ttmp15
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_b96 v255, v[2:4], s3
// GFX11: [0x00,0x00,0x71,0xdc,0xff,0x02,0x83,0x00]

scratch_store_b96 v255, v[2:4], s105 offset:-1
// GFX11: [0xff,0x1f,0x71,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_b96 v255, v[2:4], vcc_lo offset:0
// GFX11: [0x00,0x00,0x71,0xdc,0xff,0x02,0xea,0x00]

scratch_store_b96 v255, v[2:4], vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x71,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_b96 v255, v[253:255], ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x71,0xdc,0xff,0xfd,0xfb,0x00]

scratch_store_byte off, v2, off
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_byte off, v2, null
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_byte off, v2, s3
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte off, v2, s105
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x69,0x00]

scratch_store_byte off, v2, vcc_lo
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_byte off, v2, vcc_hi
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_byte off, v2, ttmp15
// GFX11: [0x00,0x00,0x61,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_byte v1, v2, off
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_byte v255, v2, off
// GFX11: [0x00,0x00,0x61,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_byte v1, v2, null
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_byte v255, v2, null
// GFX11: [0x00,0x00,0x61,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_byte v1, v2, s3
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0x83,0x00]

scratch_store_byte v1, v2, s105
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_byte v1, v2, vcc_lo
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xea,0x00]

scratch_store_byte v1, v2, vcc_hi
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_byte v1, v2, ttmp15
// GFX11: [0x00,0x00,0x61,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_byte v255, v2, s3
// GFX11: [0x00,0x00,0x61,0xdc,0xff,0x02,0x83,0x00]

scratch_store_byte v255, v2, s105 offset:-1
// GFX11: [0xff,0x1f,0x61,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_byte v255, v2, vcc_lo offset:0
// GFX11: [0x00,0x00,0x61,0xdc,0xff,0x02,0xea,0x00]

scratch_store_byte v255, v2, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x61,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_byte v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x61,0xdc,0xff,0xff,0xfb,0x00]

scratch_store_d16_hi_b16 off, v2, off
// GFX11: [0x00,0x00,0x95,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_d16_hi_b16 off, v2, null
// GFX11: [0x00,0x00,0x95,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_d16_hi_b16 off, v2, s3
// GFX11: [0x00,0x00,0x95,0xdc,0x00,0x02,0x03,0x00]

scratch_store_d16_hi_b16 off, v2, s105
// GFX11: [0x00,0x00,0x95,0xdc,0x00,0x02,0x69,0x00]

scratch_store_d16_hi_b16 off, v2, vcc_lo
// GFX11: [0x00,0x00,0x95,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_d16_hi_b16 off, v2, vcc_hi
// GFX11: [0x00,0x00,0x95,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_d16_hi_b16 off, v2, ttmp15
// GFX11: [0x00,0x00,0x95,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_d16_hi_b16 v1, v2, off
// GFX11: [0x00,0x00,0x95,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_d16_hi_b16 v255, v2, off
// GFX11: [0x00,0x00,0x95,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_d16_hi_b16 v1, v2, null
// GFX11: [0x00,0x00,0x95,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_d16_hi_b16 v255, v2, null
// GFX11: [0x00,0x00,0x95,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_d16_hi_b16 v1, v2, s3
// GFX11: [0x00,0x00,0x95,0xdc,0x01,0x02,0x83,0x00]

scratch_store_d16_hi_b16 v1, v2, s105
// GFX11: [0x00,0x00,0x95,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_d16_hi_b16 v1, v2, vcc_lo
// GFX11: [0x00,0x00,0x95,0xdc,0x01,0x02,0xea,0x00]

scratch_store_d16_hi_b16 v1, v2, vcc_hi
// GFX11: [0x00,0x00,0x95,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_d16_hi_b16 v1, v2, ttmp15
// GFX11: [0x00,0x00,0x95,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_d16_hi_b16 v255, v2, s3
// GFX11: [0x00,0x00,0x95,0xdc,0xff,0x02,0x83,0x00]

scratch_store_d16_hi_b16 v255, v2, s105 offset:-1
// GFX11: [0xff,0x1f,0x95,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_d16_hi_b16 v255, v2, vcc_lo offset:0
// GFX11: [0x00,0x00,0x95,0xdc,0xff,0x02,0xea,0x00]

scratch_store_d16_hi_b16 v255, v2, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x95,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_d16_hi_b16 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x95,0xdc,0xff,0xff,0xfb,0x00]

scratch_store_d16_hi_b8 off, v2, off
// GFX11: [0x00,0x00,0x91,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_d16_hi_b8 off, v2, null
// GFX11: [0x00,0x00,0x91,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_d16_hi_b8 off, v2, s3
// GFX11: [0x00,0x00,0x91,0xdc,0x00,0x02,0x03,0x00]

scratch_store_d16_hi_b8 off, v2, s105
// GFX11: [0x00,0x00,0x91,0xdc,0x00,0x02,0x69,0x00]

scratch_store_d16_hi_b8 off, v2, vcc_lo
// GFX11: [0x00,0x00,0x91,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_d16_hi_b8 off, v2, vcc_hi
// GFX11: [0x00,0x00,0x91,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_d16_hi_b8 off, v2, ttmp15
// GFX11: [0x00,0x00,0x91,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_d16_hi_b8 v1, v2, off
// GFX11: [0x00,0x00,0x91,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_d16_hi_b8 v255, v2, off
// GFX11: [0x00,0x00,0x91,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_d16_hi_b8 v1, v2, null
// GFX11: [0x00,0x00,0x91,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_d16_hi_b8 v255, v2, null
// GFX11: [0x00,0x00,0x91,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_d16_hi_b8 v1, v2, s3
// GFX11: [0x00,0x00,0x91,0xdc,0x01,0x02,0x83,0x00]

scratch_store_d16_hi_b8 v1, v2, s105
// GFX11: [0x00,0x00,0x91,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_d16_hi_b8 v1, v2, vcc_lo
// GFX11: [0x00,0x00,0x91,0xdc,0x01,0x02,0xea,0x00]

scratch_store_d16_hi_b8 v1, v2, vcc_hi
// GFX11: [0x00,0x00,0x91,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_d16_hi_b8 v1, v2, ttmp15
// GFX11: [0x00,0x00,0x91,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_d16_hi_b8 v255, v2, s3
// GFX11: [0x00,0x00,0x91,0xdc,0xff,0x02,0x83,0x00]

scratch_store_d16_hi_b8 v255, v2, s105 offset:-1
// GFX11: [0xff,0x1f,0x91,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_d16_hi_b8 v255, v2, vcc_lo offset:0
// GFX11: [0x00,0x00,0x91,0xdc,0xff,0x02,0xea,0x00]

scratch_store_d16_hi_b8 v255, v2, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x91,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_d16_hi_b8 v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x91,0xdc,0xff,0xff,0xfb,0x00]

scratch_store_dword off, v2, off
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_dword off, v2, null
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_dword off, v2, s3
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dword off, v2, s105
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x69,0x00]

scratch_store_dword off, v2, vcc_lo
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_dword off, v2, vcc_hi
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_dword off, v2, ttmp15
// GFX11: [0x00,0x00,0x69,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_dword v1, v2, off
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_dword v255, v2, off
// GFX11: [0x00,0x00,0x69,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_dword v1, v2, null
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_dword v255, v2, null
// GFX11: [0x00,0x00,0x69,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_dword v1, v2, s3
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0x83,0x00]

scratch_store_dword v1, v2, s105
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_dword v1, v2, vcc_lo
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xea,0x00]

scratch_store_dword v1, v2, vcc_hi
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_dword v1, v2, ttmp15
// GFX11: [0x00,0x00,0x69,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_dword v255, v2, s3
// GFX11: [0x00,0x00,0x69,0xdc,0xff,0x02,0x83,0x00]

scratch_store_dword v255, v2, s105 offset:-1
// GFX11: [0xff,0x1f,0x69,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_dword v255, v2, vcc_lo offset:0
// GFX11: [0x00,0x00,0x69,0xdc,0xff,0x02,0xea,0x00]

scratch_store_dword v255, v2, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x69,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_dword v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x69,0xdc,0xff,0xff,0xfb,0x00]

scratch_store_dwordx2 off, v[2:3], off
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_dwordx2 off, v[2:3], null
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_dwordx2 off, v[2:3], s3
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx2 off, v[2:3], s105
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x69,0x00]

scratch_store_dwordx2 off, v[2:3], vcc_lo
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_dwordx2 off, v[2:3], vcc_hi
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_dwordx2 off, v[2:3], ttmp15
// GFX11: [0x00,0x00,0x6d,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_dwordx2 v1, v[2:3], off
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_dwordx2 v255, v[2:3], off
// GFX11: [0x00,0x00,0x6d,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_dwordx2 v1, v[2:3], null
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_dwordx2 v255, v[2:3], null
// GFX11: [0x00,0x00,0x6d,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_dwordx2 v1, v[2:3], s3
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0x83,0x00]

scratch_store_dwordx2 v1, v[2:3], s105
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_dwordx2 v1, v[2:3], vcc_lo
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xea,0x00]

scratch_store_dwordx2 v1, v[2:3], vcc_hi
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_dwordx2 v1, v[2:3], ttmp15
// GFX11: [0x00,0x00,0x6d,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_dwordx2 v255, v[2:3], s3
// GFX11: [0x00,0x00,0x6d,0xdc,0xff,0x02,0x83,0x00]

scratch_store_dwordx2 v255, v[2:3], s105 offset:-1
// GFX11: [0xff,0x1f,0x6d,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_dwordx2 v255, v[2:3], vcc_lo offset:0
// GFX11: [0x00,0x00,0x6d,0xdc,0xff,0x02,0xea,0x00]

scratch_store_dwordx2 v255, v[2:3], vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x6d,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_dwordx2 v255, v[254:255], ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x6d,0xdc,0xff,0xfe,0xfb,0x00]

scratch_store_dwordx3 off, v[2:4], off
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_dwordx3 off, v[2:4], null
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_dwordx3 off, v[2:4], s3
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx3 off, v[2:4], s105
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x69,0x00]

scratch_store_dwordx3 off, v[2:4], vcc_lo
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_dwordx3 off, v[2:4], vcc_hi
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_dwordx3 off, v[2:4], ttmp15
// GFX11: [0x00,0x00,0x71,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_dwordx3 v1, v[2:4], off
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_dwordx3 v255, v[2:4], off
// GFX11: [0x00,0x00,0x71,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_dwordx3 v1, v[2:4], null
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_dwordx3 v255, v[2:4], null
// GFX11: [0x00,0x00,0x71,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_dwordx3 v1, v[2:4], s3
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0x83,0x00]

scratch_store_dwordx3 v1, v[2:4], s105
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_dwordx3 v1, v[2:4], vcc_lo
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xea,0x00]

scratch_store_dwordx3 v1, v[2:4], vcc_hi
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_dwordx3 v1, v[2:4], ttmp15
// GFX11: [0x00,0x00,0x71,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_dwordx3 v255, v[2:4], s3
// GFX11: [0x00,0x00,0x71,0xdc,0xff,0x02,0x83,0x00]

scratch_store_dwordx3 v255, v[2:4], s105 offset:-1
// GFX11: [0xff,0x1f,0x71,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_dwordx3 v255, v[2:4], vcc_lo offset:0
// GFX11: [0x00,0x00,0x71,0xdc,0xff,0x02,0xea,0x00]

scratch_store_dwordx3 v255, v[2:4], vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x71,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_dwordx3 v255, v[253:255], ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x71,0xdc,0xff,0xfd,0xfb,0x00]

scratch_store_dwordx4 off, v[2:5], off
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_dwordx4 off, v[2:5], null
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_dwordx4 off, v[2:5], s3
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx4 off, v[2:5], s105
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x69,0x00]

scratch_store_dwordx4 off, v[2:5], vcc_lo
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_dwordx4 off, v[2:5], vcc_hi
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_dwordx4 off, v[2:5], ttmp15
// GFX11: [0x00,0x00,0x75,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_dwordx4 v1, v[2:5], off
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_dwordx4 v255, v[2:5], off
// GFX11: [0x00,0x00,0x75,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_dwordx4 v1, v[2:5], null
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_dwordx4 v255, v[2:5], null
// GFX11: [0x00,0x00,0x75,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_dwordx4 v1, v[2:5], s3
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0x83,0x00]

scratch_store_dwordx4 v1, v[2:5], s105
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_dwordx4 v1, v[2:5], vcc_lo
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xea,0x00]

scratch_store_dwordx4 v1, v[2:5], vcc_hi
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_dwordx4 v1, v[2:5], ttmp15
// GFX11: [0x00,0x00,0x75,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_dwordx4 v255, v[2:5], s3
// GFX11: [0x00,0x00,0x75,0xdc,0xff,0x02,0x83,0x00]

scratch_store_dwordx4 v255, v[2:5], s105 offset:-1
// GFX11: [0xff,0x1f,0x75,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_dwordx4 v255, v[2:5], vcc_lo offset:0
// GFX11: [0x00,0x00,0x75,0xdc,0xff,0x02,0xea,0x00]

scratch_store_dwordx4 v255, v[2:5], vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x75,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_dwordx4 v255, v[252:255], ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x75,0xdc,0xff,0xfc,0xfb,0x00]

scratch_store_short off, v2, off
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_short off, v2, null
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x7c,0x00]

scratch_store_short off, v2, s3
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short off, v2, s105
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x69,0x00]

scratch_store_short off, v2, vcc_lo
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_short off, v2, vcc_hi
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_short off, v2, ttmp15
// GFX11: [0x00,0x00,0x65,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_short v1, v2, off
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_short v255, v2, off
// GFX11: [0x00,0x00,0x65,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_short v1, v2, null
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xfc,0x00]

scratch_store_short v255, v2, null
// GFX11: [0x00,0x00,0x65,0xdc,0xff,0x02,0xfc,0x00]

scratch_store_short v1, v2, s3
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0x83,0x00]

scratch_store_short v1, v2, s105
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xe9,0x00]

scratch_store_short v1, v2, vcc_lo
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xea,0x00]

scratch_store_short v1, v2, vcc_hi
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xeb,0x00]

scratch_store_short v1, v2, ttmp15
// GFX11: [0x00,0x00,0x65,0xdc,0x01,0x02,0xfb,0x00]

scratch_store_short v255, v2, s3
// GFX11: [0x00,0x00,0x65,0xdc,0xff,0x02,0x83,0x00]

scratch_store_short v255, v2, s105 offset:-1
// GFX11: [0xff,0x1f,0x65,0xdc,0xff,0x02,0xe9,0x00]

scratch_store_short v255, v2, vcc_lo offset:0
// GFX11: [0x00,0x00,0x65,0xdc,0xff,0x02,0xea,0x00]

scratch_store_short v255, v2, vcc_hi offset:4095
// GFX11: [0xff,0x0f,0x65,0xdc,0xff,0x02,0xeb,0x00]

scratch_store_short v255, v255, ttmp15 offset:-4096 glc slc dlc
// GFX11: [0x00,0xf0,0x65,0xdc,0xff,0xff,0xfb,0x00]
