/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs

#define yylval          base_yylval
#define yychar          base_yychar
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */
#line 5 "preproc.y" /* yacc.c:339  */

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, base_yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (base_yyin)
				fclose(base_yyin);
			if (base_yyout)
				fclose(base_yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
				fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(base_yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essentially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}

#line 630 "preproc.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "preproc.h".  */
#ifndef YY_BASE_YY_PREPROC_H_INCLUDED
# define YY_BASE_YY_PREPROC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int base_yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    SQL_ALLOCATE = 258,
    SQL_AUTOCOMMIT = 259,
    SQL_BOOL = 260,
    SQL_BREAK = 261,
    SQL_CALL = 262,
    SQL_CARDINALITY = 263,
    SQL_CONNECT = 264,
    SQL_COUNT = 265,
    SQL_DATETIME_INTERVAL_CODE = 266,
    SQL_DATETIME_INTERVAL_PRECISION = 267,
    SQL_DESCRIBE = 268,
    SQL_DESCRIPTOR = 269,
    SQL_DISCONNECT = 270,
    SQL_FOUND = 271,
    SQL_FREE = 272,
    SQL_GET = 273,
    SQL_GO = 274,
    SQL_GOTO = 275,
    SQL_IDENTIFIED = 276,
    SQL_INDICATOR = 277,
    SQL_KEY_MEMBER = 278,
    SQL_LENGTH = 279,
    SQL_LONG = 280,
    SQL_NULLABLE = 281,
    SQL_OCTET_LENGTH = 282,
    SQL_OPEN = 283,
    SQL_OUTPUT = 284,
    SQL_REFERENCE = 285,
    SQL_RETURNED_LENGTH = 286,
    SQL_RETURNED_OCTET_LENGTH = 287,
    SQL_SCALE = 288,
    SQL_SECTION = 289,
    SQL_SHORT = 290,
    SQL_SIGNED = 291,
    SQL_SQL = 292,
    SQL_SQLERROR = 293,
    SQL_SQLPRINT = 294,
    SQL_SQLWARNING = 295,
    SQL_START = 296,
    SQL_STOP = 297,
    SQL_STRUCT = 298,
    SQL_UNSIGNED = 299,
    SQL_VAR = 300,
    SQL_WHENEVER = 301,
    S_ADD = 302,
    S_AND = 303,
    S_ANYTHING = 304,
    S_AUTO = 305,
    S_CONST = 306,
    S_DEC = 307,
    S_DIV = 308,
    S_DOTPOINT = 309,
    S_EQUAL = 310,
    S_EXTERN = 311,
    S_INC = 312,
    S_LSHIFT = 313,
    S_MEMPOINT = 314,
    S_MEMBER = 315,
    S_MOD = 316,
    S_MUL = 317,
    S_NEQUAL = 318,
    S_OR = 319,
    S_REGISTER = 320,
    S_RSHIFT = 321,
    S_STATIC = 322,
    S_SUB = 323,
    S_VOLATILE = 324,
    S_TYPEDEF = 325,
    CSTRING = 326,
    CVARIABLE = 327,
    CPP_LINE = 328,
    IP = 329,
    DOLCONST = 330,
    ECONST = 331,
    NCONST = 332,
    UCONST = 333,
    UIDENT = 334,
    IDENT = 335,
    FCONST = 336,
    SCONST = 337,
    BCONST = 338,
    XCONST = 339,
    Op = 340,
    ICONST = 341,
    PARAM = 342,
    TYPECAST = 343,
    DOT_DOT = 344,
    COLON_EQUALS = 345,
    ABORT_P = 346,
    ABSOLUTE_P = 347,
    ACCESS = 348,
    ACTION = 349,
    ADD_P = 350,
    ADMIN = 351,
    AFTER = 352,
    AGGREGATE = 353,
    ALL = 354,
    ALSO = 355,
    ALTER = 356,
    ALWAYS = 357,
    ANALYSE = 358,
    ANALYZE = 359,
    AND = 360,
    ANY = 361,
    ARRAY = 362,
    AS = 363,
    ASC = 364,
    ASSERTION = 365,
    ASSIGNMENT = 366,
    ASYMMETRIC = 367,
    AT = 368,
    ATTRIBUTE = 369,
    AUTHORIZATION = 370,
    BACKWARD = 371,
    BEFORE = 372,
    BEGIN_P = 373,
    BETWEEN = 374,
    BIGINT = 375,
    BINARY = 376,
    BIT = 377,
    BOOLEAN_P = 378,
    BOTH = 379,
    BY = 380,
    CACHE = 381,
    CALLED = 382,
    CASCADE = 383,
    CASCADED = 384,
    CASE = 385,
    CAST = 386,
    CATALOG_P = 387,
    CHAIN = 388,
    CHAR_P = 389,
    CHARACTER = 390,
    CHARACTERISTICS = 391,
    CHECK = 392,
    CHECKPOINT = 393,
    CLASS = 394,
    CLOSE = 395,
    CLUSTER = 396,
    COALESCE = 397,
    COLLATE = 398,
    COLLATION = 399,
    COLUMN = 400,
    COMMENT = 401,
    COMMENTS = 402,
    COMMIT = 403,
    COMMITTED = 404,
    CONCURRENTLY = 405,
    CONFIGURATION = 406,
    CONNECTION = 407,
    CONSTRAINT = 408,
    CONSTRAINTS = 409,
    CONTENT_P = 410,
    CONTINUE_P = 411,
    CONVERSION_P = 412,
    COPY = 413,
    COST = 414,
    CREATE = 415,
    CROSS = 416,
    CSV = 417,
    CURRENT_P = 418,
    CURRENT_CATALOG = 419,
    CURRENT_DATE = 420,
    CURRENT_ROLE = 421,
    CURRENT_SCHEMA = 422,
    CURRENT_TIME = 423,
    CURRENT_TIMESTAMP = 424,
    CURRENT_USER = 425,
    CURSOR = 426,
    CYCLE = 427,
    DATA_P = 428,
    DATABASE = 429,
    DAY_P = 430,
    DEALLOCATE = 431,
    DEC = 432,
    DECIMAL_P = 433,
    DECLARE = 434,
    DEFAULT = 435,
    DEFAULTS = 436,
    DEFERRABLE = 437,
    DEFERRED = 438,
    DEFINER = 439,
    DELETE_P = 440,
    DELIMITER = 441,
    DELIMITERS = 442,
    DESC = 443,
    DICTIONARY = 444,
    DISABLE_P = 445,
    DISCARD = 446,
    DISTINCT = 447,
    DO = 448,
    DOCUMENT_P = 449,
    DOMAIN_P = 450,
    DOUBLE_P = 451,
    DROP = 452,
    EACH = 453,
    ELSE = 454,
    ENABLE_P = 455,
    ENCODING = 456,
    ENCRYPTED = 457,
    END_P = 458,
    ENUM_P = 459,
    ESCAPE = 460,
    EXCEPT = 461,
    EXCLUDE = 462,
    EXCLUDING = 463,
    EXCLUSIVE = 464,
    EXECUTE = 465,
    EXISTS = 466,
    EXPLAIN = 467,
    EXTENSION = 468,
    EXTERNAL = 469,
    EXTRACT = 470,
    FALSE_P = 471,
    FAMILY = 472,
    FETCH = 473,
    FIRST_P = 474,
    FLOAT_P = 475,
    FOLLOWING = 476,
    FOR = 477,
    FORCE = 478,
    FOREIGN = 479,
    FORWARD = 480,
    FREEZE = 481,
    FROM = 482,
    FULL = 483,
    FUNCTION = 484,
    FUNCTIONS = 485,
    GLOBAL = 486,
    GRANT = 487,
    GRANTED = 488,
    GREATEST = 489,
    GROUP_P = 490,
    HANDLER = 491,
    HAVING = 492,
    HEADER_P = 493,
    HOLD = 494,
    HOUR_P = 495,
    IDENTITY_P = 496,
    IF_P = 497,
    ILIKE = 498,
    IMMEDIATE = 499,
    IMMUTABLE = 500,
    IMPLICIT_P = 501,
    IN_P = 502,
    INCLUDING = 503,
    INCREMENT = 504,
    INDEX = 505,
    INDEXES = 506,
    INHERIT = 507,
    INHERITS = 508,
    INITIALLY = 509,
    INLINE_P = 510,
    INNER_P = 511,
    INOUT = 512,
    INPUT_P = 513,
    INSENSITIVE = 514,
    INSERT = 515,
    INSTEAD = 516,
    INT_P = 517,
    INTEGER = 518,
    INTERSECT = 519,
    INTERVAL = 520,
    INTO = 521,
    INVOKER = 522,
    IS = 523,
    ISNULL = 524,
    ISOLATION = 525,
    JOIN = 526,
    KEY = 527,
    LABEL = 528,
    LANGUAGE = 529,
    LARGE_P = 530,
    LAST_P = 531,
    LC_COLLATE_P = 532,
    LC_CTYPE_P = 533,
    LEADING = 534,
    LEAKPROOF = 535,
    LEAST = 536,
    LEFT = 537,
    LEVEL = 538,
    LIKE = 539,
    LIMIT = 540,
    LISTEN = 541,
    LOAD = 542,
    LOCAL = 543,
    LOCALTIME = 544,
    LOCALTIMESTAMP = 545,
    LOCATION = 546,
    LOCK_P = 547,
    MAPPING = 548,
    MATCH = 549,
    MAXVALUE = 550,
    MINUTE_P = 551,
    MINVALUE = 552,
    MODE = 553,
    MONTH_P = 554,
    MOVE = 555,
    NAME_P = 556,
    NAMES = 557,
    NATIONAL = 558,
    NATURAL = 559,
    NCHAR = 560,
    NEXT = 561,
    NO = 562,
    NONE = 563,
    NOT = 564,
    NOTHING = 565,
    NOTIFY = 566,
    NOTNULL = 567,
    NOWAIT = 568,
    NULL_P = 569,
    NULLIF = 570,
    NULLS_P = 571,
    NUMERIC = 572,
    OBJECT_P = 573,
    OF = 574,
    OFF = 575,
    OFFSET = 576,
    OIDS = 577,
    ON = 578,
    ONLY = 579,
    OPERATOR = 580,
    OPTION = 581,
    OPTIONS = 582,
    OR = 583,
    ORDER = 584,
    OUT_P = 585,
    OUTER_P = 586,
    OVER = 587,
    OVERLAPS = 588,
    OVERLAY = 589,
    OWNED = 590,
    OWNER = 591,
    PARSER = 592,
    PARTIAL = 593,
    PARTITION = 594,
    PASSING = 595,
    PASSWORD = 596,
    PLACING = 597,
    PLANS = 598,
    POSITION = 599,
    PRECEDING = 600,
    PRECISION = 601,
    PRESERVE = 602,
    PREPARE = 603,
    PREPARED = 604,
    PRIMARY = 605,
    PRIOR = 606,
    PRIVILEGES = 607,
    PROCEDURAL = 608,
    PROCEDURE = 609,
    QUOTE = 610,
    RANGE = 611,
    READ = 612,
    REAL = 613,
    REASSIGN = 614,
    RECHECK = 615,
    RECURSIVE = 616,
    REF = 617,
    REFERENCES = 618,
    REINDEX = 619,
    RELATIVE_P = 620,
    RELEASE = 621,
    RENAME = 622,
    REPEATABLE = 623,
    REPLACE = 624,
    REPLICA = 625,
    RESET = 626,
    RESTART = 627,
    RESTRICT = 628,
    RETURNING = 629,
    RETURNS = 630,
    REVOKE = 631,
    RIGHT = 632,
    ROLE = 633,
    ROLLBACK = 634,
    ROW = 635,
    ROWS = 636,
    RULE = 637,
    SAVEPOINT = 638,
    SCHEMA = 639,
    SCROLL = 640,
    SEARCH = 641,
    SECOND_P = 642,
    SECURITY = 643,
    SELECT = 644,
    SEQUENCE = 645,
    SEQUENCES = 646,
    SERIALIZABLE = 647,
    SERVER = 648,
    SESSION = 649,
    SESSION_USER = 650,
    SET = 651,
    SETOF = 652,
    SHARE = 653,
    SHOW = 654,
    SIMILAR = 655,
    SIMPLE = 656,
    SMALLINT = 657,
    SNAPSHOT = 658,
    SOME = 659,
    STABLE = 660,
    STANDALONE_P = 661,
    START = 662,
    STATEMENT = 663,
    STATISTICS = 664,
    STDIN = 665,
    STDOUT = 666,
    STORAGE = 667,
    STRICT_P = 668,
    STRIP_P = 669,
    SUBSTRING = 670,
    SYMMETRIC = 671,
    SYSID = 672,
    SYSTEM_P = 673,
    TABLE = 674,
    TABLES = 675,
    TABLESPACE = 676,
    TEMP = 677,
    TEMPLATE = 678,
    TEMPORARY = 679,
    TEXT_P = 680,
    THEN = 681,
    TIME = 682,
    TIMESTAMP = 683,
    TO = 684,
    TRAILING = 685,
    TRANSACTION = 686,
    TREAT = 687,
    TRIGGER = 688,
    TRIM = 689,
    TRUE_P = 690,
    TRUNCATE = 691,
    TRUSTED = 692,
    TYPE_P = 693,
    TYPES_P = 694,
    UNBOUNDED = 695,
    UNCOMMITTED = 696,
    UNENCRYPTED = 697,
    UNION = 698,
    UNIQUE = 699,
    UNKNOWN = 700,
    UNLISTEN = 701,
    UNLOGGED = 702,
    UNTIL = 703,
    UPDATE = 704,
    USER = 705,
    USING = 706,
    VACUUM = 707,
    VALID = 708,
    VALIDATE = 709,
    VALIDATOR = 710,
    VALUE_P = 711,
    VALUES = 712,
    VARCHAR = 713,
    VARIADIC = 714,
    VARYING = 715,
    VERBOSE = 716,
    VERSION_P = 717,
    VIEW = 718,
    VOLATILE = 719,
    WHEN = 720,
    WHERE = 721,
    WHITESPACE_P = 722,
    WINDOW = 723,
    WITH = 724,
    WITHOUT = 725,
    WORK = 726,
    WRAPPER = 727,
    WRITE = 728,
    XML_P = 729,
    XMLATTRIBUTES = 730,
    XMLCONCAT = 731,
    XMLELEMENT = 732,
    XMLEXISTS = 733,
    XMLFOREST = 734,
    XMLPARSE = 735,
    XMLPI = 736,
    XMLROOT = 737,
    XMLSERIALIZE = 738,
    YEAR_P = 739,
    YES_P = 740,
    ZONE = 741,
    NULLS_FIRST = 742,
    NULLS_LAST = 743,
    WITH_TIME = 744,
    POSTFIXOP = 745,
    UMINUS = 746
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 564 "preproc.y" /* yacc.c:355  */

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;

#line 1177 "preproc.c" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


extern YYSTYPE base_yylval;
extern YYLTYPE base_yylloc;
int base_yyparse (void);

#endif /* !YY_BASE_YY_PREPROC_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 1206 "preproc.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   106186

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  511
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  689
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2737
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4955

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   746

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   498,     2,     2,
     503,   504,   496,   494,   506,   495,   505,   497,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   508,   507,
     491,   490,   492,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   501,     2,   502,   499,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   509,     2,   510,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   493,   500
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1467,  1467,  1470,  1472,  1474,  1476,  1478,  1480,  1482,
    1484,  1486,  1488,  1490,  1492,  1494,  1496,  1498,  1500,  1502,
    1504,  1506,  1508,  1510,  1512,  1514,  1516,  1518,  1520,  1522,
    1540,  1542,  1544,  1546,  1548,  1550,  1552,  1554,  1556,  1558,
    1560,  1562,  1564,  1566,  1568,  1570,  1572,  1574,  1576,  1578,
    1580,  1582,  1584,  1586,  1588,  1590,  1592,  1594,  1596,  1600,
    1602,  1604,  1606,  1608,  1610,  1612,  1614,  1616,  1618,  1620,
    1622,  1624,  1626,  1628,  1630,  1632,  1634,  1636,  1638,  1640,
    1642,  1644,  1646,  1648,  1650,  1652,  1654,  1656,  1658,  1660,
    1662,  1664,  1666,  1673,  1675,  1677,  1679,  1681,  1683,  1685,
    1687,  1689,  1691,  1693,  1695,  1701,  1703,  1705,  1707,  1709,
    1711,  1713,  1715,  1717,  1723,  1733,  1737,  1743,  1747,  1757,
    1767,  1768,  1782,  1789,  1795,  1806,  1812,  1821,  1828,  1834,
    1843,  1850,  1858,  1863,  1871,  1876,  1882,  1887,  1893,  1898,
    1904,  1908,  1912,  1916,  1920,  1924,  1928,  1932,  1936,  1944,
    1948,  1952,  1956,  1960,  1964,  1972,  1980,  1989,  1991,  1999,
    2007,  2015,  2023,  2027,  2035,  2039,  2047,  2055,  2063,  2067,
    2075,  2079,  2087,  2091,  2099,  2104,  2110,  2115,  2121,  2125,
    2129,  2133,  2137,  2141,  2149,  2153,  2157,  2165,  2169,  2173,
    2181,  2185,  2189,  2193,  2197,  2201,  2205,  2210,  2214,  2218,
    2222,  2226,  2230,  2234,  2242,  2246,  2254,  2258,  2266,  2270,
    2284,  2288,  2292,  2296,  2304,  2308,  2312,  2316,  2324,  2328,
    2332,  2336,  2340,  2344,  2348,  2356,  2360,  2365,  2371,  2375,
    2383,  2387,  2391,  2395,  2399,  2407,  2411,  2419,  2423,  2431,
    2435,  2439,  2443,  2447,  2456,  2464,  2468,  2476,  2480,  2488,
    2496,  2500,  2504,  2508,  2516,  2520,  2524,  2528,  2532,  2536,
    2540,  2544,  2552,  2556,  2564,  2568,  2572,  2576,  2580,  2584,
    2588,  2592,  2596,  2600,  2604,  2608,  2612,  2616,  2620,  2624,
    2628,  2632,  2636,  2640,  2644,  2648,  2652,  2656,  2660,  2664,
    2668,  2672,  2676,  2680,  2684,  2688,  2692,  2696,  2700,  2704,
    2708,  2712,  2716,  2720,  2724,  2728,  2736,  2740,  2748,  2752,
    2757,  2763,  2768,  2774,  2779,  2785,  2793,  2798,  2804,  2808,
    2816,  2820,  2824,  2828,  2836,  2844,  2848,  2856,  2860,  2864,
    2868,  2876,  2881,  2889,  2900,  2911,  2915,  2923,  2927,  2931,
    2939,  2943,  2951,  2956,  2962,  2966,  2970,  2974,  2978,  2982,
    2986,  2990,  2994,  2998,  3002,  3006,  3014,  3019,  3025,  3030,
    3036,  3041,  3047,  3052,  3058,  3062,  3070,  3078,  3082,  3086,
    3090,  3095,  3101,  3105,  3113,  3121,  3125,  3129,  3133,  3141,
    3145,  3149,  3153,  3157,  3161,  3165,  3170,  3176,  3181,  3187,
    3192,  3198,  3202,  3210,  3214,  3222,  3226,  3230,  3238,  3242,
    3250,  3258,  3266,  3271,  3277,  3281,  3285,  3289,  3297,  3301,
    3305,  3309,  3313,  3317,  3321,  3329,  3333,  3337,  3341,  3349,
    3357,  3361,  3366,  3372,  3376,  3380,  3384,  3388,  3392,  3400,
    3404,  3412,  3416,  3420,  3424,  3428,  3432,  3436,  3444,  3449,
    3455,  3460,  3466,  3470,  3478,  3486,  3490,  3495,  3500,  3506,
    3510,  3518,  3522,  3530,  3535,  3541,  3545,  3549,  3553,  3558,
    3564,  3572,  3580,  3584,  3588,  3592,  3596,  3604,  3609,  3615,
    3619,  3623,  3628,  3634,  3638,  3642,  3647,  3653,  3658,  3664,
    3669,  3675,  3683,  3691,  3695,  3700,  3706,  3714,  3718,  3726,
    3731,  3737,  3741,  3749,  3753,  3757,  3761,  3765,  3769,  3773,
    3777,  3781,  3785,  3789,  3793,  3801,  3806,  3812,  3816,  3820,
    3824,  3832,  3836,  3844,  3848,  3856,  3861,  3867,  3871,  3879,
    3884,  3890,  3894,  3902,  3907,  3913,  3917,  3925,  3930,  3936,
    3944,  3949,  3955,  3959,  3967,  3971,  3979,  3984,  3990,  3994,
    3998,  4006,  4014,  4019,  4025,  4033,  4037,  4041,  4045,  4049,
    4053,  4057,  4061,  4065,  4069,  4073,  4077,  4081,  4085,  4089,
    4093,  4097,  4101,  4105,  4109,  4113,  4117,  4125,  4133,  4137,
    4141,  4145,  4153,  4157,  4165,  4170,  4176,  4180,  4188,  4192,
    4200,  4205,  4211,  4215,  4223,  4231,  4235,  4243,  4247,  4251,
    4255,  4263,  4271,  4279,  4287,  4295,  4300,  4306,  4310,  4318,
    4323,  4329,  4333,  4341,  4345,  4349,  4357,  4361,  4369,  4373,
    4381,  4385,  4393,  4401,  4405,  4413,  4421,  4425,  4429,  4437,
    4441,  4449,  4457,  4461,  4469,  4473,  4477,  4485,  4489,  4497,
    4501,  4505,  4509,  4513,  4521,  4526,  4532,  4537,  4543,  4547,
    4555,  4560,  4566,  4570,  4575,  4581,  4585,  4589,  4593,  4601,
    4606,  4613,  4615,  4623,  4627,  4631,  4635,  4639,  4643,  4651,
    4655,  4663,  4672,  4681,  4685,  4689,  4693,  4697,  4701,  4705,
    4709,  4713,  4717,  4721,  4725,  4729,  4733,  4741,  4749,  4753,
    4761,  4765,  4773,  4777,  4781,  4785,  4789,  4797,  4801,  4809,
    4817,  4821,  4829,  4837,  4842,  4848,  4852,  4860,  4864,  4868,
    4876,  4884,  4888,  4896,  4900,  4904,  4908,  4912,  4920,  4925,
    4931,  4936,  4942,  4946,  4951,  4957,  4963,  4969,  4977,  4981,
    4989,  4993,  5001,  5005,  5013,  5017,  5025,  5029,  5037,  5045,
    5053,  5057,  5061,  5065,  5073,  5077,  5081,  5085,  5089,  5093,
    5097,  5101,  5105,  5109,  5113,  5117,  5121,  5125,  5129,  5137,
    5141,  5149,  5153,  5161,  5165,  5173,  5181,  5185,  5190,  5196,
    5200,  5204,  5208,  5212,  5216,  5220,  5224,  5228,  5232,  5236,
    5240,  5244,  5248,  5252,  5256,  5260,  5268,  5272,  5276,  5280,
    5284,  5288,  5292,  5296,  5300,  5304,  5308,  5312,  5316,  5320,
    5324,  5328,  5332,  5340,  5344,  5352,  5356,  5360,  5364,  5368,
    5376,  5381,  5387,  5391,  5395,  5399,  5403,  5407,  5411,  5415,
    5419,  5423,  5427,  5435,  5439,  5447,  5451,  5455,  5459,  5465,
    5471,  5477,  5483,  5489,  5495,  5501,  5511,  5522,  5533,  5544,
    5555,  5566,  5577,  5593,  5609,  5625,  5636,  5652,  5663,  5679,
    5694,  5698,  5706,  5711,  5717,  5725,  5729,  5737,  5741,  5745,
    5749,  5753,  5761,  5765,  5773,  5777,  5781,  5785,  5793,  5797,
    5801,  5805,  5809,  5813,  5817,  5821,  5825,  5829,  5833,  5837,
    5841,  5845,  5849,  5853,  5861,  5865,  5873,  5877,  5885,  5890,
    5896,  5900,  5908,  5916,  5924,  5928,  5936,  5941,  5947,  5952,
    5958,  5966,  5971,  5977,  5981,  5985,  5993,  5997,  6001,  6009,
    6013,  6017,  6021,  6029,  6037,  6042,  6048,  6053,  6059,  6064,
    6070,  6075,  6081,  6085,  6093,  6097,  6101,  6109,  6114,  6120,
    6124,  6129,  6135,  6139,  6144,  6150,  6154,  6159,  6165,  6169,
    6173,  6181,  6186,  6192,  6196,  6204,  6208,  6216,  6220,  6228,
    6232,  6240,  6244,  6248,  6252,  6256,  6264,  6268,  6272,  6276,
    6280,  6288,  6296,  6304,  6308,  6312,  6320,  6324,  6328,  6336,
    6340,  6348,  6352,  6356,  6360,  6364,  6368,  6372,  6376,  6380,
    6384,  6388,  6392,  6396,  6400,  6404,  6412,  6416,  6420,  6424,
    6432,  6436,  6444,  6449,  6455,  6463,  6467,  6475,  6483,  6487,
    6495,  6500,  6506,  6510,  6518,  6522,  6530,  6534,  6542,  6546,
    6550,  6554,  6562,  6566,  6574,  6582,  6586,  6594,  6598,  6606,
    6610,  6614,  6622,  6626,  6631,  6637,  6645,  6650,  6656,  6660,
    6664,  6672,  6676,  6684,  6689,  6695,  6699,  6703,  6707,  6711,
    6715,  6719,  6723,  6727,  6731,  6735,  6739,  6743,  6747,  6751,
    6755,  6759,  6763,  6767,  6771,  6775,  6779,  6783,  6787,  6791,
    6795,  6799,  6803,  6807,  6811,  6815,  6819,  6823,  6827,  6831,
    6835,  6839,  6843,  6847,  6851,  6855,  6863,  6868,  6874,  6879,
    6885,  6889,  6893,  6897,  6901,  6905,  6909,  6913,  6917,  6921,
    6925,  6929,  6933,  6937,  6941,  6945,  6949,  6953,  6957,  6961,
    6965,  6969,  6977,  6981,  6985,  6989,  6993,  6997,  7001,  7005,
    7009,  7013,  7017,  7021,  7025,  7029,  7033,  7037,  7041,  7045,
    7053,  7061,  7065,  7069,  7077,  7081,  7089,  7093,  7097,  7101,
    7105,  7113,  7118,  7124,  7128,  7132,  7136,  7144,  7148,  7153,
    7159,  7163,  7171,  7179,  7184,  7190,  7198,  7202,  7210,  7214,
    7218,  7222,  7226,  7230,  7234,  7238,  7242,  7246,  7250,  7254,
    7258,  7262,  7270,  7274,  7279,  7285,  7289,  7293,  7297,  7301,
    7309,  7313,  7317,  7325,  7330,  7336,  7340,  7348,  7353,  7358,
    7364,  7370,  7378,  7386,  7391,  7397,  7401,  7405,  7409,  7413,
    7417,  7421,  7425,  7429,  7433,  7437,  7441,  7445,  7449,  7453,
    7457,  7465,  7470,  7476,  7480,  7488,  7496,  7501,  7507,  7515,
    7519,  7527,  7535,  7539,  7543,  7547,  7551,  7555,  7559,  7567,
    7572,  7578,  7586,  7590,  7594,  7598,  7602,  7606,  7614,  7622,
    7626,  7630,  7638,  7643,  7649,  7653,  7657,  7661,  7665,  7673,
    7677,  7685,  7689,  7693,  7697,  7705,  7709,  7717,  7721,  7729,
    7734,  7740,  7745,  7751,  7756,  7762,  7767,  7773,  7777,  7781,
    7785,  7793,  7797,  7801,  7805,  7809,  7813,  7817,  7825,  7829,
    7837,  7845,  7849,  7857,  7861,  7866,  7872,  7878,  7888,  7893,
    7899,  7903,  7907,  7911,  7919,  7921,  7929,  7934,  7940,  7948,
    7952,  7956,  7964,  7968,  7976,  7984,  7989,  7995,  8003,  8008,
    8014,  8022,  8027,  8033,  8037,  8041,  8045,  8049,  8053,  8057,
    8061,  8069,  8074,  8080,  8088,  8092,  8100,  8104,  8112,  8120,
    8128,  8136,  8140,  8148,  8201,  8205,  8218,  8220,  8224,  8228,
    8232,  8241,  8247,  8251,  8259,  8263,  8271,  8275,  8283,  8287,
    8291,  8295,  8299,  8303,  8307,  8311,  8319,  8323,  8331,  8335,
    8339,  8343,  8347,  8351,  8359,  8363,  8371,  8375,  8383,  8391,
    8396,  8402,  8407,  8409,  8415,  8419,  8423,  8427,  8431,  8435,
    8439,  8443,  8447,  8455,  8460,  8466,  8470,  8475,  8481,  8485,
    8489,  8494,  8500,  8505,  8511,  8519,  8523,  8531,  8535,  8543,
    8547,  8551,  8555,  8563,  8568,  8574,  8578,  8583,  8591,  8595,
    8603,  8607,  8615,  8623,  8627,  8632,  8638,  8646,  8650,  8658,
    8662,  8670,  8675,  8681,  8686,  8692,  8696,  8704,  8709,  8715,
    8719,  8727,  8731,  8739,  8744,  8750,  8754,  8762,  8767,  8773,
    8777,  8785,  8789,  8793,  8797,  8801,  8805,  8809,  8813,  8819,
    8823,  8827,  8835,  8839,  8843,  8847,  8851,  8855,  8863,  8867,
    8871,  8875,  8883,  8887,  8891,  8895,  8903,  8908,  8914,  8918,
    8926,  8930,  8934,  8938,  8946,  8950,  8958,  8962,  8966,  8974,
    8982,  8987,  8993,  8997,  9003,  9009,  9014,  9020,  9024,  9032,
    9040,  9042,  9044,  9048,  9052,  9056,  9064,  9074,  9085,  9094,
    9098,  9102,  9106,  9110,  9114,  9118,  9126,  9130,  9134,  9138,
    9146,  9150,  9158,  9163,  9169,  9173,  9177,  9181,  9185,  9189,
    9193,  9197,  9201,  9205,  9209,  9217,  9222,  9228,  9232,  9240,
    9244,  9252,  9260,  9268,  9272,  9280,  9284,  9292,  9300,  9308,
    9312,  9316,  9320,  9324,  9328,  9336,  9341,  9347,  9352,  9358,
    9362,  9366,  9370,  9378,  9386,  9390,  9395,  9401,  9405,  9409,
    9413,  9417,  9421,  9425,  9429,  9433,  9437,  9441,  9445,  9449,
    9454,  9460,  9464,  9472,  9476,  9480,  9484,  9488,  9492,  9496,
    9500,  9504,  9508,  9512,  9516,  9520,  9524,  9528,  9532,  9536,
    9540,  9544,  9548,  9552,  9556,  9560,  9564,  9568,  9572,  9576,
    9580,  9584,  9588,  9592,  9596,  9600,  9604,  9608,  9612,  9616,
    9620,  9624,  9628,  9632,  9636,  9640,  9644,  9648,  9652,  9656,
    9660,  9664,  9668,  9672,  9676,  9680,  9684,  9688,  9692,  9696,
    9701,  9705,  9713,  9717,  9721,  9725,  9729,  9733,  9737,  9741,
    9745,  9749,  9753,  9757,  9761,  9765,  9769,  9773,  9777,  9781,
    9785,  9789,  9793,  9797,  9805,  9809,  9813,  9817,  9821,  9825,
    9829,  9833,  9837,  9841,  9845,  9849,  9857,  9861,  9865,  9869,
    9873,  9877,  9881,  9885,  9889,  9893,  9897,  9901,  9905,  9909,
    9913,  9917,  9921,  9925,  9929,  9933,  9937,  9941,  9945,  9949,
    9953,  9957,  9961,  9965,  9969,  9973,  9977,  9981,  9985,  9989,
    9993,  9997, 10001, 10005, 10009, 10013, 10017, 10021, 10025, 10029,
   10033, 10037, 10041, 10045, 10049, 10053, 10061, 10065, 10073, 10077,
   10081, 10086, 10092, 10100, 10104, 10112, 10116, 10124, 10128, 10136,
   10140, 10145, 10151, 10155, 10159, 10163, 10171, 10176, 10182, 10186,
   10194, 10202, 10206, 10211, 10217, 10225, 10229, 10236, 10241, 10247,
   10252, 10257, 10263, 10267, 10275, 10279, 10283, 10287, 10291, 10299,
   10303, 10307, 10315, 10319, 10323, 10331, 10335, 10343, 10347, 10351,
   10355, 10359, 10363, 10367, 10371, 10375, 10383, 10387, 10395, 10399,
   10407, 10411, 10415, 10419, 10423, 10427, 10435, 10439, 10447, 10451,
   10459, 10463, 10471, 10475, 10483, 10487, 10491, 10499, 10503, 10511,
   10516, 10522, 10526, 10530, 10534, 10538, 10542, 10546, 10550, 10558,
   10562, 10570, 10578, 10583, 10589, 10593, 10597, 10601, 10605, 10610,
   10616, 10624, 10632, 10636, 10640, 10648, 10652, 10660, 10668, 10672,
   10680, 10688, 10693, 10699, 10704, 10710, 10714, 10722, 10726, 10730,
   10734, 10742, 10746, 10755, 10757, 10765, 10770, 10776, 10780, 10788,
   10792, 10800, 10808, 10812, 10820, 10824, 10828, 10832, 10840, 10844,
   10852, 10856, 10864, 10868, 10876, 10884, 10892, 10900, 10908, 10916,
   10924, 10928, 10936, 10940, 10944, 10948, 10952, 10956, 10960, 10964,
   10968, 10972, 10976, 10980, 10984, 10988, 10989, 10994, 11000, 11008,
   11012, 11020, 11024, 11025, 11029, 11037, 11041, 11045, 11049, 11057,
   11061, 11065, 11069, 11073, 11077, 11081, 11085, 11089, 11093, 11097,
   11101, 11105, 11109, 11113, 11117, 11121, 11125, 11129, 11133, 11137,
   11141, 11145, 11149, 11153, 11157, 11161, 11165, 11169, 11173, 11177,
   11181, 11185, 11189, 11193, 11197, 11201, 11205, 11209, 11213, 11217,
   11221, 11225, 11229, 11233, 11237, 11241, 11245, 11249, 11253, 11257,
   11261, 11265, 11269, 11273, 11277, 11281, 11285, 11289, 11293, 11297,
   11301, 11305, 11309, 11313, 11317, 11321, 11325, 11329, 11333, 11337,
   11341, 11345, 11349, 11353, 11357, 11361, 11365, 11369, 11373, 11377,
   11381, 11385, 11389, 11393, 11397, 11401, 11405, 11409, 11413, 11417,
   11421, 11425, 11429, 11433, 11437, 11441, 11445, 11449, 11453, 11457,
   11461, 11465, 11469, 11473, 11477, 11481, 11485, 11489, 11493, 11497,
   11501, 11505, 11509, 11513, 11517, 11521, 11525, 11529, 11533, 11537,
   11541, 11545, 11549, 11553, 11557, 11561, 11565, 11569, 11573, 11577,
   11581, 11585, 11589, 11593, 11597, 11601, 11605, 11609, 11613, 11617,
   11621, 11625, 11629, 11633, 11637, 11641, 11645, 11649, 11653, 11657,
   11661, 11665, 11669, 11673, 11677, 11681, 11685, 11689, 11693, 11697,
   11701, 11705, 11709, 11713, 11717, 11721, 11725, 11729, 11733, 11737,
   11741, 11745, 11749, 11753, 11757, 11761, 11765, 11769, 11773, 11777,
   11781, 11785, 11789, 11793, 11797, 11801, 11805, 11809, 11813, 11817,
   11821, 11825, 11829, 11833, 11837, 11841, 11845, 11849, 11853, 11857,
   11861, 11865, 11869, 11873, 11877, 11881, 11885, 11889, 11893, 11897,
   11901, 11905, 11909, 11913, 11917, 11921, 11925, 11929, 11933, 11937,
   11941, 11945, 11949, 11953, 11957, 11961, 11965, 11969, 11973, 11977,
   11981, 11985, 11989, 11993, 11997, 12001, 12005, 12009, 12013, 12017,
   12025, 12029, 12033, 12037, 12041, 12045, 12049, 12053, 12057, 12061,
   12065, 12069, 12073, 12077, 12081, 12085, 12089, 12093, 12097, 12101,
   12105, 12109, 12113, 12117, 12121, 12125, 12129, 12133, 12137, 12141,
   12145, 12149, 12153, 12157, 12161, 12165, 12169, 12173, 12177, 12181,
   12185, 12189, 12193, 12197, 12205, 12209, 12213, 12217, 12221, 12225,
   12229, 12233, 12237, 12241, 12245, 12249, 12253, 12257, 12261, 12265,
   12269, 12273, 12277, 12281, 12285, 12289, 12293, 12301, 12305, 12309,
   12313, 12317, 12321, 12325, 12329, 12333, 12337, 12341, 12345, 12349,
   12353, 12357, 12361, 12365, 12369, 12373, 12377, 12381, 12385, 12389,
   12393, 12397, 12401, 12405, 12409, 12413, 12417, 12421, 12425, 12429,
   12433, 12437, 12441, 12445, 12449, 12453, 12457, 12461, 12465, 12469,
   12473, 12477, 12481, 12485, 12489, 12493, 12497, 12501, 12505, 12509,
   12513, 12517, 12521, 12525, 12529, 12533, 12537, 12541, 12545, 12549,
   12553, 12557, 12561, 12565, 12569, 12573, 12577, 12581, 12585, 12589,
   12593, 12603, 12604, 12607, 12608, 12609, 12615, 12616, 12617, 12618,
   12619, 12632, 12632, 12641, 12656, 12658, 12661, 12663, 12667, 12679,
   12695, 12699, 12710, 12711, 12714, 12726, 12735, 12736, 12739, 12740,
   12741, 12744, 12745, 12748, 12749, 12752, 12753, 12756, 12758, 12760,
   12762, 12766, 12773, 12780, 12796, 12830, 12840, 12843, 12847, 12860,
   12861, 12863, 12865, 12869, 12883, 12890, 12951, 12960, 12962, 12963,
   12966, 12968, 12969, 12972, 12973, 12974, 12975, 12976, 12983, 12982,
   12992, 12994, 12996, 12997, 13000, 13001, 13002, 13003, 13006, 13007,
   13011, 13010, 13027, 13025, 13041, 13040, 13054, 13060, 13061, 13064,
   13066, 13067, 13070, 13071, 13072, 13073, 13076, 13077, 13080, 13088,
   13105, 13113, 13136, 13242, 13276, 13278, 13280, 13284, 13288, 13287,
   13338, 13340, 13339, 13354, 13360, 13367, 13372, 13378, 13379, 13382,
   13383, 13384, 13385, 13386, 13387, 13388, 13396, 13404, 13407, 13408,
   13409, 13410, 13411, 13412, 13420, 13428, 13429, 13430, 13433, 13434,
   13437, 13439, 13448, 13536, 13537, 13544, 13545, 13546, 13552, 13561,
   13564, 13565, 13566, 13567, 13570, 13571, 13572, 13575, 13577, 13585,
   13586, 13592, 13600, 13601, 13604, 13605, 13608, 13613, 13620, 13625,
   13632, 13639, 13639, 13641, 13648, 13649, 13652, 13653, 13654, 13655,
   13656, 13657, 13658, 13659, 13660, 13666, 13673, 13685, 13691, 13698,
   13706, 13707, 13719, 13730, 13741, 13745, 13746, 13749, 13754, 13758,
   13759, 13762, 13768, 13776, 13782, 13789, 13793, 13794, 13797, 13800,
   13804, 13805, 13808, 13814, 13823, 13828, 13838, 13848, 13860, 13861,
   13862, 13863, 13864, 13865, 13866, 13867, 13868, 13869, 13870, 13871,
   13872, 13873, 13874, 13881, 13882, 13885, 13886, 13893, 13894, 13895,
   13902, 13901, 13918, 13919, 13926, 13925, 13995, 14001, 14007, 14015,
   14021, 14027, 14033, 14039, 14045, 14051, 14057, 14063, 14074, 14075,
   14078, 14079, 14080, 14081, 14082, 14083, 14084, 14085, 14086, 14087,
   14088, 14089, 14090, 14091, 14092, 14093, 14094, 14095, 14096, 14097,
   14098, 14099, 14100, 14101, 14104, 14105, 14106, 14107, 14108, 14109,
   14113, 14114, 14115, 14116, 14117, 14118, 14119, 14122, 14125, 14126,
   14127, 14128, 14129, 14130, 14131, 14132, 14145, 14146, 14147, 14148,
   14149, 14150, 14151, 14156, 14157, 14158, 14159, 14160, 14161, 14167,
   14168, 14169, 14170, 14171, 14172, 14173, 14174, 14175, 14176, 14177,
   14180, 14181, 14182, 14183, 14184, 14187, 14188, 14189, 14190, 14193,
   14194, 14195, 14196, 14197, 14198, 14199, 14216, 14217, 14218, 14221,
   14222, 14223, 14224, 14225, 14226, 14230, 14230, 14233, 14239, 14240,
   14243, 14245, 14250, 14260, 14271, 14278, 14279, 14280, 14283, 14316,
   14318, 14320, 14323, 14333, 14343, 14353, 14354, 14357, 14359, 14360,
   14361, 14364, 14366, 14374, 14375, 14376, 14380, 14381, 14385, 14386,
   14389, 14390, 14393, 14394, 14395, 14396, 14397, 14400, 14401, 14402,
   14403, 14404, 14405, 14406, 14407, 14408, 14409, 14410, 14411, 14412,
   14413, 14414, 14415, 14416, 14417, 14418, 14419, 14420, 14421, 14422,
   14423, 14424, 14425, 14426, 14427, 14428, 14429, 14430, 14431, 14432,
   14433, 14434, 14435, 14436, 14437, 14438, 14439, 14440, 14441, 14442,
   14443, 14444, 14445, 14446, 14447, 14448, 14449, 14450, 14451, 14452,
   14453, 14454, 14455, 14458, 14459, 14460, 14461, 14464, 14465, 14466,
   14467, 14468, 14469, 14470, 14471, 14472, 14475, 14476, 14477, 14478,
   14481, 14482, 14485, 14486, 14489, 14490, 14501, 14502
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS",
  "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P", "FAMILY",
  "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", "FOREIGN",
  "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL",
  "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING",
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE",
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX",
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P",
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P",
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL",
  "ISOLATION", "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P",
  "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAKPROOF", "LEAST", "LEFT",
  "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME",
  "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "MAPPING", "MATCH", "MAXVALUE",
  "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", "NAMES",
  "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NOTHING",
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC",
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR",
  "OPTION", "OPTIONS", "OR", "ORDER", "OUT_P", "OUTER_P", "OVER",
  "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL",
  "PARTITION", "PASSING", "PASSWORD", "PLACING", "PLANS", "POSITION",
  "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY",
  "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "RANGE",
  "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REF", "REFERENCES",
  "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE",
  "REPLICA", "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS",
  "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE",
  "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY",
  "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER", "SESSION",
  "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE",
  "SMALLINT", "SNAPSHOT", "SOME", "STABLE", "STANDALONE_P", "START",
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P",
  "STRIP_P", "SUBSTRING", "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE",
  "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", "TEXT_P",
  "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION", "TREAT",
  "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", "TYPES_P",
  "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN",
  "UNLISTEN", "UNLOGGED", "UNTIL", "UPDATE", "USER", "USING", "VACUUM",
  "VALID", "VALIDATE", "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR",
  "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", "VIEW", "VOLATILE",
  "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK",
  "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT",
  "XMLEXISTS", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE",
  "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME",
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'",
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'",
  "'{'", "'}'", "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with",
  "OptRoleList", "AlterOptRoleList", "AlterOptRoleElem",
  "CreateOptRoleElem", "CreateUserStmt", "AlterRoleStmt",
  "opt_in_database", "AlterRoleSetStmt", "AlterUserStmt",
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt",
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt",
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt",
  "set_rest", "set_rest_more", "var_name", "var_list", "var_value",
  "iso_level", "opt_boolean_or_string", "zone_value", "opt_encoding",
  "NonReservedWord_or_Sconst", "VariableResetStmt", "SetResetClause",
  "FunctionSetResetClause", "VariableShowStmt", "ConstraintsSetStmt",
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt",
  "DiscardStmt", "AlterTableStmt", "alter_table_cmds", "alter_table_cmd",
  "alter_column_default", "opt_drop_behavior", "opt_collate_clause",
  "alter_using", "reloptions", "opt_reloptions", "reloption_list",
  "reloption_elem", "AlterCompositeTypeStmt", "alter_type_cmds",
  "alter_type_cmd", "ClosePortalStmt", "CopyStmt", "copy_from",
  "copy_file_name", "copy_options", "copy_opt_list", "copy_opt_item",
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using",
  "copy_generic_opt_list", "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateSeqStmt", "AlterSeqStmt",
  "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly",
  "NumericOnly_list", "CreatePLangStmt", "opt_trusted", "handler_name",
  "opt_inline_handler", "validator_clause", "opt_validator",
  "DropPLangStmt", "opt_procedural", "CreateTableSpaceStmt",
  "OptTableSpaceOwner", "DropTableSpaceStmt", "CreateExtensionStmt",
  "create_extension_opt_list", "create_extension_opt_item",
  "AlterExtensionStmt", "alter_extension_opt_list",
  "alter_extension_opt_item", "AlterExtensionContentsStmt",
  "CreateFdwStmt", "fdw_option", "fdw_options", "opt_fdw_options",
  "DropFdwStmt", "AlterFdwStmt", "create_generic_options",
  "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "OptForeignTableElementList", "ForeignTableElementList",
  "ForeignTableElement", "AlterForeignTableStmt", "CreateUserMappingStmt",
  "auth_ident", "DropUserMappingStmt", "AlterUserMappingStmt",
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents",
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOptEach",
  "TriggerForType", "TriggerWhen", "TriggerFuncArgs", "TriggerFuncArg",
  "OptConstrFromTable", "ConstraintAttributeSpec",
  "ConstraintAttributeElem", "DropTrigStmt", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "aggr_args", "old_aggr_definition", "old_aggr_list",
  "old_aggr_elem", "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default",
  "opt_opfamily", "opclass_purpose", "opt_recheck", "CreateOpFamilyStmt",
  "AlterOpFamilyStmt", "opclass_drop_list", "opclass_drop",
  "DropOpClassStmt", "DropOpFamilyStmt", "DropOwnedStmt",
  "ReassignOwnedStmt", "DropStmt", "drop_type", "any_name_list",
  "any_name", "attrs", "TruncateStmt", "opt_restart_seqs", "CommentStmt",
  "comment_type", "comment_text", "SecLabelStmt", "opt_provider",
  "security_label_type", "security_label", "FetchStmt", "fetch_args",
  "from_in", "opt_from_in", "GrantStmt", "RevokeStmt", "privileges",
  "privilege_list", "privilege", "privilege_target", "grantee_list",
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list",
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt",
  "opt_grant_admin_option", "opt_granted_by", "AlterDefaultPrivilegesStmt",
  "DefACLOptionList", "DefACLOption", "DefACLAction",
  "defacl_privilege_target", "IndexStmt", "opt_unique", "opt_concurrently",
  "opt_index_name", "access_method_clause", "index_params", "index_elem",
  "opt_collate", "opt_class", "opt_asc_desc", "opt_nulls_order",
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list",
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg",
  "arg_class", "param_name", "func_return", "func_type",
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item",
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column",
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list",
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt",
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list",
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt",
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt",
  "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "locked_rels_list", "values_clause", "from_clause", "from_list",
  "table_ref", "joined_table", "alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone",
  "xml_attributes", "xml_attribute_list", "xml_attribute_el",
  "document_or_content", "xml_whitespace_option", "xmlexists_argument",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "target_list", "target_el", "qualified_name_list",
  "qualified_name", "name_list", "name", "database_name", "access_method",
  "attr_name", "index_name", "file_name", "func_name", "AexprConst",
  "Iconst", "RoleId", "role_list", "SignedIconst", "NonReservedWord",
  "unreserved_keyword", "col_name_keyword", "type_func_name_keyword",
  "reserved_keyword", "statements", "statement", "CreateAsStmt", "$@1",
  "at", "ECPGConnect", "connection_target", "opt_database_name",
  "db_prefix", "server", "opt_server", "server_name", "opt_port",
  "opt_connection_name", "opt_user", "ora_user", "user_name",
  "char_variable", "opt_options", "connect_options", "opt_opt_value",
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt",
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale",
  "ecpg_interval", "ECPGDeclaration", "$@2", "sql_startdeclare",
  "sql_enddeclare", "var_type_declarations", "vt_declarations",
  "variable_declarations", "type_declaration", "$@3", "var_declaration",
  "$@4", "$@5", "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "opt_ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
      61,    60,    62,   745,    43,    45,    42,    47,    37,    94,
     746,    91,    93,    40,    41,    46,    44,    59,    58,   123,
     125
};
# endif

#define YYPACT_NINF -4308

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-4308)))

#define YYTABLE_NINF -2578

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-2578)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
   -4308,   352, 11762, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, 25154, -4308,
   -4308, -4308, -4308, -4308, 95495,   365, -4308, -4308, -4308,100328,
   -4308, -4308, -4308,   313, 65192, -4308, 68078,   374, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, 71445, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, 54598,   780, -4308,
     460, -4308, -4308, -4308, -4308, -4308, -4308, -4308,  1358, 12550,
   -4308, -4308, 68559, -4308,   327, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, 69040,   -66, -4308, -4308,   420,   -35, -4308,   103,
    8269, -4308, -4308, 61825, 66154, -4308, -4308, 71926,   172,  1249,
   12963,  1358, 24670, 72407, -4308,  1367, -4308, 51189, -4308, -4308,
   -4308, 65673, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, 79141,  2554,   438, 51679, -4308, -4308,
   -4308, -4308, 79141, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, 72888, -4308,   554,   953, 79622, 80103, 63268,
   -4308,  1227, -4308, 79141,   812,   944, 53634, -4308, 80584, -4308,
   -4308,   704, -4308, 73369, -4308, -4308, -4308, -4308,   438, -4308,
   54598, 50225,    58,   668, -4308, -4308, 81065, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308,  1724,   726, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308,   -66, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308,   351, -4308,   894,
     661,  1343,   180,   859, -4308, -4308, -4308,  8764, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, 96929,  2141, -4308, -4308, -4308,
     921, -4308,  1066, -4308, -4308, -4308,  1565, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308,   857, -4308, -4308, -4308, -4308,  1512,
   95973, 71445, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, 61344, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308,   179, -4308, -4308, -4308, -4308, -4308, 71445, 71445, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, 71445,  1180, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308,   343,  1498, -4308, -4308,
   54598,  2271,  2271,  1822, 96929, -4308, -4308, -4308, 55562, 79141,
   79141, 79141,  1493, 79141, 79141,   348, 55562,103635, 81546,  1595,
   45802, -4308,103635, 79141, 82027, 79141, 73850, 79141,  1605, 79141,
   79141,104048, 82508,  1730, -4308,  1992,  1409, -4308, -4308, -4308,
   79141, 10810,  2554, -4308, -4308, 79141,  1639, 55562, 79141,  1597,
   79141,  1676, 79141, -4308, 79141, 82989,   372,  1951,103635,  1996,
   46296,  1767,103635, 79141, 79141, 79141, -4308, -4308,  1811, 79141,
   79141, -4308, -4308,104461,  1253,  2086,  2012,   451, -4308, -4308,
    2170,  1764, -4308, -4308,  2215, 71445, -4308, 69521, -4308, -4308,
   -4308,  2285, -4308, -4308, -4308, -4308, -4308,101570,  1249, -4308,
   -4308, 56044, 79141,  2052, -4308, -4308, 83470, -4308, -4308,   517,
   56526,104874,  2159, 46790,  2233,105287, 83951, -4308, -4308, 84432,
   -4308, 84913,  1954, 85394, -4308,105700, -4308,  2093, 85875, -4308,
   13709, -4308,  1876,  1672,  1887,  1450, 71445, 71445,  1110, 98233,
     -66, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,   154,
    1675, 52169,   223, 52659, -4308, -4308,   866,   972,   975,   154,
    2311,  2311,   783, 71445, -4308, -4308,  1675, -4308,    30,    17,
    1907,  1907,  1907,  2098,   817, -4308,  1907, -4308, -4308, -4308,
   -4308, 73369, 52169, 52659, -4308,  1918,  2554,    56,  2308, 79141,
   -4308, 79141, -4308, 79141, 79141, -4308, -4308, -4308,  2324,  1943,
    2180, -4308,  1972, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
    2178,  2182,  2212,    54,  2554,  2091, -4308,  2328, -4308,  2236,
   30061,  1260, 71445,  2554, 53149, 74331, 93090,   241,101570,  2554,
   86356,  2079,  1572,  2256, -4308, -4308,   536, -4308,  2461,  2152,
    2331,   149,  1409, 43368, -4308,  2151,  1689, 73369, 97407, -4308,
   -4308, -4308, -4308,   290,  2425, 30560, -4308, 79141,  2148, -4308,
    2155,  2162,  2172,  1343, -4308, 79141,  1332,  1332,  2563,  1332,
    1694,  1703, -4308,  2185, -4308,  2464,  2431, 73369,   668,  1358,
    2195, -4308, -4308, -4308,  2217, -4308,  2207,  2208, -4308,   448,
    2459, -4308, -4308, -4308, -4308,  2300,  2301,  2307,  2315,  2219,
    2325,   305, -4308, -4308, -4308, -4308,  2540, -4308, -4308, -4308,
   -4308, -4308, -4308,  2639,  2641,100744,100744,   822,   853,   148,
     262, -4308, -4308, -4308,  2513, -4308, -4308,  2511, 79141,  2349,
   79141, -4308, -4308, -4308, 86837, -4308, -4308,  2271,  2217,  2292,
   -4308,   307, -4308,  1689, -4308,   336,   347,   356,  1220,  2282,
    1631,  1423, -4308,   190,  2408,   132,   922,  2337, 74812,  4141,
    2302,   567,  2603,  4419,   305, -4308, 79141, 79141, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308,  2316, -4308, -4308,
    2321,   657,  1745,  2621, 13176,  1587,  2637,  5494,  1707,   856,
    2547,  1142,  2655,  1218,  2670,  5614, 79141,  2386, -4308,  2616,
    2735,   759, -4308,   171, -4308,  2456,  2602,   643, 55562,  2427,
   -4308, -4308, 79141, -4308, -4308, -4308, -4308,   595, 55562, -4308,
    2623, 47284, -4308, 79141, -4308, -4308, -4308, -4308, -4308,  2548,
   79141, -4308, -4308,  2659, 79141, -4308,  1907,   903,  2441,  2811,
   58936,   106, 79141,  2493,  2857,  2660,  2493,  2500, 87318, -4308,
   -4308,  2493, -4308, -4308, 79141, 79141,  2481,  1357,  2493,  2876,
    2900,  2590,  2695,  1016,  1341,   109,  2814,  2493, 79141, 87799,
   79141, 79141,  2890, 55562, 79141, -4308,  2688, 75293, -4308,  2534,
    2170, -4308, -4308, -4308, -4308, -4308,  1315, -4308, -4308, -4308,
   -4308,  2833,  2292,   576,  2834,  2544,  2838, -4308,  2579, -4308,
    2843,  2302,  2845, -4308,  2555, 88280, 88761, 89242,  2849,  2316,
  103635,  2851,  2555,  2853,  2743,  2856,   576,  2859, -4308,  1096,
    2860,  2749,  2862,  1792,  2555,101983,  2863,    94, -4308, 16556,
   13709, -4308, 18843,  1773, -4308, -4308, -4308, -4308, -4308, -4308,
   34053,   854,  2656, -4308, -4308, -4308,  1950, -4308, 99491, -4308,
    1110,  1675, -4308, 71445,  1675, 71445,   783,  1675, 71445,  1675,
   71445,   783,  1675, 71445, 71445, 71445,  1675, -4308, -4308,  2018,
    1882, -4308, -4308, -4308, -4308, -4308, 71445,  2573, 79141, 79141,
   -4308, -4308, -4308, 66635,103635, 67116, -4308, -4308,    26, 71445,
   -4308, 71445, -4308,  2554, -4308, -4308,  1672, 58936,  2970,103635,
    2858,  2858,  2858, -4308, -4308, -4308,  2796, 79141,  2866,  2868,
   66635,103635, -4308, 89723,101570,  2757,  2580, -4308, -4308, -4308,
   -4308,  1959,  2664,   192,  2716, 34053,  2581,   281,   281,  2582,
    2869, -4308, -4308, -4308,   387,  2589,  2591, -4308,   367,   367,
    2736,  2592,  2594, -4308,   378,  2595, -4308,  2725,   419,  2596,
    2597,  2598,  1801,   281, 34053, -4308,  2599,   367,  2604,  2607,
    2609,  2776,  2610, -4308,  2861,  2611,   213,   324,  2612,  2613,
   -4308,  2592, -4308,   409,  2614,  2620,  2622,  2624,  2626,  2627,
    2631,  2632, 34053, 34053, -4308, 29063,  1689,  2554, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308,   112, -4308,   432,  3297, -4308,
   -4308,  2760, 34053, -4308, -4308,   200, -4308,   474, -4308, -4308,
    1689, -4308, -4308,   737, -4308, -4308, -4308, -4308,   878,   878,
     202, -4308, 68559, 68559, -4308, -4308,  1464,  2600, -4308,  1955,
   -4308, -4308, -4308, -4308, -4308, -4308,101157,  3016, -4308,  1098,
    2554,   171,  1740,  2963, 98649, 99070,  2870,  2870,  2867, -4308,
   -4308, 79141, -4308, -4308, 34053, 49261, -4308,  1689,    86,  2871,
   -4308, -4308, -4308,  1963, -4308, -4308, -4308,   -66, -4308, 12459,
   -4308,  1969,  2148, 79141, 79141,  3032, -4308, -4308,  2155, -4308,
   -4308,  1343,  1343, 34053,  1343,  1097,  1087, 31059, 34053,  2920,
    2824,  1403,  1079,  2924, -4308,  1694,  1703, 73369, 79141, 90204,
    2753, -4308, -4308,  2217,  2658,  1658, -4308, 60863, 96451, 96451,
    2889, -4308, -4308,   702,   650,  2765,  2872,  2311,   829,  1599,
    1599, -4308, -4308,  2649, -4308,  2977, 68559,  2707,100744, -4308,
   -4308, 79141, -4308, -4308, 75774, -4308, -4308, -4308,  1944,  2652,
   -4308,  2669, 79141,  3147, -4308,  1599,  1599, -4308, -4308,  2661,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, 96929,  2662,
   79141, -4308,  2665,  2667, -4308, 97407, 49743,  1632,  1689,  2744,
    2746,  2792, 54598,  2673,  2750,  2754,  2803,  2761,  2762, 93571,
   -4308, -4308, -4308, -4308,  1135,   745,  1089,  2763,   237,   738,
    3041, -4308,  2816, -4308, -4308, -4308,  3824, 79141,  2987,  6551,
    2879,   305,  2815, -4308, -4308,  2925,  2775,  2778,  2894,   305,
     138, 94052, -4308, -4308, -4308, -4308, -4308, -4308,  6069, 27592,
   -4308,  2780,  2766, 79141, 62306,  3065,  2892,  1279,  2115,   525,
   79141,  2965,  2899, 79141,  2718,  2790,  2795,  2722,  1507,  3073,
    2723, -4308, -4308,  2895,  2781,  2784, 57972,  1479, 47778,  3062,
    2808, -4308,   559,  2809,  2810, 79141,   305, -4308,  3115,   305,
     305,  1501,  3116,  2819,   174,  1439,  2493,  2723,  2150, -4308,
    2820,  2821,  1755, -4308,  2916, 73369,   159,  1627,  2723,  2822,
    2827,  2722,  2722, 79141, 79141, 79141, 79141, 79141,   124,  3131,
    3148,  2832,   136,  2880,  2764, -4308,102396,  2839, -4308,   559,
   79141,  2842,  1816,  2723,  1789, -4308,  1896, -4308, -4308, -4308,
    1409, -4308, 79141, -4308, 79141,  2292, 58936,  2940,  2802, -4308,
    2302,   305, 79141, 79141,  2316,    81,  1120,  2944, 79141,  3009,
    2823, -4308, -4308,  2493, -4308, 49743,  2481, -4308,  2777, -4308,
    2818, -4308,  2818,  2818,  2786,  2786,  2787, -4308, -4308,  1801,
    2818,  2786, -4308, 59900, -4308,  1542,  1569, -4308,  3171,  3174,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,   915,
   -4308,  1987, -4308, -4308, -4308, 79141, 54598, -4308,  3186, -4308,
   -4308, 58936,  3080, -4308, 79141,  2984,  2791, -4308,  3117,  2844,
   -4308,  2836, -4308,103635,  1328,  2554,  2840, 79141,  3010, 79141,
   79141, 79141, 79141, -4308, -4308,  2981,   591,   143, -4308,102396,
   -4308,  2150,  2995,  3197,   -10,  1907,  3084, -4308, 79141,  2804,
    3200,  3039, -4308, -4308,  2813,  2311, -4308,  2534, -4308,  1761,
   -4308,  2930, -4308, 55562,   576, -4308, -4308, -4308, -4308, 58936,
   79141, 90685, 55562,   576,103635,103635,  3105,    94,  3106,  2873,
    3108,  2875, 47778,   576,   101,103635, 79141, 79141, 79141, -4308,
   79141, -4308, -4308, -4308, -4308, 79141, 79141,103635,102396,  3109,
    3110,   576, 79141, 79141, -4308, -4308, 17582,  1802, -4308, 13709,
   -4308, 12459,  2020,  2870, -4308,  1180, 79141,  1397,  1110,102809,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, 71445, -4308,
   71445,   783, -4308, -4308, 71445, -4308, 71445,   783, -4308, 71445,
   -4308, -4308, -4308, 71445, 79141,  3308,  2826, -4308,   737, -4308,
   79141,  2024, -4308, -4308,  2049,  1000, 79141, 79141,   142, 55562,
   79141,  3011, 79141, 79141, 79141, 79141, 79141,  2898,  2600,  1370,
   -4308,   552, 73369,  3015, -4308, -4308, -4308, -4308, -4308,  2054,
    1724,   864, -4308, -4308, -4308, -4308, -4308, -4308, 67116, 65673,
    3103,   195, 79141, -4308, -4308,  4179, 34053, 29562, -4308, -4308,
   -4308,  2830, 12459,  2877, 34053, -4308, -4308, 34053,  2831,  2311,
    2311, 34053, -4308, -4308, -4308, -4308,  2812,  2311, -4308, 34053,
   34053,  2311,  2311,  2818,  2818, -4308,  6238, 34053, -4308, 47778,
   34053, 35550, 27092, 34053,  2913,  2874,  2311, -4308,  2311, -4308,
   34053, 28564, -4308, 34053,  3042, 36548, 34053,  1740,  3044, 34053,
    1740,  3259,  3259,   668,  3725,  5228,  2847,  1689, -4308,  2953,
    2311, -4308,  2311,   756,   181, 58936, 34053, 54598,  2927,   147,
   79141, 34053,  2854,  1417, -4308, 34053,   724, -4308,  2864, 34053,
    2932, 34053, 34053, 34053, 34053, 34053, 34053, 34053, 34053, 34053,
   -4308, 37518,   214, -4308,   964,  2126, 67597, 30061,  3129, -4308,
   26592, -4308,   249, 71445, -4308, -4308,  1689, -4308, -4308, -4308,
   -4308, -4308,  1944,  2865, -4308,  2883, -4308, -4308, -4308, -4308,
   -4308, 79141,  3016, -4308, -4308,  2928, -4308, -4308, -4308, -4308,
     560, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,  2878,
   -4308, -4308, -4308, -4308,  2878, -4308, -4308,  2870,  2882,  3938,
   -4308, -4308, -4308, -4308,  3121,  3123,   576, 96929, 79141,   290,
   70002, -4308, 30560, -4308,  2058, -4308,  2884, -4308,  3101, -4308,
    2885, -4308, 10055,  3101, -4308, -4308,   137,  3045,  3051,  3051,
   -4308,  2886, 12459, -4308,  1949, 12459,  1998, -4308, -4308, -4308,
   -4308, -4308, -4308,  1309, -4308,  2920,  1079,  2923,   680, 79141,
   -4308, 43853,  1899, -4308,  2217, -4308, -4308, 25632, -4308, 26112,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,  2891,
   -4308, -4308, -4308, -4308, -4308,   305,  2893,  3341, -4308,100744,
   -4308, -4308, -4308,  3308, -4308,  2215, -4308,  2215,  3368, -4308,
   71445, -4308, -4308, -4308, -4308,   651, -4308, 13709, -4308, 13709,
   -4308,  2896,  2064,  2950,  2952,  3004,103635, 79141, 79141, -4308,
   54598,103635, 79141, 79141,103635, 79141, 79141, -4308,  3237,  1186,
   65673,  3012, 63749, -4308, -4308,  2901, 79141,  2942,  3122,  3127,
    1216, -4308, -4308, 91166, -4308,  3089,103635, 79141, 79141, 34053,
    3092, 79141, 79141, 79141,  2978, 55562,  2905, 79141, 79141, 79141,
     612, 55562, 48272, 79141, 79141, 79141, 79141,  3023, 79141, 79141,
    3138,  1388, 73369,   119,  2097,  2723,  3100, -4308,  1263, -4308,
  103635, 79141,  3094, -4308, -4308, -4308, 64230,  3304,  3017, -4308,
   -4308, 94533, -4308, -4308,  3091, -4308, -4308, 59900, -4308, -4308,
    2077, -4308, 59418, 57008, -4308, -4308,  1044,103635,103635,  6672,
   79141,  1306, -4308, -4308, 58936, -4308, 79141, 79141, 79141, 70483,
   91647, 92128,  1393,  1402, 79141, 70964, -4308, 79141, -4308, -4308,
   55080,103635, 79141, 54598, -4308, 79141,  3102,   546, -4308, 79141,
    3582,  2993, 79141, 79141,  2917,  2081,  2997,  3043, -4308, 79141,
  103635,  1539, 93090, -4308,103635, 79141, 13707, -4308, -4308,   305,
   -4308, -4308, -4308, -4308, -4308, 79141, 79141,   305, 79141,   305,
    1521, -4308,103635, 79141, -4308, -4308, -4308,  6919, 79141, 79141,
   79141, 79141,103635, 79141, -4308, -4308,  1245,   785,  1710,  1731,
    3061, 79141,  2554, 79141, 92609,103635, 79141, 79141, 79141,  1533,
   -4308, -4308,  3036, -4308,103635,  1539, -4308,  7351, 79141, 79141,
    3001,  3003,   129,  3077, -4308, -4308, -4308, -4308, -4308, -4308,
    3167,  3328, 79141, -4308,  3169,  3184,  3002,  3007,  3192,  1779,
   79141, 79141, 79141, 79141, 79141, 79141,  3193,  1779,  3140,    74,
    2961,  2084, -4308,  2975, -4308, 34053,  3359, 58936,  2966,  2968,
    3046, -4308,  3048,  2311, -4308,  2031, -4308, -4308,  2103, -4308,
    2980,   591,  1934, -4308, 79141,   763,   565,  3260, 40942,  3085,
    2615,  3251, 79141, 79141,  2615, -4308,  2004, 65673, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308,  3255, -4308,  2554,
    2481,  2481,  2481,  2481, -4308, -4308, -4308, -4308,  3162,  1203,
   -4308,  2989,  2481, 79141,  3090,  2615, -4308,  2150,  3279,  3283,
   79141, 62787,  2046,  3025,  2554,  3172, -4308, 28078,  3735,  3173,
  101570, 75293, -4308,  3006,  3265,  3266,  3276, -4308,  2292, -4308,
    3399, -4308,  3299,   576,  2302, -4308,  2555, -4308, 79141, -4308,
   79141, 79141, 79141, 79141,  2316, -4308, -4308,  2555,  3188,   576,
     576, -4308,  3190,   576,  2555,  3130,  3292,101570, -4308,    94,
   -4308, -4308, -4308, -4308, -4308, 34053, -4308, -4308, -4308,  1907,
    1761, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, 71445,  2215, -4308,  2107, -4308, 79141, -4308,  3268,
    3273,  3275,  3018,  3021,  3066, 79141,  3027, -4308,  3018,   305,
    3018,  2600,  2600,  3018,  3021,103222,  3438,  3309,   561, -4308,
     586,  1086,  3243, -4308, -4308, -4308, -4308, 58936, -4308, -4308,
   -4308, -4308, -4308, 79141,    70,  3220,  3040,103222,  3422,   576,
   -4308, 55562, -4308, -4308, -4308,  3133, 55562,  3232, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308,  3280, 79141,  2112, -4308,  1840,
   -4308,  1841, 34053, 34053,    78, -4308, 10648,  2146, 34053,  3049,
    3052,  2153, -4308, -4308, -4308, -4308, -4308, -4308,  3053,  3331,
   -4308, -4308,  3055,  2183,  2197,  3056,  3057, -4308, -4308,  2406,
    3059, 10840,  3060, 35550, 35550,  1725, -4308, -4308, 35550,  3064,
   -4308,  2203, 10065,  3067,  3070,  3069, -4308,  3071,  3072, 11169,
   31558, 34053, 31558, 31558, 11363,  3067,  3075,  2206, 54598,  3240,
   11809,  2231, -4308, 34053, 54598,  4952, 34053, -4308, 34053, 79141,
    3078,  3079, -4308, -4308,  6238, -4308,  3099, -4308, 35550, 35550,
   -4308,  4744, 29063, -4308, -4308,  3350, -4308, -4308,  1601, -4308,
    3083, -4308, -4308,  5663,   182, 34053,  2854, 34053,  3158, 47778,
    4987, 34053,  3369,  5026,  5026,   689,   689,   219,   219,   219,
    1870,  2126, -4308, -4308, -4308,  3086,  2610, 34053, -4308,  2222,
    2326, 79141,  9177, 12347, 13000, -4308, -4308, -4308, 39001,  3125,
   34053, 34053, 34053,  3088,  3261,  3504, 12459,   891, -4308,  3505,
   -4308, -4308, -4308,  2030,  3368,  1944, -4308,  1409,  2311,   756,
   99491, -4308, -4308, -4308, 34053, -4308, -4308, -4308, -4308,  2155,
   -4308, -4308, -4308, -4308, -4308, 79141,  1724, 34053, -4308, -4308,
     580,  2053, 34053,  1949, -4308, -4308, 79141,  3015,  3015, 34053,
   -4308, -4308, -4308, -4308, -4308, 39001,  3132,  3142, 42883,  3223,
   -4308, -4308, 79141,   176, -4308, -4308, -4308,  3111, -4308, -4308,
   -4308,   814, -4308, -4308, -4308, -4308, -4308, -4308,  3093, -4308,
    3096, -4308,  3113, -4308, -4308, -4308, -4308,   177,  3104,  3112,
    3107,  1644, -4308, -4308,103635, 79141, 79141, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308,  3320, -4308,103635,
  103635,  3284, 79141,  3288,  3287, 34053,  1005, 79141,  3120,  3124,
    1400,  3365, 79141, -4308,  3408,   576, -4308, -4308,  3195, -4308,
   12459, -4308, -4308, -4308, -4308,101570, -4308,  2292, 58936, -4308,
   -4308, -4308,  3154, 79141, -4308, 79141, 79141,  2316, -4308, -4308,
   -4308, -4308,  1132, -4308, -4308, 79141, 79141,    16,  3199,  3201,
   79141, -4308,   631,  2916,  7475, 79141, 79141, 79141,  3371, -4308,
   -4308, -4308, -4308,  3317, -4308, -4308,  1987, -4308, 57008, 59418,
   -4308, 59418, -4308,  1987,  1795, -4308,  2555,  3203,  2723, -4308,
    3307,   904, -4308, -4308, -4308, -4308, -4308,  3424,   576,  3425,
     576, 79141, 79141, 79141, 79141, -4308, -4308, -4308, -4308, -4308,
   54598, 54598, 54598,  2254, -4308, -4308,  2554, -4308, -4308, -4308,
    2270, -4308,  1633, -4308, -4308, -4308, -4308, -4308, -4308,103635,
    1865, -4308,   577, 58936, -4308, 58454,103635, 79141, -4308, -4308,
    3354,  3300, -4308,  1791,  3301,103635,  3196, -4308, -4308, -4308,
   -4308,  3211,  2123,  2723,  2150, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308,   155,  2235,  2723,  3214, -4308,  3216, -4308,
   -4308, -4308,  3353,  3356,  3357,  3218,  3222,  3270,  3226,  3227,
    3274, -4308,  3228,  3277,  3230,  3278,  3231,   576, 58936,  2005,
    3256,  3452,   576, -4308,  3235, -4308, -4308,  3551, -4308, 79141,
   -4308,  3238,  2250,  2723, -4308, -4308,103635, 79141, -4308, -4308,
   -4308,  1779, 58936,  3400,  1779,  1779, 79141, 79141,  1779, -4308,
   -4308, -4308,  3402,  3403,  3405,  3406,  3407,  3411,  1779, -4308,
   -4308, -4308, -4308,   903, 54598, -4308,  2351, -4308,  2285, 45308,
    5474,  3179,  2968,  3178,  2311, 41428,  1134,  3385,  3181, -4308,
   -4308, 54598, 45308,  1905,  3401,  3198,  3198,  3198,  3198,  3198,
    3198,  3198, -4308,  1596,  2493,101570, 79141,101570, -4308,   565,
    3307, 79141, -4308, -4308,  2278, -4308, 79141,103635,   753,103635,
    2311, -4308, -4308,  3252, -4308,  1907,  1328,  3326,  1258,  3516,
   -4308, -4308, -4308, -4308, -4308, 79141, 79141,   591,  2554, -4308,
    3194,  3204, -4308, 79141, 79141, 79141,  1724,  3202, 79141,  3205,
    3207, -4308, -4308, -4308, -4308, 58936,   507,  3377,  3379,  2722,
    3595,  3282, 79141, -4308,  2279,    77, -4308,  2554,101570, 57490,
   -4308,  4716, -4308, -4308,   838,  3471, -4308, 79141, -4308, -4308,
   42398,   576, 58936, 79141, -4308,   576,    94,  3264,   576,  3267,
     576,   576, 79141, -4308, -4308, 79141, -4308, 79141,102396,   576,
   -4308, 12459,  3495, -4308, -4308, -4308, -4308,  3335,  3336,  3337,
   79141,  3018, 55562, -4308,  3224,103635,  1424, -4308, -4308,  3398,
   -4308, -4308, -4308, -4308, -4308,  3517,  3520, -4308, -4308, -4308,
  103635, 66635,   117,103635, -4308,  2292, -4308,  2302,   305, 79141,
    3464, -4308, -4308, -4308,  3233,  2284, 12097, 34053, -4308,  3530,
   58936, -4308,  6006, -4308, -4308, -4308, -4308, 34053, -4308, -4308,
   -4308, -4308, -4308, 34053, -4308, 34053,  3509, -4308,  3650,  3650,
   58936, 35550,  1502,  2604, 35550, 35550, 35550, 35550, 35550, 35550,
   35550, 35550, 35550, 38017,   757, -4308, -4308, 34053, 34053,  3518,
    3509, -4308, -4308,  1716,  1716, 58936,  3242,  3067,  3262,  3269,
   34053, -4308, -4308,  2304, 37033,  3271, 54598, -4308, 34053, 10104,
    2309,  3294, 12427,  1689,  6095, -4308,  3604,  2554, 34053,  1392,
    2424, 34053,  2314, 34053,  3514, -4308, -4308, -4308,  3239, -4308,
   -4308, 58936, 34053, 35550, 35550,  5973, -4308,  6854, 34053,  3272,
    7368, 29063, -4308,   438,   438,   438,   438, -4308, 79141, 79141,
   79141, 38516, 76255,  3257,  2184, -4308, 76255, 76736, -4308,  3295,
    1689, 34053,  3529,   395,   395,  3281,  3261, 44338, -4308, 34053,
    1670, 32057,  3286, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,  3291, -4308,
    3293, -4308, -4308,   171,  3296, -4308, -4308,  9627,   177, -4308,
   -4308,  3298, -4308,  3302, -4308,  2053, -4308, -4308, -4308,  6583,
    3441,  2600, -4308, -4308, -4308,  3257, 32556,  3223, -4308,  2318,
   -4308, -4308, 30061, -4308, -4308,  2319, 43853,  3132, 30560,  1689,
    2311,  3311, -4308,  2215,  2030, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308,  3198,  2555,  2555,   771,  3018,  3545,   771,
    7336, -4308, -4308, 39486, 79141, 79141, -4308, 79141,  2333,  1766,
   79141, -4308, 79141, -4308, -4308,  3663, 79141, -4308,  3323,  3327,
   -4308, 79141, 79141, 79141, 79141, -4308, -4308,  2282, -4308, -4308,
  103635, 79141, -4308, -4308, -4308,   185,  2293,  2723, -4308,  3348,
   -4308, -4308,  3523,  1818, -4308, -4308, -4308,  3366, 79141,  3303,
   -4308,   795,  2722,   809, -4308, -4308,  3373, 79141, -4308, 79141,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, 55080,
   -4308, -4308, -4308, 54598, 45308, 54598, -4308,  3370,  3374,  3423,
     836,  1125,  3380,  3383,  3429,  3310,  3325,  3329, -4308, -4308,
     154,  2554, -4308, -4308,  2554,  2555,  2554, 79141, 79141, 79141,
   79141, 79141, 79141, 79141,  3593,   670,  1910,103635, 79141, 79141,
  103635, 79141, 79141, 79141, 79141, 79141, 79141, 79141, -4308,  3687,
    2554,  2554,  3658,  3394, 79141, -4308, 79141,  2916, 79141, 79141,
   -4308, -4308, -4308,  3332,  1779, -4308, -4308,  3567,  3569, -4308,
    1779,  1779,  1779,  1779,  1779,  1779, -4308,   233,  2334, -4308,
   97820, -4308, -4308,  2857,  2554,  2857,  1167, -4308,  2857, -4308,
    2857, -4308, -4308,  2975,  3302,  1599,  1599, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308,  2311,  2210,  3338, -4308, 41913, -4308,
   -4308, -4308,  2230,   756, -4308, -4308, 79141,  3198, -4308,  2229,
    2502,  2528,  2585, 77217, 77698, 78179,  3342, 79141, 79141, 35550,
   -4308,  1557,   210, -4308,  3572, 79141,  3378, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308,  2791, -4308, 79141,  3307,  2555,
  103635,103635,  2555, -4308, 58936,  3025,  1450, 87799,  3376,  3340,
    3627, -4308,  3347,  3349, -4308, -4308, 79141,  3307,   492,  1887,
    3387, 64711,  2046, -4308,  3601, 62787, -4308, -4308, -4308,  3710,
    3448, -4308,  1724,  2554,  2942, -4308, 57008, 34053, 34053, -4308,
    3364, -4308,  3381,  5200, -4308,  2481, -4308, -4308, -4308, -4308,
   -4308, -4308,  3442, 79141,  3787, -4308, -4308, -4308,  3384,   576,
   -4308, -4308, 79141, -4308, 79141, -4308, -4308,   576,   576, -4308,
    3480, -4308,  1724, 79141, 79141, 79141,  3018, -4308,   305, -4308,
    3645,103222, -4308, -4308, -4308, -4308,   195,  3653, -4308, -4308,
    3613,  3614,  3615,  3617,  1989, -4308, -4308, 34053, 12459, -4308,
    3386, -4308, 12459,  7769, 12459,  3518, -4308,  3263,  3665, -4308,
    1345,  3390,  3263,   914,   914,   465,   465,   123,   123,   123,
    3650,   757, 12459, 12459, -4308, -4308, -4308, -4308,  3391, -4308,
   -4308, -4308,  3067, -4308, 34552,  3534,  3774, -4308, -4308, -4308,
    3433,  3435,  3404, -4308, 34053, 35051,  3397, 59900, -4308, -4308,
     756,  1106, 35550, 35550,  2274, -4308,   562, 34053, 58936,  2339,
    2274,  2509,  3253, 34053, 34053,  7821,   255, 34053,  8040, 79141,
   79141, 79141, 79141, -4308, -4308, -4308, 40456,  2184,  3409, 79141,
   -4308,  3412, 39001,  3633,  3574, -4308, 39001,  3574,  1762,  3574,
    3635, -4308, 44823, -4308,  3413, 26592,  1883, 12459,  3782,  3674,
   34053,  3410, -4308,  3416,  3261, -4308, 95014, -4308, -4308, 12459,
   -4308, -4308, 34053, -4308,  3261,  2030,   711,  2554, -4308, -4308,
   -4308, 47778, -4308, -4308, -4308,  3602, 12459, -4308,  1724, 79141,
    1689,   500,  3434, 79141, -4308,  3223, -4308, -4308, 13709, -4308,
   -4308, -4308,   154, -4308, -4308, -4308, -4308,  3483, 65673,  3696,
   -4308, 34053,  2357, -4308,  3456,  3783,    96,  2360,  2370,  1766,
   -4308,  3378, -4308,  1614,  3675,   266, -4308,   576, -4308, 58936,
   -4308, 79141, 79141, -4308, -4308, -4308, -4308,  2673, -4308, -4308,
   79141, 79141, 79141, 79141, -4308,  3490, -4308, -4308, 54598,  1596,
    3616, -4308, -4308,  3618,   154, 79141, -4308, 58936,   576,   576,
   -4308, -4308, -4308,  3439,103635, 79141, 79141,  2311,  2311, 58936,
    3427, -4308,  2311,  2311,  3428, -4308,103635, 79141, 79141, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,  3507,
   -4308, -4308, -4308, 79141, 79141, 79141, 79141,  3726, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, 79141,
   -4308, -4308, -4308, 58936,   576,   576, -4308, -4308, -4308,  3670,
   -4308,  1779,  1779, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
    2493,  3752, -4308, 54598, -4308, 99912, -4308, -4308, -4308,  2554,
   -4308,  2554,  3628, 50707,  2554,  2554,  1766,  3443,  1506,  3712,
   -4308,  1830, 41913, 41913, 41913, 41913, 41913, -4308, -4308,  3717,
     154, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, 34053, -4308,   227,  3263,
   -4308, -4308, -4308, -4308,  3378,  1907,  3497,   763,  3553, -4308,
   -4308,  2555,  2555,  3499,  3843,   578, 79141,  3754,  3489, -4308,
    2554, -4308, -4308, 79141, 62787,  3387,   198, -4308,  2407, -4308,
   -4308, -4308,  3488,  3379,  1600,  3458,  2046, -4308,  1222, 79141,
   -4308,  3493,  3732,  3460, -4308, 12459, 12459,  2554, 60382,  4716,
   -4308, 79141,  3709, 79141, -4308,   576, -4308,   576,   576, -4308,
   -4308, 79141,  3018,  3018,  3018, -4308,  3639, -4308,   576,103222,
    1989,  1989,  1989,  1989, -4308, -4308, -4308, 12459, -4308, -4308,
   -4308, 35550,  3739, -4308,  3467, 58936, -4308,  3468,  2420,  2436,
   36548,  3605, -4308, -4308, -4308,  8092,  3519, 12459,  3568,  3469,
    3472, -4308,  1274,  1274,   562,  2443, -4308, 35550, 35550,  2274,
    2274, 34053,  2274, -4308, -4308, -4308, -4308, -4308, 76255,  3474,
   79141,  2184, 39001, -4308, -4308,  2140, -4308, 39001,  3708, -4308,
   39001, 79141,  3484, 79141,   948, 34053, 34053,  3524,  3261,  3261,
   -4308,  3647, -4308,  3494, -4308, -4308,  1599, -4308, -4308, -4308,
   -4308,   756,  3496, 71445, -4308, -4308, -4308,   668, -4308, -4308,
   -4308, -4308,103222,  3676,103222,  1766,  8930,  3378, 39486, 48766,
   79141, 78660, 78660,  3625,  3378,  3497, -4308, -4308, -4308, -4308,
   -4308, -4308,  3500, -4308, -4308, -4308,  3564, -4308, -4308, -4308,
    2447, -4308, -4308, -4308, -4308, -4308,  3687, -4308, -4308, 45308,
   -4308, -4308, -4308, 39971, 47778, -4308,   836,  3508,  3510,  1125,
   -4308, -4308, -4308, 79141,  1468,  1129,  3528,  3018,  3781, -4308,
    3687, -4308, -4308,  1779, -4308, -4308,  2961,  2554, -4308, -4308,
    2448, -4308, -4308, -4308, 79141, -4308,  3340, -4308, -4308, -4308,
   55562,  3899,  3899, -4308,  1904,  1904, -4308, -4308, -4308, 79141,
   -4308, -4308,  8981,  3694, -4308,  3497,  3718,  3764, -4308, 79141,
   79141,  1724, 62787,  3307, -4308,  1709,  3513,  3807, -4308,  3202,
    3521, -4308, -4308,  3845, -4308, 64711,  3695,  3448,  1195,  1195,
   79141,  3379,  3640, -4308,  3646, -4308,  1377, -4308, 79141, 39486,
   -4308, 59418, -4308,  2454, -4308, -4308,  3125, 79141,   505, -4308,
    3538, -4308, -4308, -4308, -4308, -4308, -4308,   117, -4308, -4308,
   -4308, -4308,   768, 35550, 58936,  2455, 34053, -4308, 34053, -4308,
    3904, -4308, -4308, -4308,     3, -4308, -4308, -4308,  1274,  1274,
    2274, -4308, 79141,  2471, -4308, 34053,  3527, -4308, -4308, 39001,
    2140,  2472, 79141,  2475, 58936,  3261,  3067, 12459, 79141, -4308,
   -4308, -4308,  3906,  3703,  3261, -4308, -4308, -4308, -4308, -4308,
   -4308,  1424,   771,   117,  3783,  3497, -4308,  3531, -4308, -4308,
   79141, -4308,  1432,  1432, 79141,  3497, -4308, -4308, 79141, -4308,
   54598,  3584, -4308, 58936,  2302,   188, -4308, 58936, 58936, -4308,
   -4308, 79141, 79141, 79141, 79141, 79141,   576, -4308, -4308, -4308,
   -4308, 99912,  3340,  3899,  1179, -4308, -4308, -4308,  1696,  3734,
   -4308,   834,  3716,  3621,  3307,  3828,  3493, -4308, -4308, -4308,
   -4308, 34053,  3693,  2046,  3601, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308,  2476,  3448, -4308,
   -4308,  3912,  3729,  3919, -4308,  2479, -4308, -4308,  5200, 60382,
    3866, -4308,  3606, 79141, -4308, -4308,  2187,  3975, -4308,   768,
    2484, -4308,  2488,  2491,  3700,  3608, -4308,  2492, -4308, 12459,
   79141, -4308, -4308, -4308,  2505, -4308,  3559, -4308,  3958, 34053,
    1131, -4308, -4308,  3840, -4308, 78660,  3603, 47778, -4308,  2053,
    2053,  1907, -4308,  1766, -4308, -4308, 34053, -4308,  2506, -4308,
    1211,  3711,  3846,  2510,  2515,  3021,  3609,  3021, -4308,  3018,
   -4308, -4308, -4308, -4308, -4308,  3874,  3822, -4308, -4308, -4308,
   -4308,    80, -4308,  3756,  3757, 79141, -4308, 79141,  3969, -4308,
    9288, 55562,  3379,  2046,  1596, -4308, -4308,  3758, -4308,  3761,
    3025, 39486,  4716, -4308,   251, -4308, -4308, -4308, -4308, -4308,
   79141, -4308, -4308, -4308, -4308, -4308, -4308,  2516, -4308, 79141,
    3579,  3067, 33055, 33055,  3586,103222,  1432,  3580, -4308,  3588,
   -4308, -4308,  3718,  1766, 12459, 55562,  3963, -4308, -4308, -4308,
    3711, -4308, -4308, 79141,  3713, -4308,   743,   743,  3909, -4308,
    3648, -4308, -4308, -4308,   836, -4308,  3592,  3448,  3379, -4308,
   -4308,  3448, -4308, -4308, -4308, -4308,  1772, -4308, -4308, -4308,
   -4308, 36049,  3719,   134, 10177, -4308, -4308, -4308, -4308,   117,
    2053, 34053,  1766, -4308,  3716,  2302, 79141, -4308, -4308,  3489,
   -4308,  4002, -4308,  1102, -4308, -4308,  3427, 54116, -4308,  3448,
    3125, -4308,  1777, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
    3993, -4308, -4308, -4308, -4308, -4308, -4308, -4308,  9505, -4308,
   -4308, -4308,  3890, -4308, -4308, -4308,  2520, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308,  1846, -4308, -4308,  1847,  2172, 33554,
   -4308,  1766,  3747, -4308, 54116, -4308,  1777, -4308, 55562, -4308,
   -4308,  3599, 54116,  2521, -4308
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2261,     0,     2,     1,  2691,  2695,  2699,  2700,  2617,  2701,
    2702,  2667,  2668,  2669,  2670,  2671,  2672,  2673,  2674,  2675,
    2676,  2677,  2678,  2680,  2679,  2681,  2682,  2683,  2684,  2685,
    2686,  2687,  2688,  2690,  2689,  2639,  2268,  2636,  2633,  2634,
    2635,  2640,  2638,  2631,  2632,  1867,  2704,  2692,  2705,  2693,
    2694,  2696,  2697,  2666,  2698,  2706,  2707,  2708,  2703,  2711,
    2662,  2663,  2661,  2664,  2665,  2709,  2710,  2653,  2654,  2655,
    2656,  2712,  2269,  2270,  2658,  2262,  2266,  2328,  2399,  2659,
    2660,  2657,  2267,  2652,  2399,     0,  2520,  2521,  2522,     0,
    2523,  2524,  2525,  2451,  2413,  2526,     0,     0,  2527,  2528,
    2529,  2530,  2531,  2532,  2533,  2534,     0,  2535,  2536,  2537,
    2538,  2398,  2539,  2540,  2541,  2542,  2543,  2375,  2381,  2504,
       0,  2355,  2356,  2352,  2354,  2353,  2357,  2340,  1154,   528,
    1238,  1237,     0,  2164,  1154,  2120,  2121,  2165,  2122,  2123,
    2124,   249,     0,  1240,  2125,  2166,     0,  1154,  2167,   357,
     932,  2168,  2169,  2283,     0,  2126,  2127,     0,     0,     0,
     528,  1154,     0,     0,  2128,  1350,  2129,     0,  2130,  2170,
    2171,     0,  2131,  2172,  2173,  2132,  2133,  2134,  2174,  2175,
    2176,  2135,  2177,  2178,     0,     0,  1364,     0,  2136,  2179,
    2137,  2138,     0,  2180,  2139,  2140,  2141,  2181,  2182,  2183,
    2142,  2143,  2144,     0,  2145,     0,     0,     0,     0,     0,
    2184,  1154,  2146,     0,     0,  1371,     0,  2147,     0,  2185,
    2148,     0,  2149,     0,  2150,  2151,  2152,  2153,  1364,  2500,
    2376,     0,  1242,     0,  2154,  2186,     0,  2155,  2156,  2157,
    2158,  2159,  2160,  2161,  2162,  2163,     0,     0,    54,    55,
      21,    20,    26,    25,    77,    78,    44,    14,    68,    49,
     110,   109,   111,    32,    28,    62,    18,    19,    29,    33,
      51,    50,    17,    48,    72,    52,    75,    39,     8,     9,
      40,    66,    10,    41,    67,    11,    42,    12,    56,    79,
      24,    53,    76,    35,    64,    60,     7,    45,    46,    47,
      69,    70,    71,    93,    74,   105,    31,   102,    83,    84,
      99,    85,   100,     5,    86,    43,    13,    96,    95,    97,
      63,    36,    65,    94,    98,    15,    16,   101,    73,    91,
      88,   106,   104,   112,    89,    57,     3,     4,    80,    38,
       6,    23,    22,    37,    30,   108,    27,  1240,    82,    92,
      81,    87,    61,    90,   107,    59,   103,  1337,  1324,  1373,
    1336,  1349,     0,  1339,  2596,  2597,    34,  1350,   114,   115,
     120,  2265,  2317,  2318,  2319,  2399,  2350,  2351,  2344,  2360,
    2370,  2359,  2363,  2371,  2358,  2377,     0,   117,   119,   121,
     124,   118,   113,   116,   123,   128,   122,   127,   125,   126,
     129,   130,   131,  2598,  1550,  2595,    58,  2335,  2334,     0,
    2399,     0,  2628,  1879,  1880,  1881,  1882,  1883,  1884,  1885,
    1886,  1887,  1888,  1889,  1890,  1891,  1892,  1893,  1894,  1895,
    1896,  1897,  1898,  1899,  1900,  1901,  1902,  1903,  1904,  1905,
    1906,  1907,  1908,  1909,  1910,  1911,  1912,  1913,  1914,  1915,
    1916,  1917,  1918,  1919,  1920,  1921,  1922,  1923,  1924,  1925,
    1926,  1927,  1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,
    1936,  1937,  1938,  1939,  1940,  1941,  1942,  1943,  1944,  1945,
    1946,  1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954,  1955,
    1956,  1957,  1958,  1959,  1960,  1961,  1962,  1963,  1964,  1965,
    1966,  1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,
    1976,  1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,  1985,
    1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,
    1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,
    2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,  2015,
    2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,  2025,
    2028,  2026,  2027,  2029,  2030,  2031,  2032,  2033,  2034,  2035,
    2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,  2045,
    2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,  2055,
    2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2065,
    2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,  2075,
    2076,  2077,  2078,  2079,  2080,  2081,  2082,  2083,  2084,  2085,
    2086,  2087,  2088,  2283,  2089,  2090,  2091,  2092,  2093,  2094,
    2095,  2096,  2097,  2098,  2099,  2100,  2101,  2102,  2103,  2104,
    2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,  2113,  2114,
    2115,  2116,  2117,  2118,  2119,  2301,  1868,  1876,  1877,  1878,
    2276,  2297,  2303,  2624,  2302,  1875,  2450,     0,     0,  2544,
    2545,  2546,  2547,  2548,  2549,  2599,  2600,  2601,  2602,  2603,
    2605,  2604,  2412,  2571,  2608,  2411,  2609,  2415,  2610,  2611,
    2612,  2613,  2572,  2614,  2414,  2606,  2568,  2416,  2409,  2410,
    2569,  2518,  2519,  1845,  2570,  2567,  2607,  2304,  2566,  2420,
    2419,  1314,  2623,  1844,  1315,     0,  2422,  2550,  2551,  2552,
    2553,  2555,  2554,  2556,  2187,  2188,  2189,  2190,  2191,  2192,
    2193,  2194,  2195,  2196,  2197,  2198,  2581,  2199,  2200,  2201,
    2594,  2202,  2203,  2582,  2204,  2205,  2206,  2207,  2208,  2209,
    2210,  2211,  2212,  2213,  2214,  2215,  2216,  2217,  2218,  2219,
    2220,  2221,  2222,  2223,  2224,  2225,  2226,  2227,  2583,  2584,
    2228,  2229,  2230,  2231,  2232,  2233,  2234,  2235,  2236,  2237,
    2238,  2239,  2240,  2241,  2242,  2243,  2244,  2245,  2246,  2247,
    2248,  2249,  2250,  2585,  2251,  2252,  2586,  2253,  2254,  2255,
    2587,  2256,  2257,  2258,  2259,  2260,  2591,  2592,  2593,  2580,
    2373,  2557,  2579,  2590,  2588,  2589,  2383,  2379,  2387,  2382,
       0,     0,     0,     0,  2399,  1153,  1152,  1138,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   527,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2273,     0,  1164,   332,   331,  1239,
    1220,   528,     0,  1141,   356,     0,     0,     0,     0,     0,
       0,     0,     0,   708,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   175,     0,     0,   380,   379,     0,     0,
       0,   904,   385,     0,     0,     0,     0,   516,  2282,  2277,
    2287,     0,  2280,  2281,  2566,     0,  2715,  2026,  2313,  2314,
    2713,  2074,  1316,   250,   253,   251,   252,     0,  1004,  1005,
    1007,     0,     0,  1017,   741,   742,     0,   740,   744,     0,
       0,     0,   737,     0,     0,     0,     0,   743,   735,     0,
     734,     0,     0,     0,   739,     0,   736,     0,     0,  1142,
       0,  2365,  2366,  1967,  1277,   386,     0,     0,  1350,     0,
    1240,  1247,  1257,  1252,  1254,  1253,  1255,  1251,  1256,  1880,
     843,  1894,   843,  1957,   840,   841,   843,   843,   843,  2041,
       0,     0,   815,     0,   826,  1871,   843,  1872,  2624,   848,
     441,   441,   441,     0,   847,   852,   441,  1135,  1171,  1849,
    1363,     0,  1894,  1957,   816,  1134,  2089,  1269,     0,     0,
    1021,     0,  1022,     0,  2056,  1146,   234,  2564,  2065,  2150,
    2089,  2565,   230,  2559,  2560,  2562,   204,  2563,  2561,  2558,
    1884,     0,     0,   847,     0,  1143,  1144,   801,  1370,  1368,
       0,     0,     0,  1902,     0,  1914,  1993,   227,  2052,  2057,
    2065,  2150,  2089,  2117,   184,   189,     0,   243,  2065,  2150,
    2089,     0,  1164,     0,  1340,  1450,  1840,     0,     0,  2374,
    1137,  1136,  1241,     0,  1244,     0,  1415,  2038,  1344,  1346,
    1246,  1337,     0,     0,  2264,  1235,  1367,  1367,     0,  1367,
       0,  1329,  1337,  1332,  1336,     0,     0,     0,     0,  1154,
       0,  2342,  2370,  2349,  2405,  2346,     0,     0,  2395,  2391,
    2388,  2396,  2397,  2390,  2378,  1539,  1540,  1541,  1538,  1551,
    1537,     0,  2323,  1542,  2362,  2329,     0,  2337,  2336,  2641,
    2642,  2452,  2275,  2294,     0,     0,     0,     0,     0,     0,
       0,  2421,  2423,  2425,  2385,  2384,  2380,     0,     0,     0,
       0,  2510,  2511,  2509,     0,  2506,  2508,     0,  2405,     0,
    2575,  2569,  2578,     0,  1850,  2570,  2567,  2566,     0,   751,
       0,   135,   892,     0,     0,     0,  1844,     0,     0,     0,
       0,     0,  1966,     0,     0,  1745,  1906,  1953,  1755,  1753,
    1754,  1747,  1748,  1749,  1750,  1751,  1752,     0,  1002,  1746,
       0,   135,     0,  1966,     0,     0,  1966,     0,     0,     0,
       0,     0,  1996,   135,  1966,     0,     0,     0,  1158,     0,
       0,     0,  1160,  1163,  1139,  1223,     0,  1840,     0,     0,
     785,   776,     0,   786,   777,   782,   788,     0,     0,   779,
       0,     0,   789,     0,   778,   780,   791,   781,   787,     0,
       0,   783,   784,     0,     0,  1150,   441,     0,     0,     0,
       0,     0,     0,   135,  1210,  1966,   135,     0,     0,   384,
     383,   135,   382,   381,  1906,  1953,     0,   931,   135,     0,
     177,   596,   531,     0,     0,   667,  1996,   135,     0,     0,
       0,     0,   907,     0,     0,   515,   528,     0,  2286,  2292,
       0,  2284,  2453,  2716,  2714,  2408,     0,  1008,   228,   229,
    1006,  1966,     0,   310,     0,     0,  1966,  1199,     0,   738,
    1966,     0,  1966,  1869,   170,     0,  1906,  1953,  1966,     0,
       0,  1966,   162,  1966,     0,  1966,   310,  1966,   532,     0,
    1966,     0,  1966,  1996,   164,     0,  1966,   310,   749,     0,
       0,  2646,  2650,     0,  2648,  2643,  2364,  2418,  2417,  2316,
       0,  2726,     0,  1316,  1249,  1262,     0,  1258,  1265,  1261,
    1350,   843,   842,     0,   843,     0,  2736,   843,     0,   843,
       0,  2736,   843,     0,     0,     0,   843,  1873,  1874,     0,
       0,  2735,  2731,  2734,   817,   827,     0,   849,     0,     0,
     856,   855,   854,     0,     0,     0,   857,  1454,  1292,     0,
     824,     0,   822,     0,  1132,  1149,     0,     0,     0,     0,
    1024,  1024,  1024,  1145,   233,   231,     0,     0,     0,     0,
       0,     0,  1151,     0,     0,     0,     0,  2630,  1856,  1756,
    2629,     0,  2121,  2122,  2123,  1814,     0,  2571,  2124,  2125,
    2166,  1668,  1655,  1664,  1669,  1656,  1658,  1665,  2126,  2127,
    1938,  2128,  2129,  1863,  2130,  2131,  1494,  2133,  2134,  2135,
    1660,  1662,  2136,  2137,     0,  1864,  2139,  2140,  2014,  2142,
    2143,  2145,  2146,  1666,  2148,  2149,  2150,  2151,  2152,  2153,
    1862,     0,  1667,  2154,  2156,  2157,  2158,  2159,  2160,  2161,
    2162,  2163,     0,     0,  1837,     0,  1640,     0,  1486,  1487,
    1509,  1510,  1488,  1515,  1516,  1528,  1489,     0,  1836,  1553,
    1639,  1645,     0,  1638,  1634,  1353,  1832,     0,  1635,  1852,
    1815,  1866,  1865,  2624,  1823,  1855,  1853,  1854,     0,     0,
       0,   196,     0,     0,  2499,   245,     0,   246,  1838,  2065,
     185,   226,   198,   225,   199,   197,     0,  1904,   186,     0,
       0,   187,     0,     0,     0,     0,     0,     0,     0,   239,
    1140,     0,  1452,  1451,     0,     0,  1821,  1841,   758,     0,
    1233,  1234,  1232,     0,  1229,  1231,  1243,  1240,  1828,  1827,
    1829,     0,  1345,     0,     0,     0,  1327,  1326,  1246,  1365,
    1366,     0,     0,     0,     0,     0,     0,     0,     0,  1408,
    1381,  1382,  1384,  1405,  1409,     0,  1333,     0,     0,  1456,
       0,  1416,  2263,  2405,  2406,     0,  2400,     0,  2399,  2399,
    2393,  2392,  2389,     0,     0,     0,     0,     0,     0,     0,
       0,  2320,   510,  2322,   507,     0,     0,  2296,     0,  2300,
    2298,     0,  2445,  2448,     0,  2446,  2447,  2449,     0,  2454,
    2455,     0,     0,     0,  2637,     0,     0,  2436,  2424,  2431,
    2433,  2435,  2434,  2443,  2439,  2442,  2444,  2386,  2399,  2517,
       0,  2512,  2515,     0,  2507,     0,     0,     0,  1851,     0,
       0,     0,     0,   752,     0,     0,     0,     0,     0,     0,
     134,  1197,   236,  1195,     0,     0,     0,     0,     0,     0,
       0,  1202,     0,   168,   169,   543,   528,     0,  1966,     0,
       0,     0,     0,   964,   971,     0,     0,     0,     0,     0,
       0,     0,   965,   963,   966,   238,   975,   988,   991,     0,
     882,     0,     0,     0,     0,  1067,     0,     0,  1067,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     256,   262,   305,     0,     0,     0,     0,     0,     0,     0,
       0,   139,     0,     0,     0,     0,     0,   494,   506,     0,
       0,     0,     0,     0,   503,     0,   135,   258,   487,   491,
       0,     0,     0,   605,   604,     0,  1067,     0,   254,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   324,   325,     0,     0,   139,     0,
       0,     0,     0,   260,     0,  2330,     0,  1159,  1156,  1157,
       0,  1162,     0,  1219,     0,     0,     0,     0,     0,   790,
       0,     0,  1906,  1953,     0,     0,     0,     0,     0,     0,
     359,   338,   339,   135,   337,     0,     0,   664,     0,  1497,
    1526,  1504,  1526,  1526,  1493,  1493,  1506,  1495,  1533,     0,
    1526,  1493,  1498,     0,  1496,  1536,  1536,  1521,     0,  1478,
    1479,  1480,  1481,  1507,  1508,  1482,  1513,  1514,  1483,  1550,
    2576,  1493,  2577,  2574,  2573,     0,     0,   675,     0,  1174,
    1209,     0,     0,   537,     0,  1966,     0,   137,   709,     0,
     665,     0,   137,     0,   173,     0,   600,     0,     0,     0,
       0,     0,     0,   625,   624,     0,     0,     0,   666,     0,
     137,   490,  1966,     0,   441,   441,     0,   906,   909,     0,
       0,     0,  2290,  2285,  2288,     0,  2278,  2292,  1319,  1321,
    1320,     0,  1318,     0,   310,   308,   309,   662,  1016,     0,
       0,     0,     0,   310,     0,     0,  1966,   310,  1966,     0,
    1966,     0,     0,   310,   310,     0,     0,     0,     0,   601,
       0,   748,   746,   745,   747,     0,     0,     0,     0,     0,
    1966,   310,     0,     0,   731,  2644,     0,     0,  2647,     0,
    2367,  1766,     0,  2732,  1274,  2729,     0,     0,  1350,     0,
     215,   216,   214,  1263,   217,  1264,  1260,  1248,     0,   835,
       0,  2736,  2737,   820,     0,   830,     0,  2736,   818,     0,
     831,   828,   829,     0,     0,     0,  2730,  2615,  2621,   834,
       0,     0,   442,   444,     0,     0,  1924,  1937,     0,  1958,
    1984,  1985,  2057,  2061,     0,  2084,  2093,     0,   858,   887,
     853,     0,     0,  1302,   825,   823,  1133,  1267,  1772,     0,
    1350,     0,  1023,  1020,  1019,  1018,   232,   205,     0,     0,
       0,   889,  2056,  1148,   800,   528,     0,     0,  1643,  1644,
    1525,  1512,  1813,     0,     0,  1520,  1519,     0,     0,     0,
       0,     0,  1502,  1501,  1500,  1642,  1780,     0,  1499,     0,
       0,     0,     0,  1526,  1526,  1524,  1573,     0,  1503,     0,
       0,  1793,     0,  1799,     0,     0,     0,  1532,     0,  1530,
       0,     0,  1609,     0,     0,     0,     0,     0,     0,     0,
       0,  1557,  1558,  2572,  1640,  1766,     0,  1641,  1859,     0,
       0,  1518,     0,  1550,  1756,     0,     0,     0,     0,  1826,
       0,  1764,     0,     0,  1587,  1762,     0,  1589,     0,     0,
       0,  1755,  1753,  1754,  1747,  1748,  1749,  1750,  1751,  1752,
    1760,  1570,     0,  1835,     0,  1569,     0,     0,  1418,  1352,
       0,  1857,  1816,     0,  2622,  2625,  1636,  2496,  2495,  2494,
    2493,  2464,     0,  2458,  2459,     0,  2497,  2498,   247,   248,
     244,     0,     0,   201,   200,     0,   223,   224,   195,   222,
       0,   218,   219,   203,  1708,  1707,   202,   194,   192,   190,
     206,   208,   209,   193,   191,   242,   240,     0,     0,     0,
    1818,  1817,  1847,  1822,     0,     0,   310,  2399,  1227,     0,
    1224,  1831,     0,  1347,     0,  1842,     0,  1236,  1343,  1342,
    1374,  1375,   924,  1341,  1399,  1400,  1395,     0,  1414,  1414,
    1391,  1385,  1390,  1388,     0,  1392,  1553,  1407,  1331,  1379,
    1380,  1383,  1330,     0,  1410,  1408,  1384,  1289,     0,     0,
    1457,     0,     0,  2407,  2405,  2345,  1478,  2399,  2338,  2399,
    2394,  2326,  1544,  1545,  1546,  1547,  1548,  1549,  2327,     0,
    2324,  1543,  2325,   508,   509,     0,     0,     0,  2293,     0,
    2274,  2299,  2430,  2539,  2462,     0,  2463,     0,     0,  2427,
       0,  2437,  2440,  2438,  2441,     0,  1478,  2618,  2513,  2618,
    1478,     0,     0,     0,     0,     0,     0,     0,     0,   753,
       0,     0,     0,     0,     0,     0,  2084,   235,  1193,     0,
       0,     0,     0,   891,   890,     0,     0,   911,     0,     0,
       0,  1205,   430,     0,   307,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   541,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   575,     0,  1067,     0,   613,     0,   973,     0,   972,
       0,     0,     0,   974,   969,   970,  2057,  2065,  2089,   237,
     990,     0,   989,   987,   946,   948,   947,     0,   950,   934,
       0,   935,     0,     0,   945,   953,   951,     0,     0,     0,
       0,  1946,   264,   277,     0,  1066,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   297,     0,   300,   299,
       0,     0,     0,     0,   304,     0,     0,     0,   303,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1003,     0,
       0,   156,     0,   159,     0,     0,     0,   493,   505,     0,
     497,   498,   495,   499,   500,     0,     0,     0,     0,     0,
       0,   492,     0,     0,   598,   597,   603,     0,     0,     0,
       0,     0,     0,     0,  1059,  1058,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     616,   617,     0,   618,     0,   160,   161,     0,     0,     0,
       0,     0,     0,     0,   213,  1155,  1161,  1222,  1848,  1221,
       0,     0,     0,   792,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,     0,   690,  2573,   663,     0,  1478,     0,  1474,  1470,
    1539,  1538,  1537,     0,  1484,  1493,  1490,   676,     0,   678,
     681,     0,  1172,   403,     0,   534,   575,     0,     0,     0,
     166,     0,     0,     0,   133,   177,   386,     0,   176,   178,
     180,   181,   182,   179,   183,   595,   599,     0,   530,     0,
       0,     0,     0,     0,   626,   630,   629,   633,   631,     0,
     627,     0,     0,  1466,     0,   155,   486,   489,     0,  2271,
       0,   388,   472,   317,     0,     0,   908,     0,     0,     0,
       0,     0,  2291,     0,     0,     0,     0,  1317,     0,   994,
       0,  1200,  1966,   310,     0,   992,   171,  1870,     0,   732,
       0,     0,     0,     0,     0,   996,   728,   163,     0,   310,
     310,   533,     0,   310,   165,     0,     0,     0,   525,   310,
     750,  2645,  2651,  2649,  1276,     0,  2733,  2727,  2728,   441,
    1321,  1250,  1259,   832,   839,   821,   838,   837,   819,   836,
     833,  2429,     0,     0,  2620,     0,   850,     0,   440,     0,
       0,     0,   864,   865,     0,     0,   863,   880,   866,     0,
     868,   860,   859,   869,   870,     0,     0,   889,     0,  1299,
       0,  1297,     0,  1455,  1301,  1290,  1268,     0,  1266,  1271,
    1273,  1272,  1270,     0,     0,     0,   847,     0,     0,   310,
    1147,     0,   802,   803,   808,     0,     0,     0,   809,   805,
     806,   807,   810,   811,   812,     0,     0,     0,  1776,     0,
    1777,     0,     0,     0,  1812,  1808,     0,     0,     0,     0,
       0,     0,  1784,  1785,  1786,  1783,  1787,  1782,     0,     0,
    1788,  1781,     0,     0,     0,     0,     0,  1523,  1522,     0,
       0,     0,     0,     0,     0,     0,  1612,  1645,     0,     0,
    1740,     0,  1766,  1798,     0,     0,  1534,     0,     0,     0,
       0,     0,     0,     0,  1766,  1804,     0,     0,     0,     0,
    1706,     0,  1703,     0,     0,     0,     0,  1823,     0,     0,
       0,     0,  1860,  1554,  1571,  1834,     0,  1825,     0,     0,
    1555,  1578,     0,  1805,  1605,     0,  1610,  1593,     0,  1586,
       0,  1591,  1595,  1574,  1826,  1765,     0,  1763,     0,     0,
    1572,     0,  1567,  1565,  1566,  1559,  1560,  1561,  1562,  1563,
    1564,  1568,  1744,  1742,  1743,     0,     0,     0,  1590,  1960,
    1993,     0,  1364,  1364,  1364,  1351,  1362,  1833,     0,  1461,
       0,     0,     0,     0,  1723,     0,  1770,     0,  1768,  1850,
    2627,  2626,  1824,     0,     0,     0,  1839,     0,     0,  1550,
       0,   241,  1453,  1819,     0,   756,   757,   755,  1478,  1246,
    1230,  1226,  1225,  1830,  1245,     0,  1350,     0,   922,   923,
       0,   927,     0,     0,  1393,  1406,     0,  1302,  1302,     0,
    1397,  1398,  1389,  1335,  1334,     0,  1464,     0,     0,  1286,
    1279,  1458,     0,  1418,  1304,  1306,  1307,     0,  1823,  2343,
    2401,  2348,  2369,  2339,  2372,  1552,  2321,  2361,     0,  2295,
    2465,  2466,     0,  2456,  2457,  2426,  2432,  2503,     0,  2619,
       0,     0,   688,   687,     0,     0,     0,  1093,  1026,  1071,
     754,  1094,  1027,  1072,  1095,  1028,  1194,     0,  1196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   651,  1966,   310,  1203,  1096,     0,  1029,
     306,  1204,  1073,  1208,  1074,     0,   542,     0,     0,   547,
     548,   549,     0,     0,   550,  1906,  1953,     0,   555,   561,
     565,   556,     0,   566,   562,     0,     0,     0,     0,     0,
       0,   572,   574,     0,     0,     0,     0,     0,     0,   967,
     968,  1097,  1032,     0,  1075,   949,  1493,   933,     0,     0,
     944,     0,   943,  1493,  1493,  1033,   167,     0,   257,   265,
     581,  1069,   283,   296,   291,   292,   290,  1966,   310,  1966,
     310,     0,     0,     0,     0,   293,   288,   289,   285,   298,
    1883,  1939,  2066,     0,   585,   587,     0,   592,   301,  1045,
       0,   318,   321,   302,   281,   284,   282,   278,   263,     0,
       0,  1846,     0,     0,   998,     0,     0,     0,   158,  1055,
       0,     0,   144,     0,     0,     0,     0,   138,   148,  1103,
    1037,     0,     0,   259,   488,   496,   501,  1041,   504,  1085,
     502,  1109,  1038,  1067,     0,   255,     0,  1039,     0,  1079,
    1105,  1057,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1211,     0,     0,     0,     0,     0,   310,     0,   697,
    1069,  1966,   310,  1104,     0,  1064,  1091,     0,   326,     0,
    1056,     0,     0,   261,  1043,  1087,     0,     0,   211,   210,
     212,     0,     0,     0,     0,     0,     0,     0,     0,   794,
     765,   793,     0,     0,     0,     0,     0,     0,     0,   759,
     358,   335,   336,     0,     0,   334,   340,   689,     0,     0,
       0,  1475,  1471,     0,     0,     0,     0,     0,     0,  1491,
     677,     0,     0,     0,     0,  1192,  1192,  1192,  1192,  1192,
    1192,  1192,  1173,  1201,   135,     0,     0,     0,   536,   574,
     581,     0,   609,   612,     0,   610,     0,     0,     0,     0,
       0,   149,   136,     0,   717,   441,   172,     0,     0,     0,
     529,   674,   672,   671,   673,     0,     0,     0,   694,   670,
       0,  1465,  1467,     0,     0,     0,     0,   390,     0,     0,
     387,   391,   395,   396,   397,   444,     0,     0,   476,     0,
       0,     0,     0,   938,     0,   956,   939,     0,     0,     0,
     978,   983,   979,   959,     0,   513,  2289,  2283,  1322,  1323,
       0,   310,     0,     0,   576,   310,   310,     0,   310,     0,
     310,   310,     0,  1130,   602,     0,   659,     0,     0,   310,
     730,  1767,     0,  2428,  2616,   851,   443,     0,     0,     0,
       0,   862,     0,   511,   867,     0,   879,   874,   876,     0,
     883,  1300,  1293,  1295,  1294,     0,     0,  1291,  1773,   729,
       0,     0,   310,     0,   884,     0,   804,     0,     0,     0,
       0,  1369,  1774,  1775,     0,     0,     0,     0,  1809,     0,
       0,  1681,     0,  1657,  1659,  1492,  1671,     0,  1505,  1682,
    1683,  1661,  1663,     0,  1757,     0,     0,  1672,  1614,  1615,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1627,  1626,  1673,  1739,     0,     0,  1796,
    1797,  1674,  1535,  1536,  1536,     0,     0,  1803,     0,     0,
       0,  1679,  1684,     0,     0,     0,     0,  1690,     0,  1711,
       0,     0,     0,  1637,  1767,  1527,  1528,     0,     0,     0,
       0,     0,     0,     0,     0,  1611,  1594,  1588,     0,  1592,
    1596,     0,     0,     0,     0,  1580,  1606,  1576,     0,     0,
    1582,     0,  1607,  1364,  1364,  1364,  1364,  1361,     0,     0,
       0,     0,  1428,  1417,  1419,  1430,  1421,  1423,  1459,     0,
    1840,     0,  1402,  1373,  1373,     0,  1723,     0,  1646,     0,
    1723,     0,     0,  2478,  2480,  2481,  2482,  2483,  2484,  2486,
    2487,  2489,  2490,  2491,  2479,  2485,  2488,  2492,  2469,  2470,
       0,  2460,  2461,   188,     0,   220,   207,     0,  2503,  1228,
    1843,     0,  1376,     0,  1758,   927,   925,   926,  1378,     0,
       0,  1413,  1412,  1411,  1386,  1288,     0,  1286,  1281,     0,
    1282,  1823,     0,  1278,  1311,     0,     0,  1464,     0,  1310,
       0,  2403,  2331,     0,     0,  2502,  2505,  2516,  2514,  2341,
    1092,  1025,  1070,  1192,   894,   895,     0,   893,     0,     0,
       0,   429,   910,     0,     0,     0,   651,     0,     0,   433,
       0,  1206,     0,   544,   545,     0,     0,   563,     0,     0,
     552,     0,     0,     0,     0,   551,   568,   517,   569,   571,
       0,     0,   570,   573,   578,  1067,     0,   614,  1047,     0,
    1089,   961,     0,  1493,   936,   941,   942,     0,     0,     0,
     403,     0,     0,     0,   266,   276,     0,     0,   280,     0,
     274,   294,   286,   295,   287,   589,   590,   588,   584,     0,
     591,   593,   315,     0,     0,     0,  1099,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1100,  1076,
       0,     0,   141,   140,     0,   147,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   327,   312,
       0,     0,     0,     0,     0,   329,     0,     0,     0,     0,
    1098,  1034,   760,     0,     0,   761,   769,     0,     0,   762,
       0,     0,     0,     0,     0,     0,   771,   361,     0,   364,
     371,   344,   348,  1210,     0,  1210,     0,   349,  1210,   345,
    1210,   342,   691,     0,  2014,  1747,  1748,   685,   692,   682,
     684,   683,   686,   651,     0,     0,     0,  1476,     0,  2717,
    2725,  2724,     0,  1550,   679,   680,     0,  1192,  1191,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     415,     0,     0,   409,     0,     0,   983,   402,   405,   406,
     537,   540,   538,   539,   567,     0,   608,     0,   581,   151,
       0,     0,   152,   150,     0,   317,   386,     0,     0,   632,
     635,   628,     0,   693,   695,   668,     0,   581,     0,  1277,
     485,     0,   472,   422,   468,     0,   470,   469,   471,     0,
     478,   316,     0,     0,   911,   937,     0,     0,     0,   976,
     980,   977,     0,     0,   952,     0,   960,   930,  1125,  1126,
    1123,  1124,     0,     0,  2306,  1313,  2315,   995,     0,   310,
     993,   733,     0,   724,     0,   726,   997,   310,   310,   619,
       0,   526,     0,     0,     0,     0,   861,   881,     0,   877,
       0,     0,   844,   886,  1298,  1296,   889,     0,   845,   888,
       0,     0,     0,     0,     0,  1778,  1511,     0,  1811,  1807,
       0,  1654,  1779,     0,  1791,  1790,  1613,  1792,     0,  1632,
       0,     0,  1624,  1622,  1623,  1616,  1617,  1618,  1619,  1620,
    1621,  1625,  1801,  1800,  1794,  1795,  1531,  1529,     0,  1676,
    1677,  1678,  1802,  1685,     0,  1897,  1712,  1689,  1705,  1704,
       0,     0,     0,  1692,     0,     0,  1701,     0,  1741,  1517,
    1550,  1556,     0,     0,  1579,  1806,  1597,     0,     0,     0,
    1575,     0,     0,     0,     0,  1584,  1757,     0,     0,     0,
       0,     0,     0,  1355,  1354,  1360,  1337,     0,  1430,     0,
    1429,  1441,     0,     0,  1447,  1445,     0,  1447,     0,  1447,
       0,  1422,     0,  1424,  1441,     0,  1841,  1460,     0,  1404,
       0,     0,  1372,     0,  1723,  1653,  1726,  1721,  1722,  1771,
    1647,  1858,     0,  1769,  1723,     0,     0,     0,  1820,  2501,
    1348,     0,  1377,  1394,  1387,     0,  1462,  1287,     0,     0,
    1284,  2732,     0,     0,  1305,  1286,  1308,  2347,     0,  2402,
    2467,  2468,     0,   900,   901,   899,   902,     0,     0,     0,
     651,     0,     0,   449,     0,   918,   918,     0,     0,   435,
     481,   983,   654,     0,     0,     0,   652,   310,  1030,     0,
     564,     0,     0,   560,   558,   557,   559,   518,  1108,  1031,
       0,     0,     0,     0,   962,     0,   954,  1046,     0,   400,
       0,   271,  1068,     0,     0,     0,   270,     0,   310,   310,
     586,   319,   320,   323,     0,     0,     0,     0,     0,     0,
     718,   701,     0,     0,   719,   720,     0,     0,     0,  1000,
    1001,   999,   145,   142,   143,   146,  1042,  1086,  1040,     0,
    1080,  1051,  1049,     0,     0,     0,     0,     0,  1107,  1063,
    1084,  1106,  1061,  1082,  1060,  1081,  1062,  1083,  1054,     0,
    1469,   699,   698,     0,   310,   310,   621,  1044,  1088,     0,
     763,     0,     0,   764,   775,   773,   772,   774,   766,   362,
     135,     0,   341,     0,   369,     0,   367,   366,   368,     0,
     355,     0,     0,     0,     0,     0,   661,     0,     0,     0,
    1472,     0,     0,     0,     0,     0,     0,  1477,  1485,   650,
       0,  1183,  1182,  1181,  1185,  1184,  1187,  1186,  1178,  1177,
    1190,  1189,  1176,  1175,  1180,  1179,     0,   407,     0,   413,
     417,   418,   416,   408,   983,   441,   480,   535,     0,   611,
     606,   154,   153,     0,     0,     0,     0,   637,   641,   669,
       0,  1468,   615,     0,   388,   485,     0,  2272,     0,   393,
     398,   399,     0,   476,   419,     0,   472,   392,     0,     0,
     482,  1170,     0,     0,   940,   957,   958,     0,     0,   983,
     982,     0,   520,     0,  2279,   310,   577,   310,   310,  1131,
     660,     0,   873,   872,   871,   512,     0,   875,   310,     0,
       0,     0,     0,     0,   814,   795,   813,  1810,  1670,  1680,
    1789,     0,     0,  1633,     0,     0,  1675,  2155,     0,     0,
       0,     0,  1709,  1710,  1691,     0,  2005,  1696,     0,     0,
       0,  1861,  1603,  1601,  1598,     0,  1599,     0,     0,  1581,
    1577,     0,  1583,  1608,  1359,  1358,  1357,  1356,  1432,  1439,
       0,  1420,     0,  1446,  1442,     0,  1443,     0,     0,  1444,
       0,     0,  1439,     0,     0,     0,     0,  1717,  1723,  1723,
    1648,  1728,  1725,     0,  1650,  2471,     0,  2474,  2472,  2473,
    2477,  1550,     0,     0,  1280,  1283,  1285,     0,  1312,  1303,
    2404,  1198,     0,     0,     0,   431,     0,   983,     0,     0,
       0,   921,   921,     0,   983,   480,   656,   655,   658,   653,
     657,  1207,     0,   553,   554,  1048,     0,  1090,  1052,   955,
       0,   582,   267,   268,   269,   272,   312,   279,   273,     0,
    1101,  1035,  1077,     0,     0,   707,     0,     0,     0,     0,
    1102,  1036,  1078,     0,     0,     0,     0,  1216,     0,   311,
     312,   328,  1065,     0,   767,   768,   343,     0,   365,   374,
       0,   372,   346,   351,     0,   353,   352,   347,   350,  1473,
       0,  1014,  1014,  2718,  2719,  2720,  2721,  2722,  2723,     0,
     651,  1188,     0,     0,   404,   480,   448,     0,   410,     0,
       0,     0,   388,   581,   636,     0,     0,     0,   696,   390,
       0,  1275,   483,     0,   389,     0,     0,   478,     0,     0,
       0,   476,     0,   473,     0,   477,     0,  1165,     0,     0,
     981,     0,   985,     0,   951,   928,  1461,     0,   524,  2305,
    2309,  1015,   725,   727,   620,   878,   885,   310,   796,   797,
     798,   799,  1628,     0,     0,     0,     0,  1686,     0,  1687,
    1714,  1713,  1693,  1697,     0,  1694,  1695,  1600,  1604,  1602,
    1585,  1431,     0,     0,  1433,     0,     0,  1435,  1437,     0,
       0,     0,     0,     0,  1844,  1723,  1401,  1403,     0,  1338,
    1651,  1652,     0,  1373,  1723,  2476,  2475,   221,  1759,  1463,
    1309,   879,     0,   310,   918,   480,   450,  2014,   451,   917,
       0,   919,   924,   924,     0,   480,   651,   546,     0,   580,
       0,   314,   322,     0,     0,   714,   702,     0,     0,   721,
    1050,     0,     0,     0,     0,     0,   310,   770,   333,   360,
     370,     0,   354,  1014,     0,  1011,  1010,   649,     0,   439,
     411,     0,   459,     0,   581,   711,  1170,   594,   638,   639,
     634,     0,     0,   472,   468,   484,   394,   403,   377,   428,
     427,   424,   423,   425,   426,   421,   420,     0,   478,   474,
     475,     0,     0,     0,  1218,     0,   912,   984,     0,     0,
       0,   519,     0,     0,   523,   514,     0,  2307,   846,  1629,
       0,  1630,     0,     0,     0,  1699,  1698,     0,  1440,  1449,
       0,  1436,  1434,  1425,     0,  1427,  1716,  1718,     0,     0,
    1731,  1649,   896,     0,   897,   921,   454,     0,   920,   927,
     927,   441,   651,   432,  1053,   583,     0,   275,     0,   705,
       0,   716,   714,     0,     0,  1212,     0,  1213,  1214,  1217,
     330,   373,  1009,  1013,  1012,     0,     0,   412,   445,   446,
     447,     0,   414,   455,   456,     0,   607,     0,     0,  1166,
       0,     0,   476,   472,   401,   467,   375,     0,  1167,     0,
     317,     0,   983,   986,  1129,   522,   521,  2310,  2312,  2311,
       0,  1631,  1702,  1688,  1715,  1700,  1438,     0,  1426,     0,
       0,  1727,     0,     0,     0,     0,   924,     0,   651,     0,
     915,   914,   448,   434,   313,     0,     0,   712,   715,   703,
     716,   723,   722,     0,     0,   438,     0,     0,     0,   457,
       0,   458,   479,   710,     0,   640,     0,   478,   476,  1168,
    1169,   478,   913,   929,  1128,  1127,  1350,  2308,  1448,  1719,
    1720,  2120,     0,  2095,     0,  1729,  1732,  1730,  1724,   310,
     927,     0,   436,   452,   459,     0,     0,   704,  1215,   641,
     464,     0,   463,     0,   461,   460,   700,   644,   378,   478,
    1461,  1111,  1350,  1110,  1112,  1120,  1117,  1119,  1118,  1116,
       0,  1736,  1735,  1734,  1738,  1737,   898,   916,     0,   651,
     706,   713,     0,   462,   466,   465,     0,   642,   645,   648,
     646,   647,   376,   903,     0,  1121,  1115,  1337,  1324,     0,
     453,   437,     0,   622,     0,  1113,  1350,  1733,     0,   643,
    1114,     0,   644,     0,   623
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4308, -4308,  3736, -4308, -1160,   326,  2286, -1100, -4308, -4308,
   -4308,  2902, -4308, -4308, -4308, -4308, -4308, -4308, -4308,  2931,
   -4308, -4308, -4308,  1500, -4308, -4308,   -59, -1560,  1445,  2543,
    1184, -4308, -1347, -4308, -4308,  -862,    -7, -1392, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -1103,  1647,  1008,  4075,
   -2511, -4308, -1672, -3689, -4308,   425, -4308, -4308,  1590, -4308,
   -4308, -4308,   877,  -365, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308,   -91, -4308, -4308,  -537, -1815,  -113,  -159,  -402, -4308,
   -4308,   263,  -406, -1695, -4308, -3524, -4308,  -126, -4308, -4308,
   -4308,  -409, -1666,  1107, -4308,  -981, -1373,  1420,  -698, -4308,
    -290, -4308,  -743,  -640,  -638,  -701,  -534, -3697, -4111, -4279,
   -3435,  1121, -4308,  -133, -1806, -4308, -4308, -1744, -1681, -4308,
    -712, -4308, -4308, -4308, -2991, -4308, -4308, -4308, -4308,  -101,
   -4308, -4308, -4308, -4308,   325, -4308, -4308, -4308, -4308, -4308,
   -4308, -2737,  1570,  1571, -4308, -4308, -3178, -4308, -1175, -4308,
     480, -3036,  1050, -4308, -4308, -4308,  2257, -4308, -4308, -4308,
   -4308,   337, -4308,   338, -4308, -4308, -1840, -4308, -4308, -1805,
   -4308,  1583,   869, -4308, -4308, -4308,  -711,  -773,  -761, -4308,
   -3495, -4308, -4308, -4308, -4308, -4308, -1243, -4308,   923, -3130,
   -1207, -4308, -4308,   939, -4308, -4308, -4308, -4308,  -665,  -273,
    2287, -4308,  -565,  -642, -4308, -4308, -4308,  -269, -4308, -4308,
   -4308, -4308, -4308, -4308, -1307,  5389, -1825, -4308, -4308, -4308,
   -4308, -2301, -4308, -4308, -4308, -1785, -4308,  4014,     1,   131,
   -1801, -4308,  -202,  -114,  2797, -1376, -2699,   284,  -412, -4308,
   -2013, -4308, -4308, -4308, -2596, -4308, -4308, -4308, -4308, -3465,
   -1792, -4308, -4308, -4308,   346, -4308, -4090, -3907, -4176, -3527,
   -3439, -4308, -4308, -1313, -4308, -4308, -4308, -1620,  1788, -1696,
   -4308, -2309,   334, -3714,  -994, -3258, -4308, -3662,  -497, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -1306,  -860, -4308, -4308,
    3313, -4308, -3448, -4308, -4308, -4308, -4308,  1174, -4308, -1700,
    1025, -4308, -4308, -4308, -4308, -4308,  -634,  -718, -4308, -4308,
   -4308,   206, -4308, -4308, -4308, -4308,  1581, -1191,  -996,  3175,
   -1789,  -443, -4308, -4308, -4308, -4308, -3034, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308, -1277, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308,  1986,  1988,  -105,  -212, -4308, -4308, -1484, -4308,
    -795, -4308,  2227, -4308, -4308, -4308, -4308,  1293,   258,   382,
     -74, -4308, -4308,   173, -3389,   -64, -4308, -4308, -4308, -4308,
    -274,   -61, -4308,   648, -4308, -4308, -2828, -4308,   294,   -77,
    2888,  1545,   -62,   201,  -245,  -214,  -208,   -75,  3176,  2653,
   -4308, -4308, -4308,  -204,  1946, -4308, -1081,  -354, -4308,  1301,
    -900,  1966,  2645,  2647, -4308,  1299, -4308, -4308,  1307, -4308,
   -4308, -4308,  -895,  1974, -4308,  2648,  1995, -4308,  1294,  1305,
   -3371,   751, -3360,   245,  -990,  -326,   -84,  3208,  2663, -4308,
   -4307,   679, -4308, -3452, -2411, -1163, -2115, -1838, -4308, -4308,
   -1389, 11306, -4308, -4308, -4308, 14967, 16009, -4308, -4308, 18178,
   19596, -4308, -1229,   792, 20084, 10750, -1441, -1842, -1541, 18325,
     375,   712, -2750, -4308, -4308, -4308,  -297,   803,   229, -4308,
   -4308, -4308, -4308,  -536, -2847,  -538, -4308, -4308, -4308,  -539,
   -4023,  1039, -4308,  -763, -4308, 19535,  1335, -4308, -1223, -2749,
   -2760, -1390, -1966, -4308, -4308, -4308, -4308, -4308, -4308, -4308,
   -1252, -3257,  -626,  1410, -4308, -4308,  1504, -4308, -4308, -4308,
   -1539, -1132, -2670,  1415, -2161, -4308, -1092,   698,  2104, -1032,
    4734, -1533, 16241,  -119, -2410, -1514, -1764, -4308,   287, -4308,
    3361,  4281,  -873,  -165,  -843,  5926,  3974,  5236, -3107, -4308,
   -4308,   297, -4308, -4308, -4308,  3669,   946, -4308,  2994, -4308,
    1645,  2348, -4308, -4308,  1978,  -939,    40, -4308,  -512, -4308,
    -128, -4308, -4308, -4308,   164, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308, -4308, -4308,  2672, -4308, -4308, -1453, -4308, -4308,
   -4308, -4308, -4308,  3923,  -294, -4308,  3351,  -277, -4308, -4308,
   -4308, -4308, -4308, -4308, -4308, -4308, -4308,  2679,  2011, -4308,
    3149, -4308, -4308, -4308,   -68,  2903, -4308, -4308, -4308, -1181,
    -583,  3177,  3180,  1975, -4308, -4308, -4308, -4308, -4308, -4308,
   -4308, -4308,  1985, -4308, -4308,  1390, -2150,  1993, -4308, -4308,
     713, -4308, -4308,   265, -4308,   718, -4308,  2789, -4308, -4308,
   -4308,   749, -4308, -4308, -4308,  -591, 13882,    42,    11,    91,
    1331, -4308,  8653,  6813,    21,  2696,   -34, 11531, 18131,   -17,
   -4308,  3916,  1990,  1613, -1000, -4308,  3446,  2295, 16826, -4308,
    -997,   300,  1621, -4308,    -2,  -675, -1168,  2982,  -740, -1954,
   -4308,  4333, -4308, -3536, -4308, -1033,   273,  3355, -1202
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   247,   248,  1701,  2600,  2481,  3291,  3292,   249,
     250,  1772,   251,   252,   253,   254,   255,   256,   257,  1716,
     258,   259,  1279,  1914,  2608,   260,  2357,  1055,  1056,  2229,
    2230,  2545,  2231,  2218,  1552,  2014,  1735,  1703,  1736,   262,
     263,  1546,  2210,   264,   265,   266,  1760,  1761,  1711,  1957,
    4190,  4757,  2468,  3330,  3130,  3131,   267,  1814,  1815,   268,
     269,  3243,  1853,  3245,  3246,  3781,   865,  2569,  4210,  4211,
    3768,  3769,  4217,  4490,  4491,   270,  1911,  3319,  3862,  3320,
    4288,  3321,  4289,  3322,  4290,  3273,  3827,  3828,  3829,  3323,
    4294,  4695,  3324,  2372,  4777,  2642,  2044,  2042,  4672,  4092,
    4093,  4828,  4782,  4783,  4784,  4894,  4296,  3328,  3870,  4300,
    4518,  3033,  1933,  4287,   271,   272,  2636,  1788,  1789,  2489,
    3787,  3384,   273,  1296,  3646,  4558,  4714,  4715,   274,   853,
     275,  1918,   276,   277,  2595,  3278,   278,  2384,  3046,   279,
     280,  3071,  3072,  3073,   281,   282,  3670,  4450,  1762,  3123,
    3124,  3125,  3126,  3690,   283,  1916,  1794,  2617,   284,   285,
     286,  2599,  3284,  3285,   287,   288,  2532,   289,   290,   291,
    1926,  2629,  2630,  4278,  4525,  4680,  4527,  4926,  4927,  4510,
    3629,  4106,   292,   293,   294,   295,  1897,  2588,  2589,  3788,
    1687,  1857,  2571,  2572,  3852,  3853,   296,   297,  4150,  4151,
     895,  4788,  4761,  4839,   298,   299,  4154,  4155,   300,   301,
     302,   303,   304,   948,  1347,  1348,  1693,   305,  2246,   306,
    1254,  3230,   307,  1435,  2776,  4335,   308,   982,  1372,  1373,
     309,   310,   993,  2756,   995,  2057,  3386,  3387,  3922,  2726,
    1179,   311,   312,  2737,  2759,   313,  1704,  2363,  2364,  4087,
     314,   896,  1938,  2645,  3028,  4705,  4094,  4431,  4632,  2951,
    3578,   315,   897,  1740,  2430,  2648,  3334,  3335,  2432,  2915,
    3883,  2434,  3336,  3341,  3342,  3343,  3879,  3887,  4552,  4553,
     316,  1738,  2423,   317,   318,   319,  1767,  1197,   320,   918,
     919,   321,  4665,   322,  1315,   323,  1013,  2073,   324,  2446,
    3676,   325,   326,   327,  4903,  4934,  4935,  4936,  3892,  4866,
     328,  4905,  1414,   330,   331,   332,   856,  1222,  1223,  1224,
     333,  4547,   334,   335,  2592,  3272,  3809,   336,   337,  2358,
    3018,   338,   339,   340,  1901,   341,   342,   343,   344,  1833,
     345,  1583,  1584,   346,   347,   860,  1074,  1587,  1595,   348,
     961,  1366,  1367,  1368,  2016,   349,  1418,  2748,   962,  1361,
     963,  2969,  3589,  3590,  3593,   964,  2966,   353,  2063,  2742,
    2745,   965,  2973,  2974,  2975,  2976,  2977,  3595,   966,   984,
    1306,  2656,   967,  1506,   358,   359,   360,  1083,  1078,  1079,
     362,  2188,  2905,  1001,  1601,  1040,  1090,  4042,  2260,  2261,
    2281,  2282,  1610,  1611,  2271,  2273,  2953,  2274,  2962,  2266,
    4039,  4397,  2277,  2278,  1613,  1614,  2957,   363,  2909,  3523,
    3524,  3525,  4020,  4030,  4384,  4597,  3526,  1408,  1620,  3527,
    3532,  3587,  3310,  3311,  3312,  2435,  2579,  1879,  1507,  1880,
    2586,  1508,  2108,  1882,  1509,  1510,  1511,  1885,  1512,  1513,
    1514,  1515,  2091,  2151,  1516,  1517,  2127,  1122,  1123,  2001,
    2815,  1519,  1520,  3986,  4359,  4348,  2841,  2842,  2226,  3982,
    3475,  4609,  4736,  4737,  4050,  4047,  4401,  4613,  4824,  4875,
    4876,  1521,  2895,  2180,  1199,  1522,  3790,  2182,  2835,  2917,
    2918,  2342,  2089,  2781,  2798,  2799,  2812,  3436,  2819,  2824,
    3459,  3460,  2836,  2864,  1523,  2784,  2785,  3419,  2093,  1524,
    1576,  1577,  2196,  2859,  1590,  1591,  1076,  1525,  1526,  2058,
    1065,  4593,   711,   694,  3140,  2241,  1226,   998,  1527,  1528,
    1529,  1323,  1324,  1642,   656,   695,   696,  1160,   807,     2,
      75,   968,  3316,   367,   368,   899,   900,   901,  1298,  1299,
    1943,  1946,  1647,  2320,   660,   661,   712,  4314,  4559,  4717,
     954,   369,   370,   371,   372,  1643,  2316,  1124,    76,    84,
      77,  1125,   409,   410,  2297,   373,   824,   374,  1623,  1104,
    3601,   375,   376,   377,   378,   379,   951,   380,  1106,   381,
    1107,   382,   383,   384,   385,  1114,   386,  1625,  1626,  4079,
    1627,   387,   388,   698,   699,  1359,   389,   390,  1141,  1142,
    1391,  1392,  1653,  1668,  1669,  1670,   391,   668,   392,   393,
     394,  1659,  1660,   395,  2203,  2204,  2325,  2205,   396,  2990,
    2991,   397,  3558,  3559,  4408,  3560,   398,  2199,   399,   400,
    1068,  3606,   401,   820,   402,  1155,   700,   701,   702,  1162,
     810,  1026,   713,  1164,  3127,   812,   813,   704,   705,   706,
    2036,    78,  2998,  2037,  1531,   714,  1532,  2194,  1533,  1534,
    1535,  1536,  1537,  1676,   708,  1131,  1351,  1352,  2999,  1354,
      82,  1355,   406,  3802,  2004,  1393,  2697,  2022,  2023
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      81,  1082,   986,   361,   351,  1091,  1621,  1032,  1963,  1400,
    1401,  1402,  1615,  1547,   352,  1406,   356,   354,  1967,   710,
    1276,  2013,   986,  1973,  1067,  2041,   910,  2069,  1569,   716,
    1793,  1688,  1831,  1910,   898,  2576,  2727,   894,  2243,  2371,
    1139,  1771,  1928,  2433,   404,  2693,  2129,  2584,  2451,  2442,
     404,  1856,  2923,  1818,  2080,  1307,  1561,   994,  3402,   947,
     960,  2254,  1332,  3142,   854,   858,  2585,  3538,  2547,  2102,
    2103,   261,  1344,  1329,  1308,  1007,   405,  1198,  2443,  3652,
     912,  1101,   405,  3886,  3685,  2464,  3687,   665,  2118,  2634,
     361,  2943,  2304,  2306,  2307,  1033,  2510,  1878,  1102,  2609,
     815,  1787,  3834,  1899,  1798,  1954,  1903,  2501,  2610,  2611,
    3197,  1907,  1823,  2612,  2257,   405,  1369,  1198,  1912,  2431,
     403,  2780,  2613,  3090,  3092,  2614,   403,  1930,   808,  2514,
    2515,  4099,  3805,  1143,   697,  1085,  4062,  2002,   811,  1064,
    1671,  3390,  3791,  1673,  3594,   815,  4129,  1093,  2685,  2243,
    4017,   904,  3535,  1094,  4089,  3791,  4274,  1054,  3528,   403,
     405,  3533,  3534,  1364,  4266,  4293,  4031,  4033,   983,  4309,
    1198,  2419,   697,   808,  2646,  2298,  2298,  3483,  2349,  2028,
    2003,  2981,  4537,   811,  1998,  1737,  1554,  2637,   983,  4432,
    1609,  1028,  3294,   902,   909,  1612,  1649,  1650,  4067,  1028,
    1134,  1028,  3964,   909,   403,  1308,  1029,  3605,   809,   412,
    1353,  3440,  2201,   815,  1029,  3528,  1029,  1927,  2095,  2096,
     412,  2997,  1955,    45,   864,  3001,   412,  1713,   405,  1955,
    1302,  1156,  3810,  3811,  3812,  3813,  3814,  3815,  2521,  4430,
      45,   808,  2244,   909,  2115,  1955,  -135,  2149,   408,  4710,
    2526,   811,  3648,   809,  2068,  -135,  4633,  3877,  4688,  2857,
    -135,  3358,  4231,  3360,  2445,  4846,  3239, -1526, -1526, -1526,
   -1526,   913,   403,  2061, -1526,  1850,  1662,  3417,  3218,   357,
   -1745,  1431,  2146,  1416,   329,  1705,  1072, -1745, -1536, -1536,
   -1536, -1536,   361,   351,  2857, -1536, -2304,  3400,  4226,  1663,
    2445,  3241,    79,   352,  2445,   356,   354,  2155,  3599,  2640,
    4725,  2852,  2508,  2892,   862,  2724,    37,    38,    39,    40,
    2893,   809,  2414,    44, -1851, -1851, -1851, -1851,  2005,  1714,
    2445, -1851,  2158,  1895,   412,  3653,   350,    37,    38,    39,
      40,   404,   666,    43,    44,  1437,  1664,  2631,    45,  2559,
     866,  4864,     3,  1218, -1761,  4912, -1526, -1526, -1526, -1526,
     261, -1761,  2160, -1526,  3816,  1095,   357,  1540,  1144,  1397,
    1831,  4532,   355,   405,  2147,   366,   404,   412,  3054,   411,
    2483,  1844, -2576, -2576, -2576, -2576,    43,  1706,   715, -2576,
    2377,    45,  4262,   130,   131,   859,   825, -2576,  2192, -1536,
   -1536, -1536, -1536,  2908,  2560,  2415, -1536,  3819,   405,  1641,
    4760, -2577, -2577, -2577, -2577,  1389, -1526,   403, -2577,  4796,
    -363,  1551, -2574, -2574, -2574, -2574, -2577,  2536,  2758, -2574,
    4698, -2573, -2573, -2573, -2573,  2129,   826, -2574, -2573,  4435,
    1096,  1219, -1493, -1493, -1493, -1493, -2573,  1081,  4439, -1493,
     974,  1130,   403, -1506, -1506, -1506, -1506,  1974,  2245,  4706,
   -1506,  3252, -2169, -2169, -2169, -2169,  2186,  1956, -2003, -2169,
     975,  3649,  1763,  1630,  1956,  2102,  2103, -2169,  1198,  4913,
    1220, -2304,  2118,  1991, -1521, -1521, -1521, -1521,  4726, -1954,
    1956, -1521,  2189,  2641, -1533, -1533, -1533, -1533,   821,  2632,
     822, -1533,  1308,  3242,   898,  4533,   855,    37,    38,    39,
      40, -1325,  4865,  2722,    44,   914,  1580,  2728,  1581,  2730,
    1398,  1177,  2733,  2068,  4263,  1308,  1707,  2554,  1221,  4847,
    1158,  2059,  2062,  2235,  2236,  2725,  4513, -2304,  2558,  1137,
    1138,  3823,  3653,  2783, -1521,  1267,  2071,  1102,  3075,    37,
      38,    39,    40,  3440,  1652,  1655,    44,  1708,  2081,  1417,
    1405,  1073,  1092,  2858,  4142,  2527,  1684,  3878,   357,  4826,
    3219,   667,  2084,   329,  1128,  2017,  1405,  3824,  4898,  4082,
    2522,  1715,  4900, -1325,  3719, -1745,  1709,  3791,  2509,  2576,
    3825,  1308,  2062,  4933,   915,  4425,   916,  1574,  3503,  4541,
    1993,  1575,  4515,  2475,  1658,  1145,   246,  1965,  2243,  1896,
    1997,  3094,  1896,  2574,  4120,  2150,  2405,  3622,  2894,  2506,
    4932,   904,  3452,  3921,  2497,   350,  2499,  2452,  2550,  1097,
    1135,   980,   981,  2095,  2096,    37,    38,    39,    40,  2546,
    2952,  2115,    44,  1700,  1710,  2738,  2633,  4555,   980,   981,
    2155,  4381,  2090,  2243,  1427,  4385,  2015,  2922,  2202, -1761,
    4270,   355,  1713,   902,   366,  1185,  2378,  2715,  -135,  -135,
   -2003,  3826,  3700,  2551, -1954,  2158,  1136,  1830,  3255,  4282,
    1293,  4857,  3596,  2124,  4209,  2689,  4419,  3135,  4340,  4045,
    1318,  1766,  2068,  2570,  2214, -1526,  4504,  4505,  4506,  4507,
    4508,  1965,  2125,  3076,  1955,  2160,  2187,   909,   909,  2321,
    1631,  4862,  1171,  1308,  1082,  2285,  2126,  4745,  2179,  4440,
    2286,  1308,  1308,   412,  1088, -1325,    37,    38,    39,    40,
   -1954, -2003,    43,    44,  1437,  1664,  3089,    45,  2593,  1616,
    2723,  2090,  3164,   861,  2422,  3099, -2003,  4899,  1370,  2734,
    1574,  1582, -1851,  1263,  1575,  1130,  1665,  1666,   825,  2193,
    1253,  2739,  1207,  1563,  1714,  4625,  1389,  1178,  1838,   823,
    3391,  3528,  4635,  4240,  3701,  3562,  2625,  2155,  1143,  1304,
    3665,  4053,  3666,   412, -1526,  3052,    37,    38,    39,    40,
     404,  1268,    43,    44,  2124,  3393,  2660,    45,   826,  1639,
    1640,  3066,  2158,   815,  1371,   816,  1377,  1317,  1382,   412,
   -2576,  4283,  4712,  2125,  1386,   817,  3757,  3758,   405,  2705,
   -1325, -1328,   405,  3568,  2698,  2708,  1167,  2128,  1998,  3866,
   -2578,   808,  2160,  1294,  1167,   665,  3010,  1377,  1382, -2577,
     665,  1147,  1362,  2874,  2983,  3440,  2983,  2219,  4910,   665,
   -2574,  2626,  2232,  2232,  1365, -1325,  3440,  1000, -1325, -2573,
    2967,  2419,   403,  2777,  2779,  1167,   403,  3066,  3136,  1093,
    2101,  4890,  3067,  4095,  2787,  1094,   665,  2301,  2791,  1363,
     665,  2107,  2365,   361,  2807,  2808,  2803,  2804,  1295,  1008,
   -2169,   665,  4174, -1328,  1376,  2453,  1381,  2640,  2366,  2821,
    2823,  4040,  4312,  3283,  1769,  3573,  1395,  2454,  2478,  1305,
    2837,   809, -1521,  3702,   818,   665,  4947,  1407,  2379,  1167,
    3752,  4070, -1533,  3755,  3756,  1410,  1412,  3759,  1167,   665,
     208,  2580,  2740,   665,  1741,  2152,  1319,  3766,  3067,  4601,
    3789,  4603,  2302,   665,  3703,  1130,  2305,   909,    81,  1956,
    2741,  2433,  2367,  3789,  2643,  2482,  2501,   665,  2455,  3392,
    4713,  3449,  3450,  3451,  3452,  1564, -1848,  2875,  1585,  2368,
    2696,  2876,  1375,  3704,  1380,  2374,  1544,  2190,    37,    38,
      39,    40,  4132,  1407,  3394,    44,  4792,  1550,  3840,  2379,
    3275,  1558,  2853,  1358,  4802,  4284,  1116,   909,  2303,  1439,
    4636,  4083,  3440,  1409,  1411,  1198,  2187,  1803,  2877,  2407,
    2463,  4594,  2147,  1619,  1839,  4668,  4598,  2413,  4591,  4600,
    3070,  2731,  2732,  3888,  1770,  3442,  1565,  2627,  -157,  1028,
    3884,  3053,  1115,  1028,  1579, -1328, -2578,  1119,  1167,  4175,
    2628,  1427,   819,  1038,  1029,  1804,   665,  2380,  1029,  1389,
    4891,  3886,  1117,  -157,  4666,  2581,  2174,  2175,  2176,  2177,
    2178,  2179,  4778,  2928,  2487,  4147,   405,  2490,  2491,   215,
    1188,  1189,  1190,  1167,  1191,  1192,  1193,  1194,  1195,  1196,
    4670,  4522,  1130,  1828,   697,  1037,  3070,  3565,  1651,  1119,
    2580,  2666,  4451,   974,  1719,  2369,  4858,  1116,  3889,   223,
    1086,  3671,  2677,  1378,  4130,  4749,  4750,  1383,  1384,  1385,
     403,  4861,  2674,   975,  2684,  1159,  4892,  1396,  4133,  1654,
    1389,  3188,  2381,  1180,  2878,  2310,  1700,  1009,  2311,  2555,
   -1328,  3841, -1986,   665,   665,  1062,  1039,   233,  -579,  4893,
    4863,  4753,  2365,  1119,  1574,  1665,  1666,  3276,  1575,   236,
    4734, -1493,  3189,  1117,  1258,  1116,  1118,  4743,  1087,   357,
    1081,  4148,  4084,  4794,  1702, -1328,  1369,  1919, -1328,    35,
     412,  1075,  4779,    37,    38,    39,    40,    41,    42,    43,
      44,  3190,  3442,  2968,    45,  2176,  2177,  2178,  2179,  2370,
    4746,  4085,  3381,  1805,  2155,  1941,  3259,  4400,  2197,   974,
    4752,  2198,   974,  1010,  2931,  1920,  4406,  4404,  1312,  1198,
    4086,  1117,  2367,  2701,  2581,  4772,  2312,  1321,  4134,   975,
    1088,  4135,   975,  1088, -1493,  3277,  1167,  3890,  4731,  2368,
    2719,  1754,  1829,  1084,  1390,  4780,  1167,  1808, -2004,  3443,
    2582, -2029,  2373,  1809,  1119,  4418,  1404,  1981,  4149,  2160,
      79,  3447,  3448,  3449,  3450,  3451,  3452,  4833,  1894,  2810,
    1082,  3663,  3447,  3448,  3449,  3450,  3451,  3452,  3094,  2374,
     955,  2561,  3528,  1390,  3191,  3672,  3528,  1088,  2216,  1806,
    4053,  3100,  4924,  3641,  1092,  1982,  4394,  3891,  1896,   956,
    4773,  1167,  4403,  2753,  4689,   361,  2019,  1605,  2021,  4880,
    3673,  2025,  1119,  2027,  1390,  1140,  2030,  2031,  2032,  2562,
    4830,  4831,  2463,  1851,  1852,  3255,  2264, -1986,  -751,  2039,
     957,  3642,  3600,  1405,    37,    38,    39,    40,   665,  4642,
    4328,    44,  2064,  4882,  2065,  1671,  3098,  1089,  1673,  1810,
    3182,  1120,  4690,   665,  2896,  4677,  3183,    81,    81,  4691,
      81,  3355,  3791,  1921,  4152,  2369,  1198,  2359,  1167,  1439,
    1121,  3356,  3440,  1868,  1607,  1098,   665,  2360,  3361,  3917,
    1965,  1011,  1012, -1986,  2302,  2250,  4692,  3301,  3302,  3303,
    3304,  3157,  2361,  3163,  2336,  3789,  2217,  2258,  2259,  3309,
    2263,  2720,  2433,  1094,  1094,  3540,  1094,  3541,  2375,  2582,
    1608,  1102,   665,  2265,  3175, -2578, -2578,  4542,  3447,  3448,
    3449,  3450,  3451,  3452,  3253,  1894,  4925,   665,  2583,  4543,
    2721,  1644,  1143, -2004,  4941,  4774, -2029,  1692,  1105,   665,
    2303,  1599,   665,  1983,  3213,  3157,  1948,  4076,  1923,  1922,
    1674,  4917,  3184,  1167,  2267,  4281,  4693,  3079,  3935,  2370,
    4153,  3351,  4605,  4200,  3541,  3569,  1358,  2563,  1924,  4203,
    4204,  4205,  4206,  4207,  4208,  1769,  3395,  2897,  3664,  3643,
     130,   131,  1167,  3720,  2206,  2207,  4222,  1439,  1811, -2004,
    3440,  2609, -2029,  2501,  1644,  2268,  1949,  4822,  2606,  3617,
    2610,  2611,  4317,   952,  4318,  2612,  4786,  3992,  4652,   215,
    1167,  1167,  2018,  1167,  2613,  2020,  4701,  2614,  2024,  1812,
    2026,  2362,  4823,  2029,  4702,  1835,  2183,  2033,  1948,  1984,
    1167,  1119,  4223,   917,  1600,  1840,  3306,   955,  3910,   223,
    3080,  3307,  3057,  1619, -1493,  3396,  2269,  4342,  1813,  4343,
    4836,  2948,  3442,  2564,  3886, -1493,   956,  2101, -1493,  1692,
   -1493,  4610,  4611,     8,   665,  3644,  1689,  2222,   815,  3415,
    2607,  1069,   665,   665,  3019,  3096,  4711,   233,  2700,  4544,
    1108,   357,  1167,   405,  1950, -2368,  1034,   957,  2318,   236,
    1939,  3185,   697,   697,  3398,  1817,   808,  1690,   877,  -157,
    1109,  1218,  1639,  1640,   404,   404,  2242,  4837,  4653,  3443,
    1110,  1167,  1925,  2986,  4755,  1167,  1167,  4694,  3467,  2865,
      35,  2866,  3186,   246,  -157,  2400,  1691,   403,    41,    42,
    2949,  1605,  1951,    80,  3066,   405,   405,   405,  3207,  1198,
    4567,  1140,  3528,  2867,  1809,  2945,  3020,  3528,   808,  3492,
    3528,  3187,  2088,  1288,   404,   879,   665,  2208,  1288,    79,
      79,  2340,    79,  1022,  3867,  2995,  1950,  3871,   825,  3628,
    3442,  2448,  2105,  1061,  4344,  4703,   809,  3031,  1644,   403,
     403,   403,  1289,  2492,  2146,   815,   405,  3847,  4095,  1219,
      43,   877,  1028,   405,  1894,    45,   697,  1700,  1607,  1538,
     405,  3150,  2132,  2492,  3948,  3067,  3949,  1029,   826,  1111,
    1952,  4443,  4444,   808,  1951,  3259,  2144,  2268,  2209,   827,
     664,  2507,  2449,  2242,  1028,  2304,  1290,  3443,  1220,  3032,
     403,  1290,  4806,  4621,  3068,  4623,  2868,   403,   863,  1029,
    1810,  2869,   215,  3816,   403,  4500,  2870,  1894,   879,  3817,
    4260,  3151,   949,  1357,   412,    37,    38,    39,    40,  3818,
    1539,  3640,    44,  2457,  1218,  3069,   215,  3027,  2269,  1697,
    1146,  1112,   223,  4501,  1894,  1702,  1221,  4741,  3447,  3448,
    3449,  3450,  3451,  3452,   903,  3111,  3819,  3165,  3820,   886,
     920,   887,  1952,   809,  3113,  3168,   223,  3170,  3345,   825,
    1698,  3152,  1035,  3494,   208,  3495,  2493,  4436,  2494,  4095,
     233,  4261,  1092,  1092,   892,  1092,   999,  1308,  4538,  -911,
    1439,  3950,  1702,  3440,   665,  2476,  2493,  3496,  2494,  1699,
    -386,  3951,  4117,  2498,   233,  3369,  3112,  1113,   958,   826,
      37,    38,    39,    40,  1894,  3114,   236,    44,  1157,  2736,
    3634,  2661,  1219,  3070,  1308,  1172,   246,  3916,  4539,  3528,
    3821,  3031,  2871,  2573,    37,    38,    39,    40,  4437,  1644,
    2465,    44,  2872,  4100,  1644,  1644,    37,    38,    39,    40,
     959,  1894,   886,    44,   887,  2477,  1965,  2755,  4102,   815,
    3153,  1220,  3444,  3445,  3446,  3635,  3447,  3448,  3449,  3450,
    3451,  3452,  1700,  3920,   405,  2224,  1662,   892,  3654,  1894,
    4484,  4485,   974,  3625,  1365,  3822,  4407,   808,  2466,  2467,
    3823,   665,  1605,  1184,  1754,  3497,  1606,  2590,  4775,  1663,
    3498, -1372,   975,  1790,  3581, -1372,  3675,   665,  2465,  1221,
    3921,  3563,  3849,   361,  2225,  2113,  2114,  4651,   403,  2313,
    2314,  2703,  2463,  2704,  2922,  4641,  3824,  2706,  4102,  2707,
    4103,  1167,  2709,  2938,  1791,  4121,  2710,  1894,  2155,  3825,
    1167,  4238,   665,   665,  2754,  2332,  2334,  1694,  2343,  4656,
    1102,  3657,  3441,   665,  2945,  1560,  2466,  2467,  2743,  1607,
    3705,  3154,  3707,  2158,  2775,   665,   665,   809, -1372,  3155,
    4024,  1209,  3156,  3442,    81,   361,  2749,    81,  1695,  2344,
    4131,  4136,  3537,  4104,  1216,  4105,  2750,   665,  2752,  2751,
    2463,  2511,  2124,  2160,  1988,  1608,   412,  3383,  4025,  3509,
    4103,  1644,  3966,  3967, -1372,  3927,  1217,  1696,  2345,  1644,
      45,  2125,  2034,  4387,  1989,  3739,  3499,  3373,  3543,  2124,
    3826,  3544,  3545,  1799,  4027,  2126,  3500,  1167,  2465,  1792,
    3443,  4095,  3546,  3547,  3548,  2035,  3549,  3550,  2125,  3753,
    2922,  3551,  3552,  3553,    37,    38,    39,    40,  1257,  2504,
    1556,    44,  2128,  4104,  1800,  4105,  1644,  3192,  1801,  1644,
    1644,  1773,  4901,   192,  1167,  1167,  3264,  1308,   192,  4678,
     412,  2212,  1167,  3229,  3931,  1167,  2466,  2467,  3194,  1167,
    1260,  2954,  3740,  1802,  2801,  3712,  3193,  1167,  1167,  1262,
    4675,  3999,  1774,   215,  3830,  1167,  1198,  4679,  1167,  1167,
    1167,  1167,  3741,  3694,  4420,  2540,  4879,  3195,  1167,  1167,
    2463,  1167,  4176,  1167,  1167,  3265,  1277,  1167,  3695,  4029,
     815,  1644,  3283,   223,  1585,  3255,  3614,  3615,  4361,  4360,
    3789,  3609,  4177,  1894,  1167,   405,  2541,   871,  3021,  1167,
    3024,   215,  3100,  1167,  2294,  2295,   215,  1167,   808,  1167,
    1167,  1167,  1167,  1167,  1167,  1167,  1167,  1167,  2855,  1167,
    2433,   233,  4657,  3633,  3945,  1167,  2124,  3574,  1167,  3898,
    1574,   223,   122,   236,  1575,  4291,   223,  1283,  3930,   403,
    2539,  3697,  1308,  3554,  3466,  2125,  3468,  3469,  3965,   357,
     126,  3266,  3267,   404,  2155,  3444,  3445,  3446,  2232,  3447,
    3448,  3449,  3450,  3451,  3452,  3268,  2970,   246,  3806,   233,
    2654,  2655,  3698,  3307,   233,   877,  3015,  2465,  2604,  2158,
    2658,   236,  4707,  1291,   903,   405,   236,  3972,   809,  2664,
    1167,  4097,  4098,  2542,  -905,  1297,  2635,  3940,    35,   412,
    2445,  3699,  1292,   404,  2543,   404,    41,    42,  2450,  2160,
    3269,   357,  1300,    45,  3259,  4902,  1776,  3946,  1148,  1999,
     246, -1122,  3715,  2000, -1122,  2466,  2467,   412,  2544,   403,
    1149,  1150,   879,  3667,  1314,   405,    79,   405,  2101,    79,
    2350,  4023,  3968,  4334,    37,    38,    39,    40,  1999,  1325,
    1151,    44,  2692,  1152,  3845,    45,  4125,   665,  3074,  2463,
    2276,  2101,  1777,  2350,  4232,  4233,  4234,  4235,  4236,  2960,
    2961,  3555,  3297,   815,  4503,    81,  1180,    81,  2068,   403,
    1339,   403,  3412,  3413,   665,  4023,  2695,  3414,   405,   665,
    4945,  1596,   665,  4946, -1325,  3270,    35,  3271,  1330,  2154,
    3148,   808,  2155,  2863,    41,    42,  2843,  1345,  4024,  2846,
    1130,  2242,  1831,  1269,   665,  1270,  3556,  1167, -1396, -1396,
    4322,  4323,  4324,  1167,  1574,   950, -1851,  2158,  1575,  1167,
    1360,  1086,   403,  2159,  2163,  2164,  4025,    45,  4036,  1778,
    4234,  4235,  4236, -1373,  1028,  2294,  2979, -1373,   665,  4241,
    1399,  4026,  4024,  3831,  3839,  3833,  3842,  2160,  1272,  1029,
    1273,  1403,  4027,  4216,  1413,  1894,   886,  1153,   887,  1425,
    1894,  1894,  1308,  1419,  1308,   665,   665,   889,  2167,  1424,
    4025,   809,  1894,   815,  4028,  1779,   815,  1780,   891,  1087,
    1426,   892,  4041,  4043,  2008,  4026,  2009,  2500,   405,   665,
    2087,   405,   246,  4595,  1154,  1028,  4027,  2248,  3557,  2249,
   -1373,   808,  3771,  2251,   808,  2252,  3881,  1427,   665,  3158,
    1029,  3077,   665,  1255,  3132,  1782,  3574,  4663,  4028,   357,
    2101,  2154,  1692,  3298,  2155,  1308,  4219,  2243,  4221,  3574,
     665,  4224,   403,  4225,  1428,   403, -1373,  3718,  1429,  1439,
     665,  2156,  3440,  3772,  1088,  3326,  3327,  4029,  2465,  2158,
    1433,  2162,  1784,   665,  2694,  2159,  2695,  3926,  2716,  3993,
    2717,  2922,   665,  3158,  2101,  1430,  2350,  3773,  1309,   920,
    3576,  3577,  2163,  2164,  2465,  4568,  4569,  4570,  4571,  2160,
    1434,   809,  3774,  2718,   809,  2717,  3775,  1786,  2746,  1436,
    2747,  4029,  2944,  3542,  2945,  1559,  2466,  2467,  3003,  4617,
    2747,    80,  4196,  1167,  3776,  1894,  1566,    37,    38,    39,
      40,  3087,  1562,  3088,    44,  3144,  2167,  3145,  3247,  3777,
    3248,  4596,  2466,  2467,  1439,  2074,  2075,  3440,  3158,  2168,
    2463,  1568,  3158,    37,    38,    39,    40,  3260,  4365,  3261,
      44,  3375,  4551,  2717,  4367,  1644,  3411,  1082,  2695,  3721,
    2174,  2175,  2176,  2177,  2178,  2179,  2463,  1415,  1089,    37,
      38,    39,    40,  3158,  3749,  1674,    44,    79,  1567,    79,
    4474,  4475,  4310,  4477,  3513,  1894,  3514,  1573,   665,  2161,
    3421,  1586,  2695,  2162,  1593,  1432,  2465,  3425,  1594,  2695,
      37,    38,    39,    40,  1541,  3778,  1596,    44,  1553,  1309,
    1555,  2465,  3047,  3779,  2163,  2164,  1597,  4122,  1180,  4228,
    4229,  4273,  4244,  3582,  3583,   665,    35,  3429,  1603,  2695,
    2165,  1617,  3442,  1167,    41,    42,  3932,  1618,  3518,  3519,
    3520,  3430,  1622,  2695,  2466,  2467,  3780,  3456,  4246,  2695,
    3472,  3287,  2695,  1624,  2465,  2166,  1628,  1629,  2167,  2466,
    2467,  1632,  1637,  1082,  4232,  4233,  4234,  4235,  4236,  1633,
    1634,  2168,  4237,   665,  2169,  3477,  1635,  3478,  2463, -1497,
   -1497, -1497, -1497,  1645,  1636,  1894, -1497,  1646,  3515,  3443,
    3516,  4349,  1130,  2463,  1638,   665,   664,   664,  3688,  1167,
    3689,  1675,  2466,  2467,  1167,  4248,  1648,  3150,  2174,  2175,
    2176,  2177,  2178,  2179,  3692,  1677,  3693,  3442,  1680,  1678,
    1167,  1167,  3836,  3875,  3837,  3876,  1167,  1692,  3936,  1644,
    2695, -1504, -1504, -1504, -1504,  1686,  2463,  1644, -1504,  1644,
   -1495, -1495, -1495, -1495,  1712,  1739,  2170, -1495,  3973,  1717,
    3974,  1167,  1167,  3983,  1743,  3984,  1167,  3151,  3995,  1766,
    2695,   815,  4068,  4072,  4069,  4073,  1768,   815,  1167,  1167,
    1167,  1167,  1775,  2816,  3443,  2068,   405,  4101,  4212,  2717,
    4213,  1167,   405,  4366,  1167,  2747,  1167,  2839,  1795,   808,
    4496, -1498, -1498, -1498, -1498,   808,  1167,  1167, -1498,  3473,
    1167,  4427,  3288,  4428,  4433,  3480,  2717,  3152,  4489,  4291,
    1807,   361,  2749,  1167,  4434,  1167,  2717,  1816,  1854,  1167,
     403,  1820,  2750,    35,  2752,  2751,   403,    37,    38,    39,
      40,    41,    42,  1825,    44,  1167,  2171,  2172,  2173,  1826,
    2174,  2175,  2176,  2177,  2178,  2179,  1167,  1832,  1167,  1167,
    1167,  4534,  3433,  4535,  3444,  3445,  3446,  1827,  3447,  3448,
    3449,  3450,  3451,  3452,  4577,  1834,  4578,  1308,   665,   809,
    1836,  3574,  1167,  1848,  1846,   809, -1496, -1496, -1496, -1496,
    4579,  1841,  2695, -1496,  1855,  1167,  4442,  4587,  1858,  2747,
    1167,  4639,  4660,  4640,  4661,  4575,  3153,  1167,  4708,  4721,
    4709,  2747,  1700,  1167,  1688,  1900,  1309,  4271,  4272,  1902,
      80,    80,  1904,    80,  4456,  4728,  4733,  2945,  3856,  4735,
    4795,  3856,  2211,  4800,  1896,  4801,  4465,  2792,  4811,  1309,
    2747,  1913,  4812,  3289,  3478,  4813,  4816,  2695,  2945,  3444,
    3445,  3446,   665,  3447,  3448,  3449,  3450,  3451,  3452,  4818,
    4835,  3856,  2747,  4551,  4841,  -174,  2747,   665,   665,  4842,
    4868,  2747,  2945,  1167,  4943,  4954,  4944,  4944,  1915,  1644,
    4480,  1917,  3290,  1602,  2066,  1604,  1929,  4386,  2696,  4389,
    1937,   841,  1945,   665,  1953,  1958,  1894,  1959,  3405,  1960,
    4486,  1961,  2793,  3407,  1962,  1309,  1964,  3154,  4218,  4727,
    1972,  1965,  1975,  2144,  1976,  3155,  1977,  1978,  3156,  4727,
    1980,  1985,  1986,  1987,  1992,  2006,  2040,  2863,  2070,  2076,
    2085,  2072,  2104,  2086,  2094,  2097,  1894,  1894,  2078,  1894,
    2079,  2098,  2099,  2184,  2100,   246,  3512,  2106,  2109,  2110,
    2111,  2112,  2117,   815,   815,   815,  2211,  2119,  2794,  3522,
    2120,  2795,  2121,  2122,  2123,  2130,  2131,  2133,   405,   405,
     405,  4662,  4769,  2134,  2215,  2135,  2227,  2136,  2148,  2137,
    2138,   808,   808,   808,  2139,  2140,  1389,   665,  2153,  2247,
    2256,  1894,  1606,  1894,   665,  1608,  2283,   357,  2191,  2291,
    2237,  2300,  1119,   665,  2293,  2315,  2317,  2319,  2327,  2328,
    2817,  2330,   403,   403,   403,  2337,  3522,  2335, -2520,  1081,
    2339,  2308,  4606,  2346,  2817,  2347,  2348,  1309,  2350,  2351,
    2221,  2223,  2068,  2352,  4720,  1309,  1309,  2353,  3438,  3439,
    2354,  2355,  2376,  3454,  2382,  3529,  1894,  4817,  2402,  2796,
    2383,  4412,  2406,  2408,  2410,  2409,  4325,  2411,  2412,  2437,
    2445,   809,   809,   809,   665,  2447,  2438,  2457,  2458,  2461,
    1894,  2460,  3896,  2898,  2462,  2463,  2469,   815,   898,  2470,
    1644,  2471,  2472,  3489,  3490,  2473,  2479,  2480,  2484,  2485,
    2488,  2495,   405,  1754,   815,  2523,  3783,  1894,  2496,  2502,
    2503,  2512,  3529,  4758,  3860,   808,  2513,  4763,  4764,   405,
    1894,  2525,  2524,  2552,  2528,  3770,  1082,  2565,  2534,   664,
    2529,  2538,   808,   665,  2553,   665,  1082,  2567,  2090,  2577,
    2575,  2578,  2590,  2591,  4516,   665,   403,   665,  3895,  2101,
    2107,  2594,  2568,  2597,  2598,  2602,  2797,   873,  1198,  2603,
    2624,  2619,  1792,   403,  2638,  2639,  2644,  2647,  2649,  4009,
    4010,  4011,  4012,  2650,  4489,  2657,  2668,  2670,  2651,  2672,
    2686,  2687,  2712,  1894,  2671,  4620,  2673,  2735,  2744,  2729,
    2757,  4759,  2713,  2782,  2788,   809,   665,  1894,  1439,  4762,
    2825,  3440,  2783,  2838,  4765,  2844,  4767,  2155,  1439,  2849,
    1894,  3440,   809,  2848,  2856,  4723,  2908,  2862,  4368,  2927,
    2826,  2881,  2935,    74,  2936,  1087,   665,  2879,    35,  2955,
    2956,  2924,  1308,  2925,  2965,  2988,    41,    42,  2201,  3004,
    1167,  3005,  2154,   665,  2930,  2155,  2932,  2946,  3006,  3017,
     909,  2947,  2959,  3027,  3029,  2985,  3022,  2987,   665,  3030,
    3002,   665,  2156,  3036,  3025,  2157,  3041,  3045,  3048,  3062,
    2158,  2068,  3065,  2505,  3078,  1167,  2159,  3083,  1894,  1556,
    1560,  3085,  3139,  3143,  3134,  1167,  3146,  3147,  3196,  3209,
    3216,  1167,  3217,  1167,  3220,  3221,  3222,  3224,  1894,  1167,
    2160,  3739,  1167,  1167,  1167,  1167,  1167,  1167,  1167,  1167,
    1167,  1167,  3225,  3226,  2154,  1167,  1167,  2155,  3227,   815,
    3228,  3238,  3240,  1894,  3244,  3249,  3251,  3254,  1167,  3255,
    3262,  3281,  1167,  3293,   405,  3256,  1167,  3257,  3286,  3299,
    2068,  3305,  2158,  3313,  2068,  2068,  1167,   808,  2159,  1167,
    3314,  1167,  3308,  3315,  3329,  3332,  3344,  3978,  3350,  1894,
    1167,  1167,  1167,  3347,  3348,  3349,  1167,  3352,  4697,  1167,
    3353,  3362,  2160,  3365,  3368,  3377,  4821,   357,   403,  1167,
    3378,  3442,  3379,  3367,  2945,  2816,  2816,  1993,   985,  1167,
    2816,  3442,  4740,  3382,  3389,   662,  2615,  1167,  3380,  1167,
    2161,  3397,  2758,  3401,  2162,  4162,  1405,  3403,   985,  1644,
    3408,   357,  3406,  3423,  3409,  3462,  3424,  3426,  3427,  3428,
    3431,  3432,  1644,  3434,  3437,  2163,  2164,   809,  3455,  4628,
    2816,  2816,  4920,  2695,  3461,  3463,  3464,  3493,  3443,  3471,
    3474,  2165,  3486,  3487,  1167,  3488,  3501,  3508,  3443,  3511,
    1167,  3531,  3536,  3537,  3539,  -951,  1167,  3592,  3586,  3588,
    3602,  3598,  3603,  3604,  4645,  3613,  2166,  3616,  3607,  2167,
    3619,  3608,  2161,   987,  3618,  3627,  2162,    80,  1999,  3630,
      80,  1167,  2168,  3623,  3632,  2169,  3636,  3624,  3650,  3661,
    3651,  3662,  3668,   987,  3669,  3677,  3679,  2163,  2164,  3710,
    3717,  3711,  3714,  3722,  3716,  3723,  3724,  3727,   665,  3725,
    3726,  3728,  3742,  2165,  3729,  3730,  3731,  3733,  3732,  3735,
    3737,  3734,  3736,  3744,  3746,  2521,  1198,  3748,  3754,  1180,
    3760,  3761,   815,  3762,  3763,  3764,   815,  1744,   815,  3765,
    3794,  2167,  3795,  1745,  2311,  3803,  3807,   405,  3808,  3848,
    3844,   405,  1894,   405,  2168,  3846,  3574,  2170,  3855,  3868,
     808,  1198,  3869,  3872,   808,  3861,   808,  3893,  1644,  3864,
    3856,  3873,  2144,  3865,  3132,  3902,  4143,  3912,  3904,  3913,
    3914,  3915,  4016,  1746,  3923,   665,  3924,  2800,   665,  3925,
    3918,   403,  3934,  3939,  2087,   403,  3458,   403,  3440,  2149,
    3457,  3997,  3998,  3444,  3445,  3446,  3969,  3447,  3448,  3449,
    3450,  3451,  3452,  3444,  3445,  3446,  3985,  3447,  3448,  3449,
    3450,  3451,  3452,  4022,  4038,  4064,  3970,  4088,   665,  2170,
    4832,  4109,  1747,  3971,  4111,  3977,  4006,  4123,  4112,  1748,
     809,  4124,  1749,  4056,   809,  4044,   809,  2171,  2172,  2173,
    4054,  2174,  2175,  2176,  2177,  2178,  2179,  4055,  4035,  4144,
    4057,  4078,  4060,  4145,  4126,  4061,  4128,  4146,  3529,  4156,
    4301,  4137,  4157,  4158,  4159,  4173,  3947,  1167,  1308,  3952,
    3953,  3954,  3955,  3956,  3957,  3958,  3959,  3960,  3961,  4160,
    4189,  4132,  4193,  4161,  1750,  4201,  4199,  4202,   665,   665,
    4230,  2929,  1894,  3337,  4264,  4256,  2717,  3885,  4276,  4277,
    3895,  4279,  2817,  2817,  4295,  4280,  4286,  2817,  4298,  2171,
    2172,  2173,  1720,  2174,  2175,  2176,  2177,  2178,  2179,  4299,
    4307,  4311,  4313,  4321,  1894,  1167,  1167,  4326,  4001,  4002,
    4329,  4330,  4331,  4332,  4308,  4333,  4423,  4829,  4315,  1751,
    4338,  1752,  4341,  4345,  1721,  4346,  4350,  2817,  2817,  4351,
    4352,  1753,  4353,  4358,  4382,  4383,  4390,  4395,  4354,  1754,
    3529,  4396,  4422,  4378,  4398,  4380,  4393,  4421,  1755,   665,
    4399,  4413,  2385,  4424,  4417,  4429,  4430,  4438,  4449,  4459,
    4452, -1337,  4453,  4466,  4469,  1167,  4473,  4478,  4483,  4487,
     664,  4502,  4494, -1337,  4509,  4499,  4519, -1337,  4517,  1722,
    4520,  4521,  4524,  1757,  4526,  2386,  1675,  4536,    80,  4548,
      80,  4540,  4546,  4549,  4557,  4565,  4573,  4581,  2387,  4454,
    4574,  4576,  1167,  4585,  4584,  4583,  4586,  4592,  1758,  4599,
    1723,  2388,  1167,  1167,  1198,  1894,  4612,  4602,  4634, -1337,
    1167,  1167,  4608,  4638,  1644,  1167,  1894,  4654,  4614,  4622,
    4618,  1167,  1167,  4655,  4637,  1167,  4414,  4664,  4263,  3338,
   -1337,  4647,  4671,  4648,  4673,  1724,  4681,  4682,  4685,  2389,
    1167,  4699,  4687,  2154,  1167,  4684,  2155,  4700,  4716,  4724,
    4730,  4739,  1088,  1167,  4747,  4756,  1759,  1555,  1167,  4781,
    3542,  4776,  4785,  2156,  1725,  4787, -1337,  4791,  2390,  4797,
    1167,  2158,   364,  2391, -1337,  4798,  4799,  2159,   364,  4804,
    4810,  4805,  4814,   658,  4815,  4819,  4820,  4825,  4760,  4827,
    1644,  4838,  4844,   357,  4845,  4511,    81,  4854,  4843,  4848,
    4850,  2160,  4046,  4881,  4859,  2313,  2314,  4860,  4886,  1167,
    4878,   364,  4883,  4889,  4846,  4897,  4923,  4847,  4939,  4911,
    4942,  4948,  4952,  1100,  2535,  3296,   208,  1894,  2234,  3674,
    3339,   815,  1742,   357,  3566,  1819,  1729,  3138,  4141,  3208,
    3767,  4658,  4488,  1730,  4771,  4530,   405,  4683,  4297,  4686,
    4696,  2421,  4514,  3621,  4884,  1894,   364,  3376,  4626,   808,
    1732,  4919,   665,  3199,  4851,  4849,  4895,  1894,  1733,  2392,
    4793,  3626,  4531,  2816,   665,  4267,  2816,  2816,  2816,  2816,
    2816,  2816,  2816,  2816,  2816,  2816,  3279,  3280, -1337,  4140,
     403,  3686,  4268,  2616,  3263,  4269,  3851,   841,  4922,  4953,
    3231,  2161,  1024,  4949,  3804,  2162,  3976,  3782,  3231,  4896,
    1024,  1894,  1024,  4646,  4259,  2601,   815,  4840,  4887,  1734,
    4649,  1004,  2060,  3340,   364,  4327,  2163,  2164,  2393,  4742,
    4304,   405,  4803,   665,  2394,  2816,  2816,  2395,  1644,   809,
    4303,  3091,  2165,  3522,   808,  3743,  1574,  3522,  4950,  1596,
    1575,  1310,  4904,  4789,  3770,  2940,  2702,  1570,  2941,  3571,
    3300,  4285,  4415,  2396,  4074,  3372,  2253,  2166,  3572,  2397,
    2167,  2007,  2964,  1592,  1167,   403,  2280,  2279,  3584,  2963,
    3580,  2284,  2398,  2168,  2958,  3331,  2169,  3597,  1720,   357,
    3585,  1309,  4018,  4388,  4732,  1578,  4075,  2761,  3989,  4722,
    2287,  3979,  4870,  4869,  4877,  3575,  3506,  2399,  3418,  3504,
    4071,  2907,  1133,  3894,  1947,  2653,  3346,  2989,  4867,  1103,
    1721,  2299,  2292,  1356,   809,  2980,  1894,  1685,  1309,  3529,
    2996,    74,  2993,  3529,  3561,  1656,  4080,  4059,  1657,  2067,
    4405,  2994,  4081,  2296,  2762,  1126,  3374,   665,  2200,  3000,
     985,  1996,   985,  2714,   985,    83,  4619,  1394,  2170,  1167,
     985,  1387,  1388,  1894,  4416,     0,     0,     0,  1167,   364,
       0,     0,     0,  2763,     0,  1722,  4409,     0,     0,     0,
       0,     0,     0,   985,   985,  1167,  1167,  4362,  4363,  1167,
     655,     0,     0,     0,  2764,     0,     0,     0,    79,     0,
    1167,     0,     0,     0,   364,  1167,  1723,     0,  1167,     0,
       0,     0,     0,  1167,  1167,     0,     0,     0,     0,     0,
       0,     0,     0,  2765,     0,     0,     0,     0,  2766,     0,
       0,     0,     0,     0,     0,   987,     0,   987,     0,   987,
     665,  1724,   665,     0,     0,   987,  1167,     0,  2171,  2172,
    2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,
    2933,     0,     0,     0,     0,     0,  2934,     0,   987,   987,
    1725,     0,     0,     0,  2767,     0,     0,  1894,     0,  4676,
       0,  1167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1726,     0,     0,
    2817,     0,   985,  2817,  2817,  2817,  2817,  2817,  2817,  2817,
    2817,  2817,  2817,     0,     0,     0,     0,     0,  1167,     0,
       0,  1667,     0,     0,     0,     0,     0,     0,  1727,     0,
       0,     0,   208,  2817,  1744,     0,  1728,     0,     0,     0,
    1745,     0,  1729,     0,     0,     0,     0,     0,     0,  1730,
       0,  2816,   841,     0,     0,     0,     0,  1731,     0,     0,
       0,     0,  2817,  2817,     0,   985,  1732,  1167,     0,  1894,
       0,  1309,     0,     0,  1733,     0,     0,  2768,     0,     0,
    1746,     0,     0,  2769,     0,     0,     0,   987,     0,  2770,
       0,  1167,  1894,     0,  1167,     0,  1167,     0,     0,     0,
       0,   662,   662,  3522,     0,     0,  1672,     0,  3522,     0,
       0,  3522,     0,  1167,     0,     0,     0,  1167,  2771,     0,
    2772,     0,  1894,     0,     0,  1734,     0,     0,     0,  1747,
       0,     0,     0,     0,     0,     0,  1748,  2773,     0,  1749,
       0,     0,     0,   815,     0,     0,     0,     0,     0,     0,
     987,     0,     0,     0,     0,     0,     0,     0,   405,     0,
       0,  1894,  2774,     0,     0,  1894,  1894,     0,     0,     0,
       0,   808,     0,     0,     0,     0,     0,  4938,     0,   665,
       0,     0,     0,     0,     0,     0,  1309,     0,     0,  3529,
       0,  1750,     0,     0,  3529,     0,     0,  3529,     0,  1167,
       0,     0,   403,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2816,  2816,  4616,  1894,     0,     0,
      74,    74,     0,    74,  4809,  3529,  4572,     0,     0,     0,
       0,     0,   357,     0,     0,     0,  1751,     0,  1752,   985,
       0,   809,     0,     0,     0,     0,     0,  1167,  1753,     0,
       0,     0,  4588,  4589,     0,     0,  1754,  3691,     0,     0,
    4644,     0,     0,     0,  1167,  1755,     0,     0,     0,  1644,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3713,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1756,  1180,     0,  1167,
    1757,   361,  4906,     0,   364,     0,     0,     0,   364,  1167,
    3522,     0,  4907,     0,  4909,  4908,     0,     0,     0,     0,
       0,   658,     0,     0,   987,  1758,   658,     0,     0,     0,
    1167,  1167,     0,   665,  3337,   658,     0,   361,  4906,  2154,
       0,     0,  2155,  1167,     0,     0,  3529,     0,  4907,     0,
    4909,  4908,  3231,  1720,     0,  3231,  3231,     0,     0,  3231,
       0,     0,   658,     0,     0,     0,   658,  2158,  2817,  3231,
       0,     0,     0,  2159,  1854,     0,     0,   658,     0,  1167,
    3792,   361,  4906,  1759,     0,  1721,  3801,     0,     0,  1167,
     815,     0,  4907,  3792,  4909,  4908,  3529,  2160,     0,     0,
       0,   658,     0,     0,     0,   405,  1309,     0,  1309,     0,
       0,     0,     0,     0,     0,   658,     0,     0,   808,   658,
       0,     0,     0,     0,     0,     0,     0,     0,  4929,   658,
     985,     0,     0,     0,     0,   985,   985,   815,     0,  3854,
    1722,     0,     0,   658,     0,   815,     0,  1167,     0,   403,
       0,     0,   405,     0,     0,     0,  1167,     0,  4719,  3491,
     405,     0,     0,     0,     0,   808,     0,     0,  3880,  1309,
       0,  1723,     0,   808,     0,  4929,     0,     0,     0,     0,
       0,     0,     0,  4929,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   403, -2578,   809,     0,
    3338,  2162,     0,     0,   403,     0,  1724,     0,  2309,     0,
    1387,  1388,     0,     0,     0,   987,     0,     0,     0,     0,
     987,   987,  2163,  2164,     0,     0,     0,     0,     0,  2324,
    1024,     0,   658,     0,  1024,  1725,  2331,  2333, -2578,     0,
       0,  2817,  2817,     0,     0,   809,     0,  2154,     0,     0,
    2155,     0,   364,   809,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2816,     0,     0,  2167,  2156,     0,     0,
       0,     0,  4580,     0,     0,  2158,     0,   357,     0,  2168,
       0,  2159,  2154,     0,     0,  2155,     0,     0,  4856,  2816,
    2816,     0,   985,     0,     0,     0,     0,   208,  3529,     0,
     985,  1728,  2156,     0,   662,  2160,     0,  1729,     0,     0,
    2158,     0,     0,  4937,  1730,     0,  2159,     0,  3990,   658,
     658,  2154,  2421,     0,  2155,     0,     0,     0,  1181,     0,
       0,  1732,  4885,  1201,     0,     0,     0,     0,     0,  1733,
    2160,     0,  1213,     0,     0,     0,     0,   985,     0,  2158,
     985,   985,     0,     0, -2578,  2159,     0,   357,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1271,
       0,  4051,     0,  1278,     0,     0,     0,   987,     0,  2160,
       0,     0,     0,     0,  1287,   987,     0,     0,     0,     0,
    1734,     0,     0,     0,  3340,  3885,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2161,     0,  4930,     0,  2162,
       0,     0,   985,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2163,  2164,   987,     0,     0,   987,   987,     0,     0,     0,
    2161,     0,     0,     0,  2162,  4951,  2165,     0,  2174,  2175,
    2176,  2177,  2178,  2179,  4930,     0,     0,     0,     0,     0,
       0,     0,  4930,     0,     0,  2163,  2164,     0,     0,     0,
       0,  2166,     0,     0,  2167,     0,     0,     0,     0,  2161,
       0,  2165,     0,  2162,     0,     0,     0,  2168,     0,     0,
    2169,     0,     0,     0,     0,  2816,     0,   987,     0,     0,
       0,     0,     0,     0,  2163,  2164,  2166,     0,     0,  2167,
       0,     0,     0,     0,   658,     0,  2652,     0,  3337,     0,
    2165,     0,  2168,  2154,   365,  3792,  2155,     0,     0,   658,
     365,     0,     0,     0,     0,   659,     0,  1720,     0,     0,
       0,     0,  4163,  2156,     0,  4164,     0,  4165,  2167,     0,
       0,  2158,   658,     0,     0,     0,     0,  2159,     0,     0,
       0,  2168,  2170,   365,     0,     0,     0,    74,     0,  1721,
      74,  4191,  4192,     0,     0,     0,     0,     0,     0,     0,
       0,  2160,     0,     0,     0,  3231,     0,     0,   658,     0,
    2817,  3231,  3231,  3231,  3231,  3231,  3231,  2170,     0,  2817,
       0,  1309,     0,   658,     0,  4220,     0,     0,   365,     0,
       0,     0,     0,     0,     0,   658,  2817,  2817,   658,     0,
       0,  1979,     0,     0,  1722,     0,   655,   655,     0,  3801,
       0,     0,  1994,     0,     0,     0,  2170,     0,     0,     0,
    4243,  4245,  4247,  4249,     0,     0,     0,     0,     0,     0,
       0,     0,  2171,  2172,  2173,  1723,  2174,  2175,  2176,  2177,
    2178,  2179,     0,     0,     0,     0,     0,     0,  3481,     0,
    2789,  2790,     0,     0,     0,     0,   365,     0,  2802,     0,
       0,  2161,  2805,  2806,  3338,  2162,     0,  2171,  2172,  2173,
    1724,  2174,  2175,  2176,  2177,  2178,  2179,  2827,     0,  2828,
       0,     0,     0,     0,  4302,     0,  2163,  2164,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1725,
       0,  2850,  2165,  2851,     0,     0,     0, -2578, -2578,     0,
    2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,     0,
     658,     0,     0,     0,     0,     0,     0,  2166,   658,   658,
    2167,     0,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,     0,  2168,     0,  4336,  2169,     0,     0,  2154,
       0,     0,  2155,  2324,     0,     0,     0,     0,     0,     0,
       0,   208,  1183,     0,     0,  1728,     0,     0,  1204,  2156,
       0,  1729,     0,     0,     0,     0,  1215,  2158,  1730,  1744,
       0,     0,     0,  2159,  1225,  1745,  2421,     0,     0,  1256,
       0,   364,   364,   364,     0,  1732,     0,     0,     0,     0,
       0,   365,  2817,  1733,     0,     0,     0,  2160,     0,     0,
       0,     0,   658,     0,     0,     0,     0,   985,  2170,     0,
       0,     0,     0,     0,     0,  1746,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   365,     0,     0,     0,
       0,     0,   364,     0,     0,     0,     0,     0,     0,   364,
       0,     0,     0,     0,  1734,     0,   364,     0,  3340,     0,
       0,     0,     0,  1024,     0,     0,   985,  4410,  4411,     0,
       0,     0,     0,     0,  1747,     0,     0,     0,     0,     0,
       0,  1748,     0,     0,  1749,     0,  1667,     0,    74,    80,
      74,     0,     0,     0,     0,  1024,     0,     0,     0,  1744,
       0,     0,   987,     0,     0,  1745,     0,  2161,  2171,  2172,
    2173,  2162,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,
       0,     0,  2847,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2163,  2164,     0,     0,  1750,  1422,  2154,     0,
       0,  2155,     0,     0,     0,  1746,     0,     0,  2165,     0,
       0,   987,     0,     0,     0,   662,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2158,     0,     0,  1548,
       0,  1672,  2159,  2166,     0,     0,  2167,     0,     0,     0,
     658,     0,     0,     0,     0,     0,     0,  1572,     0,  2168,
       0,  1751,  2169,  1752,  1747,     0,  2160,     0,     0,     0,
       0,  1748,     0,  1753,  1749,     0,     0,     0,     0,  1598,
       0,  1754,  3231,  3231,     0,     0,     0,     0,     0,     0,
    1755,     0,     0,     0,     0,     0,  1309,     0,     0,     0,
    4492,     0,  4493,     0,     0,  4497,  4498,     0,     0,     0,
     985,     0,     0,  3801,  3801,  3801,  3801,  3801,   985,     0,
     985,  1796,     0,     0,     0,  1757,  1750,     0,  3502,     0,
     364,     0,     0,     0,  2170,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   658,     0,     0,
    1797,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4528,     0,   658,     0,     0, -2578,     0,     0,     0,
    2162,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1751,     0,  1752,     0,     0,     0,     0,  4550,   655,
       0,  2163,  2164,  1753,     0,   987,     0,     0,   658,   658,
       0,  1754,     0,   987,  3258,   987,     0, -2578,  1759,   658,
    1755,  4336,  4336,  4336,  4336,     0,     0,     0,     0,     0,
       0,   658,   658,     0,  2171,  2172,  2173,     0,  2174,  2175,
    2176,  2177,  2178,  2179,     0,  2167,     0,     0,  3793,     0,
       0,  1821,     0,   658,     0,  1757,     0,     0,  2168,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1906,     0,     0,     0,     0,     0,     0,     0,
    1822,     0,     0,     0,     0,   657,     0,     0,     0,     0,
       0,     0,  1931,  1934,  1935,     0,     0,     0,     0,  2659,
       0,     0,     0,     0,     0,     0,     0,     0,  2665,     0,
       0,     0,  2669,   806,     0,     0,     0,     0,  2675,  2676,
       0,     0,     0,     0,     0,     0,   365,     0,  2154,     0,
     365,  2155,     0, -2578,     0,     0,  2688,     0,  1759,     0,
       0,     0,     0,   659,     0,     0,     0,     0,   659,     0,
    3792,     0,     0,     0,     0,     0,  2158,   659,   806,     0,
     985,  2154,  2159,     0,  2155,     0,     0,  2533,     0,     0,
       0,     0,     0,     0,  3231,     0,     0,     0,  4659,     0,
       0,  2156,     0,     0,   659,     0,  2160,     0,   659,  2158,
       0,     0,     0,     0,     0,  2159,     0,     0,     0,   659,
       0,   364,     0,     0,  1023,     0,     0,  1548,     0,     0,
       0,     0,  1023,     0,  1023,     0,     0,     0,     0,  2160,
       0,     0,     0,   659,     0,     0,   806,  2174,  2175,  2176,
    2177,  2178,  2179,     0,  1548,     0,     0,   659,     0,     0,
       0,   659,     0,     0,     0,   987,     0,     0,  4003,     0,
    2154,   659,     0,  2155,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2605,   659,  1720,     0,     0,     0,
    2156,     0,     0,     0,     0,     0,     0,     0,  2158,     0,
    2533,     0,     0,     0,  2159,     0, -2578,     0,  1168,  1170,
    2162,   364,  1173,  1174,     0,     0,     0,     0,  1721,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2160,  1211,
       0,  2163,  2164,     0,     0,     0,  2667,     0,     0,  2161,
       0,     0,     0,  2162,     0,     0,     0, -2578,     0,  1261,
       0,     0,     0,  1264,     0,     0,     0,     0,     0,  2533,
       0,   364,     0,   364,  2163,  2164,     0,     0,     0,  1285,
       0,     0,  1309,  1722,   659,  2167,  2324,     0,     0,  3564,
    2165,   985,     0,   658,     0,     0,     0,     0,  2168,     0,
       0,     0,     0,     0,   365,  2238,     0,     0,     0,     0,
       0,     0,     0,     0,  1723,  2166,     0,     0,  2167,     0,
     658,  2937,     0,  2154,   364,   658,  2155,     0,   658,     0,
       0,  2168,     0,     0,  2169,     0,     0,     0,  2161,     0,
       0,     0,  2162,     0,     0,     0,     0,     0,     0,  1724,
     658,  2158,  2288,     0,     0,     0,     0,  2159,     0,     0,
       0,     0,     0,  2163,  2164,     0,     0,     0,     0,     0,
       0,   659,   659, -2578,     0,     0,   987,     0,  1725,  2165,
       0,  2160,     0,     0,   658,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1024,     0,     0,     0,     0,
       0,     0,     0,     0,  2166,     0,  2170,  2167,     0,     0,
       0,   658,   658,     0,     0,     0,     0,     0,     0,     0,
    2168,     0,     0,  2169,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   658,     0,   364,     0,     0,
     208,     0,  2420,     0,  1728,     0,     0,     0,     0,     0,
    1729,     0,     0,     0,   658,     0,  1024,  1730,   658,     0,
       0,     0,     0,     0,     0,  2421,     0,  2174,  2175,  2176,
    2177,  2178,  2179,     0,  1732,     0,   658,  2439,     0,     0,
       0,  2161,  1733,     0,  2456,  2162,   658,     0,     0,     0,
       0,     0,     0,     0,     0,  2170,  2171,  2172,  2173,   658,
    2174,  2175,  2176,  2177,  2178,  2179,  2163,  2164,   658,  2486,
    3941,     0,     0,     0,     0,     0,     0,     0,  4931,     0,
       0,     0,  2165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1734,     0,     0,     0,     0,     0,     0,
       0,  2520,     0,     0,     0,     0,     0,  2166,     0,     0,
    2167,     0,     0,     0,  2537,     0,     0,     0,     0,     0,
       0,     0,     0,  2168,     0,  4931,   659,     0,  2549,     0,
       0,     0,     0,  4931,     0,  1764,  1765,     0,     0,     0,
       0,   659,     0,     0,     0,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,     0,     0,     0,     0,  3988,
     655,     0,     0,     0,   659,     0,     0,     0,     0,     0,
     985,     0,     0,     0,     0,  3796,  3799,     0,     0,     0,
       0,     0,     0,   985,   658,     0,     0,  3007,     0,     0,
       0,     0,  3011,     0,     0,  3014,     0,     0,  2170,     0,
     659,     0,     0,  1849,     0,     0,  1744,     0,     0,     0,
       0,  3843,  1745,     0,     0,   659,     0,  3037,     0,     0,
       0,   658,     0,  1908,  1909,     0,     0,   659,  2154,     0,
     659,  2155,     0,     0,     0,     0,     0,     0,     0,     0,
    1936,     0,     0,     0,     0,     0,     0,     0,  2156,     0,
       0,  3081,  1746,     0,     0,   987,  2158,     0,     0,     0,
       0,     0,  2159,     0,     0,     0,     0,     0,   987,   658,
       0,     0,     0,     0,     0,  1969,  1971,     0,  3095,     0,
       0,     0,     0,     0,     0,     0,  2160,     0,  2171,  2172,
    2173,   658,  2174,  2175,  2176,  2177,  2178,  2179,  3354,     0,
    2699,  1747,  3128,     0,     0,     0,   806,     0,  1748,     0,
       0,  1749,     0,     0,  3363,  3364,     0,     0,  3366,     0,
       0,  3149,     0,   657,  3370,  3159,     0,  1744,   657,   985,
       0,     0,     0,  1745,     0,     0,     0,   657,     0,     0,
       0,     0,     0,  3171,     0,     0,     0,  1548,  1548,     0,
       0,     0,   659,  3180,     0,     0,     0,     0,     0,     0,
     659,   659,     0,  1750,   657,     0,  3203,     0,   657,     0,
       0,   365,   364,  1746,     0,  3210,     0,     0,   364,   657,
       0,     0,     0,     0,     0,     0,  2161,     0,     0,     0,
    2162,     0,     0,     0,  3404,     0,     0,     0,     0,     0,
       0,     0,     0,   657,     0,     0,     0,     0,     0,     0,
       0,  2163,  2164,     0,   987,     0,     0,   657,  1751,     0,
    1752,   657,  1747,   365,   365,   365,     0,  2165,     0,  1748,
    1753,   657,  1749,     0,     0,     0,     0,     0,  1754,     0,
       0,     0,     0,     0,   659,   657,     0,  1755,     0,     0,
       0,     0,  2166,     0,     0,  2167,     0,     0,     0,     0,
       0,     0,     0,     0,   658,     0,     0,     0,  2168,     0,
       0,  2169,     0,     0,   365,     0,     0,     0,  2403,     0,
    2906,   365,  1757,     0,  1750,     0,     0,     0,   365,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2154,
       0,     0,  2155,     0,     0,  2926,     0,  2404,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4077,     0,     0,     0,     0,     0,  2158,     0,     0,
       0,     0,  1023,  2159,   657,     0,  1023,     0,   658,  1751,
       0,  1752,  2939,  2170,  2942,     0,     0,     0,     0,     0,
       0,  1753,     0,   658,   658,     0,     0,  2160,     0,  1754,
       0,     0,     0,     0,     0,  1759,     0,     0,  1755,     0,
       0,     0,     0,     0,  1744,     0,  3388,     0,     0,   658,
    1745,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3388,  3097,
       0,     0,     0,  1757,     0,     0,     0,     0,     0,     0,
       0,     0,   659,     0,     0,   985,     0,     0,     0,  4004,
    1746,   657,   657,     0,     0,     0,     0,     0,  1758,     0,
       0,   985,     0,  2171,  2172,  2173,     0,  2174,  2175,  2176,
    2177,  2178,  2179,     0,     0,     0,     0,  4063,     0,     0,
       0,     0,     0,     0,   364,   364,   364, -2578,     0,     0,
       0,  2162,     0,     0,     0,     0,     0,     0,     0,  1747,
    3631,     0,     0,   658,     0,     0,  1748,     0,     0,  1749,
     658,     0,  2163,  2164,     0,     0,  1759,     0,     0,   658,
       0,   985,   365,     0,     0,     0,     0,     0, -2578,     0,
     987,     0,  2459,     0,     0,     0,  1387,  1388,     0,   659,
       0,     0,     0,     0,     0,  4227,   987,     0,     0,  3799,
       0,     0,     0,     0,     0,   659,  2167,     0,     0,     0,
    4242,  1750,     0,     0,     0,     0,     0,     0,     0,  2168,
       0,     0,     0,  3678,     0,  3680,     0,     0,     0,     0,
     658,  3119,  2516,  2517,  2518,  2519,     0,     0,     0,     0,
     659,   659,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   659,     0,     0,     0,     0,   987,     0,   364,     0,
       0,     0,     0,   659,   659,     0,  1751,     0,  1752,     0,
       0,  2556,  2557,     0,     0,   364,     0,  2566,  1753,     0,
       0,     0,     0,     0,     0,   659,  1754,     0,     0,   658,
       0,   658,     0,     0, -2578,  1755,   657,     0,     0,     0,
       0,   658,     0,   658,     0,     0,     0,     0,     0,     0,
       0,   657,  3738,     0,     0,     0,     0,  3745,     0,   985,
       0,     0,     0,     0,  2587,  3610,  3173,     0,     0,     0,
    1757,     0,     0,     0,   657,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2620,  2621,
    2622,  2623,   658,     0,     0,  3174,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     657,     0,     0,     0,     0,     0,     0,  3295,     0,     0,
       0,     0,   658,     0,     0,   657,     0,     0,  2174,  2175,
    2176,  2177,  2178,  2179,     0,     0,     0,   657,     0,   658,
     657,     0,     0,     0,   987,     0,  2679,     0,     0,     0,
       0,     0,     0,  1759,   658,  2683,     0,   658,     0,     0,
       0,     0,  2690,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   365,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2324,     0,     0,
    3696,  2154,     0,     0,  2155,     0,  3897,  3708,     0,     0,
    3900,  3901,     0,  3903,     0,  3905,  3906,     0,     0,    74,
       0,  2156,     0,   985,  3911,     0,  1744,     0,     0,  2158,
     364,     0,  1745,  2154,     0,  2159,  2155,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3928,     0,  2160,
       0,  2158,   657,   365,     0,     0,     0,  2159,     0,     0,
     657,   657,  1746,     0,     0,   985,     0,  3750,     0,     0,
       0,   806,     0,     0,     0,     0,     0,     0,  4463,  4464,
       0,  2160,     0,  4467,  4468,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   987,     0,
       0,     0,     0,   365,     0,   365,     0,     0,     0,     0,
       0,  1747,     0,     0,     0,     0,     0,     0,  1748,  2860,
       0,  1749,     0,   806,     0,   659,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1744,     0,     0,  4007,   657,     0,  1745,     0,     0,  2161,
     987,     0,   659,  2162,     0,     0,   365,   659,     0,     0,
     659,     0,     0,  3799,  3799,  3799,  3799,  3799,     0,     0,
       0,   985,     0,  1750,  2163,  2164,     0,     0,     0,     0,
       0, -2578,   659,     0,     0,  2162,  1746,     0,   806,     0,
    2165,     0,     0,     0,   658,  1023,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3517,  2163,  2164,     0,     0,
       0,     0,     0,     0,     0,  2166,   659,     0,  2167,  2533,
       0,     0, -2578,     0,     0,     0,     0,  1023,  1751,     0,
    1752,  2168,     0,   364,  2169,  1747,  3919,   364,     0,   364,
    1753,     0,  1748,   659,   659,  1749,     0,     0,  1754,     0,
    2167,     0,     0,     0,  3929,     0,   987,  1755,     0,     0,
    1548,     0,     0,  2168,     0,     0,   365,   659,     0,   365,
       0,   658,     0,     0,   658,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   659,     0,  3211,     0,
     659,     0,  1757,     0,     0,     0,     0,  1750,     0,     0,
       0,     0,     0,     0,     0,     0,  2170,     0,   659,     0,
       0,     0,   657,     0,   658,     0,     0,  3212,   659,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   659,     0,     0,     0,     0,     0,  4615, -2578,     0,
     659,     0,     0,     0,     0,     0,  3049,  3050,  3051,     0,
       0,     0,  1751,  3059,  1752,  3061,     0,  3063,  3064,     0,
       0,     0,     0,     0,  1753,     0,     0,     0,     0,     0,
       0,     0,  1754,     0,     0,  1759,     0,     0,     0,     0,
       0,  1755,     0,     0,   658,   658,     0,     0,     0,     0,
     985,     0,   806,     0,     0,     0,  2171,  2172,  2173,     0,
    2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,   657,
    4090,     0,  3655,     0,     0,     0,  1757,     0,     0,     0,
       0,     0,     0,     0,  2154,   657,     0,  2155,     0,     0,
       0,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,
       0,  3656,     0,     0,  2156,     0,     0,     0,     0,     0,
       0,     0,  2158,     0,  3166,     0,   659,     0,  2159,     0,
     657,   657,     0,     0,     0,   658,     0,     0,     0,     0,
       0,   657,     0,     0,     0,   987,  2154,     0,     0,  2155,
       0,     0,  2160,   657,   657,     0,     0,     0,     0,     0,
       0,     0,     0,   659,     0,     0,     0,     0,     0,  1759,
       0,  4118,     0,     0,  2158,   657,     0,     0,     0,     0,
    2159,  3223,     0,     0,     0,     0,     0,     0,     0,  3232,
    3233,  3234,  3235,  3236,  3237,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2160,     0,     0,     0,     0,     0,
       0,   659,     0,     0,  4316,     0,     0,     0,     0,     0,
       0,     0,  4319,  4320,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   659,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4178,     0,
       0,  4181,  2161,     0,     0,  3835,  2162,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4371,     0,     0,  3317,
       0,     0,     0,     0,     0,     0,     0,  2163,  2164,     0,
    3850,     0,     0,     0,     0,     0,     0,     0,  3858,     0,
       0,     0,  3863,  2165,     0,     0,     0,     0,     0,  3357,
       0,  3359,     0,     0, -2578,     0,  3874,     0,  2162,     0,
       0,     0,     0,  1891,   365,     0,     0,  4807,  2166,     0,
     365,  2167,     0,   806,     0,     0,     0,     0,     0,  2163,
    2164,     0,     0,     0,  2168,     0,     0,  2169,     0,     0,
       0,     0,   364,     0,     0, -2578,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   658,     0,
       0,     0,     0,     0,     0,  2154,     0,     0,  2155,     0,
     658,     0,     0,  2167,     0,  1548,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2156,  2168,     0,     0,     0,
       0,     0,     0,  2158,     0,     0,     0,     0,     0,  2159,
       0,     0,  4808,     0,     0,  3410,   659,     0,     0,  2170,
       0,     0,     0,     0,     0,     0,     0,  2154,     0,     0,
    2155,     0,  4441,  2160,     0,     0,     0,   364,     0,   658,
       0,     0,     0,     0,     0,     0,     0,  2156,     0,     0,
       0,     0,  3388,     0,     0,  2158,     0,     0,     0,     0,
       0,  2159,     0,  4457,  4458,     0,     0,     0,     0,     0,
       0, -2578,     0,     0,     0,     0,     0,     0,     0,     0,
    1891,     0,     0,     0,     0,  2160,     0,     0,     0,     0,
     659,     0,     0,     0,     0,   657,     0,     0,     0,     0,
       0,     0,  4013,  4014,  4015,   659,   659,     0,  4928,  2171,
    2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,  4481,
    4482,     0,   657,  4339,     0,     0,   806,   657,     0,     0,
     657,   659,     0,  2161,     0,     0,     0,  2162,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   657,   658,     0,  4928,     0,     0,  2163,  2164,
       0,     0,     0,  4928,     0,  2174,  2175,  2176,  2177,  2178,
    2179,     0,     0,     0,  2165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2161,   657,     0,     0,  2162,
       0,     0,     0,     0,     0,     0,     0,  1023,     0,  2166,
       0,     0,  2167,     0,     0,     0,   365,   365,   365,     0,
    2163,  2164,     0,   657,   657,  2168,     0,   867,  2169,     0,
       0,     0,     0,     0,     0,   659,  2165,     0,     0,   868,
       0,     0,   659,     0,     0,     0,   806,   657,     0,   806,
    4561,   659,  4562,  4563,     0,     0,   658,     0,   658,     0,
     869,  2166,     0,  4566,  2167,     0,   657,     0,  1023,     0,
     657,     0,     0,   870,     0,     0,     0,  2168,     0,     0,
    2169,     0,   871,     0,     0,  4460,  -709,     0,   657,     0,
       0,     0,     0,     0,     0,     0,     0,  4470,   657,     0,
    2170,     0,  3637,   872,  3638,  3639,     0,     0,     0,   873,
       0,   657,   659,     0,     0,     0,     0,     0,     0,     0,
     657,     0,     0,     0,   874,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     365,     0,   875,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2170,   876,     0,     0,     0,   365,     0,  1891,
     877,     0,     0,     0,   878,     0,     0,     0,     0,     0,
       0,   659,     0,   659,     0,     0,     0,     0,     0,  -905,
       0,     0,     0,   659,     0,   659,     0,     0,     0,     0,
    2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,
    4239,     0,     0,     0,  4373,     0,     0,     0,     0,     0,
       0,     0,  2436,     0,     0,     0,     0,   879,     0,  4265,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   659,     0,   657,     0,     0,  1891,
       0,  4275,  2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,
    2178,  2179,     0,     0,   880,     0,  4582,   881,     0,     0,
       0,     0,     0,     0,   659,     0,     0,     0,     0,     0,
    3388,     0,     0,   657,   364,     0,     0,     0,     0,     0,
       0,   659,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   658,   659,     0,     0,   659,
       0,     0,  4718,     0,     0,     0,     0,   882,     0,  1891,
       0,     0,     0,   883,     0,     0,     0,     0,     0,  -386,
       0,   657,   884,     0,     0,     0,     0,     0,  1891,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   657,     0,     0,  1891,     0,  -386,     0,
     885,   886,     0,   887,   888,     0,     0,     0,  4744,     0,
       0,     0,   889,  3388,     0,  3388,     0,   890,     0,     0,
       0,     0,   365,   891,  1891,     0,   892,     0,     0,   893,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4770,  -386,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4374,  4375,  4376,  4377,   703,     0,     0,
       0,  3907,     0,     0,  3908,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   806,     0,     0,    85,     0,     0,
     806,     0,  1891,    89,     0,     0,     0,    93,     0,    94,
       0,    96,    97,     0,     0,   703,     0,     0,     0,     0,
       0,     0,   106,     0,     0,     0,     0,     0,  3933,   658,
       0,     0,     0,     0,     0,     0,   703,     0,     0,   119,
     120,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   996,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   997,     0,     0,
       0,     0,     0,     0,     0,  1005,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   128,   657,     0,     0,     0,
    1015,     0,   996,     0,     0,   129,  1036,   130,   131,     0,
       0,   364,     0,     0,     0,     0,  1066,     0,     0,     0,
       0,     0,  1099,     0,  1071,     0,   659,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   141,     0,   142,   143,     0,     0,     0,     0,
     146,     0,   147,     0,     0,     0,     0,     0,   364,     0,
       0,     0,   149,     0,   150,   365,   364,     0,     0,   365,
     657,   365,     0,     0,     0,     0,     0,     0,   153,     0,
     154,     0,     0,   157,     0,   657,   657,     0,     0,     0,
       0,     0,     0,     0,  4916,   158,     0,   159,     0,     0,
       0,   160,     0,   659,     0,     0,   659,   161,  1891,     0,
       0,   657,     0,     0,   163,     0,   165,     0,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   171,     0,     0,     0,
       0,     0,     0,  2919,     0,     0,   659,     0,     0,     0,
       0,     0,     0,     0,     0,  2154,     0,     0,  2155,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4113,  4114,  4115,  4116,     0,  2156,     0,     0,     0,     0,
       0,     0,     0,  2158,     0,  4556,   806,   806,   806,  2159,
     184,   185,     0,     0,     0,     0,   186,     0,     0,     0,
       0,     0,     0,     0,   187,   657,  2154,     0,     0,  2155,
       0,     0,   657,  2160,     0,   192,   659,   659,     0,     0,
       0,   657,     0,     0,     0,     0,  2156,     0,     0,     0,
       0,     0,     0,     0,  2158,     0,     0,     0,     0,     0,
    2159,     0,     0,     0,     0,     0,  3388,     0,     0,     0,
       0,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,  2160,     0,     0,     0,   206,     0,
     207,     0,     0,     0,     0,   208,     0,     0,     0,     0,
     209,     0,   657,   211,     0,     0,     0,   213,     0,     0,
       0,     0,   214,   215,     0,     0,     0,   659,     0,     0,
     216,     0,     0,   218,     0,     0,     0,     0,     0,     0,
     806,   221,     0,  2161,     0,     0,     0,  2162,     0,     0,
       0,     0,     0,   223,     0,     0,     0,   806,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2163,  2164,
     228,   657,   229,   657,     0,     0,  4257,     0,     0,     0,
     231,     0,     0,   657,  2165,   657,   232,     0,     0,     0,
       0,   233,     0,     0,  2161,     0,     0,     0,  2162,     0,
       0,     0,     0,   236,     0,     0,     0,     0,     0,  2166,
    3086,     0,  2167,  4667,     0,  2436,  3093,     0,     0,  2163,
    2164,     0,     0,     0,     0,  2168,     0,  1891,  2169,     0,
       0,     0,     0,     0,   657,  2165,     0,   246,     0,     0,
       0,  -132,     0,     0,  1548,     0,   703,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2166,     0,     0,  2167,   657,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2168,     0,     0,  2169,
       0,   657,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   657,     0,     0,   657,
    2170,     0,     0,     0,     0,     0,     0, -2085,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   365,     0,     0,     0,  4751,     0,
       0,     0,     0,  2154,     0,     0,  2155,     0,     0,     0,
     659,  2170,     0, -2085,     0,     0,     0,     0,     0,     0,
    1891,     0,   659,  2156,     0, -2085,     0,     0,     0, -2085,
       0,  2158,   806,     0, -2085,     0,     0,  2159,     0, -2085,
       0,     0, -2085,     0, -2085,     0,     0,     0,     0,     0,
    2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,
       0,  2160,     0,     0,  4624,     0,     0,     0,     0,     0,
       0, -2085,     0,     0,     0,     0,     0,     0,     0,   365,
       0,   659,     0,     0,     0,     0,     0,     0,     0,     0,
    2436,     0, -2085,     0,     0,     0,     0,     0,     0,     0,
       0,  2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,
    2179,  1163,  1169,  1169,   703,  4669,  1169,  1176,     0,  1163,
       0,  1066,     0,  1200,     0,     0,     0,  1066, -2085,  1066,
       0,     0,     0,  1169,     0,  1066, -2085,     0,     0,     0,
       0,     0,     0,  1227,     0,     0,     0,     0,  1066,     0,
    1163,     0,     0,  1169,     0,   703,     0,  1169,     0,     0,
       0,  2161,     0,  1200,     0,  2162,  1280,     0,     0,     0,
       0,     0,     0,  1169,     0,     0,     0,     0,     0,     0,
       0, -2085,     0,     0,     0,     0,  2163,  2164,     0,     0,
    1891,     0,     0,     0,  4476,   659,     0,     0,     0,     0,
       0,     0,  2165,     0,  1163,     0,   657,     0,  4479,   703,
       0,     0,     0,  1163,     0,     0,  1200,     0,     0,     0,
    2154,     0,     0,  2155,     0,     0,  1000,  2166,     0,     0,
    2167,  1169,     0,     0,     0,     0,     0,     0,     0,     0,
    2156,     0,     0,  2168,     0,   806,  2169,     0,  2158,   806,
   -2085,   806,     0,     0,  2159,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2085,     0, -2085, -2085,     0,  2160,     0,
       0,     0,     0,   657,  1066,     0,   657,     0,   659,     0,
     659,     0,     0,     0,     0,     0,  1066,  1423,     0,     0,
       0,     0,  4529,     0,     0,     0,     0,     0, -2085,     0,
       0, -2085, -2085,     0, -2085,     0,     0,     0,  2170,     0,
       0,     0,     0,  1530,     0,     0,   657,   703,  1066,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2154,     0,     0,  2155,  1066,     0,     0,     0,
    1066,     0,     0,  2919,  2919,  2919,     0,     0,  1530,     0,
       0,     0,  2156,     0,     0,     0,     0,     0,  1066,     0,
    2158,     0,     0,     0,     0,     0,  2159,     0,  2161,     0,
    1066,     0,  2162,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   657,   657,     0,     0,
    2160,     0,     0,  2163,  2164,     0,     0,     0,  2171,  2172,
    2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,  2165,
       0,     0,  4855,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2166,     0,     0,  2167,     0,  4629,
    4631,  4631,     0,     0,     0,     0,     0,     0,     0,     0,
    2168,  1066,     0,  2169,     0,     0,     0,     0,     0,  1169,
    1169,     0,     0,     0,     0,     0,     0,   657,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1891,     0,     0,     0,     0,     0,     0,     0,     0,
    2161,     0,     0,     0,  2162,     0,   365,     0,     0,     0,
       0,  1163,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1163,     0,     0,  1200,  2163,  2164,   659,     0,     0,
       0,  2436,  3093,     0,  3093,  2170,     0,  1169,     0,     0,
       0,  2165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1066,     0,     0,     0,     0,     0,  1169,  1169,     0,
       0,     0,     0,     0,     0,     0,  2166,  4704,     0,  2167,
       0,  1066,  1066,  1066,  1169,     0,  1163,     0,     0,     0,
    1944,     0,  2168,     0,     0,  2169,  1891,     0,  1891,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1169,  1169,
    1169,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,     0,     0,     0,     0,  4940,
       0,  1891,     0,  1530,     0,     0,     0,     0,     0,  4748,
       0,     0,     0,     0,     0,     0,     0,  2170,     0,     0,
       0,     0,     0,     0,     0,  1891,     0,     0,     0,     0,
       0,  4766,     0,  4768,     0,     0,     0,     0,     0,     0,
       0,  2043,  2043,     0,   806,     0,  1066,     0,   996,     0,
       0,   659,  3093,     0,     0,     0,     0,     0,     0,     0,
     657,     0,     0,     0,     0,  3093,     0,     0,     0,     0,
    2077,     0,   657,  1066,     0,     0,  2083,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1530,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2171,  2172,  2173,
       0,  2174,  2175,  2176,  2177,  2178,  2179,  1530,     0,  4058,
       0,     0,     0,   365,  4631,     0,     0,     0,  1891,   806,
    2154,   657,     0,  2155,     0,     0,     0,     0,     0,     0,
    2154,     0,  3093,  2155,     0,  1530,  1530,     0,  1530,     0,
    2156,     0,     0,     0,  2948,  1891,     0,     0,  2158,     0,
    2156,     0,     0,     0,  2159,  1530,  4853,     0,  2158,     0,
     365,     0,     0,     0,  2159,     0,     0,     0,   365,  2154,
       0,     0,  2155,     0,     0,   703,   703,     0,  2160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2160,  2156,
       0,     0,     0,     0,     0,     0,     0,  2158,     0,     0,
       0,     0,     0,  2159,  1066,     0,     0,  1530,     0,     0,
       0,     0,  4888,  1891,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2949,     0,     0,     0,  2160,     0,     0,
       0,     0,     0,  1891,     0,   657,  1530,     0,     0,     0,
    1530,  1530,  2154,     0,     0,  2155,     0,     0,     0,     0,
    1066,  1066,  2290,     0,     0,  4921,     0,     0,  1891,     0,
       0,     0,  2156,     0,     0,     0,     0,  3457,     0,     0,
    2158,     0,  3458,     0,     0,     0,  2159,     0,  2161,   703,
       0,     0,  2162,     0,     0,     0,     0,     0,  2161,     0,
       0,     0,  2162,     0,  1891,     0,     0,     0,     0,     0,
    2160,     0,     0,  2163,  2164,     0,     0,     0,     0,     0,
       0,     0,     0,  2163,  2164,     0,     0,     0,     0,  2165,
       0,     0,     0,     0,     0,     0,     0,  2161,   657,  2165,
     657,  2162,     0,     0,  2919,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2166,     0,     0,  2167,     0,     0,
       0,     0,  2163,  2164,  2166,     0,     0,  2167,     0,     0,
    2168,     0,     0,  2169,     0,     0,     0,     0,  2165,     0,
    2168,     0,     0,  2169,     0,     0,  1066,  2444,  4914,     0,
       0,     0,     0,  1066,     0,     0,  1169,     0,     0,     0,
       0,     0,     0,  2166,     0,     0,  2167,     0,     0,     0,
    2161,  1200,     0,     0,  2162,     0,     0,     0,  1066,  2168,
       0,     0,  2169,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2163,  2164,     0,  1066,     0,
       0,  3980,     0,     0,     0,  2170,  1169,  1169,  1169,  1169,
    1066,  2165,     0,     0,     0,  2170,     0,     0,     0,     0,
       0,     0,     0,  1066,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2548,  2166,  1066,     0,  2167,
       0,     0,     0,     0,     0,  1169,  1169,     0,     0,     0,
       0,  1169,  2168,     0,  2170,  2169,  2950,  3093,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3981,     0,
       0,     0,  4915,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2171,  2172,  2173,  1169,  2174,
    2175,  2176,  2177,  2178,  2179,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,     0,   806,     0,     0,     0,
       0,     0,  1169,  1169,  1169,  1169,     0,  2170,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   657,     0,     0,
       0,  2548,     0,     0,  2171,  2172,  2173,     0,  2174,  2175,
    2176,  2177,  2178,  2179,     0,     0,  1163,     0,     0,     0,
       0,     0,     0,   703,     0,  1163,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1200,     0,     0,     0,     0,
    1169,     0,     0,     0,     0,     0,     0,     0,     0,  1169,
       0,     0,     0,     0,     0,  1169,  1169,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1891,     0,  1066,
       0,     0,     0,     0,     0,     0,     0,  2171,  2172,  2173,
       0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2436,
       0,     0,     0,  2043,     0,     0,     0,     0,     0,     0,
    1169,     0,  1163,     0,     0,     0,  1066,  1066,     0,  1169,
       0,     0,     0,     0,     0,  1066,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   996,   996,  2154,     0,  2760,  2155,     0,     0,  1530,
    1530,     0,     0,     0,     0,     0,     0,  1530,     0,     0,
    1530,   657,     0,  2156,  1530,     0,  3420,     0,     0,     0,
       0,  2158,  1530,  1530,     0,     0,     0,  2159,     0,     0,
    1530,     0,  1200,  1530,  1530,  1530,  1530,     0,     0,     0,
       0,     0,     0,  1530,  1530,     0,  1530,     0,  1530,  1530,
       0,  2160,  1530,     0,     0,     0,     0,     0,     0,     0,
    1891,     0,     0,     0,     0,     0,     0,     0,     0,  1530,
       0,  1891,     0,  1169,  1530,     0,     0,     0,  1530,     0,
       0,     0,  1530,   806,  1530,  1530,  1530,  1530,  1530,  1530,
    1530,  1530,  1530,     0,  1530,     0,     0,     0,     0,  1066,
    1530,     0,     0,  1530,     0,     0,     0,     0,  2919,     0,
       0,     0,     0,  2919,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1066,  2919,     0,     0,     0,     0,
     806,     0,     0,     0,     0,     0,     0,     0,   806,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2161,     0,     0,     0,  2162,     0,     0,     0,     0,
       0,  1066,     0,  1066,     0,  1530,     0,     0,  1228,     0,
       0,     0,     0,     0,     0,     0,  2163,  2164,     0,     0,
       0,     0,  1891,     0,     0,  2154,     0,     0,  2155,     0,
       0,     0,  2165,     0,     0,     0,     0,     0,     0,     0,
       0,  1229,  2971,     0,  2978,  2156,     0,     0,     0,     0,
    1891,     0,     0,  2158,  1230,  1231,     0,  2166,     0,  2159,
    2167,     0,  1891,  1232,     0,     0,     0,  1233,     0,     0,
       0,     0,     0,  2168,     0,     0,  2169,     0,     0,     0,
       0,     0,     0,  2160,  1234,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1235,  1891,     0,   703,     0,
       0,     0,     0,   996,     0,   996,     0,     0,     0,     0,
       0,     0,     0,  1236,     0,     0,     0,     0,     0,     0,
       0,     0,  1530,     0,  1237,     0,     0,     0,  1163,  1238,
    1169,  1169,  1169,     0,  1163,  1200,     0,  1169,  2170,  1169,
       0,  1169,  1169,     0,     0,  1066,     0,     0,     0,     0,
    1239,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2161,     0,  1240,     0,  2162,     0,     0,
       0,     0,     0,  2444,     0,     0,     0,     0,     0,  3101,
       0,     0,     0,     0,  3110,     0,     0,     0,  2163,  2164,
    1066,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4554,     0,     0,  2165,  3141,  3141,     0,     0,     0,
       0,     0,   703,     0,     0,  1241,     0,     0,  2171,  2172,
    2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,  1169,  2166,
       0,     0,  2167,     0,     0,     0,     0,     0,  1891,     0,
       0,     0,     0,   841,     0,  2168,     0,     0,  2169,     0,
       0,     0,     0,     0,  3198,     0,  3200,  3202,     0,     0,
       0,     0,  3435,     0,     0,     0,     0,     0,  1242,     0,
       0,     0,  1243,     0,  1244,     0,     0,     0,     0,     0,
    1245,     0,     0,  1246,     0,  1169,     0,     0,     0,     0,
       0,     0,     0,  1169,  1169,  1169,  1169,  1169,  1169,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1530,  1247,
       0,  1248,     0,     0,     0,  1249,     0,     0,     0,     0,
    2170,     0,     0,  1250,     0,     0,     0,     0,  1251,     0,
       0,  2444,     0,     0,  2154,  3141,  1066,  2155,     0,     0,
     996,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3093,  1252,  2156,     0,     0,  3465,     0,     0,
       0,     0,  2158,     0,     0,     0,  3198,     0,  2159,     0,
       0,     0,     0,  1169,  3325,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1944,     0,     0,     0,     0,     0,
       0,     0,  2160,     0,     0,     0,     0,     0,     0,     0,
       0,  1169,     0,  1169,  3141,  1169,  3141,     0,     0,     0,
    2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,
       0,     0,     0,     0,     0,     0,     0,     0,  1530,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3093,     0,     0,     0,     0,     0,
    2043,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1891,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2161,     0,  1163,     0,  2162,  1891,     0,  1163,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1169,
       0,     0,     0,     0,     0,  1530,  1530,  2163,  2164,     0,
       0,  1530,     0,     0,     0,     0,     0,     0,  2154,     0,
       0,  2155,     0,  2165,     0,     0,  1891,     0,     0,     0,
    1891,  1891,     0,     0,     0,     0,  1530,  1530,  2156,     0,
       0,  1530,     0,     0,     0,     0,  2158,     0,  2166,     0,
       0,  2167,  2159,  1530,  1530,  1530,  1530,     0,     0,     0,
       0,     0,     0,     0,  2168,     0,  1530,  2169,     0,  1530,
       0,  1530,  3485,     0,     0,     0,  2160,     0,     0,     0,
       0,  1530,  1530,     0,     0,  1530,     0,     0,     0,     0,
       0,     0,  4554,     0,     0,     0,     0,     0,  1530,     0,
    1530,     0,  1200,     0,  1530,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1530,     0,     0,     0,  1066,     0,     0,     0,     0,     0,
       0,  3530,     0,  1530,  1530,  1530,     0,     0,     0,  2170,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1530,     0,     0,
    3470,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1530,     0,     0,     0,     0,  1530,  2161,     0,     0,  1066,
    2162,     0,  1530,     0,     0,     0,     0,     0,  3530,     0,
       0,  3591,     0,     0,     0,  2978,     0,     0,     0,     0,
       0,  2163,  2164,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2165,   814,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2171,
    2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,
       0,     0,  2166,     0,     0,  2167,     0,     0,  1530,     0,
    3141,     0,     0,     0,     0,  2043,     0,     0,  2168,     0,
       0,  2169,     0,   814,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1169,     0,  1169,  1169,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1027,
       0,     0,     0,     0,     0,     0,     0,  1027,     0,  1027,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   814,     0,  2170,     0,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     8,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,    36,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,  2171,  2172,  2173,     0,  2174,  2175,  2176,
    2177,  2178,  2179,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3141,
    3141,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2154,     0,    46,  2155,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3800,     0,
       0,     0,     0,     0,  2156,     0,     0,  3476,     0,     0,
       0,     0,  2158,     0,     0,     0,     0,     0,  2159,     0,
       0,     0,     0,     0,  1066,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2160,     0,     0,     0,     0,     0,  2043,  1066,
       0,     0,     0,     0,     0,     0,    47,  1066,     0,     0,
       0,  1066,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,     0,     0,  1066,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     703,     0,    49,     0,     0,     0,     0,     0,     0,     0,
    1889,     0,     0,     0,     0,  1169,     0,     0,  1169,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1163,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2161,     0,  1066,     0,  2162,     0,    51,     0,
       0,    52,  1169,     0,     0,     0,     0,     0,     0,     0,
    1530,     0,     0,     0,     0,     0,    53,  2163,  2164,     0,
    1530,     0,     0,     0,     0,     0,  1530,     0,  1530,     0,
       0,     0,     0,  2165,  1530,     0,     0,  1530,  1530,  1530,
    1530,  1530,  1530,  1530,  1530,  1530,  1530,     0,     0,     0,
    1530,  1530,     0,     0,     0,     0,     0,     0,  2166,     0,
       0,  2167,     0,  1530,     0,     0,     0,  1530,     0,     0,
       0,  1530,     0,     0,  2168,     0,     0,  2169,     0,     0,
       0,  1530,     0,     0,  1530,     0,  1530,     0,     0,    54,
       0,     0,     0,     0,     0,  1530,  1530,  1530,     0,     0,
       0,  1530,     0,     0,  1530,     0,     0,  1889,     0,     0,
       0,  1066,  1066,  1066,  3530,  4021,     0,     0,     0,  4021,
    4034,     0,  2154,     0,  1530,  2155,     0,     0,     0,     0,
    4048,    55,  1530,     0,  1530,     0,     0,     0,     0,     0,
       0,     0,  2156,     0,     0,    56,     0,     0,     0,  2170,
    2158,     0,     0,     0,     0,     0,  2159,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1530,
    2160,     0,     0,     0,     0,  1530,    58,     0,     0,  2978,
       0,  1530,    59,     0,     0,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,    67,    68,     0,    69,    70,
      71,    72,    73,     0,     0,     0,  4096,  2043,  2043,     0,
    2548,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1169,  1169,  1169,  1169,     0,  2171,
    2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,  2220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4139,     0,     0,     0,     0,     0,     0,     0,
    2161,     0,     0,     0,  2162,     0,     0,     0,     0,     0,
       0,   814,     0,     0,     0,     0,     0,     0,     0,  1165,
       0,     0,     0,     0,     0,  2163,  2164,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4194,  1165,     0,
       0,     0,     0,     0,     0,     0,  2166,     0,     0,  2167,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2168,     0,     0,  2169,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1889,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3800,  1165,     0,     0,     0,     0,     0,     0,  1066,
       0,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
    1169,     0,  1530,     0,     0,     0,     0,     0,  1066,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1889,
    2444,     0,     0,     0,     0,     0,     0,  2170,     0,     0,
    1066,     0,     0,     0,     0,     0,     0, -2087,     0,  3198,
       0,     0,  2154,     0,  4292,  2155,  1889,     0,  2444,     0,
       0,     0,     0,  3937,     0,     0,     0,     0,     0,     0,
    1530,  1530,  2156,     0,     0,  3987,     0,     0,     0,     0,
    2158,     0,     0,     0,  2154,     0,  2159,  2155,     0,     0,
       0,     0,     0, -2087,     0,  3141,     0,  3141,     0,     0,
       0,     0,     0,     0,  2156, -2087,  1881,     0,     0, -2087,
    2160,  1165,  2158,     0, -2087,     0,     0,  1027,  2159, -2087,
       0,  1027, -2087,     0, -2087,     0,  1889,  2171,  2172,  2173,
    1530,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,
       0,     0,  2160,     0,     0,  1889,  1165,     0,     0,     0,
       0, -2087,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1889,     0,     0,     0,  1530,     0,     0,
       0,     0, -2087,     0,     0,     0,     0,  1530,  1530,     0,
       0,     0,     0,     0,     0,  1530,  1530,     0,   828,     0,
    1530,  1889,     0,     0,     0,     0,  1530,  1530,     0,     0,
    1530,     0,  1066,  1066,  1066,  1066,     0,     0, -2087,  4021,
    2161,     0,  4379,     0,  2162,  3530, -2087,     0,     0,  3530,
       0,     0,     0,     0,     0,  4392,     0,     0,  1530,     0,
       0,     0,     0,  1530,   829,  2163,  2164,     0,     0,  4402,
       0,     0,  2161,     0,     0,  1530,  2162,   830,     0,  1889,
       0,  2165,     0,     0,  1200,     0,     0,     0,     0,     0,
       0, -2087,  3591,  1881,   831,     0,  2978,  2163,  2164,     0,
     832,     0,     0,     0,     0,     0,  2166,     0,     0,  2167,
       0,   996,     0,  2165,  1530,   833,     0,     0,     0,     0,
       0,     0,  2168,     0,     0,  2169,     0,     0,     0,  1165,
       0,     0,     0,   834,  3141,  3141,  1000,     0,  2166,  1165,
       0,  2167,     0,     0,   835,     0,     0,     0,     0,   836,
       0,     0,     0,     0,  2168,   837,     0,  2169,  4455,     0,
   -2087,  1892,     0,     0,     0,     0,     0,     0,     0,     0,
     838,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2087,     0, -2087, -2087,     0,     0,     0,
       0,     0,     0,     0,  1165,   839,     0,  2170,  1169,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1169,     0,     0,     0,     0,     0, -2087,     0,
       0, -2087, -2087,     0, -2087,     0,     0,     0,     0,  2170,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   840,  2043,     0,     0,     0,
       0,     0,     0,     0,     0,  3800,  3800,  3800,  3800,  3800,
       0,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   841,     0,  1889,     0,     0,     0,  1530,
       0,     0,     0,     0,     0,     0,     0,  2171,  2172,  2173,
       0,  2174,  2175,  2176,  2177,  2178,  2179,     0,   842,     0,
       0,     0,     0,     0,   843,     0,  1169,  2444,     0,     0,
     844,     0,     0,   845,     0,     0,     0,     0,  1892,  2171,
    2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,
       0,     0,     0,     0,  1066,     0,  4560,     0,     0,   846,
       0,   847,     0,     0,     0,   848,  1165,     0,     0,     0,
       0,     0,     0,   849,     0,     0,     0,     0,   850,     0,
       0,     0,  1881,     0,  1530,     0,     0,     0,     0,     0,
     851,     0,     0,  1530,     0,  1165,     0,     0,     0,     0,
       0,     0,     0,   852,     0,     0,     0,     0,     0,     0,
    1530,  1530,     0,     0,  1530,     0,     0,     0,     0,     0,
       0,  4021,     0,  1165,  1165,  3530,  1165,     0,     0,     0,
    3530,     0,     0,  3530,  3198,  1881,  4604,     0,  1530,  1530,
       0,     0,     0,  1165,     0,     0,     0,     0,     0,     0,
       0,   921,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1881,   922,     0,     0,     0,     0,     0,     0,
       0,  4096,  1200,  1169,  1169,  1169,     0,     0,     0,     0,
       0,     0,     0,     0,   923,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1165,   814,   924,     0,     0,
       0,     0,     0,     0,     0,     0,  1163,  1200,     0,     0,
     925,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,   926,  1165,  1165,
       0,     0,  1881,     0,     0,     0,     0,  2043,     0,     0,
       0,     0,     0,  1163,     0,     0,     0,     0,   927,     0,
   -2100,  1881,  1066,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3141,     0,  2444,   928,  1889,     0,  1881,
       0,     0,  1889,  1889,     0,     0,     0,   929,  4292,     0,
       0,     0,   930,  1066,  1889,     0,     0,     0,   931,     0,
       0,  1169,  4096,     0,     0,     0, -2100,  1881,     0,     0,
       0,     0,     0,   932,     0,     0,     0,  1892, -2100,     0,
       0,     0, -2100,   814,     0,     0,  1530, -2100,     0,  1530,
    1027,  1530, -2100,     0,     0, -2100,     0, -2100,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1530,     0,
       0,     0,  3530,     0,     0,  4604,     0,     0,     0,     0,
       0,  4738,  1027,     0, -2100,  1881,     0,     0,     0,     0,
    1892,  1744,     0,     0,     0,     0,     0,  1745,     0,     0,
       0,     0,     0,  1169,     0, -2100,     0,  1066,   933,     0,
       0,     0,     0,     0,     0,     0,     0,  1892,   934,     0,
       0,     0,  1776,     0,  1169,  1169,  1169,  1169,     0,     0,
       0,     0,     0,     0,     0,     0,   841,  1746,     0,     0,
       0, -2100,     0,     0,     0,     0,     0,  1889,     0, -2100,
       0,     0,     0,     0,  1530,     0,     0,     0,     0,     0,
       0,   935,     0,     0,     0,   936,     0,   937,  1777,     0,
       0,     0,     0,   938,     0,     0,   939,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1747,  1892,     0,     0,
       0,     0,     0,  1748, -2100,     0,  1749,     0,     0,     0,
       0,     0,   940,     0,   941,     0,  1892,     0,   942,     0,
       0,     0,  1530,     0,     0,     0,   943,  1889,  1169,     0,
    1200,   944,     0,     0,  1892,     0,     0,     0,     0,  1530,
       0,     0,     0,   945,     0,     0,     0,     0,     0,  1000,
       0,     0,     0,     0,     0,  1778,   946,   814,  1750,     0,
       0,     0,  1892,     0,     0,     0,     0,     0,     0,     0,
    1169,     0,     0, -2100,  1163,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
       0,  1881,     0,  4560,     0,     0, -2100,     0, -2100, -2100,
       0,  1779,  4738,  1780,     0,  1530,  1530,     0,     0,     0,
       0,     0,     0,  1781,  1165,  1752,     0,     0,  1163,     0,
    1892,     0,     0,  1165,     0,  1753,  1169,  1889,     0,     0,
       0, -2100,     0,  1754, -2100, -2100,     0, -2100,     0,     0,
       0,  1782,  1755,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1530,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1530,     0,     0,     0,     0,  1169,
       0,     0,     0,  1783,     0,     0,     0,  1757,  1784,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1785,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,     0,  1786,     0,     0,     0,     0,     0,     0,
       0,     0,  1530,     0,     0,     0,     0,     0,     0,     0,
       0,  1163,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1165,  1165,     0,
       0,     0,     0,     0,     0,  1165,     0,     0,  1165,     0,
    1759,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
    1165,  1165,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,  1165,  1165,  1165,  1165,     0,     0,     0,     0,     0,
       0,  1165,  1165,     0,  1165,     0,  1165,  1165,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1892,  1165,   814,     0,
       0,     0,  1165,     0,     0,     0,  1165,     0,     0,     0,
    1165,     0,  1165,  1165,  1165,  1165,  1165,  1165,  1165,  1165,
    1165,     0,  1165,     0,     4,     0,     0,     0,  1165,     0,
       0,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1881,     5,     0,     0,     0,  1881,  1881,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
    1881,     0,     9,    10,     0,     0,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,  1165,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,     0,     0,  1889,     0,
       0,     0,  1744,     0,     0,     0,     0,     0,  1745,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1776,     0,     0,     0,     0,  1889,  1889,
       0,  1889,     0,    46,     0,     0,     0,     0,  1746,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1777,
       0,   814,     0,  1881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1889,     0,  1889,     0,  1747,     0,     0,
       0,     0,     0,     0,  1748,     0,     0,  1749,     0,     0,
    1165,     0,     0,    47,     0,     0,  1165,     0,     0,     0,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1889,    49,
       0,     0,  1027,  1881,     0,     0,  1778,     0,  1892,  1750,
       0,     0,     0,  1892,  1892,     0,     0,     0,     0,     0,
       0,    50,  1889,     0,     0,  1892,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   814,     0,     0,   814,     0,     0,     0,     0,  1889,
       0,     0,  1779,     0,  1780,    51,     0,     0,    52,     0,
       0,     0,  1889,  1027,  1781,     0,  1752,     0,     0,     0,
       0,     0,     0,    53,     0,     0,  1753,     0,     0,     0,
       0,     0,     0,     0,  1754,     0,     0,     0,     0,     0,
       0,     0,  1782,  1755,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3161,  1889,     0,     0,  1757,  1784,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1889,
    1025,     0,     0,     0,     0,     0,    54,     0,  1025,     0,
    1025,     0,  1889,  3162,     0,     0,  1165,     0,  1892,     0,
       0,     0,     0,     0,  1786,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    56,     0,     0,     0,     0,     0,     0,     0,
       0,  1759,     0,     0,     0,     0,     0,    57,     0,     0,
    1889,     0,     0,     0,     0,     0,     0,     0,  1892,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1889,     0,     0,    58,     0,     0,     0,     0,     0,    59,
       0,     0,     0,    60,    61,    62,    63,    64,     0,     0,
      65,    66,  1349,     0,     0,  1889,     0,    71,  1350,     0,
       0,     0,     0,     0,     0,     0,  1165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1889,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1892,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1165,     0,     0,     0,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1165,  1165,     0,     0,     0,     0,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,  1165,     0,     0,     0,  1165,
       0,     0,     0,     0,  1881,     0,     0,     0,     0,     0,
       0,  1165,  1165,  1165,  1165,     0,     0,     0,     0,   814,
       0,     0,     0,     0,  1165,   814,     0,  1165,     0,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1165,
    1165,     0,     0,  1165,  1881,  1881,     0,  1881,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,     0,  1165,     0,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1165,
       0,  1165,  1165,  1165,  1889,     0,     0,     0,     0,  1881,
       0,  1881,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,  1165,     0,     0,     0,     0,     0,     0,
    1165,     0,     0,     0,     0,     0,  1165,     0,     0,     0,
       0,     0,     0,     0,  1881,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1881,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1881,  1165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1881,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1892,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1889,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1892,
    1892,     0,  1892,     0,     0,     0,  1889,     0,     0,     0,
       0,  1881,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1881,     0,     0,     0,     0,
       0,   814,   814,   814,     0,     0,     0,     0,  1881,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1892,     0,  1892,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
       0,     0,     0,     0,     0,     0,  1881,     0,     0,  1892,
       0,     0,     0,     0,     0,     0,     0,  1889,     0,     0,
       0,     0,     0,     0,     0,     0,  1881,     0,  1889,  1161,
       0,     0,     0,  1892,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1881,     0,     0,     0,   814,     0,     0,     0,     0,
    1892,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   814,  1892,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,     0,  1881,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1892,     0,     0,  1889,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1892,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1892,     0,     0,     0,  1889,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1889,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1165,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,  1025,     0,
       0,     0,  1025,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1889,     0,     0,     0,     0,  1165,     0,
       0,  1892,     0,     0,     0,     0,     0,  1161,  1165,     0,
       0,     0,     0,     0,  1165,     0,  1165,     0,     0,     0,
       0,  1892,  1165,     0,     0,  1165,  1165,  1165,  1165,  1165,
    1165,  1165,  1165,  1165,  1165,     0,     0,     0,  1165,  1165,
       0,     0,     0,     0,     0,     0,  1892,     0,     0,     0,
    1881,  1165,     0,     0,     0,  1165,     0,   814,     0,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1165,
       0,     0,  1165,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,  1892,  1165,  1165,  1165,     0,     0,     0,  1165,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1889,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,  1165,     0,     0,
    1161,     0,     0,  1165,     0,     0,     0,     0,     0,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1890,     0,     0,     0,     0,     0,     0,     0,
    1881,     0,     0,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,     0,  1881,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1889,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     814,     0,     0,     0,   814,  1892,   814,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1881,     0,     0,     0,     0,     0,  1890,
       0,  1889,     0,     0,  1881,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1889,     0,     0,  1161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,     0,     0,  1889,     0,  1161,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1892,     0,     0,     0,     0,
       0,     0,     0,     0,  1161,  1161,     0,  1161,     0,     0,
       0,     0,     0,  1889,     0,     0,     0,  1889,  1889,     0,
       0,     0,     0,     0,  1161,     0,     0,  1892,  1165,  1165,
       0,     0,     0,     0,     0,  1881,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1881,  1161,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,  1161,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,  1881,
       0,     0,     0,     0,     0,  1165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1165,  1165,     0,  1892,     0,
       0,     0,     0,  1165,  1165,     0,     0,     0,  1165,  1892,
       0,     0,     0,     0,  1165,  1165,     0,     0,  1165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1165,     0,     0,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,     0,  1890,     0,
       0,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1025,     0,  1165,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1025,     0,     0,     0,     0,     0,     0,
       0,  1890,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1892,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
       0,  1881,     0,     0,     0,     0,     0,     0,     0,   814,
       0,     0,     0,     0,     0,     0,     0,     0,  1892,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1892,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
       0,     0,     0,     0,  1892,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1890,     0,     0,
       0,     0,     0,     0,   814,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1890,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1881,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1890,     0,     0,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,  1892,
       0,  1890,     0,     0,  1161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1881,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1165,     0,     0,     0,  1892,     0,     0,     0,
    1881,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1165,  1165,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
    1881,     0,     0,  1165,     0,     0,     0,     0,  1165,     0,
       0,  1165,     0,     0,     0,     0,  1165,  1165,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1881,
       0,     0,     0,  1881,  1881,     0,     0,     0,     0,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,  1161,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,  1161,
       0,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
    1892,  1161,  1161,     0,  1165,     0,     0,     0,     0,  1161,
       0,     0,  1161,  1161,  1161,  1161,     0,     0,     0,     0,
       0,     0,  1161,  1161,     0,  1161,     0,  1161,  1161,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1165,     0,     0,     0,     0,     0,  1890,  1161,     0,
       0,     0,     0,  1161,     0,     0,     0,  1161,     0,     0,
       0,  1161,     0,  1161,  1161,  1161,  1161,  1161,  1161,  1161,
    1161,  1161,     0,  1161,     0,     0,     0,     0,     0,  1161,
       0,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,  1892,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,  1892,     0,  1165,     0,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,     0,     0,     0,
    1165,     0,     0,     0,  1161,  1892,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   814,     0,     0,  1892,     0,     0,     0,  1892,  1892,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1883,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1892,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,  1161,     0,     0,
    1165,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1025,     0,     0,     0,     0,     0,  1890,
       0,     0,     0,     0,  1890,  1890,     0,     0,     0,     0,
       0,     0,  1165,     0,     0,     0,  1890,     0,     0,     0,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1165,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1025,     0,  1165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1883,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   908,     0,     0,     0,     0,
       0,     0,  1165,     0,   908,     0,     0,     0,     0,     0,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   814,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   908,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,  1890,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,     0,     0,     0,   814,     0,  1080,     0,  1165,
       0,     0,     0,   814,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1890,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,     0,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,  1890,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,  1161,     0,     0,     0,     0,  1161,     0,
       0,     0,  1129,  1883,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1161,  1161,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,  1161,  1161,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,  1883,     0,     0,     0,
       0,     0,  1161,  1161,  1161,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,  1161,     0,
    1161,     0,     0,  1883,     0,     0,     0,     0,     0,     0,
    1161,  1161,     0,     0,  1161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,  1161,
      47,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    48,     0,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,  1161,  1161,  1161,     0,    49,     0,     0,     0,
       0,     0,     0,  1883,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1161,     0,    50,     0,
       0,     0,  1883,     0,     0,     0,     0,     0,     0,  1161,
       0,     0,     0,     0,  1161,     0,     0,     0,     0,     0,
    1883,  1161,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,     0,    51,     0,     0,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1883,     0,
      53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,   908,   908,
       0,     0,     0,     0,     0,   663,     0,     0,     0,     0,
     707,     0,   707,     0,     0,     0,  1883,     0,     0,     0,
    1890,     0,   707,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    54,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1129,     0,   707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   707,     0,
    1890,  1890,     0,  1890,     0,     0,     0,     0,     0,   707,
     707,     0,     0,   707,     0,    55,     0,     0,     0,   707,
       0,     0,     0,   988,     0,     0,     0,     0,     0,    56,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   988,    57,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1890,     0,  1890,     0,   707,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      58,     0,     0,     0,     0,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1349,
    1995,     0,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1175,     0,     0,     0,     0,
    1890,     0,     0,     0,  1202,     0,  1205,     0,  1208,     0,
    1210,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1890,     0,     0,     0,     0,  1259,
       0,     0,     0,     0,     0,     0,  1266,     0,     0,     0,
       0,     0,  1883,     0,     0,  1281,  1282,     0,     0,     0,
    1284,  1890,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1890,     0,  1129,     0,   908,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1313,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1334,     0,     0,
    1336,     0,  1338,     0,  1341,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   908,     0,
       0,     0,     0,     0,     0,     0,     0,  1890,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1890,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1890,     0,     0,   707,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1420,     0,  1421,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1161,     0,     0,     0,     0,  1884,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1129,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1161,
       0,     0,  1890,     0,     0,     0,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,  1161,     0,  1161,  1080,     0,
       0,     0,  1890,  1161,     0,     0,  1161,  1161,  1161,  1161,
    1161,  1161,  1161,  1161,  1161,  1161,     0,     0,     0,  1161,
    1161,     0,     0,     0,     0,     0,     0,  1890,     0,     0,
       0,     0,  1161,     0,     0,     0,  1161,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,  1161,     0,  1161,     0,     0,     0,     0,
       0,     0,     0,  1890,  1161,  1161,  1161,     0,     0,  1679,
    1161,  1681,     0,  1161,  1883,  1683,     0,     0,     0,  1883,
    1883,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,  1883,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,  1161,     0,  1161,     0,     0,  1884,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   707,
       0,     0,     0,     0,     0,     0,     0,  1824,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
       0,     0,     0,  1837,  1161,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,  1845,     0,     0,     0,     0,     0,
       0,  1847,     0,   707,   707,     0,     0,     0,     0,     0,
       0,     0,     0,  1898,     0,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1940,     0,     0,     0,     0,
       0,   707,     0,     0,  1883,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1890,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,  1883,     0,     0,     6,     7,     0,
       0,     0,     0,     0,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1884,     0,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1883,     0,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1890,     0,     0,     0,
    1301,   707,     0,   707,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1884,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,  1161,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1884,     0,     0,     0,   707,
       0,     0,   707,   707,     0,     0,    47,     0,     0,     0,
       0,     0,     0,     0,     0,   663,     0,   988,     0,   988,
       0,     0,    48,     0,     0,   663,     0,     0,     0,   707,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1161,
       0,     0,    49,     0,     0,     0,     0,     0,   988,   988,
       0,     0,     0,     0,  1080,  2255,     0,     0,     0,     0,
       0,     0,     0,     0,    50,  1884,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,     0,
       0,     0,     0,     0,  1884,     0,  1161,  1161,   707,  1890,
     707,     0,     0,     0,  1161,  1161,     0,     0,    51,  1161,
    1890,    52,  1884,     0,     0,  1161,  1161,     0,     0,  1161,
       0,     0,  2322,     0,     0,  2322,    53,     0,     0,     0,
       0,     0,     0,  2329,  1161,     0,     0,     0,  1161,     0,
    1884,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,  2338,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   663,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2401,     0,
       0,   663,   663,     0,     0,  1661,     0,     0,  1884,    54,
       0,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1890,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     663,    55,     0,     0,     0,  1883,     0,     0,     0,  1890,
       0,     0,     0,     0,     0,    56,     0,     0,     0,     0,
       0,  1890,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1883,  1883,     0,  1883,     0,
       0,     0,     0,     0,     0,     0,    58,     0,     0,     0,
       0,     0,    59,     0,     0,  1890,    60,    61,    62,    63,
      64,     0,     0,    65,    66,  1349,  2691,     0,     0,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1883,     0,  1883,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
       0,     0,     0,     0,     0,  2596,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2618,     0,
       0,     0,     0,     0,  1884,  1883,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1883,
    1890,     0,     0,     0,   663,     0,     0,     0,     0,   707,
       0,   707,  2663,     0,   707,     0,   707,     0,     0,   707,
     707,   707,     0,     0,     0,  2038,  1883,  2678,     0,  2680,
       0,  2681,   707,  1161,     0,     0,  2682,  1890,     0,  1883,
       0,     0,  1161,     0,     0,   707,     0,   707,     0,     0,
       0,     0,   707,     0,     0,     0,     0,     0,     0,  1161,
    1161,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1161,     0,     0,     0,     0,  1161,
       0,     0,  1161,     0,     0,  2711,     0,  1161,  1161,     0,
       0,     0,     0,     0,     0,     0,     0,  2255,     0,     0,
       0,  2255,  1883,  2255,     0,     0,  2255,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1883,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,  1883,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1890,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2195,
       0,     0,     0,     0,     0,     0,     0,     0,   707,   707,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,     0,     0,   663,     0,  1883,     0,     0,
     663,   663,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1883,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,  1883,  1890,  2920,     0,  1884,     0,     0,     0,
       0,  1884,  1884,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1884,     0,  1161,  1890,     0,  1161,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,  1883,     0,
       0,     0,   707,     0,   663,     0,     0,  1161,     0,     0,
       0,  1161,     0,     0,  2326,     0,  1890,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1890,     0,     0,     0,  1890,
    1890,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   663,     0,     0,
       0,     0,     0,     0,     0,   663,     0,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,  1129,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1884,     0,  3008,  3009,
       0,  1890,     0,  3012,  3013,     0,     0,  3016,     0,     0,
       0,     0,   663,     0,     0,   663,   663,  3026,     0,     0,
       0,     0,     0,     0,  3035,     0,     0,     0,  3038,  3039,
       0,  1161,  3042,  3043,  3044,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3058,     0,  3060,     0,  1161,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3082,     0,     0,     0,  1884,  3084,     0,     0,
       0,  1883,     0,     0,     0,     0,     0,   663,     0,     0,
       0,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,     0,     0,  3102,  3103,
    3106,  3108,     0,     0,     0,  3115,  3118,     0,     0,     0,
       0,     0,     0,  3129,  1161,  1161,  3133,     0,     0,     0,
    3137,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,     0,     0,     0,     0,     0,  3160,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3167,     0,  3169,
       0,     0,     0,     0,  3172,     0,     0,     0,     0,  3176,
    3177,  3178,  3179,  1161,  3181,     0,  1884,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,     0,  3204,  3205,  3206,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3214,
    3215,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1883,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,  3274,     0,     0,     0,     0,
       0,     0,     0,  1883,   707,     0,   707,     0,     4,     0,
     707,     0,   707,     0,     0,   707,     0,     0,     0,   707,
       0,     0,     0,     0,  2195,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,     0,     0,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,     0,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1129,  1883,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,  1883,  2255,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3399,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2038,     0,     0,     0,     0,     0,     0,  2921,
       0,     0,     0,     0,     0,     0,     0,     0,  2326,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,  1884,     0,     0,
       0,  1166,     0,    48,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1883,     0,     0,     0,
       0,     0,     0,    49,     0,     0,     0,     0,     0,     0,
       0,     0,   663,     0,     0,     0,     0,  1884,  1884,     0,
    1884,     0,     0,     0,  1883,    50,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1883,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    51,
       0,   663,    52,     0,     0,   663,     0,     0,     0,     0,
       0,  2992,  1884,  1661,  1884,     0,   707,    53,     0,     0,
    1883,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3570,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,  1884,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      54,  1884,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3611,  3612,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1884,     0,
       0,     0,     0,  2255,     0,     0,     0,     0,     0,     0,
       0,  1884,    55,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    56,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    57,     0,     0,     0,     0,  3645,  3647,     0,     0,
       0,  3647,  1883,     0,     0,   663,  3658,  3659,  3660,     0,
       0,     0,     0,   663,     0,   663,     0,    58,     0,     0,
       0,     0,     0,    59,  1884,     0,     0,    60,    61,    62,
      63,    64,     0,     0,    65,    66,  1349,     0,  1884,     0,
       0,    71,  3681,  3682,  3683,  3684,     0,     0,     0,  1166,
       0,  1884,     0,     0,     0,  1518,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3709,     0,
       0,  1893,     0,     0,     0,     0,     0,     0,     0,     0,
    1589,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,  1883,     0,     0,  1884,
       0,     0,     0,     0,     0,     0,     0,     0,  1886,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1884,
    3747,     0,     0,     0,     0,     0,     0,     0,  3751,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1884,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1884,     0,     0,     0,     0,     0,     0,  3832,  1883,     0,
       0,     0,     0,     0,     0,     0,     0,  3838,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   707,  2038,
       0,  1883,     0,     0,     0,     0,     0,     0,  1893,     0,
       0,     0,     0,     0,  3857,   663,  3859,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1883,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   908,     0,     0,  3899,  1886,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,  3909,     0,
    1883,     0,     0,     0,  1883,  1883,     0,     0,     0,     0,
       0,  2255,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,  1166,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1884,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,  1166,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2326,     0,     0,     0,     0,   663,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2092,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2116,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1893,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2141,  2142,     0,
    2145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2185,     0,     0,
       0,     0,     0,  1884,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1886,     0,     0,     0,     0,     0,
    1893,  4107,     0,  4108,     0,     0,     0,  4110,     0,     0,
       0,     0,     0,     0,     0,  1884,     0,     0,     0,     0,
       0,     0,  4119,     0,     0,     0,     0,  1893,     0,  2239,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4127,
       0,     0,     0,     0,     0,     0,     0,  1886,  4138,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2262,     0,
       0,     0,  2272,  2275,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1886,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4166,  4167,
    4168,  4169,  4170,  4171,  4172,     0,     0,  1893,     0,  4179,
    4180,     0,  4182,  4183,  4184,  4185,  4186,  4187,  4188,     0,
       0,     0,     0,     0,     0,     0,  1893,  4195,     0,  4197,
    4198,     0,     0,     0,     0,     0,  1884,     0,     0,     0,
       0,     0,     0,     0,  1893,     0,     0,  1884,     0,     0,
       0,     0,     0,     0,  1886,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1893,  1886,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1886,     0,     0,  4251,  4253,  4255,     0,     0,  4258,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   663,     0,     0,     0,  1886,
       0,     0,     0,     0,  1166,     0,     0,     0,   663,     0,
    1893,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1884,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3647,     0,     0,  1886,     0,     0,
       0,     0,     0,     0,     0,     0,  1884,     0,     0,     0,
       0,     0,     0,     0,  2255,  2255,  2255,     0,  1884,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   707,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1884,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,  1166,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,  1166,     0,
       0,     0,  1166,     0,   663,     0,     0,     0,     0,     0,
    1166,  1166,     0,     0,     0,     0,     0,     0,  1166,     0,
       0,  1166,  1166,  1166,  1166,     0,     0,     0,     0,     0,
       0,  1166,  1166,     0,  1166,     0,  1166,  1166,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1893,  1166,     0,     0,
       0,     0,  1166,     0,     0,     0,  1166,     0,     0,     0,
    1166,     0,  1166,  1166,  1166,  1166,  1166,  1166,  1166,  1166,
    1166,     0,  1166,     0,     0,     0,     0,     0,  1166,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1886,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1884,     0,     0,     0,     0,     0,
       0,  4445,  4446,  4447,  4448,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,  4461,  4462,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4471,  4472,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2255,  2255,     0,  2255,     0,  2786,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2992,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2809,     0,     0,  2811,     0,     0,  2822,     0,
       0,     0,     0,     0,     0,  2829,  2834,     0,     0,     0,
       0,  2840,     0,     0,  2845,     0,     0,     0,  1884,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2854,     0,     0,     0,     0,  2861,     0,     0,     0,
    2873,     0,     0,     0,  2880,     0,  2882,  2883,  2884,  2885,
    2886,  2887,  2888,  2889,  2890,     0,  2891,     0,     0,     0,
    1166,     0,  1518,     0,     0,  2916,  1166,  4523,     0,     0,
     663,     0,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   663,     0,     0,     0,
    4545,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1893,     0,
    1884,     0,  4564,  1893,  1893,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1893,     0,  1589,     0,     0,
       0,     0,     0,  1884,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   663,     0,     0,     0,
       0,     0,     0,     0,     0,  1886,     0,     0,     0,     0,
    1886,  1886,     0,  1884,     0,     0,     0,     0,     0,     0,
       0,  2255,  1886,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2255,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1884,     0,     0,     0,  1884,  1884,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3040,     0,  1166,     0,  1893,     0,
       0,     0,     0,     0,  4650,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   663,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1886,     0,     0,     0,     0,
    4674,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1893,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3647,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1886,  1166,     0,     0,     0,
       0,     0,     0,  2255,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2255,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1887,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1893,  4754,
       0,     0,  2326,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,  2255,  1166,     0,     0,
    3250,     0,     0,     0,     0,     0,     0,     0,   663,     0,
       0,     0,     0,  1166,  1166,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,  1886,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,  1166,     0,     0,     0,  1166,
       0,     0,     0,     0,  3647,     0,     0,     0,     0,     0,
     663,  1166,  1166,  1166,  1166,     0,     0,     0,     0,     0,
       0,  2255,     0,     0,  1166,     0,     0,  1166,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
    1166,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,  1166,     0,
       0,     0,  1166,  1887,     0,     0,     0,     0,     0,     0,
    3371,     0,     0,     0,     0,     0,  4852,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,  1166,  1166,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,   663,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,     0,
       0,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3416,     0,
       0,     0,     0,  3422,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2834,  1166,  2834,  2834,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3479,     0,
       0,  3482,     0,  3484,     0,     0,     0,     0,     0,  1893,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3505,     0,  3507,     0,     0,     0,  3510,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1893,
    1893,     0,  1893,     0,     0,     0,  1886,     0,     0,     0,
       0,     0,     0,     0,     0,  2916,  2916,  2916,     0,   707,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3567,
       0,     0,     0,     0,     0,     0,  1886,  1886,     0,  1886,
       0,     0,  2262,     0,  1893,     0,  1893,  3579,     0,     0,
       0,     0,  1887,     0,  2275,   663,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1886,     0,  1886,     0,     0,     0,     0,     0,  1893,
       0,     0,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,  1888,     0,     0,     0,     0,     0,
    3620,     0,     0,  1893,     0,     0,     0,     0,     0,     0,
       0,     0,  1887,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1886,     0,     0,     0,
    1893,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1893,     0,     0,     0,     0,     0,     0,
    1886,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1886,     0,     0,
       0,     0,  1887,     0,     0,     0,     0,     0,     0,     0,
    1886,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1887,     0,     0,     0,     0,  1893,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1887,
    1893,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1887,     0,     0,
       0,  1888,     0,  1886,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,     0,  1886,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1886,     0,     0,     0,     0,     0,  2181,     0,     0,     0,
       0,     0,   663,     0,     0,     0,     0,     0,  1166,     0,
       0,  1893,     0,     0,     0,  1887,     0,     0,  1166,     0,
       0,     0,     0,     0,  1166,     0,  1166,     0,     0,     0,
       0,  1893,  1166,     0,     0,  1166,  1166,  1166,  1166,  1166,
    1166,  1166,  1166,  1166,  1166,     0,     0,     0,  1166,  1166,
       0,     0,     0,     0,     0,     0,  1893,     0,  1886,     0,
       0,  1166,     0,     0,     0,  1166,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,  1886,  1166,
       0,     0,  1166,     0,  1166,     0,     0,  2181,     0,     0,
       0,     0,  1893,  1166,  1166,  1166,     0,     0,     0,  1166,
       0,     0,  1166,  1886,     0,     0,     0,     0,     0,     0,
       0,  2181,  1166,     0,     0,     0,  2818,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,     0,     0,
    1166,     0,  1166,     0,     0,     0,  2181,  2181,     0,  1886,
    2181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
    2181,     0,     0,  1166,     0,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3938,     0,     0,     0,     0,     0,     0,     0,
       0,  1887,  3942,     0,  1166,     0,     0,     0,  3943,     0,
    3944,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,     0,  2181,     0,     0,     0,     0,     0,
       0,     0,  3962,  3963,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2181,     0,     0,
       0,     0,     0,  2840,     0,     0,     0,  2181,     0,     0,
    2181,     0,     0,  3991,     0,     0,  3994,     0,  3996,     0,
       0,     0,     0,  1888,     0,  1893,     0,  4000,     0,     0,
       0,     0,     0,  4005,     0,     0,  4008,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,     0,     0,     0,  4037,     0,     0,     0,
       0,     0,     0,     0,  4049,     0,  2916,     0,     0,     0,
       0,     0,  1886,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4066,     0,     0,     0,     0,     0,  1518,     0,     0,
    1888,     0,     0,  1589,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,  1888,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1893,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1888,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1893,  1166,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1886,  1887,     0,     0,     0,     0,  1887,  1887,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1887,     0,     0,  1888,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1886,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,  1166,     0,  1893,     0,
       0,     0,     0,  1166,  1166,     0,     0,     0,  1166,  1893,
       0,     0,     0,     0,  1166,  1166,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,     0,     0,  1886,  1166,     0,     0,     0,
       0,  1166,     0,  1887,     0,     0,  1886,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4305,  4306,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
    1893,     0,     0,  1887,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4337,     0,     0,     0,     0,     0,  1893,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1893,     0,     0,     0,     0,     0,     0,  1886,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4355,
    4357,     0,     0,     0,     0,  1886,     0,     0,     0,     0,
       0,  2181,  4364,     0,  1893,     0,     0,  1886,  4369,  4370,
       0,     0,  4372,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1887,  2181,     0,  2181,     0,  2818,  2818,
    3453,     0,     0,  2818,     0,     0,     0,  2181,     0,     0,
    2916,     0,     0,     0,  2181,  2916,     0,     0,     0,  2181,
       0,  1886,     0,     0,     0,  2181,     0,  2916,     0,     0,
    2181,     0,     0,     0,     0,     0,     0,  1166,     0,  2181,
       0,     0,     0,  2818,  2818,     0,  2181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2181,     0,
       0,     0,     0,     0,     0,  2181,  4426,  2181,  2181,  2181,
    2181,  2181,  2181,  2181,  2181,  2181,  2181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1893,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,  1893,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,  1166,
       0,     0,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,  1888,     0,  1166,     0,     0,  1888,  1888,  1166,     0,
       0,  1166,     0,  1886,     0,     0,  1166,  1166,  1888,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2181,     0,     0,     0,     0,
       0,  4512,     0,     0,     0,     0,     0,     0,     0,     0,
    1893,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,  1886,     0,     0,
       0,     0,     0,     0,  1887,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1888,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,     0,  1893,     0,  1887,  1887,     0,  1887,     0,     0,
       0,     0,     0,     0,     0,     0,  4590,     0,     0,     0,
       0,     0,     0,     0,  1166,  1893,     0,  1166,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4607,     0,     0,     0,     0,  1166,     0,     0,  1886,
    1166,  1888,     0,     0,     0,  1893,     0,     0,     0,  1887,
       0,  1887,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1886,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1893,     0,     0,     0,  1893,  1893,
       0,     0,  1886,     0,     0,  2181,     0,     0,     0,     0,
       0,     0,     0,     0,  1887,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,  1887,     0,
       0,  1886,     0,     0,     0,  1886,  1886,     0,     0,     0,
       0,  1888,     0,     0,     0,     0,     0,     0,     0,     0,
    1893,     0,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1887,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2840,     0,     0,     0,     0,  2181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4729,  1887,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1887,     0,
       0,  2181,     0,  1166,  1166,     0,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,  3453,  3453,     0,  2818,     0,     0,  2818,
    2818,  2818,  2818,  2818,  2818,  2818,  2818,  2818,  2818,  3453,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,  4790,     0,     0,     0,
       0,     0,  1166,     0,  2181,     0,  1887,  2181,     0,  2181,
       0,     0,     0,     0,  3453,  3453,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1887,     0,  2818,  2818,
    2181,     0,  2181,     0,     0,  2181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1887,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,  4834,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1887,     0,     0,
       0,     0,  2181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1888,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4874,  4874,     0,
       0,     0,     0,     0,     0,  2181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1888,  1888,     0,  1888,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4874,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4918,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1888,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4874,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1888,     0,     0,     0,     0,     0,     0,     0,
    1887,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1888,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1888,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1888,     0,     0,     0,
       0,     0,     0,     0,  2818,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1888,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1888,     0,     0,     0,
    1887,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1887,  2181,     0,     0,     0,  2181,  2181,  2181,
       0,     0,  3453,     0,     0,     0,     0,  3453,  3453,  3453,
    3453,  3453,  3453,  3453,  3453,  3453,  3453,  2181,  2181,     0,
       0,     0,     0,     0,  1888,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1888,     0,  2181,  2818,  2818,  2181,
       0,  2181,     0,     0,     0,  2181,  3453,  3453,     0,     0,
    2181,     0,     0,  2181,     0,     0,     0,     0,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1887,  2181,  1888,     0,     0,     0,     0,
       0,     0,     0,     0,  1887,     0,     0,     0,     0,     0,
       0,  2181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1887,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1888,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1887,
       0,     0,     0,     0,  3453,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2181,  2181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2181,     0,     0,     0,  2818,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2181,     0,  2181,     0,     0,     0,     0,  3453,  3453,  2181,
       0,     0,  2818,  2818,  2181,  2181,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1888,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1887,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1888,  2181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1888,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1888,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3453,  2818,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3453,  3453,  2181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2181,     0,     0,     0,     0,  1887,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1887,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1888,     0,     0,     0,     0,     0,     0,
    1887,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1888,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1888,     0,     0,     0,     0,     0,  1887,
       0,     0,     0,  1887,  1887,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3453,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1888,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1888,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1888,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1888,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,  1888,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,  1888,     0,     0,
       0,  1888,  1888,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   724,
     421,   422,   423,   725,   726,   727,   728,   729,   730,   731,
     424,   425,   732,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,   733,   431,   432,   433,   434,   435,
     734,   735,   436,   437,   736,   140,   438,   737,   439,   440,
     441,   442,   144,   738,   145,   739,   443,   444,   445,   446,
     148,   447,   740,   741,   448,   449,   450,   451,   452,   453,
     742,   151,   454,   743,   744,   745,   746,   152,   747,   748,
     749,   455,   456,   457,   458,   686,   459,   155,   156,   460,
     750,   461,   751,   462,   463,   464,   465,   466,   752,   467,
     468,   469,   753,   754,   470,   471,   472,   473,   474,   755,
     475,   476,   477,   756,   478,   479,   757,   480,   481,   482,
     483,   164,   484,   485,   486,   166,   758,   487,   759,   488,
     168,   489,   760,   490,   761,   491,   169,   762,   170,   492,
     493,   494,   763,   495,   172,   764,   496,   765,   497,   498,
     688,   499,   500,   173,   501,   502,   503,   766,   504,   505,
     506,   507,   508,   509,   767,   510,   174,   175,   768,   511,
     512,   513,   769,   176,   770,   177,   771,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,   772,
     523,   181,   182,   524,   183,   773,   525,   526,   527,   774,
     775,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,   189,   190,   538,   539,   191,   776,
     540,   541,   193,   542,   777,   194,   543,   195,   544,   545,
     546,   778,   547,   779,   780,   548,   549,   550,   781,   782,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,   783,   558,   201,   559,   202,   560,   561,   562,
     784,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,   785,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,   786,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,   787,
     595,   596,   597,   598,   599,   788,   600,   217,   601,   602,
     219,   603,   220,   604,   789,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,   790,   615,   616,   791,
     617,   618,   619,   620,   621,   622,   792,   224,   225,   793,
     794,   624,   226,   625,   227,   795,   626,   627,   628,   629,
     630,   631,   632,   796,   797,   633,   634,   635,   636,   637,
     798,   799,   638,   639,   640,   641,   642,   800,   234,   801,
     643,   235,   644,   645,   646,   802,   803,   647,   804,   805,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    85,     0,     0,
      86,    87,    88,    89,    90,    91,    92,    93,     0,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   950,
     104,   105,   106,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,   119,
     120,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,   127,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   129,     0,   130,   131,     0,
       0,     0,     0,     0,     0,     0,     0,   132,     0,   133,
       0,     0,   134,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,   141,     0,   142,   143,   144,     0,   145,     0,
     146,     0,   147,     0,   148,     0,     0,     0,     0,     0,
       0,     0,   149,     0,   150,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,   153,     0,
     154,   155,   156,   157,     0,     0,     0,     0,     0, -1350,
       0,     0,     0,     0,     0,   158,     0,   159,     0,     0,
       0,   160,     0,     0,     0,     0,     0,   161,   162,     0,
       0,     0,     0,     0,   163,   164,   165,     0,     0,   166,
       0,     0,   167,     0,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,   171,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,   173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     174,   175,     0,     0, -1350,     0,     0,   176,     0,   177,
       0,     0,   178,   179,     0,   180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,   182,     0,   183,     0,
     184,   185,     0,     0,     0,     0,   186,     0,     0,     0,
       0,     0,     0,     0,   187,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,   192,   193,     0,     0,   194,
       0,   195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   196,   197,   198,   199,   200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   201,     0,
     202,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   204,   205,     0,     0,     0,     0,   206,     0,
     207,     0,     0,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,   211,   212,     0,     0,   213,     0,     0,
       0,     0,   214,   215,     0,     0,     0,     0,     0,     0,
     216,   217,     0,   218,   219,     0,   220,     0,     0,     0,
       0,   221,     0,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,   223,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
     228,     0,   229,     0,     0,     0,     0,   230,     0,     0,
     231,     0,     0, -1350,     0,     0,   232,     0,     0,     0,
       0,   233,   234,     0,     0,   235,     0,     0,     0,     0,
       0,     0,     0,   236,     0,     0,     0,     0,     0,   237,
     238,   239,   240,   241,   242,   243,   244,   245,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   246,   104,   105,
       0,  -132,     0,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115,     0,   116,   117,   118,     0,     0,     0,
       0,     0,   121,   122,     0,     0,     0,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,   145,     0,     0,     0,
       0,     0,   148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   151,     0,     0,     0,     0,     0,   152,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
     156,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   164,     0,     0,     0,   166,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,     0,     0,     0,   176,     0,   177,     0,     0,
     178,   179,     0,   180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,   212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   224,
     225,     0,     0,     0,   226,     0,   227,     0,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     234,     0,     0,   235,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   237,   238,   239,
     240,   241,   242,   243,   244,   245,     0,     0,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
       0,     0,  2982,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115,     0,   116,   117,   118,     0,     0,     0,
       0,     0,   121,   122,     0,     0,     0,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,   145,     0,     0,     0,
       0,     0,   148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   151,     0,     0,     0,     0,     0,   152,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
     156,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   164,     0,     0,     0,   166,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,     0,     0,     0,   176,     0,   177,     0,     0,
     178,   179,     0,   180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,   212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   224,
     225,     0,     0,     0,   226,     0,   227,     0,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     234,     0,     0,   235,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   237,   238,   239,
     240,   241,   242,   243,   244,   245,     0,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,  2984,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,   412,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,  2910,   421,   422,   423,     0,     0,     0,     0,  1441,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,  1442,   137,  1443,  1444,     0,   431,   432,   433,
     434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,
     439,   440,   441,   442,  1449,     0,  1450,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,  1451,  1452,  1453,  1454,
    1455,  1456,  1457,   455,   456,   457,   458,   686,   459,  1458,
    1459,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,  2911,     0,   470,   471,  1460,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,  1461,   484,   485,   486,  1462,  1463,   487,
       0,   488,  1464,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,  1465,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,  1466,  1467,     0,  1468,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,  1469,   182,   524,   183,     0,   525,   526,
     527,  1470,  1471,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,  1472,   189,  1473,   538,   539,
     191,  1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,
     544,   545,   546,     0,   547,     0,     0,  1478,   549,   550,
       0,     0,   196,   197,   198,   199,  1479,   551,   552,   553,
     554,   555,   556,   557,     0,   558,  1480,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
    1481,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,  1482,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,  1483,   600,   217,
     601,   602,   219,   603,  1484,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,  1485,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1486,
    1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,   627,
     628,   629,   630,   631,   632,     0,  1491,   633,   634,   635,
     636,   637,  1492,     0,   638,   639,   640,   641,   642,   692,
    1493,  2912,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,
       0,     0,     0,     0,     0,     0,  1502,  1503,  2913,     0,
       0,     0,     0,     0,     0,  1505,  2914,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,   412,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,  1441,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,  1442,   137,  1443,  1444,     0,   431,   432,   433,
     434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,
     439,   440,   441,   442,  1449,     0,  1450,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,  1451,  1452,  1453,  1454,
    1455,  1456,  1457,   455,   456,   457,   458,   686,   459,  1458,
    1459,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,  1460,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,  1461,   484,   485,   486,  1462,  1463,   487,
       0,   488,  1464,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,  1465,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,  1466,  1467,     0,  1468,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,  1469,   182,   524,   183,     0,   525,   526,
     527,  1470,  1471,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,  1472,   189,  1473,   538,   539,
     191,  1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,
     544,   545,   546,     0,   547,     0,     0,  1478,   549,   550,
       0,     0,   196,   197,   198,   199,  1479,   551,   552,   553,
     554,   555,   556,   557,     0,   558,  1480,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
    1481,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,  1482,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,  1483,   600,   217,
     601,   602,   219,   603,  1484,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,  1485,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1486,
    1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,   627,
     628,   629,   630,   631,   632,     0,  1491,   633,   634,   635,
     636,   637,  1492,     0,   638,   639,   640,   641,   642,   692,
    1493,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,
       0,     0,     0,     0,     0,     0,  1502,  1503,     0,     0,
       0,     0,     0,     0,     0,  1505,  2820,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,     0,  1859,   137,  1860,  1861,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,  1862,  1863,   438,     0,
     439,   440,   441,   442,     0,     0,   145,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,     0,     0,     0,   152,
       0,     0,     0,   455,   456,   457,   458,   686,   459,  1864,
    1865,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,  1460,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,     0,   484,   485,   486,     0,     0,   487,
       0,   488,  1866,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,     0,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,  2424,
     504,   505,   506,   507,   508,   509,     0,   510,   174,  2425,
       0,   511,   512,   513,  1466,  1867,     0,  1868,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,     0,   182,   524,   183,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,  1869,   189,  1870,   538,   539,
       0,     0,   540,   541,   193,   542,     0,     0,   543,  1871,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,  2426,   197,   198,   199,     0,   551,   552,   553,
     554,   555,   556,   557,     0,   558,     0,   559,     0,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
    1872,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,  2427,
     601,   602,   219,   603,  1874,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,     0,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1875,
    1876,     0,     0,   624,     0,   625,     0,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,     0,
    1877,  2428,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   693,   653,   654,     0,
       0,     0,     0,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,  2429,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,     0,  1859,   137,
    1860,  1861,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,  1862,  1863,   438,     0,   439,   440,   441,   442,
       0,     0,   145,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,   686,   459,  1864,  1865,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,     0,
     484,   485,   486,     0,     0,   487,     0,   488,  1866,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,     0,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,  2424,   504,   505,   506,   507,
     508,   509,     0,   510,   174,  2425,     0,   511,   512,   513,
    1466,  1867,     0,  1868,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,     0,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1869,   189,  1870,   538,   539,     0,     0,   540,   541,
     193,   542,     0,     0,   543,  1871,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,  2426,   197,
     198,   199,     0,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,     0,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1872,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,  2427,   601,   602,   219,   603,
    1874,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,     0,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1875,  1876,     0,     0,   624,
       0,   625,     0,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,  1877,  2428,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   693,   653,   654,     0,     0,     0,     0,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,  3333,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1437,  1438,  1439,
      45,  1440,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,  1441,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,  1442,   137,  1443,  1444,  2830,   431,
     432,   433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,
     438,     0,   439,   440,   441,   442,  1449,     0,  1450,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,  1451,  1452,
    1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,
     459,  1458,  1459,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,  1461,   484,   485,   486,  1462,
    1463,   487,     0,   488,  1464,   489,     0,   490,     0,   491,
     169,  2831,   170,   492,   493,   494,     0,   495,  1465,     0,
     496,     0,   497,   498,   688,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,  1466,  1467,     0,  1468,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,  2832,   523,  1469,   182,   524,   183,     0,
     525,   526,   527,  1470,  1471,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1472,   189,  1473,
     538,   539,   191,  1474,   540,   541,   193,   542,  1475,  1476,
     543,  1477,   544,   545,   546,     0,   547,     0,     0,  1478,
     549,   550,     0,     0,   196,   197,   198,   199,  1479,   551,
     552,   553,   554,   555,   556,   557,     0,   558,  1480,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1481,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,  1482,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,  1483,
     600,   217,   601,   602,   219,   603,  1484,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,  1485,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1486,  1487,     0,  2833,   624,  1488,   625,  1489,  1490,
     626,   627,   628,   629,   630,   631,   632,     0,  1491,   633,
     634,   635,   636,   637,  1492,     0,   638,   639,   640,   641,
     642,   692,  1493,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
    1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,
     654,     0,     0,     0,     0,     0,     0,     0,  1502,  1503,
       0,     0,     0,     0,     0,     0,     0,  1505,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,   412,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1437,  1438,  1439,    45,
    1440,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
    1441,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,  1442,   137,  1443,  1444,     0,   431,   432,
     433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,
       0,   439,   440,   441,   442,  1449,     0,  1450,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,  1451,  1452,  1453,
    1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,   459,
    1458,  1459,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,  1460,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,  1461,   484,   485,   486,  1462,  1463,
     487,     0,   488,  1464,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,  1465,     0,   496,
       0,   497,   498,   688,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,  1466,  1467,     0,  1468,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,  1469,   182,   524,   183,     0,   525,
     526,   527,  1470,  1471,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,  1472,   189,  1473,   538,
     539,   191,  1474,   540,   541,   193,   542,  1475,  1476,   543,
    1477,   544,   545,   546,     0,   547,     0,     0,  1478,   549,
     550,     0,     0,   196,   197,   198,   199,  1479,   551,   552,
     553,   554,   555,   556,   557,     0,   558,  1480,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,  1481,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,  1482,   588,   589,   590,   591,   592,   593,
     691,   594,   215,   595,   596,   597,   598,   599,  1483,   600,
     217,   601,   602,   219,   603,  1484,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,  1485,     0,
     615,   616,   223,   617,   618,   619,   620,   621,   622,     0,
    1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,
     627,   628,   629,   630,   631,   632,     0,  1491,   633,   634,
     635,   636,   637,  1492,     0,   638,   639,   640,   641,   642,
    2143,  1493,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,   236,   648,   649,   650,   651,   652,   237,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,
       0,     0,     0,     0,     0,     0,     0,  1502,  1503,     0,
       0,     0,     0,     0,     0,     0,  1505,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,   412,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,  1441,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,  1442,   137,  1443,  1444,     0,   431,   432,   433,
     434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,
     439,   440,   441,   442,  1449,     0,  1450,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,  1451,  1452,  1453,  1454,
    1455,  1456,  1457,   455,   456,   457,   458,   686,   459,  1458,
    1459,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,  1460,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,  1461,   484,   485,   486,  1462,  1463,   487,
       0,   488,  1464,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,  1465,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,  1466,  1467,     0,  1468,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,  1469,   182,   524,   183,     0,   525,   526,
     527,  1470,  1471,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,  1472,   189,  1473,   538,   539,
     191,  1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,
     544,   545,   546,     0,   547,     0,     0,  1478,   549,   550,
       0,     0,   196,   197,   198,   199,  1479,   551,   552,   553,
     554,   555,   556,   557,     0,   558,  1480,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
    1481,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,  1482,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,  1483,   600,   217,
     601,   602,   219,   603,  1484,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,  1485,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1486,
    1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,   627,
     628,   629,   630,   631,   632,     0,  1491,   633,   634,   635,
     636,   637,  1492,     0,   638,   639,   640,   641,   642,   692,
    1493,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,
       0,     0,     0,     0,     0,     0,  1502,  1503,     0,     0,
       0,     0,     0,  2087,  2778,  1505,   717,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   718,   104,   105,   672,
     719,     0,   107,   108,   109,   110,   720,   721,   112,   113,
     114,   115,     0,   116,   722,   723,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,   412,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,  1441,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,  1442,   137,  1443,  1444,     0,   431,   432,   433,   434,
     435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,
     440,   441,   442,  1449,     0,  1450,     0,   443,   444,   445,
     446,   148,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,  1451,  1452,  1453,  1454,  1455,
    1456,  1457,   455,   456,   457,   458,   686,   459,  1458,  1459,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,  1460,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,  1461,   484,   485,   486,  1462,  1463,   487,     0,
     488,  1464,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,  1465,     0,   496,     0,   497,
     498,   688,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,  1466,  1467,     0,  1468,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,  1469,   182,   524,   183,     0,   525,   526,   527,
    1470,  1471,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,  1472,   189,  1473,   538,   539,   191,
    1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,   544,
     545,   546,     0,   547,     0,     0,  1478,   549,   550,     0,
       0,   196,   197,   198,   199,  1479,   551,   552,   553,   554,
     555,   556,   557,     0,   558,  1480,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,  1481,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,  1482,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,  1483,   600,   217,   601,
     602,   219,   603,  1484,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,  1485,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,  1486,  1487,
       0,     0,   624,  1488,   625,  1489,  1490,   626,   627,   628,
     629,   630,   631,   632,     0,  1491,   633,   634,   635,   636,
     637,  1492,     0,   638,   639,   640,   641,   642,   692,  1493,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,  1494,  1495,  1496,
    1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,
       0,     0,     0,     0,     0,  1502,  1503,  1504,     0,     0,
       0,     0,     0,     0,  1505,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,   412,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,  1441,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
    1442,   137,  1443,  1444,     0,   431,   432,   433,   434,   435,
    1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,   440,
     441,   442,  1449,     0,  1450,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,
    1457,   455,   456,   457,   458,   686,   459,  1458,  1459,   460,
    1588,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,  1461,   484,   485,   486,  1462,  1463,   487,     0,   488,
    1464,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,  1465,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,  1466,  1467,     0,  1468,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,  1469,   182,   524,   183,     0,   525,   526,   527,  1470,
    1471,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1472,   189,  1473,   538,   539,   191,  1474,
     540,   541,   193,   542,  1475,  1476,   543,  1477,   544,   545,
     546,     0,   547,     0,     0,  1478,   549,   550,     0,     0,
     196,   197,   198,   199,  1479,   551,   552,   553,   554,   555,
     556,   557,     0,   558,  1480,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1481,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
    1482,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,  1483,   600,   217,   601,   602,
     219,   603,  1484,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,  1485,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1486,  1487,     0,
       0,   624,  1488,   625,  1489,  1490,   626,   627,   628,   629,
     630,   631,   632,     0,  1491,   633,   634,   635,   636,   637,
    1492,     0,   638,   639,   640,   641,   642,   692,  1493,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,
    1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,     0,
       0,     0,     0,     0,  1502,  1503,     0,     0,     0,     0,
       0,     0,     0,  1505,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,  2270,   421,
     422,   423,     0,     0,     0,     0,  1441,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,  1442,
     137,  1443,  1444,     0,   431,   432,   433,   434,   435,  1445,
    1446,   436,   437,  1447,  1448,   438,     0,   439,   440,   441,
     442,  1449,     0,  1450,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,
     455,   456,   457,   458,   686,   459,  1458,  1459,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
    1461,   484,   485,   486,  1462,  1463,   487,     0,   488,  1464,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,  1465,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,  1466,  1467,     0,  1468,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
    1469,   182,   524,   183,     0,   525,   526,   527,  1470,  1471,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1472,   189,  1473,   538,   539,   191,  1474,   540,
     541,   193,   542,  1475,  1476,   543,  1477,   544,   545,   546,
       0,   547,     0,     0,  1478,   549,   550,     0,     0,   196,
     197,   198,   199,  1479,   551,   552,   553,   554,   555,   556,
     557,     0,   558,  1480,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1481,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,  1482,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,  1483,   600,   217,   601,   602,   219,
     603,  1484,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,  1485,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1486,  1487,     0,     0,
     624,  1488,   625,  1489,  1490,   626,   627,   628,   629,   630,
     631,   632,     0,  1491,   633,   634,   635,   636,   637,  1492,
       0,   638,   639,   640,   641,   642,   692,  1493,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,  1501,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,  1502,  1503,     0,     0,     0,     0,     0,
       0,     0,  1505,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,  1441,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,  1442,   137,
    1443,  1444,     0,   431,   432,   433,   434,   435,  1445,  1446,
     436,   437,  1447,  1448,   438,     0,   439,   440,   441,   442,
    1449,     0,  1450,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,
     456,   457,   458,   686,   459,  1458,  1459,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,  1461,
     484,   485,   486,  1462,  1463,   487,     0,   488,  1464,   489,
       0,   490,     0,   491,   169,  2831,   170,   492,   493,   494,
       0,   495,  1465,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
    1466,  1467,     0,  1468,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,  1469,
     182,   524,   183,     0,   525,   526,   527,  1470,  1471,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1472,   189,  1473,   538,   539,   191,  1474,   540,   541,
     193,   542,  1475,  1476,   543,  1477,   544,   545,   546,     0,
     547,     0,     0,  1478,   549,   550,     0,     0,   196,   197,
     198,   199,  1479,   551,   552,   553,   554,   555,   556,   557,
       0,   558,  1480,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1481,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,  1482,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,  1483,   600,   217,   601,   602,   219,   603,
    1484,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,  1485,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1486,  1487,     0,     0,   624,
    1488,   625,  1489,  1490,   626,   627,   628,   629,   630,   631,
     632,     0,  1491,   633,   634,   635,   636,   637,  1492,     0,
     638,   639,   640,   641,   642,   692,  1493,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,  1501,   693,   653,   654,     0,     0,     0,     0,     0,
       0,     0,  1502,  1503,     0,     0,     0,     0,     0,     0,
       0,  1505,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,   412,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,  1441,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,  1442,   137,  1443,
    1444,     0,   431,   432,   433,   434,   435,  1445,  1446,   436,
     437,  1447,  1448,   438,     0,   439,   440,   441,   442,  1449,
       0,  1450,     0,   443,   444,   445,   446,   148,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,
     457,   458,   686,   459,  1458,  1459,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,  1460,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,  1461,   484,
     485,   486,  1462,  1463,   487,     0,   488,  1464,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,  1465,     0,   496,     0,   497,   498,   688,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,  1466,
    1467,     0,  1468,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,  1469,   182,
     524,   183,     0,   525,   526,   527,  1470,  1471,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
    1472,   189,  1473,   538,   539,   191,  1474,   540,   541,   193,
     542,  1475,  1476,   543,  1477,   544,   545,   546,     0,   547,
       0,     0,  1478,   549,   550,     0,     0,   196,   197,   198,
     199,  1479,   551,   552,   553,   554,   555,   556,   557,     0,
     558,  1480,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,  1481,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,  1482,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,  1483,   600,   217,   601,   602,   219,   603,  1484,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,  1485,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,  1486,  1487,     0,     0,   624,  1488,
     625,  1489,  1490,   626,   627,   628,   629,   630,   631,   632,
       0,  1491,   633,   634,   635,   636,   637,  1492,     0,   638,
     639,   640,   641,   642,   692,  1493,  4052,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,
    1501,   693,   653,   654,     0,     0,     0,     0,     0,     0,
       0,  1502,  1503,     0,     0,     0,     0,     0,     0,     0,
    1505,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1437,
    1438,  1439,    45,  1440,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,  1441,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,  1442,   137,  1443,  1444,
       0,   431,   432,   433,   434,   435,  1445,  1446,   436,   437,
    1447,  1448,   438,     0,   439,   440,   441,   442,  1449,     0,
    1450,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,  4065,
    1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,
     458,   686,   459,  1458,  1459,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,  1460,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,  1461,   484,   485,
     486,  1462,  1463,   487,     0,   488,  1464,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
    1465,     0,   496,     0,   497,   498,   688,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,  1466,  1467,
       0,  1468,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,  1469,   182,   524,
     183,     0,   525,   526,   527,  1470,  1471,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,  1472,
     189,  1473,   538,   539,   191,  1474,   540,   541,   193,   542,
    1475,  1476,   543,  1477,   544,   545,   546,     0,   547,     0,
       0,  1478,   549,   550,     0,     0,   196,   197,   198,   199,
    1479,   551,   552,   553,   554,   555,   556,   557,     0,   558,
    1480,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,  1481,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,  1482,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,  1483,   600,   217,   601,   602,   219,   603,  1484,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,  1485,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,  1486,  1487,     0,     0,   624,  1488,   625,
    1489,  1490,   626,   627,   628,   629,   630,   631,   632,     0,
    1491,   633,   634,   635,   636,   637,  1492,     0,   638,   639,
     640,   641,   642,   692,  1493,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,
     693,   653,   654,     0,     0,     0,     0,     0,     0,     0,
    1502,  1503,     0,     0,     0,     0,     0,     0,     0,  1505,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1437,  1438,
    1439,    45,  1440,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,  1441,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,  4871,  1442,   137,  1443,  1444,     0,
     431,   432,   433,   434,   435,  1445,  1446,   436,   437,  1447,
    1448,   438,     0,   439,   440,   441,   442,  1449,     0,  1450,
       0,   443,   444,   445,   446,   148,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,  4872,  1451,
    1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,
     686,   459,  1458,  1459,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,  1460,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,  1461,   484,   485,   486,
    1462,  1463,   487,     0,   488,  1464,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,  1465,
       0,   496,     0,   497,   498,   688,   499,   500,   173,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,  1466,  1467,     0,
    1468,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,  1469,   182,   524,   183,
       0,   525,   526,   527,  1470,  1471,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,  1472,   189,
    1473,   538,   539,   191,  1474,   540,   541,   193,   542,  1475,
    1476,   543,  1477,   544,   545,   546,     0,   547,     0,     0,
    1478,   549,   550,     0,     0,   196,   197,   198,   199,  1479,
     551,   552,   553,   554,   555,   556,   557,     0,   558,  1480,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,  1481,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,  1482,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
    1483,   600,   217,   601,   602,   219,   603,  1484,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
    1485,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,
    1490,   626,   627,   628,   629,  4873,   631,   632,     0,  1491,
     633,   634,   635,   636,   637,  1492,     0,   638,   639,   640,
     641,   642,   692,  1493,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,
     653,   654,     0,     0,     0,     0,     0,     0,     0,  1502,
    1503,     0,     0,     0,     0,     0,     0,     0,  1505,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1437,  1438,  1439,
      45,  1440,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,  1441,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,  1442,   137,  1443,  1444,     0,   431,
     432,   433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,
     438,     0,   439,   440,   441,   442,  1449,     0,  1450,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,  4872,  1451,  1452,
    1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,
     459,  1458,  1459,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,  1461,   484,   485,   486,  1462,
    1463,   487,     0,   488,  1464,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,  1465,     0,
     496,     0,   497,   498,   688,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,  1466,  1467,     0,  1468,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,  1469,   182,   524,   183,     0,
     525,   526,   527,  1470,  1471,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1472,   189,  1473,
     538,   539,   191,  1474,   540,   541,   193,   542,  1475,  1476,
     543,  1477,   544,   545,   546,     0,   547,     0,     0,  1478,
     549,   550,     0,     0,   196,   197,   198,   199,  1479,   551,
     552,   553,   554,   555,   556,   557,     0,   558,  1480,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1481,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,  1482,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,  1483,
     600,   217,   601,   602,   219,   603,  1484,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,  1485,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,
     626,   627,   628,   629,  4873,   631,   632,     0,  1491,   633,
     634,   635,   636,   637,  1492,     0,   638,   639,   640,   641,
     642,   692,  1493,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
    1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,
     654,     0,     0,     0,     0,     0,     0,     0,  1502,  1503,
       0,     0,     0,     0,     0,     0,     0,  1505,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,   412,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1437,  1438,  1439,    45,
    1440,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
    1441,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,  1442,   137,  1443,  1444,     0,   431,   432,
     433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,
       0,   439,   440,   441,   442,  1449,     0,  1450,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,  1451,  1452,  1453,
    1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,   459,
    1458,  1459,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,  1460,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,  1461,   484,   485,   486,  1462,  1463,
     487,     0,   488,  1464,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,  1465,     0,   496,
       0,   497,   498,   688,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,  1466,  1467,     0,  1468,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,  1469,   182,   524,   183,     0,   525,
     526,   527,  1470,  1471,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,  1472,   189,  1473,   538,
     539,   191,  1474,   540,   541,   193,   542,  1475,  1476,   543,
    1477,   544,   545,   546,     0,   547,     0,     0,  1478,   549,
     550,     0,     0,   196,   197,   198,   199,  1479,   551,   552,
     553,   554,   555,   556,   557,     0,   558,  1480,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,  1481,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,  1482,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,  1483,   600,
     217,   601,   602,   219,   603,  1484,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,  1485,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
    1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,
     627,   628,   629,   630,   631,   632,     0,  1491,   633,   634,
     635,   636,   637,  1492,     0,   638,   639,   640,   641,   642,
     692,  1493,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,
       0,     0,     0,     0,     0,     0,     0,  1502,  1503,     0,
       0,     0,     0,     0,     0,     0,  1505,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,   412,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,  1441,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,  1442,   137,  1443,  1444,     0,   431,   432,   433,
     434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,
     439,   440,   441,   442,  1449,     0,  1450,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,  1451,  1452,  1453,  1454,
    1455,  1456,  1457,   455,   456,   457,   458,   686,   459,  1458,
    1459,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,  1460,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,  1461,   484,   485,   486,  1462,  1463,   487,
       0,   488,  1464,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,  1465,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,  1466,  1467,     0,  1468,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,  1469,   182,   524,   183,     0,   525,   526,
     527,  1470,  1471,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,  1472,   189,  1473,   538,   539,
     191,  1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,
     544,   545,   546,     0,   547,     0,     0,  1478,   549,   550,
       0,     0,   196,   197,   198,   199,  1479,   551,   552,   553,
     554,   555,   556,   557,     0,   558,  1480,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
    1481,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,  1482,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,  1483,   600,   217,
     601,   602,   219,   603,  1484,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,  1485,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1486,
    1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,   627,
     628,   629,   630,   631,   632,     0,  1491,   633,   634,   635,
     636,   637,  1492,     0,   638,   639,   640,   641,   642,   692,
    1493,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,  4347,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,
       0,     0,     0,     0,     0,     0,  1502,  1503,     0,     0,
       0,     0,     0,     0,     0,  1505,   717,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   718,   104,   105,   672,
     719,     0,   107,   108,   109,   110,   720,   721,   112,   113,
     114,   115,     0,   116,   722,   723,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,   412,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,  1441,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,  1442,   137,  1443,  1444,     0,   431,   432,   433,   434,
     435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,
     440,   441,   442,  1449,     0,  1450,     0,   443,   444,   445,
     446,   148,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,  1451,  1452,  1453,  1454,  1455,
    1456,  1457,   455,   456,   457,   458,   686,   459,  1458,  1459,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,  1460,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,  1461,   484,   485,   486,  1462,  1463,   487,     0,
     488,  1464,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,  1465,     0,   496,     0,   497,
     498,   688,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,  1466,  1467,     0,  1468,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,  1469,   182,   524,   183,     0,   525,   526,   527,
    1470,  1471,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,  1472,   189,  1473,   538,  4356,   191,
    1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,   544,
     545,   546,     0,   547,     0,     0,  1478,   549,   550,     0,
       0,   196,   197,   198,   199,  1479,   551,   552,   553,   554,
     555,   556,   557,     0,   558,  1480,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,  1481,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,  1482,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,  1483,   600,   217,   601,
     602,   219,   603,  1484,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,  1485,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,  1486,  1487,
       0,     0,   624,  1488,   625,  1489,  1490,   626,   627,   628,
     629,   630,   631,   632,     0,  1491,   633,   634,   635,   636,
     637,  1492,     0,   638,   639,   640,   641,   642,   692,  1493,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,  1494,  1495,  1496,
    1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,
       0,     0,     0,     0,     0,  1502,  1503,     0,     0,     0,
       0,     0,     0,     0,  1505,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,   412,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,  1441,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
    1442,   137,  1443,  1444,     0,   431,   432,   433,   434,   435,
    1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,   440,
     441,   442,  1449,     0,  1450,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,
    1457,   455,   456,   457,   458,   686,   459,  1458,  1459,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,  1461,   484,   485,   486,  1462,  1463,   487,     0,   488,
    1464,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,  1465,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,  1466,  1467,     0,  1468,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,  1469,   182,   524,   183,     0,   525,   526,   527,  1470,
    1471,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1472,   189,  1473,   538,   539,   191,     0,
     540,   541,   193,   542,  1475,  1476,   543,  1477,   544,   545,
     546,     0,   547,     0,     0,  1478,   549,   550,     0,     0,
     196,   197,   198,   199,  1479,   551,   552,   553,   554,   555,
     556,   557,     0,   558,  1480,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1481,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
    1482,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,  1483,   600,   217,   601,   602,
     219,   603,  1484,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,  1485,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1486,  1487,     0,
       0,   624,  1488,   625,  1489,  1490,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
    1492,     0,   638,   639,   640,   641,   642,   692,  1493,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,
    1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,     0,
       0,     0,     0,     0,  2813,  2814,     0,     0,     0,     0,
       0,     0,     0,  1505,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,  1441,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430, -2578,  1442,
     137,  1443,  1444,     0,   431,   432,   433,   434,   435,  1445,
    1446,   436,   437,  1447,  1448,   438,     0,   439,   440,   441,
     442,  1449,     0,  1450,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,  4872,  1451,  1452,  1453,  1454,  1455,  1456,  1457,
     455,   456,   457,   458,   686,   459,  1458,  1459,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
    1461,   484,   485,   486,  1462,  1463,   487,     0,   488,  1464,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,  1465,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,  1466,  1467,     0,  1468,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
    1469,   182,   524,     0,     0,   525,   526,   527,  1470,  1471,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1472,   189,  1473,   538,   539,   191,     0,   540,
     541,   193,   542,  1475,  1476,   543,  1477,   544,   545,   546,
       0,   547,     0,     0,  1478,   549,   550,     0,     0,   196,
     197,   198,   199,  1479,   551,   552,   553,   554,   555,   556,
     557,     0,   558,  1480,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1481,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,  1482,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,  1483,   600,   217,   601,   602,     0,
     603,  1484,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,  1485,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1486,  1487,     0,     0,
     624,  1488,   625,  1489,  1490,   626,   627,   628,   629,  4873,
     631,   632,     0,  1491,   633,   634,   635,   636,   637,  1492,
       0,   638,   639,   640,   641,   642,   692,  1493,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,  1501,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,  1502,  1503,     0,     0,     0,     0,     0,
       0,     0,  1505,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1437,  1438,     0,    45,  1440,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,  1441,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,  1442,   137,
    1443,  1444,     0,   431,   432,   433,   434,   435,  1445,  1446,
     436,   437,  1447,  1448,   438,     0,   439,   440,   441,   442,
    1449,     0,  1450,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,
     456,   457,   458,   686,   459,  1458,  1459,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,  1461,
     484,   485,   486,  1462,  1463,   487,     0,   488,  1464,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,  1465,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
    1466,  1467,     0,  1468,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,  1469,
     182,   524,   183,     0,   525,   526,   527,  1470,  1471,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1472,   189,  1473,   538,   539,   191,     0,   540,   541,
     193,   542,  1475,  1476,   543,  1477,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,   197,
     198,   199,  1479,   551,   552,   553,   554,   555,   556,   557,
       0,   558,  1480,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1481,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,  1482,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,  1483,   600,   217,   601,   602,   219,   603,
    1484,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,  1485,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1486,  1487,     0,     0,   624,
    1488,   625,  1489,  1490,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,  1492,     0,
     638,   639,   640,   641,   642,   692,  1493,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,  1501,   693,   653,   654,     0,     0,     0,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,  1505,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,   412,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1437,  1438,     0,    45,
    1440,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
    1441,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,  1442,   137,  1443,  1444,     0,  3975,   432,
     433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,
       0,   439,   440,   441,   442,  1449,     0,  1450,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,  1451,  1452,  1453,
    1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,   459,
    1458,  1459,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,  1460,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,  1461,   484,   485,   486,  1462,  1463,
     487,     0,   488,  1464,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,  1465,     0,   496,
       0,   497,   498,   688,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,  1466,  1467,     0,  1468,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,  1469,   182,   524,   183,     0,   525,
     526,   527,  1470,  1471,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,  1472,   189,  1473,   538,
     539,   191,     0,   540,   541,   193,   542,  1475,  1476,   543,
    1477,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,   197,   198,   199,  1479,   551,   552,
     553,   554,   555,   556,   557,     0,   558,  1480,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,  1481,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,  1482,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,  1483,   600,
     217,   601,   602,   219,   603,  1484,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,  1485,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
    1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,  1492,     0,   638,   639,   640,   641,   642,
     692,  1493,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,
       0,     0,     0,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,  1505,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,  1441,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,     0,  1442,   137,
    1443,  1444,     0,   431,   432,   433,   434,   435,  1445,  1446,
     436,   437,  1447,  1448,   438,     0,   439,   440,   441,   442,
    1449,     0,  1450,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,
     456,   457,   458,   686,   459,  1458,  1459,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,     0,     0,   480,   481,   482,   483,  1461,
     484,   485,   486,  1462,  1463,   487,     0,   488,  1464,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,  1465,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
    1466,  1467,     0,  1468,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,  1469,
     182,   524,     0,     0,   525,   526,   527,  1470,  1471,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1472,   189,  1473,   538,   539,   191,     0,   540,   541,
     193,   542,  1475,  1476,   543,  1477,   544,   545,   546,     0,
     547,     0,     0,  1478,   549,   550,     0,     0,   196,   197,
     198,   199,  1479,   551,   552,   553,   554,   555,   556,   557,
       0,   558,  1480,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1481,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,  1482,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,  1483,   600,   217,   601,   602,     0,   603,
    1484,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,  1485,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1486,  1487,     0,     0,   624,
    1488,   625,  1489,  1490,   626,   627,   628,   629,   630,   631,
     632,     0,  1491,   633,   634,   635,   636,   637,  1492,     0,
     638,   639,   640,   641,   642,   692,  1493,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,  1501,   693,   653,   654,     0,     0,     0,     0,     0,
       0,     0,  1502,  1503,     0,     0,     0,     0,     0,     0,
       0,  1505,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,   412,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,  1441,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,     0,  1442,   137,  1443,
    1444,     0,   431,   432,   433,   434,   435,  1445,  1446,   436,
     437,  1447,  1448,   438,     0,   439,   440,   441,   442,  1449,
       0,  1450,     0,   443,   444,   445,   446,   148,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,
     457,   458,   686,   459,  1458,  1459,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,  1460,   473,   474,     0,   475,   476,   477,
       0,   478,     0,     0,   480,   481,   482,   483,  1461,   484,
     485,   486,  1462,  1463,   487,     0,   488,  1464,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,  1465,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,  1466,
    1467,     0,  1468,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,  1469,   182,
     524,     0,     0,   525,   526,   527,  1470,  1471,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
    1472,   189,  1473,   538,   539,   191,     0,   540,   541,   193,
     542,  1475,  1476,   543,  1477,   544,   545,   546,     0,   547,
       0,     0,  1478,   549,   550,     0,     0,   196,   197,   198,
     199,  1479,   551,   552,   553,   554,   555,   556,   557,     0,
     558,  1480,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,  1481,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,  1482,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,  1483,   600,   217,   601,   602,     0,   603,  1484,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,  1485,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,  1486,  1487,     0,     0,   624,  1488,
     625,  1489,  1490,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,  1492,     0,   638,
     639,   640,   641,   642,   692,  1493,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,
    1501,   693,   653,   654,     0,     0,     0,     0,     0,     0,
       0,  2813,  2814,     0,     0,     0,     0,     0,     0,     0,
    1505,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,  1446,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,  1449,     0,
    1450,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
    1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,  1462,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
    1465,     0,   496,     0,   497,   498,   688,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,  1469,   182,   524,
     183,     0,   525,   526,   527,  1470,  1471,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
     189,   190,   538,   539,   191,     0,   540,   541,   193,   542,
       0,  1476,   543,   195,   544,   545,   546,     0,   547,     0,
    1063,   548,   549,   550,     0,     0,   196,   197,   198,   199,
    1479,   551,   552,   553,   554,   555,   556,   557,     0,   558,
    1480,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,   215,   595,   596,   597,   598,
     599,  1483,   600,   217,   601,   602,   219,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,  1485,     0,   615,   616,   223,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,  1488,   625,
    1489,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,  1492,     0,   638,   639,
     640,   641,   642,  2143,   234,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,   236,   648,   649,   650,   651,
     652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,
     693,   653,   654,     0,     0,     0,   717,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,  3521,
      98,    99,   100,   101,   102,   103,   718,   104,   105,   672,
     719,     0,   107,   108,   109,   110,   720,   721,   112,   113,
     114,   115,     0,   116,   722,   723,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,   433,   434,
     435,     0,  1446,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,  1449,     0,  1450,     0,   443,   444,   445,
     446,   148,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,  1451,  1452,  1453,  1454,  1455,
    1456,  1457,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,  1462,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,  1465,     0,   496,     0,   497,
     498,   688,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,  1469,   182,   524,   183,     0,   525,   526,   527,
    1470,  1471,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,   189,   190,   538,   539,   191,
       0,   540,   541,   193,   542,     0,  1476,   543,   195,   544,
     545,   546,     0,   547,     0,  1063,   548,   549,   550,     0,
       0,   196,   197,   198,   199,  1479,   551,   552,   553,   554,
     555,   556,   557,     0,   558,  1480,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,  1483,   600,   217,   601,
     602,   219,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,  1485,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,  1488,   625,  1489,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,  1492,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,  1494,  1495,  1496,
    1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,
       0,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,  3521,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,  1446,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,  1449,     0,
    1450,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
    1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,  1462,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
    1465,     0,   496,     0,   497,   498,   688,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,  1469,   182,   524,
     183,     0,   525,   526,   527,  1470,  1471,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
     189,   190,   538,   539,   191,     0,   540,   541,   193,   542,
       0,  1476,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,   197,   198,   199,
    1479,   551,   552,   553,   554,   555,   556,   557,     0,   558,
    1480,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,  1483,   600,   217,   601,   602,   219,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,  1485,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,  1488,   625,
    1489,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,  1492,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,
     693,   653,   654,     0,     0,     0,   717,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,  4091,
      98,    99,   100,   101,   102,   103,   718,   104,   105,   672,
     719,     0,   107,   108,   109,   110,   720,   721,   112,   113,
     114,   115,     0,   116,   722,   723,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,   145,     0,   443,   444,   445,
     446,   148,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,     0,     0,     0,   152,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,   182,   524,   183,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,   189,   190,   538,   539,   191,
       0,   540,   541,   193,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,   197,   198,   199,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,   219,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,     0,     0,
       0,     0,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,  4643,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,  4019,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0, -1428,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0, -1428,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510, -1428,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515, -1428,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181, -1428,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
   -1428,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585, -1428,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,     0,     0,     0,     0,     0,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
    1596,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,     0,
       0,     0,     0,     0,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,  3282,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,     0,     0,     0,     0,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
    3797,  3798,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,    37,    38,
      39,    40,    41,    42,     0,    44,     0,     0,     0,    45,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
       0,     0,     0,     0,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,  3798,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,   215,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,   223,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,  2143,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,   236,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,     0,     0,     0,     0,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,   246,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,   215,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,   223,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
    2143,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,   236,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
       0,     0,     0,     0,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,   246,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,     0,     0,     0,     0,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,  1571,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
       0,     0,     0,     0,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,  2972,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,     0,     0,     0,     0,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,  4046,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
       0,     0,     0,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,  4391,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,  1185,    45,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   724,   421,   422,
     423,   725,   726,   727,   728,   729,   730,   731,   424,   425,
     732,   426,   427,   133,   428,   429,   430,     0,  1859,   137,
    1860,  1861,   733,   431,   432,   433,   434,   435,   734,   735,
     436,   437,  1862,  1863,   438,   737,   439,   440,   441,   442,
       0,   738,   145,   739,   443,   444,   445,   446,   148,   447,
     684,   741,   448,   449,   450,   451,   452,   453,   742,   151,
     454,     0,   744,   745,   746,   152,   747,   748,   749,   455,
     456,   457,   458,   686,   459,  1864,  1865,   460,   750,   461,
     751,   462,   463,   464,   465,   466,   752,   467,   468,   469,
     753,   754,   470,   471,  1460,   473,   474,   755,   475,   476,
     477,   756,   478,   479,   757,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   758,   487,   759,   488,  1866,   489,
     760,   490,   761,   491,   169,   762,   170,   492,   493,   494,
     763,   495,     0,   764,   496,   765,   497,   498,   688,   499,
     500,   173,   501,   502,   503,   766,   504,   505,   506,   507,
     508,   509,   767,   510,   174,     0,     0,   511,   512,   513,
    1466,  1867,   770,  1868,   771,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,   772,   523,     0,
     182,   524,   183,   773,   525,   526,   527,   774,   775,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1869,   189,  1870,   538,   539,     0,   776,   540,   541,
     193,   542,   777,     0,   543,  1871,   544,   545,   546,   778,
     547,   779,   780,  3784,   549,   550,   781,   782,     0,   197,
     198,   199,     0,   551,   552,   553,   554,   555,   556,   557,
     783,   558,     0,   559,     0,   560,   561,   562,   784,   563,
     564,   565,   566,   567,   568,   569,  1872,   570,   571,   572,
     573,   785,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,   786,   584,   585,   210,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   691,   594,   787,   595,   596,
     597,   598,   599,   788,   600,  2427,   601,   602,   219,   603,
    1874,   604,   789,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,     0,   790,   615,   616,   791,   617,   618,
     619,   620,   621,   622,   792,  1875,  1876,     0,   794,   624,
       0,   625,     0,   795,   626,   627,   628,   629,   630,   631,
     632,     0,   797,   633,   634,   635,   636,   637,   798,   799,
     638,   639,   640,   641,   642,     0,  1877,   801,   643,   235,
     644,   645,   646,   802,   803,   647,   804,   805,   648,   649,
     650,   651,   652,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   693,   653,   654,     0,     0,     0,  1188,  1189,
    1190,     0,  3785,  3786,  1193,  1194,  1195,  1196,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,  1186,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,  1187,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,     0,
       0,     0,  1188,  1189,  1190,     0,  1191,  1192,  1193,  1194,
    1195,  1196,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,  1274,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,  1275,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,     0,     0,     0,  1188,  1189,  1190,     0,
    1191,  1192,  1193,  1194,  1195,  1196,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,  1326,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,  1327,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,  1328,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,     0,     0,     0,
    1188,  1189,  1190,     0,  1191,  1192,  1193,  1194,  1195,  1196,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,  1842,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,  1843,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,     0,     0,     0,  1188,  1189,  1190,     0,  1191,  1192,
    1193,  1194,  1195,  1196,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,     0,     0,     0,  1188,  1189,
    1190,     0,  1191,  1192,  1193,  1194,  1195,  1196,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,  3055,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,  3056,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,     0,
       0,     0,  1188,  1189,  1190,     0,  1191,  1192,  1193,  1194,
    1195,  1196,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,  4627,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,     0,     0,     0,  1188,  1189,  1190,     0,
    1191,  1192,  1193,  1194,  1195,  1196,   717,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   718,   104,   105,   672,
     719,     0,   107,   108,   109,   110,   720,   721,   112,   113,
     114,   115,     0,   116,   722,   723,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
     724,   421,   422,   423,   725,   726,   727,   728,   729,   730,
     731,   424,   425,   732,   426,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,   733,   431,   432,   433,   434,
     435,   734,   735,   436,   437,   736,   140,   438,   737,   439,
     440,   441,   442,   144,   738,   145,   739,   443,   444,   445,
     446,   148,   447,   740,   741,   448,   449,   450,   451,   452,
     453,   742,   151,   454,   743,   744,   745,   746,   152,   747,
     748,   749,   455,   456,   457,   458,   686,   459,   155,   156,
     460,   750,   461,   751,   462,   463,   464,   465,   466,   752,
     467,   468,   469,   753,   754,   470,   471,   472,   473,   474,
     755,   475,   476,   477,   756,   478,   479,   757,   480,   481,
     482,   483,   164,   484,   485,   486,   166,   758,   487,   759,
     488,   168,   489,   760,   490,   761,   491,   169,   762,   170,
     492,   493,   494,   763,   495,   172,   764,   496,   765,   497,
     498,   688,   499,   500,   173,   501,   502,   503,   766,   504,
     505,   506,   507,   508,   509,   767,   510,   174,   175,   768,
     511,   512,   513,   769,   176,   770,   177,   771,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
     772,   523,   181,   182,   524,   183,   773,   525,   526,   527,
     774,   775,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,   189,   190,   538,   539,   191,
     776,   540,   541,   193,   542,   777,   194,   543,   195,   544,
     545,   546,   778,   547,   779,   780,   548,   549,   550,   781,
     782,   196,   197,   198,   199,   200,   551,   552,   553,   554,
     555,   556,   557,   783,   558,   201,   559,   202,   560,   561,
     562,   784,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,   785,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,   786,   584,   585,   210,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
     787,   595,   596,   597,   598,   599,   788,   600,   217,   601,
     602,   219,   603,   220,   604,   789,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,   790,   615,   616,
     791,   617,   618,   619,   620,   621,   622,   792,   224,   225,
     793,   794,   624,   226,   625,   227,   795,   626,   627,   628,
     629,   630,   631,   632,   796,   797,   633,   634,   635,   636,
     637,   798,   799,   638,   639,   640,   641,   642,   800,   234,
     801,   643,   235,   644,   645,   646,   802,   803,   647,   804,
     805,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,   717,    86,
      87,    88,   669,    90,    91,    92,   670,  2240,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,     0,  1859,   137,  1860,  1861,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,  1862,  1863,   438,
       0,   439,   440,   441,   442,     0,     0,   145,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,     0,     0,     0,
     152,     0,     0,     0,   455,   456,   457,   458,   686,   459,
    1864,  1865,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,  1460,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,     0,   484,   485,   486,     0,     0,
     487,     0,   488,  1866,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,     0,     0,   496,
       0,   497,   498,   688,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
       0,     0,   511,   512,   513,  1466,  1867,     0,  1868,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,     0,   182,   524,   183,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,  1869,   189,  1870,   538,
     539,     0,     0,   540,   541,   193,   542,     0,     0,   543,
    1871,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,     0,   197,   198,   199,     0,   551,   552,
     553,   554,   555,   556,   557,     0,   558,     0,   559,     0,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,  1872,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,     0,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
    1873,   601,   602,   219,   603,  1874,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,     0,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
    1875,  1876,     0,     0,   624,     0,   625,     0,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
       0,  1877,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   693,   653,   654,
       0,    86,    87,    88,   669,    90,    91,    92,   670,  2341,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,    86,    87,    88,   669,    90,    91,    92,
     670,  1070,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,     0,    86,    87,    88,   669,    90,
      91,    92,   670,  4495,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
     413,   969,   415,   416,   417,   418,   419,   420,   970,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   971,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   972,   168,
     489,     0,   490,     0,   973,     0,   974,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,   975,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   976,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   977,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     978,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   979,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,   980,   981,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
     413,   969,   415,   416,   417,   418,   419,   420,   970,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,  1002,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   972,   168,
     489,     0,   490,     0,  1003,     0,   974,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,   975,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   976,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   977,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     978,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   979,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,   980,   981,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,  1374,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,   974,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,   975,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,   980,   981,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,  1379,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,   974,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,   975,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,   980,   981,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,   687,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,  1542,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,  1041,  1543,
      86,    87,    88,   669,    90,    91,    92,   670,  1042,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,  1043,   437,  1017,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,  1044,     0,  1045,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,  1046,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,  1047,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,  1048,   587,   212,   588,   589,   590,  1049,   592,
     593,   691,   594,     0,   595,   596,   597,   598,  1050,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1051,   225,     0,     0,  1052,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,  1021,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,  1053,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   724,   421,   422,   423,   725,
     726,   727,   728,   729,   730,   731,   424,   425,   732,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
     733,   431,   432,   433,   434,   435,   734,   735,   436,   437,
     736,   140,   438,   737,   439,   440,   441,   442,   144,   738,
     145,   739,   443,   444,   445,   446,   148,   447,   740,   741,
     448,   449,   450,   451,   452,   453,   742,   151,   454,   743,
     744,   745,   746,   152,   747,   748,   749,   455,   456,   457,
     458,   686,   459,   155,   156,   460,   750,   461,   751,   462,
     463,   464,   465,   466,   752,   467,   468,   469,   753,   754,
     470,   471,   472,   473,   474,   755,   475,   476,   477,   756,
     478,   479,   757,   480,   481,   482,   483,   164,   484,   485,
     486,   166,   758,   487,   759,   488,   168,   489,   760,   490,
     761,   491,   169,   762,   170,   492,   493,   494,   763,   495,
     172,   764,   496,   765,   497,   498,   688,   499,   500,   173,
     501,   502,   503,   766,   504,   505,   506,   507,   508,   509,
     767,   510,   174,   175,   768,   511,   512,   513,   769,   176,
     770,   177,   771,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,   772,   523,   181,   182,   524,
     183,   773,   525,   526,   527,   774,   775,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
     189,   190,   538,   539,   191,   776,   540,   541,   193,   542,
     777,   194,   543,   195,   544,   545,   546,   778,   547,   779,
     780,   548,   549,   550,   781,   782,   196,   197,   198,   199,
     200,   551,   552,   553,   554,   555,   556,   557,   783,   558,
     201,   559,   202,   560,   561,   562,   784,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,   785,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
     786,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,   787,   595,   596,   597,   598,
     599,   788,   600,   217,   601,   602,   219,   603,   220,   604,
     789,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,   790,   615,   616,   791,   617,   618,   619,   620,
     621,   622,   792,   224,   225,   793,   794,   624,   226,   625,
     227,   795,   626,   627,   628,   629,   630,   631,   632,   796,
     797,   633,   634,   635,   636,   637,   798,   799,   638,   639,
     640,   641,   642,   800,   234,   801,   643,   235,   644,   645,
     646,   802,   803,   647,   804,   805,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   724,   421,   422,
     423,   725,   726,   727,   728,   729,   730,   731,   424,   425,
     732,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,   733,   431,   432,   433,   434,   435,   734,   735,
     436,   437,   736,   140,   438,   737,   439,   440,   441,   442,
     144,   738,   145,   739,   443,   444,   445,   446,   148,   447,
     740,   741,   448,   449,   450,   451,   452,   453,   742,   151,
     454,   743,   744,   745,   746,   152,   747,   748,   749,   455,
     456,   457,   458,   686,   459,   155,   156,   460,   750,   461,
     751,   462,   463,   464,   465,   466,   752,   467,   468,   469,
     753,   754,   470,   471,   472,   473,   474,   755,   475,   476,
     477,   756,   478,   479,   757,   480,   481,   482,   483,   164,
     484,   485,   486,   166,   758,   487,   759,   488,   168,   489,
     760,   490,   761,   491,   169,   762,   170,   492,   493,   494,
     763,   495,   172,   764,   496,   765,   497,   498,   688,   499,
     500,   173,   501,   502,   503,   766,   504,   505,   506,   507,
     508,   509,   767,   510,   174,   175,   768,   511,   512,   513,
     769,   176,   770,   177,   771,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,   772,   523,   181,
     182,   524,   183,   773,   525,   526,   527,   774,   775,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,   189,   190,   538,   539,   191,   776,   540,   541,
     193,   542,   777,   194,   543,   195,   544,   545,   546,   778,
     547,   779,   780,   548,   549,   550,   781,   782,   196,   197,
     198,   199,   200,   551,   552,   553,   554,   555,   556,   557,
     783,   558,   201,   559,   202,   560,   561,   562,   784,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,   785,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,   786,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,   787,   595,   596,
     597,   598,   599,   788,   600,   217,   601,   602,   219,   603,
     220,   604,   789,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,   790,   615,   616,   791,   617,   618,
     619,   620,   621,   622,   792,   224,   225,   793,   794,   624,
     226,   625,   227,   795,   626,   627,   628,   629,   630,   631,
     632,   796,   797,   633,   634,   635,   636,   637,   798,   799,
     638,   639,   640,   641,   642,   800,   234,   801,   643,   235,
     644,   645,   646,   802,   803,   647,   804,   805,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,  3120,   418,   419,   420,   724,
     421,   422,   423,   725,   726,   727,   728,   729,   730,   731,
     424,   425,   732,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,   733,   431,   432,   433,   434,   435,
     734,   735,   436,   437,   736,   140,   438,   737,   439,   440,
     441,   442,   144,   738,   145,   739,   443,   444,   445,   446,
     148,   447,   740,   741,   448,   449,   450,   451,   452,   453,
     742,   151,   454,   743,   744,   745,   746,   152,   747,   748,
     749,   455,   456,   457,   458,   686,   459,   155,   156,   460,
     750,   461,   751,   462,   463,   464,   465,   466,   752,   467,
     468,   469,   753,   754,   470,   471,   472,  3121,   474,   755,
     475,   476,   477,   756,   478,   479,   757,   480,   481,   482,
     483,   164,   484,   485,   486,   166,   758,   487,   759,   488,
     168,   489,   760,   490,   761,   491,   169,   762,   170,   492,
     493,   494,   763,   495,   172,   764,   496,   765,   497,   498,
     688,   499,   500,   173,   501,   502,   503,   766,   504,   505,
     506,   507,   508,   509,   767,   510,   174,   175,   768,   511,
     512,   513,   769,   176,   770,   177,   771,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,   772,
     523,   181,   182,   524,   183,   773,   525,   526,   527,   774,
     775,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,   189,   190,   538,   539,   191,   776,
     540,   541,   193,   542,   777,   194,   543,   195,   544,   545,
     546,   778,   547,   779,   780,   548,   549,   550,   781,   782,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,   783,   558,   201,   559,   202,   560,   561,   562,
     784,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,   785,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,   786,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,   787,
     595,   596,   597,   598,   599,   788,  3122,   217,   601,   602,
     219,   603,   220,   604,   789,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,   790,   615,   616,   791,
     617,   618,   619,   620,   621,   622,   792,   224,   225,   793,
     794,   624,   226,   625,   227,   795,   626,   627,   628,   629,
     630,   631,   632,   796,   797,   633,   634,   635,   636,   637,
     798,   799,   638,   639,   640,   641,   642,   800,   234,   801,
     643,   235,   644,   645,   646,   802,   803,   647,   804,   805,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,   145,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,     0,     0,     0,   152,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,   182,   524,   183,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,   189,   190,   538,   539,
     191,     0,   540,   541,   193,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,   197,   198,   199,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,   219,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,   145,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,  1311,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,   189,   190,
     538,   539,   191,     0,   540,   541,   193,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,   197,   198,   199,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,   219,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
     145,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,  1320,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
     189,   190,   538,   539,   191,     0,   540,   541,   193,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,   197,   198,   199,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,   219,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,     0,  1859,   137,
    1860,  1861,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,  1862,  1863,   438,     0,   439,   440,   441,   442,
       0,     0,   145,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,   686,   459,  1864,  1865,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,     0,
     484,   485,   486,     0,     0,   487,     0,   488,  1866,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,     0,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,  2424,   504,   505,   506,   507,
     508,   509,     0,   510,   174,  2425,     0,   511,   512,   513,
    1466,  1867,     0,  1868,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,     0,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1869,   189,  1870,   538,   539,     0,     0,   540,   541,
     193,   542,     0,     0,   543,  1871,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,  2426,   197,
     198,   199,     0,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,     0,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1872,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,  2427,   601,   602,   219,   603,
    1874,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,     0,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1875,  1876,     0,     0,   624,
       0,   625,     0,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,  1877,  2428,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   693,   653,   654,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,     0,
    1859,   137,  1860,  1861,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1862,  1863,   438,     0,   439,   440,
     441,   442,     0,     0,   145,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,   686,   459,  1864,  1865,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,     0,   484,   485,   486,     0,     0,   487,     0,   488,
    1866,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,     0,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,     0,     0,   511,
     512,   513,  1466,  1867,     0,  1868,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,     0,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1869,   189,  1870,   538,   539,     0,     0,
     540,   541,   193,   542,  2412,     0,   543,  1871,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
       0,   197,   198,   199,     0,   551,   552,   553,   554,   555,
     556,   557,     0,   558,     0,   559,     0,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1872,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,  2427,   601,   602,
     219,   603,  1874,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,     0,     0,   615,   616,  3882,
     617,   618,   619,   620,   621,   622,     0,  1875,  1876,     0,
       0,   624,     0,   625,     0,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,  1877,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   693,   653,   654,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,     0,  1859,   137,  1860,  1861,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,  1862,  1863,   438,     0,
     439,   440,   441,   442,     0,     0,   145,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,     0,     0,     0,   152,
       0,     0,     0,   455,   456,   457,   458,   686,   459,  1864,
    1865,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,  1460,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,     0,   484,   485,   486,     0,     0,   487,
       0,   488,  1866,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,     0,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,     0,
       0,   511,   512,   513,  1466,  1867,     0,  1868,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,     0,   182,   524,   183,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,  1869,   189,  1870,   538,   539,
    2474,     0,   540,   541,   193,   542,     0,     0,   543,  1871,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,     0,   197,   198,   199,     0,   551,   552,   553,
     554,   555,   556,   557,     0,   558,     0,   559,     0,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
    1872,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,  1873,
     601,   602,   219,   603,  1874,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,     0,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1875,
    1876,     0,     0,   624,     0,   625,     0,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,     0,
    1877,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   693,   653,   654,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,     0,  1859,   137,  1860,  1861,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,  1862,  1863,
     438,     0,   439,   440,   441,   442,     0,     0,   145,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,   686,
     459,  1864,  1865,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,     0,   484,   485,   486,     0,
       0,   487,     0,   488,  1866,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,     0,     0,
     496,     0,   497,   498,   688,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,     0,     0,   511,   512,   513,  1466,  1867,     0,  1868,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,     0,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1869,   189,  1870,
     538,   539,  3706,     0,   540,   541,   193,   542,     0,     0,
     543,  1871,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,     0,   197,   198,   199,     0,   551,
     552,   553,   554,   555,   556,   557,     0,   558,     0,   559,
       0,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1872,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,  1873,   601,   602,   219,   603,  1874,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,     0,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1875,  1876,     0,     0,   624,     0,   625,     0,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,     0,  1877,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   693,   653,
     654,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,     0,  1859,   137,  1860,  1861,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
    1862,  1863,   438,     0,   439,   440,   441,   442,     0,     0,
     145,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,     0,   455,   456,   457,
     458,   686,   459,  1864,  1865,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,  1460,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,     0,   484,   485,
     486,     0,     0,   487,     0,   488,  1866,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
       0,     0,   496,     0,   497,   498,   688,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,     0,     0,   511,   512,   513,  1466,  1867,
       0,  1868,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,     0,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,  1869,
     189,  1870,   538,   539,     0,     0,   540,   541,   193,   542,
       0,     0,   543,  1871,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,     0,   197,   198,   199,
       0,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,     0,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,  1872,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,  1873,   601,   602,   219,   603,  1874,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,     0,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,  1875,  1876,     0,     0,   624,     0,   625,
       0,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,     0,  1877,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     693,   653,   654,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,     0,  1859,   137,
    1860,  1861,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,  1862,  1863,   438,     0,   439,   440,   441,   442,
       0,     0,   145,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,   686,   459,  1864,  1865,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,     0,
     484,   485,   486,     0,     0,   487,     0,   488,  1866,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,     0,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,     0,     0,   511,   512,   513,
    1466,  1867,     0,  1868,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,     0,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1869,   189,  1870,   538,   539,     0,     0,   540,   541,
     193,   542,     0,     0,   543,  1871,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,     0,   197,
     198,   199,     0,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,     0,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1872,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,  2427,   601,   602,   219,   603,
    1874,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,     0,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1875,  1876,     0,     0,   624,
       0,   625,     0,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,  1877,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   693,   653,   654,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,     0,
    1859,   137,  1860,  1861,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1862,  1863,   438,     0,   439,   440,
     441,   442,     0,     0,   145,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,   686,   459,  1864,  1865,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,     0,   484,   485,   486,     0,     0,   487,     0,   488,
    1866,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,     0,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,     0,     0,   511,
     512,   513,  1466,  1867,     0,  1868,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,     0,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1869,   189,  1870,   538,   539,     0,     0,
     540,   541,   193,   542,     0,     0,   543,  1871,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
       0,   197,   198,   199,     0,   551,   552,   553,   554,   555,
     556,   557,     0,   558,     0,   559,     0,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1872,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,     0,   601,   602,
     219,   603,  1874,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,     0,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1875,  1876,     0,
       0,   624,     0,   625,     0,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,  1877,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   693,   653,   654,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,     0,     0,   137,     0,     0,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,     0,     0,   438,     0,
     439,   440,   441,   442,     0,     0,   145,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,     0,     0,     0,   152,
       0,     0,     0,   455,   456,   457,   458,   686,   459,     0,
       0,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,     0,   484,   485,   486,     0,     0,   487,
       0,   488,     0,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,     0,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,     0,
       0,   511,   512,   513,     0,     0,     0,     0,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,     0,   182,   524,   183,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,     0,   189,     0,   538,   539,
       0,     0,   540,   541,   193,   542,     0,     0,   543,     0,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,     0,   197,   198,   199,     0,   551,   552,   553,
     554,   555,   556,   557,     0,   558,     0,   559,     0,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
       0,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,     0,
     601,   602,   219,   603,     0,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,     0,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,     0,
       0,     0,     0,   624,     0,   625,     0,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,     0,
       0,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,   724,   421,   422,   423,   725,   726,   727,   728,
     729,   730,   731,   424,   425,   732,   426,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,   733,   431,   432,
     433,   434,   435,   734,   735,   436,   437,     0,   140,   438,
     737,   439,   440,   441,   442,   144,   738,   145,   739,   443,
     444,   445,   446,   148,   447,   740,   741,   448,   449,   450,
     451,   452,   453,   742,   151,   454,     0,   744,   745,   746,
     152,   747,   748,   749,   455,   456,   457,   458,     0,   459,
     155,   156,   460,   750,   461,   751,   462,   463,   464,   465,
     466,   752,   467,   468,   469,   753,   754,   470,   471,   472,
     473,   474,   755,   475,   476,   477,   756,   478,   479,   757,
     480,   481,   482,   483,   164,   484,   485,   486,   166,   758,
     487,   759,   488,   168,   489,   760,   490,   761,   491,   169,
     762,   170,   492,   493,   494,   763,   495,   172,   764,   496,
     765,   497,   498,     0,   499,   500,   173,   501,   502,   503,
     766,   504,   505,   506,   507,   508,   509,   767,   510,   174,
     175,     0,   511,   512,   513,     0,   176,   770,   177,   771,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,   772,   523,   181,   182,   524,   183,   773,   525,
     526,   527,   774,   775,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   537,   188,   189,   190,   538,
     539,   191,   776,   540,   541,   193,   542,   777,   194,   543,
     195,   544,   545,   546,   778,   547,   779,   780,   548,   549,
     550,   781,   782,   196,   197,   198,   199,   200,   551,   552,
     553,   554,   555,   556,   557,   783,   558,   201,   559,   202,
     560,   561,   562,   784,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,   785,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,   786,   584,   585,
     210,   586,   587,   212,   588,   589,   590,   591,   592,   593,
       0,   594,   787,   595,   596,   597,   598,   599,   788,   600,
     217,   601,   602,   219,   603,   220,   604,   789,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,   790,
     615,   616,   791,   617,   618,   619,   620,   621,   622,   792,
     224,   225,     0,   794,   624,   226,   625,   227,   795,   626,
     627,   628,   629,   630,   631,   632,     0,   797,   633,   634,
     635,   636,   637,   798,   799,   638,   639,   640,   641,   642,
       0,   234,   801,   643,   235,   644,   645,   646,   802,   803,
     647,   804,   805,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,     0,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,  1132,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
      37,    38,    39,    40,    41,    42,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,  2365,   439,   440,   441,   442,   144,     0,
       0,  2440,   443,   444,   445,   446,     0,   447,   684,  2366,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,  2441,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
    2368,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,  2369,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
    2370,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,  2365,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
    2366,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,  2441,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,  2368,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,  3318,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,  2369,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,  2370,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,  1030,   419,   420,   989,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,   990,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
    1031,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,   991,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,   992,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,   989,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,   990,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,  3023,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,   991,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,   992,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,  2365,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,  2366,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,  2441,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,  2368,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,  2369,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,  2370,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,   412,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,   682,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,   685,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,   687,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,   989,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,   990,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,   991,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,   992,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,   905,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   906,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   907,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,  2045,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,  2046,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
    2047,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,  2048,
     491,     0,     0,     0,  2049,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,  2050,
    2051,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,  2052,
     592,   593,   691,   594,     0,  2053,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,  2054,   617,  2055,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,  2056,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,   990,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,   991,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,   992,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,  2034,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,  2323,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,   412,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,  2899,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,  2900,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,  2901,   617,   618,  2902,
     620,  2903,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,  2904,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   709,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,   687,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,   412,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   857,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,   412,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
    1303,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,   130,   131,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,  3104,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,  3105,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,  3116,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,  3117,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   911,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,   412,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   953,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,  1006,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,  1063,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,  1206,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,  1063,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
    1545,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,  1718,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,  1063,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,  1942,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,  2034,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,  2323,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,  4019,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,  4032,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,  4250,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,  4252,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,  4254,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,  4630,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,  1014,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,  1016,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,  1017,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,  1018,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
    1019,   225,     0,     0,  1020,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
    1021,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,  1057,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,  1017,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,     0,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,  1058,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1059,   225,     0,     0,  1060,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,  1021,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,  1077,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,  1182,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,  1203,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
    1214,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,  1265,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,  1316,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,  1333,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,  1335,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,  1337,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,  1340,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,  1346,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,  1556,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,  1043,   437,
    1017,   140,  1557,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,  1047,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,  1048,   587,   212,   588,   589,   590,
    1049,   592,   593,   691,   594,     0,   595,   596,   597,   598,
    1549,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,  1051,   225,     0,     0,  1052,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,  1021,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
    1053,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,  1682,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
    1905,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,  1932,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,  1966,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,  1968,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,  1970,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,  2082,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,  2289,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
       0,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,  2662,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,  3034,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,  3107,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
    3109,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,  3201,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,  1043,   437,  1017,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,  1047,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,  1048,   587,
     212,   588,   589,   590,  1049,   592,   593,   691,   594,     0,
     595,   596,   597,   598,  1549,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1051,   225,     0,
       0,  1052,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,  1021,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,  1053,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,  1043,   437,  1017,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,  1047,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,  1048,
     587,   212,   588,   589,   590,  1049,   592,   593,   691,   594,
       0,   595,   596,   597,   598,  1549,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,  2356,   619,   620,   621,   622,     0,  1051,   225,
       0,     0,  1052,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,  1021,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,  1053,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,  1043,   437,  1017,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,  1047,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
    1048,   587,   212,   588,   589,   590,  2416,   592,   593,   691,
     594,     0,   595,   596,   597,   598,  2417,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1051,
     225,     0,     0,  2418,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,  1021,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,  1053,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,  1043,   437,  1017,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,  1047,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,  1048,   587,   212,   588,   589,   590,  1049,   592,   593,
     691,   594,     0,   595,   596,   597,   598,  2417,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
    1051,   225,     0,     0,  2418,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
    1021,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,  1053,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,     0,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
       0,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,     0,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,     0,    90,    91,    92,     0,     0,
       0,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,     0,     0,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115, -2332,   116,   117,   118,
       0,     0,     0,     0,     0,   121,   122,     0,     0,     0,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,   125,     0,   126,   127,    35,     0,   407,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     133,     0,     0,     0,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,   144,     0,   145,
       0,     0,     0,     0,     0,   148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,   156,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
     166,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   172,
       0,     0,     0,     0,     0,     0,     0,     0,   173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   174,   175,     0,     0,     0,     0,     0,   176,     0,
     177,     0,     0,   178,   179,     0,   180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   181,   182,     0,   183,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,   189,
     190,     0,     0,   191,     0,     0,     0,   193,     0,     0,
     194,     0,   195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   196,   197,   198,   199,   200,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   204,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,   212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   217,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   224,   225,     0,     0,     0,   226,     0,   227,
       0,     0,     0,     0,     0,     0,     0,     0,   230,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   234,     0,     0,   235,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115, -2333,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,   127,    35,     0,  1127,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,   145,     0,     0,
       0,     0,     0,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
     152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,   164,     0,     0,     0,   166,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   172,     0,     0,
       0,     0,     0,     0,     0,     0,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   174,
     175,     0,     0,     0,     0,     0,   176,     0,   177,     0,
       0,   178,   179,     0,   180,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   181,   182,     0,   183,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,     0,   193,     0,     0,   194,     0,
     195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,   197,   198,   199,   200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     210,     0,     0,   212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,     0,
       0,     0,     0,     0,     0,     0,   230,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   234,     0,     0,   235,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    86,    87,    88,
       0,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,     0,     0,     0,     0,
       0,   121,   122,     0,     0,     0,     0,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   125,     0,
     126,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,   144,     0,   145,     0,     0,     0,     0,
       0,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,   152,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,   156,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,   166,     0,     0,     0,
       0,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   172,     0,     0,     0,     0,
       0,     0,     0,     0,   173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   174,   175,     0,
       0,     0,     0,     0,   176,     0,   177,     0,     0,   178,
     179,     0,   180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,   182,     0,   183,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,   193,     0,     0,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,   198,   199,   200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   204,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,   212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,   225,
       0,     0,     0,   226,     0,   227,     0,     0,     0,     0,
       0,     0,     0,     0,   230,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   234,
       0,     0,   235,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    86,    87,    88,     0,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,     0,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
       0,   116,   117,   118,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,   145,     0,     0,     0,     0,     0,   148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,     0,   152,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,   156,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   162,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,   166,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,     0,     0,     0,
       0,     0,   176,     0,   177,     0,     0,   178,   179,     0,
     180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,   190,     0,     0,   191,     0,     0,
       0,   193,     0,     0,   194,     0,   195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   204,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   210,     0,     0,   212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,     0,     0,   219,
       0,   220,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   224,   225,     0,     0,
       0,   226,     0,   227,     0,     0,     0,     0,     0,     0,
       0,     0,   230,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   234,     0,     0,
     235,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,   145,     0,     0,     0,     0,     0,   148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,   166,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     176,     0,   177,     0,     0,   178,   179,     0,   180,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
       0,   183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   204,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,   212,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   234,     0,     0,   235,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   412,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   140,   438,     0,   439,   440,
     441,   442,   144,     0,   145,     0,   443,   444,   445,   446,
     148,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,     0,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,  2010,   487,     0,   488,
     168,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
       0,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   537,   188,   189,   190,   538,   539,   191,     0,
     540,   541,   193,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,  2011,     0,   548,   549,   550,     0,     0,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,     0,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
     219,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,  2012,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,   234,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,    35,   653,   654,     0,     0,     0,
       0,     0,    41,    42,  1639,  1640,  4214,     0,     0,     0,
       0,     0,     0,  4215,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,   130,   131,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,     0,   140,   438,
       0,   439,   440,   441,   442,   144,     0,   145,     0,   443,
     444,   445,   446,   148,   447,     0,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,     0,     0,     0,
     152,     0,     0,     0,   455,   456,   457,   458,     0,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,     0,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,   182,   524,   183,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   537,   188,   189,   190,   538,
     539,   191,     0,   540,   541,   193,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,   197,   198,   199,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,   212,   588,   589,   590,   591,   592,   593,
       0,   594,   215,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,   219,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,   223,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     233,   234,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,   236,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,     0,   653,   654,
      35,   412,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,   246,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   140,   438,     0,   439,   440,   441,
     442,   144,     0,   145,     0,   443,   444,   445,   446,   148,
     447,     0,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,     0,   459,   155,   156,   460,  2228,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,  2010,   487,     0,   488,   168,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,     0,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   537,   188,   189,   190,   538,   539,   191,     0,   540,
     541,   193,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,  2011,     0,   548,   549,   550,     0,     0,   196,
     197,   198,   199,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,   212,
     588,   589,   590,   591,   592,   593,     0,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,   219,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,  2012,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,     0,   234,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   653,   654,     0,     0,     0,     0,
       0,    35,   412,  1639,  1640,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   140,   438,     0,   439,   440,
     441,   442,   144,     0,   145,     0,   443,   444,   445,   446,
     148,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,     0,   459,   155,   156,   460,
    2233,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,  2010,   487,     0,   488,
     168,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
       0,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   537,   188,   189,   190,   538,   539,   191,     0,
     540,   541,   193,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,  2011,     0,   548,   549,   550,     0,     0,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,     0,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
     219,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,  2012,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,   234,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,     0,   653,   654,     0,     0,     0,
       0,     0,    35,   412,  1639,  1640,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,     0,   140,   438,     0,   439,
     440,   441,   442,   144,     0,   145,     0,   443,   444,   445,
     446,   148,   447,     0,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,     0,     0,     0,   152,     0,
       0,     0,   455,   456,   457,   458,     0,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,  2010,   487,     0,
     488,   168,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,     0,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,   182,   524,   183,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   537,   188,   189,   190,   538,   539,   191,
       0,   540,   541,   193,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,  2011,     0,   548,   549,   550,     0,
       0,   196,   197,   198,   199,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,   212,   588,   589,   590,   591,   592,   593,     0,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,   219,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,  2012,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,     0,   234,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,     0,   653,   654,     0,     0,
       0,     0,     0,    35,     0,  1639,  1640,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,     0,   140,   438,     0,
     439,   440,   441,   442,   144,     0,   145,     0,   443,   444,
     445,   446,   148,   447,     0,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,     0,     0,     0,   152,
       0,     0,     0,   455,   456,   457,   458,     0,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,  2010,   487,
       0,   488,   168,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,     0,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,   182,   524,   183,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   537,   188,   189,   190,   538,   539,
     191,     0,   540,   541,   193,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,  2011,     0,   548,   549,   550,
       0,     0,   196,   197,   198,   199,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,   212,   588,   589,   590,   591,   592,   593,     0,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,   219,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,  2012,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,     0,
     234,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,     0,   653,   654,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,     0,   140,   438,     0,   439,   440,   441,   442,
     144,     0,   145,     0,   443,   444,   445,   446,   148,   447,
       0,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,     0,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,     0,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     537,   188,   189,   190,   538,   539,   191,     0,   540,   541,
     193,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,   197,
     198,   199,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,     0,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,   219,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,   623,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,   234,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,     0,   653,   654,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   140,
     438,     0,   439,   440,   441,   442,   144,     0,   145,     0,
     443,   444,   445,   446,   148,   447,     0,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,     0,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,     0,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   537,   188,   189,   190,
     538,   539,   191,     0,   540,   541,   193,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,   197,   198,   199,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,   212,   588,   589,   590,   591,   592,
     593,     0,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,   219,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,     0,   234,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,    35,   653,
     654,     0,    37,    38,    39,    40,    41,    42,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,     0,   140,   438,     0,   439,   440,   441,   442,   144,
       0,   145,     0,   443,   444,   445,   446,   148,   447,     0,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,     0,   459,   155,   156,   460,  2213,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,     0,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   537,
     188,   189,   190,   538,   539,   191,     0,   540,   541,   193,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,     0,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,   219,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,     0,   234,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   653,   654,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   140,   438,     0,   439,   440,
     441,   442,   144,     0,   145,     0,   443,   444,   445,   446,
     148,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,     0,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
       0,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   537,   188,   189,   190,   538,   539,   191,     0,
     540,   541,   193,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,     0,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
     219,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,   234,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,    35,   653,   654,     0,    37,    38,
      39,    40,    41,    42,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,     0,   140,   438,
       0,   439,   440,   441,   442,   144,     0,   145,     0,   443,
     444,   445,   446,   148,   447,     0,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,     0,     0,     0,
     152,     0,     0,     0,   455,   456,   457,   458,     0,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,     0,   499,  1990,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,   182,   524,   183,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   537,   188,   189,   190,   538,
     539,   191,     0,   540,   541,   193,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,   197,   198,   199,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,   212,   588,   589,   590,   591,   592,   593,
       0,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,   219,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
       0,   234,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   653,   654,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
       0,   140,   438,     0,   439,   440,   441,   442,   144,     0,
     145,     0,   443,   444,   445,   446,   148,   447,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,  2530,   455,   456,   457,
     458,     0,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,     0,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   537,   188,
     189,   190,   538,   539,   191,     0,   540,   541,   193,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,   197,   198,   199,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,     0,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,   219,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,  2531,     0,   638,   639,
     640,   641,   642,     0,   234,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
      35,   653,   654,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,   130,   131,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   140,   438,     0,   439,   440,   441,
     442,   144,     0,   145,     0,   443,   444,   445,   446,   148,
     447,     0,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,     0,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,     0,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   537,   188,   189,   190,   538,   539,   191,     0,   540,
     541,   193,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
     197,   198,   199,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,   212,
     588,   589,   590,   591,   592,   593,     0,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,   219,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,     0,   234,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   653,   654,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,     0,   140,   438,     0,
     439,   440,   441,   442,   144,     0,   145,     0,   443,   444,
     445,   446,   148,   447,     0,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,     0,     0,     0,   152,
       0,     0,     0,   455,   456,   457,   458,     0,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,   172,  3385,   496,     0,
     497,   498,     0,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,   182,   524,   183,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   537,   188,   189,   190,   538,   539,
     191,     0,   540,   541,   193,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,   197,   198,   199,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,   212,   588,   589,   590,   591,   592,   593,     0,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,   219,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,     0,
     234,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,    35,   653,   654,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,     0,
     140,   438,     0,   439,   440,   441,   442,   144,     0,   145,
       0,   443,   444,   445,   446,   148,   447,     0,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,     0,
       0,     0,   152,     0,     0,     0,   455,   456,   457,   458,
       0,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,     0,   499,   500,   173,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,   182,   524,   183,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   537,   188,   189,
     190,   538,   539,   191,     0,   540,   541,   193,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,   197,   198,   199,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,   212,   588,   589,   590,   591,
     592,   593,     0,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,   219,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,     0,   234,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     653,   654,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,     0,   140,   438,     0,   439,   440,   441,   442,
     144,     0,   145,     0,   443,   444,   445,   446,   148,   447,
       0,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,     0,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,     0,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,  1212,   531,   532,     0,   533,   534,     0,   535,   536,
     537,   188,   189,   190,   538,   539,   191,     0,   540,   541,
     193,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,   197,
     198,   199,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,     0,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,   219,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,   234,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,    35,   653,   654,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,     0,   140,   438,     0,   439,
     440,   441,   442,   144,     0,   145,     0,   443,   444,   445,
     446,   148,   447,     0,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,     0,     0,     0,   152,     0,
       0,     0,   455,   456,   457,   458,     0,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,     0,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,   182,   524,   183,     0,   525,   526,   527,
       0,     0,   528,   529,  1286,   531,   532,     0,   533,   534,
       0,   535,   536,   537,   188,   189,   190,   538,   539,   191,
       0,   540,   541,   193,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,   197,   198,   199,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,   212,   588,   589,   590,   591,   592,   593,     0,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,   219,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,     0,   234,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   653,   654,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   140,
     438,     0,   439,   440,   441,   442,   144,     0,   145,     0,
     443,   444,   445,   446,   148,   447,     0,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,     0,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,     0,   499,  1322,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   537,   188,   189,   190,
     538,   539,   191,     0,   540,   541,   193,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,   197,   198,   199,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,   212,   588,   589,   590,   591,   592,
     593,     0,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,   219,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,     0,   234,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,    35,   653,
     654,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,     0,   140,   438,     0,   439,   440,   441,   442,   144,
       0,   145,     0,   443,   444,   445,   446,   148,   447,     0,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,     0,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,     0,   499,  1331,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   537,
     188,   189,   190,   538,   539,   191,     0,   540,   541,   193,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,     0,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,   219,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,     0,   234,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   653,   654,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   140,   438,     0,   439,   440,
     441,   442,   144,     0,   145,     0,   443,   444,   445,   446,
     148,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,     0,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
       0,   499,  1342,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,  1343,   531,   532,     0,   533,   534,     0,
     535,   536,   537,   188,   189,   190,   538,   539,   191,     0,
     540,   541,   193,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,     0,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
     219,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,   234,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,     0,   653,   654
};

static const yytype_int16 yycheck[] =
{
       2,   246,   167,    78,    78,   359,  1098,   209,  1321,   990,
     991,   992,  1093,  1045,    78,   996,    78,    78,  1325,    96,
     880,  1368,   187,  1329,   228,  1398,   154,  1417,  1061,   106,
    1205,  1163,  1223,  1276,   153,  1873,  2049,   150,  1577,  1705,
     715,  1201,  1285,  1739,    78,  1999,  1487,  1889,  1748,  1744,
      84,  1258,  2202,  1213,  1430,   917,  1052,   171,  2757,   160,
     165,  1594,   935,  2473,   132,   142,  1891,  2914,  1832,  1458,
    1459,    78,   945,   933,   917,   203,    78,   840,  1744,  3070,
     157,   375,    84,  3341,  3120,  1757,  3122,    89,  1477,  1929,
     165,  2252,  1633,  1634,  1635,   209,  1796,  1260,   375,  1914,
     117,  1204,  3280,  1263,  1207,  1312,  1266,  1788,  1914,  1914,
    2521,  1271,  1215,  1914,  1598,   117,   959,   880,  1278,  1739,
      78,  2087,  1914,  2432,  2433,  1914,    84,  1287,   117,  1801,
    1802,  3626,  3262,   716,    94,   347,  3575,  1360,   117,   223,
    1140,  2737,  3249,  1140,  2972,   162,  3670,   361,  1988,  1688,
    3521,   153,  2912,   361,  3619,  3262,  3845,   216,  2908,   117,
     162,  2910,  2911,   958,  3826,  3862,  3526,  3527,   167,  3883,
     933,  1731,   132,   162,  1938,  1628,  1629,  2847,  1692,  1381,
    1361,  2296,  4293,   162,  1352,  1179,  1048,  1931,   187,  4096,
    1090,   208,  2602,   153,   154,  1090,  1135,  1136,  3587,   216,
      21,   218,  3459,   163,   162,  1048,   208,    30,   117,    72,
     950,    88,    10,   230,   216,  2965,   218,   108,  1447,  1448,
      72,  2336,   128,    86,   121,  2340,    72,    95,   230,   128,
     905,   822,  3266,  3267,  3268,  3269,  3270,  3271,   114,   143,
      86,   230,   156,   203,  1473,   128,    72,   135,    84,  4556,
     114,   230,   236,   162,  1417,    81,  4432,   180,  4537,   112,
      86,  2671,  3798,  2673,   145,   185,  2567,    75,    76,    77,
      78,    99,   230,   247,    82,  1256,    14,   199,   149,    78,
      99,   227,  1505,   227,    78,    95,   228,   106,    75,    76,
      77,    78,   367,   367,   112,    82,   266,   227,  3793,    37,
     145,   227,     2,   367,   145,   367,   367,    88,  2978,   319,
     307,  2153,   153,    99,   349,   173,    75,    76,    77,    78,
     106,   230,   184,    82,    75,    76,    77,    78,  1361,   197,
     145,    82,   113,   227,    72,  3072,    78,    75,    76,    77,
      78,   375,    29,    81,    82,    83,    84,   204,    86,   268,
     149,   100,     0,   182,    99,   221,    75,    76,    77,    78,
     367,   106,   143,    82,   137,   185,   165,  1042,    25,   352,
    1561,   173,    78,   375,  1506,    78,   410,    72,  2391,    14,
    1772,  1241,    75,    76,    77,    78,    81,   197,    14,    82,
     153,    86,   182,   103,   104,   461,   431,    90,  1530,    75,
      76,    77,    78,   227,   323,   267,    82,   180,   410,  1121,
     222,    75,    76,    77,    78,   266,   135,   375,    82,  4698,
     187,   180,    75,    76,    77,    78,    90,  1819,   233,    82,
    4541,    75,    76,    77,    78,  1876,   471,    90,    82,  4101,
     260,   270,    75,    76,    77,    78,    90,   246,   182,    82,
     227,   411,   410,    75,    76,    77,    78,  1330,   372,  4549,
      82,  2576,    75,    76,    77,    78,   266,   373,   227,    82,
     247,   455,  1184,    25,   373,  1864,  1865,    90,  1241,   345,
     309,   451,  1871,  1345,    75,    76,    77,    78,   485,   266,
     373,    82,  1525,   503,    75,    76,    77,    78,    38,   356,
      40,    82,  1345,   429,   623,   307,   179,    75,    76,    77,
      78,   160,   261,  2046,    82,   343,   226,  2050,   228,  2052,
     503,   173,  2055,  1686,   314,  1368,   336,  1840,   357,   449,
     824,  1404,   506,  1566,  1567,   393,   309,   507,  1844,   667,
     668,   314,  3279,   465,   135,   173,  1419,   824,   429,    75,
      76,    77,    78,    88,  1137,  1138,    82,   367,  1431,   503,
     506,   503,   361,   416,  3694,   429,  1157,   490,   367,  4745,
     441,   258,  1434,   367,   410,  1370,   506,   350,  4857,  3613,
     456,   449,  4861,   232,   429,   404,   396,  3694,   429,  2427,
     363,  1434,   506,  4900,   422,  4090,   424,   501,   416,  4296,
     506,   505,  4264,  1766,   456,   262,   503,   506,  2147,   503,
    1350,  2436,   503,  1856,   429,   503,  1719,  3027,   404,  1794,
    4899,   623,   499,   506,  1784,   367,  1786,   102,  1835,   449,
     451,   494,   495,  1862,  1863,    75,    76,    77,    78,  1830,
     503,  1870,    82,   469,   454,    93,   503,  4309,   494,   495,
      88,  4022,   460,  2192,   505,  4026,  1368,  2196,   456,   404,
    3838,   367,    95,   623,   367,    85,   429,  2040,   494,   495,
     429,   444,    95,  1836,   451,   113,   497,   506,   501,  3857,
     229,  4792,   506,   470,   451,  1992,  4075,   141,  3945,  3536,
     173,   503,  1855,  1853,  1556,   503,  4232,  4233,  4234,  4235,
    4236,   506,   489,  2403,   128,   143,   506,   667,   668,  1648,
     262,  4801,   831,  1556,   959,  1615,   503,  4624,   499,   453,
    1615,  1564,  1565,    72,   329,   374,    75,    76,    77,    78,
     507,   490,    81,    82,    83,    84,  2432,    86,  1901,  1093,
    2047,   460,  2486,   323,  1738,  2440,   505,  4858,   960,  2056,
     501,   461,   503,   872,   505,   715,   494,   495,   431,    22,
     861,   209,   846,   227,   197,  4427,   266,   419,   173,   309,
     209,  3521,  4434,  3807,   197,  2925,   185,    88,  1361,   907,
    3089,  3541,  3091,    72,   503,   173,    75,    76,    77,    78,
     824,   419,    81,    82,   470,   209,  1959,    86,   471,   494,
     495,   236,   113,   820,   969,    25,   971,   926,   973,    72,
     503,   319,   307,   489,   979,    35,  3226,  3227,   820,  2021,
     469,   160,   824,  2938,  2005,  2027,   828,   503,  1996,   322,
     268,   820,   143,   382,   836,   837,  2350,  1002,  1003,   503,
     842,   820,   955,   119,  2297,    88,  2299,  1559,  4871,   851,
     503,   260,  1564,  1565,   959,   504,    88,   419,   507,   503,
     180,  2421,   820,  2086,  2087,   867,   824,   236,   322,  1083,
     503,   128,   307,  3623,  2097,  1083,   878,   175,  2101,   956,
     882,   503,   137,   958,  2113,  2114,  2109,  2110,   437,   335,
     503,   893,   222,   232,   971,   370,   973,   319,   153,  2122,
    2123,   506,  3893,  2598,   247,   325,   983,   382,  1768,   911,
    2133,   820,   503,   336,   134,   917,  4939,  1001,   180,   921,
    3221,  3591,   503,  3224,  3225,  1002,  1003,  3228,   930,   931,
     371,   175,   380,   935,   367,   503,   419,  3238,   307,  4391,
    3249,  4393,   240,   945,   367,   905,   296,   907,   950,   373,
     398,  2647,   207,  3262,  1935,   396,  2637,   959,   433,   398,
     455,   496,   497,   498,   499,   429,   323,   243,  1073,   224,
    2003,   247,   971,   396,   973,   180,  1044,   503,    75,    76,
      77,    78,   173,  1067,   398,    82,  4683,  1046,   235,   180,
     227,  1050,  2155,   953,  4708,   503,   240,   957,   296,    85,
    4435,   230,    88,  1002,  1003,  1768,   506,   151,   284,  1721,
     503,  4382,  2144,  1097,   419,  4510,  4387,  1729,  4378,  4390,
     455,  2053,  2054,   185,   367,   268,   490,   436,   371,  1046,
    3339,   419,   175,  1050,  1068,   374,   268,   387,  1040,   369,
     449,   505,   262,    99,  1046,   189,  1048,   309,  1050,   266,
     307,  4309,   296,   396,  4502,   299,   494,   495,   496,   497,
     498,   499,   228,   503,  1776,   229,  1068,  1779,  1780,   389,
     490,   491,   492,  1075,   494,   495,   496,   497,   498,   499,
    4515,   503,  1042,   324,  1044,   273,   455,  2929,   266,   387,
     175,  1964,  4128,   227,  1178,   350,  4793,   240,   260,   419,
     206,   197,  1975,   972,   309,  4632,  4633,   976,   977,   978,
    1068,  4800,  1972,   247,  1987,   828,   373,   986,   309,   266,
     266,   336,   384,   836,   400,   296,   469,   174,   299,  1841,
     469,   378,   266,  1135,  1136,   431,   192,   457,   507,   396,
    4802,  4636,   137,   387,   501,   494,   495,   384,   505,   469,
    4602,   107,   367,   296,   867,   240,   299,  4622,   264,   958,
     959,   325,   391,  4687,  1171,   504,  2009,   151,   507,    71,
      72,   503,   338,    75,    76,    77,    78,    79,    80,    81,
      82,   396,   268,   503,    86,   496,   497,   498,   499,   444,
    4625,   420,  2725,   337,    88,  1296,  2585,  4044,   320,   227,
    4635,   323,   227,   250,  2237,   189,   495,  4054,   921,  1972,
     439,   296,   207,  2008,   299,  4663,   387,   930,   409,   247,
     329,   412,   247,   329,   180,   462,  1228,   389,  4599,   224,
     230,   327,   473,   507,   451,   401,  1238,    95,   266,   325,
     484,   266,   153,   101,   387,  4073,   429,   151,   412,   143,
     950,   494,   495,   496,   497,   498,   499,  4752,  1260,  2119,
    1505,  3086,   494,   495,   496,   497,   498,   499,  3093,   180,
     160,   151,  4022,   451,  2517,   371,  4026,   329,   180,   423,
    4040,  2444,   180,   151,  1083,   189,  4035,   449,   503,   179,
     111,  1293,  4052,   429,    99,  1370,  1373,   218,  1375,  4826,
     396,  1378,   387,  1380,   451,   451,  1383,  1384,  1385,   189,
    4749,  4750,   503,   410,   411,   501,   219,   451,   396,  1396,
     210,   189,   508,   506,    75,    76,    77,    78,  1330,  4459,
    3926,    82,  1409,  4828,  1411,  2335,  2439,   443,  2335,   197,
      95,   484,   147,  1345,   380,  4523,   101,  1349,  1350,   154,
    1352,  2664,  4459,   337,   229,   350,  2119,   222,  1360,    85,
     503,  2668,    88,   265,   285,   506,  1368,   232,  2674,  3382,
     506,   418,   419,   507,   240,  1587,   181,  2620,  2621,  2622,
    2623,  2481,   247,  2486,  1678,  3694,   288,  1601,  1602,  2632,
    1604,   391,  3088,  1601,  1602,   504,  1604,   506,   309,   484,
     321,  1678,  1404,   306,  2507,   491,   492,   185,   494,   495,
     496,   497,   498,   499,  2577,  1417,   314,  1419,   503,   197,
     420,  1121,  2005,   451,  4919,   246,   451,   505,   507,  1431,
     296,    99,  1434,   337,  2537,  2535,   121,  3598,    97,   423,
    1140,  4880,   197,  1445,   357,  3856,   251,   184,  3414,   444,
     325,  2658,   504,  3754,   506,  2939,  1416,   337,   117,  3760,
    3761,  3762,  3763,  3764,  3765,   247,   380,   503,  3088,   337,
     103,   104,  1474,  3173,  1542,  1543,   309,    85,   336,   507,
      88,  3296,   507,  3164,  1184,   398,   171,   356,   160,  3022,
    3296,  3296,  3902,   162,  3904,  3296,  4674,   105,   369,   389,
    1502,  1503,  1371,  1505,  3296,  1374,   129,  3296,  1377,   367,
    1379,   376,   381,  1382,   137,  1228,  1518,  1386,   121,   423,
    1522,   387,   355,   274,   192,  1238,   323,   160,  3368,   419,
     267,   328,  2392,  1617,   490,   449,   449,   192,   396,   194,
     329,   109,   268,   423,  4802,   501,   179,   503,   504,   505,
     506,  4398,  4399,    41,  1556,   423,   336,  1559,  1575,  2782,
     232,   230,  1564,  1565,   378,  2438,  4557,   457,   171,   347,
       5,  1370,  1574,  1575,   259,   509,   349,   210,  1646,   469,
    1293,   336,  1542,  1543,  2747,   367,  1575,   367,   231,   371,
      25,   182,   494,   495,  1628,  1629,  1575,   386,   469,   325,
      35,  1603,   261,  2315,  4640,  1607,  1608,   412,  2831,   192,
      71,   194,   367,   503,   396,  1716,   396,  1575,    79,    80,
     188,   218,   307,     2,   236,  1627,  1628,  1629,    95,  2392,
    4329,   451,  4382,   216,   101,   506,   450,  4387,  1627,  2862,
    4390,   396,  1441,   390,  1678,   288,  1648,   183,   390,  1349,
    1350,  1685,  1352,   208,  3326,  2330,   259,  3329,   431,  3032,
     268,   382,  1461,   218,   319,   288,  1575,   451,  1368,  1627,
    1628,  1629,   419,   172,  2897,  1692,  1678,   419,  4428,   270,
      81,   231,  1699,  1685,  1686,    86,  1646,   469,   285,   429,
    1692,   152,  1491,   172,   192,   307,   194,  1699,   471,   134,
     385,  4111,  4112,  1692,   307,  3094,  1505,   398,   244,   128,
      89,  1795,   433,  1692,  1731,  3256,   463,   325,   309,   503,
    1678,   463,  4713,  4422,   336,  4424,   309,  1685,   147,  1731,
     197,   314,   389,   137,  1692,   229,   319,  1739,   288,   143,
     183,   202,   161,    71,    72,    75,    76,    77,    78,   153,
     490,  3057,    82,   252,   182,   367,   389,   451,   449,   336,
     262,   196,   419,   257,  1766,  1772,   357,  4614,   494,   495,
     496,   497,   498,   499,   153,   382,   180,  2489,   182,   422,
     159,   424,   385,  1692,   382,  2497,   419,  2499,  2650,   431,
     367,   252,   211,   192,   371,   194,   295,   183,   297,  4549,
     457,   244,  1601,  1602,   447,  1604,   185,  2650,   208,   503,
      85,   309,  1819,    88,  1816,   336,   295,   216,   297,   396,
     463,   319,  3647,   384,   457,  2687,   433,   262,   461,   471,
      75,    76,    77,    78,  1836,   433,   469,    82,    16,   469,
    3047,  1960,   270,   455,  2687,   352,   503,  3380,   248,  4599,
     254,   451,   435,  1855,    75,    76,    77,    78,   244,  1559,
     421,    82,   445,  3627,  1564,  1565,    75,    76,    77,    78,
     503,  1873,   422,    82,   424,   396,   506,  2079,   182,  1896,
     341,   309,   490,   491,   492,  3048,   494,   495,   496,   497,
     498,   499,   469,   469,  1896,   155,    14,   447,  3073,  1901,
    4201,  4202,   227,   503,  2009,   309,  4056,  1896,   469,   470,
     314,  1913,   218,   318,   327,   314,   222,  1896,   222,    37,
     319,   218,   247,   336,  2956,   222,  3101,  1929,   421,   357,
     506,  2927,  3305,  2008,   194,   134,   135,   469,  1896,  1639,
    1640,  2018,   503,  2020,  3483,  4456,   350,  2024,   182,  2026,
     254,  1953,  2029,  2247,   367,  3655,  2033,  1959,    88,   363,
    1962,  3803,  1964,  1965,  2078,  1665,  1666,   336,   336,  4480,
    2247,  3074,   247,  1975,   506,   403,   469,   470,  2062,   285,
    3143,   442,  3145,   113,  2085,  1987,  1988,  1896,   285,   450,
     228,   386,   453,   268,  1996,  2070,  2070,  1999,   367,   367,
    3672,  3673,   332,   307,   274,   309,  2070,  2009,  2070,  2070,
     503,   384,   470,   143,   222,   321,    72,  2729,   256,  2879,
     254,  1721,  3463,  3464,   321,  3401,    34,   396,   396,  1729,
      86,   489,    14,   271,   242,  3198,   435,  2712,     8,   470,
     444,    11,    12,   336,   282,   503,   445,  2049,   421,   462,
     325,  4801,    22,    23,    24,    37,    26,    27,   489,  3222,
    3599,    31,    32,    33,    75,    76,    77,    78,   429,   314,
     115,    82,   503,   307,   367,   309,  1776,   367,   371,  1779,
    1780,   336,   310,   311,  2086,  2087,   152,  2930,   311,   380,
      72,   136,  2094,   314,  3407,  2097,   469,   470,   367,  2101,
     503,  2266,    97,   396,  2106,   314,   396,  2109,  2110,   433,
    4520,  3501,   367,   389,  3274,  2117,  2879,   408,  2120,  2121,
    2122,  2123,   117,   490,  4078,   336,  4825,   396,  2130,  2131,
     503,  2133,   222,  2135,  2136,   201,   369,  2139,   505,   377,
    2157,  1841,  3837,   419,  2249,   501,  3019,  3020,  3990,  3987,
    4459,   507,   242,  2155,  2156,  2157,   367,   153,  2360,  2161,
    2362,   389,  3325,  2165,   506,   507,   389,  2169,  2157,  2171,
    2172,  2173,  2174,  2175,  2176,  2177,  2178,  2179,  2157,  2181,
    3876,   457,  4483,  3045,  3436,  2187,   470,  2950,  2190,  3352,
     501,   419,    51,   469,   505,  3861,   419,   386,  3405,  2157,
     384,   336,  3045,   173,  2830,   489,  2832,  2833,  3460,  2008,
      69,   277,   278,  2247,    88,   490,   491,   492,  2930,   494,
     495,   496,   497,   498,   499,   291,  2288,   503,   323,   457,
     469,   470,   367,   328,   457,   231,  2355,   421,  1912,   113,
    1953,   469,  4551,   157,   623,  2247,   469,  3470,  2157,  1962,
    2252,  3624,  3625,   357,   250,    85,  1930,  3420,    71,    72,
     145,   396,   250,  2297,   368,  2299,    79,    80,   153,   143,
     336,  2070,   508,    86,  3663,   503,   126,  3440,     7,   506,
     503,   504,  3155,   510,   507,   469,   470,    72,   392,  2247,
      19,    20,   288,   498,   242,  2297,  1996,  2299,   503,  1999,
     505,   161,  3465,   314,    75,    76,    77,    78,   506,   150,
      39,    82,   510,    42,  3295,    86,   498,  2319,  2402,   503,
    1608,   503,   172,   505,   494,   495,   496,   497,   498,   380,
     381,   301,   328,  2350,   504,  2337,  2049,  2339,  3501,  2297,
     386,  2299,   502,   502,  2346,   161,   506,   506,  2350,  2351,
     504,   504,  2354,   507,   507,   421,    71,   423,   125,    85,
    2479,  2350,    88,  2162,    79,    80,  2137,   274,   228,  2140,
    2330,  2350,  3563,   422,  2376,   424,   346,  2379,   380,   381,
    3913,  3914,  3915,  2385,   501,   509,   503,   113,   505,  2391,
     503,   206,  2350,   119,   268,   269,   256,    86,  3530,   249,
     496,   497,   498,   218,  2421,   506,   507,   222,  2410,   180,
     503,   271,   228,  3275,  3287,  3277,  3289,   143,   422,  2421,
     424,   323,   282,  3770,   506,  2427,   422,   156,   424,   486,
    2432,  2433,  3275,   125,  3277,  2437,  2438,   433,   312,   115,
     256,  2350,  2444,  2460,   304,   295,  2463,   297,   444,   264,
     270,   447,  3533,  3534,   504,   271,   506,   307,  2460,  2461,
     501,  2463,   503,   323,   193,  2482,   282,   504,   438,   506,
     285,  2460,   121,   504,  2463,   506,  3338,   505,  2480,  2481,
    2482,   384,  2484,   862,  2463,   335,  3249,  4500,   304,  2288,
     503,    85,   505,  2606,    88,  3338,  3773,  4036,  3775,  3262,
    2502,  3778,  2460,  3780,   326,  2463,   321,   384,   326,    85,
    2512,   105,    88,   162,   329,   469,   470,   377,   421,   113,
     429,   247,   372,  2525,   504,   119,   506,  3400,   504,   105,
     506,  4070,  2534,  2535,   503,   323,   505,   186,   917,   918,
     487,   488,   268,   269,   421,  4330,  4331,  4332,  4333,   143,
     222,  2460,   201,   504,  2463,   506,   205,   407,   504,   323,
     506,   377,   504,  2917,   506,   486,   469,   470,   504,  4411,
     506,   950,  3747,  2575,   223,  2577,   115,    75,    76,    77,
      78,   504,   326,   506,    82,   504,   312,   506,   504,   238,
     506,   451,   469,   470,    85,  1421,  1422,    88,  2600,   325,
     503,   270,  2604,    75,    76,    77,    78,   504,  3998,   506,
      82,   504,  4308,   506,   105,  2315,   504,  2862,   506,   384,
     494,   495,   496,   497,   498,   499,   503,  1006,   443,    75,
      76,    77,    78,  2635,   384,  2335,    82,  2337,   486,  2339,
    4173,  4174,  3885,  4176,   422,  2647,   424,   496,  2650,   243,
     504,   226,   506,   247,   506,  1034,   421,   504,   503,   506,
      75,    76,    77,    78,  1043,   314,   504,    82,  1047,  1048,
    1049,   421,  2385,   322,   268,   269,   504,   384,  2391,   469,
     470,  3844,   180,  2957,  2958,  2687,    71,   504,   125,   506,
     284,   227,   268,  2695,    79,    80,  3408,   266,  2902,  2903,
    2904,   504,   507,   506,   469,   470,   355,   504,   180,   506,
     504,    96,   506,   496,   421,   309,   509,   509,   312,   469,
     470,   262,   503,  2968,   494,   495,   496,   497,   498,   429,
     429,   325,   502,  2735,   328,   504,   429,   506,   503,    75,
      76,    77,    78,   203,   429,  2747,    82,   108,   422,   325,
     424,  3974,  2712,   503,   429,  2757,  1135,  1136,   504,  2761,
     506,  1140,   469,   470,  2766,   180,   125,   152,   494,   495,
     496,   497,   498,   499,   504,   262,   506,   268,   429,   268,
    2782,  2783,   504,   504,   506,   506,  2788,   505,   504,  2489,
     506,    75,    76,    77,    78,   503,   503,  2497,    82,  2499,
      75,    76,    77,    78,   396,   503,   400,    82,   504,   472,
     506,  2813,  2814,   504,   211,   506,  2818,   202,   504,   503,
     506,  2838,   504,   504,   506,   506,   505,  2844,  2830,  2831,
    2832,  2833,   211,  2121,   325,  3998,  2838,   504,   504,   506,
     506,  2843,  2844,   504,  2846,   506,  2848,  2135,   211,  2838,
    4223,    75,    76,    77,    78,  2844,  2858,  2859,    82,  2838,
    2862,   504,   247,   506,   504,  2844,   506,   252,  4215,  4535,
     323,  2946,  2946,  2875,   504,  2877,   506,   222,  1257,  2881,
    2838,   211,  2946,    71,  2946,  2946,  2844,    75,    76,    77,
      78,    79,    80,   507,    82,  2897,   490,   491,   492,   283,
     494,   495,   496,   497,   498,   499,  2908,   451,  2910,  2911,
    2912,   504,   506,   506,   490,   491,   492,   182,   494,   495,
     496,   497,   498,   499,   504,   323,   506,  3770,  2930,  2838,
     503,  3694,  2934,   274,   386,  2844,    75,    76,    77,    78,
     504,   318,   506,    82,   503,  2947,  4109,   504,   137,   506,
    2952,   504,   504,   506,   506,  4345,   341,  2959,   504,   504,
     506,   506,   469,  2965,  4096,   108,  1345,  3840,  3841,   309,
    1349,  1350,   472,  1352,  4137,   504,   504,   506,   506,   504,
     504,   506,   506,   504,   503,   506,  4149,   175,   504,  1368,
     506,   115,   504,   378,   506,   504,   504,   506,   506,   490,
     491,   492,  3004,   494,   495,   496,   497,   498,   499,   504,
     504,   506,   506,  4709,   504,   115,   506,  3019,  3020,   504,
     504,   506,   506,  3025,   504,   504,   506,   506,   438,  2729,
    4193,   336,   417,  1087,  1413,  1089,   222,  4027,  4071,  4029,
     150,   353,   508,  3045,   211,   211,  3048,   503,  2761,   211,
    4210,   472,   240,  2766,   211,  1434,   211,   442,  3770,  4592,
     211,   506,   211,  2862,   211,   450,   323,   211,   453,  4602,
     211,   211,   323,   211,   211,   419,   503,  2876,   108,   283,
     323,   223,   346,   503,   503,   503,  3088,  3089,   222,  3091,
     222,   222,   503,   333,   503,   503,  2895,   503,   503,   503,
     503,   503,   503,  3120,  3121,  3122,   506,   503,   296,  2908,
     503,   299,   503,   503,   503,   503,   503,   503,  3120,  3121,
    3122,  4494,  4655,   503,   108,   503,   163,   503,  1507,   503,
     503,  3120,  3121,  3122,   503,   503,   266,  3139,  1517,   268,
     108,  3143,   222,  3145,  3146,   321,   222,  2946,  1527,   396,
     283,   262,   387,  3155,   496,   506,   179,   450,   506,   490,
    2121,    14,  3120,  3121,  3122,   503,  2965,   506,   503,  2968,
     503,   299,  4395,   429,  2135,   429,   384,  1556,   505,   429,
    1559,  1560,  4345,   429,  4574,  1564,  1565,   384,  2813,  2814,
     429,   429,   429,  2818,   153,  2908,  3198,  4730,   211,   387,
     384,  4061,   323,   388,   429,   280,  3918,   429,   314,   429,
     145,  3120,  3121,  3122,  3216,   323,   450,   252,   319,   429,
    3222,   503,  3350,  2184,   429,   503,   153,  3244,  3347,   506,
    2930,   336,   451,  2858,  2859,   451,   174,   429,   429,   429,
     125,   125,  3244,   327,  3261,   114,  3248,  3249,   429,   429,
     429,   429,  2965,  4643,  3316,  3244,   429,  4647,  4648,  3261,
    3262,   429,   114,   323,   384,  3244,  3511,   323,   429,  1648,
     506,   429,  3261,  3275,   472,  3277,  3521,   268,   460,   108,
     503,   107,  3261,    97,  4265,  3287,  3244,  3289,  3350,   503,
     503,   211,   469,   309,   503,   451,   484,   180,  4061,   463,
     319,   291,   462,  3261,   309,   108,   222,   503,   108,  3513,
    3514,  3515,  3516,   274,  4661,   385,   211,   211,   505,   211,
     211,   211,    14,  3325,   451,  4417,   451,   429,   313,   318,
     227,  4644,   506,   503,   503,  3244,  3338,  3339,    85,  4645,
     427,    88,   465,   301,  4651,   301,  4653,    88,    85,   396,
    3352,    88,  3261,   506,   427,  4578,   227,   503,   105,   431,
     486,   429,   241,     2,   241,   264,  3368,   503,    71,   324,
     319,   506,  4215,   490,   451,    34,    79,    80,    10,   429,
    3382,   429,    85,  3385,   506,    88,   504,   503,   384,   152,
    3350,   506,   506,   451,   272,   504,   384,   504,  3400,   272,
     504,  3403,   105,   314,   503,   108,   314,   429,   503,   386,
     113,  4574,   274,  1792,   314,  3417,   119,   323,  3420,   115,
     403,   330,   429,   506,   322,  3427,   429,   384,   367,   393,
     429,  3433,   429,  3435,   357,   268,   108,   268,  3440,  3441,
     143,  4604,  3444,  3445,  3446,  3447,  3448,  3449,  3450,  3451,
    3452,  3453,   268,   451,    85,  3457,  3458,    88,   451,  3476,
     268,   268,   322,  3465,   503,   490,   107,   501,  3470,   501,
     490,   211,  3474,   222,  3476,   429,  3478,   429,   393,   224,
    4643,   319,   113,   393,  4647,  4648,  3488,  3476,   119,  3491,
     211,  3493,   503,   210,   469,   323,   323,  3476,   222,  3501,
    3502,  3503,  3504,   497,   239,   239,  3508,   108,  4540,  3511,
     211,   323,   143,   323,   222,   247,  4739,  3316,  3476,  3521,
     247,   268,   247,   393,   506,  2813,  2814,   506,   167,  3531,
    2818,   268,  4613,   506,    96,    89,  1915,  3539,   472,  3541,
     243,   298,   233,   323,   247,  3710,   506,   125,   187,  3249,
     318,  3350,   419,   504,   274,   486,   504,   504,   227,   504,
     504,   504,  3262,   504,   504,   268,   269,  3476,   504,  4429,
    2858,  2859,  4885,   506,   504,   504,   504,   227,   325,   504,
     340,   284,   504,   504,  3586,   486,   503,   429,   325,   503,
    3592,   466,   504,   332,    90,    90,  3598,   374,   466,   457,
     507,   490,   506,   490,  4464,   285,   309,   323,   504,   312,
     323,   504,   243,   167,   326,   250,   247,  1996,   506,   211,
    1999,  3623,   325,   503,   429,   328,   472,   503,   429,   258,
     429,   314,   429,   187,   327,   211,   211,   268,   269,   285,
     429,   341,   341,   429,   448,   429,   293,   429,  3650,   293,
     293,   429,   396,   284,   384,   429,   429,   429,   384,   429,
     429,   384,   384,   211,   429,   114,  4429,   429,   268,  3382,
     268,   268,  3689,   268,   268,   268,  3693,    95,  3695,   268,
     501,   312,   504,   101,   299,   504,   285,  3689,   490,   173,
     438,  3693,  3694,  3695,   325,   369,  4459,   400,   504,   322,
    3689,  4464,   323,   108,  3693,   503,  3695,   236,  3408,   504,
     506,   429,  3511,   506,  3693,   451,  3695,   222,   451,   384,
     384,   384,  3521,   141,   326,  3727,   209,  2106,  3730,   209,
     506,  3689,   268,   203,   501,  3693,   227,  3695,    88,   135,
     222,   227,   503,   490,   491,   492,   504,   494,   495,   496,
     497,   498,   499,   490,   491,   492,   462,   494,   495,   496,
     497,   498,   499,   506,   235,   324,   504,   222,  3770,   400,
    4751,   108,   190,   504,   451,   504,   504,   429,   451,   197,
    3689,   258,   200,   490,  3693,   504,  3695,   490,   491,   492,
     504,   494,   495,   496,   497,   498,   499,   506,   503,   429,
     504,   490,   504,   429,   438,   503,   503,   384,  3521,   429,
    3872,   438,   429,   384,   504,   222,  3441,  3819,  4661,  3444,
    3445,  3446,  3447,  3448,  3449,  3450,  3451,  3452,  3453,   504,
     143,   173,   438,   504,   252,   268,   504,   268,  3840,  3841,
     502,  2220,  3844,   108,   272,   503,   506,   469,   472,   222,
    3912,   504,  2813,  2814,   253,   506,   469,  2818,   148,   490,
     491,   492,   127,   494,   495,   496,   497,   498,   499,   421,
     506,   429,    85,   393,  3876,  3877,  3878,   232,  3503,  3504,
     227,   268,   268,   268,   503,   268,  4088,  4747,   504,   307,
     504,   309,   227,   503,   159,   504,   362,  2858,  2859,   125,
     467,   319,   467,   506,   271,   331,   271,   125,   504,   327,
    3623,   237,   429,   504,   504,   503,   503,  4082,   336,  3921,
     504,   319,    98,   227,   490,   469,   143,   252,   438,   490,
     314,   206,   314,   506,   506,  3937,   429,   211,   268,   187,
    2319,   229,   314,   218,   227,   502,   393,   222,   451,   214,
     451,   108,   198,   371,   465,   131,  2335,   469,  2337,   227,
    2339,   503,   469,   503,   255,   326,   227,   362,   144,  4134,
     503,   503,  3974,   504,   406,   456,   504,   503,   396,   271,
     245,   157,  3984,  3985,  4747,  3987,   339,   503,   363,   264,
    3992,  3993,   468,   429,  3694,  3997,  3998,   469,   504,   323,
     504,  4003,  4004,   222,   504,  4007,  4068,   108,   314,   274,
     285,   503,   294,   503,   250,   280,   503,   210,   173,   195,
    4022,   381,   327,    85,  4026,   504,    88,   381,   490,   125,
     503,   125,   329,  4035,   503,   451,   454,  2416,  4040,   323,
    4394,   307,   421,   105,   309,   217,   321,   354,   224,   137,
    4052,   113,    78,   229,   329,   326,   137,   119,    84,   193,
      85,   455,   362,    89,   456,   506,   108,   227,   222,   466,
    3770,   360,   198,  3872,   252,  4240,  4078,   108,   469,   323,
     323,   143,   503,   503,   326,  3785,  3786,   326,   125,  4091,
     504,   117,   504,   380,   185,   503,    94,   449,   105,   380,
     210,   354,   503,   367,  1818,  2605,   371,  4109,  1565,  3101,
     375,  4128,  1181,  3912,  2930,  1213,   381,  2470,  3693,  2529,
    3243,  4486,  4213,   388,  4661,  4284,  4128,  4529,  3865,  4535,
    4539,   396,  4258,  3026,  4832,  4137,   162,  2717,  4428,  4128,
     405,  4884,  4144,  2522,  4784,  4783,  4847,  4149,   413,   325,
    4684,  3030,  4285,  3441,  4156,  3830,  3444,  3445,  3446,  3447,
    3448,  3449,  3450,  3451,  3452,  3453,  2596,  2596,   443,  3689,
    4128,  3121,  3835,  1916,  2591,  3837,  3307,   353,  4889,  4952,
    2559,   243,   208,  4944,  3261,   247,  3474,  3248,  2567,  4854,
     216,  4193,   218,  4466,  3819,  1908,  4213,  4762,  4840,   464,
    4469,   187,  1405,   468,   230,  3921,   268,   269,   384,  4621,
    3876,  4213,  4709,  4215,   390,  3503,  3504,   393,  3918,  4128,
    3874,  2433,   284,  4022,  4213,  3200,   501,  4026,  4946,   504,
     505,   918,  4866,  4676,  4213,  2249,  2009,  1062,  2250,  2946,
    2619,  3859,  4069,   419,  3596,  2700,  1593,   309,  2947,   425,
     312,  1363,  2286,  1077,  4256,  4213,  1611,  1610,  2959,  2285,
    2953,  1613,   438,   325,  2269,  2644,   328,  2973,   127,  4068,
    2965,  2650,  3521,  4028,  4600,  1067,  3597,    98,  3486,  4576,
    1617,  3478,  4820,  4819,  4823,  2950,  2876,   463,  2784,  2874,
    3592,  2187,   623,  3347,  1300,  1947,  2651,  2319,  4810,   376,
     159,  1629,  1623,   952,  4213,  2294,  4308,  1158,  2687,  4022,
    2335,   950,  2327,  4026,  2924,  1138,  3603,  3568,  1138,  1416,
    4055,  2328,  3604,  1627,   145,   409,  2713,  4329,  1539,  2339,
     969,  1349,   971,  2038,   973,     2,  4413,   982,   400,  4341,
     979,   980,   981,  4345,  4071,    -1,    -1,    -1,  4350,   375,
      -1,    -1,    -1,   174,    -1,   214,  4056,    -1,    -1,    -1,
      -1,    -1,    -1,  1002,  1003,  4367,  4368,  3992,  3993,  4371,
      89,    -1,    -1,    -1,   195,    -1,    -1,    -1,  4078,    -1,
    4382,    -1,    -1,    -1,   410,  4387,   245,    -1,  4390,    -1,
      -1,    -1,    -1,  4395,  4396,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,   229,    -1,
      -1,    -1,    -1,    -1,    -1,   969,    -1,   971,    -1,   973,
    4422,   280,  4424,    -1,    -1,   979,  4428,    -1,   490,   491,
     492,    -1,   494,   495,   496,   497,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,    -1,   508,    -1,  1002,  1003,
     309,    -1,    -1,    -1,   275,    -1,    -1,  4459,    -1,  4521,
      -1,  4463,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   336,    -1,    -1,
    3441,    -1,  1121,  3444,  3445,  3446,  3447,  3448,  3449,  3450,
    3451,  3452,  3453,    -1,    -1,    -1,    -1,    -1,  4500,    -1,
      -1,  1140,    -1,    -1,    -1,    -1,    -1,    -1,   367,    -1,
      -1,    -1,   371,  3474,    95,    -1,   375,    -1,    -1,    -1,
     101,    -1,   381,    -1,    -1,    -1,    -1,    -1,    -1,   388,
      -1,  3819,   353,    -1,    -1,    -1,    -1,   396,    -1,    -1,
      -1,    -1,  3503,  3504,    -1,  1184,   405,  4549,    -1,  4551,
      -1,  2930,    -1,    -1,   413,    -1,    -1,   378,    -1,    -1,
     141,    -1,    -1,   384,    -1,    -1,    -1,  1121,    -1,   390,
      -1,  4573,  4574,    -1,  4576,    -1,  4578,    -1,    -1,    -1,
      -1,  1135,  1136,  4382,    -1,    -1,  1140,    -1,  4387,    -1,
      -1,  4390,    -1,  4595,    -1,    -1,    -1,  4599,   419,    -1,
     421,    -1,  4604,    -1,    -1,   464,    -1,    -1,    -1,   190,
      -1,    -1,    -1,    -1,    -1,    -1,   197,   438,    -1,   200,
      -1,    -1,    -1,  4640,    -1,    -1,    -1,    -1,    -1,    -1,
    1184,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4640,    -1,
      -1,  4643,   463,    -1,    -1,  4647,  4648,    -1,    -1,    -1,
      -1,  4640,    -1,    -1,    -1,    -1,    -1,  4902,    -1,  4661,
      -1,    -1,    -1,    -1,    -1,    -1,  3045,    -1,    -1,  4382,
      -1,   252,    -1,    -1,  4387,    -1,    -1,  4390,    -1,  4681,
      -1,    -1,  4640,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3992,  3993,  4406,  4709,    -1,    -1,
    1349,  1350,    -1,  1352,  4716,  4428,  4341,    -1,    -1,    -1,
      -1,    -1,  4521,    -1,    -1,    -1,   307,    -1,   309,  1368,
      -1,  4640,    -1,    -1,    -1,    -1,    -1,  4739,   319,    -1,
      -1,    -1,  4367,  4368,    -1,    -1,   327,  3126,    -1,    -1,
    4463,    -1,    -1,    -1,  4756,   336,    -1,    -1,    -1,  4459,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3153,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   367,  4500,    -1,  4791,
     371,  4866,  4866,    -1,   820,    -1,    -1,    -1,   824,  4801,
    4599,    -1,  4866,    -1,  4866,  4866,    -1,    -1,    -1,    -1,
      -1,   837,    -1,    -1,  1368,   396,   842,    -1,    -1,    -1,
    4822,  4823,    -1,  4825,   108,   851,    -1,  4902,  4902,    85,
      -1,    -1,    88,  4835,    -1,    -1,  4549,    -1,  4902,    -1,
    4902,  4902,  3221,   127,    -1,  3224,  3225,    -1,    -1,  3228,
      -1,    -1,   878,    -1,    -1,    -1,   882,   113,  3819,  3238,
      -1,    -1,    -1,   119,  3243,    -1,    -1,   893,    -1,  4871,
    3249,  4946,  4946,   454,    -1,   159,  3255,    -1,    -1,  4881,
    4897,    -1,  4946,  3262,  4946,  4946,  4599,   143,    -1,    -1,
      -1,   917,    -1,    -1,    -1,  4897,  3275,    -1,  3277,    -1,
      -1,    -1,    -1,    -1,    -1,   931,    -1,    -1,  4897,   935,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4897,   945,
    1559,    -1,    -1,    -1,    -1,  1564,  1565,  4944,    -1,  3308,
     214,    -1,    -1,   959,    -1,  4952,    -1,  4939,    -1,  4897,
      -1,    -1,  4944,    -1,    -1,    -1,  4948,    -1,  4573,   205,
    4952,    -1,    -1,    -1,    -1,  4944,    -1,    -1,  3337,  3338,
      -1,   245,    -1,  4952,    -1,  4944,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4952,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4944,   243,  4897,    -1,
     274,   247,    -1,    -1,  4952,    -1,   280,    -1,  1637,    -1,
    1639,  1640,    -1,    -1,    -1,  1559,    -1,    -1,    -1,    -1,
    1564,  1565,   268,   269,    -1,    -1,    -1,    -1,    -1,  1658,
    1046,    -1,  1048,    -1,  1050,   309,  1665,  1666,   284,    -1,
      -1,  3992,  3993,    -1,    -1,  4944,    -1,    85,    -1,    -1,
      88,    -1,  1068,  4952,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4341,    -1,    -1,   312,   105,    -1,    -1,
      -1,    -1,  4350,    -1,    -1,   113,    -1,  4866,    -1,   325,
      -1,   119,    85,    -1,    -1,    88,    -1,    -1,  4791,  4367,
    4368,    -1,  1721,    -1,    -1,    -1,    -1,   371,  4801,    -1,
    1729,   375,   105,    -1,  1648,   143,    -1,   381,    -1,    -1,
     113,    -1,    -1,  4902,   388,    -1,   119,    -1,  3487,  1135,
    1136,    85,   396,    -1,    88,    -1,    -1,    -1,   837,    -1,
      -1,   405,  4835,   842,    -1,    -1,    -1,    -1,    -1,   413,
     143,    -1,   851,    -1,    -1,    -1,    -1,  1776,    -1,   113,
    1779,  1780,    -1,    -1,   400,   119,    -1,  4946,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   878,
      -1,  3540,    -1,   882,    -1,    -1,    -1,  1721,    -1,   143,
      -1,    -1,    -1,    -1,   893,  1729,    -1,    -1,    -1,    -1,
     464,    -1,    -1,    -1,   468,   469,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   243,    -1,  4897,    -1,   247,
      -1,    -1,  1841,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     268,   269,  1776,    -1,    -1,  1779,  1780,    -1,    -1,    -1,
     243,    -1,    -1,    -1,   247,  4948,   284,    -1,   494,   495,
     496,   497,   498,   499,  4944,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4952,    -1,    -1,   268,   269,    -1,    -1,    -1,
      -1,   309,    -1,    -1,   312,    -1,    -1,    -1,    -1,   243,
      -1,   284,    -1,   247,    -1,    -1,    -1,   325,    -1,    -1,
     328,    -1,    -1,    -1,    -1,  4573,    -1,  1841,    -1,    -1,
      -1,    -1,    -1,    -1,   268,   269,   309,    -1,    -1,   312,
      -1,    -1,    -1,    -1,  1330,    -1,  1945,    -1,   108,    -1,
     284,    -1,   325,    85,    78,  3694,    88,    -1,    -1,  1345,
      84,    -1,    -1,    -1,    -1,    89,    -1,   127,    -1,    -1,
      -1,    -1,  3711,   105,    -1,  3714,    -1,  3716,   312,    -1,
      -1,   113,  1368,    -1,    -1,    -1,    -1,   119,    -1,    -1,
      -1,   325,   400,   117,    -1,    -1,    -1,  1996,    -1,   159,
    1999,  3740,  3741,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   143,    -1,    -1,    -1,  3754,    -1,    -1,  1404,    -1,
    4341,  3760,  3761,  3762,  3763,  3764,  3765,   400,    -1,  4350,
      -1,  3770,    -1,  1419,    -1,  3774,    -1,    -1,   162,    -1,
      -1,    -1,    -1,    -1,    -1,  1431,  4367,  4368,  1434,    -1,
      -1,  1336,    -1,    -1,   214,    -1,  1135,  1136,    -1,  3798,
      -1,    -1,  1347,    -1,    -1,    -1,   400,    -1,    -1,    -1,
    3809,  3810,  3811,  3812,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   490,   491,   492,   245,   494,   495,   496,   497,
     498,   499,    -1,    -1,    -1,    -1,    -1,    -1,   506,    -1,
    2099,  2100,    -1,    -1,    -1,    -1,   230,    -1,  2107,    -1,
      -1,   243,  2111,  2112,   274,   247,    -1,   490,   491,   492,
     280,   494,   495,   496,   497,   498,   499,  2126,    -1,  2128,
      -1,    -1,    -1,    -1,  3873,    -1,   268,   269,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   309,
      -1,  2150,   284,  2152,    -1,    -1,    -1,   491,   492,    -1,
     494,   495,   496,   497,   498,   499,    -1,    -1,    -1,    -1,
    1556,    -1,    -1,    -1,    -1,    -1,    -1,   309,  1564,  1565,
     312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1575,
      -1,    -1,    -1,   325,    -1,  3934,   328,    -1,    -1,    85,
      -1,    -1,    88,  2202,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   371,   838,    -1,    -1,   375,    -1,    -1,   844,   105,
      -1,   381,    -1,    -1,    -1,    -1,   852,   113,   388,    95,
      -1,    -1,    -1,   119,   860,   101,   396,    -1,    -1,   865,
      -1,  1627,  1628,  1629,    -1,   405,    -1,    -1,    -1,    -1,
      -1,   375,  4573,   413,    -1,    -1,    -1,   143,    -1,    -1,
      -1,    -1,  1648,    -1,    -1,    -1,    -1,  2266,   400,    -1,
      -1,    -1,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   410,    -1,    -1,    -1,
      -1,    -1,  1678,    -1,    -1,    -1,    -1,    -1,    -1,  1685,
      -1,    -1,    -1,    -1,   464,    -1,  1692,    -1,   468,    -1,
      -1,    -1,    -1,  1699,    -1,    -1,  2315,  4056,  4057,    -1,
      -1,    -1,    -1,    -1,   190,    -1,    -1,    -1,    -1,    -1,
      -1,   197,    -1,    -1,   200,    -1,  2335,    -1,  2337,  4078,
    2339,    -1,    -1,    -1,    -1,  1731,    -1,    -1,    -1,    95,
      -1,    -1,  2266,    -1,    -1,   101,    -1,   243,   490,   491,
     492,   247,   494,   495,   496,   497,   498,   499,    -1,    -1,
      -1,    -1,   504,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   268,   269,    -1,    -1,   252,  1013,    85,    -1,
      -1,    88,    -1,    -1,    -1,   141,    -1,    -1,   284,    -1,
      -1,  2315,    -1,    -1,    -1,  2319,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   113,    -1,    -1,  1045,
      -1,  2335,   119,   309,    -1,    -1,   312,    -1,    -1,    -1,
    1816,    -1,    -1,    -1,    -1,    -1,    -1,  1063,    -1,   325,
      -1,   307,   328,   309,   190,    -1,   143,    -1,    -1,    -1,
      -1,   197,    -1,   319,   200,    -1,    -1,    -1,    -1,  1085,
      -1,   327,  4201,  4202,    -1,    -1,    -1,    -1,    -1,    -1,
     336,    -1,    -1,    -1,    -1,    -1,  4215,    -1,    -1,    -1,
    4219,    -1,  4221,    -1,    -1,  4224,  4225,    -1,    -1,    -1,
    2489,    -1,    -1,  4232,  4233,  4234,  4235,  4236,  2497,    -1,
    2499,   367,    -1,    -1,    -1,   371,   252,    -1,   205,    -1,
    1896,    -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1913,    -1,    -1,
     396,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4280,    -1,  1929,    -1,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   307,    -1,   309,    -1,    -1,    -1,    -1,  4307,  1648,
      -1,   268,   269,   319,    -1,  2489,    -1,    -1,  1964,  1965,
      -1,   327,    -1,  2497,  2583,  2499,    -1,   284,   454,  1975,
     336,  4330,  4331,  4332,  4333,    -1,    -1,    -1,    -1,    -1,
      -1,  1987,  1988,    -1,   490,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,   312,    -1,    -1,   504,    -1,
      -1,   367,    -1,  2009,    -1,   371,    -1,    -1,   325,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     396,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,  1288,  1289,  1290,    -1,    -1,    -1,    -1,  1954,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1963,    -1,
      -1,    -1,  1967,   117,    -1,    -1,    -1,    -1,  1973,  1974,
      -1,    -1,    -1,    -1,    -1,    -1,   820,    -1,    85,    -1,
     824,    88,    -1,   400,    -1,    -1,  1991,    -1,   454,    -1,
      -1,    -1,    -1,   837,    -1,    -1,    -1,    -1,   842,    -1,
    4459,    -1,    -1,    -1,    -1,    -1,   113,   851,   162,    -1,
    2729,    85,   119,    -1,    88,    -1,    -1,  1816,    -1,    -1,
      -1,    -1,    -1,    -1,  4483,    -1,    -1,    -1,  4487,    -1,
      -1,   105,    -1,    -1,   878,    -1,   143,    -1,   882,   113,
      -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,    -1,   893,
      -1,  2157,    -1,    -1,   208,    -1,    -1,  1403,    -1,    -1,
      -1,    -1,   216,    -1,   218,    -1,    -1,    -1,    -1,   143,
      -1,    -1,    -1,   917,    -1,    -1,   230,   494,   495,   496,
     497,   498,   499,    -1,  1430,    -1,    -1,   931,    -1,    -1,
      -1,   935,    -1,    -1,    -1,  2729,    -1,    -1,   205,    -1,
      85,   945,    -1,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1913,   959,   127,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   113,    -1,
    1929,    -1,    -1,    -1,   119,    -1,   243,    -1,   829,   830,
     247,  2247,   833,   834,    -1,    -1,    -1,    -1,   159,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,   850,
      -1,   268,   269,    -1,    -1,    -1,  1965,    -1,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,    -1,   284,    -1,   870,
      -1,    -1,    -1,   874,    -1,    -1,    -1,    -1,    -1,  1988,
      -1,  2297,    -1,  2299,   268,   269,    -1,    -1,    -1,   890,
      -1,    -1,  4661,   214,  1048,   312,  2925,    -1,    -1,  2928,
     284,  2930,    -1,  2319,    -1,    -1,    -1,    -1,   325,    -1,
      -1,    -1,    -1,    -1,  1068,  1571,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   245,   309,    -1,    -1,   312,    -1,
    2346,  2246,    -1,    85,  2350,  2351,    88,    -1,  2354,    -1,
      -1,   325,    -1,    -1,   328,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,    -1,    -1,    -1,    -1,   280,
    2376,   113,  1618,    -1,    -1,    -1,    -1,   119,    -1,    -1,
      -1,    -1,    -1,   268,   269,    -1,    -1,    -1,    -1,    -1,
      -1,  1135,  1136,   400,    -1,    -1,  2930,    -1,   309,   284,
      -1,   143,    -1,    -1,  2410,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2421,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   309,    -1,   400,   312,    -1,    -1,
      -1,  2437,  2438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     325,    -1,    -1,   328,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2460,  2461,    -1,  2463,    -1,    -1,
     371,    -1,   373,    -1,   375,    -1,    -1,    -1,    -1,    -1,
     381,    -1,    -1,    -1,  2480,    -1,  2482,   388,  2484,    -1,
      -1,    -1,    -1,    -1,    -1,   396,    -1,   494,   495,   496,
     497,   498,   499,    -1,   405,    -1,  2502,  1743,    -1,    -1,
      -1,   243,   413,    -1,  1750,   247,  2512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   400,   490,   491,   492,  2525,
     494,   495,   496,   497,   498,   499,   268,   269,  2534,  1775,
     504,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4897,    -1,
      -1,    -1,   284,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   464,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1807,    -1,    -1,    -1,    -1,    -1,   309,    -1,    -1,
     312,    -1,    -1,    -1,  1820,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   325,    -1,  4944,  1330,    -1,  1834,    -1,
      -1,    -1,    -1,  4952,    -1,  1186,  1187,    -1,    -1,    -1,
      -1,  1345,    -1,    -1,    -1,   490,   491,   492,    -1,   494,
     495,   496,   497,   498,   499,    -1,    -1,    -1,    -1,   504,
    2319,    -1,    -1,    -1,  1368,    -1,    -1,    -1,    -1,    -1,
    3249,    -1,    -1,    -1,    -1,  3254,  3255,    -1,    -1,    -1,
      -1,    -1,    -1,  3262,  2650,    -1,    -1,  2346,    -1,    -1,
      -1,    -1,  2351,    -1,    -1,  2354,    -1,    -1,   400,    -1,
    1404,    -1,    -1,  1254,    -1,    -1,    95,    -1,    -1,    -1,
      -1,  3290,   101,    -1,    -1,  1419,    -1,  2376,    -1,    -1,
      -1,  2687,    -1,  1274,  1275,    -1,    -1,  1431,    85,    -1,
    1434,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   105,    -1,
      -1,  2410,   141,    -1,    -1,  3249,   113,    -1,    -1,    -1,
      -1,    -1,   119,    -1,    -1,    -1,    -1,    -1,  3262,  2735,
      -1,    -1,    -1,    -1,    -1,  1326,  1327,    -1,  2437,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   143,    -1,   490,   491,
     492,  2757,   494,   495,   496,   497,   498,   499,  2663,    -1,
    2006,   190,  2461,    -1,    -1,    -1,   820,    -1,   197,    -1,
      -1,   200,    -1,    -1,  2679,  2680,    -1,    -1,  2683,    -1,
      -1,  2480,    -1,   837,  2689,  2484,    -1,    95,   842,  3408,
      -1,    -1,    -1,   101,    -1,    -1,    -1,   851,    -1,    -1,
      -1,    -1,    -1,  2502,    -1,    -1,    -1,  2053,  2054,    -1,
      -1,    -1,  1556,  2512,    -1,    -1,    -1,    -1,    -1,    -1,
    1564,  1565,    -1,   252,   878,    -1,  2525,    -1,   882,    -1,
      -1,  1575,  2838,   141,    -1,  2534,    -1,    -1,  2844,   893,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,    -1,  2759,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   917,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   268,   269,    -1,  3408,    -1,    -1,   931,   307,    -1,
     309,   935,   190,  1627,  1628,  1629,    -1,   284,    -1,   197,
     319,   945,   200,    -1,    -1,    -1,    -1,    -1,   327,    -1,
      -1,    -1,    -1,    -1,  1648,   959,    -1,   336,    -1,    -1,
      -1,    -1,   309,    -1,    -1,   312,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2930,    -1,    -1,    -1,   325,    -1,
      -1,   328,    -1,    -1,  1678,    -1,    -1,    -1,   367,    -1,
    2186,  1685,   371,    -1,   252,    -1,    -1,    -1,  1692,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,
      -1,    -1,    88,    -1,    -1,  2211,    -1,   396,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3600,    -1,    -1,    -1,    -1,    -1,   113,    -1,    -1,
      -1,    -1,  1046,   119,  1048,    -1,  1050,    -1,  3004,   307,
      -1,   309,  2248,   400,  2250,    -1,    -1,    -1,    -1,    -1,
      -1,   319,    -1,  3019,  3020,    -1,    -1,   143,    -1,   327,
      -1,    -1,    -1,    -1,    -1,   454,    -1,    -1,   336,    -1,
      -1,    -1,    -1,    -1,    95,    -1,  2735,    -1,    -1,  3045,
     101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2757,   367,
      -1,    -1,    -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1816,    -1,    -1,  3694,    -1,    -1,    -1,   205,
     141,  1135,  1136,    -1,    -1,    -1,    -1,    -1,   396,    -1,
      -1,  3710,    -1,   490,   491,   492,    -1,   494,   495,   496,
     497,   498,   499,    -1,    -1,    -1,    -1,   504,    -1,    -1,
      -1,    -1,    -1,    -1,  3120,  3121,  3122,   243,    -1,    -1,
      -1,   247,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   190,
    3035,    -1,    -1,  3139,    -1,    -1,   197,    -1,    -1,   200,
    3146,    -1,   268,   269,    -1,    -1,   454,    -1,    -1,  3155,
      -1,  3770,  1896,    -1,    -1,    -1,    -1,    -1,   284,    -1,
    3694,    -1,  1753,    -1,    -1,    -1,  3785,  3786,    -1,  1913,
      -1,    -1,    -1,    -1,    -1,  3794,  3710,    -1,    -1,  3798,
      -1,    -1,    -1,    -1,    -1,  1929,   312,    -1,    -1,    -1,
    3809,   252,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   325,
      -1,    -1,    -1,  3108,    -1,  3110,    -1,    -1,    -1,    -1,
    3216,  2457,  1803,  1804,  1805,  1806,    -1,    -1,    -1,    -1,
    1964,  1965,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1975,    -1,    -1,    -1,    -1,  3770,    -1,  3244,    -1,
      -1,    -1,    -1,  1987,  1988,    -1,   307,    -1,   309,    -1,
      -1,  1842,  1843,    -1,    -1,  3261,    -1,  1848,   319,    -1,
      -1,    -1,    -1,    -1,    -1,  2009,   327,    -1,    -1,  3275,
      -1,  3277,    -1,    -1,   400,   336,  1330,    -1,    -1,    -1,
      -1,  3287,    -1,  3289,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1345,  3197,    -1,    -1,    -1,    -1,  3202,    -1,  3918,
      -1,    -1,    -1,    -1,  1895,  3004,   367,    -1,    -1,    -1,
     371,    -1,    -1,    -1,  1368,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1919,  1920,
    1921,  1922,  3338,    -1,    -1,   396,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1404,    -1,    -1,    -1,    -1,    -1,    -1,  2603,    -1,    -1,
      -1,    -1,  3368,    -1,    -1,  1419,    -1,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,  1431,    -1,  3385,
    1434,    -1,    -1,    -1,  3918,    -1,  1977,    -1,    -1,    -1,
      -1,    -1,    -1,   454,  3400,  1986,    -1,  3403,    -1,    -1,
      -1,    -1,  1993,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2157,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    